/*
**
** Copyright 2008, The Android Open Source Project
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
*/

#ifndef _DBG_CAM_SHADING_PARAM_H
#define _DBG_CAM_SHADING_PARAM_H

//Shading Parameter Structure
typedef enum
{
    SHAD_TAG_VERSION = 0,
    /* add tags here */
    SHAD_TAG_1TO3_EN,
    SHAD_TAG_SCENE_IDX,
    SHAD_TAG_CT_IDX,
    SHAD_TAG_CAM_CTL_DMA_EN,
    SHAD_TAG_CAM_LSCI_BASE_ADDR,
    SHAD_TAG_CAM_LSCI_XSIZE,
    SHAD_TAG_CAM_CTL_EN1,
    SHAD_TAG_CAM_LSC_CTL1,
    SHAD_TAG_CAM_LSC_CTL2,
    SHAD_TAG_CAM_LSC_CTL3,
    SHAD_TAG_CAM_LSC_LBLOCK,
    SHAD_TAG_CAM_LSC_RATIO,
    SHAD_TAG_CAM_LSC_GAIN_TH,
    SHAD_TAG_TSF_EN,

	// TSF INFO
    SHAD_TAG_CNT1,
    SHAD_TAG_CNT2,
    
    SHAD_TAG_COEF1_00,
    SHAD_TAG_COEF1_01,
    SHAD_TAG_COEF1_02,
    SHAD_TAG_COEF1_03,
    SHAD_TAG_COEF1_04,
    SHAD_TAG_COEF1_05,
    SHAD_TAG_COEF1_06,
    SHAD_TAG_COEF1_07,
    SHAD_TAG_COEF1_08,
    SHAD_TAG_COEF1_09,
    SHAD_TAG_COEF1_10,
    SHAD_TAG_COEF1_11,
    SHAD_TAG_COEF1_12,
    SHAD_TAG_COEF1_13,
    SHAD_TAG_COEF1_14,
    SHAD_TAG_COEF1_15,
    
    SHAD_TAG_COEF2_00,
    SHAD_TAG_COEF2_01,
    SHAD_TAG_COEF2_02,
    SHAD_TAG_COEF2_03,
    SHAD_TAG_COEF2_04,
    SHAD_TAG_COEF2_05,
    SHAD_TAG_COEF2_06,
    SHAD_TAG_COEF2_07,
    SHAD_TAG_COEF2_08,
    SHAD_TAG_COEF2_09,
    SHAD_TAG_COEF2_10,
    SHAD_TAG_COEF2_11,
    SHAD_TAG_COEF2_12,
    SHAD_TAG_COEF2_13,
    SHAD_TAG_COEF2_14,
    SHAD_TAG_COEF2_15,
    
    SHAD_TAG_COEF3_00,
    SHAD_TAG_COEF3_01,
    SHAD_TAG_COEF3_02,
    SHAD_TAG_COEF3_03,
    SHAD_TAG_COEF3_04,
    SHAD_TAG_COEF3_05,
    SHAD_TAG_COEF3_06,
    SHAD_TAG_COEF3_07,
    SHAD_TAG_COEF3_08,
    SHAD_TAG_COEF3_09,
    SHAD_TAG_COEF3_10,
    SHAD_TAG_COEF3_11,
    SHAD_TAG_COEF3_12,
    SHAD_TAG_COEF3_13,
    SHAD_TAG_COEF3_14,
    SHAD_TAG_COEF3_15, 
    
    SHAD_TAG_COEF4_00,
    SHAD_TAG_COEF4_01,
    SHAD_TAG_COEF4_02,
    SHAD_TAG_COEF4_03,
    SHAD_TAG_COEF4_04,
    SHAD_TAG_COEF4_05,
    SHAD_TAG_COEF4_06,
    SHAD_TAG_COEF4_07,
    SHAD_TAG_COEF4_08,
    SHAD_TAG_COEF4_09,
    SHAD_TAG_COEF4_10,
    SHAD_TAG_COEF4_11,
    SHAD_TAG_COEF4_12,
    SHAD_TAG_COEF4_13,
    SHAD_TAG_COEF4_14,
    SHAD_TAG_COEF4_15,
    
    SHAD_TAG_COEF5_00,
    SHAD_TAG_COEF5_01,
    SHAD_TAG_COEF5_02,
    SHAD_TAG_COEF5_03,
    SHAD_TAG_COEF5_04,
    SHAD_TAG_COEF5_05,
    SHAD_TAG_COEF5_06,
    SHAD_TAG_COEF5_07,
    SHAD_TAG_COEF5_08,
    SHAD_TAG_COEF5_09,
    SHAD_TAG_COEF5_10,
    SHAD_TAG_COEF5_11,
    SHAD_TAG_COEF5_12,
    SHAD_TAG_COEF5_13,
    SHAD_TAG_COEF5_14,
    SHAD_TAG_COEF5_15,
    
    SHAD_TAG_COEF6_00,
    SHAD_TAG_COEF6_01,
    SHAD_TAG_COEF6_02,
    SHAD_TAG_COEF6_03,
    SHAD_TAG_COEF6_04,
    SHAD_TAG_COEF6_05,
    SHAD_TAG_COEF6_06,
    SHAD_TAG_COEF6_07,
    SHAD_TAG_COEF6_08,
    SHAD_TAG_COEF6_09,
    SHAD_TAG_COEF6_10,
    SHAD_TAG_COEF6_11,
    SHAD_TAG_COEF6_12,
    SHAD_TAG_COEF6_13,
    SHAD_TAG_COEF6_14,
    SHAD_TAG_COEF6_15,
    
    SHAD_TAG_PARAL,
    SHAD_TAG_PARAC,
    SHAD_TAG_RGAIN,
    SHAD_TAG_GGAIN,
    SHAD_TAG_BGAIN,
    SHAD_TAG_FLUO_IDX,
    SHAD_TAG_DAY_FLUO_IDX,

    SHAD_TAG_EN_CB,
    SHAD_TAG_MEAN_R,
    SHAD_TAG_MEAN_G,

    SHAD_TAG_BL_IDX,
    SHAD_TAG_BL_WT,
    SHAD_TAG_MOD_BL_WT,
    SHAD_TAG_ST_IDX,
    SHAD_TAG_ST_WT,
    SHAD_TAG_MOD_ST_WT,
    SHAD_TAG_MOD_FL_LV,
    SHAD_TAG_FL_WT,

    SHAD_TAG_WB_DL_STR_XR,
    SHAD_TAG_WB_DL_STR_YR,
    SHAD_TAG_WB_STR_LV,
    SHAD_TAG_WB_WT,
    SHAD_TAG_DAY_WT,

	SHAD_TAG_ENABLE_UNIT,
    SHAD_TAG_OVERWRITE_D,

    SHAD_TAG_TSF_DL_CT_ST,
    SHAD_TAG_TSF_DL_CT_UC,

    SHAD_TAG_TSF_DL_L_ST,
    SHAD_TAG_TSF_DL_L_UC,
    SHAD_TAG_TSF_DL_FI_ST,
    SHAD_TAG_TSF_DL_FI_UC,

    SHAD_TAG_TSF_H1,
    SHAD_TAG_TSF_H2,
    SHAD_TAG_TSF_B1,
    SHAD_TAG_TSF_B2,
    SHAD_TAG_TSF_BL1,	
    SHAD_TAG_TSF_BL2,
    SHAD_TAG_TSF_S1,
    SHAD_TAG_TSF_S2,
    SHAD_TAG_TSF_SL1,
    SHAD_TAG_TSF_SL2,

	SHAD_TAG_ISC_00,
	SHAD_TAG_ISC_01,
	SHAD_TAG_ISC_02,
	SHAD_TAG_ISC_03,
	SHAD_TAG_ISC_04,
	SHAD_TAG_ISC_05,
	SHAD_TAG_ISC_06,
	SHAD_TAG_ISC_07,
	SHAD_TAG_ISC_08,
	SHAD_TAG_ISC_09,
	SHAD_TAG_ISC_10,
	SHAD_TAG_ISC_11,
	SHAD_TAG_ISC_12,
	SHAD_TAG_ISC_13,
	SHAD_TAG_ISC_14,
	SHAD_TAG_ISC_15,

	SHAD_TAG_PCD_00,
	SHAD_TAG_PCD_01,
	SHAD_TAG_PCD_02,
	SHAD_TAG_PCD_03,
	SHAD_TAG_PCD_04,
	SHAD_TAG_PCD_05,
	SHAD_TAG_PCD_06,
	SHAD_TAG_PCD_07,
	SHAD_TAG_PCD_08,
	SHAD_TAG_PCD_09,
	SHAD_TAG_PCD_10,
	SHAD_TAG_PCD_11,
	SHAD_TAG_PCD_12,
	SHAD_TAG_PCD_13,
	SHAD_TAG_PCD_14,
	SHAD_TAG_PCD_15,

    SHAD_TAG_TSF_TH1,
    SHAD_TAG_TSF_TH2,
    SHAD_TAG_TSF_HI,
    SHAD_TAG_TSF_LO,

    SHAD_TAG_TSF_P, 

    SHAD_TAG_TSF_FULL,
    SHAD_TAG_TSF_OFF,

    SHAD_TAG_TSF_ARR_0,
    SHAD_TAG_TSF_ARR_1,
    SHAD_TAG_TSF_ARR_2,
    SHAD_TAG_TSF_ARR_3,
    SHAD_TAG_TSF_ARR_4,
    SHAD_TAG_TSF_ARR_5,
    SHAD_TAG_TSF_ARR_6,
    SHAD_TAG_TSF_ARR_7,
    SHAD_TAG_TSF_ARR_8,
    SHAD_TAG_TSF_ARR_9,
    SHAD_TAG_TSF_ARR_10,
    SHAD_TAG_TSF_ARR_11,
    SHAD_TAG_TSF_ARR_12,
    SHAD_TAG_TSF_ARR_13,
    SHAD_TAG_TSF_ARR_14,
    SHAD_TAG_TSF_ARR_15,
    SHAD_TAG_TSF_ARR_16,
    SHAD_TAG_TSF_ARR_17,
    SHAD_TAG_TSF_ARR_18,
    SHAD_TAG_TSF_ARR_19,
    SHAD_TAG_TSF_ARR_20,
    SHAD_TAG_TSF_ARR_21,
    SHAD_TAG_TSF_ARR_22,
    SHAD_TAG_TSF_ARR_23,
    SHAD_TAG_TSF_ARR_24,
    SHAD_TAG_TSF_ARR_25,
    SHAD_TAG_TSF_ARR_26,
    SHAD_TAG_TSF_ARR_27,
    SHAD_TAG_TSF_ARR_28,
    SHAD_TAG_TSF_ARR_29,
    SHAD_TAG_TSF_ARR_30,
    SHAD_TAG_TSF_ARR_31,
    SHAD_TAG_TSF_ARR_32,
    SHAD_TAG_TSF_ARR_33,
    SHAD_TAG_TSF_ARR_34,
    SHAD_TAG_TSF_ARR_35,
    SHAD_TAG_TSF_ARR_36,
    SHAD_TAG_TSF_ARR_37,
    SHAD_TAG_TSF_ARR_38,
    SHAD_TAG_TSF_ARR_39,
    SHAD_TAG_TSF_ARR_40,
    SHAD_TAG_TSF_ARR_41,
    SHAD_TAG_TSF_ARR_42,
    SHAD_TAG_TSF_ARR_43,
    SHAD_TAG_TSF_ARR_44,
    SHAD_TAG_TSF_ARR_45,
    SHAD_TAG_TSF_ARR_46,
    SHAD_TAG_TSF_ARR_47,
    SHAD_TAG_TSF_ARR_48,
    SHAD_TAG_TSF_ARR_49,
    SHAD_TAG_TSF_ARR_50,
    SHAD_TAG_TSF_ARR_51,
    SHAD_TAG_TSF_ARR_52,
    SHAD_TAG_TSF_ARR_53,
    SHAD_TAG_TSF_ARR_54,
    SHAD_TAG_TSF_ARR_55,
    SHAD_TAG_TSF_ARR_56,
    SHAD_TAG_TSF_ARR_57,
    SHAD_TAG_TSF_ARR_58,
    SHAD_TAG_TSF_ARR_59,
    SHAD_TAG_TSF_ARR_60,
    SHAD_TAG_TSF_ARR_61,
    SHAD_TAG_TSF_ARR_62,
    SHAD_TAG_TSF_ARR_63,
    SHAD_TAG_TSF_ARR_64,
    SHAD_TAG_TSF_ARR_65,
    SHAD_TAG_TSF_ARR_66,
    SHAD_TAG_TSF_ARR_67,
    SHAD_TAG_TSF_ARR_68,
    SHAD_TAG_TSF_ARR_69,
    SHAD_TAG_TSF_ARR_70,
    SHAD_TAG_TSF_ARR_71,
    SHAD_TAG_TSF_ARR_72,
    SHAD_TAG_TSF_ARR_73,
    SHAD_TAG_TSF_ARR_74,
    SHAD_TAG_TSF_ARR_75,
    SHAD_TAG_TSF_ARR_76,
    SHAD_TAG_TSF_ARR_77,
    SHAD_TAG_TSF_ARR_78,
    SHAD_TAG_TSF_ARR_79,
    SHAD_TAG_TSF_ARR_80,
    SHAD_TAG_TSF_ARR_81,
    SHAD_TAG_TSF_ARR_82,
    SHAD_TAG_TSF_ARR_83,
    SHAD_TAG_TSF_ARR_84,
    SHAD_TAG_TSF_ARR_85,
    SHAD_TAG_TSF_ARR_86,
    SHAD_TAG_TSF_ARR_87,
    SHAD_TAG_TSF_ARR_88,
    SHAD_TAG_TSF_ARR_89,
    SHAD_TAG_TSF_ARR_90,
    SHAD_TAG_TSF_ARR_91,
    SHAD_TAG_TSF_ARR_92,
    SHAD_TAG_TSF_ARR_93,
    SHAD_TAG_TSF_ARR_94,
    SHAD_TAG_TSF_ARR_95,
    
    SHAD_TAG_TSF_SMTH,
    SHAD_TAG_TSF_FNUM,
    
    SHAD_TAG_END //276
}DEBUG_SHAD_TAG_T;

// Shading debug info
#define SHAD_DEBUG_TAG_SIZE     (SHAD_TAG_END+10)
#define SHAD_DEBUG_TAG_VERSION  (0)
//
#define DEBUF_SHAD_ARRAY_TOT_MODULE_NUM    1
#define DEBUF_SHAD_ARRAY_TAG_MODULE_NUM    1
//
#define APPN_SHAD_BLOCK_NUM_RST   (8)
#define APPN_SHAD_BLOCK_NUM_MAX   ((32*32)-APPN_SHAD_BLOCK_NUM_RST)
#define SHAD_ARRAY_VALUE_SIZE     (APPN_SHAD_BLOCK_NUM_MAX*4*4)
#define SHAD_ARRAY_VALUE_SIZE_2   (APPN_SHAD_BLOCK_NUM_RST*4*4)
//

typedef struct SHADING_DEBUG_INFO_S
{
    AAA_DEBUG_TAG_T Tag[SHAD_DEBUG_TAG_SIZE];

} SHADING_DEBUG_INFO_T;

//
typedef struct DEBUG_SHAD_ARRAY_S
{
    MUINT32 u4CountU32;
    MUINT32 u4BlockNumX;
    MUINT32 u4BlockNumY;
    MUINT32 u4Array[SHAD_ARRAY_VALUE_SIZE];
} DEBUG_SHAD_ARRAY_T;

typedef struct DEBUG_SHAD_ARRAY_INFO_S
{
    struct Header
    {
        MUINT32  u4KeyID;
        MUINT32  u4ModuleCount;
        MUINT32  u4DbgSHADArrayOffset;
    } hdr;
    DEBUG_SHAD_ARRAY_T  rDbgSHADArray;

} DEBUG_SHAD_ARRAY_INFO_T;
//

typedef struct DEBUG_SHAD_ARRAY_2_S
{
    MUINT32 u4CountU32;
    MUINT32 u4Array[SHAD_ARRAY_VALUE_SIZE_2];
} DEBUG_SHAD_ARRAY_2_T;


#endif //_DBG_CAM_SHADING_PARAM_H
