/*
**
** Copyright 2008, The Android Open Source Project
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
*/

#ifndef _DBG_CAM_MF_PARAM_H
#define _DBG_CAM_MF_PARAM_H

// MF debug info
#define MF_DEBUG_TAG_SIZE     190
#define MF_DEBUG_TAG_VERSION  0


typedef struct DEBUG_MF_INFO_S
{
    DEBUG_CAM_TAG_T Tag[MF_DEBUG_TAG_SIZE];
} DEBUG_MF_INFO_T;


//MF Parameter Structure
typedef enum
{
    MF_TAG_VERSION = 0,             //sw info
    MF_TAG_MFB_MODE,
    MF_TAG_MAX_FRAME_NUMBER,
    MF_TAG_PROCESSING_NUMBER,
    MF_TAG_EXPOSURE,
    MF_TAG_ISO,
    MF_TAG_ISO_HI_TH,
    MF_TAG_ISO_LOW_TH,
    MF_TAG_RAW_WIDTH,
    MF_TAG_RAW_HEIGHT,
    MF_TAG_BSS_ENABLE,
    MF_TAG_BSS_ROI_WIDTH,
    MF_TAG_BSS_ROI_HEIGHT,
    MF_TAG_BSS_SCALE_FACTOR,
    MF_TAG_BSS_CLIP_TH0,
    MF_TAG_BSS_CLIP_TH1,
    MF_TAG_BSS_INPUT0,
    MF_TAG_BSS_INPUT1,           
    MF_TAG_BSS_INPUT2,           
    MF_TAG_BSS_INPUT3,           
    MF_TAG_BSS_INPUT4,
    MF_TAG_BSS_INPUT5,
    MF_TAG_BSS_INPUT6,           
    MF_TAG_BSS_INPUT7,           
    MF_TAG_MEMC_WIDTH,
    MF_TAG_MEMC_HEIGHT,
    MF_TAG_MEMC_INPUT_FORMAT,
    MF_TAG_MEMC_OUTPUT_FORMAT,
    MF_TAG_MEMC_SKIP,
    MF_TAG_MEMC_BAD_MB_COUNT0,
    MF_TAG_MEMC_BAD_MB_COUNT1,
    MF_TAG_MEMC_BAD_MB_COUNT2,
    MF_TAG_MEMC_BAD_MB_TH,
    MF_TAG_MEMC_BAD_MV_RANGE,
    MF_TAG_AIS_EXPOSURE,            
    MF_TAG_AIS_ISO,
    MF_TAG_AIS_CALCULATED_EXPOSURE, 
    MF_TAG_AIS_CALCULATED_ISO,
    MF_TAG_AIS_EXPOSURE_TH0,            
    MF_TAG_AIS_ISO_TH0,
    MF_TAG_AIS_EXPOSURE_TH1,
    MF_TAG_AIS_ADVANCED_ENABLE,
    MF_TAG_AIS_ADVANCED_MAX_EXPOSURE,
    MF_TAG_AIS_ADVANCED_MAX_ISO,
    MF_TAG_BASE_CAM_ANR_CON1,       //ee/anr for base frame
    MF_TAG_BASE_CAM_ANR_CON2,
    MF_TAG_BASE_CAM_ANR_CON3,
    MF_TAG_BASE_CAM_ANR_YAD1,
    MF_TAG_BASE_CAM_ANR_YAD2,
    MF_TAG_BASE_CAM_ANR_4LUT1,
    MF_TAG_BASE_CAM_ANR_4LUT2,
    MF_TAG_BASE_CAM_ANR_4LUT3,
    MF_TAG_BASE_CAM_ANR_PTY,
    MF_TAG_BASE_CAM_ANR_CAD,
    MF_TAG_BASE_CAM_ANR_PTC,
    MF_TAG_BASE_CAM_ANR_LCE1,
    MF_TAG_BASE_CAM_ANR_LCE2,
    MF_TAG_BASE_CAM_ANR_HP1,
    MF_TAG_BASE_CAM_ANR_HP2,
    MF_TAG_BASE_CAM_ANR_HP3,
    MF_TAG_BASE_CAM_ANR_ACTY,
    MF_TAG_BASE_CAM_ANR_ACTC,
    MF_TAG_BASE_CAM_SEEE_SRK_CTRL,
    MF_TAG_BASE_CAM_SEEE_CLIP_CTRL,
    MF_TAG_BASE_CAM_SEEE_FLT_CTRL_1,
    MF_TAG_BASE_CAM_SEEE_FLT_CTRL_2,
    MF_TAG_BASE_CAM_SEEE_GLUT_CTRL_01,
    MF_TAG_BASE_CAM_SEEE_GLUT_CTRL_02,
    MF_TAG_BASE_CAM_SEEE_GLUT_CTRL_03,
    MF_TAG_BASE_CAM_SEEE_GLUT_CTRL_04,
    MF_TAG_BASE_CAM_SEEE_GLUT_CTRL_05,
    MF_TAG_BASE_CAM_SEEE_GLUT_CTRL_06,
    MF_TAG_BASE_CAM_SEEE_EDTR_CTRL,
    MF_TAG_BASE_CAM_SEEE_GLUT_CTRL_07,
    MF_TAG_BASE_CAM_SEEE_GLUT_CTRL_08,
    MF_TAG_BASE_CAM_SEEE_GLUT_CTRL_09,
    MF_TAG_BASE_CAM_SEEE_GLUT_CTRL_10,
    MF_TAG_BASE_CAM_SEEE_GLUT_CTRL_11,
    MF_TAG_BASE_CAM_SEEE_OUT_EDGE_CTRL,
    MF_TAG_BASE_CAM_SEEE_SE_Y_CTRL,
    MF_TAG_BASE_CAM_SEEE_SE_EDGE_CTRL_1,
    MF_TAG_BASE_CAM_SEEE_SE_EDGE_CTRL_2,
    MF_TAG_BASE_CAM_SEEE_SE_EDGE_CTRL_3,
    MF_TAG_BASE_CAM_SEEE_SE_SPECL_CTRL,
    MF_TAG_BASE_CAM_SEEE_SE_CORE_CTRL_1,
    MF_TAG_BASE_CAM_SEEE_SE_CORE_CTRL_2,
    MF_TAG_BEFORE_MFB_CAM_ANR_CON1,     //ee/anr before mfb
    MF_TAG_BEFORE_MFB_CAM_ANR_CON2,
    MF_TAG_BEFORE_MFB_CAM_ANR_CON3,
    MF_TAG_BEFORE_MFB_CAM_ANR_YAD1,
    MF_TAG_BEFORE_MFB_CAM_ANR_YAD2,
    MF_TAG_BEFORE_MFB_CAM_ANR_4LUT1,
    MF_TAG_BEFORE_MFB_CAM_ANR_4LUT2,
    MF_TAG_BEFORE_MFB_CAM_ANR_4LUT3,
    MF_TAG_BEFORE_MFB_CAM_ANR_PTY,
    MF_TAG_BEFORE_MFB_CAM_ANR_CAD,
    MF_TAG_BEFORE_MFB_CAM_ANR_PTC,
    MF_TAG_BEFORE_MFB_CAM_ANR_LCE1,
    MF_TAG_BEFORE_MFB_CAM_ANR_LCE2,
    MF_TAG_BEFORE_MFB_CAM_ANR_HP1,
    MF_TAG_BEFORE_MFB_CAM_ANR_HP2,
    MF_TAG_BEFORE_MFB_CAM_ANR_HP3,
    MF_TAG_BEFORE_MFB_CAM_ANR_ACTY,
    MF_TAG_BEFORE_MFB_CAM_ANR_ACTC,
    MF_TAG_BEFORE_MFB_CAM_SEEE_SRK_CTRL,
    MF_TAG_BEFORE_MFB_CAM_SEEE_CLIP_CTRL,
    MF_TAG_BEFORE_MFB_CAM_SEEE_FLT_CTRL_1,
    MF_TAG_BEFORE_MFB_CAM_SEEE_FLT_CTRL_2,
    MF_TAG_BEFORE_MFB_CAM_SEEE_GLUT_CTRL_01,
    MF_TAG_BEFORE_MFB_CAM_SEEE_GLUT_CTRL_02,
    MF_TAG_BEFORE_MFB_CAM_SEEE_GLUT_CTRL_03,
    MF_TAG_BEFORE_MFB_CAM_SEEE_GLUT_CTRL_04,
    MF_TAG_BEFORE_MFB_CAM_SEEE_GLUT_CTRL_05,
    MF_TAG_BEFORE_MFB_CAM_SEEE_GLUT_CTRL_06,
    MF_TAG_BEFORE_MFB_CAM_SEEE_EDTR_CTRL,
    MF_TAG_BEFORE_MFB_CAM_SEEE_GLUT_CTRL_07,
    MF_TAG_BEFORE_MFB_CAM_SEEE_GLUT_CTRL_08,
    MF_TAG_BEFORE_MFB_CAM_SEEE_GLUT_CTRL_09,
    MF_TAG_BEFORE_MFB_CAM_SEEE_GLUT_CTRL_10,
    MF_TAG_BEFORE_MFB_CAM_SEEE_GLUT_CTRL_11,
    MF_TAG_BEFORE_MFB_CAM_SEEE_OUT_EDGE_CTRL,
    MF_TAG_BEFORE_MFB_CAM_SEEE_SE_Y_CTRL,
    MF_TAG_BEFORE_MFB_CAM_SEEE_SE_EDGE_CTRL_1,
    MF_TAG_BEFORE_MFB_CAM_SEEE_SE_EDGE_CTRL_2,
    MF_TAG_BEFORE_MFB_CAM_SEEE_SE_EDGE_CTRL_3,
    MF_TAG_BEFORE_MFB_CAM_SEEE_SE_SPECL_CTRL,
    MF_TAG_BEFORE_MFB_CAM_SEEE_SE_CORE_CTRL_1,
    MF_TAG_BEFORE_MFB_CAM_SEEE_SE_CORE_CTRL_2,
    MF_TAG_AFTER_MFB_CAM_ANR_CON1,      //ee/anr after mfb
    MF_TAG_AFTER_MFB_CAM_ANR_CON2,
    MF_TAG_AFTER_MFB_CAM_ANR_CON3,
    MF_TAG_AFTER_MFB_CAM_ANR_YAD1,
    MF_TAG_AFTER_MFB_CAM_ANR_YAD2,
    MF_TAG_AFTER_MFB_CAM_ANR_4LUT1,
    MF_TAG_AFTER_MFB_CAM_ANR_4LUT2,
    MF_TAG_AFTER_MFB_CAM_ANR_4LUT3,
    MF_TAG_AFTER_MFB_CAM_ANR_PTY,
    MF_TAG_AFTER_MFB_CAM_ANR_CAD,
    MF_TAG_AFTER_MFB_CAM_ANR_PTC,
    MF_TAG_AFTER_MFB_CAM_ANR_LCE1,
    MF_TAG_AFTER_MFB_CAM_ANR_LCE2,
    MF_TAG_AFTER_MFB_CAM_ANR_HP1,
    MF_TAG_AFTER_MFB_CAM_ANR_HP2,
    MF_TAG_AFTER_MFB_CAM_ANR_HP3,
    MF_TAG_AFTER_MFB_CAM_ANR_ACTY,
    MF_TAG_AFTER_MFB_CAM_ANR_ACTC,
    MF_TAG_AFTER_MFB_CAM_SEEE_SRK_CTRL,
    MF_TAG_AFTER_MFB_CAM_SEEE_CLIP_CTRL,
    MF_TAG_AFTER_MFB_CAM_SEEE_FLT_CTRL_1,
    MF_TAG_AFTER_MFB_CAM_SEEE_FLT_CTRL_2,
    MF_TAG_AFTER_MFB_CAM_SEEE_GLUT_CTRL_01,
    MF_TAG_AFTER_MFB_CAM_SEEE_GLUT_CTRL_02,
    MF_TAG_AFTER_MFB_CAM_SEEE_GLUT_CTRL_03,
    MF_TAG_AFTER_MFB_CAM_SEEE_GLUT_CTRL_04,
    MF_TAG_AFTER_MFB_CAM_SEEE_GLUT_CTRL_05,
    MF_TAG_AFTER_MFB_CAM_SEEE_GLUT_CTRL_06,
    MF_TAG_AFTER_MFB_CAM_SEEE_EDTR_CTRL,
    MF_TAG_AFTER_MFB_CAM_SEEE_GLUT_CTRL_07,
    MF_TAG_AFTER_MFB_CAM_SEEE_GLUT_CTRL_08,
    MF_TAG_AFTER_MFB_CAM_SEEE_GLUT_CTRL_09,
    MF_TAG_AFTER_MFB_CAM_SEEE_GLUT_CTRL_10,
    MF_TAG_AFTER_MFB_CAM_SEEE_GLUT_CTRL_11,
    MF_TAG_AFTER_MFB_CAM_SEEE_OUT_EDGE_CTRL,
    MF_TAG_AFTER_MFB_CAM_SEEE_SE_Y_CTRL,
    MF_TAG_AFTER_MFB_CAM_SEEE_SE_EDGE_CTRL_1,
    MF_TAG_AFTER_MFB_CAM_SEEE_SE_EDGE_CTRL_2,
    MF_TAG_AFTER_MFB_CAM_SEEE_SE_EDGE_CTRL_3,
    MF_TAG_AFTER_MFB_CAM_SEEE_SE_SPECL_CTRL,
    MF_TAG_AFTER_MFB_CAM_SEEE_SE_CORE_CTRL_1,
    MF_TAG_AFTER_MFB_CAM_SEEE_SE_CORE_CTRL_2,
    MF_TAG_IN_MFB_CAM_MFB_LL_CON2,
    MF_TAG_IN_MFB_CAM_MFB_LL_CON3,
    MF_TAG_IN_MFB_CAM_MFB_LL_CON4,
    MF_TAG_IN_MFB_CAM_MFB_LL_CON5,
    MF_TAG_IN_MFB_CAM_MFB_LL_CON6,
    MF_TAG_AFTER_MFB_CAM_MFB_LL_CON2,
    MF_TAG_AFTER_MFB_CAM_MFB_LL_CON3,
    MF_TAG_AFTER_MFB_CAM_MFB_LL_CON4,
    MF_TAG_AFTER_MFB_CAM_MFB_LL_CON5,
    MF_TAG_AFTER_MFB_CAM_MFB_LL_CON6,
    MF_TAG_AFTER_MFB_CAM_MIX3_CTRL_0,
    MF_TAG_AFTER_MFB_CAM_MIX3_CTRL_1,
    MF_TAG_AFTER_MFB_CAM_MIX3_SPARE,
    //don't forget add new tag of register to MFLL_DUMP_REG_TEMPLATE
} DEBUG_MF_TAG_T;


#endif //_DBG_CAM_MF_PARAM_H
