/* BEGIN PN:DTS2013053103858 , Added by d00238048, 2013.05.31*/
#ifndef BUILD_LK
#include <linux/string.h>
#endif
#include "lcm_drv.h"

#ifdef BUILD_LK
	#include <platform/mt_gpio.h>
	#include <platform/mt_i2c.h> 
	#include <platform/mt_pmic.h>
#elif defined(BUILD_UBOOT)
    #include <asm/arch/mt_gpio.h>
#else
    //#include <linux/delay.h>
    #include <mach/mt_gpio.h>
#endif
#include <cust_gpio_usage.h>
#include <cust_i2c.h>
#ifdef BUILD_LK
#define LCD_DEBUG(fmt)  dprintf(CRITICAL,fmt)
#else
#define LCD_DEBUG(fmt)  printk(fmt)
#endif


static const unsigned int BL_MIN_LEVEL =20;
static LCM_UTIL_FUNCS lcm_util;

#define SET_RESET_PIN(v)    								(lcm_util.set_reset_pin((v)))
#define MDELAY(n) 											(lcm_util.mdelay(n))

// ---------------------------------------------------------------------------
//  Local Functions
// ---------------------------------------------------------------------------

#define dsi_set_cmdq_V2(cmd, count, ppara, force_update)	lcm_util.dsi_set_cmdq_V2(cmd, count, ppara, force_update)
#define dsi_set_cmdq(pdata, queue_size, force_update)		lcm_util.dsi_set_cmdq(pdata, queue_size, force_update)
#define wrtie_cmd(cmd)										lcm_util.dsi_write_cmd(cmd)
#define write_regs(addr, pdata, byte_nums)					lcm_util.dsi_write_regs(addr, pdata, byte_nums)
#define read_reg(cmd)										lcm_util.dsi_dcs_read_lcm_reg(cmd)
#define read_reg_v2(cmd, buffer, buffer_size)   			lcm_util.dsi_dcs_read_lcm_reg_v2(cmd, buffer, buffer_size)    


//static unsigned char lcd_id_pins_value = 0xFF;
static const unsigned char LCD_MODULE_ID = 0x01; //  haobing modified 2013.07.11
// ---------------------------------------------------------------------------
//  Local Constants
// ---------------------------------------------------------------------------
#define LCM_DSI_CMD_MODE									1
#define FRAME_WIDTH  										(1080)
#define FRAME_HEIGHT 										(1920)


#define REGFLAG_DELAY             								0xFC
#define REGFLAG_END_OF_TABLE      							0xFD   // END OF REGISTERS MARKER


#ifndef TRUE
    #define TRUE 1
#endif

#ifndef FALSE
    #define FALSE 0
#endif
//static unsigned int lcm_esd_test = FALSE;      ///only for ESD test
// ---------------------------------------------------------------------------
//  Local Variables
// ---------------------------------------------------------------------------


struct LCM_setting_table {
    unsigned char cmd;
    unsigned char count;
    unsigned char para_list[64];
};

/* lenovo-sw yexm1 add lcd effect function 20140314 start */
#ifndef BUILD_LK
#ifdef LENOVO_LCM_EFFECT
static unsigned int lcm_gammamode_index = 0;

static struct LCM_setting_table lcm_gamma_cosy_setting[] = {
	{0xFF,1,{0x10}},
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},
	{0xFF,1,{0x20}},
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},
	{0xFF,1,{0x21}},
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},
	{0xFF,1,{0x22}},
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},
	{0xFF,1,{0x24}},
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},
	{0x9D,1,{0xB0}},
	{0x72,1,{0x00}},
	{0x93,1,{0x04}},
	{0x94,1,{0x04}},
	{0x9B,1,{0x0F}},
	{0x8A,1,{0x33}},
	{0x86,1,{0x1B}},
	{0x87,1,{0x39}},
	{0x88,1,{0x1B}},
	{0x89,1,{0x39}},
	{0x8B,1,{0xF4}},
	{0x8C,1,{0x01}},
	{0x90,1,{0x79}},
	{0x91,1,{0x44}},
	{0x92,1,{0x79}},
	{0x00,1,{0x0F}},
	{0x01,1,{0x00}},
	{0x02,1,{0x00}},
	{0x03,1,{0x00}},
	{0x04,1,{0x0B}},
	{0x05,1,{0x0C}},
	{0x06,1,{0x00}},
	{0x07,1,{0x00}},
	{0x08,1,{0x00}},
	{0x09,1,{0x00}},
	{0x0A,1,{0x03}},
	{0x0B,1,{0x04}},
	{0x0C,1,{0x01}},
	{0x0D,1,{0x13}},
	{0x0E,1,{0x15}},
	{0x0F,1,{0x17}},
	{0x10,1,{0x0F}},
	{0x11,1,{0x00}},
	{0x12,1,{0x00}},
	{0x13,1,{0x00}},
	{0x14,1,{0x0B}},
	{0x15,1,{0x0C}},
	{0x16,1,{0x00}},
	{0x17,1,{0x00}},
	{0x18,1,{0x00}},
	{0x19,1,{0x00}},
	{0x1A,1,{0x03}},
	{0x1B,1,{0x04}},
	{0x1C,1,{0x01}},
	{0x1D,1,{0x13}},
	{0x1E,1,{0x15}},
	{0x1F,1,{0x17}},
	{0x20,1,{0x09}},
	{0x21,1,{0x01}},
	{0x22,1,{0x00}},
	{0x23,1,{0x00}},
	{0x24,1,{0x00}},
	{0x25,1,{0x6D}},
	{0x26,1,{0x00}},
	{0x27,1,{0x00}},
	{0x2F,1,{0x02}},
	{0x30,1,{0x04}},
	{0x31,1,{0x49}},
	{0x32,1,{0x23}},
	{0x33,1,{0x01}},
	{0x34,1,{0x00}},
	{0x35,1,{0x69}},
	{0x36,1,{0x00}},
	{0x37,1,{0x2D}},
	{0x38,1,{0x08}},
	{0x39,1,{0x00}},
	{0x3A,1,{0x69}},
	{0x29,1,{0x58}},
	{0x2A,1,{0x16}},
	{0x5B,1,{0x00}},
	{0x5F,1,{0x75}},
	{0x63,1,{0x00}},
	{0x67,1,{0x04}},
	{0x7B,1,{0x80}},
	{0x7C,1,{0xD8}},
	{0x7D,1,{0x60}},
	{0x7E,1,{0x0b}},
	{0x7F,1,{0x17}},
	{0x80,1,{0x00}},
	{0x81,1,{0x06}},
	{0x82,1,{0x03}},
	{0x83,1,{0x00}},
	{0x84,1,{0x03}},
	{0x85,1,{0x07}},
	{0x74,1,{0x0b}},
	{0x75,1,{0x17}},
	{0x76,1,{0x06}},
	{0x77,1,{0x03}},
	{0x78,1,{0x00}},
	{0x79,1,{0x00}},
	{0x99,1,{0x33}},
	{0x98,1,{0x00}},
	{0xB3,1,{0x28}},
	{0xB4,1,{0x05}},
	{0xB5,1,{0x10}},

	{0xFF,1,{0x20}},
	{REGFLAG_DELAY, 2, {}},
	{0x00,1,{0x01}},
	{0x01,1,{0x55}},
	{0x02,1,{0x45}},
	{0x03,1,{0x55}},
	{0x05,1,{0x50}},
	{0x06,1,{0xA8}},
	{0x07,1,{0xB2}},
	{0x08,1,{0x0C}},
	{0x0B,1,{0xB3}},
	{0x0C,1,{0xB3}},
	{0x0E,1,{0xB5}},
	{0x0F,1,{0xB8}},
	{0x11,1,{0x2F}},
	{0x12,1,{0x2F}},
	{0x13,1,{0x03}},
	{0x14,1,{0x0A}},
	{0x15,1,{0x15}},
	{0x16,1,{0x15}},
	{0x6D,1,{0x44}},
	{0x58,1,{0x05}},
	{0x59,1,{0x05}},
	{0x5A,1,{0x05}},
	{0x5B,1,{0x05}},
	{0x5C,1,{0x00}},
	{0x5D,1,{0x00}},
	{0x5E,1,{0x00}},
	{0x5F,1,{0x00}},
	{0x1B,1,{0x39}},
	{0x1C,1,{0x39}},
	{0x1D,1,{0x47}},

	{0xFF,1,{0x20}},
	{REGFLAG_DELAY, 2, {}},
	{0x75,1,{0x00}},
	{0x76,1,{0x01}},
	{0x77,1,{0x00}},
	{0x78,1,{0x02}},
	{0x79,1,{0x00}},
	{0x7A,1,{0x0A}},
	{0x7B,1,{0x00}},
	{0x7C,1,{0x15}},
	{0x7D,1,{0x00}},
	{0x7E,1,{0x2B}},
	{0x7F,1,{0x00}},
	{0x80,1,{0x38}},
	{0x81,1,{0x00}},
	{0x82,1,{0x46}},
	{0x83,1,{0x00}},
	{0x84,1,{0x51}},
	{0x85,1,{0x00}},
	{0x86,1,{0x5F}},
	{0x87,1,{0x00}},
	{0x88,1,{0x8C}},
	{0x89,1,{0x00}},
	{0x8A,1,{0xB3}},
	{0x8B,1,{0x00}},
	{0x8C,1,{0xF9}},
	{0x8D,1,{0x01}},
	{0x8E,1,{0x33}},
	{0x8F,1,{0x01}},
	{0x90,1,{0x92}},
	{0x91,1,{0x01}},
	{0x92,1,{0xDD}},
	{0x93,1,{0x01}},
	{0x94,1,{0xDF}},
	{0x95,1,{0x02}},
	{0x96,1,{0x20}},
	{0x97,1,{0x02}},
	{0x98,1,{0x5A}},
	{0x99,1,{0x02}},
	{0x9A,1,{0x75}},
	{0x9B,1,{0x02}},
	{0x9C,1,{0x8D}},
	{0x9D,1,{0x02}},
	{0x9E,1,{0x97}},
	{0x9F,1,{0x02}},
	{0xA0,1,{0x9E}},
	{0xA2,1,{0x02}},
	{0xA3,1,{0x9F}},
	{0xA4,1,{0x02}},
	{0xA5,1,{0xA0}},
	{0xA6,1,{0x02}},
	{0xA7,1,{0xA1}},
	{0xA9,1,{0x02}},
	{0xAA,1,{0xA2}},
	{0xAB,1,{0x02}},
	{0xAC,1,{0xA3}},
	{0xAD,1,{0x02}},
	{0xAE,1,{0xA4}},
	{0xAF,1,{0x02}},
	{0xB0,1,{0xA6}},
	{0xB1,1,{0x02}},
	{0xB2,1,{0xA7}},
	{0xB3,1,{0x00}},
	{0xB4,1,{0x01}},
	{0xB5,1,{0x00}},
	{0xB6,1,{0x02}},
	{0xB7,1,{0x00}},
	{0xB8,1,{0x0A}},
	{0xB9,1,{0x00}},
	{0xBA,1,{0x15}},
	{0xBB,1,{0x00}},
	{0xBC,1,{0x2B}},
	{0xBD,1,{0x00}},
	{0xBE,1,{0x38}},
	{0xBF,1,{0x00}},
	{0xC0,1,{0x46}},
	{0xC1,1,{0x00}},
	{0xC2,1,{0x51}},
	{0xC3,1,{0x00}},
	{0xC4,1,{0x5F}},
	{0xC5,1,{0x00}},
	{0xC6,1,{0x8C}},
	{0xC7,1,{0x00}},
	{0xC8,1,{0xB3}},
	{0xC9,1,{0x00}},
	{0xCA,1,{0xF9}},
	{0xCB,1,{0x01}},
	{0xCC,1,{0x33}},
	{0xCD,1,{0x01}},
	{0xCE,1,{0x92}},
	{0xCF,1,{0x01}},
	{0xD0,1,{0xDD}},
	{0xD1,1,{0x01}},
	{0xD2,1,{0xDF}},
	{0xD3,1,{0x02}},
	{0xD4,1,{0x20}},
	{0xD5,1,{0x02}},
	{0xD6,1,{0x5A}},
	{0xD7,1,{0x02}},
	{0xD8,1,{0x75}},
	{0xD9,1,{0x02}},
	{0xDA,1,{0x8D}},
	{0xDB,1,{0x02}},
	{0xDC,1,{0x97}},
	{0xDD,1,{0x02}},
	{0xDE,1,{0x9E}},
	{0xDF,1,{0x02}},
	{0xE0,1,{0x9F}},
	{0xE1,1,{0x02}},
	{0xE2,1,{0xA0}},
	{0xE3,1,{0x02}},
	{0xE4,1,{0xA1}},
	{0xE5,1,{0x02}},
	{0xE6,1,{0xA2}},
	{0xE7,1,{0x02}},
	{0xE8,1,{0xA3}},
	{0xE9,1,{0x02}},
	{0xEA,1,{0xA4}},
	{0xEB,1,{0x02}},
	{0xEC,1,{0xA6}},
	{0xED,1,{0x02}},
	{0xEE,1,{0xA7}},
	{0xEF,1,{0x00}},
	{0xF0,1,{0x29}},
	{0xF1,1,{0x00}},
	{0xF2,1,{0x31}},
	{0xF3,1,{0x00}},
	{0xF4,1,{0x41}},
	{0xF5,1,{0x00}},
	{0xF6,1,{0x4F}},
	{0xF7,1,{0x00}},
	{0xF8,1,{0x58}},
	{0xF9,1,{0x00}},
	{0xFA,1,{0x67}},

	{0xFF,1,{0x21}},
	{REGFLAG_DELAY, 2, {}},
	{0x00,1,{0x00}},
	{0x01,1,{0x71}},
	{0x02,1,{0x00}},
	{0x03,1,{0x7D}},
	{0x04,1,{0x00}},
	{0x05,1,{0x87}},
	{0x06,1,{0x00}},
	{0x07,1,{0xAF}},
	{0x08,1,{0x00}},
	{0x09,1,{0xD2}},
	{0x0A,1,{0x01}},
	{0x0B,1,{0x10}},
	{0x0C,1,{0x01}},
	{0x0D,1,{0x46}},
	{0x0E,1,{0x01}},
	{0x0F,1,{0x9F}},
	{0x10,1,{0x01}},
	{0x11,1,{0xE8}},
	{0x12,1,{0x01}},
	{0x13,1,{0xEA}},
	{0x14,1,{0x02}},
	{0x15,1,{0x27}},
	{0x16,1,{0x02}},
	{0x17,1,{0x5F}},
	{0x18,1,{0x02}},
	{0x19,1,{0x7A}},
	{0x1A,1,{0x02}},
	{0x1B,1,{0x91}},
	{0x1C,1,{0x02}},
	{0x1D,1,{0x9B}},
	{0x1E,1,{0x02}},
	{0x1F,1,{0xA2}},
	{0x20,1,{0x02}},
	{0x21,1,{0xA4}},
	{0x22,1,{0x02}},
	{0x23,1,{0xA5}},
	{0x24,1,{0x02}},
	{0x25,1,{0xA6}},
	{0x26,1,{0x02}},
	{0x27,1,{0xA7}},
	{0x28,1,{0x02}},
	{0x29,1,{0xA8}},
	{0x2A,1,{0x02}},
	{0x2B,1,{0xAA}},
	{0x2D,1,{0x02}},
	{0x2F,1,{0xAB}},
	{0x30,1,{0x02}},
	{0x31,1,{0xAC}},
	{0x32,1,{0x00}},
	{0x33,1,{0x29}},
	{0x34,1,{0x00}},
	{0x35,1,{0x31}},
	{0x36,1,{0x00}},
	{0x37,1,{0x41}},
	{0x38,1,{0x00}},
	{0x39,1,{0x4F}},
	{0x3A,1,{0x00}},
	{0x3B,1,{0x58}},
	{0x3D,1,{0x00}},
	{0x3F,1,{0x67}},
	{0x40,1,{0x00}},
	{0x41,1,{0x71}},
	{0x42,1,{0x00}},
	{0x43,1,{0x7D}},
	{0x44,1,{0x00}},
	{0x45,1,{0x87}},
	{0x46,1,{0x00}},
	{0x47,1,{0xAF}},
	{0x48,1,{0x00}},
	{0x49,1,{0xD2}},
	{0x4A,1,{0x01}},
	{0x4B,1,{0x10}},
	{0x4C,1,{0x01}},
	{0x4D,1,{0x46}},
	{0x4E,1,{0x01}},
	{0x4F,1,{0x9F}},
	{0x50,1,{0x01}},
	{0x51,1,{0xE8}},
	{0x52,1,{0x01}},
	{0x53,1,{0xEA}},
	{0x54,1,{0x02}},
	{0x55,1,{0x27}},
	{0x56,1,{0x02}},
	{0x58,1,{0x5F}},
	{0x59,1,{0x02}},
	{0x5A,1,{0x7A}},
	{0x5B,1,{0x02}},
	{0x5C,1,{0x91}},
	{0x5D,1,{0x02}},
	{0x5E,1,{0x9B}},
	{0x5F,1,{0x02}},
	{0x60,1,{0xA2}},
	{0x61,1,{0x02}},
	{0x62,1,{0xA4}},
	{0x63,1,{0x02}},
	{0x64,1,{0xA5}},
	{0x65,1,{0x02}},
	{0x66,1,{0xA6}},
	{0x67,1,{0x02}},
	{0x68,1,{0xA7}},
	{0x69,1,{0x02}},
	{0x6A,1,{0xA8}},
	{0x6B,1,{0x02}},
	{0x6C,1,{0xAA}},
	{0x6D,1,{0x02}},
	{0x6E,1,{0xAB}},
	{0x6F,1,{0x02}},
	{0x70,1,{0xAC}},
	{0x71,1,{0x00}},
	{0x72,1,{0xEB}},
	{0x73,1,{0x00}},
	{0x74,1,{0xEC}},
	{0x75,1,{0x00}},
	{0x76,1,{0xF4}},
	{0x77,1,{0x00}},
	{0x78,1,{0xFB}},
	{0x79,1,{0x01}},
	{0x7A,1,{0x01}},
	{0x7B,1,{0x01}},
	{0x7C,1,{0x07}},
	{0x7D,1,{0x01}},
	{0x7E,1,{0x0E}},
	{0x7F,1,{0x01}},
	{0x80,1,{0x13}},
	{0x81,1,{0x01}},
	{0x82,1,{0x1A}},
	{0x83,1,{0x01}},
	{0x84,1,{0x31}},
	{0x85,1,{0x01}},
	{0x86,1,{0x48}},
	{0x87,1,{0x01}},
	{0x88,1,{0x71}},
	{0x89,1,{0x01}},
	{0x8A,1,{0x95}},
	{0x8B,1,{0x01}},
	{0x8C,1,{0xD6}},
	{0x8D,1,{0x02}},
	{0x8E,1,{0x0F}},
	{0x8F,1,{0x02}},
	{0x90,1,{0x10}},
	{0x91,1,{0x02}},
	{0x92,1,{0x44}},
	{0x93,1,{0x02}},
	{0x94,1,{0x76}},
	{0x95,1,{0x02}},
	{0x96,1,{0x90}},
	{0x97,1,{0x02}},
	{0x98,1,{0xA7}},
	{0x99,1,{0x02}},
	{0x9A,1,{0xB1}},
	{0x9B,1,{0x02}},
	{0x9C,1,{0xB9}},
	{0x9D,1,{0x02}},
	{0x9E,1,{0xBA}},
	{0x9F,1,{0x02}},
	{0xA0,1,{0xBB}},
	{0xA2,1,{0x02}},
	{0xA3,1,{0xBD}},
	{0xA4,1,{0x02}},
	{0xA5,1,{0xBE}},
	{0xA6,1,{0x02}},
	{0xA7,1,{0xBF}},
	{0xA9,1,{0x02}},
	{0xAA,1,{0xC0}},
	{0xAB,1,{0x02}},
	{0xAC,1,{0xC1}},
	{0xAD,1,{0x02}},
	{0xAE,1,{0xC2}},
	{0xAF,1,{0x00}},
	{0xB0,1,{0xEB}},
	{0xB1,1,{0x00}},
	{0xB2,1,{0xEC}},
	{0xB3,1,{0x00}},
	{0xB4,1,{0xF4}},
	{0xB5,1,{0x00}},
	{0xB6,1,{0xFB}},
	{0xB7,1,{0x01}},
	{0xB8,1,{0x01}},
	{0xB9,1,{0x01}},
	{0xBA,1,{0x07}},
	{0xBB,1,{0x01}},
	{0xBC,1,{0x0E}},
	{0xBD,1,{0x01}},
	{0xBE,1,{0x13}},
	{0xBF,1,{0x01}},
	{0xC0,1,{0x1A}},
	{0xC1,1,{0x01}},
	{0xC2,1,{0x31}},
	{0xC3,1,{0x01}},
	{0xC4,1,{0x48}},
	{0xC5,1,{0x01}},
	{0xC6,1,{0x71}},
	{0xC7,1,{0x01}},
	{0xC8,1,{0x95}},
	{0xC9,1,{0x01}},
	{0xCA,1,{0xD6}},
	{0xCB,1,{0x02}},
	{0xCC,1,{0x0F}},
	{0xCD,1,{0x02}},
	{0xCE,1,{0x10}},
	{0xCF,1,{0x02}},
	{0xD0,1,{0x44}},
	{0xD1,1,{0x02}},
	{0xD2,1,{0x76}},
	{0xD3,1,{0x02}},
	{0xD4,1,{0x90}},
	{0xD5,1,{0x02}},
	{0xD6,1,{0xA7}},
	{0xD7,1,{0x02}},
	{0xD8,1,{0xB1}},
	{0xD9,1,{0x02}},
	{0xDA,1,{0xB9}},
	{0xDB,1,{0x02}},
	{0xDC,1,{0xBA}},
	{0xDD,1,{0x02}},
	{0xDE,1,{0xBB}},
	{0xDF,1,{0x02}},
	{0xE0,1,{0xBD}},
	{0xE1,1,{0x02}},
	{0xE2,1,{0xBE}},
	{0xE3,1,{0x02}},
	{0xE4,1,{0xBF}},
	{0xE5,1,{0x02}},
	{0xE6,1,{0xC0}},
	{0xE7,1,{0x02}},
	{0xE8,1,{0xC1}},
	{0xE9,1,{0x02}},
	{0xEA,1,{0xC2}},

	{0xFF,1,{0x10}},
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},
	{0x55,1,{0x00}},
	{0xFF,1,{0x22}},
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},
	{0x00,1,{0x5F}},
	{0x01,1,{0x69}},
	{0x02,1,{0x64}},
	{0x03,1,{0x5F}},
	{0x04,1,{0x5A}},
	{0x05,1,{0x50}},
	{0x06,1,{0x55}},
	{0x07,1,{0x5A}},
	{0x08,1,{0x50}},
	{0x09,1,{0x46}},
	{0x0A,1,{0x3C}},
	{0x0B,1,{0x32}},
	{0x0C,1,{0x3C}},
	{0x0D,1,{0x32}},
	{0x0E,1,{0x28}},
	{0x0F,1,{0x3C}},
	{0x10,1,{0x50}},
	{0x11,1,{0x64}},
	{0x12,1,{0x78}},
	{0x13,1,{0x82}},
	{0x1B,1,{0x5A}},
	{0x1C,1,{0x50}},
	{0x1D,1,{0x46}},
	{0x1E,1,{0x3C}},
	{0x1F,1,{0x32}},
	{0x20,1,{0x28}},
	{0x21,1,{0x1E}},
	{0x22,1,{0x1A}},
	{0x23,1,{0x18}},
	{0x24,1,{0x16}},
	{0x25,1,{0x10}},
	{0x26,1,{0x08}},
	{0x27,1,{0x04}},
	{0x28,1,{0x00}},
	{0x29,1,{0x00}},
	{0x2A,1,{0x00}},
	{0x2B,1,{0x00}},
	{0x2F,1,{0x00}},
	{0x30,1,{0x00}},
	{0x31,1,{0x00}},
	{0x32,1,{0x1C}},
	{0x33,1,{0x9C}},
	{0x34,1,{0x99}},
	{0x35,1,{0x17}},
	{0x36,1,{0x17}},
	{0x37,1,{0x17}},
	{0x38,1,{0x1C}},
	{0x39,1,{0x1E}},
	{0x3A,1,{0x1C}},
	{0x3B,1,{0x19}},
	{0x3F,1,{0x16}},
	{0x40,1,{0x19}},
	{0x41,1,{0x19}},
	{0x42,1,{0x1C}},
	{0x43,1,{0x20}},
	{0x44,1,{0x23}},
	{0x45,1,{0x23}},
	{0x46,1,{0x23}},
	{0x47,1,{0x23}},
	{0x48,1,{0x20}},
	{0x49,1,{0x1E}},
	{0x4A,1,{0x1C}},
	{0x4B,1,{0x19}},
	{0x4C,1,{0x1C}},
	{0x1A,1,{0x00}},
	{0x53,1,{0x01}},
	{0x54,1,{0x01}},
	{0x55,1,{0x00}},
	{0x56,1,{0x01}},
	{0x68,1,{0x00}},
	{0x14,1,{0x00}},
	{0x4D,1,{0x00}},
	{0x58,1,{0x0A}},
	{0x59,1,{0x14}},
	{0x64,1,{0x20}},
	{0x65,1,{0x00}},
	{0x69,1,{0x02}},
	{0xFF,1,{0x10}},
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},
	{0x55,1,{0x00}},
};

static struct LCM_setting_table lcm_gamma_sunshine_setting[] = {
	{0xFF,1,{0x20}},
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},
	{0xFF,1,{0x21}},
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},
	{0xFF,1,{0x24}},
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},
	{0x9D,1,{0xB0}},
	{0x72,1,{0x00}},
	{0x93,1,{0x04}},
	{0x94,1,{0x04}},
	{0x9B,1,{0x0F}},
	{0x8A,1,{0x33}},
	{0x86,1,{0x1B}},
	{0x87,1,{0x39}},
	{0x88,1,{0x1B}},
	{0x89,1,{0x39}},
	{0x8B,1,{0xF4}},
	{0x8C,1,{0x01}},
	{0x90,1,{0x79}},
	{0x91,1,{0x44}},
	{0x92,1,{0x79}},
	{0x00,1,{0x0F}},
	{0x01,1,{0x00}},
	{0x02,1,{0x00}},
	{0x03,1,{0x00}},
	{0x04,1,{0x0B}},
	{0x05,1,{0x0C}},
	{0x06,1,{0x00}},
	{0x07,1,{0x00}},
	{0x08,1,{0x00}},
	{0x09,1,{0x00}},
	{0x0A,1,{0x03}},
	{0x0B,1,{0x04}},
	{0x0C,1,{0x01}},
	{0x0D,1,{0x13}},
	{0x0E,1,{0x15}},
	{0x0F,1,{0x17}},
	{0x10,1,{0x0F}},
	{0x11,1,{0x00}},
	{0x12,1,{0x00}},
	{0x13,1,{0x00}},
	{0x14,1,{0x0B}},
	{0x15,1,{0x0C}},
	{0x16,1,{0x00}},
	{0x17,1,{0x00}},
	{0x18,1,{0x00}},
	{0x19,1,{0x00}},
	{0x1A,1,{0x03}},
	{0x1B,1,{0x04}},
	{0x1C,1,{0x01}},
	{0x1D,1,{0x13}},
	{0x1E,1,{0x15}},
	{0x1F,1,{0x17}},
	{0x20,1,{0x09}},
	{0x21,1,{0x01}},
	{0x22,1,{0x00}},
	{0x23,1,{0x00}},
	{0x24,1,{0x00}},
	{0x25,1,{0x6D}},
	{0x26,1,{0x00}},
	{0x27,1,{0x00}},
	{0x2F,1,{0x02}},
	{0x30,1,{0x04}},
	{0x31,1,{0x49}},
	{0x32,1,{0x23}},
	{0x33,1,{0x01}},
	{0x34,1,{0x00}},
	{0x35,1,{0x69}},
	{0x36,1,{0x00}},
	{0x37,1,{0x2D}},
	{0x38,1,{0x08}},
	{0x39,1,{0x00}},
	{0x3A,1,{0x69}},
	{0x29,1,{0x58}},
	{0x2A,1,{0x16}},
	{0x5B,1,{0x00}},
	{0x5F,1,{0x75}},
	{0x63,1,{0x00}},
	{0x67,1,{0x04}},
	{0x7B,1,{0x80}},
	{0x7C,1,{0xD8}},
	{0x7D,1,{0x60}},
	{0x7E,1,{0x0b}},
	{0x7F,1,{0x17}},
	{0x80,1,{0x00}},
	{0x81,1,{0x06}},
	{0x82,1,{0x03}},
	{0x83,1,{0x00}},
	{0x84,1,{0x03}},
	{0x85,1,{0x07}},
	{0x74,1,{0x0b}},
	{0x75,1,{0x17}},
	{0x76,1,{0x06}},
	{0x77,1,{0x03}},
	{0x78,1,{0x00}},
	{0x79,1,{0x00}},
	{0x99,1,{0x33}},
	{0x98,1,{0x00}},
	{0xB3,1,{0x28}},
	{0xB4,1,{0x05}},
	{0xB5,1,{0x10}},

	{0xFF,1,{0x20}},
	{REGFLAG_DELAY, 2, {}},
	{0x00,1,{0x01}},
	{0x01,1,{0x55}},
	{0x02,1,{0x45}},
	{0x03,1,{0x55}},
	{0x05,1,{0x50}},
	{0x06,1,{0xA8}},
	{0x07,1,{0xB2}},
	{0x08,1,{0x0C}},
	{0x0B,1,{0xB3}},
	{0x0C,1,{0xB3}},
	{0x0E,1,{0xB5}},
	{0x0F,1,{0xB8}},
	{0x11,1,{0x2F}},
	{0x12,1,{0x2F}},
	{0x13,1,{0x03}},
	{0x14,1,{0x0A}},
	{0x15,1,{0x15}},
	{0x16,1,{0x15}},
	{0x6D,1,{0x44}},
	{0x58,1,{0x05}},
	{0x59,1,{0x05}},
	{0x5A,1,{0x05}},
	{0x5B,1,{0x05}},
	{0x5C,1,{0x00}},
	{0x5D,1,{0x00}},
	{0x5E,1,{0x00}},
	{0x5F,1,{0x00}},
	{0x1B,1,{0x39}},
	{0x1C,1,{0x39}},
	{0x1D,1,{0x47}},

	{0xFF,1,{0x20}},
	{REGFLAG_DELAY, 2, {}},
	{0x75,1,{0x00}},
	{0x76,1,{0x63}},
	{0x77,1,{0x00}},
	{0x78,1,{0x72}},
	{0x79,1,{0x00}},
	{0x7A,1,{0x80}},
	{0x7B,1,{0x00}},
	{0x7C,1,{0x88}},
	{0x7D,1,{0x00}},
	{0x7E,1,{0x94}},
	{0x7F,1,{0x00}},
	{0x80,1,{0x9E}},
	{0x81,1,{0x00}},
	{0x82,1,{0xA6}},
	{0x83,1,{0x00}},
	{0x84,1,{0xAF}},
	{0x85,1,{0x00}},
	{0x86,1,{0xB7}},
	{0x87,1,{0x00}},
	{0x88,1,{0xDB}},
	{0x89,1,{0x00}},
	{0x8A,1,{0xF8}},
	{0x8B,1,{0x01}},
	{0x8C,1,{0x2F}},
	{0x8D,1,{0x01}},
	{0x8E,1,{0x61}},
	{0x8F,1,{0x01}},
	{0x90,1,{0xB5}},
	{0x91,1,{0x01}},
	{0x92,1,{0xFB}},
	{0x93,1,{0x01}},
	{0x94,1,{0xFD}},
	{0x95,1,{0x02}},
	{0x96,1,{0x3B}},
	{0x97,1,{0x02}},
	{0x98,1,{0x7D}},
	{0x99,1,{0x02}},
	{0x9A,1,{0xA5}},
	{0x9B,1,{0x02}},
	{0x9C,1,{0xD8}},
	{0x9D,1,{0x02}},
	{0x9E,1,{0xF9}},
	{0x9F,1,{0x03}},
	{0xA0,1,{0x25}},
	{0xA2,1,{0x03}},
	{0xA3,1,{0x34}},
	{0xA4,1,{0x03}},
	{0xA5,1,{0x43}},
	{0xA6,1,{0x03}},
	{0xA7,1,{0x46}},
	{0xA9,1,{0x03}},
	{0xAA,1,{0x6F}},
	{0xAB,1,{0x03}},
	{0xAC,1,{0x98}},
	{0xAD,1,{0x03}},
	{0xAE,1,{0xC1}},
	{0xAF,1,{0x03}},
	{0xB0,1,{0xEA}},
	{0xB1,1,{0x03}},
	{0xB2,1,{0xFF}},
	{0xB3,1,{0x00}},
	{0xB4,1,{0x63}},
	{0xB5,1,{0x00}},
	{0xB6,1,{0x72}},
	{0xB7,1,{0x00}},
	{0xB8,1,{0x80}},
	{0xB9,1,{0x00}},
	{0xBA,1,{0x88}},
	{0xBB,1,{0x00}},
	{0xBC,1,{0x94}},
	{0xBD,1,{0x00}},
	{0xBE,1,{0x9E}},
	{0xBF,1,{0x00}},
	{0xC0,1,{0xA6}},
	{0xC1,1,{0x00}},
	{0xC2,1,{0xAF}},
	{0xC3,1,{0x00}},
	{0xC4,1,{0xB7}},
	{0xC5,1,{0x00}},
	{0xC6,1,{0xDB}},
	{0xC7,1,{0x00}},
	{0xC8,1,{0xF8}},
	{0xC9,1,{0x01}},
	{0xCA,1,{0x2F}},
	{0xCB,1,{0x01}},
	{0xCC,1,{0x61}},
	{0xCD,1,{0x01}},
	{0xCE,1,{0xB5}},
	{0xCF,1,{0x01}},
	{0xD0,1,{0xFB}},
	{0xD1,1,{0x01}},
	{0xD2,1,{0xFD}},
	{0xD3,1,{0x02}},
	{0xD4,1,{0x3B}},
	{0xD5,1,{0x02}},
	{0xD6,1,{0x7D}},
	{0xD7,1,{0x02}},
	{0xD8,1,{0xA5}},
	{0xD9,1,{0x02}},
	{0xDA,1,{0xD8}},
	{0xDB,1,{0x02}},
	{0xDC,1,{0xF9}},
	{0xDD,1,{0x03}},
	{0xDE,1,{0x25}},
	{0xDF,1,{0x03}},
	{0xE0,1,{0x34}},
	{0xE1,1,{0x03}},
	{0xE2,1,{0x43}},
	{0xE3,1,{0x03}},
	{0xE4,1,{0x46}},
	{0xE5,1,{0x03}},
	{0xE6,1,{0x6F}},
	{0xE7,1,{0x03}},
	{0xE8,1,{0x98}},
	{0xE9,1,{0x03}},
	{0xEA,1,{0xC1}},
	{0xEB,1,{0x03}},
	{0xEC,1,{0xEA}},
	{0xED,1,{0x03}},
	{0xEE,1,{0xFF}},
	{0xEF,1,{0x00}},
	{0xF0,1,{0x01}},
	{0xF1,1,{0x00}},
	{0xF2,1,{0x04}},
	{0xF3,1,{0x00}},
	{0xF4,1,{0x13}},
	{0xF5,1,{0x00}},
	{0xF6,1,{0x24}},
	{0xF7,1,{0x00}},
	{0xF8,1,{0x31}},
	{0xF9,1,{0x00}},
	{0xFA,1,{0x3F}},

	{0xFF,1,{0x21}},
	{REGFLAG_DELAY, 2, {}},
	{0x00,1,{0x00}},
	{0x01,1,{0x4E}},
	{0x02,1,{0x00}},
	{0x03,1,{0x5B}},
	{0x04,1,{0x00}},
	{0x05,1,{0x68}},
	{0x06,1,{0x00}},
	{0x07,1,{0x93}},
	{0x08,1,{0x00}},
	{0x09,1,{0xBD}},
	{0x0A,1,{0x01}},
	{0x0B,1,{0x01}},
	{0x0C,1,{0x01}},
	{0x0D,1,{0x3C}},
	{0x0E,1,{0x01}},
	{0x0F,1,{0x9D}},
	{0x10,1,{0x01}},
	{0x11,1,{0xEA}},
	{0x12,1,{0x01}},
	{0x13,1,{0xED}},
	{0x14,1,{0x02}},
	{0x15,1,{0x30}},
	{0x16,1,{0x02}},
	{0x17,1,{0x75}},
	{0x18,1,{0x02}},
	{0x19,1,{0x9D}},
	{0x1A,1,{0x02}},
	{0x1B,1,{0xD1}},
	{0x1C,1,{0x02}},
	{0x1D,1,{0xF3}},
	{0x1E,1,{0x03}},
	{0x1F,1,{0x20}},
	{0x20,1,{0x03}},
	{0x21,1,{0x2D}},
	{0x22,1,{0x03}},
	{0x23,1,{0x3B}},
	{0x24,1,{0x03}},
	{0x25,1,{0x3E}},
	{0x26,1,{0x03}},
	{0x27,1,{0x68}},
	{0x28,1,{0x03}},
	{0x29,1,{0x93}},
	{0x2A,1,{0x03}},
	{0x2B,1,{0xBE}},
	{0x2D,1,{0x03}},
	{0x2F,1,{0xE9}},
	{0x30,1,{0x03}},
	{0x31,1,{0xFF}},
	{0x32,1,{0x00}},
	{0x33,1,{0x01}},
	{0x34,1,{0x00}},
	{0x35,1,{0x04}},
	{0x36,1,{0x00}},
	{0x37,1,{0x13}},
	{0x38,1,{0x00}},
	{0x39,1,{0x24}},
	{0x3A,1,{0x00}},
	{0x3B,1,{0x31}},
	{0x3D,1,{0x00}},
	{0x3F,1,{0x3F}},
	{0x40,1,{0x00}},
	{0x41,1,{0x4E}},
	{0x42,1,{0x00}},
	{0x43,1,{0x5B}},
	{0x44,1,{0x00}},
	{0x45,1,{0x68}},
	{0x46,1,{0x00}},
	{0x47,1,{0x93}},
	{0x48,1,{0x00}},
	{0x49,1,{0xBD}},
	{0x4A,1,{0x01}},
	{0x4B,1,{0x01}},
	{0x4C,1,{0x01}},
	{0x4D,1,{0x3C}},
	{0x4E,1,{0x01}},
	{0x4F,1,{0x9D}},
	{0x50,1,{0x01}},
	{0x51,1,{0xEA}},
	{0x52,1,{0x01}},
	{0x53,1,{0xED}},
	{0x54,1,{0x02}},
	{0x55,1,{0x30}},
	{0x56,1,{0x02}},
	{0x58,1,{0x75}},
	{0x59,1,{0x02}},
	{0x5A,1,{0x9D}},
	{0x5B,1,{0x02}},
	{0x5C,1,{0xD1}},
	{0x5D,1,{0x02}},
	{0x5E,1,{0xF3}},
	{0x5F,1,{0x03}},
	{0x60,1,{0x20}},
	{0x61,1,{0x03}},
	{0x62,1,{0x2D}},
	{0x63,1,{0x03}},
	{0x64,1,{0x3B}},
	{0x65,1,{0x03}},
	{0x66,1,{0x3E}},
	{0x67,1,{0x03}},
	{0x68,1,{0x68}},
	{0x69,1,{0x03}},
	{0x6A,1,{0x93}},
	{0x6B,1,{0x03}},
	{0x6C,1,{0xBE}},
	{0x6D,1,{0x03}},
	{0x6E,1,{0xE9}},
	{0x6F,1,{0x03}},
	{0x70,1,{0xFF}},
	{0x71,1,{0x00}},
	{0x72,1,{0x72}},
	{0x73,1,{0x00}},
	{0x74,1,{0x79}},
	{0x75,1,{0x00}},
	{0x76,1,{0x83}},
	{0x77,1,{0x00}},
	{0x78,1,{0x8F}},
	{0x79,1,{0x00}},
	{0x7A,1,{0x98}},
	{0x7B,1,{0x00}},
	{0x7C,1,{0xA1}},
	{0x7D,1,{0x00}},
	{0x7E,1,{0xA9}},
	{0x7F,1,{0x00}},
	{0x80,1,{0xB4}},
	{0x81,1,{0x00}},
	{0x82,1,{0xBD}},
	{0x83,1,{0x00}},
	{0x84,1,{0xDF}},
	{0x85,1,{0x00}},
	{0x86,1,{0xFD}},
	{0x87,1,{0x01}},
	{0x88,1,{0x34}},
	{0x89,1,{0x01}},
	{0x8A,1,{0x66}},
	{0x8B,1,{0x01}},
	{0x8C,1,{0xB7}},
	{0x8D,1,{0x01}},
	{0x8E,1,{0xFD}},
	{0x8F,1,{0x01}},
	{0x90,1,{0xFF}},
	{0x91,1,{0x02}},
	{0x92,1,{0x3D}},
	{0x93,1,{0x02}},
	{0x94,1,{0x7F}},
	{0x95,1,{0x02}},
	{0x96,1,{0xA7}},
	{0x97,1,{0x02}},
	{0x98,1,{0xDF}},
	{0x99,1,{0x03}},
	{0x9A,1,{0x06}},
	{0x9B,1,{0x03}},
	{0x9C,1,{0x46}},
	{0x9D,1,{0x03}},
	{0x9E,1,{0x64}},
	{0x9F,1,{0x03}},
	{0xA0,1,{0xA5}},
	{0xA2,1,{0x03}},
	{0xA3,1,{0xD9}},
	{0xA4,1,{0x03}},
	{0xA5,1,{0xE1}},
	{0xA6,1,{0x03}},
	{0xA7,1,{0xE9}},
	{0xA9,1,{0x03}},
	{0xAA,1,{0xF1}},
	{0xAB,1,{0x03}},
	{0xAC,1,{0xFA}},
	{0xAD,1,{0x03}},
	{0xAE,1,{0xFF}},
	{0xAF,1,{0x00}},
	{0xB0,1,{0x72}},
	{0xB1,1,{0x00}},
	{0xB2,1,{0x79}},
	{0xB3,1,{0x00}},
	{0xB4,1,{0x83}},
	{0xB5,1,{0x00}},
	{0xB6,1,{0x8F}},
	{0xB7,1,{0x00}},
	{0xB8,1,{0x98}},
	{0xB9,1,{0x00}},
	{0xBA,1,{0xA1}},
	{0xBB,1,{0x00}},
	{0xBC,1,{0xA9}},
	{0xBD,1,{0x00}},
	{0xBE,1,{0xB4}},
	{0xBF,1,{0x00}},
	{0xC0,1,{0xBD}},
	{0xC1,1,{0x00}},
	{0xC2,1,{0xDF}},
	{0xC3,1,{0x00}},
	{0xC4,1,{0xFD}},
	{0xC5,1,{0x01}},
	{0xC6,1,{0x34}},
	{0xC7,1,{0x01}},
	{0xC8,1,{0x66}},
	{0xC9,1,{0x01}},
	{0xCA,1,{0xB7}},
	{0xCB,1,{0x01}},
	{0xCC,1,{0xFD}},
	{0xCD,1,{0x01}},
	{0xCE,1,{0xFF}},
	{0xCF,1,{0x02}},
	{0xD0,1,{0x3D}},
	{0xD1,1,{0x02}},
	{0xD2,1,{0x7F}},
	{0xD3,1,{0x02}},
	{0xD4,1,{0xA7}},
	{0xD5,1,{0x02}},
	{0xD6,1,{0xDF}},
	{0xD7,1,{0x03}},
	{0xD8,1,{0x06}},
	{0xD9,1,{0x03}},
	{0xDA,1,{0x46}},
	{0xDB,1,{0x03}},
	{0xDC,1,{0x64}},
	{0xDD,1,{0x03}},
	{0xDE,1,{0xA5}},
	{0xDF,1,{0x03}},
	{0xE0,1,{0xD9}},
	{0xE1,1,{0x03}},
	{0xE2,1,{0xE1}},
	{0xE3,1,{0x03}},
	{0xE4,1,{0xE9}},
	{0xE5,1,{0x03}},
	{0xE6,1,{0xF1}},
	{0xE7,1,{0x03}},
	{0xE8,1,{0xFA}},
	{0xE9,1,{0x03}},
	{0xEA,1,{0xFF}},

	{0xFF,1,{0x10}},
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},
	{0x55,1,{0x80}},
	{0xFF,1,{0x22}},
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},
	{0x00,1,{0x5F}},
	{0x01,1,{0x69}},
	{0x02,1,{0x64}},
	{0x03,1,{0x5F}},
	{0x04,1,{0x5A}},
	{0x05,1,{0x50}},
	{0x06,1,{0x55}},
	{0x07,1,{0x5A}},
	{0x08,1,{0x50}},
	{0x09,1,{0x46}},
	{0x0A,1,{0x3C}},
	{0x0B,1,{0x32}},
	{0x0C,1,{0x3C}},
	{0x0D,1,{0x32}},
	{0x0E,1,{0x28}},
	{0x0F,1,{0x3C}},
	{0x10,1,{0x50}},
	{0x11,1,{0x64}},
	{0x12,1,{0x78}},
	{0x13,1,{0x82}},
	{0x1B,1,{0x5A}},
	{0x1C,1,{0x50}},
	{0x1D,1,{0x46}},
	{0x1E,1,{0x3C}},
	{0x1F,1,{0x32}},
	{0x20,1,{0x28}},
	{0x21,1,{0x1E}},
	{0x22,1,{0x1A}},
	{0x23,1,{0x18}},
	{0x24,1,{0x16}},
	{0x25,1,{0x10}},
	{0x26,1,{0x08}},
	{0x27,1,{0x04}},
	{0x28,1,{0x00}},
	{0x29,1,{0x00}},
	{0x2A,1,{0x00}},
	{0x2B,1,{0x00}},
	{0x2F,1,{0x00}},
	{0x30,1,{0x00}},
	{0x31,1,{0x00}},
	{0x32,1,{0x1C}},
	{0x33,1,{0x9C}},
	{0x34,1,{0x99}},
	{0x35,1,{0x17}},
	{0x36,1,{0x17}},
	{0x37,1,{0x17}},
	{0x38,1,{0x1C}},
	{0x39,1,{0x1E}},
	{0x3A,1,{0x1C}},
	{0x3B,1,{0x19}},
	{0x3F,1,{0x16}},
	{0x40,1,{0x19}},
	{0x41,1,{0x19}},
	{0x42,1,{0x1C}},
	{0x43,1,{0x20}},
	{0x44,1,{0x23}},
	{0x45,1,{0x23}},
	{0x46,1,{0x23}},
	{0x47,1,{0x23}},
	{0x48,1,{0x20}},
	{0x49,1,{0x1E}},
	{0x4A,1,{0x1C}},
	{0x4B,1,{0x19}},
	{0x4C,1,{0x1C}},
	{0x1A,1,{0x00}},
	{0x53,1,{0x01}},
	{0x54,1,{0x01}},
	{0x55,1,{0x00}},
	{0x56,1,{0x40}},
	{0x68,1,{0x00}},
	{0x14,1,{0x00}},
	{0x4D,1,{0x00}},
	{0x58,1,{0x0A}},
	{0x59,1,{0x14}},
	{0x64,1,{0x20}},
	{0x65,1,{0x00}},
	{0x69,1,{0x02}},
	{0xFF,1,{0x10}},
};

static struct LCM_setting_table lcm_gamma_default_setting[] = {
		//page selection cmd start
	{ 0xFF,1,{ 0x20}},
	{REGFLAG_DELAY, 2, {}},
	{ 0xFB,1,{ 0x01}},
	//ccmon          }},
	//page selectio}}, cmd end
	//R(+) MCR cmd }},
	{ 0x75,1,{0x00 }},
	{ 0x76,1,{0x81 }},
	{ 0x77,1,{0x00 }},
	{ 0x78,1,{0x99 }},
	{ 0x79,1,{0x00 }},
	{ 0x7A,1,{0xA8 }},
	{ 0x7B,1,{0x00 }},
	{ 0x7C,1,{0xB9 }},
	{ 0x7D,1,{0x00 }},
	{ 0x7E,1,{0xC5 }},
	{ 0x7F,1,{0x00 }},
	{ 0x80,1,{0xD2 }},
	{ 0x81,1,{0x00 }},
	{ 0x82,1,{0xDD }},
	{ 0x83,1,{0x00 }},
	{ 0x84,1,{0xEA }},
	{ 0x85,1,{0x00 }},
	{ 0x86,1,{0xF2 }},
	{ 0x87,1,{0x01 }},
	{ 0x88,1,{0x17 }},
	{ 0x89,1,{0x01 }},
	{ 0x8A,1,{0x37 }},
	{ 0x8B,1,{0x01 }},
	{ 0x8C,1,{0x69 }},
	{ 0x8D,1,{0x01 }},
	{ 0x8E,1,{0x95 }},
	{ 0x8F,1,{0x01 }},
	{ 0x90,1,{0xD8 }},
	{ 0x91,1,{0x02 }},
	{ 0x92,1,{0x0F }},
	{ 0x93,1,{0x02 }},
	{ 0x94,1,{0x12 }},
	{ 0x95,1,{0x02 }},
	{ 0x96,1,{0x47 }},
	{ 0x97,1,{0x02 }},
	{ 0x98,1,{0x85 }},
	{ 0x99,1,{0x02 }},
	{ 0x9A,1,{0xA8 }},
	{ 0x9B,1,{0x02 }},
	{ 0x9C,1,{0xD2 }},
	{ 0x9D,1,{0x02 }},
	{ 0x9E,1,{0xED }},
	{ 0x9F,1,{0x03 }},
	{ 0xA0,1,{0x23 }},
	{ 0xA2,1,{0x03 }},
	{ 0xA3,1,{0x2D }},
	{ 0xA4,1,{0x03 }},
	{ 0xA5,1,{0x37 }},
	{ 0xA6,1,{0x03 }},
	{ 0xA7,1,{0x39 }},
	{ 0xA9,1,{0x03 }},
	{ 0xAA,1,{0x65 }},
	{ 0xAB,1,{0x03 }},
	{ 0xAC,1,{0x91 }},
	{ 0xAD,1,{0x03 }},
	{ 0xAE,1,{0xBD }},
	{ 0xAF,1,{0x03 }},
	{ 0xB0,1,{0xE9 }},
	{ 0xB1,1,{0x03 }},
	{ 0xB2,1,{0xFF }},
	//R(-) MCR cmd }},
	{ 0xB3,1,{0x00 }},
	{ 0xB4,1,{0x81 }},
	{ 0xB5,1,{0x00 }},
	{ 0xB6,1,{0x99 }},
	{ 0xB7,1,{0x00 }},
	{ 0xB8,1,{0xA8 }},
	{ 0xB9,1,{0x00 }},
	{ 0xBA,1,{0xB9 }},
	{ 0xBB,1,{0x00 }},
	{ 0xBC,1,{0xC5 }},
	{ 0xBD,1,{0x00 }},
	{ 0xBE,1,{0xD2 }},
	{ 0xBF,1,{0x00 }},
	{ 0xC0,1,{0xDD }},
	{ 0xC1,1,{0x00 }},
	{ 0xC2,1,{0xEA }},
	{ 0xC3,1,{0x00 }},
	{ 0xC4,1,{0xF2 }},
	{ 0xC5,1,{0x01 }},
	{ 0xC6,1,{0x17 }},
	{ 0xC7,1,{0x01 }},
	{ 0xC8,1,{0x37 }},
	{ 0xC9,1,{0x01 }},
	{ 0xCA,1,{0x69 }},
	{ 0xCB,1,{0x01 }},
	{ 0xCC,1,{0x95 }},
	{ 0xCD,1,{0x01 }},
	{ 0xCE,1,{0xD8 }},
	{ 0xCF,1,{0x02 }},
	{ 0xD0,1,{0x0F }},
	{ 0xD1,1,{0x02 }},
	{ 0xD2,1,{0x12 }},
	{ 0xD3,1,{0x02 }},
	{ 0xD4,1,{0x47 }},
	{ 0xD5,1,{0x02 }},
	{ 0xD6,1,{0x85 }},
	{ 0xD7,1,{0x02 }},
	{ 0xD8,1,{0xA8 }},
	{ 0xD9,1,{0x02 }},
	{ 0xDA,1,{0xD2 }},
	{ 0xDB,1,{0x02 }},
	{ 0xDC,1,{0xED }},
	{ 0xDD,1,{0x03 }},
	{ 0xDE,1,{0x23 }},
	{ 0xDF,1,{0x03 }},
	{ 0xE0,1,{0x2D }},
	{ 0xE1,1,{0x03 }},
	{ 0xE2,1,{0x37 }},
	{ 0xE3,1,{0x03 }},
	{ 0xE4,1,{0x39 }},
	{ 0xE5,1,{0x03 }},
	{ 0xE6,1,{0x65 }},
	{ 0xE7,1,{0x03 }},
	{ 0xE8,1,{0x91 }},
	{ 0xE9,1,{0x03 }},
	{ 0xEA,1,{0xBD }},
	{ 0xEB,1,{0x03 }},
	{ 0xEC,1,{0xE9 }},
	{ 0xED,1,{0x03 }},
	{ 0xEE,1,{0xFF }},
	//G(+) MCR cmd }},
	{ 0xEF,1,{0x00 }},
	{ 0xF0,1,{0x01 }},
	{ 0xF1,1,{0x00 }},
	{ 0xF2,1,{0x1A }},
	{ 0xF3,1,{0x00 }},
	{ 0xF4,1,{0x4C }},
	{ 0xF5,1,{0x00 }},
	{ 0xF6,1,{0x6A }},
	{ 0xF7,1,{0x00 }},
	{ 0xF8,1,{0x83 }},
	{ 0xF9,1,{0x00 }},
	{ 0xFA,1,{0x97 }},
	//ccmoff         }},
	//ccmrun         }},
	//page selectio}}, cmd start
	{ 0xFF,1,{ 0x21}},
	{REGFLAG_DELAY, 2, {}},
	{ 0xFB,1,{ 0x01}},
	//ccmon          }},
	//page selectio}}, cmd end
	{ 0x00,1,{0x00 }},
	{ 0x01,1,{0xA9 }},
	{ 0x02,1,{0x00 }},
	{ 0x03,1,{0xB8 }},
	{ 0x04,1,{0x00 }},
	{ 0x05,1,{0xC7 }},
	{ 0x06,1,{0x00 }},
	{ 0x07,1,{0xF6 }},
	{ 0x08,1,{0x01 }},
	{ 0x09,1,{0x1B }},
	{ 0x0A,1,{0x01 }},
	{ 0x0B,1,{0x56 }},
	{ 0x0C,1,{0x01 }},
	{ 0x0D,1,{0x84 }},
	{ 0x0E,1,{0x01 }},
	{ 0x0F,1,{0xCE }},
	{ 0x10,1,{0x02 }},
	{ 0x11,1,{0x09 }},
	{ 0x12,1,{0x02 }},
	{ 0x13,1,{0x0A }},
	{ 0x14,1,{0x02 }},
	{ 0x15,1,{0x43 }},
	{ 0x16,1,{0x02 }},
	{ 0x17,1,{0x81 }},
	{ 0x18,1,{0x02 }},
	{ 0x19,1,{0xA5 }},
	{ 0x1A,1,{0x02 }},
	{ 0x1B,1,{0xCF }},
	{ 0x1C,1,{0x02 }},
	{ 0x1D,1,{0xEC }},
	{ 0x1E,1,{0x03 }},
	{ 0x1F,1,{0x24 }},
	{ 0x20,1,{0x03 }},
	{ 0x21,1,{0x2C }},
	{ 0x22,1,{0x03 }},
	{ 0x23,1,{0x36 }},
	{ 0x24,1,{0x03 }},
	{ 0x25,1,{0x3B }},
	{ 0x26,1,{0x03 }},
	{ 0x27,1,{0x66 }},
	{ 0x28,1,{0x03 }},
	{ 0x29,1,{0x91 }},
	{ 0x2A,1,{0x03 }},
	{ 0x2B,1,{0xBD }},
	{ 0x2D,1,{0x03 }},
	{ 0x2F,1,{0xE9 }},
	{ 0x30,1,{0x03 }},
	{ 0x31,1,{0xFF }},
	//G(-) MCR cmd }},
	{ 0x32,1,{0x00 }},
	{ 0x33,1,{0x01 }},
	{ 0x34,1,{0x00 }},
	{ 0x35,1,{0x1A }},
	{ 0x36,1,{0x00 }},
	{ 0x37,1,{0x4C }},
	{ 0x38,1,{0x00 }},
	{ 0x39,1,{0x6A }},
	{ 0x3A,1,{0x00 }},
	{ 0x3B,1,{0x83 }},
	{ 0x3D,1,{0x00 }},
	{ 0x3F,1,{0x97 }},
	{ 0x40,1,{0x00 }},
	{ 0x41,1,{0xA9 }},
	{ 0x42,1,{0x00 }},
	{ 0x43,1,{0xB8 }},
	{ 0x44,1,{0x00 }},
	{ 0x45,1,{0xC7 }},
	{ 0x46,1,{0x00 }},
	{ 0x47,1,{0xF6 }},
	{ 0x48,1,{0x01 }},
	{ 0x49,1,{0x1B }},
	{ 0x4A,1,{0x01 }},
	{ 0x4B,1,{0x56 }},
	{ 0x4C,1,{0x01 }},
	{ 0x4D,1,{0x84 }},
	{ 0x4E,1,{0x01 }},
	{ 0x4F,1,{0xCE }},
	{ 0x50,1,{0x02 }},
	{ 0x51,1,{0x09 }},
	{ 0x52,1,{0x02 }},
	{ 0x53,1,{0x0A }},
	{ 0x54,1,{0x02 }},
	{ 0x55,1,{0x43 }},
	{ 0x56,1,{0x02 }},
	{ 0x58,1,{0x81 }},
	{ 0x59,1,{0x02 }},
	{ 0x5A,1,{0xA5 }},
	{ 0x5B,1,{0x02 }},
	{ 0x5C,1,{0xCF }},
	{ 0x5D,1,{0x02 }},
	{ 0x5E,1,{0xEC }},
	{ 0x5F,1,{0x03 }},
	{ 0x60,1,{0x24 }},
	{ 0x61,1,{0x03 }},
	{ 0x62,1,{0x2C }},
	{ 0x63,1,{0x03 }},
	{ 0x64,1,{0x36 }},
	{ 0x65,1,{0x03 }},
	{ 0x66,1,{0x3B }},
	{ 0x67,1,{0x03 }},
	{ 0x68,1,{0x66 }},
	{ 0x69,1,{0x03 }},
	{ 0x6A,1,{0x91 }},
	{ 0x6B,1,{0x03 }},
	{ 0x6C,1,{0xBD }},
	{ 0x6D,1,{0x03 }},
	{ 0x6E,1,{0xE9 }},
	{ 0x6F,1,{0x03 }},
	{ 0x70,1,{0xFF }},
	//B(+) MCR cmd }},
	{ 0x71,1,{0x00 }},
	{ 0x72,1,{0x01 }},
	{ 0x73,1,{0x00 }},
	{ 0x74,1,{0x17 }},
	{ 0x75,1,{0x00 }},
	{ 0x76,1,{0x42 }},
	{ 0x77,1,{0x00 }},
	{ 0x78,1,{0x5F }},
	{ 0x79,1,{0x00 }},
	{ 0x7A,1,{0x76 }},
	{ 0x7B,1,{0x00 }},
	{ 0x7C,1,{0x8B }},
	{ 0x7D,1,{0x00 }},
	{ 0x7E,1,{0x9B }},
	{ 0x7F,1,{0x00 }},
	{ 0x80,1,{0xAC }},
	{ 0x81,1,{0x00 }},
	{ 0x82,1,{0xBA }},
	{ 0x83,1,{0x00 }},
	{ 0x84,1,{0xEA }},
	{ 0x85,1,{0x01 }},
	{ 0x86,1,{0x10 }},
	{ 0x87,1,{0x01 }},
	{ 0x88,1,{0x4C }},
	{ 0x89,1,{0x01 }},
	{ 0x8A,1,{0x7B }},
	{ 0x8B,1,{0x01 }},
	{ 0x8C,1,{0xC7 }},
	{ 0x8D,1,{0x02 }},
	{ 0x8E,1,{0x04 }},
	{ 0x8F,1,{0x02 }},
	{ 0x90,1,{0x06 }},
	{ 0x91,1,{0x02 }},
	{ 0x92,1,{0x3F }},
	{ 0x93,1,{0x02 }},
	{ 0x94,1,{0x7E }},
	{ 0x95,1,{0x02 }},
	{ 0x96,1,{0xA4 }},
	{ 0x97,1,{0x02 }},
	{ 0x98,1,{0xD1 }},
	{ 0x99,1,{0x02 }},
	{ 0x9A,1,{0xF3 }},
	{ 0x9B,1,{0x03 }},
	{ 0x9C,1,{0x35 }},
	{ 0x9D,1,{0x03 }},
	{ 0x9E,1,{0x49 }},
	{ 0x9F,1,{0x03 }},
	{ 0xA0,1,{0x7B }},
	{ 0xA2,1,{0x03 }},
	{ 0xA3,1,{0xFE }},
	{ 0xA4,1,{0x03 }},
	{ 0xA5,1,{0xFE }},
	{ 0xA6,1,{0x03 }},
	{ 0xA7,1,{0xFE }},
	{ 0xA9,1,{0x03 }},
	{ 0xAA,1,{0xFE }},
	{ 0xAB,1,{0x03 }},
	{ 0xAC,1,{0xFE }},
	{ 0xAD,1,{0x03 }},
	{ 0xAE,1,{0xFF }},
	//B(-) MCR cmd }},
	{ 0xAF,1,{0x00 }},
	{ 0xB0,1,{0x01 }},
	{ 0xB1,1,{0x00 }},
	{ 0xB2,1,{0x17 }},
	{ 0xB3,1,{0x00 }},
	{ 0xB4,1,{0x42 }},
	{ 0xB5,1,{0x00 }},
	{ 0xB6,1,{0x5F }},
	{ 0xB7,1,{0x00 }},
	{ 0xB8,1,{0x76 }},
	{ 0xB9,1,{0x00 }},
	{ 0xBA,1,{0x8B }},
	{ 0xBB,1,{0x00 }},
	{ 0xBC,1,{0x9B }},
	{ 0xBD,1,{0x00 }},
	{ 0xBE,1,{0xAC }},
	{ 0xBF,1,{0x00 }},
	{ 0xC0,1,{0xBA }},
	{ 0xC1,1,{0x00 }},
	{ 0xC2,1,{0xEA }},
	{ 0xC3,1,{0x01 }},
	{ 0xC4,1,{0x10 }},
	{ 0xC5,1,{0x01 }},
	{ 0xC6,1,{0x4C }},
	{ 0xC7,1,{0x01 }},
	{ 0xC8,1,{0x7B }},
	{ 0xC9,1,{0x01 }},
	{ 0xCA,1,{0xC7 }},
	{ 0xCB,1,{0x02 }},
	{ 0xCC,1,{0x04 }},
	{ 0xCD,1,{0x02 }},
	{ 0xCE,1,{0x06 }},
	{ 0xCF,1,{0x02 }},
	{ 0xD0,1,{0x3F }},
	{ 0xD1,1,{0x02 }},
	{ 0xD2,1,{0x7E }},
	{ 0xD3,1,{0x02 }},
	{ 0xD4,1,{0xA4 }},
	{ 0xD5,1,{0x02 }},
	{ 0xD6,1,{0xD1 }},
	{ 0xD7,1,{0x02 }},
	{ 0xD8,1,{0xF3 }},
	{ 0xD9,1,{0x03 }},
	{ 0xDA,1,{0x35 }},
	{ 0xDB,1,{0x03 }},
	{ 0xDC,1,{0x49 }},
	{ 0xDD,1,{0x03 }},
	{ 0xDE,1,{0x7B }},
	{ 0xDF,1,{0x03 }},
	{ 0xE0,1,{0xFE }},
	{ 0xE1,1,{0x03 }},
	{ 0xE2,1,{0xFE }},
	{ 0xE3,1,{0x03 }},
	{ 0xE4,1,{0xFE }},
	{ 0xE5,1,{0x03 }},
	{ 0xE6,1,{0xFE }},
	{ 0xE7,1,{0x03 }},
	{ 0xE8,1,{0xFE }},
	{ 0xE9,1,{0x03 }},
	{ 0xEA,1,{0xFF }},	

	{ 0xFF,1,{ 0x22}},
	{REGFLAG_DELAY, 2, {}},
	{ 0xFB,1,{ 0x01}},
	//               }},
	{ 0x00,1,{ 0x23}},
	{ 0x01,1,{ 0x26}},
	{ 0x02,1,{ 0x2B}},
	{ 0x03,1,{ 0x2C}},
	{ 0x04,1,{ 0x2D}},
	{ 0x05,1,{ 0x2D}},
	{ 0x06,1,{ 0x30}},
	{ 0x07,1,{ 0x30}},
	{ 0x08,1,{ 0x32}},
	{ 0x09,1,{ 0x32}},
	{ 0x0A,1,{ 0x32}},
	{ 0x0B,1,{ 0x32}},
	{ 0x0C,1,{ 0x37}},
	{ 0x0D,1,{ 0x3C}},
	{ 0x0E,1,{ 0x50}},
	{ 0x0F,1,{ 0x5A}},
	{ 0x10,1,{ 0x5A}},
	{ 0x11,1,{ 0x5A}},
	{ 0x12,1,{ 0x50}},
	{ 0x13,1,{ 0x46}},
	//               }},
	{ 0x1B,1,{ 0x0F}},
	{ 0x1C,1,{ 0x14}},
	{ 0x1D,1,{ 0x17}},
	{ 0x1E,1,{ 0x19}},
	{ 0x1F,1,{ 0x19}},
	{ 0x20,1,{ 0x19}},
	{ 0x21,1,{ 0x19}},
	{ 0x22,1,{ 0x19}},
	{ 0x23,1,{ 0x17}},
	{ 0x24,1,{ 0x14}},
	{ 0x25,1,{ 0x12}},
	{ 0x26,1,{ 0x0F}},
	{ 0x27,1,{ 0x0A}},
	{ 0x28,1,{ 0x0A}},
	{ 0x29,1,{ 0x08}},
	{ 0x2A,1,{ 0x05}},
	{ 0x2B,1,{ 0x05}},
	{ 0x2F,1,{ 0x05}},
	{ 0x30,1,{ 0x05}},
	{ 0x31,1,{ 0x03}},
	//               }},
	{ 0x32,1,{ 0x9E}},
	{ 0x33,1,{ 0xA3}},
	{ 0x34,1,{ 0xA6}},
	{ 0x35,1,{ 0x08}},
	{ 0x36,1,{ 0x0A}},
	{ 0x37,1,{ 0x0C}},
	{ 0x38,1,{ 0x0E}},
	{ 0x39,1,{ 0x10}},
	{ 0x3A,1,{ 0x12}},
	{ 0x3B,1,{ 0x14}},
	{ 0x3F,1,{ 0x16}},
	{ 0x40,1,{ 0x18}},
	{ 0x41,1,{ 0x1A}},
	{ 0x42,1,{ 0x18}},
	{ 0x43,1,{ 0x16}},
	{ 0x44,1,{ 0x14}},
	{ 0x45,1,{ 0x12}},
	{ 0x46,1,{ 0x10}},
	{ 0x47,1,{ 0x0E}},
	{ 0x48,1,{ 0x0C}},
	{ 0x49,1,{ 0x0A}},
	{ 0x4A,1,{ 0x08}},
	{ 0x4B,1,{ 0xA6}},
	{ 0x4C,1,{ 0xA2}},
	//SMART_COLOR R}},ATIO
	{ 0x4D,1,{ 0x0A}},
	//SMART_COLOR E}},NABLE
	{ 0x53,1,{ 0x77}},
	//SKIN_KEEP    }},
	{ 0x54,1,{ 0x77}},
	//V_CONSTRAIN E}},NABLE
	{ 0x55,1,{ 0x77}},
	//SC           }},
	{ 0x56,1,{ 0x00}},
	//SC_RELATED   }},
	{ 0x58,1,{ 0x0F}},
	{ 0x59,1,{ 0x11}},
	{ 0x64,1,{ 0x20}},
	//EDGE DISABLE }},
	{ 0x68,1,{ 0x00}},
	//EDGE RELATED }},
	//{ 0x65,1,{ 0x}},82
	//{ 0x66,1,{ 0x}},A6
	//{ 0x67,1,{ 0x}},C8
	//{ 0x69,1,{ 0x}},02
	//{ 0x97,1,{ 0x}},FF
	//{ 0x98,1,{ 0x}},1C
	{ 0xFF,1,{ 0x10}},
	{REGFLAG_DELAY, 2, {}},
	{ 0xFB,1,{ 0x01}},
	{ 0x55,1,{ 0x80}},
	
	{0xFF,1,{0x10}},
};

static struct LCM_setting_table lcm_gamma_low_color_setting[] = {	
	{0xFF,1,{0x23}},	//	CMD2	Page	3	Entrance	
	{REGFLAG_DELAY, 2, {}},	
	{0xFB,1,{0x01}},//
	{0x13,1,{0xDE}},
	{0x17,1,{0xDE}},	 // still mode // 0xFF 100% 0xDE 87%
	{0x21,1,{0xDE}},	//moving mode
	{0xFF,1,{0x10}},
};

static struct LCM_setting_table lcm_gamma_high_color_setting[] = {
	{0xFF,1,{0x23}},	//	CMD2	Page	3	Entrance	
	{REGFLAG_DELAY, 2, {}},	
	{0xFB,1,{0x01}},//
	{0x13,1,{0xFF}},
	{0x17,1,{0xFF}},	 // still mode // 0xFF 100% 0xDE 87%
	{0x21,1,{0xFF}},	//moving mode
	{0xFF,1,{0x10}},
};
#endif
#endif
/* lenovo-sw yexm1 add lcd effect function 20140314 end */

//update initial param for IC nt35520 0.01
static struct LCM_setting_table lcm_initialization_setting[] = {
	{0xFF,1,{0x10}},	//	Return	To	CMD1		
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},//
	{0xBB,1,{0x10}},//cmd mode
	//{0xBB,1,{0x03}}, //video mode
	{0x3B,5,{0x03,0x0A,0x0A,0x0A,0x0A}},	
	//{0x51,1,{0xFF}},//lenovo-sw yexm1 modify,20140404 begin
	{0x53,1,{0x24}},						
	{0x55,1,{0x02}},////lenovo-sw yexm1 modify,20140404 end						
	{0x5E,1,{0x00}},						
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
					
	{0x11,0,{}},						
	{REGFLAG_DELAY, 150, {}},
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	{0xFF,1,{0x24}},	//	CMD2	Page	4	Entrance	
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},		
	//{0xE3,1,{0x02}},
	{0x9D,1,{0xB0}},						
	{0x72,1,{0x00}},						
	{0x93,1,{0x04}},						
	{0x94,1,{0x04}},						
	{0x9B,1,{0x0F}},						
	{0x8A,1,{0x33}},						
	{0x86,1,{0x1B}},						
	{0x87,1,{0x39}},						
	{0x88,1,{0x1B}},						
	{0x89,1,{0x39}},						
	{0x8B,1,{0xF4}},						
	{0x8C,1,{0x01}},						
	{0x90,1,{0x79}},						
	{0x91,1,{0x4C}},						
	{0x92,1,{0x79}},						
	{0x95,1,{0xE4}},						

	{0xDE,1,{0xFF}},						
	{0xDF,1,{0x82}},						

	{0x00,1,{0x0F}},						
	{0x01,1,{0x00}},						
	{0x02,1,{0x00}},						
	{0x03,1,{0x00}},						
	{0x04,1,{0x0B}},						
	{0x05,1,{0x0C}},						
	{0x06,1,{0x00}},						
	{0x07,1,{0x00}},						
	{0x08,1,{0x00}},						
	{0x09,1,{0x00}},						
	{0x0A,1,{0X03}},						
	{0x0B,1,{0X04}},						
	{0x0C,1,{0x01}},						
	{0x0D,1,{0x13}},						
	{0x0E,1,{0x15}},						
	{0x0F,1,{0x17}},						
	{0x10,1,{0x0F}},						
	{0x11,1,{0x00}},						
	{0x12,1,{0x00}},						
	{0x13,1,{0x00}},						
	{0x14,1,{0x0B}},						
	{0x15,1,{0x0C}},						
	{0x16,1,{0x00}},						
	{0x17,1,{0x00}},						
	{0x18,1,{0x00}},						
	{0x19,1,{0x00}},						
	{0x1A,1,{0x03}},						
	{0x1B,1,{0X04}},						
	{0x1C,1,{0x01}},						
	{0x1D,1,{0x13}},						
	{0x1E,1,{0x15}},						
	{0x1F,1,{0x17}},						

	{0x20,1,{0x09}},						
	{0x21,1,{0x01}},						
	{0x22,1,{0x00}},						
	{0x23,1,{0x00}},						
	{0x24,1,{0x00}},						
	{0x25,1,{0x6D}},						
	{0x26,1,{0x00}},						
	{0x27,1,{0x00}},						

	{0x2F,1,{0x02}},						
	{0x30,1,{0x04}},						
	{0x31,1,{0x49}},						
	{0x32,1,{0x23}},						
	{0x33,1,{0x01}},						
	{0x34,1,{0x00}},						
	{0x35,1,{0x69}},						
	{0x36,1,{0x00}},						
	{0x37,1,{0x2D}},						
	{0x38,1,{0x08}},						
	{0x39,1,{0x00}},						
	{0x3A,1,{0x69}},						

	{0x29,1,{0x58}},						
	{0x2A,1,{0x16}},						

	{0x5B,1,{0x00}},						
	{0x5F,1,{0x75}},						
	{0x63,1,{0x00}},						
	{0x67,1,{0x04}},						

	{0x7B,1,{0x80}},						
	{0x7C,1,{0xD8}},						
	{0x7D,1,{0x60}},						
	{0x7E,1,{0x10}},						
	{0x7F,1,{0x19}},						
	{0x80,1,{0x00}},						
	{0x81,1,{0x06}},						
	{0x82,1,{0x03}},						
	{0x83,1,{0x00}},						
	{0x84,1,{0x03}},						
	{0x85,1,{0x07}},						
	{0x74,1,{0x10}},						
	{0x75,1,{0x19}},						
	{0x76,1,{0x06}},						
	{0x77,1,{0x03}},						

	{0x78,1,{0x00}},						
	{0x79,1,{0x00}},						
	{0x99,1,{0x33}},						
	{0x98,1,{0x00}},						
	{0xB3,1,{0x28}},						
	{0xB4,1,{0x05}},						
	{0xB5,1,{0x10}},						

	{0xFF,1,{0x20}},	//	Page	0,1,{	power-related	setting	
	{REGFLAG_DELAY, 2, {}},	
	{0xFB,1,{0x01}},//
	{0x00,1,{0x01}},						
	{0x01,1,{0x55}},						
	{0x02,1,{0x45}},						
	{0x03,1,{0x55}},						
	{0x05,1,{0x50}},						
	{0x06,1,{0x9E}},						
	{0x07,1,{0xA8}},						
	{0x08,1,{0x0C}},						
	{0x0B,1,{0x96}},						
	{0x0C,1,{0x96}},						
	{0x0E,1,{0x00}},						
	{0x0F,1,{0x00}},						
	{0x11,1,{0x29}},						
	{0x12,1,{0x29}},						
	{0x13,1,{0x03}},						
	{0x14,1,{0x0A}},						
	{0x15,1,{0x99}},						
	{0x16,1,{0x99}},						
	{0x6D,1,{0x44}},						
	{0x58,1,{0x05}},						
	{0x59,1,{0x05}},						
	{0x5A,1,{0x05}},						
	{0x5B,1,{0x05}},						
	{0x5C,1,{0x00}},						
	{0x5D,1,{0x00}},						
	{0x5E,1,{0x00}},						
	{0x5F,1,{0x00}},						

	{0x1B,1,{0x39}},						
	{0x1C,1,{0x39}},						
	{0x1D,1,{0x47}},						
		//page selection cmd start
	{ 0xFF,1,{ 0x20}},
	{REGFLAG_DELAY, 2, {}},
	{ 0xFB,1,{ 0x01}},
	//ccmon          }},
	//page selectio}}, cmd end
	//R(+) MCR cmd }},
	{ 0x75,1,{0x00 }},
	{ 0x76,1,{0x81 }},
	{ 0x77,1,{0x00 }},
	{ 0x78,1,{0x99 }},
	{ 0x79,1,{0x00 }},
	{ 0x7A,1,{0xA8 }},
	{ 0x7B,1,{0x00 }},
	{ 0x7C,1,{0xB9 }},
	{ 0x7D,1,{0x00 }},
	{ 0x7E,1,{0xC5 }},
	{ 0x7F,1,{0x00 }},
	{ 0x80,1,{0xD2 }},
	{ 0x81,1,{0x00 }},
	{ 0x82,1,{0xDD }},
	{ 0x83,1,{0x00 }},
	{ 0x84,1,{0xEA }},
	{ 0x85,1,{0x00 }},
	{ 0x86,1,{0xF2 }},
	{ 0x87,1,{0x01 }},
	{ 0x88,1,{0x17 }},
	{ 0x89,1,{0x01 }},
	{ 0x8A,1,{0x37 }},
	{ 0x8B,1,{0x01 }},
	{ 0x8C,1,{0x69 }},
	{ 0x8D,1,{0x01 }},
	{ 0x8E,1,{0x95 }},
	{ 0x8F,1,{0x01 }},
	{ 0x90,1,{0xD8 }},
	{ 0x91,1,{0x02 }},
	{ 0x92,1,{0x0F }},
	{ 0x93,1,{0x02 }},
	{ 0x94,1,{0x12 }},
	{ 0x95,1,{0x02 }},
	{ 0x96,1,{0x47 }},
	{ 0x97,1,{0x02 }},
	{ 0x98,1,{0x85 }},
	{ 0x99,1,{0x02 }},
	{ 0x9A,1,{0xA8 }},
	{ 0x9B,1,{0x02 }},
	{ 0x9C,1,{0xD2 }},
	{ 0x9D,1,{0x02 }},
	{ 0x9E,1,{0xED }},
	{ 0x9F,1,{0x03 }},
	{ 0xA0,1,{0x23 }},
	{ 0xA2,1,{0x03 }},
	{ 0xA3,1,{0x2D }},
	{ 0xA4,1,{0x03 }},
	{ 0xA5,1,{0x37 }},
	{ 0xA6,1,{0x03 }},
	{ 0xA7,1,{0x39 }},
	{ 0xA9,1,{0x03 }},
	{ 0xAA,1,{0x65 }},
	{ 0xAB,1,{0x03 }},
	{ 0xAC,1,{0x91 }},
	{ 0xAD,1,{0x03 }},
	{ 0xAE,1,{0xBD }},
	{ 0xAF,1,{0x03 }},
	{ 0xB0,1,{0xE9 }},
	{ 0xB1,1,{0x03 }},
	{ 0xB2,1,{0xFF }},
	//R(-) MCR cmd }},
	{ 0xB3,1,{0x00 }},
	{ 0xB4,1,{0x81 }},
	{ 0xB5,1,{0x00 }},
	{ 0xB6,1,{0x99 }},
	{ 0xB7,1,{0x00 }},
	{ 0xB8,1,{0xA8 }},
	{ 0xB9,1,{0x00 }},
	{ 0xBA,1,{0xB9 }},
	{ 0xBB,1,{0x00 }},
	{ 0xBC,1,{0xC5 }},
	{ 0xBD,1,{0x00 }},
	{ 0xBE,1,{0xD2 }},
	{ 0xBF,1,{0x00 }},
	{ 0xC0,1,{0xDD }},
	{ 0xC1,1,{0x00 }},
	{ 0xC2,1,{0xEA }},
	{ 0xC3,1,{0x00 }},
	{ 0xC4,1,{0xF2 }},
	{ 0xC5,1,{0x01 }},
	{ 0xC6,1,{0x17 }},
	{ 0xC7,1,{0x01 }},
	{ 0xC8,1,{0x37 }},
	{ 0xC9,1,{0x01 }},
	{ 0xCA,1,{0x69 }},
	{ 0xCB,1,{0x01 }},
	{ 0xCC,1,{0x95 }},
	{ 0xCD,1,{0x01 }},
	{ 0xCE,1,{0xD8 }},
	{ 0xCF,1,{0x02 }},
	{ 0xD0,1,{0x0F }},
	{ 0xD1,1,{0x02 }},
	{ 0xD2,1,{0x12 }},
	{ 0xD3,1,{0x02 }},
	{ 0xD4,1,{0x47 }},
	{ 0xD5,1,{0x02 }},
	{ 0xD6,1,{0x85 }},
	{ 0xD7,1,{0x02 }},
	{ 0xD8,1,{0xA8 }},
	{ 0xD9,1,{0x02 }},
	{ 0xDA,1,{0xD2 }},
	{ 0xDB,1,{0x02 }},
	{ 0xDC,1,{0xED }},
	{ 0xDD,1,{0x03 }},
	{ 0xDE,1,{0x23 }},
	{ 0xDF,1,{0x03 }},
	{ 0xE0,1,{0x2D }},
	{ 0xE1,1,{0x03 }},
	{ 0xE2,1,{0x37 }},
	{ 0xE3,1,{0x03 }},
	{ 0xE4,1,{0x39 }},
	{ 0xE5,1,{0x03 }},
	{ 0xE6,1,{0x65 }},
	{ 0xE7,1,{0x03 }},
	{ 0xE8,1,{0x91 }},
	{ 0xE9,1,{0x03 }},
	{ 0xEA,1,{0xBD }},
	{ 0xEB,1,{0x03 }},
	{ 0xEC,1,{0xE9 }},
	{ 0xED,1,{0x03 }},
	{ 0xEE,1,{0xFF }},
	//G(+) MCR cmd }},
	{ 0xEF,1,{0x00 }},
	{ 0xF0,1,{0x01 }},
	{ 0xF1,1,{0x00 }},
	{ 0xF2,1,{0x1A }},
	{ 0xF3,1,{0x00 }},
	{ 0xF4,1,{0x4C }},
	{ 0xF5,1,{0x00 }},
	{ 0xF6,1,{0x6A }},
	{ 0xF7,1,{0x00 }},
	{ 0xF8,1,{0x83 }},
	{ 0xF9,1,{0x00 }},
	{ 0xFA,1,{0x97 }},
	//ccmoff         }},
	//ccmrun         }},
	//page selectio}}, cmd start
	{ 0xFF,1,{ 0x21}},
	{REGFLAG_DELAY, 2, {}},
	{ 0xFB,1,{ 0x01}},
	//ccmon          }},
	//page selectio}}, cmd end
	{ 0x00,1,{0x00 }},
	{ 0x01,1,{0xA9 }},
	{ 0x02,1,{0x00 }},
	{ 0x03,1,{0xB8 }},
	{ 0x04,1,{0x00 }},
	{ 0x05,1,{0xC7 }},
	{ 0x06,1,{0x00 }},
	{ 0x07,1,{0xF6 }},
	{ 0x08,1,{0x01 }},
	{ 0x09,1,{0x1B }},
	{ 0x0A,1,{0x01 }},
	{ 0x0B,1,{0x56 }},
	{ 0x0C,1,{0x01 }},
	{ 0x0D,1,{0x84 }},
	{ 0x0E,1,{0x01 }},
	{ 0x0F,1,{0xCE }},
	{ 0x10,1,{0x02 }},
	{ 0x11,1,{0x09 }},
	{ 0x12,1,{0x02 }},
	{ 0x13,1,{0x0A }},
	{ 0x14,1,{0x02 }},
	{ 0x15,1,{0x43 }},
	{ 0x16,1,{0x02 }},
	{ 0x17,1,{0x81 }},
	{ 0x18,1,{0x02 }},
	{ 0x19,1,{0xA5 }},
	{ 0x1A,1,{0x02 }},
	{ 0x1B,1,{0xCF }},
	{ 0x1C,1,{0x02 }},
	{ 0x1D,1,{0xEC }},
	{ 0x1E,1,{0x03 }},
	{ 0x1F,1,{0x24 }},
	{ 0x20,1,{0x03 }},
	{ 0x21,1,{0x2C }},
	{ 0x22,1,{0x03 }},
	{ 0x23,1,{0x36 }},
	{ 0x24,1,{0x03 }},
	{ 0x25,1,{0x3B }},
	{ 0x26,1,{0x03 }},
	{ 0x27,1,{0x66 }},
	{ 0x28,1,{0x03 }},
	{ 0x29,1,{0x91 }},
	{ 0x2A,1,{0x03 }},
	{ 0x2B,1,{0xBD }},
	{ 0x2D,1,{0x03 }},
	{ 0x2F,1,{0xE9 }},
	{ 0x30,1,{0x03 }},
	{ 0x31,1,{0xFF }},
	//G(-) MCR cmd }},
	{ 0x32,1,{0x00 }},
	{ 0x33,1,{0x01 }},
	{ 0x34,1,{0x00 }},
	{ 0x35,1,{0x1A }},
	{ 0x36,1,{0x00 }},
	{ 0x37,1,{0x4C }},
	{ 0x38,1,{0x00 }},
	{ 0x39,1,{0x6A }},
	{ 0x3A,1,{0x00 }},
	{ 0x3B,1,{0x83 }},
	{ 0x3D,1,{0x00 }},
	{ 0x3F,1,{0x97 }},
	{ 0x40,1,{0x00 }},
	{ 0x41,1,{0xA9 }},
	{ 0x42,1,{0x00 }},
	{ 0x43,1,{0xB8 }},
	{ 0x44,1,{0x00 }},
	{ 0x45,1,{0xC7 }},
	{ 0x46,1,{0x00 }},
	{ 0x47,1,{0xF6 }},
	{ 0x48,1,{0x01 }},
	{ 0x49,1,{0x1B }},
	{ 0x4A,1,{0x01 }},
	{ 0x4B,1,{0x56 }},
	{ 0x4C,1,{0x01 }},
	{ 0x4D,1,{0x84 }},
	{ 0x4E,1,{0x01 }},
	{ 0x4F,1,{0xCE }},
	{ 0x50,1,{0x02 }},
	{ 0x51,1,{0x09 }},
	{ 0x52,1,{0x02 }},
	{ 0x53,1,{0x0A }},
	{ 0x54,1,{0x02 }},
	{ 0x55,1,{0x43 }},
	{ 0x56,1,{0x02 }},
	{ 0x58,1,{0x81 }},
	{ 0x59,1,{0x02 }},
	{ 0x5A,1,{0xA5 }},
	{ 0x5B,1,{0x02 }},
	{ 0x5C,1,{0xCF }},
	{ 0x5D,1,{0x02 }},
	{ 0x5E,1,{0xEC }},
	{ 0x5F,1,{0x03 }},
	{ 0x60,1,{0x24 }},
	{ 0x61,1,{0x03 }},
	{ 0x62,1,{0x2C }},
	{ 0x63,1,{0x03 }},
	{ 0x64,1,{0x36 }},
	{ 0x65,1,{0x03 }},
	{ 0x66,1,{0x3B }},
	{ 0x67,1,{0x03 }},
	{ 0x68,1,{0x66 }},
	{ 0x69,1,{0x03 }},
	{ 0x6A,1,{0x91 }},
	{ 0x6B,1,{0x03 }},
	{ 0x6C,1,{0xBD }},
	{ 0x6D,1,{0x03 }},
	{ 0x6E,1,{0xE9 }},
	{ 0x6F,1,{0x03 }},
	{ 0x70,1,{0xFF }},
	//B(+) MCR cmd }},
	{ 0x71,1,{0x00 }},
	{ 0x72,1,{0x01 }},
	{ 0x73,1,{0x00 }},
	{ 0x74,1,{0x17 }},
	{ 0x75,1,{0x00 }},
	{ 0x76,1,{0x42 }},
	{ 0x77,1,{0x00 }},
	{ 0x78,1,{0x5F }},
	{ 0x79,1,{0x00 }},
	{ 0x7A,1,{0x76 }},
	{ 0x7B,1,{0x00 }},
	{ 0x7C,1,{0x8B }},
	{ 0x7D,1,{0x00 }},
	{ 0x7E,1,{0x9B }},
	{ 0x7F,1,{0x00 }},
	{ 0x80,1,{0xAC }},
	{ 0x81,1,{0x00 }},
	{ 0x82,1,{0xBA }},
	{ 0x83,1,{0x00 }},
	{ 0x84,1,{0xEA }},
	{ 0x85,1,{0x01 }},
	{ 0x86,1,{0x10 }},
	{ 0x87,1,{0x01 }},
	{ 0x88,1,{0x4C }},
	{ 0x89,1,{0x01 }},
	{ 0x8A,1,{0x7B }},
	{ 0x8B,1,{0x01 }},
	{ 0x8C,1,{0xC7 }},
	{ 0x8D,1,{0x02 }},
	{ 0x8E,1,{0x04 }},
	{ 0x8F,1,{0x02 }},
	{ 0x90,1,{0x06 }},
	{ 0x91,1,{0x02 }},
	{ 0x92,1,{0x3F }},
	{ 0x93,1,{0x02 }},
	{ 0x94,1,{0x7E }},
	{ 0x95,1,{0x02 }},
	{ 0x96,1,{0xA4 }},
	{ 0x97,1,{0x02 }},
	{ 0x98,1,{0xD1 }},
	{ 0x99,1,{0x02 }},
	{ 0x9A,1,{0xF3 }},
	{ 0x9B,1,{0x03 }},
	{ 0x9C,1,{0x35 }},
	{ 0x9D,1,{0x03 }},
	{ 0x9E,1,{0x49 }},
	{ 0x9F,1,{0x03 }},
	{ 0xA0,1,{0x7B }},
	{ 0xA2,1,{0x03 }},
	{ 0xA3,1,{0xFE }},
	{ 0xA4,1,{0x03 }},
	{ 0xA5,1,{0xFE }},
	{ 0xA6,1,{0x03 }},
	{ 0xA7,1,{0xFE }},
	{ 0xA9,1,{0x03 }},
	{ 0xAA,1,{0xFE }},
	{ 0xAB,1,{0x03 }},
	{ 0xAC,1,{0xFE }},
	{ 0xAD,1,{0x03 }},
	{ 0xAE,1,{0xFF }},
	//B(-) MCR cmd }},
	{ 0xAF,1,{0x00 }},
	{ 0xB0,1,{0x01 }},
	{ 0xB1,1,{0x00 }},
	{ 0xB2,1,{0x17 }},
	{ 0xB3,1,{0x00 }},
	{ 0xB4,1,{0x42 }},
	{ 0xB5,1,{0x00 }},
	{ 0xB6,1,{0x5F }},
	{ 0xB7,1,{0x00 }},
	{ 0xB8,1,{0x76 }},
	{ 0xB9,1,{0x00 }},
	{ 0xBA,1,{0x8B }},
	{ 0xBB,1,{0x00 }},
	{ 0xBC,1,{0x9B }},
	{ 0xBD,1,{0x00 }},
	{ 0xBE,1,{0xAC }},
	{ 0xBF,1,{0x00 }},
	{ 0xC0,1,{0xBA }},
	{ 0xC1,1,{0x00 }},
	{ 0xC2,1,{0xEA }},
	{ 0xC3,1,{0x01 }},
	{ 0xC4,1,{0x10 }},
	{ 0xC5,1,{0x01 }},
	{ 0xC6,1,{0x4C }},
	{ 0xC7,1,{0x01 }},
	{ 0xC8,1,{0x7B }},
	{ 0xC9,1,{0x01 }},
	{ 0xCA,1,{0xC7 }},
	{ 0xCB,1,{0x02 }},
	{ 0xCC,1,{0x04 }},
	{ 0xCD,1,{0x02 }},
	{ 0xCE,1,{0x06 }},
	{ 0xCF,1,{0x02 }},
	{ 0xD0,1,{0x3F }},
	{ 0xD1,1,{0x02 }},
	{ 0xD2,1,{0x7E }},
	{ 0xD3,1,{0x02 }},
	{ 0xD4,1,{0xA4 }},
	{ 0xD5,1,{0x02 }},
	{ 0xD6,1,{0xD1 }},
	{ 0xD7,1,{0x02 }},
	{ 0xD8,1,{0xF3 }},
	{ 0xD9,1,{0x03 }},
	{ 0xDA,1,{0x35 }},
	{ 0xDB,1,{0x03 }},
	{ 0xDC,1,{0x49 }},
	{ 0xDD,1,{0x03 }},
	{ 0xDE,1,{0x7B }},
	{ 0xDF,1,{0x03 }},
	{ 0xE0,1,{0xFE }},
	{ 0xE1,1,{0x03 }},
	{ 0xE2,1,{0xFE }},
	{ 0xE3,1,{0x03 }},
	{ 0xE4,1,{0xFE }},
	{ 0xE5,1,{0x03 }},
	{ 0xE6,1,{0xFE }},
	{ 0xE7,1,{0x03 }},
	{ 0xE8,1,{0xFE }},
	{ 0xE9,1,{0x03 }},
	{ 0xEA,1,{0xFF }},					
	{0xFF,1,{0x21}},	//	Page	,1,{	Gamma	Default	Update
	{REGFLAG_DELAY, 2, {}},	
	{0xFB,1,{0x01}},//
	
	{0xEB,1,{0x30}},						
	{0xEC,1,{0x17}},						
	{0xED,1,{0x20}},						
	{0xEE,1,{0x0F}},						
	{0xEF,1,{0x1F}},						
	{0xF0,1,{0x0F}},						
	{0xF1,1,{0x0F}},						
	{0xF2,1,{0x07}},	
	{ 0xFF,1,{ 0x22}},
	{REGFLAG_DELAY, 2, {}},
	{ 0xFB,1,{ 0x01}},
	//               }},
	{ 0x00,1,{ 0x23}},
	{ 0x01,1,{ 0x26}},
	{ 0x02,1,{ 0x2B}},
	{ 0x03,1,{ 0x2C}},
	{ 0x04,1,{ 0x2D}},
	{ 0x05,1,{ 0x2D}},
	{ 0x06,1,{ 0x30}},
	{ 0x07,1,{ 0x30}},
	{ 0x08,1,{ 0x32}},
	{ 0x09,1,{ 0x32}},
	{ 0x0A,1,{ 0x32}},
	{ 0x0B,1,{ 0x32}},
	{ 0x0C,1,{ 0x37}},
	{ 0x0D,1,{ 0x3C}},
	{ 0x0E,1,{ 0x50}},
	{ 0x0F,1,{ 0x5A}},
	{ 0x10,1,{ 0x5A}},
	{ 0x11,1,{ 0x5A}},
	{ 0x12,1,{ 0x50}},
	{ 0x13,1,{ 0x46}},
	//               }},
	{ 0x1B,1,{ 0x0F}},
	{ 0x1C,1,{ 0x14}},
	{ 0x1D,1,{ 0x17}},
	{ 0x1E,1,{ 0x19}},
	{ 0x1F,1,{ 0x19}},
	{ 0x20,1,{ 0x19}},
	{ 0x21,1,{ 0x19}},
	{ 0x22,1,{ 0x19}},
	{ 0x23,1,{ 0x17}},
	{ 0x24,1,{ 0x14}},
	{ 0x25,1,{ 0x12}},
	{ 0x26,1,{ 0x0F}},
	{ 0x27,1,{ 0x0A}},
	{ 0x28,1,{ 0x0A}},
	{ 0x29,1,{ 0x08}},
	{ 0x2A,1,{ 0x05}},
	{ 0x2B,1,{ 0x05}},
	{ 0x2F,1,{ 0x05}},
	{ 0x30,1,{ 0x05}},
	{ 0x31,1,{ 0x03}},
	//               }},
	{ 0x32,1,{ 0x9E}},
	{ 0x33,1,{ 0xA3}},
	{ 0x34,1,{ 0xA6}},
	{ 0x35,1,{ 0x08}},
	{ 0x36,1,{ 0x0A}},
	{ 0x37,1,{ 0x0C}},
	{ 0x38,1,{ 0x0E}},
	{ 0x39,1,{ 0x10}},
	{ 0x3A,1,{ 0x12}},
	{ 0x3B,1,{ 0x14}},
	{ 0x3F,1,{ 0x16}},
	{ 0x40,1,{ 0x18}},
	{ 0x41,1,{ 0x1A}},
	{ 0x42,1,{ 0x18}},
	{ 0x43,1,{ 0x16}},
	{ 0x44,1,{ 0x14}},
	{ 0x45,1,{ 0x12}},
	{ 0x46,1,{ 0x10}},
	{ 0x47,1,{ 0x0E}},
	{ 0x48,1,{ 0x0C}},
	{ 0x49,1,{ 0x0A}},
	{ 0x4A,1,{ 0x08}},
	{ 0x4B,1,{ 0xA6}},
	{ 0x4C,1,{ 0xA2}},
	//SMART_COLOR R}},ATIO
	{ 0x4D,1,{ 0x0A}},
	//SMART_COLOR E}},NABLE
	{ 0x53,1,{ 0x77}},
	//SKIN_KEEP    }},
	{ 0x54,1,{ 0x77}},
	//V_CONSTRAIN E}},NABLE
	{ 0x55,1,{ 0x77}},
	//SC           }},
	{ 0x56,1,{ 0x00}},
	//SC_RELATED   }},
	{ 0x58,1,{ 0x0F}},
	{ 0x59,1,{ 0x11}},
	{ 0x64,1,{ 0x20}},
	//EDGE DISABLE }},
	{ 0x68,1,{ 0x00}},
	//EDGE RELATED }},
	//{ 0x65,1,{ 0x}},82
	//{ 0x66,1,{ 0x}},A6
	//{ 0x67,1,{ 0x}},C8
	//{ 0x69,1,{ 0x}},02
	//{ 0x97,1,{ 0x}},FF
	//{ 0x98,1,{ 0x}},1C
	{ 0xFF,1,{ 0x10}},
	{REGFLAG_DELAY, 2, {}},
	{ 0xFB,1,{ 0x01}},
	{ 0x55,1,{ 0x80}},
	{0xFF,1,{0x23}},	//	CMD2	Page	3	Entrance	
	{REGFLAG_DELAY, 2, {}},	
	{0xFB,1,{0x01}},//
	{0x07,1,{0x40}},		//10.5Mhz
	{0x08,1,{0x04}},						
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//image.first
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	{0xFF,1,{0x10}},	//	Return	To	CMD1		
	{REGFLAG_DELAY, 2, {}},				
	{0xFB,1,{0x01}},//
	
	{0x35,1,{0x00}},	
#if 1
	{0x11, 1, {0x00}},
	{REGFLAG_DELAY, 200, {}},

       //Display ON
       {0x29, 1, {0x00}},
       {REGFLAG_DELAY, 50, {}},
       {REGFLAG_END_OF_TABLE, 0x00, {}}

#else
	{0xFF,1,{0x24}},
	{REGFLAG_DELAY, 2, {}},	
	
	{0xEC,1,{0x01}},
#endif
};
							
#if 0
static struct LCM_setting_table lcm_set_window[] = {
	{0x2A,	4,	{0x00, 0x00, (FRAME_WIDTH>>8), (FRAME_WIDTH&0xFF)}},
	{0x2B,	4,	{0x00, 0x00, (FRAME_HEIGHT>>8), (FRAME_HEIGHT&0xFF)}},
	{REGFLAG_END_OF_TABLE, 0x00, {}}
};
#endif
#if 1
static struct LCM_setting_table lcm_sleep_out_setting[] = {
    //Sleep Out
    {0x11, 1, {0x00}},
    {REGFLAG_DELAY, 120, {}},

    // Display ON
    {0x29, 1, {0x00}},
    {REGFLAG_DELAY, 20, {}},
    {REGFLAG_END_OF_TABLE, 0x00, {}}
};
#endif

static struct LCM_setting_table lcm_deep_sleep_mode_in_setting[] = {
    // Display off sequence
    {0x28, 1, {0x00}},
    {REGFLAG_DELAY, 20, {}},

    // Sleep Mode On
    {0x10, 1, {0x00}},
    {REGFLAG_DELAY, 120, {}},
    {REGFLAG_END_OF_TABLE, 0x00, {}}
};

static void push_table(struct LCM_setting_table *table, unsigned int count, unsigned char force_update)
{
    unsigned int i;

    for(i = 0; i < count; i++)
    {
        unsigned cmd;
        cmd = table[i].cmd;

        switch (cmd) {

            case REGFLAG_DELAY :
                if(table[i].count <= 10)
                    MDELAY(table[i].count);
                else
                    MDELAY(table[i].count);
                break;

            case REGFLAG_END_OF_TABLE :
                break;

            default:
                dsi_set_cmdq_V2(cmd, table[i].count, table[i].para_list, force_update);
        }
    }
}

// ---------------------------------------------------------------------------
//  LCM Driver Implementations
// ---------------------------------------------------------------------------

static void lcm_set_util_funcs(const LCM_UTIL_FUNCS *util)
{
    memcpy(&lcm_util, util, sizeof(LCM_UTIL_FUNCS));
}


static void lcm_get_params(LCM_PARAMS *params)
{
	memset(params, 0, sizeof(LCM_PARAMS));

	params->type   = LCM_TYPE_DSI;

	params->width  = FRAME_WIDTH;
	params->height = FRAME_HEIGHT;

#if (LCM_DSI_CMD_MODE)
	params->dsi.mode   = CMD_MODE;
#else
    params->dsi.mode   = SYNC_PULSE_VDO_MODE;//BURST_VDO_MODE;//SYNC_PULSE_VDO_MODE;BURST_VDO_MODE
#endif

	// DSI
	/* Command mode setting */
	params->dsi.LANE_NUM				= LCM_FOUR_LANE;
	//The following defined the fomat for data coming from LCD engine.
	params->dsi.data_format.color_order 	= LCM_COLOR_ORDER_RGB;
	params->dsi.data_format.trans_seq   	= LCM_DSI_TRANS_SEQ_MSB_FIRST;
	params->dsi.data_format.padding     	= LCM_DSI_PADDING_ON_LSB;
	params->dsi.data_format.format      		= LCM_DSI_FORMAT_RGB888;

	// Highly depends on LCD driver capability.
	params->dsi.packet_size=256;
	//video mode timing

	params->dsi.PS=LCM_PACKED_PS_24BIT_RGB888;

	params->dsi.vertical_sync_active				= 2;
	params->dsi.vertical_backporch					= 8;
	params->dsi.vertical_frontporch					= 10;
	params->dsi.vertical_active_line					= FRAME_HEIGHT;

	params->dsi.horizontal_sync_active				= 10;
	params->dsi.horizontal_backporch				= 20;
	params->dsi.horizontal_frontporch				= 40;
	params->dsi.horizontal_active_pixel				= FRAME_WIDTH;

	//begin:haobing modified
	/*BEGIN PN:DTS2013013101431 modified by s00179437 , 2013-01-31*/
	//improve clk quality
	params->dsi.PLL_CLOCK = 500; //this value must be in MTK suggested table
	//params->dsi.pll_div1=0;		// div1=0,1,2,3;div1_real=1,2,4,4 ----0: 546Mbps  1:273Mbps
	//params->dsi.pll_div2=1;		// div2=0,1,2,3;div1_real=1,2,4,4	
	//params->dsi.fbk_div =21;    	// fref=26MHz, fvco=fref*(fbk_div)*2/(div1_real*div2_real)	
	/*END PN:DTS2013013101431 modified by s00179437 , 2013-01-31*/
	//end:haobing modified

	//lenovo-sw wangyq13 add for esd check start 20140606
	params->dsi.cont_clock = 0;
	params->dsi.clk_lp_per_line_enable = 1;
	params->dsi.esd_check_enable = 1;
	params->dsi.customization_esd_check_enable = 0;
	params->dsi.lcm_esd_check_table[0].cmd          = 0xAB; //0xAB
	params->dsi.lcm_esd_check_table[0].count        = 2;
	params->dsi.lcm_esd_check_table[0].para_list[0] = 0x00;
	params->dsi.lcm_esd_check_table[0].para_list[1] = 0x00;
	//lenovo-sw wangyq13 add for esd check end 20140606

}




static void lcm_init(void)
{
	unsigned char cmd = 0x0;
	unsigned char data = 0xFF;
	int ret=0;
	cmd=0x00;
	data=0x0a;
	mt_set_gpio_mode(GPIO_LCD_BIAS_ENP_PIN, GPIO_MODE_00);
    mt_set_gpio_dir(GPIO_LCD_BIAS_ENP_PIN, GPIO_DIR_OUT);
    mt_set_gpio_out(GPIO_LCD_BIAS_ENP_PIN, GPIO_OUT_ONE);



	SET_RESET_PIN(1);
    MDELAY(10);
    SET_RESET_PIN(0);
    MDELAY(10);
    SET_RESET_PIN(1);
    MDELAY(10);

	// when phone initial , config output high, enable backlight drv chip  
    push_table(lcm_initialization_setting, sizeof(lcm_initialization_setting) / sizeof(struct LCM_setting_table), 1);  



}


static void lcm_suspend(void)
{
 push_table(lcm_deep_sleep_mode_in_setting, sizeof(lcm_deep_sleep_mode_in_setting) / sizeof(struct LCM_setting_table), 1); 
 //mt_set_gpio_mode(GPIO_LCD_BIAS_ENP_PIN, GPIO_MODE_00);
 //mt_set_gpio_dir(GPIO_LCD_BIAS_ENP_PIN, GPIO_DIR_OUT);
 //mt_set_gpio_out(GPIO_LCD_BIAS_ENP_PIN, GPIO_OUT_ZERO);
}
static void lcm_resume(void)
{

	/*SET_RESET_PIN(1);
    SET_RESET_PIN(0);
    MDELAY(10);
    SET_RESET_PIN(1);
    MDELAY(10);*/
	//lcm_init(); 
    push_table(lcm_sleep_out_setting, sizeof(lcm_sleep_out_setting) / sizeof(struct LCM_setting_table), 1); 
}
static void lcm_update(unsigned int x, unsigned int y,
                       unsigned int width, unsigned int height)
{
	unsigned int x0 = x;
	unsigned int y0 = y;
	unsigned int x1 = x0 + width - 1;
	unsigned int y1 = y0 + height - 1;

	unsigned char x0_MSB = ((x0>>8)&0xFF);
	unsigned char x0_LSB = (x0&0xFF);
	unsigned char x1_MSB = ((x1>>8)&0xFF);
	unsigned char x1_LSB = (x1&0xFF);
	unsigned char y0_MSB = ((y0>>8)&0xFF);
	unsigned char y0_LSB = (y0&0xFF);
	unsigned char y1_MSB = ((y1>>8)&0xFF);
	unsigned char y1_LSB = (y1&0xFF);

	unsigned int data_array[16];

	data_array[0]= 0x00053902;
	data_array[1]= (x1_MSB<<24)|(x0_LSB<<16)|(x0_MSB<<8)|0x2a;
	data_array[2]= (x1_LSB);
	dsi_set_cmdq(data_array, 3, 1);
	
	data_array[0]= 0x00053902;
	data_array[1]= (y1_MSB<<24)|(y0_LSB<<16)|(y0_MSB<<8)|0x2b;
	data_array[2]= (y1_LSB);
	dsi_set_cmdq(data_array, 3, 1);
         /*BEGIN PN:DTS2013013101431 modified by s00179437 , 2013-01-31*/
         //delete high speed packet
	//data_array[0]=0x00290508;
	//dsi_set_cmdq(data_array, 1, 1);
         /*END PN:DTS2013013101431 modified by s00179437 , 2013-01-31*/
	
	data_array[0]= 0x002c3909;
	dsi_set_cmdq(data_array, 1, 0);	
}

/* Lenovo-sw yexm1 add 20140402 begin */
#ifdef LENOVO_LCD_BACKLIGHT_CONTROL_BY_LCM
static void lcm_setbacklight(unsigned int level)
{
	unsigned char data_array[16];

	if(level > 255) 
	level = 255;

	#ifndef BUILD_LK
	printk("[yexm1] %s level is %d \n",__func__,level);
	#endif
	data_array[0] = level;       
	dsi_set_cmdq_V2(0x51, 1, data_array, 1); 

}
#endif
/* Lenovo-sw yexm1 add 20140402 end */

/*lenovo-sw zhouyj5 add LCD automatic recognition mechanism. 20140521 start */
#define LENOVO_LCD_ID_PIN (GPIO171 | 0x80000000)
static unsigned int lcm_compare_id(void)
{
	unsigned  int ret = 0;
	ret = mt_get_gpio_in(LENOVO_LCD_ID_PIN);
#ifdef BUILD_LK
	if(1 == ret)
		dprintf(0, "[LK]lg_nt35595 found\n");
#else
	if(1 == ret)
		printk(0, "[KERNEL]lg_nt35595 found\n");
#endif
	return (1 == ret) ? 1: 0;
}
/*lenovo-sw zhouyj5 add LCD automatic recognition mechanism. 20140521 end */	

/* lenovo-sw yexm1 add lcd effect function 20140314 start */
#ifndef BUILD_LK
#ifdef LENOVO_LCM_EFFECT
static void lcm_setgamma_default(void)
{
push_table(lcm_gamma_default_setting, sizeof(lcm_gamma_default_setting) / sizeof(struct LCM_setting_table), 1); 
}

static void lcm_setgamma_cosy(void)
{
push_table(lcm_gamma_cosy_setting, sizeof(lcm_gamma_cosy_setting) / sizeof(struct LCM_setting_table), 1); 
}

static void lcm_setgamma_sunshine(void)
{
push_table(lcm_gamma_sunshine_setting, sizeof(lcm_gamma_sunshine_setting) / sizeof(struct LCM_setting_table), 1); 
}

static void lcm_setgamma_low_color(void)
{
push_table(lcm_gamma_low_color_setting, sizeof(lcm_gamma_low_color_setting) / sizeof(struct LCM_setting_table), 1); 
}

static void lcm_setgamma_high_color(void)
{
push_table(lcm_gamma_high_color_setting, sizeof(lcm_gamma_high_color_setting) / sizeof(struct LCM_setting_table), 1); 
}

static void lcm_setgammamode(unsigned int mode)
{

	unsigned int data_array[16];
	#if BUILD_LK
	printf("%s mode=%d\n",__func__,mode);
	#else
	printk("%s mode=%d\n",__func__,mode);
	#endif

	 if(lcm_gammamode_index == mode)
		return;
	lcm_gammamode_index = mode;

	switch(mode){
		case 0:
			lcm_setgamma_default();
			break;
		case 1:
			lcm_setgamma_cosy();
			break;
		case 2:
			lcm_setgamma_sunshine();
			break;
		case 3:
			lcm_setgamma_low_color();
			break;
		case 4:
			lcm_setgamma_high_color();
			break;
		default:
			break;
	}
//MDELAY(10);
}


static void lcm_setinversemode(unsigned int mode)
{
	unsigned int data_array[16];	

	#ifndef BUILD_LK
	printk("%s on=%d\n",__func__,mode);
	switch(mode){
		case 0:
			data_array[0]=0x00; 
			dsi_set_cmdq_V2(0x20, 1, data_array, 1); 
			//lcm_inversemode_index = 0;
			break;
		case 1:
			data_array[0]=0x00; 
			dsi_set_cmdq_V2(0x21, 1, data_array, 1); 
			//lcm_inversemode_index = 1;
			break;
		default:
			break;
		}

	 MDELAY(10);
	 #endif
}

static void lcm_setcabcmode(unsigned int mode)
{
#ifndef BUILD_LK
	unsigned char buffer[8] = {0x0};
       unsigned int arry[4] ;
       arry[0] =0x00043700;
	dsi_set_cmdq(arry, 1, 4);
	read_reg_v2(0x56, buffer,1);
	printk("setcabcmode begin = 0x%x,mode=%d\n",buffer[0],mode);
	switch(mode){
		case 0:
			buffer[1] =0x82;
			dsi_set_cmdq_V2(0x55,1,&buffer[1],1);
			break;
		case 1:
			buffer[1] = 0x81;
			dsi_set_cmdq_V2(0x55,1,&buffer[1],1);
			break;
		case 2:
			buffer[1] = 0x82;
			dsi_set_cmdq_V2(0x55,1,&buffer[1],1);
			break;
		case 3:
			buffer[1] = 0x83;
			dsi_set_cmdq_V2(0x55,1,&buffer[1],1);
			break;
		default:
			break;
	}
	printk("setcabcmode end = 0x%x\n",buffer[1]);
	MDELAY(10);
	arry[0] =0x00043700;
	dsi_set_cmdq(arry, 1, 4);
	read_reg_v2(0x56, buffer,1);
	printk("setcabcmode after = 0x%x\n",buffer[0]);
#endif
}

static void lcm_setiemode(unsigned int mode)
{
#ifndef BUILD_LK
	unsigned char buffer[8] = {0x0};
       unsigned int arry[4] ;
	arry[0] =0x00043700;
	dsi_set_cmdq(arry, 1, 4);
	read_reg_v2(0x56, buffer,1);
	printk("setiemode begin = 0x%x,mode = %d\n",buffer[0],mode);
	switch(mode){
		case 0:
			//buffer[1] = ((buffer[0]<<4)>>4)|0x80;
			buffer[1] = 0x83;
			dsi_set_cmdq_V2(0x55,1,&buffer[1],1);
			printk("setiemode 0mode = %d\n",mode);
			break;
		case 1:
			//buffer[1] = ((buffer[0]<<4)>>4)|0xB0;
			buffer[1] = 0x83;// 0xb3
			dsi_set_cmdq_V2(0x55,1,&buffer[1],1);
			printk("setiemode 1mode = %d\n",mode);
			break;
		case 2:
			buffer[1] = ((buffer[0]<<4)>>4)|0x90;
			dsi_set_cmdq_V2(0x55,1,&buffer[1],1);
			break;
		case 3:
			buffer[1] = ((buffer[0]<<4)>>4)|0xB0;
			dsi_set_cmdq_V2(0x55,1,&buffer[1],1);
			break;
		case 4:
			buffer[1] = ((buffer[0]<<4)>>4)|0x40;
			dsi_set_cmdq_V2(0x55,1,&buffer[1],1);
			break;
		case 5:
			buffer[1] = ((buffer[0]<<4)>>4)|0x50;
			dsi_set_cmdq_V2(0x55,1,&buffer[1],1);
			break;
		case 6:
			buffer[1] = ((buffer[0]<<4)>>4)|0x60;
			dsi_set_cmdq_V2(0x55,1,&buffer[1],1);
			break;
		default:
			break;
	}
	printk("setiemode end = 0x%x\n",buffer[1]);
	MDELAY(10);
	arry[0] =0x00043700;
	dsi_set_cmdq(arry, 1, 4);
	read_reg_v2(0x56, buffer,1);
	printk("setiemode after = 0x%x\n",buffer[0]);
#endif
}

#endif
#endif
/* lenovo-sw yexm1 add lcd effect function 20140314 end */

LCM_DRIVER nt35595_fhd_dsi_vdo_lg_lcm_drv=
{
    .name           = "nt35595_fhd_dsi_vdo_lg_lcm_drv",
    .set_util_funcs = lcm_set_util_funcs,
    .get_params     = lcm_get_params,
    .init           = lcm_init,/*tianma init fun.*/
    .suspend        = lcm_suspend,
    .resume         = lcm_resume,
     .compare_id     = lcm_compare_id,
#if (LCM_DSI_CMD_MODE)
    .update         = lcm_update,
#endif
#ifdef LENOVO_LCD_BACKLIGHT_CONTROL_BY_LCM
	.set_backlight		= lcm_setbacklight,	//Lenovo-sw yexm1 add 20140402
#endif
/* lenovo-sw yexm1 add lcd effect function 20140314 start */
#ifndef BUILD_LK
#ifdef LENOVO_LCM_EFFECT
	.set_gammamode = lcm_setgammamode,
	.set_inversemode = lcm_setinversemode,
	//.set_inversemode = lcm_setcabcmode,
	.set_cabcmode = lcm_setcabcmode,
	.set_iemode = lcm_setiemode,
#endif
#endif
/* lenovo-sw yexm1 add lcd effect function 20140314 end */
};
/* END PN:DTS2013053103858 , Added by d00238048, 2013.05.31*/
