/*
  File autogenerated by gengetopt version 2.22.5
  generated with the following command:
  /home/wim/bin/gengetopt -i src/cli/climax_cmdline.ggo --output-dir=src/cli 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#ifndef WIN32
#include <getopt.h>
#else
#include <cmdlineWin.h>
#endif

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: climax [OPTIONS]...";

const char *gengetopt_args_info_description = "climax, a Maximus/TFA98xx command line utility";

const char *gengetopt_args_info_full_help[] = {
  "  -h, --help                    Print help and exit",
  "      --full-help               Print help, including hidden options, and exit",
  "      --version                 Print version and exit",
  "\tThe following arguments are available:",
  "  -d, --device=/dev/i2c-x|/dev/ttyUSBx|host:port|dummy\n                                device name for the interface: i2c, serial, \n                                  socket, i2c dummy",
  "  -S, --speaker=L|R|B           speaker side select Left, Right or Both, \n                                  default is Left only",
  "  -c, --clock=state             clock enable=1/disable=0, default is enable",
  "      --clockStereo=state       clock enable=1/disable=0, default is enable",
  "  -a, --calibrate[=once|always] do calibration with loaded speaker file, \n                                  --output returns updated speaker file  \n                                  (default=`always')",
  "      --calibrateStereo[=once|always]\n                                do calibration with loaded speaker file, \n                                  --output returns updated speaker file for \n                                  stereo  (default=`always')",
  "      --resetMtpEx              reset MtpEx register to do re-calibration",
  "  -A, --calshow                 show calibration impedance value",
  "  -i, --init                    force poweron init",
  "  -R, --reset                   initialize registers and coldboot dsp",
  "  -p, --params=parameter file   store input params file depending on type: \n                                  patch, speaker, preset, config, eq ",
  "  -P, --profile=profilenr       set the profile for current operation",
  "      --currentprof=profilenr   set the profile from previous operation",
  "  -v, --volume=step             set volume step",
  "\ndiagnostics and test options:",
  "  -V, --versions                print versions and chip rev",
  "  -r, --register=hex            read tfa register, write if extra arg given",
  "  -w, --regwrite=hex            write value for register",
  "      --dump                    dump all defined registers",
  "      --dumpStereo              dump all defined registers of stereo",
  "      --pin=pin                 control pin",
  "      --diag[=testnr]           run all diagnostic tests, or single if \n                                  specified  (default=`0')",
  "      --dumpmodel[=x|z]         dump current speakermodel impedance=z or \n                                  excursion=x  (default=`z')",
  "  -D, --dsp[=hex]               DSP get speakerboost params, use --count to set \n                                  bytecount  (default=`0x80')",
  "      --tcoef[=tCoef]           show tCoef of loaded speaker, save to --output \n                                  if new value given  (default=`0')",
  "  -x, --xmem=hex                read tfa xmem",
  "live data options:",
  "      --record[=msInterval]     record speaker state info via I2C and display  \n                                  (default=`55')",
  "      --recordStereo[=msInterval]\n                                record speaker state info via I2C and display \n                                  for stereo  (default=`55')",
  "      --count=cycles            number of read cycles to execute, 0 means \n                                  forever",
  "      --output=filename         the output file for binary speaker state info \n                                  records, default=stdout",
  "      --logger[=sInterval]      start datalogger, recording <count> state info \n                                  lines and binary Z/Xmodels  (default=`2')",
  "generic options:",
  "  -l, --load=filename           read parameter settings from saved file",
  "      --splitparms              save parameters of the loaded parms file to \n                                  seperate files",
  "      --loadPreset=filename     read preset settings from saved file",
  "      --loadSpeaker=filename    read speaker settings from saved file",
  "      --loadConfig=filename     read config settings from saved file",
  "  -s, --save=filename           write parameter settings to file",
  "      --savePreset=filename     write preset settings to file",
  "      --saveSpeaker=filename    write speaker settings to file",
  "      --saveConfig=filename     write config settings to file",
  "      --server[=port]           run as server  (default=`9887')",
  "      --client[=port]           run as client  (default=`9887')",
  "      --slave=i2c address       override hardcoded I2C slave address",
  "  -L, --loop=count              loop the operation [0=forever]",
  "  -b, --verbose[=mask]          Enable verbose (mask=i2cserver|socket|scribo)",
  "  -t, --trace                   Enable message tracing",
  "  -q, --quiet                   Suppress printing to stdout",
    0
};

static void
init_help_array(void)
{
  gengetopt_args_info_help[0] = gengetopt_args_info_full_help[0];
  gengetopt_args_info_help[1] = gengetopt_args_info_full_help[1];
  gengetopt_args_info_help[2] = gengetopt_args_info_full_help[2];
  gengetopt_args_info_help[3] = gengetopt_args_info_full_help[3];
  gengetopt_args_info_help[4] = gengetopt_args_info_full_help[4];
  gengetopt_args_info_help[5] = gengetopt_args_info_full_help[6];
  gengetopt_args_info_help[6] = gengetopt_args_info_full_help[7];
  gengetopt_args_info_help[7] = gengetopt_args_info_full_help[8];
  gengetopt_args_info_help[8] = gengetopt_args_info_full_help[9];
  gengetopt_args_info_help[9] = gengetopt_args_info_full_help[10];
  gengetopt_args_info_help[10] = gengetopt_args_info_full_help[11];
  gengetopt_args_info_help[11] = gengetopt_args_info_full_help[12];
  gengetopt_args_info_help[12] = gengetopt_args_info_full_help[13];
  gengetopt_args_info_help[13] = gengetopt_args_info_full_help[14];
  gengetopt_args_info_help[14] = gengetopt_args_info_full_help[15];
  gengetopt_args_info_help[15] = gengetopt_args_info_full_help[16];
  gengetopt_args_info_help[16] = gengetopt_args_info_full_help[17];
  gengetopt_args_info_help[17] = gengetopt_args_info_full_help[18];
  gengetopt_args_info_help[18] = gengetopt_args_info_full_help[19];
  gengetopt_args_info_help[19] = gengetopt_args_info_full_help[20];
  gengetopt_args_info_help[20] = gengetopt_args_info_full_help[21];
  gengetopt_args_info_help[21] = gengetopt_args_info_full_help[22];
  gengetopt_args_info_help[22] = gengetopt_args_info_full_help[23];
  gengetopt_args_info_help[23] = gengetopt_args_info_full_help[25];
  gengetopt_args_info_help[24] = gengetopt_args_info_full_help[26];
  gengetopt_args_info_help[25] = gengetopt_args_info_full_help[27];
  gengetopt_args_info_help[26] = gengetopt_args_info_full_help[28];
  gengetopt_args_info_help[27] = gengetopt_args_info_full_help[29];
  gengetopt_args_info_help[28] = gengetopt_args_info_full_help[30];
  gengetopt_args_info_help[29] = gengetopt_args_info_full_help[31];
  gengetopt_args_info_help[30] = gengetopt_args_info_full_help[32];
  gengetopt_args_info_help[31] = gengetopt_args_info_full_help[33];
  gengetopt_args_info_help[32] = gengetopt_args_info_full_help[34];
  gengetopt_args_info_help[33] = gengetopt_args_info_full_help[35];
  gengetopt_args_info_help[34] = gengetopt_args_info_full_help[36];
  gengetopt_args_info_help[35] = gengetopt_args_info_full_help[37];
  gengetopt_args_info_help[36] = gengetopt_args_info_full_help[38];
  gengetopt_args_info_help[37] = gengetopt_args_info_full_help[39];
  gengetopt_args_info_help[38] = gengetopt_args_info_full_help[40];
  gengetopt_args_info_help[39] = gengetopt_args_info_full_help[41];
  gengetopt_args_info_help[40] = gengetopt_args_info_full_help[42];
  gengetopt_args_info_help[41] = gengetopt_args_info_full_help[43];
  gengetopt_args_info_help[42] = gengetopt_args_info_full_help[44];
  gengetopt_args_info_help[43] = gengetopt_args_info_full_help[45];
  gengetopt_args_info_help[44] = gengetopt_args_info_full_help[46];
  gengetopt_args_info_help[45] = gengetopt_args_info_full_help[47];
  gengetopt_args_info_help[46] = gengetopt_args_info_full_help[48];
  gengetopt_args_info_help[47] = gengetopt_args_info_full_help[49];
  gengetopt_args_info_help[48] = gengetopt_args_info_full_help[50];
  gengetopt_args_info_help[49] = gengetopt_args_info_full_help[51];
  gengetopt_args_info_help[50] = gengetopt_args_info_full_help[52];
  gengetopt_args_info_help[51] = 0; 
  
}

const char *gengetopt_args_info_help[52];

typedef enum {ARG_NO
  , ARG_STRING
  , ARG_INT
  , ARG_FLOAT
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->device_given = 0 ;
  args_info->speaker_given = 0 ;
  args_info->clock_given = 0 ;
  args_info->clockStereo_given = 0 ;
  args_info->calibrate_given = 0 ;
  args_info->calibrateStereo_given = 0 ;
  args_info->resetMtpEx_given = 0 ;
  args_info->calshow_given = 0 ;
  args_info->init_given = 0 ;
  args_info->reset_given = 0 ;
  args_info->params_given = 0 ;
  args_info->profile_given = 0 ;
  args_info->currentprof_given = 0 ;
  args_info->volume_given = 0 ;
  args_info->versions_given = 0 ;
  args_info->register_given = 0 ;
  args_info->regwrite_given = 0 ;
  args_info->dump_given = 0 ;
  args_info->dumpStereo_given = 0 ;
  args_info->pin_given = 0 ;
  args_info->diag_given = 0 ;
  args_info->dumpmodel_given = 0 ;
  args_info->dsp_given = 0 ;
  args_info->tcoef_given = 0 ;
  args_info->xmem_given = 0 ;
  args_info->record_given = 0 ;
  args_info->recordStereo_given = 0 ;
  args_info->count_given = 0 ;
  args_info->output_given = 0 ;
  args_info->logger_given = 0 ;
  args_info->load_given = 0 ;
  args_info->splitparms_given = 0 ;
  args_info->loadPreset_given = 0 ;
  args_info->loadSpeaker_given = 0 ;
  args_info->loadConfig_given = 0 ;
  args_info->save_given = 0 ;
  args_info->savePreset_given = 0 ;
  args_info->saveSpeaker_given = 0 ;
  args_info->saveConfig_given = 0 ;
  args_info->server_given = 0 ;
  args_info->client_given = 0 ;
  args_info->slave_given = 0 ;
  args_info->loop_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->trace_given = 0 ;
  args_info->quiet_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->device_arg = NULL;
  args_info->device_orig = NULL;
  args_info->speaker_arg = NULL;
  args_info->speaker_orig = NULL;
  args_info->clock_orig = NULL;
  args_info->clockStereo_orig = NULL;
  args_info->calibrate_arg = gengetopt_strdup ("always");
  args_info->calibrate_orig = NULL;
  args_info->calibrateStereo_arg = gengetopt_strdup ("always");
  args_info->calibrateStereo_orig = NULL;
  args_info->params_arg = NULL;
  args_info->params_orig = NULL;
  args_info->profile_orig = NULL;
  args_info->currentprof_orig = NULL;
  args_info->volume_orig = NULL;
  args_info->register_arg = NULL;
  args_info->register_orig = NULL;
  args_info->regwrite_arg = NULL;
  args_info->regwrite_orig = NULL;
  args_info->pin_orig = NULL;
  args_info->diag_arg = 0;
  args_info->diag_orig = NULL;
  args_info->dumpmodel_arg = gengetopt_strdup ("z");
  args_info->dumpmodel_orig = NULL;
  args_info->dsp_arg = 0x80;
  args_info->dsp_orig = NULL;
  args_info->tcoef_arg = 0;
  args_info->tcoef_orig = NULL;
  args_info->xmem_arg = NULL;
  args_info->xmem_orig = NULL;
  args_info->record_arg = 55;
  args_info->record_orig = NULL;
  args_info->recordStereo_arg = 55;
  args_info->recordStereo_orig = NULL;
  args_info->count_orig = NULL;
  args_info->output_arg = NULL;
  args_info->output_orig = NULL;
  args_info->logger_arg = 2;
  args_info->logger_orig = NULL;
  args_info->load_arg = NULL;
  args_info->load_orig = NULL;
  args_info->loadPreset_arg = NULL;
  args_info->loadPreset_orig = NULL;
  args_info->loadSpeaker_arg = NULL;
  args_info->loadSpeaker_orig = NULL;
  args_info->loadConfig_arg = NULL;
  args_info->loadConfig_orig = NULL;
  args_info->save_arg = NULL;
  args_info->save_orig = NULL;
  args_info->savePreset_arg = NULL;
  args_info->savePreset_orig = NULL;
  args_info->saveSpeaker_arg = NULL;
  args_info->saveSpeaker_orig = NULL;
  args_info->saveConfig_arg = NULL;
  args_info->saveConfig_orig = NULL;
  args_info->server_arg = gengetopt_strdup ("9887");
  args_info->server_orig = NULL;
  args_info->client_arg = gengetopt_strdup ("9887");
  args_info->client_orig = NULL;
  args_info->slave_orig = NULL;
  args_info->loop_orig = NULL;
  args_info->verbose_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{

  init_help_array(); 
  args_info->help_help = gengetopt_args_info_full_help[0] ;
  args_info->full_help_help = gengetopt_args_info_full_help[1] ;
  args_info->version_help = gengetopt_args_info_full_help[2] ;
  args_info->device_help = gengetopt_args_info_full_help[4] ;
  args_info->speaker_help = gengetopt_args_info_full_help[5] ;
  args_info->clock_help = gengetopt_args_info_full_help[6] ;
  args_info->clockStereo_help = gengetopt_args_info_full_help[7] ;
  args_info->calibrate_help = gengetopt_args_info_full_help[8] ;
  args_info->calibrateStereo_help = gengetopt_args_info_full_help[9] ;
  args_info->resetMtpEx_help = gengetopt_args_info_full_help[10] ;
  args_info->calshow_help = gengetopt_args_info_full_help[11] ;
  args_info->init_help = gengetopt_args_info_full_help[12] ;
  args_info->reset_help = gengetopt_args_info_full_help[13] ;
  args_info->params_help = gengetopt_args_info_full_help[14] ;
  args_info->params_min = 0;
  args_info->params_max = 0;
  args_info->profile_help = gengetopt_args_info_full_help[15] ;
  args_info->currentprof_help = gengetopt_args_info_full_help[16] ;
  args_info->volume_help = gengetopt_args_info_full_help[17] ;
  args_info->versions_help = gengetopt_args_info_full_help[19] ;
  args_info->register_help = gengetopt_args_info_full_help[20] ;
  args_info->register_min = 0;
  args_info->register_max = 0;
  args_info->regwrite_help = gengetopt_args_info_full_help[21] ;
  args_info->regwrite_min = 0;
  args_info->regwrite_max = 0;
  args_info->dump_help = gengetopt_args_info_full_help[22] ;
  args_info->dumpStereo_help = gengetopt_args_info_full_help[23] ;
  args_info->pin_help = gengetopt_args_info_full_help[24] ;
  args_info->diag_help = gengetopt_args_info_full_help[25] ;
  args_info->dumpmodel_help = gengetopt_args_info_full_help[26] ;
  args_info->dsp_help = gengetopt_args_info_full_help[27] ;
  args_info->tcoef_help = gengetopt_args_info_full_help[28] ;
  args_info->xmem_help = gengetopt_args_info_full_help[29] ;
  args_info->xmem_min = 0;
  args_info->xmem_max = 0;
  args_info->record_help = gengetopt_args_info_full_help[31] ;
  args_info->recordStereo_help = gengetopt_args_info_full_help[32] ;
  args_info->count_help = gengetopt_args_info_full_help[33] ;
  args_info->output_help = gengetopt_args_info_full_help[34] ;
  args_info->logger_help = gengetopt_args_info_full_help[35] ;
  args_info->load_help = gengetopt_args_info_full_help[37] ;
  args_info->splitparms_help = gengetopt_args_info_full_help[38] ;
  args_info->loadPreset_help = gengetopt_args_info_full_help[39] ;
  args_info->loadSpeaker_help = gengetopt_args_info_full_help[40] ;
  args_info->loadConfig_help = gengetopt_args_info_full_help[41] ;
  args_info->save_help = gengetopt_args_info_full_help[42] ;
  args_info->savePreset_help = gengetopt_args_info_full_help[43] ;
  args_info->saveSpeaker_help = gengetopt_args_info_full_help[44] ;
  args_info->saveConfig_help = gengetopt_args_info_full_help[45] ;
  args_info->server_help = gengetopt_args_info_full_help[46] ;
  args_info->client_help = gengetopt_args_info_full_help[47] ;
  args_info->slave_help = gengetopt_args_info_full_help[48] ;
  args_info->loop_help = gengetopt_args_info_full_help[49] ;
  args_info->verbose_help = gengetopt_args_info_full_help[50] ;
  args_info->trace_help = gengetopt_args_info_full_help[51] ;
  args_info->quiet_help = gengetopt_args_info_full_help[52] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_full_help[i])
    printf("%s\n", gengetopt_args_info_full_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    float float_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}

/**
 * The passed arg parameter is NOT set to 0 from this function
 */
static void
free_multiple_field(unsigned int len, void *arg, char ***orig)
{
  unsigned int i;
  if (arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*orig)[i]));
      }

    free (arg);
    free (*orig);
    *orig = 0;
  }
}

static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->device_arg));
  free_string_field (&(args_info->device_orig));
  free_string_field (&(args_info->speaker_arg));
  free_string_field (&(args_info->speaker_orig));
  free_string_field (&(args_info->clock_orig));
  free_string_field (&(args_info->clockStereo_orig));
  free_string_field (&(args_info->calibrate_arg));
  free_string_field (&(args_info->calibrate_orig));
  free_string_field (&(args_info->calibrateStereo_arg));
  free_string_field (&(args_info->calibrateStereo_orig));
  free_multiple_string_field (args_info->params_given, &(args_info->params_arg), &(args_info->params_orig));
  free_string_field (&(args_info->profile_orig));
  free_string_field (&(args_info->currentprof_orig));
  free_string_field (&(args_info->volume_orig));
  free_multiple_field (args_info->register_given, (void *)(args_info->register_arg), &(args_info->register_orig));
  args_info->register_arg = 0;
  free_multiple_field (args_info->regwrite_given, (void *)(args_info->regwrite_arg), &(args_info->regwrite_orig));
  args_info->regwrite_arg = 0;
  free_string_field (&(args_info->pin_orig));
  free_string_field (&(args_info->diag_orig));
  free_string_field (&(args_info->dumpmodel_arg));
  free_string_field (&(args_info->dumpmodel_orig));
  free_string_field (&(args_info->dsp_orig));
  free_string_field (&(args_info->tcoef_orig));
  free_multiple_field (args_info->xmem_given, (void *)(args_info->xmem_arg), &(args_info->xmem_orig));
  args_info->xmem_arg = 0;
  free_string_field (&(args_info->record_orig));
  free_string_field (&(args_info->recordStereo_orig));
  free_string_field (&(args_info->count_orig));
  free_string_field (&(args_info->output_arg));
  free_string_field (&(args_info->output_orig));
  free_string_field (&(args_info->logger_orig));
  free_string_field (&(args_info->load_arg));
  free_string_field (&(args_info->load_orig));
  free_string_field (&(args_info->loadPreset_arg));
  free_string_field (&(args_info->loadPreset_orig));
  free_string_field (&(args_info->loadSpeaker_arg));
  free_string_field (&(args_info->loadSpeaker_orig));
  free_string_field (&(args_info->loadConfig_arg));
  free_string_field (&(args_info->loadConfig_orig));
  free_string_field (&(args_info->save_arg));
  free_string_field (&(args_info->save_orig));
  free_string_field (&(args_info->savePreset_arg));
  free_string_field (&(args_info->savePreset_orig));
  free_string_field (&(args_info->saveSpeaker_arg));
  free_string_field (&(args_info->saveSpeaker_orig));
  free_string_field (&(args_info->saveConfig_arg));
  free_string_field (&(args_info->saveConfig_orig));
  free_string_field (&(args_info->server_arg));
  free_string_field (&(args_info->server_orig));
  free_string_field (&(args_info->client_arg));
  free_string_field (&(args_info->client_orig));
  free_string_field (&(args_info->slave_orig));
  free_string_field (&(args_info->loop_orig));
  free_string_field (&(args_info->verbose_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->device_given)
    write_into_file(outfile, "device", args_info->device_orig, 0);
  if (args_info->speaker_given)
    write_into_file(outfile, "speaker", args_info->speaker_orig, 0);
  if (args_info->clock_given)
    write_into_file(outfile, "clock", args_info->clock_orig, 0);
  if (args_info->clockStereo_given)
    write_into_file(outfile, "clockStereo", args_info->clockStereo_orig, 0);
  if (args_info->calibrate_given)
    write_into_file(outfile, "calibrate", args_info->calibrate_orig, 0);
  if (args_info->calibrateStereo_given)
    write_into_file(outfile, "calibrateStereo", args_info->calibrateStereo_orig, 0);
  if (args_info->resetMtpEx_given)
    write_into_file(outfile, "resetMtpEx", 0, 0 );
  if (args_info->calshow_given)
    write_into_file(outfile, "calshow", 0, 0 );
  if (args_info->init_given)
    write_into_file(outfile, "init", 0, 0 );
  if (args_info->reset_given)
    write_into_file(outfile, "reset", 0, 0 );
  write_multiple_into_file(outfile, args_info->params_given, "params", args_info->params_orig, 0);
  if (args_info->profile_given)
    write_into_file(outfile, "profile", args_info->profile_orig, 0);
  if (args_info->currentprof_given)
    write_into_file(outfile, "currentprof", args_info->currentprof_orig, 0);
  if (args_info->volume_given)
    write_into_file(outfile, "volume", args_info->volume_orig, 0);
  if (args_info->versions_given)
    write_into_file(outfile, "versions", 0, 0 );
  write_multiple_into_file(outfile, args_info->register_given, "register", args_info->register_orig, 0);
  write_multiple_into_file(outfile, args_info->regwrite_given, "regwrite", args_info->regwrite_orig, 0);
  if (args_info->dump_given)
    write_into_file(outfile, "dump", 0, 0 );
  if (args_info->dumpStereo_given)
    write_into_file(outfile, "dumpStereo", 0, 0 );
  if (args_info->pin_given)
    write_into_file(outfile, "pin", args_info->pin_orig, 0);
  if (args_info->diag_given)
    write_into_file(outfile, "diag", args_info->diag_orig, 0);
  if (args_info->dumpmodel_given)
    write_into_file(outfile, "dumpmodel", args_info->dumpmodel_orig, 0);
  if (args_info->dsp_given)
    write_into_file(outfile, "dsp", args_info->dsp_orig, 0);
  if (args_info->tcoef_given)
    write_into_file(outfile, "tcoef", args_info->tcoef_orig, 0);
  write_multiple_into_file(outfile, args_info->xmem_given, "xmem", args_info->xmem_orig, 0);
  if (args_info->record_given)
    write_into_file(outfile, "record", args_info->record_orig, 0);
  if (args_info->recordStereo_given)
    write_into_file(outfile, "recordStereo", args_info->recordStereo_orig, 0);
  if (args_info->count_given)
    write_into_file(outfile, "count", args_info->count_orig, 0);
  if (args_info->output_given)
    write_into_file(outfile, "output", args_info->output_orig, 0);
  if (args_info->logger_given)
    write_into_file(outfile, "logger", args_info->logger_orig, 0);
  if (args_info->load_given)
    write_into_file(outfile, "load", args_info->load_orig, 0);
  if (args_info->splitparms_given)
    write_into_file(outfile, "splitparms", 0, 0 );
  if (args_info->loadPreset_given)
    write_into_file(outfile, "loadPreset", args_info->loadPreset_orig, 0);
  if (args_info->loadSpeaker_given)
    write_into_file(outfile, "loadSpeaker", args_info->loadSpeaker_orig, 0);
  if (args_info->loadConfig_given)
    write_into_file(outfile, "loadConfig", args_info->loadConfig_orig, 0);
  if (args_info->save_given)
    write_into_file(outfile, "save", args_info->save_orig, 0);
  if (args_info->savePreset_given)
    write_into_file(outfile, "savePreset", args_info->savePreset_orig, 0);
  if (args_info->saveSpeaker_given)
    write_into_file(outfile, "saveSpeaker", args_info->saveSpeaker_orig, 0);
  if (args_info->saveConfig_given)
    write_into_file(outfile, "saveConfig", args_info->saveConfig_orig, 0);
  if (args_info->server_given)
    write_into_file(outfile, "server", args_info->server_orig, 0);
  if (args_info->client_given)
    write_into_file(outfile, "client", args_info->client_orig, 0);
  if (args_info->slave_given)
    write_into_file(outfile, "slave", args_info->slave_orig, 0);
  if (args_info->loop_given)
    write_into_file(outfile, "loop", args_info->loop_orig, 0);
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", args_info->verbose_orig, 0);
  if (args_info->trace_given)
    write_into_file(outfile, "trace", 0, 0 );
  if (args_info->quiet_given)
    write_into_file(outfile, "quiet", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error = 1;
            }
        }
    }
    
  return error;
}
int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->params_given, args_info->params_min, args_info->params_max, "'--params' ('-p')"))
     error = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->register_given, args_info->register_min, args_info->register_max, "'--register' ('-r')"))
     error = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->regwrite_given, args_info->regwrite_min, args_info->regwrite_max, "'--regwrite' ('-w')"))
     error = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->xmem_given, args_info->xmem_min, args_info->xmem_max, "'--xmem' ('-x')"))
     error = 1;
  
  
  /* checks for dependences among options */

  return error;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_FLOAT:
    if (val) *((float *)field) = (float)strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_FLOAT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_FLOAT:
      *((float **)field) = (float *)realloc (*((float **)field), (field_given + prev_given) * sizeof (float)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_FLOAT:
          (*((float **)field))[i + field_given] = tmp->arg.float_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_FLOAT:
        if (! *((float **)field)) {
          *((float **)field) = (float *)malloc (sizeof (float));
          (*((float **)field))[0] = default_value->float_arg;
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  struct generic_list * params_list = NULL;
  struct generic_list * register_list = NULL;
  struct generic_list * regwrite_list = NULL;
  struct generic_list * xmem_list = NULL;
  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
#ifdef WIN32  
  char *optarg;
  int optind;
  int opterr;
  int optopt;
#endif  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 0 },
        { "device",	1, NULL, 'd' },
        { "speaker",	1, NULL, 'S' },
        { "clock",	1, NULL, 'c' },
        { "clockStereo",	1, NULL, 0 },
        { "calibrate",	2, NULL, 'a' },
        { "calibrateStereo",	2, NULL, 0 },
        { "resetMtpEx",	0, NULL, 0 },
        { "calshow",	0, NULL, 'A' },
        { "init",	0, NULL, 'i' },
        { "reset",	0, NULL, 'R' },
        { "params",	1, NULL, 'p' },
        { "profile",	1, NULL, 'P' },
        { "currentprof",	1, NULL, 0 },
        { "volume",	1, NULL, 'v' },
        { "versions",	0, NULL, 'V' },
        { "register",	1, NULL, 'r' },
        { "regwrite",	1, NULL, 'w' },
        { "dump",	0, NULL, 0 },
        { "dumpStereo",	0, NULL, 0 },
        { "pin",	1, NULL, 0 },
        { "diag",	2, NULL, 0 },
        { "dumpmodel",	2, NULL, 0 },
        { "dsp",	2, NULL, 'D' },
        { "tcoef",	2, NULL, 0 },
        { "xmem",	1, NULL, 'x' },
        { "record",	2, NULL, 0 },
        { "recordStereo",	2, NULL, 0 },
        { "count",	1, NULL, 0 },
        { "output",	1, NULL, 0 },
        { "logger",	2, NULL, 0 },
        { "load",	1, NULL, 'l' },
        { "splitparms",	0, NULL, 0 },
        { "loadPreset",	1, NULL, 0 },
        { "loadSpeaker",	1, NULL, 0 },
        { "loadConfig",	1, NULL, 0 },
        { "save",	1, NULL, 's' },
        { "savePreset",	1, NULL, 0 },
        { "saveSpeaker",	1, NULL, 0 },
        { "saveConfig",	1, NULL, 0 },
        { "server",	2, NULL, 0 },
        { "client",	2, NULL, 0 },
        { "slave",	1, NULL, 0 },
        { "loop",	1, NULL, 'L' },
        { "verbose",	2, NULL, 'b' },
        { "trace",	0, NULL, 't' },
        { "quiet",	0, NULL, 'q' },
        { 0,  0, 0, 0 }
      };
#ifdef WIN32
      custom_optarg = optarg;
      custom_optind = optind;
      custom_opterr = opterr;
      custom_optopt = optopt;

      c = custom_getopt_long (argc, argv, "hd:S:c:a::AiRp:P:v:Vr:w:D::l:s:L:btq", long_options, &option_index);
     
      optarg = custom_optarg;
      optind = custom_optind;
      opterr = custom_opterr;
      optopt = custom_optopt;
#else
      c = getopt_long (argc, argv, "hd:S:c:a::AiRp:P:v:Vr:w:D::x:l:s:L:b::tq", long_options, &option_index);
#endif
      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'd':	/* device name for the interface: i2c, serial, socket, i2c dummy.  */
        
        
          if (update_arg( (void *)&(args_info->device_arg), 
               &(args_info->device_orig), &(args_info->device_given),
              &(local_args_info.device_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "device", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* speaker side select Left, Right or Both, default is Left only.  */
        
        
          if (update_arg( (void *)&(args_info->speaker_arg), 
               &(args_info->speaker_orig), &(args_info->speaker_given),
              &(local_args_info.speaker_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "speaker", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* clock enable=1/disable=0, default is enable.  */
        
        
          if (update_arg( (void *)&(args_info->clock_arg), 
               &(args_info->clock_orig), &(args_info->clock_given),
              &(local_args_info.clock_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "clock", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'a':	/* do calibration with loaded speaker file, --output returns updated speaker file.  */
        
        
          if (update_arg( (void *)&(args_info->calibrate_arg), 
               &(args_info->calibrate_orig), &(args_info->calibrate_given),
              &(local_args_info.calibrate_given), optarg, 0, "always", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "calibrate", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'A':	/* show calibration impedance value.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->calshow_given),
              &(local_args_info.calshow_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "calshow", 'A',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* force poweron init.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->init_given),
              &(local_args_info.init_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "init", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'R':	/* initialize registers and coldboot dsp.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->reset_given),
              &(local_args_info.reset_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "reset", 'R',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* store input params file depending on type: patch, speaker, preset, config, eq .  */
        
          if (update_multiple_arg_temp(&params_list, 
              &(local_args_info.params_given), optarg, 0, 0, ARG_STRING,
              "params", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* set the profile for current operation.  */
        
        
          if (update_arg( (void *)&(args_info->profile_arg), 
               &(args_info->profile_orig), &(args_info->profile_given),
              &(local_args_info.profile_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "profile", 'P',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* set volume step.  */
        
        
          if (update_arg( (void *)&(args_info->volume_arg), 
               &(args_info->volume_orig), &(args_info->volume_given),
              &(local_args_info.volume_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "volume", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'V':	/* print versions and chip rev.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->versions_given),
              &(local_args_info.versions_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "versions", 'V',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* read tfa register, write if extra arg given.  */
        
          if (update_multiple_arg_temp(&register_list, 
              &(local_args_info.register_given), optarg, 0, 0, ARG_INT,
              "register", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'w':	/* write value for register.  */
        
          if (update_multiple_arg_temp(&regwrite_list, 
              &(local_args_info.regwrite_given), optarg, 0, 0, ARG_INT,
              "regwrite", 'w',
              additional_error))
            goto failure;
        
          break;
        case 'D':	/* DSP get speakerboost params, use --count to set bytecount.  */
        
        
          if (update_arg( (void *)&(args_info->dsp_arg), 
               &(args_info->dsp_orig), &(args_info->dsp_given),
              &(local_args_info.dsp_given), optarg, 0, "0x80", ARG_INT,
              check_ambiguity, override, 0, 0,
              "dsp", 'D',
              additional_error))
            goto failure;
        
          break;
        case 'x':	/* read tfa xmem.  */
        
          if (update_multiple_arg_temp(&xmem_list, 
              &(local_args_info.xmem_given), optarg, 0, 0, ARG_INT,
              "xmem", 'x',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* read parameter settings from saved file.  */
        
        
          if (update_arg( (void *)&(args_info->load_arg), 
               &(args_info->load_orig), &(args_info->load_given),
              &(local_args_info.load_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "load", 'l',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* write parameter settings to file.  */
        
        
          if (update_arg( (void *)&(args_info->save_arg), 
               &(args_info->save_orig), &(args_info->save_given),
              &(local_args_info.save_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "save", 's',
              additional_error))
            goto failure;
        
          break;
        case 'L':	/* loop the operation [0=forever].  */
        
        
          if (update_arg( (void *)&(args_info->loop_arg), 
               &(args_info->loop_orig), &(args_info->loop_given),
              &(local_args_info.loop_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "loop", 'L',
              additional_error))
            goto failure;
        
          break;
        case 'b':	/* Enable verbose (mask=i2cserver|socket|scribo).  */
        
        
          if (update_arg( (void *)&(args_info->verbose_arg), 
               &(args_info->verbose_orig), &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "verbose", 'b',
              additional_error))
            goto failure;
        
          break;
        case 't':	/* Enable message tracing.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->trace_given),
              &(local_args_info.trace_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "trace", 't',
              additional_error))
            goto failure;
        
          break;
        case 'q':	/* Suppress printing to stdout.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->quiet_given),
              &(local_args_info.quiet_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "quiet", 'q',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            cmdline_parser_print_full_help ();
            cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          if (strcmp (long_options[option_index].name, "version") == 0) {
            cmdline_parser_print_version ();
            cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* clock enable=1/disable=0, default is enable.  */
          if (strcmp (long_options[option_index].name, "clockStereo") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->clockStereo_arg), 
                 &(args_info->clockStereo_orig), &(args_info->clockStereo_given),
                &(local_args_info.clockStereo_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "clockStereo", '-',
                additional_error))
              goto failure;
          
          }
          /* do calibration with loaded speaker file, --output returns updated speaker file for stereo.  */
          else if (strcmp (long_options[option_index].name, "calibrateStereo") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->calibrateStereo_arg), 
                 &(args_info->calibrateStereo_orig), &(args_info->calibrateStereo_given),
                &(local_args_info.calibrateStereo_given), optarg, 0, "always", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "calibrateStereo", '-',
                additional_error))
              goto failure;
          
          }
          /* reset MtpEx register to do re-calibration.  */
          else if (strcmp (long_options[option_index].name, "resetMtpEx") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->resetMtpEx_given),
                &(local_args_info.resetMtpEx_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "resetMtpEx", '-',
                additional_error))
              goto failure;
          
          }
          /* set the profile from previous operation.  */
          else if (strcmp (long_options[option_index].name, "currentprof") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->currentprof_arg), 
                 &(args_info->currentprof_orig), &(args_info->currentprof_given),
                &(local_args_info.currentprof_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "currentprof", '-',
                additional_error))
              goto failure;
          
          }
          /* dump all defined registers.  */
          else if (strcmp (long_options[option_index].name, "dump") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->dump_given),
                &(local_args_info.dump_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "dump", '-',
                additional_error))
              goto failure;
          
          }
          /* dump all defined registers of stereo.  */
          else if (strcmp (long_options[option_index].name, "dumpStereo") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->dumpStereo_given),
                &(local_args_info.dumpStereo_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "dumpStereo", '-',
                additional_error))
              goto failure;
          
          }
          /* control pin.  */
          else if (strcmp (long_options[option_index].name, "pin") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->pin_arg), 
                 &(args_info->pin_orig), &(args_info->pin_given),
                &(local_args_info.pin_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "pin", '-',
                additional_error))
              goto failure;
          
          }
          /* run all diagnostic tests, or single if specified.  */
          else if (strcmp (long_options[option_index].name, "diag") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->diag_arg), 
                 &(args_info->diag_orig), &(args_info->diag_given),
                &(local_args_info.diag_given), optarg, 0, "0", ARG_INT,
                check_ambiguity, override, 0, 0,
                "diag", '-',
                additional_error))
              goto failure;
          
          }
          /* dump current speakermodel impedance=z or excursion=x.  */
          else if (strcmp (long_options[option_index].name, "dumpmodel") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->dumpmodel_arg), 
                 &(args_info->dumpmodel_orig), &(args_info->dumpmodel_given),
                &(local_args_info.dumpmodel_given), optarg, 0, "z", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "dumpmodel", '-',
                additional_error))
              goto failure;
          
          }
          /* show tCoef of loaded speaker, save to --output if new value given.  */
          else if (strcmp (long_options[option_index].name, "tcoef") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->tcoef_arg), 
                 &(args_info->tcoef_orig), &(args_info->tcoef_given),
                &(local_args_info.tcoef_given), optarg, 0, "0", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "tcoef", '-',
                additional_error))
              goto failure;
          
          }
          /* record speaker state info via I2C and display.  */
          else if (strcmp (long_options[option_index].name, "record") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->record_arg), 
                 &(args_info->record_orig), &(args_info->record_given),
                &(local_args_info.record_given), optarg, 0, "55", ARG_INT,
                check_ambiguity, override, 0, 0,
                "record", '-',
                additional_error))
              goto failure;
          
          }
          /* record speaker state info via I2C and display for stereo.  */
          else if (strcmp (long_options[option_index].name, "recordStereo") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->recordStereo_arg), 
                 &(args_info->recordStereo_orig), &(args_info->recordStereo_given),
                &(local_args_info.recordStereo_given), optarg, 0, "55", ARG_INT,
                check_ambiguity, override, 0, 0,
                "recordStereo", '-',
                additional_error))
              goto failure;
          
          }
          /* number of read cycles to execute, 0 means forever.  */
          else if (strcmp (long_options[option_index].name, "count") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->count_arg), 
                 &(args_info->count_orig), &(args_info->count_given),
                &(local_args_info.count_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "count", '-',
                additional_error))
              goto failure;
          
          }
          /* the output file for binary speaker state info records, default=stdout.  */
          else if (strcmp (long_options[option_index].name, "output") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->output_arg), 
                 &(args_info->output_orig), &(args_info->output_given),
                &(local_args_info.output_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "output", '-',
                additional_error))
              goto failure;
          
          }
          /* start datalogger, recording <count> state info lines and binary Z/Xmodels.  */
          else if (strcmp (long_options[option_index].name, "logger") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->logger_arg), 
                 &(args_info->logger_orig), &(args_info->logger_given),
                &(local_args_info.logger_given), optarg, 0, "2", ARG_INT,
                check_ambiguity, override, 0, 0,
                "logger", '-',
                additional_error))
              goto failure;
          
          }
          /* save parameters of the loaded parms file to seperate files.  */
          else if (strcmp (long_options[option_index].name, "splitparms") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->splitparms_given),
                &(local_args_info.splitparms_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "splitparms", '-',
                additional_error))
              goto failure;
          
          }
          /* read preset settings from saved file.  */
          else if (strcmp (long_options[option_index].name, "loadPreset") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->loadPreset_arg), 
                 &(args_info->loadPreset_orig), &(args_info->loadPreset_given),
                &(local_args_info.loadPreset_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "loadPreset", '-',
                additional_error))
              goto failure;
          
          }
          /* read speaker settings from saved file.  */
          else if (strcmp (long_options[option_index].name, "loadSpeaker") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->loadSpeaker_arg), 
                 &(args_info->loadSpeaker_orig), &(args_info->loadSpeaker_given),
                &(local_args_info.loadSpeaker_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "loadSpeaker", '-',
                additional_error))
              goto failure;
          
          }
          /* read config settings from saved file.  */
          else if (strcmp (long_options[option_index].name, "loadConfig") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->loadConfig_arg), 
                 &(args_info->loadConfig_orig), &(args_info->loadConfig_given),
                &(local_args_info.loadConfig_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "loadConfig", '-',
                additional_error))
              goto failure;
          
          }
          /* write preset settings to file.  */
          else if (strcmp (long_options[option_index].name, "savePreset") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->savePreset_arg), 
                 &(args_info->savePreset_orig), &(args_info->savePreset_given),
                &(local_args_info.savePreset_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "savePreset", '-',
                additional_error))
              goto failure;
          
          }
          /* write speaker settings to file.  */
          else if (strcmp (long_options[option_index].name, "saveSpeaker") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->saveSpeaker_arg), 
                 &(args_info->saveSpeaker_orig), &(args_info->saveSpeaker_given),
                &(local_args_info.saveSpeaker_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "saveSpeaker", '-',
                additional_error))
              goto failure;
          
          }
          /* write config settings to file.  */
          else if (strcmp (long_options[option_index].name, "saveConfig") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->saveConfig_arg), 
                 &(args_info->saveConfig_orig), &(args_info->saveConfig_given),
                &(local_args_info.saveConfig_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "saveConfig", '-',
                additional_error))
              goto failure;
          
          }
          /* run as server.  */
          else if (strcmp (long_options[option_index].name, "server") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->server_arg), 
                 &(args_info->server_orig), &(args_info->server_given),
                &(local_args_info.server_given), optarg, 0, "9887", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "server", '-',
                additional_error))
              goto failure;
          
          }
          /* run as client.  */
          else if (strcmp (long_options[option_index].name, "client") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->client_arg), 
                 &(args_info->client_orig), &(args_info->client_given),
                &(local_args_info.client_given), optarg, 0, "9887", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "client", '-',
                additional_error))
              goto failure;
          
          }
          /* override hardcoded I2C slave address.  */
          else if (strcmp (long_options[option_index].name, "slave") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->slave_arg), 
                 &(args_info->slave_orig), &(args_info->slave_given),
                &(local_args_info.slave_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "slave", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->params_arg),
    &(args_info->params_orig), args_info->params_given,
    local_args_info.params_given, 0,
    ARG_STRING, params_list);
  update_multiple_arg((void *)&(args_info->register_arg),
    &(args_info->register_orig), args_info->register_given,
    local_args_info.register_given, 0,
    ARG_INT, register_list);
  update_multiple_arg((void *)&(args_info->regwrite_arg),
    &(args_info->regwrite_orig), args_info->regwrite_given,
    local_args_info.regwrite_given, 0,
    ARG_INT, regwrite_list);
  update_multiple_arg((void *)&(args_info->xmem_arg),
    &(args_info->xmem_orig), args_info->xmem_given,
    local_args_info.xmem_given, 0,
    ARG_INT, xmem_list);

  args_info->params_given += local_args_info.params_given;
  local_args_info.params_given = 0;
  args_info->register_given += local_args_info.register_given;
  local_args_info.register_given = 0;
  args_info->regwrite_given += local_args_info.regwrite_given;
  local_args_info.regwrite_given = 0;
  args_info->xmem_given += local_args_info.xmem_given;
  local_args_info.xmem_given = 0;
  
  if (check_required)
    {
      error += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  free_list (params_list, 1 );
  free_list (register_list, 0 );
  free_list (regwrite_list, 0 );
  free_list (xmem_list, 0 );
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
