/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.5
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "climax"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "climax"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION "1.9"
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * device_arg;	/**< @brief device name for the interface: i2c, serial, socket, i2c dummy.  */
  char * device_orig;	/**< @brief device name for the interface: i2c, serial, socket, i2c dummy original value given at command line.  */
  const char *device_help; /**< @brief device name for the interface: i2c, serial, socket, i2c dummy help description.  */
  char * speaker_arg;	/**< @brief speaker side select Left, Right or Both, default is Left only.  */
  char * speaker_orig;	/**< @brief speaker side select Left, Right or Both, default is Left only original value given at command line.  */
  const char *speaker_help; /**< @brief speaker side select Left, Right or Both, default is Left only help description.  */
  int clock_arg;	/**< @brief clock enable=1/disable=0, default is enable.  */
  char * clock_orig;	/**< @brief clock enable=1/disable=0, default is enable original value given at command line.  */
  const char *clock_help; /**< @brief clock enable=1/disable=0, default is enable help description.  */
  int clockStereo_arg;	/**< @brief clock enable=1/disable=0, default is enable.  */
  char * clockStereo_orig;	/**< @brief clock enable=1/disable=0, default is enable original value given at command line.  */
  const char *clockStereo_help; /**< @brief clock enable=1/disable=0, default is enable help description.  */
  char * calibrate_arg;	/**< @brief do calibration with loaded speaker file, --output returns updated speaker file (default='always').  */
  char * calibrate_orig;	/**< @brief do calibration with loaded speaker file, --output returns updated speaker file original value given at command line.  */
  const char *calibrate_help; /**< @brief do calibration with loaded speaker file, --output returns updated speaker file help description.  */
  char * calibrateStereo_arg;	/**< @brief do calibration with loaded speaker file, --output returns updated speaker file for stereo (default='always').  */
  char * calibrateStereo_orig;	/**< @brief do calibration with loaded speaker file, --output returns updated speaker file for stereo original value given at command line.  */
  const char *calibrateStereo_help; /**< @brief do calibration with loaded speaker file, --output returns updated speaker file for stereo help description.  */
  const char *resetMtpEx_help; /**< @brief reset MtpEx register to do re-calibration help description.  */
  const char *calshow_help; /**< @brief show calibration impedance value help description.  */
  const char *init_help; /**< @brief force poweron init help description.  */
  const char *reset_help; /**< @brief initialize registers and coldboot dsp help description.  */
  char ** params_arg;	/**< @brief store input params file depending on type: patch, speaker, preset, config, eq .  */
  char ** params_orig;	/**< @brief store input params file depending on type: patch, speaker, preset, config, eq  original value given at command line.  */
  unsigned int params_min; /**< @brief store input params file depending on type: patch, speaker, preset, config, eq 's minimum occurreces */
  unsigned int params_max; /**< @brief store input params file depending on type: patch, speaker, preset, config, eq 's maximum occurreces */
  const char *params_help; /**< @brief store input params file depending on type: patch, speaker, preset, config, eq  help description.  */
  int profile_arg;	/**< @brief set the profile for current operation.  */
  char * profile_orig;	/**< @brief set the profile for current operation original value given at command line.  */
  const char *profile_help; /**< @brief set the profile for current operation help description.  */
  int currentprof_arg;	/**< @brief set the profile from previous operation.  */
  char * currentprof_orig;	/**< @brief set the profile from previous operation original value given at command line.  */
  const char *currentprof_help; /**< @brief set the profile from previous operation help description.  */
  int volume_arg;	/**< @brief set volume step.  */
  char * volume_orig;	/**< @brief set volume step original value given at command line.  */
  const char *volume_help; /**< @brief set volume step help description.  */
  const char *versions_help; /**< @brief print versions and chip rev help description.  */
  int* register_arg;	/**< @brief read tfa register, write if extra arg given.  */
  char ** register_orig;	/**< @brief read tfa register, write if extra arg given original value given at command line.  */
  unsigned int register_min; /**< @brief read tfa register, write if extra arg given's minimum occurreces */
  unsigned int register_max; /**< @brief read tfa register, write if extra arg given's maximum occurreces */
  const char *register_help; /**< @brief read tfa register, write if extra arg given help description.  */
  int* regwrite_arg;	/**< @brief write value for register.  */
  char ** regwrite_orig;	/**< @brief write value for register original value given at command line.  */
  unsigned int regwrite_min; /**< @brief write value for register's minimum occurreces */
  unsigned int regwrite_max; /**< @brief write value for register's maximum occurreces */
  const char *regwrite_help; /**< @brief write value for register help description.  */
  const char *dump_help; /**< @brief dump all defined registers help description.  */
  const char *dumpStereo_help; /**< @brief dump all defined registers of stereo help description.  */
  int pin_arg;	/**< @brief control pin.  */
  char * pin_orig;	/**< @brief control pin original value given at command line.  */
  const char *pin_help; /**< @brief control pin help description.  */
  int diag_arg;	/**< @brief run all diagnostic tests, or single if specified (default='0').  */
  char * diag_orig;	/**< @brief run all diagnostic tests, or single if specified original value given at command line.  */
  const char *diag_help; /**< @brief run all diagnostic tests, or single if specified help description.  */
  char * dumpmodel_arg;	/**< @brief dump current speakermodel impedance=z or excursion=x (default='z').  */
  char * dumpmodel_orig;	/**< @brief dump current speakermodel impedance=z or excursion=x original value given at command line.  */
  const char *dumpmodel_help; /**< @brief dump current speakermodel impedance=z or excursion=x help description.  */
  int dsp_arg;	/**< @brief DSP get speakerboost params, use --count to set bytecount (default='0x80').  */
  char * dsp_orig;	/**< @brief DSP get speakerboost params, use --count to set bytecount original value given at command line.  */
  const char *dsp_help; /**< @brief DSP get speakerboost params, use --count to set bytecount help description.  */
  float tcoef_arg;	/**< @brief show tCoef of loaded speaker, save to --output if new value given (default='0').  */
  char * tcoef_orig;	/**< @brief show tCoef of loaded speaker, save to --output if new value given original value given at command line.  */
  const char *tcoef_help; /**< @brief show tCoef of loaded speaker, save to --output if new value given help description.  */
  int* xmem_arg;	/**< @brief read tfa xmem.  */
  char ** xmem_orig;	/**< @brief read tfa xmem original value given at command line.  */
  unsigned int xmem_min; /**< @brief read tfa xmem's minimum occurreces */
  unsigned int xmem_max; /**< @brief read tfa xmem's maximum occurreces */
  const char *xmem_help; /**< @brief read tfa xmem help description.  */
  int record_arg;	/**< @brief record speaker state info via I2C and display (default='55').  */
  char * record_orig;	/**< @brief record speaker state info via I2C and display original value given at command line.  */
  const char *record_help; /**< @brief record speaker state info via I2C and display help description.  */
  int recordStereo_arg;	/**< @brief record speaker state info via I2C and display for stereo (default='55').  */
  char * recordStereo_orig;	/**< @brief record speaker state info via I2C and display for stereo original value given at command line.  */
  const char *recordStereo_help; /**< @brief record speaker state info via I2C and display for stereo help description.  */
  int count_arg;	/**< @brief number of read cycles to execute, 0 means forever.  */
  char * count_orig;	/**< @brief number of read cycles to execute, 0 means forever original value given at command line.  */
  const char *count_help; /**< @brief number of read cycles to execute, 0 means forever help description.  */
  char * output_arg;	/**< @brief the output file for binary speaker state info records, default=stdout.  */
  char * output_orig;	/**< @brief the output file for binary speaker state info records, default=stdout original value given at command line.  */
  const char *output_help; /**< @brief the output file for binary speaker state info records, default=stdout help description.  */
  int logger_arg;	/**< @brief start datalogger, recording <count> state info lines and binary Z/Xmodels (default='2').  */
  char * logger_orig;	/**< @brief start datalogger, recording <count> state info lines and binary Z/Xmodels original value given at command line.  */
  const char *logger_help; /**< @brief start datalogger, recording <count> state info lines and binary Z/Xmodels help description.  */
  char * load_arg;	/**< @brief read parameter settings from saved file.  */
  char * load_orig;	/**< @brief read parameter settings from saved file original value given at command line.  */
  const char *load_help; /**< @brief read parameter settings from saved file help description.  */
  const char *splitparms_help; /**< @brief save parameters of the loaded parms file to seperate files help description.  */
  char * loadPreset_arg;	/**< @brief read preset settings from saved file.  */
  char * loadPreset_orig;	/**< @brief read preset settings from saved file original value given at command line.  */
  const char *loadPreset_help; /**< @brief read preset settings from saved file help description.  */
  char * loadSpeaker_arg;	/**< @brief read speaker settings from saved file.  */
  char * loadSpeaker_orig;	/**< @brief read speaker settings from saved file original value given at command line.  */
  const char *loadSpeaker_help; /**< @brief read speaker settings from saved file help description.  */
  char * loadConfig_arg;	/**< @brief read config settings from saved file.  */
  char * loadConfig_orig;	/**< @brief read config settings from saved file original value given at command line.  */
  const char *loadConfig_help; /**< @brief read config settings from saved file help description.  */
  char * save_arg;	/**< @brief write parameter settings to file.  */
  char * save_orig;	/**< @brief write parameter settings to file original value given at command line.  */
  const char *save_help; /**< @brief write parameter settings to file help description.  */
  char * savePreset_arg;	/**< @brief write preset settings to file.  */
  char * savePreset_orig;	/**< @brief write preset settings to file original value given at command line.  */
  const char *savePreset_help; /**< @brief write preset settings to file help description.  */
  char * saveSpeaker_arg;	/**< @brief write speaker settings to file.  */
  char * saveSpeaker_orig;	/**< @brief write speaker settings to file original value given at command line.  */
  const char *saveSpeaker_help; /**< @brief write speaker settings to file help description.  */
  char * saveConfig_arg;	/**< @brief write config settings to file.  */
  char * saveConfig_orig;	/**< @brief write config settings to file original value given at command line.  */
  const char *saveConfig_help; /**< @brief write config settings to file help description.  */
  char * server_arg;	/**< @brief run as server (default='9887').  */
  char * server_orig;	/**< @brief run as server original value given at command line.  */
  const char *server_help; /**< @brief run as server help description.  */
  char * client_arg;	/**< @brief run as client (default='9887').  */
  char * client_orig;	/**< @brief run as client original value given at command line.  */
  const char *client_help; /**< @brief run as client help description.  */
  int slave_arg;	/**< @brief override hardcoded I2C slave address.  */
  char * slave_orig;	/**< @brief override hardcoded I2C slave address original value given at command line.  */
  const char *slave_help; /**< @brief override hardcoded I2C slave address help description.  */
  int loop_arg;	/**< @brief loop the operation [0=forever].  */
  char * loop_orig;	/**< @brief loop the operation [0=forever] original value given at command line.  */
  const char *loop_help; /**< @brief loop the operation [0=forever] help description.  */
  int verbose_arg;	/**< @brief Enable verbose (mask=i2cserver|socket|scribo).  */
  char * verbose_orig;	/**< @brief Enable verbose (mask=i2cserver|socket|scribo) original value given at command line.  */
  const char *verbose_help; /**< @brief Enable verbose (mask=i2cserver|socket|scribo) help description.  */
  const char *trace_help; /**< @brief Enable message tracing help description.  */
  const char *quiet_help; /**< @brief Suppress printing to stdout help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int device_given ;	/**< @brief Whether device was given.  */
  unsigned int speaker_given ;	/**< @brief Whether speaker was given.  */
  unsigned int clock_given ;	/**< @brief Whether clock was given.  */
  unsigned int clockStereo_given ;	/**< @brief Whether clockStereo was given.  */
  unsigned int calibrate_given ;	/**< @brief Whether calibrate was given.  */
  unsigned int calibrateStereo_given ;	/**< @brief Whether calibrateStereo was given.  */
  unsigned int resetMtpEx_given ;	/**< @brief Whether resetMtpEx was given.  */
  unsigned int calshow_given ;	/**< @brief Whether calshow was given.  */
  unsigned int init_given ;	/**< @brief Whether init was given.  */
  unsigned int reset_given ;	/**< @brief Whether reset was given.  */
  unsigned int params_given ;	/**< @brief Whether params was given.  */
  unsigned int profile_given ;	/**< @brief Whether profile was given.  */
  unsigned int currentprof_given ;	/**< @brief Whether currentprof was given.  */
  unsigned int volume_given ;	/**< @brief Whether volume was given.  */
  unsigned int versions_given ;	/**< @brief Whether versions was given.  */
  unsigned int register_given ;	/**< @brief Whether register was given.  */
  unsigned int regwrite_given ;	/**< @brief Whether regwrite was given.  */
  unsigned int dump_given ;	/**< @brief Whether dump was given.  */
  unsigned int dumpStereo_given ;	/**< @brief Whether dumpStereo was given.  */
  unsigned int pin_given ;	/**< @brief Whether pin was given.  */
  unsigned int diag_given ;	/**< @brief Whether diag was given.  */
  unsigned int dumpmodel_given ;	/**< @brief Whether dumpmodel was given.  */
  unsigned int dsp_given ;	/**< @brief Whether dsp was given.  */
  unsigned int tcoef_given ;	/**< @brief Whether tcoef was given.  */
  unsigned int xmem_given ;	/**< @brief Whether xmem was given.  */
  unsigned int record_given ;	/**< @brief Whether record was given.  */
  unsigned int recordStereo_given ;	/**< @brief Whether recordStereo was given.  */
  unsigned int count_given ;	/**< @brief Whether count was given.  */
  unsigned int output_given ;	/**< @brief Whether output was given.  */
  unsigned int logger_given ;	/**< @brief Whether logger was given.  */
  unsigned int load_given ;	/**< @brief Whether load was given.  */
  unsigned int splitparms_given ;	/**< @brief Whether splitparms was given.  */
  unsigned int loadPreset_given ;	/**< @brief Whether loadPreset was given.  */
  unsigned int loadSpeaker_given ;	/**< @brief Whether loadSpeaker was given.  */
  unsigned int loadConfig_given ;	/**< @brief Whether loadConfig was given.  */
  unsigned int save_given ;	/**< @brief Whether save was given.  */
  unsigned int savePreset_given ;	/**< @brief Whether savePreset was given.  */
  unsigned int saveSpeaker_given ;	/**< @brief Whether saveSpeaker was given.  */
  unsigned int saveConfig_given ;	/**< @brief Whether saveConfig was given.  */
  unsigned int server_given ;	/**< @brief Whether server was given.  */
  unsigned int client_given ;	/**< @brief Whether client was given.  */
  unsigned int slave_given ;	/**< @brief Whether slave was given.  */
  unsigned int loop_given ;	/**< @brief Whether loop was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int trace_given ;	/**< @brief Whether trace was given.  */
  unsigned int quiet_given ;	/**< @brief Whether quiet was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *gengetopt_args_info_full_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void cmdline_parser_print_full_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
