/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef ANDROID_SENSORS_H
#define ANDROID_SENSORS_H

#include <stdint.h>
#include <errno.h>
#include <sys/cdefs.h>
#include <sys/types.h>

#include <linux/input.h>

#include <hardware/hardware.h>
#include <hardware/sensors.h>

__BEGIN_DECLS

/*****************************************************************************/

#define ARRAY_SIZE(a) (sizeof(a) / sizeof(a[0]))


/*****************************************************************************/

/*
 * The SENSORS Module
 */

/* the GP2A is a binary proximity sensor that triggers around 5 cm on
 * this hardware */
#define PROXIMITY_THRESHOLD_GP2A  5.0f

#define CONVERT_1			1.0f
#define CONVERT_10			0.1f
#define CONVERT_100			0.01f
#define CONVERT_1000		0.001f
#define CONVERT_10000		0.0001f

#define RANGE_A                     (2*GRAVITY_EARTH)
#define RESOLUTION_A                (RANGE_A/(256*1))

#define SENSOR_STATE_MASK           (0x7FFF)

/*****************************************************************************/
typedef enum {
	CW_ACCELERATION					= 0,
	CW_MAGNETIC					= 1,
	CW_GYRO						= 2,
	CW_LIGHT					= 3,
	CW_PROXIMITY					= 4,
	CW_PRESSURE					= 5,
	CW_ORIENTATION					= 6,
	CW_ROTATIONVECTOR				= 7,
	CW_LINEARACCELERATION				= 8,
	CW_GRAVITY					= 9,
	CW_PEDOMETER					= 10,
	CW_AIRMOUSE					= 11,
	CW_SNAP						= 12,
	CW_SHAKE					= 13,
	CW_TAP						= 14,
	CW_PEDOMETER_DETECTOR				= 15,
	CW_MAGNETIC_UNCALIBRATED			= 16,
	CW_GYROSCOPE_UNCALIBRATED			= 17,
	CW_GAME_ROTATION_VECTOR				= 18,
	CW_GEOMAGNETIC_ROTATION_VECTOR			= 19,
	CW_SIGNIFICANT_MOTION				= 20,
	CW_FLIP								= 21,
	CW_TWIST							= 22,
	CW_TILT								= 23,
	CW_PDR								= 24,
	CW_FALLING							= 25,
	CW_RGB								= 26,
	CW_PROXIMITY_GESTURE				= 27,
	CW_CONTEXT_AWARE					= 28,
	CW_SCREEN_ON						= 29,
	CW_PROXIMITY_SCREEN_ON				= 30,
	CW_SENSORS_ID_END,
	CW_META_DATA						= 99
} CW_SENSORS_ID;

enum ABS_status {
	CW_ABS_X = 0x01,
	CW_ABS_Y,
	CW_ABS_Z,
	CW_ABS_X1,
	CW_ABS_Y1,
	CW_ABS_Z1,
	CW_ABS_TIMEDIFF,
	CW_ABS_M_ACCURACY
};

__END_DECLS

#endif  // ANDROID_SENSORS_H
