/**
 * @file mt_cpufreq_tlp.c
 * @brief CPU DVFS TLP Table
 */

#ifndef __MT_CPUFREQ_TLP_C__
#define __MT_CPUFREQ_TLP_C__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __MT_CPUFREQ_C__
#define CPUFREQ_EXTERN
#else
#define CPUFREQ_EXTERN extern
#endif

#define TAG     "[Power/cpufreq] "

#define cpufreq_tlp_err(fmt, args...)       \
	printk(KERN_ERR TAG KERN_CONT fmt, ##args)
#define cpufreq_tlp_warn(fmt, args...)      \
	printk(KERN_WARNING TAG KERN_CONT fmt, ##args)
#define cpufreq_tlp_info(fmt, args...)      \
	printk(KERN_NOTICE TAG KERN_CONT fmt, ##args)
#define cpufreq_tlp_dbg(fmt, args...)       \
	printk(KERN_INFO TAG KERN_CONT fmt, ##args)
#define cpufreq_tlp_ver(fmt, args...)       \
	printk(KERN_DEBUG TAG KERN_CONT fmt, ##args)

#define FUNC_ENTER() do { cpufreq_tlp_dbg(">> %s()\n", __func__); } while (0)
#define FUNC_EXIT() do { cpufreq_tlp_dbg("<< %s():%d\n", __func__, __LINE__); } while (0)

/*=============================================================*/
// Include files
/*=============================================================*/

// system includes

// project includes
#ifndef __KERNEL__
#else  /* __KERNEL__ */
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>

/* project includes */
#include "mach/mt_cpufreq.h"
#endif /* ! __KERNEL__ */

// local includes

// forward references


/*=============================================================*/
// Macro definition
/*=============================================================*/


/*=============================================================*/
// Type definition
/*=============================================================*/

struct mt_cpu_power_tbl cpu_tlp1_power_tbl[] = {
	{1, 1, 0, 1, 5859, 1171},
	{1, 2, 0, 1, 4622, 913},
	{1, 3, 0, 1, 4232, 790},
	{1, 4, 0, 1, 3841, 693},
	{1, 5, 0, 1, 3515, 597},
	{1, 6, 0, 1, 3125, 488},
	{1, 7, 0, 1, 2474, 360},
	{1, 8, 0, 1, 1237, 152},
	{1, 1, 0, 1, 5859, 1171},
	{1, 2, 0, 1, 4622, 913},
	{1, 3, 0, 1, 4232, 790},
	{1, 4, 0, 1, 3841, 693},
	{1, 5, 0, 1, 3515, 597},
	{1, 6, 0, 1, 3125, 488},
	{1, 7, 0, 1, 2474, 360},
	{1, 8, 0, 1, 1237, 152},
	{1, 1, 0, 1, 5859, 1171},
	{1, 2, 0, 1, 4622, 913},
	{1, 3, 0, 1, 4232, 790},
	{1, 4, 0, 1, 3841, 693},
	{1, 5, 0, 1, 3515, 597},
	{1, 6, 0, 1, 3125, 488},
	{1, 7, 0, 1, 2474, 360},
	{1, 8, 0, 1, 1237, 152},
	{1, 1, 0, 1, 5859, 1171},
	{1, 2, 0, 1, 4622, 913},
	{1, 3, 0, 1, 4232, 790},
	{1, 4, 0, 1, 3841, 693},
	{1, 5, 0, 1, 3515, 597},
	{1, 6, 0, 1, 3125, 488},
	{1, 7, 0, 1, 2474, 360},
	{1, 8, 0, 1, 1237, 152},
	{0, 8, 1, 1, 3130, 268},
	{0, 8, 1, 2, 2783, 217},
	{0, 8, 1, 3, 2530, 201},
	{0, 8, 1, 4, 2308, 161},
	{0, 8, 1, 5, 2119, 143},
	{0, 8, 1, 6, 1866, 116},
	{0, 8, 1, 7, 1486, 84},
	{0, 8, 1, 8, 759, 37},
	{0, 8, 0, 1, 0, 0},
	{0, 8, 0, 2, 0, 0},
	{0, 8, 0, 3, 0, 0},
	{0, 8, 0, 4, 0, 0},
	{0, 8, 0, 5, 0, 0},
	{0, 8, 0, 6, 0, 0},
	{0, 8, 0, 7, 0, 0},
	{0, 8, 0, 8, 0, 0},
	{0, 8, 0, 1, 0, 0},
	{0, 8, 0, 2, 0, 0},
	{0, 8, 0, 3, 0, 0},
	{0, 8, 0, 4, 0, 0},
	{0, 8, 0, 5, 0, 0},
	{0, 8, 0, 6, 0, 0},
	{0, 8, 0, 7, 0, 0},
	{0, 8, 0, 8, 0, 0},
	{0, 8, 0, 1, 0, 0},
	{0, 8, 0, 2, 0, 0},
	{0, 8, 0, 3, 0, 0},
	{0, 8, 0, 4, 0, 0},
	{0, 8, 0, 5, 0, 0},
	{0, 8, 0, 6, 0, 0},
	{0, 8, 0, 7, 0, 0},
	{0, 8, 0, 8, 0, 0},
	{0, 8, 0, 1, 0, 0},
};

struct mt_cpu_power_tbl cpu_tlp2_power_tbl[] = {
	{2, 1, 0, 1, 11718, 2342},
	{2, 2, 0, 1, 9244, 1827},
	{2, 3, 0, 1, 8463, 1580},
	{2, 4, 0, 1, 7682, 1387},
	{2, 5, 0, 1, 7031, 1195},
	{2, 6, 0, 1, 6250, 976},
	{2, 7, 0, 1, 4948, 721},
	{2, 8, 0, 1, 2474, 305},
	{2, 1, 0, 1, 11718, 2342},
	{2, 2, 0, 1, 9244, 1827},
	{2, 3, 0, 1, 8463, 1580},
	{2, 4, 0, 1, 7682, 1387},
	{2, 5, 0, 1, 7031, 1195},
	{2, 6, 0, 1, 6250, 976},
	{2, 7, 0, 1, 4948, 721},
	{2, 8, 0, 1, 2474, 305},
	{2, 1, 0, 1, 11718, 2342},
	{2, 2, 0, 1, 9244, 1827},
	{2, 3, 0, 1, 8463, 1580},
	{2, 4, 0, 1, 7682, 1387},
	{2, 5, 0, 1, 7031, 1195},
	{2, 6, 0, 1, 6250, 976},
	{2, 7, 0, 1, 4948, 721},
	{2, 8, 0, 1, 2474, 305},
	{1, 1, 1, 1, 8989, 1439},
	{1, 2, 1, 1, 7752, 1181},
	{1, 3, 1, 1, 7362, 1058},
	{1, 4, 1, 1, 6971, 961},
	{1, 5, 1, 1, 6646, 865},
	{1, 6, 1, 1, 6255, 756},
	{1, 7, 1, 1, 5604, 628},
	{1, 8, 1, 1, 4367, 420},
	{0, 8, 2, 1, 6261, 536},
	{0, 8, 2, 2, 5565, 433},
	{0, 8, 2, 3, 5059, 402},
	{0, 8, 2, 4, 4617, 322},
	{0, 8, 2, 5, 4237, 285},
	{0, 8, 2, 6, 3731, 232},
	{0, 8, 2, 7, 2972, 168},
	{0, 8, 2, 8, 1518, 73},
	{0, 8, 1, 1, 3130, 268},
	{0, 8, 1, 2, 2783, 217},
	{0, 8, 1, 3, 2530, 201},
	{0, 8, 1, 4, 2308, 161},
	{0, 8, 1, 5, 2119, 143},
	{0, 8, 1, 6, 1866, 116},
	{0, 8, 1, 7, 1486, 84},
	{0, 8, 1, 8, 759, 37},
	{0, 8, 0, 1, 0, 0},
	{0, 8, 0, 2, 0, 0},
	{0, 8, 0, 3, 0, 0},
	{0, 8, 0, 4, 0, 0},
	{0, 8, 0, 5, 0, 0},
	{0, 8, 0, 6, 0, 0},
	{0, 8, 0, 7, 0, 0},
	{0, 8, 0, 8, 0, 0},
	{0, 8, 0, 1, 0, 0},
	{0, 8, 0, 2, 0, 0},
	{0, 8, 0, 3, 0, 0},
	{0, 8, 0, 4, 0, 0},
	{0, 8, 0, 5, 0, 0},
	{0, 8, 0, 6, 0, 0},
	{0, 8, 0, 7, 0, 0},
	{0, 8, 0, 8, 0, 0},
	{0, 8, 0, 1, 0, 0},
};

struct mt_cpu_power_tbl cpu_tlp3_power_tbl[] = {
	{3, 1, 0, 1, 17577, 3513},
	{3, 2, 0, 1, 13866, 2740},
	{3, 3, 0, 1, 12695, 2369},
	{3, 4, 0, 1, 11523, 2080},
	{3, 5, 0, 1, 10546, 1792},
	{3, 6, 0, 1, 9374, 1464},
	{3, 7, 0, 1, 7421, 1081},
	{3, 8, 0, 1, 3711, 457},
	{3, 1, 0, 1, 17577, 3513},
	{3, 2, 0, 1, 13866, 2740},
	{3, 3, 0, 1, 12695, 2369},
	{3, 4, 0, 1, 11523, 2080},
	{3, 5, 0, 1, 10546, 1792},
	{3, 6, 0, 1, 9374, 1464},
	{3, 7, 0, 1, 7421, 1081},
	{3, 8, 0, 1, 3711, 457},
	{2, 1, 1, 1, 14848, 2610},
	{2, 2, 1, 1, 12375, 2095},
	{2, 3, 1, 1, 11593, 1847},
	{2, 4, 1, 1, 10812, 1655},
	{2, 5, 1, 1, 10161, 1463},
	{2, 6, 1, 1, 9380, 1244},
	{2, 7, 1, 1, 8078, 988},
	{2, 8, 1, 1, 5604, 572},
	{1, 1, 2, 1, 12120, 1707},
	{1, 2, 2, 1, 10883, 1449},
	{1, 3, 2, 1, 10492, 1326},
	{1, 4, 2, 1, 10102, 1229},
	{1, 5, 2, 1, 9776, 1133},
	{1, 6, 2, 1, 9386, 1024},
	{1, 7, 2, 1, 8735, 896},
	{1, 8, 2, 1, 7498, 688},
	{0, 8, 3, 1, 9391, 804},
	{0, 8, 3, 2, 8348, 650},
	{0, 8, 3, 3, 7589, 602},
	{0, 8, 3, 4, 6925, 483},
	{0, 8, 3, 5, 6356, 428},
	{0, 8, 3, 6, 5597, 348},
	{0, 8, 3, 7, 4458, 252},
	{0, 8, 3, 8, 2277, 110},
	{0, 8, 2, 1, 6261, 536},
	{0, 8, 2, 2, 5565, 433},
	{0, 8, 2, 3, 5059, 402},
	{0, 8, 2, 4, 4617, 322},
	{0, 8, 2, 5, 4237, 285},
	{0, 8, 2, 6, 3731, 232},
	{0, 8, 2, 7, 2972, 168},
	{0, 8, 2, 8, 1518, 73},
	{0, 8, 1, 1, 3130, 268},
	{0, 8, 1, 2, 2783, 217},
	{0, 8, 1, 3, 2530, 201},
	{0, 8, 1, 4, 2308, 161},
	{0, 8, 1, 5, 2119, 143},
	{0, 8, 1, 6, 1866, 116},
	{0, 8, 1, 7, 1486, 84},
	{0, 8, 1, 8, 759, 37},
	{0, 8, 0, 1, 0, 0},
	{0, 8, 0, 2, 0, 0},
	{0, 8, 0, 3, 0, 0},
	{0, 8, 0, 4, 0, 0},
	{0, 8, 0, 5, 0, 0},
	{0, 8, 0, 6, 0, 0},
	{0, 8, 0, 7, 0, 0},
	{0, 8, 0, 8, 0, 0},
	{0, 8, 0, 1, 0, 0},
};

struct mt_cpu_power_tbl cpu_tlp4_power_tbl[] = {
	{4, 1, 0, 1, 23436, 4684},
	{4, 2, 0, 1, 18488, 3654},
	{4, 3, 0, 1, 16926, 3159},
	{4, 4, 0, 1, 15364, 2774},
	{4, 5, 0, 1, 14062, 2390},
	{4, 6, 0, 1, 12499, 1952},
	{4, 7, 0, 1, 9895, 1441},
	{4, 8, 0, 1, 4948, 609},
	{3, 1, 1, 1, 20707, 3781},
	{3, 2, 1, 1, 16997, 3008},
	{3, 3, 1, 1, 15825, 2637},
	{3, 4, 1, 1, 14653, 2348},
	{3, 5, 1, 1, 13677, 2060},
	{3, 6, 1, 1, 12505, 1732},
	{3, 7, 1, 1, 10552, 1349},
	{3, 8, 1, 1, 6841, 725},
	{2, 1, 2, 1, 17979, 2878},
	{2, 2, 2, 1, 15505, 2362},
	{2, 3, 2, 1, 14724, 2115},
	{2, 4, 2, 1, 13943, 1923},
	{2, 5, 2, 1, 13292, 1730},
	{2, 6, 2, 1, 12510, 1512},
	{2, 7, 2, 1, 11208, 1256},
	{2, 8, 2, 1, 8735, 840},
	{1, 1, 3, 1, 15250, 1975},
	{1, 2, 3, 1, 14013, 1717},
	{1, 3, 3, 1, 13623, 1593},
	{1, 4, 3, 1, 13232, 1497},
	{1, 5, 3, 1, 12907, 1401},
	{1, 6, 3, 1, 12516, 1292},
	{1, 7, 3, 1, 11865, 1164},
	{1, 8, 3, 1, 10628, 956},
	{0, 8, 4, 1, 12522, 1071},
	{0, 8, 4, 2, 11130, 867},
	{0, 8, 4, 3, 10118, 803},
	{0, 8, 4, 4, 9233, 643},
	{0, 8, 4, 5, 8474, 571},
	{0, 8, 4, 6, 7462, 463},
	{0, 8, 4, 7, 5945, 336},
	{0, 8, 4, 8, 3036, 147},
	{0, 8, 3, 1, 9391, 804},
	{0, 8, 3, 2, 8348, 650},
	{0, 8, 3, 3, 7589, 602},
	{0, 8, 3, 4, 6925, 483},
	{0, 8, 3, 5, 6356, 428},
	{0, 8, 3, 6, 5597, 348},
	{0, 8, 3, 7, 4458, 252},
	{0, 8, 3, 8, 2277, 110},
	{0, 8, 2, 1, 6261, 536},
	{0, 8, 2, 2, 5565, 433},
	{0, 8, 2, 3, 5059, 402},
	{0, 8, 2, 4, 4617, 322},
	{0, 8, 2, 5, 4237, 285},
	{0, 8, 2, 6, 3731, 232},
	{0, 8, 2, 7, 2972, 168},
	{0, 8, 2, 8, 1518, 73},
	{0, 8, 1, 1, 3130, 268},
	{0, 8, 1, 2, 2783, 217},
	{0, 8, 1, 3, 2530, 201},
	{0, 8, 1, 4, 2308, 161},
	{0, 8, 1, 5, 2119, 143},
	{0, 8, 1, 6, 1866, 116},
	{0, 8, 1, 7, 1486, 84},
	{0, 8, 1, 8, 759, 37},
	{0, 8, 0, 1, 0, 0},
};

struct mt_cpu_power_tbl cpu_tlp5_power_tbl[] = {
	{4, 1, 1, 1, 26566, 4952},
	{4, 2, 1, 1, 21619, 3921},
	{4, 3, 1, 1, 20056, 3427},
	{4, 4, 1, 1, 18494, 3042},
	{4, 5, 1, 1, 17192, 2657},
	{4, 6, 1, 1, 15630, 2220},
	{4, 7, 1, 1, 13026, 1709},
	{4, 8, 1, 1, 8078, 877},
	{3, 1, 2, 1, 23838, 4049},
	{3, 2, 2, 1, 20127, 3276},
	{3, 3, 2, 1, 18955, 2905},
	{3, 4, 2, 1, 17783, 2616},
	{3, 5, 2, 1, 16807, 2328},
	{3, 6, 2, 1, 15635, 2000},
	{3, 7, 2, 1, 13682, 1617},
	{3, 8, 2, 1, 9971, 993},
	{2, 1, 3, 1, 21109, 3146},
	{2, 2, 3, 1, 18635, 2630},
	{2, 3, 3, 1, 17854, 2383},
	{2, 4, 3, 1, 17073, 2191},
	{2, 5, 3, 1, 16422, 1998},
	{2, 6, 3, 1, 15641, 1780},
	{2, 7, 3, 1, 14339, 1524},
	{2, 8, 3, 1, 11865, 1108},
	{1, 1, 4, 1, 18381, 2243},
	{1, 2, 4, 1, 17144, 1985},
	{1, 3, 4, 1, 16753, 1861},
	{1, 4, 4, 1, 16362, 1765},
	{1, 5, 4, 1, 16037, 1669},
	{1, 6, 4, 1, 15646, 1559},
	{1, 7, 4, 1, 14995, 1432},
	{1, 8, 4, 1, 13758, 1224},
	{0, 8, 4, 1, 12522, 1071},
	{0, 8, 4, 2, 11130, 867},
	{0, 8, 4, 3, 10118, 803},
	{0, 8, 4, 4, 9233, 643},
	{0, 8, 4, 5, 8474, 571},
	{0, 8, 4, 6, 7462, 463},
	{0, 8, 4, 7, 5945, 336},
	{0, 8, 4, 8, 3036, 147},
	{0, 8, 3, 1, 9391, 804},
	{0, 8, 3, 2, 8348, 650},
	{0, 8, 3, 3, 7589, 602},
	{0, 8, 3, 4, 6925, 483},
	{0, 8, 3, 5, 6356, 428},
	{0, 8, 3, 6, 5597, 348},
	{0, 8, 3, 7, 4458, 252},
	{0, 8, 3, 8, 2277, 110},
	{0, 8, 2, 1, 6261, 536},
	{0, 8, 2, 2, 5565, 433},
	{0, 8, 2, 3, 5059, 402},
	{0, 8, 2, 4, 4617, 322},
	{0, 8, 2, 5, 4237, 285},
	{0, 8, 2, 6, 3731, 232},
	{0, 8, 2, 7, 2972, 168},
	{0, 8, 2, 8, 1518, 73},
	{0, 8, 1, 1, 3130, 268},
	{0, 8, 1, 2, 2783, 217},
	{0, 8, 1, 3, 2530, 201},
	{0, 8, 1, 4, 2308, 161},
	{0, 8, 1, 5, 2119, 143},
	{0, 8, 1, 6, 1866, 116},
	{0, 8, 1, 7, 1486, 84},
	{0, 8, 1, 8, 759, 37},
	{0, 8, 0, 1, 0, 0},
};

struct mt_cpu_power_tbl cpu_tlp6_power_tbl[] = {
	{4, 1, 2, 1, 29697, 5220},
	{4, 2, 2, 1, 24749, 4189},
	{4, 3, 2, 1, 23187, 3695},
	{4, 4, 2, 1, 21624, 3310},
	{4, 5, 2, 1, 20322, 2925},
	{4, 6, 2, 1, 18760, 2488},
	{4, 7, 2, 1, 16156, 1977},
	{4, 8, 2, 1, 11208, 1145},
	{3, 1, 3, 1, 26968, 4317},
	{3, 2, 3, 1, 23257, 3544},
	{3, 3, 3, 1, 22086, 3173},
	{3, 4, 3, 1, 20914, 2884},
	{3, 5, 3, 1, 19937, 2596},
	{3, 6, 3, 1, 18766, 2268},
	{3, 7, 3, 1, 16813, 1884},
	{3, 8, 3, 1, 13102, 1261},
	{2, 1, 4, 1, 24240, 3414},
	{2, 2, 4, 1, 21766, 2898},
	{2, 3, 4, 1, 20985, 2651},
	{2, 4, 4, 1, 20203, 2458},
	{2, 5, 4, 1, 19552, 2266},
	{2, 6, 4, 1, 18771, 2047},
	{2, 7, 4, 1, 17469, 1792},
	{2, 8, 4, 1, 14995, 1376},
	{1, 1, 4, 1, 18381, 2243},
	{1, 2, 4, 1, 17144, 1985},
	{1, 3, 4, 1, 16753, 1861},
	{1, 4, 4, 1, 16362, 1765},
	{1, 5, 4, 1, 16037, 1669},
	{1, 6, 4, 1, 15646, 1559},
	{1, 7, 4, 1, 14995, 1432},
	{1, 8, 4, 1, 13758, 1224},
	{0, 8, 4, 1, 12522, 1071},
	{0, 8, 4, 2, 11130, 867},
	{0, 8, 4, 3, 10118, 803},
	{0, 8, 4, 4, 9233, 643},
	{0, 8, 4, 5, 8474, 571},
	{0, 8, 4, 6, 7462, 463},
	{0, 8, 4, 7, 5945, 336},
	{0, 8, 4, 8, 3036, 147},
	{0, 8, 3, 1, 9391, 804},
	{0, 8, 3, 2, 8348, 650},
	{0, 8, 3, 3, 7589, 602},
	{0, 8, 3, 4, 6925, 483},
	{0, 8, 3, 5, 6356, 428},
	{0, 8, 3, 6, 5597, 348},
	{0, 8, 3, 7, 4458, 252},
	{0, 8, 3, 8, 2277, 110},
	{0, 8, 2, 1, 6261, 536},
	{0, 8, 2, 2, 5565, 433},
	{0, 8, 2, 3, 5059, 402},
	{0, 8, 2, 4, 4617, 322},
	{0, 8, 2, 5, 4237, 285},
	{0, 8, 2, 6, 3731, 232},
	{0, 8, 2, 7, 2972, 168},
	{0, 8, 2, 8, 1518, 73},
	{0, 8, 1, 1, 3130, 268},
	{0, 8, 1, 2, 2783, 217},
	{0, 8, 1, 3, 2530, 201},
	{0, 8, 1, 4, 2308, 161},
	{0, 8, 1, 5, 2119, 143},
	{0, 8, 1, 6, 1866, 116},
	{0, 8, 1, 7, 1486, 84},
	{0, 8, 1, 8, 759, 37},
	{0, 8, 0, 1, 0, 0},
};

struct mt_cpu_power_tbl cpu_tlp7_power_tbl[] = {
	{4, 1, 3, 1, 32827, 5488},
	{4, 2, 3, 1, 27880, 4457},
	{4, 3, 3, 1, 26317, 3963},
	{4, 4, 3, 1, 24755, 3577},
	{4, 5, 3, 1, 23453, 3193},
	{4, 6, 3, 1, 21890, 2755},
	{4, 7, 3, 1, 19286, 2245},
	{4, 8, 3, 1, 14339, 1413},
	{3, 1, 4, 1, 30099, 4585},
	{3, 2, 4, 1, 26388, 3812},
	{3, 3, 4, 1, 25216, 3441},
	{3, 4, 4, 1, 24044, 3152},
	{3, 5, 4, 1, 23068, 2864},
	{3, 6, 4, 1, 21896, 2535},
	{3, 7, 4, 1, 19943, 2152},
	{3, 8, 4, 1, 16232, 1528},
	{2, 1, 4, 1, 24240, 3414},
	{2, 2, 4, 1, 21766, 2898},
	{2, 3, 4, 1, 20985, 2651},
	{2, 4, 4, 1, 20203, 2458},
	{2, 5, 4, 1, 19552, 2266},
	{2, 6, 4, 1, 18771, 2047},
	{2, 7, 4, 1, 17469, 1792},
	{2, 8, 4, 1, 14995, 1376},
	{1, 1, 4, 1, 18381, 2243},
	{1, 2, 4, 1, 17144, 1985},
	{1, 3, 4, 1, 16753, 1861},
	{1, 4, 4, 1, 16362, 1765},
	{1, 5, 4, 1, 16037, 1669},
	{1, 6, 4, 1, 15646, 1559},
	{1, 7, 4, 1, 14995, 1432},
	{1, 8, 4, 1, 13758, 1224},
	{0, 8, 4, 1, 12522, 1071},
	{0, 8, 4, 2, 11130, 867},
	{0, 8, 4, 3, 10118, 803},
	{0, 8, 4, 4, 9233, 643},
	{0, 8, 4, 5, 8474, 571},
	{0, 8, 4, 6, 7462, 463},
	{0, 8, 4, 7, 5945, 336},
	{0, 8, 4, 8, 3036, 147},
	{0, 8, 3, 1, 9391, 804},
	{0, 8, 3, 2, 8348, 650},
	{0, 8, 3, 3, 7589, 602},
	{0, 8, 3, 4, 6925, 483},
	{0, 8, 3, 5, 6356, 428},
	{0, 8, 3, 6, 5597, 348},
	{0, 8, 3, 7, 4458, 252},
	{0, 8, 3, 8, 2277, 110},
	{0, 8, 2, 1, 6261, 536},
	{0, 8, 2, 2, 5565, 433},
	{0, 8, 2, 3, 5059, 402},
	{0, 8, 2, 4, 4617, 322},
	{0, 8, 2, 5, 4237, 285},
	{0, 8, 2, 6, 3731, 232},
	{0, 8, 2, 7, 2972, 168},
	{0, 8, 2, 8, 1518, 73},
	{0, 8, 1, 1, 3130, 268},
	{0, 8, 1, 2, 2783, 217},
	{0, 8, 1, 3, 2530, 201},
	{0, 8, 1, 4, 2308, 161},
	{0, 8, 1, 5, 2119, 143},
	{0, 8, 1, 6, 1866, 116},
	{0, 8, 1, 7, 1486, 84},
	{0, 8, 1, 8, 759, 37},
	{0, 8, 0, 1, 0, 0},
};

struct mt_cpu_power_tbl cpu_tlp8_power_tbl[] = {
	{4, 1, 4, 1, 35958, 5756},
	{4, 2, 4, 1, 31010, 4725},
	{4, 3, 4, 1, 29448, 4231},
	{4, 4, 4, 1, 27885, 3845},
	{4, 5, 4, 1, 26583, 3461},
	{4, 6, 4, 1, 25021, 3023},
	{4, 7, 4, 1, 22417, 2512},
	{4, 8, 4, 1, 17469, 1681},
	{3, 1, 4, 1, 30099, 4585},
	{3, 2, 4, 1, 26388, 3812},
	{3, 3, 4, 1, 25216, 3441},
	{3, 4, 4, 1, 24044, 3152},
	{3, 5, 4, 1, 23068, 2864},
	{3, 6, 4, 1, 21896, 2535},
	{3, 7, 4, 1, 19943, 2152},
	{3, 8, 4, 1, 16232, 1528},
	{2, 1, 4, 1, 24240, 3414},
	{2, 2, 4, 1, 21766, 2898},
	{2, 3, 4, 1, 20985, 2651},
	{2, 4, 4, 1, 20203, 2458},
	{2, 5, 4, 1, 19552, 2266},
	{2, 6, 4, 1, 18771, 2047},
	{2, 7, 4, 1, 17469, 1792},
	{2, 8, 4, 1, 14995, 1376},
	{1, 1, 4, 1, 18381, 2243},
	{1, 2, 4, 1, 17144, 1985},
	{1, 3, 4, 1, 16753, 1861},
	{1, 4, 4, 1, 16362, 1765},
	{1, 5, 4, 1, 16037, 1669},
	{1, 6, 4, 1, 15646, 1559},
	{1, 7, 4, 1, 14995, 1432},
	{1, 8, 4, 1, 13758, 1224},
	{0, 8, 4, 1, 12522, 1071},
	{0, 8, 4, 2, 11130, 867},
	{0, 8, 4, 3, 10118, 803},
	{0, 8, 4, 4, 9233, 643},
	{0, 8, 4, 5, 8474, 571},
	{0, 8, 4, 6, 7462, 463},
	{0, 8, 4, 7, 5945, 336},
	{0, 8, 4, 8, 3036, 147},
	{0, 8, 3, 1, 9391, 804},
	{0, 8, 3, 2, 8348, 650},
	{0, 8, 3, 3, 7589, 602},
	{0, 8, 3, 4, 6925, 483},
	{0, 8, 3, 5, 6356, 428},
	{0, 8, 3, 6, 5597, 348},
	{0, 8, 3, 7, 4458, 252},
	{0, 8, 3, 8, 2277, 110},
	{0, 8, 2, 1, 6261, 536},
	{0, 8, 2, 2, 5565, 433},
	{0, 8, 2, 3, 5059, 402},
	{0, 8, 2, 4, 4617, 322},
	{0, 8, 2, 5, 4237, 285},
	{0, 8, 2, 6, 3731, 232},
	{0, 8, 2, 7, 2972, 168},
	{0, 8, 2, 8, 1518, 73},
	{0, 8, 1, 1, 3130, 268},
	{0, 8, 1, 2, 2783, 217},
	{0, 8, 1, 3, 2530, 201},
	{0, 8, 1, 4, 2308, 161},
	{0, 8, 1, 5, 2119, 143},
	{0, 8, 1, 6, 1866, 116},
	{0, 8, 1, 7, 1486, 84},
	{0, 8, 1, 8, 759, 37},
	{0, 8, 0, 1, 0, 0},
};

static struct mt_cpu_tlp_power_info cpu_tlp_power_tbl[] = {
	[0]	= {
		.power_tbl = cpu_tlp1_power_tbl,
		.nr_power_table = sizeof(cpu_tlp1_power_tbl)/sizeof(struct mt_cpu_power_tbl) - 1,
	},

	[1] = {
		.power_tbl = cpu_tlp2_power_tbl,
		.nr_power_table = sizeof(cpu_tlp2_power_tbl)/sizeof(struct mt_cpu_power_tbl) - 1,
	},

	[2] = {
		.power_tbl = cpu_tlp3_power_tbl,
		.nr_power_table = sizeof(cpu_tlp3_power_tbl)/sizeof(struct mt_cpu_power_tbl) - 1,
	},

	[3] = {
		.power_tbl = cpu_tlp4_power_tbl,
		.nr_power_table = sizeof(cpu_tlp4_power_tbl)/sizeof(struct mt_cpu_power_tbl) - 1,
	},

	[4] = {
		.power_tbl = cpu_tlp5_power_tbl,
		.nr_power_table = sizeof(cpu_tlp5_power_tbl)/sizeof(struct mt_cpu_power_tbl) - 1,
	},

	[5] = {
		.power_tbl = cpu_tlp6_power_tbl,
		.nr_power_table = sizeof(cpu_tlp6_power_tbl)/sizeof(struct mt_cpu_power_tbl) - 1,
	},

	[6] = {
		.power_tbl = cpu_tlp7_power_tbl,
		.nr_power_table = sizeof(cpu_tlp7_power_tbl)/sizeof(struct mt_cpu_power_tbl) - 1,
	},

	[7] = {
		.power_tbl = cpu_tlp8_power_tbl,
		.nr_power_table = sizeof(cpu_tlp8_power_tbl)/sizeof(struct mt_cpu_power_tbl) - 1,
	},
};

#undef CPUFREQ_EXTERN

#ifdef __cplusplus
}
#endif

struct mt_cpu_tlp_power_info *get_cpu_tlp_power_tbl(void) {
    return cpu_tlp_power_tbl;
}

/*
 * Module driver
 */
static int __init _mt_cpufreq_tlp_init(void)
{
	int ret = 0;

	FUNC_ENTER();

	FUNC_EXIT();

	return ret;
}

static void __exit _mt_cpufreq_tlp_exit(void)
{
	FUNC_ENTER();

	FUNC_EXIT();
}

module_init(_mt_cpufreq_tlp_init);
module_exit(_mt_cpufreq_tlp_exit);

MODULE_DESCRIPTION("MediaTek CPU DVFS TLB Driver v0.1");
MODULE_LICENSE("GPL");

#endif // __MT_CPUFREQ_TLP_C__
