#ifndef _CAMERA_CUSTOM_HDR_H_
#define _CAMERA_CUSTOM_HDR_H_

#include "camera_custom_types.h"	// For MUINT*/MINT*/MVOID/MBOOL type definitions.

#define CUST_HDR_DEBUG          0   // Enable this will dump HDR Debug Information into SDCARD
#define HDR_DEBUG_OUTPUT_FOLDER		"/storage/sdcard0/"	// For ALPS.JB.
/**************************************************************************
 *                      D E F I N E S / M A C R O S                       *
 **************************************************************************/
// For HDR Customer Parameters

// [capture policy]
//     - When CUST_HDR_CAPTURE_POLICY==0,
//          The capture size of each frame will be as same as the HDR output image size.
//          If no special reason (ex. memory issues), this one will be a good choise.
//     - When CUST_HDR_CAPTURE_POLICY==1,
//          Use the sensor size as the maximum frame size.
//          The HDR result will be scaled up to fit JPEG size later.
//          This option can save memory when capture size is larger than sensor size.
//          But the cost is a HDR with worse quality.
#define CUST_HDR_CAPTURE_POLICY	0

// [Core Number]
//     - Value Range: 1(For single-core)/2(For multi-core).
#define CUST_HDR_CORE_NUMBER	2

// 
/*        [Capture Algorithm]
u4AOEMode==1 : Dynamic EV Bracket
     - Use histogram 0~40 Avg to calculate LE.
        And by DeltaEV + SE_OFFSET to calculate SE.
        if LE-SE > than EVDIFFTH
           use LE, (LE+SE)/2, SE
        else
           use LE + SE
u4AOEMode==0 : Static EV Bracket

     - When CUST_HDR_CAPTURE_ALGORITHM==1,
          If original Image (0EV) needs to be saved. we use 1.
	      If there is less than HDR_NEOverExp_Percent/1000 pixels
          over saturation in 0EV, we capture +1.5/0 EV 2  frames, else we take +1.5/0/-2 EV 3 frames.
     - When CUST_HDR_CAPTURE_ALGORITHM==2,
          If original Image (0EV) needs not to be saved. we use 2.
	      If there is less than HDR_NEOverExp_Percent/1000 pixels
          over saturation in 0EV, we capture +1.5/-1 EV 2  frames, else we take +1.5/0/-2 EV 3 frames.
*/

//u4AOEMode==0 : Static EV Bracket Parameters
#define CUST_HDR_CAPTURE_ALGORITHM   2
#define CUST_HDR_NEOverExp_Percent   10

//u4AOEMode==1 : Dynamic EV Bracket Parameters
#define SE_HIST_BIN_NUM 20
#define INTENSITY_TARGET 1.7f
#define NE_AOE_GAIN 0.84f // -0.25EV
#define SE_OFFSET 0.5f
#define EVDIFFTH 3.0f
#define MAX_LE_EV 2.5f

// [Prolonged VD]
//     - Value Range: 1(default)~ (depend on sensor characteristics).
#define CUST_HDR_PROLONGED_VD	1

// [BRatio]
//     - Higher value:
//         - Decrease the degree of artifact (halo-like around object boundary).
//         - Avoid non-continued edge in fusion result.
//         - Decrease little dynamic range.
//         - Decrease sharpness.
//     - Value Range: 1 (non-blur) ~ 160. (Default: 40).
#define CUST_HDR_BRATIO		40

// [Gain]
//     - Higher value increase sharpness, but also increase noise.
//     - Value Range: 256 ~ 512. (Default: 256 (1x gain)) (384/256 = 1.5x gain)
#define CUST_HDR_GAIN_00	256//384 //lenovo-sw sunliang modify 2014_8_22
#define CUST_HDR_GAIN_01	256//384//lenovo-sw sunliang modify 2014_8_22
#define CUST_HDR_GAIN_02	256//384//lenovo-sw sunliang modify 2014_8_22
#define CUST_HDR_GAIN_03	256
#define CUST_HDR_GAIN_04	256
#define CUST_HDR_GAIN_05	256
#define CUST_HDR_GAIN_06	256
#define CUST_HDR_GAIN_07	256
#define CUST_HDR_GAIN_08	256
#define CUST_HDR_GAIN_09	256
#define CUST_HDR_GAIN_10	256

// [F Control]
//     -Higher value decreases the degree of flare, but also decrease parts of the image details.
//     - Value Range: 0 ~ 50. (Default: 10)
#define CUST_HDR_BOTTOM_FRATIO		10
//     - Value Range: 0 ~ 50. (Default: 10)
#define CUST_HDR_TOP_FRATIO		10
//     - Value Range: 0 ~ 24. (Default: 16)
#define CUST_HDR_BOTTOM_FBOUND		16
//     - Value Range: 0 ~ 24. (Default: 16)
#define CUST_HDR_TOP_FBOUND		16

// [De-halo Control]
//     - Higher value reduce more halo for sky, but also reduce more dynamic range in some parts of the image.
//     - Value Range: 0 (off) ~ 255. (Default: 245)
#define CUST_HDR_TH_HIGH				245

// [Noise Control]
//     - Higher value reduce more noise, but also reduce dynamic range in low light region.
//     - Value Range: 0 (off) ~ 255. (Default: 25)
#define CUST_HDR_TH_LOW					0

// [Level Subtract]
//     - Value Range: 0 (less low-frequency halo, less dynamic range) or 1 (more low-frequency halo, more dynamic range). (Default: 0)
#define CUST_HDR_TARGET_LEVEL_SUB		0


/**************************************************************************
 *     E N U M / S T R U C T / T Y P E D E F    D E C L A R A T I O N     *
 **************************************************************************/

/**************************************************************************
 *                 E X T E R N A L    R E F E R E N C E S                 *
 **************************************************************************/

/**************************************************************************
 *        P U B L I C    F U N C T I O N    D E C L A R A T I O N         *
 **************************************************************************/
MUINT32 CustomHdrCoreNumberGet(void);
MUINT32 CustomHdrProlongedVdGet(void);
MUINT32 CustomHdrBRatioGet(void);
MUINT32 CustomHdrGainArrayGet(MUINT32 u4ArrayIndex);
double CustomHdrBottomFRatioGet(void);
double CustomHdrTopFRatioGet(void);
MUINT32 CustomHdrBottomFBoundGet(void);
MUINT32 CustomHdrTopFBoundGet(void);
MINT32 CustomHdrThHighGet(void);
MINT32 CustomHdrThLowGet(void);
MUINT32 CustomHdrTargetLevelSubGet(void);

/*******************************************************************************
* HDR exposure setting
*******************************************************************************/
typedef struct HDRExpSettingInputParam_S
{
	MINT32 u4AOEMode;
    MUINT32 u4MaxSensorAnalogGain; // 1x=1024
    MUINT32 u4MaxAEExpTimeInUS;    // unit: us
    MUINT32 u4MinAEExpTimeInUS;     // unit: us
    MUINT32 u4ShutterLineTime;    // unit: 1/1000 us
    MUINT32 u4MaxAESensorGain;     // 1x=1024
    MUINT32 u4MinAESensorGain;     // 1x=1024
    MUINT32 u4ExpTimeInUS0EV;      // unit: us
    MUINT32 u4SensorGain0EV;       // 1x=1024
    MUINT8  u1FlareOffset0EV;
	MINT32 	i4GainBase0EV;		// AOE application for LE calculation
	MINT32 	i4LE_LowAvg;		// AOE application for LE calculation, def: 0 ~ 39 avg
	MINT32 	i4SEDeltaEVx100;	// AOE application for SE calculation
    MUINT32 u4Histogram[128];
} HDRExpSettingInputParam_T;

typedef struct HDRExpSettingOutputParam_S
{
    MUINT32 u4OutputFrameNum;     // Output frame number (2 or 3)
    MUINT32 u4ExpTimeInUS[3];     // unit: us; [0]-> short exposure; [1]: 0EV; [2]: long exposure
    MUINT32 u4SensorGain[3];      // 1x=1204; [0]-> short exposure; [1]: 0EV; [2]: long exposure
    MUINT8  u1FlareOffset[3];     // [0]-> short exposure; [1]: 0EV; [2]: long exposure
    MUINT32 u4FinalGainDiff[2];   // 1x=1024; [0]: Between short exposure and 0EV; [1]: Between 0EV and long exposure
    MUINT32 u4TargetTone; //Decide the curve to decide target tone
} HDRExpSettingOutputParam_T;

MVOID getHDRExpSetting(const HDRExpSettingInputParam_T& rInput, HDRExpSettingOutputParam_T& rOutput);

/**************************************************************************
 *                   C L A S S    D E C L A R A T I O N                   *
 **************************************************************************/




#endif	// _CAMERA_CUSTOM_HDR_H_

