#ifndef _CUST_BATTERY_METER_TABLE_H
#define _CUST_BATTERY_METER_TABLE_H

#include <mach/mt_typedefs.h>

// ============================================================
// define
// ============================================================
#define BAT_NTC_10 1
#define BAT_NTC_47 0

#if (BAT_NTC_10 == 1)
#define RBAT_PULL_UP_R             24000	
#endif

#if (BAT_NTC_47 == 1)
#define RBAT_PULL_UP_R             61900	
#endif

#define RBAT_PULL_UP_VOLT          2800



// ============================================================
// ENUM
// ============================================================

// ============================================================
// structure
// ============================================================

// ============================================================
// typedef
// ============================================================
typedef struct _BATTERY_PROFILE_STRUC
{
    kal_int32 percentage;
    kal_int32 voltage;
} BATTERY_PROFILE_STRUC, *BATTERY_PROFILE_STRUC_P;

typedef struct _R_PROFILE_STRUC
{
    kal_int32 resistance; // Ohm
    kal_int32 voltage;
} R_PROFILE_STRUC, *R_PROFILE_STRUC_P;

typedef enum
{
    T1_0C,
    T2_25C,
    T3_50C
} PROFILE_TEMPERATURE;

// ============================================================
// External Variables
// ============================================================

// ============================================================
// External function
// ============================================================

// ============================================================
// <DOD, Battery_Voltage> Table
// ============================================================
#if (BAT_NTC_10 == 1)
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
        {-20,68237},
        {-15,53650},
        {-10,42506},
        { -5,33892},
        {  0,27219},
        {  5,22021},
        { 10,17926},
        { 15,14674},
        { 20,12081},
        { 25,10000},
        { 30,8315},
        { 35,6948},
        { 40,5834},
        { 45,4917},
        { 50,4161},
        { 55,3535},
        { 60,3014}
    };
#endif

#if (BAT_NTC_47 == 1)
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
        {-20,483954},
        {-15,360850},
        {-10,271697},
        { -5,206463},
        {  0,158214},
        {  5,122259},
        { 10,95227},
        { 15,74730},
        { 20,59065},
        { 25,47000},
        { 30,37643},
        { 35,30334},
        { 40,24591},
        { 45,20048},
        { 50,16433},
        { 55,13539},
        { 60,11210}        
    };
#endif

// T0 -10C
BATTERY_PROFILE_STRUC battery_profile_t0[] =
{
	{0   , 4299},         
	{1   , 4273},         
	{2   , 4244},         
	{3   , 4219},         
	{5   , 4202},         
	{6   , 4187},         
	{7   , 4173},         
	{8   , 4161},         
	{9   , 4152},         
	{10  , 4139},         
	{11  , 4129},         
	{12  , 4118},         
	{14  , 4109},         
	{15  , 4097},         
	{16  , 4088},         
	{17  , 4080},         
	{18  , 4073},         
	{19  , 4062},         
	{20  , 4051},         
	{21  , 4038},         
	{23  , 4024},         
	{24  , 4010},         
	{25  , 4000},         
	{26  , 3989},         
	{27  , 3981},         
	{28  , 3973},         
	{29  , 3966},         
	{31  , 3957},         
	{32  , 3949},         
	{33  , 3938},         
	{34  , 3928},         
	{35  , 3919},         
	{36  , 3908},         
	{37  , 3900},         
	{38  , 3892},         
	{40  , 3883},         
	{41  , 3875},         
	{42  , 3867},         
	{43  , 3862},         
	{44  , 3855},         
	{45  , 3849},         
	{46  , 3845},         
	{47  , 3840},         
	{49  , 3835},         
	{50  , 3829},         
	{51  , 3826},         
	{52  , 3822},         
	{53  , 3817},         
	{54  , 3813},         
	{55  , 3810},         
	{56  , 3807},         
	{58  , 3804},         
	{59  , 3801},         
	{60  , 3797},         
	{61  , 3796},         
	{62  , 3792},         
	{63  , 3791},         
	{64  , 3789},         
	{65  , 3787},         
	{67  , 3784},         
	{68  , 3784},          
  {69  , 3780},
  {70  , 3779},
  {71  , 3775},
  {72  , 3773},
  {73  , 3770},
  {75  , 3766},
  {76  , 3762},
  {77  , 3758},
  {78  , 3752},
	{79  , 3745}, 
	{80  , 3739},
	{81  , 3732},
	{82  , 3724},
	{84  , 3716},
	{85  , 3711}, 
	{86  , 3707},
	{87  , 3704},
	{88  , 3701},
	{89  , 3698},
	{90  , 3696},
	{91  , 3693},
	{93  , 3690},
	{94  , 3681},
	{95  , 3660},
	{96  , 3621},
	{97  , 3564},
	{98  , 3504},
	{99  , 3472},
	{99  , 3454},
	{99  , 3440},
	{100 , 3424},
	{100 , 3408},
	{100 , 3386},
	{100 , 3363},
	{100 , 3341},
	{100 , 3322},
	{100 , 3302},
	{100 , 3287},
	{100 , 3270}	       
};      
        
// T1 0C 
BATTERY_PROFILE_STRUC battery_profile_t1[] =
{
	{0   ,4308},         
	{1   ,4286},         
	{2   ,4268},         
	{3   ,4256},         
	{4   ,4242},         
	{5   ,4230},         
	{6   ,4217},         
	{8   ,4207},         
	{9   ,4196},         
	{10  ,4184},         
	{11  ,4174},         
	{12  ,4163},         
	{13  ,4152},         
	{14  ,4142},         
	{15  ,4130},         
	{16  ,4121},         
	{17  ,4111},         
	{18  ,4100},         
	{19  ,4089},         
	{20  ,4082},         
	{21  ,4073},         
	{22  ,4065},         
	{24  ,4054},         
	{25  ,4043},         
	{26  ,4031},         
	{27  ,4018},         
	{28  ,4008},         
	{29  ,3998},         
	{30  ,3992},         
	{31  ,3984},         
	{32  ,3976},         
	{33  ,3967},         
	{34  ,3958},         
	{35  ,3950},         
	{36  ,3940},         
	{37  ,3930},         
	{39  ,3920},         
	{40  ,3909},         
	{41  ,3899},         
	{42  ,3890},         
	{43  ,3881},         
	{44  ,3874},         
	{45  ,3866},         
	{46  ,3859},         
	{47  ,3855},         
	{48  ,3849},         
	{49  ,3843},         
	{50  ,3839},         
	{51  ,3834},         
	{53  ,3830},         
	{54  ,3826},         
	{55  ,3821},         
	{56  ,3817},         
	{57  ,3814},         
	{58  ,3811},         
	{59  ,3807},         
	{60  ,3805},         
	{61  ,3802},         
  {62  ,3798},
	{63  ,3796},         
	{64  ,3792},          
  {65  ,3790},
  {66  ,3787},
  {67  ,3786},
  {69  ,3784},
  {70  ,3783},
  {71  ,3779},
  {72  ,3779},
  {73  ,3777},
  {74  ,3775},
	{75  ,3771}, 
	{76  ,3769},
	{77  ,3764},
	{78  ,3761},
	{79  ,3756},
	{80  ,3750},
	{81  ,3742},
	{82  ,3733},
	{84  ,3723},
	{85  ,3713},
	{86  ,3706},
	{87  ,3703},
	{88  ,3700},
	{89  ,3699},
	{90  ,3697},
	{91  ,3694},
	{92  ,3693},
	{93  ,3691},
	{94  ,3685},
	{95  ,3663},
	{96  ,3618},
	{98  ,3556},
	{99  ,3485},
	{100 ,3435},
	{100 ,3330},
	{100 ,3263},
	{100 ,3219},
	{100 ,3185},
	{100 ,3155}, 
	{100 ,3127}	       
};           

// T2 25C
BATTERY_PROFILE_STRUC battery_profile_t2[] =
{
	{0   , 4334},         
	{1   , 4320},         
	{2   , 4305},         
	{3   , 4293},         
	{4   , 4281},         
	{5   , 4268},         
	{6   , 4258},         
	{7   , 4245},         
	{8   , 4235},         
	{9   , 4222},         
	{10  , 4212},         
	{11  , 4201},         
	{12  , 4190},         
	{13  , 4178},         
	{14  , 4168},         
	{15  , 4156},         
	{16  , 4147},         
	{17  , 4135},         
	{18  , 4125},         
	{19  , 4116},         
	{20  , 4103},         
	{21  , 4094},         
	{22  , 4084},         
	{23  , 4074},         
	{24  , 4064},         
	{26  , 4056},         
	{27  , 4046},         
	{28  , 4037},         
	{29  , 4028},         
	{30  , 4019},         
	{31  , 4009},         
	{32  , 4001},         
	{33  , 3993},         
	{34  , 3986},         
	{35  , 3976},         
	{36  , 3968},         
	{37  , 3961},         
	{38  , 3953},         
	{39  , 3944},         
	{40  , 3935},         
	{41  , 3925},         
	{42  , 3914},         
	{43  , 3904},         
	{44  , 3895},         
	{45  , 3886},         
	{46  , 3877},         
	{47  , 3868},         
	{48  , 3861},         
	{49  , 3855},         
	{50  , 3851},         
	{51  , 3845},         
	{52  , 3840},         
	{53  , 3835},         
	{54  , 3830},         
	{55  , 3827},         
	{56  , 3823},         
	{57  , 3818},         
	{58  , 3814},         
	{59  , 3810},         
	{60  , 3807},         
	{61  , 3805},          
  {62  , 3800},
  {63  , 3797},
  {64  , 3794},
  {65  , 3793},
  {66  , 3788},
  {67  , 3787},
  {68  , 3783},
  {69  , 3781},
  {70  , 3779},
	{71  , 3776}, 
	{72  , 3773},
	{73  , 3769},
	{74  , 3767},
	{75  , 3764},
	{77  , 3759},
	{78  , 3754},
	{79  , 3749},
	{80  , 3745},
	{81  , 3738},
	{82  , 3730},
	{83  , 3722},
	{84  , 3713},
	{85  , 3703},
	{86  , 3695},
	{87  , 3691},
	{88  , 3690},
	{89  , 3689},
	{90  , 3688},
	{91  , 3689},
	{92  , 3686},
	{93  , 3684},
	{94  , 3677},
	{95  , 3651},
	{96  , 3617},
	{97  , 3570},
	{98  , 3513},
	{99  , 3471},
	{100 , 3406},
	{100 , 3280}	       
};     

// T3 50C
BATTERY_PROFILE_STRUC battery_profile_t3[] =
{
	{0   , 4342},         
	{1   , 4326},         
	{2   , 4313},         
	{3   , 4301},         
	{4   , 4287},         
	{5   , 4276},         
	{6   , 4263},         
	{7   , 4252},         
	{8   , 4239},         
	{9   , 4229},         
	{10  , 4216},         
	{11  , 4206},         
	{12  , 4196},         
	{13  , 4184},         
	{14  , 4174},         
	{15  , 4161},         
	{16  , 4152},         
	{17  , 4140},         
	{18  , 4129},         
	{19  , 4119},         
	{21  , 4108},         
	{22  , 4098},         
	{23  , 4089},         
	{24  , 4079},         
	{25  , 4069},         
	{26  , 4058},         
	{27  , 4051},         
	{28  , 4041},         
	{29  , 4031},         
	{30  , 4022},         
	{31  , 4013},         
	{32  , 4004},         
	{33  , 3997},         
	{34  , 3988},         
	{35  , 3980},         
	{36  , 3972},         
	{37  , 3964},         
	{38  , 3956},         
	{39  , 3947},         
	{40  , 3939},         
	{41  , 3929},         
	{42  , 3919},         
	{43  , 3912},         
	{44  , 3901},         
	{45  , 3891},         
	{46  , 3881},         
	{47  , 3872},         
	{48  , 3865},         
	{49  , 3858},         
	{50  , 3853},         
	{51  , 3846},         
	{52  , 3844},         
	{53  , 3836},         
	{54  , 3833},         
	{55  , 3827},         
	{56  , 3824},         
	{57  , 3819},         
	{58  , 3816},         
	{60  , 3810},         
	{61  , 3807},         
	{62  , 3803},          
  {63  , 3800},
  {64  , 3797},
  {65  , 3793},
  {66  , 3790},
  {67  , 3788},
  {68  , 3783},
  {69  , 3782},
  {70  , 3775},
  {71  , 3771},
	{72  , 3763}, 
	{73  , 3758},
	{74  , 3755},
	{75  , 3750},
	{76  , 3747},
	{77  , 3742},
	{78  , 3737},
	{79  , 3732},
	{80  , 3727},
	{81  , 3721},
	{82  , 3716},
	{83  , 3705},
	{84  , 3697},
	{85  , 3687},
	{86  , 3678},
	{87  , 3675},
	{88  , 3676},
	{89  , 3675},
	{90  , 3673},
	{91  , 3673},
	{92  , 3672},
	{93  , 3668},
	{94  , 3656},
	{95  , 3626},
	{96  , 3582},
	{98  , 3526},
	{99  , 3483},
	{100 , 3441},
	{100 , 3346},
	{100 , 3174}	       
};           

// battery profile for actual temperature. The size should be the same as T1, T2 and T3
BATTERY_PROFILE_STRUC battery_profile_temperature[] =
{
  {0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },  
	{0  , 0 }, 
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },  
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 }
};    

// ============================================================
// <Rbat, Battery_Voltage> Table
// ============================================================
// T0 -10C
R_PROFILE_STRUC r_profile_t0[] =
{
	{450  ,4299},         
	{450  ,4273},         
	{473  ,4244},         
	{485  ,4219},         
	{520  ,4202},         
	{533  ,4187},         
	{535  ,4173},         
	{540  ,4161},         
	{550  ,4152},         
	{540  ,4139},         
	{573  ,4129},         
	{563  ,4118},         
	{573  ,4109},         
	{578  ,4097},         
	{575  ,4088},         
	{603  ,4080},         
	{595  ,4073},         
	{618  ,4062},         
	{623  ,4051},         
	{605  ,4038},         
	{630  ,4024},         
	{628  ,4010},         
	{625  ,4000},         
	{628  ,3989},         
	{655  ,3981},         
	{633  ,3973},         
	{663  ,3966},         
	{643  ,3957},         
	{643  ,3949},         
	{668  ,3938},         
	{648  ,3928},         
	{640  ,3919},         
	{648  ,3908},         
	{643  ,3900},         
	{653  ,3892},         
	{660  ,3883},         
	{645  ,3875},         
	{670  ,3867},         
	{665  ,3862},         
	{668  ,3855},         
	{685  ,3849},         
	{680  ,3845},         
	{708  ,3840},         
	{705  ,3835},         
	{725  ,3829},         
	{740  ,3826},         
	{740  ,3822},         
	{740  ,3817},         
	{765  ,3813},         
	{773  ,3810},         
	{768  ,3807},         
	{808  ,3804},         
	{810  ,3801},         
	{808  ,3797},         
	{815  ,3796},         
	{828  ,3792},         
	{873  ,3791},         
	{883  ,3789},         
	{878  ,3787},         
	{888  ,3784},         
	{923  ,3784},          
  {920  ,3780},
  {933  ,3779},
  {935  ,3775},
  {963  ,3773},
  {985  ,3770},
  {1000 ,3766},
  {1015 ,3762},
  {1023 ,3758},
  {1028 ,3752},
	{1038 ,3745}, 
	{1068 ,3739},
	{1083 ,3732},
	{1090 ,3724},
	{1103 ,3716},
	{1143 ,3711},
	{1163 ,3707},
	{1173 ,3704},
	{1200 ,3701},
	{1255 ,3698},
	{1278 ,3696},
	{1358 ,3693},
	{1428 ,3690},
	{1480 ,3681},
	{1540 ,3660},
	{1608 ,3621},
	{1708 ,3564},
	{1765 ,3504},
	{1683 ,3472},
	{1635 ,3454},
	{1610 ,3440},
	{1568 ,3424},
	{1520 ,3408},
	{1470 ,3386},
	{1423 ,3363},
	{1368 ,3341},
	{1325 ,3322},
	{1275 ,3302},
	{1220 ,3287}, 
	{1185 ,3270}	       
};      

// T1 0C
R_PROFILE_STRUC r_profile_t1[] =
{
	{270  , 4308},         
	{270  , 4286},         
	{270  , 4268},         
	{278  , 4256},         
	{278  , 4242},         
	{275  , 4230},         
	{275  , 4217},         
	{283  , 4207},         
	{288  , 4196},         
	{288  , 4184},         
	{295  , 4174},         
	{300  , 4163},         
	{303  , 4152},         
	{308  , 4142},         
	{305  , 4130},         
	{313  , 4121},         
	{323  , 4111},         
	{320  , 4100},         
	{318  , 4089},         
	{328  , 4082},         
	{338  , 4073},         
	{340  , 4065},         
	{340  , 4054},         
	{343  , 4043},         
	{353  , 4031},         
	{350  , 4018},         
	{353  , 4008},         
	{350  , 3998},         
	{360  , 3992},         
	{363  , 3984},         
	{365  , 3976},         
	{358  , 3967},         
	{358  , 3958},         
	{360  , 3950},         
	{360  , 3940},         
	{358  , 3930},         
	{353  , 3920},         
	{350  , 3909},         
	{343  , 3899},         
	{340  , 3890},         
	{338  , 3881},         
	{338  , 3874},         
	{338  , 3866},         
	{338  , 3859},         
	{343  , 3855},         
	{345  , 3849},         
	{350  , 3843},         
	{355  , 3839},         
	{360  , 3834},         
	{365  , 3830},         
	{375  , 3826},         
	{375  , 3821},         
	{380  , 3817},         
	{390  , 3814},         
	{398  , 3811},         
	{405  , 3807},         
	{418  , 3805},         
	{425  , 3802},         
	{423  , 3798},         
	{435  , 3796},         
	{438  , 3792},          
  {455  , 3790},
  {450  , 3787},
  {460  , 3786},
  {478  , 3784},
  {478  , 3783},
  {488  , 3779},
  {495  , 3779},
  {500  , 3777},
  {513  , 3775},
	{515  , 3771}, 
	{518  , 3769},
	{525  , 3764},
	{543  , 3761},
	{553  , 3756},
	{548  , 3750},
	{565  , 3742},
	{570  , 3733},
	{570  , 3723},
	{585  , 3713},
	{583  , 3706},
	{600  , 3703},
	{615  , 3700},
	{620  , 3699},
	{648  , 3697},
	{668  , 3694},
	{688  , 3693},
	{730  , 3691},
	{778  , 3685},
	{785  , 3663},
	{823  , 3618},
	{865  , 3556},
	{963  , 3485},
	{1128 , 3435},
	{1325 , 3330},
	{1160 , 3263},
	{1065 , 3219},
	{990  , 3185},
	{918  , 3155}, 
	{865  , 3127}	       
};     

// T2 25C
R_PROFILE_STRUC r_profile_t2[] =
{
	{108  , 4334},         
	{108  , 4320},         
	{100  , 4305},         
	{103  , 4293},         
	{108  , 4281},         
	{103  , 4268},         
	{108  , 4258},         
	{108  , 4245},         
	{113  , 4235},         
	{110  , 4222},         
	{113  , 4212},         
	{118  , 4201},         
	{118  , 4190},         
	{113  , 4178},         
	{118  , 4168},         
	{118  , 4156},         
	{123  , 4147},         
	{120  , 4135},         
	{120  , 4125},         
	{128  , 4116},         
	{120  , 4103},         
	{125  , 4094},         
	{125  , 4084},         
	{128  , 4074},         
	{130  , 4064},         
	{135  , 4056},         
	{133  , 4046},         
	{138  , 4037},         
	{140  , 4028},         
	{143  , 4019},         
	{143  , 4009},         
	{145  , 4001},         
	{145  , 3993},         
	{155  , 3986},         
	{155  , 3976},         
	{155  , 3968},         
	{158  , 3961},         
	{158  , 3953},         
	{155  , 3944},         
	{155  , 3935},         
	{150  , 3925},         
	{140  , 3914},         
	{138  , 3904},         
	{130  , 3895},         
	{125  , 3886},         
	{120  , 3877},         
	{113  , 3868},         
	{110  , 3861},         
	{110  , 3855},         
	{118  , 3851},         
	{115  , 3845},         
	{113  , 3840},         
	{115  , 3835},         
	{110  , 3830},         
	{118  , 3827},         
	{120  , 3823},         
	{118  , 3818},         
	{118  , 3814},         
	{118  , 3810},         
	{120  , 3807},         
	{123  , 3805},          
  {115  , 3800},
  {120  , 3797},
  {120  , 3794},
  {125  , 3793},
  {120  , 3788},
  {125  , 3787},
  {125  , 3783},
  {128  , 3781},
  {125  , 3779},
	{128  , 3776}, 
	{125  , 3773},
	{125  , 3769},
	{125  , 3767},
	{125  , 3764},
	{125  , 3759},
	{120  , 3754},
	{123  , 3749},
	{125  , 3745},
	{120  , 3738},
	{123  , 3730},
	{123  , 3722},
	{123  , 3713},
	{125  , 3703},
	{123  , 3695},
	{120  , 3691},
	{118  , 3690},
	{120  , 3689},
	{123  , 3688},
	{133  , 3689},
	{138  , 3686},
	{140  , 3684},
	{150  , 3677},
	{148  , 3651},
	{158  , 3617},
	{165  , 3570},
	{180  , 3513},
	{233  , 3471},
	{243  , 3406}, 
	{315  , 3280}	       
}; 

// T3 50C
R_PROFILE_STRUC r_profile_t3[] =
{
	{0    , 4342},         
	{1    , 4326},         
	{2    , 4313},         
	{3    , 4301},         
	{4    , 4287},         
	{5    , 4276},         
	{6    , 4263},         
	{7    , 4252},         
	{8    , 4239},         
	{9    , 4229},         
	{10   , 4216},         
	{11   , 4206},         
	{12   , 4196},         
	{13   , 4184},         
	{14   , 4174},         
	{15   , 4161},         
	{16   , 4152},         
	{17   , 4140},         
	{18   , 4129},         
	{19   , 4119},         
	{21   , 4108},         
	{22   , 4098},         
	{23   , 4089},         
	{24   , 4079},         
	{25   , 4069},         
	{26   , 4058},         
	{27   , 4051},         
	{28   , 4041},         
	{29   , 4031},         
	{30   , 4022},         
	{31   , 4013},         
	{32   , 4004},         
	{33   , 3997},         
	{34   , 3988},         
	{35   , 3980},         
	{36   , 3972},         
	{37   , 3964},         
	{38   , 3956},         
	{39   , 3947},         
	{40   , 3939},         
	{41   , 3929},         
	{42   , 3919},         
	{43   , 3912},         
	{44   , 3901},         
	{45   , 3891},         
	{46   , 3881},         
	{47   , 3872},         
	{48   , 3865},         
	{49   , 3858},         
	{50   , 3853},         
	{51   , 3846},         
	{52   , 3844},         
	{53   , 3836},         
	{54   , 3833},         
	{55   , 3827},         
	{56   , 3824},         
	{57   , 3819},         
	{58   , 3816},         
	{60   , 3810},         
	{61   , 3807},         
	{62   , 3803},          
  {63   , 3800},
  {64   , 3797},
  {65   , 3793},
  {66   , 3790},
  {67   , 3788},
  {68   , 3783},
  {69   , 3782},
  {70   , 3775},
  {71   , 3771},
	{72   , 3763}, 
	{73   , 3758},
	{74   , 3755},
	{75   , 3750},
	{76   , 3747},
	{77   , 3742},
	{78   , 3737},
	{79   , 3732},
	{80   , 3727},
	{81   , 3721},
	{82   , 3716},
	{83   , 3705},
	{84   , 3697},
	{85   , 3687},
	{86   , 3678},
	{87   , 3675},
	{88   , 3676},
	{89   , 3675},
	{90   , 3673},
	{91   , 3673},
	{92   , 3672},
	{93   , 3668},
	{94   , 3656},
	{95   , 3626},
	{96   , 3582},
	{98   , 3526},
	{99   , 3483},
	{100  , 3441},
	{100  , 3346}, 
	{100  , 3174}	       
}; 

// r-table profile for actual temperature. The size should be the same as T1, T2 and T3
R_PROFILE_STRUC r_profile_temperature[] =
{
  {0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },  
	{0  , 0 }, 
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },  
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 }
};    

// ============================================================
// function prototype
// ============================================================
int fgauge_get_saddles(void);
BATTERY_PROFILE_STRUC_P fgauge_get_profile(kal_uint32 temperature);

int fgauge_get_saddles_r_table(void);
R_PROFILE_STRUC_P fgauge_get_profile_r_table(kal_uint32 temperature);

#endif	//#ifndef _CUST_BATTERY_METER_TABLE_H

