#ifndef _CFG_ISP_TUNING_IDX_PREVIEW_H_
#define _CFG_ISP_TUNING_IDX_PREVIEW_H_

#include <mtkcam/metadata/mtk_metadata_tag.h>

#define PREVIEW_SCENE_MODE_CONFIG(sensor, scene)\
    IDX_MODE_Preview(sensor, scene, eIDX_ISO_100)\
    IdxSet<EIspProfile_Preview, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100>::idx;\
    IDX_MODE_Preview(sensor, scene, eIDX_ISO_200)\
    IdxSet<EIspProfile_Preview, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200>::idx;\
    IDX_MODE_Preview(sensor, scene, eIDX_ISO_400)\
    IdxSet<EIspProfile_Preview, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400>::idx;\
    IDX_MODE_Preview(sensor, scene, eIDX_ISO_800)\
    IdxSet<EIspProfile_Preview, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800>::idx;\
    IDX_MODE_Preview(sensor, scene, eIDX_ISO_1200)\
    IdxSet<EIspProfile_Preview, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200>::idx;\
    IDX_MODE_Preview(sensor, scene, eIDX_ISO_1600)\
    IdxSet<EIspProfile_Preview, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600>::idx;\
    IDX_MODE_Preview(sensor, scene, eIDX_ISO_2000)\
    IdxSet<EIspProfile_Preview, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000>::idx;\
    IDX_MODE_Preview(sensor, scene, eIDX_ISO_2400)\
    IdxSet<EIspProfile_Preview, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400>::idx;\
    IDX_MODE_Preview(sensor, scene, eIDX_ISO_2800)\
    IdxSet<EIspProfile_Preview, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800>::idx;\
    IDX_MODE_Preview(sensor, scene, eIDX_ISO_3200)\
    IdxSet<EIspProfile_Preview, sensor, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200>::idx;\

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Preview> <Sensor Mode: Preview>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Preview( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:0, BPC:0, NR1:0, CFA:0, GGM:0, ANR:0, CCR:0, EE:0, NR3D:0, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Preview( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:0, BPC:1, NR1:1, CFA:1, GGM:0, ANR:1, CCR:1, EE:1, NR3D:1, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Preview( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:0, BPC:1, NR1:1, CFA:2, GGM:0, ANR:2, CCR:2, EE:2, NR3D:2, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Preview( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:1, BPC:2, NR1:2, CFA:3, GGM:0, ANR:3, CCR:3, EE:3, NR3D:3, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Preview( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:1, BPC:2, NR1:2, CFA:4, GGM:0, ANR:4, CCR:4, EE:4, NR3D:4, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Preview( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:1, BPC:2, NR1:2, CFA:5, GGM:0, ANR:5, CCR:5, EE:5, NR3D:5, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Preview( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:1, BPC:2, NR1:2, CFA:6, GGM:0, ANR:6, CCR:6, EE:6, NR3D:6, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Preview( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:1, BPC:2, NR1:2, CFA:7, GGM:0, ANR:7, CCR:7, EE:7, NR3D:7, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Preview( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:1, BPC:2, NR1:2, CFA:8, GGM:0, ANR:8, CCR:8, EE:8, NR3D:8, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Preview( ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:1, BPC:2, NR1:2, CFA:9, GGM:0, ANR:9, CCR:9, EE:9, NR3D:9, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_NORMAL)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_ACTION)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_PORTRAIT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_NIGHT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_THEATRE)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_BEACH)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_SNOW)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_SUNSET)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_FIREWORKS)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_SPORTS)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_PARTY)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_HDR)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Preview, MTK_CONTROL_SCENE_MODE_BARCODE)


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Preview> <Sensor Mode: Capture>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Preview( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:2, BPC:3, NR1:3, CFA:10, GGM:0, ANR:10, CCR:0, EE:10, NR3D:10, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Preview( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:2, BPC:4, NR1:4, CFA:11, GGM:0, ANR:11, CCR:1, EE:11, NR3D:11, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Preview( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:2, BPC:4, NR1:4, CFA:12, GGM:0, ANR:12, CCR:2, EE:12, NR3D:12, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Preview( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:3, BPC:5, NR1:5, CFA:13, GGM:0, ANR:13, CCR:3, EE:13, NR3D:13, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Preview( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:3, BPC:5, NR1:5, CFA:14, GGM:0, ANR:14, CCR:4, EE:14, NR3D:14, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Preview( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:3, BPC:5, NR1:5, CFA:15, GGM:0, ANR:15, CCR:5, EE:15, NR3D:15, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Preview( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:3, BPC:5, NR1:5, CFA:16, GGM:0, ANR:16, CCR:6, EE:16, NR3D:16, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Preview( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:3, BPC:5, NR1:5, CFA:17, GGM:0, ANR:17, CCR:7, EE:17, NR3D:17, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Preview( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:3, BPC:5, NR1:5, CFA:18, GGM:0, ANR:18, CCR:8, EE:18, NR3D:18, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Preview( ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:3, BPC:5, NR1:5, CFA:19, GGM:0, ANR:19, CCR:9, EE:19, NR3D:19, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_NORMAL)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_ACTION)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_PORTRAIT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_NIGHT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_THEATRE)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_BEACH)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_SNOW)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_SUNSET)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_FIREWORKS)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_SPORTS)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_PARTY)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_HDR)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Capture, MTK_CONTROL_SCENE_MODE_BARCODE)

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Preview> <Sensor Mode: Video>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Preview( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:4, BPC:6, NR1:6, CFA:20, GGM:0, ANR:20, CCR:0, EE:20, NR3D:20, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Preview( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:4, BPC:7, NR1:7, CFA:21, GGM:0, ANR:21, CCR:1, EE:21, NR3D:21, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Preview( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:4, BPC:7, NR1:7, CFA:22, GGM:0, ANR:22, CCR:2, EE:22, NR3D:22, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Preview( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:5, BPC:8, NR1:8, CFA:23, GGM:0, ANR:23, CCR:3, EE:23, NR3D:23, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Preview( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:5, BPC:8, NR1:8, CFA:24, GGM:0, ANR:24, CCR:4, EE:24, NR3D:24, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Preview( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:5, BPC:8, NR1:8, CFA:25, GGM:0, ANR:25, CCR:5, EE:25, NR3D:25, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Preview( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:5, BPC:8, NR1:8, CFA:26, GGM:0, ANR:26, CCR:6, EE:26, NR3D:26, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Preview( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:5, BPC:8, NR1:8, CFA:27, GGM:0, ANR:27, CCR:7, EE:27, NR3D:27, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Preview( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:5, BPC:8, NR1:8, CFA:28, GGM:0, ANR:28, CCR:8, EE:28, NR3D:28, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Preview( ESensorMode_Video, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:5, BPC:8, NR1:8, CFA:29, GGM:0, ANR:29, CCR:9, EE:29, NR3D:29, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_NORMAL)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_ACTION)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_PORTRAIT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_NIGHT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_THEATRE)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_BEACH)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_SNOW)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_SUNSET)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_FIREWORKS)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_SPORTS)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_PARTY)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_HDR)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_Video, MTK_CONTROL_SCENE_MODE_BARCODE)


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Preview> <Sensor Mode: SlimVideo1>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Preview( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:6, BPC:9,  NR1:9,  CFA:30, GGM:0, ANR:30, CCR:0, EE:30, NR3D:30, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Preview( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:6, BPC:10, NR1:10, CFA:31, GGM:0, ANR:31, CCR:1, EE:31, NR3D:31, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Preview( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:6, BPC:10, NR1:10, CFA:32, GGM:0, ANR:32, CCR:2, EE:32, NR3D:32, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Preview( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:7, BPC:11, NR1:11, CFA:33, GGM:0, ANR:33, CCR:3, EE:33, NR3D:33, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Preview( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:7, BPC:11, NR1:11, CFA:34, GGM:0, ANR:34, CCR:4, EE:34, NR3D:34, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Preview( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:7, BPC:11, NR1:11, CFA:35, GGM:0, ANR:35, CCR:5, EE:35, NR3D:35, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Preview( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:7, BPC:11, NR1:11, CFA:36, GGM:0, ANR:36, CCR:6, EE:36, NR3D:36, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Preview( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:7, BPC:11, NR1:11, CFA:37, GGM:0, ANR:37, CCR:7, EE:37, NR3D:37, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Preview( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:7, BPC:11, NR1:11, CFA:38, GGM:0, ANR:38, CCR:8, EE:38, NR3D:38, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Preview( ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:7, BPC:11, NR1:11, CFA:39, GGM:0, ANR:39, CCR:9, EE:39, NR3D:39, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_NORMAL)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_ACTION)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_PORTRAIT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_NIGHT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_THEATRE)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_BEACH)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_SNOW)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_SUNSET)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_FIREWORKS)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_SPORTS)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_PARTY)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_HDR)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo1, MTK_CONTROL_SCENE_MODE_BARCODE)

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// <ISP Profile: Preview> <Sensor Mode: SlimVideo2>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//+++++++++++++++++++++++++++++++++++++++
//  MTK_CONTROL_SCENE_MODE_UNSUPPORTED
//+++++++++++++++++++++++++++++++++++++++
// ISO 100
IDX_MODE_Preview( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_100 )
IDX_SET( OBC:8, BPC:12, NR1:12, CFA:40, GGM:0, ANR:40, CCR:0, EE:40, NR3D:40, MFB:0, LCE:0);
// ISO 200
IDX_MODE_Preview( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_200 )
IDX_SET( OBC:8, BPC:13, NR1:13, CFA:41, GGM:0, ANR:41, CCR:1, EE:41, NR3D:41, MFB:0, LCE:0);
// ISO 400
IDX_MODE_Preview( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_400 )
IDX_SET( OBC:8, BPC:13, NR1:13, CFA:42, GGM:0, ANR:42, CCR:2, EE:42, NR3D:42, MFB:0, LCE:0);
// ISO 800
IDX_MODE_Preview( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_800 )
IDX_SET( OBC:9, BPC:14, NR1:14, CFA:43, GGM:0, ANR:43, CCR:3, EE:43, NR3D:43, MFB:0, LCE:0);
// ISO 1200
IDX_MODE_Preview( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1200 )
IDX_SET( OBC:9, BPC:14, NR1:14, CFA:44, GGM:0, ANR:44, CCR:4, EE:44, NR3D:44, MFB:0, LCE:0);
// ISO 1600
IDX_MODE_Preview( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_1600 )
IDX_SET( OBC:9, BPC:14, NR1:14, CFA:45, GGM:0, ANR:45, CCR:5, EE:45, NR3D:45, MFB:0, LCE:0);
// ISO 2000
IDX_MODE_Preview( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2000 )
IDX_SET( OBC:9, BPC:14, NR1:14, CFA:46, GGM:0, ANR:46, CCR:6, EE:46, NR3D:46, MFB:0, LCE:0);
// ISO 2400
IDX_MODE_Preview( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2400 )
IDX_SET( OBC:9, BPC:14, NR1:14, CFA:47, GGM:0, ANR:47, CCR:7, EE:47, NR3D:47, MFB:0, LCE:0);
// ISO 2800
IDX_MODE_Preview( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_2800 )
IDX_SET( OBC:9, BPC:14, NR1:14, CFA:48, GGM:0, ANR:48, CCR:8, EE:48, NR3D:48, MFB:0, LCE:0);
// ISO 3200
IDX_MODE_Preview( ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_UNSUPPORTED, eIDX_ISO_3200 )
IDX_SET( OBC:9, BPC:14, NR1:14, CFA:49, GGM:0, ANR:49, CCR:9, EE:49, NR3D:49, MFB:0, LCE:0);

//+++++++++++++++++++++++++++++++++++++++
//  Scene Mode
//+++++++++++++++++++++++++++++++++++++++
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_NORMAL)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_ACTION)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_PORTRAIT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_LANDSCAPE)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_NIGHT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_NIGHT_PORTRAIT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_THEATRE)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_BEACH)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_SNOW)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_SUNSET)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_STEADYPHOTO)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_FIREWORKS)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_SPORTS)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_PARTY)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_CANDLELIGHT)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_HDR)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_FACE_PRIORITY)
PREVIEW_SCENE_MODE_CONFIG(ESensorMode_SlimVideo2, MTK_CONTROL_SCENE_MODE_BARCODE)

#endif //  _CFG_ISP_TUNING_IDX_PREVIEW_H_

