/* BEGIN PN:DTS2013053103858 , Added by d00238048, 2013.05.31*/
#ifndef BUILD_LK
#include <linux/string.h>
#endif
#include "lcm_drv.h"

#ifdef BUILD_LK
	#include <platform/mt_gpio.h>
	#include <platform/mt_i2c.h>
	#include <platform/mt_pmic.h>
#elif defined(BUILD_UBOOT)
    #include <asm/arch/mt_gpio.h>
#else
    //#include <linux/delay.h>
    #include <mach/mt_gpio.h>
#endif
#include <cust_gpio_usage.h>
#include <cust_i2c.h>
#ifdef BUILD_LK
#define LCD_DEBUG(fmt)  dprintf(CRITICAL,fmt)
#else
#define LCD_DEBUG(fmt)  printk(fmt)
#endif


static const unsigned int BL_MIN_LEVEL =20;
static LCM_UTIL_FUNCS lcm_util;

#define SET_RESET_PIN(v)    								(lcm_util.set_reset_pin((v)))
#define MDELAY(n) 											(lcm_util.mdelay(n))

// ---------------------------------------------------------------------------
//  Local Functions
// ---------------------------------------------------------------------------

#define dsi_set_cmdq_V2(cmd, count, ppara, force_update)	lcm_util.dsi_set_cmdq_V2(cmd, count, ppara, force_update)
#define dsi_set_cmdq(pdata, queue_size, force_update)		lcm_util.dsi_set_cmdq(pdata, queue_size, force_update)
#define wrtie_cmd(cmd)										lcm_util.dsi_write_cmd(cmd)
#define write_regs(addr, pdata, byte_nums)					lcm_util.dsi_write_regs(addr, pdata, byte_nums)
#define read_reg(cmd)										lcm_util.dsi_dcs_read_lcm_reg(cmd)
#define read_reg_v2(cmd, buffer, buffer_size)   			lcm_util.dsi_dcs_read_lcm_reg_v2(cmd, buffer, buffer_size)


//static unsigned char lcd_id_pins_value = 0xFF;
static const unsigned char LCD_MODULE_ID = 0x01; //  haobing modified 2013.07.11
// ---------------------------------------------------------------------------
//  Local Constants
// ---------------------------------------------------------------------------
#define LCM_DSI_CMD_MODE									1
#define FRAME_WIDTH  										(1080)
#define FRAME_HEIGHT 										(1920)


#define REGFLAG_DELAY             								0xFC
#define REGFLAG_END_OF_TABLE      							0xFD   // END OF REGISTERS MARKER


#ifndef TRUE
    #define TRUE 1
#endif

#ifndef FALSE
    #define FALSE 0
#endif

//static unsigned int lcm_esd_test = FALSE;      ///only for ESD test
// ---------------------------------------------------------------------------
//  Local Variables
// ---------------------------------------------------------------------------
struct LCM_setting_table {
    unsigned char cmd;
    unsigned char count;
    unsigned char para_list[64];
};

static struct LCM_setting_table lcm_initialization_setting[] = {
	//enable orise command
	{0x00,1,{0x00}},
	{0xFF,3,{0x19,0x02,0x01}},
	{0x00,1,{0x80}},
	{0xFF,2,{0x19,0x02}},
	//select LCD work mode. 00(Cmd mode)/13(Video mode)
	{0x00,1,{0x00}},
	{0x1C,1,{0x00}},
	//OSC & Pclk freq
	{0x00,1,{0x80}},
	{0xC1,2,{0x11,0x11}},
	{0x00,1,{0x90}},
	{0xC1,2,{0x44,0x00}},
	//enable TE, just for cmd mode of mipi
	{0x35,1,{0x00}},
	//enable CABC function.
	{0x53,1,{0x2C}},
	//sleep out
	{0x11,0,{}},
	{REGFLAG_DELAY, 120, {}},
	//display on
	{0x29,0,{}},
	//write	display	brightness level to max.
	{0x51,1,{0x00}},
	{REGFLAG_DELAY, 10, {}},
	{REGFLAG_END_OF_TABLE, 0x00, {}}
};

//update initial param for IC nt35520 0.01
static struct LCM_setting_table lcm_full_initialization_setting[] = {
	//enable orise command
	{0x00,1,{0x00}},
	{0xFF,3,{0x19,0x02,0x01}},
	{0x00,1,{0x80}},
	{0xFF,2,{0x19,0x02}},
	//select LCD work mode. 00(Cmd mode)/13(Video mode)
	{0x00,1,{0x00}},
	{0x1C,1,{0x00}},
	//OSC & Pclk freq
	{0x00,1,{0x80}},
	{0xC1,2,{0x11,0x11}},
	{0x00,1,{0x90}},
	{0xC1,2,{0x44,0x00}},
	//Porch
	{0x00,1,{0x80}},
	{0xC0,14,{0x00,0x77,0x00,0x0A,0x0A,0x00,0x77,0x03,0x03,0x00,0x77,0x00,0x0A,0x0A}},
	//unkown7
	{0x00,1,{0x80}},
	{0xA5,3,{0x0C,0x00,0x0F}},
	//unkown8
	{0x00,1,{0xF8}},
	{0xC2,6,{0x03,0x00,0x00,0x0C,0x01,0x01}},
	//unkown9
	{0x00,1,{0xA0}},
	{0xC0,13,{0x00,0x00,0x00,0x15,0x02,0x15,0x05,0x00,0x00,0xFF,0xFF,0x00,0x00}},
	//unkown10
	{0x00,1,{0xB3}},
	{0xC0,2,{0xCC,0x40}},
	//unkown11
	{0x00,1,{0xEA}},
	{0xC2,2,{0x22,0x00}},
	//unkown12
	{0x00,1,{0xD0}},
	{0xC0,13,{0x00,0x00,0x00,0x12,0x01,0x1A,0x05,0x00,0x00,0xFF,0xFF,0x00,0x00}},
	//unkown13
	{0x00,1,{0x80}},
	{0xC2,8,{0x82,0x01,0x00,0x0E,0x83,0x00,0x1D,0x00}},
	//unkown14
	{0x00,1,{0x90}},
	{0xC2,15,{0x82,0x80,0x01,0x0D,0x00,0x81,0x00,0x01,0x0D,0x00,0x80,0x00,0x01,0x0D,0x00}},
	//unkonw15
	{0x00,1,{0xA0}},
	{0xC2,15,{0x01,0x01,0x01,0x0D,0x00,0x82,0x00,0x00,0x00,0x8E,0x81,0x02,0x00,0x00,0x8E}},
	//unkown16
	{0x00,1,{0xB0}},
	{0xC2,10,{0x82,0x03,0x01,0x00,0x8E,0x82,0x03,0x01,0x00,0x8E}},
	//unkown17
	{0x00,1,{0xC0}},
	{0xC1,13,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x11}},
	//unkown18
	{0x00,1,{0xC0}},
	{0xC2,10,{0x00,0x01,0x03,0x00,0x00,0x01,0x02,0x03,0x00,0x00}},
	//unkown19
	{0x00,1,{0xD0}},
	{0xC2,10,{0x82,0x81,0x03,0x00,0x00,0x81,0x80,0x03,0x00,0x00}},
	//unkown20
	{0x00,1,{0xE0}},
	{0xC2,9,{0x81,0x5F,0x01,0x00,0x1F,0x81,0x5F,0x01,0x00}},
	//unkown21
	{0x00,1,{0xEC}},
	{0xC2,2,{0x10,0x00}},
	//unkown22
	{0x00,1,{0xE0}},
	{0x00,12,{0x80,0x74,0x01,0x01,0x09,0x81,0x74,0x01,0x01,0x09,0x01,0x01}},
	//unkown23
	{0x00,1,{0xF0}},
	{0xC2,8,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	//unkown24
	{0x00,1,{0x80}},
	{0xCB,13,{0xF0,0x0F,0x00,0xFF,0x00,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	//unkown25
	{0x00,1,{0x90}},
	{0xCB,15,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	//unkown26
	{0x00,1,{0xA0}},
	{0xCB,15,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0x00,0x00}},
	//unkown27
	//TOOD: why set twice at the same register(CB)????
	{0x00,1,{0xA0}},
	{0xCB,15,{0xB0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x50,0x40,0x00,0x00}},
	//unkown28
	{0x00,1,{0xEB}},
	{0xCC,2,{0xF0,0x00}},
	//unkown29
	{0x00,1,{0xC0}},
	{0xCB,15,{0x00,0x00,0xD4,0xD4,0xD4,0xD4,0x00,0x00,0x00,0x00,0x00,0x00,0xD4,0xD4,0xD4}},
	//unkonw30
	{0x00,1,{0xD0}},
	{0xCB,15,{0xD4,0x28,0x28,0x28,0x28,0xD4,0x14,0xE8,0x28,0x037,0x04,0x04,0x04,0x04,0x04}},
	//unkonw31
	{0x00,1,{0xE0}},
	{0xCB,15,{0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x05,0x05,0x05,0x04,0x00}},
	//unkown32
	{0x00,1,{0xED}},
	{0xCC,2,{0xFF,0x00}},
	//unkown33
	{0x00,1,{0xF0}},
	{0xCB,11,{0x0F,0x00,0xFF,0x00,0xF3,0x03,0x00,0x00,0x00,0x00,0x00}},
	//unkown34
	{0x00,1,{0xE0}},
	{0xCC,6,{0x00,0X00,0X00,0X00,0X00,0X40}},
	//unkown35
	{0x00,1,{0x80}},
	{0xCC,12,{0x2E,0X0F,0X03,0X04,0X05,0X06,0X07,0X08,0X05,0X0A,0X10,0X2F}},
	//unkown36
	{0x00,1,{0xB0}},
	{0xCC,12,{0x2F,0x10,0x06,0x05,0x04,0x03,0x07,0x08,0x09,0x0A,0x0F,0x2E}},
	//unkown37
	{0x00,1,{0x80}},
	{0xCD,15,{0x13,0x14,0x15,0x12,0x13,0x14,0x15,0x12,0x01,0x2D,0x2D,0x02,0x17,0x26,0x18}},
	//unkown38
	{0x00,1,{0x90}},
	{0xCD,15,{0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x024,0x25,0x27,0x28}},
	//unkown39
	{0x00,1,{0xE6}},
	{0xCC,5,{0x29,0x2A,0x11,0x11,0x11}},
	//unkown40
	{0x00,1,{0xA0}},
	{0xCD,15,{0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x03}},
	//unkown41
	{0x00,1,{0xB0}},
	{0xCD,15,{0x05,0x2F,0x18,0x16,0x17,0x15,0x2F,0x12,0x11,0x14,0x0E,0x0D,0x10,0x2F,0x2F}},
	//unkown42
	//TODO: why here is 14
	{0x00,1,{0xC0}},
	{0xCD,14,{0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F}},
	//unkown43
	{0x00,1,{0xD0}},
	{0xCD,15,{0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x04}},
	//unkown44
	{0x00,1,{0xE0}},
	{0xCD,15,{0x06,0x2F,0x18,0x16,0x17,0x15,0x2F,0x12,0x11,0x14,0x0E,0x0D,0x10,0x2F,0x2F}},
	//unkown45
	//TODO: why here is 14
	{0x00,1,{0xF0}},
	{0xCD,14,{0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F}},
	//unkown46
	{0x00,1,{0x80}},
	{0xC3,8,{0x82,0x01,0x00,0x0e,0x83,0x00,0x1D,0x00}},
	//unkown47
	{0x00,1,{0x90}},
	{0xC3,15,{0x82,0x80,0x01,0x0D,0x00,0x81,0x00,0x01,0x0D,0x00,0x80,0x00,0x01,0x0D,0x00}},
	//unkown48
	{0x00,1,{0xA0}},
	{0x00,15,{0x01,0x01,0x01,0x0D,0x00,0x82,0x00,0x00,0x00,0x8E,0x81,0x02,0x00,0x00,0x8E}},
	//unkown49
	{0x00,1,{0xB0}},
	{0xC3,10,{0x82,0x03,0x01,0x00,0x8E,0x82,0x03,0x01,0x00,0x8E}},
	//unkown50
	{0x00,1,{0xD0}},
	{0xC1,13,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x11}},
	//unkown51
	{0x00,1,{0xC0}},
	{0xC3,10,{0x00,0x01,0x03,0x00,0x00,0x01,0x02,0x03,0x00,0x00}},
	//unkown52
	{0x00,1,{0xD0}},
	{0xC3,10,{0x82,0x81,0x03,0x00,0x00,0x81,0x80,0x03,0x00,0x00}},
	//unkown53
	{0x00,1,{0xE0}},
	{0xC3,10,{0x81,0x5F,0x01,0x00,0x0A,0x81,0x5F,0x01,0x00,0x0A}},
	//unkown54
	{0x00,1,{0xEC}},
	{0xC3,2,{0x10,0x00}},
	//timing
	{0x00,1,{0xF0}},
	{0xC1,10,{0x80,0x74,0x01,0x01,0x09,0x81,0x74,0x01,0x01,0x09}},
	//power
	{0x00,1,{0x80}},
	{0xC4,5,{0x08,0x2C,0x02,0x20,0x00}},
	//unkown57
	{0x00,1,{0xA0}},
	{0xC4,9,{0x30,0x06,0x04,0x0A,0x30,0x26,0x84,0x3A,0x11}},
	//unkown58
	{0x00,1,{0x90}},
	{0xC5,14,{0x92,0x16,0xA0,0x14,0xA0,0x1E,0x80,0x14,0x80,0x1E,0x44,0x44,0x40,0xF8}},
	//unkown59
	{0x00,1,{0xA0}},
	{0xC5,14,{0x92,0x16,0xA0,0x14,0xA0,0x1E,0x80,0x14,0x80,0x1E,0x44,0x44,0x40,0x88}},
	//unkown60
	{0x00,1,{0xC0}},
	{0xC5,3,{0x12,0x0A,0x08}},
	//unkown61
	{0x00,1,{0xB0}},
	{0xCA,4,{0x10,0x20,0x5F,0x50}},
	//unkown62
	{0x00,1,{0x00}},
	{0xD8,2,{0x22,0x22}},
	//unkown63
	{0x00,1,{0x00}},
	{0xD9,1,{0x75}},
	//unkown64
	{0x00,1,{0x83}},
	{0xF3,1,{0xCA}},
	//unkown65
	{0x00,1,{0x90}},
	{0xC4,1,{0x00}},
	//unkown66
	{0x00,1,{0xC4}},
	{0xC5,1,{0x04}},
	//unkown67
	{0x00,1,{0xB6}},
	{0xC0,1,{0x7F}},
	//unkown68
	{0x00,1,{0xA0}},
	{0xC1,7,{0x00,0xED,0x00,0x00,0x00,0x00,0x02}},
	//unkown69
	{0x00,1,{0x91}},
	{0xE9,1,{0xC0}},
	//unkown70
	{0x00,1,{0xBA}},
	{0xF5,1,{0x80}},
	//unkown71
	{0x00,1,{0xA5}},
	{0xB3,1,{0x80}},
	//unkown72
	{0x00,1,{0x90}},
	{0xB4,1,{0x19}},
	//unkown73
	{0x00,1,{0x85}},
	{0xF5,1,{0x14}},
	//unkown74
	{0x00,1,{0x87}},
	{0xF5,1,{0x14}},
	//unkown75
	{0x00,1,{0x99}},
	{0xF5,1,{0x14}},
	//unkown76
	{0x00,1,{0xA1}},
	{0xF5,1,{0x14}},
	//unkown77
	{0x00,1,{0xA5}},
	{0xF5,1,{0x08}},
	//unkown78
	{0x00,1,{0xA7}},
	{0xF5,1,{0x08}},
	//unkown79
	{0x00,1,{0xC1}},
	{0xF5,1,{0x18}},
	//unkown80
	{0x00,1,{0xC3}},
	{0xF5,1,{0x18}},
	//unkown81
	{0x00,1,{0xDD}},
	{0xF5,1,{0x18}},

	{0x11,0,{}},
	{REGFLAG_DELAY, 100, {}},
	{0x29,0,{}},
	{REGFLAG_DELAY, 100, {}},
};

static struct LCM_setting_table lcm_deep_sleep_mode_in_setting[] = {
    // Display off sequence
    {0x28, 1, {0x00}},
    {REGFLAG_DELAY, 120, {}},

    // Sleep Mode On
    {0x10, 1, {0x00}},
    {REGFLAG_DELAY, 120, {}},
    {REGFLAG_END_OF_TABLE, 0x00, {}}
};

static void push_table(struct LCM_setting_table *table, unsigned int count, unsigned char force_update)
{
    unsigned int i;

    for(i = 0; i < count; i++)
    {
        unsigned cmd;
        cmd = table[i].cmd;

        switch (cmd) {

            case REGFLAG_DELAY :
                if(table[i].count <= 10)
                    MDELAY(table[i].count);
                else
                    MDELAY(table[i].count);
                break;

            case REGFLAG_END_OF_TABLE :
                break;

            default:
                dsi_set_cmdq_V2(cmd, table[i].count, table[i].para_list, force_update);
        }
    }
}

// ---------------------------------------------------------------------------
//  LCM Driver Implementations
// ---------------------------------------------------------------------------

static void lcm_set_util_funcs(const LCM_UTIL_FUNCS *util)
{
	memcpy(&lcm_util, util, sizeof(LCM_UTIL_FUNCS));
}


static void lcm_get_params(LCM_PARAMS *params)
{
	memset(params, 0, sizeof(LCM_PARAMS));

	params->type   = LCM_TYPE_DSI;

	params->width  = FRAME_WIDTH;
	params->height = FRAME_HEIGHT;

#if (LCM_DSI_CMD_MODE)
	params->dsi.mode   = CMD_MODE;
#else
	params->dsi.mode   = SYNC_PULSE_VDO_MODE;
#endif

	// DSI
	/* Command mode setting */
	params->dsi.LANE_NUM				= LCM_FOUR_LANE;
	//The following defined the fomat for data coming from LCD engine.
	params->dsi.data_format.color_order 	= LCM_COLOR_ORDER_RGB;
	params->dsi.data_format.trans_seq   	= LCM_DSI_TRANS_SEQ_MSB_FIRST;
	params->dsi.data_format.padding     	= LCM_DSI_PADDING_ON_LSB;
	params->dsi.data_format.format      		= LCM_DSI_FORMAT_RGB888;

	// Highly depends on LCD driver capability.
	params->dsi.packet_size=256;
	//video mode timing

	params->dsi.PS=LCM_PACKED_PS_24BIT_RGB888;

	params->dsi.vertical_sync_active				= 2;
	params->dsi.vertical_backporch					= 8;
	params->dsi.vertical_frontporch					= 10;
	params->dsi.vertical_active_line					= FRAME_HEIGHT;

	params->dsi.horizontal_sync_active				= 10;
	params->dsi.horizontal_backporch				= 20;
	params->dsi.horizontal_frontporch				= 40;
	params->dsi.horizontal_active_pixel				= FRAME_WIDTH;

	//begin:haobing modified
	/*BEGIN PN:DTS2013013101431 modified by s00179437 , 2013-01-31*/
	//improve clk quality
	params->dsi.PLL_CLOCK = 500; //this value must be in MTK suggested table
	//params->dsi.pll_div1=0;		// div1=0,1,2,3;div1_real=1,2,4,4 ----0: 546Mbps  1:273Mbps
	//params->dsi.pll_div2=1;		// div2=0,1,2,3;div1_real=1,2,4,4
	//params->dsi.fbk_div =21;    	// fref=26MHz, fvco=fref*(fbk_div)*2/(div1_real*div2_real)
	/*END PN:DTS2013013101431 modified by s00179437 , 2013-01-31*/
	//end:haobing modified
}

static void lcm_init(void)
{
	unsigned char cmd = 0x0;
	unsigned char data = 0xFF;
	int ret=0;
	cmd=0x00;
	data=0x0a;

	mt_set_gpio_mode(GPIO_LCD_BIAS_ENP_PIN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCD_BIAS_ENP_PIN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCD_BIAS_ENP_PIN, GPIO_OUT_ONE);

	SET_RESET_PIN(1);
	MDELAY(10);
	SET_RESET_PIN(0);
	MDELAY(10);
	SET_RESET_PIN(1);
	MDELAY(10);

	// when phone initial , config output high, enable backlight drv chip
	push_table(lcm_initialization_setting, sizeof(lcm_initialization_setting) / sizeof(struct LCM_setting_table), 1);
}

static void lcm_suspend(void)
{
	push_table(lcm_deep_sleep_mode_in_setting, sizeof(lcm_deep_sleep_mode_in_setting) / sizeof(struct LCM_setting_table), 1);
	mt_set_gpio_mode(GPIO_LCD_BIAS_ENP_PIN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCD_BIAS_ENP_PIN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCD_BIAS_ENP_PIN, GPIO_OUT_ZERO);
}

static void lcm_resume(void)
{
	lcm_init();
}

static void lcm_update(unsigned int x, unsigned int y,
                       unsigned int width, unsigned int height)
{
	unsigned int x0 = x;
	unsigned int y0 = y;
	unsigned int x1 = x0 + width - 1;
	unsigned int y1 = y0 + height - 1;

	unsigned char x0_MSB = ((x0>>8)&0xFF);
	unsigned char x0_LSB = (x0&0xFF);
	unsigned char x1_MSB = ((x1>>8)&0xFF);
	unsigned char x1_LSB = (x1&0xFF);
	unsigned char y0_MSB = ((y0>>8)&0xFF);
	unsigned char y0_LSB = (y0&0xFF);
	unsigned char y1_MSB = ((y1>>8)&0xFF);
	unsigned char y1_LSB = (y1&0xFF);

	unsigned int data_array[16];

	data_array[0]= 0x00053902;
	data_array[1]= (x1_MSB<<24)|(x0_LSB<<16)|(x0_MSB<<8)|0x2a;
	data_array[2]= (x1_LSB);
	dsi_set_cmdq(data_array, 3, 1);

	data_array[0]= 0x00053902;
	data_array[1]= (y1_MSB<<24)|(y0_LSB<<16)|(y0_MSB<<8)|0x2b;
	data_array[2]= (y1_LSB);
	dsi_set_cmdq(data_array, 3, 1);
/*BEGIN PN:DTS2013013101431 modified by s00179437 , 2013-01-31*/
	//delete high speed packet
	//data_array[0]=0x00290508;
	//dsi_set_cmdq(data_array, 1, 1);
/*END PN:DTS2013013101431 modified by s00179437 , 2013-01-31*/
	data_array[0]= 0x002c3909;
	dsi_set_cmdq(data_array, 1, 0);
}

/* Lenovo-sw yexm1 add 20140402 begin */
#ifdef LENOVO_LCD_BACKLIGHT_CONTROL_BY_LCM
static void lcm_setbacklight(unsigned int level)
{
	unsigned char data_array[16];

	if(level > 255)
	level = 255;

#ifndef BUILD_LK
	printk("[yexm1] %s level is %d \n",__func__,level);
#endif
	data_array[0] = level;
	dsi_set_cmdq_V2(0x51, 1, data_array, 1);
}
#endif
/* Lenovo-sw yexm1 add 20140402 end */

/*lenovo-sw zhouyj5 add LCD automatic recognition mechanism. 20140521 start */
#define LENOVO_LCD_ID_PIN (GPIO171 | 0x80000000)
static unsigned int lcm_compare_id(void)
{
	unsigned  int ret = 1;
	ret = mt_get_gpio_in(LENOVO_LCD_ID_PIN);
#ifdef BUILD_LK
	if(0 == ret)
		dprintf(0, "[LK]tianma_otm1902a found\n");
#else
	if(0 == ret)
		printk(0, "[KERNEL]tianma_otm1902a found\n");
#endif
	return (0 == ret) ? 1: 0;
}
/*lenovo-sw zhouyj5 add LCD automatic recognition mechanism. 20140521 end */	

/* lenovo-sw yexm1 add lcd effect function 20140314 start */
#ifndef BUILD_LK
#ifdef LENOVO_LCM_EFFECT
static void lcm_setgammamode(unsigned int mode)
{
}


static void lcm_setinversemode(unsigned int mode)
{
}

static void lcm_setcabcmode(unsigned int mode)
{
}

static void lcm_setiemode(unsigned int mode)
{
}
#endif
#endif
/* lenovo-sw yexm1 add lcd effect function 20140314 end */

LCM_DRIVER otm1902a_fhd_dsi_cmd_tianma_lcm_drv=
{
    .name           = "otm1902a_fhd_dsi_cmd_tianma_lcm_drv",
    .set_util_funcs = lcm_set_util_funcs,
    .get_params     = lcm_get_params,
    .init           = lcm_init,/*tianma init fun.*/
    .suspend        = lcm_suspend,
    .resume         = lcm_resume,
    .compare_id     = lcm_compare_id,
#if (LCM_DSI_CMD_MODE)
    .update         = lcm_update,
#endif
#ifdef LENOVO_LCD_BACKLIGHT_CONTROL_BY_LCM
	.set_backlight		= lcm_setbacklight,	//Lenovo-sw yexm1 add 20140402
#endif
#ifndef BUILD_LK
#ifdef LENOVO_LCM_EFFECT
	.set_gammamode = lcm_setgammamode,
	.set_inversemode = lcm_setinversemode,
	//.set_inversemode = lcm_setcabcmode,
	.set_cabcmode = lcm_setcabcmode,
	.set_iemode = lcm_setiemode,
#endif
#endif
};
/* END PN:DTS2013053103858 , Added by d00238048, 2013.05.31*/
