#include <utils/Log.h>                                                                                   
#include <fcntl.h>                                                                                       
#include <math.h>                                                                                        
                                                                                                         
#include "camera_custom_nvram.h"                                                                         
#include "camera_custom_sensor.h"                                                                        
#include "image_sensor.h"                                                                                
#include "kd_imgsensor_define.h"                                                                         
#include "camera_AE_PLineTable_ov5693mipiraw.h"                                                    
#include "camera_info_ov5693mipiraw.h"                                                             
#include "camera_custom_AEPlinetable.h"                                                                  
#include "camera_custom_tsf_tbl.h"                                                                             
                                                                                                         
const NVRAM_CAMERA_ISP_PARAM_STRUCT CAMERA_ISP_DEFAULT_VALUE =                                           
{{                                                                                                       
    //Version                                                                                            
    Version: NVRAM_CAMERA_PARA_FILE_VERSION,                                                             
                                                                                                         
    //SensorId                                                                                           
    SensorId: SENSOR_ID,                                                                                 
    ISPComm:{                                                                                            
        {                                                                                                
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                                              
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                                              
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                                              
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,                                              
    	}                                                                                                   
    },                                                                                                   
    ISPPca: {                                                                                            
        #include INCLUDE_FILENAME_ISP_PCA_PARAM                                                          
    },                                                                                                   
    ISPRegs:{                                                                                            
        #include INCLUDE_FILENAME_ISP_REGS_PARAM                                                         
    },                                                                                                   
    ISPMfbMixer:{{                                                                                       
            0x01FF0001, // MIX3_CTRL_0
            0x00FF0000, // MIX3_CTRL_1
            0xFFFF0000  // MIX3_SPARE
    }},                                                                                                  
    ISPMulitCCM:{                                                                                       
            Poly22:{
        83775,    // i4R_AVG
        21215,    // i4R_STD
        111150,    // i4B_AVG
        27436,    // i4B_STD
        {  // i4P00[9]
            6997500, -1857500, -30000, -755000, 5947500, -80000, 55000, -2455000, 7512500
        },
        {  // i4P10[9]
            2514608, -2923651, 409043, -269850, -102141, 363527, 173910, 485237, -661564
        },
        {  // i4P01[9]
            2049646, -2235460, 185814, -501175, -179690, 672903, -43737, -231400, 268441
        },                                                                                               
        { // i4P20[9]                                                                                    
            0,  0,   0,  0,   0,  0, 0,  0,  0              
        },                                                                                               
        { // i4P11[9]                                                                                    
            0,  0,  0,  0,   0, 0, 0,  0,  0              
        },                                                                                               
        { // i4P02[9]                                                                                    
            0,    0,  0,  0,   0, 0,  0,    0,  0             
        }                                                                                                
            },
      AWBGain:{
        // Strobe
        {
          512,    // i4R
          512,    // i4G
          512,    // i4B
        },
        // A
        {
          583,    // i4R
          512,    // i4G
          1416,    // i4B
        },
        // TL84
        {
          782,    // i4R
          512,    // i4G
          1120,    // i4B
        },
        // CWF
        {
          896,    // i4R
          512,    // i4G
          1160,    // i4B
        },
        // D65
        {
          1090,    // i4R
          512,    // i4G
          750,    // i4B
        },
        // Reserved 1
        {
          512,    // i4R
          512,    // i4G
          512,    // i4B
        },
        // Reserved 2
        {
          512,    // i4R
          512,    // i4G
          512,    // i4B
        },
        // Reserved 3
        {
          512,    // i4R
          512,    // i4G
          512,    // i4B
        }
            },
            Weight:{
    1, // Strobe
    1, // A
    1, // TL84
    1, // CWF
    1, // D65
    1, // Reserved 1
    1, // Reserved 2
    1  // Reserved 3
}
    }                                                                                                    
}};                                                                                                      
                                                                                                         
const NVRAM_CAMERA_3A_STRUCT CAMERA_3A_NVRAM_DEFAULT_VALUE =                                             
{                                                                                                        
    NVRAM_CAMERA_3A_FILE_VERSION, // u4Version                                                           
    SENSOR_ID, // SensorId                                                                               
                                                                                                         
    // AE NVRAM                                                                                          
    {                                                                                                    
        // rDevicesInfo                                                                                  
        {                                                                                                
            1152,    // u4MinGain, 1024 base = 1x                                                        
            10240,    // u4MaxGain, 16x                                                                   
            93,    // u4MiniISOGain, ISOxx                                                              
            128,    // u4GainStepUnit, 1x/8                                                              
            16801,    // u4PreExpUnit                                                                       
            30,    // u4PreMaxFrameRate                                                                  
            16801,    // u4VideoExpUnit                                                                     
            30,    // u4VideoMaxFrameRate                                                                
            1024,    // u4Video2PreRatio, 1024 base = 1x                                                 
            16801,    // u4CapExpUnit                                                                       
            30,    // u4CapMaxFrameRate                                                                  
            1024,    // u4Cap2PreRatio, 1024 base = 1x                                                   
            10951,     // u4Video1ExpUnit
            120,     // u4Video1MaxFrameRate
            1024,   // u4Video12PreRatio, 1024 base = 1x
            21907,     // u4Video2ExpUnit
            30,     // u4Video2MaxFrameRate
            1024,   // u4Video22PreRatio, 1024 base = 1x
            24,    // u4LensFno, Fno = 2.8                                                               
            350    // u4FocusLength_100x                                                                 
         },                                                                                              
         // rHistConfig                                                                                  
        {                                                                                                
            4, // 2,   // u4HistHighThres                                                                
            40,  // u4HistLowThres                                                                       
            2,   // u4MostBrightRatio                                                                    
            1,   // u4MostDarkRatio                                                                      
            160, // u4CentralHighBound                                                                   
            20,  // u4CentralLowBound                                                                    
            {240, 230, 220, 210, 200}, // u4OverExpThres[AE_CCT_STRENGTH_NUM]                            
            {62, 70, 82, 108, 141},  // u4HistStretchThres[AE_CCT_STRENGTH_NUM]                        
            {18, 22, 26, 30, 34}       // u4BlackLightThres[AE_CCT_STRENGTH_NUM]                         
        },                                                                                               
        // rCCTConfig                                                                                    
        {                                                                                                
            TRUE,            // bEnableBlackLight                                                        
            TRUE,            // bEnableHistStretch                                                       
            TRUE,           // bEnableAntiOverExposure                                                  
            TRUE,            // bEnableTimeLPF                                                           
            FALSE,            // bEnableCaptureThres                                                      
            TRUE,            // bEnableVideoThres                                                        
            TRUE,            // bEnableStrobeThres                                                       
            47,                // u4AETarget                                                             
            47,                // u4StrobeAETarget                                                       
                                                                                                         
            50,                // u4InitIndex                                                            
            4,                 // u4BackLightWeight                                                      
            32,                // u4HistStretchWeight                                                    
            4,                 // u4AntiOverExpWeight                                                    
            2,                 // u4BlackLightStrengthIndex                                              
            2, // 2,                 // u4HistStretchStrengthIndex                                       
            2,                 // u4AntiOverExpStrengthIndex                                             
            2,                 // u4TimeLPFStrengthIndex                                                 
            {1, 3, 5, 7, 8}, // u4LPFConvergeTable[AE_CCT_STRENGTH_NUM]                                  
            90,                // u4InDoorEV = 9.0, 10 base                                              
            -3,               // i4BVOffset delta BV = -2.3                   
            64,                 // u4PreviewFlareOffset                                                  
            64,                 // u4CaptureFlareOffset                                                  
            7,                 // u4CaptureFlareThres                                                    
            64,                 // u4VideoFlareOffset                                                    
            7,                 // u4VideoFlareThres                                                      
            64,                 // u4StrobeFlareOffset                                                   
            5,                 // u4StrobeFlareThres                                                     
            160,                 // u4PrvMaxFlareThres                                                   
            0,                 // u4PrvMinFlareThres                                                     
            160,                 // u4VideoMaxFlareThres                                                 
            0,                 // u4VideoMinFlareThres                                                   
            18,                // u4FlatnessThres              // 10 base for flatness condition.        
            60,                // u4FlatnessStrength                                                     
                        //rMeteringSpec
                        {
                                //rHS_Spec
                                {
                                        TRUE,//bEnableHistStretch           // enable histogram stretch
                                        1024,//u4HistStretchWeight          // Histogram weighting value
                                        40,//u4Pcent                      // 1%=10, 0~1000
                                        176,//178,//174,//160,//u4Thd                        // 0~255
                                        53,//56,//62,//75,//u4FlatThd                    // 0~255

                                        120,//u4FlatBrightPcent
                                        120,//u4FlatDarkPcent
                                        //sFlatRatio
                                        {
                                            1000, //i4X1
                                            1024,  //i4Y1
                                            2400, //i4X2
                                            0     //i4Y2
                                        },
                    TRUE, //bEnableGreyTextEnhance
                    1800, //u4GreyTextFlatStart, > sFlatRatio.i4X1, < sFlatRatio.i4X2
                    {
                        10,     //i4X1
                        1024,   //i4Y1
                        80,     //i4X2
                        0       //i4Y2
                    }
                                },
                                //rAOE_Spec
                                {
                                        TRUE,//bEnableAntiOverExposure
                                        1024,//u4AntiOverExpWeight
                                        10,//u4Pcent
                                        210,//220,//200,//u4Thd
                                        TRUE,//bEnableCOEP
                                        1,//u4COEPcent
                                        115,//106,//u4COEThd
                                        0,  // u4BVCompRatio
                                        //sCOEYRatio;     // the outer y ratio
                                        {
                                               23,   //i4X1
                                                1024,  //i4Y1
                                                47,   //i4X2
                                                0     //i4Y2
                                        },
                                       //sCOEDiffRatio;  // inner/outer y difference ratio
                                        {
                                                1500, //i4X1
                                                0,    //i4Y1
                                                2100, //i4X2
                                                1024   //i4Y2
                                        }
                                },
                                //rABL_Spec
                                {
                                        TRUE,//bEnableBlackLigh
                                        1024,//u4BackLightWeigh
                                        400,//u4Pcent
                                        22,//u4Thd,
                                        255, // center luminance
                                        256, // final target limitation, 256/128 = 2x
                                        //sFgBgEVRatio
                                        {
                                                2200, //i4X1
                                                0,    //i4Y1
                                                4000, //i4X2
                                                1024   //i4Y2
                                        },
                                        //sBVRatio
                                        {
                                                3800,//i4X1
                                                0,   //i4Y1
                                                5000,//i4X2
                                                1024  //i4Y2
                                        }
                                },
                                //rNS_Spec
                                {
                                        TRUE, // bEnableNightScene
                                        5,    //u4Pcent
                    174,//170,  //u4Thd
                    53,//56,//58,//72, //52,   //u4FlatThd

                    200,  //u4BrightTonePcent
                    95, //u4BrightToneThd

                    500,  //u4LowBndPcent
                    5,    //u4LowBndThd
                    26,    //u4LowBndThdLimit

                                        50,  //u4FlatBrightPcent;
                                        300,   //u4FlatDarkPcent;
                                        //sFlatRatio
                                        {
                                                1200, //i4X1
                                                1024, //i4Y1
                        2400, //i4X2
                                                0    //i4Y2
                                        },
                                        //sBVRatio
                                        {
                                                -500, //i4X1
                                                1024,  //i4Y1
                        3000, //i4X2
                                                0     //i4Y2
                                        },
                                        TRUE, // bEnableNightSkySuppresion
                                        //sSkyBVRatio
                                        {
                                                -4000, //i4X1
                                                1024, //i4X2
                                                -2000,  //i4Y1
                                                0     //i4Y2
                                        }
                            },
                            // rTOUCHFD_Spec
                            {
                    40, //uMeteringYLowBound;
                    50, //uMeteringYHighBound;
                    40, //uFaceYLowBound;
                    50, //uFaceYHighBound;
                    3, //uFaceCentralWeight;
                    120, //u4MeteringStableMax;
                    80, //u4MeteringStableMin;
                            }
                        }, //End rMeteringSpec
                        // rFlareSpec
                        {
                            {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
                            {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
                96,                                               //u4FlareStdThrHigh;
                48,                                               //u4FlareStdThrLow;
                0,                                               //u4PrvCapFlareDiff;
                4,                                               //u4FlareMaxStepGap_Fast;
                0,                                               //u4FlareMaxStepGap_Slow;
                1800,                                               //u4FlarMaxStepGapLimitBV;
                0,                                               //u4FlareAEStableCount;
                        },
                        //rAEMoveRatio =
                        {
                            100, //u4SpeedUpRatio
                            100, //u4GlobalRatio
                            190, //u4Bright2TargetEnd
                            20,   //u4Dark2TargetStart
                            90, //u4B2TEnd
                            70,  //u4B2TStart
                            60,  //u4D2TEnd
                            90,  //u4D2TStart
                        },

                        //rAEVideoMoveRatio =
                        {
                            100, //u4SpeedUpRatio
                            100, //u4GlobalRatio
                150,  //u4Bright2TargetEnd
                20,    //u4Dark2TargetStart
                90, //u4B2TEnd
                10,  //u4B2TStart
                10,  //u4D2TEnd
                90,  //u4D2TStart
            },

            //rAEFaceMoveRatio =
            {
                100, //u4SpeedUpRatio
                100, //u4GlobalRatio
                190,  //u4Bright2TargetEnd
                10,    //u4Dark2TargetStart
                80, //u4B2TEnd
                30,  //u4B2TStart
                20,  //u4D2TEnd
                60,  //u4D2TStart
            },

            //rAETrackingMoveRatio =
            {
                100, //u4SpeedUpRatio
                100, //u4GlobalRatio
                190,  //u4Bright2TargetEnd
                10,    //u4Dark2TargetStart
                80, //u4B2TEnd
                30,  //u4B2TStart
                20,  //u4D2TEnd
                60,  //u4D2TStart
            },
            //rAEAOENVRAMParam =
            {
                1,      // i4AOEStrengthIdx: 0 / 1 / 2
                130,    // u4BVCompRatio
                {
                    {
                        47,  //u4Y_Target
                        25,  //u4AOE_OE_percent
                        210,  //u4AOE_OEBound
                        10,    //u4AOE_DarkBound
                        950,    //u4AOE_LowlightPrecent
                        1,    //u4AOE_LowlightBound
                        145,    //u4AOESceneLV_L
                        180,    //u4AOESceneLV_H
                        40,    //u4AOE_SWHdrLE_Bound
                    },
                    {
                        47,  //u4Y_Target
                        25,  //u4AOE_OE_percent
                        210,  //u4AOE_OEBound
                        15, //20,    //u4AOE_DarkBound
                        950,    //u4AOE_LowlightPrecent
                        3, //10,    //u4AOE_LowlightBound
                        145,    //u4AOESceneLV_L
                        180,    //u4AOESceneLV_H
                        40,    //u4AOE_SWHdrLE_Bound
                    },
                    {
                        47,  //u4Y_Target
                        25,  //u4AOE_OE_percent
                        210,  //u4AOE_OEBound
                        25,    //u4AOE_DarkBound
                        950,    //u4AOE_LowlightPrecent
                        8,    //u4AOE_LowlightBound
                        145,    //u4AOESceneLV_L
                        180,    //u4AOESceneLV_H
                        40,    //u4AOE_SWHdrLE_Bound
                    }
                }
            }
        }
    },                                                                                                   
    // AWB NVRAM
   {	
	// AWB calibration data							
	{		
		// rUnitGain (unit gain: 1.0 = 512)						
		{						
			0,	// i4R		
			0,	// i4G				
			0	// i4B				
		},			
		// rGoldenGain (golden sample gain: 1.0 = 512)					
		{						
			0,	// i4R				
			0,	// i4G				
			0	// i4B				
		},						
		// rTuningUnitGain (Tuning sample unit gain: 1.0 = 512)						
		{						
			0,	// i4R				
			0,	// i4G				
			0	// i4B				
		},						
		// rD65Gain (D65 WB gain: 1.0 = 512)		
		{						
                1078,    // i4R
                512,    // i4G
                748    // i4B
		}						
	},							
	// Original XY coordinate of AWB light source				
	{							
		// Strobe			
		{		
			0,	// i4X	
			0	// i4Y		
		},	
		// Horizon		
		{		
                -463,    // i4X
                -404    // i4Y
            },
            // A
            {
                -324,    // i4X
                -424    // i4Y
            },
            // TL84
            {
                -126,    // i4X
                -443    // i4Y
            },
            // CWF
            {
                -93,    // i4X
                -510    // i4Y
            },
            // DNP
            {
                -8,    // i4X
                -435    // i4Y
            },
            // D65
            {
                135,    // i4X
                -415    // i4Y
            },
            // DF
            {
                116,    // i4X
                -509    // i4Y
            }
        },
        // Rotated XY coordinate of AWB light source
        {
            // Strobe
            {
                0,    // i4X
                0    // i4Y
            },
            // Horizon
            {
                -463,    // i4X
                -404    // i4Y
            },
            // A
            {
                -324,    // i4X
                -424    // i4Y
            },
            // TL84
            {
                -126,    // i4X
                -443    // i4Y
            },
            // CWF
            {
                -93,    // i4X
                -510    // i4Y
            },
            // DNP
            {
                -8,    // i4X
                -435    // i4Y
            },
            // D65
            {
                135,    // i4X
                -415    // i4Y
            },
            // DF
            {
                116,    // i4X
                -509    // i4Y
            }
        },
        // AWB gain of AWB light source
        {
            // Strobe 
            {
                512,    // i4R
                512,    // i4G
                512    // i4B
            },
            // Horizon 
            {
                512,    // i4R
                554,    // i4G
                1793    // i4B
            },
            // A 
            {
                586,    // i4R
                512,    // i4G
                1409    // i4B
            },
            // TL84 
            {
                786,    // i4R
                512,    // i4G
                1107    // i4B
            },
            // CWF 
            {
                901,    // i4R
                512,    // i4G
                1158    // i4B
            },
            // DNP 
            {
                913,    // i4R
                512,    // i4G
                933    // i4B
            },
            // D65 
            {
                1078,    // i4R
                512,    // i4G
                748    // i4B
            },
            // DF 
            {
                1194,    // i4R
                512,    // i4G
                872    // i4B
            }
        },
        // Rotation matrix parameter
        {
            0,    // i4RotationAngle
            256,    // i4Cos
            0    // i4Sin
        },
        // Daylight locus parameter
        {
            -130,    // i4SlopeNumerator
		128	// i4SlopeDenominator		
	},							                              
 // Predictor gain
 {
                        // i4PrefRatio100
                        101,

                        // DaylightLocus_L
                        {
                            1103,    // i4R
                            512,    // i4G
                            731,    // i4B
                        },
                        // DaylightLocus_H
                        {
                            864,    // i4R
                            512,    // i4G
                            933,    // i4B
                        },
                        // Temporal General
                        {
                            1103,    // i4R
                            512,    // i4G
                            731,    // i4B
                        }
 },
	// AWB light area							                
	{							                                
		// Strobe						                        
		{						                                
			0,	// StrobeRightBound				            
			0,	// StrobeLeftBound				          
			0,	// StrobeUpperBound				          
			0	// StrobeLowerBound				          
		},						                              
		// Tungsten						                      
		{						                                
            -176,    // i4RightBound
            -826,    // i4LeftBound
            -334,    // i4UpperBound
            -464    // i4LowerBound
            },
            // Warm fluorescent
            {
            -176,    // i4RightBound
            -826,    // i4LeftBound
            -464,    // i4UpperBound
            -584    // i4LowerBound
            },
            // Fluorescent
            {
            -58,    // i4RightBound
            -176,    // i4LeftBound
            -349,    // i4UpperBound
            -476    // i4LowerBound
            },
            // CWF
            {
            -58,    // i4RightBound
            -176,    // i4LeftBound
            -476,    // i4UpperBound
            -560    // i4LowerBound
            },
            // Daylight
            {
            160,    // i4RightBound
            -58,    // i4LeftBound
            -335,    // i4UpperBound
            -495    // i4LowerBound
            },
            // Shade
            {
            520,    // i4RightBound
            160,    // i4LeftBound
            -335,    // i4UpperBound
            -495    // i4LowerBound
            },
            // Daylight Fluorescent
            {
            165,    // i4RightBound
            -58,    // i4LeftBound
            -495,    // i4UpperBound
            -565    // i4LowerBound
            }
        },
        // PWB light area
        {
            // Reference area
            {
            520,    // i4RightBound
            -826,    // i4LeftBound
            0,    // i4UpperBound
            -584    // i4LowerBound
            },
            // Daylight
            {
            185,    // i4RightBound
            -58,    // i4LeftBound
            -335,    // i4UpperBound
            -495    // i4LowerBound
            },
            // Cloudy daylight
            {
            285,    // i4RightBound
            110,    // i4LeftBound
            -335,    // i4UpperBound
            -495    // i4LowerBound
            },
            // Shade
            {
            385,    // i4RightBound
            110,    // i4LeftBound
            -335,    // i4UpperBound
            -495    // i4LowerBound
            },
            // Twilight
            {
            -58,    // i4RightBound
            -218,    // i4LeftBound
            -335,    // i4UpperBound
            -495    // i4LowerBound
            },
            // Fluorescent
            {
            185,    // i4RightBound
            -226,    // i4LeftBound
            -365,    // i4UpperBound
            -560    // i4LowerBound
            },
            // Warm fluorescent
            {
            -224,    // i4RightBound
            -424,    // i4LeftBound
            -365,    // i4UpperBound
            -560    // i4LowerBound
            },
            // Incandescent
            {
            -224,    // i4RightBound
            -424,    // i4LeftBound
            -335,    // i4UpperBound
            -495    // i4LowerBound
            },
            // Gray World
            {
            5000,    // i4RightBound
            -5000,    // i4LeftBound
            5000,    // i4UpperBound
            -5000    // i4LowerBound
            }
        },
        // PWB default gain	
        {
            // Daylight
            {
            979,    // i4R
            512,    // i4G
            824    // i4B
            },
            // Cloudy daylight
            {
            1173,    // i4R
            512,    // i4G
            687    // i4B
            },
            // Shade
            {
            1255,    // i4R
            512,    // i4G
            642    // i4B
            },
            // Twilight
            {
            745,    // i4R
            512,    // i4G
            1082    // i4B
            },
            // Fluorescent
            {
            931,    // i4R
            512,    // i4G
            985    // i4B
            },
            // Warm fluorescent
            {
            618,    // i4R
            512,    // i4G
            1485    // i4B
            },
            // Incandescent
            {
            579,    // i4R
            512,    // i4G
            1392    // i4B
            },
            // Gray World
            {
            512,    // i4R
            512,    // i4G
            512    // i4B
            }
        },
        // AWB preference color	
        {
            // Tungsten
            {
            0,    // i4SliderValue
           9100// 8200//7597    // i4OffsetThr
            },
            // Warm fluorescent	
            {
            0,    // i4SliderValue
            8237    // i4OffsetThr
            },
            // Shade
            {
            5,    // i4SliderValue
            1241    // i4OffsetThr
            },
            // Preference gain: strobe
            {
            512,    // i4R
            512,    // i4G
            512    // i4B
            },
            // Preference gain: tungsten
            {
            520,    // i4R
            512,    // i4G
            528    // i4B
            },
            // Preference gain: warm fluorescent
            {
            515,    // i4R
            512,    // i4G
            525    // i4B
            },
            // Preference gain: fluorescent
            {
            522,    // i4R
            512,    // i4G
            514    // i4B
            },
            // Preference gain: CWF
            {
            516,    // i4R
            512,    // i4G
            515    // i4B
            },
            // Preference gain: daylight
            {
            510,    // i4R
            512,    // i4G
            516    // i4B
            },
            // Preference gain: shade
            {
            512,    // i4R
            512,    // i4G
            512    // i4B
            },
            // Preference gain: daylight fluorescent
            {
            512,    // i4R
            512,    // i4G
            512    // i4B
            }
        },
                // Algorithm Tuning Paramter
                {
                    // AWB Backup Enable
                    0,
                    // AWB LSC Gain
                    {
                        864,        // i4R
                        512,        // i4G
                        933,        // i4B
                    },
                    // Parent block weight parameter
                    {
                        1,      // bEnable
                        6           // i4ScalingFactor: [6] 1~12, [7] 1~6, [8] 1~3, [9] 1~2, [>=10]: 1
                    },
                    // AWB LV threshold for predictor
                    {
                            100,    // i4InitLVThr_L
                            140,    // i4InitLVThr_H
                            80      // i4EnqueueLVThr
                    },
                    // AWB number threshold for temporal predictor
                    {
                            65,     // i4Neutral_ParentBlk_Thr
                        //LV0  1    2    3    4    5    6    7    8    9    10   11   12   13   14   15   16   17   18
                        {  100,   100,   100,   100,   100,   100,   100,   100,   50,   25,   2,   2,   2,   2,   2,   2,   2,   2,   2}  // (%) i4CWFDF_LUTThr
                    },
                    // AWB light neutral noise reduction for outdoor
                    {
                        //LV0  1    2    3    4    5    6    7    8    9    10   11   12   13   14   15   16   17   18
                        // Non neutral
		                { 5,  5,  5,  5,  5,  5,  5,  5,  5,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10},  // (%)
		                // Flurescent
		                { 0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  10,  10,  10,  10,  10,  10,  10,  10,  10},  // (%)
		                // CWF
		                { 0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  10,  10,  10,  10,  10,  10,  10,  10,  10},  // (%)
		                // Daylight
		                { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,  4,  4,  4,  4,  4,  4,  4,  4},  // (%)
		                // DF
		                { 0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  10,  10,  10,  10,  10,  10,  10,  10,  10},  // (%)
                    },
                    // AWB feature detection
                    {
                        // Sunset Prop
                        {
                            1,      // i4Enable
                            130,        // i4LVThr
                            {
                                7,   // i4Sunset_BoundXr_Thr
                                -435     // i4Sunset_BoundYr_Thr
                            },
                            10,         // i4SunsetCountThr
                            0,          // i4SunsetCountRatio_L
                            171         // i4SunsetCountRatio_H
                        },
                        // Shade F Detection
                        {
                            1,          // i4Enable
                            105,        // i4LVThr
                            {
                                -97,   // i4BoundXrThr
                                -415     // i4BoundYrThr
                            },
                            128         // i4DaylightProb
                        },
                        // Shade CWF Detection
                        {
                            1,          // i4Enable
                            95,        // i4LVThr
                            {
                                -93,   // i4BoundXrThr
                                -510     // i4BoundYrThr
                            },
                            128         // i4DaylightProb
                        },
                        // Low CCT
                        {
                            1,          // i4Enable
                            384,        // i4LVThr
                            {
                                -400,//-513,   // i4BoundXrThr
                                360     // i4BoundYrThr
                            }
                        }
                    },

                    // AWB Gain Limit
                    {
                    // rNormalLowCCT
                    {
                        1,  // Gain Limit Enable
                        1000//717     // Gain ratio
                    },
                    // rPrefLowCCT
                    {
                        1,  // Gain Limit Enable
                           1300// 870     // Gain ratio
                    }
                },

                    // AWB non-neutral probability for spatial and temporal weighting look-up table (Max: 100; Min: 0)
                    {
                        //LV0   1    2    3    4    5    6    7    8    9    10   11   12   13   14   15   16   17   18
		                { 100,  100,  100,  100,  100,  100,  100,  100,  100,  70,  30,  20,  10,  0,  0,  0,  0,  0,  0}
                    },

                    // AWB daylight locus probability look-up table (Max: 100; Min: 0)
                    {   //LV0    1     2     3      4     5     6     7     8      9      10     11    12   13     14    15   16    17    18
                        {100, 100, 100, 100, 100, 100, 100, 100, 100, 100,  100,  100, 100,  50,  25,   0,  0,   0,   0}, // Strobe
                        {100, 100, 100, 100, 100, 100, 100, 100, 100, 100,  100,  100, 100, 100,  50,  25,  0,   0,   0}, // Tungsten
                        {100, 100, 100, 100, 100, 100, 100, 100, 100, 100,  100,  100, 100, 100,  50,  25,  0,   0,   0}, // Warm fluorescent
                        {100, 100, 100, 100, 100, 100, 100, 100, 100, 100,  100,  75, 50,  25,  25,  25,  0,   0,   0}, // Fluorescent
		                { 90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  80,  55,  30, 30,  30,  30,  0,  0,  0}, // CWF
		                { 100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,  75,  50,  40,  30,  20}, // Daylight
                        {100, 100, 100, 100, 100, 100, 100, 100, 100, 100,  100,  100, 75,  50,  25,   0,  0,   0,   0}, // Shade
		                { 90,  90,  90,  90,  90,  90,  90,  90,  90,  90,  80,  55,  30,  30,  30,  30,  0,  0,  0} // Daylight fluorescent

    		        }
                },

	// CCT estimation							                
	{							                                
		// CCT						                          
		{						                                
                2300,    // i4CCT[0]
                2850,    // i4CCT[1]
                3750,    // i4CCT[2]
                5100,    // i4CCT[3]
                6500    // i4CCT[4]
            },
            {// Rotated X coordinate
                -598,    // i4RotatedXCoordinate[0]
                -459,    // i4RotatedXCoordinate[1]
                -261,    // i4RotatedXCoordinate[2]
                -143,    // i4RotatedXCoordinate[3]
                0    // i4RotatedXCoordinate[4]
		}						                                
	}							                                
},
        // Flash AWB NVRAM
        {
            #include INCLUDE_FILENAME_FLASH_AWB_PARA
        },
                                               
	{0}  //FIXED                                  
};                                             

#include INCLUDE_FILENAME_ISP_LSC_PARAM                                                                        
//};  //  namespace                                                                                            
const CAMERA_TSF_TBL_STRUCT CAMERA_TSF_DEFAULT_VALUE =                                                         
{
        {
                1,  // isTsfEn
                2,  // tsfCtIdx
                {20, 2000, -110, -110, 512, 512, 512, 0}    // rAWBInput[8]
        },
    #include INCLUDE_FILENAME_TSF_PARA                                                                         
    #include INCLUDE_FILENAME_TSF_DATA                                                                         
}; 
const NVRAM_CAMERA_FEATURE_STRUCT CAMERA_FEATURE_DEFAULT_VALUE =
{
#include INCLUDE_FILENAME_FEATURE_PARA
};

typedef NSFeature::RAWSensorInfo<SENSOR_ID> SensorInfoSingleton_T;                                             
                                                                                                               
                                                                                                               
namespace NSFeature {                                                                                          
template <>                                                                                                    
UINT32                                                                                                         
SensorInfoSingleton_T::                                                                                        
impGetDefaultData(CAMERA_DATA_TYPE_ENUM const CameraDataType, VOID*const pDataBuf, UINT32 const size) const    
{                                                                                                              
    UINT32 dataSize[CAMERA_DATA_TYPE_NUM] = {sizeof(NVRAM_CAMERA_ISP_PARAM_STRUCT),                            
                                             sizeof(NVRAM_CAMERA_3A_STRUCT),                                   
                                             sizeof(NVRAM_CAMERA_SHADING_STRUCT),                              
                                             sizeof(NVRAM_LENS_PARA_STRUCT),                                   
                                             sizeof(AE_PLINETABLE_T),                                           
                                             0,                                                                
                                             sizeof(CAMERA_TSF_TBL_STRUCT),                                    
                                             0,
                                             sizeof(NVRAM_CAMERA_FEATURE_STRUCT)
                                            };
                                                                                                               
    if (CameraDataType > CAMERA_NVRAM_DATA_FEATURE || NULL == pDataBuf || (size < dataSize[CameraDataType]))   
    {                                                                                                          
        return 1;                                                                                              
    }                                                                                                          
                                                                                                               
    switch(CameraDataType)                                                                                     
    {                                                                                                          
        case CAMERA_NVRAM_DATA_ISP:                                                                            
            memcpy(pDataBuf,&CAMERA_ISP_DEFAULT_VALUE,sizeof(NVRAM_CAMERA_ISP_PARAM_STRUCT));                  
            break;                                                                                             
        case CAMERA_NVRAM_DATA_3A:                                                                             
            memcpy(pDataBuf,&CAMERA_3A_NVRAM_DEFAULT_VALUE,sizeof(NVRAM_CAMERA_3A_STRUCT));                    
            break;                                                                                             
        case CAMERA_NVRAM_DATA_SHADING:                                                                        
            memcpy(pDataBuf,&CAMERA_SHADING_DEFAULT_VALUE,sizeof(NVRAM_CAMERA_SHADING_STRUCT));                
            break;                                                                                             
        case CAMERA_DATA_AE_PLINETABLE:                                                                        
            memcpy(pDataBuf,&g_PlineTableMapping,sizeof(AE_PLINETABLE_T));                                     
            break;                                                                                             
        case CAMERA_DATA_TSF_TABLE:                                                                            
            memcpy(pDataBuf,&CAMERA_TSF_DEFAULT_VALUE,sizeof(CAMERA_TSF_TBL_STRUCT));                          
            break;                                                                                             
        case CAMERA_NVRAM_DATA_FEATURE:                                                                            
            memcpy(pDataBuf,&CAMERA_FEATURE_DEFAULT_VALUE,sizeof(NVRAM_CAMERA_FEATURE_STRUCT));                          
            break;                                                                                             
        default:                                                                                               
            return 1;
    }                                                                                                          
    return 0;                                                                                                  
}};  //  NSFeature                                                                                             
