
extern "C" {

// The LCM number which this project can support
int LCM_COUNT = 1;

// The gamma of LCM
// This value must be configured correctly.
// LcmGamma[0] is for LCM 0, LcmGamma[1] is for LCM 1, ... etc,
// if this project supports multiple LCM.
float LcmGamma[] = { 2.2 };


// --------------------------------------------------------------------------
//  Behavior configuration
// --------------------------------------------------------------------------

// The default brightness of auto backlight in [0, 255]
// Larger value means DARKER
// Supports multiple LCM. The number of elements must equal to LCM_COUNT.
int BrightnessLevel[] = { 64 };

// Brightening speed of auto backlight in [0, 255]
// Larger value means faster
int BrighteningSpeedLevel = 128;

// Darkening speed of auto backlight in [0, 255]
// Larger value means faster
int DarkeningSpeedLevel = 128;

// The enhancement level of DRE in [0, 255]
// Larger value means stronger
// Supports multiple LCM. The number of elements must equal to LCM_COUNT.
int ReadabilityLevel[] = { 140 };

// Strength of Content-adaptive backlight control
// In [0, 255]
// This function could intelligently reduce backlight to save power according to content.
// The larger SmartBacklightStrength value, the more power saving.
// However, the excessive large value may degrade images brightness. 
// Supports multiple LCM. The number of elements must equal to LCM_COUNT.
int SmartBacklightStrength[] = { 128 };

// Effective range of Content-adaptive backlight control
// In [0, 255]
// This parameter influences the image type which SmartBacklightStrength applied.
// Using small SmartBacklightRange value, SmartBacklightStrength only effects on bright image scene.
// SmartBacklightStrength effects on mid-bright image scene by using larger SmartBacklightStrength value.
// Supports multiple LCM. The number of elements must equal to LCM_COUNT.
int SmartBacklightRange[] = { 128 };

// Minimum backlight value of AAL output
// In [0, 1023]
// Supports multiple LCM. The number of elements must equal to LCM_COUNT.
int MinOutBL[] = { 4 };

// The number of control points
int ControlPointNumber = 19;

// The value of ambient light. The array length should match ControlPointNumber
int AmbientLightCurve[19] = { 0,  5,  30,  60, 90, 150, 200, 350, 450, 550, 720, 950, 1100, 1500, 2000, 3500, 5600, 6700, 8700 };

// Backlight, maximum value is 1023. The array length should match ControlPointNumber
int BacklightCurve[19] = {4, 80, 300, 300, 300, 300, 300, 384, 484, 536, 600, 736, 776, 848, 872, 972, 1023, 1023, 1023};
}

