/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef ANDROID_CWMCU_SENSOR_H
#define ANDROID_CWMCU_SENSOR_H

#include <stdint.h>
#include <errno.h>
#include <sys/cdefs.h>
#include <sys/types.h>

#include "sensors.h"
#include "SensorBase.h"
#include "InputEventReader.h"

#define	SAVE_PATH_ACC				"/data/system/cw_calibrator_acc.ini"
#define	SAVE_PATH_MAG				"/data/system/cw_calibrator_mag.ini"
#define	SAVE_PATH_GYRO				"/data/system/cw_calibrator_gyro.ini"

/*****************************************************************************/
struct input_event;
class CwMcuSensor : public SensorBase {

	uint32_t mEnabled;
	InputEventCircularReader mInputReader;
	sensors_event_t mPendingEvents[CW_SENSORS_ID_END];
	sensors_event_t mPendingEvents_flush;
	bool mHasPendingEvent;
	uint32_t mPendingMask;
	char input_sysfs_path[PATH_MAX];
	int input_sysfs_path_len;
	int64_t mEnabledTime;
	int flush_event;
	int setInitialState();
	int write_to_file(int type,int data);
	uint16_t pedometer_l;
	uint16_t pedometer_h;

public:
	CwMcuSensor();
	virtual ~CwMcuSensor();
	virtual int readEvents(sensors_event_t* data, int count);
	virtual bool hasPendingEvents() const;
	virtual int setDelay(int32_t handle, int64_t ns);
	virtual int enable(int32_t handle, int enabled);
	virtual int batch(int handle, int flags, int64_t period_ns, int64_t timeout);
	virtual int flush(int handle);
	int find_sensor(int32_t handle);
	void processEvent(int code, int value);

	int cw_read_calibrator_file(int type, char *path, int *calib);
	int cw_save_calibrator_file(int type, char *path, int *calib);
	int cw_read_calibrator_sysfs(int type, char *path, int *calib);
	int cw_save_calibrator_sysfs(int type, char *path, int *calib);

};

/*****************************************************************************/

#endif  // ANDROID_CWMCU_SENSOR_H
