/******************************************************************************
*
 *
 * Filename:
 * ---------
 *   AudDrv_Common.h
 *
 * Project:
 * --------
 *   MT6583 FPGA LDVT Audio Driver
 *
 * Description:
 * ------------
 *   Audio register
 *
 * Author:
 * -------
 *   Chipeng Chang (MTK02308)
 *
 *---------------------------------------------------------------------------
---
 * $Revision: #1 $
 * $Modtime:$
 * $Log:$
 *
 *

*******************************************************************************/

#ifndef AUDIO_DEF_H
#define AUDIO_DEF_H

// Type re-definition
#ifndef int8
typedef signed char int8;
#endif

#ifndef uint8
typedef unsigned char uint8;
#endif

#ifndef int16
typedef short int16;
#endif

#ifndef uint16
typedef unsigned short uint16;
#endif

#ifndef int32
typedef int int32;
#endif

#ifndef uint32
typedef unsigned int uint32;
#endif

#ifndef int64
typedef long long int64;
#endif

#ifndef uint64
typedef unsigned long long uint64;
#endif

#define PM_MANAGER_API
#define AUDIO_MEMORY_SRAM
#define AUDIO_MEM_IOREMAP


// below for audio debugging
#define DEBUG_AUDDRV
#define DEBUG_AFE_REG
#define DEBUG_ANA_REG
#define DEBUG_AUD_CLK


#ifdef DEBUG_AUDDRV
#define PRINTK_AUDDRV(format, args...) xlog_printk( ANDROID_LOG_VERBOSE,"Sound",format, ##args )
#else
#define PRINTK_AUDDRV(format, args...)
#endif

#ifdef DEBUG_AFE_REG
#define PRINTK_AFE_REG(format, args...) xlog_printk( ANDROID_LOG_VERBOSE,"Sound",format, ##args )
#else
#define PRINTK_AFE_REG(format, args...)
#endif

#ifdef DEBUG_ANA_REG
#define PRINTK_ANA_REG(format, args...) xlog_printk( ANDROID_LOG_VERBOSE,"Sound",format, ##args )
#else
#define PRINTK_ANA_REG(format, args...)
#endif

#ifdef DEBUG_AUD_CLK
#define PRINTK_AUD_CLK(format, args...) xlog_printk( ANDROID_LOG_VERBOSE,"Sound",format, ##args )
#else
#define PRINTK_AUD_CLK(format, args...)
#endif

#define PRINTK_AUD_ERROR(format, args...) xlog_printk( ANDROID_LOG_VERBOSE,"Sound",format, ##args )


#ifdef DEBUG_AUDDRV
#define PRINTK_AUDDRV(format, args...) printk(format, ##args )
#else
#define PRINTK_AUDDRV(format, args...)
#endif

#ifdef DEBUG_AFE_REG
#define PRINTK_AFE_REG(format, args...) printk(format, ##args )
#else
#define PRINTK_AFE_REG(format, args...)
#endif

#ifdef DEBUG_ANA_REG
#define PRINTK_ANA_REG(format, args...) printk(format, ##args )
#else
#define PRINTK_ANA_REG(format, args...)
#endif

#ifdef DEBUG_AUD_CLK
#define PRINTK_AUD_CLK(format, args...)  printk(format, ##args )
#else
#define PRINTK_AUD_CLK(format, args...)
#endif

#define PRINTK_AUD_ERROR(format, args...)  printk(format, ##args )

// if need assert , use AUDIO_ASSERT(true)
#define AUDIO_ASSERT(value) BUG_ON(false)


/**********************************
 *  Other Definitions             *
 **********************************/
#define BIT_00  0x00000001        /* ---- ---- ---- ---- ---- ---- ---- ---1 */
#define BIT_01  0x00000002        /* ---- ---- ---- ---- ---- ---- ---- --1- */
#define BIT_02  0x00000004        /* ---- ---- ---- ---- ---- ---- ---- -1-- */
#define BIT_03  0x00000008        /* ---- ---- ---- ---- ---- ---- ---- 1--- */
#define BIT_04  0x00000010        /* ---- ---- ---- ---- ---- ---- ---1 ---- */
#define BIT_05  0x00000020        /* ---- ---- ---- ---- ---- ---- --1- ---- */
#define BIT_06  0x00000040        /* ---- ---- ---- ---- ---- ---- -1-- ---- */
#define BIT_07  0x00000080        /* ---- ---- ---- ---- ---- ---- 1--- ---- */
#define BIT_08  0x00000100        /* ---- ---- ---- ---- ---- ---1 ---- ---- */
#define BIT_09  0x00000200        /* ---- ---- ---- ---- ---- --1- ---- ---- */
#define BIT_10  0x00000400        /* ---- ---- ---- ---- ---- -1-- ---- ---- */
#define BIT_11  0x00000800        /* ---- ---- ---- ---- ---- 1--- ---- ---- */
#define BIT_12  0x00001000        /* ---- ---- ---- ---- ---1 ---- ---- ---- */
#define BIT_13  0x00002000        /* ---- ---- ---- ---- --1- ---- ---- ---- */
#define BIT_14  0x00004000        /* ---- ---- ---- ---- -1-- ---- ---- ---- */
#define BIT_15  0x00008000        /* ---- ---- ---- ---- 1--- ---- ---- ---- */
#define BIT_16  0x00010000        /* ---- ---- ---- ---1 ---- ---- ---- ---- */
#define BIT_17  0x00020000        /* ---- ---- ---- --1- ---- ---- ---- ---- */
#define BIT_18  0x00040000        /* ---- ---- ---- -1-- ---- ---- ---- ---- */
#define BIT_19  0x00080000        /* ---- ---- ---- 1--- ---- ---- ---- ---- */
#define BIT_20  0x00100000        /* ---- ---- ---1 ---- ---- ---- ---- ---- */
#define BIT_21  0x00200000        /* ---- ---- --1- ---- ---- ---- ---- ---- */
#define BIT_22  0x00400000        /* ---- ---- -1-- ---- ---- ---- ---- ---- */
#define BIT_23  0x00800000        /* ---- ---- 1--- ---- ---- ---- ---- ---- */
#define BIT_24  0x01000000        /* ---- ---1 ---- ---- ---- ---- ---- ---- */
#define BIT_25  0x02000000        /* ---- --1- ---- ---- ---- ---- ---- ---- */
#define BIT_26  0x04000000        /* ---- -1-- ---- ---- ---- ---- ---- ---- */
#define BIT_27  0x08000000        /* ---- 1--- ---- ---- ---- ---- ---- ---- */
#define BIT_28  0x10000000        /* ---1 ---- ---- ---- ---- ---- ---- ---- */
#define BIT_29  0x20000000        /* --1- ---- ---- ---- ---- ---- ---- ---- */
#define BIT_30  0x40000000        /* -1-- ---- ---- ---- ---- ---- ---- ---- */
#define BIT_31  0x80000000        /* 1--- ---- ---- ---- ---- ---- ---- ---- */

#endif


