#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/spinlock.h>
#include <linux/delay.h>  

#include <mach/irqs.h>
#include <mach/mt_cirq.h>
#include <mach/mt_spm_idle.h>
#include <mach/mt_cpuidle.h>
#include <mach/wd_api.h>
#include <mach/mt_gpt.h>
#include <mach/mt_cpufreq.h>
#include <mach/mt_dramc.h>
#include <mach/mt_boot.h>

#include "mt_spm_internal.h"


/**************************************
 * only for internal debug
 **************************************/
//FIXME: for FPGA early porting
#define  CONFIG_MTK_LDVT

#ifdef CONFIG_MTK_LDVT
#define SPM_PWAKE_EN            0
#define SPM_BYPASS_SYSPWREQ     1
#else
#define SPM_PWAKE_EN            1
#define SPM_BYPASS_SYSPWREQ     0
#endif

#define WAKE_SRC_FOR_DPIDLE                                                                      \
    (WAKE_SRC_KP | WAKE_SRC_GPT | WAKE_SRC_EINT | WAKE_SRC_CCIF_MD | WAKE_SRC_MD32 |             \
     WAKE_SRC_USB_CD | WAKE_SRC_USB_PDN | WAKE_SRC_AFE | WAKE_SRC_THERM | WAKE_SRC_PMIC_EINT_0 | \
     WAKE_SRC_PMIC_EINT_1 | WAKE_SRC_SYSPWREQ | WAKE_SRC_MD_WDT | WAKE_SRC_CLDMA_MD |            \
     WAKE_SRC_SEJ)

#define WAKE_SRC_FOR_MD32  0                                          \
    //(WAKE_SRC_AUD_MD32)


#define spm_is_wakesrc_invalid(wakesrc)     (!!((u32)(wakesrc) & 0xc0003803))

/**********************************************************
 * PCM E1 code for deep idle
 **********************************************************/
#if SPM_CTRL_BIG_CPU
static const u32 dpidle_binary[] = {
	0x1800001f, 0x17cf7f16, 0xc0c026a0, 0x10c0041f, 0xe8208000, 0x10006b04,
	0x00000008, 0xe8208000, 0x10006b04, 0x00000010, 0xe8208000, 0x10006354,
	0xfffe7fff, 0xe8208000, 0x10006b04, 0x00000000, 0xc2802e00, 0x1290041f,
	0x8880000c, 0x2f7be75f, 0xd8200342, 0x17c07c1f, 0x1b00001f, 0x7fffe7ff,
	0xd0000380, 0x17c07c1f, 0x1b00001f, 0x7ffff7ff, 0xf0000000, 0x17c07c1f,
	0xe8208000, 0x10006354, 0xffffffff, 0xc0c026a0, 0x10c07c1f, 0xe8208000,
	0x10006b04, 0x00000002, 0xc2802e00, 0x1290841f, 0x1800001f, 0x17cf7f36,
	0x1b00001f, 0x3fffefff, 0xf0000000, 0x17c07c1f, 0x81411801, 0xd8000985,
	0x17c07c1f, 0xe8208000, 0x1000f600, 0xd2000000, 0x1b80001f, 0x20000208,
	0x18c0001f, 0x10006240, 0xe0e00016, 0xe0e0001e, 0xe0e0000e, 0xe0e0000f,
	0x18c0001f, 0x100040e4, 0x1910001f, 0x100040e4, 0xa1158404, 0xe0c00004,
	0x81358404, 0xe0c00004, 0x18c0001f, 0x100110e4, 0x1910001f, 0x100110e4,
	0xa1158404, 0xe0c00004, 0x81358404, 0xe0c00004, 0x1800001f, 0x17cf5f16,
	0x1b80001f, 0x20000208, 0x1800001f, 0x17cf1f16, 0x1b80001f, 0x20000208,
	0x1800001f, 0x17cf0f16, 0x1800001f, 0x07cf0f16, 0x1b80001f, 0x20000208,
	0x1800001f, 0x07ce0f16, 0x1b80001f, 0x20000208, 0x1800001f, 0x078e0f16,
	0x1b80001f, 0x20000208, 0x1800001f, 0x038e0f16, 0xa01d8400, 0x81481801,
	0xd8000d85, 0x17c07c1f, 0x1b80001f, 0x20000208, 0xd0000dc0, 0x17c07c1f,
	0x1b80001f, 0x20000a50, 0x803d8400, 0x1b80001f, 0x2000001a, 0x18c0001f,
	0x1000f5c8, 0x1910001f, 0x1000f5c8, 0xa1000404, 0xe0c00004, 0x18c0001f,
	0x100125c8, 0x1910001f, 0x100125c8, 0xa1000404, 0xe0c00004, 0x1910001f,
	0x100125c8, 0x80340400, 0x17c07c1f, 0x17c07c1f, 0x1800001f, 0x038e0e12,
	0x1b80001f, 0x2000000a, 0x18c0001f, 0x10006240, 0xe0e0000d, 0xd80011a5,
	0x17c07c1f, 0xc2803880, 0x17c07c1f, 0x1b80001f, 0x20000100, 0x81fa0407,
	0x81f18407, 0x81f08407, 0xe8208000, 0x10006354, 0xfffe7b47, 0xa1d80407,
	0xa1dc0407, 0xc2802e00, 0x1291041f, 0x8880000c, 0x2f7be75f, 0xd8201422,
	0x17c07c1f, 0x1b00001f, 0x3fffe7ff, 0xd0001460, 0x17c07c1f, 0x1b00001f,
	0xbfffe7ff, 0xf0000000, 0x17c07c1f, 0x1b80001f, 0x20000fdf, 0x1890001f,
	0x10006608, 0x80c98801, 0x810a8801, 0x10918c1f, 0xa0939002, 0x8080080d,
	0xd8201742, 0x17c07c1f, 0x1b00001f, 0x3fffe7ff, 0x1b80001f, 0x20000004,
	0xd8001dcc, 0x17c07c1f, 0x1b00001f, 0xbfffe7ff, 0xd0001dc0, 0x17c07c1f,
	0x81f80407, 0x81fc0407, 0x1880001f, 0x10006320, 0xc0c02240, 0xe080000f,
	0xd8001603, 0x17c07c1f, 0xe080001f, 0xa1da0407, 0x1800001f, 0x038e0e16,
	0x1800001f, 0x038e0f16, 0x18c0001f, 0x1000f5c8, 0x1910001f, 0x1000f5c8,
	0x81200404, 0xe0c00004, 0x18c0001f, 0x100125c8, 0x1910001f, 0x100125c8,
	0x81200404, 0xe0c00004, 0x1910001f, 0x100125c8, 0x1800001f, 0x07cf0f16,
	0x1800001f, 0x17cf0f16, 0x1800001f, 0x17cf1f16, 0x1800001f, 0x17cf7f16,
	0x1b80001f, 0x20000104, 0x81411801, 0xd8001d45, 0x17c07c1f, 0x18c0001f,
	0x10006240, 0xc0c02140, 0x17c07c1f, 0xe8208000, 0x1000f600, 0xd2000001,
	0xc2802e00, 0x1291841f, 0x1b00001f, 0x7ffff7ff, 0xf0000000, 0x17c07c1f,
	0x1900001f, 0x10006830, 0xe1000003, 0xe8208000, 0x10006834, 0x00000000,
	0xe8208000, 0x10006834, 0x00000001, 0xf0000000, 0x17c07c1f, 0xe0f07f16,
	0x1380201f, 0xe0f07f1e, 0x1380201f, 0xe0f07f0e, 0x1b80001f, 0x20000104,
	0xe0f07f0c, 0xe0f07f0d, 0xe0f07e0d, 0xe0f07c0d, 0xe0f0780d, 0xe0f0700d,
	0xf0000000, 0x17c07c1f, 0xe0f07f0d, 0xe0f07f0f, 0xe0f07f1e, 0x1b80001f,
	0x20000080, 0xe0f07f12, 0xf0000000, 0x17c07c1f, 0x11407c1f, 0x81f08407,
	0x81f18407, 0x1b80001f, 0x20000007, 0xa1d08407, 0xa1d18407, 0x1b80001f,
	0x20000020, 0x812ab401, 0x80ebb401, 0xa0c00c04, 0xd8202463, 0x17c07c1f,
	0x80c01403, 0xd8202263, 0x01400405, 0x1900001f, 0x10006814, 0xf0000000,
	0xe1000003, 0xa1d10407, 0x1b80001f, 0x20000020, 0xf0000000, 0x17c07c1f,
	0xa1d00407, 0x1b80001f, 0x20000100, 0x80ea3401, 0x1a00001f, 0x10006814,
	0xe2000003, 0xf0000000, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xd8002823,
	0x17c07c1f, 0xe2200007, 0x1b80001f, 0x2000008c, 0xe2200005, 0x1b80001f,
	0x2000008c, 0xd82028e3, 0x17c07c1f, 0xe2200004, 0x1b80001f, 0x2000008c,
	0xe2200006, 0x1b80001f, 0x20000208, 0xf0000000, 0x17c07c1f, 0x80390400,
	0x1b80001f, 0x20000034, 0x803c0400, 0x1b80001f, 0x20000300, 0x80350400,
	0x18d0001f, 0x10000040, 0x1900001f, 0x10000040, 0xb8c08003, 0xfffffff8,
	0x00000001, 0xe1000003, 0x1b80001f, 0x20000104, 0x81f90407, 0x81f40407,
	0xf0000000, 0x17c07c1f, 0xa1d40407, 0x1391841f, 0xa1d90407, 0x18d0001f,
	0x10000040, 0x1900001f, 0x10000040, 0xb8c08003, 0xfffffff8, 0x00000006,
	0xe1000003, 0x1b80001f, 0x20000104, 0xa0150400, 0xa01c0400, 0xa0190400,
	0xf0000000, 0x17c07c1f, 0x18c0001f, 0x10006b6c, 0x1910001f, 0x10006b6c,
	0xa1002804, 0xe0c00004, 0xf0000000, 0x17c07c1f, 0x1910001f, 0x1000f5cc,
	0x18c0001f, 0x1000f5cc, 0x1a50001f, 0x100125cc, 0x1a00001f, 0x100125cc,
	0xa1000404, 0xa2400409, 0xe0c00004, 0xe2000009, 0xa1120404, 0xa2520409,
	0xe0c00004, 0xe2000009, 0xa1140404, 0xa2540409, 0xe0c00004, 0xe2000009,
	0xa1160404, 0xa2560409, 0xe0c00004, 0xe2000009, 0x1910001f, 0x10012640,
	0x18c0001f, 0x10012640, 0xa1120404, 0xe0c00004, 0x81328404, 0xe0c00004,
	0xa1128404, 0xe0c00004, 0x1910001f, 0x1000f640, 0x18c0001f, 0x1000f640,
	0xa1108404, 0xe0c00004, 0x81308404, 0xe0c00004, 0x1910001f, 0x1000f690,
	0x18c0001f, 0x1000f690, 0xa1108404, 0xe0c00004, 0x81308404, 0xe0c00004,
	0x1910001f, 0x1000f5cc, 0x18c0001f, 0x1000f5cc, 0x1a50001f, 0x100125cc,
	0x1a00001f, 0x100125cc, 0x81200404, 0x82600409, 0xe0c00004, 0xe2000009,
	0x81320404, 0x82720409, 0xe0c00004, 0xe2000009, 0x81340404, 0x82740409,
	0xe0c00004, 0xe2000009, 0x81360404, 0x82760409, 0xe0c00004, 0xe2000009,
	0xf0000000, 0x17c07c1f, 0xf0000000, 0x17c07c1f, 0x18c0001f, 0x10011008,
	0x1910001f, 0x10011008, 0xa11f8404, 0xe0c00004, 0x1b80001f, 0x2000fff0,
	0x18c0001f, 0x10004020, 0x1910001f, 0x102133fc, 0xe0c00004, 0x18c0001f,
	0x10011008, 0x1910001f, 0x10011008, 0x813f8404, 0xe0c00004, 0xf0000000,
	0x17c07c1f, 0x18c0001f, 0x10011008, 0x1910001f, 0x10011008, 0xa11f8404,
	0xe0c00004, 0x1b80001f, 0x2000fff0, 0x18c0001f, 0x10004024, 0x1910001f,
	0x102133fc, 0xe0c00004, 0x18c0001f, 0x10011008, 0x1910001f, 0x10011008,
	0x813f8404, 0xe0c00004, 0xf0000000, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0x1a50001f, 0x10006610, 0x8246a401, 0xe8208000, 0x10006b6c,
	0x00000000, 0x1b00001f, 0x2f7be75f, 0x1b80001f, 0xd00f0000, 0x8880000c,
	0x2f7be75f, 0xd8006302, 0x17c07c1f, 0xe8208000, 0x10006354, 0xfffe7b47,
	0xc0c024e0, 0x81401801, 0xd8004885, 0x17c07c1f, 0x81f60407, 0x18c0001f,
	0x100062a0, 0xc0c063c0, 0x12807c1f, 0x18c0001f, 0x100062b4, 0x1910001f,
	0x100062b4, 0xa9000004, 0x00000001, 0xe0c00004, 0xa9000004, 0x00000011,
	0xe0c00004, 0x18c0001f, 0x100062a0, 0xc0c063c0, 0x1280041f, 0x18c0001f,
	0x100062b0, 0xc0c063c0, 0x12807c1f, 0xe8208000, 0x100062b8, 0x00000000,
	0x1b80001f, 0x20000080, 0xe8208000, 0x100062b8, 0x00000040, 0xc0c063c0,
	0x1280041f, 0x18c0001f, 0x10006290, 0xc0c063c0, 0x1280041f, 0xe8208000,
	0x10006404, 0x00003101, 0xc2802e00, 0x1292041f, 0xc0c06a20, 0x17c07c1f,
	0x18c0001f, 0x10006294, 0xe0f07fff, 0xe0e00fff, 0xe0e000ff, 0x81449801,
	0xd8004c65, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200003, 0xc0c06ae0,
	0x17c07c1f, 0xe2200001, 0x81459801, 0xd8004ba5, 0x17c07c1f, 0x18c0001f,
	0x10005468, 0x1111041f, 0xe0c00004, 0xd0004c20, 0x17c07c1f, 0x18c0001f,
	0x10005468, 0x1113841f, 0xe0c00004, 0xc0c06ae0, 0x17c07c1f, 0xa1d38407,
	0xa1d98407, 0x1800001f, 0x00000012, 0x1800001f, 0x00000e12, 0x1800001f,
	0x03800e12, 0x1800001f, 0x038e0e12, 0x18c0001f, 0x10209200, 0x1910001f,
	0x10209200, 0x81200404, 0xe0c00004, 0x18c0001f, 0x1020920c, 0x1910001f,
	0x1020920c, 0xa1108404, 0xe0c00004, 0x81200404, 0xe0c00004, 0xe8208000,
	0x10006310, 0x0b1600f8, 0x1b00001f, 0xbfffe7ff, 0x1b80001f, 0x90100000,
	0x80c28001, 0xd8205143, 0x17c07c1f, 0xa1dd8407, 0x1b00001f, 0x3fffefff,
	0xd0005000, 0x17c07c1f, 0x1890001f, 0x100063e8, 0x88c0000c, 0x2f7be75f,
	0xd8005363, 0x17c07c1f, 0x80c10001, 0xd80052e3, 0x17c07c1f, 0x1b00001f,
	0xbfffe7ff, 0xd0005320, 0x17c07c1f, 0x1b00001f, 0x7ffff7ff, 0xd0005000,
	0x17c07c1f, 0x80c10001, 0xd8205463, 0x17c07c1f, 0xa1de0407, 0x1b00001f,
	0x7fffe7ff, 0xd0005000, 0x17c07c1f, 0x18c0001f, 0x10006294, 0xe0e001fe,
	0xe0e003fc, 0xe0e007f8, 0xe0e00ff0, 0x1b80001f, 0x20000020, 0xe0f07ff0,
	0xe0f07f00, 0x81449801, 0xd80058a5, 0x17c07c1f, 0x1a00001f, 0x10006604,
	0xe2200000, 0x81459801, 0xd8005785, 0x17c07c1f, 0x18c0001f, 0x10005464,
	0x1111041f, 0xe0c00004, 0xd0005800, 0x17c07c1f, 0x18c0001f, 0x10005464,
	0x1113841f, 0xe0c00004, 0xc0c06ae0, 0x17c07c1f, 0xe2200002, 0xc0c06ae0,
	0x17c07c1f, 0x1800001f, 0x03800e12, 0x18c0001f, 0x1020920c, 0x1910001f,
	0x1020920c, 0xa1000404, 0xe0c00004, 0x1b80001f, 0x20000300, 0x1800001f,
	0x00000e12, 0x81308404, 0xe0c00004, 0x18c0001f, 0x10209200, 0x1910001f,
	0x10209200, 0xa1000404, 0xe0c00004, 0x1b80001f, 0x20000300, 0x1800001f,
	0x00000012, 0x1b80001f, 0x20000104, 0x10007c1f, 0x81f38407, 0x81f98407,
	0x81f90407, 0x81f40407, 0x81401801, 0xd8006305, 0x17c07c1f, 0xe8208000,
	0x10006404, 0x00001101, 0x18c0001f, 0x10006290, 0x1212841f, 0xc0c06520,
	0x12807c1f, 0xc0c06520, 0x1280041f, 0x18c0001f, 0x100062b0, 0x1212841f,
	0xc0c06520, 0x12807c1f, 0xe8208000, 0x100062b8, 0x00000000, 0xe8208000,
	0x100062b8, 0x00000010, 0x1b80001f, 0x20000080, 0xc0c06520, 0x1280041f,
	0xe8208000, 0x10200268, 0x000ffffe, 0x18c0001f, 0x100062a0, 0x1212841f,
	0xc0c06520, 0x12807c1f, 0x18c0001f, 0x100062b4, 0x1910001f, 0x100062b4,
	0x89000004, 0xffffffef, 0xe0c00004, 0x89000004, 0xffffffee, 0xe0c00004,
	0x1b80001f, 0x20000a50, 0x18c0001f, 0x100062a0, 0xc0c06520, 0x1280041f,
	0x19c0001f, 0x01411820, 0x1ac0001f, 0x55aa55aa, 0x10007c1f, 0xf0000000,
	0xd800644a, 0x17c07c1f, 0xe2e0006d, 0xe2e0002d, 0xd82064ea, 0x17c07c1f,
	0xe2e0002f, 0xe2e0003e, 0xe2e00032, 0xf0000000, 0x17c07c1f, 0xd800662a,
	0x17c07c1f, 0xe2e00036, 0x1380201f, 0xe2e0003e, 0x1380201f, 0xe2e0002e,
	0x1380201f, 0xd820672a, 0x17c07c1f, 0xe2e0006e, 0xe2e0004e, 0xe2e0004c,
	0x1b80001f, 0x20000020, 0xe2e0004d, 0xf0000000, 0x17c07c1f, 0xd8206869,
	0x17c07c1f, 0xe2e0000d, 0xe2e0000c, 0xe2e0001c, 0xe2e0001e, 0xe2e00016,
	0xe2e00012, 0xf0000000, 0x17c07c1f, 0xd82069e9, 0x17c07c1f, 0xe2e00016,
	0x1380201f, 0xe2e0001e, 0x1380201f, 0xe2e0001c, 0x1380201f, 0xe2e0000c,
	0xe2e0000d, 0xf0000000, 0x17c07c1f, 0xa1d40407, 0x1391841f, 0xa1d90407,
	0x1393041f, 0xf0000000, 0x17c07c1f, 0x1910001f, 0x10006604, 0x10cf901f,
	0xd8206ae3, 0x17c07c1f, 0xf0000000, 0x17c07c1f
};
static struct pcm_desc dpidle_pcm = {
	.version	= "pcm_deepidle_e2_v15.15_2014_0617_srf_mr4_txrf",
	.base		= dpidle_binary,
	.size		= 862,
	.sess		= 2,
	.replace	= 0,
	.vec0		= EVENT_VEC(11, 1, 0, 0),	/* FUNC_26M_WAKEUP */
	.vec1		= EVENT_VEC(12, 1, 0, 30),	/* FUNC_26M_SLEEP */
	.vec2		= EVENT_VEC(30, 1, 0, 46),	/* FUNC_APSRC_WAKEUP */
	.vec3		= EVENT_VEC(31, 1, 0, 165),	/* FUNC_APSRC_SLEEP */
};

#else	/* !SPM_CTRL_BIG_CPU */
static const u32 dpidle_binary[] = {
	0x1800001f, 0x17cf7f16, 0xc0c026a0, 0x10c0041f, 0xe8208000, 0x10006b04,
	0x00000008, 0xe8208000, 0x10006b04, 0x00000010, 0xe8208000, 0x10006354,
	0xfffe7fff, 0xe8208000, 0x10006b04, 0x00000000, 0xc2802e00, 0x1290041f,
	0x8880000c, 0x2f7be75f, 0xd8200342, 0x17c07c1f, 0x1b00001f, 0x7fffe7ff,
	0xd0000380, 0x17c07c1f, 0x1b00001f, 0x7ffff7ff, 0xf0000000, 0x17c07c1f,
	0xe8208000, 0x10006354, 0xffffffff, 0xc0c026a0, 0x10c07c1f, 0xe8208000,
	0x10006b04, 0x00000002, 0xc2802e00, 0x1290841f, 0x1800001f, 0x17cf7f36,
	0x1b00001f, 0x3fffefff, 0xf0000000, 0x17c07c1f, 0x81411801, 0xd8000985,
	0x17c07c1f, 0xe8208000, 0x1000f600, 0xd2000000, 0x1b80001f, 0x20000208,
	0x18c0001f, 0x10006240, 0xe0e00016, 0xe0e0001e, 0xe0e0000e, 0xe0e0000f,
	0x18c0001f, 0x100040e4, 0x1910001f, 0x100040e4, 0xa1158404, 0xe0c00004,
	0x81358404, 0xe0c00004, 0x18c0001f, 0x100110e4, 0x1910001f, 0x100110e4,
	0xa1158404, 0xe0c00004, 0x81358404, 0xe0c00004, 0x1800001f, 0x17cf5f16,
	0x1b80001f, 0x20000208, 0x1800001f, 0x17cf1f16, 0x1b80001f, 0x20000208,
	0x1800001f, 0x17cf0f16, 0x1800001f, 0x07cf0f16, 0x1b80001f, 0x20000208,
	0x1800001f, 0x07ce0f16, 0x1b80001f, 0x20000208, 0x1800001f, 0x078e0f16,
	0x1b80001f, 0x20000208, 0x1800001f, 0x038e0f16, 0xa01d8400, 0x81481801,
	0xd8000d85, 0x17c07c1f, 0x1b80001f, 0x20000208, 0xd0000dc0, 0x17c07c1f,
	0x1b80001f, 0x20000a50, 0x803d8400, 0x1b80001f, 0x2000001a, 0x18c0001f,
	0x1000f5c8, 0x1910001f, 0x1000f5c8, 0xa1000404, 0xe0c00004, 0x18c0001f,
	0x100125c8, 0x1910001f, 0x100125c8, 0xa1000404, 0xe0c00004, 0x1910001f,
	0x100125c8, 0x80340400, 0x17c07c1f, 0x17c07c1f, 0x1800001f, 0x038e0e12,
	0x1b80001f, 0x2000000a, 0x18c0001f, 0x10006240, 0xe0e0000d, 0xd80011a5,
	0x17c07c1f, 0xc2803880, 0x17c07c1f, 0x1b80001f, 0x20000100, 0x81fa0407,
	0x81f18407, 0x81f08407, 0xe8208000, 0x10006354, 0xfffe7b47, 0xa1d80407,
	0xa1dc0407, 0xc2802e00, 0x1291041f, 0x8880000c, 0x2f7be75f, 0xd8201422,
	0x17c07c1f, 0x1b00001f, 0x3fffe7ff, 0xd0001460, 0x17c07c1f, 0x1b00001f,
	0xbfffe7ff, 0xf0000000, 0x17c07c1f, 0x1b80001f, 0x20000fdf, 0x1890001f,
	0x10006608, 0x80c98801, 0x810a8801, 0x10918c1f, 0xa0939002, 0x8080080d,
	0xd8201742, 0x17c07c1f, 0x1b00001f, 0x3fffe7ff, 0x1b80001f, 0x20000004,
	0xd8001dcc, 0x17c07c1f, 0x1b00001f, 0xbfffe7ff, 0xd0001dc0, 0x17c07c1f,
	0x81f80407, 0x81fc0407, 0x1880001f, 0x10006320, 0xc0c02240, 0xe080000f,
	0xd8001603, 0x17c07c1f, 0xe080001f, 0xa1da0407, 0x1800001f, 0x038e0e16,
	0x1800001f, 0x038e0f16, 0x18c0001f, 0x1000f5c8, 0x1910001f, 0x1000f5c8,
	0x81200404, 0xe0c00004, 0x18c0001f, 0x100125c8, 0x1910001f, 0x100125c8,
	0x81200404, 0xe0c00004, 0x1910001f, 0x100125c8, 0x1800001f, 0x07cf0f16,
	0x1800001f, 0x17cf0f16, 0x1800001f, 0x17cf1f16, 0x1800001f, 0x17cf7f16,
	0x1b80001f, 0x20000104, 0x81411801, 0xd8001d45, 0x17c07c1f, 0x18c0001f,
	0x10006240, 0xc0c02140, 0x17c07c1f, 0xe8208000, 0x1000f600, 0xd2000001,
	0xc2802e00, 0x1291841f, 0x1b00001f, 0x7ffff7ff, 0xf0000000, 0x17c07c1f,
	0x1900001f, 0x10006830, 0xe1000003, 0xe8208000, 0x10006834, 0x00000000,
	0xe8208000, 0x10006834, 0x00000001, 0xf0000000, 0x17c07c1f, 0xe0f07f16,
	0x1380201f, 0xe0f07f1e, 0x1380201f, 0xe0f07f0e, 0x1b80001f, 0x20000104,
	0xe0f07f0c, 0xe0f07f0d, 0xe0f07e0d, 0xe0f07c0d, 0xe0f0780d, 0xe0f0700d,
	0xf0000000, 0x17c07c1f, 0xe0f07f0d, 0xe0f07f0f, 0xe0f07f1e, 0x1b80001f,
	0x20000080, 0xe0f07f12, 0xf0000000, 0x17c07c1f, 0x11407c1f, 0x81f08407,
	0x81f18407, 0x1b80001f, 0x20000007, 0xa1d08407, 0xa1d18407, 0x1b80001f,
	0x20000020, 0x812ab401, 0x80ebb401, 0xa0c00c04, 0xd8202463, 0x17c07c1f,
	0x80c01403, 0xd8202263, 0x01400405, 0x1900001f, 0x10006814, 0xf0000000,
	0xe1000003, 0xa1d10407, 0x1b80001f, 0x20000020, 0xf0000000, 0x17c07c1f,
	0xa1d00407, 0x1b80001f, 0x20000100, 0x80ea3401, 0x1a00001f, 0x10006814,
	0xe2000003, 0xf0000000, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xd8002823,
	0x17c07c1f, 0xe2200007, 0x1b80001f, 0x2000008c, 0xe2200005, 0x1b80001f,
	0x2000008c, 0xd82028e3, 0x17c07c1f, 0xe2200004, 0x1b80001f, 0x2000008c,
	0xe2200006, 0x1b80001f, 0x20000208, 0xf0000000, 0x17c07c1f, 0x80390400,
	0x1b80001f, 0x20000034, 0x803c0400, 0x1b80001f, 0x20000300, 0x80350400,
	0x18d0001f, 0x10000040, 0x1900001f, 0x10000040, 0xb8c08003, 0xfffffff8,
	0x00000001, 0xe1000003, 0x1b80001f, 0x20000104, 0x81f90407, 0x81f40407,
	0xf0000000, 0x17c07c1f, 0xa1d40407, 0x1391841f, 0xa1d90407, 0x18d0001f,
	0x10000040, 0x1900001f, 0x10000040, 0xb8c08003, 0xfffffff8, 0x00000006,
	0xe1000003, 0x1b80001f, 0x20000104, 0xa0150400, 0xa01c0400, 0xa0190400,
	0xf0000000, 0x17c07c1f, 0x18c0001f, 0x10006b6c, 0x1910001f, 0x10006b6c,
	0xa1002804, 0xe0c00004, 0xf0000000, 0x17c07c1f, 0x1910001f, 0x1000f5cc,
	0x18c0001f, 0x1000f5cc, 0x1a50001f, 0x100125cc, 0x1a00001f, 0x100125cc,
	0xa1000404, 0xa2400409, 0xe0c00004, 0xe2000009, 0xa1120404, 0xa2520409,
	0xe0c00004, 0xe2000009, 0xa1140404, 0xa2540409, 0xe0c00004, 0xe2000009,
	0xa1160404, 0xa2560409, 0xe0c00004, 0xe2000009, 0x1910001f, 0x10012640,
	0x18c0001f, 0x10012640, 0xa1120404, 0xe0c00004, 0x81328404, 0xe0c00004,
	0xa1128404, 0xe0c00004, 0x1910001f, 0x1000f640, 0x18c0001f, 0x1000f640,
	0xa1108404, 0xe0c00004, 0x81308404, 0xe0c00004, 0x1910001f, 0x1000f690,
	0x18c0001f, 0x1000f690, 0xa1108404, 0xe0c00004, 0x81308404, 0xe0c00004,
	0x1910001f, 0x1000f5cc, 0x18c0001f, 0x1000f5cc, 0x1a50001f, 0x100125cc,
	0x1a00001f, 0x100125cc, 0x81200404, 0x82600409, 0xe0c00004, 0xe2000009,
	0x81320404, 0x82720409, 0xe0c00004, 0xe2000009, 0x81340404, 0x82740409,
	0xe0c00004, 0xe2000009, 0x81360404, 0x82760409, 0xe0c00004, 0xe2000009,
	0xf0000000, 0x17c07c1f, 0xf0000000, 0x17c07c1f, 0x18c0001f, 0x10011008,
	0x1910001f, 0x10011008, 0xa11f8404, 0xe0c00004, 0x1b80001f, 0x2000fff0,
	0x18c0001f, 0x10004020, 0x1910001f, 0x102133fc, 0xe0c00004, 0x18c0001f,
	0x10011008, 0x1910001f, 0x10011008, 0x813f8404, 0xe0c00004, 0xf0000000,
	0x17c07c1f, 0x18c0001f, 0x10011008, 0x1910001f, 0x10011008, 0xa11f8404,
	0xe0c00004, 0x1b80001f, 0x2000fff0, 0x18c0001f, 0x10004024, 0x1910001f,
	0x102133fc, 0xe0c00004, 0x18c0001f, 0x10011008, 0x1910001f, 0x10011008,
	0x813f8404, 0xe0c00004, 0xf0000000, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0x1a50001f, 0x10006610, 0x8246a401, 0xe8208000, 0x10006b6c,
	0x00000000, 0x1b00001f, 0x2f7be75f, 0x1b80001f, 0xd00f0000, 0x8880000c,
	0x2f7be75f, 0xd8005c02, 0x17c07c1f, 0xe8208000, 0x10006354, 0xfffe7b47,
	0xc0c024e0, 0x81401801, 0xd8004885, 0x17c07c1f, 0x81f60407, 0x18c0001f,
	0x10006200, 0xc0c05cc0, 0x12807c1f, 0xe8208000, 0x1000625c, 0x00000001,
	0x1890001f, 0x1000625c, 0x81040801, 0xd8204444, 0x17c07c1f, 0xc0c05cc0,
	0x1280041f, 0x18c0001f, 0x10006204, 0xc0c06060, 0x1280041f, 0x18c0001f,
	0x10006208, 0xc0c05cc0, 0x12807c1f, 0xe8208000, 0x10006248, 0x00000000,
	0x1890001f, 0x10006248, 0x81040801, 0xd8004684, 0x17c07c1f, 0xc0c05cc0,
	0x1280041f, 0x18c0001f, 0x10006290, 0xc0c05cc0, 0x1280041f, 0xe8208000,
	0x10006404, 0x00003101, 0xc2802e00, 0x1292041f, 0xc0c06320, 0x17c07c1f,
	0x18c0001f, 0x10006294, 0xe0f07fff, 0xe0e00fff, 0xe0e000ff, 0x81449801,
	0xd8004ac5, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200003, 0xc0c063e0,
	0x17c07c1f, 0xe2200001, 0xc0c063e0, 0x17c07c1f, 0xa1d38407, 0xa1d98407,
	0x1800001f, 0x00000012, 0x1800001f, 0x00000e12, 0x1800001f, 0x03800e12,
	0x1800001f, 0x038e0e12, 0xe8208000, 0x10006310, 0x0b1600f8, 0x1b00001f,
	0xbfffe7ff, 0x1b80001f, 0x90100000, 0x80c28001, 0xd8204de3, 0x17c07c1f,
	0xa1dd8407, 0x1b00001f, 0x3fffefff, 0xd0004ca0, 0x17c07c1f, 0x1890001f,
	0x100063e8, 0x88c0000c, 0x2f7be75f, 0xd8005003, 0x17c07c1f, 0x80c10001,
	0xd8004f83, 0x17c07c1f, 0x1b00001f, 0xbfffe7ff, 0xd0004fc0, 0x17c07c1f,
	0x1b00001f, 0x7ffff7ff, 0xd0004ca0, 0x17c07c1f, 0x80c10001, 0xd8205103,
	0x17c07c1f, 0xa1de0407, 0x1b00001f, 0x7fffe7ff, 0xd0004ca0, 0x17c07c1f,
	0x18c0001f, 0x10006294, 0xe0e001fe, 0xe0e003fc, 0xe0e007f8, 0xe0e00ff0,
	0x1b80001f, 0x20000020, 0xe0f07ff0, 0xe0f07f00, 0x81449801, 0xd80053a5,
	0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200000, 0xc0c063e0, 0x17c07c1f,
	0xe2200002, 0xc0c063e0, 0x17c07c1f, 0x1800001f, 0x03800e12, 0x1b80001f,
	0x20000300, 0x1800001f, 0x00000e12, 0x1b80001f, 0x20000300, 0x1800001f,
	0x00000012, 0x1b80001f, 0x20000104, 0x10007c1f, 0x81f38407, 0x81f98407,
	0x81f90407, 0x81f40407, 0x81401801, 0xd8005c05, 0x17c07c1f, 0xe8208000,
	0x10006404, 0x00002101, 0x18c0001f, 0x10006290, 0x1212841f, 0xc0c05e20,
	0x12807c1f, 0xc0c05e20, 0x1280041f, 0x18c0001f, 0x10006208, 0x1212841f,
	0xc0c05e20, 0x12807c1f, 0xe8208000, 0x10006248, 0x00000001, 0x1890001f,
	0x10006248, 0x81040801, 0xd8205864, 0x17c07c1f, 0x1b80001f, 0x20000020,
	0xc0c05e20, 0x1280041f, 0x18c0001f, 0x10006204, 0x1212841f, 0xc0c061a0,
	0x1280041f, 0x18c0001f, 0x10006200, 0x1212841f, 0xc0c05e20, 0x12807c1f,
	0xe8208000, 0x1000625c, 0x00000000, 0x1890001f, 0x1000625c, 0x81040801,
	0xd8005b24, 0x17c07c1f, 0xc0c05e20, 0x1280041f, 0x19c0001f, 0x01411820,
	0x1ac0001f, 0x55aa55aa, 0x10007c1f, 0xf0000000, 0xd8005d4a, 0x17c07c1f,
	0xe2e0006d, 0xe2e0002d, 0xd8205dea, 0x17c07c1f, 0xe2e0002f, 0xe2e0003e,
	0xe2e00032, 0xf0000000, 0x17c07c1f, 0xd8005f2a, 0x17c07c1f, 0xe2e00036,
	0x1380201f, 0xe2e0003e, 0x1380201f, 0xe2e0002e, 0x1380201f, 0xd820602a,
	0x17c07c1f, 0xe2e0006e, 0xe2e0004e, 0xe2e0004c, 0x1b80001f, 0x20000020,
	0xe2e0004d, 0xf0000000, 0x17c07c1f, 0xd8206169, 0x17c07c1f, 0xe2e0000d,
	0xe2e0000c, 0xe2e0001c, 0xe2e0001e, 0xe2e00016, 0xe2e00012, 0xf0000000,
	0x17c07c1f, 0xd82062e9, 0x17c07c1f, 0xe2e00016, 0x1380201f, 0xe2e0001e,
	0x1380201f, 0xe2e0001c, 0x1380201f, 0xe2e0000c, 0xe2e0000d, 0xf0000000,
	0x17c07c1f, 0xa1d40407, 0x1391841f, 0xa1d90407, 0x1393041f, 0xf0000000,
	0x17c07c1f, 0x1910001f, 0x10006604, 0x10cf901f, 0xd82063e3, 0x17c07c1f,
	0xf0000000, 0x17c07c1f
};
static struct pcm_desc dpidle_pcm = {
	.version	= "pcm_deepidle_e2_v15.15_2014_0617_srf_mr4_txrf",
	.base		= dpidle_binary,
	.size		= 806,
	.sess		= 2,
	.replace	= 0,
	.vec0		= EVENT_VEC(11, 1, 0, 0),	/* FUNC_26M_WAKEUP */
	.vec1		= EVENT_VEC(12, 1, 0, 30),	/* FUNC_26M_SLEEP */
	.vec2		= EVENT_VEC(30, 1, 0, 46),	/* FUNC_APSRC_WAKEUP */
	.vec3		= EVENT_VEC(31, 1, 0, 165),	/* FUNC_APSRC_SLEEP */
};

#endif

/**********************************************************
 * PCM E2 code for deep idle
 **********************************************************/ 
static const u32 dpidle_binary_e2[] = {
	0x1800001f, 0x17cf7f16, 0x1990001f, 0x10006b08, 0x81419801, 0xd8000125,
	0x17c07c1f, 0xc0c02400, 0x10c0041f, 0xe8208000, 0x10006b04, 0x00000008,
	0xe8208000, 0x10006b04, 0x00000010, 0xe8208000, 0x10006354, 0xfffe7fff,
	0xe8208000, 0x10006b04, 0x00000000, 0xc2802b60, 0x1290041f, 0x8880000c,
	0x2f7be75f, 0xd82003e2, 0x17c07c1f, 0x1b00001f, 0x7fffe7ff, 0xd0000420,
	0x17c07c1f, 0x1b00001f, 0x7ffff7ff, 0xf0000000, 0x17c07c1f, 0xe8208000,
	0x10006354, 0xffffffff, 0x1990001f, 0x10006b08, 0x81419801, 0xd80005a5,
	0x17c07c1f, 0xc0c02400, 0x10c07c1f, 0xe8208000, 0x10006b04, 0x00000002,
	0xc2802b60, 0x1290841f, 0x1800001f, 0x17cf7f36, 0x1b00001f, 0x3fffefff,
	0xf0000000, 0x17c07c1f, 0x81411801, 0xd8000865, 0x17c07c1f, 0xe8208000,
	0x1000f600, 0xd2000000, 0x1b80001f, 0x20000208, 0x18c0001f, 0x10006240,
	0xe0e0000f, 0x1800001f, 0x17cf5f16, 0x1b80001f, 0x20000208, 0x1800001f,
	0x17cf1f16, 0x1b80001f, 0x20000208, 0x1800001f, 0x17cf0f16, 0x1800001f,
	0x07cf0f16, 0x1b80001f, 0x20000208, 0x1800001f, 0x07ce0f16, 0x1800001f,
	0x078e0f16, 0xa01d8400, 0x1b80001f, 0x20000034, 0x803d8400, 0x1b80001f,
	0x20000152, 0x1800001f, 0x038e0f16, 0x1b80001f, 0x20000208, 0x18c0001f,
	0x1000f5c8, 0x1910001f, 0x1000f5c8, 0xa1000404, 0xe0c00004, 0x18c0001f,
	0x100125c8, 0x1910001f, 0x100125c8, 0xa1000404, 0xe0c00004, 0x1910001f,
	0x100125c8, 0x80340400, 0x17c07c1f, 0x17c07c1f, 0x1800001f, 0x038e0e12,
	0x1b80001f, 0x2000000a, 0x18c0001f, 0x10006240, 0xe0e0000d, 0xd8000f65,
	0x17c07c1f, 0xc28035e0, 0x17c07c1f, 0x1b80001f, 0x20000100, 0x81fa0407,
	0x81f18407, 0x81f08407, 0xe8208000, 0x10006354, 0xfffe7b47, 0xa1d80407,
	0xa1dc0407, 0xc2802b60, 0x1291041f, 0x8880000c, 0x2f7be75f, 0xd82011e2,
	0x17c07c1f, 0x1b00001f, 0x3fffe7ff, 0xd0001220, 0x17c07c1f, 0x1b00001f,
	0xbfffe7ff, 0xf0000000, 0x17c07c1f, 0x1b80001f, 0x20000fdf, 0x1890001f,
	0x10006608, 0x80c98801, 0x810a8801, 0x10918c1f, 0xa0939002, 0x8080080d,
	0xd8201502, 0x17c07c1f, 0x1b00001f, 0x3fffe7ff, 0x1b80001f, 0x20000004,
	0xd8001b8c, 0x17c07c1f, 0x1b00001f, 0xbfffe7ff, 0xd0001b80, 0x17c07c1f,
	0x81f80407, 0x81fc0407, 0x1880001f, 0x10006320, 0xc0c01fa0, 0xe080000f,
	0xd80013c3, 0x17c07c1f, 0xe080001f, 0xa1da0407, 0x1800001f, 0x038e0e16,
	0x1800001f, 0x038e0f16, 0x18c0001f, 0x1000f5c8, 0x1910001f, 0x1000f5c8,
	0x81200404, 0xe0c00004, 0x18c0001f, 0x100125c8, 0x1910001f, 0x100125c8,
	0x81200404, 0xe0c00004, 0x1910001f, 0x100125c8, 0x1800001f, 0x07cf0f16,
	0x1800001f, 0x17cf0f16, 0x1800001f, 0x17cf1f16, 0x1800001f, 0x17cf7f16,
	0x1b80001f, 0x20000104, 0x81411801, 0xd8001b05, 0x17c07c1f, 0x18c0001f,
	0x10006240, 0xc0c01f00, 0x17c07c1f, 0xe8208000, 0x1000f600, 0xd2000001,
	0xc2802b60, 0x1291841f, 0x1b00001f, 0x7ffff7ff, 0xf0000000, 0x17c07c1f,
	0x1900001f, 0x10006830, 0xe1000003, 0xe8208000, 0x10006834, 0x00000000,
	0xe8208000, 0x10006834, 0x00000001, 0xf0000000, 0x17c07c1f, 0xe0f07f16,
	0x1380201f, 0xe0f07f1e, 0x1380201f, 0xe0f07f0e, 0x1b80001f, 0x20000104,
	0xe0f07f0c, 0xe0f07f0d, 0xe0f07e0d, 0xe0f07c0d, 0xe0f0780d, 0xe0f0700d,
	0xf0000000, 0x17c07c1f, 0xe0e0000f, 0x1b80001f, 0x20000080, 0xf0000000,
	0x17c07c1f, 0x11407c1f, 0x81f08407, 0x81f18407, 0x1b80001f, 0x20000007,
	0xa1d08407, 0xa1d18407, 0x1b80001f, 0x20000020, 0x812ab401, 0x80ebb401,
	0xa0c00c04, 0xd82021c3, 0x17c07c1f, 0x80c01403, 0xd8201fc3, 0x01400405,
	0x1900001f, 0x10006814, 0xf0000000, 0xe1000003, 0xa1d10407, 0x1b80001f,
	0x20000020, 0xf0000000, 0x17c07c1f, 0xa1d00407, 0x1b80001f, 0x20000100,
	0x80ea3401, 0x1a00001f, 0x10006814, 0xe2000003, 0xf0000000, 0x17c07c1f,
	0x1a00001f, 0x10006604, 0xd8002583, 0x17c07c1f, 0xe2200007, 0x1b80001f,
	0x2000008c, 0xe2200005, 0x1b80001f, 0x2000008c, 0xd8202643, 0x17c07c1f,
	0xe2200004, 0x1b80001f, 0x2000008c, 0xe2200006, 0x1b80001f, 0x20000208,
	0xf0000000, 0x17c07c1f, 0x80390400, 0x1b80001f, 0x20000034, 0x803c0400,
	0x1b80001f, 0x20000300, 0x80350400, 0x18d0001f, 0x10000040, 0x1900001f,
	0x10000040, 0xb8c08003, 0xfffffff8, 0x00000001, 0xe1000003, 0x1b80001f,
	0x20000104, 0x81f90407, 0x81f40407, 0xf0000000, 0x17c07c1f, 0xa1d40407,
	0x1391841f, 0xa1d90407, 0x18d0001f, 0x10000040, 0x1900001f, 0x10000040,
	0xb8c08003, 0xfffffff8, 0x00000006, 0xe1000003, 0x1b80001f, 0x20000104,
	0xa0150400, 0xa01c0400, 0xa0190400, 0xf0000000, 0x17c07c1f, 0x18c0001f,
	0x10006b6c, 0x1910001f, 0x10006b6c, 0xa1002804, 0xe0c00004, 0xf0000000,
	0x17c07c1f, 0x1910001f, 0x1000f5cc, 0x18c0001f, 0x1000f5cc, 0x1a50001f,
	0x100125cc, 0x1a00001f, 0x100125cc, 0xa1000404, 0xa2400409, 0xe0c00004,
	0xe2000009, 0xa1120404, 0xa2520409, 0xe0c00004, 0xe2000009, 0xa1140404,
	0xa2540409, 0xe0c00004, 0xe2000009, 0xa1160404, 0xa2560409, 0xe0c00004,
	0xe2000009, 0x1910001f, 0x10012640, 0x18c0001f, 0x10012640, 0xa1120404,
	0xe0c00004, 0x81328404, 0xe0c00004, 0xa1128404, 0xe0c00004, 0x1910001f,
	0x1000f640, 0x18c0001f, 0x1000f640, 0xa1108404, 0xe0c00004, 0x81308404,
	0xe0c00004, 0x1910001f, 0x1000f690, 0x18c0001f, 0x1000f690, 0xa1108404,
	0xe0c00004, 0x81308404, 0xe0c00004, 0x1910001f, 0x1000f5cc, 0x18c0001f,
	0x1000f5cc, 0x1a50001f, 0x100125cc, 0x1a00001f, 0x100125cc, 0x81200404,
	0x82600409, 0xe0c00004, 0xe2000009, 0x81320404, 0x82720409, 0xe0c00004,
	0xe2000009, 0x81340404, 0x82740409, 0xe0c00004, 0xe2000009, 0x81360404,
	0x82760409, 0xe0c00004, 0xe2000009, 0xf0000000, 0x17c07c1f, 0xf0000000,
	0x17c07c1f, 0x18c0001f, 0x10011008, 0x1910001f, 0x10011008, 0xa11f8404,
	0xe0c00004, 0x1b80001f, 0x2000fff0, 0x18c0001f, 0x10004020, 0x1910001f,
	0x102133fc, 0xe0c00004, 0x18c0001f, 0x10011008, 0x1910001f, 0x10011008,
	0x813f8404, 0xe0c00004, 0xf0000000, 0x17c07c1f, 0x18c0001f, 0x10011008,
	0x1910001f, 0x10011008, 0xa11f8404, 0xe0c00004, 0x1b80001f, 0x2000fff0,
	0x18c0001f, 0x10004024, 0x1910001f, 0x102133fc, 0xe0c00004, 0x18c0001f,
	0x10011008, 0x1910001f, 0x10011008, 0x813f8404, 0xe0c00004, 0xf0000000,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0x1a50001f, 0x10006610, 0x8246a401, 0xe8208000, 0x10006b6c,
	0x00000000, 0x1b00001f, 0x2f7be75f, 0x1b80001f, 0xd00f0000, 0x8880000c,
	0x2f7be75f, 0xd8005c02, 0x17c07c1f, 0xe8208000, 0x10006354, 0xfffe7b47,
	0xc0c02240, 0x81401801, 0xd8004885, 0x17c07c1f, 0x81f60407, 0x18c0001f,
	0x10006200, 0xc0c05cc0, 0x12807c1f, 0xe8208000, 0x1000625c, 0x00000001,
	0x1890001f, 0x1000625c, 0x81040801, 0xd8204444, 0x17c07c1f, 0xc0c05cc0,
	0x1280041f, 0x18c0001f, 0x10006204, 0xc0c06060, 0x1280041f, 0x18c0001f,
	0x10006208, 0xc0c05cc0, 0x12807c1f, 0xe8208000, 0x10006248, 0x00000000,
	0x1890001f, 0x10006248, 0x81040801, 0xd8004684, 0x17c07c1f, 0xc0c05cc0,
	0x1280041f, 0x18c0001f, 0x10006290, 0xc0c05cc0, 0x1280041f, 0xe8208000,
	0x10006404, 0x00003101, 0xc2802b60, 0x1292041f, 0xc0c06320, 0x17c07c1f,
	0x18c0001f, 0x10006294, 0xe0f07fff, 0xe0e00fff, 0xe0e000ff, 0x81449801,
	0xd8004ac5, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200003, 0xc0c063e0,
	0x17c07c1f, 0xe2200001, 0xc0c063e0, 0x17c07c1f, 0xa1d38407, 0xa1d98407,
	0x1800001f, 0x00000012, 0x1800001f, 0x00000e12, 0x1800001f, 0x03800e12,
	0x1800001f, 0x038e0e12, 0xe8208000, 0x10006310, 0x0b1600f8, 0x1b00001f,
	0xbfffe7ff, 0x1b80001f, 0x90100000, 0x80c28001, 0xd8204de3, 0x17c07c1f,
	0xa1dd8407, 0x1b00001f, 0x3fffefff, 0xd0004ca0, 0x17c07c1f, 0x1890001f,
	0x100063e8, 0x88c0000c, 0x2f7be75f, 0xd8005003, 0x17c07c1f, 0x80c10001,
	0xd8004f83, 0x17c07c1f, 0x1b00001f, 0xbfffe7ff, 0xd0004fc0, 0x17c07c1f,
	0x1b00001f, 0x7ffff7ff, 0xd0004ca0, 0x17c07c1f, 0x80c10001, 0xd8205103,
	0x17c07c1f, 0xa1de0407, 0x1b00001f, 0x7fffe7ff, 0xd0004ca0, 0x17c07c1f,
	0x18c0001f, 0x10006294, 0xe0e001fe, 0xe0e003fc, 0xe0e007f8, 0xe0e00ff0,
	0x1b80001f, 0x20000020, 0xe0f07ff0, 0xe0f07f00, 0x81449801, 0xd80053a5,
	0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200000, 0xc0c063e0, 0x17c07c1f,
	0xe2200002, 0xc0c063e0, 0x17c07c1f, 0x1800001f, 0x03800e12, 0x1b80001f,
	0x20000300, 0x1800001f, 0x00000e12, 0x1b80001f, 0x20000300, 0x1800001f,
	0x00000012, 0x1b80001f, 0x20000104, 0x10007c1f, 0x81f38407, 0x81f98407,
	0x81f90407, 0x81f40407, 0x81401801, 0xd8005c05, 0x17c07c1f, 0xe8208000,
	0x10006404, 0x00002101, 0x18c0001f, 0x10006290, 0x1212841f, 0xc0c05e20,
	0x12807c1f, 0xc0c05e20, 0x1280041f, 0x18c0001f, 0x10006208, 0x1212841f,
	0xc0c05e20, 0x12807c1f, 0xe8208000, 0x10006248, 0x00000001, 0x1890001f,
	0x10006248, 0x81040801, 0xd8205864, 0x17c07c1f, 0x1b80001f, 0x20000020,
	0xc0c05e20, 0x1280041f, 0x18c0001f, 0x10006204, 0x1212841f, 0xc0c061a0,
	0x1280041f, 0x18c0001f, 0x10006200, 0x1212841f, 0xc0c05e20, 0x12807c1f,
	0xe8208000, 0x1000625c, 0x00000000, 0x1890001f, 0x1000625c, 0x81040801,
	0xd8005b24, 0x17c07c1f, 0xc0c05e20, 0x1280041f, 0x19c0001f, 0x01411820,
	0x1ac0001f, 0x55aa55aa, 0x10007c1f, 0xf0000000, 0xd8005d4a, 0x17c07c1f,
	0xe2e0006d, 0xe2e0002d, 0xd8205dea, 0x17c07c1f, 0xe2e0002f, 0xe2e0003e,
	0xe2e00032, 0xf0000000, 0x17c07c1f, 0xd8005f4a, 0x17c07c1f, 0xe2e00036,
	0x1380201f, 0xe2e0003e, 0x1380201f, 0xe2e0002e, 0x1380201f, 0xe2e0002c,
	0xd820602a, 0x17c07c1f, 0xe2e0006c, 0xe2e0004c, 0x1b80001f, 0x20000020,
	0xe2e0004d, 0xf0000000, 0x17c07c1f, 0xd8206169, 0x17c07c1f, 0xe2e0000d,
	0xe2e0000c, 0xe2e0001c, 0xe2e0001e, 0xe2e00016, 0xe2e00012, 0xf0000000,
	0x17c07c1f, 0xd82062e9, 0x17c07c1f, 0xe2e00016, 0x1380201f, 0xe2e0001e,
	0x1380201f, 0xe2e0001c, 0x1380201f, 0xe2e0000c, 0xe2e0000d, 0xf0000000,
	0x17c07c1f, 0xa1d40407, 0x1391841f, 0xa1d90407, 0x1393041f, 0xf0000000,
	0x17c07c1f, 0x1910001f, 0x10006604, 0x10cf901f, 0xd82063e3, 0x17c07c1f,
	0xf0000000, 0x17c07c1f
};
static struct pcm_desc dpidle_pcm_e2 = {
	.version	= "pcm_deepidle_e2_v15.18_2014_0721_mtcmos_3.5.8",
	.base		= dpidle_binary_e2,
	.size		= 806,
	.sess		= 2,
	.replace	= 0,
	.vec0		= EVENT_VEC(11, 1, 0, 0),	/* FUNC_26M_WAKEUP */
	.vec1		= EVENT_VEC(12, 1, 0, 35),	/* FUNC_26M_SLEEP */
	.vec2		= EVENT_VEC(30, 1, 0, 56),	/* FUNC_APSRC_WAKEUP */
	.vec3		= EVENT_VEC(31, 1, 0, 147),	/* FUNC_APSRC_SLEEP */
};


static struct pwr_ctrl dpidle_ctrl = {
	.wake_src		= WAKE_SRC_FOR_DPIDLE,
	.wake_src_md32		= WAKE_SRC_FOR_MD32,
	.r0_ctrl_en		= 1,
	.r7_ctrl_en		= 1,
	.infra_dcm_lock		= 1,
	.wfi_op			= WFI_OP_AND,
	.ca15_wfi0_en		= 1,
	.ca15_wfi1_en		= 1,
	.ca15_wfi2_en		= 1,
	.ca15_wfi3_en		= 1,
	.ca7_wfi0_en		= 1,
	.ca7_wfi1_en		= 1,
	.ca7_wfi2_en		= 1,
	.ca7_wfi3_en		= 1,
	.md2_req_mask		= 1,
	.disp_req_mask		= 1,
	.mfg_req_mask		= 1,
#if SPM_BYPASS_SYSPWREQ
	.syspwreq_mask		= 1,
#endif
};

struct spm_lp_scen __spm_dpidle = {
	.pcmdesc	= &dpidle_pcm,
	.pwrctrl	= &dpidle_ctrl,
};


extern int mt_irq_mask_all(struct mtk_irq_mask *mask);
extern int mt_irq_mask_restore(struct mtk_irq_mask *mask);
extern void mt_irq_unmask_for_sleep(unsigned int irq);
extern int request_uart_to_sleep(void);
extern int request_uart_to_wakeup(void);


static void spm_trigger_wfi_for_dpidle(struct pwr_ctrl *pwrctrl)
{
    //sync_hw_gating_value();     /* for Vcore DVFS */

#if 0	//deepidle no need, vproc(ext buck) can't set to 0v, because SRAM perpheral control from vproc
    spm_i2c_control(mt6333_BUSNUM, 1);
#endif

    if (is_cpu_pdn(pwrctrl->pcm_flags)) {
        mt_cpu_dormant(CPU_DEEPIDLE_MODE);
    } else {
        wfi_with_sync();
    }

#if 0	//deepidle no need, vproc(ext buck) can't set to 0v, because SRAM perpheral control from vproc
    spm_i2c_control(mt6333_BUSNUM, 0);     /* restore I2C1 power */
#endif
}

/*
 * wakesrc: WAKE_SRC_XXX
 * enable : enable or disable @wakesrc
 * replace: if true, will replace the default setting
 */
int spm_set_dpidle_wakesrc(u32 wakesrc, bool enable, bool replace)
{
    unsigned long flags;

    if (spm_is_wakesrc_invalid(wakesrc))
        return -EINVAL;

    spin_lock_irqsave(&__spm_lock, flags);
    if (enable) {
        if (replace)
            __spm_dpidle.pwrctrl->wake_src = wakesrc;
        else
            __spm_dpidle.pwrctrl->wake_src |= wakesrc;
    } else {
        if (replace)
            __spm_dpidle.pwrctrl->wake_src = 0;
        else
            __spm_dpidle.pwrctrl->wake_src &= ~wakesrc;
    }
    spin_unlock_irqrestore(&__spm_lock, flags);

    return 0;
}

void __attribute__((weak)) spm_dpidle_before_wfi(void)
{
}

void __attribute__((weak)) spm_dpidle_after_wfi(void)
{
}
wake_reason_t spm_go_to_dpidle(u32 spm_flags, u32 spm_data)
{
    struct wake_status wakesta;
    unsigned long flags;
    struct mtk_irq_mask mask;
    wake_reason_t wr = WR_NONE;
    struct pcm_desc *pcmdesc = __spm_dpidle.pcmdesc;
    struct pwr_ctrl *pwrctrl = __spm_dpidle.pwrctrl;
    struct spm_lp_scen *lpscen;

    lpscen = spm_check_talking_get_lpscen(&__spm_dpidle, &spm_flags);
    pcmdesc = lpscen->pcmdesc;
    pwrctrl = lpscen->pwrctrl;

    set_pwrctrl_pcm_flags(pwrctrl, spm_flags);
	
    /* set PMIC WRAP table for deepidle power control */
    mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_DEEPIDLE);

    spin_lock_irqsave(&__spm_lock, flags);

    mt_irq_mask_all(&mask);
    mt_irq_unmask_for_sleep(MT_SPM_IRQ_ID);
    mt_cirq_clone_gic();
    mt_cirq_enable();

    if (request_uart_to_sleep()) {
        wr = WR_UART_BUSY;
        goto RESTORE_IRQ;
    }
	
    __spm_reset_and_init_pcm(pcmdesc);

    __spm_kick_im_to_fetch(pcmdesc);
	
    __spm_init_pcm_register();

    __spm_init_event_vector(pcmdesc);

    __spm_set_power_control(pwrctrl);

    __spm_set_wakeup_event(pwrctrl);

    __spm_kick_pcm_to_run(pwrctrl);

    spm_dpidle_before_wfi();

    spm_trigger_wfi_for_dpidle(pwrctrl);

    spm_dpidle_after_wfi();

    __spm_get_wakeup_status(&wakesta);

    __spm_clean_after_wakeup();

    request_uart_to_wakeup();

    wr = __spm_output_wake_reason(&wakesta, pcmdesc, false);

RESTORE_IRQ:
    mt_cirq_flush();
    mt_cirq_disable();
    mt_irq_mask_restore(&mask);

    spin_unlock_irqrestore(&__spm_lock, flags);
    /* set PMIC WRAP table for normal power control */
    mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_NORMAL);

    return wr;
}

/*
 * cpu_pdn:
 *    true  = CPU dormant
 *    false = CPU standby
 * pwrlevel:
 *    0 = AXI is off
 *    1 = AXI is 26M
 * pwake_time:
 *    >= 0  = specific wakeup period
 */
wake_reason_t spm_go_to_sleep_dpidle(u32 spm_flags, u32 spm_data)
{
    u32 sec = 0;
    int wd_ret;
    struct wake_status wakesta;
    unsigned long flags;
    struct mtk_irq_mask mask;
    struct wd_api *wd_api;
    static wake_reason_t last_wr = WR_NONE;
    struct pcm_desc *pcmdesc = __spm_dpidle.pcmdesc;
    struct pwr_ctrl *pwrctrl = __spm_dpidle.pwrctrl;

    set_pwrctrl_pcm_flags(pwrctrl, spm_flags);

#if SPM_PWAKE_EN
    sec = spm_get_wake_period(-1 /* FIXME */, last_wr);
#endif
    pwrctrl->timer_val = sec * 32768;

    pwrctrl->wake_src = spm_get_sleep_wakesrc();

    wd_ret = get_wd_api(&wd_api);
    if (!wd_ret)
        wd_api->wd_suspend_notify();

    spin_lock_irqsave(&__spm_lock, flags);
    mt_irq_mask_all(&mask);
    mt_irq_unmask_for_sleep(MT_SPM_IRQ_ID);
    mt_cirq_clone_gic();
    mt_cirq_enable();

    /* set PMIC WRAP table for deepidle power control */
    mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_DEEPIDLE);


    spm_crit2("sleep_deepidle, sec = %u, wakesrc = 0x%x [%u]\n",
              sec, pwrctrl->wake_src, is_cpu_pdn(pwrctrl->pcm_flags));

    __spm_reset_and_init_pcm(pcmdesc);

    __spm_kick_im_to_fetch(pcmdesc);

    if (request_uart_to_sleep()) {
        last_wr = WR_UART_BUSY;
        goto RESTORE_IRQ;
    }

    __spm_init_pcm_register();

    __spm_init_event_vector(pcmdesc);

    __spm_set_power_control(pwrctrl);

    __spm_set_wakeup_event(pwrctrl);

    __spm_kick_pcm_to_run(pwrctrl);

    spm_trigger_wfi_for_dpidle(pwrctrl);

    __spm_get_wakeup_status(&wakesta);

    __spm_clean_after_wakeup();

	request_uart_to_wakeup();

    last_wr = __spm_output_wake_reason(&wakesta, pcmdesc, true);

RESTORE_IRQ:
	
    /* set PMIC WRAP table for normal power control */
    mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_NORMAL);	
    mt_cirq_flush();
    mt_cirq_disable();
    mt_irq_mask_restore(&mask);
    spin_unlock_irqrestore(&__spm_lock, flags);

    if (!wd_ret)
        wd_api->wd_resume_notify();

    return last_wr;  
}

static void spm_set_dpidle_pcm_ver(void)
{
    CHIP_SW_VER ver=mt_get_chip_sw_ver();

    if(CHIP_SW_VER_02<=ver)
    {
    	/*E2 Deepidle FW*/
        __spm_dpidle.pcmdesc = &dpidle_pcm_e2;
    }	
}

void spm_dpidle_init(void)
{
    spm_set_dpidle_pcm_ver();
}


MODULE_DESCRIPTION("SPM-DPIdle Driver v0.1");
