/* CWMCU.h - header file for CyWee digital 3-axis gyroscope
 *
 * Copyright (C) 2014 Cywee Motion Group Ltd.
 * Author: cywee-motion <cywee-motion@cywee.com>
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
#ifndef __CWMCUSENSOR_H__
#define __CWMCUSENSOR_H__
#include <linux/ioctl.h>

#define CWMCU_I2C_NAME "CwMcuSensor"

enum ABS_status {
    CW_ABS_X = 0x01,
    CW_ABS_Y,
    CW_ABS_Z,
    CW_ABS_X1,
    CW_ABS_Y1,
    CW_ABS_Z1,
    CW_ABS_TIMEDIFF,
    CW_ABS_ACCURACY,
    CW_ABS_TIMESTAMP_H,
    CW_ABS_TIMESTAMP_L
};

enum MCU_mode {
    CW_NORMAL = 0x00,
    CW_SLEEP,
    CW_NO_SLEEP,
    CW_BOOT,
    CW_SUSPEND
};

enum MCU_status {
    CW_VAILD = 0x00,
    CW_INVAILD
};

/* interrupt status */
typedef enum {
    INTERRUPT_NON                   = 0,
    INTERRUPT_INIT                  = 1,
    INTERRUPT_BATCHTIMEOUT          = 2,
    INTERRUPT_BATCHFULL             = 3,
    INTERRUPT_BATCH_FLUSH           = 4,
    INTERRUPT_BATCH_TIMESTAMP_SYNC  = 5,
    INTERRUPT_DATAREADY             = 6,
    INTERRUPT_GESTURE               = 7,
    INTERRUPT_ERROR_LOG             = 8,
    INTERRUPT_DEBUG_LOG             = 9,
    INTERRUPT_VOICETRIGGER          = 15
} INTERRUPT_STATUS_LIST;


/* calibrator command */
typedef enum {
    CWMCU_CALIBRATOR_ACCELERATION   = 0,
    CWMCU_CALIBRATOR_MAGNETIC       = 1,
    CWMCU_CALIBRATOR_GYRO           = 2,
    CWMCU_CALIBRATOR_LIGHT          = 3,
    CWMCU_CALIBRATOR_PROXIMITY      = 4,
    CWMCU_CALIBRATOR_PRESSURE       = 5,
    CWMCU_CALIBRATOR_STATUS         = 6,
    CWMCU_CALIBRATOR_ENABLE         = 7,
    CWMCU_CALIBRATOR_WRITE_BIAS     = 8
} CALIBRATOR_CMD;

/* firmware command */
typedef enum {
    CHANGE_TO_BOOTLOADER_MODE = 1, /*  firmware upgrade command  */
    CHANGE_TO_NORMAL_MODE     = 2, /*  firmware upgrade command  */
    MCU_IMAGE_WRITE           = 3, /*  firmware upgrade command  */
    MCU_IMAGE_ERASE            = 4, /*  firmware upgrade command  */
} FIRMWARE_CMD;

/* mcu command */
typedef enum {
    MCU_REGISTER_WRITE_CTRL     = 1,
    MCU_REGISTER_READ_CTRL      = 2,
    CHECK_ACC_DATA              = 7,
    CHECK_MAG_DATA              = 8,
    CHECK_GYRO_DATA             = 9,
    FILE_SEND_NET_TO_MCU        = 11,
    FILE_SEND_GRAM_TO_MCU       = 12,
    FILE_SEND_GRAMNET_TO_MCU    = 13,
    VOICE_TRIGGER_CTRL          = 15,
    WDT_FEED_STATUS             = 16,
    MCU_DBG_INT_SWITCH          = 17,
    SET_PROXIMITY_THRESHOLD     = 18,
    SET_INTERRUPT_ENABLE        = 19,
    MCU_CHECK_SENSOR_ALIVE_CTRL = 20,

} MCU_CMD;

/* udt control command */
typedef enum {
    UDT_FS_CMD                  = 1,
    UDT_FS_GET_STATUS           = 2,
    UDT_FS_BURN_VOICE_TO_MCU    = 3,
} UDT_CMD;

/* sensor id */
typedef enum {
    CW_ACCELERATION                    = 0,
    CW_MAGNETIC                        = 1,
    CW_GYRO                            = 2,
    CW_LIGHT                        = 3,
    CW_PROXIMITY                    = 4,
    CW_PRESSURE                        = 5,
    CW_ORIENTATION                    = 6,
    CW_ROTATIONVECTOR                = 7,
    CW_LINEARACCELERATION            = 8,
    CW_GRAVITY                        = 9,
    CW_STEP_COUNTER                    = 10,
    CW_STEP_DETECTOR                = 11,
    CW_MAGNETIC_UNCALIBRATED        = 12,
    CW_GYROSCOPE_UNCALIBRATED        = 13,
    CW_GAME_ROTATION_VECTOR            = 14,
    CW_GEOMAGNETIC_ROTATION_VECTOR    = 15,
    CW_SIGNIFICANT_MOTION            = 16,
    CW_SINGLE_SNAP                    = 17,
    CW_DOUBLE_SNAP                    = 18,
    CW_TAP                            = 19,
    CW_CONTEXT_AWARE                = 20,
    CW_PROXIMITY_GESTURE            = 21,
    CW_LIGHT_RGB                    = 22,
    CW_VOICE_TRIGGER                = 23,
    CW_SCREEN_ON                    = 24,
    CW_SENSORS_ID_END,
    CW_META_DATA                    = 99,
    CW_MAGNETIC_UNCALIBRATED_BIAS    = 100,
    CW_GYROSCOPE_UNCALIBRATED_BIAS    = 101
} CW_SENSORS_ID;

#define CW_FWVERSION                            0x3A

/*  0x01 ~ 0x0F  */
#define CW_ENABLE_REG                           0x01
#define CW_ENABLE_STATUS                        0x05

#define CW_SENSOR_DELAY_SET                     0x06    /* 2byte: byte1=>id, byte2=>ms*/
#define CW_SENSOR_DELAY_ID_SET                  0x07
#define CW_SENSOR_DELAY_GET                     0x08
#define CW_SUSPEND_ENABLE                       0x0A
#define CW_RESUME_ENABLE                        0x0B
#define CW_INTERRUPT_STATUS                     0x0F    /* 4Byte */

/*  0x10 ~ 0x1F  */
#define CW_BATCH_ENABLE_REG                     0x10
#define CW_BATCHENABLE_STATUS                   0x14
#define CW_BATCHTIMEOUT                         0x15    /* 5Byte ms */
#define CW_BATCHFLUSH                           0x16
#define CW_BATCHCOUNT                           0x17
#define CW_BATCHEVENT                           0x18
#define CW_BATCHTIME_SYNC                       0x19



#define CWMCU_I2C_SENSORS_REG_START             (0x60)
#define CW_READ_ACCELERATION                    (CWMCU_I2C_SENSORS_REG_START + CW_ACCELERATION)
#define CW_READ_MAGNETIC                        (CWMCU_I2C_SENSORS_REG_START + CW_MAGNETIC)
#define CW_READ_GYRO                            (CWMCU_I2C_SENSORS_REG_START + CW_GYRO)
#define CW_READ_LIGHT                           (CWMCU_I2C_SENSORS_REG_START + CW_LIGHT)
#define CW_READ_PROXIMITY                       (CWMCU_I2C_SENSORS_REG_START + CW_PROXIMITY)
#define CW_READ_PRESSURE                        (CWMCU_I2C_SENSORS_REG_START + CW_PRESSURE)
#define CW_READ_ORIENTATION                     (CWMCU_I2C_SENSORS_REG_START + CW_ORIENTATION)
#define CW_READ_ROTATIONVECTOR                  (CWMCU_I2C_SENSORS_REG_START + CW_ROTATIONVECTOR)
#define CW_READ_LINEARACCELERATION              (CWMCU_I2C_SENSORS_REG_START + CW_LINEARACCELERATION)
#define CW_READ_GRAVITY                         (CWMCU_I2C_SENSORS_REG_START + CW_GRAVITY)
#define CW_READ_STEP_COUNTER                    (CWMCU_I2C_SENSORS_REG_START + CW_STEP_COUNTER)
#define CW_READ_MAGNETIC_UNCALIBRATED           (CWMCU_I2C_SENSORS_REG_START + CW_MAGNETIC_UNCALIBRATED)
#define CW_READ_GYROSCOPE_UNCALIBRATED          (CWMCU_I2C_SENSORS_REG_START + CW_GYROSCOPE_UNCALIBRATED)
#define CW_READ_GAME_ROTATION_VECTOR            (CWMCU_I2C_SENSORS_REG_START + CW_GAME_ROTATION_VECTOR)
#define CW_READ_GEOMAGNETIC_ROTATION_VECTOR     (CWMCU_I2C_SENSORS_REG_START + CW_GEOMAGNETIC_ROTATION_VECTOR)

#define CW_READ_PROXIMITY_GESTURE               0x70
#define CW_READ_LIGHT_RGB                       0x71
#define CW_READ_GESTURE_EVENT_COUNT             0x7A
#define CW_READ_GESTURE_EVENT_DATA              0x7B    /* read 2byte id: 1byte, data: 1byte */
#define CW_ACCURACY                             0X7C

#define CW_READ_SENSORY_EVENT_COUNT             0x7E
#define CW_READ_SENSORY_EVENT_DATA              0x7F


#define CW_CALIBRATOR_TYPE                      0x40
#define CW_CALIBRATOR_SENSOR_ID                 0x41
#define CW_CALIBRATOR_STATUS                    0x42
#define CW_CALIBRATOR_GET_BIAS_ACC              0x43
#define CW_CALIBRATOR_GET_BIAS_MAG              0x44
#define CW_CALIBRATOR_GET_BIAS_GYRO             0x45
#define CW_CALIBRATOR_GET_BIAS_LIGHT            0x46
#define CW_CALIBRATOR_GET_BIAS_PROXIMITY        0x47
#define CW_CALIBRATOR_GET_BIAS_PRESSURE         0x48
#define CW_CALIBRATOR_SET_BIAS                  0x49


/*
Power mode control :
    Register : 0x90
    Parameter:
    PMU_SLEEP      = 0
    PMU_DEEP_SLEEP = 1
    PMU_POWERDOWN  = 2
    PMU_RESUME     = 3

LED control :
    1-Red LED breath on  
    2-Green LED breath on  
    3-Blue LED breath on  
    4-Red LED on  
    5-Green LED on  
    6-Blue LED on  
    7-Factory test mode

Voice trigger:
        0 => disable
        1 => enable

Get mag vendor type:
    0 => none
    1 => akm sensor
    2 => alps
*/
#define CW_POWER_CTRL                0x90
#define CW_VOICE_TRIGGER_CTRL        0x91
#define CW_LED_CTRL                  0x92
#define CW_MAG_GET_VENDOR_TYPE      0x93


#define CW_MCU_STATUS_SET        0x94
#define CW_MCU_STATUS_GET        0x95

/* mcu log */
#define CW_DEBUG_INFO_GET       0x96
#define CW_DEBUG_COUNT_GET      0x97
#define CW_ERROR_INFO_GET       0x98
#define CW_ERROR_COUNT_GET      0x99


#define CW_PSENSOR_RAW_DATA_GET     0x9A    //(read, 1 byte)
#define CW_WDT_FEED_STATUS          0x9B    //(write, 0 : no feed, 1 :
#define CW_MCU_DBG_INT_SWITCH       0x9C    //(write, 0 : disable, 1 :
#define CW_SET_PROXIMITY_THRESHOLD  0x9D    //(write 2 bytes)
#define CW_SET_STEP_COUNTER          0x9E    //(write 4 bytes)
#define CW_SET_INTERRUPT_ENABLE      0x9F    //(write 1 bytes)
#define CW_GET_DMIC_BUF               0xAA    //(read, 2 bytes)
#define CW_SET_VT_SV_PARAM           0xAB    //(write, 4 bytes)

/*
Send file to mcu
    node: udt_control
    Operation:
        echo udt_cmd udt_value > udt_ctrl

    FS command value: [REG = 0xA0]
    1 => Notify mcu of ap will send net.bin
    2 => Notify mcu of ap will send gram.bin or voice.bin
    3 => File send is completed
    4 => Reset mcu status
    5 => Erase udt bin file from flash
    
    FS Status: [REG = 0xA1]
    0 => File send is not ready
    1 => File send is ready
    2 => Erase udt file complete

    Get UDT Type: [REG = 0xA9]
    1 => FT
    2 => UDT
    
*/
#define CW_FILE_SEND_CMD            0xA0
#define CW_FILE_SEND_STATUS            0xA1
#define CW_FILE_SEND_WRITE            0xA2
#define CW_FILE_SEND_READ            0xA3
#define CW_FILE_SEND_SIZE            0xA4
#define CW_FILE_SEND_GRAM_VERSIOM    0xA5
#define CW_FILE_SEND_NET_VERSIOM    0xA6
#define CW_FILE_SEND_SET_FILESIZE    0xA7
#define CW_FILE_SEND_SET_FLASH_CNT    0xA8
#define CW_FILE_SEND_GET_UDT_TYPE    0xA9



/* check data of queue if queue is empty */
#define CWMCU_NODATA    0xff

#define DPS_MAX            (1 << (16 - 1))
#ifdef __KERNEL__

struct CWMCU_platform_data {
    unsigned char Acceleration_hwid;
    unsigned char Acceleration_deviceaddr;
    unsigned char Acceleration_axes;
    unsigned char Magnetic_hwid;
    unsigned char Magnetic_deviceaddr;
    unsigned char Magnetic_axes;
    unsigned char Gyro_hwid;
    unsigned char Gyro_deviceaddr;
    unsigned char Gyro_axes;
};
#endif /* __KERNEL */

#endif /* __CWMCUSENSOR_H__ */
