#include <linux/module.h>
#include <linux/delay.h>
#include <linux/debugfs.h>
#include <linux/types.h>
#include <linux/i2c.h>
#include <linux/uaccess.h>
#include <linux/miscdevice.h>
#include <linux/slab.h>
#include <linux/gpio.h>
#include <linux/bitops.h>
#include <linux/leds.h>

#include <linux/platform_device.h>
//#include <linux/sysdev.h>

#include <linux/interrupt.h>
#include <linux/input.h>
#include <linux/kernel.h>
#include <linux/of_gpio.h>



static volatile int key_debug = 5;
#define HALL_GPIO 108
unsigned int irq_gpio;
//#define HALL_GPIO1 77

//extern int hall_ctrl(int);

struct hall_switch_data{
    struct input_dev *input_dev;
    struct delayed_work hall_work;
    struct workqueue_struct *hall_workqueue;
    int hall_irq;
#ifdef HALL_GPIO1
    int hall_irq1;
#endif
    int hall_gpio_val;
    int intr_pin;
    int irq;
};
static irqreturn_t misc_hall_irq(int irq, void *data)
{
    struct hall_switch_data *hall_data = data;
    int gpio_value;
    //int ret;

    if(hall_data == NULL)
        return 0;
	disable_irq_nosync(hall_data->hall_irq);
	gpio_value = gpio_get_value(irq_gpio);
    if(gpio_value){
        /*----hall far----*/
        if(key_debug == 5)
            printk("hall-switch %d,report:____________________________far!!!\n",irq_gpio);
        input_event(hall_data->input_dev, EV_KEY, KEY_SHOP, 1);
        input_sync(hall_data->input_dev);
        input_event(hall_data->input_dev, EV_KEY, KEY_SHOP, 0);
        input_sync(hall_data->input_dev);
//	ret = hall_ctrl(0);
    }else{
        /*----hall near----*/
        if(key_debug == 5)
            printk("hall-switch %d,report:_____________________________near!!!\n",irq_gpio);
        input_event(hall_data->input_dev, EV_KEY, KEY_SPORT, 1);
        input_sync(hall_data->input_dev);
        input_event(hall_data->input_dev, EV_KEY, KEY_SPORT, 0);
        input_sync(hall_data->input_dev);
	//ret = hall_ctrl(1);
    }
	enable_irq(hall_data->hall_irq);
    return IRQ_HANDLED;
}
#ifdef HALL_GPIO1
static irqreturn_t misc_hall_irq1(int irq, void *data)
{
    struct hall_switch_data *hall_data = data;
    int gpio_value;
    //int ret;

    if(hall_data == NULL)
        return 0;

    gpio_value = gpio_get_value(HALL_GPIO1);
	disable_irq_nosync(hall_data->hall_irq1);
    if(gpio_value){
        /*----hall far----*/
        if(key_debug == 5)
            printk("hall-switch %d,report:____________________________far!!!\n",HALL_GPIO1);
       input_event(hall_data->input_dev, EV_KEY, KEY_SHOP_B, 1);
        input_sync(hall_data->input_dev);
        input_event(hall_data->input_dev, EV_KEY, KEY_SHOP_B, 0);
        input_sync(hall_data->input_dev);
//	ret = hall_ctrl(0);
    }else{
        /*----hall near----*/
        if(key_debug == 5)
            printk("hall-switch %d,report:_____________________________near!!!\n",HALL_GPIO1);
       input_event(hall_data->input_dev, EV_KEY, KEY_SPORT_B, 1);
       input_sync(hall_data->input_dev);
       input_event(hall_data->input_dev, EV_KEY, KEY_SPORT_B, 0);
       input_sync(hall_data->input_dev);
	//ret = hall_ctrl(1);
    }
	enable_irq(hall_data->hall_irq1);
    return IRQ_HANDLED;
}
#endif
/********************** zhujp modify 2014.07.07 start
//gpio value: /sys/devices/system/hall-switch/hall_int_gpio
static ssize_t hall_gpio83_show(struct sysdev_class *class, struct sysdev_class_attribute * attr, char *buf)
{
	int tmp = gpio_get_value(HALL_GPIO);
        return sprintf(buf, "%s\n", tmp==0?"0":"1");
}

static SYSDEV_CLASS_ATTR(hall_int_gpio, 0444, hall_gpio83_show, NULL);
#ifdef HALL_GPIO1
static ssize_t hall_gpio77_show(struct sysdev_class *class, struct sysdev_class_attribute * attr, char *buf)
{
	int tmp = gpio_get_value(HALL_GPIO1);
        return sprintf(buf, "%s\n", tmp==0?"0":"1");
}

static SYSDEV_CLASS_ATTR(hall_gpio77, 0444, hall_gpio77_show, NULL);
#endif
static struct sysdev_class_attribute *mhall_int_attributes[] = {
        &attr_hall_int_gpio,
#ifdef HALL_GPIO1
        &attr_hall_gpio77,
#endif
        NULL
};

static struct sysdev_class module_hall_class = {
        .name = "hall-switch",
};

***************** zhujp2 modify 2014.07.07 end***************/


/***************** zhujp2 modify 2014.07.07 start***************/
static ssize_t hall_gpio108_show(struct device *dev, struct device_attribute *attr, char *buf)
{
        int tmp = gpio_get_value(irq_gpio);
        return sprintf(buf, "%s\n", tmp==0?"0":"1");
}
#ifdef HALL_GPIO1
static ssize_t hall_gpio77_show(struct device *dev, struct device_attribute *attr, char *buf)
{
        int tmp = gpio_get_value(HALL_GPIO1);
        return sprintf(buf, "%s\n", tmp==0?"0":"1");
}

#endif

static DEVICE_ATTR(hall_int_gpio, 0444, hall_gpio108_show, NULL);
#ifdef HALL_GPIO1
static DEVICE_ATTR(hall_gpio77, 0444, hall_gpio77_show, NULL);
#endif
static struct attribute *hall_attributes[] = {
          &dev_attr_hall_int_gpio.attr,
#ifdef HALL_GPIO1
          &dev_attr_hall_gpio77.attr,
#endif
         NULL,
};

static struct attribute_group hall_attr_group = {
        .attrs = hall_attributes,
};


/***************** zhujp2 modify 2014.07.07 end***************/

static int hall_probe(struct platform_device *pdev)
{
        int retval = 0;

        int err = 0;
        struct hall_switch_data *hall_data;
//        unsigned int irq_gpio;
        unsigned int irq_gpio_flags;
        struct device_node *np = pdev->dev.of_node;

      
        printk("%s sucess !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!11\n", __func__);
        hall_data = kzalloc(sizeof(struct hall_switch_data), GFP_KERNEL);
        if (!hall_data){
            err = -ENOMEM;
            goto exit;
        }

        /*----Register to Input Device----*/
        hall_data->input_dev = input_allocate_device();
        if (hall_data->input_dev == NULL){
            err = -ENOMEM;
            printk("hall-switch: ____________________________Failed to allocate input device!!! \n");
            goto exit_kfree;
        }
        printk("%s Register to Input Device !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!11\n", __func__);
        hall_data->input_dev->name = "hall-switch";

        set_bit(EV_SYN, hall_data->input_dev->evbit);
        set_bit(EV_KEY, hall_data->input_dev->evbit);
        set_bit(EV_ABS, hall_data->input_dev->evbit);

        set_bit(KEY_SPORT, hall_data->input_dev->keybit);
        input_set_capability(hall_data->input_dev, EV_KEY, KEY_SPORT);
        set_bit(KEY_SHOP, hall_data->input_dev->keybit);
        input_set_capability(hall_data->input_dev, EV_KEY, KEY_SHOP);

        set_bit(KEY_SPORT_B, hall_data->input_dev->keybit);
        input_set_capability(hall_data->input_dev, EV_KEY, KEY_SPORT_B);
        set_bit(KEY_SHOP_B, hall_data->input_dev->keybit);
        input_set_capability(hall_data->input_dev, EV_KEY, KEY_SHOP_B);

        retval = input_register_device(hall_data->input_dev);
        if(retval) {
            printk("hall-switch:____________________________Failed to register input device!!!\n");
            goto exit_register_input;
        }

       irq_gpio = of_get_named_gpio_flags(np, "rohm,irq-gpio",
                                0, &irq_gpio_flags);
       hall_data->intr_pin = irq_gpio;
        if (irq_gpio < 0) {
                 printk("intr_pin failed @@@@@@@@@@\n");
 //               return initial_fail;
         gpio_free(hall_data->intr_pin);
        }

        if (gpio_is_valid(irq_gpio)) {
                retval = gpio_request(irq_gpio, "hall_switch");
                if (retval) {
                        printk( "irq gpio request failed");
                }

                retval = gpio_direction_input(irq_gpio);
                if (retval) {
                        printk("set_direction for irq gpio failed\n");
                }
        }
    hall_data->hall_irq = gpio_to_irq(irq_gpio);      // add 0731
    retval = request_irq(hall_data->hall_irq, misc_hall_irq, IRQF_TRIGGER_FALLING | IRQF_TRIGGER_RISING,
                      "misc_hall_irq", hall_data);
    if(retval <0)
    {
        printk("request irq pin %d fail for gpio\n",retval);
        goto fail_free_intr_pin;
    }
    irq_set_irq_wake(hall_data->irq, 1);

/****************************
       ----hall irq request----
        hall_data->hall_irq = gpio_to_irq(HALL_GPIO);

        retval = request_threaded_irq(hall_data->hall_irq, NULL, misc_hall_irq, IRQF_TRIGGER_RISING | IRQF_TRIGGER_FALLING, "misc_hall_irq", hall_data);
        if(retval < 0){
            printk("hall-switch:____________________________Failed to create hall irq thread!!!i%d\n",HALL_GPIO);
            goto exit_free_gpio;
        }
        enable_irq_wake(hall_data->hall_irq);
*************************************/
#ifdef HALL_GPIO1
		retval = gpio_request(HALL_GPIO1, "hall_gpio1");
		if (retval) {
			printk("hall-switch:_____________________________irq gpio %d,request failed\n",HALL_GPIO1);
			goto exit_enable_irq;
		}
		retval = gpio_direction_input(HALL_GPIO1);
		if (retval) {
			printk("hall-switch:_____________________________irq gpio %d,direction set failed\n",HALL_GPIO1);
			goto exit_free_gpio;
		}
        /*----hall irq request----*/
        hall_data->hall_irq1 = gpio_to_irq(HALL_GPIO1);

        retval = request_threaded_irq(hall_data->hall_irq1, NULL, misc_hall_irq1, IRQF_TRIGGER_RISING | IRQF_TRIGGER_FALLING, "misc_hall1_irq", hall_data);
        if(retval < 0){
            printk("hall-switch:____________________________Failed to create hall irq thread,%d!!!\n",HALL_GPIO1);
            goto exit_free_gpio;
        }

        enable_irq_wake(hall_data->hall_irq1);
#endif

      /* Register sysfs hooks   zhujp2 add 2014.07.07 start*/
        retval = sysfs_create_group(&pdev->dev.kobj, &hall_attr_group);
        if(retval) {
                printk(KERN_ERR "%s: Failed to create sysfs\n", __FUNCTION__);
                goto exit_sys;
        }
       printk("%s sysfs_create_group sucess\n", __func__);
       /*  zhujp2 add 2014.07.07 end */
        return retval;
/*8
exit_free_gpio:
		gpio_free(HALL_GPIO);
#ifdef HALL_GPIO1
		gpio_free(HALL_GPIO1);
#endif
*******************/
/*******************
exit_enable_irq:
     input_unregister_device(hall_data->input_dev);
**********************/
//initial_fail:
fail_free_intr_pin:
    gpio_free(hall_data->intr_pin);
    return retval;
exit_register_input:
     input_free_device(hall_data->input_dev);
     hall_data->input_dev = NULL;

exit_kfree:
     kfree(hall_data);

exit_sys:
        return -1;
exit:
     return err;
}

#ifdef CONFIG_OF
static struct of_device_id hall_match_table[] = {
        { .compatible = "rohm,hall_switch",},
        { },
};
#else
#define rmi4_match_table NULL
#endif

static struct platform_driver msm_hall_driver = {
	.probe = hall_probe,
	.driver = {
		.name = "msm_hall_switch",
		.owner = THIS_MODULE,
                .of_match_table = hall_match_table,
	},
};
/*************** zhujp2 modify 2014.07.07 start*******
static int __init hall_init(void)
{
        struct sysdev_class_attribute **attr;
        int res;

        res = sysdev_class_register(&module_hall_class);
        if (unlikely(res)) {
                return res;
        }

        for (attr = mhall_int_attributes; *attr; attr++) {
                res = sysdev_class_create_file(&module_hall_class, *attr);
                if (res)
                        goto out_unreg;
        }

	return platform_driver_register(&msm_hall_driver);

out_unreg:
        for (; attr >= mhall_int_attributes; attr--)
                sysdev_class_remove_file(&module_hall_class, *attr);
        sysdev_class_unregister(&module_hall_class);

        return res;


}
*************** zhujp2 modify 2014.07.07 end******************/
static int __init hall_init(void)
{

   return platform_driver_register(&msm_hall_driver);

}


module_init(hall_init);
MODULE_DESCRIPTION("Hall switch sensor driver--zangzhuo1");
MODULE_LICENSE("GPL");



