/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*******************************************************************************
 *
 * Filename:
 * ---------
 *   AudDrv_Ana.h
 *
 * Project:
 * --------
 *   MT6583  Audio Driver Ana
 *
 * Description:
 * ------------
 *   Audio register
 *
 * Author:
 * -------
 *   Chipeng Chang (mtk02308)
 *
 *------------------------------------------------------------------------------
 * $Revision: #1 $
 * $Modtime:$
 * $Log:$
 *
 *
 *******************************************************************************/

#ifndef _AUDDRV_ANA_H_
#define _AUDDRV_ANA_H_

/*****************************************************************************
 *                     C O M P I L E R   F L A G S
 *****************************************************************************/


/*****************************************************************************
 *                E X T E R N A L   R E F E R E N C E S
 *****************************************************************************/

#include "AudDrv_Common.h"
#include "AudDrv_Def.h"


/*****************************************************************************
 *                         D A T A   T Y P E S
 *****************************************************************************/


/*****************************************************************************
 *                         M A C R O
 *****************************************************************************/

/*****************************************************************************
 *                  R E G I S T E R       D E F I N I T I O N
 *****************************************************************************/
#define PMIC_REG_BASE                    (0x0000)
#define AFE_UL_DL_CON0                                   ((UINT32)(PMIC_REG_BASE+0x2000+0x0))
#define AFE_DL_SRC2_CON0_H                         ((UINT32)(PMIC_REG_BASE+0x2000+0x2))
#define AFE_DL_SRC2_CON0_L                          ((UINT32)(PMIC_REG_BASE+0x2000+0x4))
#define AFE_DL_SDM_CON0                                ((UINT32)(PMIC_REG_BASE+0x2000+0x6))
#define AFE_DL_SDM_CON1                                ((UINT32)(PMIC_REG_BASE+0x2000+0x8))
#define AFE_UL_SRC0_CON0_H                         ((UINT32)(PMIC_REG_BASE+0x2000+0xa))
#define AFE_UL_SRC0_CON0_L                          ((UINT32)(PMIC_REG_BASE+0x2000+0xc))
#define AFE_UL_SRC1_CON0_H                         ((UINT32)(PMIC_REG_BASE+0x2000+0xe))
#define AFE_UL_SRC1_CON0_L                          ((UINT32)(PMIC_REG_BASE+0x2000+0x10))
#define PMIC_AFE_TOP_CON0                            ((UINT32)(PMIC_REG_BASE+0x2000+0x12))
#define AFE_AUDIO_TOP_CON0                         ((UINT32)(PMIC_REG_BASE+0x2000+0x14))
#define AFE_DL_SRC_MON0                                ((UINT32)(PMIC_REG_BASE+0x2000+0x16))
#define AFE_DL_SDM_TEST0                               ((UINT32)(PMIC_REG_BASE+0x2000+0x18))
#define AFE_MON_DEBUG0                                 ((UINT32)(PMIC_REG_BASE+0x2000+0x1a))
#define AFUNC_AUD_CON0                                 ((UINT32)(PMIC_REG_BASE+0x2000+0x1c))
#define AFUNC_AUD_CON1                                 ((UINT32)(PMIC_REG_BASE+0x2000+0x1e))
#define AFUNC_AUD_CON2                                 ((UINT32)(PMIC_REG_BASE+0x2000+0x20))
#define AFUNC_AUD_CON3                                 ((UINT32)(PMIC_REG_BASE+0x2000+0x22))
#define AFUNC_AUD_CON4                                 ((UINT32)(PMIC_REG_BASE+0x2000+0x24))
#define AFUNC_AUD_MON0                                ((UINT32)(PMIC_REG_BASE+0x2000+0x26))
#define AFUNC_AUD_MON1                                ((UINT32)(PMIC_REG_BASE+0x2000+0x28))
#define AUDRC_TUNE_MON0                              ((UINT32)(PMIC_REG_BASE+0x2000+0x2a))
#define AFE_UP8X_FIFO_CFG0                         ((UINT32)(PMIC_REG_BASE+0x2000+0x2c))
#define AFE_UP8X_FIFO_LOG_MON0              ((UINT32)(PMIC_REG_BASE+0x2000+0x2e))
#define AFE_UP8X_FIFO_LOG_MON1              ((UINT32)(PMIC_REG_BASE+0x2000+0x30))
#define AFE_DL_DC_COMP_CFG0                    ((UINT32)(PMIC_REG_BASE+0x2000+0x32))
#define AFE_DL_DC_COMP_CFG1                    ((UINT32)(PMIC_REG_BASE+0x2000+0x34))
#define AFE_DL_DC_COMP_CFG2                    ((UINT32)(PMIC_REG_BASE+0x2000+0x36))
#define AFE_PMIC_NEWIF_CFG0                     ((UINT32)(PMIC_REG_BASE+0x2000+0x38))
#define AFE_PMIC_NEWIF_CFG1                     ((UINT32)(PMIC_REG_BASE+0x2000+0x3a))
#define AFE_PMIC_NEWIF_CFG2                     ((UINT32)(PMIC_REG_BASE+0x2000+0x3c))
#define AFE_PMIC_NEWIF_CFG3                     ((UINT32)(PMIC_REG_BASE+0x2000+0x3e))
#define AFE_SGEN_CFG0                                   ((UINT32)(PMIC_REG_BASE+0x2000+0x40))
#define AFE_SGEN_CFG1                                   ((UINT32)(PMIC_REG_BASE+0x2000+0x42))
#define AFE_ADDA2_UL_SRC_CON0_H           ((UINT32)(PMIC_REG_BASE+0x2000+0x44))
#define AFE_ADDA2_UL_SRC_CON0_L            ((UINT32)(PMIC_REG_BASE+0x2000+0x46))
#define AFE_UL_SRC_CON1_H                          ((UINT32)(PMIC_REG_BASE+0x2000+0x48))
#define AFE_ADDA2_UL_SRC_CON1_L          ((UINT32)(PMIC_REG_BASE+0x2000+0x4a))
#define AFE_ADDA2_UP8X_FIFO_LOG_MON0   ((UINT32)(PMIC_REG_BASE+0x2000+0x4c))
#define AFE_ADDA2_UP8X_FIFO_LOG_MON1   ((UINT32)(PMIC_REG_BASE+0x2000+0x4e))
#define AFE_ADDA2_PMIC_NEWIF_CFG0       ((UINT32)(PMIC_REG_BASE+0x2000+0x50))
#define AFE_ADDA2_PMIC_NEWIF_CFG1       ((UINT32)(PMIC_REG_BASE+0x2000+0x52))
#define AFE_ADDA2_PMIC_NEWIF_CFG2       ((UINT32)(PMIC_REG_BASE+0x2000+0x54))
#define AFE_MIC_ARRAY_CFG                          ((UINT32)(PMIC_REG_BASE+0x2000+0x56))
#define AFE_ADC_ASYNC_FIFO_CFG              ((UINT32)(PMIC_REG_BASE+0x2000+0x58))
#define AFE_ANC_CFG0                                     ((UINT32)(PMIC_REG_BASE+0x2000+0x5a))
#define AFE_ANC_CFG1                                     ((UINT32)(PMIC_REG_BASE+0x2000+0x5c))
#define AFE_ANC_COEF_B00                            ((UINT32)(PMIC_REG_BASE+0x2000+0x5e))
#define AFE_ANC_COEF_ADDR                         ((UINT32)(PMIC_REG_BASE+0x2000+0x60))
#define AFE_ANC_COEF_WDATA                      ((UINT32)(PMIC_REG_BASE+0x2000+0x62))
#define AFE_ANC_COEF_RDATA                       ((UINT32)(PMIC_REG_BASE+0x2000+0x64))
#define AUDRC_TUNE_UL2_MON0                     ((UINT32)(PMIC_REG_BASE+0x2000+0x66))
#define AFE_MBIST_CFG0                                  ((UINT32)(PMIC_REG_BASE+0x2000+0x68))
#define AFE_MBIST_CFG1                                  ((UINT32)(PMIC_REG_BASE+0x2000+0x6a))
#define AFE_MBIST_CFG2                                  ((UINT32)(PMIC_REG_BASE+0x2000+0x6c))
#define AFE_MBIST_CFG3                                  ((UINT32)(PMIC_REG_BASE+0x2000+0x6e))
#define AFE_MAD_TOP                                        ((UINT32)(PMIC_REG_BASE+0x2000+0x70))
#define AFE_MAD_CFG0                                     ((UINT32)(PMIC_REG_BASE+0x2000+0x72))
#define AFE_MAD_CFG1                                     ((UINT32)(PMIC_REG_BASE+0x2000+0x74))
#define AFE_MAD_CFG2                                     ((UINT32)(PMIC_REG_BASE+0x2000+0x76))
#define AFE_MAD_CFG3                                     ((UINT32)(PMIC_REG_BASE+0x2000+0x78))
#define AFE_MAD_CFG4                                     ((UINT32)(PMIC_REG_BASE+0x2000+0x7a))
#define AFE_MAD_CFG5                                     ((UINT32)(PMIC_REG_BASE+0x2000+0x7c))
#define AFE_MAD_MON0                                    ((UINT32)(PMIC_REG_BASE+0x2000+0x7e))
#define AFE_MAD_MON1                                    ((UINT32)(PMIC_REG_BASE+0x2000+0x80))
#define AFE_MAD_MON2                                    ((UINT32)(PMIC_REG_BASE+0x2000+0x82))
#define AFE_MAD_MON3                                    ((UINT32)(PMIC_REG_BASE+0x2000+0x84))
#define AFE_MAD_MON4                                    ((UINT32)(PMIC_REG_BASE+0x2000+0x86))
#define AFE_MAD_MON5                                    ((UINT32)(PMIC_REG_BASE+0x2000+0x88))
#define AFE_CLASSH_CFG0                               ((UINT32)(PMIC_REG_BASE+0x2000+0x8a))
#define AFE_CLASSH_CFG1                               ((UINT32)(PMIC_REG_BASE+0x2000+0x8c))
#define AFE_CLASSH_CFG2                               ((UINT32)(PMIC_REG_BASE+0x2000+0x8e))
#define AFE_CLASSH_CFG3                               ((UINT32)(PMIC_REG_BASE+0x2000+0x90))
#define AFE_CLASSH_CFG4                               ((UINT32)(PMIC_REG_BASE+0x2000+0x92))
#define AFE_CLASSH_CFG5                               ((UINT32)(PMIC_REG_BASE+0x2000+0x94))
#define AFE_CLASSH_CFG6                               ((UINT32)(PMIC_REG_BASE+0x2000+0x96))
#define AFE_CLASSH_CFG7                               ((UINT32)(PMIC_REG_BASE+0x2000+0x98))
#define AFE_CLASSH_CFG8                               ((UINT32)(PMIC_REG_BASE+0x2000+0x9a))
#define AFE_CLASSH_CFG9                               ((UINT32)(PMIC_REG_BASE+0x2000+0x9c))
#define AFE_CLASSH_CFG10                             ((UINT32)(PMIC_REG_BASE+0x2000+0x9e))
#define AFE_CLASSH_CFG11                             ((UINT32)(PMIC_REG_BASE+0x2000+0xa0))
#define AFE_CLASSH_CFG12                               ((UINT32)(PMIC_REG_BASE+0x2000+0xa2))
#define AFE_CLASSH_CFG13                               ((UINT32)(PMIC_REG_BASE+0x2000+0xa4))
#define AFE_CLASSH_CFG14                               ((UINT32)(PMIC_REG_BASE+0x2000+0xa6))
#define AFE_CLASSH_CFG15                               ((UINT32)(PMIC_REG_BASE+0x2000+0xa8))
#define AFE_CLASSH_CFG16                               ((UINT32)(PMIC_REG_BASE+0x2000+0xaa))
#define AFE_CLASSH_CFG17                               ((UINT32)(PMIC_REG_BASE+0x2000+0xac))
#define AFE_CLASSH_CFG18                               ((UINT32)(PMIC_REG_BASE+0x2000+0xae))
#define AFE_CLASSH_CFG19                               ((UINT32)(PMIC_REG_BASE+0x2000+0xb0))
#define AFE_CLASSH_CFG20                               ((UINT32)(PMIC_REG_BASE+0x2000+0xb2))
#define AFE_CLASSH_CFG21                               ((UINT32)(PMIC_REG_BASE+0x2000+0xb4))
#define AFE_CLASSH_CFG22                               ((UINT32)(PMIC_REG_BASE+0x2000+0xb6))
#define AFE_CLASSH_CFG23                               ((UINT32)(PMIC_REG_BASE+0x2000+0xb8))
#define AFE_CLASSH_CFG24                               ((UINT32)(PMIC_REG_BASE+0x2000+0xba))
#define AFE_CLASSH_CFG25                               ((UINT32)(PMIC_REG_BASE+0x2000+0xbc))
#define AFE_CLASSH_CFG26                               ((UINT32)(PMIC_REG_BASE+0x2000+0xbe))
#define AFE_CLASSH_CFG27                               ((UINT32)(PMIC_REG_BASE+0x2000+0xc0))
#define AFE_CLASSH_CFG28                               ((UINT32)(PMIC_REG_BASE+0x2000+0xc2))
#define AFE_CLASSH_CFG29                               ((UINT32)(PMIC_REG_BASE+0x2000+0xc4))
#define AFE_CLASSH_CFG30                               ((UINT32)(PMIC_REG_BASE+0x2000+0xc6))
#define AFE_CLASSH_MON00                               ((UINT32)(PMIC_REG_BASE+0x2000+0xc8))
#define AFE_CLASSH_MON1                                 ((UINT32)(PMIC_REG_BASE+0x2000+0xca))
#define AFE_CLASSH_RESERVED0                       ((UINT32)(PMIC_REG_BASE+0x2000+0xcc))
#define AFE_CLASSH_RESERVED1                       ((UINT32)(PMIC_REG_BASE+0x2000+0xce))
#define AFE_DCCLK_AFG0                                     ((UINT32)(PMIC_REG_BASE+0x2000+0xd0))
#define AFE_ANC_COEF_MON1                            ((UINT32)(PMIC_REG_BASE+0x2000+0xd2))
#define AFE_ANC_COEF_MON2                            ((UINT32)(PMIC_REG_BASE+0x2000+0xd4))
#define AFE_ANC_COEF_MON3                            ((UINT32)(PMIC_REG_BASE+0x2000+0xd6))


#define TOP_STATUS                                               ((UINT32)(PMIC_REG_BASE+0x132))
#define TOP_STATUS_SET                                       ((UINT32)(PMIC_REG_BASE+0x134))
#define TOP_STATUS_CLR                                       ((UINT32)(PMIC_REG_BASE+0x136))
#define TOP_CKPDN_CON0                                     ((UINT32)(PMIC_REG_BASE+0x138))
#define TOP_CKPDN_CON0_SET                             ((UINT32)(PMIC_REG_BASE+0x13a))
#define TOP_CKPDN_CON0_CLR                             ((UINT32)(PMIC_REG_BASE+0x13c))
#define TOP_CKPDN_CON1                                     ((UINT32)(PMIC_REG_BASE+0x13e))
#define TOP_CKPDN_CON1_SET                             ((UINT32)(PMIC_REG_BASE+0x140))
#define TOP_CKPDN_CON1_CLR                             ((UINT32)(PMIC_REG_BASE+0x142))
#define TOP_CKPDN_CON2                                      ((UINT32)(PMIC_REG_BASE+0x144))
#define TOP_CKPDN_CON2_SET                             ((UINT32)(PMIC_REG_BASE+0x146))
#define TOP_CKPDN_CON2_CLR                             ((UINT32)(PMIC_REG_BASE+0x148))
#define TOP_CKSEL_CON                                         ((UINT32)(PMIC_REG_BASE+0x14a))
#define TOP_CKSEL_CON_SET                                 ((UINT32)(PMIC_REG_BASE+0x14c))
#define TOP_CKSEL_CON_CLR                                 ((UINT32)(PMIC_REG_BASE+0x14e))
#define TOP_CKHWEN_CON                                     ((UINT32)(PMIC_REG_BASE+0x150))
#define TOP_CKHWEN_CON_SET                             ((UINT32)(PMIC_REG_BASE+0x152))
#define TOP_CKHWEN_CON_CLR                             ((UINT32)(PMIC_REG_BASE+0x154))
#define TOP_CKTST_CON0                                        ((UINT32)(PMIC_REG_BASE+0x156))
#define TOP_CKTST_CON0_SET                              ((UINT32)(PMIC_REG_BASE+0x158))
#define TOP_CKTST_CON0_GET                              ((UINT32)(PMIC_REG_BASE+0x158))

#define TOP_CLKSQ                                                   ((UINT32)(PMIC_REG_BASE+0x15a))
#define TOP_CLKSQ_SET                                          ((UINT32)(PMIC_REG_BASE+0x15C))
#define TOP_CLKSQ_CLR                                          ((UINT32)(PMIC_REG_BASE+0x15e))
#define TOP_RST_CON                                              ((UINT32)(PMIC_REG_BASE+0x160))
#define TOP_RST_CON_SET                                     ((UINT32)(PMIC_REG_BASE+0x162))
#define TOP_RST_CON_CLR                                     ((UINT32)(PMIC_REG_BASE+0x164))

#define ZCD_CON0                                                    ((UINT32)(PMIC_REG_BASE+0x400))
#define ZCD_CON1                                                    ((UINT32)(PMIC_REG_BASE+0x402))
#define ZCD_CON2                                                    ((UINT32)(PMIC_REG_BASE+0x404))
#define ZCD_CON3                                                    ((UINT32)(PMIC_REG_BASE+0x406))
#define ZCD_CON4                                                    ((UINT32)(PMIC_REG_BASE+0x408))
#define ZCD_CON5                                                    ((UINT32)(PMIC_REG_BASE+0x40a))


#define AUDDAC_CFG0                                            ((UINT32)(PMIC_REG_BASE+0x662))
#define AUDBUF_CFG0                                            ((UINT32)(PMIC_REG_BASE+0x664))
#define AUDBUF_CFG1                                            ((UINT32)(PMIC_REG_BASE+0x666))
#define AUDBUF_CFG2                                            ((UINT32)(PMIC_REG_BASE+0x668))
#define AUDBUF_CFG3                                            ((UINT32)(PMIC_REG_BASE+0x66a))
#define AUDBUF_CFG4                                            ((UINT32)(PMIC_REG_BASE+0x66c))
#define AUDBUF_CFG5                                            ((UINT32)(PMIC_REG_BASE+0x66e))
#define AUDBUF_CFG6                                            ((UINT32)(PMIC_REG_BASE+0x670))
#define AUDBUF_CFG7                                            ((UINT32)(PMIC_REG_BASE+0x672))
#define AUDBUF_CFG8                                            ((UINT32)(PMIC_REG_BASE+0x674))
#define IBIASDIST_CFG0                                         ((UINT32)(PMIC_REG_BASE+0x676))
#define AUDCLKGEN_CFG0                                      ((UINT32)(PMIC_REG_BASE+0x678))
#define AUDLDO_CFG0                                            ((UINT32)(PMIC_REG_BASE+0x67a))
#define AUDDCDC_CFG1                                          ((UINT32)(PMIC_REG_BASE+0x67c))
#define AUDNVREGGLB_CFG0                                 ((UINT32)(PMIC_REG_BASE+0x680))
#define AUD_NCP0                                                   ((UINT32)(PMIC_REG_BASE+0x682))
#define AUD_ZCD_CFG0                                          ((UINT32)(PMIC_REG_BASE+0x684))
#define AUDPREAMP_CFG0                                     ((UINT32)(PMIC_REG_BASE+0x686))
#define AUDPREAMP_CFG1                                     ((UINT32)(PMIC_REG_BASE+0x688))
#define AUDPREAMP_CFG2                                     ((UINT32)(PMIC_REG_BASE+0x68a))
#define AUDADC_CFG0                                            ((UINT32)(PMIC_REG_BASE+0x68c))
#define AUDADC_CFG1                                            ((UINT32)(PMIC_REG_BASE+0x68e))
#define AUDADC_CFG2                                            ((UINT32)(PMIC_REG_BASE+0x690))
#define AUDADC_CFG3                                            ((UINT32)(PMIC_REG_BASE+0x692))
#define AUDADC_CFG4                                            ((UINT32)(PMIC_REG_BASE+0x694))
#define AUDADC_CFG5                                            ((UINT32)(PMIC_REG_BASE+0x696))
#define AUDDIGMI_CFG0                                         ((UINT32)(PMIC_REG_BASE+0x698))
#define AUDDIGMI_CFG1                                         ((UINT32)(PMIC_REG_BASE+0x69a))
#define AUDMICBIAS_CFG0                                     ((UINT32)(PMIC_REG_BASE+0x69c))
#define AUDMICBIAS_CFG1                                     ((UINT32)(PMIC_REG_BASE+0x69e))
#define AUDENCSPARE_CFG0                                  ((UINT32)(PMIC_REG_BASE+0x6a0))
#define AUDPREAMPGAIN_CFG0                             ((UINT32)(PMIC_REG_BASE+0x6a2))
#define AUDMADPLL_CFG0                                      ((UINT32)(PMIC_REG_BASE+0x6a4))
#define AUDMADPLL_CFG1                                       ((UINT32)(PMIC_REG_BASE+0x6a6))
#define AUDMADPLL_CFG2                                       ((UINT32)(PMIC_REG_BASE+0x6a8))
#define AUDLDO_NVREG_CFG0                                ((UINT32)(PMIC_REG_BASE+0x6aa))
#define AUDLDO_NVREG_CFG1                                ((UINT32)(PMIC_REG_BASE+0x6ac))
#define AUDLDO_NVREG_CFG2                                ((UINT32)(PMIC_REG_BASE+0x6ae))

#if 1
//register number


#define CHR_CON0           ((UINT32)(PMIC_REG_BASE+0x0000))
#define CHR_CON1           ((UINT32)(PMIC_REG_BASE+0x0002))
#define CHR_CON2           ((UINT32)(PMIC_REG_BASE+0x0004))
#define CHR_CON3           ((UINT32)(PMIC_REG_BASE+0x0006))
#define CHR_CON4           ((UINT32)(PMIC_REG_BASE+0x0008))
#define CHR_CON5           ((UINT32)(PMIC_REG_BASE+0x000A))
#define CHR_CON6           ((UINT32)(PMIC_REG_BASE+0x000C))
#define CHR_CON7           ((UINT32)(PMIC_REG_BASE+0x000E))
#define CHR_CON8           ((UINT32)(PMIC_REG_BASE+0x0010))
#define CHR_CON9           ((UINT32)(PMIC_REG_BASE+0x0012))
#define CHR_CON10          ((UINT32)(PMIC_REG_BASE+0x0014))
#define CHR_CON11          ((UINT32)(PMIC_REG_BASE+0x0016))
#define CHR_CON12          ((UINT32)(PMIC_REG_BASE+0x0018))
#define CHR_CON13          ((UINT32)(PMIC_REG_BASE+0x001A))
#define CHR_CON14          ((UINT32)(PMIC_REG_BASE+0x001C))
#define CHR_CON15          ((UINT32)(PMIC_REG_BASE+0x001E))
#define CHR_CON16          ((UINT32)(PMIC_REG_BASE+0x0020))
#define CHR_CON17          ((UINT32)(PMIC_REG_BASE+0x0022))
#define CHR_CON18          ((UINT32)(PMIC_REG_BASE+0x0024))
#define CHR_CON19          ((UINT32)(PMIC_REG_BASE+0x0026))
#define CHR_CON20          ((UINT32)(PMIC_REG_BASE+0x0028))
#define CHR_CON21          ((UINT32)(PMIC_REG_BASE+0x002A))
#define CHR_CON22          ((UINT32)(PMIC_REG_BASE+0x002C))
#define CHR_CON23          ((UINT32)(PMIC_REG_BASE+0x002E))
#define CHR_CON24          ((UINT32)(PMIC_REG_BASE+0x0030))
#define CHR_CON25          ((UINT32)(PMIC_REG_BASE+0x0032))
#define CHR_CON26          ((UINT32)(PMIC_REG_BASE+0x0034))
#define CHR_CON27          ((UINT32)(PMIC_REG_BASE+0x0036))
#define CHR_CON28          ((UINT32)(PMIC_REG_BASE+0x0038))
#define CHR_CON29          ((UINT32)(PMIC_REG_BASE+0x003A))
#define STRUP_CON0         ((UINT32)(PMIC_REG_BASE+0x003C))
#define STRUP_CON2         ((UINT32)(PMIC_REG_BASE+0x003E))
#define STRUP_CON3         ((UINT32)(PMIC_REG_BASE+0x0040))
#define STRUP_CON4         ((UINT32)(PMIC_REG_BASE+0x0042))
#define STRUP_CON5         ((UINT32)(PMIC_REG_BASE+0x0044))
#define STRUP_CON6         ((UINT32)(PMIC_REG_BASE+0x0046))
#define STRUP_CON7         ((UINT32)(PMIC_REG_BASE+0x0048))
#define STRUP_CON8         ((UINT32)(PMIC_REG_BASE+0x004A))
#define STRUP_CON9         ((UINT32)(PMIC_REG_BASE+0x004C))
#define STRUP_CON10        ((UINT32)(PMIC_REG_BASE+0x004E))
#define STRUP_CON11        ((UINT32)(PMIC_REG_BASE+0x0050))
#define SPK_CON0           ((UINT32)(PMIC_REG_BASE+0x0052))
#define SPK_CON1           ((UINT32)(PMIC_REG_BASE+0x0054))
#define SPK_CON2           ((UINT32)(PMIC_REG_BASE+0x0056))
#define SPK_CON6           ((UINT32)(PMIC_REG_BASE+0x005E))
#define SPK_CON7           ((UINT32)(PMIC_REG_BASE+0x0060))
#define SPK_CON8           ((UINT32)(PMIC_REG_BASE+0x0062))
#define SPK_CON9           ((UINT32)(PMIC_REG_BASE+0x0064))
#define SPK_CON10          ((UINT32)(PMIC_REG_BASE+0x0066))
#define SPK_CON11          ((UINT32)(PMIC_REG_BASE+0x0068))
#define SPK_CON12          ((UINT32)(PMIC_REG_BASE+0x006A))
#define CID                ((UINT32)(PMIC_REG_BASE+0x0100))
#define TOP_CKPDN0         ((UINT32)(PMIC_REG_BASE+0x0102))
#define TOP_CKPDN0_SET     ((UINT32)(PMIC_REG_BASE+0x0104))
#define TOP_CKPDN0_CLR     ((UINT32)(PMIC_REG_BASE+0x0106))
#define TOP_CKPDN1         ((UINT32)(PMIC_REG_BASE+0x0108))
#define TOP_CKPDN1_SET     ((UINT32)(PMIC_REG_BASE+0x010A))
#define TOP_CKPDN1_CLR     ((UINT32)(PMIC_REG_BASE+0x010C))
#define TOP_CKPDN2         ((UINT32)(PMIC_REG_BASE+0x010E))
#define TOP_CKPDN2_SET     ((UINT32)(PMIC_REG_BASE+0x0110))
#define TOP_CKPDN2_CLR     ((UINT32)(PMIC_REG_BASE+0x0112))
#define TOP_RST_CON        ((UINT32)(PMIC_REG_BASE+0x0114))
#define TOP_RST_CON_SET    ((UINT32)(PMIC_REG_BASE+0x0116))
#define TOP_RST_CON_CLR    ((UINT32)(PMIC_REG_BASE+0x0118))
#define TOP_RST_MISC       ((UINT32)(PMIC_REG_BASE+0x011A))
#define TOP_RST_MISC_SET   ((UINT32)(PMIC_REG_BASE+0x011C))
#define TOP_RST_MISC_CLR   ((UINT32)(PMIC_REG_BASE+0x011E))
#define TOP_CKCON0         ((UINT32)(PMIC_REG_BASE+0x0120))
#define TOP_CKCON0_SET     ((UINT32)(PMIC_REG_BASE+0x0122))
#define TOP_CKCON0_CLR     ((UINT32)(PMIC_REG_BASE+0x0124))
#define TOP_CKCON1         ((UINT32)(PMIC_REG_BASE+0x0126))
#define TOP_CKCON1_SET     ((UINT32)(PMIC_REG_BASE+0x0128))
#define TOP_CKCON1_CLR     ((UINT32)(PMIC_REG_BASE+0x012A))
#define TOP_CKTST0         ((UINT32)(PMIC_REG_BASE+0x012C))
#define TOP_CKTST1         ((UINT32)(PMIC_REG_BASE+0x012E))
#define TOP_CKTST2         ((UINT32)(PMIC_REG_BASE+0x0130))
#define TEST_OUT           ((UINT32)(PMIC_REG_BASE+0x0132))
#define TEST_CON0          ((UINT32)(PMIC_REG_BASE+0x0134))
#define TEST_CON1          ((UINT32)(PMIC_REG_BASE+0x0136))
#define EN_STATUS0         ((UINT32)(PMIC_REG_BASE+0x0138))
#define EN_STATUS1         ((UINT32)(PMIC_REG_BASE+0x013A))
#define OCSTATUS0          ((UINT32)(PMIC_REG_BASE+0x013C))
#define OCSTATUS1          ((UINT32)(PMIC_REG_BASE+0x013E))
#define PGSTATUS           ((UINT32)(PMIC_REG_BASE+0x0140))
#define CHRSTATUS          ((UINT32)(PMIC_REG_BASE+0x0142))
#define TDSEL_CON          ((UINT32)(PMIC_REG_BASE+0x0144))
#define RDSEL_CON          ((UINT32)(PMIC_REG_BASE+0x0146))
#define SMT_CON0           ((UINT32)(PMIC_REG_BASE+0x0148))
#define SMT_CON1           ((UINT32)(PMIC_REG_BASE+0x014A))
#define SMT_CON2           ((UINT32)(PMIC_REG_BASE+0x014C))
#define SMT_CON3           ((UINT32)(PMIC_REG_BASE+0x014E))
#define SMT_CON4           ((UINT32)(PMIC_REG_BASE+0x0150))
#define DRV_CON0           ((UINT32)(PMIC_REG_BASE+0x0152))
#define DRV_CON1           ((UINT32)(PMIC_REG_BASE+0x0154))
#define DRV_CON2           ((UINT32)(PMIC_REG_BASE+0x0156))
#define DRV_CON3           ((UINT32)(PMIC_REG_BASE+0x0158))
#define DRV_CON4           ((UINT32)(PMIC_REG_BASE+0x015A))
#define SIMLS1_CON         ((UINT32)(PMIC_REG_BASE+0x015C))
#define SIMLS2_CON         ((UINT32)(PMIC_REG_BASE+0x015E))
#define INT_CON0           ((UINT32)(PMIC_REG_BASE+0x0160))
#define INT_CON0_SET       ((UINT32)(PMIC_REG_BASE+0x0162))
#define INT_CON0_CLR       ((UINT32)(PMIC_REG_BASE+0x0164))
#define INT_CON1           ((UINT32)(PMIC_REG_BASE+0x0166))
#define INT_CON1_SET       ((UINT32)(PMIC_REG_BASE+0x0168))
#define INT_CON1_CLR       ((UINT32)(PMIC_REG_BASE+0x016A))
#define INT_MISC_CON       ((UINT32)(PMIC_REG_BASE+0x016C))
#define INT_MISC_CON_SET   ((UINT32)(PMIC_REG_BASE+0x016E))
#define INT_MISC_CON_CLR   ((UINT32)(PMIC_REG_BASE+0x0170))
#define INT_STATUS0        ((UINT32)(PMIC_REG_BASE+0x0172))
#define INT_STATUS1        ((UINT32)(PMIC_REG_BASE+0x0174))
#define OC_GEAR_0          ((UINT32)(PMIC_REG_BASE+0x0176))
#define OC_GEAR_1          ((UINT32)(PMIC_REG_BASE+0x0178))
#define OC_GEAR_2          ((UINT32)(PMIC_REG_BASE+0x017A))
#define OC_CTL_VPROC       ((UINT32)(PMIC_REG_BASE+0x017C))
#define OC_CTL_VSYS        ((UINT32)(PMIC_REG_BASE+0x017E))
#define OC_CTL_VPA         ((UINT32)(PMIC_REG_BASE+0x0180))
#define FQMTR_CON0         ((UINT32)(PMIC_REG_BASE+0x0182))
#define FQMTR_CON1         ((UINT32)(PMIC_REG_BASE+0x0184))
#define FQMTR_CON2         ((UINT32)(PMIC_REG_BASE+0x0186))
#define RG_SPI_CON         ((UINT32)(PMIC_REG_BASE+0x0188))
#define DEW_DIO_EN         ((UINT32)(PMIC_REG_BASE+0x018A))
#define DEW_READ_TEST      ((UINT32)(PMIC_REG_BASE+0x018C))
#define DEW_WRITE_TEST     ((UINT32)(PMIC_REG_BASE+0x018E))
#define DEW_CRC_SWRST      ((UINT32)(PMIC_REG_BASE+0x0190))
#define DEW_CRC_EN         ((UINT32)(PMIC_REG_BASE+0x0192))
#define DEW_CRC_VAL        ((UINT32)(PMIC_REG_BASE+0x0194))
#define DEW_DBG_MON_SEL    ((UINT32)(PMIC_REG_BASE+0x0196))
#define DEW_CIPHER_KEY_SEL ((UINT32)(PMIC_REG_BASE+0x0198))
#define DEW_CIPHER_IV_SEL  ((UINT32)(PMIC_REG_BASE+0x019A))
#define DEW_CIPHER_EN      ((UINT32)(PMIC_REG_BASE+0x019C))
#define DEW_CIPHER_RDY     ((UINT32)(PMIC_REG_BASE+0x019E))
#define DEW_CIPHER_MODE    ((UINT32)(PMIC_REG_BASE+0x01A0))
#define DEW_CIPHER_SWRST   ((UINT32)(PMIC_REG_BASE+0x01A2))
#define DEW_RDDMY_NO       ((UINT32)(PMIC_REG_BASE+0x01A4))
#define DEW_RDATA_DLY_SEL  ((UINT32)(PMIC_REG_BASE+0x01A6))
#define BUCK_CON0          ((UINT32)(PMIC_REG_BASE+0x0200))
#define BUCK_CON1          ((UINT32)(PMIC_REG_BASE+0x0202))
#define BUCK_CON2          ((UINT32)(PMIC_REG_BASE+0x0204))
#define BUCK_CON3          ((UINT32)(PMIC_REG_BASE+0x0206))
#define BUCK_CON4          ((UINT32)(PMIC_REG_BASE+0x0208))
#define BUCK_CON5          ((UINT32)(PMIC_REG_BASE+0x020A))
#define VPROC_CON0         ((UINT32)(PMIC_REG_BASE+0x020C))
#define VPROC_CON1         ((UINT32)(PMIC_REG_BASE+0x020E))
#define VPROC_CON2         ((UINT32)(PMIC_REG_BASE+0x0210))
#define VPROC_CON3         ((UINT32)(PMIC_REG_BASE+0x0212))
#define VPROC_CON4         ((UINT32)(PMIC_REG_BASE+0x0214))
#define VPROC_CON5         ((UINT32)(PMIC_REG_BASE+0x0216))
#define VPROC_CON7         ((UINT32)(PMIC_REG_BASE+0x021A))
#define VPROC_CON8         ((UINT32)(PMIC_REG_BASE+0x021C))
#define VPROC_CON9         ((UINT32)(PMIC_REG_BASE+0x021E))
#define VPROC_CON10        ((UINT32)(PMIC_REG_BASE+0x0220))
#define VPROC_CON11        ((UINT32)(PMIC_REG_BASE+0x0222))
#define VPROC_CON12        ((UINT32)(PMIC_REG_BASE+0x0224))
#define VPROC_CON13        ((UINT32)(PMIC_REG_BASE+0x0226))
#define VPROC_CON14        ((UINT32)(PMIC_REG_BASE+0x0228))
#define VPROC_CON15        ((UINT32)(PMIC_REG_BASE+0x022A))
#define VPROC_CON18        ((UINT32)(PMIC_REG_BASE+0x0230))
#define VSYS_CON0          ((UINT32)(PMIC_REG_BASE+0x0232))
#define VSYS_CON1          ((UINT32)(PMIC_REG_BASE+0x0234))
#define VSYS_CON2          ((UINT32)(PMIC_REG_BASE+0x0236))
#define VSYS_CON3          ((UINT32)(PMIC_REG_BASE+0x0238))
#define VSYS_CON4          ((UINT32)(PMIC_REG_BASE+0x023A))
#define VSYS_CON5          ((UINT32)(PMIC_REG_BASE+0x023C))
#define VSYS_CON7          ((UINT32)(PMIC_REG_BASE+0x0240))
#define VSYS_CON8          ((UINT32)(PMIC_REG_BASE+0x0242))
#define VSYS_CON9          ((UINT32)(PMIC_REG_BASE+0x0244))
#define VSYS_CON10         ((UINT32)(PMIC_REG_BASE+0x0246))
#define VSYS_CON11         ((UINT32)(PMIC_REG_BASE+0x0248))
#define VSYS_CON12         ((UINT32)(PMIC_REG_BASE+0x024A))
#define VSYS_CON13         ((UINT32)(PMIC_REG_BASE+0x024C))
#define VSYS_CON14         ((UINT32)(PMIC_REG_BASE+0x024E))
#define VSYS_CON15         ((UINT32)(PMIC_REG_BASE+0x0250))
#define VSYS_CON18         ((UINT32)(PMIC_REG_BASE+0x0256))
#define VPA_CON0           ((UINT32)(PMIC_REG_BASE+0x0300))
#define VPA_CON1           ((UINT32)(PMIC_REG_BASE+0x0302))
#define VPA_CON2           ((UINT32)(PMIC_REG_BASE+0x0304))
#define VPA_CON3           ((UINT32)(PMIC_REG_BASE+0x0306))
#define VPA_CON4           ((UINT32)(PMIC_REG_BASE+0x0308))
#define VPA_CON5           ((UINT32)(PMIC_REG_BASE+0x030A))
#define VPA_CON7           ((UINT32)(PMIC_REG_BASE+0x030E))
#define VPA_CON8           ((UINT32)(PMIC_REG_BASE+0x0310))
#define VPA_CON9           ((UINT32)(PMIC_REG_BASE+0x0312))
#define VPA_CON10          ((UINT32)(PMIC_REG_BASE+0x0314))
#define VPA_CON11          ((UINT32)(PMIC_REG_BASE+0x0316))
#define VPA_CON12          ((UINT32)(PMIC_REG_BASE+0x0318))
#define VPA_CON14          ((UINT32)(PMIC_REG_BASE+0x031C))
#define VPA_CON16          ((UINT32)(PMIC_REG_BASE+0x0320))
#define VPA_CON17          ((UINT32)(PMIC_REG_BASE+0x0322))
#define VPA_CON18          ((UINT32)(PMIC_REG_BASE+0x0324))
#define VPA_CON19          ((UINT32)(PMIC_REG_BASE+0x0326))
#define VPA_CON20          ((UINT32)(PMIC_REG_BASE+0x0328))
#define BUCK_K_CON0        ((UINT32)(PMIC_REG_BASE+0x032A))
#define BUCK_K_CON1        ((UINT32)(PMIC_REG_BASE+0x032C))
#define BUCK_K_CON2        ((UINT32)(PMIC_REG_BASE+0x032E))
#define ISINK0_CON0        ((UINT32)(PMIC_REG_BASE+0x0330))
#define ISINK0_CON1        ((UINT32)(PMIC_REG_BASE+0x0332))
#define ISINK0_CON2        ((UINT32)(PMIC_REG_BASE+0x0334))
#define ISINK0_CON3        ((UINT32)(PMIC_REG_BASE+0x0336))
#define ISINK1_CON0        ((UINT32)(PMIC_REG_BASE+0x0338))
#define ISINK1_CON1        ((UINT32)(PMIC_REG_BASE+0x033A))
#define ISINK1_CON2        ((UINT32)(PMIC_REG_BASE+0x033C))
#define ISINK1_CON3        ((UINT32)(PMIC_REG_BASE+0x033E))
#define ISINK2_CON0        ((UINT32)(PMIC_REG_BASE+0x0340))
#define ISINK2_CON1        ((UINT32)(PMIC_REG_BASE+0x0342))
#define ISINK2_CON2        ((UINT32)(PMIC_REG_BASE+0x0344))
#define ISINK2_CON3        ((UINT32)(PMIC_REG_BASE+0x0346))
#define ISINK3_CON0        ((UINT32)(PMIC_REG_BASE+0x0348))
#define ISINK3_CON1        ((UINT32)(PMIC_REG_BASE+0x034A))
#define ISINK3_CON2        ((UINT32)(PMIC_REG_BASE+0x034C))
#define ISINK3_CON3        ((UINT32)(PMIC_REG_BASE+0x034E))
#define ISINK_ANA0         ((UINT32)(PMIC_REG_BASE+0x0350))
#define ISINK_ANA1         ((UINT32)(PMIC_REG_BASE+0x0352))
#define ISINK_PHASE_DLY    ((UINT32)(PMIC_REG_BASE+0x0354))
#define ISINK_EN_CTRL      ((UINT32)(PMIC_REG_BASE+0x0356))
#define ANALDO_CON0        ((UINT32)(PMIC_REG_BASE+0x0400))
#define ANALDO_CON1        ((UINT32)(PMIC_REG_BASE+0x0402))
#define ANALDO_CON2        ((UINT32)(PMIC_REG_BASE+0x0404))
#define ANALDO_CON3        ((UINT32)(PMIC_REG_BASE+0x0406))
#define ANALDO_CON4        ((UINT32)(PMIC_REG_BASE+0x0408))
#define ANALDO_CON5        ((UINT32)(PMIC_REG_BASE+0x040A))
#define ANALDO_CON6        ((UINT32)(PMIC_REG_BASE+0x040C))
#define ANALDO_CON7        ((UINT32)(PMIC_REG_BASE+0x040E))
#define ANALDO_CON8        ((UINT32)(PMIC_REG_BASE+0x0410))
#define ANALDO_CON10       ((UINT32)(PMIC_REG_BASE+0x0412))
#define ANALDO_CON15       ((UINT32)(PMIC_REG_BASE+0x0414))
#define ANALDO_CON16       ((UINT32)(PMIC_REG_BASE+0x0416))
#define ANALDO_CON17       ((UINT32)(PMIC_REG_BASE+0x0418))
#define ANALDO_CON18       ((UINT32)(PMIC_REG_BASE+0x041A))
#define ANALDO_CON19       ((UINT32)(PMIC_REG_BASE+0x041C))
#define ANALDO_CON20       ((UINT32)(PMIC_REG_BASE+0x041E))
#define ANALDO_CON21       ((UINT32)(PMIC_REG_BASE+0x0420))
#define DIGLDO_CON0        ((UINT32)(PMIC_REG_BASE+0x0500))
#define DIGLDO_CON2        ((UINT32)(PMIC_REG_BASE+0x0502))
#define DIGLDO_CON3        ((UINT32)(PMIC_REG_BASE+0x0504))
#define DIGLDO_CON5        ((UINT32)(PMIC_REG_BASE+0x0506))
#define DIGLDO_CON6        ((UINT32)(PMIC_REG_BASE+0x0508))
#define DIGLDO_CON7        ((UINT32)(PMIC_REG_BASE+0x050A))
#define DIGLDO_CON8        ((UINT32)(PMIC_REG_BASE+0x050C))
#define DIGLDO_CON9        ((UINT32)(PMIC_REG_BASE+0x050E))
#define DIGLDO_CON10       ((UINT32)(PMIC_REG_BASE+0x0510))
#define DIGLDO_CON11       ((UINT32)(PMIC_REG_BASE+0x0512))
#define DIGLDO_CON12       ((UINT32)(PMIC_REG_BASE+0x0514))
#define DIGLDO_CON13       ((UINT32)(PMIC_REG_BASE+0x0516))
#define DIGLDO_CON14       ((UINT32)(PMIC_REG_BASE+0x0518))
#define DIGLDO_CON15       ((UINT32)(PMIC_REG_BASE+0x051A))
#define DIGLDO_CON16       ((UINT32)(PMIC_REG_BASE+0x051C))
#define DIGLDO_CON17       ((UINT32)(PMIC_REG_BASE+0x051E))
#define DIGLDO_CON18       ((UINT32)(PMIC_REG_BASE+0x0520))
#define DIGLDO_CON19       ((UINT32)(PMIC_REG_BASE+0x0522))
#define DIGLDO_CON20       ((UINT32)(PMIC_REG_BASE+0x0524))
#define DIGLDO_CON21       ((UINT32)(PMIC_REG_BASE+0x0526))
#define DIGLDO_CON23       ((UINT32)(PMIC_REG_BASE+0x0528))
#define DIGLDO_CON24       ((UINT32)(PMIC_REG_BASE+0x052A))
#define DIGLDO_CON26       ((UINT32)(PMIC_REG_BASE+0x052C))
#define DIGLDO_CON27       ((UINT32)(PMIC_REG_BASE+0x052E))
#define DIGLDO_CON28       ((UINT32)(PMIC_REG_BASE+0x0530))
#define DIGLDO_CON29       ((UINT32)(PMIC_REG_BASE+0x0532))
#define DIGLDO_CON30       ((UINT32)(PMIC_REG_BASE+0x0534))
#define DIGLDO_CON31       ((UINT32)(PMIC_REG_BASE+0x0536))
#define DIGLDO_CON32       ((UINT32)(PMIC_REG_BASE+0x0538))
#define DIGLDO_CON33       ((UINT32)(PMIC_REG_BASE+0x053A))
#define DIGLDO_CON34       ((UINT32)(PMIC_REG_BASE+0x053C))
#define DIGLDO_CON35       ((UINT32)(PMIC_REG_BASE+0x053E))
#define DIGLDO_CON36       ((UINT32)(PMIC_REG_BASE+0x0540))
#define DIGLDO_CON39       ((UINT32)(PMIC_REG_BASE+0x0542))
#define DIGLDO_CON40       ((UINT32)(PMIC_REG_BASE+0x0544))
#define DIGLDO_CON41       ((UINT32)(PMIC_REG_BASE+0x0546))
#define DIGLDO_CON42       ((UINT32)(PMIC_REG_BASE+0x0548))
#define DIGLDO_CON43       ((UINT32)(PMIC_REG_BASE+0x054A))
#define DIGLDO_CON44       ((UINT32)(PMIC_REG_BASE+0x054C))
#define DIGLDO_CON45       ((UINT32)(PMIC_REG_BASE+0x054E))
#define DIGLDO_CON46       ((UINT32)(PMIC_REG_BASE+0x0550))
#define DIGLDO_CON47       ((UINT32)(PMIC_REG_BASE+0x0552))
#define DIGLDO_CON48       ((UINT32)(PMIC_REG_BASE+0x0554))
#define DIGLDO_CON49       ((UINT32)(PMIC_REG_BASE+0x0556))
#define DIGLDO_CON50       ((UINT32)(PMIC_REG_BASE+0x0558))
#define DIGLDO_CON51       ((UINT32)(PMIC_REG_BASE+0x055A))
#define DIGLDO_CON52       ((UINT32)(PMIC_REG_BASE+0x055C))
#define DIGLDO_CON53       ((UINT32)(PMIC_REG_BASE+0x055E))
#define DIGLDO_CON54       ((UINT32)(PMIC_REG_BASE+0x0560))
#define EFUSE_CON0         ((UINT32)(PMIC_REG_BASE+0x0600))
#define EFUSE_CON1         ((UINT32)(PMIC_REG_BASE+0x0602))
#define EFUSE_CON2         ((UINT32)(PMIC_REG_BASE+0x0604))
#define EFUSE_CON3         ((UINT32)(PMIC_REG_BASE+0x0606))
#define EFUSE_CON4         ((UINT32)(PMIC_REG_BASE+0x0608))
#define EFUSE_CON5         ((UINT32)(PMIC_REG_BASE+0x060A))
#define EFUSE_CON6         ((UINT32)(PMIC_REG_BASE+0x060C))
#define EFUSE_VAL_0_15     ((UINT32)(PMIC_REG_BASE+0x060E))
#define EFUSE_VAL_16_31    ((UINT32)(PMIC_REG_BASE+0x0610))
#define EFUSE_VAL_32_47    ((UINT32)(PMIC_REG_BASE+0x0612))
#define EFUSE_VAL_48_63    ((UINT32)(PMIC_REG_BASE+0x0614))
#define EFUSE_VAL_64_79    ((UINT32)(PMIC_REG_BASE+0x0616))
#define EFUSE_VAL_80_95    ((UINT32)(PMIC_REG_BASE+0x0618))
#define EFUSE_VAL_96_111   ((UINT32)(PMIC_REG_BASE+0x061A))
#define EFUSE_VAL_112_127  ((UINT32)(PMIC_REG_BASE+0x061C))
#define EFUSE_VAL_128_143  ((UINT32)(PMIC_REG_BASE+0x061E))
#define EFUSE_VAL_144_159  ((UINT32)(PMIC_REG_BASE+0x0620))
#define EFUSE_VAL_160_175  ((UINT32)(PMIC_REG_BASE+0x0622))
#define EFUSE_VAL_176_191  ((UINT32)(PMIC_REG_BASE+0x0624))
#define EFUSE_DOUT_0_15    ((UINT32)(PMIC_REG_BASE+0x0626))
#define EFUSE_DOUT_16_31   ((UINT32)(PMIC_REG_BASE+0x0628))
#define EFUSE_DOUT_32_47   ((UINT32)(PMIC_REG_BASE+0x062A))
#define EFUSE_DOUT_48_63   ((UINT32)(PMIC_REG_BASE+0x062C))
#define EFUSE_DOUT_64_79   ((UINT32)(PMIC_REG_BASE+0x062E))
#define EFUSE_DOUT_80_95   ((UINT32)(PMIC_REG_BASE+0x0630))
#define EFUSE_DOUT_96_111  ((UINT32)(PMIC_REG_BASE+0x0632))
#define EFUSE_DOUT_112_127 ((UINT32)(PMIC_REG_BASE+0x0634))
#define EFUSE_DOUT_128_143 ((UINT32)(PMIC_REG_BASE+0x0636))
#define EFUSE_DOUT_144_159 ((UINT32)(PMIC_REG_BASE+0x0638))
#define EFUSE_DOUT_160_175 ((UINT32)(PMIC_REG_BASE+0x063A))
#define EFUSE_DOUT_176_191 ((UINT32)(PMIC_REG_BASE+0x063C))
#define EFUSE_CON7         ((UINT32)(PMIC_REG_BASE+0x063E))
#define EFUSE_CON8         ((UINT32)(PMIC_REG_BASE+0x0640))
#define EFUSE_CON9         ((UINT32)(PMIC_REG_BASE+0x0642))
#define RTC_MIX_CON0       ((UINT32)(PMIC_REG_BASE+0x0644))
#define RTC_MIX_CON1       ((UINT32)(PMIC_REG_BASE+0x0646))
#define AUDTOP_CON0        ((UINT32)(PMIC_REG_BASE+0x0700))
#define AUDTOP_CON1        ((UINT32)(PMIC_REG_BASE+0x0702))
#define AUDTOP_CON2        ((UINT32)(PMIC_REG_BASE+0x0704))
#define AUDTOP_CON3        ((UINT32)(PMIC_REG_BASE+0x0706))
#define AUDTOP_CON4        ((UINT32)(PMIC_REG_BASE+0x0708))
#define AUDTOP_CON5        ((UINT32)(PMIC_REG_BASE+0x070A))
#define AUDTOP_CON6        ((UINT32)(PMIC_REG_BASE+0x070C))
#define AUDTOP_CON7        ((UINT32)(PMIC_REG_BASE+0x070E))
#define AUDTOP_CON8        ((UINT32)(PMIC_REG_BASE+0x0710))
#define AUDTOP_CON9        ((UINT32)(PMIC_REG_BASE+0x0712))
#define AUXADC_ADC0        ((UINT32)(PMIC_REG_BASE+0x0714))
#define AUXADC_ADC1        ((UINT32)(PMIC_REG_BASE+0x0716))
#define AUXADC_ADC2        ((UINT32)(PMIC_REG_BASE+0x0718))
#define AUXADC_ADC3        ((UINT32)(PMIC_REG_BASE+0x071A))
#define AUXADC_ADC4        ((UINT32)(PMIC_REG_BASE+0x071C))
#define AUXADC_ADC5        ((UINT32)(PMIC_REG_BASE+0x071E))
#define AUXADC_ADC6        ((UINT32)(PMIC_REG_BASE+0x0720))
#define AUXADC_ADC7        ((UINT32)(PMIC_REG_BASE+0x0722))
#define AUXADC_ADC8        ((UINT32)(PMIC_REG_BASE+0x0724))
#define AUXADC_ADC9        ((UINT32)(PMIC_REG_BASE+0x0726))
#define AUXADC_ADC10       ((UINT32)(PMIC_REG_BASE+0x0728))
#define AUXADC_ADC11       ((UINT32)(PMIC_REG_BASE+0x072A))
#define AUXADC_ADC12       ((UINT32)(PMIC_REG_BASE+0x072C))
#define AUXADC_ADC13       ((UINT32)(PMIC_REG_BASE+0x072E))
#define AUXADC_ADC14       ((UINT32)(PMIC_REG_BASE+0x0730))
#define AUXADC_ADC15       ((UINT32)(PMIC_REG_BASE+0x0732))
#define AUXADC_ADC16       ((UINT32)(PMIC_REG_BASE+0x0734))
#define AUXADC_ADC17       ((UINT32)(PMIC_REG_BASE+0x0736))
#define AUXADC_ADC18       ((UINT32)(PMIC_REG_BASE+0x0738))
#define AUXADC_ADC19       ((UINT32)(PMIC_REG_BASE+0x073A))
#define AUXADC_ADC20       ((UINT32)(PMIC_REG_BASE+0x073C))
#define AUXADC_RSV1        ((UINT32)(PMIC_REG_BASE+0x073E))
#define AUXADC_RSV2        ((UINT32)(PMIC_REG_BASE+0x0740))
#define AUXADC_CON0        ((UINT32)(PMIC_REG_BASE+0x0742))
#define AUXADC_CON1        ((UINT32)(PMIC_REG_BASE+0x0744))
#define AUXADC_CON2        ((UINT32)(PMIC_REG_BASE+0x0746))
#define AUXADC_CON3        ((UINT32)(PMIC_REG_BASE+0x0748))
#define AUXADC_CON4        ((UINT32)(PMIC_REG_BASE+0x074A))
#define AUXADC_CON5        ((UINT32)(PMIC_REG_BASE+0x074C))
#define AUXADC_CON6        ((UINT32)(PMIC_REG_BASE+0x074E))
#define AUXADC_CON7        ((UINT32)(PMIC_REG_BASE+0x0750))
#define AUXADC_CON8        ((UINT32)(PMIC_REG_BASE+0x0752))
#define AUXADC_CON9        ((UINT32)(PMIC_REG_BASE+0x0754))
#define AUXADC_CON10       ((UINT32)(PMIC_REG_BASE+0x0756))
#define AUXADC_CON11       ((UINT32)(PMIC_REG_BASE+0x0758))
#define AUXADC_CON12       ((UINT32)(PMIC_REG_BASE+0x075A))
#define AUXADC_CON13       ((UINT32)(PMIC_REG_BASE+0x075C))
#define AUXADC_CON14       ((UINT32)(PMIC_REG_BASE+0x075E))
#define AUXADC_CON15       ((UINT32)(PMIC_REG_BASE+0x0760))
#define AUXADC_CON16       ((UINT32)(PMIC_REG_BASE+0x0762))
#define AUXADC_CON17       ((UINT32)(PMIC_REG_BASE+0x0764))
#define AUXADC_CON18       ((UINT32)(PMIC_REG_BASE+0x0766))
#define AUXADC_CON19       ((UINT32)(PMIC_REG_BASE+0x0768))
#define AUXADC_CON20       ((UINT32)(PMIC_REG_BASE+0x076A))
#define AUXADC_CON21       ((UINT32)(PMIC_REG_BASE+0x076C))
#define AUXADC_CON22       ((UINT32)(PMIC_REG_BASE+0x076E))
#define AUXADC_CON23       ((UINT32)(PMIC_REG_BASE+0x0770))
#define AUXADC_CON24       ((UINT32)(PMIC_REG_BASE+0x0772))
#define AUXADC_CON25       ((UINT32)(PMIC_REG_BASE+0x0774))
#define AUXADC_CON26       ((UINT32)(PMIC_REG_BASE+0x0776))
#define AUXADC_CON27       ((UINT32)(PMIC_REG_BASE+0x0778))
#define ACCDET_CON0        ((UINT32)(PMIC_REG_BASE+0x077A))
#define ACCDET_CON1        ((UINT32)(PMIC_REG_BASE+0x077C))
#define ACCDET_CON2        ((UINT32)(PMIC_REG_BASE+0x077E))
#define ACCDET_CON3        ((UINT32)(PMIC_REG_BASE+0x0780))
#define ACCDET_CON4        ((UINT32)(PMIC_REG_BASE+0x0782))
#define ACCDET_CON5        ((UINT32)(PMIC_REG_BASE+0x0784))
#define ACCDET_CON6        ((UINT32)(PMIC_REG_BASE+0x0786))
#define ACCDET_CON7        ((UINT32)(PMIC_REG_BASE+0x0788))
#define ACCDET_CON8        ((UINT32)(PMIC_REG_BASE+0x078A))
#define ACCDET_CON9        ((UINT32)(PMIC_REG_BASE+0x078C))
#define ACCDET_CON10       ((UINT32)(PMIC_REG_BASE+0x078E))
#define ACCDET_CON11       ((UINT32)(PMIC_REG_BASE+0x0790))
#define ACCDET_CON12       ((UINT32)(PMIC_REG_BASE+0x0792))
#define ACCDET_CON13       ((UINT32)(PMIC_REG_BASE+0x0794))
#define ACCDET_CON14       ((UINT32)(PMIC_REG_BASE+0x0796))
#define ACCDET_CON15       ((UINT32)(PMIC_REG_BASE+0x0798))
#define ACCDET_CON16       ((UINT32)(PMIC_REG_BASE+0x079A))

#else
#include <mach/upmu_hw.h>
#endif

void Ana_Set_Reg(uint32 offset, uint32 value, uint32 mask);
uint32  Ana_Get_Reg(uint32 offset);

// for debug usage
void Ana_Log_Print(void);

#endif


