/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*******************************************************************************
 *
 * Filename:
 * ---------
 *  mt_sco_analog_type.h
 *
 * Project:
 * --------
 *   MT6583  Audio Driver Kernel Function
 *
 * Description:
 * ------------
 *   Audio register
 *
 * Author:
 * -------
 * Chipeng Chang
 *
 *------------------------------------------------------------------------------
 * $Revision: #1 $
 * $Modtime:$
 * $Log:$
 *
 *
 *******************************************************************************/

#ifndef _AUDIO_ANALOG_TYPE_H
#define _AUDIO_ANALOG_TYPE_H


/*****************************************************************************
 *                ENUM DEFINITION
 *****************************************************************************/


typedef enum
{
    AUDIO_ANALOG_VOLUME_HSOUTL = 0 ,
    AUDIO_ANALOG_VOLUME_HSOUTR,
    AUDIO_ANALOG_VOLUME_HPOUTL,
    AUDIO_ANALOG_VOLUME_HPOUTR,
    AUDIO_ANALOG_VOLUME_SPKL,
    AUDIO_ANALOG_VOLUME_SPKR,
    AUDIO_ANALOG_VOLUME_SPEAKER_HEADSET_R,
    AUDIO_ANALOG_VOLUME_SPEAKER_HEADSET_L,
    AUDIO_ANALOG_VOLUME_IV_BUFFER,
    AUDIO_ANALOG_VOLUME_LINEOUTL,
    AUDIO_ANALOG_VOLUME_LINEOUTR,
    AUDIO_ANALOG_VOLUME_LINEINL,
    AUDIO_ANALOG_VOLUME_LINEINR,
    AUDIO_ANALOG_VOLUME_MICAMPL,
    AUDIO_ANALOG_VOLUME_MICAMPR,
    AUDIO_ANALOG_VOLUME_LEVELSHIFTL,
    AUDIO_ANALOG_VOLUME_LEVELSHIFTR,
    AUDIO_ANALOG_VOLUME_TYPE_MAX
} AUDIO_ANALOG_VOLUME_TYPE;

// mux seleciotn
typedef enum
{
    AUDIO_ANALOG_MUX_VOICE = 0,
    AUDIO_ANALOG_MUX_AUDIO,
    AUDIO_ANALOG_MUX_IV_BUFFER ,
    AUDIO_ANALOG_MUX_LINEIN_STEREO ,
    AUDIO_ANALOG_MUX_LINEIN_L ,
    AUDIO_ANALOG_MUX_LINEIN_R ,
    AUDIO_ANALOG_MUX_LINEIN_AUDIO_MONO ,
    AUDIO_ANALOG_MUX_LINEIN_AUDIO_STEREO ,
    AUDIO_ANALOG_MUX_IN_MIC1 ,
    AUDIO_ANALOG_MUX_IN_MIC2 ,
    AUDIO_ANALOG_MUX_IN_MIC3 ,
    AUDIO_ANALOG_MUX_IN_MIC4 ,
    AUDIO_ANALOG_MUX_IN_LINE_IN ,
    AUDIO_ANALOG_MUX_IN_PREAMP_1,
    AUDIO_ANALOG_MUX_IN_PREAMP_2 ,
    AUDIO_ANALOG_MUX_IN_PREAMP_3 ,
    AUDIO_ANALOG_MUX_IN_PREAMP_4,
    AUDIO_MICSOURCE_MUX_IN_1,
    AUDIO_MICSOURCE_MUX_IN_2,
    AUDIO_MICSOURCE_MUX_IN_3,
    AUDIO_MICSOURCE_MUX_IN_4,
    AUDIO_ANALOG_MUX_IN_LEVEL_SHIFT_BUFFER ,
    AUDIO_ANALOG_MUX_MUTE ,
    AUDIO_ANALOG_MUX_OPEN ,
    AUDIO_ANALOG_MAX_MUX_TYPE
} AUDIO_ANALOG_MUX_TYPE;

// device power
typedef enum
{
    AUDIO_ANALOG_DEVICE_OUT_EARPIECER = 0,
    AUDIO_ANALOG_DEVICE_OUT_EARPIECEL = 1,
    AUDIO_ANALOG_DEVICE_OUT_HEADSETR = 2,
    AUDIO_ANALOG_DEVICE_OUT_HEADSETL = 3,
    AUDIO_ANALOG_DEVICE_OUT_SPEAKERR = 4,
    AUDIO_ANALOG_DEVICE_OUT_SPEAKERL = 5,
    AUDIO_ANALOG_DEVICE_OUT_SPEAKER_HEADSET_R = 6,
    AUDIO_ANALOG_DEVICE_OUT_SPEAKER_HEADSET_L = 7,
    AUDIO_ANALOG_DEVICE_OUT_LINEOUTR = 8,
    AUDIO_ANALOG_DEVICE_OUT_LINEOUTL = 9,
    AUDIO_ANALOG_DEVICE_2IN1_SPK = 10,
    //DEVICE_IN_LINEINR = 11,
    //DEVICE_IN_LINEINL = 12,
    AUDIO_ANALOG_DEVICE_IN_ADC1 = 13,
    AUDIO_ANALOG_DEVICE_IN_ADC2 = 14,
    AUDIO_ANALOG_DEVICE_IN_ADC3 = 15,
    AUDIO_ANALOG_DEVICE_IN_ADC4 = 16,
    AUDIO_ANALOG_DEVICE_IN_PREAMP_L = 17,
    AUDIO_ANALOG_DEVICE_IN_PREAMP_R = 18,
    AUDIO_ANALOG_DEVICE_IN_DIGITAL_MIC = 19,
    AUDIO_ANALOG_DEVICE_MAX
} AUDIO_ANALOG_DEVICE_TYPE;

typedef enum
{
    AUDIO_ANALOG_DEVICE_OUT_DAC,
    AUDIO_ANALOG_DEVICE_IN_ADC,
    AUDIO_ANALOG_DEVICE_INOUT_MAX
} AUDIO_ANALOG_DEVICE_SAMPLERATE_TYPE;


typedef enum
{
    AUDIO_ANALOG_DEVICE_PLATFORM_MACHINE,
    AUDIO_ANALOG_DEVICE_PLATFORM,
    AUDIO_ANALOG_DEVICE_MACHINE,
    AUDIO_ANALOG_DEVICE_TYPE_SETTING_MAX
} AUDIO_ANALOG_DEVICE_TYPE_SETTING;

typedef enum
{
    AUDIO_ANALOG_AUDIOANALOG_DEVICE,
    AUDIO_ANALOG_AUDIOANALOG_VOLUME,
    AUDIO_ANALOG_AUDIOANALOG_MUX
} AUDIO_ANALOG_AUDIOANALOG_TYPE;

typedef enum
{
    AUDIO_ANALOG_AUDIOANALOGZCD_HEADPHONE = 1,
    AUDIO_ANALOG_AUDIOANALOGZCD_HANDSET = 2,
    AUDIO_ANALOG_AUDIOANALOGZCD_IVBUFFER = 3,
} AUDIO_ANALOG_AUDIOANALOGZCD_TYPE;

typedef enum
{
    AUDIO_ANALOG_CLASS_AB = 0,
    AUDIO_ANALOG_CLASS_D,
} AUDIO_ANALOG_SPEAKER_CLASS;


typedef enum
{
    AUDIO_ANALOG_CHANNELS_LEFT1 = 0,
    AUDIO_ANALOG_CHANNELS_RIGHT1,
} AUDIO_ANALOG_CHANNELS;


typedef enum
{
    AUDIO_ANALOG_SET_SPEAKER_CLASS = 0,
    AUDIO_ANALOG_GET_SPEAKER_CLASS = 1,
    AUDIO_ANALOG_SET_CURRENT_SENSING = 2,
    AUDIO_ANALOG_SET_CURRENT_SENSING_PEAK_DETECTOR = 3,
} AUDIOANALOG_COMMAND;


typedef struct
{
    int32 mAudio_Ana_Volume[AUDIO_ANALOG_VOLUME_TYPE_MAX] ;
    int32 mAudio_Ana_Mux[AUDIO_ANALOG_MAX_MUX_TYPE];
    int32 mAudio_Ana_DevicePower[AUDIO_ANALOG_DEVICE_MAX];
} mt6331_Codec_Data_Priv;


#endif

