/*----------------------------------------------------------------------------*/
#include <linux/interrupt.h>
#include <linux/i2c.h>
#include <linux/slab.h>
#include <linux/irq.h>
#include <linux/miscdevice.h>
#include <asm/uaccess.h>
#include <linux/delay.h>
#include <linux/input.h>
#include <linux/workqueue.h>
#include <linux/kobject.h>
#include <linux/earlysuspend.h>
#include <linux/platform_device.h>
#include <asm/atomic.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/sched.h>
#include <linux/kthread.h>
#include <linux/bitops.h>
#include <linux/kernel.h>
#include <linux/byteorder/generic.h>
#include <linux/interrupt.h>
#include <linux/time.h>
#include <linux/rtpm_prio.h>
#include <linux/dma-mapping.h>
#include <linux/syscalls.h>
#include <linux/reboot.h>
#include <linux/vmalloc.h>
#include <linux/fs.h>
#include <linux/string.h>
#include <linux/completion.h>

#include "ch703xtype.h"
#include "ch703xerr.h"
#include "ch703xdriver.h"
#include "edid.h"

#include "hdmi_drv.h"
#include <cust_eint.h>
#include "cust_gpio_usage.h"
#include "mach/eint.h"
#include "mach/irqs.h"

#include <mach/devs.h>
#include <mach/mt_typedefs.h>
#include <mach/mt_gpio.h>
#include <mach/mt_pm_ldo.h>

/*----------------------------------------------------------------------------*/
// Debug message defination
/*----------------------------------------------------------------------------*/
static size_t ch7035_log_on = false;
#define CH7035_LOG(fmt, arg...) \
	do { \
		if (ch7035_log_on) {printk("[hdmi_ch7035]%s,%d ", __func__, __LINE__); printk(fmt, ##arg);} \
	}while (0)

#define CH7035_FUNC()	\
	do { \
		if(ch7035_log_on) {printk("[hdmi_ch7035] %s\n", __func__);} \
	}while (0)

#define RETNULL(cond)       if ((cond)){CH7035_LOG("return in %d\n",__LINE__);return;}
#define RETINT(cond, rslt)       if ((cond)){CH7035_LOG("return in %d\n",__LINE__);return (rslt);}

/*----------------------------------------------------------------------------*/
// HDMI Timer
/*----------------------------------------------------------------------------*/		
static struct timer_list r_hdmi_timer;
static uint32_t gHDMI_CHK_INTERVAL = 300;
static uint8_t ucHdmi_Plugin = 0;
static uint8_t ucHdmi_isr_en = 0;
static uint8_t ucHdmi_chip_exist = 0;
static struct task_struct *hdmi_timer_task = NULL;
wait_queue_head_t hdmi_timer_wq;
atomic_t hdmi_timer_event = ATOMIC_INIT(0);

/*----------------------------------------------------------------------------*/
// HDMI device information
/*----------------------------------------------------------------------------*/
#define MAX_TRANSACTION_LENGTH 8
#define HDMI_DEVICE_NAME            "mtk-hdmi"
#define CH7035_I2C_SLAVE_ADDR       0xEC
/*----------------------------------------------------------------------------*/
static int hdmi_i2c_probe(struct i2c_client *client, const struct i2c_device_id *id);
//static int hdmi_i2c_detect(struct i2c_client *client, int kind, struct i2c_board_info *info);
static int hdmi_i2c_remove(struct i2c_client *client);
/*----------------------------------------------------------------------------*/
static struct i2c_client *ch7035_i2c_client = NULL;
static const struct i2c_device_id hdmi_i2c_id[] = {{HDMI_DEVICE_NAME,0},{}};
//static unsigned short force[] = {0, CH7035_I2C_SLAVE_ADDR, I2C_CLIENT_END,I2C_CLIENT_END};
//static const unsigned short * const forces[] = { force, NULL };
//static struct i2c_client_address_data addr_data = { .forces = forces,};
static struct i2c_board_info __initdata i2c_hdmi = { I2C_BOARD_INFO(HDMI_DEVICE_NAME, (CH7035_I2C_SLAVE_ADDR>>1))};
/*----------------------------------------------------------------------------*/
struct i2c_driver hdmi_i2c_driver = {                       
    .probe = hdmi_i2c_probe,                                   
    .remove = hdmi_i2c_remove,                           
    //.detect = hdmi_i2c_detect,                           
    .driver = { .name = HDMI_DEVICE_NAME,}, 
    .id_table = hdmi_i2c_id,                             
    //.address_list = (const unsigned short*) forces,                         
}; 
struct ch7035_i2c_data {
      struct i2c_client *client;
	uint16_t addr;
	int use_reset;	//use RESET flag
	int use_irq;		//use EINT flag
	int retry;
};

static struct ch7035_i2c_data *obj_i2c_data = NULL;
/*----------------------------------------------------------------------------*/
// IIC APIs
/*----------------------------------------------------------------------------*/
int ch7035_i2c_read_byte(u8 addr, u8 *data);
int ch7035_i2c_write_byte(u8 addr, u8 data);
int ch7035_i2c_read_block( u8 addr, u8 *data, int len );
int ch7035_i2c_write_block( u8 addr, u8 *data, int len );
/*----------------------------------------------------------------------------*/
static uint8_t hdmi_load_status = 0;
/*----------------------------------------------------------------------------*/
// MCU initial FW table
/*----------------------------------------------------------------------------*/
static unsigned char u1FW_Table[] = 
{
0x02, 0x0E, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x11, 0xD2, 0x02, 0x01,
0x62, 0xEC, 0x5D, 0x04, 0x60, 0x05, 0xE8, 0x59, 0x04, 0x70, 0x03, 0x02, 0x01, 0x58, 0x12, 0x01,
0x23, 0x58, 0x04, 0x60, 0xF6, 0xEC, 0x48, 0x60, 0xF2, 0xEC, 0x70, 0x04, 0xFD, 0xFE, 0xFF, 0x22,
0xC8, 0x60, 0xDB, 0x24, 0x81, 0xC8, 0x50, 0x09, 0xC3, 0x98, 0x60, 0x02, 0x50, 0x06, 0x02, 0x01,
0x5F, 0x98, 0x50, 0xCA, 0xF5, 0x82, 0xE9, 0x29, 0x4B, 0x4A, 0x70, 0x05, 0xAB, 0x82, 0x02, 0x01,
0x4E, 0x75, 0xF0, 0x00, 0x7C, 0x1A, 0x78, 0x80, 0xC3, 0xEF, 0x9B, 0xEE, 0x9A, 0xED, 0x99, 0x40,
0x0D, 0xC3, 0xEF, 0x9B, 0xFF, 0xEE, 0x9A, 0xFE, 0xED, 0x99, 0xFD, 0xE8, 0x42, 0xF0, 0xDC, 0x23,
0xAC, 0xF0, 0xD0, 0xE0, 0xFF, 0xD0, 0xE0, 0xFE, 0xD0, 0xE0, 0xFD, 0xAB, 0x82, 0x20, 0xE7, 0x10,
0x1B, 0xEB, 0x60, 0xBA, 0xEC, 0x2C, 0xFC, 0xEF, 0x33, 0xFF, 0xEE, 0x33, 0xFE, 0xED, 0x33, 0xFD,
0x02, 0x01, 0x3A, 0xE8, 0x03, 0xF8, 0x30, 0xE7, 0x05, 0xC0, 0xF0, 0x75, 0xF0, 0x00, 0xEF, 0x2F,
0xFF, 0xEE, 0x33, 0xFE, 0xED, 0x33, 0xFD, 0x40, 0xB8, 0x30, 0xE7, 0xC2, 0x80, 0xAA, 0x75, 0xF0,
0x20, 0x80, 0x0E, 0x75, 0xF0, 0x10, 0x80, 0x05, 0x75, 0xF0, 0x08, 0x7D, 0x00, 0x7E, 0x00, 0x7F,
0x00, 0x33, 0x92, 0xD5, 0x30, 0xD5, 0x03, 0x12, 0x02, 0x8A, 0xEC, 0x33, 0x40, 0x10, 0xEF, 0x33,
0xFF, 0xEE, 0x33, 0xFE, 0xED, 0x33, 0xFD, 0xEC, 0x33, 0xFC, 0xD5, 0xF0, 0xED, 0x22, 0xE5, 0xF0,
0x24, 0x7E, 0xA2, 0xD5, 0x13, 0xCC, 0x92, 0xE7, 0xCD, 0xCE, 0xFF, 0x22, 0xED, 0xD2, 0xE7, 0xCD,
0x33, 0xEC, 0x33, 0x92, 0xD5, 0x24, 0x81, 0x40, 0x06, 0xE4, 0xFF, 0xFE, 0xFD, 0xFC, 0x22, 0xFC,
0xE4, 0xCF, 0xCE, 0xCD, 0xCC, 0x24, 0xE0, 0x50, 0x11, 0x74, 0xFF, 0x80, 0xED, 0xC3, 0xCC, 0x13,
0xCC, 0xCD, 0x13, 0xCD, 0xCE, 0x13, 0xCE, 0xCF, 0x13, 0xCF, 0x04, 0x70, 0xF0, 0x30, 0xD5, 0xDE,
0x02, 0x02, 0x8A, 0xE9, 0xD2, 0xE7, 0xC9, 0x33, 0xE8, 0x33, 0xF8, 0x92, 0xD5, 0xED, 0xD2, 0xE7,
0xCD, 0x33, 0xEC, 0x33, 0xFC, 0x50, 0x02, 0xB2, 0xD5, 0x22, 0xEC, 0x30, 0xE7, 0x10, 0x0F, 0xBF,
0x00, 0x0C, 0x0E, 0xBE, 0x00, 0x08, 0x0D, 0xBD, 0x00, 0x04, 0x0B, 0xEB, 0x60, 0x14, 0xA2, 0xD5,
0xEB, 0x13, 0xFC, 0xED, 0x92, 0xE7, 0xFD, 0x22, 0x74, 0xFF, 0xFC, 0xFD, 0xFE, 0xFF, 0x22, 0xE4,
0x80, 0xF8, 0xA2, 0xD5, 0x74, 0xFF, 0x13, 0xFC, 0x7D, 0x80, 0xE4, 0x80, 0xEF, 0xE8, 0x8F, 0xF0,
0xA4, 0xCC, 0x8B, 0xF0, 0xA4, 0x2C, 0xFC, 0xE9, 0x8E, 0xF0, 0xA4, 0x2C, 0xFC, 0x8A, 0xF0, 0xED,
0xA4, 0x2C, 0xFC, 0xEA, 0x8E, 0xF0, 0xA4, 0xCD, 0xA8, 0xF0, 0x8B, 0xF0, 0xA4, 0x2D, 0xCC, 0x38,
0x25, 0xF0, 0xFD, 0xE9, 0x8F, 0xF0, 0xA4, 0x2C, 0xCD, 0x35, 0xF0, 0xFC, 0xEB, 0x8E, 0xF0, 0xA4,
0xFE, 0xA9, 0xF0, 0xEB, 0x8F, 0xF0, 0xA4, 0xCF, 0xC5, 0xF0, 0x2E, 0xCD, 0x39, 0xFE, 0xE4, 0x3C,
0xFC, 0xEA, 0xA4, 0x2D, 0xCE, 0x35, 0xF0, 0xFD, 0xE4, 0x3C, 0xFC, 0x22, 0x75, 0xF0, 0x08, 0x75,
0x82, 0x00, 0xEF, 0x2F, 0xFF, 0xEE, 0x33, 0xFE, 0xCD, 0x33, 0xCD, 0xCC, 0x33, 0xCC, 0xC5, 0x82,
0x33, 0xC5, 0x82, 0x9B, 0xED, 0x9A, 0xEC, 0x99, 0xE5, 0x82, 0x98, 0x40, 0x0C, 0xF5, 0x82, 0xEE,
0x9B, 0xFE, 0xED, 0x9A, 0xFD, 0xEC, 0x99, 0xFC, 0x0F, 0xD5, 0xF0, 0xD6, 0xE4, 0xCE, 0xFB, 0xE4,
0xCD, 0xFA, 0xE4, 0xCC, 0xF9, 0xA8, 0x82, 0x22, 0xB8, 0x00, 0xC1, 0xB9, 0x00, 0x59, 0xBA, 0x00,
0x2D, 0xEC, 0x8B, 0xF0, 0x84, 0xCF, 0xCE, 0xCD, 0xFC, 0xE5, 0xF0, 0xCB, 0xF9, 0x78, 0x18, 0xEF,
0x2F, 0xFF, 0xEE, 0x33, 0xFE, 0xED, 0x33, 0xFD, 0xEC, 0x33, 0xFC, 0xEB, 0x33, 0xFB, 0x10, 0xD7,
0x03, 0x99, 0x40, 0x04, 0xEB, 0x99, 0xFB, 0x0F, 0xD8, 0xE5, 0xE4, 0xF9, 0xFA, 0x22, 0x78, 0x18,
0xEF, 0x2F, 0xFF, 0xEE, 0x33, 0xFE, 0xED, 0x33, 0xFD, 0xEC, 0x33, 0xFC, 0xC9, 0x33, 0xC9, 0x10,
0xD7, 0x05, 0x9B, 0xE9, 0x9A, 0x40, 0x07, 0xEC, 0x9B, 0xFC, 0xE9, 0x9A, 0xF9, 0x0F, 0xD8, 0xE0,
0xE4, 0xC9, 0xFA, 0xE4, 0xCC, 0xFB, 0x22, 0x75, 0xF0, 0x10, 0xEF, 0x2F, 0xFF, 0xEE, 0x33, 0xFE,
0xED, 0x33, 0xFD, 0xCC, 0x33, 0xCC, 0xC8, 0x33, 0xC8, 0x10, 0xD7, 0x07, 0x9B, 0xEC, 0x9A, 0xE8,
0x99, 0x40, 0x0A, 0xED, 0x9B, 0xFD, 0xEC, 0x9A, 0xFC, 0xE8, 0x99, 0xF8, 0x0F, 0xD5, 0xF0, 0xDA,
0xE4, 0xCD, 0xFB, 0xE4, 0xCC, 0xFA, 0xE4, 0xC8, 0xF9, 0x22, 0xC3, 0xE4, 0x9F, 0xFF, 0xE4, 0x9E,
0xFE, 0xE4, 0x9D, 0xFD, 0xE4, 0x9C, 0xFC, 0x22, 0xE8, 0x60, 0x0F, 0xEC, 0xC3, 0x13, 0xFC, 0xED,
0x13, 0xFD, 0xEE, 0x13, 0xFE, 0xEF, 0x13, 0xFF, 0xD8, 0xF1, 0x22, 0xE6, 0xFC, 0x08, 0xE6, 0xFD,
0x08, 0xE6, 0xFE, 0x08, 0xE6, 0xFF, 0x22, 0xEC, 0xF6, 0x08, 0xED, 0xF6, 0x08, 0xEE, 0xF6, 0x08,
0xEF, 0xF6, 0x22, 0x75, 0x69, 0x7F, 0xC2, 0x01, 0xC2, 0x00, 0xE4, 0xF5, 0x28, 0xF5, 0x29, 0xD2,
0x05, 0xFF, 0x12, 0x11, 0x0A, 0x40, 0x03, 0x02, 0x04, 0x43, 0xE5, 0x69, 0x24, 0x3E, 0xF8, 0xE6,
0xF5, 0x63, 0x7B, 0x08, 0xE4, 0xFD, 0xFF, 0x12, 0x0F, 0x2B, 0x40, 0x01, 0x22, 0xA8, 0x69, 0xE6,
0x70, 0x3C, 0xE8, 0x04, 0xF8, 0xE6, 0xF4, 0x70, 0x35, 0xE5, 0x69, 0x24, 0x02, 0xF8, 0xE6, 0xF4,
0x70, 0x2C, 0xE5, 0x69, 0x24, 0x03, 0xF8, 0xE6, 0xF4, 0x70, 0x23, 0xE5, 0x69, 0x24, 0x04, 0xF8,
0xE6, 0xF4, 0x70, 0x1A, 0xE5, 0x69, 0x24, 0x05, 0xF8, 0xE6, 0xB4, 0xFF, 0x11, 0xE5, 0x69, 0x24,
0x06, 0xF8, 0xE6, 0xB4, 0xFF, 0x08, 0xE5, 0x69, 0x24, 0x07, 0xF8, 0xE6, 0x60, 0x02, 0xC3, 0x22,
0x7B, 0x02, 0x7D, 0x23, 0xE4, 0xFF, 0x12, 0x0F, 0x2B, 0x40, 0x01, 0x22, 0xE5, 0x69, 0x04, 0xF8,
0xE6, 0x30, 0xE0, 0x03, 0x43, 0x29, 0x04, 0x75, 0x64, 0x26, 0xE4, 0xF5, 0x68, 0x7B, 0x02, 0xAD,
0x64, 0xE4, 0xFF, 0x12, 0x0F, 0x2B, 0x50, 0x28, 0x05, 0x64, 0x05, 0x64, 0xA8, 0x69, 0xE6, 0xFF,
0xB4, 0x01, 0x08, 0xE8, 0x04, 0xF8, 0xE6, 0x64, 0x01, 0x60, 0x15, 0xE5, 0x69, 0x04, 0xF8, 0x74,
0xC0, 0x56, 0xF6, 0xEF, 0xB4, 0x81, 0x09, 0xE5, 0x69, 0x04, 0xF8, 0x76, 0x80, 0x43, 0x29, 0x04,
0x05, 0x68, 0xE5, 0x68, 0xC3, 0x94, 0x08, 0x40, 0xC4, 0x7B, 0x06, 0x7D, 0x38, 0xE4, 0xFF, 0x12,
0x0F, 0x2B, 0x40, 0x03, 0x02, 0x04, 0x16, 0xE5, 0x69, 0x24, 0x02, 0xF8, 0xE6, 0x54, 0xF0, 0xFF,
0xE5, 0x69, 0x04, 0xF8, 0xA6, 0x07, 0xE5, 0x69, 0x24, 0x03, 0xF8, 0xE6, 0xFF, 0xE5, 0x69, 0x24,
0x02, 0xF8, 0xA6, 0x07, 0xE5, 0x69, 0x24, 0x05, 0xF8, 0xE6, 0x54, 0xF0, 0xFF, 0xE5, 0x69, 0x24,
0x03, 0xF8, 0xA6, 0x07, 0xE4, 0xF5, 0x68, 0xE4, 0xF5, 0x65, 0xE5, 0x68, 0x75, 0xF0, 0x05, 0xA4,
0x24, 0x5E, 0xF5, 0x82, 0xE4, 0x34, 0x13, 0xF5, 0x83, 0xE5, 0x82, 0x25, 0x65, 0xF5, 0x82, 0xE4,
0x35, 0x83, 0xF5, 0x83, 0xE4, 0x93, 0xFF, 0xE5, 0x69, 0x25, 0x65, 0xF8, 0xE6, 0xB5, 0x07, 0x07,
0x05, 0x65, 0xE5, 0x65, 0xB4, 0x04, 0xD3, 0xE5, 0x65, 0xB4, 0x04, 0x13, 0xE5, 0x68, 0x75, 0xF0,
0x05, 0xA4, 0x24, 0x63, 0xF5, 0x82, 0xE4, 0x34, 0x13, 0xF5, 0x83, 0xE4, 0x93, 0x42, 0x29, 0x05,
0x68, 0xE5, 0x68, 0xB4, 0x02, 0xB1, 0xE5, 0x63, 0x70, 0x08, 0xE5, 0x58, 0x70, 0x02, 0xD2, 0x00,
0xC3, 0x22, 0x75, 0x68, 0x01, 0xE5, 0x68, 0xD3, 0x95, 0x63, 0x40, 0x03, 0x02, 0x05, 0x41, 0xE5,
0x68, 0x30, 0xE0, 0x04, 0x7F, 0x80, 0x80, 0x02, 0x7F, 0x00, 0x8F, 0x6A, 0xAF, 0x68, 0x12, 0x11,
0x0A, 0x40, 0x09, 0x7D, 0x80, 0x7F, 0x4E, 0x12, 0x0D, 0x09, 0xC3, 0x22, 0xE5, 0x68, 0xC3, 0x13,
0xF5, 0x67, 0x7B, 0x05, 0xAD, 0x6A, 0xFF, 0x12, 0x0F, 0x2B, 0x40, 0x01, 0x22, 0xA8, 0x69, 0xE6,
0x64, 0x02, 0x60, 0x03, 0x02, 0x05, 0x3C, 0xE8, 0x04, 0xF8, 0xE6, 0x64, 0x03, 0x60, 0x03, 0x02,
0x05, 0x3C, 0xE5, 0x69, 0x24, 0x02, 0xF8, 0xE6, 0xFF, 0xD3, 0x94, 0x04, 0x50, 0x03, 0x02, 0x05,
0x3C, 0x8F, 0x64, 0xE5, 0x69, 0x24, 0x04, 0xF8, 0xE6, 0xF5, 0x65, 0x75, 0x66, 0x04, 0xE5, 0x65,
0x54, 0xE0, 0x64, 0x60, 0x70, 0x25, 0xE5, 0x66, 0x7B, 0x06, 0x12, 0x0F, 0x26, 0x40, 0x01, 0x22,
0xE5, 0x69, 0x04, 0xF8, 0xE6, 0xB4, 0x03, 0x13, 0xE5, 0x69, 0x24, 0x02, 0xF8, 0xE6, 0xB4, 0x0C,
0x0A, 0xE5, 0x69, 0x24, 0x03, 0xF8, 0xE6, 0x70, 0x02, 0xD2, 0x01, 0xE5, 0x65, 0x54, 0xE0, 0x64,
0x40, 0x70, 0x59, 0xE5, 0x65, 0x54, 0x1F, 0xF5, 0x6B, 0xE5, 0x66, 0x25, 0x6A, 0x04, 0xFD, 0xAB,
0x6B, 0xAF, 0x67, 0x12, 0x0F, 0x2B, 0x50, 0x64, 0xE4, 0xF5, 0x6C, 0xE5, 0x6C, 0xC3, 0x95, 0x6B,
0x50, 0x3A, 0xE4, 0xF5, 0x6D, 0xE5, 0x69, 0x25, 0x6C, 0xF8, 0xE6, 0x54, 0x7F, 0xFF, 0xE5, 0x6D,
0x25, 0xE0, 0x24, 0x56, 0xF5, 0x82, 0xE4, 0x34, 0x13, 0xF5, 0x83, 0xE4, 0x93, 0xB5, 0x07, 0x11,
0xE5, 0x6D, 0x25, 0xE0, 0x24, 0x57, 0xF5, 0x82, 0xE4, 0x34, 0x13, 0xF5, 0x83, 0xE4, 0x93, 0x42,
0x28, 0x05, 0x6D, 0xE5, 0x6D, 0xB4, 0x04, 0xCD, 0x05, 0x6C, 0x80, 0xBF, 0xE5, 0x65, 0x54, 0x1F,
0x25, 0x66, 0x04, 0xF5, 0x66, 0x7B, 0x01, 0x12, 0x0F, 0x26, 0x40, 0x01, 0x22, 0xA8, 0x69, 0xE6,
0xF5, 0x65, 0xE5, 0x66, 0xC3, 0x95, 0x64, 0x50, 0x03, 0x02, 0x04, 0x8E, 0x05, 0x68, 0x02, 0x04,
0x25, 0xA2, 0x01, 0x22, 0xE4, 0xF5, 0xA8, 0xF5, 0xA0, 0x75, 0x90, 0xC0, 0xD2, 0x8A, 0xD2, 0x88,
0x12, 0x13, 0x05, 0x7D, 0x69, 0x7F, 0x1C, 0x12, 0x0C, 0xC8, 0x7D, 0x78, 0x7F, 0x1D, 0x12, 0x0C,
0xC8, 0x7D, 0x0C, 0x7F, 0x1E, 0x12, 0x0C, 0xCC, 0x7F, 0x1F, 0x12, 0x12, 0xE6, 0xEF, 0x54, 0xF8,
0xFD, 0x7F, 0x1F, 0x12, 0x0C, 0xCC, 0x7F, 0x50, 0x12, 0x12, 0xEE, 0xEF, 0x54, 0xF7, 0xF5, 0x55,
0xB4, 0x56, 0x09, 0x7D, 0x20, 0x7F, 0x61, 0x12, 0x0D, 0x15, 0x80, 0x0C, 0xE5, 0x55, 0xB4, 0x52,
0x07, 0x7D, 0x20, 0x7F, 0x61, 0x12, 0x0D, 0x00, 0x7D, 0x08, 0x7F, 0x07, 0x12, 0x0C, 0xF4, 0x7D,
0x20, 0x7F, 0x07, 0x12, 0x0C, 0xF4, 0x7D, 0x01, 0x7F, 0x6B, 0x12, 0x0C, 0xF8, 0xE4, 0xFB, 0x7D,
0x80, 0x7F, 0x0A, 0x12, 0x0D, 0x21, 0x7D, 0x10, 0x7F, 0x09, 0x12, 0x0C, 0xF4, 0x7D, 0x04, 0x7F,
0x07, 0x12, 0x0C, 0xF4, 0x7D, 0x20, 0x7F, 0x0A, 0x12, 0x0C, 0xF4, 0x7F, 0x32, 0x7E, 0x00, 0x12,
0x12, 0xC6, 0x7D, 0x20, 0x7F, 0x0A, 0x12, 0x0D, 0x09, 0x7F, 0x32, 0x7E, 0x00, 0x12, 0x12, 0xC6,
0x7D, 0x04, 0x7F, 0x07, 0x12, 0x0D, 0x09, 0x7D, 0x10, 0x7F, 0x09, 0x12, 0x0D, 0x09, 0x7D, 0x40,
0x7F, 0x4F, 0x12, 0x0D, 0x09, 0xE4, 0xF5, 0x57, 0xC2, 0x08, 0xC2, 0x05, 0xC2, 0x07, 0xC2, 0x02,
0xF5, 0x5B, 0xC2, 0x03, 0xC2, 0x0A, 0xF5, 0x40, 0xF5, 0x3E, 0xF5, 0x3F, 0x7D, 0x20, 0x7F, 0x4E,
0x12, 0x0D, 0x09, 0x75, 0x16, 0x20, 0x75, 0x10, 0xFA, 0xC2, 0x0E, 0x12, 0x0D, 0x6C, 0xC2, 0x06,
0x7D, 0x40, 0x7F, 0x4F, 0x12, 0x0C, 0xF4, 0x12, 0x10, 0x97, 0x30, 0x08, 0x05, 0x7F, 0xFF, 0x12,
0x0F, 0xAB, 0x30, 0x07, 0x11, 0x7F, 0x50, 0x12, 0x12, 0xE2, 0x12, 0x0B, 0x1A, 0xD2, 0x0D, 0x7F,
0x08, 0x12, 0x12, 0x2A, 0xC2, 0x07, 0x12, 0x09, 0x6C, 0xE5, 0x15, 0x70, 0xDA, 0x20, 0x02, 0x03,
0x02, 0x07, 0x0E, 0xC2, 0xA8, 0xC2, 0x02, 0xE5, 0x5B, 0x70, 0x03, 0x02, 0x07, 0x00, 0x30, 0x01,
0x55, 0xE5, 0x28, 0x30, 0xE7, 0x0D, 0x7D, 0x01, 0x7F, 0x18, 0x12, 0x0C, 0xD4, 0xAF, 0x5F, 0xAE,
0x5E, 0x80, 0x6B, 0xE5, 0x28, 0x30, 0xE6, 0x0D, 0x7D, 0x02, 0x7F, 0x18, 0x12, 0x0C, 0xD4, 0xAF,
0x5D, 0xAE, 0x5C, 0x80, 0x59, 0xE5, 0x28, 0x30, 0xE5, 0x0D, 0x7D, 0x03, 0x7F, 0x18, 0x12, 0x0C,
0xD4, 0xAF, 0x53, 0xAE, 0x52, 0x80, 0x47, 0xE5, 0x28, 0x30, 0xE4, 0x0D, 0x7D, 0x04, 0x7F, 0x18,
0x12, 0x0C, 0xD4, 0xAF, 0x50, 0xAE, 0x4F, 0x80, 0x35, 0x7D, 0x05, 0x7F, 0x18, 0x12, 0x0C, 0xD4,
0xAF, 0x53, 0xAE, 0x52, 0x80, 0x28, 0x30, 0x00, 0x21, 0xE5, 0x29, 0x30, 0xE5, 0x06, 0xAF, 0x27,
0xAE, 0x26, 0x80, 0x1A, 0xE5, 0x29, 0x30, 0xE2, 0x0B, 0xE4, 0x25, 0x27, 0xFF, 0xE5, 0x26, 0x34,
0xFE, 0xFE, 0x80, 0x0A, 0xAF, 0x23, 0xAE, 0x22, 0x80, 0x04, 0xAF, 0x53, 0xAE, 0x52, 0x12, 0x10,
0x23, 0xE5, 0x55, 0xB4, 0x56, 0x09, 0x7D, 0x20, 0x7F, 0x61, 0x12, 0x0D, 0x15, 0x80, 0x0C, 0xE5,
0x55, 0xB4, 0x52, 0x07, 0x7D, 0x20, 0x7F, 0x61, 0x12, 0x0D, 0x00, 0x7F, 0x02, 0x12, 0x0B, 0x1A,
0x7D, 0xAA, 0x7F, 0x18, 0x12, 0x0C, 0xD4, 0x75, 0x15, 0x71, 0xD2, 0xA8, 0x80, 0x03, 0x75, 0x15,
0x4B, 0x30, 0x03, 0x61, 0x30, 0x0A, 0x56, 0xE5, 0x29, 0x30, 0xE5, 0x0D, 0x7D, 0x06, 0x7F, 0x18,
0x12, 0x0C, 0xD4, 0xAF, 0x25, 0xAE, 0x24, 0x80, 0x22, 0xE5, 0x29, 0x30, 0xE2, 0x12, 0x7D, 0x07,
0x7F, 0x18, 0x12, 0x0C, 0xD4, 0xE4, 0x25, 0x25, 0xFF, 0xE5, 0x24, 0x34, 0xFE, 0xFE, 0x80, 0x0B,
0x7D, 0x08, 0x7F, 0x18, 0x12, 0x0C, 0xD4, 0xAF, 0x4A, 0xAE, 0x49, 0x12, 0x10, 0x23, 0xE5, 0x55,
0xB4, 0x56, 0x09, 0x7D, 0x20, 0x7F, 0x61, 0x12, 0x0D, 0x15, 0x80, 0x0C, 0xE5, 0x55, 0xB4, 0x52,
0x07, 0x7D, 0x20, 0x7F, 0x61, 0x12, 0x0D, 0x00, 0x7F, 0x04, 0x12, 0x0B, 0x1A, 0xC2, 0x03, 0x75,
0x15, 0x19, 0x02, 0x06, 0x27, 0x75, 0x15, 0x4B, 0x02, 0x06, 0x27, 0x7F, 0x2A, 0x12, 0x12, 0xEE,
0x8F, 0x66, 0x7F, 0x2B, 0x12, 0x12, 0xEE, 0x8F, 0x67, 0x7F, 0x2C, 0x12, 0x12, 0xEE, 0x8F, 0x68,
0x7F, 0x2D, 0x12, 0x12, 0xEE, 0x8F, 0x69, 0x7F, 0x2E, 0x12, 0x12, 0xEE, 0x8F, 0x6A, 0x7F, 0x2F,
0x12, 0x12, 0xEE, 0x8F, 0x6B, 0x7F, 0x30, 0x12, 0x12, 0xEE, 0x8F, 0x6C, 0x7F, 0x31, 0x12, 0x12,
0xEE, 0x8F, 0x6D, 0x7F, 0x32, 0x12, 0x12, 0xEE, 0x8F, 0x6E, 0x7F, 0x33, 0x12, 0x12, 0xEE, 0x8F,
0x6F, 0x7F, 0x34, 0x12, 0x12, 0xEE, 0x8F, 0x70, 0x7F, 0x35, 0x12, 0x12, 0xEE, 0x8F, 0x71, 0xE5,
0x66, 0x75, 0xF0, 0x08, 0xA4, 0x7C, 0x00, 0x25, 0x67, 0xFF, 0xEC, 0x35, 0xF0, 0xFE, 0xE4, 0xFD,
0x78, 0xBF, 0x12, 0x02, 0xB7, 0x78, 0xBF, 0x12, 0x02, 0xAB, 0xE4, 0xFB, 0x7A, 0x04, 0xF9, 0xF8,
0x12, 0x01, 0x6D, 0x78, 0xBF, 0x12, 0x02, 0xB7, 0x78, 0xBF, 0x12, 0x02, 0xAB, 0xE4, 0xFB, 0x7A,
0x04, 0xF9, 0xF8, 0x12, 0x01, 0x6D, 0x78, 0xBF, 0x12, 0x02, 0xB7, 0xE5, 0x68, 0x75, 0xF0, 0x08,
0xA4, 0x7C, 0x00, 0x25, 0x69, 0xFF, 0xEC, 0x35, 0xF0, 0xFE, 0x78, 0xC3, 0xF6, 0xFA, 0x08, 0xEF,
0xF6, 0x78, 0xBF, 0x12, 0x12, 0x62, 0x78, 0xD1, 0x12, 0x02, 0xB7, 0xE4, 0xF5, 0x65, 0x78, 0xD1,
0x12, 0x02, 0xAB, 0x8F, 0x64, 0xC3, 0x74, 0x38, 0x95, 0x65, 0xFF, 0xAD, 0x64, 0x12, 0x0C, 0xD4,
0x78, 0xD1, 0x12, 0x02, 0xAB, 0x78, 0x08, 0x12, 0x02, 0x98, 0x78, 0xD1, 0x12, 0x02, 0xB7, 0x05,
0x65, 0xE5, 0x65, 0xC3, 0x94, 0x03, 0x40, 0xD6, 0xE5, 0x6A, 0x75, 0xF0, 0x08, 0xA4, 0x7C, 0x00,
0x25, 0x6B, 0xFF, 0xEC, 0x35, 0xF0, 0xFE, 0xE4, 0xFD, 0x78, 0xC5, 0x12, 0x02, 0xB7, 0x78, 0xC5,
0x12, 0x02, 0xAB, 0xE4, 0xFB, 0x7A, 0x04, 0xF9, 0xF8, 0x12, 0x01, 0x6D, 0x78, 0xC5, 0x12, 0x02,
0xB7, 0x78, 0xC5, 0x12, 0x02, 0xAB, 0xE4, 0xFB, 0x7A, 0x04, 0xF9, 0xF8, 0x12, 0x01, 0x6D, 0x78,
0xC5, 0x12, 0x02, 0xB7, 0xE5, 0x6C, 0x75, 0xF0, 0x08, 0xA4, 0x7C, 0x00, 0x25, 0x6D, 0xFF, 0xEC,
0x35, 0xF0, 0xFE, 0x78, 0xC9, 0xF6, 0xFA, 0x08, 0xEF, 0xF6, 0x78, 0xC5, 0x12, 0x12, 0x62, 0x78,
0xD5, 0x12, 0x02, 0xB7, 0xE4, 0xF5, 0x65, 0x78, 0xD5, 0x12, 0x02, 0xAB, 0x8F, 0x64, 0xC3, 0x74,
0x3B, 0x95, 0x65, 0xFF, 0xAD, 0x64, 0x12, 0x0C, 0xD4, 0x78, 0xD5, 0x12, 0x02, 0xAB, 0x78, 0x08,
0x12, 0x02, 0x98, 0x78, 0xD5, 0x12, 0x02, 0xB7, 0x05, 0x65, 0xE5, 0x65, 0xC3, 0x94, 0x03, 0x40,
0xD6, 0xE5, 0x6E, 0x75, 0xF0, 0x08, 0xA4, 0x7C, 0x00, 0x25, 0x6F, 0xFF, 0xEC, 0x35, 0xF0, 0xFE,
0xE4, 0xFD, 0x78, 0xCB, 0x12, 0x02, 0xB7, 0x78, 0xCB, 0x12, 0x02, 0xAB, 0xE4, 0xFB, 0x7A, 0x04,
0xF9, 0xF8, 0x12, 0x01, 0x6D, 0x78, 0xCB, 0x12, 0x02, 0xB7, 0x78, 0xCB, 0x12, 0x02, 0xAB, 0xE4,
0xFB, 0x7A, 0x04, 0xF9, 0xF8, 0x12, 0x01, 0x6D, 0x78, 0xCB, 0x12, 0x02, 0xB7, 0xE5, 0x70, 0x75,
0xF0, 0x08, 0xA4, 0x7C, 0x00, 0x25, 0x71, 0xFF, 0xEC, 0x35, 0xF0, 0xFE, 0x78, 0xCF, 0xF6, 0xFA,
0x08, 0xEF, 0xF6, 0xFB, 0x78, 0xCB, 0x12, 0x12, 0x63, 0x78, 0xD9, 0x12, 0x02, 0xB7, 0xE4, 0xF5,
0x65, 0x78, 0xD9, 0x12, 0x02, 0xAB, 0x8F, 0x64, 0xC3, 0x74, 0x3E, 0x95, 0x65, 0xFF, 0xAD, 0x64,
0x12, 0x0C, 0xD4, 0x78, 0xD9, 0x12, 0x02, 0xAB, 0x78, 0x08, 0x12, 0x02, 0x98, 0x78, 0xD9, 0x12,
0x02, 0xB7, 0x05, 0x65, 0xE5, 0x65, 0xC3, 0x94, 0x03, 0x40, 0xD6, 0x22, 0xE4, 0xF5, 0x61, 0xF5,
0x62, 0x7F, 0x51, 0x12, 0x12, 0xEE, 0xEF, 0x54, 0x10, 0xF5, 0x60, 0xC3, 0xE5, 0x62, 0x94, 0xFF,
0xE5, 0x61, 0x94, 0x1F, 0x50, 0x30, 0x7F, 0x51, 0x12, 0x12, 0xEE, 0xEF, 0x54, 0x10, 0x65, 0x60,
0x60, 0x1A, 0xE5, 0x40, 0xB4, 0x01, 0x0A, 0xE4, 0xF5, 0x40, 0x7D, 0x20, 0x7F, 0x4E, 0x12, 0x0D,
0x09, 0x75, 0x61, 0x1F, 0x75, 0x62, 0xFF, 0xE4, 0xF5, 0x3E, 0xF5, 0x3F, 0x05, 0x62, 0xE5, 0x62,
0x70, 0xC9, 0x05, 0x61, 0x80, 0xC5, 0x05, 0x3F, 0xE5, 0x3F, 0x70, 0x02, 0x05, 0x3E, 0x64, 0x02,
0x45, 0x3E, 0x70, 0x2E, 0xE5, 0x40, 0x70, 0x25, 0x75, 0x40, 0x01, 0xFF, 0x12, 0x0B, 0x1A, 0x7D,
0x20, 0x7F, 0x4E, 0x12, 0x0C, 0xF4, 0x7D, 0x02, 0x7F, 0x4E, 0x12, 0x0C, 0xF4, 0xC2, 0x02, 0xE4,
0xF5, 0x5B, 0x7D, 0x04, 0x7F, 0x4E, 0x12, 0x0C, 0xF4, 0xC2, 0x03, 0xC2, 0x0A, 0xE4, 0xF5, 0x3E,
0xF5, 0x3F, 0xE5, 0x40, 0x64, 0x01, 0x70, 0x03, 0x02, 0x0B, 0x19, 0x7F, 0x25, 0x12, 0x12, 0xEA,
0xEF, 0x54, 0x10, 0xFF, 0x65, 0x5B, 0x60, 0x58, 0x8F, 0x5B, 0xE5, 0x5B, 0x60, 0x35, 0x7F, 0x4E,
0x12, 0x12, 0xE2, 0xEF, 0x20, 0xE6, 0x0A, 0xE4, 0xF5, 0x58, 0x12, 0x02, 0xC3, 0x92, 0x01, 0x80,
0x0E, 0x7F, 0x4E, 0x12, 0x12, 0xE2, 0xEF, 0x30, 0xE6, 0x05, 0xAF, 0x57, 0x12, 0x0B, 0x1A, 0x7D,
0x02, 0x7F, 0x4E, 0x12, 0x0D, 0x09, 0x7D, 0x04, 0x7F, 0x4E, 0x12, 0x0C, 0xF4, 0xC2, 0x03, 0xC2,
0x0A, 0x80, 0x0F, 0x7D, 0x02, 0x7F, 0x4E, 0x12, 0x0C, 0xF4, 0xE5, 0x57, 0x54, 0xFD, 0xFF, 0x12,
0x0B, 0x1A, 0x7D, 0x80, 0x7F, 0x4E, 0x12, 0x0D, 0x09, 0xD2, 0x0E, 0x75, 0x10, 0xFA, 0xD2, 0x02,
0xE5, 0x5B, 0x60, 0x03, 0x02, 0x0A, 0xFC, 0x7D, 0x04, 0x7F, 0x26, 0x12, 0x0C, 0xFC, 0x7D, 0x20,
0x7F, 0x1A, 0x12, 0x0D, 0x0D, 0x7D, 0x02, 0x7F, 0x74, 0x12, 0x0C, 0xF4, 0x7F, 0x50, 0x7E, 0x00,
0x12, 0x12, 0xC6, 0x7D, 0x02, 0x7F, 0x74, 0x12, 0x0D, 0x09, 0x7F, 0x50, 0x7E, 0x00, 0x12, 0x12,
0xC6, 0x7D, 0x02, 0x7F, 0x74, 0x12, 0x0C, 0xF4, 0x7F, 0x7C, 0x12, 0x12, 0xE6, 0xEF, 0x54, 0xFC,
0xFF, 0x64, 0xFC, 0x60, 0x32, 0xEF, 0x60, 0x2F, 0x20, 0x0A, 0x42, 0x7F, 0x4E, 0x12, 0x12, 0xE2,
0xEF, 0x20, 0xE6, 0x08, 0x75, 0x58, 0x80, 0x12, 0x02, 0xC3, 0x80, 0x0E, 0x7F, 0x4E, 0x12, 0x12,
0xE2, 0xEF, 0x30, 0xE6, 0x05, 0xAF, 0x57, 0x12, 0x0B, 0x1A, 0x7D, 0x04, 0x7F, 0x4E, 0x12, 0x0D,
0x09, 0xD2, 0x03, 0xD2, 0x0A, 0x80, 0x16, 0x30, 0x0A, 0x13, 0xD2, 0x03, 0xC2, 0x0A, 0x7D, 0x04,
0x7F, 0x4E, 0x12, 0x0C, 0xF4, 0xE5, 0x57, 0x54, 0xFB, 0xFF, 0x12, 0x0B, 0x1A, 0x30, 0x03, 0x0C,
0x7D, 0x80, 0x7F, 0x4E, 0x12, 0x0D, 0x09, 0x75, 0x10, 0xFA, 0xD2, 0x0E, 0x30, 0x0E, 0x0D, 0xE5,
0x10, 0x70, 0x09, 0x7D, 0x80, 0x7F, 0x4E, 0x12, 0x0C, 0xF4, 0xC2, 0x0E, 0x7F, 0x4E, 0x12, 0x12,
0xE2, 0xEF, 0x30, 0xE6, 0x04, 0xC2, 0x02, 0xC2, 0x03, 0x22, 0x8F, 0x63, 0xC2, 0x0B, 0xE5, 0x63,
0x60, 0x04, 0xF5, 0x57, 0x80, 0x55, 0x7D, 0x10, 0x7F, 0x0A, 0x12, 0x0D, 0x09, 0x7D, 0x40, 0x7F,
0x0A, 0x12, 0x0D, 0x09, 0xE4, 0xFB, 0x7D, 0x80, 0x7F, 0x0A, 0x12, 0x0D, 0x21, 0x7D, 0x10, 0x7F,
0x09, 0x12, 0x0C, 0xF4, 0x7D, 0x04, 0x7F, 0x07, 0x12, 0x0C, 0xF4, 0x7D, 0x20, 0x7F, 0x0A, 0x12,
0x0C, 0xF4, 0x12, 0x12, 0xBB, 0x7D, 0x20, 0x7F, 0x0A, 0x12, 0x0D, 0x09, 0x12, 0x12, 0xC2, 0x7D,
0x04, 0x7F, 0x07, 0x12, 0x0D, 0x09, 0x7F, 0x32, 0x7E, 0x00, 0x12, 0x12, 0xC6, 0x7D, 0x10, 0x7F,
0x09, 0x12, 0x0D, 0x09, 0x7F, 0x0A, 0x7E, 0x00, 0x12, 0x12, 0xC6, 0x53, 0x63, 0x1F, 0x7F, 0x07,
0x12, 0x12, 0xE2, 0xEF, 0x44, 0x5B, 0xF5, 0x4B, 0x7F, 0x08, 0x12, 0x12, 0xE2, 0xEF, 0x44, 0xFE,
0xF5, 0x4C, 0x7F, 0x09, 0x12, 0x12, 0xE2, 0xEF, 0x44, 0x0F, 0xF5, 0x4E, 0x7F, 0x0A, 0x12, 0x12,
0xE2, 0xEF, 0x44, 0x0A, 0xF5, 0x56, 0x7F, 0x08, 0x12, 0x12, 0xE6, 0xEF, 0x54, 0xFE, 0xF5, 0x4D,
0x7F, 0x6B, 0x12, 0x12, 0xE6, 0xEF, 0x44, 0x02, 0xF5, 0x59, 0x7F, 0x6C, 0x12, 0x12, 0xE6, 0xEF,
0x44, 0x02, 0xF5, 0x5A, 0x7F, 0x54, 0x12, 0x12, 0xEE, 0xEF, 0x44, 0x10, 0xF5, 0x54, 0x7F, 0x61,
0x12, 0x12, 0xEE, 0xEF, 0x44, 0x02, 0xF5, 0x51, 0xE5, 0x63, 0x30, 0xE2, 0x17, 0xD2, 0x0B, 0x53,
0x4B, 0xFD, 0x53, 0x4C, 0xF1, 0x53, 0x4E, 0xF3, 0x43, 0x4D, 0x01, 0x53, 0x59, 0xFD, 0x53, 0x54,
0xEF, 0x53, 0x51, 0xFD, 0xE5, 0x63, 0x30, 0xE1, 0x2F, 0xD2, 0x0B, 0x7F, 0x1E, 0x12, 0x12, 0xE2,
0xEF, 0xC4, 0x13, 0x13, 0x54, 0x01, 0xFF, 0xBF, 0x01, 0x04, 0x7F, 0xB5, 0x80, 0x02, 0x7F, 0xF4,
0xEF, 0x52, 0x4B, 0x53, 0x4C, 0x0F, 0x53, 0x4E, 0xF2, 0x53, 0x56, 0xFD, 0x53, 0x59, 0xFD, 0x53,
0x5A, 0xFD, 0x53, 0x54, 0xEF, 0x53, 0x51, 0xFD, 0xAD, 0x4B, 0x7F, 0x07, 0x12, 0x0C, 0xC8, 0xAD,
0x4C, 0x7F, 0x08, 0x12, 0x0C, 0xC8, 0xAD, 0x4E, 0x7F, 0x09, 0x12, 0x0C, 0xC8, 0xAD, 0x56, 0x7F,
0x0A, 0x12, 0x0C, 0xC8, 0xAD, 0x4D, 0x7F, 0x08, 0x12, 0x0C, 0xCC, 0xAD, 0x59, 0x7F, 0x6B, 0x12,
0x0C, 0xCC, 0xAD, 0x5A, 0x7F, 0x6C, 0x12, 0x0C, 0xCC, 0xAD, 0x54, 0x7F, 0x54, 0x12, 0x0C, 0xD4,
0xAD, 0x51, 0x7F, 0x61, 0x12, 0x0C, 0xD4, 0x85, 0x63, 0x2B, 0x85, 0x4B, 0x2C, 0x85, 0x4C, 0x2D,
0x85, 0x4E, 0x2E, 0x85, 0x56, 0x2F, 0x85, 0x4D, 0x30, 0x30, 0x0B, 0x4B, 0x7D, 0x10, 0x7F, 0x09,
0x12, 0x0C, 0xF4, 0x7D, 0x04, 0x7F, 0x07, 0x12, 0x0C, 0xF4, 0x7D, 0x20, 0x7F, 0x0A, 0x12, 0x0C,
0xF4, 0x12, 0x07, 0x7B, 0x7D, 0x40, 0x7F, 0x0A, 0x12, 0x0C, 0xF4, 0x7D, 0x90, 0x7F, 0x0A, 0x12,
0x0D, 0x09, 0x7D, 0x80, 0x7F, 0x0A, 0x12, 0x0C, 0xF4, 0xE4, 0xFB, 0x7D, 0x10, 0x7F, 0x0A, 0x12,
0x0D, 0x21, 0xE5, 0x55, 0xB4, 0x52, 0x09, 0x12, 0x12, 0xBB, 0x12, 0x12, 0xBB, 0x12, 0x12, 0xC2,
0x7F, 0x01, 0x7E, 0x00, 0x12, 0x12, 0xC6, 0x22, 0x7B, 0x00, 0x80, 0x0A, 0x7B, 0x01, 0x80, 0x06,
0x7B, 0x03, 0x80, 0x02, 0x7B, 0x04, 0x7C, 0x00, 0x80, 0x00, 0x12, 0x0C, 0xE8, 0xE2, 0x5C, 0x4D,
0xF2, 0x78, 0x03, 0xEB, 0xF2, 0xD2, 0xAF, 0x22, 0xC2, 0xAF, 0x78, 0x83, 0xE2, 0xCB, 0xF2, 0x74,
0x80, 0x2F, 0xF8, 0x22, 0x7B, 0x00, 0x80, 0x0A, 0x7B, 0x01, 0x80, 0x06, 0x7B, 0x03, 0x80, 0x02,
0x7B, 0x04, 0xED, 0xF4, 0xFC, 0x7D, 0x00, 0x80, 0xD1, 0x7B, 0x00, 0x80, 0x0A, 0x7B, 0x01, 0x80,
0x06, 0x7B, 0x03, 0x80, 0x02, 0x7B, 0x04, 0x7C, 0xFF, 0x80, 0xBF, 0x7B, 0x03, 0x80, 0x02, 0x7B,
0x04, 0x12, 0x0C, 0xE8, 0xED, 0xF4, 0xFF, 0xE2, 0x5F, 0xF2, 0x4D, 0xF2, 0x5F, 0xF2, 0x80, 0xB1,
0x8E, 0x83, 0x8F, 0x82, 0xE4, 0x93, 0xA3, 0xFB, 0x54, 0x0F, 0xCB, 0x54, 0xF0, 0xB4, 0xF0, 0x01,
0x22, 0xFD, 0xE4, 0x93, 0xA3, 0xFF, 0xE4, 0x93, 0xA3, 0xCD, 0xB4, 0x00, 0x05, 0x12, 0x0C, 0xD6,
0x80, 0xE2, 0xB4, 0x10, 0x05, 0x12, 0x0D, 0x02, 0x80, 0xDA, 0xB4, 0x20, 0x05, 0x12, 0x0D, 0x17,
0x80, 0xD2, 0xB4, 0x30, 0x05, 0x12, 0x0D, 0x21, 0x80, 0xCA, 0x80, 0xC8, 0xC2, 0x96, 0xD2, 0x97,
0xD2, 0x96, 0x22, 0x22, 0xC2, 0x97, 0xD2, 0x96, 0x74, 0x28, 0x00, 0x00, 0xD5, 0xE0, 0xFB, 0xD2,
0x97, 0x74, 0x1E, 0x00, 0x00, 0xD5, 0xE0, 0xFB, 0x22, 0xC2, 0x97, 0xD2, 0x97, 0x74, 0x1E, 0x00,
0x00, 0xD5, 0xE0, 0xFB, 0xD2, 0x96, 0x74, 0x28, 0x00, 0x00, 0xD5, 0xE0, 0xFB, 0x22, 0xD2, 0x97,
0xD2, 0x96, 0x74, 0x28, 0x00, 0x00, 0xD5, 0xE0, 0xFB, 0xC2, 0x97, 0x74, 0x1E, 0x00, 0x00, 0xD5,
0xE0, 0xFB, 0xC2, 0x96, 0x74, 0x1E, 0x00, 0x00, 0xD5, 0xE0, 0xFB, 0x22, 0xEF, 0x7E, 0x08, 0x33,
0xC0, 0xE0, 0x40, 0x04, 0xC2, 0x97, 0x80, 0x02, 0xD2, 0x97, 0x74, 0x11, 0x00, 0x00, 0xD5, 0xE0,
0xFB, 0xD2, 0x96, 0x74, 0x11, 0x00, 0x00, 0xD5, 0xE0, 0xFB, 0xC2, 0x96, 0x74, 0x11, 0x00, 0x00,
0xD5, 0xE0, 0xFB, 0xD0, 0xE0, 0xDE, 0xD8, 0xD2, 0x97, 0x74, 0x11, 0x00, 0x00, 0xD5, 0xE0, 0xFB,
0xD2, 0x96, 0x74, 0x11, 0x00, 0x00, 0xD5, 0xE0, 0xFB, 0xA2, 0x97, 0xE4, 0x92, 0xE0, 0xFE, 0xC2,
0x96, 0x74, 0x11, 0x00, 0x00, 0xD5, 0xE0, 0xFB, 0xEE, 0x22, 0x8F, 0x77, 0x8D, 0x78, 0x7F, 0x61,
0x12, 0x12, 0xEE, 0xEF, 0x54, 0x40, 0xF5, 0x7B, 0xE5, 0x77, 0xB4, 0x01, 0x04, 0x7F, 0x40, 0x80,
0x02, 0x7F, 0x00, 0x8F, 0x79, 0x43, 0x79, 0x80, 0xAD, 0x79, 0x7F, 0x0A, 0x12, 0x0C, 0xD4, 0xE5,
0x79, 0x44, 0x20, 0xFD, 0x7F, 0x0A, 0x12, 0x0C, 0xD4, 0xAD, 0x79, 0x7F, 0x0A, 0x12, 0x0C, 0xD4,
0x7F, 0x0E, 0x12, 0x12, 0xEE, 0xEF, 0x20, 0xE7, 0x4E, 0x7F, 0x61, 0x12, 0x12, 0xEE, 0xEF, 0x54,
0x40, 0x65, 0x7B, 0x60, 0x03, 0x7F, 0xFF, 0x22, 0x7F, 0x0E, 0x12, 0x12, 0xEE, 0xEF, 0x30, 0xE6,
0x03, 0x7F, 0x01, 0x22, 0x85, 0x79, 0x7A, 0x7F, 0x0C, 0x12, 0x12, 0xEE, 0x8F, 0x79, 0xE5, 0x7A,
0x65, 0x79, 0x60, 0x04, 0x7F, 0x01, 0x80, 0x02, 0x7F, 0x00, 0xE5, 0x79, 0x60, 0x04, 0x7E, 0x01,
0x80, 0x02, 0x7E, 0x00, 0xEE, 0x5F, 0x60, 0xB8, 0x7F, 0x0D, 0x12, 0x12, 0xEE, 0xE5, 0x79, 0x14,
0x25, 0x78, 0xF8, 0xA6, 0x07, 0x80, 0xA9, 0x7F, 0x00, 0x22, 0x78, 0x7F, 0xE4, 0xF6, 0xD8, 0xFD,
0x75, 0x81, 0xE0, 0x02, 0x0E, 0xE1, 0x02, 0x05, 0x44, 0xE4, 0x93, 0xA3, 0xF8, 0xE4, 0x93, 0xA3,
0x40, 0x03, 0xF6, 0x80, 0x01, 0xF2, 0x08, 0xDF, 0xF4, 0x80, 0x29, 0xE4, 0x93, 0xA3, 0xF8, 0x54,
0x07, 0x24, 0x0C, 0xC8, 0xC3, 0x33, 0xC4, 0x54, 0x0F, 0x44, 0x20, 0xC8, 0x83, 0x40, 0x04, 0xF4,
0x56, 0x80, 0x01, 0x46, 0xF6, 0xDF, 0xE4, 0x80, 0x0B, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40,
0x80, 0x90, 0x13, 0x26, 0xE4, 0x7E, 0x01, 0x93, 0x60, 0xBC, 0xA3, 0xFF, 0x54, 0x3F, 0x30, 0xE5,
0x09, 0x54, 0x1F, 0xFE, 0xE4, 0x93, 0xA3, 0x60, 0x01, 0x0E, 0xCF, 0x54, 0xC0, 0x25, 0xE0, 0x60,
0xA8, 0x40, 0xB8, 0xE4, 0x93, 0xA3, 0xFA, 0xE4, 0x93, 0xA3, 0xF8, 0xE4, 0x93, 0xA3, 0xC8, 0xC5,
0x82, 0xC8, 0xCA, 0xC5, 0x83, 0xCA, 0xF0, 0xA3, 0xC8, 0xC5, 0x82, 0xC8, 0xCA, 0xC5, 0x83, 0xCA,
0xDF, 0xE9, 0xDE, 0xE7, 0x80, 0xBE, 0x25, 0x6A, 0xFD, 0xAF, 0x67, 0x8F, 0x72, 0x8D, 0x73, 0x8B,
0x74, 0x75, 0x75, 0x03, 0xE5, 0x58, 0x42, 0x72, 0xE5, 0x72, 0x30, 0xE7, 0x04, 0x7F, 0x01, 0x80,
0x02, 0x7F, 0x00, 0x8F, 0x76, 0x53, 0x72, 0x7F, 0x12, 0x0D, 0x73, 0x12, 0x0D, 0x9E, 0x7F, 0xFF,
0x12, 0x0D, 0xBC, 0x12, 0x0D, 0x74, 0xAF, 0x75, 0x15, 0x75, 0xEF, 0x60, 0x4C, 0xE5, 0x76, 0x70,
0x1D, 0xE5, 0x72, 0xD3, 0x94, 0x00, 0x40, 0x16, 0x12, 0x0D, 0x73, 0x12, 0x0D, 0x9E, 0x7F, 0x60,
0x12, 0x0D, 0xBC, 0xAF, 0x72, 0x12, 0x0D, 0xBC, 0x12, 0x0D, 0x89, 0x12, 0x0D, 0x73, 0xE5, 0x76,
0x60, 0x0D, 0xE5, 0x73, 0xFD, 0x7C, 0x00, 0xAB, 0x74, 0x7F, 0x50, 0x7E, 0x02, 0x80, 0x0B, 0xE5,
0x73, 0xFD, 0x7C, 0x00, 0xAB, 0x74, 0x7F, 0x50, 0x7E, 0x00, 0x12, 0x11, 0x77, 0x7D, 0x7F, 0xE4,
0xFF, 0x12, 0x0E, 0x0A, 0xEF, 0x70, 0xAF, 0xD3, 0x22, 0xC3, 0x22, 0xAD, 0x07, 0x8D, 0x60, 0xED,
0xF4, 0x70, 0x6D, 0x7F, 0x50, 0x12, 0x12, 0xE2, 0xAD, 0x07, 0xED, 0x54, 0x80, 0xFF, 0x53, 0x05,
0x7F, 0xED, 0xC4, 0x13, 0x54, 0x07, 0xFE, 0xED, 0x54, 0x1F, 0x75, 0xF0, 0x08, 0xA4, 0xFD, 0xEF,
0x4E, 0xFF, 0x7B, 0x08, 0x12, 0x0F, 0x2B, 0x92, 0x0B, 0xAD, 0x60, 0x7F, 0x7F, 0xE4, 0xF5, 0x60,
0x30, 0x0B, 0x08, 0xEF, 0x25, 0x60, 0xF8, 0xE6, 0xFE, 0x80, 0x02, 0x7E, 0x00, 0x74, 0x2A, 0x25,
0x60, 0xF8, 0xA6, 0x06, 0x05, 0x60, 0xE5, 0x60, 0xB4, 0x08, 0xE5, 0xA2, 0x0B, 0x92, 0x0D, 0x7F,
0x08, 0x12, 0x12, 0x2A, 0xC2, 0x08, 0x7D, 0x40, 0x7F, 0x4F, 0x12, 0x0C, 0xF4, 0x30, 0x0B, 0x09,
0x7D, 0x80, 0x7F, 0x50, 0x12, 0x0C, 0xF4, 0x80, 0x07, 0x7D, 0x40, 0x7F, 0x50, 0x12, 0x0D, 0x09,
0xA2, 0x0B, 0x22, 0x8E, 0x60, 0x8F, 0x61, 0x75, 0x2A, 0x01, 0xE5, 0x2A, 0x70, 0x04, 0xE5, 0x2B,
0x60, 0x64, 0x7D, 0x02, 0xAF, 0x61, 0xAE, 0x60, 0x12, 0x12, 0x8F, 0x74, 0x02, 0x25, 0x61, 0xF5,
0x61, 0xE4, 0x35, 0x60, 0xF5, 0x60, 0xE5, 0x2A, 0xB4, 0xFF, 0x05, 0xE5, 0x2B, 0xF4, 0x60, 0x46,
0xE5, 0x2A, 0x70, 0x04, 0xE5, 0x2B, 0x60, 0x3E, 0xE5, 0x2A, 0xB4, 0x03, 0x05, 0x85, 0x2B, 0x62,
0x80, 0xC8, 0xE5, 0x62, 0x14, 0x60, 0x14, 0x24, 0xFE, 0x60, 0x19, 0x14, 0x60, 0x1F, 0x24, 0x04,
0x70, 0xB8, 0xAD, 0x2B, 0xAF, 0x2A, 0x12, 0x0C, 0xC8, 0x80, 0xAF, 0xAD, 0x2B, 0xAF, 0x2A, 0x12,
0x0C, 0xCC, 0x80, 0xA6, 0xAD, 0x2B, 0xAF, 0x2A, 0x12, 0x0C, 0xD0, 0x80, 0x9D, 0xAD, 0x2B, 0xAF,
0x2A, 0x12, 0x0C, 0xD4, 0x80, 0x94, 0x22, 0xD2, 0x0B, 0xD2, 0x0C, 0x20, 0x06, 0x69, 0x7F, 0x4F,
0x12, 0x12, 0xE2, 0xEF, 0x30, 0xE6, 0x60, 0xD2, 0x06, 0x53, 0x07, 0x3F, 0xEF, 0x24, 0xF9, 0x60,
0x0E, 0x24, 0xE8, 0x60, 0x10, 0x24, 0x1E, 0x70, 0x40, 0xD2, 0x08, 0xC2, 0x0B, 0x80, 0x3E, 0xD2,
0x07, 0xC2, 0x0B, 0x80, 0x38, 0x75, 0x60, 0x13, 0x75, 0x61, 0x4F, 0xE4, 0xFE, 0xE5, 0x61, 0x2E,
0xF5, 0x82, 0xE4, 0x35, 0x60, 0xF5, 0x83, 0xE4, 0x93, 0xFD, 0x74, 0x2A, 0x2E, 0xF8, 0xA6, 0x05,
0x0E, 0xBE, 0x07, 0xE9, 0x7F, 0x50, 0x12, 0x12, 0xEE, 0x8F, 0x2D, 0x7F, 0x51, 0x12, 0x12, 0xEE,
0xEF, 0x54, 0x0F, 0xF5, 0x2E, 0x7F, 0x07, 0x80, 0x04, 0xE4, 0xFF, 0xC2, 0x0C, 0x30, 0x0B, 0x07,
0xA2, 0x0C, 0x92, 0x0D, 0x12, 0x12, 0x2A, 0xA2, 0x06, 0x22, 0x8F, 0x6E, 0x75, 0x71, 0x7F, 0xE4,
0xF5, 0x6F, 0xE5, 0x6E, 0xC3, 0x13, 0xFF, 0xE5, 0x6E, 0x30, 0xE0, 0x04, 0x7D, 0x80, 0x80, 0x02,
0x7D, 0x00, 0x7B, 0x40, 0x12, 0x0F, 0x2B, 0x40, 0x01, 0x22, 0xE4, 0xF5, 0x70, 0xE5, 0x71, 0x25,
0x70, 0xF8, 0xE6, 0x25, 0x6F, 0xF5, 0x6F, 0x05, 0x70, 0xE5, 0x70, 0xB4, 0x40, 0xEF, 0xE5, 0x6E,
0xC3, 0x13, 0xFF, 0xE5, 0x6E, 0x30, 0xE0, 0x04, 0x7E, 0x80, 0x80, 0x02, 0x7E, 0x00, 0xEE, 0x24,
0x40, 0xFD, 0x7B, 0x40, 0x12, 0x0F, 0x2B, 0x40, 0x01, 0x22, 0xE4, 0xF5, 0x70, 0xE5, 0x71, 0x25,
0x70, 0xF8, 0xE6, 0x25, 0x6F, 0xF5, 0x6F, 0x05, 0x70, 0xE5, 0x70, 0xB4, 0x40, 0xEF, 0xE5, 0x6F,
0x70, 0x03, 0xD3, 0x80, 0x01, 0xC3, 0x22, 0x8E, 0x77, 0x8F, 0x78, 0x8C, 0x79, 0x8D, 0x7A, 0x8B,
0x7B, 0xE5, 0x77, 0xF5, 0x7C, 0xEF, 0xF5, 0x7D, 0xE5, 0x7C, 0x7D, 0x40, 0x7F, 0x61, 0x30, 0xE1,
0x05, 0x12, 0x0D, 0x15, 0x80, 0x03, 0x12, 0x0D, 0x00, 0x53, 0x7C, 0x01, 0xE5, 0x7C, 0x70, 0x0B,
0xE5, 0x79, 0x25, 0x7D, 0xF5, 0x7D, 0xE4, 0xF5, 0x7E, 0x80, 0x04, 0xE5, 0x79, 0xF5, 0x7E, 0xAD,
0x7D, 0x7F, 0x28, 0x12, 0x0C, 0xD4, 0xAD, 0x7E, 0x7F, 0x40, 0x12, 0x0C, 0xD4, 0xE5, 0x7A, 0xF5,
0x7E, 0xAD, 0x7E, 0x7F, 0x29, 0x12, 0x0C, 0xD4, 0xAD, 0x7B, 0x7F, 0x08, 0x12, 0x0C, 0xD4, 0xAF,
0x7C, 0x22, 0xC0, 0xE0, 0xC0, 0xD0, 0xC2, 0x8C, 0x75, 0x8A, 0x40, 0x75, 0x8C, 0x7C, 0xD2, 0x8C,
0x05, 0x17, 0xE5, 0x17, 0x70, 0x19, 0x05, 0x11, 0xE5, 0x11, 0xD3, 0x94, 0x02, 0x40, 0x05, 0x75,
0x11, 0x00, 0xD2, 0x09, 0xE5, 0x11, 0xB4, 0x01, 0x03, 0xD3, 0x80, 0x01, 0xC3, 0x92, 0x04, 0xE5,
0x12, 0x60, 0x02, 0x15, 0x12, 0xE5, 0x14, 0x45, 0x13, 0x60, 0x08, 0xE5, 0x14, 0x15, 0x14, 0x70,
0x02, 0x15, 0x13, 0xE5, 0x15, 0x60, 0x02, 0x15, 0x15, 0xE5, 0x16, 0x60, 0x02, 0x15, 0x16, 0xE5,
0x10, 0x60, 0x02, 0x15, 0x10, 0xD0, 0xD0, 0xD0, 0xE0, 0x32, 0x8F, 0x62, 0xE4, 0xF5, 0x63, 0xE5,
0x63, 0xC3, 0x95, 0x62, 0x50, 0x15, 0xE5, 0x63, 0x90, 0x13, 0x47, 0x93, 0xFF, 0x74, 0x2A, 0x25,
0x63, 0xF8, 0xE6, 0xFD, 0x12, 0x0C, 0xCC, 0x05, 0x63, 0x80, 0xE4, 0x20, 0x0D, 0x03, 0x43, 0x62,
0x80, 0xAD, 0x62, 0x7F, 0x50, 0x12, 0x0C, 0xC8, 0x7D, 0x40, 0x7F, 0x4F, 0x12, 0x0C, 0xF4, 0xC2,
0x06, 0x22, 0xFB, 0x12, 0x02, 0xAB, 0x8A, 0x76, 0x8B, 0x77, 0x8F, 0x75, 0x8E, 0x74, 0x8D, 0x73,
0x8C, 0x72, 0xAE, 0x76, 0xAF, 0x77, 0xAB, 0x07, 0xAA, 0x06, 0xE4, 0xF9, 0xF8, 0xAF, 0x75, 0xAE,
0x74, 0x12, 0x01, 0xF8, 0x78, 0xDD, 0x12, 0x02, 0xB7, 0x78, 0xDD, 0x12, 0x02, 0xAB, 0x22, 0x8E,
0x63, 0x8F, 0x64, 0x8D, 0x65, 0xE4, 0xF5, 0x66, 0xAB, 0x65, 0xAD, 0x64, 0xAC, 0x63, 0x7F, 0x57,
0x7E, 0x03, 0x12, 0x11, 0x77, 0x7D, 0x2A, 0x7F, 0x01, 0x12, 0x0E, 0x0A, 0xEF, 0x70, 0x02, 0xD3,
0x22, 0x05, 0x66, 0xE5, 0x66, 0xD3, 0x94, 0x02, 0x40, 0xDE, 0x22, 0x7F, 0xC8, 0x7E, 0x00, 0x12,
0x12, 0xC6, 0x7F, 0xC8, 0x7E, 0x00, 0xAD, 0x07, 0xAC, 0x06, 0xE4, 0x12, 0x00, 0xB3, 0xE4, 0xFB,
0xFA, 0x79, 0x20, 0x78, 0x40, 0x12, 0x00, 0x11, 0x12, 0x00, 0xEC, 0x8F, 0x12, 0xE5, 0x12, 0x70,
0xFC, 0x22, 0x7D, 0x00, 0x80, 0x0A, 0x7D, 0x01, 0x80, 0x06, 0x7D, 0x03, 0x80, 0x02, 0x7D, 0x04,
0xC2, 0xAF, 0x78, 0x83, 0xE2, 0xCD, 0xF2, 0x74, 0x80, 0x2F, 0xF8, 0xE2, 0x78, 0x03, 0xFF, 0xED,
0xF2, 0xD2, 0xAF, 0x22, 0x32, 0xC2, 0xAF, 0xE4, 0xF5, 0x12, 0x75, 0x15, 0x19, 0xF5, 0x17, 0xF5,
0x11, 0xC2, 0x8C, 0x53, 0x89, 0xF0, 0x43, 0x89, 0x01, 0x75, 0x8A, 0x40, 0x75, 0x8C, 0x7C, 0xD2,
0xA9, 0xD2, 0x8C, 0xD2, 0xAF, 0x22, 0x02, 0x24, 0x18, 0x00, 0x02, 0x26, 0x19, 0x00, 0x02, 0x52,
0x1A, 0x00, 0x02, 0x4F, 0x1B, 0x00, 0x02, 0x5E, 0x1C, 0x00, 0x02, 0x5C, 0x1D, 0x00, 0x02, 0x49,
0x1E, 0x00, 0x02, 0x22, 0x1F, 0x00, 0x00, 0x26, 0x27, 0x42, 0x43, 0x44, 0x45, 0x46, 0x51, 0x07,
0x01, 0x13, 0x00, 0x00, 0x01, 0x00, 0x10, 0x80, 0x1F, 0x40, 0x04, 0x20, 0x13, 0x10, 0x00, 0x50,
0x00, 0x40, 0x04, 0x80, 0x70, 0x38, 0x40, 0x20
};

/*----------------------------------------------------------------------------*/
typedef enum tagINMODEINDEX{
	RGB888_800x480_60Hz = 0,	// YL6410 demo
	RGB888_1024x600_60Hz,
	NUM_INPUT_TIMING,			// always be the last
	
}INMODEINDEX;
/*----------------------------------------------------------------------------*/
static EDID_TIMING gInputModes[] = {
	{	// RGB888_800x480_60Hz
		33250,	PIXEL_FMT_RGB888, POL_LOW, POL_LOW, POL_HIGH,
		65,  928,  800,	 40,  48,  550,  480,  17,  24,
	},
	{ 	// RGB888_1024x600_60Hz
		50400,	PIXEL_FMT_RGB888, POL_LOW, POL_LOW, POL_HIGH,
		60, 1344, 1024,  40, 128,  625,  600, 10,  3,
	},
};
/*----------------------------------------------------------------------------*/
static HDMI_UTIL_FUNCS hdmi_util = {0};

static uint8 output_ratate  = ROTATE_NO;
static uint8 output_flip    = 0;
static uint8 output_hscale  = 0; 
static uint8 output_vscale = 0;
//static uint8 mcu_autofunc;
static int mode_index = N_KNOWN_MODES;
static int from_edid  = 1;				// 0: from known modes table, 1: from panel EDID
//static int wakeup_chip  = 1;
//static int dither_on    = 0;
static int input_index  = RGB888_1024x600_60Hz;
static EDID_TIMING	edid_timing;
static CH703x_INPUT_INFO	input_timing;
static CH703x_OUTPUT_INFO	output_timing;

#define MAX_EDID_BLOCKS		4
static unsigned char gEDIDBuffer[128*MAX_EDID_BLOCKS];
/*----------------------------------------------------------------------------*/
//static int hdmi_i2c_detect(struct i2c_client *client, int kind, struct i2c_board_info *info) {
//    strcpy(info->type, HDMI_DEVICE_NAME);
//    return 0;
//}
/*----------------------------------------------------------------------------*/

int ch7035_i2c_read_byte(u8 addr, u8 *data)
{
    u8 buf;
    int ret = 0;
    struct i2c_client *client = ch7035_i2c_client;
    
    buf = addr;
    ret = i2c_master_send(client, (const char*)&buf, 1);
    if (ret < 0) 
    {
        CH7035_LOG("send command error!!\n");
        return -EFAULT;
    }
    ret = i2c_master_recv(client, (char*)&buf, 1);
    if (ret < 0) 
    {
        CH7035_LOG("reads data error!!\n");
        return -EFAULT;
    } 
#if defined(HDMI_DEBUG)     
    else 
    {
       CH7035_LOG("%s(0x%02X) = %02X\n", __func__, addr, buf);    

    }
#endif    
    *data = buf;
    return 0;
}
/*----------------------------------------------------------------------------*/
EXPORT_SYMBOL_GPL(ch7035_i2c_read_byte);
/*----------------------------------------------------------------------------*/

int ch7035_i2c_write_byte(u8 addr, u8 data)
{
    struct i2c_client *client = ch7035_i2c_client;
    u8 buf[] = {addr, data};
    int ret = 0;

    ret = i2c_master_send(client, (const char*)buf, sizeof(buf));
    if (ret < 0) 
    {
        CH7035_LOG("send command error!!\n");
        return -EFAULT;
    } 
#if defined(HDMI_DEBUG)    
    else 
    {
        CH7035_LOG("%s(0x%02X)= %02X\n", __func__, addr, data);
    }
#endif    
    return 0;
}
/*----------------------------------------------------------------------------*/
EXPORT_SYMBOL_GPL(ch7035_i2c_write_byte);
/*----------------------------------------------------------------------------*/

int ch7035_i2c_read_block( u8 addr, u8 *data, int len )
{
    struct i2c_client *client = ch7035_i2c_client;
    if (len == 1) 
    {
        return ch7035_i2c_read_byte(addr, data);
    } 
    else 
    {
        u8 beg = addr; 
        struct i2c_msg msgs[2] = 
        {
            {
                .addr = client->addr,    .flags = 0,
                .len = 1,                .buf= &beg
            },
            {
                .addr = client->addr,    .flags = I2C_M_RD,
                .len = len,             .buf = data,
            }
        };
        int err;

        if (!client)
        {
            return -EINVAL;
        }
        else if (len > MAX_TRANSACTION_LENGTH) 
        {        
            CH7035_LOG(" length %d exceeds %d\n", len, MAX_TRANSACTION_LENGTH);
            return -EINVAL;
        }

        err = i2c_transfer(client->adapter, msgs, sizeof(msgs)/sizeof(msgs[0]));
        if (err != 2) 
        {
            CH7035_LOG("i2c_transfer error: (%d %p %d) %d\n", addr, data, len, err);
            err = -EIO;
        } 
        else 
        {           
            err = 0;    /*no error*/
        }
        return err;
    }
}
/*----------------------------------------------------------------------------*/
EXPORT_SYMBOL_GPL(ch7035_i2c_read_block);
/*----------------------------------------------------------------------------*/

int ch7035_i2c_write_block( u8 addr, u8 *data, int len )
{
    /*because address also occupies one byte, the maximum length for write is 7 bytes*/
    int err, idx, num;
    char buf[MAX_TRANSACTION_LENGTH];
    struct i2c_client *client = ch7035_i2c_client;
    
    if (!client)
    {
        return -EINVAL;
    }
    else if (len >= MAX_TRANSACTION_LENGTH) 
    {        
        CH7035_LOG(" length %d exceeds %d\n", len, MAX_TRANSACTION_LENGTH);
        return -EINVAL;
    }    

    num = 0;
    buf[num++] = addr;
    for (idx = 0; idx < len; idx++)
    {
        buf[num++] = data[idx];
    }

    err = i2c_master_send(client, buf, num);
    if (err < 0) 
    {
        CH7035_LOG("send command error!!\n");
        return -EFAULT;
    } 
    else 
    {     
        err = 0;    /*no error*/
    }
    return err;
}
/*----------------------------------------------------------------------------*/
EXPORT_SYMBOL_GPL(ch7035_i2c_write_block);
/*----------------------------------------------------------------------------*/

void hdmi_poll_isr(unsigned long n)
{
    //CH7035_FUNC();
    atomic_set(&hdmi_timer_event, 1);
    wake_up_interruptible(&hdmi_timer_wq);
    
    mod_timer(&r_hdmi_timer, jiffies + gHDMI_CHK_INTERVAL/(1000/HZ));
}
/*----------------------------------------------------------------------------*/

static void show_output_timing(int i, EDID_TIMING * timing)
{
    CH7035_LOG(" %2d - %s %02d %4d x %4d %c %dHz %6dKHz %c %c\n",  i,
        	(timing->pixel_fmt & PIXEL_HDMI_ENCODE_DVI) ? " DVI" : "HDMI",
        	PIXEL_HDMI_FOTMAT(timing->pixel_fmt),
        	timing->ha, timing->va,
        	(timing->pixel_fmt & PIXEL_HDMI_ENCODE_INTERLACE) ? 'i' : 'p',
        	timing->fps, timing->clk_khz,
        	(timing->pixel_fmt & PIXEL_REDUCED_BLANKING) ? 'R' : ' ',
        	(timing->pixel_fmt & PIXEL_HDMI_ENCODE_NATIVE) ? 'n' : ' ');
}
/*----------------------------------------------------------------------------*/

static void show_input_timing(int i, EDID_TIMING* timing)
{
    CH7035_LOG("  %2d - %dKHz, 0x%X, %d, %d, %d,\n"
           "       %dfps, H %d %d %d %d, V %d %d %d %d\n",
    	    i, timing->clk_khz, timing->pixel_fmt,
    	    timing->hs_pol, timing->vs_pol, timing->de_pol,
    	    timing->fps, timing->ht, timing->ha, timing->ho, timing->hw,
    	    timing->vt, timing->va, timing->vo, timing->vw);
}
/*----------------------------------------------------------------------------*/

static void ToInputInfo(CH703x_INPUT_INFO *pInputInfo, EDID_TIMING *pTiming)
{
    pInputInfo->if_type = IF_PRO;
    pInputInfo->pixel_fmt.format = pTiming->pixel_fmt;	// IDF: RGB 888
    pInputInfo->pixel_fmt.bit_swap = 0;					// REVERSE
    pInputInfo->pixel_fmt.byte_swap = BYTE_SWAP_RGB;	// SWAP
    pInputInfo->pixel_fmt.byte_align = 0;				// HIGH
    pInputInfo->pixel_fmt.multiplexed = MULTI_1X;		// MULTI
    pInputInfo->pixel_fmt.m2x_fmt.halfword_swap = 0;	// SWP_PAPB
    pInputInfo->pixel_fmt.m2x_fmt.halfword_align = 0;	// AH_LB
    pInputInfo->pixel_fmt.m2x_fmt.yc_swap = 0 ;			// SWP_YC
    pInputInfo->pixel_fmt.m3x_fmt.byte_align = 0;		// POS3X
    pInputInfo->pixel_fmt.embedded_sync = 0;			// DES
    
    pInputInfo->audio_type = AUDIO_I2S;
    pInputInfo->spdif_mode = SPDIF_MOD_CMOS;
    pInputInfo->i2s_pol    = POL_HIGH;
    pInputInfo->i2s_fmt    = I2S_FMT_STD;
    pInputInfo->i2s_len    = I2S_LEN_20B;
    
    pInputInfo->crystal_used = 1;
    pInputInfo->crystal_khz  = 27000;
    
    pInputInfo->pclk_khz  = pTiming->clk_khz;
    pInputInfo->timing.ht = pTiming->ht;
    pInputInfo->timing.ha = pTiming->ha;
    pInputInfo->timing.ho = pTiming->ho;
    pInputInfo->timing.hw = pTiming->hw;
    pInputInfo->timing.vt = pTiming->vt;
    pInputInfo->timing.va = pTiming->va;
    pInputInfo->timing.vo = pTiming->vo;
    pInputInfo->timing.vw = pTiming->vw;
    pInputInfo->hs_pol    = pTiming->hs_pol;
    pInputInfo->vs_pol    = pTiming->vs_pol;
    pInputInfo->de_pol    = pTiming->de_pol;
}
/*----------------------------------------------------------------------------*/

static void ToOutputInfo(CH703x_OUTPUT_INFO* pOutputInfo, EDID_TIMING* pTiming)
{
    // public timing
    pOutputInfo->uclk_khz  = pTiming->clk_khz;
    pOutputInfo->timing.ht = pTiming->ht;
    pOutputInfo->timing.ha = pTiming->ha;
    pOutputInfo->timing.ho = pTiming->ho;
    pOutputInfo->timing.hw = pTiming->hw;
    pOutputInfo->timing.vt = pTiming->vt;
    pOutputInfo->timing.va = pTiming->va;
    pOutputInfo->timing.vo = pTiming->vo;
    pOutputInfo->timing.vw = pTiming->vw;
    
    // output channel
    pOutputInfo->channel  =  CHANNEL_HDMI;
    
    // lvds
    pOutputInfo->lvds_fmt.bypass = 1;
    if(pTiming->clk_khz == 100000 && pTiming->ht == 2084 && pTiming->vt == 800) {
        pOutputInfo->lvds_fmt.channel_swap = 14;
    } else {
        pOutputInfo->lvds_fmt.channel_swap = LVDS_CHANNEL_SWAP_DEF;
    }
    pOutputInfo->lvds_fmt.channel_pol = POL_NO_INV;	// (POL_LOW << 4) | (POL_LOW << 3) | (POL_LOW << 2) | (POL_LOW << 1) | (POL_LOW << 0);
    pOutputInfo->lvds_fmt.hs_pol   = pTiming->hs_pol;
    pOutputInfo->lvds_fmt.vs_pol   = pTiming->vs_pol;
    pOutputInfo->lvds_fmt.de_pol   = POL_HIGH;	// pTiming->de_pol;
    pOutputInfo->lvds_fmt.pwm_freq = 100;
    pOutputInfo->lvds_fmt.pwm_duty = 128;
    pOutputInfo->lvds_fmt.pwm_inv  = POL_NO_INV;
    pOutputInfo->lvds_fmt.spwg_t1  = 32;
    pOutputInfo->lvds_fmt.spwg_t2  = 256;
    pOutputInfo->lvds_fmt.spwg_t3  = 256;
    pOutputInfo->lvds_fmt.spwg_t4  = 32;
    pOutputInfo->lvds_fmt.spwg_t5  = 256;
    
    // hdmi
    pOutputInfo->hdmi_fmt.bypass       = 0;
    pOutputInfo->hdmi_fmt.is_dvi_mode  = (PIXEL_HDMI_ENCODE_DVI & pTiming->pixel_fmt) ? 1 : 0;
    pOutputInfo->hdmi_fmt.format_index = PIXEL_HDMI_FOTMAT(pTiming->pixel_fmt);
    pOutputInfo->hdmi_fmt.aspect_ratio = PIXEL_HDMI_ASPECT(pTiming->pixel_fmt);
    pOutputInfo->hdmi_fmt.channel_swap = HDMI_CHANNEL_SWAP_DEF;
    pOutputInfo->hdmi_fmt.hs_pol       = pTiming->hs_pol;
    pOutputInfo->hdmi_fmt.vs_pol       = pTiming->vs_pol;
    pOutputInfo->hdmi_fmt.data_pol_invert = POL_NO_INV;
    //	pOutputInfo->hdmi_fmt.protect_enable  = 0;
    //	pOutputInfo->hdmi_fmt.interlace = (PIXEL_HDMI_ENCODE_INTERLACE & pTiming->pixel_fmt) ? 1 : 0;
    
    // VGA
    pOutputInfo->vga_fmt.bypass = 1;
    pOutputInfo->vga_fmt.hs_pol = pTiming->hs_pol;
    pOutputInfo->vga_fmt.vs_pol = pTiming->vs_pol;
    pOutputInfo->vga_fmt.de_pol = POL_HIGH;		// pTiming->de_pol;
    pOutputInfo->vga_fmt.channel_swap = VGA_CHANNEL_SWAP_DEF;
    pOutputInfo->vga_fmt.sync_swap    = VGA_SYNC_SWAP_DEF;
    pOutputInfo->vga_fmt.csync_type   = VGA_CSYNC_XOR;
    
    // hdtv
    pOutputInfo->hdtv_fmt.bypass = 1;
    pOutputInfo->hdtv_fmt.channel_swap = HDTV_CHANNEL_SWAP_DEF;
    pOutputInfo->hdtv_fmt.format_index = PIXEL_HDMI_FOTMAT(pTiming->pixel_fmt);
    
    // features
    pOutputInfo->ds_percent_h = output_hscale;	// wyc fix
    pOutputInfo->ds_percent_v = output_vscale;
    pOutputInfo->rotate = output_ratate;
    pOutputInfo->h_flip =  output_flip & 1;
    pOutputInfo->v_flip = (output_flip & 2) >> 1;
}
/*----------------------------------------------------------------------------*/

int config_mode(void)
{
    int i, ret = 0;
    
    CH7035_FUNC();
    
    // input format
    CH7035_LOG("Input timing:\n");
    show_input_timing(input_index, &gInputModes[input_index]);
    ToInputInfo(&input_timing, &gInputModes[input_index]);
    
    if (from_edid) {
        ret = ch_get_edid(DEV_CH7035F, gEDIDBuffer, sizeof(gEDIDBuffer), GET_HDMI_EDID);	// prefer HDMI EDID
        if (ret < 0) {
        	CH7035_LOG("ch_get_edid %d\n", ret);
        }
        
        ret = parse_edid_timing(gEDIDBuffer);
        if (ret < 0) {
        	CH7035_LOG("parse_edid_timing %d\n", ret);
        }
        
        // always list the timing modes in panel EDID
        for(i = 0; get_edid_timing(&edid_timing, i) >= 0; i++) {
        	show_output_timing(i, &edid_timing);
        }
    }
    
    // get output timing
    if (from_edid) { // from panel EDID
        CH7035_LOG("Output from EDID\n");
        ret = get_edid_timing(&edid_timing, mode_index);
    } else { // from known timing talbe
        CH7035_LOG("Output from know timing\n");
        ret = get_known_timing(&edid_timing, mode_index);
    }
    if (ret < 0) {
        CH7035_LOG("get output timing %d\n", ret);
    }
    
    CH7035_LOG("Output timing:\n");
    show_output_timing(ret, &edid_timing);
    
    // disable MCU auto set mode
    //mcu_autofunc = ch_enable_MCU_AutoFunc(DEV_CH7035F, 0);
    
    ToOutputInfo(&output_timing, &edid_timing);
    ret = ch_set_mode(DEV_CH7035F, &input_timing, &output_timing);
    CH7035_LOG("ch_set_mode: %d\n", ret);
    
    // test, to check whether input timing is correct
    // It will report lost syncing(0x20) if input timing is not correct
    //ret = ch_check_connection(DEV_CH7035F, VGA_HOTPLUG_DELAY);
    //CH7035_LOG("ch_check_connection: 0x%X\n",ret);
    
    // disable MCU auto set mode
    // ch_enable_MCU_AutoFunc(DEV_CH7035F, 0); wyc
    return ret;
}

/*----------------------------------------------------------------------------*/

static void ch7035_set_util_funcs(const HDMI_UTIL_FUNCS *util)
{
    memcpy(&hdmi_util, util, sizeof(HDMI_UTIL_FUNCS));
}
/*----------------------------------------------------------------------------*/

static void ch7035_get_params(HDMI_PARAMS *params)
{
    memset(params, 0, sizeof(HDMI_PARAMS));
    
    CH7035_LOG("720p\n");
    params->init_config.vformat 		= HDMI_VIDEO_1280x720p_60Hz;
    params->init_config.aformat 		= HDMI_AUDIO_PCM_16bit_48000;
    
    params->clk_pol           = HDMI_POLARITY_RISING;
    params->de_pol            = HDMI_POLARITY_RISING;
    params->vsync_pol         = HDMI_POLARITY_FALLING;
    params->hsync_pol         = HDMI_POLARITY_FALLING;
    
    params->hsync_pulse_width = 128;
    params->hsync_back_porch  = 152;
    params->hsync_front_porch = 40;
    params->vsync_pulse_width = 3;
    params->vsync_back_porch  = 12;
    params->vsync_front_porch = 10;
    
    params->rgb_order         = HDMI_COLOR_ORDER_RGB;
    
    params->io_driving_current = IO_DRIVING_CURRENT_2MA;
    params->intermediat_buffer_num = 2;
    params->output_mode         = HDMI_OUTPUT_MODE_DPI_BYPASS;
    params->is_force_awake  = 1;
    params->is_force_landscape = 1;
}
/*----------------------------------------------------------------------------*/

static void ch7035_suspend(void)
{
    CH7035_FUNC();
    //ch_set_channel_power(DEV_CH7035F, 0); //output A/V needed
    //ch_set_chip_power(DEV_CH7035F, 0); //hotplug needed    
    //reset variables
    mode_index = N_KNOWN_MODES;
    ucHdmi_Plugin = 0;  
}
/*----------------------------------------------------------------------------*/

static void ch7035_resume(void)
{
    CH7035_FUNC();
    //ch_set_chip_power(DEV_CH7035F, 1); //hotplug needed
}
/*----------------------------------------------------------------------------*/

static int ch7035_enter(void) //ch7035 re-power on
{
//    int ret = -1;
    CH7035_FUNC();
#if 0    
    mt_set_gpio_mode(GPIO_HDMI_POWER_CONTROL, GPIO_MODE_00);  //CH7035_RESET
    mt_set_gpio_dir(GPIO_HDMI_POWER_CONTROL, GPIO_DIR_OUT);
    mt_set_gpio_out(GPIO_HDMI_POWER_CONTROL, GPIO_OUT_ONE);

    // input format
    CH7035_LOG("Input timing:\n");
    show_input_timing(input_index, &gInputModes[input_index]);
    ToInputInfo(&input_timing, &gInputModes[input_index]);
        
    //check if chip exist
    if(DEV_UNKNOW == ch_check_chip(DEV_CH7035F))
    {
        ucHdmi_chip_exist = 0;
        CH7035_LOG("ch_check_chip not exist!\n");
    }
    else
    {
        CH7035_LOG("ch_check_chip exist!\n");
        ucHdmi_chip_exist = 1;   
        ucHdmi_Plugin = 0;
        //ch_set_chip_power(DEV_CH7035F, CHANNEL_HDMI); //hotplug needed   
        ret = ch_start_firmware(DEV_CH7035F);
        if( ret != 0) 
        {
            ret = ch_load_firmware(DEV_CH7035F, u1FW_Table, sizeof(u1FW_Table));
            CH7035_LOG("ch_load_firmware:%d,size=%d\n",ret,sizeof(u1FW_Table));
            ret = ch_start_firmware(DEV_CH7035F);
            CH7035_LOG("ch_start_firmware:%d\n",ret);
        }  
    }
#endif    
    return 0;
}
/*----------------------------------------------------------------------------*/

static int ch7035_exit(void) //ch7035 power off
{
    CH7035_FUNC();

    //todo: wait for HW ready, turn off ch7035 individual 3.3V power source
    
    mt_set_gpio_mode(GPIO_HDMI_POWER_CONTROL, GPIO_MODE_00);  //CH7035_RESET
    mt_set_gpio_dir(GPIO_HDMI_POWER_CONTROL, GPIO_DIR_OUT);
    mt_set_gpio_out(GPIO_HDMI_POWER_CONTROL, GPIO_OUT_ZERO);
    return 0;
}
/*----------------------------------------------------------------------------*/

static int ch7035_video_config(HDMI_VIDEO_RESOLUTION vformat, HDMI_VIDEO_INPUT_FORMAT vin, HDMI_VIDEO_OUTPUT_FORMAT vout)
{
    int i4Tmp;
    CH7035_FUNC();
    RETINT(0 == ucHdmi_chip_exist, 0);
    CH7035_LOG("hdmi format=%d\n", vformat);

    switch(vformat)
    {
        case HDMI_VIDEO_720x480p_60Hz:
            i4Tmp = HDMI_02_720x480P_60;
            break;
        case HDMI_VIDEO_1280x720p_60Hz:
            i4Tmp = HDMI_04_1280x720P_60;
            break;    
        default:
            i4Tmp = GETTIMING_NATIVEMODE;
            break;
    }    

    if(i4Tmp != mode_index)
    {
        CH7035_LOG("hdmi format change!\n");
        mode_index = i4Tmp;
        from_edid = (mode_index == GETTIMING_NATIVEMODE) ? 1 : 0;
        config_mode();
        //ch_set_channel_power(DEV_CH7035F, CHANNEL_HDMI); //output A/V needed
    }
    return 0;
}
/*----------------------------------------------------------------------------*/

static int ch7035_audio_config(HDMI_AUDIO_FORMAT aformat)
{
    CH7035_FUNC();
    RETINT(0 == ucHdmi_chip_exist, 0);
    return 0;
}
/*----------------------------------------------------------------------------*/

static int ch7035_video_enable(bool enable)
{
    CH7035_FUNC();
    RETINT(0 == ucHdmi_chip_exist, 0);
    return 0;
}
/*----------------------------------------------------------------------------*/

static int ch7035_audio_enable(bool enable)
{	
    CH7035_FUNC();
    RETINT(0 == ucHdmi_chip_exist, 0);
    return 0;
}
/*----------------------------------------------------------------------------*/

void hdmi_timer_impl(void)
{
    int ret;
    ret = ch_check_connection(DEV_CH7035F, VGA_HOTPLUG_DELAY);
    //CH7035_LOG("ch_check_connection: 0x%X\n",ret);  
   
    if((0x02 == (ret & 0x0F)) && (ucHdmi_Plugin == 0)) //plug in
    {
        CH7035_LOG("Plug in\n");
        ucHdmi_Plugin = 1;
        hdmi_util.state_callback(HDMI_STATE_ACTIVE);
    }
    else if((0x02 != (ret & 0x0F)) && (ucHdmi_Plugin == 1)) //plug out
    {
        CH7035_LOG("Plug out\n");
        ucHdmi_Plugin = 0;
        hdmi_util.state_callback(HDMI_STATE_NO_DEVICE);
    }

}
/*----------------------------------------------------------------------------*/

static int hdmi_timer_kthread(void *data)
{
    struct sched_param param = { .sched_priority = RTPM_PRIO_SCRN_UPDATE };
    sched_setscheduler(current, SCHED_RR, &param);
    
    for( ;; ) {
        wait_event_interruptible(hdmi_timer_wq, atomic_read(&hdmi_timer_event));
	 atomic_set(&hdmi_timer_event,0);
        hdmi_timer_impl();
        if (kthread_should_stop())
            break;
    }

    return 0;
}
/*----------------------------------------------------------------------------*/

static int ch7035_init(void)
{        
    CH7035_FUNC();
    
    i2c_register_board_info(0, &i2c_hdmi, 1);

    if(i2c_add_driver(&hdmi_i2c_driver)) {
      CH7035_LOG("unable to add HDMI i2c driver.\n");
      return -1;
    }

    return 0;
}
/*----------------------------------------------------------------------------*/

void ch7035_set_mode(unsigned char ucMode)
{
    CH7035_LOG("%s, mode=%d\n", __func__,ucMode);
    mode_index = ucMode;
}
/*----------------------------------------------------------------------------*/

int ch7035_power_on(void)  //ch7035 suspend
{
    // Start: Temp solution for ch7035 indivial power not ready
    int ret = -1;
    CH7035_FUNC();
    
    mt_set_gpio_mode(GPIO_HDMI_POWER_CONTROL, GPIO_MODE_00);  //CH7035_RESET
    mt_set_gpio_dir(GPIO_HDMI_POWER_CONTROL, GPIO_DIR_OUT);
    mt_set_gpio_out(GPIO_HDMI_POWER_CONTROL, GPIO_OUT_ONE);

    // input format
    CH7035_LOG("Input timing:\n");
    show_input_timing(input_index, &gInputModes[input_index]);
    ToInputInfo(&input_timing, &gInputModes[input_index]);
        
    //check if chip exist
    if(DEV_UNKNOW == ch_check_chip(DEV_CH7035F))
    {
        ucHdmi_chip_exist = 0;
        CH7035_LOG("ch_check_chip not exist!\n");
    }
    else
    {
        CH7035_LOG("ch_check_chip exist!\n");
        ucHdmi_chip_exist = 1;   
        ucHdmi_Plugin = 0;
        //ch_set_chip_power(DEV_CH7035F, CHANNEL_HDMI); //hotplug needed   
        ret = ch_start_firmware(DEV_CH7035F);
        if( ret != 0) 
        {
            ret = ch_load_firmware(DEV_CH7035F, u1FW_Table, sizeof(u1FW_Table));
            CH7035_LOG("ch_load_firmware:%d,size=%d\n",ret,sizeof(u1FW_Table));
            ret = ch_start_firmware(DEV_CH7035F);
            CH7035_LOG("ch_start_firmware:%d\n",ret);
        }  
    }    
    // End: Temp solution for ch7035 indivial power not ready
    
    RETNULL(0 == ucHdmi_chip_exist);

    mt_set_gpio_mode(GPIO60, GPIO_MODE_00);  //HDMI_5V_EN
    mt_set_gpio_dir(GPIO60, GPIO_DIR_OUT);
    mt_set_gpio_out(GPIO60, GPIO_OUT_ONE);

    //ch_set_chip_power(DEV_CH7035F, CHANNEL_HDMI); //hotplug needed

    //reset variables
    mode_index = N_KNOWN_MODES;
    ucHdmi_Plugin = 0;
    
    if(0 == ucHdmi_isr_en)
    {
        CH7035_LOG("r_hdmi_timer\n");
        memset((void*)&r_hdmi_timer, 0, sizeof(r_hdmi_timer));
        r_hdmi_timer.expires  = jiffies + 1000/(1000/HZ);   // wait 1s to stable
        r_hdmi_timer.function = hdmi_poll_isr;     
        r_hdmi_timer.data     = 0;
        init_timer(&r_hdmi_timer);
        add_timer(&r_hdmi_timer);
        ucHdmi_isr_en = 1;
    }

    return 0;
}
/*----------------------------------------------------------------------------*/

void ch7035_power_off(void)  //ch7035 resume
{
    CH7035_FUNC();
    
    RETNULL(0 == ucHdmi_chip_exist);
     
    if(ucHdmi_isr_en)
    {
        ucHdmi_isr_en = 0;
        del_timer(&r_hdmi_timer);
        memset((void*)&r_hdmi_timer, 0, sizeof(r_hdmi_timer));
    }
    
    mt_set_gpio_mode(GPIO60, GPIO_MODE_00);  //HDMI_5V_EN
    mt_set_gpio_dir(GPIO60, GPIO_DIR_OUT);
    mt_set_gpio_out(GPIO60, GPIO_OUT_ZERO);   

    //ch_set_channel_power(DEV_CH7035F, 0); //output A/V needed
    //ch_set_chip_power(DEV_CH7035F, 0); //hotplug needed
}
/*----------------------------------------------------------------------------*/

void ch7035_dump(void)
{
    CH7035_FUNC();
    ch_dump_reg();
}
/*----------------------------------------------------------------------------*/

void ch7035_read(unsigned char u8Reg)
{
    CH7035_FUNC();
    ch_read_reg(u8Reg);
}
/*----------------------------------------------------------------------------*/

void ch7035_write(unsigned char u8Reg, unsigned char u8Data)
{
    CH7035_FUNC();
    ch_write_reg(u8Reg,u8Data);
}
/*----------------------------------------------------------------------------*/

static int hdmi_i2c_probe(struct i2c_client *client, const struct i2c_device_id *id) 
{             
    int ret = -1;
    struct ch7035_i2c_data *obj;
    
    CH7035_LOG("MediaTek HDMI i2c probe\n");
      
    obj = kzalloc(sizeof(*obj), GFP_KERNEL);
    if (obj == NULL) {
        ret = -ENOMEM;
        CH7035_LOG(HDMI_DEVICE_NAME ": Allocate ts memory fail\n");
	return ret;
    }
    obj_i2c_data = obj;
    obj->client = client;
    ch7035_i2c_client = obj->client;
    i2c_set_clientdata(client, obj);
   
    hdmi_load_status = 1;
    CH7035_LOG("MediaTek HDMI i2c probe success\n");


    init_waitqueue_head(&hdmi_timer_wq);
    hdmi_timer_task = kthread_create(hdmi_timer_kthread, NULL, "hdmi_timer_kthread"); 
    wake_up_process(hdmi_timer_task);

    return 0;
}
/*----------------------------------------------------------------------------*/

static int hdmi_i2c_remove(struct i2c_client *client) 
{
    ch7035_i2c_client = NULL;
    i2c_unregister_device(client);
    kfree(i2c_get_clientdata(client));
    i2c_del_driver(&hdmi_i2c_driver);
    return 0;
}

/*----------------------------------------------------------------------------*/

HDMI_STATE ch7035_get_state(void)
{
    int ret;
    
    ret = ch_check_connection(DEV_CH7035F, VGA_HOTPLUG_DELAY);
    CH7035_LOG("  = 0x%X\n",ret); 
    
    if(0x02 == (ret & 0x0F))
    {
        return HDMI_STATE_ACTIVE;
    }
    else
    {
        return HDMI_STATE_NO_DEVICE;
    }
}
/*----------------------------------------------------------------------------*/

void ch7035_log_enable(bool enable)
{
    ch7035_log_on = enable;
}
/*----------------------------------------------------------------------------*/

const HDMI_DRIVER* HDMI_GetDriver(void)
{
	static const HDMI_DRIVER HDMI_DRV =
	{
		.set_util_funcs = ch7035_set_util_funcs,
		.get_params     = ch7035_get_params,
		.init           = ch7035_init,
		.enter           = ch7035_enter,
		.exit            = ch7035_exit,
		.suspend        = ch7035_suspend,
		.resume         = ch7035_resume,
		.video_config	= ch7035_video_config,
		.audio_config	= ch7035_audio_config,
		.video_enable	= ch7035_video_enable,
		.audio_enable	= ch7035_audio_enable,
		.power_on		= ch7035_power_on,
		.power_off		= ch7035_power_off,
		.set_mode		= ch7035_set_mode,
		.dump              = ch7035_dump,
		.read              = ch7035_read,
		.write             = ch7035_write,
		.get_state     = ch7035_get_state,
		.log_enable    = ch7035_log_enable
	};

	return &HDMI_DRV;
}
EXPORT_SYMBOL(HDMI_GetDriver);
