﻿/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2008
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/
/* BEGIN PN:DTS2013053103858 , Added by d00238048, 2013.05.31*/
#ifndef BUILD_LK
#include <linux/string.h>
#endif
#include "lcm_drv.h"

#ifdef BUILD_LK
    #include <platform/disp_drv_platform.h>
	#include <string.h>
#elif defined(BUILD_UBOOT)
    #include <asm/arch/mt_gpio.h>
#else
    //#include <linux/delay.h>
    #include <mach/mt_gpio.h>
#endif
#include <cust_gpio_usage.h>
#ifdef BUILD_LK
#define LCD_DEBUG(fmt)  dprintf(CRITICAL,fmt)
#else
#define LCD_DEBUG(fmt)  printk(fmt)
#endif
//static unsigned char lcd_id_pins_value = 0xFF;
static const unsigned char LCD_MODULE_ID = 0x01; //  haobing modified 2013.07.11
// ---------------------------------------------------------------------------
//  Local Constants
// ---------------------------------------------------------------------------
#define LCM_DSI_CMD_MODE									1
#define FRAME_WIDTH  										(1080)
#define FRAME_HEIGHT 										(1920)


#define REGFLAG_DELAY             								0xFC
#define REGFLAG_END_OF_TABLE      							0xFD   // END OF REGISTERS MARKER


#ifndef TRUE
    #define TRUE 1
#endif

#ifndef FALSE
    #define FALSE 0
#endif
//static unsigned int lcm_esd_test = FALSE;      ///only for ESD test
// ---------------------------------------------------------------------------
//  Local Variables
// ---------------------------------------------------------------------------

static const unsigned int BL_MIN_LEVEL =20;
static LCM_UTIL_FUNCS lcm_util;

#define SET_RESET_PIN(v)    								(lcm_util.set_reset_pin((v)))
#define MDELAY(n) 											(lcm_util.mdelay(n))

// ---------------------------------------------------------------------------
//  Local Functions
// ---------------------------------------------------------------------------

#define dsi_set_cmdq_V2(cmd, count, ppara, force_update)	lcm_util.dsi_set_cmdq_V2(cmd, count, ppara, force_update)
#define dsi_set_cmdq(pdata, queue_size, force_update)		lcm_util.dsi_set_cmdq(pdata, queue_size, force_update)
#define wrtie_cmd(cmd)										lcm_util.dsi_write_cmd(cmd)
#define write_regs(addr, pdata, byte_nums)					lcm_util.dsi_write_regs(addr, pdata, byte_nums)
#define read_reg(cmd)										lcm_util.dsi_dcs_read_lcm_reg(cmd)
#define read_reg_v2(cmd, buffer, buffer_size)   			lcm_util.dsi_dcs_read_lcm_reg_v2(cmd, buffer, buffer_size)    

struct LCM_setting_table {
    unsigned char cmd;
    unsigned char count;
    unsigned char para_list[64];
};
//update initial param for IC nt35520 0.01
static struct LCM_setting_table lcm_initialization_setting[] = 
#if 1
{
	{0xFF,1,{0x10}},	//	Return	To	CMD1		
	{REGFLAG_DELAY, 2, {}},
	{0xBB,1,{0x30}},						
	{0x3B,5,{0x03,0x0A,0x0A,0x0A,0x0A}},	
	{0x53,1,{0x24}},						
	{0x55,1,{0x00}},						
	{0x5E,1,{0x00}},						
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
					
	{0x11,0,{}},						
	{REGFLAG_DELAY, 150, {}},
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	{0xFF,1,{0x24}},	//	CMD2	Page	4	Entrance	
	{REGFLAG_DELAY, 2, {}},
	{0xFB,1,{0x01}},						
	{0x9D,1,{0xB0}},						
	{0x72,1,{0x00}},						
	{0x93,1,{0x04}},						
	{0x94,1,{0x04}},						
	{0x9B,1,{0x0F}},						
	{0x8A,1,{0x33}},						
	{0x86,1,{0x1B}},						
	{0x87,1,{0x39}},						
	{0x88,1,{0x1B}},						
	{0x89,1,{0x39}},						
	{0x8B,1,{0xF4}},						
	{0x8C,1,{0x01}},						
	{0x90,1,{0x79}},						
	{0x91,1,{0x4C}},						
	{0x92,1,{0x79}},						
	{0x95,1,{0xE4}},						

	{0xDE,1,{0xFF}},						
	{0xDF,1,{0x82}},						

	{0x00,1,{0x0F}},						
	{0x01,1,{0x00}},						
	{0x02,1,{0x00}},						
	{0x03,1,{0x00}},						
	{0x04,1,{0x0B}},						
	{0x05,1,{0x0C}},						
	{0x06,1,{0x00}},						
	{0x07,1,{0x00}},						
	{0x08,1,{0x00}},						
	{0x09,1,{0x00}},						
	{0x0A,1,{0X03}},						
	{0x0B,1,{0X04}},						
	{0x0C,1,{0x01}},						
	{0x0D,1,{0x13}},						
	{0x0E,1,{0x15}},						
	{0x0F,1,{0x17}},						
	{0x10,1,{0x0F}},						
	{0x11,1,{0x00}},						
	{0x12,1,{0x00}},						
	{0x13,1,{0x00}},						
	{0x14,1,{0x0B}},						
	{0x15,1,{0x0C}},						
	{0x16,1,{0x00}},						
	{0x17,1,{0x00}},						
	{0x18,1,{0x00}},						
	{0x19,1,{0x00}},						
	{0x1A,1,{0x03}},						
	{0x1B,1,{0X04}},						
	{0x1C,1,{0x01}},						
	{0x1D,1,{0x13}},						
	{0x1E,1,{0x15}},						
	{0x1F,1,{0x17}},						

	{0x20,1,{0x09}},						
	{0x21,1,{0x01}},						
	{0x22,1,{0x00}},						
	{0x23,1,{0x00}},						
	{0x24,1,{0x00}},						
	{0x25,1,{0x6D}},						
	{0x26,1,{0x00}},						
	{0x27,1,{0x00}},						

	{0x2F,1,{0x02}},						
	{0x30,1,{0x04}},						
	{0x31,1,{0x49}},						
	{0x32,1,{0x23}},						
	{0x33,1,{0x01}},						
	{0x34,1,{0x00}},						
	{0x35,1,{0x69}},						
	{0x36,1,{0x00}},						
	{0x37,1,{0x2D}},						
	{0x38,1,{0x08}},						
	{0x39,1,{0x00}},						
	{0x3A,1,{0x69}},						

	{0x29,1,{0x58}},						
	{0x2A,1,{0x16}},						

	{0x5B,1,{0x00}},						
	{0x5F,1,{0x75}},						
	{0x63,1,{0x00}},						
	{0x67,1,{0x04}},						

	{0x7B,1,{0x80}},						
	{0x7C,1,{0xD8}},						
	{0x7D,1,{0x60}},						
	{0x7E,1,{0x10}},						
	{0x7F,1,{0x19}},						
	{0x80,1,{0x00}},						
	{0x81,1,{0x06}},						
	{0x82,1,{0x03}},						
	{0x83,1,{0x00}},						
	{0x84,1,{0x03}},						
	{0x85,1,{0x07}},						
	{0x74,1,{0x10}},						
	{0x75,1,{0x19}},						
	{0x76,1,{0x06}},						
	{0x77,1,{0x03}},						

	{0x78,1,{0x00}},						
	{0x79,1,{0x00}},						
	{0x99,1,{0x33}},						
	{0x98,1,{0x00}},						
	{0xB3,1,{0x28}},						
	{0xB4,1,{0x05}},						
	{0xB5,1,{0x10}},						

	{0xFF,1,{0x20}},	//	Page	0,1,{	power-related	setting	
	{REGFLAG_DELAY, 2, {}},						
	{0x00,1,{0x01}},						
	{0x01,1,{0x55}},						
	{0x02,1,{0x45}},						
	{0x03,1,{0x55}},						
	{0x05,1,{0x50}},						
	{0x06,1,{0x9E}},						
	{0x07,1,{0xA8}},						
	{0x08,1,{0x0C}},						
	{0x0B,1,{0x96}},						
	{0x0C,1,{0x96}},						
	{0x0E,1,{0x00}},						
	{0x0F,1,{0x00}},						
	{0x11,1,{0x29}},						
	{0x12,1,{0x29}},						
	{0x13,1,{0x03}},						
	{0x14,1,{0x0A}},						
	{0x15,1,{0x99}},						
	{0x16,1,{0x99}},						
	{0x6D,1,{0x44}},						
	{0x58,1,{0x05}},						
	{0x59,1,{0x05}},						
	{0x5A,1,{0x05}},						
	{0x5B,1,{0x05}},						
	{0x5C,1,{0x00}},						
	{0x5D,1,{0x00}},						
	{0x5E,1,{0x00}},						
	{0x5F,1,{0x00}},						

	{0x1B,1,{0x39}},						
	{0x1C,1,{0x39}},						
	{0x1D,1,{0x47}},						

	{0xFF,1,{0x20}},	//	Page	0,1,{	power-related	setting	
	{REGFLAG_DELAY, 2, {}},							
	//	R+	,1,{}},						
	{0x75,1,{0x00}},						
	{0x76,1,{0x00}},						
	{0x77,1,{0x00}},						
	{0x78,1,{0x22}},						
	{0x79,1,{0x00}},						
	{0x7A,1,{0x46}},						
	{0x7B,1,{0x00}},						
	{0x7C,1,{0x5C}},						
	{0x7D,1,{0x00}},						
	{0x7E,1,{0x76}},						
	{0x7F,1,{0x00}},						
	{0x80,1,{0x8D}},						
	{0x81,1,{0x00}},						
	{0x82,1,{0xA6}},						
	{0x83,1,{0x00}},						
	{0x84,1,{0xB8}},						
	{0x85,1,{0x00}},						
	{0x86,1,{0xC7}},						
	{0x87,1,{0x00}},						
	{0x88,1,{0xF6}},						
	{0x89,1,{0x01}},						
	{0x8A,1,{0x1D}},						
	{0x8B,1,{0x01}},						
	{0x8C,1,{0x54}},						
	{0x8D,1,{0x01}},						
	{0x8E,1,{0x81}},						
	{0x8F,1,{0x01}},						
	{0x90,1,{0xCB}},						
	{0x91,1,{0x02}},						
	{0x92,1,{0x05}},						
	{0x93,1,{0x02}},						
	{0x94,1,{0x07}},						
	{0x95,1,{0x02}},						
	{0x96,1,{0x47}},						
	{0x97,1,{0x02}},						
	{0x98,1,{0x82}},						
	{0x99,1,{0x02}},						
	{0x9A,1,{0xAB}},						
	{0x9B,1,{0x02}},						
	{0x9C,1,{0xDC}},						
	{0x9D,1,{0x03}},						
	{0x9E,1,{0x01}},						
	{0x9F,1,{0x03}},						
	{0xA0,1,{0x3A}},						
	{0xA2,1,{0x03}},						
	{0xA3,1,{0x56}},						
	{0xA4,1,{0x03}},						
	{0xA5,1,{0x6D}},						
	{0xA6,1,{0x03}},						
	{0xA7,1,{0x89}},						
	{0xA9,1,{0x03}},						
	{0xAA,1,{0xA3}},						
	{0xAB,1,{0x03}},						
	{0xAC,1,{0xC9}},						
	{0xAD,1,{0x03}},						
	{0xAE,1,{0xDD}},						
	{0xAF,1,{0x03}},						
	{0xB0,1,{0xF5}},						
	{0xB1,1,{0x03}},						
	{0xB2,1,{0xFF}},						
	//	R-	,1,{}},						
	{0xB3,1,{0x00}},						
	{0xB4,1,{0x00}},						
	{0xB5,1,{0x00}},						
	{0xB6,1,{0x22}},						
	{0xB7,1,{0x00}},						
	{0xB8,1,{0x46}},						
	{0xB9,1,{0x00}},						
	{0xBA,1,{0x5C}},						
	{0xBB,1,{0x00}},						
	{0xBC,1,{0x76}},						
	{0xBD,1,{0x00}},						
	{0xBE,1,{0x8D}},						
	{0xBF,1,{0x00}},						
	{0xC0,1,{0xA6}},						
	{0xC1,1,{0x00}},						
	{0xC2,1,{0xB8}},						
	{0xC3,1,{0x00}},						
	{0xC4,1,{0xC7}},						
	{0xC5,1,{0x00}},						
	{0xC6,1,{0xF6}},						
	{0xC7,1,{0x01}},						
	{0xC8,1,{0x1D}},						
	{0xC9,1,{0x01}},						
	{0xCA,1,{0x54}},						
	{0xCB,1,{0x01}},						
	{0xCC,1,{0x81}},						
	{0xCD,1,{0x01}},						
	{0xCE,1,{0xCB}},						
	{0xCF,1,{0x02}},						
	{0xD0,1,{0x05}},						
	{0xD1,1,{0x02}},						
	{0xD2,1,{0x07}},						
	{0xD3,1,{0x02}},						
	{0xD4,1,{0x47}},						
	{0xD5,1,{0x02}},						
	{0xD6,1,{0x82}},						
	{0xD7,1,{0x02}},						
	{0xD8,1,{0xAB}},						
	{0xD9,1,{0x02}},						
	{0xDA,1,{0xDC}},						
	{0xDB,1,{0x03}},						
	{0xDC,1,{0x01}},						
	{0xDD,1,{0x03}},						
	{0xDE,1,{0x3A}},						
	{0xDF,1,{0x03}},						
	{0xE0,1,{0x56}},						
	{0xE1,1,{0x03}},						
	{0xE2,1,{0x6D}},						
	{0xE3,1,{0x03}},						
	{0xE4,1,{0x89}},						
	{0xE5,1,{0x03}},						
	{0xE6,1,{0xA3}},						
	{0xE7,1,{0x03}},						
	{0xE8,1,{0xC9}},						
	{0xE9,1,{0x03}},						
	{0xEA,1,{0xDD}},						
	{0xEB,1,{0x03}},						
	{0xEC,1,{0xF5}},						
	{0xED,1,{0x03}},						
	{0xEE,1,{0xFF}},						
	//	G+	,1,{}},						
	{0xEF,1,{0x00}},						
	{0xF0,1,{0x00}},						
	{0xF1,1,{0x00}},						
	{0xF2,1,{0x22}},						
	{0xF3,1,{0x00}},						
	{0xF4,1,{0x46}},						
	{0xF5,1,{0x00}},						
	{0xF6,1,{0x5C}},						
	{0xF7,1,{0x00}},						
	{0xF8,1,{0x76}},						
	{0xF9,1,{0x00}},						
	{0xFA,1,{0x8D}},						

	{0xFF,1,{0x21}},	//	Page	0,1,{	power-related	setting	
	{REGFLAG_DELAY, 2, {}},						
	{0x00,1,{0x00}},						
	{0x01,1,{0xA6}},						
	{0x02,1,{0x00}},						
	{0x03,1,{0xB8}},						
	{0x04,1,{0x00}},						
	{0x05,1,{0xC7}},						
	{0x06,1,{0x00}},						
	{0x07,1,{0xF6}},						
	{0x08,1,{0x01}},						
	{0x09,1,{0x1D}},						
	{0x0A,1,{0x01}},						
	{0x0B,1,{0x54}},						
	{0x0C,1,{0x01}},						
	{0x0D,1,{0x81}},						
	{0x0E,1,{0x01}},						
	{0x0F,1,{0xCB}},						
	{0x10,1,{0x02}},						
	{0x11,1,{0x05}},						
	{0x12,1,{0x02}},						
	{0x13,1,{0x07}},						
	{0x14,1,{0x02}},						
	{0x15,1,{0x47}},						
	{0x16,1,{0x02}},						
	{0x17,1,{0x82}},						
	{0x18,1,{0x02}},						
	{0x19,1,{0xAB}},						
	{0x1A,1,{0x02}},						
	{0x1B,1,{0xDC}},						
	{0x1C,1,{0x03}},						
	{0x1D,1,{0x01}},						
	{0x1E,1,{0x03}},						
	{0x1F,1,{0x3A}},						
	{0x20,1,{0x03}},						
	{0x21,1,{0x56}},						
	{0x22,1,{0x03}},						
	{0x23,1,{0x6D}},						
	{0x24,1,{0x03}},						
	{0x25,1,{0x89}},						
	{0x26,1,{0x03}},						
	{0x27,1,{0xA3}},						
	{0x28,1,{0x03}},						
	{0x29,1,{0xC9}},						
	{0x2A,1,{0x03}},						
	{0x2B,1,{0xDD}},						
	{0x2D,1,{0x03}},						
	{0x2F,1,{0xF5}},						
	{0x30,1,{0x03}},						
	{0x31,1,{0xFF}},						
	//	G-	,1,{}},						
	{0x32,1,{0x00}},						
	{0x33,1,{0x00}},						
	{0x34,1,{0x00}},						
	{0x35,1,{0x22}},						
	{0x36,1,{0x00}},						
	{0x37,1,{0x46}},						
	{0x38,1,{0x00}},						
	{0x39,1,{0x5C}},						
	{0x3A,1,{0x00}},						
	{0x3B,1,{0x76}},						
	{0x3D,1,{0x00}},						
	{0x3F,1,{0x8D}},						
	{0x40,1,{0x00}},						
	{0x41,1,{0xA6}},						
	{0x42,1,{0x00}},						
	{0x43,1,{0xB8}},						
	{0x44,1,{0x00}},						
	{0x45,1,{0xC7}},						
	{0x46,1,{0x00}},						
	{0x47,1,{0xF6}},						
	{0x48,1,{0x01}},						
	{0x49,1,{0x1D}},						
	{0x4A,1,{0x01}},						
	{0x4B,1,{0x54}},						
	{0x4C,1,{0x01}},						
	{0x4D,1,{0x81}},						
	{0x4E,1,{0x01}},						
	{0x4F,1,{0xCB}},						
	{0x50,1,{0x02}},						
	{0x51,1,{0x05}},						
	{0x52,1,{0x02}},						
	{0x53,1,{0x07}},						
	{0x54,1,{0x02}},						
	{0x55,1,{0x47}},						
	{0x56,1,{0x02}},						
	{0x58,1,{0x82}},						
	{0x59,1,{0x02}},						
	{0x5A,1,{0xAB}},						
	{0x5B,1,{0x02}},						
	{0x5C,1,{0xDC}},						
	{0x5D,1,{0x03}},						
	{0x5E,1,{0x01}},						
	{0x5F,1,{0x03}},						
	{0x60,1,{0x3A}},						
	{0x61,1,{0x03}},						
	{0x62,1,{0x56}},						
	{0x63,1,{0x03}},						
	{0x64,1,{0x6D}},						
	{0x65,1,{0x03}},						
	{0x66,1,{0x89}},						
	{0x67,1,{0x03}},						
	{0x68,1,{0xA3}},						
	{0x69,1,{0x03}},						
	{0x6A,1,{0xC9}},						
	{0x6B,1,{0x03}},						
	{0x6C,1,{0xDD}},						
	{0x6D,1,{0x03}},						
	{0x6E,1,{0xF5}},						
	{0x6F,1,{0x03}},						
	{0x70,1,{0xFF}},						
	//	B+	,1,{}},						
	{0x71,1,{0x00}},						
	{0x72,1,{0x00}},						
	{0x73,1,{0x00}},						
	{0x74,1,{0x22}},						
	{0x75,1,{0x00}},						
	{0x76,1,{0x46}},						
	{0x77,1,{0x00}},						
	{0x78,1,{0x5C}},						
	{0x79,1,{0x00}},						
	{0x7A,1,{0x76}},						
	{0x7B,1,{0x00}},						
	{0x7C,1,{0x8D}},						
	{0x7D,1,{0x00}},						
	{0x7E,1,{0xA6}},						
	{0x7F,1,{0x00}},						
	{0x80,1,{0xB8}},						
	{0x81,1,{0x00}},						
	{0x82,1,{0xC7}},						
	{0x83,1,{0x00}},						
	{0x84,1,{0xF6}},						
	{0x85,1,{0x01}},						
	{0x86,1,{0x1D}},						
	{0x87,1,{0x01}},						
	{0x88,1,{0x54}},						
	{0x89,1,{0x01}},						
	{0x8A,1,{0x81}},						
	{0x8B,1,{0x01}},						
	{0x8C,1,{0xCB}},						
	{0x8D,1,{0x02}},						
	{0x8E,1,{0x05}},						
	{0x8F,1,{0x02}},						
	{0x90,1,{0x07}},						
	{0x91,1,{0x02}},						
	{0x92,1,{0x47}},						
	{0x93,1,{0x02}},						
	{0x94,1,{0x82}},						
	{0x95,1,{0x02}},						
	{0x96,1,{0xAB}},						
	{0x97,1,{0x02}},						
	{0x98,1,{0xDC}},						
	{0x99,1,{0x03}},						
	{0x9A,1,{0x01}},						
	{0x9B,1,{0x03}},						
	{0x9C,1,{0x3A}},						
	{0x9D,1,{0x03}},						
	{0x9E,1,{0x56}},						
	{0x9F,1,{0x03}},						
	{0xA0,1,{0x6D}},						
	{0xA2,1,{0x03}},						
	{0xA3,1,{0x89}},						
	{0xA4,1,{0x03}},						
	{0xA5,1,{0xA3}},						
	{0xA6,1,{0x03}},						
	{0xA7,1,{0xC9}},						
	{0xA9,1,{0x03}},						
	{0xAA,1,{0xDD}},						
	{0xAB,1,{0x03}},						
	{0xAC,1,{0xF5}},						
	{0xAD,1,{0x03}},						
	{0xAE,1,{0xFF}},						
	//	B-	,1,{}},						
	{0xAF,1,{0x00}},						
	{0xB0,1,{0x00}},						
	{0xB1,1,{0x00}},						
	{0xB2,1,{0x22}},						
	{0xB3,1,{0x00}},						
	{0xB4,1,{0x46}},						
	{0xB5,1,{0x00}},						
	{0xB6,1,{0x5C}},						
	{0xB7,1,{0x00}},						
	{0xB8,1,{0x76}},						
	{0xB9,1,{0x00}},						
	{0xBA,1,{0x8D}},						
	{0xBB,1,{0x00}},						
	{0xBC,1,{0xA6}},						
	{0xBD,1,{0x00}},						
	{0xBE,1,{0xB8}},						
	{0xBF,1,{0x00}},						
	{0xC0,1,{0xC7}},						
	{0xC1,1,{0x00}},						
	{0xC2,1,{0xF6}},						
	{0xC3,1,{0x01}},						
	{0xC4,1,{0x1D}},						
	{0xC5,1,{0x01}},						
	{0xC6,1,{0x54}},						
	{0xC7,1,{0x01}},						
	{0xC8,1,{0x81}},						
	{0xC9,1,{0x01}},						
	{0xCA,1,{0xCB}},						
	{0xCB,1,{0x02}},						
	{0xCC,1,{0x05}},						
	{0xCD,1,{0x02}},						
	{0xCE,1,{0x07}},						
	{0xCF,1,{0x02}},						
	{0xD0,1,{0x47}},						
	{0xD1,1,{0x02}},						
	{0xD2,1,{0x82}},						
	{0xD3,1,{0x02}},						
	{0xD4,1,{0xAB}},						
	{0xD5,1,{0x02}},						
	{0xD6,1,{0xDC}},						
	{0xD7,1,{0x03}},						
	{0xD8,1,{0x01}},						
	{0xD9,1,{0x03}},						
	{0xDA,1,{0x3A}},						
	{0xDB,1,{0x03}},						
	{0xDC,1,{0x56}},						
	{0xDD,1,{0x03}},						
	{0xDE,1,{0x6D}},						
	{0xDF,1,{0x03}},						
	{0xE0,1,{0x89}},						
	{0xE1,1,{0x03}},						
	{0xE2,1,{0xA3}},						
	{0xE3,1,{0x03}},						
	{0xE4,1,{0xC9}},						
	{0xE5,1,{0x03}},						
	{0xE6,1,{0xDD}},						
	{0xE7,1,{0x03}},						
	{0xE8,1,{0xF5}},						
	{0xE9,1,{0x03}},						
	{0xEA,1,{0xFF}},						

	{0xFF,1,{0x21}},	//	Page	,1,{	Gamma	Default	Update
	{REGFLAG_DELAY, 2, {}},						
	{0xEB,1,{0x30}},						
	{0xEC,1,{0x17}},						
	{0xED,1,{0x20}},						
	{0xEE,1,{0x0F}},						
	{0xEF,1,{0x1F}},						
	{0xF0,1,{0x0F}},						
	{0xF1,1,{0x0F}},						
	{0xF2,1,{0x07}},						

	{0xFF,1,{0x23}},	//	CMD2	Page	3	Entrance	
	{REGFLAG_DELAY, 2, {}},						
	{0x08,1,{0x04}},						
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//image.first
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	{0xFF,1,{0x10}},	//	Return	To	CMD1		
	{REGFLAG_DELAY, 2, {}},							
	{0x35,1,{0x00}},						
	{0x29,0,{}},
	//{0x51,1,{0xFF}},	//	write	display	brightness		
};

#else
{
//NT35595 Cut2 + LGD6" Panel Initial Code

//CMD3 AE
//Source OP bias
{0xFF, 1, { 0xE0}},
{REGFLAG_DELAY, 1, {}},
{0x88, 1, { 0xF0}},
{0xFB, 1, { 0x01}},


//CMD2 Page 0
{0xFF, 1, { 0x20}},
{REGFLAG_DELAY, 1, {}},

{0xFB, 1, { 0x01}},

//Angus Add--> Abnormal power det
{0x30, 1, { 0x6F}},

//ccmon

//Power-Related

{0x00, 1, {	0x01}},
{0x01, 1, {	0x55}},
{0x02, 1, {	0x45}},
{0x03, 1, {	0x55}},
{0x05, 1, {	0x50}},

//VGH/VGL w/Clamp +/- 9V
{0x06, 1, {	0x9E}},
{0x07, 1, {	0xA8}},
{0x08, 1, {	0x0C}},

//Gamma Voltage +/-4.35V
{0x0B, 1, {	0x96}},
{0x0C, 1, {	0x96}},

//VGHO/VGLO Disable
{0x0E, 1, {	0x00}},
{0x0F, 1, {	0x00}},

{0x11, 1, {	0x27}},
{0x12, 1, {	0x27}},
{0x13, 1, {	0x03}},
{0x14, 1, {	0x0A}},
{0x15, 1, {	0x99}},
{0x16, 1, {	0x99}},
{0x1B, 1, {	0x39}},
{0x1C, 1, {	0x39}},
{0x1D, 1, {	0x47}},

//ID code
{0x44, 1, {	0xC1}},
{0x45, 1, {	0x86}},
{0x46, 1, {	0xC4}},  

//Gate EQ
{0x58, 1, {	0x05}},
{0x59, 1, {	0x05}},
{0x5A, 1, {	0x05}},
{0x5B, 1, {	0x05}},
{0x5C, 1, {	0x00}},
{0x5D, 1, {	0x00}},
{0x5E, 1, {	0x00}},
{0x5F, 1, {	0x00}},


//ISOP P/N (Normal Mode)
{0x6D, 1, {	0x44}}, 

//Angus Add --> ISOP P/N (Idle Mode}},
{0x6A, 1, { 0x33}},
{0x6C, 1, { 0x33}},


//Gamma R +/-

{0x75, 1, {	0x00}},
{0x76, 1, {	0x00}},
{0x77, 1, {	0x00}},
{0x78, 1, {	0x22}},
{0x79, 1, {	0x00}},
{0x7A, 1, {	0x46}},
{0x7B, 1, {	0x00}},
{0x7C, 1, {	0x5C}},
{0x7D, 1, {	0x00}},
{0x7E, 1, {	0x76}},
{0x7F, 1, {	0x00}},
{0x80, 1, {	0x8D}},
{0x81, 1, {	0x00}},
{0x82, 1, {	0xA6}},
{0x83, 1, {	0x00}},
{0x84, 1, {	0xB8}},
{0x85, 1, {	0x00}},
{0x86, 1, {	0xC7}},
{0x87, 1, {	0x00}},
{0x88, 1, {	0xF6}},
{0x89, 1, {	0x01}},
{0x8A, 1, {	0x1D}},
{0x8B, 1, {	0x01}},
{0x8C, 1, {	0x54}},
{0x8D, 1, {	0x01}},
{0x8E, 1, {	0x81}},
{0x8F, 1, {	0x01}},
{0x90, 1, {	0xCB}},
{0x91, 1, {	0x02}},
{0x92, 1, {	0x05}},
{0x93, 1, {	0x02}},
{0x94, 1, {	0x07}},
{0x95, 1, {	0x02}},
{0x96, 1, {	0x47}},
{0x97, 1, {	0x02}},
{0x98, 1, {	0x82}},
{0x99, 1, {	0x02}},
{0x9A, 1, {	0xAB}},
{0x9B, 1, {	0x02}},
{0x9C, 1, {	0xDC}},
{0x9D, 1, {	0x03}},
{0x9E, 1, {	0x01}},
{0x9F, 1, {	0x03}},
{0xA0, 1, {	0x3A}},
{0xA2, 1, {	0x03}},
{0xA3, 1, {	0x56}},
{0xA4, 1, {	0x03}},
{0xA5, 1, {	0x6D}},
{0xA6, 1, {	0x03}},
{0xA7, 1, {	0x89}},
{0xA9, 1, {	0x03}},
{0xAA, 1, {	0xA3}},
{0xAB, 1, {	0x03}},
{0xAC, 1, {	0xC9}},
{0xAD, 1, {	0x03}},
{0xAE, 1, {	0xDD}},
{0xAF, 1, {	0x03}},
{0xB0, 1, {	0xF5}},
{0xB1, 1, {	0x03}},
{0xB2, 1, {	0xFF}},
{0xB3, 1, {	0x00}},
{0xB4, 1, {	0x00}},
{0xB5, 1, {	0x00}},
{0xB6, 1, {	0x22}},
{0xB7, 1, {	0x00}},
{0xB8, 1, {	0x46}},
{0xB9, 1, {	0x00}},
{0xBA, 1, {	0x5C}},
{0xBB, 1, {	0x00}},
{0xBC, 1, {	0x76}},
{0xBD, 1, {	0x00}},
{0xBE, 1, {	0x8D}},
{0xBF, 1, {	0x00}},
{0xC0, 1, {	0xA6}},
{0xC1, 1, {	0x00}},
{0xC2, 1, {	0xB8}},
{0xC3, 1, {	0x00}},
{0xC4, 1, {	0xC7}},
{0xC5, 1, {	0x00}},
{0xC6, 1, {	0xF6}},
{0xC7, 1, {	0x01}},
{0xC8, 1, {	0x1D}},
{0xC9, 1, {	0x01}},
{0xCA, 1, {	0x54}},
{0xCB, 1, {	0x01}},
{0xCC, 1, {	0x81}},
{0xCD, 1, {	0x01}},
{0xCE, 1, {	0xCB}},
{0xCF, 1, {	0x02}},
{0xD0, 1, {	0x05}},
{0xD1, 1, {	0x02}},
{0xD2, 1, {	0x07}},
{0xD3, 1, {	0x02}},
{0xD4, 1, {	0x47}},
{0xD5, 1, {	0x02}},
{0xD6, 1, {	0x82}},
{0xD7, 1, {	0x02}},
{0xD8, 1, {	0xAB}},
{0xD9, 1, {	0x02}},
{0xDA, 1, {	0xDC}},
{0xDB, 1, {	0x03}},
{0xDC, 1, {	0x01}},
{0xDD, 1, {	0x03}},
{0xDE, 1, {	0x3A}},
{0xDF, 1, {	0x03}},
{0xE0, 1, {	0x56}},
{0xE1, 1, {	0x03}},
{0xE2, 1, {	0x6D}},
{0xE3, 1, {	0x03}},
{0xE4, 1, {	0x89}},
{0xE5, 1, {	0x03}},
{0xE6, 1, {	0xA3}},
{0xE7, 1, {	0x03}},
{0xE8, 1, {	0xC9}},
{0xE9, 1, {	0x03}},
{0xEA, 1, {	0xDD}},
{0xEB, 1, {	0x03}},
{0xEC, 1, {	0xF5}},
{0xED, 1, {	0x03}},
{0xEE, 1, {	0xFF}}, 


//Gamma G+

{0xEF, 1, {	0x00}},
{0xF0, 1, {	0x00}},
{0xF1, 1, {	0x00}},
{0xF2, 1, {	0x22}},
{0xF3, 1, {	0x00}},
{0xF4, 1, {	0x46}},
{0xF5, 1, {	0x00}},
{0xF6, 1, {	0x5C}},
{0xF7, 1, {	0x00}},
{0xF8, 1, {	0x76}},
{0xF9, 1, {	0x00}},
{0xFA, 1, {	0x8D}},

//ccmoff
//ccmrun

//CMD2 Page 1
{0xFF, 1, { 0x21}},
	{REGFLAG_DELAY, 1, {}},

{0xFB, 1, { 0x01}},

//ccmon
//Gamma G+/-

{0x00, 1, {	0x00}},
{0x01, 1, {	0xA6}},
{0x02, 1, {	0x00}},
{0x03, 1, {	0xB8}},
{0x04, 1, {	0x00}},
{0x05, 1, {	0xC7}},
{0x06, 1, {	0x00}},
{0x07, 1, {	0xF6}},
{0x08, 1, {	0x01}},
{0x09, 1, {	0x1D}},
{0x0A, 1, {	0x01}},
{0x0B, 1, {	0x54}},
{0x0C, 1, {	0x01}},
{0x0D, 1, {	0x81}},
{0x0E, 1, {	0x01}},
{0x0F, 1, {	0xCB}},
{0x10, 1, {	0x02}},
{0x11, 1, {	0x05}},
{0x12, 1, {	0x02}},
{0x13, 1, {	0x07}},
{0x14, 1, {	0x02}},
{0x15, 1, {	0x47}},
{0x16, 1, {	0x02}},
{0x17, 1, {	0x82}},
{0x18, 1, {	0x02}},
{0x19, 1, {	0xAB}},
{0x1A, 1, {	0x02}},
{0x1B, 1, {	0xDC}},
{0x1C, 1, {	0x03}},
{0x1D, 1, {	0x01}},
{0x1E, 1, {	0x03}},
{0x1F, 1, {	0x3A}},
{0x20, 1, {	0x03}},
{0x21, 1, {	0x56}},
{0x22, 1, {	0x03}},
{0x23, 1, {	0x6D}},
{0x24, 1, {	0x03}},
{0x25, 1, {	0x89}},
{0x26, 1, {	0x03}},
{0x27, 1, {	0xA3}},
{0x28, 1, {	0x03}},
{0x29, 1, {	0xC9}},
{0x2A, 1, { 0x03}},
{0x2B, 1, { 0xDD}},
{0x2D, 1, { 0x03}},
{0x2F, 1, { 0xF5}},
{0x30, 1, { 0x03}},
{0x31, 1, { 0xFF}},
{0x32, 1, { 0x00}},
{0x33, 1, { 0x00}},
{0x34, 1, {	0x00}},
{0x35, 1, {	0x22}},
{0x36, 1, {	0x00}},
{0x37, 1, {	0x46}},
{0x38, 1, {	0x00}},
{0x39, 1, {	0x5C}},
{0x3A, 1, {	0x00}},
{0x3B, 1, {	0x76}},
{0x3D, 1, {	0x00}},
{0x3F, 1, {	0x8D}},
{0x40, 1, {	0x00}},
{0x41, 1, {	0xA6}},
{0x42, 1, {	0x00}},
{0x43, 1, {	0xB8}},
{0x44, 1, {	0x00}},
{0x45, 1, {	0xC7}},
{0x46, 1, {	0x00}},
{0x47, 1, {	0xF6}},
{0x48, 1, {	0x01}},
{0x49, 1, {	0x1D}},
{0x4A, 1, {	0x01}},
{0x4B, 1, {	0x54}},
{0x4C, 1, {	0x01}},
{0x4D, 1, {	0x81}},
{0x4E, 1, {	0x01}},
{0x4F, 1, {	0xCB}},
{0x50, 1, {	0x02}},
{0x51, 1, {	0x05}},
{0x52, 1, {	0x02}},
{0x53, 1, {	0x07}},
{0x54, 1, {	0x02}},
{0x55, 1, {	0x47}},
{0x56, 1, {	0x02}},
{0x58, 1, {	0x82}},
{0x59, 1, {	0x02}},
{0x5A, 1, {	0xAB}},
{0x5B, 1, {	0x02}},
{0x5C, 1, {	0xDC}},
{0x5D, 1, {	0x03}},
{0x5E, 1, {	0x01}},
{0x5F, 1, {	0x03}},
{0x60, 1, {	0x3A}},
{0x61, 1, {	0x03}},
{0x62, 1, {	0x56}},
{0x63, 1, {	0x03}},
{0x64, 1, {	0x6D}},
{0x65, 1, {	0x03}},
{0x66, 1, {	0x89}},
{0x67, 1, {	0x03}},
{0x68, 1, {	0xA3}},
{0x69, 1, {	0x03}},
{0x6A, 1, {	0xC9}},
{0x6B, 1, {	0x03}},
{0x6C, 1, {	0xDD}},
{0x6D, 1, {	0x03}},
{0x6E, 1, {	0xF5}},
{0x6F, 1, {	0x03}},
{0x70, 1, {	0xFF}},

//Gamma B+/-

{0x71, 1, {	0x00}},
{0x72, 1, {	0x00}},
{0x73, 1, {	0x00}},
{0x74, 1, {	0x22}},
{0x75, 1, {	0x00}},
{0x76, 1, {	0x46}},
{0x77, 1, {	0x00}},
{0x78, 1, {	0x5C}},
{0x79, 1, {	0x00}},
{0x7A, 1, {	0x76}},
{0x7B, 1, {	0x00}},
{0x7C, 1, {	0x8D}},
{0x7D, 1, {	0x00}},
{0x7E, 1, {	0xA6}},
{0x7F, 1, {	0x00}},
{0x80, 1, {	0xB8}},
{0x81, 1, {	0x00}},
{0x82, 1, {	0xC7}},
{0x83, 1, {	0x00}},
{0x84, 1, {	0xF6}},
{0x85, 1, {	0x01}},
{0x86, 1, {	0x1D}},
{0x87, 1, {	0x01}},
{0x88, 1, {	0x54}},
{0x89, 1, {	0x01}},
{0x8A, 1, {	0x81}},
{0x8B, 1, {	0x01}},
{0x8C, 1, {	0xCB}},
{0x8D, 1, {	0x02}},
{0x8E, 1, {	0x05}},
{0x8F, 1, {	0x02}},
{0x90, 1, {	0x07}},
{0x91, 1, {	0x02}},
{0x92, 1, {	0x47}},
{0x93, 1, {	0x02}},
{0x94, 1, {	0x82}},
{0x95, 1, {	0x02}},
{0x96, 1, {	0xAB}},
{0x97, 1, {	0x02}},
{0x98, 1, {	0xDC}},
{0x99, 1, {	0x03}},
{0x9A, 1, {	0x01}},
{0x9B, 1, {	0x03}},
{0x9C, 1, {	0x3A}},
{0x9D, 1, {	0x03}},
{0x9E, 1, {	0x56}},
{0x9F, 1, {	0x03}},
{0xA0, 1, {	0x6D}},
{0xA2, 1, {	0x03}},
{0xA3, 1, {	0x89}},
{0xA4, 1, {	0x03}},
{0xA5, 1, {	0xA3}},
{0xA6, 1, {	0x03}},
{0xA7, 1, {	0xC9}},
{0xA9, 1, {	0x03}},
{0xAA, 1, {	0xDD}},
{0xAB, 1, {	0x03}},
{0xAC, 1, {	0xF5}},
{0xAD, 1, {	0x03}},
{0xAE, 1, {	0xFF}},
{0xAF, 1, {	0x00}},
{0xB0, 1, {	0x00}},
{0xB1, 1, {	0x00}},
{0xB2, 1, {	0x22}},
{0xB3, 1, {	0x00}},
{0xB4, 1, {	0x46}},
{0xB5, 1, {	0x00}},
{0xB6, 1, {	0x5C}},
{0xB7, 1, {	0x00}},
{0xB8, 1, {	0x76}},
{0xB9, 1, {	0x00}},
{0xBA, 1, {	0x8D}},
{0xBB, 1, {	0x00}},
{0xBC, 1, {	0xA6}},
{0xBD, 1, {	0x00}},
{0xBE, 1, {	0xB8}},
{0xBF, 1, {	0x00}},
{0xC0, 1, {	0xC7}},
{0xC1, 1, {	0x00}},
{0xC2, 1, {	0xF6}},
{0xC3, 1, {	0x01}},
{0xC4, 1, {	0x1D}},
{0xC5, 1, {	0x01}},
{0xC6, 1, {	0x54}},
{0xC7, 1, {	0x01}},
{0xC8, 1, {	0x81}},
{0xC9, 1, {	0x01}},
{0xCA, 1, {	0xCB}},
{0xCB, 1, {	0x02}},
{0xCC, 1, {	0x05}},
{0xCD, 1, {	0x02}},
{0xCE, 1, {	0x07}},
{0xCF, 1, {	0x02}},
{0xD0, 1, {	0x47}},
{0xD1, 1, {	0x02}},
{0xD2, 1, {	0x82}},
{0xD3, 1, {	0x02}},
{0xD4, 1, {	0xAB}},
{0xD5, 1, {	0x02}},
{0xD6, 1, {	0xDC}},
{0xD7, 1, {	0x03}},
{0xD8, 1, {	0x01}},
{0xD9, 1, {	0x03}},
{0xDA, 1, {	0x3A}},
{0xDB, 1, {	0x03}},
{0xDC, 1, {	0x56}},
{0xDD, 1, {	0x03}},
{0xDE, 1, {	0x6D}},
{0xDF, 1, {	0x03}},
{0xE0, 1, {	0x89}},
{0xE1, 1, {	0x03}},
{0xE2, 1, {	0xA3}},
{0xE3, 1, {	0x03}},
{0xE4, 1, {	0xC9}},
{0xE5, 1, {	0x03}},
{0xE6, 1, {	0xDD}},
{0xE7, 1, {	0x03}},
{0xE8, 1, {	0xF5}},
{0xE9, 1, {	0x03}},
{0xEA, 1, {	0xFF}},

{0xEB, 1, {	0x30}},
{0xEC, 1, {	0x17}},
{0xED, 1, {	0x20}},
{0xEE, 1, {	0x0F}},
{0xEF, 1, {	0x1F}},
{0xF0, 1, {	0x0F}},
{0xF1, 1, {	0x0F}},
{0xF2, 1, {	0x07}},

//ccmoff
//ccmrun


//CMD2 Page 4
{0xFF, 1, { 0x24}},
	{REGFLAG_DELAY, 1, {}},
{0xFB, 1, { 0x01}},

//ccmon
//LTPS related

//CGOUT Mapping
{0x00, 1, {	0x0F}},                              
{0x01, 1, {	0x00}},                              
{0x02, 1, {	0x00}},                              
{0x03, 1, {	0x00}},                              
{0x04, 1, {	0x0B}},                              
{0x05, 1, {	0x0C}},                              
{0x06, 1, {	0x00}},                              
{0x07, 1, {	0x00}},                              
{0x08, 1, {	0x00}},                              
{0x09, 1, {	0x00}},                              
{0x0A, 1, {	0x03}},                              
{0x0B, 1, {	0x04}},                              
{0x0C, 1, {	0x01}},                              
{0x0D, 1, {	0x13}},                              
{0x0E, 1, {	0x15}},                              
{0x0F, 1, {	0x17}},                              
{0x10, 1, {	0x0F}},                              
{0x11, 1, {	0x00}},                              
{0x12, 1, {	0x00}},                              
{0x13, 1, {	0x00}},                              
{0x14, 1, {	0x0B}},                              
{0x15, 1, {	0x0C}},                              
{0x16, 1, {	0x00}},                              
{0x17, 1, {	0x00}},                              
{0x18, 1, {	0x00}},                              
{0x19, 1, {	0x00}},                              
{0x1A, 1, {	0x03}},                              
{0x1B, 1, {	0x04}},                              
{0x1C, 1, {	0x01}},                              
{0x1D, 1, {	0x13}},                              
{0x1E, 1, {	0x15}},                              
{0x1F, 1, {	0x17}}, 

//STV                            
{0x20, 1, {	0x09}},                              
{0x21, 1, {	0x01}},                              
{0x22, 1, {	0x00}},                              
{0x23, 1, {	0x00}},                              
{0x24, 1, {	0x00}},                              
{0x25, 1, {	0x6D}},                              
{0x26, 1, {	0x00}},                              
{0x27, 1, {	0x00}},

//U2D/D2U                              
{0x29, 1, {	0x58}},                              
{0x2A, 1, {	0x16}},  

//GCK1/2                            
{0x2F, 1, {	0x02}},                              
{0x30, 1, {	0x04}},                              
{0x31, 1, {	0x49}},                              
{0x32, 1, {	0x23}},                              
{0x33, 1, {	0x01}},                              
{0x34, 1, {	0x00}},                              
{0x35, 1, {	0x69}},                              
{0x36, 1, {	0x00}},                              
{0x37, 1, {	0x2D}},                              
{0x38, 1, {	0x08}},                              
{0x39, 1, {	0x00}},                              
{0x3A, 1, {	0x69}}, 

//APO                           
{0x5B, 1, {	0x00}},                                                                                                                             
{0x5F, 1, {	0x75}},                                                               
{0x63, 1, {	0x00}},                                                                
{0x67, 1, {	0x04}}, 

//Resolution                                                              
{0x72, 1, {	0x00}},   

//MUX                                                          
{0x74, 1, {	0x10}},                              
{0x75, 1, {	0x19}},                              
{0x76, 1, {	0x06}},
{0x77, 1, {	0x03}},
{0x78, 1, {	0x00}},
{0x79, 1, {	0x00}},  
{0x7B, 1, {	0x80}},
{0x7C, 1, {	0xD8}},
{0x7D, 1, {	0x60}},
{0x7E, 1, {	0x10}},
{0x7F, 1, {	0x19}},
{0x80, 1, {	0x00}},
{0x81, 1, {	0x06}},
{0x82, 1, {	0x03}},
{0x83, 1, {	0x00}},                              
{0x84, 1, {	0x03}},                              
{0x85, 1, {	0x07}},

//MUX and LTF setting                              
{0x86, 1, {	0x1B}},                              
{0x87, 1, {	0x39}},                              
{0x88, 1, {	0x1B}},                              
{0x89, 1, {	0x39}},                              
{0x8A, 1, {	0x33}},                              
{0x8B, 1, {	0xF4}},                              
{0x8C, 1, {	0x01}}, 

//RTN, 1, { BP, 1, { PF  (Normal/Idle Mode)                           
{0x91, 1, {	0x4C}},                              
{0x92, 1, {	0x79}},                              
{0x93, 1, {	0x04}},                              
{0x94, 1, {	0x04}},                              
{0x95, 1, {	0xE4}},  

                                                             
{0x98, 1, {	0x00}},                             
{0x99, 1, {	0x33}},                                                               
{0x9B, 1, {	0x0F}},                                                               
{0x9D, 1, {	0xB0}}, 
//Angus Add --> Inversion for Idle Mode
{0xDE, 1, { 0xFF}},

//Abnormal Setting for LTPS                                                            
{0xB3, 1, {	0x28}},                              
{0xB4, 1, {	0x05}},                              
{0xB5, 1, {	0x10}}, 

//GPIO output                            
{0xC4, 1, {	0x24}},                              
{0xC5, 1, {	0x30}},                              
{0xC6, 1, {	0x00}}, 

//ccmoff
//ccmrun

//##############################
//Qualcomm FBC related
{0xFF, 1, { 0x24}},
	{REGFLAG_DELAY, 1, {}},
//FBC RTN
{0xDF, 1, { 0x82}},
{0x91, 1, { 0x4C}},
{0xFB, 1, { 0x01}},

{0xFF, 1, { 0xE0}},
	{REGFLAG_DELAY, 1, {}},
//FBC oscillator
{0xB4, 1, { 0x10}},
{0xFB, 1, { 0x01}},


{0xFF, 1, { 0x20}},
	{REGFLAG_DELAY, 1, {}},
//low v det
//{0x30, 1, { 0x6F}},
{0xFB, 1, { 0x01}},



//##############################

//PWM Frequency
{0xFF, 1, { 0x23}},
	{REGFLAG_DELAY, 1, {}},
{0x08, 1, { 0x04}},
{0xFB, 1, { 0x01}},

//EN_Manual CKBT
{0xFF, 1, { 0x20}},
	{REGFLAG_DELAY, 1, {}},

{0x13, 1, { 0x67}},
{0x18, 1, { 0x08}},
{0xFB, 1, { 0x01}},


//CMD1
{0xFF, 1, { 0x10}},
	{REGFLAG_DELAY, 1, {}},


{0x3B, 5, {0x03,0x04,0x04,0x04,0x04}},

//Via/Bypass RAM setting
{0xBB, 1, { 0x30}},

//FBC on/off
//{0xC6, 1, { 0x45}},
//{0xC0, 1, { 0x01}},
{0xFB, 1, { 0x01}},
//{0xBA, 1, { 0x01}},
{0x11, 0, { }},

	{REGFLAG_DELAY, 120, {}},
{0x29, 0, { }},
};
#endif

#if 0
static struct LCM_setting_table lcm_set_window[] = {
	{0x2A,	4,	{0x00, 0x00, (FRAME_WIDTH>>8), (FRAME_WIDTH&0xFF)}},
	{0x2B,	4,	{0x00, 0x00, (FRAME_HEIGHT>>8), (FRAME_HEIGHT&0xFF)}},
	{REGFLAG_END_OF_TABLE, 0x00, {}}
};
#endif
#if 0
static struct LCM_setting_table lcm_sleep_out_setting[] = {
    //Sleep Out
    {0x11, 1, {0x00}},
    {REGFLAG_DELAY, 120, {}},

    // Display ON
    {0x29, 1, {0x00}},
    {REGFLAG_DELAY, 20, {}},
    {REGFLAG_END_OF_TABLE, 0x00, {}}
};
#endif

static struct LCM_setting_table lcm_deep_sleep_mode_in_setting[] = {
    // Display off sequence
    {0x28, 1, {0x00}},
    {REGFLAG_DELAY, 20, {}},

    // Sleep Mode On
    {0x10, 1, {0x00}},
    {REGFLAG_DELAY, 120, {}},
    {REGFLAG_END_OF_TABLE, 0x00, {}}
};

static void push_table(struct LCM_setting_table *table, unsigned int count, unsigned char force_update)
{
    unsigned int i;

    for(i = 0; i < count; i++)
    {
        unsigned cmd;
        cmd = table[i].cmd;

        switch (cmd) {

            case REGFLAG_DELAY :
                if(table[i].count <= 10)
                    MDELAY(table[i].count);
                else
                    MDELAY(table[i].count);
                break;

            case REGFLAG_END_OF_TABLE :
                break;

            default:
                dsi_set_cmdq_V2(cmd, table[i].count, table[i].para_list, force_update);
        }
    }
}

// ---------------------------------------------------------------------------
//  LCM Driver Implementations
// ---------------------------------------------------------------------------

static void lcm_set_util_funcs(const LCM_UTIL_FUNCS *util)
{
    memcpy(&lcm_util, util, sizeof(LCM_UTIL_FUNCS));
}


static void lcm_get_params(LCM_PARAMS *params)
{
	memset(params, 0, sizeof(LCM_PARAMS));

	params->type   = LCM_TYPE_DSI;

	params->width  = FRAME_WIDTH;
	params->height = FRAME_HEIGHT;

#if (LCM_DSI_CMD_MODE)
	params->dsi.mode   = CMD_MODE;
#else
    params->dsi.mode   = SYNC_PULSE_VDO_MODE;
#endif

	// DSI
	/* Command mode setting */
	params->dsi.LANE_NUM				= LCM_FOUR_LANE;
	//The following defined the fomat for data coming from LCD engine.
	params->dsi.data_format.color_order 	= LCM_COLOR_ORDER_RGB;
	params->dsi.data_format.trans_seq   	= LCM_DSI_TRANS_SEQ_MSB_FIRST;
	params->dsi.data_format.padding     	= LCM_DSI_PADDING_ON_LSB;
	params->dsi.data_format.format      		= LCM_DSI_FORMAT_RGB888;

	// Highly depends on LCD driver capability.
	params->dsi.packet_size=256;
	//video mode timing

	params->dsi.PS=LCM_PACKED_PS_24BIT_RGB888;

	params->dsi.vertical_sync_active				= 2;
	params->dsi.vertical_backporch					= 8;
	params->dsi.vertical_frontporch					= 10;
	params->dsi.vertical_active_line					= FRAME_HEIGHT;

	params->dsi.horizontal_sync_active				= 10;
	params->dsi.horizontal_backporch				= 20;
	params->dsi.horizontal_frontporch				= 40;
	params->dsi.horizontal_active_pixel				= FRAME_WIDTH;

	//begin:haobing modified
	/*BEGIN PN:DTS2013013101431 modified by s00179437 , 2013-01-31*/
	//improve clk quality
	params->dsi.PLL_CLOCK = 450; //this value must be in MTK suggested table
	//params->dsi.pll_div1=0;		// div1=0,1,2,3;div1_real=1,2,4,4 ----0: 546Mbps  1:273Mbps
	//params->dsi.pll_div2=1;		// div2=0,1,2,3;div1_real=1,2,4,4	
	//params->dsi.fbk_div =21;    	// fref=26MHz, fvco=fref*(fbk_div)*2/(div1_real*div2_real)	
	/*END PN:DTS2013013101431 modified by s00179437 , 2013-01-31*/
	//end:haobing modified

}

static void lcm_init(void)
{
    SET_RESET_PIN(1);
    SET_RESET_PIN(0);
    MDELAY(10);
    SET_RESET_PIN(1);
    MDELAY(10);

	// when phone initial , config output high, enable backlight drv chip  
    push_table(lcm_initialization_setting, sizeof(lcm_initialization_setting) / sizeof(struct LCM_setting_table), 1);  



}


static void lcm_suspend(void)
{
 
}
static void lcm_resume(void)
{

lcm_init(); 
}
static void lcm_update(unsigned int x, unsigned int y,
                       unsigned int width, unsigned int height)
{
	unsigned int x0 = x;
	unsigned int y0 = y;
	unsigned int x1 = x0 + width - 1;
	unsigned int y1 = y0 + height - 1;

	unsigned char x0_MSB = ((x0>>8)&0xFF);
	unsigned char x0_LSB = (x0&0xFF);
	unsigned char x1_MSB = ((x1>>8)&0xFF);
	unsigned char x1_LSB = (x1&0xFF);
	unsigned char y0_MSB = ((y0>>8)&0xFF);
	unsigned char y0_LSB = (y0&0xFF);
	unsigned char y1_MSB = ((y1>>8)&0xFF);
	unsigned char y1_LSB = (y1&0xFF);

	unsigned int data_array[16];

	data_array[0]= 0x00053902;
	data_array[1]= (x1_MSB<<24)|(x0_LSB<<16)|(x0_MSB<<8)|0x2a;
	data_array[2]= (x1_LSB);
	dsi_set_cmdq(data_array, 3, 1);
	
	data_array[0]= 0x00053902;
	data_array[1]= (y1_MSB<<24)|(y0_LSB<<16)|(y0_MSB<<8)|0x2b;
	data_array[2]= (y1_LSB);
	dsi_set_cmdq(data_array, 3, 1);
         /*BEGIN PN:DTS2013013101431 modified by s00179437 , 2013-01-31*/
         //delete high speed packet
	//data_array[0]=0x00290508;
	//dsi_set_cmdq(data_array, 1, 1);
         /*END PN:DTS2013013101431 modified by s00179437 , 2013-01-31*/
	
	data_array[0]= 0x002c3909;
	dsi_set_cmdq(data_array, 1, 0);

}

static unsigned int lcm_compare_id(void)
{

}

LCM_DRIVER nt35595_fhd_dsi_cmd_truly_lcm_drv=
{
    .name           = "nt35595_fhd_dsi_cmd_truly_drv",
    .set_util_funcs = lcm_set_util_funcs,
    .get_params     = lcm_get_params,
    .init           = lcm_init,/*tianma init fun.*/
    .suspend        = lcm_suspend,
    .resume         = lcm_resume,
     .compare_id     = lcm_compare_id,
#if (LCM_DSI_CMD_MODE)
    .update         = lcm_update,
#endif
   
};
/* END PN:DTS2013053103858 , Added by d00238048, 2013.05.31*/
