/*
** $Id: //Department/DaVinci/BRANCHES/MT6620_WIFI_DRIVER_V2_3/include/mgmt/rsn.h#1 $
*/

/*! \file   rsn.h
    \brief  The wpa/rsn related define, macro and structure are described here.
*/



/*
** $Log: rsn.h $
**
** 07 23 2013 wh.su
** [BORA00002446] [MT6630] [Wi-Fi] [Driver] Update the security function code
** Modify some security code for 11w and p2p
**
** 07 23 2013 wh.su
** [BORA00002446] [MT6630] [Wi-Fi] [Driver] Update the security function code
** Sync the latest jb2.mp 11w code as draft version
** Not the CM bit for avoid wapi 1x drop at re-key
** 
** 09 17 2012 cm.chang
** [BORA00002149] [MT6630 Wi-Fi] Initial software development
** Duplicate source from MT6620 v2.3 driver branch
** (Davinci label: MT6620_WIFI_Driver_V2_3_120913_1942_As_MT6630_Base)
 *
 * 10 12 2011 wh.su
 * [WCXRP00001036] [MT6620 Wi-Fi][Driver][FW] Adding the 802.11w code for MFP
 * adding the 802.11w related function and define .
 *
 * 06 22 2011 wh.su
 * [WCXRP00000806] [MT6620 Wi-Fi][Driver] Move the WPA/RSN IE and WAPI IE structure to mac.h and let the sw structure not align at byte
 * Move the WAPI/RSN IE to mac.h and SW structure not align to byte, 
 * Notice needed update P2P.ko.
 *
 * 03 17 2011 chinglan.wang
 * [WCXRP00000570] [MT6620 Wi-Fi][Driver] Add Wi-Fi Protected Setup v2.0 feature
 * .
 *
 * 02 09 2011 wh.su
 * [WCXRP00000432] [MT6620 Wi-Fi][Driver] Add STA privacy check at hotspot mode
 * adding the code for check STA privacy bit at AP mode, .
 *
 * 11 05 2010 wh.su
 * [WCXRP00000165] [MT6620 Wi-Fi] [Pre-authentication] Assoc req rsn ie use wrong pmkid value
 * fixed the.pmkid value mismatch issue
 *
 * 10 04 2010 wh.su
 * [WCXRP00000081] [MT6620][Driver] Fix the compiling error at WinXP while enable P2P
 * add a kal function for set cipher.
 *
 * 09 01 2010 wh.su
 * NULL
 * adding the wapi support for integration test.
 *
 * 08 30 2010 wh.su
 * NULL
 * remove non-used code.
 *
 * 08 19 2010 wh.su
 * NULL
 * adding the tx pkt call back handle for countermeasure.
 *
 * 07 08 2010 cp.wu
 *
 * [WPD00003833] [MT6620 and MT5931] Driver migration - move to new repository.
 *
 * 06 18 2010 wh.su
 * [WPD00003840][MT6620 5931] Security migration
 * migration from MT6620 firmware.
 *
 * 03 03 2010 wh.su
 * [BORA00000637][MT6620 Wi-Fi] [Bug] WPA2 pre-authentication timer not correctly initialize
 * Fixed the pre-authentication timer not correctly init issue, and modify the security related callback function prototype.
 *
 * 01 27 2010 wh.su
 * [BORA00000476][Wi-Fi][firmware] Add the security module initialize code
 * add and fixed some security function.
 *
 * Dec 4 2009 mtk01088
 * [BORA00000476] [Wi-Fi][firmware] Add the security module initialize code
 * adjust the function prototype for generate wap/rsn ie
 *
 * Dec 3 2009 mtk01088
 * [BORA00000476] [Wi-Fi][firmware] Add the security module initialize code
 * adjust the function input parameter
 *
 * Dec 1 2009 mtk01088
 * [BORA00000476] [Wi-Fi][firmware] Add the security module initialize code
 * adding some event function declaration
 *
 * Nov 26 2009 mtk01088
 * [BORA00000476] [Wi-Fi][firmware] Add the security module initialize code
 * move the internal data structure for pmkid to rsn.h
 *
 * Nov 23 2009 mtk01088
 * [BORA00000476] [Wi-Fi][firmware] Add the security module initialize code
 * adding the port control and class error function
 *
 * Nov 19 2009 mtk01088
 * [BORA00000476] [Wi-Fi][firmware] Add the security module initialize code
 * adding the pmkid candidate
 *
 * Nov 18 2009 mtk01088
 * [BORA00000476] [Wi-Fi][firmware] Add the security module initialize code
 *
**
*/

#ifndef _RSN_H
#define _RSN_H

/*******************************************************************************
*                         C O M P I L E R   F L A G S
********************************************************************************
*/

/*******************************************************************************
*                    E X T E R N A L   R E F E R E N C E S
********************************************************************************
*/

/*******************************************************************************
*                              C O N S T A N T S
********************************************************************************
*/
/* ----- Definitions for Cipher Suite Selectors ----- */
#define RSN_CIPHER_SUITE_USE_GROUP_KEY  0x00AC0F00
#define RSN_CIPHER_SUITE_WEP40          0x01AC0F00
#define RSN_CIPHER_SUITE_TKIP           0x02AC0F00
#define RSN_CIPHER_SUITE_CCMP           0x04AC0F00
#define RSN_CIPHER_SUITE_WEP104         0x05AC0F00
#if CFG_SUPPORT_802_11W
#define RSN_CIPHER_SUITE_AES_128_CMAC   0x06AC0F00
#endif

#define WPA_CIPHER_SUITE_NONE           0x00F25000
#define WPA_CIPHER_SUITE_WEP40          0x01F25000
#define WPA_CIPHER_SUITE_TKIP           0x02F25000
#define WPA_CIPHER_SUITE_CCMP           0x04F25000
#define WPA_CIPHER_SUITE_WEP104         0x05F25000

/* ----- Definitions for Authentication and Key Management Suite Selectors ----- */
#define RSN_AKM_SUITE_NONE              0x00AC0F00
#define RSN_AKM_SUITE_802_1X            0x01AC0F00
#define RSN_AKM_SUITE_PSK               0x02AC0F00
#if CFG_SUPPORT_802_11W
#define RSN_AKM_SUITE_802_1X_SHA256     0x05AC0F00
#define RSN_AKM_SUITE_PSK_SHA256        0x06AC0F00
#endif

#define WPA_AKM_SUITE_NONE              0x00F25000
#define WPA_AKM_SUITE_802_1X            0x01F25000
#define WPA_AKM_SUITE_PSK               0x02F25000

#define ELEM_ID_RSN_LEN_FIXED           20  /* The RSN IE len for associate request */

#define ELEM_ID_WPA_LEN_FIXED           22  /* The RSN IE len for associate request */

#define MASK_RSNIE_CAP_PREAUTH          BIT(0)

#define GET_SELECTOR_TYPE(x)           ((UINT_8)(((x) >> 24) & 0x000000FF))
#define SET_SELECTOR_TYPE(x, y)         x = (((x) & 0x00FFFFFF) | (((UINT_32)(y) << 24) & 0xFF000000))

#define AUTH_CIPHER_CCMP                0x00000008

/* Cihpher suite flags */
#define CIPHER_FLAG_NONE                        0x00000000
#define CIPHER_FLAG_WEP40                       0x00000001 /* BIT 1 */
#define CIPHER_FLAG_TKIP                        0x00000002 /* BIT 2 */
#define CIPHER_FLAG_CCMP                        0x00000008 /* BIT 4 */
#define CIPHER_FLAG_WEP104                      0x00000010 /* BIT 5 */
#define CIPHER_FLAG_WEP128                      0x00000020 /* BIT 6 */

#define WAIT_TIME_IND_PMKID_CANDICATE_SEC       6 /* seconds */
#define TKIP_COUNTERMEASURE_SEC                 60 /* seconds */

#if CFG_SUPPORT_802_11W
#define RSN_AUTH_MFP_DISABLED   0   /* MFP disabled */
#define RSN_AUTH_MFP_OPTIONAL   1   /* MFP optional */
#define RSN_AUTH_MFP_REQUIRED   2   /* MFP required */
#endif

/*******************************************************************************
*                             D A T A   T Y P E S
********************************************************************************
*/

/* Flags for PMKID Candidate list structure */
#define EVENT_PMKID_CANDIDATE_PREAUTH_ENABLED   0x01


#define CONTROL_FLAG_UC_MGMT_NO_ENC             BIT(5)

/*******************************************************************************
*                            P U B L I C   D A T A
********************************************************************************
*/

/*******************************************************************************
*                           P R I V A T E   D A T A
********************************************************************************
*/

/*******************************************************************************
*                                 M A C R O S
********************************************************************************
*/
#define RSN_IE(fp)              ((P_RSN_INFO_ELEM_T) fp)
#define WPA_IE(fp)              ((P_WPA_INFO_ELEM_T) fp)


/*******************************************************************************
*                  F U N C T I O N   D E C L A R A T I O N S
********************************************************************************
*/
BOOLEAN
rsnParseRsnIE(
    IN  P_ADAPTER_T       prAdapter,
    IN  P_RSN_INFO_ELEM_T prInfoElem,
    OUT P_RSN_INFO_T      prRsnInfo
    );

BOOLEAN
rsnParseWpaIE(
    IN  P_ADAPTER_T       prAdapter,
    IN  P_WPA_INFO_ELEM_T prInfoElem,
    OUT P_RSN_INFO_T      prWpaInfo
    );

BOOLEAN
rsnSearchSupportedCipher(
    IN  P_ADAPTER_T       prAdapter,
    IN  UINT_32           u4Cipher,
    OUT PUINT_32          pu4Index
    );

BOOLEAN
rsnIsSuitableBSS (
    IN P_ADAPTER_T          prAdapter,
    IN P_RSN_INFO_T         prBssRsnInfo
    );

BOOLEAN
rsnSearchAKMSuite(
    IN  P_ADAPTER_T       prAdapter,
    IN  UINT_32           u4AkmSuite,
    OUT PUINT_32          pu4Index
    );

BOOLEAN
rsnPerformPolicySelection(
    IN  P_ADAPTER_T       prAdapter,
    IN  P_BSS_DESC_T      prBss
    );

VOID
rsnGenerateWpaNoneIE(
    IN  P_ADAPTER_T       prAdapter,
    IN  P_MSDU_INFO_T     prMsduInfo
    );

VOID
rsnGenerateWPAIE(
    IN  P_ADAPTER_T       prAdapter,
    IN  P_MSDU_INFO_T     prMsduInfo
    );

VOID
rsnGenerateRSNIE(
    IN  P_ADAPTER_T       prAdapter,
    IN  P_MSDU_INFO_T     prMsduInfo
    );

BOOLEAN
rsnParseCheckForWFAInfoElem(
    IN  P_ADAPTER_T       prAdapter,
    IN  PUINT_8           pucBuf,
    OUT PUINT_8           pucOuiType,
    OUT PUINT_16          pu2SubTypeVersion
    );

#if CFG_SUPPORT_AAA
void
rsnParserCheckForRSNCCMPPSK (
    P_ADAPTER_T           prAdapter,
    P_RSN_INFO_ELEM_T     prIe,
    PUINT_16              pu2StatusCode
    );
#endif

VOID
rsnTkipHandleMICFailure(
    IN  P_ADAPTER_T       prAdapter,
    IN  P_STA_RECORD_T    prSta,
    IN  BOOLEAN           fgErrorKeyType
    );

VOID
rsnSelectPmkidCandidateList(
    IN  P_ADAPTER_T       prAdapter,
    IN  P_BSS_DESC_T      prBssDesc
    );

VOID
rsnUpdatePmkidCandidateList(
    IN  P_ADAPTER_T       prAdapter,
    IN  P_BSS_DESC_T      prBssDesc
    );

BOOLEAN
rsnSearchPmkidEntry(
    IN  P_ADAPTER_T       prAdapter,
    IN  PUINT_8           pucBssid,
    OUT PUINT_32          pu4EntryIndex
    );

BOOLEAN
rsnCheckPmkidCandicate(
    IN  P_ADAPTER_T       prAdapter
   );

VOID
rsnCheckPmkidCache(
    IN  P_ADAPTER_T       prAdapter,
    IN  P_BSS_DESC_T      prBss
    );

VOID
rsnGeneratePmkidIndication(
    IN  P_ADAPTER_T       prAdapter
    );

VOID
rsnIndicatePmkidCand(
    IN  P_ADAPTER_T       prAdapter,
    IN  UINT_32           u4Parm
    );
#if CFG_SUPPORT_WPS2
VOID
rsnGenerateWSCIE(
    IN  P_ADAPTER_T       prAdapter,
    IN  P_MSDU_INFO_T     prMsduInfo
    );
#endif

#if CFG_SUPPORT_802_11W
UINT_32
rsnCheckBipKeyInstalled(
    IN P_ADAPTER_T        prAdapter,
    IN P_STA_RECORD_T     prStaRec
    );

UINT_8
rsnCheckSaQueryTimeout(
    IN P_ADAPTER_T        prAdapter
    );

void
rsnStartSaQueryTimer(
    IN  P_ADAPTER_T       prAdapter
    );

void
rsnStartSaQuery(
    IN P_ADAPTER_T        prAdapter
    );

void
rsnStopSaQuery(
    IN P_ADAPTER_T        prAdapter
    );

void
rsnSaQueryRequest(
    IN P_ADAPTER_T        prAdapter,
    IN P_SW_RFB_T         prSwRfb
    );

void
rsnSaQueryAction(
    IN P_ADAPTER_T        prAdapter,
    IN P_SW_RFB_T         prSwRfb
    );
#endif
/*******************************************************************************
*                              F U N C T I O N S
********************************************************************************
*/

#endif /* _RSN_H */

