/*****************************************************************************
*                E X T E R N A L   R E F E R E N C E S
******************************************************************************/
#include "AudioAfe.h"
#include "AudioRom.h"

/*****************************************************************************
*                Tables
******************************************************************************/
const UINT8 IntrConCap[IN_MAX][OUT_MAX] =   /// S=1, RS=3
{
//   0  1  2  3  4  5  6  7  8  9 10 11 12
    {3, 3, 3, 3, 3, 1, 0, 0, 0, 0, 0, 0, 0},   //I0
    {3, 3, 3, 3, 3, 0, 1, 0, 0, 0, 0, 0, 0},   //I1
    {1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0},   //I2
    {1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0},   //I3
    {1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0},   //I4
    {3, 3, 3, 3, 3, 1, 0, 1, 0, 1, 0, 1, 0},   //I5
    {3, 3, 3, 3, 3, 0, 1, 0, 1, 0, 1, 0, 1},   //I6
    {3, 3, 3, 3, 3, 1, 0, 1, 0, 1, 0, 1, 0},   //I7
    {3, 3, 3, 3, 3, 0, 1, 0, 1, 0, 1, 0, 1},   //I8
    {3, 3, 3, 3, 3, 1, 0, 0, 0, 0, 0, 0, 1}    //I9
};


const UINT8 IntrConReg[IN_MAX][OUT_MAX] =       // format:    upper 4 bits: S    lower 4 bits: R
{
//     0     1     2     3     4     5     6     7     8     9    10    11    12
    {0x00, 0x00, 0x11, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x33},   //I0
    {0x00, 0x00, 0x11, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x33},   //I1
    {0x00, 0x00, 0x11, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x33},   //I2
    {0x00, 0x00, 0x11, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x33},   //I3
    {0x00, 0x00, 0x11, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x33},   //I4
    {0x00, 0x00, 0x11, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x33},   //I5
    {0x00, 0x00, 0x11, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x33},   //I6
    {0x00, 0x00, 0x11, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x33},   //I7
    {0x00, 0x00, 0x11, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x33},   //I8
    {0x00, 0x00, 0x11, 0x11, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x33}    //I9
};

const INT8 IntrConSBit[IN_MAX][OUT_MAX]=
{
//   0   1   2   3   4   5   6   7   8   9  10  11  12
    { 0, 16,  0, 16,  0, 16, -1, -1, -1, -1, -1, -1, -1,},   //I0
    { 1, 17,  1, 17,  1, -1, 22, -1, -1, -1, -1, -1, -1,},   //I1
    { 2, 18,  2, 18,  2, 17, -1, -1, -1, -1, -1,  6, -1,},   //I2
    { 3, 19,  3, 19,  3, 18, -1, 26, -1,  0, -1, -1, -1,},   //I3
    { 4, 20,  4, 20,  4, -1, 23, -1, 29, -1,  3, -1, -1,},   //I4
    { 5, 21,  5, 21,  5, 19, -1, 27, -1,  1, -1,  7, -1,},   //I5
    { 6, 22,  6, 22,  6, -1, 24, -1, 30, -1,  4, -1,  9,},   //I6
    { 7, 23,  7, 23,  7, 20, -1, 28, -1,  2, -1,  8, -1,},   //I7
    { 8, 24,  8, 24,  8, -1, 25, -1, 31, -1,  5, -1, 10,},   //I8
    { 9, 25,  9, 25,  9, 21, -1, -1, -1, -1, -1, -1, 11}     //I9
};



const INT8 IntrConRBit[IN_MAX][OUT_MAX]=
{
//   0   1   2   3   4   5   6   7   8   9  10  11  12
    {10, 26, 10, 26, 10, -1, -1, -1, -1, -1, -1, -1, -1,},   //I0
    {11, 27, 11, 27, 11, -1, -1, -1, -1, -1, -1, -1, -1,},   //I1
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,},   //I2
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,},   //I3
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,},   //I4
    {12, 28, 12, 28, 12, -1, -1, -1, -1, -1, -1, -1, -1,},   //I5
    {13, 29, 13, 29, 13, -1, -1, -1, -1, -1, -1, -1, -1,},   //I6
    {14, 30, 14, 30, 14, -1, -1, -1, -1, -1, -1, -1, -1,},   //I7
    {15, 31, 15, 31, 15, -1, -1, -1, -1, -1, -1, -1, -1,},   //I8
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}
};  //I9

const UINT16 tone1k_48kHz[TBL_SZ_48KHz_1K] =
{
    0xFFFA, 0x075B, 0x0E9C, 0x159C, 0x1C3D, 0x2263, 0x27F3, 0x2CD4,
    0x30F0, 0x3435, 0x3697, 0x3808, 0x3885, 0x380A, 0x3699, 0x3439,
    0x30F5, 0x2CDB, 0x27FB, 0x226C, 0x1C47, 0x15A7, 0x0EA7, 0x0766,
    0x0006, 0xF8A5, 0xF165, 0xEA63, 0xE3C2, 0xDD9C, 0xD80C, 0xD32C,
    0xCF11, 0xCBCB, 0xC969, 0xC7F8, 0xC77A, 0xC7F7, 0xC967, 0xCBC6,
    0xCF0B, 0xD326, 0xD804, 0xDD94, 0xE3BA, 0xEA5A, 0xF15A, 0xF89A
};

const UINT16 tone1k_48kHz_ST[TBL_SZ_48KHz_1K * 2] =
{
    0xFFF9, 0xFFFA, 0x085A, 0x1095, 0x1094, 0x200E, 0x1887, 0x2D58,
    0x200E, 0x378C, 0x2709, 0x3DF5, 0x2D58, 0x4027, 0x32E1, 0x3DF9,
    0x378B, 0x3791, 0x3B43, 0x2D61, 0x3DF5, 0x2018, 0x3F99, 0x10A0,
    0x4026, 0x0006, 0x3F9B, 0xEF6C, 0x3DF9, 0xDFF3, 0x3B46, 0xD2A8,
    0x3792, 0xC875, 0x32E9, 0xC20B, 0x2D62, 0xBFDA, 0x2712, 0xC208,
    0x2019, 0xC86F, 0x1892, 0xD29F, 0x10A0, 0xDFE7, 0x0865, 0xEF60,
    0x0006, 0xFFFA, 0xF7A6, 0x1095, 0xEF6C, 0x200D, 0xE779, 0x2D57,
    0xDFF2, 0x378B, 0xD8F8, 0x3DF5, 0xD2A9, 0x4026, 0xCD1F, 0x3DF9,
    0xC875, 0x3791, 0xC4BF, 0x2D61, 0xC20A, 0x2019, 0xC067, 0x10A0,
    0xBFD9, 0x0006, 0xC065, 0xEF6C, 0xC207, 0xDFF2, 0xC4BA, 0xD2A8,
    0xC86F, 0xC875, 0xCD18, 0xC20B, 0xD29F, 0xBFD9, 0xD8EE, 0xC207,
    0xDFE7, 0xC86F, 0xE76E, 0xD29F, 0xEF60, 0xDFE7, 0xF79B, 0xEF60
};


/*
const UINT16 tone1k_48kHz_ST1[TBL_SZ_48KHz_1K * 2] = {
	0xFFFA, 0xFFFA, 0x075B, 0x075B, 0x0E9C, 0x0E9C, 0x159C, 0x159C, 0x1C3D, 0x1C3D, 0x2263, 0x2263, 0x27F3, 0x27F3, 0x2CD4, 0x2CD4,
	0x30F0, 0x30F0, 0x3435, 0x3435, 0x3697, 0x3697, 0x3808, 0x3808, 0x3885, 0x3885, 0x380A, 0x380A, 0x3699, 0x3699, 0x3439, 0x3439,
	0x30F5, 0x30F5, 0x2CDB, 0x2CDB, 0x27FB, 0x27FB, 0x226C, 0x226C, 0x1C47, 0x1C47, 0x15A7, 0x15A7, 0x0EA7, 0x0EA7, 0x0766, 0x0766,
	0x0006, 0x0006, 0xF8A5, 0xF8A5, 0xF165, 0xF165, 0xEA63, 0xEA63, 0xE3C2, 0xE3C2, 0xDD9C, 0xDD9C, 0xD80C, 0xD80C, 0xD32C, 0xD32C,
	0xCF11, 0xCF11, 0xCBCB, 0xCBCB, 0xC969, 0xC969, 0xC7F8, 0xC7F8, 0xC77A, 0xC77A, 0xC7F7, 0xC7F7, 0xC967, 0xC967, 0xCBC6, 0xCBC6,
	0xCF0B, 0xCF0B, 0xD326, 0xD326, 0xD804, 0xD804, 0xDD94, 0xDD94, 0xE3BA, 0xE3BA, 0xEA5A, 0xEA5A, 0xF15A, 0xF15A, 0xF89A, 0xF89A
};*/

const UINT16  tone1p5k_48kHz[TBL_SZ_48KHz_1p5K] =
{
    0xfffa, 0x0b02, 0x159c, 0x1f62,
    0x27f3, 0x2efb, 0x3435, 0x376d,
    0x3885, 0x3770, 0x343a, 0x2f01,
    0x27fa, 0x1f6b, 0x15a6, 0x0b0c,
    0x0005, 0xf4ff, 0xea64, 0xe09f,
    0xd80d, 0xd104, 0xcbca, 0xc892,
    0xc77b, 0xc88f, 0xcbc6, 0xd0fe,
    0xd805, 0xe095, 0xea5a, 0xf4f4
};

const UINT16 tone500_48kHz[TBL_SZ_48KHz_500] =
{
    0xFFFF, 0x085F, 0x10B5, 0x18F8, 0x2121, 0x2925,0x30FB, 0x389C,
    0x3FFF, 0x471D, 0x4DEC, 0x5465,0x5A82, 0x603B, 0x658C, 0x6A6D,
    0x6ED9, 0x72CC,0x7641, 0x7934, 0x7BA3, 0x7D89, 0x7EE6, 0x7FB8,
    0x7FFF, 0x7FB8, 0x7EE7, 0x7D89, 0x7BA3, 0x7933, 0x7641, 0x72CC,
    0x6ED9, 0x6A6C, 0x658C, 0x603C,0x5A81, 0x5465, 0x4DEB, 0x471C,
    0x4000, 0x389C,0x30FB, 0x2925, 0x2120, 0x18F9, 0x10B4, 0x085F,
    0x0000, 0xF7A1, 0xEF4B, 0xE707, 0xDEDF, 0xD6DC, 0xCF05, 0xC763,
    0xC000, 0xB8E3, 0xB215, 0xAB9B,0xA57F, 0x9FC4, 0x9A74, 0x9593,
    0x9127, 0x8D35,0x89BF, 0x86CC, 0x845D, 0x8277, 0x8119, 0x8048,
    0x8001, 0x8047, 0x8119, 0x8277, 0x845D, 0x86CC,0x89C0, 0x8D34,
    0x9128, 0x9593, 0x9A74, 0x9FC4,0xA57E, 0xAB9C, 0xB215, 0xB8E3,
    0xC001, 0xC763,0xCF05, 0xD6DC, 0xDEE0, 0xE707, 0xEF4B, 0xF7A1
};

const UINT16 tone1010_48kHz[TBL_SZ_48KHz_1010] =
{
    0x0000, 0x10DF, 0x2173, 0x3173, 0x4094, 0x4E95,
    0x5B37, 0x6641, 0x6F83, 0x76D2, 0x7C0F, 0x7F21,
    0x7FFB, 0x7E99, 0x7B02, 0x7545, 0x6D7C, 0x63C9,
    0x5859, 0x4B5F, 0x3D13, 0x2DB6, 0x1D8E, 0x0CE1,
    0xFBFB, 0xEB26, 0xDAB0, 0xCADF, 0xBBFB, 0xAE49,
    0xA203, 0x975F, 0x8E91, 0x87BE, 0x8303, 0x8078,
    0x8025, 0x820F, 0x862A, 0x8C66, 0x94A8, 0x9EC8,
    0xAA9A, 0xB7EB, 0xC67D, 0xD610, 0xE65F, 0xF720,
    0x080A, 0x18CE, 0x2925, 0x38C3, 0x4763, 0x54C5,
    0x60AC, 0x6AE3, 0x733C, 0x7993, 0x7DCA, 0x7FCF,
    0x7F9A, 0x7D2A, 0x788B, 0x71D1, 0x691B, 0x5E8E,
    0x525D, 0x44BA, 0x35E4, 0x261D, 0x15AD, 0x04DC,
    0xF3F4, 0xE343, 0xD312, 0xC3AA, 0xB54F, 0xA842,
    0x9CBE, 0x92F4, 0x8B11, 0x853A, 0x8186, 0x8009,
    0x80C7, 0x83BD, 0x88DE, 0x9015, 0x993E, 0xA432,
    0xB0C2, 0xBEB3, 0xCDC9, 0xDDBE, 0xEE4C
};

const UINT16 tone1k_192kHz[TBL_SZ_192KHz_1k] =
{
    0xFFFA,0x0213,0x042D,0x0644,0x085A,0x0A6E,0x0C7E,0x0E8B,
    0x1095,0x1299,0x1499,0x1693,0x1887,0x1A75,0x1C5A,0x1E38,
    0x200D,0x21DB,0x239F,0x2559,0x2709,0x28AE,0x2A47,0x2BD6,
    0x2D58,0x2ECD,0x3037,0x3193,0x32E1,0x3421,0x3553,0x3677,
    0x378B,0x3891,0x3986,0x3A6C,0x3B42,0x3C08,0x3CBD,0x3D62,
    0x3DF5,0x3E79,0x3EE9,0x3F4A,0x3F99,0x3FD6,0x4003,0x401E,
    0x4027,0x401E,0x4003,0x3FD8,0x3F9B,0x3F4C,0x3EEC,0x3E7A,
    0x3DF9,0x3D65,0x3CC1,0x3C0C,0x3B47,0x3A71,0x398C,0x3896,
    0x3790,0x367D,0x355B,0x3429,0x32E9,0x319B,0x303F,0x2ED7,
    0x2D60,0x2BDF,0x2A51,0x28B7,0x2712,0x2563,0x23A8,0x21E5,
    0x2019,0x1E44,0x1C65,0x1A7F,0x1892,0x169E,0x14A5,0x12A4,
    0x10A0,0x0E97,0x0C89,0x0A79,0x0866,0x0650,0x0438,0x021F,
    0x0006,0xFDEC,0xFBD4,0xF9BD,0xF7A7,0xF593,0xF383,0xF174,
    0xEF6B,0xED67,0xEB67,0xE96D,0xE77A,0xE58C,0xE3A6,0xE1C8,
    0xDFF2,0xDE25,0xDC62,0xDAA8,0xD8F8,0xD752,0xD5B8,0xD42A,
    0xD2A8,0xD132,0xCFCA,0xCE6D,0xCD1F,0xCBDF,0xCAAC,0xC98A,
    0xC875,0xC76F,0xC67A,0xC594,0xC4BF,0xC3F8,0xC343,0xC29E,
    0xC20B,0xC188,0xC117,0xC0B7,0xC067,0xC02A,0xBFFD,0xBFE2,
    0xBFD9,0xBFE2,0xBFFC,0xC028,0xC065,0xC0B4,0xC115,0xC185,
    0xC208,0xC29B,0xC33F,0xC3F4,0xC4B9,0xC58F,0xC674,0xC769,
    0xC86F,0xC982,0xCAA6,0xCBD8,0xCD18,0xCE65,0xCFC1,0xD129,
    0xD2A0,0xD421,0xD5AF,0xD74A,0xD8EE,0xDA9C,0xDC57,0xDE1A,
    0xDFE8,0xE1BD,0xE39B,0xE580,0xE76D,0xE962,0xEB5C,0xED5B,
    0xEF5F,0xF168,0xF376,0xF587,0xF79A,0xF9B0,0xFBC8,0xFDE1,
};

const UINT32 tone1k_48kHz_24bit[TBL_SZ_48KHz_1K] =
{
    0xfff3a600,0x10a8b400,0x2114ca00,0x30effa00,0x3ff4cd00,0x4de17c00,0x5a790800,0x65844a00,
    0x6ed2e000,0x763c0800,0x7b9f4b00,0x7ee50f00,0x7fff0000,0x7ee84800,0x7ba5b000,0x76457c00,
    0x6edf3a00,0x65935400,0x5a8a8000,0x4df51600,0x400a3200,0x3106cd00,0x212ca800,0x10c13300,
    0x000c5a00,0xef574c00,0xdeeb3600,0xcf100600,0xc00b3300,0xb21e8400,0xa586f800,0x9a7bb600,
    0x912d2000,0x89c3f800,0x8460b500,0x811af100,0x80010000,0x8117b800,0x845a5000,0x89ba8400,
    0x9120c600,0x9a6cac00,0xa5758000,0xb20aea00,0xbff5ce00,0xcef93300,0xded35800,0xef3ecd00
};

const INT32 resetTable[TBL_SZ_RESET] =
{
    0x8031007c, 0x00000000, 0x00000000, 0x60000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x08000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000180, 0x00000000, 0x00000000,
    0x00000000, 0x00000300, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x0f000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00007ffa, 0x00000000,
    0x00005a00, 0x00000000, 0x00001589, 0x0000019a,
    0x00000067, 0x00000034, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x02000000, 0x00000000, 0x0000001f, 0x00007fff,
    0xf0000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x20101014, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00001000, 0x77ffffff, 0x00077777, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000770, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00007100, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000001, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x33333333, 0x33333333, 0x000000FF, 0x00000000
};

const UINT32 STF_32K_Coeff_Table[TBL_SZ_STF_32K_COEFF] =
{
    0xff58, 0x0063, 0x0086, 0x00bf, 0x0100, 0x013d, 0x0169, 0x0178,
    0x0160, 0x011c, 0x00aa, 0x0011, 0xff5d, 0xfea1, 0xfdf6, 0xfd75,
    0xfd39, 0xfd5a, 0xfde8, 0xfeea, 0x005f, 0x0237, 0x0458, 0x069f,
    0x08e2, 0x0af7, 0x0cb2, 0x0df0, 0x0e96
};

const UINT16
STF_32K_Input_Table[TBL_SZ_STF_32K_INPUT] =
{
    0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0x8001, 0x8001,
    0x8001, 0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001,
    0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001,
    0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001,
    0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001,
    0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0x8001, 0x8001,
    0x8001, 0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001,
    0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0x8001, 0x8001,
    0x8001, 0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001,
    0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001,
    0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff
};

const UINT16
STF_32K_Golden_Table[TBL_SZ_STF_32K_GOLDEN] =
{
    0x00a8, 0xfef5, 0xff35, 0xff82, 0x0000, 0x00c3, 0x01d4, 0x032e,
    0x04be, 0x0662, 0x07f0, 0x0933, 0x0b48, 0x0a9b, 0x08db, 0x05d4,
    0x0185, 0xfc23, 0xf61d, 0xf013, 0xe978, 0xe68d, 0xe65b, 0xe9c8,
    0xf16a, 0xfd6f, 0x0d91, 0x210b, 0x36a3, 0x4cbb, 0x617b, 0x72f7,
    0x7f60, 0x7ffe, 0x7ffe, 0x7a33, 0x695a, 0x522f, 0x37c1, 0x18db,
    0xf9d7, 0xdd16, 0xc4e3, 0xb339, 0xa988, 0xa8a7, 0xaf66, 0xc09a,
    0xd948, 0xf7ea, 0x1a84, 0x3ed7, 0x628a, 0x7ffe, 0x7ffe, 0x7ffe,
    0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x628a, 0x3f9a,
    0x1c58, 0xfb18, 0xde06, 0xc6fc, 0xb756, 0xb1da, 0xb4d0, 0xbdd4,
    0xcdbe, 0xe2ea, 0xfb5c, 0x14fe, 0x2dde, 0x4242, 0x52d2, 0x60c0,
    0x69fc, 0x6f08, 0x70ca, 0x7066, 0x6f0c, 0x6dc6, 0x6d44, 0x6dc6,
    0x6f0c, 0x7066, 0x70ca, 0x6f08, 0x69fc, 0x60c0, 0x52d2, 0x4242,
    0x2dde, 0x14fe, 0xfb5c, 0xe2ea, 0xcdbe, 0xbdd4, 0xb4d0, 0xb1da,
    0xb756, 0xc6fc, 0xde06, 0xfb18, 0x1c58, 0x3f9a, 0x628a, 0x7ffe,
    0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe,
    0x628a, 0x3f9a, 0x1c58, 0xfb18, 0xde06, 0xc6fc, 0xb756, 0xb1da,
    0xb4d0, 0xbdd4, 0xcdbe, 0xe2ea, 0xfb5c, 0x14fe, 0x2dde, 0x4242,
    0x52d2, 0x60c0, 0x69fc, 0x6f08, 0x70ca, 0x7066, 0x6f0c, 0x6dc6,
    0x6d44, 0x6dc6, 0x6f0c, 0x7066, 0x70ca, 0x6f08, 0x69fc, 0x60c0,
    0x52d2, 0x4242, 0x2dde, 0x14fe, 0xfb5c, 0xe2ea, 0xcdbe, 0xbdd4,
    0xb4d0, 0xb1da, 0xb756, 0xc6fc, 0xde06, 0xfb18, 0x1c58, 0x3f9a,
    0x628a, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe,
    0x7ffe, 0x7ffe, 0x628a, 0x3f9a, 0x1c58, 0xfb18, 0xde06, 0xc6fc,
    0xb756, 0xb1da, 0xb4d0, 0xbdd4, 0xcdbe, 0xe2ea, 0xfb5c, 0x14fe,
    0x2dde, 0x4242, 0x52d2, 0x60c0, 0x69fc, 0x6f08, 0x70ca, 0x7066,
    0x6f0c, 0x6dc6, 0x6d44, 0x6dc6, 0x6f0c, 0x7066, 0x70ca, 0x6f08,
    0x69fc, 0x60c0, 0x52d2, 0x4242, 0x2dde, 0x14fe, 0xfb5c, 0xe2ea,
    0xcdbe, 0xbdd4, 0xb4d0, 0xb1da, 0xb756, 0xc6fc, 0xde06, 0xfb18,
    0x1c58, 0x3f9a, 0x628a, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe,
    0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x628a, 0x3f9a, 0x1c58, 0xfb18,
    0xde06, 0xc6fc, 0xb756, 0xb1da, 0xb4d0, 0xbdd4, 0xcdbe, 0xe2ea,
    0xfb5c, 0x14fe, 0x2dde, 0x4242, 0x52d2, 0x60c0, 0x69fc, 0x6f08,
    0x70ca, 0x7066, 0x6f0c, 0x6dc6, 0x6d44, 0x6dc6, 0x6f0c, 0x7066,
    0x70ca, 0x6f08, 0x69fc, 0x60c0, 0x52d2, 0x4242, 0x2dde, 0x14fe,
    0xfb5c, 0xe2ea, 0xcdbe, 0xbdd4, 0xb4d0, 0xb1da, 0xb756, 0xc6fc,
    0xde06, 0xfb18, 0x1c58, 0x3f9a, 0x628a, 0x7ffe, 0x7ffe, 0x7ffe,
    0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x628a, 0x3f9a,
    0x1c58, 0xfb18, 0xde06, 0xc6fc, 0xb756, 0xb1da, 0xb4d0, 0xbdd4,
    0xcdbe, 0xe2ea, 0xfb5c, 0x14fe, 0x2dde, 0x4242, 0x52d2, 0x60c0,
    0x69fc, 0x6f08, 0x70ca, 0x7066, 0x6f0c, 0x6dc6, 0x6d44, 0x6dc6,
    0x6f0c, 0x7066, 0x70ca, 0x6f08, 0x69fc, 0x60c0, 0x52d2, 0x4242,
    0x2dde, 0x14fe, 0xfb5c, 0xe2ea, 0xcdbe, 0xbdd4, 0xb4d0, 0xb1da,
    0xb756, 0xc6fc, 0xde06, 0xfb18, 0x1c58, 0x3f9a, 0x628a, 0x7ffe,
    0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe,
    0x628a, 0x3f9a, 0x1c58, 0xfb18, 0xde06, 0xc6fc, 0xb756, 0xb1da,
    0xb4d0, 0xbdd4, 0xcdbe, 0xe2ea, 0xfb5c, 0x14fe, 0x2dde, 0x4242,
    0x52d2, 0x60c0, 0x69fc, 0x6f08, 0x70ca, 0x7066, 0x6f0c, 0x6dc6,
    0x6d44, 0x6dc6, 0x6f0c, 0x7066, 0x70ca, 0x6f08, 0x69fc, 0x60c0,
    0x537a, 0x4287, 0x2c4d, 0x1374, 0xf9de, 0xe1ad, 0xcd18, 0xbe30,
    0xb69e, 0xb57c, 0xbe5e, 0xcf65, 0xe75a, 0x046f, 0x2473, 0x4506,
    0x63d9, 0x7ecd, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe,
    0x7ffe, 0x74b7, 0x5fff, 0x4b29, 0x375d, 0x2581, 0x1635, 0x09cb,
    0x0046, 0xfb74, 0xf7c5, 0xf63f, 0xf682, 0xf823, 0xfab7, 0xfddb,
    0x0147, 0x02be, 0x0549, 0x0753, 0x08b2, 0x0955, 0x0944, 0x089a,
    0x077e, 0x061e, 0x04a6, 0x033d, 0x0200, 0x0100, 0x0041, 0xffbb,
    0xff58
};

const UINT32 STF_16K_Coeff_Table[TBL_SZ_STF_16K_COEFF] =
{
    0x0127, 0x027a, 0x0278, 0x0227, 0xffd5, 0xfd22, 0xfabf, 0xfaeb,
    0xfe90, 0x05eb, 0x0f47, 0x180a, 0x1d4e
};

const UINT16
STF_16K_Input_Table[TBL_SZ_STF_16K_INPUT] =
{
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0x8001, 0x8001,
    0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001,
    0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0x8001,
    0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001,
    0x8001, 0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0x8001, 0x8001,
    0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001,
    0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8001, 0x8001, 0x8001,
    0x8001, 0x8001, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
    0x7fff, 0x7fff, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x7fff
};

const UINT16
STF_16K_Golden_Table[TBL_SZ_STF_16K_GOLDEN] =
{
    0x0127, 0x03a1, 0x0619, 0x0840, 0x05c7, 0xfdf5, 0xf3c4, 0xea61,
    0xe947, 0xf73c, 0x15f9, 0x3d1d, 0x6197, 0x72b9, 0x6679, 0x3b2c,
    0xfc51, 0xbb19, 0x8cd2, 0x82a1, 0x9fb3, 0xdd58, 0x2c4f, 0x78d1,
    0x7ffe, 0x7ffe, 0x7ffe, 0x7c72, 0x3268, 0xe598, 0xa57a, 0x8096,
    0x8096, 0xa57a, 0xe598, 0x3268, 0x7c72, 0x7ffe, 0x7ffe, 0x7ffe,
    0x7c72, 0x3268, 0xe598, 0xa57a, 0x8096, 0x8096, 0xa57a, 0xe598,
    0x3268, 0x7c72, 0x7ffe, 0x7ffe, 0x7ffe, 0x7c72, 0x3268, 0xe598,
    0xa57a, 0x8096, 0x8096, 0xa57a, 0xe598, 0x3268, 0x7c72, 0x7ffe,
    0x7ffe, 0x7ffe, 0x7c72, 0x3268, 0xe598, 0xa57a, 0x8096, 0x8096,
    0xa57a, 0xe598, 0x3268, 0x7c72, 0x7ffe, 0x7ffe, 0x7ffe, 0x7c72,
    0x3268, 0xe598, 0xa57a, 0x8096, 0x8096, 0xa57a, 0xe598, 0x3268,
    0x7c72, 0x7ffe, 0x7ffe, 0x7ffe, 0x7c72, 0x3268, 0xe598, 0xa57a,
    0x8096, 0x8096, 0xa57a, 0xe598, 0x3268, 0x7c72, 0x7ffe, 0x7ffe,
    0x7ffe, 0x7c72, 0x3268, 0xe598, 0xa57a, 0x8096, 0x8096, 0xa57a,
    0xe598, 0x3268, 0x7c72, 0x7ffe, 0x7ffe, 0x7ffe, 0x7c72, 0x3268,
    0xe598, 0xa57a, 0x8096, 0x8096, 0xa57a, 0xe598, 0x3268, 0x7c72,
    0x7ffe, 0x7ffe, 0x7ffe, 0x7c72, 0x3268, 0xe598, 0xa57a, 0x8096,
    0x8096, 0xa57a, 0xe598, 0x3268, 0x7c72, 0x7ffe, 0x7ffe, 0x7ffe,
    0x7c72, 0x3268, 0xe598, 0xa57a, 0x8096, 0x8096, 0xa57a, 0xe598,
    0x3268, 0x7c72, 0x7ffe, 0x7ffe, 0x7ffe, 0x7c72, 0x3268, 0xe598,
    0xa57a, 0x8096, 0x8096, 0xa57a, 0xe598, 0x3268, 0x7c72, 0x7ffe,
    0x7ffe, 0x7ffe, 0x7c72, 0x3268, 0xe598, 0xa57a, 0x8096, 0x8096,
    0xa57a, 0xe598, 0x3268, 0x7c72, 0x7ffe, 0x7ffe, 0x7ffe, 0x7c72,
    0x3268, 0xe598, 0xa57a, 0x8096, 0x8096, 0xa57a, 0xe598, 0x3268,
    0x7b4b, 0x7ffe, 0x7ffe, 0x7ffe, 0x745d, 0x2d31, 0xe5a2, 0xace7,
    0x8e67, 0x8d6c, 0xa757, 0xcf15, 0xf68d, 0x13d5, 0x2015, 0x1cfa,
    0x0fe1, 0x0237, 0xf7d6, 0xf50d, 0xf795, 0xfc0e, 0xfed7, 0x0153,
    0x0127
};

const UINT32 ac3_raw_table[TBL_SZ_AC3_RAW] =
{
    0x7577770B, 0xFD434014, 0x33364F68, 0xC1F07FD9, 0xFAEA7C80, 0xDFCFE7BB, 0xF3F97C3E, 0x3E9FCFE7,
    0x9FCF0718, 0xF97C3E3E, 0x9FCFE7F3, 0xF3F97C3E, 0xA46D2EE3, 0xFE010048, 0x4E000088, 0x6CFD0180,
    0x72FC0100, 0x60FF0700, 0x000E5D00, 0x00601C07, 0x0000E67C, 0xCC078041, 0x802B0040, 0x2100A81D,
    0x01901840, 0x009C00B2, 0xA00A2017, 0xB4004201, 0x0B001200, 0x000401C0, 0x801D00C2, 0x401BC023,
    0x4806E025, 0x5E007A02, 0x05402900, 0x00AA0280, 0xC02B8053, 0xCE02E804, 0x2D804A00, 0x027004C0,
    0x004400EA, 0x1004602F, 0x7D000003, 0x78008500, 0x74008A00, 0x70008E00, 0x6C009100, 0x69009500,
    0x66009800, 0x63009B00, 0x61009E00, 0x5F00A000, 0x5C00A300, 0x5A00A500, 0x5800A700, 0x5600A900,
    0x5500AB00, 0x5300AC00, 0x5200AE00, 0x5000AF00, 0x4F00B000, 0x4E00B200, 0x4D00B200, 0x4C00B400,
    0xBA00B500, 0xA6BBE96E, 0x6EBA9BEE, 0xACCBBAE9, 0x0300CBBA, 0x000010FD, 0xFA03009D, 0xF80300D8,
    0xFE0F00E4, 0x1CBA00C0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0xF9000000, 0x30FC18F0, 0x7C3E1F70, 0x39140A55, 0xA4A6A1D4, 0xCF278D48, 0xE7F301C7,
    0x43A150C5, 0x6A1A4A9D, 0x7CD28844, 0x000100FC, 0xFAFFFF07, 0xC8FF01C0, 0x00F04FFD, 0xED2F1FED,
    0xFDBE944C, 0x447F9194, 0xF0FF7301, 0xFD1F0006, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x003E1F00, 0xFF7F0010, 0x1F00ACFF, 0xFFD48FFC, 0xF2D10E00, 0x4BC9D4FE, 0x0040D9EF, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xF1010000, 0x807059BD, 0x25101082,
    0x529F4FA5, 0xE7F3497D, 0x0358FED0, 0xBBFCF144, 0xCFE72B71, 0x5AA53EA9, 0xA1CF271C, 0xD2A9AEA9,
    0xAB616A58, 0xDAF30D49, 0x86C39EF0, 0xE927D595, 0x4DADC288, 0x4FEF672D, 0x3FD10096, 0x18693E9F,
    0x4FEAF3F9, 0x098756A9, 0x6B6AE8F3, 0x1A9674AA, 0x43D26A98, 0x27BCF67C, 0x75A5E1B0, 0x3062FA49,
    0x594B53AB, 0x226DD1FB, 0x20759044, 0x030828FC, 0xDA106824, 0xA4B56100, 0x0831EA9F, 0x783F94F6,
    0x020A3FD8, 0x041AC900, 0x6D188036, 0x8CFA2769, 0x3B000042, 0x560000E3, 0x67D03F32, 0xBBC881B3,
    0xB26B2ECA, 0xD6FDAFFD, 0xE1D9D6FD, 0xF48F8C15, 0x72E0EC19, 0x9A8BF22E, 0xFF6BBFEC, 0xEF000075,
    0x2F02008C, 0x863E80F6, 0xED16F9B4, 0xB33E4CD1, 0xA376F648, 0x96A74CEF, 0x0FA0FD8B, 0x453EADA1,
    0x0F5374BB, 0x9D3DD2AC, 0xBE0300A8, 0x20100030, 0xCC1CD905, 0x7F017E9F, 0x153D8444, 0xF4B3933F,
    0x20CA038B, 0x4F78AAC1, 0x80DF271B, 0x0F21D15F, 0xECE44F45, 0xF2C022FD, 0x07003088, 0x956F007C,
    0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA,
    0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA,
    0xC5ED770B, 0xFD434014, 0x0F364F68, 0x84CBEAD9, 0x83801004, 0xE9C5D80A, 0xFA74BE9C, 0x9FD46794,
    0xF3955453, 0xFC2BEEE7, 0xE38907B0, 0xE7DB76F9, 0x7D3E9FCF, 0xCF37CC5D, 0xFA4A3FA1, 0x954EA59A,
    0xF399553E, 0xD221E3A7, 0xD8934A7D, 0x7C3E5F84, 0x4FE813FA, 0x012C9F6B, 0x7C3E7FE2, 0xE7F331D2,
    0x73579FCF, 0x4FE8F30D, 0xA9A6BED2, 0x954FA553, 0xF8E97C66, 0x529F74C8, 0x1721F6A4, 0x843E9FCF,
    0xE6DA13FA, 0xF3F97F5C, 0x115311E4, 0xEE3AF05F, 0x059E0315, 0xDE2E98E6, 0x7DFFBDCA, 0xC5AE66CB,
    0x20F357F4, 0x15311319, 0xE1AE03FF, 0x5EE03950, 0xECED8269, 0xDCF7DFAB, 0x00000000, 0x000C0000,
    0x9F001204, 0x8E3442F8, 0xE6E2FEF5, 0xEEFF8F83, 0xCCAC3DE3, 0x0EE3D5D6, 0x5FAF5931, 0x5E79C92F,
    0xEEBFE308, 0x28CFB64B, 0xEEFEFF38, 0xCDCCDA33, 0xE3305E6D, 0xF2F59A15, 0x000080FC, 0x06000000,
    0x00480200, 0x8CEFA598, 0x5D20EDF2, 0xD2C1C205, 0xDC049482, 0x6C18D317, 0x702CEE75, 0xDA72574C,
    0x98197D4C, 0x9C51D026, 0xD449C088, 0x3133BD23, 0xA43E37A7, 0x1B999EC4, 0x8876622B, 0xD904F38A,
    0x0072C192, 0xEBF23CF3, 0x8AB3D45D, 0xF807E0BD, 0x49E14AD0, 0x1538C3CA, 0x689F4806, 0x698B0C76,
    0x0B64211D, 0xEBD8221A, 0x8D7F00DE, 0x9C14AE04, 0x508133AC, 0x87F68964, 0x0000C060, 0x03000000,
    0x00240100, 0xF27C4046, 0xDB8D8668, 0x2D55D9D5, 0xFF0A9085, 0x6AE783EF, 0x06A28B8C, 0xEAF38053,
    0xAE93B93D, 0x6B3A8F41, 0x381F5958, 0xAEFAEFF9, 0xE4042B1D, 0x73F5E2BB, 0x72846ECC, 0xFA69A7C7,
    0xA35D64A5, 0x0398FD5D, 0x36514CE8, 0x07FE2D42, 0x6AA18060, 0x54D9F20D, 0xB652FD07, 0x6C689703,
    0x007FC608, 0x14230A63, 0x76E0DF22, 0xA0160A08, 0x40952DDF, 0x602BD57F, 0x00006039, 0x01000000,
    0x00920080, 0x60939E1A, 0xCFB2AA67, 0x91B09334, 0x8238164E, 0x3FB7EDFF, 0xA397D695, 0x4A86CC9B,
    0x51EF4BDE, 0x93BE1069, 0x6C60D607, 0x38801907, 0x13CA9572, 0x5AAA07D6, 0xE84C2ABE, 0x999D7AB6,
    0xCAC8B3CA, 0x167A5247, 0x975D5238, 0xFEFFF6D0, 0xF6F9B8CB, 0xC2D89687, 0x4A1F27BB, 0x601B03E1,
    0x7D4520B5, 0x8DD9F645, 0xECFF6F0F, 0x689F8FBB, 0x2B8C6D79, 0xAEF471B2, 0x00003010, 0x00000000,
    0x52A185C1, 0x90F09BF6, 0x6FE91840, 0xE5266F5F, 0xB1BC74EB, 0x8E76C56D, 0xB8607D52, 0x2B873845,
    0xE43513B2, 0x9EF86845, 0xD5DB152B, 0x452BF64E, 0xEBB2E59C, 0xC27E0041, 0x065BA227, 0x7393677C,
    0x0634ACAB, 0x3AC9CB20, 0xF2AE6708, 0x4353FD01, 0xE65B4074, 0x8A348FB3, 0xA617F33C, 0x1C394F35,
    0x094A8287, 0x20EF9236, 0x3734D51F, 0x6BBE0544, 0xA348F338, 0x607A31CF, 0x00000000, 0x8B330000,
    0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA,
    0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA,
    0x056A770B, 0xFD434014, 0x0F364F68, 0x84CBEAD9, 0x83801004, 0xCFC7D80A, 0xFD84BE6B, 0x9DAE742E,
    0xD24D7D3E, 0x7C9F6A8A, 0xE38906B0, 0x57C276F9, 0xA43E9FCF, 0xCAA7D3FD, 0xFA7CA5A9, 0xD24F981A,
    0xBA46A7D2, 0x2A9F4A67, 0x28BD5A7B, 0xA8BD1C36, 0x70DB9346, 0x012C9F77, 0x7C3E7FA2, 0xE7F331D2,
    0x743FA9CF, 0x69AAF2E9, 0xA6863E5F, 0xA9B4F413, 0xD299AED1, 0xD69ECAA7, 0x870D4AAF, 0xA4116A2F,
    0xE61DDCF6, 0xF3F97F5C, 0x09AA11E4, 0x1937F85F, 0x6701FB9C, 0x9B2160A6, 0xB990EA5A, 0xBFA18D1B,
    0x2813B8B4, 0x95A01851, 0x997183FF, 0x7A16B0CF, 0xB5190266, 0x910BA9AE, 0x00000000, 0x000C0000,
    0x14011204, 0x677058F0, 0xC2F0ACFD, 0xFFFBEF8B, 0xFDF6655B, 0x75C5C7FC, 0xB62ED0B2, 0xED28D0F6,
    0xE667607F, 0x68ACB50B, 0xF5BFFFBE, 0xDF6F5FB6, 0x5B577CCC, 0x6FEB022D, 0x0000006D, 0x06000000,
    0x00480200, 0x92D4E599, 0x34185D2C, 0x0F90955C, 0xD32DBF99, 0x30E00A53, 0xD797A5FA, 0x7644C2FE,
    0xBED590CF, 0x5F3C3EDD, 0x0967FE98, 0x6C48FF70, 0x39CD70D5, 0x1EE78337, 0xCC876706, 0xF39B4BB1,
    0x431561AA, 0x6DE3D860, 0x9CF7E043, 0xF207B8FB, 0xF8C4A2C8, 0x0480A279, 0x2C32118B, 0xCC0B9D3E,
    0x07A82297, 0x4F6A1532, 0x2C7F80BB, 0x874F2C8A, 0x4800289A, 0xC32213B1, 0x0000C0E9, 0x03000000,
    0x00240100, 0x1FD4E10F, 0x56312885, 0x971E2D6F, 0x5BB4A8A5, 0x998A5201, 0xCA39E3D8, 0xE5589204,
    0xE38017DD, 0x3BC92B3A, 0xE64986F3, 0x5B1B5F62, 0x13D5EE5C, 0x050FEC3B, 0x2AE21057, 0xF9E51307,
    0xEB312D24, 0xF75D1505, 0xB5828302, 0x05002421, 0x801A9CC5, 0x4AACE04E, 0x9E76355A, 0xD4879928,
    0x03CF2662, 0x122311E8, 0x5C004012, 0x04A8C159, 0xA5C40AEE, 0xE26957A3, 0x00008089, 0x01000000,
    0x00920080, 0x5C58FA0A, 0x0AAA991F, 0x1A534BF5, 0x552FBB08, 0xC91AD594, 0x81718516, 0x89CF7709,
    0xED909869, 0x7AD1D3B2, 0x3B2D5561, 0xFCBF4871, 0x09665A5E, 0xAF7BF6E4, 0x79DC4880, 0x73647DAD,
    0xAA2F40A7, 0x281ABD2A, 0xD97F60F3, 0x00FF0351, 0xE1438AFB, 0x421936C1, 0xDCEB33B8, 0x64EEAFDF,
    0x7DD3F3B1, 0x8DB57A3D, 0x0FF03F10, 0x1C3EA4B8, 0x2B946113, 0xCDBD3E83, 0x0000F0FA, 0x00000000,
    0xA04800C0, 0x1E8BDE1D, 0xF6246277, 0xF6532287, 0x0B2EFD52, 0x4489F0A0, 0xAFBB1AB7, 0x595B395B,
    0xF19D8A93, 0xA4990C66, 0x81049DD8, 0x96545AF1, 0xD11F22B6, 0x1F9C320D, 0x6E9F291C, 0xED3F65A9,
    0x8A93C3FA, 0x737022D6, 0x80B59F53, 0xD76D30BE, 0xCA0F86C8, 0x2AED068E, 0xA51E839D, 0x5E868746,
    0xED0067C0, 0x0B58FB49, 0x7CDD06E3, 0xA8FC6088, 0xA9D26EE0, 0x00E831D8, 0x00000000, 0x4C610000,
    0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA,
    0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA,
    0x97CF770B, 0xFD434014, 0x0F364F68, 0x84CBEAD9, 0x83801004, 0x0A21DA0A, 0x4A7D3EA1, 0x5FE957BA,
    0x144A7D3E, 0x7CA92932, 0xE38907B0, 0xE7BB76F9, 0x863E9FCF, 0xCF77B5F6, 0x0A7BD3D2, 0x95EFEA13,
    0x13FEA28D, 0xD69E50A5, 0xEA93BAB6, 0x9B569D4F, 0x6F35EC5D, 0x012C9F90, 0x7C3E7FE2, 0xE7F331D2,
    0xADBDA1CF, 0xB4F4F35D, 0xFA84C2DE, 0x6863E5BB, 0x54E984BF, 0xAEADB527, 0xE793FAA4, 0x7BD7A655,
    0x26E45B0D, 0xF3F97F5C, 0x00F911E4, 0x3C2108E0, 0x9AE69918, 0xC623E8D3, 0xB391E2CC, 0x1B54461D,
    0x782B18B9, 0x0E101E89, 0xC1138200, 0xAD699E89, 0x6C3C823E, 0x311B29CE, 0x00000000, 0x000C0000,
    0x1C001204, 0x3956C500, 0xA2F2D5A3, 0x10F44F08, 0x54447660, 0x86BCE187, 0x9F9D4604, 0x0DCA761B,
    0xEBEF1CD8, 0xA0A9D5CB, 0x0641FF84, 0x48456407, 0x60C81B7E, 0xF1D96944, 0x000000B7, 0x06000000,
    0x00480200, 0xF4CB780A, 0x0CB5E30A, 0xB158044B, 0x5365C9FC, 0x628A234F, 0x4D780373, 0x86DF5797,
    0x7C6F11ED, 0x9FD91FA4, 0x5FCB73EC, 0x2CF6FBF4, 0x760AA8EE, 0xADB76B09, 0x41AE3274, 0xA29DEF61,
    0x403590FF, 0x8B26077D, 0x8520420D, 0xF105A83D, 0x83BDEC7D, 0x7B4FF2C5, 0xE358C9DE, 0xAF2D11F1,
    0xFFFFD2DB, 0xF368F93B, 0x175F80DA, 0x3CD8CBDE, 0xBDF7245F, 0x3F8E95EC, 0x00000011, 0x03000000,
    0x00240100, 0xE919EF79, 0x78E40FF4, 0x1279016D, 0x1151DB9C, 0x4D6335BA, 0x1D28A87E, 0x5A97CB21,
    0x5BA9375B, 0x78D50363, 0x8A93C8F1, 0x695D9EBE, 0xECA81B02, 0x6C6F5AF4, 0xC027F14C, 0x404BF843,
    0xC5500891, 0x27B138ED, 0xC963A10F, 0x0201103F, 0x3A8ABC08, 0x7442E0F5, 0x04CB958C, 0xA4D1473F,
    0x068BE798, 0x73241977, 0x201000F1, 0xAFA3C88B, 0x4827045E, 0x43B05CC9, 0x000060F4, 0x01000000,
    0x00920080, 0x706DD81E, 0x503E0470, 0x4DCFA673, 0xE32C5D55, 0x8FA242C1, 0x8C7CF363, 0x96464B68,
    0x298D267B, 0xC21B2188, 0x9CFE567B, 0xF3C12301, 0x4331E444, 0xC998F3B2, 0xC0442E77, 0x2441B03D,
    0x71995572, 0x241ABA81, 0x14CFF916, 0x82FE8FC1, 0x6DCCEEDC, 0xD95092A9, 0x89BF97CE, 0x9EC7C2E9,
    0xFD704FCA, 0x3411FEF5, 0x2DE8FF18, 0xDAC6ECCE, 0x9C0D2599, 0x9EF87BE9, 0x0000209C, 0x00000000,
    0xA04800C0, 0x42380F1C, 0x621D8214, 0x2F1ADAD9, 0x8E5C8DA9, 0x859211A2, 0x3AEA1CA1, 0x7471A5E4,
    0x5716014B, 0xCBE6E5B1, 0xF5D08957, 0xBAC2A219, 0x02EA86D6, 0x1235ECCB, 0xB19108F8, 0xE32DB218,
    0xCFD7FE6B, 0x3C9DE4EF, 0x80F5E770, 0x58135F7E, 0x4E04E657, 0x2724F131, 0xA250F9B6, 0x58D46FBD,
    0x2DFD863F, 0x07587F1E, 0x8535F1E5, 0xE344607E, 0x7B42121F, 0x0008956F, 0x00000000, 0x63E40000,
    0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA,
    0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA, 0x55555555, 0xAAAAAAAA,
    0x5BCF770B, 0xFD434014, 0x0F364F68, 0x84CBEAD9, 0x83801004, 0x6FB8D812, 0xF97C429F, 0x2CDF77EC,
    0xFE78A201, 0xF395B85D, 0x25D3CFE7, 0xE7F35D85, 0x7E3EABCF, 0x30F7EBE9, 0x9D543EE9, 0xDAD0A72A,
    0xDBF65443, 0x419F2EF4, 0xA7F2A9AE, 0x6800CBC7, 0x349FCF9F, 0xF3F97C8C, 0x5761C9F4, 0xEAF3F97C,
    0x7ABA9FCF, 0x4F3ACCFD, 0xA94A2795, 0xD59036F4, 0x0BFDB63D, 0xAA6BD0A7, 0x97F1A97C, 0xF97CFE1F,
    0x087C8E04, 0x58D2FF05, 0x34029D00, 0x4327C503, 0xE784FCFC, 0x0F4155FD, 0x32FE0DFA, 0x80C0E7D8,
    0x8025FD5F, 0x4023D009, 0x3F74523C, 0x404EC8CF, 0x00000000, 0x01000300, 0xE5090009, 0xCD863CB1,
    0xA22D38CC, 0xBB77FCFD, 0xAA5BA0FD, 0x06FD2763, 0x659E2ADC, 0xADC5F6C9, 0x636239C2, 0x257631E4,
    0xFDA2E6BC, 0x6622FC66, 0x6DD07F32, 0x5CE6A9C2, 0xDC5A6C9F, 0x3E269623, 0x00000043, 0x01000000,
    0x00920080, 0xA91E8238, 0x69B5A40D, 0x2B60C2C8, 0x6A6BB796, 0xE3A25FE2, 0x50125718, 0x6FC6B9E4,
    0xBBCA23B3, 0xF12AF1EF, 0x8BB33D07, 0x877065A4, 0xA02DC4B3, 0x1377B6A1, 0xDAD89719, 0xF39E0488,
    0xD9949898, 0x48C76FB7, 0x1C4266D0, 0x7D00EF5F, 0x6033FD4C, 0xE6ADA3D5, 0x77418DCF, 0x443933EA,
    0x7E914CCB, 0xE5D97A0B, 0xD407F0FE, 0x0D36D3CF, 0x6CDE3A5A, 0x7E17D4F8, 0x000030A3, 0x00000000,
    0x004900C0, 0x08CCC71E, 0x80B0B079, 0xAD8E5813, 0x779475C9, 0xC3AF5D9A, 0xD7EEA683, 0x795FC7A3,
    0xB0EF74D8, 0x808DA53F, 0xF146AFB7, 0x072A283E, 0xCA2466F1, 0x3F653FCF, 0x2CB9A9D5, 0xD80EBBC2,
    0x07944914, 0xE036AB68, 0x710596DD, 0xFF00BE8F, 0x961D326A, 0x4A70E79E, 0x860C56A3, 0xF48AE78F,
    0x011C6A26, 0x1C5B0482, 0xF60FE0FB, 0x69D921A3, 0xAA0477EE, 0x68C86035, 0x000078FE, 0x00000000,
    0x80240060, 0xF69F3805, 0x7EAF10C5, 0x8114F6A2, 0x25CAF751, 0x53DB04D5, 0x20231C2F, 0x74CC4C43,
    0x55C28534, 0xCC0FC6E5, 0xCEAF2C7A, 0x648D98D4, 0x83C31808, 0x324D9C07, 0x7A1532D6, 0x4047E976,
    0xBDBD90EC, 0xA683672A, 0x26944C33, 0xC07F45A8, 0x2524DAEF, 0xF99AE7FD, 0x7D2A9BFD, 0x2F2DECBE,
    0x5FD067BD, 0x626460EC, 0x0EFC5784, 0x5F42A2FD, 0x9FAF79DE, 0xDBA7B2D9, 0x0000C0EE, 0x00000000,
    0x28120030, 0x85178D01, 0xD816611D, 0xE11B276A, 0x0DA64883, 0xDB3C5FEC, 0xDE5FD410, 0x7D7E2984,
    0x4E28F0B9, 0xBDE4A13D, 0x5923B88A, 0x9E63BC1C, 0x03352077, 0x1C0F7515, 0x50612C7B, 0x3BCBCF33,
    0x44BCD0AA, 0xFFABC06B, 0x7F0E9AF3, 0x1683C5FF, 0xB82299E6, 0x452658DA, 0x84771CB3, 0x8C7677FC,
    0xDB0EB1AF, 0xFFE7A03C, 0x6E3158FC, 0x8D2B9269, 0x5B6482A5, 0x0078C731, 0x00000000, 0x29BC0000,
};


const UINT32 table_sgen_golden_values[64] =
{
    0x0FE50FE5, 0x285E1C44, 0x3F4A285E, 0x53C73414,
    0x650C3F4A, 0x726F49E3, 0x7B6C53C7, 0x7FAB5CDC,
    0x7F02650C, 0x79776C43, 0x6F42726F, 0x60C67781,
    0x4E917B6C, 0x39587E27, 0x21EB7FAB, 0x09307FF4,
    0xF01A7F02, 0xD7A17CD6, 0xC0B67977, 0xAC3874ED,
    0x9AF36F42, 0x8D906884, 0x849360C6, 0x80545818,
    0x80FD4E91, 0x86884449, 0x90BD3958, 0x9F3A2DDA,
    0xB16E21EB, 0xC6A715A8, 0xDE140930, 0xF6CFFCA1,
    0x0FE5F01A, 0x285EE3BB, 0x3F4AD7A1, 0x53C7CBEB,
    0x650CC0B6, 0x726FB61C, 0x7B6CAC38, 0x7FABA323,
    0x7F029AF3, 0x797793BC, 0x6F428D90, 0x60C6887E,
    0x4E918493, 0x395881D8, 0x21EB8054, 0x0930800B,
    0xF01A80FD, 0xD7A18329, 0xC0B68688, 0xAC388B12,
    0x9AF390BD, 0x8D90977B, 0x84939F3A, 0x8054A7E7,
    0x80FDB16E, 0x8688BBB6, 0x90BDC6A7, 0x9F3AD225,
    0xB16EDE14, 0xC6A7EA57, 0xDE14F6CF, 0xF6CF035E
};


const UINT32 table_sgen_golden_values_ch1_duplicate[64] =
{
    0x0FE50FE5, 0x1C441C44, 0x285E285E, 0x34143414,
    0x3F4A3F4A, 0x49E349E3, 0x53C753C7, 0x5CDC5CDC,
    0x650C650C, 0x6C436C43, 0x726F726F, 0x77817781,
    0x7B6C7B6C, 0x7E277E27, 0x7FAB7FAB, 0x7FF47FF4,
    0x7F027F02, 0x7CD67CD6, 0x79777977, 0x74ED74ED,
    0x6F426F42, 0x68846884, 0x60C660C6, 0x58185818,
    0x4E914E91, 0x44494449, 0x39583958, 0x2DDA2DDA,
    0x21EB21EB, 0x15A815A8, 0x09300930, 0xFCA1FCA1,
    0xF01AF01A, 0xE3BBE3BB, 0xD7A1D7A1, 0xCBEBCBEB,
    0xC0B6C0B6, 0xB61CB61C, 0xAC38AC38, 0xA323A323,
    0x9AF39AF3, 0x93BC93BC, 0x8D908D90, 0x887E887E,
    0x84938493, 0x81D881D8, 0x80548054, 0x800B800B,
    0x80FD80FD, 0x83298329, 0x86888688, 0x8B128B12,
    0x90BD90BD, 0x977B977B, 0x9F3A9F3A, 0xA7E7A7E7,
    0xB16EB16E, 0xBBB6BBB6, 0xC6A7C6A7, 0xD225D225,
    0xDE14DE14, 0xEA57EA57, 0xF6CFF6CF, 0x035E035E
};

BOOL check_bit_true(UINT32 u4PhyBufBase, UINT32 u4PhyBufEnd, const UINT32 *golden_table, UINT32 table_size)
{
    BOOL retval = FALSE;
    BOOL flag_start = FALSE;

    unsigned int addr;
    unsigned int revice_val;

    unsigned int idx_table = 0;
    unsigned int cnt = 1;

    UINT32 u4VirBufBase = u4BufPhyAddr2VirAddr(u4PhyBufBase);
    UINT32 u4VirBufEnd  = u4BufPhyAddr2VirAddr(u4PhyBufEnd);

    for(addr=u4VirBufBase; addr<u4VirBufEnd; addr+=4)
    {
        revice_val = ReadREG(addr);

        if (!flag_start && revice_val == 0 ) continue;
        flag_start = TRUE;

        if (revice_val == 0) break;

        //printk("\t\t[0x%x] 0x%x, golden=0x%x\n", addr, revice_val, golden_table[num_line]);

        if (revice_val != golden_table[idx_table++])
        {
            printk("[%d]revice_val %x !=  golden %x\n", cnt, revice_val,  golden_table[idx_table-1]);
            retval = FALSE;
            return retval;
        }
        else
        {
            retval = TRUE;
        }

        if (idx_table == table_size)
        {
            idx_table = 0;
        }
        cnt++;
    }

    return retval;
}

BOOL check_bit_true_stress(UINT32 u4PhyBufBase, UINT32 u4PhyBufEnd, const UINT32 *golden_table, UINT32 table_size)
{
    static BOOL retval = FALSE;

    static unsigned int idx_table = 0;

    unsigned int addr;
    unsigned int revice_val;

    UINT32 u4VirBufBase = u4BufPhyAddr2VirAddr(u4PhyBufBase);
    UINT32 u4VirBufEnd  = u4BufPhyAddr2VirAddr(u4PhyBufEnd);

    for(addr=u4VirBufBase; addr<u4VirBufEnd; addr+=4)
    {
        revice_val = ReadREG(addr);

        if (revice_val == 0) break;

        //printk("\t\t[0x%x] 0x%x, golden=0x%x\n", addr, revice_val, golden_table[idx_table]);

        if (revice_val != golden_table[idx_table])
        {
            printk("[0x%x] revice_val 0x%x !=  golden 0x%x\n", addr, revice_val,  golden_table[idx_table]);
            retval = FALSE;
            break;
        }
        else
        {
            retval = TRUE;
            idx_table++;
        }

        if (idx_table == table_size) idx_table = 0;
    }

    if (!retval)
    {
        idx_table = 0;
    }

    return retval;
}

