#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>

#include <mach/mt_typedefs.h>
#include <mach/mt_power_gs.h>

const unsigned int mt8127_power_gs_2g_paging_data[] = {
    0xf0000004, 0x0000ff9f, 0x00000080,
    0xf000000C, 0x00000001, 0x00000000,
    0xf0000040, 0x87818107, 0x00810106,
    0xf0000050, 0x87878f83, 0x80818180,
    0xf0000060, 0x87838781, 0x81818180,
    0xf0000070, 0x87818787, 0x81808181,
    0xf0000080, 0x000083cf, 0x00000380,
    0xf0000200, 0x000003ff, 0x000003ff,
    0xf0000204, 0x00000011, 0x00000011,
    0xf0001008, 0x0000001f, 0x00000000,
    0xf0001010, 0x00000007, 0x00000007,
    0xf0001014, 0x00000001, 0x00000001,
    0xf0001048, 0x0091b1e7, 0x0001b1e6,
    0xf0001050, 0x00000303, 0x00000303,
    0xf0001054, 0x0000037f, 0x00000300,
    0xf0001058, 0x001f0f07, 0x00100000,
    0xf0003018, 0x03ffffff, 0x02fef7fd,
    0xf0003030, 0x03ffffff, 0x03ffffff,
    0xf0003050, 0x00001ff3, 0x000000f3,
    0xf0003054, 0x000000ff, 0x000000f0,
    0xf0003058, 0x001f0f07, 0x00000000,
    0xf00041DC, 0x03000000, 0x03000000,
    0xf000F800, 0x00000001, 0x00000000,
    0xf020005C, 0x00000200, 0x00000200,
    0xf0208000, 0x00001000, 0x00001000,
    0xf0209004, 0x00ff03f3, 0x00000000,
    0xf0209008, 0x00000007, 0x00000000,
    0xf020900C, 0x0079ce7f, 0x00780000,
    0xf0209018, 0x00ff00ff, 0x00050001,
    0xf0209024, 0x000fffff, 0x00088888,
    0xf0209210, 0x00000001, 0x00000000,
    0xf0209220, 0x00000001, 0x00000000,
    0xf0209230, 0x00000001, 0x00000000,
    0xf0209240, 0x00000001, 0x00000000,
    0xf020924C, 0x00000003, 0x00000002,
    0xf1220000, 0x00000044, 0x00000044,
    0xf3000000, 0x00000001, 0x00000001,
    0xf300000C, 0x00000000, 0x00000000,
    0xf3000010, 0x0001ff7f, 0x0001c03f,
    0xf4000100, 0x0007ffff, 0x0007ffff,
    0xf4000110, 0x0000000f, 0x0000000f,
    0xf4000120, 0xffffffff, 0x00000000,
    0xf4000124, 0xffffffff, 0x00000000,
    0xf4000128, 0xffffffff, 0x00000000,
    0xf400012C, 0xffffffff, 0x00000000,
    0xf4000130, 0xffffffff, 0x00000000,
    0xf4000134, 0xffffffff, 0x00000000,
    0xf5000000, 0x000003e1, 0x000003e1,
    0xf5009094, 0xffffffff, 0xffffffff,
    0xf50090EC, 0x00000001, 0x00000000,
    0xf50090F4, 0x00000001, 0x00000001,
    0xf500A300, 0x00000001, 0x00000000,
    0xf6000000, 0x00000100, 0x00000000,
    0xf6000008, 0x00000001, 0x00000000,
    0xf6000010, 0x00000001, 0x00000001,
    0xf6000014, 0x00000001, 0x00000001,
    0xf6000018, 0x00000001, 0x00000000,
};

const unsigned int *mt8127_power_gs_2g_paging = mt8127_power_gs_2g_paging_data;

unsigned int mt8127_power_gs_2g_paging_len = 171;

const unsigned int mt8127_power_gs_2g_talking_data[] = {
    0xf0000004, 0x0000ff9f, 0x00000080,
    0xf000000C, 0x00000001, 0x00000000,
    0xf0000040, 0x87818107, 0x00810106,
    0xf0000050, 0x87878f83, 0x80818180,
    0xf0000060, 0x87838781, 0x81818180,
    0xf0000070, 0x87818787, 0x01008181,
    0xf0000080, 0x000083cf, 0x00000380,
    0xf0000200, 0x000003ff, 0x000003ff,
    0xf0000204, 0x00000011, 0x00000011,
    0xf0001008, 0x0000001f, 0x00000000,
    0xf0001010, 0x00000007, 0x00000007,
    0xf0001014, 0x00000001, 0x00000001,
    0xf0001048, 0x0091b1e7, 0x0001b1c6,
    0xf0001050, 0x00000303, 0x00000303,
    0xf0001054, 0x0000037f, 0x00000300,
    0xf0001058, 0x001f0f07, 0x00100000,
    0xf0003018, 0x03ffffff, 0x02fef7fd,
    0xf0003030, 0x03ffffff, 0x03ffffff,
    0xf0003050, 0x00001ff3, 0x000000f3,
    0xf0003054, 0x000000ff, 0x000000f0,
    0xf0003058, 0x001f0f07, 0x00000000,
    0xf00041DC, 0x03000000, 0x03000000,
    0xf000F800, 0x00000001, 0x00000000,
    0xf020005C, 0x00000200, 0x00000200,
    0xf0208000, 0x00001000, 0x00001000,
    0xf0209004, 0x00ff03f3, 0x00000000,
    0xf0209008, 0x00000007, 0x00000000,
    0xf020900C, 0x0079ce7f, 0x00780000,
    0xf0209018, 0x00ff00ff, 0x00050001,
    0xf0209024, 0x000fffff, 0x00088888,
    0xf0209210, 0x00000001, 0x00000000,
    0xf0209220, 0x00000001, 0x00000000,
    0xf0209230, 0x00000001, 0x00000000,
    0xf0209240, 0x00000001, 0x00000000,
    0xf020924C, 0x00000003, 0x00000002,
    0xf1220000, 0x00000044, 0x00000000,
    0xf3000000, 0x00000001, 0x00000001,
    0xf300000C, 0x00000000, 0x00000000,
    0xf3000010, 0x0001ff7f, 0x0001c03f,
    0xf4000100, 0x0007ffff, 0x0007fff0,
    0xf4000110, 0x0000000f, 0x00000000,
    0xf4000120, 0xffffffff, 0x00000000,
    0xf4000124, 0xffffffff, 0x00000000,
    0xf4000128, 0xffffffff, 0x00000000,
    0xf400012C, 0xffffffff, 0x00000000,
    0xf4000130, 0xffffffff, 0x00000000,
    0xf4000134, 0xffffffff, 0x00000000,
    0xf5000000, 0x000003e1, 0x000003e1,
    0xf5009094, 0xffffffff, 0xffffffff,
    0xf50090EC, 0x00000001, 0x00000000,
    0xf50090F4, 0x00000001, 0x00000001,
    0xf500A300, 0x00000001, 0x00000000,
    0xf6000000, 0x00000100, 0x00000000,
    0xf6000008, 0x00000001, 0x00000000,
    0xf6000010, 0x00000001, 0x00000001,
    0xf6000014, 0x00000001, 0x00000001,
    0xf6000018, 0x00000001, 0x00000000,
};

const unsigned int *mt8127_power_gs_2g_talking = mt8127_power_gs_2g_talking_data;

unsigned int mt8127_power_gs_2g_talking_len = 171;

const unsigned int mt8127_power_gs_data_connection_data[] = {
    0xf0000004, 0x0000ff9f, 0x00000080,
    0xf000000C, 0x00000001, 0x00000000,
    0xf0000040, 0x87818107, 0x00810106,
    0xf0000050, 0x87878f83, 0x80818180,
    0xf0000060, 0x87838781, 0x81818180,
    0xf0000070, 0x87818787, 0x81808181,
    0xf0000080, 0x000083cf, 0x00000380,
    0xf0000200, 0x000003ff, 0x000003ff,
    0xf0000204, 0x00000011, 0x00000011,
    0xf0001008, 0x0000001f, 0x00000000,
    0xf0001010, 0x00000007, 0x00000007,
    0xf0001014, 0x00000001, 0x00000001,
    0xf0001048, 0x0091b1e7, 0x0001b1e6,
    0xf0001050, 0x00000303, 0x00000303,
    0xf0001054, 0x0000037f, 0x00000300,
    0xf0001058, 0x001f0f07, 0x00100000,
    0xf0003018, 0x03ffffff, 0x02fef7fd,
    0xf0003030, 0x03ffffff, 0x03ffffff,
    0xf0003050, 0x00001ff3, 0x000000f3,
    0xf0003054, 0x000000ff, 0x000000f0,
    0xf0003058, 0x001f0f07, 0x00000000,
    0xf00041DC, 0x03000000, 0x03000000,
    0xf000F800, 0x00000001, 0x00000000,
    0xf020005C, 0x00000200, 0x00000200,
    0xf0208000, 0x00001000, 0x00001000,
    0xf0209004, 0x00ff03f3, 0x00000000,
    0xf0209008, 0x00000007, 0x00000000,
    0xf020900C, 0x0079ce7f, 0x00780000,
    0xf0209018, 0x00ff00ff, 0x00050001,
    0xf0209024, 0x000fffff, 0x00088888,
    0xf0209210, 0x00000001, 0x00000000,
    0xf0209220, 0x00000001, 0x00000000,
    0xf0209230, 0x00000001, 0x00000000,
    0xf0209240, 0x00000001, 0x00000000,
    0xf020924C, 0x00000003, 0x00000002,
    0xf1220000, 0x00000044, 0x00000044,
    0xf3000000, 0x00000001, 0x00000001,
    0xf300000C, 0x00000000, 0x00000000,
    0xf3000010, 0x0001ff7f, 0x0001c03f,
    0xf4000100, 0x0007ffff, 0x0007ffff,
    0xf4000110, 0x0000000f, 0x0000000f,
    0xf4000120, 0xffffffff, 0x00000000,
    0xf4000124, 0xffffffff, 0x00000000,
    0xf4000128, 0xffffffff, 0x00000000,
    0xf400012C, 0xffffffff, 0x00000000,
    0xf4000130, 0xffffffff, 0x00000000,
    0xf4000134, 0xffffffff, 0x00000000,
    0xf5000000, 0x000003e1, 0x000003e1,
    0xf5009094, 0xffffffff, 0xffffffff,
    0xf50090EC, 0x00000001, 0x00000000,
    0xf50090F4, 0x00000001, 0x00000001,
    0xf500A300, 0x00000001, 0x00000000,
    0xf6000000, 0x00000100, 0x00000000,
    0xf6000008, 0x00000001, 0x00000000,
    0xf6000010, 0x00000001, 0x00000001,
    0xf6000014, 0x00000001, 0x00000001,
    0xf6000018, 0x00000001, 0x00000000,
};

const unsigned int *mt8127_power_gs_data_connection = mt8127_power_gs_data_connection_data;

unsigned int mt8127_power_gs_data_connection_len = 171;

const unsigned int mt8127_power_gs_3g_paging_data[] = {
    0xf0000004, 0x0000ff9f, 0x00000080,
    0xf000000C, 0x00000001, 0x00000000,
    0xf0000040, 0x87818107, 0x00810106,
    0xf0000050, 0x87878f83, 0x80818180,
    0xf0000060, 0x87838781, 0x81818180,
    0xf0000070, 0x87818787, 0x81808181,
    0xf0000080, 0x000083cf, 0x00000380,
    0xf0000200, 0x000003ff, 0x000003ff,
    0xf0000204, 0x00000011, 0x00000011,
    0xf0001008, 0x0000001f, 0x00000000,
    0xf0001010, 0x00000007, 0x00000007,
    0xf0001014, 0x00000001, 0x00000001,
    0xf0001048, 0x0091b1e7, 0x0081b1e6,
    0xf0001050, 0x00000303, 0x00000303,
    0xf0001054, 0x0000037f, 0x00000300,
    0xf0001058, 0x001f0f07, 0x00100000,
    0xf0003018, 0x03ffffff, 0x02fef7fd,
    0xf0003030, 0x03ffffff, 0x03ffffff,
    0xf0003050, 0x00001ff3, 0x000000f3,
    0xf0003054, 0x000000ff, 0x000000f0,
    0xf0003058, 0x001f0f07, 0x00000000,
    0xf00041DC, 0x03000000, 0x03000000,
    0xf000F800, 0x00000001, 0x00000000,
    0xf020005C, 0x00000200, 0x00000200,
    0xf0208000, 0x00001000, 0x00001000,
    0xf0209004, 0x00ff03f3, 0x00000000,
    0xf0209008, 0x00000007, 0x00000000,
    0xf020900C, 0x0079ce7f, 0x00780000,
    0xf0209018, 0x00ff00ff, 0x00050001,
    0xf0209024, 0x000fffff, 0x00088888,
    0xf0209210, 0x00000001, 0x00000000,
    0xf0209220, 0x00000001, 0x00000000,
    0xf0209230, 0x00000001, 0x00000000,
    0xf0209240, 0x00000001, 0x00000000,
    0xf020924C, 0x00000003, 0x00000002,
    0xf1220000, 0x00000044, 0x00000044,
    0xf3000000, 0x00000001, 0x00000001,
    0xf300000C, 0x00000000, 0x00000000,
    0xf3000010, 0x0001ff7f, 0x0001c03f,
    0xf4000100, 0x0007ffff, 0x0007ffff,
    0xf4000110, 0x0000000f, 0x0000000f,
    0xf4000120, 0xffffffff, 0x00000000,
    0xf4000124, 0xffffffff, 0x00000000,
    0xf4000128, 0xffffffff, 0x00000000,
    0xf400012C, 0xffffffff, 0x00000000,
    0xf4000130, 0xffffffff, 0x00000000,
    0xf4000134, 0xffffffff, 0x00000000,
    0xf5000000, 0x000003e1, 0x000003e1,
    0xf5009094, 0xffffffff, 0xffffffff,
    0xf50090EC, 0x00000001, 0x00000000,
    0xf50090F4, 0x00000001, 0x00000001,
    0xf500A300, 0x00000001, 0x00000000,
    0xf6000000, 0x00000100, 0x00000000,
    0xf6000008, 0x00000001, 0x00000000,
    0xf6000010, 0x00000001, 0x00000001,
    0xf6000014, 0x00000001, 0x00000001,
    0xf6000018, 0x00000001, 0x00000000,
};

const unsigned int *mt8127_power_gs_3g_paging = mt8127_power_gs_3g_paging_data;

unsigned int mt8127_power_gs_3g_paging_len = 171;

const unsigned int mt8127_power_gs_3g_talking_data[] = {
    0xf0000004, 0x0000ff9f, 0x00000080,
    0xf000000C, 0x00000001, 0x00000000,
    0xf0000040, 0x87818107, 0x00810106,
    0xf0000050, 0x87878f83, 0x80818180,
    0xf0000060, 0x87838781, 0x81818180,
    0xf0000070, 0x87818787, 0x01008181,
    0xf0000080, 0x000083cf, 0x00000380,
    0xf0000200, 0x000003ff, 0x000003ff,
    0xf0000204, 0x00000011, 0x00000011,
    0xf0001008, 0x0000001f, 0x00000000,
    0xf0001010, 0x00000007, 0x00000007,
    0xf0001014, 0x00000001, 0x00000001,
    0xf0001048, 0x0091b1e7, 0x0001b1c6,
    0xf0001050, 0x00000303, 0x00000303,
    0xf0001054, 0x0000037f, 0x00000300,
    0xf0001058, 0x001f0f07, 0x00100000,
    0xf0003018, 0x03ffffff, 0x02fef7fd,
    0xf0003030, 0x03ffffff, 0x03ffffff,
    0xf0003050, 0x00001ff3, 0x000000f3,
    0xf0003054, 0x000000ff, 0x000000f0,
    0xf0003058, 0x001f0f07, 0x00000000,
    0xf00041DC, 0x03000000, 0x03000000,
    0xf000F800, 0x00000001, 0x00000000,
    0xf020005C, 0x00000200, 0x00000200,
    0xf0208000, 0x00001000, 0x00001000,
    0xf0209004, 0x00ff03f3, 0x00000000,
    0xf0209008, 0x00000007, 0x00000000,
    0xf020900C, 0x0079ce7f, 0x00780000,
    0xf0209018, 0x00ff00ff, 0x00050001,
    0xf0209024, 0x000fffff, 0x00088888,
    0xf0209210, 0x00000001, 0x00000000,
    0xf0209220, 0x00000001, 0x00000000,
    0xf0209230, 0x00000001, 0x00000000,
    0xf0209240, 0x00000001, 0x00000000,
    0xf020924C, 0x00000003, 0x00000002,
    0xf1220000, 0x00000044, 0x00000000,
    0xf3000000, 0x00000001, 0x00000001,
    0xf300000C, 0x00000000, 0x00000000,
    0xf3000010, 0x0001ff7f, 0x0001c03f,
    0xf4000100, 0x0007ffff, 0x0007ffff,
    0xf4000110, 0x0000000f, 0x0000000f,
    0xf4000120, 0xffffffff, 0x00000000,
    0xf4000124, 0xffffffff, 0x00000000,
    0xf4000128, 0xffffffff, 0x00000000,
    0xf400012C, 0xffffffff, 0x00000000,
    0xf4000130, 0xffffffff, 0x00000000,
    0xf4000134, 0xffffffff, 0x00000000,
    0xf5000000, 0x000003e1, 0x000003e1,
    0xf5009094, 0xffffffff, 0xffffffff,
    0xf50090EC, 0x00000001, 0x00000000,
    0xf50090F4, 0x00000001, 0x00000001,
    0xf500A300, 0x00000001, 0x00000000,
    0xf6000000, 0x00000100, 0x00000000,
    0xf6000008, 0x00000001, 0x00000000,
    0xf6000010, 0x00000001, 0x00000001,
    0xf6000014, 0x00000001, 0x00000001,
    0xf6000018, 0x00000001, 0x00000000,
};

const unsigned int *mt8127_power_gs_3g_talking = mt8127_power_gs_3g_talking_data;

unsigned int mt8127_power_gs_3g_talking_len = 171;

const unsigned int mt8127_power_gs_connsys_data[] = {
    0xf0000004, 0x0000ff9f, 0x00000080,
    0xf000000C, 0x00000001, 0x00000000,
    0xf0000040, 0x87818107, 0x00810106,
    0xf0000050, 0x87878f83, 0x80818180,
    0xf0000060, 0x87838781, 0x81818180,
    0xf0000070, 0x87818787, 0x81808181,
    0xf0000080, 0x000083af, 0x00000380,
    0xf0000200, 0x000003ff, 0x000003ff,
    0xf0000204, 0x00000011, 0x00000011,
    0xf0001008, 0x0000001f, 0x00000000,
    0xf0001010, 0x00000007, 0x00000007,
    0xf0001014, 0x00000001, 0x00000001,
    0xf0001048, 0x0091b1e7, 0x0001b1e6,
    0xf0001050, 0x00000303, 0x00000303,
    0xf0001054, 0x0000037f, 0x00000300,
    0xf0001058, 0x001f0f07, 0x00100000,
    0xf0003018, 0x03ffffff, 0x02fef7fd,
    0xf0003030, 0x03ffffff, 0x03ffffff,
    0xf0003050, 0x00001ff3, 0x000000f3,
    0xf0003054, 0x000000ff, 0x000000f0,
    0xf0003058, 0x001f0f07, 0x00000000,
    0xf00041DC, 0x03000000, 0x03000000,
    0xf000F800, 0x00000001, 0x00000000,
    0xf020005C, 0x00000200, 0x00000200,
    0xf0208000, 0x00001000, 0x00001000,
    0xf0209004, 0x00ff03f3, 0x00000000,
    0xf0209008, 0x00000007, 0x00000000,
    0xf020900C, 0x0079ce7f, 0x00780000,
    0xf0209018, 0x00ff00ff, 0x00050001,
    0xf0209024, 0x000fffff, 0x00088888,
    0xf0209210, 0x00000001, 0x00000000,
    0xf0209220, 0x00000001, 0x00000000,
    0xf0209230, 0x00000001, 0x00000000,
    0xf0209240, 0x00000001, 0x00000000,
    0xf020924C, 0x00000003, 0x00000002,
    0xf1220000, 0x00000044, 0x00000044,
    0xf3000000, 0x00000001, 0x00000001,
    0xf300000C, 0x00000000, 0x00000000,
    0xf3000010, 0x0001ff7f, 0x0001c03f,
    0xf4000100, 0x0007ffff, 0x0007ffff,
    0xf4000110, 0x0000000f, 0x0000000f,
    0xf4000120, 0xffffffff, 0x00000000,
    0xf4000124, 0xffffffff, 0x00000000,
    0xf4000128, 0xffffffff, 0x00000000,
    0xf400012C, 0xffffffff, 0x00000000,
    0xf4000130, 0xffffffff, 0x00000000,
    0xf4000134, 0xffffffff, 0x00000000,
    0xf5000000, 0x000003e1, 0x000003e1,
    0xf5009094, 0xffffffff, 0xffffffff,
    0xf50090EC, 0x00000001, 0x00000000,
    0xf50090F4, 0x00000001, 0x00000001,
    0xf500A300, 0x00000001, 0x00000000,
    0xf6000000, 0x00000100, 0x00000000,
    0xf6000008, 0x00000001, 0x00000000,
    0xf6000010, 0x00000001, 0x00000001,
    0xf6000014, 0x00000001, 0x00000001,
    0xf6000018, 0x00000001, 0x00000000,
};

const unsigned int *mt8127_power_gs_connsys = mt8127_power_gs_connsys_data;

unsigned int mt8127_power_gs_connsys_len = 171;

const unsigned int mt8127_power_gs_dpidle_data[] = {
    0xF0001048, 0x00CDB1E3, 0x000CB0A0,/*CLOCK GATE*/
    0xF1220000, 0x00780042, 0x00000000,
    0xF0003018, 0xFFFFFFFF, 0x1FFDFFFD,/*auxadc can be off?*/
    0xF000301C, 0x00000007, 0x00000007,
    0xF0000004, 0x0000FF9F, 0x00000000,/*topckgen*//*ignore bit 7*/
    0xF0000200, 0x000003FF, 0x000003FF,
    0xF0000204, 0x00000011, 0x00000011,
    0xf0000040, 0x87818107, 0x81010101,/*ignore bit 0 1 2 23 24 31*/
    0xf0000050, 0x80808080, 0x80808080,
    0xf0000060, 0x80808080, 0x80808080,
    0xf0000070, 0x80808080, 0x80808080,
    0xf0000080, 0x000083cf, 0x00000180,/*ignore bit 7 9*/
    0xF0000090, 0x87808387, 0x81808186,
    0xF00000A0, 0x00808780, 0x00808100,
    0xF0209600, 0x000000C0, 0x000000C0,/*ACD*/
    0xF0209250, 0x00000001, 0x00000000,/*ignore?*/
    0xF0209260, 0x00000001, 0x00000000,/*ignore?*/
    0xF0209270, 0x00000001, 0x00000000,/*ignore?*/
    0xF0209220, 0x00000001, 0x00000000,/*ignore?*/
    0xF0209230, 0x00000001, 0x00000000,/*ignore?*/
    0xF0209240, 0x00000001, 0x00000000,/*ignore?*/
    0xF0010404, 0x00C00000, 0x00000000,
    0xF0010408, 0x00007FE0, 0x00000000,
    0xF0010418, 0x00000080, 0x00000000,
    0xF0209100, 0xFFFFF000, 0x00000000,
    0xF0209108, 0x00000041, 0x00000000,
    0xF0209118, 0x80000000, 0x00000000,
    0xF020911C, 0x00000100, 0x00000000,
    0xF0010044, 0xFFFFFFFF, 0x88492480,
    0xF0010040, 0xFFFFFFFF, 0x00000080,
    0xF0010000, 0xFFFFFFFF, 0x00000400,
    0xF0010004, 0x00000001, 0x00000000,/*bit0 is enough*/
    0xF0010008, 0xFFFFFFFF, 0x00000400,
    0xF001000C, 0xFFFFFFFF, 0x00000100,
    0xF0010010, 0xFFFFFFFF, 0x00000100,
    0xF0010014, 0xFFFFFFFF, 0x00000100,
    0xF0010068, 0xFFFFFFFF, 0x00000002,
    0xF0010050, 0xFFFFFFFF, 0x00000000,
    0xF0010824, 0xFFFFFFFF, 0x24248800,
    0xF0010820, 0x00FFFFFF, 0x00000000,
    0xF0010800, 0xFFFFFFFF, 0x00008000,
    0xF0010804, 0xFFFFFFFF, 0x00008000,
    0xF0010808, 0xFFFFFFFF, 0x00008000,
    0xF001080C, 0xFFFFFFFF, 0x00008000,
    0xF0010810, 0xFFFFFFFF, 0x00008000,
};

const unsigned int *mt8127_power_gs_dpidle = mt8127_power_gs_dpidle_data;

unsigned int mt8127_power_gs_dpidle_len = sizeof(mt8127_power_gs_dpidle_data)/sizeof(mt8127_power_gs_dpidle_data[0]);

const unsigned int mt8127_power_gs_idle_data[] = {
    0xf0000004, 0x0000ff9f, 0x00000080,
    0xf000000C, 0x00000001, 0x00000000,
    0xf0000040, 0x87818107, 0x00810106,
    0xf0000050, 0x87878f83, 0x80818180,
    0xf0000060, 0x87838781, 0x81818180,
    0xf0000070, 0x87818787, 0x81808181,
    0xf0000080, 0x000083cf, 0x00000380,
    0xf0000200, 0x000003ff, 0x000003ff,
    0xf0000204, 0x00000011, 0x00000011,
    0xf0001008, 0x0000001f, 0x00000000,
    0xf0001010, 0x00000007, 0x00000007,
    0xf0001014, 0x00000001, 0x00000001,
    0xf0001048, 0x0091bfe7, 0x0000b1e6,
    0xf0001050, 0x00000303, 0x00000303,
    0xf0001054, 0x0000037f, 0x00000300,
    0xf0001058, 0x001f0f07, 0x00100000,
    0xf0003018, 0x03ffffff, 0x02def7fd,
    0xf0003030, 0x03ffffff, 0x03ffffff,
    0xf0003050, 0x00001ff3, 0x000000f3,
    0xf0003054, 0x000000ff, 0x000000f0,
    0xf0003058, 0x001f0f07, 0x00000000,
    0xf00041DC, 0x03000000, 0x03000000,
    0xf000F800, 0x00000001, 0x00000000,
    0xf020005C, 0x00000200, 0x00000200,
    0xf0208000, 0x00001000, 0x00001000,
    0xf0209004, 0x00ff03f3, 0x00000000,
    0xf0209008, 0x00000007, 0x00000000,
    0xf020900C, 0x0079ce7f, 0x00780000,
    0xf0209018, 0x00ff00ff, 0x00050001,
    0xf0209024, 0x000fffff, 0x00088888,
    0xf0209210, 0x00000001, 0x00000000,
    0xf0209220, 0x00000001, 0x00000000,
    0xf0209230, 0x00000001, 0x00000000,
    0xf0209240, 0x00000001, 0x00000000,
    0xf020924C, 0x00000003, 0x00000002,
    0xf1220000, 0x00000044, 0x00000044,
    0xf3000000, 0x00000001, 0x00000001,
    0xf300000C, 0x00000000, 0x00000000,
    0xf3000010, 0x0001ff7f, 0x0001c03f,
    0xf4000100, 0x0007ffff, 0x0007ffff,
    0xf4000110, 0x0000000f, 0x0000000f,
    0xf4000120, 0xffffffff, 0x00000000,
    0xf4000124, 0xffffffff, 0x00000000,
    0xf4000128, 0xffffffff, 0x00000000,
    0xf400012C, 0xffffffff, 0x00000000,
    0xf4000130, 0xffffffff, 0x00000000,
    0xf4000134, 0xffffffff, 0x00000000,
    0xf5000000, 0x000003e1, 0x000003e1,
    0xf5009094, 0xffffffff, 0xffffffff,
    0xf50090EC, 0x00000001, 0x00000000,
    0xf50090F4, 0x00000001, 0x00000001,
    0xf500A300, 0x00000001, 0x00000000,
    0xf6000000, 0x00000100, 0x00000000,
    0xf6000008, 0x00000001, 0x00000000,
    0xf6000010, 0x00000001, 0x00000001,
    0xf6000014, 0x00000001, 0x00000001,
    0xf6000018, 0x00000001, 0x00000000,
};

const unsigned int *mt8127_power_gs_idle = mt8127_power_gs_idle_data;

unsigned int mt8127_power_gs_idle_len = 171;

const unsigned int mt8127_power_gs_audio_playback_data[] = {
    0xf0000004, 0x0000ff9f, 0x00000080,
    0xf000000C, 0x00000001, 0x00000000,
    0xf0000040, 0x87818107, 0x00810106,
    0xf0000050, 0x87878f83, 0x80818180,
    0xf0000060, 0x87838781, 0x81818180,
    0xf0000070, 0x87818787, 0x00008101,
    0xf0000080, 0x000083cf, 0x00000380,
    0xf0000200, 0x000003ff, 0x000003ff,
    0xf0000204, 0x00000011, 0x00000011,
    0xf0001008, 0x0000001f, 0x00000000,
    0xf0001010, 0x00000007, 0x00000007,
    0xf0001014, 0x00000001, 0x00000001,
    0xf0001048, 0x0091b1e7, 0x0001b1c6,
    0xf0001050, 0x00000303, 0x00000303,
    0xf0001054, 0x0000037f, 0x00000300,
    0xf0001058, 0x001f0f07, 0x00100000,
    0xf0003018, 0x03ffffff, 0x02fef7fd,
    0xf0003030, 0x03ffffff, 0x03ffffff,
    0xf0003050, 0x00001ff3, 0x000000f3,
    0xf0003054, 0x000000ff, 0x000000f0,
    0xf0003058, 0x001f0f07, 0x00000000,
    0xf00041DC, 0x03000000, 0x03000000,
    0xf000F800, 0x00000001, 0x00000000,
    0xf020005C, 0x00000200, 0x00000200,
    0xf0208000, 0x00001000, 0x00001000,
    0xf0209004, 0x00ff03f3, 0x00000000,
    0xf0209008, 0x00000007, 0x00000000,
    0xf020900C, 0x0079ce7f, 0x00780000,
    0xf0209018, 0x00ff00ff, 0x00050001,
    0xf0209024, 0x000fffff, 0x00088888,
    0xf0209210, 0x00000001, 0x00000001,
    0xf0209220, 0x00000001, 0x00000000,
    0xf0209230, 0x00000001, 0x00000000,
    0xf0209240, 0x00000001, 0x00000001,
    0xf020924C, 0x00000003, 0x00000002,
    0xf1220000, 0x00000044, 0x00000000,
    0xf3000000, 0x00000001, 0x00000001,
    0xf300000C, 0x00000000, 0x00000000,
    0xf3000010, 0x0001ff7f, 0x0001c03f,
    0xf4000100, 0x0007ffff, 0x0007ffff,
    0xf4000110, 0x0000000f, 0x0000000f,
    0xf4000120, 0xffffffff, 0x00000000,
    0xf4000124, 0xffffffff, 0x00000000,
    0xf4000128, 0xffffffff, 0x00000000,
    0xf400012C, 0xffffffff, 0x00000000,
    0xf4000130, 0xffffffff, 0x00000000,
    0xf4000134, 0xffffffff, 0x00000000,
    0xf5000000, 0x000003e1, 0x000003e1,
    0xf5009094, 0xffffffff, 0xffffffff,
    0xf50090EC, 0x00000001, 0x00000000,
    0xf50090F4, 0x00000001, 0x00000001,
    0xf500A300, 0x00000001, 0x00000000,
    0xf6000000, 0x00000100, 0x00000000,
    0xf6000008, 0x00000001, 0x00000000,
    0xf6000010, 0x00000001, 0x00000001,
    0xf6000014, 0x00000001, 0x00000001,
    0xf6000018, 0x00000001, 0x00000000,
};

const unsigned int *mt8127_power_gs_audio_playback = mt8127_power_gs_audio_playback_data;

unsigned int mt8127_power_gs_audio_playback_len = 171;

const unsigned int mt8127_power_gs_suspend_data[] = {
    0xF0001048, 0x00CDB1E3, 0x000CB0A0,/*CLOCK GATE*/
    0xF0003018, 0xFFFFFFFF, 0x1FFDFFFD,/*auxadc can be off?*/
    0xF000301C, 0x00000007, 0x00000007,
    0xF0000004, 0x0000FF9F, 0x00000000,/*topckgen*//*ignore bit 7*/
    0xF000000C, 0x00000001, 0x00000000,
    0xF0000200, 0x000003FF, 0x000003FF,
    0xF0000204, 0x00000011, 0x00000011,
    0xf0000040, 0x87818107, 0x81010101,/*ignore bit 0 1 2 23 24 31*/
    0xf0000050, 0x80808080, 0x80808080,
    0xf0000060, 0x80808080, 0x80808080,
    0xf0000070, 0x80808080, 0x80808080,
    0xf0000080, 0x000083cf, 0x00000180,/*ignore bit 9*/
    0xF0000090, 0x87808387, 0x81808186,
    0xF00000A0, 0x00808780, 0x00808100,
    0xF0209600, 0x000000C0, 0x000000C0,/*ACD*/
    0xF0209250, 0x00000001, 0x00000000,
    0xF0209260, 0x00000001, 0x00000000,
    0xF0209270, 0x00000001, 0x00000000,
    0xF0209220, 0x00000001, 0x00000000,
    0xF0209230, 0x00000001, 0x00000000,
    0xF0209240, 0x00000001, 0x00000000,
    0xF0010404, 0x00C00000, 0x00000000,
    0xF0010408, 0x00007FE0, 0x00000000,
    0xF0010418, 0x00000080, 0x00000000,
    0xF0209100, 0xFFFFF000, 0x00000000,
    0xF0209108, 0x00000041, 0x00000000,
    0xF0209118, 0x80000000, 0x00000000,
    0xF020911C, 0x00000100, 0x00000000,
    0xF0010044, 0xFFFFFFFF, 0x88492480,
    0xF0010040, 0xFFFFFFFF, 0x00000080,
    0xF0010000, 0xFFFFFFFF, 0x00000400,
    0xF0010004, 0x00000001, 0x00000000,/*bit0 is enough*/
    0xF0010008, 0xFFFFFFFF, 0x00000400,
    0xF001000C, 0xFFFFFFFF, 0x00000100,
    0xF0010010, 0xFFFFFFFF, 0x00000100,
    0xF0010014, 0xFFFFFFFF, 0x00000100,
    0xF0010068, 0xFFFFFFFF, 0x00000002,
    0xF0010050, 0xFFFFFFFF, 0x00000000,
    0xF0010824, 0xFFFFFFFF, 0x24248800,
    0xF0010820, 0x00FFFFFF, 0x00000000,
    0xF0010800, 0xFFFFFFFF, 0x00008000,
    0xF0010804, 0xFFFFFFFF, 0x00008000,
    0xF0010808, 0xFFFFFFFF, 0x00008000,
    0xF001080C, 0xFFFFFFFF, 0x00008000,
    0xF0010810, 0xFFFFFFFF, 0x00008000,
	  
  /*
    0xF0209000, 0x00000001, 0x00000000, //appll
    0xF0209210, 0x00000001, 0x00000000, //mainpll
    0xF0209200, 0x00000001, 0x00000000, //armpll
    0xF000F604, 0x00004000, 0x00000000, //mempll
    0xF000F600, 0x00000004, 0x00000000,
    0xF000F60C, 0x00040000, 0x00000000,
    0xF000F614, 0x00040000, 0x00000000,
    0xF000F61C, 0x00040000, 0x00000000,
	  
    0xF1220000, 0x00078044, 0x00078044,	  //AUDIO: can be ignored as long as 0xf0000070 bit 23,31 is 1 
    
    0xF3000000, 0x00000001, 0x00000001, //subsys cg ignored start
    0xF6000000, 0x00000100, 0x00000000,
    0xF6000008, 0x00000001, 0x00000000,
    0xF4000100, 0x000FFFFF, 0x000FFFFF,
    0xF4000110, 0x00003FFF, 0x00003FFF,
    0xF5000000, 0x000003E1, 0x000003E1,//subsys cg ignored end
         
    0xF0003030, 0x03FFFFFF, 0x03FFFFFF,//module golden-setting
    0xF0003038, 0x00000003, 0x00000003,
    0xF0003208, 0x80000000, 0x00000000,
    0xF0003050, 0x00001FF3, 0x000000F3,
    0xF0003054, 0x000000FF, 0x000000F0,
    0xF0003058, 0x001F0F07, 0x00000000,
    0xF0001008, 0x0000001F, 0x00000000,
    0xF0001010, 0x00000007, 0x00000007,
    0xF0001014, 0x00000001, 0x00000001,
    0xF0001040, 0x0091BFE3, 0x0080BFE2,
    0xF0001044, 0x0091BFE3, 0x00000000,
    0xF0001050, 0x00000303, 0x00000303,
    0xF0001054, 0x0000037F, 0x00000300,
    0xF0001058, 0x001F0F07, 0x00100000,
    0xF00041DC, 0x03000000, 0x03000000,
    0xF300000C, 0x00000000, 0x00000000,
    0xF3000010, 0x0001FF7F, 0x0001C03F,
    0xF500A000, 0x00000200, 0x00000200,
    0xF500A300, 0x00000001, 0x00000000,
    0xF5009094, 0xFFFFFFFF, 0xFFFFFFFF,
    0xF50090EC, 0x00000001, 0x00000000,
    0xF50090F4, 0x00000001, 0x00000001,
    0xF4000120, 0xFFFFFFFF, 0x00000000,
    0xF4000124, 0xFFFFFFFF, 0x00000000,
    0xF4000128, 0xFFFFFFFF, 0x00000000,
    0xF400012C, 0xFFFFFFFF, 0x00000000,
    0xF4000130, 0xFFFFFFFF, 0x00000000,
    0xF4000134, 0xFFFFFFFF, 0x00000000,
    0xF6000018, 0x00000001, 0x00000000,
    0xF6000010, 0x00000001, 0x00000001,
    0xF6000014, 0x00000001, 0x00000001,
    0xF0000004, 0x0000FF9F, 0x00000080,
    0xF000000C, 0x00000001, 0x00000000,
    0xF0000200, 0x000003FF, 0x000003FF,
    0xF0000204, 0x00000011, 0x00000011,
    0xF0000040, 0x87818107, 0x00810106,
    0xF0000050, 0x87878F83, 0x80818180,
    0xF0000060, 0x87838781, 0x81818180,
    0xF0000070, 0x87818787, 0x81808181,
    0xF0000080, 0x000083EF, 0x000003E0,
    0xF000F800, 0x00000001, 0x00000000,
    0xF0209004, 0x00FF03F3, 0x00000000,
    0xF0209008, 0x00000007, 0x00000000,
    0xF020900C, 0x0079CE7F, 0x00780000,
    0xF0209018, 0x00FF00FF, 0x00050001,
    0xF0209024, 0x000FFFFF, 0x00088888,
    0xF0209210, 0x00000001, 0x00000000,
    0xF0209220, 0x00000001, 0x00000000,
    0xF0209230, 0x00000001, 0x00000000,
    0xF0209240, 0x00000001, 0x00000000,
    0xF020924C, 0x00000003, 0x00000002,
    0xF0208000, 0x00001000, 0x00001000,
    0xF020005C, 0x00000200, 0x00000200,
    0xF0003008, 0x03FFFFFF, 0x02FFFFFF,
    0xF0003010, 0x03FFFFFF, 0x00000000,
    0xF600000C, 0x00000001, 0x00000000,
    0xF5000004, 0x000001FF, 0x000001FF,
*/
};

const unsigned int *mt8127_power_gs_suspend = mt8127_power_gs_suspend_data;

unsigned int mt8127_power_gs_suspend_len = sizeof(mt8127_power_gs_suspend_data)/sizeof(mt8127_power_gs_suspend_data[0]);

const unsigned int mt8127_power_gs_tdd_paging_data[] = {
    0xf0000004, 0x0000ff9f, 0x00000080,
    0xf000000C, 0x00000001, 0x00000000,
    0xf0000040, 0x87818107, 0x00810106,
    0xf0000050, 0x87878f83, 0x80818180,
    0xf0000060, 0x87838781, 0x81818180,
    0xf0000070, 0x87818787, 0x81808181,
    0xf0000080, 0x000083cf, 0x00000380,
    0xf0000200, 0x000003ff, 0x000003ff,
    0xf0000204, 0x00000011, 0x00000011,
    0xf0001008, 0x0000001f, 0x00000000,
    0xf0001010, 0x00000007, 0x00000007,
    0xf0001014, 0x00000001, 0x00000001,
    0xf0001048, 0x0091b1e7, 0x0001b1e6,
    0xf0001050, 0x00000303, 0x00000303,
    0xf0001054, 0x0000037f, 0x00000300,
    0xf0001058, 0x001f0f07, 0x00100000,
    0xf0003018, 0x03ffffff, 0x02fef7fd,
    0xf0003030, 0x03ffffff, 0x03ffffff,
    0xf0003050, 0x00001ff3, 0x000000f3,
    0xf0003054, 0x000000ff, 0x000000f0,
    0xf0003058, 0x001f0f07, 0x00000000,
    0xf00041DC, 0x03000000, 0x03000000,
    0xf000F800, 0x00000001, 0x00000000,
    0xf020005C, 0x00000200, 0x00000200,
    0xf0208000, 0x00001000, 0x00001000,
    0xf0209004, 0x00ff03f3, 0x00000000,
    0xf0209008, 0x00000007, 0x00000000,
    0xf020900C, 0x0079ce7f, 0x00780000,
    0xf0209018, 0x00ff00ff, 0x00050001,
    0xf0209024, 0x000fffff, 0x00088888,
    0xf0209210, 0x00000001, 0x00000000,
    0xf0209220, 0x00000001, 0x00000000,
    0xf0209230, 0x00000001, 0x00000000,
    0xf0209240, 0x00000001, 0x00000000,
    0xf020924C, 0x00000003, 0x00000002,
    0xf1220000, 0x00000044, 0x00000044,
    0xf3000000, 0x00000001, 0x00000001,
    0xf300000C, 0x00000000, 0x00000000,
    0xf3000010, 0x0001ff7f, 0x0001c03f,
    0xf4000100, 0x0007ffff, 0x0007ffff,
    0xf4000110, 0x0000000f, 0x0000000f,
    0xf4000120, 0xffffffff, 0x00000000,
    0xf4000124, 0xffffffff, 0x00000000,
    0xf4000128, 0xffffffff, 0x00000000,
    0xf400012C, 0xffffffff, 0x00000000,
    0xf4000130, 0xffffffff, 0x00000000,
    0xf4000134, 0xffffffff, 0x00000000,
    0xf5000000, 0x000003e1, 0x000003e1,
    0xf5009094, 0xffffffff, 0xffffffff,
    0xf50090EC, 0x00000001, 0x00000000,
    0xf50090F4, 0x00000001, 0x00000001,
    0xf500A300, 0x00000001, 0x00000000,
    0xf6000000, 0x00000100, 0x00000000,
    0xf6000008, 0x00000001, 0x00000000,
    0xf6000010, 0x00000001, 0x00000001,
    0xf6000014, 0x00000001, 0x00000001,
    0xf6000018, 0x00000001, 0x00000000,
};

const unsigned int *mt8127_power_gs_tdd_paging = mt8127_power_gs_tdd_paging_data;

unsigned int mt8127_power_gs_tdd_paging_len = 171;

const unsigned int mt8127_power_gs_tdd_talking_data[] = {
    0xf0000004, 0x0000ff9f, 0x00000080,
    0xf000000C, 0x00000001, 0x00000000,
    0xf0000040, 0x87818107, 0x00810106,
    0xf0000050, 0x87878f83, 0x80818180,
    0xf0000060, 0x87838781, 0x81818180,
    0xf0000070, 0x87818787, 0x81808181,
    0xf0000080, 0x000083cf, 0x00000380,
    0xf0000200, 0x000003ff, 0x000003ff,
    0xf0000204, 0x00000011, 0x00000011,
    0xf0001008, 0x0000001f, 0x00000000,
    0xf0001010, 0x00000007, 0x00000007,
    0xf0001014, 0x00000001, 0x00000001,
    0xf0001048, 0x0091b1e7, 0x0001b1c6,
    0xf0001050, 0x00000303, 0x00000303,
    0xf0001054, 0x0000037f, 0x00000300,
    0xf0001058, 0x001f0f07, 0x00100000,
    0xf0003018, 0x03ffffff, 0x02fef7fd,
    0xf0003030, 0x03ffffff, 0x03ffffff,
    0xf0003050, 0x00001ff3, 0x000000f3,
    0xf0003054, 0x000000ff, 0x000000f0,
    0xf0003058, 0x001f0f07, 0x00000000,
    0xf00041DC, 0x03000000, 0x03000000,
    0xf000F800, 0x00000001, 0x00000000,
    0xf020005C, 0x00000200, 0x00000200,
    0xf0208000, 0x00001000, 0x00001000,
    0xf0209004, 0x00ff03f3, 0x00000000,
    0xf0209008, 0x00000007, 0x00000000,
    0xf020900C, 0x0079ce7f, 0x00780000,
    0xf0209018, 0x00ff00ff, 0x00050001,
    0xf0209024, 0x000fffff, 0x00088888,
    0xf0209210, 0x00000001, 0x00000000,
    0xf0209220, 0x00000001, 0x00000000,
    0xf0209230, 0x00000001, 0x00000000,
    0xf0209240, 0x00000001, 0x00000000,
    0xf020924C, 0x00000003, 0x00000002,
    0xf1220000, 0x00000044, 0x00000000,
    0xf3000000, 0x00000001, 0x00000001,
    0xf300000C, 0x00000000, 0x00000000,
    0xf3000010, 0x0001ff7f, 0x0001c03f,
    0xf4000100, 0x0007ffff, 0x0007ffff,
    0xf4000110, 0x0000000f, 0x0000000f,
    0xf4000120, 0xffffffff, 0x00000000,
    0xf4000124, 0xffffffff, 0x00000000,
    0xf4000128, 0xffffffff, 0x00000000,
    0xf400012C, 0xffffffff, 0x00000000,
    0xf4000130, 0xffffffff, 0x00000000,
    0xf4000134, 0xffffffff, 0x00000000,
    0xf5000000, 0x000003e1, 0x000003e1,
    0xf5009094, 0xffffffff, 0xffffffff,
    0xf50090EC, 0x00000001, 0x00000000,
    0xf50090F4, 0x00000001, 0x00000001,
    0xf500A300, 0x00000001, 0x00000000,
    0xf6000000, 0x00000100, 0x00000000,
    0xf6000008, 0x00000001, 0x00000000,
    0xf6000010, 0x00000001, 0x00000001,
    0xf6000014, 0x00000001, 0x00000001,
    0xf6000018, 0x00000001, 0x00000000,
};

const unsigned int *mt8127_power_gs_tdd_talking = mt8127_power_gs_tdd_talking_data;

unsigned int mt8127_power_gs_tdd_talking_len = 171;

const unsigned int mt8127_power_gs_video_playback_data[] = {
    0xf0000004, 0x0000ff9f, 0x00000000,
    0xf000000C, 0x00000001, 0x00000000,
    0xf0000040, 0x87818107, 0x01810101,
    0xf0000050, 0x87878f83, 0x80010100,
    0xf0000060, 0x87838781, 0x81818180,
    0xf0000070, 0x87818787, 0x01008101,
    0xf0000080, 0x000083cf, 0x00000380,
    0xf0000200, 0x000003ff, 0x000003ff,
    0xf0000204, 0x00000011, 0x00000011,
    0xf0001008, 0x0000001f, 0x00000000,
    0xf0001010, 0x00000007, 0x00000007,
    0xf0001014, 0x00000001, 0x00000001,
    0xf0001048, 0x0091b1e7, 0x0081b0c4,
    0xf0001050, 0x00000303, 0x00000303,
    0xf0001054, 0x0000037f, 0x00000300,
    0xf0001058, 0x001f0f07, 0x00100000,
    0xf0003018, 0x03ffffff, 0x02fef7fd,
    0xf0003030, 0x03ffffff, 0x03ffffff,
    0xf0003050, 0x00001ff3, 0x000000f3,
    0xf0003054, 0x000000ff, 0x000000f0,
    0xf0003058, 0x001f0f07, 0x00000000,
    0xf00041DC, 0x03000000, 0x03000000,
    0xf000F800, 0x00000001, 0x00000001,
    0xf020005C, 0x00000200, 0x00000200,
    0xf0208000, 0x00001000, 0x00001000,
    0xf0209004, 0x00ff03f3, 0x00000000,
    0xf0209008, 0x00000007, 0x00000000,
    0xf020900C, 0x0079ce7f, 0x00780000,
    0xf0209018, 0x00ff00ff, 0x00050001,
    0xf0209024, 0x000fffff, 0x00088888,
    0xf0209210, 0x00000001, 0x00000001,
    0xf0209220, 0x00000001, 0x00000000,
    0xf0209230, 0x00000001, 0x00000000,
    0xf0209240, 0x00000001, 0x00000001,
    0xf020924C, 0x00000003, 0x00000002,
    0xf1220000, 0x00000044, 0x00000000,
    0xf3000000, 0x00000001, 0x00000000,
    0xf300000C, 0x00000003, 0x00000000,
    0xf3000010, 0x0001ff7f, 0x0001c03f,
    0xf4000100, 0x0007ffff, 0x00020000,
    0xf4000110, 0x0000000f, 0x00000000,
    0xf4000120, 0xffffffff, 0x00000000,
    0xf4000124, 0xffffffff, 0x00000000,
    0xf4000128, 0xffffffff, 0x00000000,
    0xf400012C, 0xffffffff, 0x00000000,
    0xf4000130, 0xffffffff, 0x00000000,
    0xf4000134, 0xffffffff, 0x00000000,
    0xf5000000, 0x000003e1, 0x000003e1,
    0xf5009094, 0xffffffff, 0xffffffff,
    0xf50090EC, 0x00000001, 0x00000000,
    0xf50090F4, 0x00000001, 0x00000001,
    0xf500A300, 0x00000001, 0x00000000,
    0xf6000000, 0x00000100, 0x00000100,
    0xf6000008, 0x00000001, 0x00000001,
    0xf6000010, 0x00000001, 0x00000001,
    0xf6000014, 0x00000001, 0x00000001,
    0xf6000018, 0x00000001, 0x00000000,
};

const unsigned int *mt8127_power_gs_video_playback = mt8127_power_gs_video_playback_data;

unsigned int mt8127_power_gs_video_playback_len = 171;

const unsigned int mt8127_power_gs_video_record_data[] = {
    0xf0000004, 0x0000ff9f, 0x00000000,
    0xf000000C, 0x00000001, 0x00000000,
    0xf0000040, 0x87818107, 0x01810101,
    0xf0000050, 0x80878f83, 0x00018100,
    0xf0000060, 0x87838781, 0x81818180,
    0xf0000070, 0x87818787, 0x01008101,
    0xf0000080, 0x000083cf, 0x00000380,
    0xf0000200, 0x000003ff, 0x000003ff,
    0xf0000204, 0x00000011, 0x00000011,
    0xf0001008, 0x0000001f, 0x00000000,
    0xf0001010, 0x00000007, 0x00000007,
    0xf0001014, 0x00000001, 0x00000001,
    0xf0001048, 0x0091b1e7, 0x0001b044,
    0xf0001050, 0x00000303, 0x00000303,
    0xf0001054, 0x0000037f, 0x00000300,
    0xf0001058, 0x001f0f07, 0x00100000,
    0xf0003018, 0x03ffffff, 0x02fef7fd,
    0xf0003030, 0x03ffffff, 0x03ffffff,
    0xf0003050, 0x00001ff3, 0x000000f3,
    0xf0003054, 0x000000ff, 0x000000f0,
    0xf0003058, 0x001f0f07, 0x00000000,
    0xf00041DC, 0x03000000, 0x03000000,
    0xf000F800, 0x00000001, 0x00000001,
    0xf020005C, 0x00000200, 0x00000200,
    0xf0208000, 0x00001000, 0x00001000,
    0xf0209004, 0x00ff03f3, 0x00000000,
    0xf0209008, 0x00000007, 0x00000000,
    0xf020900C, 0x0079ce7f, 0x00780000,
    0xf0209018, 0x00ff00ff, 0x00050001,
    0xf0209024, 0x000fffff, 0x00088888,
    0xf0209210, 0x00000001, 0x00000001,
    0xf0209220, 0x00000001, 0x00000001,
    0xf0209230, 0x00000001, 0x00000000,
    0xf0209240, 0x00000001, 0x00000001,
    0xf020924C, 0x00000003, 0x00000002,
    0xf1220000, 0x00000044, 0x00000000,
    0xf3000000, 0x00000001, 0x00000000,
    0xf300000C, 0x00000003, 0x00000000,
    0xf3000010, 0x0001ff7f, 0x0001c03f,
    0xf4000100, 0x0007ffff, 0x00020000,
    0xf4000110, 0x0000000f, 0x00000000,
    0xf4000120, 0xffffffff, 0x00000000,
    0xf4000124, 0xffffffff, 0x00000000,
    0xf4000128, 0xffffffff, 0x00000000,
    0xf400012C, 0xffffffff, 0x00000000,
    0xf4000130, 0xffffffff, 0x00000000,
    0xf4000134, 0xffffffff, 0x00000000,
    0xf5000000, 0x000003e1, 0x00000000,
    0xf5009094, 0xffffffff, 0xffffffff,
    0xf50090EC, 0x00000001, 0x00000001,
    0xf50090F4, 0x00000001, 0x00000001,
    0xf500A300, 0x00000001, 0x00000000,
    0xf6000000, 0x00000100, 0x00000000,
    0xf6000008, 0x00000001, 0x00000000,
    0xf6000010, 0x00000001, 0x00000001,
    0xf6000014, 0x00000001, 0x00000001,
    0xf6000018, 0x00000001, 0x00000000,
};

const unsigned int *mt8127_power_gs_video_record = mt8127_power_gs_video_record_data;

unsigned int mt8127_power_gs_video_record_len = 171;

const unsigned int mt6323_power_gs_2g_paging_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000000,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x0000c7ff, 0x00008240,
    0x00000108, 0x0000ffbf, 0x000015bf,
    0x0000010E, 0x000000f0, 0x00000020,
    0x00000120, 0x000083fd, 0x000000b9,
    0x00000126, 0x0000c000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00000000,
    0x00000416, 0x00000080, 0x00000000,
    0x00000418, 0x00001000, 0x00000000,
    0x0000041C, 0x00001000, 0x00000000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00000000,
    0x00000506, 0x00004000, 0x00000000,
    0x00000508, 0x00004000, 0x00004000,
    0x00000512, 0x00004000, 0x00000000,
    0x00000516, 0x00008000, 0x00008000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00000000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00000000,
    0x0000055E, 0x00004000, 0x00000000,
    0x00000700, 0x00001980, 0x00000000,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x00000000,
    0x0000070C, 0x0000c250, 0x00000200,
    0x0000070E, 0x00000100, 0x00000000,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00000000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000000, 0x00000000,
};

const unsigned int *mt6323_power_gs_2g_paging = mt6323_power_gs_2g_paging_data;

unsigned int mt6323_power_gs_2g_paging_len = 135;

const unsigned int mt6323_power_gs_2g_talking_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000000,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x00000001, 0x00000001,
    0x00000108, 0x0000010e, 0x0000000e,
    0x0000010E, 0x00000000, 0x00000000,
    0x00000120, 0x000083fd, 0x000000b1,
    0x00000126, 0x00008000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00000000,
    0x00000416, 0x00000080, 0x00000000,
    0x00000418, 0x00001000, 0x00000000,
    0x0000041C, 0x00001000, 0x00000000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00000000,
    0x00000506, 0x00004000, 0x00000000,
    0x00000508, 0x00004000, 0x00004000,
    0x00000512, 0x00004000, 0x00000000,
    0x00000516, 0x00008000, 0x00008000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00000000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00000000,
    0x0000055E, 0x00004000, 0x00000000,
    0x00000700, 0x00001980, 0x00001980,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x00000014,
    0x0000070C, 0x0000c250, 0x00008010,
    0x0000070E, 0x00000100, 0x00000100,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00000000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000003, 0x00000003,
};

const unsigned int *mt6323_power_gs_2g_talking = mt6323_power_gs_2g_talking_data;

unsigned int mt6323_power_gs_2g_talking_len = 135;

const unsigned int mt6323_power_gs_data_connection_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000000,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x0000c7ff, 0x00008042,
    0x00000108, 0x0000ffbf, 0x000095bf,
    0x0000010E, 0x000000f0, 0x00000020,
    0x00000120, 0x000083fd, 0x000000b1,
    0x00000126, 0x0000c000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00000000,
    0x00000416, 0x00000080, 0x00000000,
    0x00000418, 0x00001000, 0x00000000,
    0x0000041C, 0x00001000, 0x00000000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00001000,
    0x00000506, 0x00004000, 0x00004000,
    0x00000508, 0x00004000, 0x00004000,
    0x00000512, 0x00004000, 0x00000000,
    0x00000516, 0x00008000, 0x00008000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00000000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00000000,
    0x0000055E, 0x00004000, 0x00000000,
    0x00000700, 0x00001980, 0x00000000,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x00000000,
    0x0000070C, 0x0000c250, 0x00000200,
    0x0000070E, 0x00000100, 0x00000000,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00000000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000000, 0x00000000,
};

const unsigned int *mt6323_power_gs_data_connection = mt6323_power_gs_data_connection_data;

unsigned int mt6323_power_gs_data_connection_len = 135;

const unsigned int mt6323_power_gs_3g_paging_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000000,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x0000c7ff, 0x00008240,
    0x00000108, 0x0000ffbf, 0x000015bf,
    0x0000010E, 0x000000f0, 0x00000020,
    0x00000120, 0x000083fd, 0x000000b9,
    0x00000126, 0x0000c000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00000000,
    0x00000416, 0x00000080, 0x00000000,
    0x00000418, 0x00001000, 0x00000000,
    0x0000041C, 0x00001000, 0x00000000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00000000,
    0x00000506, 0x00004000, 0x00000000,
    0x00000508, 0x00004000, 0x00004000,
    0x00000512, 0x00004000, 0x00000000,
    0x00000516, 0x00008000, 0x00008000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00000000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00000000,
    0x0000055E, 0x00004000, 0x00000000,
    0x00000700, 0x00001980, 0x00000000,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x00000000,
    0x0000070C, 0x0000c250, 0x00000200,
    0x0000070E, 0x00000100, 0x00000000,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00000000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000000, 0x00000000,
};

const unsigned int *mt6323_power_gs_3g_paging = mt6323_power_gs_3g_paging_data;

unsigned int mt6323_power_gs_3g_paging_len = 135;

const unsigned int mt6323_power_gs_3g_talking_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000000,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x00000001, 0x00000001,
    0x00000108, 0x0000010e, 0x0000000e,
    0x0000010E, 0x00000000, 0x00000000,
    0x00000120, 0x000083fd, 0x000000b1,
    0x00000126, 0x00008000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00000000,
    0x00000416, 0x00000080, 0x00000000,
    0x00000418, 0x00001000, 0x00000000,
    0x0000041C, 0x00001000, 0x00000000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00000000,
    0x00000506, 0x00004000, 0x00000000,
    0x00000508, 0x00004000, 0x00004000,
    0x00000512, 0x00004000, 0x00000000,
    0x00000516, 0x00008000, 0x00008000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00000000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00000000,
    0x0000055E, 0x00004000, 0x00000000,
    0x00000700, 0x00001980, 0x00001980,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x00000014,
    0x0000070C, 0x0000c250, 0x00008010,
    0x0000070E, 0x00000100, 0x00000100,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00000000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000003, 0x00000003,
};

const unsigned int *mt6323_power_gs_3g_talking = mt6323_power_gs_3g_talking_data;

unsigned int mt6323_power_gs_3g_talking_len = 135;

const unsigned int mt6323_power_gs_connsys_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000000,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x0000c7ff, 0x00008240,
    0x00000108, 0x0000ffbf, 0x000015bf,
    0x0000010E, 0x000000f0, 0x00000020,
    0x00000120, 0x000083fd, 0x000000b1,
    0x00000126, 0x0000c000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00000000,
    0x00000416, 0x00000080, 0x00000080,
    0x00000418, 0x00001000, 0x00001000,
    0x0000041C, 0x00001000, 0x00001000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00001000,
    0x00000506, 0x00004000, 0x00004000,
    0x00000508, 0x00004000, 0x00004000,
    0x00000512, 0x00004000, 0x00004000,
    0x00000516, 0x00008000, 0x00000000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00000000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00000000,
    0x0000055E, 0x00004000, 0x00000000,
    0x00000700, 0x00001980, 0x00000000,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x00000000,
    0x0000070C, 0x0000c250, 0x00000200,
    0x0000070E, 0x00000100, 0x00000000,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00000000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000000, 0x00000000,
};

const unsigned int *mt6323_power_gs_connsys = mt6323_power_gs_connsys_data;

unsigned int mt6323_power_gs_connsys_len = 135;

const unsigned int mt6323_power_gs_dpidle_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000000,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x0000c7ff, 0x00008042,
    0x00000108, 0x0000ffbf, 0x000095bf,
    0x0000010E, 0x000000f0, 0x00000020,
    0x00000120, 0x000083fd, 0x000000b9,
    0x00000126, 0x0000c000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00000000,
    0x00000416, 0x00000080, 0x00000000,
    0x00000418, 0x00001000, 0x00000000,
    0x0000041C, 0x00001000, 0x00000000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00001000,
    0x00000506, 0x00004000, 0x00004000,
    0x00000508, 0x00004000, 0x00004000,
    0x00000512, 0x00004000, 0x00000000,
    0x00000516, 0x00008000, 0x00008000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00000000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00000000,
    0x0000055E, 0x00004000, 0x00000000,
    0x00000700, 0x00001980, 0x00000000,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x00000000,
    0x0000070C, 0x0000c250, 0x00000200,
    0x0000070E, 0x00000100, 0x00000000,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00008000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000000, 0x00000000,
};

const unsigned int *mt6323_power_gs_dpidle = mt6323_power_gs_dpidle_data;

unsigned int mt6323_power_gs_dpidle_len = 135;

const unsigned int mt6323_power_gs_idle_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000000,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x0000c7ff, 0x00008042,
    0x00000108, 0x0000ffbf, 0x000095bf,
    0x0000010E, 0x000000f0, 0x00000020,
    0x00000120, 0x000083fd, 0x000000b1,
    0x00000126, 0x0000c000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00000000,
    0x00000416, 0x00000080, 0x00000000,
    0x00000418, 0x00001000, 0x00000000,
    0x0000041C, 0x00001000, 0x00000000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00001000,
    0x00000506, 0x00004000, 0x00004000,
    0x00000508, 0x00004000, 0x00004000,
    0x00000512, 0x00004000, 0x00000000,
    0x00000516, 0x00008000, 0x00000000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00000000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00000000,
    0x0000055E, 0x00004000, 0x00000000,
    0x00000700, 0x00001980, 0x00000000,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x00000000,
    0x0000070C, 0x0000c250, 0x00000200,
    0x0000070E, 0x00000100, 0x00000000,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00000000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000000, 0x00000000,
};

const unsigned int *mt6323_power_gs_idle = mt6323_power_gs_idle_data;

unsigned int mt6323_power_gs_idle_len = 135;

const unsigned int mt6323_power_gs_audio_playback_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000000,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x00000001, 0x00000001,
    0x00000108, 0x0000010e, 0x0000000e,
    0x0000010E, 0x00000000, 0x00000000,
    0x00000120, 0x000083fd, 0x000000b1,
    0x00000126, 0x00008000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00000000,
    0x00000416, 0x00000080, 0x00000000,
    0x00000418, 0x00001000, 0x00000000,
    0x0000041C, 0x00001000, 0x00000000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00000000,
    0x00000506, 0x00004000, 0x00000000,
    0x00000508, 0x00004000, 0x00004000,
    0x00000512, 0x00004000, 0x00000000,
    0x00000516, 0x00008000, 0x00000000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00000000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00000000,
    0x0000055E, 0x00004000, 0x00000000,
    0x00000700, 0x00001980, 0x00001000,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x0000007c,
    0x0000070C, 0x0000c250, 0x0000c010,
    0x0000070E, 0x00000100, 0x00000000,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00000000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000003, 0x00000001,
};

const unsigned int *mt6323_power_gs_audio_playback = mt6323_power_gs_audio_playback_data;

unsigned int mt6323_power_gs_audio_playback_len = 135;

const unsigned int mt6323_power_gs_suspend_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000000,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x0000c7ff, 0x00008042,
    0x00000108, 0x0000ffff, 0x000015ff,
    0x0000010E, 0x000000f0, 0x00000020,
    0x00000120, 0x000083fd, 0x000000b9,
    0x00000126, 0x0000c000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00000000,
    0x00000416, 0x00000080, 0x00000000,
    0x00000418, 0x00001000, 0x00000000,
    0x0000041C, 0x00001000, 0x00000000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00000000,
    0x00000506, 0x00004000, 0x00000000,
    0x00000508, 0x00004000, 0x00000000,
    0x00000512, 0x00004000, 0x00000000,
    0x00000516, 0x00008000, 0x00000000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00000000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00000000,
    0x0000055E, 0x00004000, 0x00000000,
    0x00000700, 0x00001980, 0x00000000,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x00000000,
    0x0000070C, 0x0000c250, 0x00000200,
    0x0000070E, 0x00000100, 0x00000000,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00008000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000000, 0x00000000,
};

const unsigned int *mt6323_power_gs_suspend = mt6323_power_gs_suspend_data;

const unsigned int MT6397_E3_Suspend_Golden[] = {	
0x00000102, 0xffff, 0xc787,
0x00000108, 0x7eff, 0x4882,
0x000001ce, 0x0001, 0x0000,
0x00000128, 0xe37f, 0x0f0a,
0x0000012a, 0xfc07, 0x0001,//bit[11:10] = 2'b0 for reg_ck=24MHz
0x000001d4, 0x001f, 0x0000,
0x00000714, 0x0c00, 0x0000,
0x00000718, 0x000a, 0x0002,
0x0000071A, 0x7000, 0x0000,
0x00000746, 0x0001, 0x0001,
0x00000712, 0x0003, 0x0000,
0x00000710, 0x0101, 0x0000,
0x0000070C, 0x1000, 0x1000,
0x00000702, 0x0007, 0x0000,
0x00000700, 0x000f, 0x0000,
0x0000071C, 0x0003, 0x0000,
0x0000071E, 0x0003, 0x0000,
0x0000072C, 0x0100, 0x0000,
0x00000222, 0x0001, 0x0000,
0x00000248, 0x0001, 0x0000,
0x00000270, 0x0002, 0x0002,
0x0000028a, 0x0100, 0x0100,
0x00000274, 0x0001, 0x0001,
0x0000029a, 0x0001, 0x0000,
0x00000324, 0x0100, 0x0100,
0x0000030e, 0x0001, 0x0001,
0x00000330, 0x0002, 0x0002,
0x00000334, 0x0001, 0x0001,
0x0000034a, 0x0100, 0x0100,
0x00000356, 0x0002, 0x0002,
0x0000035a, 0x0001, 0x0001,
0x00000370, 0x0100, 0x0100,
0x00000386, 0x0001, 0x0001,
0x0000039C, 0x0100, 0x0100,
0x00000206, 0x0060, 0x0060,
0x00000400, 0xffff, 0xcc58, //E3 VTCXO fix
0x00000402, 0x4001, 0x4001,
0x00000404, 0x1000, 0x0000,
0x00000446, 0x0200, 0x0200, //E3 VTCXO fix
0x00000410, 0x4000, 0x4000,
0x00000412, 0x4000, 0x4000,
0x00000414, 0x1000, 0x0000,
0x00000416, 0x4000, 0x0000,
0x00000418, 0x4000, 0x0000,
0x0000041a, 0x8000, 0x0000,
0x0000041c, 0x8000, 0x0000,
0x0000041e, 0x8000, 0x0000,
0x00000420, 0x8000, 0x0000,
0x00000422, 0x8000, 0x0000,
0x00000424, 0x8000, 0x0000,
0x00000428, 0x0100, 0x0100,
0x00000440, 0x8000, 0x0000,
0x0000083a, 0x7000, 0x0000,
};
const unsigned int *mt6397_power_gs_suspend = MT6397_E3_Suspend_Golden;
unsigned int mt6397_power_gs_suspend_len = sizeof (MT6397_E3_Suspend_Golden)/sizeof (MT6397_E3_Suspend_Golden[0]);

unsigned int mt6323_power_gs_suspend_len = 135;

const unsigned int mt6323_power_gs_tdd_paging_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000000,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x0000c7ff, 0x00008240,
    0x00000108, 0x0000ffbf, 0x000015bf,
    0x0000010E, 0x000000f0, 0x00000020,
    0x00000120, 0x000083fd, 0x000000b9,
    0x00000126, 0x0000c000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00000000,
    0x00000416, 0x00000080, 0x00000000,
    0x00000418, 0x00001000, 0x00000000,
    0x0000041C, 0x00001000, 0x00000000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00000000,
    0x00000506, 0x00004000, 0x00000000,
    0x00000508, 0x00004000, 0x00004000,
    0x00000512, 0x00004000, 0x00000000,
    0x00000516, 0x00008000, 0x00008000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00000000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00000000,
    0x0000055E, 0x00004000, 0x00000000,
    0x00000700, 0x00001980, 0x00000000,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x00000000,
    0x0000070C, 0x0000c250, 0x00000200,
    0x0000070E, 0x00000100, 0x00000000,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00000000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000000, 0x00000000,
};

const unsigned int *mt6323_power_gs_tdd_paging = mt6323_power_gs_tdd_paging_data;

unsigned int mt6323_power_gs_tdd_paging_len = 135;

const unsigned int mt6323_power_gs_tdd_talking_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000000,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x00000001, 0x00000001,
    0x00000108, 0x0000010e, 0x0000000e,
    0x0000010E, 0x00000000, 0x00000000,
    0x00000120, 0x000083fd, 0x000000b1,
    0x00000126, 0x00008000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00000000,
    0x00000416, 0x00000080, 0x00000000,
    0x00000418, 0x00001000, 0x00000000,
    0x0000041C, 0x00001000, 0x00000000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00000000,
    0x00000506, 0x00004000, 0x00000000,
    0x00000508, 0x00004000, 0x00004000,
    0x00000512, 0x00004000, 0x00000000,
    0x00000516, 0x00008000, 0x00008000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00000000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00000000,
    0x0000055E, 0x00004000, 0x00000000,
    0x00000700, 0x00001980, 0x00001980,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x00000014,
    0x0000070C, 0x0000c250, 0x00008010,
    0x0000070E, 0x00000100, 0x00000100,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00000000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000003, 0x00000003,
};

const unsigned int *mt6323_power_gs_tdd_talking = mt6323_power_gs_tdd_talking_data;

unsigned int mt6323_power_gs_tdd_talking_len = 135;

const unsigned int mt6323_power_gs_video_playback_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000001,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x0000c7ff, 0x00008043,
    0x00000108, 0x0000ffbf, 0x000014bf,
    0x0000010E, 0x000000f0, 0x00000020,
    0x00000120, 0x000083fd, 0x00000031,
    0x00000126, 0x0000c000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00000000,
    0x00000416, 0x00000080, 0x00000000,
    0x00000418, 0x00001000, 0x00000000,
    0x0000041C, 0x00001000, 0x00000000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00000000,
    0x00000506, 0x00004000, 0x00000000,
    0x00000508, 0x00004000, 0x00004000,
    0x00000512, 0x00004000, 0x00000000,
    0x00000516, 0x00008000, 0x00000000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00000000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00000000,
    0x0000055E, 0x00004000, 0x00000000,
    0x00000700, 0x00001980, 0x00001000,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x00000014,
    0x0000070C, 0x0000c250, 0x00008010,
    0x0000070E, 0x00000100, 0x00000100,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00000000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000003, 0x00000001,
};

const unsigned int *mt6323_power_gs_video_playback = mt6323_power_gs_video_playback_data;

unsigned int mt6323_power_gs_video_playback_len = 135;

const unsigned int mt6323_power_gs_video_record_data[] = {
    0x0000004E, 0x000000a0, 0x000000a0,
    0x00000052, 0x00000001, 0x00000000,
    0x00000066, 0x00000200, 0x00000000,
    0x00000102, 0x0000c7ff, 0x00008043,
    0x00000108, 0x0000ffbf, 0x000014bf,
    0x0000010E, 0x000000f0, 0x00000020,
    0x00000120, 0x000083fd, 0x00000031,
    0x00000126, 0x0000c000, 0x00000000,
    0x00000212, 0x00000030, 0x00000020,
    0x00000216, 0x00000002, 0x00000002,
    0x0000021C, 0x00008080, 0x00008080,
    0x00000230, 0x00000100, 0x00000100,
    0x00000256, 0x00000100, 0x00000100,
    0x00000310, 0x00008080, 0x00008080,
    0x00000402, 0x00000c01, 0x00000401,
    0x00000404, 0x00000001, 0x00000001,
    0x00000408, 0x00008000, 0x00008000,
    0x00000416, 0x00000080, 0x00000000,
    0x00000418, 0x00001000, 0x00000000,
    0x0000041C, 0x00001000, 0x00000000,
    0x00000500, 0x00000001, 0x00000001,
    0x00000502, 0x00000001, 0x00000001,
    0x00000504, 0x00001000, 0x00000000,
    0x00000506, 0x00004000, 0x00000000,
    0x00000508, 0x00004000, 0x00004000,
    0x00000512, 0x00004000, 0x00000000,
    0x00000516, 0x00008000, 0x00000000,
    0x00000518, 0x00008000, 0x00000000,
    0x0000051A, 0x00000100, 0x00000100,
    0x00000536, 0x00008000, 0x00008000,
    0x0000054E, 0x00008000, 0x00000000,
    0x00000550, 0x00000002, 0x00000002,
    0x00000552, 0x00004001, 0x00004001,
    0x00000556, 0x00000001, 0x00000001,
    0x0000055A, 0x00004000, 0x00004000,
    0x0000055E, 0x00004000, 0x00004000,
    0x00000700, 0x00001980, 0x00001980,
    0x00000704, 0x00000033, 0x00000000,
    0x00000708, 0x0000007c, 0x00000000,
    0x0000070C, 0x0000c250, 0x00000200,
    0x0000070E, 0x00000100, 0x00000000,
    0x00000742, 0x00000005, 0x00000000,
    0x00000776, 0x00008000, 0x00000000,
    0x00000778, 0x00008000, 0x00008000,
    0x00004000, 0x00000003, 0x00000002,
};

const unsigned int *mt6323_power_gs_video_record = mt6323_power_gs_video_record_data;

unsigned int mt6323_power_gs_video_record_len = 135;

