#include <linux/msm_mdp.h>
#include <linux/moduleparam.h>
#include <linux/gpio.h>
#include <asm/uaccess.h>
#include "mdss_panel.h"
#include "mdss_dsi.h"
#include "mdss_fb.h"
#include "mdss_dsi_cmd.h"

#define FILEPATH	"/data/lcd.txt"
#define BUFSIZE 3
#define LENGTH 256

#define LENGTH_POS	0
#define TYPE_POS	1
#define DELAY_POS	2
#define DATA_POS	3

#define TAG "[houdz1-LCD_DEBUG: ]"
#define lcd_debug_info(fmt, ...) printk(TAG fmt, ##__VA_ARGS__)

static char data_buf[LENGTH] = {0};
static char *data_pos[LENGTH];
static struct lcd_cmds lcd_txt_cmds;
static int read_lcd_file=0;

struct lcd_cmds {
	struct dsi_cmd_desc *cmd;
	int cnt;
};

static int show_lcd_param(struct dsi_cmd_desc *cmds, int cmd_cnt)
{
	int i, j;

	printk("======================================= cmds_cnt %d =========================================\n", cmd_cnt);
	for (i = 0; i < cmd_cnt; i++) {
		printk("%02x %02x %02x %02x %02x %02x ", cmds[i].dchdr.dtype, 
				cmds[i].dchdr.last, 
				cmds[i].dchdr.vc, 
				cmds[i].dchdr.ack, 
				cmds[i].dchdr.wait, 
				cmds[i].dchdr.dlen);
		for (j = 0; j < cmds[i].dchdr.dlen; j++) {
			printk("%02x ", cmds[i].payload[j]);
		}	
		printk("\n");
	}
	pr_debug("===========================================================================================\n");
	return 0;
}

static int char_to_hex(char *buf)
{
	char a, b;
	//printk("%s",buf);
	if (buf[0] >= 'A' && buf[0] <= 'F') {
		a = buf[0] - 55;
	} else if (buf[0] >= 'a' && buf[0] <= 'f') {
		a = buf[0] - 87;
	} else {
		a = buf[0] - 48;
	}
	if (buf[1] >= 'A' && buf[1] <= 'F') {
		b = buf[1] - 55;
	} else if (buf[1] >= 'a' && buf[1] <= 'f') {
		b = buf[1] - 87;
	} else {
		b = buf[1] - 48;
	}
	return a * 16 + b;
}


static int read_init_param_from_file(void)
{
	struct file *fp;
	int ret, length = 0;
	int i = 0;
	char buf[BUFSIZE] = {0};
	char *filepath = FILEPATH;
	mm_segment_t old_fs;
	int cmds_cnt = 0;

	lcd_txt_cmds.cnt = 0;
	
	for (i = 0; i < length; i++) data_buf[i] = 0;//clear BUF
	
	fp = filp_open(filepath, O_RDONLY, 0);
	if (IS_ERR(fp)) {
		pr_err("%s--houdz1:open file failure\n",__func__);
		return -1;
	} else {
		lcd_debug_info("open file success, begin to read\n");
		old_fs = get_fs();
		set_fs(KERNEL_DS);	
		do {
			ret = vfs_read(fp, buf, BUFSIZE, &fp->f_pos);
			if (ret == -1) {
				pr_err("%s--houdz1:read file failure!\n",__func__);
				goto read_err;
			}
			if (ret == BUFSIZE) {
				length++;
				if (length > LENGTH) { 
					pr_err("%s--houdz1:data too long !\n",__func__);
					goto large_err;
				}
				
				if((buf[2] == ' ')||(buf[2] == '\n'))
				{
					data_buf[length] = char_to_hex(buf); //length+format+delay+data,//buf[0]=length
					if (buf[2] == '\n') { //the end of line
						data_buf[LENGTH_POS] = length + 1;
					
						data_pos[cmds_cnt] = kmalloc(sizeof(char) * data_buf[LENGTH_POS], GFP_KERNEL);
						if (!data_pos[cmds_cnt]) {
							pr_err("%s--houdz1:kmalloc failure !\n",__func__);
							goto mem_err;
						}

						memcpy(data_pos[cmds_cnt], data_buf, data_buf[0]);
						//lcd_debug_info("buf[%d] length = %d\n", cmds_cnt, length);
						cmds_cnt ++; //cmd count ＋1
						length = 0;
					}
				} 
			}
		} while (ret != 0);
	
		lcd_txt_cmds.cnt = cmds_cnt;

		lcd_txt_cmds.cmd = kmalloc(sizeof(struct dsi_cmd_desc) * lcd_txt_cmds.cnt, GFP_KERNEL);
		if (!lcd_txt_cmds.cmd) {
			pr_err("%s--houdz1:kmalloc failure !\n",__func__);
			goto cmds_err;
		}
		
		for (i = 0; i < cmds_cnt; i++) {
			lcd_txt_cmds.cmd[i].dchdr.dtype = data_pos[i][TYPE_POS];
			lcd_txt_cmds.cmd[i].dchdr.last = 1;
			lcd_txt_cmds.cmd[i].dchdr.vc = 0;
			lcd_txt_cmds.cmd[i].dchdr.ack = 0;
			lcd_txt_cmds.cmd[i].dchdr.wait = data_pos[i][DELAY_POS];
			lcd_txt_cmds.cmd[i].dchdr.dlen = (short)(data_pos[i][LENGTH_POS] - DATA_POS);
			lcd_txt_cmds.cmd[i].payload = &data_pos[i][DATA_POS];
			//lcd_debug_info("%d:len=%d length = %d,l=%d\n",i, (data_pos[i][LENGTH_POS]), (data_pos[i][LENGTH_POS] - DATA_POS),lcd_txt_cmds.cmd[i].dchdr.dlen);
		}
		//show_lcd_param(lcd_txt_cmds.cmd, lcd_txt_cmds.cnt);
		filp_close(fp, NULL);
		lcd_debug_info("after file close\n");
	}
	return 0;
cmds_err:
large_err:
read_err:
mem_err:
	for (i = 0; i < cmds_cnt; i++) kfree(data_pos[i]);
	lcd_txt_cmds.cnt = 0;
	return -1;
}

void lenovo_lcd_free_mem(void)
{
	int i;
	i=0;

	if (lcd_txt_cmds.cnt) {
		pr_info("Free mem for lcd txt file's cmds buf.\n");
		for (i = 0; i < lcd_txt_cmds.cnt; i++) {
			if (data_pos[i]) kfree(data_pos[i]);
		}
		if (lcd_txt_cmds.cmd)
			kfree(lcd_txt_cmds.cmd);
		lcd_txt_cmds.cnt = 0;
	}
}
int lenovo_lcd_update_init_code(struct mdss_dsi_ctrl_pdata *ctrl_pdata)
{
	int ret =0;
	if (read_lcd_file) 
	{
		if (!read_init_param_from_file()) {
			ctrl_pdata->on_cmds.cmds = lcd_txt_cmds.cmd;
			ctrl_pdata->on_cmds.cmd_cnt = lcd_txt_cmds.cnt;
			lcd_debug_info("%s Use Txt file param\n", __func__);
		}
		show_lcd_param(ctrl_pdata->on_cmds.cmds, ctrl_pdata->on_cmds.cmd_cnt);
	}
	return ret;
}




static int get_lcd_param_func(const char *val, struct kernel_param *kp)
{
	int value;
	int ret = param_set_int(val, kp); 

	if(ret < 0) 
	{    
		pr_info(KERN_ERR"%s Invalid argument\n", __func__);
		return -EINVAL;
	}    
	value = *((int*)kp->arg);
	if (value) {
		read_lcd_file = 1;
		pr_info("prepare to read lcd param...\n");
	} else {
		read_lcd_file = 0;
		pr_info("show lcd param off...\n");
	}
	return 0;
}

module_param_call(read_txt_file, get_lcd_param_func, param_get_int, &read_lcd_file, S_IRUSR | S_IWUSR);
