/* Copyright (c) 2014, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __MSM_CLOCKS_ZIRC_HWIO_H
#define __MSM_CLOCKS_ZIRC_HWIO_H

#define FMAX_LOW        1
#define FMAX_NOM        2
#define FMAX_TURBO      3

#define RPM_REGULATOR_CORNER_NONE 1
#define RPM_REGULATOR_CORNER_SVS_SOC 4
#define RPM_REGULATOR_CORNER_NOMINAL 5
#define RPM_REGULATOR_CORNER_SUPER_TURBO 7

#define GCC_GPLL0_MODE				  0x21000
#define GCC_GPLL0_L_VAL				  0x21004
#define GCC_GPLL0_ALPHA_VAL			  0x21008
#define GCC_GPLL0_ALPHA_VAL_U			  0x2100C
#define GCC_GPLL0_USER_CTL			  0x21010
#define GCC_GPLL0_USER_CTL_U			  0x21014
#define GCC_GPLL0_CONFIG_CTL			  0x21018
#define GCC_GPLL0_TEST_CTL			  0x2101C
#define GCC_GPLL0_TEST_CTL_U			  0x21020
#define GCC_GPLL0_FREQ_CTL			  0x21028
#define GCC_GPLL0_STATUS			  0x21024
#define GCC_GPLL1_MODE				  0x20000
#define GCC_GPLL1_L_VAL				  0x20004
#define GCC_GPLL1_ALPHA_VAL			  0x20008
#define GCC_GPLL1_ALPHA_VAL_U			  0x2000C
#define GCC_GPLL1_USER_CTL			  0x20010
#define GCC_GPLL1_CONFIG_CTL			  0x20018
#define GCC_GPLL1_TEST_CTL			  0x2001C
#define GCC_GPLL1_STATUS			  0x20024
#define GCC_GPLL3_MODE				  0x23000
#define GCC_GPLL3_L_VAL				  0x23004
#define GCC_GPLL3_ALPHA_VAL			  0x23008
#define GCC_GPLL3_ALPHA_VAL_U			  0x2300C
#define GCC_GPLL3_USER_CTL			  0x23010
#define GCC_GPLL3_USER_CTL_U			  0x23014
#define GCC_GPLL3_CONFIG_CTL			  0x23018
#define GCC_GPLL3_TEST_CTL			  0x2301C
#define GCC_GPLL3_TEST_CTL_U			  0x23020
#define GCC_GPLL3_FREQ_CTL			  0x23028
#define GCC_GPLL3_STATUS			  0x23024
#define GCC_GPLL2_MODE				  0x25000
#define GCC_GPLL2_L_VAL				  0x25004
#define GCC_GPLL2_ALPHA_VAL			  0x25008
#define GCC_GPLL2_ALPHA_VAL_U			  0x2500C
#define GCC_GPLL2_USER_CTL			  0x25010
#define GCC_GPLL2_USER_CTL_U			  0x25014
#define GCC_GPLL2_CONFIG_CTL			  0x25018
#define GCC_GPLL2_TEST_CTL			  0x2501C
#define GCC_GPLL2_TEST_CTL_U			  0x25020
#define GCC_GPLL2_FREQ_CTL			  0x25028
#define GCC_GPLL2_STATUS			  0x25024
#define GCC_SYSTEM_NOC_BCR			  0x26000
#define GCC_SYSTEM_NOC_BFDCD_CMD_RCGR		  0x26004
#define GCC_SYSTEM_NOC_BFDCD_CFG_RCGR		  0x26008
#define GCC_SNOC_QOSGEN_EXTREF_CTL		  0x2601C
#define GCC_PCNOC_BFDCD_CMD_RCGR		  0x27000
#define GCC_PCNOC_BFDCD_CFG_RCGR		  0x27004
#define GCC_SYS_NOC_AXI_CBCR			  0x26020
#define GCC_SYS_NOC_QDSS_STM_AXI_CBCR		  0x26024
#define GCC_SYS_NOC_APSS_AHB_CBCR		  0x26028
#define GCC_SNOC_PCNOC_AHB_CBCR			  0x2602C
#define GCC_SYS_NOC_AT_CBCR			  0x26030
#define GCC_PCNOC_BCR				  0x27018
#define GCC_PCNOC_AHB_CBCR			  0x2701C
#define GCC_PCNOC_DDR_CFG_CBCR			  0x27020
#define GCC_PCNOC_RPM_AHB_CBCR			  0x27024
#define GCC_PCNOC_AT_CBCR			  0x27028
#define GCC_NOC_CONF_XPU_AHB_CBCR		  0x17000
#define GCC_IMEM_BCR				  0xE000
#define GCC_IMEM_AXI_CBCR			  0xE004
#define GCC_IMEM_CFG_AHB_CBCR			  0xE008
#define GCC_MSS_CFG_AHB_CBCR			  0x49000
#define GCC_MSS_Q6_BIMC_AXI_CBCR		  0x49004
#define GCC_RPM_CFG_XPU_CBCR			  0x17004
#define GCC_QDSS_BCR				  0x29000
#define GCC_QDSS_DAP_AHB_CBCR			  0x29004
#define GCC_QDSS_CFG_AHB_CBCR			  0x29008
#define GCC_QDSS_AT_CMD_RCGR			  0x2900C
#define GCC_QDSS_AT_CFG_RCGR			  0x29010
#define GCC_QDSS_AT_CBCR			  0x29024
#define GCC_QDSS_ETR_USB_CBCR			  0x29028
#define GCC_QDSS_STM_CMD_RCGR			  0x2902C
#define GCC_QDSS_STM_CFG_RCGR			  0x29030
#define GCC_QDSS_STM_CBCR			  0x29044
#define GCC_QDSS_TRACECLKIN_CMD_RCGR		  0x29048
#define GCC_QDSS_TRACECLKIN_CFG_RCGR		  0x2904C
#define GCC_QDSS_TRACECLKIN_CBCR		  0x29060
#define GCC_QDSS_TSCTR_CMD_RCGR			  0x29064
#define GCC_QDSS_TSCTR_CFG_RCGR			  0x29068
#define GCC_QDSS_TSCTR_DIV2_CBCR		  0x2907C
#define GCC_QDSS_TSCTR_DIV3_CBCR		  0x29080
#define GCC_QDSS_DAP_CBCR			  0x29084
#define GCC_QDSS_TSCTR_DIV4_CBCR		  0x29088
#define GCC_QDSS_TSCTR_DIV8_CBCR		  0x2908C
#define GCC_QDSS_TSCTR_DIV16_CBCR		  0x29090
#define GCC_GCC_SLEEP_CMD_RCGR			  0x30000
#define GCC_QUSB2A_PHY_BCR			  0x41028
#define GCC_SDCC1_BCR				  0x42000
#define GCC_SDCC1_APPS_CMD_RCGR			  0x42004
#define GCC_SDCC1_APPS_CFG_RCGR			  0x42008
#define GCC_SDCC1_APPS_M			  0x4200C
#define GCC_SDCC1_APPS_N			  0x42010
#define GCC_SDCC1_APPS_D			  0x42014
#define GCC_SDCC1_APPS_CBCR			  0x42018
#define GCC_SDCC1_AHB_CBCR			  0x4201C
#define GCC_BLSP1_BCR				  0x1000
#define GCC_BLSP1_SLEEP_CBCR			  0x1004
#define GCC_BLSP1_AHB_CBCR			  0x1008
#define GCC_BLSP1_QUP1_BCR			  0x2000
#define GCC_BLSP1_QUP1_SPI_APPS_CBCR		  0x2004
#define GCC_BLSP1_QUP1_I2C_APPS_CBCR		  0x2008
#define GCC_BLSP1_QUP1_I2C_APPS_CMD_RCGR	  0x200C
#define GCC_BLSP1_QUP1_I2C_APPS_CFG_RCGR	  0x2010
#define GCC_BLSP1_QUP2_I2C_APPS_CMD_RCGR	  0x3000
#define GCC_BLSP1_QUP2_I2C_APPS_CFG_RCGR	  0x3004
#define GCC_BLSP1_QUP3_I2C_APPS_CMD_RCGR	  0x4000
#define GCC_BLSP1_QUP3_I2C_APPS_CFG_RCGR	  0x4004
#define GCC_BLSP1_QUP4_I2C_APPS_CMD_RCGR	  0x5000
#define GCC_BLSP1_QUP4_I2C_APPS_CFG_RCGR	  0x5004
#define GCC_BLSP1_QUP1_SPI_APPS_CMD_RCGR	  0x2024
#define GCC_BLSP1_QUP1_SPI_APPS_CFG_RCGR	  0x2028
#define GCC_BLSP1_QUP1_SPI_APPS_M		  0x202C
#define GCC_BLSP1_QUP1_SPI_APPS_N		  0x2030
#define GCC_BLSP1_QUP1_SPI_APPS_D		  0x2034
#define GCC_BLSP1_UART1_BCR			  0x2038
#define GCC_BLSP1_UART1_APPS_CBCR		  0x203C
#define GCC_BLSP1_UART1_SIM_CBCR		  0x2040
#define GCC_BLSP1_UART1_APPS_CMD_RCGR		  0x2044
#define GCC_BLSP1_UART1_APPS_CFG_RCGR		  0x2048
#define GCC_BLSP1_UART1_APPS_M			  0x204C
#define GCC_BLSP1_UART1_APPS_N			  0x2050
#define GCC_BLSP1_UART1_APPS_D			  0x2054
#define GCC_BLSP1_QUP2_BCR			  0x3008
#define GCC_BLSP1_QUP2_SPI_APPS_CBCR		  0x300C
#define GCC_BLSP1_QUP2_I2C_APPS_CBCR		  0x3010
#define GCC_BLSP1_QUP2_SPI_APPS_CMD_RCGR	  0x3014
#define GCC_BLSP1_QUP2_SPI_APPS_CFG_RCGR	  0x3018
#define GCC_BLSP1_QUP2_SPI_APPS_M		  0x301C
#define GCC_BLSP1_QUP2_SPI_APPS_N		  0x3020
#define GCC_BLSP1_QUP2_SPI_APPS_D		  0x3024
#define GCC_BLSP1_UART2_BCR			  0x3028
#define GCC_BLSP1_UART2_APPS_CBCR		  0x302C
#define GCC_BLSP1_UART2_SIM_CBCR		  0x3030
#define GCC_BLSP1_UART2_APPS_CMD_RCGR		  0x3034
#define GCC_BLSP1_UART2_APPS_CFG_RCGR		  0x3038
#define GCC_BLSP1_UART2_APPS_M			  0x303C
#define GCC_BLSP1_UART2_APPS_N			  0x3040
#define GCC_BLSP1_UART2_APPS_D			  0x3044
#define GCC_BLSP1_QUP3_BCR			  0x4018
#define GCC_BLSP1_QUP3_SPI_APPS_CBCR		  0x401C
#define GCC_BLSP1_QUP3_I2C_APPS_CBCR		  0x4020
#define GCC_BLSP1_QUP3_SPI_APPS_CMD_RCGR	  0x4024
#define GCC_BLSP1_QUP3_SPI_APPS_CFG_RCGR	  0x4028
#define GCC_BLSP1_QUP3_SPI_APPS_M		  0x402C
#define GCC_BLSP1_QUP3_SPI_APPS_N		  0x4030
#define GCC_BLSP1_QUP3_SPI_APPS_D		  0x4034
#define GCC_BLSP1_UART3_BCR			  0x4038
#define GCC_BLSP1_UART3_APPS_CBCR		  0x403C
#define GCC_BLSP1_UART3_SIM_CBCR		  0x4040
#define GCC_BLSP1_UART3_APPS_CMD_RCGR		  0x4044
#define GCC_BLSP1_UART3_APPS_CFG_RCGR		  0x4048
#define GCC_BLSP1_UART3_APPS_M			  0x404C
#define GCC_BLSP1_UART3_APPS_N			  0x4050
#define GCC_BLSP1_UART3_APPS_D			  0x4054
#define GCC_BLSP1_QUP4_BCR			  0x5018
#define GCC_BLSP1_QUP4_SPI_APPS_CBCR		  0x501C
#define GCC_BLSP1_QUP4_I2C_APPS_CBCR		  0x5020
#define GCC_BLSP1_QUP4_SPI_APPS_CMD_RCGR	  0x5024
#define GCC_BLSP1_QUP4_SPI_APPS_CFG_RCGR	  0x5028
#define GCC_BLSP1_QUP4_SPI_APPS_M		  0x502C
#define GCC_BLSP1_QUP4_SPI_APPS_N		  0x5030
#define GCC_BLSP1_QUP4_SPI_APPS_D		  0x5034
#define GCC_BLSP1_UART4_BCR			  0x5038
#define GCC_BLSP1_UART4_APPS_CBCR		  0x503C
#define GCC_BLSP1_UART4_SIM_CBCR		  0x5040
#define GCC_BLSP1_UART4_APPS_CMD_RCGR		  0x5044
#define GCC_BLSP1_UART4_APPS_CFG_RCGR		  0x5048
#define GCC_BLSP1_UART4_APPS_M			  0x504C
#define GCC_BLSP1_UART4_APPS_N			  0x5050
#define GCC_BLSP1_UART4_APPS_D			  0x5054
#define GCC_BLSP_UART_SIM_CMD_RCGR		  0x100C
#define GCC_BLSP_UART_SIM_CFG_RCGR		  0x1010
#define GCC_PRNG_XPU_CFG_AHB_CBCR		  0x17008
#define GCC_PDM_BCR				  0x44000
#define GCC_PDM_AHB_CBCR			  0x44004
#define GCC_PDM_XO4_CBCR			  0x44008
#define GCC_PDM2_CBCR				  0x4400C
#define GCC_PDM2_CMD_RCGR			  0x44010
#define GCC_PDM2_CFG_RCGR			  0x44014
#define GCC_PRNG_BCR				  0x13000
#define GCC_PRNG_AHB_CBCR			  0x13004
#define GCC_TCSR_BCR				  0x28000
#define GCC_TCSR_AHB_CBCR			  0x28004
#define GCC_BOOT_ROM_BCR			  0x13008
#define GCC_BOOT_ROM_AHB_CBCR			  0x1300C
#define GCC_MSG_RAM_BCR				  0x2B000
#define GCC_MSG_RAM_AHB_CBCR			  0x2B004
#define GCC_TLMM_BCR				  0x34000
#define GCC_TLMM_AHB_CBCR			  0x34004
#define GCC_TLMM_CBCR				  0x34008
#define GCC_MPM_BCR				  0x2C000
#define GCC_MPM_MISC				  0x2C004
#define GCC_MPM_AHB_CBCR			  0x2C008
#define GCC_RPM_PROC_HCLK_CBCR			  0x2D000
#define GCC_RPM_BUS_AHB_CBCR			  0x2D004
#define GCC_RPM_SLEEP_CBCR			  0x2D008
#define GCC_RPM_TIMER_CBCR			  0x2D00C
#define GCC_RPM_CMD_RCGR			  0x2D010
#define GCC_RPM_CFG_RCGR			  0x2D014
#define GCC_RPM_MISC				  0x2D028
#define GCC_SEC_CTRL_BCR			  0x1A000
#define GCC_ACC_CMD_RCGR			  0x1A004
#define GCC_ACC_CFG_RCGR			  0x1A008
#define GCC_ACC_MISC				  0x1A01C
#define GCC_SEC_CTRL_ACC_CBCR			  0x1A020
#define GCC_SEC_CTRL_AHB_CBCR			  0x1A024
#define GCC_SEC_CTRL_CBCR			  0x1A028
#define GCC_SEC_CTRL_SENSE_CBCR			  0x1A02C
#define GCC_SEC_CTRL_BOOT_ROM_PATCH_CBCR	  0x1A030
#define GCC_SEC_CTRL_CMD_RCGR			  0x1A034
#define GCC_SEC_CTRL_CFG_RCGR			  0x1A038
#define GCC_SPMI_BCR				  0x2E000
#define GCC_SPMI_SER_CMD_RCGR			  0x2E004
#define GCC_SPMI_SER_CFG_RCGR			  0x2E008
#define GCC_SPMI_SER_CBCR			  0x2E01C
#define GCC_SPMI_PCNOC_AHB_CBCR			  0x2E020
#define GCC_SPMI_AHB_CMD_RCGR			  0x2E024
#define GCC_SPMI_AHB_CFG_RCGR			  0x2E028
#define GCC_SPMI_AHB_CBCR			  0x2E03C
#define GCC_SPDM_BCR				  0x2F000
#define GCC_SPDM_CFG_AHB_CBCR			  0x2F004
#define GCC_SPDM_MSTR_AHB_CBCR			  0x2F008
#define GCC_SPDM_FF_CBCR			  0x2F00C
#define GCC_SPDM_BIMC_CY_CBCR			  0x2F010
#define GCC_SPDM_SNOC_CY_CBCR			  0x2F014
#define GCC_SPDM_DEBUG_CY_CBCR			  0x2F018
#define GCC_SPDM_PCNOC_CY_CBCR			  0x2F01C
#define GCC_SPDM_RPM_CY_CBCR			  0x2F020
#define GCC_CRYPTO_BCR				  0x16000
#define GCC_CRYPTO_CMD_RCGR			  0x16004
#define GCC_CRYPTO_CFG_RCGR			  0x16008
#define GCC_CRYPTO_CBCR				  0x1601C
#define GCC_CRYPTO_AXI_CBCR			  0x16020
#define GCC_CRYPTO_AHB_CBCR			  0x16024
#define GCC_GCC_AHB_CBCR			  0x30014
#define GCC_GCC_XO_CMD_RCGR			  0x30018
#define GCC_GCC_XO_CBCR				  0x30030
#define GCC_GCC_XO_DIV4_CBCR			  0x30034
#define GCC_GCC_IM_SLEEP_CBCR			  0x30038
#define GCC_BIMC_BCR				  0x31000
#define GCC_BIMC_GDSCR				  0x31004
#define GCC_BIMC_DDR_XO_CMD_RCGR		  0x32000
#define GCC_BIMC_XO_CBCR			  0x31008
#define GCC_BIMC_CFG_AHB_CBCR			  0x3100C
#define GCC_BIMC_SLEEP_CBCR			  0x31010
#define GCC_BIMC_SYSNOC_AXI_CBCR		  0x31014
#define GCC_BIMC_DDR_CMD_RCGR			  0x32004
#define GCC_BIMC_DDR_CFG_RCGR			  0x32008
#define GCC_BIMC_MISC				  0x31018
#define GCC_BIMC_CBCR				  0x3101C
#define GCC_BIMC_APSS_AXI_CBCR			  0x31020
#define GCC_DDR_DIM_CFG_CBCR			  0x3201C
#define GCC_DDR_DIM_SLEEP_CBCR			  0x32020
#define GCC_BIMC_TCU_CBCR			  0x31044
#define GCC_ULTAUDIO_PCNOC_MPORT_CBCR		  0x1C000
#define GCC_ULTAUDIO_PCNOC_SWAY_CBCR		  0x1C004
#define GCC_ULT_AUDIO_BCR			  0x1C0B4
#define GCC_APSS_AHB_CMD_RCGR			  0x46000
#define GCC_APSS_AHB_CFG_RCGR			  0x46004
#define GCC_APSS_AHB_MISC			  0x46018
#define GCC_APSS_AHB_CBCR			  0x4601C
#define GCC_APSS_AXI_CBCR			  0x46020
#define GCC_DEHR_BCR				  0x1F000
#define GCC_DEHR_CBCR				  0x1F004
#define GCC_PCNOC_MPU_CFG_AHB_CBCR		  0x1700C
#define GCC_APSS_TCU_CBCR			  0x12018
#define GCC_MSS_TBU_AXI_CBCR			  0x12024
#define GCC_MSS_TBU_Q6_AXI_CBCR			  0x1202C
#define GCC_PCNOC_TBU_CBCR			  0x12030
#define GCC_SMMU_CFG_CBCR			  0x12038
#define GCC_SMMU_XPU_CBCR			  0x17010
#define GCC_SMMU_CATS64_CBCR			  0x7C004
#define GCC_SMMU_CATS_BCR			  0x7C000
#define GCC_SMMU_BCR				  0x12000
#define GCC_APSS_TCU_BCR			  0x12050
#define GCC_MSS_TBU_AXI_BCR			  0x65000
#define GCC_MSS_TBU_Q6_AXI_BCR			  0x67000
#define GCC_SMMU_XPU_BCR			  0x12054
#define GCC_SMMU_CFG_BCR			  0x12094
#define GCC_PCNOC_TBU_BCR			  0x12058
#define GCC_APCS_GPLL_ENA_VOTE			  0x45000
#define GCC_APCS_CLOCK_BRANCH_ENA_VOTE		  0x45004
#define GCC_APCS_SMMU_CLOCK_BRANCH_ENA_VOTE	  0x4500C
#define GCC_APCS_CLOCK_SLEEP_ENA_VOTE		  0x45008
#define GCC_APCS_SMMU_CLOCK_SLEEP_ENA_VOTE	  0x45010
#define GCC_MSS_RESTART				  0x10000
#define GCC_RESET_DEBUG				  0x14000
#define GCC_FLUSH_ETR_DEBUG_TIMER		  0x15000
#define GCC_STOP_CAPTURE_DEBUG_TIMER		  0x15004
#define GCC_RESET_STATUS			  0x15008
#define GCC_SW_SRST				  0x1500C
#define GCC_PROC_HALT				  0x1301C
#define GCC_GCC_DEBUG_CLK_CTL			  0x74000
#define GCC_CLOCK_FRQ_MEASURE_CTL		  0x74004
#define GCC_CLOCK_FRQ_MEASURE_STATUS		  0x74008
#define GCC_PLLTEST_PAD_CFG			  0x7400C
#define GCC_GP1_CBCR				  0x8000
#define GCC_GP1_CMD_RCGR			  0x8004
#define GCC_GP1_CFG_RCGR			  0x8008
#define GCC_GP1_M				  0x800C
#define GCC_GP1_N				  0x8010
#define GCC_GP1_D				  0x8014
#define GCC_GP2_CBCR				  0x9000
#define GCC_GP2_CMD_RCGR			  0x9004
#define GCC_GP2_CFG_RCGR			  0x9008
#define GCC_GP2_M				  0x900C
#define GCC_GP2_N				  0x9010
#define GCC_GP2_D				  0x9014
#define GCC_GP3_CBCR				  0xA000
#define GCC_GP3_CMD_RCGR			  0xA004
#define GCC_GP3_CFG_RCGR			  0xA008
#define GCC_GP3_M				  0xA00C
#define GCC_GP3_N				  0xA010
#define GCC_GP3_D				  0xA014
#define GCC_SYS_NOC_IPA_AXI_CBCR		  0x3E028
#define GCC_IPA_BCR				  0x3E000
#define GCC_IPA_CMD_RCGR			  0x3E004
#define GCC_IPA_CFG_RCGR			  0x3E008
#define GCC_IPA_M				  0x3E00C
#define GCC_IPA_N				  0x3E010
#define GCC_IPA_D				  0x3E014
#define GCC_IPA_CBCR				  0x3E018
#define GCC_IPA_AHB_CBCR			  0x3E01C
#define GCC_IPA_SLEEP_CBCR			  0x3E020
#define GCC_QPIC_BCR				  0x3F000
#define GCC_QPIC_CMD_RCGR			  0x3F004
#define GCC_QPIC_CFG_RCGR			  0x3F008
#define GCC_QPIC_M				  0x3F00C
#define GCC_QPIC_N				  0x3F010
#define GCC_QPIC_D				  0x3F014
#define GCC_QPIC_CBCR				  0x3F018
#define GCC_QPIC_AHB_CBCR			  0x3F01C
#define GCC_QPIC_SYSTEM_CBCR			  0x3F020
#define GCC_PCIE_BCR				  0x5D004
#define GCC_PCIE_CFG_AHB_CBCR			  0x5D008
#define GCC_PCIE_PIPE_CBCR			  0x5D00C
#define GCC_PCIE_AXI_CBCR			  0x5D010
#define GCC_PCIE_SLEEP_CBCR			  0x5D014
#define GCC_PCIE_AXI_MSTR_CBCR			  0x5D018
#define GCC_PCIE_PIPE_CMD_RCGR			  0x5D01C
#define GCC_PCIE_PIPE_CFG_RCGR			  0x5D020
#define GCC_PCIE_AUX_CMD_RCGR			  0x5D030
#define GCC_PCIE_AUX_CFG_RCGR			  0x5D034
#define GCC_PCIE_AUX_M				  0x5D038
#define GCC_PCIE_AUX_N				  0x5D03C
#define GCC_PCIE_AUX_D				  0x5D040
#define GCC_PCIE_GDSCR				  0x5D044
#define GCC_PCIEPHY_PHY_BCR			  0x5D048
#define GCC_PCIE_GPIO_LDO_EN			  0x5D04C
#define GCC_PCIE_PHY_BCR			  0x5D050
#define GCC_PCIE_MISC_RESET			  0x5D054
#define GCC_PCIE_LINK_DOWN_BCR			  0x5D05C
#define GCC_USB_SS_LDO_EN			  0x5E07C
#define GCC_USB_PHY_CFG_AHB_CBCR		  0x5E080
#define GCC_SYS_NOC_USB3_AXI_CBCR		  0x5E084
#define GCC_USB_30_BCR				  0x5E070
#define GCC_USB_30_MISC				  0x5E074
#define GCC_USB30_MASTER_CBCR			  0x5E000
#define GCC_USB30_SLEEP_CBCR			  0x5E004
#define GCC_USB30_MOCK_UTMI_CBCR		  0x5E008
#define GCC_USB30_MASTER_CMD_RCGR		  0x5E00C
#define GCC_USB30_MASTER_CFG_RCGR		  0x5E010
#define GCC_USB30_MASTER_M			  0x5E014
#define GCC_USB30_MASTER_N			  0x5E018
#define GCC_USB30_MASTER_D			  0x5E01C
#define GCC_USB30_MOCK_UTMI_CMD_RCGR		  0x5E020
#define GCC_USB30_MOCK_UTMI_CFG_RCGR		  0x5E024
#define GCC_USB3_PHY_BCR			  0x5E034
#define GCC_USB3PHY_PHY_BCR			  0x5E03C
#define GCC_USB3_PIPE_CBCR			  0x5E040
#define GCC_USB3_AUX_CBCR			  0x5E044
#define GCC_USB3_PIPE_CMD_RCGR			  0x5E048
#define GCC_USB3_PIPE_CFG_RCGR			  0x5E04C
#define GCC_USB3_AUX_CMD_RCGR			  0x5E05C
#define GCC_USB3_AUX_CFG_RCGR			  0x5E060
#define GCC_USB3_AUX_M				  0x5E064
#define GCC_USB3_AUX_N				  0x5E068
#define GCC_USB3_AUX_D				  0x5E06C
#define GCC_USB_30_GDSCR			  0x5E078
#define GCC_IPA_TBU_CBCR			  0x1205C
#define GCC_USB3_AXI_TBU_CBCR			  0x12060
#define GCC_PCIE_AXI_TBU_CBCR			  0x12064
#define GCC_IPA_TBU_BCR				  0x6E000
#define GCC_USB3_AXI_TBU_BCR			  0x6F000
#define GCC_PCIE_AXI_TBU_BCR			  0x7D000
#define GCC_SMMU_TCU_BIMC_CMD_RCGR		  0x1206C
#define GCC_SMMU_TCU_BIMC_CFG_RCGR		  0x12070
#define GCC_SMMU_CATS_2X_CMD_RCGR		  0x7C010
#define GCC_SMMU_CATS_2X_CFG_RCGR		  0x7C014

#endif
