/* Copyright (c) 2011-2014, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef CUSTOM_DEFINE_OTP_INIT_MAP_H
#define CUSTOM_DEFINE_OTP_INIT_MAP_H

#include <media/msmb_camera.h>

static struct msm_camera_i2c_reg_array init_otp_array[] = {
	{0x0118, 0x00, 10},
	{0x0F02, 0x00, 0},
	{0x011A, 0x01, 0},
	{0x011B, 0x09, 0},
	{0x0D04, 0x01, 0},
	{0x0D00, 0x07, 0},
	{0x004C, 0x01, 0},
	{0x003E, 0x01, 0},
	{0x0118, 0x01, 10},
};


static struct msm_camera_i2c_reg_array otp_to_norm_mode_array[] = {
	{0x0118, 0x00, 0},
	{0x003E, 0x00, 0},
	{0x0118, 0x01, 0},
};

static struct msm_camera_i2c_reg_array init_reg_array0[] = {
	{0x0118, 0x0000},
	{0x0E00, 0x0101},
	{0x0E02, 0x0101},
	{0x0E04, 0x0101},
	{0x0E06, 0x0101},
	{0x0E08, 0x0101},
	{0x0E0A, 0x0101},
	{0x0E0C, 0x0101},
	{0x0E0E, 0x0101},
	{0x2000, 0x4031},
	{0x2002, 0x8400},
	{0x2004, 0x425F},
	{0x2006, 0x0118},
	{0x2008, 0xF37F},
	{0x200a, 0x930F},
	{0x200c, 0x2002},
	{0x200e, 0x0CC8},
	{0x2010, 0x3FF9},
	{0x2012, 0x4F82},
	{0x2014, 0x8050},
	{0x2016, 0x43D2},
	{0x2018, 0x0A80},
	{0x201a, 0x43D2},
	{0x201c, 0x0180},
	{0x201e, 0x43D2},
	{0x2020, 0x019A},
	{0x2022, 0x40F2},
	{0x2024, 0x0009},
	{0x2026, 0x019B},
	{0x2028, 0x4392},
	{0x202a, 0x760E},
	{0x202c, 0x93C2},
	{0x202e, 0x0118},
	{0x2030, 0x2005},
	{0x2032, 0x43C2},
	{0x2034, 0x0A80},
	{0x2036, 0x0B00},
	{0x2038, 0x7302},
	{0x203a, 0xFFF0},
	{0x203c, 0x9382},
	{0x203e, 0x760C},
	{0x2040, 0x2002},
	{0x2042, 0x0C64},
	{0x2044, 0x3FF3},
	{0x2046, 0x0260},
	{0x2048, 0x0000},
	{0x204a, 0x0C18},
	{0x204c, 0x0240},
	{0x204e, 0x0000},
	{0x2050, 0x0260},
	{0x2052, 0x0000},
	{0x2054, 0x0C05},
	{0x2056, 0x4292},
	{0x2058, 0x018A},
	{0x205a, 0x7600},
	{0x205c, 0x0270},
	{0x205e, 0x0000},
	{0x2060, 0x0C07},
	{0x2062, 0x0270},
	{0x2064, 0x0001},
	{0x2066, 0x421F},
	{0x2068, 0x7606},
	{0x206a, 0x4FC2},
	{0x206c, 0x0188},
	{0x206e, 0x0261},
	{0x2070, 0x0000},
	{0x2072, 0x3FDA},
	{0x2074, 0x4030},
	{0x2076, 0xF078},
	{0x2078, 0xDF02},
	{0x207a, 0x3FFE},
	{0x207c, 0x0000},
	{0x2ffe, 0xf000},
	{0x004C, 0x0100},
	{0x003C, 0x0000},
	{0x0118, 0x0100},
};

#endif

