/* 
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
/*
 * Definitions for AL3320 als/ps sensor chip.
 */
#ifndef __AL3320_H__
#define __AL3320_H__

#include <linux/ioctl.h>

#define AL3320_NUM_CACHABLE_REGS	15

#define AL3320_MODE_COMMAND	0x00
#define AL3320_MODE_SHIFT	(0)
#define AL3320_MODE_MASK	0x01

#define AL3320_INT_COMMAND	0x01
#define AL3320_INT_SHIFT	(0)
#define AL3320_INT_MASK		0x01

#define AL3320_INT_ENABLE	0x02
#define AL3320_INT_ENABLE_SHIFT	(3)
#define AL3320_INT_ENABLE_MASK	0x08
#define AL3320_SUS_ENABLE_SHIFT	(2)
#define AL3320_SUS_ENABLE_MASK	0x04

#define AL3320_WAITING_TIME	0x06
#define AL3320_WAITING_SHIFT	(0)
#define AL3320_WAITING_MASK	0xff

#define AL3320_RAN_COMMAND	0x07
#define AL3320_RAN_MASK		0x06
#define AL3320_RAN_SHIFT	(1)
#define AL3320_EXGAIN_MASK		0x01
#define AL3320_EXGAIN_SHIFT	(0)

#define AL3320_ALS_PERSIST		0x08
#define AL3320_PERSIST_SHIFT	(0)
#define AL3320_PERSIST_MASK		0x3f

#define AL3320_ALS_MEANTIME		0x09
#define AL3320_MEANTIME_SHIFT	(0)
#define AL3320_MEANTIME_MASK	0x0f

#define AL3320_ALS_ADUMMY		0x0a
#define AL3320_ADUMMY_SHIFT		(0)
#define AL3320_ADUMMY_MASK		0xff

#define	AL3320_ADC_LSB		0x22
#define	AL3320_ADC_MSB		0x23

#define AL3320_ALS_LTHL			0x30
#define AL3320_ALS_LTHL_SHIFT	(0)
#define AL3320_ALS_LTHL_MASK	0xff

#define AL3320_ALS_LTHH			0x31
#define AL3320_ALS_LTHH_SHIFT	(0)
#define AL3320_ALS_LTHH_MASK	0xff

#define AL3320_ALS_HTHL			0x32
#define AL3320_ALS_HTHL_SHIFT	(0)
#define AL3320_ALS_HTHL_MASK	0xff

#define AL3320_ALS_HTHH			0x33
#define AL3320_ALS_HTHH_SHIFT	(0)
#define AL3320_ALS_HTHH_MASK	0xff

#define ALS_ACTIVE    0x01
#define ALS_DEACTIVE    0x00
#define ALS_RESET    0x04

#define ENABLE	0X01
#define DISABLE	0X00

#define ALS_NO_WAITING    0x00

#define ALS_RAN_0	0x00
#define ALS_RAN_1	0x01
#define ALS_RAN_2	0x02
#define ALS_RAN_3	0x03

#define ALS_LOW_GAIN	0x00
#define ALS_HIGH_GAIN	0x01

#define ALS_ADUMMY_0	(53)
#define ALS_ADUMMY_1	(43)
#define ALS_ADUMMY_2	(3)
#define ALS_ADUMMY_3	(2)

#define AL3320_SUCCESS			0
#define AL3320_ERR_I2C			-1
#define AL3320_ERR_STATUS			-3
#define AL3320_ERR_SETUP_FAILURE	-4
#define AL3320_ERR_GETGSENSORDATA	-5
#define AL3320_ERR_IDENTIFICATION	-6


#define ADD_TO_IDX(addr,idx)	{					\
					int i;			\
					for(i = 0; i < AL3320_NUM_CACHABLE_REGS; i++)	\
					{						\
						if (addr == al3320_reg[i])		\
						{						\
							idx = i;				\
							break;					\
						}					\
					}						\
				}

static u8 al3320_reg[AL3320_NUM_CACHABLE_REGS] = 
	{0x00,0x01,0x02,0x06,0x07,0x08,0x09,0x0a,0x22,0x23,0x30,0x31,0x32,0x33,0x34};

// AL3320 range
static long al3320_range[8] = {33280,8320,2080,650,100000,25000,6250,1950};


int al3320_cali = 100;
// User settings. Customer can change the settings here.

u8 als_polling = 1;					/* Set the polling mode or int mode here. 0 = interrupt mode, 1 = polling mode */
u16 als_poll_delay = 200;			/* Set polling delay (ms) for polling mode */
u8 als_range = ALS_RAN_1;			/* Set range of ALS */
u8 als_exgain = ALS_HIGH_GAIN;		/* Set exgain of ALS */
u8 als_meantime = 0x0f;				/* Set meantime of ALS */
u16 als_low_threshold = 0x00;		/* Set low threshold of ALS */
u16 als_high_threshold = 0xffff;	/* Set high threshold of ALS */
u8 als_persist = 0;					/* Set persist of ALS */
#endif
