/* 
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
/*
 * Definitions for BH1745 als/ps sensor chip.
 */
#ifndef __BH1745_H__
#define __BH1745_H__

#include <linux/ioctl.h>

#define BH1745_NUM_CACHABLE_REGS	7

/* BH1745 REGSTER */
#define REG_SYSTEMCONTROL      (0x40)
#define REG_MODECONTROL1       (0x41)
#define REG_MODECONTROL2       (0x42)
#define REG_MODECONTROL3       (0x44)
#define REG_READ_DATA          (0x50)
#define REG_RED_DATA          (0x50)
#define REG_GREEN_DATA          (0x52)
#define REG_BLUE_DATA          (0x54)
#define REG_CLEAR_DATA          (0x56)
#define REG_INTERRUPT          (0x60)
#define REG_THRED_HIGH          (0x62)
#define REG_THRED_LOW          (0x64)
#define REG_MANUFACT_ID           (0x92)

/************ define parameter for register ************/
/* REG_SYSTEMCONTROL(0x40) */
#define SW_RESET               (1 << 7)
#define INT_RESET              (1 << 6)

/* REG_MODECONTROL1(0x41) */
#define MEASURE_160MS          (0x00)
#define MEASURE_320MS          (0x01)
#define MEASURE_640MS          (0x02)
#define MEASURE_1280MS          (0x03)
#define MEASURE_2560MS          (0x04)
#define MEASUREMENT_MAX        (0x05)

/* REG_MODECONTROL2(0x42) */
#define ADC_GAIN_X1            (0x00)
#define ADC_GAIN_X2            (0x01)
#define ADC_GAIN_X16            (0x02)
#define RGBC_EN_ON             (1 << 4)
#define RGBC_EN_OFF            (0 << 4)
#define RGBC_VALID_HIGH        (1 << 7)

/************ definition to dependent on sensor IC ************/
#define BH1745_I2C_ADDRESS     (0x38) //7 bits slave address 011 1001

/************ set initial parameter to IC ************/
#define RGB_SET_MODE_CONTROL1  (MEASURE_160MS)
#define RGB_SET_MODE_CONTROL2  (ADC_GAIN_X1 | RGBC_EN_OFF)

/* Interface parameter of file system */
#define RGB_DISABLE            (0)
#define RGB_ENABLE             (1)

#define PS_ALS_SET_MIN_DELAY_TIME (500)	

#define FT_VTG_MIN_UV           2600000
#define FT_VTG_MAX_UV           3300000
#define FT_I2C_VTG_MIN_UV       1800000
#define FT_I2C_VTG_MAX_UV       1800000

/* OTHER */
#ifdef _ALS_BIG_ENDIAN_
#define CONVERT_TO_BE(value) ((((value) >> 8) & 0xFF) | (((value) << 8) & 0xFF00))
#else
#define CONVERT_TO_BE(value) (value)
#endif	
static u8 bh1745_reg[BH1745_NUM_CACHABLE_REGS] = 
	{0x40,0x41,0x42,0x44,0x60,0x61,0x92};
	/* Set persist of ALS */
/************ typedef struct ************/
/* structure to read data value from sensor */
typedef struct {
    unsigned short red;         /* data value of red data from sensor */
    unsigned short green;       /* data value of green data from sensor */
    unsigned short blue;        /* data value of blue data from sensor */
    unsigned short clear;       /* data value of clear data from sensor */
} READ_DATA_ARG;

/* structure to read data value from sensor */
typedef struct {
    //unsigned long lux;          /* data value of lux data from sensor */
    //unsigned long color_temp;   /* data value of temperature data from sensor */
    int lux;
    int color_temp;
} CALC_DATA_ARG;
#endif
