
#ifndef __ALS_SUB_H__
#define __ALS_SUB_H__


#include <linux/wakelock.h>
#include <linux/interrupt.h>
#include <linux/miscdevice.h>
#include <linux/platform_device.h>
#include <linux/input.h>
#include <linux/workqueue.h>
#include <linux/slab.h>
#include <linux/module.h>
#include <linux/hwmsensor.h>
#include <linux/earlysuspend.h> 
#include <linux/hwmsen_dev.h>

#define ALS_SUB_TAG					"<ALS_SUB> "
#define ALS_SUB_FUN(f)			printk(ALS_SUB_TAG"%s\n", __func__)
#define ALS_SUB_ERR(fmt, args...)	printk(ALS_SUB_TAG"%s %d : "fmt, __func__, __LINE__, ##args)
#define ALS_SUB_LOG(fmt, args...)	printk(ALS_SUB_TAG fmt, ##args)
#define ALS_SUB_VER(fmt, args...)   printk(ALS_SUB_TAG"%s: "fmt, __func__, ##args) //((void)0)

#define   OP_ALS_SUB_DELAY	0X01
#define	OP_ALS_SUB_ENABLE	0X02
#define	OP_ALS_SUB_GET_DATA	0X04

#define ALS_SUB_INVALID_VALUE -1

#define EVENT_TYPE_ALS_SUB_VALUE         		ABS_X
#define EVENT_TYPE_ALS_SUB_STATUS     		ABS_WHEEL


#define ALS_SUB_VALUE_MAX (32767)
#define ALS_SUB_VALUE_MIN (-32768)
#define ALS_SUB_STATUS_MIN (0)
#define ALS_SUB_STATUS_MAX (64)
#define ALS_SUB_DIV_MAX (32767)
#define ALS_SUB_DIV_MIN (1)


#define MAX_CHOOSE_ALS_SUB_NUM 5

struct als_sub_control_path
{
	int (*open_report_data)(int open);//open data rerport to HAL
	int (*enable_nodata)(int en);//only enable not report event to HAL
	int (*set_delay)(u64 delay);
	int (*access_data_fifo)(void);//version2.used for flush operate
	bool is_report_input_direct;
	bool is_support_batch;//version2.used for batch mode support flag
	bool is_polling_mode;
	bool is_use_common_factory;
};

struct als_sub_data_path
{
	int (*get_data)(int *als_value, int *status);
	int (*als_get_raw_data)(int *als_value);
	int vender_div;
};

struct als_sub_init_info
{
    	char *name;
	int (*init)(void);
	int (*uninit)(void);
	struct platform_driver* platform_diver_addr;
};

struct als_sub_data{
	hwm_sensor_data als_data ;
	int data_updata;
};

struct als_sub_drv_obj {
    void *self;
	int polling;
	int (*als_sub_operate)(void* self, uint32_t command, void* buff_in, int size_in,
		void* buff_out, int size_out, int* actualout);
};

struct als_sub_context {
	/*lenovo-sw molg1 add 20141126 begin*/
	struct input_dev   		*idev_als;
	/*lenovo-sw molg1 add 20141126 end*/
	struct miscdevice   	mdev;
	struct work_struct  	report_als;
	struct mutex 			als_sub_op_mutex;
	struct timer_list   		timer_als;  /*als polling timer */
	
	atomic_t            		trace;
	atomic_t            		delay_als; /*als polling period for reporting input event*/
	atomic_t            		wake;  /*user-space request to wake-up, used with stop*/

	struct early_suspend   early_drv;
	atomic_t                	early_suspend;

	struct als_sub_data       	drv_data;
	struct als_sub_control_path	als_ctl;
	struct als_sub_data_path   	als_data;
	
	bool					is_als_active_nodata;// Active, but HAL don't need data sensor. such as orientation need
	bool					is_als_active_data;// Active and HAL need data .

	bool 				is_als_first_data_after_enable;
	bool 				is_als_polling_run;
	bool 				is_als_batch_enable;	//version2.this is used for judging whether sensor is in batch mode

	bool 				is_get_valid_als_data_after_enable;
};

//AAL Functions
extern int als_sub_aal_enable(int enable);
extern int als_sub_aal_get_status(void);
extern int als_sub_aal_get_data(void);

//for auto detect
extern int als_sub_driver_add(struct als_sub_init_info* obj) ;
extern int als_sub_report_interrupt_data(int value);
extern int als_sub_data_report(struct input_dev *dev, int value,int status);
extern int als_sub_register_control_path(struct als_sub_control_path *ctl);
extern int als_sub_register_data_path(struct als_sub_data_path *data);

#endif
