/* BEGIN PN:DTS2013053103858 , Added by d00238048, 2013.05.31*/
#ifndef BUILD_LK
#include <linux/string.h>
#endif
#include "lcm_drv.h"

#ifdef BUILD_LK
    #include <platform/disp_drv_platform.h>
	
#elif defined(BUILD_UBOOT)
    #include <asm/arch/mt_gpio.h>
    #include <platform/mt_pmic.h>
#else
    #include <linux/delay.h>
    #include <mach/mt_gpio.h>
    #include <mach/mt_pm_ldo.h>
#endif
#ifdef BUILD_LK
#define LCD_DEBUG(fmt)  dprintf(CRITICAL,fmt)
#else
#define LCD_DEBUG(fmt)  printk(fmt)
#endif

// ---------------------------------------------------------------------------
//  Local Constants
// ---------------------------------------------------------------------------
#define FRAME_WIDTH  										(800)
#define FRAME_HEIGHT 										(1280)

#ifndef TRUE
    #define TRUE 1
#endif

#ifndef FALSE
    #define FALSE 0
#endif

#define LCD_VCC_EN        			GPIO_LCM_LVDS_PWR_EN //GPIO119
#define DISP_RSTN_CONN   		GPIO_LCM_MIPI2LVDS_EN //GPIO112

// ---------------------------------------------------------------------------
//  Local Variables
// ---------------------------------------------------------------------------

static LCM_UTIL_FUNCS lcm_util = {0};

// ---------------------------------------------------------------------------
//  Local Functions
// ---------------------------------------------------------------------------

#define dsi_set_cmdq_V3(para_tbl,size,force_update)        lcm_util.dsi_set_cmdq_V3(para_tbl,size,force_update)
#define dsi_set_cmdq_V2(cmd, count, ppara, force_update)	lcm_util.dsi_set_cmdq_V2(cmd, count, ppara, force_update)
#define dsi_set_cmdq(pdata, queue_size, force_update)		lcm_util.dsi_set_cmdq(pdata, queue_size, force_update)
#define wrtie_cmd(cmd)										lcm_util.dsi_write_cmd(cmd)
#define write_regs(addr, pdata, byte_nums)					lcm_util.dsi_write_regs(addr, pdata, byte_nums)
#define read_reg(cmd)										lcm_util.dsi_dcs_read_lcm_reg(cmd)
#define read_reg_v2(cmd, buffer, buffer_size)   			lcm_util.dsi_dcs_read_lcm_reg_v2(cmd, buffer, buffer_size)    

//update initial param for IC nt35521 0.01
static LCM_setting_table_V3 lcm_initialization_setting_innolux[] = {
	{0x39, 0xFF,4,{0xAA,0x55,0xA5,0x80}},
	{0x39, 0x6F,2,{0x11,0x00}},
	{0x39, 0xF7,2,{0x20,0x00}},
	{0x15, 0x6F,1,{0x06}},
	{0x15, 0xF7,1,{0xA0}},
	{0x15, 0x6F,1,{0x19}},
	{0x15, 0xF7,1,{0x12}},
	{0x15, 0xF4,1,{0x03}},
	{0x15, 0x6F,1,{0x06}},
	{0x15, 0xFC,1,{0x03}},
	{0x39, 0xF0,5,{0x55,0xAA,0x52,0x08,0x00}},
	{0x15, 0xC8,1,{0x00}},
	{0x39, 0xB1,2,{0x6C,0x01}},
	{0x15, 0xB6,1,{0x08}},
	{0x15, 0x6F,1,{0x02}},
	{0x15, 0xB8,1,{0x08}},
	{0x39, 0xBB,2,{0x74,0x44}},
	{0x39, 0xBC,2,{0x00,0x00}},
	{0x39, 0xBD,5,{0x02,0xB0,0x0C,0x0A,0x00}},
	{0x39, 0xF0,5,{0x55,0xAA,0x52,0x08,0x01}},
	{0x39, 0xB0,2,{0x05,0x05}},
	{0x39, 0xB1,2,{0x05,0x05}},
	{0x39, 0xBC,2,{0x90,0x01}},
	{0x39, 0xBD,2,{0x90,0x01}},
	{0x15, 0xCA,1,{0x00}},
	{0x15, 0xC0,1,{0x04}},
	{0x39, 0xB3,2,{0x37,0x37}},
	{0x39, 0xB4,2,{0x19,0x19}},
	{0x39, 0xB9,2,{0x45,0x45}},
	{0x39, 0xBA,2,{0x25,0x25}},
	{0x39, 0xF0,5,{0x55,0xAA,0x52,0x08,0x02}},
	{0x15, 0xEE,1,{0x02}},
	{0x39, 0xEF,4,{0x09,0x06,0x15,0x18}},
	{0x39, 0xB0,6,{0x00,0x00,0x00,0x19,0x00,0x31}},
	{0x15, 0x6F,1,{0x06}},
	{0x39, 0xB0,6,{0x00,0x4B,0x00,0x63,0x00,0x95}},
	{0x15, 0x6F,1,{0x0C}},
	{0x39, 0xB0,4,{0x00,0xB4,0x00,0xF3}},
	{0x39, 0xB1,6,{0x01,0x24,0x01,0x70,0x01,0xA6}},
	{0x15, 0x6F,1,{0x06}},
	{0x39, 0xB1,6,{0x01,0xFC,0x02,0x49,0x02,0x4C}},
	{0x15, 0x6F,1,{0x0C}},
	{0x39, 0xB1,4,{0x02,0x96,0x02,0xEC}},
	{0x39, 0xB2,6,{0x03,0x1D,0x03,0x5A,0x03,0x81}},
	{0x15, 0x6F,1,{0x06}},
	{0x39, 0xB2,6,{0x03,0xA2,0x03,0xB6,0x03,0xCB}},
	{0x15, 0x6F,1,{0x0C}},
	{0x39, 0xB2,4,{0x03,0xD9,0x03,0xE8}},
	{0x39, 0xB3,4,{0x03,0xF7,0x03,0xFF}},
	{0x39, 0xBC,6,{0x00,0x00,0x00,0x19,0x00,0x31}},
	{0x15, 0x6F,1,{0x06}},
	{0x39, 0xBC,6,{0x00,0x4B,0x00,0x63,0x00,0x95}},
	{0x15, 0x6F,1,{0x0C}},
	{0x39, 0xBC,4,{0x00,0xB4,0x00,0xF3}},
	{0x39, 0xBD,6,{0x01,0x24,0x01,0x70,0x01,0xA6}},
	{0x15, 0x6F,1,{0x06}},
	{0x39, 0xBD,6,{0x01,0xFC,0x02,0x49,0x02,0x4C}},
	{0x15, 0x6F,1,{0x0C}},
	{0x39, 0xBD,4,{0x02,0x96,0x02,0xEC}},
	{0x39, 0xBE,6,{0x03,0x1D,0x03,0x5A,0x03,0x81}},
	{0x15, 0x6F,1,{0x06}},
	{0x39, 0xBE,6,{0x03,0xA2,0x03,0xB6,0x03,0xCB}},
	{0x15, 0x6F,1,{0x0C}},
	{0x39, 0xBE,4,{0x03,0xD9,0x03,0xE8}},
	{0x39, 0xBF,4,{0x03,0xF7,0x03,0xFF}},
	{0x39, 0xF0,5,{0x55,0xAA,0x52,0x08,0x06}},
	{0x39, 0xB0,2,{0x00,0x10}},
	{0x39, 0xB1,2,{0x12,0x14}},
	{0x39, 0xB2,2,{0x16,0x18}},
	{0x39, 0xB3,2,{0x1A,0x29}},
	{0x39, 0xB4,2,{0x2A,0x08}},
	{0x39, 0xB5,2,{0x31,0x31}},
	{0x39, 0xB6,2,{0x31,0x31}},
	{0x39, 0xB7,2,{0x31,0x31}},
	{0x39, 0xB8,2,{0x31,0x0A}},
	{0x39, 0xB9,2,{0x31,0x31}},
	{0x39, 0xBA,2,{0x31,0x31}},
	{0x39, 0xBB,2,{0x0B,0x31}},
	{0x39, 0xBC,2,{0x31,0x31}},
	{0x39, 0xBD,2,{0x31,0x31}},
	{0x39, 0xBE,2,{0x31,0x31}},
	{0x39, 0xBF,2,{0x09,0x2A}},
	{0x39, 0xC0,2,{0x29,0x1B}},
	{0x39, 0xC1,2,{0x19,0x17}},
	{0x39, 0xC2,2,{0x15,0x13}},
	{0x39, 0xC3,2,{0x11,0x01}},
	{0x39, 0xE5,2,{0x31,0x31}},
	{0x39, 0xC4,2,{0x09,0x1B}},
	{0x39, 0xC5,2,{0x19,0x17}},
	{0x39, 0xC6,2,{0x15,0x13}},
	{0x39, 0xC7,2,{0x11,0x29}},
	{0x39, 0xC8,2,{0x2A,0x01}},
	{0x39, 0xC9,2,{0x31,0x31}},
	{0x39, 0xCA,2,{0x31,0x31}},
	{0x39, 0xCB,2,{0x31,0x31}},
	{0x39, 0xCC,2,{0x31,0x0B}},
	{0x39, 0xCD,2,{0x31,0x31}},
	{0x39, 0xCE,2,{0x31,0x31}},
	{0x39, 0xCF,2,{0x0A,0x31}},
	{0x39, 0xD0,2,{0x31,0x31}},
	{0x39, 0xD1,2,{0x31,0x31}},
	{0x39, 0xD2,2,{0x31,0x31}},
	{0x39, 0xD3,2,{0x00,0x2A}},
	{0x39, 0xD4,2,{0x29,0x10}},
	{0x39, 0xD5,2,{0x12,0x14}},
	{0x39, 0xD6,2,{0x16,0x18}},
	{0x39, 0xD7,2,{0x1A,0x08}},
	{0x39, 0xE6,2,{0x31,0x31}},
	{0x39, 0xD8,5,{0x00,0x00,0x00,0x54,0x00}},
	{0x39, 0xD9,5,{0x00,0x15,0x00,0x00,0x00}},
	{0x15, 0xE7,1,{0x00}},
	{0x39, 0xF0,5,{0x55,0xAA,0x52,0x08,0x03}},
	{0x39, 0xB0,2,{0x20,0x00}},
	{0x39, 0xB1,2,{0x20,0x00}},
	{0x39, 0xB2,5,{0x05,0x00,0x00,0x00,0x00}},
	{0x39, 0xB6,5,{0x05,0x00,0x00,0x00,0x00}},
	{0x39, 0xB7,5,{0x05,0x00,0x00,0x00,0x00}},
	{0x39, 0xBA,5,{0x57,0x00,0x00,0x00,0x00}},
	{0x39, 0xBB,5,{0x57,0x00,0x00,0x00,0x00}},
	{0x39, 0xC0,4,{0x00,0x00,0x00,0x00}},
	{0x39, 0xC1,4,{0x00,0x00,0x00,0x00}},
	{0x15, 0xC4,1,{0x60}},
	{0x15, 0xC5,1,{0x40}},
	{0x39, 0xF0,5,{0x55,0xAA,0x52,0x08,0x05}},
	{0x39, 0xBD,5,{0x03,0x01,0x03,0x03,0x03}},
	{0x39, 0xB0,2,{0x17,0x06}},
	{0x39, 0xB1,2,{0x17,0x06}},
	{0x39, 0xB2,2,{0x17,0x06}},
	{0x39, 0xB3,2,{0x17,0x06}},
	{0x39, 0xB4,2,{0x17,0x06}},
	{0x39, 0xB5,2,{0x17,0x06}},
	{0x15, 0xB8,1,{0x00}},
	{0x15, 0xB9,1,{0x00}},
	{0x15, 0xBA,1,{0x00}},
	{0x15, 0xBB,1,{0x02}},
	{0x15, 0xBC,1,{0x00}},
	{0x15, 0xC0,1,{0x07}},
	{0x15, 0xC4,1,{0x80}},
	{0x15, 0xC5,1,{0xA4}},
	{0x39, 0xC8,2,{0x05,0x30}},
	{0x39, 0xC9,2,{0x01,0x31}},
	{0x39, 0xCC,3,{0x00,0x00,0x3C}},
	{0x39, 0xCD,3,{0x00,0x00,0x3C}},
	{0x39, 0xD1,5,{0x00,0x04,0xFD,0x07,0x10}},
	{0x39, 0xD2,5,{0x00,0x05,0x02,0x07,0x10}},
	{0x15, 0xE5,1,{0x06}},
	{0x15, 0xE6,1,{0x06}},
	{0x15, 0xE7,1,{0x06}},
	{0x15, 0xE8,1,{0x06}},
	{0x15, 0xE9,1,{0x06}},
	{0x15, 0xEA,1,{0x06}},
	{0x15, 0xED,1,{0x30}},
	{0x15, 0x6F,1,{0x11}},
	{0x15, 0xF3,1,{0x01}},
	{0x15, 0x35,1, {0x00}},
	{0x05, 0x11,0,{}},
	{REGFLAG_ESCAPE_ID,REGFLAG_DELAY_MS_V3,120,{}},
	{0x05, 0x29,0,{}},
	{REGFLAG_ESCAPE_ID,REGFLAG_DELAY_MS_V3,20,{}},
};

// ---------------------------------------------------------------------------
//  LCM Driver Implementations
// ---------------------------------------------------------------------------

static void lcm_set_util_funcs(const LCM_UTIL_FUNCS *util)
{
    memcpy(&lcm_util, util, sizeof(LCM_UTIL_FUNCS));
}

static void lcm_get_params(LCM_PARAMS *params)
{
    memset(params, 0, sizeof(LCM_PARAMS));
    params->type   						= LCM_TYPE_DSI;
    params->width  					= FRAME_WIDTH;
    params->height 					= FRAME_HEIGHT;

    params->dsi.mode   					= SYNC_PULSE_VDO_MODE;

    // DSI
    /* Command mode setting */
    params->dsi.LANE_NUM				= LCM_FOUR_LANE;
    //The following defined the fomat for data coming from LCD engine.
    params->dsi.data_format.color_order 	= LCM_COLOR_ORDER_RGB;
    params->dsi.data_format.trans_seq   	= LCM_DSI_TRANS_SEQ_MSB_FIRST;
    params->dsi.data_format.padding     	= LCM_DSI_PADDING_ON_LSB;
    params->dsi.data_format.format      	= LCM_DSI_FORMAT_RGB888;

   // Highly depends on LCD driver capability.
   //video mode timing

    params->dsi.PS						= LCM_PACKED_PS_24BIT_RGB888;

    params->dsi.vertical_sync_active		= 4;
    params->dsi.vertical_backporch		= 20;
    params->dsi.vertical_frontporch		= 20;
    params->dsi.vertical_active_line		= FRAME_HEIGHT;

    params->dsi.horizontal_sync_active	= 4;
    params->dsi.horizontal_backporch	= 40;
    params->dsi.horizontal_frontporch	= 40;
    params->dsi.horizontal_active_pixel	= FRAME_WIDTH;

    //improve clk quality
    params->dsi.PLL_CLOCK 				= 234; //this value must be in MTK suggested table
    params->dsi.compatibility_for_nvk 	= 1;
    params->dsi.ssc_disable 				= 1;
}
static void lcm_init_innolux(void)
{
    //enable power
#ifdef BUILD_LK
    upmu_set_rg_vgp3_vosel(3);//3=1.8v
    upmu_set_rg_vgp3_en(1);
#else
    hwPowerOn(MT6322_POWER_LDO_VGP3, VOL_1800, "LCM");
#endif
    lcm_util.set_gpio_out(LCD_VCC_EN, GPIO_OUT_ONE);
    msleep(50);
    //reset high to low to high
    lcm_util.set_gpio_out(DISP_RSTN_CONN, GPIO_OUT_ONE);
    mdelay(50);
    lcm_util.set_gpio_out(DISP_RSTN_CONN, GPIO_OUT_ZERO);
    mdelay(50);
    lcm_util.set_gpio_out(DISP_RSTN_CONN, GPIO_OUT_ONE);
    msleep(150);

    dsi_set_cmdq_V3(lcm_initialization_setting_innolux, sizeof(lcm_initialization_setting_innolux) / sizeof(lcm_initialization_setting_innolux[0]), 1);  

    LCD_DEBUG("uboot:innolux_nt35521_lcm_init\n");
}

static void lcm_suspend(void)
{
    unsigned int data_array[16];

    data_array[0]=0x00280500; // Display Off
    dsi_set_cmdq(data_array, 1, 1);
	
    data_array[0] = 0x00100500; // Sleep In
    dsi_set_cmdq(data_array, 1, 1);

    //reset low
    lcm_util.set_gpio_out(DISP_RSTN_CONN, GPIO_OUT_ZERO);
    mdelay(5);
    //disable power
    lcm_util.set_gpio_out(LCD_VCC_EN, GPIO_OUT_ZERO);
#ifndef BUILD_LK
    hwPowerDown(MT6322_POWER_LDO_VGP3, "LCM");
#endif
    mdelay(5);	
    LCD_DEBUG("uboot:innolux_nt35521_lcm_suspend\n");
}
static void lcm_resume_innolux(void)
{
    //enable power
#ifdef BUILD_LK
    upmu_set_rg_vgp3_vosel(3);//3=1.8v
    upmu_set_rg_vgp3_en(1);
#else
    hwPowerOn(MT6322_POWER_LDO_VGP3, VOL_1800, "LCM");
#endif
    lcm_util.set_gpio_out(LCD_VCC_EN, GPIO_OUT_ONE);
    msleep(50);

    //reset low to high
    lcm_util.set_gpio_out(DISP_RSTN_CONN, GPIO_OUT_ONE);
    mdelay(50);
    lcm_util.set_gpio_out(DISP_RSTN_CONN, GPIO_OUT_ZERO);
    mdelay(50);
    lcm_util.set_gpio_out(DISP_RSTN_CONN, GPIO_OUT_ONE);
    msleep(150);

    dsi_set_cmdq_V3(lcm_initialization_setting_innolux, sizeof(lcm_initialization_setting_innolux) / sizeof(lcm_initialization_setting_innolux[0]), 1);

    LCD_DEBUG("uboot:innolux_nt35521_lcm_resume\n");
}

static unsigned int lcm_compare_id_innolux(void)
{
    unsigned char LCD_ID_value = 0;

    LCD_ID_value = mt_get_gpio_in(GPIO29);
    return (LCD_ID_value != 0)?1:0; 
}
LCM_DRIVER nt35521_wxga_innolux_lcm_drv =
{
    .name           = "nt35521_wxga_dsi_video_innolux",
    .set_util_funcs = lcm_set_util_funcs,
    .get_params     = lcm_get_params,
    .init           = lcm_init_innolux,/*tianma init fun.*/
    .suspend        = lcm_suspend,
    .resume         = lcm_resume_innolux,
    .compare_id     = lcm_compare_id_innolux,
   
};
