#ifndef _CUST_BATTERY_METER_TABLE_H
#define _CUST_BATTERY_METER_TABLE_H

#include <mach/mt_typedefs.h>

/* ============================================================ */
/* define */
/* ============================================================ */
#define BAT_NTC_10 1
#define BAT_NTC_47 0

#if (BAT_NTC_10 == 1)
#define RBAT_PULL_UP_R             24000
#endif

#if (BAT_NTC_47 == 1)
#define RBAT_PULL_UP_R             61900
#endif

#define RBAT_PULL_UP_VOLT          2800

/* multiple battery profile compile options */
#define MTK_GET_BATTERY_ID_BY_AUXADC
//lenovo-sw mahj2 modify for get battery ID Begin
#define BATTERY_ID_CHANNEL_NUM 13
#define TOTAL_BATTERY_NUMBER 2
//lenovo-sw mahj2 modify for get battery ID End
/*#define MTK_GET_BATTERY_ID_BY_GPIO*/

/* ============================================================ */
/* ENUM */
/* ============================================================ */

/* ============================================================ */
/* structure */
/* ============================================================ */

/* ============================================================ */
/* typedef */
/* ============================================================ */
typedef struct _BATTERY_PROFILE_STRUCT {
	kal_int32 percentage;
	kal_int32 voltage;
} BATTERY_PROFILE_STRUCT, *BATTERY_PROFILE_STRUCT_P;

typedef struct _R_PROFILE_STRUCT {
	kal_int32 resistance;	/* Ohm */
	kal_int32 voltage;
} R_PROFILE_STRUCT, *R_PROFILE_STRUCT_P;

typedef enum {
	T1_0C,
	T2_25C,
	T3_50C
} PROFILE_TEMPERATURE;

/* ============================================================ */
/* External Variables */
/* ============================================================ */

/* ============================================================ */
/* External function */
/* ============================================================ */

/* ============================================================ */
/* <DOD, Battery_Voltage> Table */
/* ============================================================ */

/* Qmax for battery  */
kal_int32 g_Q_MAX_POS_50[TOTAL_BATTERY_NUMBER] = { 3430, 3465 };
kal_int32 g_Q_MAX_POS_25[TOTAL_BATTERY_NUMBER] = { 3500, 3465 };
kal_int32 g_Q_MAX_POS_0[TOTAL_BATTERY_NUMBER] = { 2710, 2695 };
kal_int32 g_Q_MAX_NEG_10[TOTAL_BATTERY_NUMBER] = { 1915, 1599 };

kal_int32 g_Q_MAX_POS_50_H_CURRENT[TOTAL_BATTERY_NUMBER] = { 3361, 3396 };
kal_int32 g_Q_MAX_POS_25_H_CURRENT[TOTAL_BATTERY_NUMBER] = { 3430, 3396 };
kal_int32 g_Q_MAX_POS_0_H_CURRENT[TOTAL_BATTERY_NUMBER] = { 2656, 2641 };
kal_int32 g_Q_MAX_NEG_10_H_CURRENT[TOTAL_BATTERY_NUMBER] = { 1877, 1567 };

kal_int32 g_Q_MAX_SYS_VOLTAGE[TOTAL_BATTERY_NUMBER] = { 3350, 3350 };
kal_int32 g_BATTERYPSEUDO1[TOTAL_BATTERY_NUMBER] = { 2, 2 };

/* 0~0.5V for battery 0, 0.5~1V for battery 1, 1~1.5V for battery 2, -1 for the last one (battery 3) */
kal_int32 g_battery_id_voltage[TOTAL_BATTERY_NUMBER] = { 600000, -1 };

#if (BAT_NTC_10 == 1)
BATT_TEMPERATURE Batt_Temperature_Table[TOTAL_BATTERY_NUMBER][17] = {
	{
	{-20, 67790},
	{-15, 53460},
	{-10, 42450},
	{-5, 33930},
	{0, 27280},
	{5, 22070},
	{10, 17960},
	{15, 14700},
	{20, 12090},
	{25, 10000},
	{30, 8312},
	{35, 6942},
	{40, 5826},
	{45, 4911},
	{50, 4158},
	{55, 3536},
	{60, 3019}
	 },
	{
 	{-20, 67790},
	{-15, 53460},
	{-10, 42450},
	{-5, 33930},
	{0, 27280},
	{5, 22070},
	{10, 17960},
	{15, 14700},
	{20, 12090},
	{25, 10000},
	{30, 8312},
	{35, 6942},
	{40, 5826},
	{45, 4911},
	{50, 4158},
	{55, 3536},
	{60, 3019}
	 }

};
#endif

#if (BAT_NTC_47 == 1)
BATT_TEMPERATURE Batt_Temperature_Table[TOTAL_BATTERY_NUMBER][17] = {
	{
	 {-20, 483954},
	 {-15, 360850},
	 {-10, 271697},
	 {-5, 206463},
	 {0, 158214},
	 {5, 122259},
	 {10, 95227},
	 {15, 74730},
	 {20, 59065},
	 {25, 47000},
	 {30, 37643},
	 {35, 30334},
	 {40, 24591},
	 {45, 20048},
	 {50, 16433},
	 {55, 13539},
	 {60, 11210}

	 },
	{
	 {-20, 483954},
	 {-15, 360850},
	 {-10, 271697},
	 {-5, 206463},
	 {0, 158214},
	 {5, 122259},
	 {10, 95227},
	 {15, 74730},
	 {20, 59065},
	 {25, 47000},
	 {30, 37643},
	 {35, 30334},
	 {40, 24591},
	 {45, 20048},
	 {50, 16433},
	 {55, 13539},
	 {60, 11210}
	 }

};
#endif

/* T0 -10C */
BATTERY_PROFILE_STRUCT battery_profile_t0[TOTAL_BATTERY_NUMBER][101] = {
	{
	{0,4406},
	{2,4380},
	{4,4369},
	{5,4358},
	{7,4337},
	{9,4326},
	{11,4316},
	{12,4297},
	{14,4288},
	{16,4280},
	{18,4263},
	{20,4255},
	{21,4247},
	{23,4230},
	{25,4222},
	{27,4214},
	{28,4199},
	{30,4192},
	{32,4184},
	{34,4168},
	{36,4153},
	{37,4145},
	{39,4137},
	{41,4121},
	{43,4114},
	{44,4106},
	{47,4094},
	{48,4090},
	{50,4086},
	{52,4076},
	{53,4064},
	{55,4052},
	{57,4014},
	{59,4000},
	{60,3985},
	{63,3965},
	{64,3958},
	{66,3950},
	{68,3938},
	{70,3928},
	{71,3924},
	{73,3920},
	{75,3912},
	{76,3908},
	{79,3904},
	{80,3895},
	{82,3890},
	{84,3885},
	{86,3876},
	{87,3871},
	{89,3866},
	{91,3858},
	{93,3854},
	{95,3849},
	{96,3841},
	{98,3838},
	{100,3834},
	{102,3827},
	{103,3820},
	{105,3817},
	{107,3814},
	{109,3808},
	{111,3806},
	{112,3803},
	{114,3798},
	{116,3796},
	{118,3794},
	{119,3790},
	{121,3789},
	{123,3788},
	{125,3785},
	{127,3784},
	{128,3782},
	{130,3780},
	{132,3779},
	{134,3778},
	{135,3775},
	{137,3774},
	{139,3773},
	{141,3771},
	{143,3767},
	{144,3765},
	{146,3763},
	{148,3759},
	{150,3756},
	{151,3754},
	{153,3749},
	{155,3746},
	{157,3743},
	{159,3736},
	{160,3732},
	{162,3728},
	{164,3720},
	{166,3713},
	{167,3707},
	{170,3703},
	{171,3700},
	{173,3695},
	{175,3693},
	{176,3689},
	{178,3687}
	 },
	{
	{0,4403},
	{2,4380},
	{4,4370},
	{7,4359},
	{9,4339},
	{11,4329},
	{13,4319},
	{15,4300},
	{17,4292},
	{19,4283},
	{21,4266},
	{23,4258},
	{25,4249},
	{28,4232},
	{30,4224},
	{32,4216},
	{34,4200},
	{36,4192},
	{38,4185},
	{41,4170},
	{43,4162},
	{45,4155},
	{47,4139},
	{49,4124},
	{51,4116},
	{54,4108},
	{55,4096},
	{57,4090},
	{59,4085},
	{62,4071},
	{64,4062},
	{66,4053},
	{68,4027},
	{70,4013},
	{72,3999},
	{75,3975},
	{77,3966},
	{79,3957},
	{81,3942},
	{83,3936},
	{86,3929},
	{88,3920},
	{89,3916},
	{91,3912},
	{94,3903},
	{96,3894},
	{98,3890},
	{100,3885},
	{102,3876},
	{104,3872},
	{107,3867},
	{109,3859},
	{111,3855},
	{113,3851},
	{115,3844},
	{117,3840},
	{120,3836},
	{122,3829},
	{124,3826},
	{125,3823},
	{128,3817},
	{130,3814},
	{132,3811},
	{134,3805},
	{136,3802},
	{138,3800},
	{141,3795},
	{143,3791},
	{145,3790},
	{147,3788},
	{149,3785},
	{151,3784},
	{154,3782},
	{156,3780},
	{158,3778},
	{160,3777},
	{162,3774},
	{164,3772},
	{166,3770},
	{168,3766},
	{170,3764},
	{173,3761},
	{175,3755},
	{177,3752},
	{179,3748},
	{181,3741},
	{183,3737},
	{186,3733},
	{188,3727},
	{190,3720},
	{192,3718},
	{194,3715},
	{196,3711},
	{198,3708},
	{200,3706},
	{202,3703},
	{204,3698},
	{207,3696},
	{209,3690},
	{211,3684},
	{213,3681}
	 }

};

/* T1 0C */
BATTERY_PROFILE_STRUCT battery_profile_t1[TOTAL_BATTERY_NUMBER][101] = {
	{
	{0,4389},
	{1,4368},
	{2,4358},
	{3,4348},
	{6,4329},
	{7,4319},
	{8,4309},
	{9,4292},
	{10,4284},
	{11,4276},
	{13,4259},
	{15,4244},
	{16,4236},
	{17,4227},
	{18,4212},
	{19,4204},
	{20,4196},
	{22,4181},
	{23,4174},
	{25,4166},
	{26,4151},
	{27,4136},
	{28,4128},
	{30,4120},
	{31,4106},
	{32,4100},
	{34,4093},
	{35,4088},
	{36,4083},
	{38,4078},
	{39,4053},
	{40,4018},
	{41,4005},
	{43,3992},
	{44,3974},
	{45,3967},
	{47,3960},
	{48,3948},
	{49,3943},
	{50,3938},
	{51,3928},
	{53,3920},
	{55,3915},
	{56,3910},
	{57,3899},
	{58,3893},
	{59,3887},
	{60,3877},
	{63,3867},
	{64,3862},
	{65,3858},
	{66,3850},
	{67,3846},
	{68,3842},
	{69,3835},
	{72,3832},
	{73,3828},
	{74,3822},
	{75,3816},
	{76,3814},
	{77,3811},
	{78,3806},
	{80,3803},
	{82,3800},
	{83,3796},
	{84,3794},
	{85,3792},
	{86,3788},
	{88,3784},
	{89,3783},
	{91,3782},
	{92,3779},
	{93,3778},
	{94,3777},
	{95,3775},
	{97,3774},
	{98,3773},
	{100,3770},
	{101,3768},
	{102,3766},
	{103,3764},
	{105,3759},
	{106,3757},
	{107,3755},
	{108,3749},
	{110,3746},
	{111,3742},
	{113,3734},
	{114,3725},
	{115,3720},
	{116,3715},
	{117,3705},
	{119,3702},
	{120,3699},
	{122,3694},
	{123,3692},
	{124,3691},
	{125,3685},
	{126,3670},
	{128,3646},
	{130,3622}
	 },
	{
	{0,4401},
	{1,4382},
	{3,4374},
	{4,4367},
	{5,4351},
	{6,4344},
	{8,4336},
	{9,4319},
	{10,4310},
	{12,4302},
	{13,4286},
	{14,4270},
	{16,4262},
	{17,4254},
	{18,4238},
	{19,4230},
	{21,4223},
	{22,4207},
	{23,4192},
	{25,4184},
	{26,4177},
	{27,4162},
	{29,4155},
	{30,4148},
	{31,4133},
	{32,4126},
	{34,4118},
	{35,4103},
	{36,4090},
	{38,4085},
	{39,4080},
	{40,4071},
	{42,4063},
	{43,4055},
	{44,4028},
	{45,4014},
	{47,3999},
	{48,3976},
	{49,3958},
	{51,3952},
	{52,3945},
	{53,3934},
	{55,3930},
	{56,3925},
	{57,3916},
	{58,3911},
	{60,3906},
	{61,3896},
	{62,3885},
	{64,3880},
	{65,3876},
	{66,3867},
	{68,3863},
	{69,3859},
	{70,3851},
	{71,3844},
	{73,3840},
	{74,3837},
	{75,3830},
	{77,3827},
	{78,3824},
	{79,3818},
	{81,3815},
	{82,3812},
	{83,3807},
	{84,3802},
	{86,3800},
	{87,3797},
	{88,3792},
	{90,3790},
	{91,3788},
	{92,3787},
	{94,3786},
	{95,3785},
	{96,3781},
	{97,3778},
	{99,3776},
	{100,3775},
	{101,3771},
	{103,3769},
	{104,3767},
	{105,3762},
	{106,3758},
	{108,3755},
	{109,3746},
	{110,3739},
	{112,3734},
	{113,3729},
	{114,3717},
	{116,3711},
	{117,3705},
	{118,3693},
	{119,3690},
	{121,3689},
	{122,3688},
	{123,3687},
	{125,3686},
	{126,3686},
	{127,3682},
	{129,3672},
	{130,3661}
	 }
};

/* T2 25C */
BATTERY_PROFILE_STRUCT battery_profile_t2[TOTAL_BATTERY_NUMBER][101] = {
	{
	{0,4389},
	{1,4370},
	{2,4362},
	{3,4353},
	{4,4336},
	{5,4327},
	{6,4318},
	{7,4301},
	{8,4292},
	{9,4284},
	{10,4267},
	{11,4250},
	{12,4242},
	{13,4234},
	{14,4217},
	{15,4209},
	{16,4201},
	{17,4186},
	{18,4178},
	{19,4170},
	{20,4154},
	{21,4139},
	{22,4131},
	{23,4123},
	{24,4108},
	{25,4100},
	{26,4093},
	{27,4081},
	{28,4078},
	{29,4076},
	{30,4061},
	{31,4034},
	{32,4021},
	{33,4008},
	{34,3990},
	{35,3984},
	{36,3978},
	{37,3969},
	{38,3966},
	{39,3962},
	{40,3953},
	{41,3940},
	{42,3933},
	{43,3926},
	{44,3909},
	{45,3901},
	{46,3893},
	{47,3880},
	{48,3874},
	{49,3869},
	{50,3860},
	{51,3852},
	{52,3848},
	{53,3844},
	{54,3836},
	{55,3832},
	{56,3829},
	{57,3823},
	{58,3817},
	{59,3814},
	{60,3812},
	{61,3806},
	{62,3804},
	{63,3801},
	{64,3797},
	{65,3794},
	{66,3792},
	{67,3788},
	{68,3784},
	{69,3782},
	{70,3781},
	{71,3777},
	{72,3775},
	{73,3773},
	{74,3768},
	{75,3766},
	{76,3763},
	{77,3759},
	{78,3754},
	{79,3752},
	{80,3749},
	{81,3744},
	{82,3742},
	{83,3739},
	{84,3733},
	{85,3730},
	{86,3726},
	{87,3717},
	{88,3710},
	{89,3704},
	{90,3698},
	{91,3690},
	{92,3689},
	{93,3688},
	{94,3686},
	{95,3684},
	{96,3683},
	{97,3677},
	{98,3642},
	{99,3606},
	{100,3570}
	 },
	{
	{0,4385},
	{1,4367},
	{2,4359},
	{3,4351},
	{4,4335},
	{5,4327},
	{6,4319},
	{7,4303},
	{8,4294},
	{9,4286},
	{10,4270},
	{11,4254},
	{12,4246},
	{13,4238},
	{14,4222},
	{15,4214},
	{16,4206},
	{17,4190},
	{18,4182},
	{19,4175},
	{20,4159},
	{21,4145},
	{22,4137},
	{23,4129},
	{24,4115},
	{25,4107},
	{26,4099},
	{27,4085},
	{28,4079},
	{29,4073},
	{30,4065},
	{31,4054},
	{32,4042},
	{33,4030},
	{34,4007},
	{35,3999},
	{36,3991},
	{37,3981},
	{38,3978},
	{39,3975},
	{40,3967},
	{41,3955},
	{42,3948},
	{43,3941},
	{44,3926},
	{45,3918},
	{46,3909},
	{47,3894},
	{48,3888},
	{49,3881},
	{51,3870},
	{52,3861},
	{53,3856},
	{54,3852},
	{55,3845},
	{56,3842},
	{57,3838},
	{58,3831},
	{59,3828},
	{60,3825},
	{61,3819},
	{62,3814},
	{63,3812},
	{64,3809},
	{65,3804},
	{66,3801},
	{67,3798},
	{68,3794},
	{69,3792},
	{70,3790},
	{71,3786},
	{72,3782},
	{73,3780},
	{74,3779},
	{75,3775},
	{76,3773},
	{77,3771},
	{78,3766},
	{79,3764},
	{80,3761},
	{81,3755},
	{82,3749},
	{83,3746},
	{84,3743},
	{85,3736},
	{86,3730},
	{87,3725},
	{88,3714},
	{89,3707},
	{90,3700},
	{91,3692},
	{92,3690},
	{93,3690},
	{94,3689},
	{95,3688},
	{96,3687},
	{97,3686},
	{98,3677},
	{99,3657},
	{100,3637},
	{101,3568}
	 }
};

/* T3 50C */
BATTERY_PROFILE_STRUCT battery_profile_t3[TOTAL_BATTERY_NUMBER][101] = {
	{
	{0,4374},
	{1,4355},
	{2,4347},
	{3,4339},
	{4,4322},
	{5,4314},
	{6,4305},
	{7,4288},
	{8,4280},
	{9,4271},
	{10,4254},
	{11,4237},
	{12,4228},
	{13,4220},
	{14,4204},
	{15,4196},
	{16,4188},
	{17,4171},
	{18,4163},
	{19,4155},
	{20,4140},
	{21,4124},
	{22,4116},
	{23,4108},
	{24,4093},
	{26,4086},
	{27,4078},
	{28,4063},
	{29,4058},
	{30,4054},
	{31,4038},
	{32,4019},
	{33,4011},
	{34,4003},
	{35,3993},
	{36,3988},
	{37,3982},
	{38,3970},
	{39,3964},
	{40,3957},
	{41,3946},
	{42,3933},
	{43,3925},
	{44,3917},
	{45,3898},
	{46,3890},
	{47,3883},
	{48,3872},
	{49,3867},
	{50,3862},
	{51,3853},
	{52,3845},
	{53,3841},
	{54,3837},
	{55,3830},
	{56,3827},
	{57,3824},
	{58,3817},
	{59,3814},
	{60,3811},
	{61,3806},
	{62,3801},
	{63,3798},
	{64,3795},
	{65,3791},
	{66,3788},
	{67,3786},
	{68,3782},
	{69,3778},
	{70,3776},
	{71,3775},
	{72,3769},
	{73,3764},
	{74,3759},
	{76,3750},
	{77,3747},
	{78,3744},
	{79,3739},
	{80,3734},
	{81,3731},
	{82,3728},
	{83,3724},
	{84,3722},
	{85,3719},
	{86,3712},
	{87,3708},
	{88,3703},
	{89,3695},
	{90,3686},
	{91,3681},
	{92,3676},
	{93,3674},
	{94,3673},
	{95,3672},
	{96,3670},
	{97,3667},
	{98,3664},
	{99,3636},
	{100,3572},
	{101,3524},
	{102,3477}
	 },
	{
	{0,4386},
	{1,4370},
	{2,4362},
	{3,4355},
	{4,4340},
	{5,4332},
	{6,4324},
	{7,4308},
	{8,4300},
	{9,4293},
	{10,4277},
	{11,4260},
	{12,4252},
	{13,4244},
	{14,4228},
	{15,4220},
	{16,4212},
	{17,4196},
	{18,4188},
	{19,4180},
	{20,4165},
	{21,4149},
	{22,4142},
	{23,4134},
	{24,4119},
	{25,4112},
	{26,4104},
	{27,4089},
	{28,4082},
	{29,4075},
	{30,4061},
	{31,4047},
	{32,4040},
	{33,4034},
	{34,4020},
	{35,4014},
	{36,4008},
	{37,3995},
	{38,3989},
	{39,3983},
	{40,3972},
	{41,3961},
	{42,3954},
	{43,3948},
	{44,3935},
	{45,3927},
	{46,3919},
	{47,3901},
	{48,3894},
	{49,3887},
	{51,3875},
	{52,3865},
	{53,3860},
	{54,3856},
	{55,3848},
	{56,3844},
	{57,3841},
	{58,3834},
	{59,3830},
	{60,3827},
	{61,3821},
	{62,3815},
	{63,3812},
	{64,3810},
	{65,3804},
	{66,3802},
	{67,3800},
	{68,3795},
	{69,3792},
	{70,3790},
	{71,3786},
	{72,3781},
	{73,3778},
	{74,3774},
	{75,3765},
	{76,3762},
	{77,3758},
	{78,3753},
	{79,3750},
	{80,3747},
	{81,3741},
	{82,3733},
	{83,3730},
	{84,3727},
	{85,3721},
	{86,3716},
	{87,3711},
	{88,3699},
	{89,3693},
	{90,3687},
	{91,3677},
	{92,3676},
	{93,3676},
	{94,3675},
	{95,3674},
	{96,3672},
	{97,3671},
	{98,3662},
	{99,3641},
	{100,3620},
	{101,3555}
	 }
};

/* battery profile for actual temperature. The size should be the same as T1, T2 and T3 */
BATTERY_PROFILE_STRUCT battery_profile_temperature[TOTAL_BATTERY_NUMBER][101] = {
	{
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0}
	 },
	{
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0}
	 }


};

/* ============================================================ */
/* <Rbat, Battery_Voltage> Table */
/* ============================================================ */
/* T0 -10C */
R_PROFILE_STRUCT r_profile_t0[TOTAL_BATTERY_NUMBER][101] = {
	{
	{943, 4406},
	{943, 4380},
	{964, 4369},
	{985, 4358},
	{975, 4337},
	{972, 4326},
	{970, 4316},
	{965, 4297},
	{965, 4288},
	{965, 4280},
	{960, 4263},
	{955, 4255},
	{950, 4247},
	{943, 4230},
	{940, 4222},
	{938, 4214},
	{930, 4199},
	{928, 4192},
	{925, 4184},
	{915, 4168},
	{910, 4153},
	{904, 4145},
	{898, 4137},
	{878, 4121},
	{872, 4114},
	{865, 4106},
	{865, 4094},
	{872, 4090},
	{878, 4086},
	{890, 4076},
	{884, 4064},
	{878, 4052},
	{843, 4014},
	{834, 4000},
	{825, 3985},
	{818, 3965},
	{816, 3958},
	{815, 3950},
	{815, 3938},
	{815, 3928},
	{818, 3924},
	{820, 3920},
	{825, 3912},
	{825, 3908},
	{825, 3904},
	{825, 3895},
	{824, 3890},
	{823, 3885},
	{825, 3876},
	{824, 3871},
	{823, 3866},
	{828, 3858},
	{836, 3854},
	{845, 3849},
	{855, 3841},
	{858, 3838},
	{860, 3834},
	{863, 3827},
	{868, 3820},
	{873, 3817},
	{878, 3814},
	{880, 3808},
	{885, 3806},
	{890, 3803},
	{898, 3798},
	{902, 3796},
	{905, 3794},
	{908, 3790},
	{914, 3789},
	{920, 3788},
	{913, 3785},
	{916, 3784},
	{920, 3782},
	{928, 3780},
	{936, 3779},
	{943, 3778},
	{953, 3775},
	{962, 3774},
	{970, 3773},
	{983, 3771},
	{1000, 3767},
	{1008, 3765},
	{1015, 3763},
	{1035, 3759},
	{1048, 3756},
	{1060, 3754},
	{1085, 3749},
	{1102, 3746},
	{1120, 3743},
	{1158, 3736},
	{1182, 3732},
	{1205, 3728},
	{1263, 3720},
	{1283, 3713},
	{1268, 3707},
	{1258, 3703},
	{1243, 3700},
	{1240, 3695},
	{1233, 3693},
	{1228, 3689},
	{1220, 3687}
	 },
	{
	{333, 4403},
	{900, 4380},
	{899, 4370},
	{898, 4359},
	{893, 4339},
	{890, 4329},
	{888, 4319},
	{873, 4300},
	{870, 4292},
	{868, 4283},
	{860, 4266},
	{856, 4258},
	{853, 4249},
	{848, 4232},
	{846, 4224},
	{843, 4216},
	{838, 4200},
	{836, 4192},
	{833, 4185},
	{828, 4170},
	{824, 4162},
	{820, 4155},
	{818, 4139},
	{810, 4124},
	{806, 4116},
	{803, 4108},
	{803, 4096},
	{810, 4090},
	{818, 4085},
	{820, 4071},
	{818, 4062},
	{815, 4053},
	{785, 4027},
	{769, 4013},
	{753, 3999},
	{728, 3975},
	{723, 3966},
	{718, 3957},
	{708, 3942},
	{706, 3936},
	{705, 3929},
	{705, 3920},
	{706, 3916},
	{708, 3912},
	{708, 3903},
	{705, 3894},
	{704, 3890},
	{703, 3885},
	{703, 3876},
	{702, 3872},
	{700, 3867},
	{705, 3859},
	{705, 3855},
	{705, 3851},
	{713, 3844},
	{713, 3840},
	{713, 3836},
	{715, 3829},
	{716, 3826},
	{718, 3823},
	{723, 3817},
	{726, 3814},
	{730, 3811},
	{735, 3805},
	{740, 3802},
	{745, 3800},
	{750, 3795},
	{755, 3791},
	{760, 3790},
	{765, 3788},
	{773, 3785},
	{779, 3784},
	{785, 3782},
	{798, 3780},
	{804, 3778},
	{810, 3777},
	{830, 3774},
	{840, 3772},
	{850, 3770},
	{873, 3766},
	{888, 3764},
	{903, 3761},
	{925, 3755},
	{939, 3752},
	{953, 3748},
	{990, 3741},
	{1008, 3737},
	{1025, 3733},
	{1060, 3727},
	{1098, 3720},
	{1120, 3718},
	{1143, 3715},
	{1198, 3711},
	{1232, 3708},
	{1265, 3706},
	{1253, 3703},
	{1248, 3698},
	{1235, 3696},
	{1223, 3690},
	{1215, 3684},
	{1203, 3681}
	 }

};

/* T1 0C */
R_PROFILE_STRUCT r_profile_t1[TOTAL_BATTERY_NUMBER][101] = {
	{
	{438, 4389},
	{438, 4368},
	{438, 4358},
	{438, 4348},
	{440, 4329},
	{439, 4319},
	{438, 4309},
	{443, 4292},
	{444, 4284},
	{445, 4276},
	{443, 4259},
	{445, 4244},
	{445, 4236},
	{445, 4227},
	{445, 4212},
	{445, 4204},
	{445, 4196},
	{445, 4181},
	{448, 4174},
	{450, 4166},
	{453, 4151},
	{450, 4136},
	{449, 4128},
	{448, 4120},
	{448, 4106},
	{446, 4100},
	{445, 4093},
	{458, 4088},
	{466, 4083},
	{473, 4078},
	{475, 4053},
	{460, 4018},
	{454, 4005},
	{448, 3992},
	{443, 3974},
	{442, 3967},
	{440, 3960},
	{438, 3948},
	{438, 3943},
	{438, 3938},
	{435, 3928},
	{435, 3920},
	{432, 3915},
	{428, 3910},
	{423, 3899},
	{419, 3893},
	{415, 3887},
	{413, 3877},
	{413, 3867},
	{412, 3862},
	{410, 3858},
	{413, 3850},
	{413, 3846},
	{413, 3842},
	{415, 3835},
	{415, 3832},
	{415, 3828},
	{420, 3822},
	{420, 3816},
	{422, 3814},
	{423, 3811},
	{425, 3806},
	{426, 3803},
	{428, 3800},
	{430, 3796},
	{432, 3794},
	{433, 3792},
	{435, 3788},
	{435, 3784},
	{436, 3783},
	{438, 3782},
	{438, 3779},
	{438, 3778},
	{438, 3777},
	{440, 3775},
	{442, 3774},
	{443, 3773},
	{445, 3770},
	{448, 3768},
	{448, 3766},
	{448, 3764},
	{450, 3759},
	{452, 3757},
	{455, 3755},
	{460, 3749},
	{462, 3746},
	{465, 3742},
	{468, 3734},
	{478, 3725},
	{482, 3720},
	{485, 3715},
	{498, 3705},
	{508, 3702},
	{518, 3699},
	{548, 3694},
	{573, 3692},
	{598, 3691},
	{670, 3685},
	{808, 3670},
	{920, 3646},
	{1033, 3622}
	 },
	{
	{228, 4401},
	{405, 4382},
	{406, 4374},
	{408, 4367},
	{405, 4351},
	{404, 4344},
	{403, 4336},
	{398, 4319},
	{396, 4310},
	{393, 4302},
	{390, 4286},
	{390, 4270},
	{392, 4262},
	{393, 4254},
	{390, 4238},
	{390, 4230},
	{390, 4223},
	{385, 4207},
	{385, 4192},
	{384, 4184},
	{383, 4177},
	{383, 4162},
	{384, 4155},
	{385, 4148},
	{385, 4133},
	{385, 4126},
	{385, 4118},
	{380, 4103},
	{380, 4090},
	{386, 4085},
	{393, 4080},
	{413, 4071},
	{412, 4063},
	{410, 4055},
	{390, 4028},
	{379, 4014},
	{368, 3999},
	{355, 3976},
	{343, 3958},
	{340, 3952},
	{338, 3945},
	{330, 3934},
	{329, 3930},
	{328, 3925},
	{325, 3916},
	{322, 3911},
	{320, 3906},
	{315, 3896},
	{313, 3885},
	{312, 3880},
	{310, 3876},
	{310, 3867},
	{312, 3863},
	{313, 3859},
	{310, 3851},
	{313, 3844},
	{314, 3840},
	{315, 3837},
	{320, 3830},
	{322, 3827},
	{325, 3824},
	{330, 3818},
	{330, 3815},
	{330, 3812},
	{335, 3807},
	{338, 3802},
	{338, 3800},
	{338, 3797},
	{340, 3792},
	{342, 3790},
	{343, 3788},
	{223, 3787},
	{199, 3786},
	{175, 3785},
	{165, 3781},
	{165, 3778},
	{160, 3776},
	{155, 3775},
	{148, 3771},
	{144, 3769},
	{140, 3767},
	{138, 3762},
	{134, 3758},
	{130, 3755},
	{123, 3746},
	{125, 3739},
	{124, 3734},
	{123, 3729},
	{120, 3717},
	{122, 3711},
	{123, 3705},
	{115, 3693},
	{118, 3690},
	{119, 3689},
	{120, 3688},
	{128, 3687},
	{133, 3686},
	{138, 3686},
	{143, 3682},
	{142, 3672},
	{140, 3661}
	 }

};

/* T2 25C */
R_PROFILE_STRUCT r_profile_t2[TOTAL_BATTERY_NUMBER][101] = {
	{
	{145, 4389},
	{145, 4370},
	{146, 4362},
	{148, 4353},
	{148, 4336},
	{148, 4327},
	{148, 4318},
	{150, 4301},
	{150, 4292},
	{150, 4284},
	{150, 4267},
	{150, 4250},
	{152, 4242},
	{153, 4234},
	{150, 4217},
	{152, 4209},
	{153, 4201},
	{155, 4186},
	{155, 4178},
	{155, 4170},
	{158, 4154},
	{160, 4139},
	{160, 4131},
	{160, 4123},
	{163, 4108},
	{164, 4100},
	{165, 4093},
	{165, 4081},
	{168, 4078},
	{170, 4076},
	{173, 4061},
	{175, 4034},
	{175, 4021},
	{175, 4008},
	{175, 3990},
	{178, 3984},
	{180, 3978},
	{183, 3969},
	{186, 3966},
	{188, 3962},
	{188, 3953},
	{185, 3940},
	{182, 3933},
	{180, 3926},
	{168, 3909},
	{163, 3901},
	{158, 3893},
	{150, 3880},
	{149, 3874},
	{148, 3869},
	{148, 3860},
	{150, 3852},
	{149, 3848},
	{148, 3844},
	{148, 3836},
	{146, 3832},
	{145, 3829},
	{148, 3823},
	{148, 3817},
	{149, 3814},
	{150, 3812},
	{150, 3806},
	{150, 3804},
	{150, 3801},
	{155, 3797},
	{154, 3794},
	{153, 3792},
	{155, 3788},
	{155, 3784},
	{156, 3782},
	{158, 3781},
	{160, 3777},
	{159, 3775},
	{158, 3773},
	{155, 3768},
	{152, 3766},
	{150, 3763},
	{150, 3759},
	{150, 3754},
	{150, 3752},
	{150, 3749},
	{148, 3744},
	{149, 3742},
	{150, 3739},
	{150, 3733},
	{150, 3730},
	{150, 3726},
	{148, 3717},
	{153, 3710},
	{150, 3704},
	{148, 3698},
	{145, 3690},
	{146, 3689},
	{148, 3688},
	{150, 3686},
	{154, 3684},
	{158, 3683},
	{168, 3677},
	{163, 3642},
	{168, 3606},
	{173, 3570}
	 },
	{
	{138, 4385},
	{135, 4367},
	{135, 4359},
	{135, 4351},
	{135, 4335},
	{135, 4327},
	{135, 4319},
	{135, 4303},
	{134, 4294},
	{133, 4286},
	{135, 4270},
	{135, 4254},
	{136, 4246},
	{138, 4238},
	{138, 4222},
	{138, 4214},
	{138, 4206},
	{140, 4190},
	{140, 4182},
	{140, 4175},
	{140, 4159},
	{145, 4145},
	{145, 4137},
	{145, 4129},
	{148, 4115},
	{148, 4107},
	{148, 4099},
	{150, 4085},
	{152, 4079},
	{153, 4073},
	{163, 4065},
	{170, 4054},
	{166, 4042},
	{163, 4030},
	{163, 4007},
	{164, 3999},
	{165, 3991},
	{170, 3981},
	{172, 3978},
	{175, 3975},
	{178, 3967},
	{175, 3955},
	{172, 3948},
	{170, 3941},
	{163, 3926},
	{156, 3918},
	{150, 3909},
	{140, 3894},
	{135, 3888},
	{130, 3881},
	{128, 3870},
	{128, 3861},
	{126, 3856},
	{125, 3852},
	{128, 3845},
	{128, 3842},
	{128, 3838},
	{130, 3831},
	{130, 3828},
	{130, 3825},
	{133, 3819},
	{135, 3814},
	{136, 3812},
	{138, 3809},
	{138, 3804},
	{138, 3801},
	{138, 3798},
	{140, 3794},
	{140, 3792},
	{140, 3790},
	{143, 3786},
	{143, 3782},
	{144, 3780},
	{145, 3779},
	{145, 3775},
	{145, 3773},
	{145, 3771},
	{140, 3766},
	{139, 3764},
	{138, 3761},
	{135, 3755},
	{133, 3749},
	{134, 3746},
	{135, 3743},
	{140, 3736},
	{139, 3730},
	{138, 3725},
	{140, 3714},
	{139, 3707},
	{138, 3700},
	{133, 3692},
	{140, 3690},
	{145, 3690},
	{150, 3689},
	{160, 3688},
	{166, 3687},
	{173, 3686},
	{180, 3677},
	{179, 3657},
	{178, 3637},
	{195, 3568}
	 }

};

/* T3 50C */
R_PROFILE_STRUCT r_profile_t3[TOTAL_BATTERY_NUMBER][101] = {
	{
	{113, 4374},
	{113, 4355},
	{116, 4347},
	{118, 4339},
	{118, 4322},
	{118, 4314},
	{118, 4305},
	{118, 4288},
	{119, 4280},
	{120, 4271},
	{118, 4254},
	{118, 4237},
	{118, 4228},
	{118, 4220},
	{120, 4204},
	{120, 4196},
	{120, 4188},
	{118, 4171},
	{119, 4163},
	{120, 4155},
	{123, 4140},
	{123, 4124},
	{123, 4116},
	{123, 4108},
	{125, 4093},
	{125, 4086},
	{125, 4078},
	{125, 4063},
	{128, 4058},
	{130, 4054},
	{128, 4038},
	{128, 4019},
	{129, 4011},
	{130, 4003},
	{133, 3993},
	{134, 3988},
	{135, 3982},
	{135, 3970},
	{135, 3964},
	{135, 3957},
	{140, 3946},
	{143, 3933},
	{142, 3925},
	{140, 3917},
	{128, 3898},
	{126, 3890},
	{123, 3883},
	{123, 3872},
	{122, 3867},
	{120, 3862},
	{118, 3853},
	{120, 3845},
	{119, 3841},
	{118, 3837},
	{118, 3830},
	{119, 3827},
	{120, 3824},
	{120, 3817},
	{120, 3814},
	{120, 3811},
	{123, 3806},
	{123, 3801},
	{123, 3798},
	{123, 3795},
	{125, 3791},
	{125, 3788},
	{125, 3786},
	{128, 3782},
	{130, 3778},
	{132, 3776},
	{133, 3775},
	{130, 3769},
	{126, 3764},
	{123, 3759},
	{120, 3750},
	{122, 3747},
	{123, 3744},
	{123, 3739},
	{123, 3734},
	{122, 3731},
	{120, 3728},
	{123, 3724},
	{123, 3722},
	{123, 3719},
	{123, 3712},
	{122, 3708},
	{120, 3703},
	{120, 3695},
	{123, 3686},
	{120, 3681},
	{118, 3676},
	{120, 3674},
	{122, 3673},
	{123, 3672},
	{130, 3670},
	{132, 3667},
	{135, 3664},
	{130, 3636},
	{135, 3572},
	{140, 3524},
	{145, 3477}
	 },
	{
	{170, 4386},
	{88, 4370},
	{88, 4362},
	{88, 4355},
	{88, 4340},
	{88, 4332},
	{88, 4324},
	{88, 4308},
	{89, 4300},
	{90, 4293},
	{90, 4277},
	{88, 4260},
	{88, 4252},
	{88, 4244},
	{90, 4228},
	{90, 4220},
	{90, 4212},
	{93, 4196},
	{92, 4188},
	{90, 4180},
	{95, 4165},
	{95, 4149},
	{95, 4142},
	{95, 4134},
	{98, 4119},
	{98, 4112},
	{98, 4104},
	{98, 4089},
	{99, 4082},
	{100, 4075},
	{103, 4061},
	{103, 4047},
	{104, 4040},
	{105, 4034},
	{105, 4020},
	{108, 4014},
	{110, 4008},
	{110, 3995},
	{112, 3989},
	{115, 3983},
	{118, 3972},
	{123, 3961},
	{124, 3954},
	{125, 3948},
	{125, 3935},
	{122, 3927},
	{118, 3919},
	{103, 3901},
	{100, 3894},
	{98, 3887},
	{93, 3875},
	{90, 3865},
	{90, 3860},
	{90, 3856},
	{90, 3848},
	{92, 3844},
	{93, 3841},
	{93, 3834},
	{93, 3830},
	{93, 3827},
	{95, 3821},
	{95, 3815},
	{98, 3812},
	{100, 3810},
	{100, 3804},
	{102, 3802},
	{103, 3800},
	{105, 3795},
	{105, 3792},
	{105, 3790},
	{108, 3786},
	{108, 3781},
	{106, 3778},
	{103, 3774},
	{98, 3765},
	{96, 3762},
	{95, 3758},
	{98, 3753},
	{98, 3750},
	{98, 3747},
	{98, 3741},
	{95, 3733},
	{95, 3730},
	{95, 3727},
	{98, 3721},
	{96, 3716},
	{95, 3711},
	{93, 3699},
	{96, 3693},
	{98, 3687},
	{90, 3677},
	{93, 3676},
	{96, 3676},
	{98, 3675},
	{100, 3674},
	{102, 3672},
	{103, 3671},
	{103, 3662},
	{104, 3641},
	{105, 3620},
	{120, 3555}
	 }


};

/* r-table profile for actual temperature. The size should be the same as T1, T2 and T3 */
R_PROFILE_STRUCT r_profile_temperature[TOTAL_BATTERY_NUMBER][101] = {
	{
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0}
	 },
	{
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0}

	 }
};

/* ============================================================ */
/* function prototype */
/* ============================================================ */
int fgauge_get_saddles(void);
BATTERY_PROFILE_STRUCT_P fgauge_get_profile(kal_uint32 temperature);

int fgauge_get_saddles_r_table(void);
R_PROFILE_STRUCT_P fgauge_get_profile_r_table(kal_uint32 temperature);

#endif				/* #ifndef _CUST_BATTERY_METER_TABLE_H */
