#ifndef _MT_CPUFREQ_HYBRID_FW_
#define _MT_CPUFREQ_HYBRID_FW_

#include <linux/kernel.h>


#define EVENT_VEC(event, resume, imme, pc)	\
	(((pc) << 16) |				\
	 (!!(imme) << 7) |			\
	 (!!(resume) << 6) |			\
	 ((event) & 0x3f))

struct pcm_desc {
	const char *version;	/* PCM code version */
	const u32 *base;	/* binary array base */
	const u16 size;		/* binary array size */
	const u8 sess;		/* session number */
	const u8 replace;	/* replace mode */
	const u16 addr_2nd;	/* 2nd binary array size */

	u32 vec0;		/* event vector 0 config */
	u32 vec1;		/* event vector 1 config */
};


static const u32 dvfs_binary[] = {
	0x1ad0001f, 0x1022761c, 0x8ac0000b, 0x0000000f, 0x12c02c1f, 0xf0000000,
	0x17c07c1f, 0x1850001f, 0x1022761c, 0x88400001, 0xfffffff0, 0xa0502c01,
	0x18c0001f, 0x1022761c, 0xe0c00001, 0xf0000000, 0x17c07c1f, 0x1ad0001f,
	0x1022761c, 0x8ac0000b, 0x000f0000, 0x12c82c1f, 0xf0000000, 0x17c07c1f,
	0x1850001f, 0x1022761c, 0x88400001, 0xfff0ffff, 0xa0582c01, 0x18c0001f,
	0x1022761c, 0xe0c00001, 0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x1022761c,
	0x8ac0000b, 0x000000f0, 0x12c22c1f, 0xf0000000, 0x17c07c1f, 0x1850001f,
	0x1022761c, 0x88400001, 0xffffff0f, 0xa0522c01, 0x18c0001f, 0x1022761c,
	0xe0c00001, 0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x1022761c, 0x8ac0000b,
	0x00f00000, 0x12ca2c1f, 0xf0000000, 0x17c07c1f, 0x1850001f, 0x1022761c,
	0x88400001, 0xff0fffff, 0xa05a2c01, 0x18c0001f, 0x1022761c, 0xe0c00001,
	0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x1022761c, 0x8ac0000b, 0x00008000,
	0x12c7ac1f, 0xf0000000, 0x17c07c1f, 0x1850001f, 0x1022761c, 0x88400001,
	0xffff7fff, 0xa057ac01, 0x18c0001f, 0x1022761c, 0xe0c00001, 0xf0000000,
	0x17c07c1f, 0x1ad0001f, 0x1022761c, 0x12cfac1f, 0x8ac0000b, 0x00000001,
	0xf0000000, 0x17c07c1f, 0x1850001f, 0x1022761c, 0x88400001, 0x7fffffff,
	0xa05fac01, 0x18c0001f, 0x1022761c, 0xe0c00001, 0xf0000000, 0x17c07c1f,
	0x1ad0001f, 0x10227610, 0x8ac0000b, 0x00004000, 0x12c72c1f, 0xf0000000,
	0x17c07c1f, 0x1ad0001f, 0x10227610, 0x8ac0000b, 0x40000000, 0x12cf2c1f,
	0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x10227618, 0x8ac0000b, 0x00008000,
	0x12c7ac1f, 0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x10227614, 0x8ac0000b,
	0x30000000, 0x12ce2c1f, 0xf0000000, 0x17c07c1f, 0x1850001f, 0x10227614,
	0x88400001, 0xcfffffff, 0xa05e2c01, 0x18c0001f, 0x10227614, 0xe0c00001,
	0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x10227614, 0x12cf2c1f, 0x8ac0000b,
	0x00000003, 0xf0000000, 0x17c07c1f, 0x1850001f, 0x10227614, 0x88400001,
	0x3fffffff, 0xa05f2c01, 0x18c0001f, 0x10227614, 0xe0c00001, 0xf0000000,
	0x17c07c1f, 0x1850001f, 0x10200744, 0x88400001, 0xffffffbf, 0x18c0001f,
	0x10200744, 0xe0c00001, 0x88400001, 0xffffffbf, 0x1800001f, 0x00000001,
	0x1013001f, 0xa0400001, 0x10002c1f, 0x100d801f, 0x88000000, 0x0000001f,
	0x88400001, 0xffffffc1, 0x1010801f, 0xa0400001, 0xe0c00001, 0xf0000000,
	0x17c07c1f, 0x1850001f, 0x10200744, 0x88400001, 0xffffbfff, 0x18c0001f,
	0x10200744, 0xe0c00001, 0x88400001, 0xffffbfff, 0x1800001f, 0x00000001,
	0x1017001f, 0xa0400001, 0x10002c1f, 0x88000000, 0x003e0000, 0x1008801f,
	0x88400001, 0xffffc1ff, 0x1014801f, 0xa0400001, 0xe0c00001, 0xf0000000,
	0x17c07c1f, 0x1850001f, 0x10200744, 0x88400001, 0xffbfffff, 0x18c0001f,
	0x10200744, 0xe0c00001, 0x88400001, 0xffbfffff, 0x1800001f, 0x00000001,
	0x101b001f, 0xa0400001, 0x10002c1f, 0x88000000, 0x003e0000, 0x1008801f,
	0x88400001, 0xffc1ffff, 0x1018801f, 0xa0400001, 0xe0c00001, 0xf0000000,
	0x17c07c1f, 0x10002c1f, 0x88000000, 0x07c00000, 0x100b001f, 0x18c0001f,
	0x1000102c, 0x1850001f, 0x1000102c, 0x88400001, 0xffffffe0, 0xa0400001,
	0xe0c00001, 0x1b80001f, 0x20000104, 0xf0000000, 0x17c07c1f, 0x18c0001f,
	0x10001000, 0x1850001f, 0x10001000, 0x88400001, 0xffffcfff, 0xa0562c01,
	0xe0c00001, 0x1850001f, 0x10227614, 0x88400001, 0xcfffffff, 0xa05e2c01,
	0x18c0001f, 0x10227614, 0xe0c00001, 0xf0000000, 0x17c07c1f, 0x10002c1f,
	0x88000000, 0x0001f000, 0x1006001f, 0x18c0001f, 0x10001024, 0x1850001f,
	0x10001024, 0x88400001, 0xffffffe0, 0xa0400001, 0xe0c00001, 0x1b80001f,
	0x20000104, 0xf0000000, 0x17c07c1f, 0x10002c1f, 0x88000000, 0x0001f000,
	0x1006001f, 0x18c0001f, 0x10001028, 0x1850001f, 0x10001028, 0x88400001,
	0xffffffe0, 0xa0400001, 0xe0c00001, 0x1b80001f, 0x20000104, 0xf0000000,
	0x17c07c1f, 0x18c0001f, 0x10227600, 0x1850001f, 0x10227600, 0x1052041f,
	0xa0402c01, 0xe0c00001, 0xf0000000, 0x17c07c1f, 0x18c0001f, 0x10227600,
	0x1850001f, 0x10227600, 0x1054041f, 0xa0402c01, 0xe0c00001, 0xf0000000,
	0x17c07c1f, 0x18c0001f, 0x10227610, 0x1850001f, 0x10227610, 0x1052041f,
	0xa0402c01, 0xe0c00001, 0xf0000000, 0x17c07c1f, 0x18c0001f, 0x10227610,
	0x1850001f, 0x10227610, 0x1054041f, 0xa0402c01, 0xe0c00001, 0xf0000000,
	0x17c07c1f, 0x18c0001f, 0x0011c330, 0x1850001f, 0x0011c330, 0x1052041f,
	0xa0402c01, 0xe0c00001, 0xf0000000, 0x17c07c1f, 0x18c0001f, 0x0011c330,
	0x1850001f, 0x0011c330, 0x1054041f, 0xa0402c01, 0xe0c00001, 0xf0000000,
	0x17c07c1f, 0x18c0001f, 0x0011c048, 0x00f1ac03, 0x08c00003, 0x00000004,
	0x1af00003, 0x17c07c1f, 0xf0000000, 0x17c07c1f, 0x18c0001f, 0x0011c0d8,
	0x00f1ac03, 0x08c00003, 0x00000004, 0x1af00003, 0x17c07c1f, 0xf0000000,
	0x17c07c1f, 0xc2001180, 0x17c07c1f, 0xc2001ea0, 0x17c07c1f, 0xc2400440,
	0x17c07c1f, 0xc2402ba0, 0x17c07c1f, 0x68600008, 0x00000001, 0xd8202fe1,
	0x17c07c1f, 0xc2400660, 0x17c07c1f, 0xc2402cc0, 0x17c07c1f, 0xc24013a0,
	0x17c07c1f, 0xf0000000, 0x17c07c1f, 0x1800001f, 0x10000104, 0x18d0001f,
	0x10000104, 0x88c00003, 0xffffffcf, 0x1840001f, 0x00000003, 0xa0d20403,
	0xe0000003, 0x1b80001f, 0x20000104, 0x1800001f, 0x10001000, 0x18d0001f,
	0x10001000, 0x88c00003, 0xffffffcf, 0x1840001f, 0x00000002, 0xa0d20403,
	0xe0000003, 0x1800001f, 0x00000002, 0x18c0001f, 0x10001000, 0x1850001f,
	0x10001000, 0x88400001, 0xffffcfff, 0xa0560001, 0xe0c00001, 0x1850001f,
	0x10227614, 0x88400001, 0xcfffffff, 0xa05e0001, 0x18c0001f, 0x10227614,
	0xe0c00001, 0x1000101f, 0x88000000, 0x00000e00, 0x1004801f, 0x18c0001f,
	0x1000c204, 0x1850001f, 0x1000c204, 0x88400001, 0xf8ffffff, 0x101c001f,
	0xa8400001, 0x80000000, 0xa0400001, 0xe0c00001, 0x1b80001f, 0x20000104,
	0x1800001f, 0x10001000, 0x18d0001f, 0x10001000, 0x88c00003, 0xffffffcf,
	0x1840001f, 0x00000001, 0xa0d20403, 0xe0000003, 0x1800001f, 0x10000104,
	0x18d0001f, 0x10000104, 0x88c00003, 0xffffffcf, 0xe0000003, 0xf0000000,
	0x17c07c1f, 0x18d0001f, 0x1000cf38, 0x82109803, 0xd8203ce8, 0x17c07c1f,
	0x1800001f, 0x1000cf38, 0x80f09803, 0xe0000003, 0x1a50001f, 0x1000cf40,
	0x8a400009, 0x001fffff, 0x18d0001f, 0x1000cf48, 0x88c00003, 0x001fffff,
	0x60600c09, 0xd8003ce1, 0x17c07c1f, 0x1b80001f, 0x20000104, 0xd0003b80,
	0x17c07c1f, 0x1800001f, 0x1000cf40, 0x18d0001f, 0x1000c204, 0x88c00003,
	0x001fffff, 0xa8c00003, 0x80000000, 0xe0000003, 0x1800001f, 0x1000cf38,
	0x18d0001f, 0x1000cf38, 0x88c00003, 0xfffffffb, 0xa8c00003, 0x00000004,
	0xe0000003, 0x1800001f, 0x1000cf38, 0x18d0001f, 0x1000cf38, 0x88c00003,
	0xfffffffe, 0xa8c00003, 0x00000001, 0xe0000003, 0xe8208000, 0x1000cf0c,
	0x06003c97, 0xe8208000, 0x1022742c, 0x00000001, 0x18d0001f, 0x1022742c,
	0xd82040a3, 0x17c07c1f, 0x1800001f, 0x1000cf00, 0x18d0001f, 0x1000cf00,
	0x88c00003, 0xfffffffe, 0xa8c00003, 0x00000001, 0xe0000003, 0xe8208000,
	0x1022742c, 0x00000001, 0x1240101f, 0x8a400009, 0x000001ff, 0x1256241f,
	0x1800001f, 0x1000cf44, 0x18d0001f, 0x1000cf44, 0xa8c00009, 0x80000000,
	0xe0000003, 0x1800001f, 0x00000000, 0x18d0001f, 0x1000cf48, 0x88c00003,
	0x001fffff, 0x60600c09, 0xd80047a1, 0x17c07c1f, 0x68600000, 0x00000064,
	0xd80046c1, 0x17c07c1f, 0x08000000, 0x00000001, 0x1b80001f, 0x20000104,
	0xd00044a0, 0x17c07c1f, 0x1810001f, 0x10227604, 0xa8000000, 0x00000002,
	0x18c0001f, 0x10227604, 0xe0c00000, 0x1800001f, 0x1000c204, 0x1850001f,
	0x1000c204, 0x88400001, 0xffe00000, 0xa8400001, 0x80000000, 0x18d0001f,
	0x1000cf48, 0x88c00003, 0x001fffff, 0xa0c00403, 0xe0000003, 0xe8208000,
	0x1022742c, 0x00000001, 0x18d0001f, 0x1022742c, 0xd8204963, 0x17c07c1f,
	0x1800001f, 0x1000cf00, 0x18d0001f, 0x1000cf00, 0x88c00003, 0xfffffffe,
	0xe0000003, 0xe8208000, 0x1022742c, 0x00000001, 0xd82050e8, 0x17c07c1f,
	0x1800001f, 0x1000cf40, 0x18d0001f, 0x1000c204, 0x88c00003, 0x001fffff,
	0xa8c00003, 0x80000000, 0xe0000003, 0x1000101f, 0x88000000, 0x000001ff,
	0x1840001f, 0x0000000a, 0x10c0341f, 0x10d80c1f, 0x1800001f, 0x1000cf3c,
	0xe0000003, 0xe8208000, 0x1022742c, 0x00000001, 0x18d0001f, 0x1022742c,
	0xd8204e23, 0x17c07c1f, 0x1800001f, 0x1000cf00, 0x18d0001f, 0x1000cf00,
	0xa0d01803, 0xe0000003, 0xe8208000, 0x1022742c, 0x00000001, 0x18d0001f,
	0x1000cf38, 0x1800001f, 0x1000cf38, 0xa0d09803, 0xe0000003, 0xf0000000,
	0x17c07c1f, 0x18d0001f, 0x1000cf4c, 0x82109803, 0xd8205428, 0x17c07c1f,
	0x1800001f, 0x1000cf4c, 0x80f09803, 0xe0000003, 0x1a50001f, 0x1000cf54,
	0x8a400009, 0x001fffff, 0x18d0001f, 0x1000cf5c, 0x88c00003, 0x001fffff,
	0x60600c09, 0xd8005421, 0x17c07c1f, 0x1b80001f, 0x20000104, 0xd00052c0,
	0x17c07c1f, 0x1800001f, 0x1000cf54, 0x18d0001f, 0x1000c214, 0x88c00003,
	0x001fffff, 0xa8c00003, 0x80000000, 0xe0000003, 0x1800001f, 0x1000cf4c,
	0x18d0001f, 0x1000cf4c, 0x88c00003, 0xfffffffb, 0xa8c00003, 0x00000004,
	0xe0000003, 0x1800001f, 0x1000cf4c, 0x18d0001f, 0x1000cf4c, 0x88c00003,
	0xfffffffe, 0xa8c00003, 0x00000001, 0xe0000003, 0xe8208000, 0x1000cf0c,
	0x06003c97, 0xe8208000, 0x1022742c, 0x00000001, 0x18d0001f, 0x1022742c,
	0xd82057e3, 0x17c07c1f, 0x1800001f, 0x1000cf00, 0x18d0001f, 0x1000cf00,
	0xa0d09803, 0xe0000003, 0xe8208000, 0x1022742c, 0x00000001, 0x1240101f,
	0x8a400009, 0x000001ff, 0x1256241f, 0x1800001f, 0x1000cf58, 0x18d0001f,
	0x1000cf58, 0xa8c00009, 0x80000000, 0xe0000003, 0x1800001f, 0x00000000,
	0x18d0001f, 0x1000cf5c, 0x88c00003, 0x001fffff, 0x60600c09, 0xd8005e81,
	0x17c07c1f, 0x68600000, 0x00000064, 0xd8005da1, 0x17c07c1f, 0x08000000,
	0x00000001, 0x1b80001f, 0x20000104, 0xd0005b80, 0x17c07c1f, 0x1810001f,
	0x10227604, 0xa8000000, 0x00000002, 0x18c0001f, 0x10227604, 0xe0c00000,
	0x1800001f, 0x1000c214, 0x1850001f, 0x1000c214, 0x88400001, 0xffe00000,
	0xa8400001, 0x80000000, 0x18d0001f, 0x1000cf5c, 0x88c00003, 0x001fffff,
	0xa0c00403, 0xe0000003, 0xe8208000, 0x1022742c, 0x00000001, 0x18d0001f,
	0x1022742c, 0xd8206043, 0x17c07c1f, 0x1800001f, 0x1000cf00, 0x18d0001f,
	0x1000cf00, 0x80f09803, 0xe0000003, 0xe8208000, 0x1022742c, 0x00000001,
	0xd82067a8, 0x17c07c1f, 0x1800001f, 0x1000cf54, 0x18d0001f, 0x1000c214,
	0x88c00003, 0x001fffff, 0xa8c00003, 0x80000000, 0xe0000003, 0x1000101f,
	0x88000000, 0x000001ff, 0x1840001f, 0x0000000a, 0x10c0341f, 0x10d80c1f,
	0x1800001f, 0x1000cf50, 0xe0000003, 0xe8208000, 0x1022742c, 0x00000001,
	0x18d0001f, 0x1022742c, 0xd82064e3, 0x17c07c1f, 0x1800001f, 0x1000cf00,
	0x18d0001f, 0x1000cf00, 0xa0d09803, 0xe0000003, 0xe8208000, 0x1022742c,
	0x00000001, 0x18d0001f, 0x1000cf4c, 0x1800001f, 0x1000cf4c, 0xa0d09803,
	0xe0000003, 0xf0000000, 0x17c07c1f, 0xc1400000, 0x17c07c1f, 0xc2800440,
	0x17c07c1f, 0x1080141f, 0xc0802ba0, 0x17c07c1f, 0x1100281f, 0xc1002ba0,
	0x17c07c1f, 0x12407c1f, 0xc24013a0, 0x17c07c1f, 0xc10016a0, 0x17c07c1f,
	0xc10022e0, 0x17c07c1f, 0xc1001ca0, 0x17c07c1f, 0xc1005120, 0x17c07c1f,
	0xf0000000, 0x17c07c1f, 0xc1400000, 0x17c07c1f, 0xc2800440, 0x17c07c1f,
	0x1080141f, 0xc0802ba0, 0x17c07c1f, 0x1100281f, 0xc1002ba0, 0x17c07c1f,
	0x12407c1f, 0xc24013a0, 0x17c07c1f, 0xc1005120, 0x17c07c1f, 0xc1001ca0,
	0x17c07c1f, 0xc10022e0, 0x17c07c1f, 0xc10016a0, 0x17c07c1f, 0xf0000000,
	0x17c07c1f, 0xc1400220, 0x17c07c1f, 0xc2800660, 0x17c07c1f, 0x1080141f,
	0xc0802cc0, 0x17c07c1f, 0x1100281f, 0xc1002cc0, 0x17c07c1f, 0x12407c1f,
	0xc24013a0, 0x17c07c1f, 0xc10019a0, 0x17c07c1f, 0xc10020e0, 0x17c07c1f,
	0x88000004, 0x00000e00, 0x1004801f, 0x88c00002, 0x00000e00, 0x10c48c1f,
	0x20600c00, 0xd8207121, 0x17c07c1f, 0xc2003060, 0x17c07c1f, 0xc1001ca0,
	0x17c07c1f, 0xc10039e0, 0x17c07c1f, 0xf0000000, 0x17c07c1f, 0xc1400220,
	0x17c07c1f, 0xc2800660, 0x17c07c1f, 0x1080141f, 0xc0802cc0, 0x17c07c1f,
	0x1100281f, 0xc1002cc0, 0x17c07c1f, 0x12407c1f, 0xc24013a0, 0x17c07c1f,
	0xc10039e0, 0x17c07c1f, 0xc1001ca0, 0x17c07c1f, 0x88000004, 0x00000e00,
	0x1004801f, 0x1a50001f, 0x1000c204, 0x124c241f, 0x8a400009, 0x00000007,
	0x40602400, 0xd82075a1, 0x17c07c1f, 0xc2003060, 0x17c07c1f, 0xc10020e0,
	0x17c07c1f, 0xc10019a0, 0x17c07c1f, 0xf0000000, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x1980001f, 0x00000001,
	0xe8208000, 0x10227608, 0x00000340, 0xe8208000, 0x1022760c, 0x00000344,
	0xe8208000, 0x10227424, 0x00000348, 0xe8208000, 0x10227418, 0x00000000,
	0xe8208000, 0x1022741c, 0x00000000, 0xc100c580, 0x17c07c1f, 0xc080c3c0,
	0x17c07c1f, 0x68600004, 0x00000001, 0xd8208361, 0x17c07c1f, 0xc0800520,
	0x17c07c1f, 0xc100c660, 0x17c07c1f, 0xc080c4a0, 0x17c07c1f, 0x68600004,
	0x00000001, 0xd82084a1, 0x17c07c1f, 0xc0800740, 0x17c07c1f, 0xc100c200,
	0x17c07c1f, 0xc080c040, 0x17c07c1f, 0xc0c00440, 0x17c07c1f, 0x20601003,
	0xd8208601, 0x17c07c1f, 0xc1000520, 0x17c07c1f, 0x20600c02, 0xd82086a1,
	0x17c07c1f, 0xc0800520, 0x17c07c1f, 0xc100c2e0, 0x17c07c1f, 0xc080c120,
	0x17c07c1f, 0xc0c00660, 0x17c07c1f, 0x20601003, 0xd8208801, 0x17c07c1f,
	0xc1000740, 0x17c07c1f, 0x20600c02, 0xd82088a1, 0x17c07c1f, 0xc0800740,
	0x17c07c1f, 0xc100c740, 0x17c07c1f, 0x68600004, 0x00000001, 0xd8208d21,
	0x17c07c1f, 0xc0800000, 0x17c07c1f, 0xc0800520, 0x17c07c1f, 0x1880001f,
	0x00000001, 0xc0800960, 0x17c07c1f, 0xc100c960, 0x17c07c1f, 0x68600004,
	0x00000001, 0xd8208c61, 0x17c07c1f, 0xc0800220, 0x17c07c1f, 0xc0800740,
	0x17c07c1f, 0x1880001f, 0x00000001, 0xc0800b80, 0x17c07c1f, 0xd000bfa0,
	0x17c07c1f, 0x1880001f, 0x00000000, 0xc0800b80, 0x17c07c1f, 0xd0008fe0,
	0x17c07c1f, 0x1880001f, 0x00000000, 0xc0800960, 0x17c07c1f, 0xc100c960,
	0x17c07c1f, 0x68600004, 0x00000001, 0xd8208f61, 0x17c07c1f, 0xc0800220,
	0x17c07c1f, 0xc0800740, 0x17c07c1f, 0x1880001f, 0x00000001, 0xc0800b80,
	0x17c07c1f, 0x1880001f, 0x00000000, 0xc0800b80, 0x17c07c1f, 0x1840001f,
	0x10227610, 0x18d0001f, 0x10227618, 0xe0400003, 0xc1000cc0, 0x17c07c1f,
	0x68600004, 0x00000000, 0xd82091c1, 0x17c07c1f, 0x1880001f, 0x00000000,
	0xc0800520, 0x17c07c1f, 0xc1000da0, 0x17c07c1f, 0x68600004, 0x00000000,
	0xd8209301, 0x17c07c1f, 0x1880001f, 0x00000000, 0xc0800740, 0x17c07c1f,
	0xc1000da0, 0x17c07c1f, 0x68600004, 0x00000001, 0xd8209721, 0x17c07c1f,
	0xc1400440, 0x17c07c1f, 0xc1402ba0, 0x17c07c1f, 0x89400005, 0x003e01ff,
	0xc2800660, 0x17c07c1f, 0xc2802cc0, 0x17c07c1f, 0x8a80000a, 0x003e01ff,
	0x2060140a, 0xd8209661, 0x17c07c1f, 0x1880001f, 0x00000001, 0xc0801260,
	0x17c07c1f, 0xd00097a0, 0x17c07c1f, 0x1880001f, 0x00000002, 0xc0801260,
	0x17c07c1f, 0xd00097a0, 0x17c07c1f, 0x1880001f, 0x00000002, 0xc0801260,
	0x17c07c1f, 0x1840001f, 0x0011c318, 0x18d0001f, 0x1022761c, 0xe0400003,
	0x1840001f, 0x0011c31c, 0x18d0001f, 0x10227618, 0xe0400003, 0x1840001f,
	0x0011c320, 0x18d0001f, 0x10227614, 0xe0400003, 0xc1400220, 0x17c07c1f,
	0xc2800660, 0x17c07c1f, 0x6060140a, 0xd820a4c1, 0x17c07c1f, 0xc1400000,
	0x17c07c1f, 0xc2800440, 0x17c07c1f, 0x6060140a, 0xd820a0a1, 0x17c07c1f,
	0x18d0001f, 0x10227610, 0x821f1803, 0x120f201f, 0x805e9803, 0x104e841f,
	0xa2000408, 0x82571803, 0x1247241f, 0x80569803, 0x1046841f, 0xa2400409,
	0x80402408, 0xd8209d61, 0x17c07c1f, 0xc0c0d260, 0x17c07c1f, 0x18d0001f,
	0x10227610, 0x821f1803, 0x120f201f, 0x805e9803, 0x104e841f, 0xa2000408,
	0xd8009f08, 0x17c07c1f, 0xc0c02de0, 0x17c07c1f, 0xc180ca40, 0x17c07c1f,
	0x18d0001f, 0x10227610, 0x82171803, 0x1207201f, 0x80569803, 0x1046841f,
	0xa2000408, 0xd800a068, 0x17c07c1f, 0xc180c820, 0x17c07c1f, 0xd000bd40,
	0x17c07c1f, 0x2060140a, 0xd820a241, 0x17c07c1f, 0xc0c0d260, 0x17c07c1f,
	0xc0c06ac0, 0x17c07c1f, 0x1800001f, 0x00000001, 0xc0002960, 0x17c07c1f,
	0xd000b120, 0x17c07c1f, 0xc0c067e0, 0x17c07c1f, 0xc2400cc0, 0x17c07c1f,
	0x68600009, 0x00000001, 0xd820a3c1, 0x17c07c1f, 0xc0c0d260, 0x17c07c1f,
	0xd000a400, 0x17c07c1f, 0xc180c820, 0x17c07c1f, 0x1800001f, 0x00000002,
	0xc0002960, 0x17c07c1f, 0xd000b120, 0x17c07c1f, 0x2060140a, 0xd820aaa1,
	0x17c07c1f, 0xc1400000, 0x17c07c1f, 0xc2800440, 0x17c07c1f, 0x6060140a,
	0xd820a741, 0x17c07c1f, 0xc0c0d260, 0x17c07c1f, 0xc0c071e0, 0x17c07c1f,
	0x1800001f, 0x00000003, 0xc0002960, 0x17c07c1f, 0xd000b120, 0x17c07c1f,
	0x2060140a, 0xd820a921, 0x17c07c1f, 0xc0c0d260, 0x17c07c1f, 0xc0c06ac0,
	0x17c07c1f, 0xc0c071e0, 0x17c07c1f, 0x1800001f, 0x00000004, 0xc0002960,
	0x17c07c1f, 0xd000b120, 0x17c07c1f, 0xc0c067e0, 0x17c07c1f, 0xc0c0d260,
	0x17c07c1f, 0xc0c071e0, 0x17c07c1f, 0x1800001f, 0x00000005, 0xc0002960,
	0x17c07c1f, 0xd000b120, 0x17c07c1f, 0xc1400000, 0x17c07c1f, 0xc2800440,
	0x17c07c1f, 0x6060140a, 0xd820ae01, 0x17c07c1f, 0xc0c06da0, 0x17c07c1f,
	0xc2400da0, 0x17c07c1f, 0x68600009, 0x00000001, 0xd820ad01, 0x17c07c1f,
	0xc0c0d260, 0x17c07c1f, 0xd000ad40, 0x17c07c1f, 0xc180ca40, 0x17c07c1f,
	0x1800001f, 0x00000006, 0xc0002960, 0x17c07c1f, 0xd000b120, 0x17c07c1f,
	0x2060140a, 0xd820afe1, 0x17c07c1f, 0xc0c06da0, 0x17c07c1f, 0xc0c0d260,
	0x17c07c1f, 0xc0c06ac0, 0x17c07c1f, 0x1800001f, 0x00000007, 0xc0002960,
	0x17c07c1f, 0xd000b120, 0x17c07c1f, 0xc0c067e0, 0x17c07c1f, 0xc0c06da0,
	0x17c07c1f, 0xc0c0d260, 0x17c07c1f, 0x1800001f, 0x00000008, 0xc0002960,
	0x17c07c1f, 0xc0c02de0, 0x17c07c1f, 0xc2800440, 0x17c07c1f, 0xc28000e0,
	0x17c07c1f, 0xc2800660, 0x17c07c1f, 0xc2800300, 0x17c07c1f, 0x1810001f,
	0x10227150, 0x1840001f, 0x0011c000, 0x1890001f, 0x10227608, 0x00c00801,
	0xe0c00000, 0x08800002, 0x0000000c, 0x79200002, 0x00000f70, 0xd800b464,
	0x17c07c1f, 0x1880001f, 0x00000340, 0x18c0001f, 0x10227608, 0xe0c00002,
	0x1a90001f, 0x1022741c, 0x1295a81f, 0x1990001f, 0x1022761c, 0x89800006,
	0x00000070, 0x1191981f, 0xa280180a, 0x1183981f, 0x1940001f, 0x0011c048,
	0x02319805, 0x1a700008, 0x17c07c1f, 0x8a400009, 0x0000007f, 0xa280240a,
	0x1890001f, 0x1022760c, 0x00c00801, 0xe0c0000a, 0x08800002, 0x0000000c,
	0x79200002, 0x00000f74, 0xd800b884, 0x17c07c1f, 0x1880001f, 0x00000344,
	0x18c0001f, 0x1022760c, 0xe0c00002, 0x1a90001f, 0x10227420, 0x1295a81f,
	0x1990001f, 0x1022761c, 0x89800006, 0x00700000, 0x1186981f, 0xa280180a,
	0x1183981f, 0x1940001f, 0x0011c0d8, 0x02319805, 0x1a700008, 0x17c07c1f,
	0x8a400009, 0x0000007f, 0xa280240a, 0x1890001f, 0x10227424, 0x00c00801,
	0xe0c0000a, 0x08800002, 0x0000000c, 0x79200002, 0x00000f78, 0xd800bca4,
	0x17c07c1f, 0x1880001f, 0x00000348, 0x18c0001f, 0x10227424, 0xe0c00002,
	0x1980001f, 0x00000001, 0xc1800b80, 0x17c07c1f, 0xc1800960, 0x17c07c1f,
	0x1840001f, 0x0011c324, 0x18d0001f, 0x1022761c, 0xe0400003, 0x1840001f,
	0x0011c328, 0x18d0001f, 0x10227618, 0xe0400003, 0x1840001f, 0x0011c32c,
	0x18d0001f, 0x10227614, 0xe0400003, 0x1b80001f, 0x20003365, 0xd0008220,
	0x17c07c1f, 0xf0000000, 0x1ad0001f, 0x10227618, 0x8ac0000b, 0x0000000f,
	0x12c02c1f, 0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x10227618, 0x8ac0000b,
	0x000f0000, 0x12c82c1f, 0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x10227618,
	0x8ac0000b, 0x000000f0, 0x12c22c1f, 0xf0000000, 0x17c07c1f, 0x1ad0001f,
	0x10227618, 0x8ac0000b, 0x00f00000, 0x12ca2c1f, 0xf0000000, 0x17c07c1f,
	0x1ad0001f, 0x10227618, 0x8ac0000b, 0x00000f00, 0x12c42c1f, 0xf0000000,
	0x17c07c1f, 0x1ad0001f, 0x10227618, 0x8ac0000b, 0x0f000000, 0x12cc2c1f,
	0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x10227618, 0x8ac0000b, 0x00001000,
	0x12c62c1f, 0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x10227618, 0x8ac0000b,
	0x10000000, 0x12ce2c1f, 0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x10227618,
	0x8ac0000b, 0x00002000, 0x12c6ac1f, 0xf0000000, 0x17c07c1f, 0x1850001f,
	0x10227618, 0x88400001, 0xffffdfff, 0xa056ac01, 0x18c0001f, 0x10227618,
	0xe0c00001, 0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x10227618, 0x8ac0000b,
	0x20000000, 0x12ceac1f, 0xf0000000, 0x17c07c1f, 0x1850001f, 0x10227618,
	0x88400001, 0xdfffffff, 0xa05eac01, 0x18c0001f, 0x10227618, 0xe0c00001,
	0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x1022761c, 0x8ac0000b, 0x000000f0,
	0x12c22c1f, 0xf0000000, 0x17c07c1f, 0x1ad0001f, 0x1022761c, 0x8ac0000b,
	0x00f00000, 0x12ca2c1f, 0xf0000000, 0x17c07c1f, 0x18c0001f, 0x0011c048,
	0x00f1ac03, 0x1af00003, 0x17c07c1f, 0xf0000000, 0x17c07c1f, 0x18c0001f,
	0x0011c0d8, 0x00f1ac03, 0x1af00003, 0x17c07c1f, 0xf0000000, 0x17c07c1f,
	0x1ad0001f, 0x1022761c, 0x8ac0000b, 0x7f000000, 0x12cc2c1f, 0xf0000000,
	0x17c07c1f, 0x1850001f, 0x1022761c, 0x88400001, 0x80ffffff, 0xa05c2c01,
	0x18c0001f, 0x1022761c, 0xe0c00001, 0xf0000000, 0x17c07c1f, 0x1850001f,
	0x1022761c, 0x88400001, 0xffff80ff, 0xa0542c01, 0x18c0001f, 0x1022761c,
	0xe0c00001, 0xf0000000, 0x17c07c1f, 0xc200cb80, 0x17c07c1f, 0xc200cd40,
	0x17c07c1f, 0x88000008, 0x00003f80, 0x1003801f, 0x8a000008, 0x0000007f,
	0xc100cc60, 0x17c07c1f, 0xc100ce20, 0x17c07c1f, 0x8a400004, 0x00003f80,
	0x1243a41f, 0x89000004, 0x0000007f, 0x20601008, 0xd820d541, 0x17c07c1f,
	0x1100201f, 0x1240001f, 0xc080cf00, 0x17c07c1f, 0x28600004, 0x00000058,
	0xd820d641, 0x17c07c1f, 0x1900001f, 0x00000058, 0x48600004, 0x00000020,
	0xd820d701, 0x17c07c1f, 0x1900001f, 0x00000020, 0x60600804, 0xd820d7a1,
	0x17c07c1f, 0xd000df40, 0x17c07c1f, 0x20600804, 0xd820db41, 0x17c07c1f,
	0x1200081f, 0x60602004, 0xd820d8c1, 0x17c07c1f, 0xd000df40, 0x17c07c1f,
	0x0a000008, 0x0000000c, 0x20601008, 0xd820d981, 0x17c07c1f, 0x1200101f,
	0x08000008, 0x00000010, 0x20602400, 0xd820da41, 0x17c07c1f, 0x1000241f,
	0xc000e7e0, 0x17c07c1f, 0xc200e040, 0x17c07c1f, 0x1b80001f, 0x20000300,
	0xd000d820, 0x17c07c1f, 0x1200081f, 0x60602004, 0xd820dc01, 0x17c07c1f,
	0xd000df40, 0x17c07c1f, 0x0a200008, 0x0000000c, 0x40601008, 0xd820dcc1,
	0x17c07c1f, 0x1200101f, 0xc200e040, 0x17c07c1f, 0x08000008, 0x00000010,
	0x40602400, 0xd820ddc1, 0x17c07c1f, 0x1000241f, 0x28600000, 0x00000058,
	0xd820de81, 0x17c07c1f, 0x1800001f, 0x00000058, 0xc000e7e0, 0x17c07c1f,
	0x1b80001f, 0x20000300, 0xd000db60, 0x17c07c1f, 0xc100cfe0, 0x17c07c1f,
	0xc100d120, 0x17c07c1f, 0x1800001f, 0x00000000, 0xf0000000, 0x17c07c1f,
	0xe8208000, 0x1100f004, 0x000000d6, 0xe8208000, 0x1100f008, 0x000000f8,
	0xe8208000, 0x1100f010, 0x00000028, 0xe8208000, 0x1100f014, 0x00000002,
	0xe8208000, 0x1100f018, 0x00000001, 0xe8208000, 0x1100f01c, 0x00000002,
	0xe8208000, 0x1100f020, 0x00001001, 0xe8208000, 0x1100f028, 0x00001800,
	0xe8208000, 0x1100f040, 0x00000000, 0xe8208000, 0x1100f048, 0x00000102,
	0xe8208000, 0x1100f054, 0x00000000, 0xe8208000, 0x1100f06c, 0x00000000,
	0x1840001f, 0x1100f000, 0xe060008e, 0xe040000b, 0xe8208000, 0x1100f024,
	0x00000001, 0x18d0001f, 0x1100f00c, 0x88c00003, 0x00000007, 0xd820e5a3,
	0x17c07c1f, 0x1840001f, 0x1100f00c, 0xe0400003, 0x18c0001f, 0x0011c310,
	0x1850001f, 0x0011c310, 0x1054041f, 0xa0402c01, 0xe0c00001, 0xf0000000,
	0x17c07c1f, 0xe8208000, 0x10006428, 0x00000001, 0x18d0001f, 0x10006428,
	0xd820e7e3, 0x17c07c1f, 0x1840001f, 0x1000d14c, 0xe06006aa, 0x1840001f,
	0x1000d150, 0xe040000b, 0x1840001f, 0x10006400, 0xe0600008, 0x1850001f,
	0x10006400, 0x104f841f, 0xd820e9e1, 0x17c07c1f, 0xe8208000, 0x10006428,
	0x00000001, 0x18c0001f, 0x0011c314, 0x1850001f, 0x0011c314, 0x1054041f,
	0xa0402c01, 0xe0c00001, 0xf0000000, 0x17c07c1f
};
static struct pcm_desc dvfs_pcm = {
	.version	= "pcm_dvfs_v0.1_150806_08",
	.base		= dvfs_binary,
	.size		= 1888,
	.sess		= 2,
	.replace	= 0,
	.addr_2nd	= 0,
};


#endif	/* _MT_CPUFREQ_HYBRID_FW_ */
