/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.border;

import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.visual.border.BevelBorder;
import org.netbeans.modules.visual.border.CompositeBorder;
import org.netbeans.modules.visual.border.DashedBorder;
import org.netbeans.modules.visual.border.EmptyBorder;
import org.netbeans.modules.visual.border.FancyDashedBorder;
import org.netbeans.modules.visual.border.ImageBorder;
import org.netbeans.modules.visual.border.LineBorder;
import org.netbeans.modules.visual.border.ResizeBorder;
import org.netbeans.modules.visual.border.RoundedBorder;
import org.netbeans.modules.visual.border.SwingBorder;
import org.netbeans.modules.visual.util.GeomUtil;
import org.openide.util.Parameters;

public final class BorderFactory {
    private static final Border BORDER_EMPTY = new EmptyBorder(0, 0, 0, 0, false);
    private static final Border BORDER_LINE = BorderFactory.createLineBorder(1);

    private BorderFactory() {
    }

    public static Border createEmptyBorder() {
        return BORDER_EMPTY;
    }

    public static Border createEmptyBorder(int n) {
        return n > 0 ? BorderFactory.createEmptyBorder(n, n, n, n) : BORDER_EMPTY;
    }

    public static Border createEmptyBorder(int n, int n2) {
        return BorderFactory.createEmptyBorder(n2, n, n2, n);
    }

    public static Border createEmptyBorder(int n, int n2, int n3, int n4) {
        return new EmptyBorder(n, n2, n3, n4, false);
    }

    public static Border createOpaqueBorder(int n, int n2, int n3, int n4) {
        return new EmptyBorder(n, n2, n3, n4, true);
    }

    public static Border createCompositeBorder(Border ... borderArray) {
        return new CompositeBorder(borderArray);
    }

    public static Border createSwingBorder(Scene scene, javax.swing.border.Border border) {
        Parameters.notNull((CharSequence)"scene", (Object)scene);
        Parameters.notNull((CharSequence)"border", (Object)border);
        return new SwingBorder(scene, border);
    }

    public static Border createLineBorder() {
        return BORDER_LINE;
    }

    public static Border createLineBorder(int n) {
        return BorderFactory.createLineBorder(n, null);
    }

    public static Border createLineBorder(int n, Color color) {
        return new LineBorder(n, n, n, n, color != null ? color : Color.BLACK);
    }

    public static Border createLineBorder(int n, int n2, int n3, int n4, Color color) {
        return new LineBorder(n, n2, n3, n4, color != null ? color : Color.BLACK);
    }

    public static Border createBevelBorder(boolean bl) {
        return BorderFactory.createBevelBorder(bl, null);
    }

    public static Border createBevelBorder(boolean bl, Color color) {
        return new BevelBorder(bl, color != null ? color : Color.GRAY);
    }

    public static Border createImageBorder(Insets insets, Image image) {
        return BorderFactory.createImageBorder(insets, insets, image);
    }

    public static Border createImageBorder(Insets insets, Insets insets2, Image image) {
        assert (insets != null && insets2 != null && image != null);
        return new ImageBorder(insets, insets2, image);
    }

    public static Border createRoundedBorder(int n, int n2, Color color, Color color2) {
        return BorderFactory.createRoundedBorder(n, n2, n, n2, color, color2);
    }

    public static Border createRoundedBorder(int n, int n2, int n3, int n4, Color color, Color color2) {
        return new RoundedBorder(n, n2, n3, n4, color, color2);
    }

    public static Border createResizeBorder(int n) {
        return BorderFactory.createResizeBorder(n, null, false);
    }

    public static Border createResizeBorder(int n, Color color, boolean bl) {
        return new ResizeBorder(n, color != null ? color : Color.BLACK, bl);
    }

    public static Border createDashedBorder(Color color, int n, int n2) {
        return BorderFactory.createDashedBorder(color, n, n2, false);
    }

    public static Border createDashedBorder(Color color, int n, int n2, boolean bl) {
        if (!bl) {
            return new FancyDashedBorder(color != null ? color : Color.BLACK, n, n2);
        }
        return new DashedBorder(color != null ? color : Color.BLACK, n, (float)n2);
    }

    public static Border createFancyDashedBorder(Color color, int n, int n2) {
        GeomUtil.LOG.warning("BorderFactory.createFancyDashedBorder() method is deprecated. Use BorderFactory.createDashedBorder(color,width,height,true) method instead.");
        return new FancyDashedBorder(color != null ? color : Color.BLACK, n, n2);
    }
}

