// events from file arm/armv7-common/events
    {0x00, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "PMNC_SW_INCR",
     "Software increment of PMNC registers"},
    {0x01, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "IFETCH_MISS",
     "Instruction fetch misses from cache or normal cacheable memory"},
    {0x02, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "ITLB_MISS",
     "Instruction fetch misses from TLB"},
    {0x03, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "DCACHE_REFILL",
     "Data R/W operation that causes a refill from cache or normal cacheable memory"},
    {0x04, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "DCACHE_ACCESS",
     "Data R/W from cache"},
    {0x05, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "DTLB_REFILL",
     "Data R/W that causes a TLB refill"},
    {0x06, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "DREAD",
     "Data read architecturally executed (note: architecturally executed = for instructions that are unconditional or that pass the condition code)"},
    {0x07, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "DWRITE",
     "Data write architecturally executed"},
    {0x08, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "INSTR_EXECUTED",
     "All executed instructions"},
    {0x09, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "EXC_TAKEN",
     "Exception taken"},
    {0x0A, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "EXC_EXECUTED",
     "Exception return architecturally executed"},
    {0x0B, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "CID_WRITE",
     "Instruction that writes to the Context ID Register architecturally executed"},
    {0x0C, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "PC_WRITE",
     "SW change of PC, architecturally executed (not by exceptions)"},
    {0x0D, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "PC_IMM_BRANCH",
     "Immediate branch instruction executed (taken or not)"},
    {0x0E, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "PC_PROC_RETURN",
     "Procedure return architecturally executed (not by exceptions)"},
    {0x0F, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "UNALIGNED_ACCESS",
     "Unaligned access architecturally executed"},
    {0x10, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "PC_BRANCH_MIS_PRED",
     "Branch mispredicted or not predicted. Counts pipeline flushes because of misprediction"},
    {0x12, CTR(1) | CTR(2) | CTR(3) | CTR(4) | CTR(5) | CTR(6), 0, "PC_BRANCH_MIS_USED",
     "Branch or change in program flow that could have been predicted"},
    {0xFF, CTR(0), 0, "CPU_CYCLES",
     "Number of CPU cycles"},
// events from file arm/armv7/events
    {0x40, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "WRITE_BUFFER_FULL",
     "Any write buffer full cycle"},
    {0x41, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "L2_STORE_MERGED",
     "Any store that is merged in L2 cache"},
    {0x42, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "L2_STORE_BUFF",
     "Any bufferable store from load/store to L2 cache"},
    {0x43, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "L2_ACCESS",
     "Any access to L2 cache"},
    {0x44, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "L2_CACH_MISS",
     "Any cacheable miss in L2 cache"},
    {0x45, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "AXI_READ_CYCLES",
     "Number of cycles for an active AXI read"},
    {0x46, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "AXI_WRITE_CYCLES",
     "Number of cycles for an active AXI write"},
    {0x47, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "MEMORY_REPLAY",
     "Any replay event in the memory subsystem"},
    {0x48, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "UNALIGNED_ACCESS_REPLAY",
     "Unaligned access that causes a replay"},
    {0x49, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "L1_DATA_MISS",
     "L1 data cache miss as a result of the hashing algorithm"},
    {0x4A, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "L1_INST_MISS",
     "L1 instruction cache miss as a result of the hashing algorithm"},
    {0x4B, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "L1_DATA_COLORING",
     "L1 data access in which a page coloring alias occurs"},
    {0x4C, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "L1_NEON_DATA",
     "NEON data access that hits L1 cache"},
    {0x4D, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "L1_NEON_CACH_DATA",
     "NEON cacheable data access that hits L1 cache"},
    {0x4E, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "L2_NEON",
     "L2 access as a result of NEON memory access"},
    {0x4F, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "L2_NEON_HIT",
     "Any NEON hit in L2 cache"},
    {0x50, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "L1_INST",
     "Any L1 instruction cache access, excluding CP15 cache accesses"},
    {0x51, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "PC_RETURN_MIS_PRED",
     "Return stack misprediction at return stack pop (incorrect target address)"},
    {0x52, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "PC_BRANCH_FAILED",
     "Branch prediction misprediction"},
    {0x53, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "PC_BRANCH_TAKEN",
     "Any predicted branch that is taken"},
    {0x54, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "PC_BRANCH_EXECUTED",
     "Any taken branch that is executed"},
    {0x55, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "OP_EXECUTED",
     "Number of operations executed (in instruction or mutli-cycle instruction)"},
    {0x56, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "CYCLES_INST_STALL",
     "Cycles where no instruction available"},
    {0x57, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "CYCLES_INST",
     "Number of instructions issued in a cycle"},
    {0x58, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "CYCLES_NEON_DATA_STALL",
     "Number of cycles the processor waits on MRC data from NEON"},
    {0x59, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "CYCLES_NEON_INST_STALL",
     "Number of cycles the processor waits on NEON instruction queue or NEON load queue"},
    {0x5A, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "NEON_CYCLES",
     "Number of cycles NEON and integer processors are not idle"},
    {0x70, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "PMU0_EVENTS",
     "Number of events from external input source PMUEXTIN[0]"},
    {0x71, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "PMU1_EVENTS",
     "Number of events from external input source PMUEXTIN[1]"},
    {0x72, CTR(1) | CTR(2) | CTR(3) | CTR(4), 0, "PMU_EVENTS",
     "Number of events from both external input sources PMUEXTIN[0] and PMUEXTIN[1]"},
