/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

/* ST LSM6DS3A Accelerometer and Gyroscope sensor driver
 *
 *
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <linux/interrupt.h>
#include <linux/i2c.h>
#include <linux/slab.h>
#include <linux/irq.h>
#include <linux/miscdevice.h>
#include <asm/uaccess.h>
#include <linux/delay.h>
#include <linux/input.h>
#include <linux/workqueue.h>
#include <linux/kobject.h>
#include <linux/earlysuspend.h>
#include <linux/platform_device.h>
#include <mach/mt_gpio.h>

#include <linux/sensors_io.h>
#include <linux/kernel.h>
#include <mach/mt_pm_ldo.h>
#include <cust_eint.h>
#include <mach/eint.h>
#include <linux/dma-mapping.h>
#include "lsm6ds3a.h"
#include <cust_acc.h>
#include <accel.h>

#define POWER_NONE_MACRO MT65XX_POWER_NONE
//#define LSM6DS3A_STEP_COUNTER 			//it depends on the MACRO LSM6DS3A_NEW_ARCH
//#define LSM6DS3A_TILT_FUNC 				//dependency on LSM6DS3A_STEP_COUNTER
//#define LSM6DS3A_SIGNIFICANT_MOTION  	//dependency on LSM6DS3A_STEP_COUNTER
//#define LSM6DS3A_FIFO_SUPPORT
#ifndef LSM6DS3A_STEP_COUNTER		//significant_motion depend on step_counter
#undef LSM6DS3A_SIGNIFICANT_MOTION
#endif
#ifdef LSM6DS3A_STEP_COUNTER //step counter
#include <step_counter.h>
#endif
#ifdef LSM6DS3A_TILT_FUNC //tilt detector
#include <tilt_detector.h>
#endif
/****************************************************************/
#if(defined(LSM6DS3A_TILT_FUNC) || defined(LSM6DS3A_SIGNIFICANT_MOTION) || defined(LSM6DS3A_STEP_COUNTER))
/*lenovo-sw caoyi1 modify for GPIO pin 20150325 begin*/
#define GPIO_LSM6DS3A_EINT_PIN GPIO_ACCEL_GYRO_INT1
#define GPIO_LSM6DS3A_EINT_PIN_M_EINT GPIO_ACCEL_GYRO_INT1_M_EINT
#define CUST_EINT_LSM6DS3A_NUM CUST_EINT_ACCEL_GYRO_INT1_NUM
/*lenovo-sw caoyi1 modify for GPIO pin 20150325 end*/
#define CUST_EINT_LSM6DS3A_DEBOUNCE_CN CUST_EINT_ACCEL_GYRO_INT1_DEBOUNCE_CN //debounce time
#define CUST_EINT_LSM6DS3A_TYPE CUST_EINT_ACCEL_GYRO_INT1_TYPE	//eint trigger type
/* lenovo-sw liaoxl add for int2 pin of lsm6ds3a  20150505 start */
#define GPIO_LSM6DS3A_EINT2_PIN GPIO_ACCEL_GYRO_INT2
#define GPIO_LSM6DS3A_EINT2_PIN_M_EINT GPIO_ACCEL_GYRO_INT2_M_EINT
#define CUST_EINT2_LSM6DS3A_NUM CUST_EINT_ACCEL_GYRO_INT2_NUM
#define CUST_EINT2_LSM6DS3A_DEBOUNCE_CN CUST_EINT_ACCEL_GYRO_INT2_DEBOUNCE_CN //debounce time
#define CUST_EINT2_LSM6DS3A_TYPE CUST_EINT_ACCEL_GYRO_INT2_TYPE	//eint trigger type
/* lenovo-sw liaoxl add for int2 pin of lsm6ds3a  20150505 start */
#endif
/*lenovo-sw caoyi1 add for selftest function 20150527 begin*/
#define LSM6DS3A_FTM_ENABLE 1
#ifdef LSM6DS3A_FTM_ENABLE
#define ABS_ST(X) ((X) < 0 ? (-1 * (X)) : (X))
#define MIN_ST   90
#define MAX_ST  1700
#endif
/*lenovo-sw caoyi1 add for selftest function 20150527 end*/
/*----------------------------------------------------------------------------*/
#define LSM6DS3A_ACC_DATA_LEN        6   
#define LSM6DS3A_GYRO_DATA_LEN       6   
#define LSM6DS3A_ACC_DEV_NAME        "LSM6DS3A_ACCEL"
/*----------------------------------------------------------------------------*/
static const struct i2c_device_id lsm6ds3a_i2c_id[] = {{LSM6DS3A_ACC_DEV_NAME,0},{}};
static struct i2c_board_info __initdata i2c_lsm6ds3a={ I2C_BOARD_INFO(LSM6DS3A_ACC_DEV_NAME, (0xD5>>1))};
/*----------------------------------------------------------------------------*/
static int lsm6ds3a_i2c_probe(struct i2c_client *client, const struct i2c_device_id *id);
static int lsm6ds3a_i2c_remove(struct i2c_client *client);
static int LSM6DS3A_init_client(struct i2c_client *client, int enable);
static int LSM6DS3A_acc_SetPowerMode(struct i2c_client *client, int enable);
static int LSM6DS3A_ReadAccRawData(struct i2c_client *client, s16 data[LSM6DS3A_ACC_AXES_NUM]);
#ifndef CONFIG_HAS_EARLYSUSPEND
static int lsm6ds3a_acc_suspend(struct i2c_client *client, pm_message_t msg);
static int lsm6ds3a_acc_resume(struct i2c_client *client);
#endif
static int LSM6DS3A_acc_SetSampleRate(struct i2c_client *client, u8 sample_rate);
#if defined(LSM6DS3A_STEP_COUNTER) ||defined(LSM6DS3A_TILT_FUNC) ||defined(LSM6DS3A_SIGNIFICANT_MOTION)
static int LSM6DS3A_acc_Enable_Func(struct i2c_client *client, LSM6DS3A_ACC_GYRO_FUNC_EN_t newValue);
static int LSM6DS3A_Int_Ctrl(struct i2c_client *client, LSM6DS3A_ACC_GYRO_INT_ACTIVE_t int_act, LSM6DS3A_ACC_GYRO_INT_LATCH_CTL_t int_latch);
#endif
#ifdef LSM6DS3A_STEP_COUNTER //step counter
static int LSM6DS3A_acc_Enable_Pedometer_Func(struct i2c_client *client, bool enable);
static int LSM6DS3A_Write_PedoThreshold(struct i2c_client *client, u8 newValue);
static int LSM6DS3A_Reset_Pedo_Data(struct i2c_client *client, LSM6DS3A_ACC_GYRO_PEDO_RST_STEP_t newValue);
#ifdef LSM6DS3A_SIGNIFICANT_MOTION
static int LSM6DS3A_Enable_SigMotion_Func(struct i2c_client *client, LSM6DS3A_ACC_GYRO_SIGN_MOT_t newValue);
#endif
#endif
#ifdef LSM6DS3A_TILT_FUNC //tilt detector
static int LSM6DS3A_Enable_Tilt_Func(struct i2c_client *client, bool enable);
static int LSM6DS3A_Enable_Tilt_Func_On_Int(struct i2c_client *client, LSM6DS3A_ACC_GYRO_ROUNT_INT_t tilt_int, bool enable);
#endif
#ifdef LSM6DS3A_FIFO_SUPPORT
int lsm6ds3a_reconfigure_fifo(struct lsm6ds3a_i2c_data *cdata);
#endif
/*----------------------------------------------------------------------------*/
static struct i2c_driver lsm6ds3a_i2c_driver = {
	.probe = lsm6ds3a_i2c_probe,
	.remove = lsm6ds3a_i2c_remove,
#if !defined(CONFIG_HAS_EARLYSUSPEND)    
	.suspend = lsm6ds3a_acc_suspend,
	.resume = lsm6ds3a_acc_resume,
#endif
	.id_table = lsm6ds3a_i2c_id,
	.driver = {
		.owner = THIS_MODULE,
		.name = LSM6DS3A_ACC_DEV_NAME,
	},
};
static int lsm6ds3a_local_init(void);
static int lsm6ds3a_local_uninit(void);
static int lsm6ds3a_acc_init_flag = -1;
static unsigned long lsm6ds3a_init_flag_test = 0; //initial state
static DEFINE_MUTEX(lsm6ds3a_init_mutex);
typedef enum {
	CFG_LSM6DS3A_ACC = 1,
	CFG_LSM6DS3A_STEP_C = 2,
	CFG_LSM6DS3A_TILT = 3,
}LSM6DS3A_INIT_TYPE;
static struct acc_init_info  lsm6ds3a_init_info = {
	.name   = LSM6DS3A_ACC_DEV_NAME,
	.init   = lsm6ds3a_local_init,
	.uninit = lsm6ds3a_local_uninit,
};
#ifdef LSM6DS3A_STEP_COUNTER
static int lsm6ds3a_step_c_local_init(void);
static int lsm6ds3a_step_c_local_uninit(void);
static struct step_c_init_info  lsm6ds3a_step_c_init_info = {
	.name   = "LSM6DS3A_STEP_C",
	.init   = lsm6ds3a_step_c_local_init,
	.uninit = lsm6ds3a_step_c_local_uninit,
};
#endif
#ifdef LSM6DS3A_TILT_FUNC
static int lsm6ds3a_tilt_local_init(void);
static int lsm6ds3a_tilt_local_uninit(void);
static struct tilt_init_info  lsm6ds3a_tilt_init_info = {
	.name   = "LSM6DS3A_TILT",
	.init   = lsm6ds3a_tilt_local_init,
	.uninit = lsm6ds3a_tilt_local_uninit,
};
#endif
/*----------------------------------------------------------------------------*/
static struct i2c_client *lsm6ds3a_i2c_client = NULL;
static struct lsm6ds3a_i2c_data *obj_i2c_data = NULL;
static bool pedo_enable_status = false;
static bool tilt_enable_status = false;
static bool sigm_enable_status = false;  /* add for significant motioon sensor -- by liaoxl.lenovo 5.12.2015 */
static bool stepd_enable_status = false; /* add for step detector sensor -- by liaoxl.lenovo 7.12.2015 */
/*----------------------------------------------------------------------------*/
#define GSE_TAG                  "[accel] "
#define GSE_FUN(f)               printk(KERN_ERR GSE_TAG"%s\n", __FUNCTION__)
#define GSE_ERR(fmt, args...)    printk(KERN_ERR GSE_TAG " %s %d : " fmt, __FUNCTION__, __LINE__, ##args)
#define GSE_LOG(fmt, args...)    printk(KERN_ERR GSE_TAG " %s %d : " fmt, __FUNCTION__, __LINE__, ##args)
/*----------------------------------------------------------------------------*/
#define IIC_MAX_TRANSFER_SIZE         8
#define IIC_DMA_MAX_TRANSFER_SIZE     250
#define LSM6DS3A_ADDR_LENGTH 1
#define I2C_MASTER_CLOCK 400
static u8 *gpDMABuf_va = NULL;
static dma_addr_t gpDMABuf_pa = 0;
struct mutex lsm_mutex;
DEFINE_MUTEX(lsm_mutex);
static int lsm6ds3a_i2c_read(struct lsm6ds3a_i2c_data *cdata, u8 reg_addr, int len, u8 *data)
{
	s32 ret = 0;
	s32 pos = 0;
	struct i2c_client *client = cdata->client;
	s32 transfer_length;
	u8 addr_buf[LSM6DS3A_ADDR_LENGTH] = { 0 };

	if (!client)
		return -EINVAL;

	if(len > 8)
	{
		struct i2c_msg msgs[2] = {
			{
				.flags = 0,	//!I2C_M_RD,
				.addr = (client->addr & I2C_MASK_FLAG),
				.timing = I2C_MASTER_CLOCK,
				.len = LSM6DS3A_ADDR_LENGTH,
				.buf = addr_buf,
			},
			{
				.flags = I2C_M_RD,
				.ext_flag = (client->ext_flag | I2C_ENEXT_FLAG | I2C_DMA_FLAG),
				.addr = (client->addr & I2C_MASK_FLAG),
				.timing = I2C_MASTER_CLOCK,
				.buf = (u8 *) gpDMABuf_pa,
			},
		};

		mutex_lock(&lsm_mutex);
		while (pos != len) {
			if (len - pos > IIC_DMA_MAX_TRANSFER_SIZE) {
				transfer_length = IIC_DMA_MAX_TRANSFER_SIZE;
			} else {
				transfer_length = len - pos;
			}

			msgs[0].buf[0] = reg_addr;
			msgs[1].len = transfer_length;

			ret = i2c_transfer(client->adapter, msgs, 2);
			if (ret != 2) {
				GSE_ERR("I2C Transfer error! (%d)\n", ret);
				ret = -EIO;
				break;
			}
			memcpy(&data[pos], gpDMABuf_va, transfer_length);
			pos += transfer_length;
		};
		mutex_unlock(&lsm_mutex);
		if(2 == ret)
		{
			ret = 0;
		}
	}
	else
	{
		struct i2c_msg msgs[2] = {
			{
				.addr = client->addr,	
				.flags = 0,
				.len = 1,	
				.buf = addr_buf,
			},
			{
				.addr = client->addr,	
				.flags = I2C_M_RD,
				.len = len,	
				.buf = data,
			}
		};
		msgs[0].buf[0] = reg_addr;
		mutex_lock(&lsm_mutex);
		ret = i2c_transfer(client->adapter, msgs, sizeof(msgs)/sizeof(msgs[0]));
		mutex_unlock(&lsm_mutex);
		if (ret != 2) {
			GSE_ERR("I2C Transfer error! (%d)\n", ret);
			ret = -EIO;
		} else {
			ret = 0;
		}
	}
	return ret;
}
static int lsm6ds3a_i2c_write(struct lsm6ds3a_i2c_data *cdata, u8 reg_addr, int len, u8 *data)
{
	s32 ret = 0;
	s32 pos = 0;
	s32 transfer_length;
	struct i2c_client *client = cdata->client;

	if(len > 8)
	{
		struct i2c_msg msg = {
			.flags = !I2C_M_RD,
			.ext_flag = (client->ext_flag | I2C_ENEXT_FLAG | I2C_DMA_FLAG),
			.addr = (client->addr & I2C_MASK_FLAG),
			.timing = I2C_MASTER_CLOCK,
			.buf = (u8 *) gpDMABuf_pa,
		};

		mutex_lock(&lsm_mutex);
		while (pos != len) {
			if (len - pos > (IIC_DMA_MAX_TRANSFER_SIZE - LSM6DS3A_ADDR_LENGTH)) {
				transfer_length = IIC_DMA_MAX_TRANSFER_SIZE - LSM6DS3A_ADDR_LENGTH;
			} else {
				transfer_length = len - pos;
			}

			gpDMABuf_va[0] = reg_addr;
			memcpy(&gpDMABuf_va[LSM6DS3A_ADDR_LENGTH], &data[pos], transfer_length);

			msg.len = transfer_length + LSM6DS3A_ADDR_LENGTH;

			ret = i2c_transfer(client->adapter, &msg, 1);
			if (ret != 1) {
				GSE_ERR("I2c Transfer error! (%d)\n", ret);
				ret = -EIO;
				break;
			}
			pos += transfer_length;
		}
		mutex_unlock(&lsm_mutex);
		if(ret ==1)
		{
			ret = 0;
		}
	}
	else
	{
		u8 buf[8];
		int num, idx;

		num = 0;
		buf[num++] = reg_addr;
		for (idx = 0; idx < len; idx++)
			buf[num++] = data[idx];
		mutex_lock(&lsm_mutex);
		ret = i2c_master_send(client, buf, num);
		mutex_unlock(&lsm_mutex);
		if (ret < 0) {
			GSE_ERR("send command error!!\n");
			return -EFAULT;
		} else {
			ret = 0;    /*no error*/
		}
	}
	return ret;
}

static void LSM6DS3A_dumpReg(struct i2c_client *client)
{
	/*lenovo-sw caoyi1 modify for debug 20150325 begin*/
	int i=0;
	u8 addr = 0x0C;
	u8 regdata=0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);

	for(i=0; i<35 ; i++)
	{	
		lsm6ds3a_i2c_read(obj, addr, 1, &regdata);
		GSE_LOG("Reg addr=%x regdata=%x\n",addr,regdata);
		addr++;	
	}
	addr = 0x49;
	for(i=0x49; i<0x60; i++)
	{		
		lsm6ds3a_i2c_read(obj, addr, 1, &regdata);
		GSE_LOG("Reg addr=%x regdata=%x\n",addr,regdata);
		addr++;
	}
	/*lenovo-sw caoyi1 modify for debug 20150325 end*/
}

static void LSM6DS3A_power(struct acc_hw *hw, unsigned int on) 
{
	static unsigned int power_on = 0;

	if(hw->power_id != POWER_NONE_MACRO)		// have externel LDO
	{        
		GSE_LOG("power %s\n", on ? "on" : "off");
		if(power_on == on)	// power status not change
		{
			GSE_LOG("ignore power control: %d\n", on);
		}
		else if(on)	// power on
		{
			if(!hwPowerOn(hw->power_id, hw->power_vol, "LSM6DS3A"))
			{
				GSE_ERR("power on fails!!\n");
			}
		}
		else	// power off
		{
			if (!hwPowerDown(hw->power_id, "LSM6DS3A"))
			{
				GSE_ERR("power off fail!!\n");
			}			  
		}
	}
	power_on = on;    
}
/*----------------------------------------------------------------------------*/
static int LSM6DS3A_acc_write_rel_calibration(struct lsm6ds3a_i2c_data *obj, int dat[LSM6DS3A_GYRO_AXES_NUM])
{
	obj->cali_sw[LSM6DS3A_AXIS_X] = obj->cvt.sign[LSM6DS3A_AXIS_X]*dat[obj->cvt.map[LSM6DS3A_AXIS_X]];
	obj->cali_sw[LSM6DS3A_AXIS_Y] = obj->cvt.sign[LSM6DS3A_AXIS_Y]*dat[obj->cvt.map[LSM6DS3A_AXIS_Y]];
	obj->cali_sw[LSM6DS3A_AXIS_Z] = obj->cvt.sign[LSM6DS3A_AXIS_Z]*dat[obj->cvt.map[LSM6DS3A_AXIS_Z]];
	return 0;
}
/*----------------------------------------------------------------------------*/
static int LSM6DS3A_acc_ResetCalibration(struct i2c_client *client)
{
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);	
	memset(obj->cali_sw, 0x00, sizeof(obj->cali_sw));
	return 0;    
}
/*----------------------------------------------------------------------------*/
static int LSM6DS3A_acc_ReadCalibration(struct i2c_client *client, int dat[LSM6DS3A_GYRO_AXES_NUM])
{
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);

	dat[obj->cvt.map[LSM6DS3A_AXIS_X]] = obj->cvt.sign[LSM6DS3A_AXIS_X]*obj->cali_sw[LSM6DS3A_AXIS_X];
	dat[obj->cvt.map[LSM6DS3A_AXIS_Y]] = obj->cvt.sign[LSM6DS3A_AXIS_Y]*obj->cali_sw[LSM6DS3A_AXIS_Y];
	dat[obj->cvt.map[LSM6DS3A_AXIS_Z]] = obj->cvt.sign[LSM6DS3A_AXIS_Z]*obj->cali_sw[LSM6DS3A_AXIS_Z];
	return 0;
}
/*----------------------------------------------------------------------------*/
static int LSM6DS3A_acc_WriteCalibration(struct i2c_client *client, int dat[LSM6DS3A_GYRO_AXES_NUM])
{
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	int err = 0;
	int cali[LSM6DS3A_GYRO_AXES_NUM];

	GSE_FUN();
	if(!obj || ! dat)
	{
		GSE_ERR("null ptr!!\n");
		return -EINVAL;
	}
	else
	{        		
		cali[obj->cvt.map[LSM6DS3A_AXIS_X]] = obj->cvt.sign[LSM6DS3A_AXIS_X]*obj->cali_sw[LSM6DS3A_AXIS_X];
		cali[obj->cvt.map[LSM6DS3A_AXIS_Y]] = obj->cvt.sign[LSM6DS3A_AXIS_Y]*obj->cali_sw[LSM6DS3A_AXIS_Y];
		cali[obj->cvt.map[LSM6DS3A_AXIS_Z]] = obj->cvt.sign[LSM6DS3A_AXIS_Z]*obj->cali_sw[LSM6DS3A_AXIS_Z]; 
		cali[LSM6DS3A_AXIS_X] += dat[LSM6DS3A_AXIS_X];
		cali[LSM6DS3A_AXIS_Y] += dat[LSM6DS3A_AXIS_Y];
		cali[LSM6DS3A_AXIS_Z] += dat[LSM6DS3A_AXIS_Z];
		return LSM6DS3A_acc_write_rel_calibration(obj, cali);
	} 
	return err;
}
/*----------------------------------------------------------------------------*/
static int LSM6DS3A_CheckDeviceID(struct i2c_client *client)
{
	u8 databuf[2];    
	int res;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);

	databuf[0] = LSM6DS3A_FIXED_DEVID;
	databuf[1] = 0;
	res = 	lsm6ds3a_i2c_read(obj, LSM6DS3A_WHO_AM_I, 1, databuf);
	GSE_LOG(" LSM6DS3A  LSM6DS3A_CheckDeviceID = 0x%x ret=%d!\n", databuf[0], res);
	if(databuf[0]!=LSM6DS3A_FIXED_DEVID)
	{
		return LSM6DS3A_ERR_IDENTIFICATION;
	}
	if (res < 0)
	{
		return LSM6DS3A_ERR_I2C;
	}
	return LSM6DS3A_SUCCESS;
}

#ifdef LSM6DS3A_TILT_FUNC //tilt detector
static int LSM6DS3A_enable_tilt(struct i2c_client *client, bool enable)
{
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);//obj_i2c_data;

	if(enable)
	{
		//set ODR to 26 hz		
		res = LSM6DS3A_acc_SetSampleRate(client, obj->sample_rate);
		if(LSM6DS3A_SUCCESS == res)
		{
			GSE_LOG(" %s set 26hz odr to acc\n", __func__);
		}			

		res = LSM6DS3A_Enable_Tilt_Func(client, enable);
		if(res != LSM6DS3A_SUCCESS)
		{
			GSE_LOG(" LSM6DS3A_Enable_Tilt_Func failed!\n");
			return LSM6DS3A_ERR_STATUS;
		}

		res = LSM6DS3A_acc_Enable_Func(client, LSM6DS3A_ACC_GYRO_FUNC_EN_ENABLED);	
		if(res != LSM6DS3A_SUCCESS)
		{
			GSE_LOG(" LSM6DS3A_acc_Enable_Func failed!\n");
			return LSM6DS3A_ERR_STATUS;
		}		

		res = LSM6DS3A_Enable_Tilt_Func_On_Int(client, LSM6DS3A_ACC_GYRO_INT1);  //default route to INT1 	
		if(res != LSM6DS3A_SUCCESS)
		{
			GSE_LOG(" LSM6DS3A_Enable_Tilt_Func_On_Int failed!\n");
			return LSM6DS3A_ERR_STATUS;
		}
		if(0 == atomic_read(&obj->int1_request_num))
		{
			mt_eint_unmask(CUST_EINT_LSM6DS3A_NUM);
		}
		atomic_inc(&obj->int1_request_num);
	}
	else
	{
		res = LSM6DS3A_Enable_Tilt_Func(client, enable);
		if(res != LSM6DS3A_SUCCESS)
		{
			GSE_LOG(" LSM6DS3A_Enable_Tilt_Func failed!\n");
			return LSM6DS3A_ERR_STATUS;
		}
		if(!atomic_read(&obj->gs_enable) && !pedo_enable_status && !sigm_enable_status)
		{
			res = LSM6DS3A_acc_SetPowerMode(client, 0);
			if(res != LSM6DS3A_SUCCESS)
			{
				GSE_LOG(" LSM6DS3A_acc_SetPowerMode failed!\n");
				return LSM6DS3A_ERR_STATUS;
			}
		}
		atomic_dec(&obj->int1_request_num);
		if(0 >= atomic_read(&obj->int1_request_num))
		{
			atomic_set(&obj->int1_request_num, 0);
			cancel_work_sync(&obj->eint_work);
			mt_eint_mask(CUST_EINT_LSM6DS3A_NUM);
		}
	}
	return LSM6DS3A_SUCCESS;
}
#endif

#ifdef LSM6DS3A_STEP_COUNTER //step counter
static int lsm6ds3a_write_data_with_mask(struct lsm6ds3a_i2c_data *cdata, u8 reg_addr, u8 mask, u8 data)
{
	int err;
	u8 new_data = 0x00, old_data = 0x00;

	err = lsm6ds3a_i2c_read(cdata, reg_addr, 1, &old_data);
	if (err < 0)
		return err;

	new_data = ((old_data & (~mask)) | ((data << __ffs(mask)) & mask));
	if (new_data == old_data)
		return 1;

	return lsm6ds3a_i2c_write(cdata, reg_addr, 1, &new_data);
}


static int LSM6DS3A_enable_pedo_On_Int(struct i2c_client *client, bool enable)
{
	u8 databuf[2] = {0}; 
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	GSE_FUN();    

	/* route INT2 to INT1 pin */
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL4_C, 1, databuf))
	{
		GSE_ERR("%s read LSM6DS3A_CTRL4_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  LSM6DS3A_CTRL4_C register: 0x%x\n", databuf[0]);
	}
	databuf[1] = databuf[0] | 0x20;
	databuf[0] = LSM6DS3A_CTRL4_C;
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL4_C register err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_TAP_CFG, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_TAP_CFG register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read LSM6DS3A_TAP_CFG register: 0x%x\n", databuf[0]);
	}
	if(enable)
	{
		databuf[0] &= ~LSM6DS3A_TIMER_EN;//clear 
		databuf[0] |= LSM6DS3A_TIMER_EN_ENABLED;
	}
	else
	{
		databuf[0] &= ~LSM6DS3A_TIMER_EN;//clear 
		databuf[0] |= LSM6DS3A_TIMER_EN_DISABLED;
	}
	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_TAP_CFG;
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write LSM6DS3A_TAP_CFG func register err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	if(enable)
	{
		/* enable step count delta func */
		/* step2 TIMER_HR bit = 0 */
		if(lsm6ds3a_i2c_read(obj, LSM6DS3A_WAKE_UP_DUR, 1, databuf))
		{
			GSE_ERR("read acc wakeup dur register err!\n");
			return LSM6DS3A_ERR_I2C;
		}
		else
		{
			GSE_LOG("read  acc wakeup dur register: 0x%x\n", databuf[0]);
		}
		databuf[0] &= ~0x10;
		databuf[1] = databuf[0];
		databuf[0] = LSM6DS3A_WAKE_UP_DUR; 	
		res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
		if(res < 0)
		{
			GSE_ERR("write acc wakeup func register err!\n");
			return LSM6DS3A_ERR_I2C;
		}
		/* step3 STEP_COUNT_DELTA value, 1LSB = 1.6384S */
		/* treat as batch timeout value */
		databuf[1] = 0x80;
		databuf[0] = LSM6DS3A_FUNC_CFG_ACCESS; 	
		res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
		if(res < 0)
		{
			GSE_ERR("%s turnon embedded func access err1!\n", __func__);
			return LSM6DS3A_ERR_I2C;
		}
		databuf[1] = 3;  // 3 steps for test
		databuf[0] = LSM6DS3A_STEP_COUNT_DELTA; 
		res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
		if(res < 0)
		{
			GSE_ERR("%s write LSM6DS3A_STEP_COUNT_DELTA register err2!\n", __func__);
			return LSM6DS3A_ERR_I2C;
		}
		databuf[1] = 0x00;
		databuf[0] = LSM6DS3A_FUNC_CFG_ACCESS;
		res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
		if(res < 0)
		{
			GSE_ERR("%s turnoff embedded func access err!\n", __func__);
			return LSM6DS3A_ERR_I2C;
		}
#ifdef LSM6DS3A_FIFO_SUPPORT
		/* step4 step counter& timestamp as 4th FIFO data set */
		/*       step detecter as FIFO DRDY */
		res = lsm6ds3a_write_data_with_mask(obj, LSM6DS3A_FIFO_PEDO_E_ADDR, LSM6DS3A_FIFO_PEDO_E_MASK, 0x03);
		if(res < 0)
		{
			GSE_ERR("%s write LSM6DS3A_FIFO_PEDO_E_ADDR register err!\n", __func__);
			return LSM6DS3A_ERR_I2C;
		}

		res = lsm6ds3a_reconfigure_fifo(obj);
		if(res != LSM6DS3A_SUCCESS)
		{
			GSE_LOG(" lsm6ds3a_reconfigure_fifo failed!\n");
			return LSM6DS3A_ERR_STATUS;
		}
#endif
	}
	else
	{
		/* anything else? */
	}

	/*enable INT2_STEP_DELTA/INT2_STEP_COUNT_OV/INT2_FULL_FLAG/INT2_FIFO_OVR/INT2_FTH bit*/
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_INT2_CTRL, 1, databuf))
	{
		GSE_ERR("%s read LSM6DS3A_INT2_CTRL register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  LSM6DS3A_INT2_CTRL register: 0x%x\n", databuf[0]);
	}
#ifdef LSM6DS3A_FIFO_SUPPORT
	if(enable)
	{
		databuf[0] |= 0xF8;
	}
	else
	{
		databuf[0] &= ~0xF8;//clear 
	}
	/* turn off step counter delta intterrupt */
	if(atomic_read(&obj->suspend))
	{
		databuf[0] &= ~0x80;//clear 
	}
	else
	{
		databuf[0] |= 0x80;
	}
#else
	if(enable)
	{
		databuf[0] |= 0x40;
	}
	else
	{
		databuf[0] &= ~0x40;//clear 
	}
	/* turn off step counter delta intterrupt */
	if(atomic_read(&obj->suspend))
	{
		databuf[0] &= ~0x80;//clear 
	}
	else
	{
		databuf[0] |= 0x80;
	}
#endif
	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_INT2_CTRL;
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write LSM6DS3A_INT2_CTRL register err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	res = LSM6DS3A_Int_Ctrl(client, LSM6DS3A_ACC_GYRO_INT_ACTIVE_LOW, LSM6DS3A_ACC_GYRO_INT_LATCH);
	if(res < 0)
	{
		GSE_ERR(" call LSM6DS3A_Int_Ctrl func return err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	if(true == enable)
	{
		if(0 == atomic_read(&obj->int1_request_num))
		{
			mt_eint_unmask(CUST_EINT_LSM6DS3A_NUM);
			GSE_LOG("enable step counter eint\n");
		}
		atomic_inc(&obj->int1_request_num);
#ifdef LSM6DS3A_FIFO_SUPPORT
		mt_eint_unmask(CUST_EINT2_LSM6DS3A_NUM);
#endif
	}
	else
	{
		atomic_dec(&obj->int1_request_num);
		if(0 >= atomic_read(&obj->int1_request_num))
		{
			atomic_set(&obj->int1_request_num, 0);
			cancel_work_sync(&obj->eint_work);
			mt_eint_mask(CUST_EINT_LSM6DS3A_NUM);
			GSE_LOG("disable step counter eint\n");
		}
#ifdef LSM6DS3A_FIFO_SUPPORT
		mt_eint_mask(CUST_EINT2_LSM6DS3A_NUM);
#endif
	}

	return LSM6DS3A_SUCCESS;
}


static int LSM6DS3A_enable_pedo(struct i2c_client *client, bool enable)
{
	//	u8 databuf[2] = {0};    
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);//obj_i2c_data;
	GSE_FUN();

	if(true == enable)
	{	
		//software reset
		//set ODR to 26 hz		
		//res = LSM6DS3A_acc_SetSampleRate(client, LSM6DS3A_ACC_ODR_26HZ);
		res = LSM6DS3A_acc_SetSampleRate(client, obj->sample_rate);
		if(LSM6DS3A_SUCCESS == res)
		{
			GSE_LOG(" %s set 26hz odr to acc\n", __func__);
		}

		res = LSM6DS3A_acc_Enable_Func(client, LSM6DS3A_ACC_GYRO_FUNC_EN_ENABLED);	
		if(res != LSM6DS3A_SUCCESS)
		{
			GSE_LOG(" LSM6DS3A_acc_Enable_Func failed!\n");
			return LSM6DS3A_ERR_STATUS;
		}
		/* change reg value from 0x1B to 0x16 for step counter debounce on bus env --modified by liaoxl.lenovo 7.6.2015 */
		res = LSM6DS3A_Write_PedoThreshold(client, 0x19);  // set threshold to a certain value here
		if(res != LSM6DS3A_SUCCESS)
		{
			GSE_LOG(" LSM6DS3A_Write_PedoThreshold failed!\n");
			return LSM6DS3A_ERR_STATUS;
		}

		/* remove step counter reset operation to prevent data losing when system sleeping --modified by liaoxl.lenovo 7.28.2015 start */
		if(obj->boot_deb == 2)
		{
			obj->boot_deb = 1;
			res = LSM6DS3A_Reset_Pedo_Data(client, LSM6DS3A_ACC_GYRO_PEDO_RST_STEP_ENABLED);
			if(res != LSM6DS3A_SUCCESS)
			{
				GSE_LOG(" LSM6DS3A_Reset_Pedo_Data failed!\n");
				return LSM6DS3A_ERR_STATUS;
			}
		}
		/* remove step counter reset operation to prevent data losing when system sleeping --modified by liaoxl.lenovo 7.28.2015 end */

		/* config batch mode & wakeup relateds */
		res = LSM6DS3A_enable_pedo_On_Int(client, true);
		if(res != LSM6DS3A_SUCCESS)
		{
			GSE_LOG(" LSM6DS3A_enable_pedo_On_Int failed!\n");
			return LSM6DS3A_ERR_STATUS;
		}		

		//enable tilt feature and pedometer feature
		res = LSM6DS3A_acc_Enable_Pedometer_Func(client, enable);
		if(res != LSM6DS3A_SUCCESS)
		{
			GSE_LOG(" LSM6DS3A_acc_Enable_Pedometer_Func failed!\n");
			return LSM6DS3A_ERR_STATUS;
		}

	}
	else
	{
		res = LSM6DS3A_enable_pedo_On_Int(client, false);
		if(res != LSM6DS3A_SUCCESS)
		{
			GSE_LOG(" LSM6DS3A_enable_pedo_On_Int failed!\n");
			return LSM6DS3A_ERR_STATUS;
		}		

		res = LSM6DS3A_acc_Enable_Pedometer_Func(client, enable);
		if(res != LSM6DS3A_SUCCESS)
		{
			GSE_LOG(" LSM6DS3A_acc_Enable_Pedometer_Func failed at disable pedo!\n");
			return LSM6DS3A_ERR_STATUS;
		}
		/*do not turn off the func when other related func working, modified by liaoxl.lenovo 7.6.2015 */
		if(!atomic_read(&obj->gs_enable) && !tilt_enable_status && !sigm_enable_status)
		{
			res = LSM6DS3A_acc_SetPowerMode(client, 0);
			if(res != LSM6DS3A_SUCCESS)
			{
				GSE_LOG(" LSM6DS3A_acc_SetPowerMode failed at disable pedo!\n");
				return LSM6DS3A_ERR_STATUS;
			}
		}
	}
	return LSM6DS3A_SUCCESS;
}
#endif

static int LSM6DS3A_acc_SetPowerMode(struct i2c_client *client, int enable)
{
	u8 databuf[2] = {0};    
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);

	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL1_XL, 1, databuf))
	{
		GSE_ERR("read power ctl register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	if(enable == 1)
	{
		databuf[0] &= ~LSM6DS3A_ACC_ODR_MASK;//clear lsm6ds3a gyro ODR bits
		databuf[0] |= obj->sample_rate;//LSM6DS3A_ACC_ODR_104HZ; //default set 100HZ for LSM6DS3A acc
		atomic_set(&obj->gs_enable, 1);
	}
	else
	{
		databuf[0] &= ~LSM6DS3A_ACC_ODR_MASK;//clear lsm6ds3a acc ODR bits
		databuf[0] |= LSM6DS3A_ACC_ODR_POWER_DOWN;
		atomic_set(&obj->gs_enable, 0);
	}
	res = lsm6ds3a_i2c_write(obj, LSM6DS3A_CTRL1_XL, 1, databuf);
	if(res < 0)
	{
		GSE_LOG("LSM6DS3A set power mode: ODR 100hz failed!\n");
		return LSM6DS3A_ERR_I2C;
	}
	return LSM6DS3A_SUCCESS;    
}
/*----------------------------------------------------------------------------*/
static int LSM6DS3A_acc_SetFullScale(struct i2c_client *client, u8 acc_fs)
{
	u8 databuf[2] = {0};    
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);

	GSE_FUN();     

	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL1_XL, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL1_XL err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  LSM6DS3A_CTRL1_XL register: 0x%x\n", databuf[0]);
	}

	databuf[0] &= ~LSM6DS3A_ACC_RANGE_MASK;//clear 
	databuf[0] |= acc_fs;

	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_CTRL1_XL; 
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write full scale register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	switch(acc_fs)
	{
		case LSM6DS3A_ACC_RANGE_2g:
			obj->sensitivity = LSM6DS3A_ACC_SENSITIVITY_2G;
			break;
		case LSM6DS3A_ACC_RANGE_4g:
			obj->sensitivity = LSM6DS3A_ACC_SENSITIVITY_4G;
			break;
		case LSM6DS3A_ACC_RANGE_8g:
			obj->sensitivity = LSM6DS3A_ACC_SENSITIVITY_8G;
			break;
		case LSM6DS3A_ACC_RANGE_16g:
			obj->sensitivity = LSM6DS3A_ACC_SENSITIVITY_16G;
			break;
		default:
			obj->sensitivity = LSM6DS3A_ACC_SENSITIVITY_2G;
			break;
	}

	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL9_XL, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL9_XL err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  LSM6DS3A_CTRL9_XL register: 0x%x\n", databuf[0]);
	}

	databuf[0] &= ~LSM6DS3A_ACC_ENABLE_AXIS_MASK;//clear 
	databuf[0] |= LSM6DS3A_ACC_ENABLE_AXIS_X | LSM6DS3A_ACC_ENABLE_AXIS_Y| LSM6DS3A_ACC_ENABLE_AXIS_Z;

	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_CTRL9_XL; 
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write full scale register err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	return LSM6DS3A_SUCCESS;    
}
/*----------------------------------------------------------------------------*/
static int LSM6DS3A_acc_SetSampleRate(struct i2c_client *client, u8 sample_rate)
{
	u8 databuf[2] = {0}; 
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	GSE_FUN();    

	res = LSM6DS3A_acc_SetPowerMode(client, 1);	//set Sample Rate will enable power and should changed power status
	if(res != LSM6DS3A_SUCCESS)	
	{
		return res;
	}

	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL1_XL, 1, databuf))
	{
		GSE_ERR("read acc data format register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  acc data format register: 0x%x\n", databuf[0]);
	}

	databuf[0] &= ~LSM6DS3A_ACC_ODR_MASK;//clear 
	databuf[0] |= sample_rate;

	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_CTRL1_XL; 
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write sample rate register err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	return LSM6DS3A_SUCCESS;    
}

#ifdef LSM6DS3A_TILT_FUNC //tilt detector
static int LSM6DS3A_Enable_Tilt_Func(struct i2c_client *client, bool enable)
{
	u8 databuf[2] = {0}; 
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	GSE_FUN();    
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_TAP_CFG, 1, databuf))
	{
		GSE_ERR("read acc data format register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  acc data format register: 0x%x\n", databuf[0]);
	}

	if(enable)
	{
		databuf[0] &= ~LSM6DS3A_TILT_EN_MASK;//clear 
		databuf[0] |= LSM6DS3A_ACC_GYRO_TILT_EN_ENABLED;			
	}
	else
	{
		databuf[0] &= ~LSM6DS3A_TILT_EN_MASK;//clear 
		databuf[0] |= LSM6DS3A_ACC_GYRO_TILT_EN_DISABLED;		
	}

	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_TAP_CFG; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write enable tilt func register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	return LSM6DS3A_SUCCESS; 
}
#endif

#ifdef LSM6DS3A_SIGNIFICANT_MOTION
static int LSM6DS3A_Enable_SigMotion_Func_On_Int(struct i2c_client *client, bool enable)
{
	u8 databuf[2] = {0}; 
	int res = 0;
	u8 op_reg = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	LSM6DS3A_ACC_GYRO_FUNC_EN_t func_enable;
	LSM6DS3A_ACC_GYRO_SIGN_MOT_t sigm_enable;
	GSE_FUN();    

	if(enable)
	{
		func_enable = LSM6DS3A_ACC_GYRO_FUNC_EN_ENABLED;
		sigm_enable = LSM6DS3A_ACC_GYRO_SIGN_MOT_ENABLED;

		res = LSM6DS3A_acc_Enable_Func(client, func_enable);	
		if(res != LSM6DS3A_SUCCESS)
		{
			GSE_LOG(" LSM6DS3A_acc_Enable_Func failed!\n");
			return LSM6DS3A_ERR_STATUS;
		}	
	}
	else
	{
		sigm_enable = LSM6DS3A_ACC_GYRO_SIGN_MOT_DISABLED;
	}		

	res = LSM6DS3A_Enable_SigMotion_Func(client, sigm_enable);	
	if(res != LSM6DS3A_SUCCESS)
	{
		GSE_LOG(" LSM6DS3A_Enable_SigMotion_Func failed!\n");
		return LSM6DS3A_ERR_STATUS;
	}	
	// configure WU for sig int
	op_reg = LSM6DS3A_MD1_CFG;
	if(lsm6ds3a_i2c_read(obj, op_reg, 1, databuf))
	{
		GSE_ERR("%s read data format register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  acc data format register: 0x%x\n", databuf[0]);
	}

	if(enable)
	{
		databuf[0] &= ~LSM6DS3A_ACC_GYRO_MD1_WU_CFG;//clear 
		databuf[0] |= LSM6DS3A_ACC_GYRO_MD1_WU_CFG_ENABLE;			
	}
	else
	{
		databuf[0] &= ~LSM6DS3A_ACC_GYRO_MD1_WU_CFG;//clear 
		databuf[0] |= LSM6DS3A_ACC_GYRO_MD1_WU_CFG_DISABLE;		
	}

	databuf[1] = databuf[0];
	databuf[0] = op_reg; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write enable tilt func register err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	//Config interrupt for significant motion
	op_reg = LSM6DS3A_INT1_CTRL;
	if(lsm6ds3a_i2c_read(obj, op_reg, 1, databuf))
	{
		GSE_ERR("%s read data format register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  acc data format register: 0x%x\n", databuf[0]);
	}

	if(enable)
	{
		databuf[0] &= ~LSM6DS3A_ACC_GYRO_INT_SIGN_MOT_MASK;//clear 
		databuf[0] |= LSM6DS3A_ACC_GYRO_INT_SIGN_MOT_ENABLED;			
	}
	else
	{
		databuf[0] &= ~LSM6DS3A_ACC_GYRO_INT_SIGN_MOT_MASK;//clear 
		databuf[0] |= LSM6DS3A_ACC_GYRO_INT_SIGN_MOT_DISABLED;		
	}

	databuf[1] = databuf[0];
	databuf[0] = op_reg; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write enable tilt func register err!\n");
		return LSM6DS3A_ERR_I2C;
	}	
	res = LSM6DS3A_Int_Ctrl(client, LSM6DS3A_ACC_GYRO_INT_ACTIVE_LOW, LSM6DS3A_ACC_GYRO_INT_LATCH);
	if(res < 0)
	{
		GSE_ERR("write enable tilt func register err!\n");
		return LSM6DS3A_ERR_I2C;
	}	
	return LSM6DS3A_SUCCESS; 
}
#endif
#if defined(LSM6DS3A_STEP_COUNTER) ||defined(LSM6DS3A_TILT_FUNC) ||defined(LSM6DS3A_SIGNIFICANT_MOTION)
static int LSM6DS3A_Int_Ctrl(struct i2c_client *client, LSM6DS3A_ACC_GYRO_INT_ACTIVE_t int_act, LSM6DS3A_ACC_GYRO_INT_LATCH_CTL_t int_latch)
{
	u8 databuf[2] = {0}; 
	int res = 0;
	u8 op_reg = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	GSE_FUN();    

	//config latch int or no latch
	op_reg = LSM6DS3A_TAP_CFG;
	if(lsm6ds3a_i2c_read(obj, op_reg, 1, databuf))
	{
		GSE_ERR("%s read data format register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  acc data format register: 0x%x\n", databuf[0]);
	}

	databuf[0] &= ~LSM6DS3A_ACC_GYRO_INT_LATCH_CTL_MASK;//clear 
	databuf[0] |= int_latch;			
	databuf[1] = databuf[0];
	databuf[0] = op_reg; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write enable tilt func register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	// config high or low active
	op_reg = LSM6DS3A_CTRL3_C;
	if(lsm6ds3a_i2c_read(obj, op_reg, 1, databuf))
	{
		GSE_ERR("%s read data format register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  acc data format register: 0x%x\n", databuf[0]);
	}

	databuf[0] &= ~LSM6DS3A_ACC_GYRO_INT_ACTIVE_MASK;//clear 
	databuf[0] |= int_act;			
	databuf[1] = databuf[0];
	databuf[0] = op_reg; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write enable tilt func register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	return LSM6DS3A_SUCCESS; 
}
#endif
#ifdef LSM6DS3A_TILT_FUNC //tilt detector
static int LSM6DS3A_Enable_Tilt_Func_On_Int(struct i2c_client *client, LSM6DS3A_ACC_GYRO_ROUNT_INT_t tilt_int, bool enable)
{
	u8 databuf[2] = {0}; 
	int res = 0;
	u8 op_reg = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	GSE_FUN();    

	if(LSM6DS3A_ACC_GYRO_INT1 == tilt_int)
	{
		op_reg = LSM6DS3A_MD1_CFG;
	}
	else if(LSM6DS3A_ACC_GYRO_INT2 == tilt_int)
	{
		op_reg = LSM6DS3A_MD2_CFG;
	}

	if(lsm6ds3a_i2c_read(obj, op_reg, 1, databuf))
	{
		GSE_ERR("%s read data format register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  acc data format register: 0x%x\n", databuf[0]);
	}

	if(enable)
	{
		databuf[0] &= ~LSM6DS3A_ACC_GYRO_INT_TILT_MASK;//clear 
		databuf[0] |= LSM6DS3A_ACC_GYRO_INT_TILT_ENABLED;			
	}
	else
	{
		databuf[0] &= ~LSM6DS3A_ACC_GYRO_INT_TILT_MASK;//clear 
		databuf[0] |= LSM6DS3A_ACC_GYRO_INT_TILT_DISABLED;		
	}

	databuf[1] = databuf[0];
	databuf[0] = op_reg; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write enable tilt func register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	res = LSM6DS3A_Int_Ctrl(client, LSM6DS3A_ACC_GYRO_INT_ACTIVE_LOW, LSM6DS3A_ACC_GYRO_INT_LATCH);
	if(res < 0)
	{
		GSE_ERR("write enable tilt func register err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	return LSM6DS3A_SUCCESS; 
}
#endif

#ifdef LSM6DS3A_STEP_COUNTER //step counter
static int LSM6DS3A_acc_Enable_Pedometer_Func(struct i2c_client *client, bool enable)
{
	u8 databuf[2] = {0}; 
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	GSE_FUN();    

	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_TAP_CFG, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_TAP_CFG register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read LSM6DS3A_TAP_CFG register: 0x%x\n", databuf[0]);
	}

	if(enable)
	{
		databuf[0] &= ~LSM6DS3A_PEDO_EN_MASK;//clear 
		databuf[0] |= LSM6DS3A_ACC_GYRO_PEDO_EN_ENABLED;
	}
	else
	{
		databuf[0] &= ~LSM6DS3A_PEDO_EN_MASK;//clear 
		databuf[0] |= LSM6DS3A_ACC_GYRO_PEDO_EN_DISABLED;
	}
	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_TAP_CFG; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write enable pedometer func register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	return LSM6DS3A_SUCCESS;    
}

#ifdef LSM6DS3A_SIGNIFICANT_MOTION
static int LSM6DS3A_Set_SigMotion_Threshold(struct i2c_client *client, u8 SigMotion_Threshold)
{
	u8 databuf[2] = {0}; 
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	GSE_FUN();    
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_FUNC_CFG_ACCESS, 1, databuf))
	{
		GSE_ERR("%s read LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("%s read acc data format register: 0x%x\n", __func__, databuf[0]);
	}
	databuf[0] = 0x80;

	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_FUNC_CFG_ACCESS; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("%s write LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] = SigMotion_Threshold;
	databuf[0] = LSM6DS3A_SM_THS; 
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("%s write LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] = 0x00;
	databuf[0] = LSM6DS3A_FUNC_CFG_ACCESS;
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("%s write LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}

	// read WU TH	
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_WAKE_UP_THS, 1, databuf))
	{
		GSE_ERR("%s read LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("%s read acc data format register: 0x%x\n", __func__, databuf[0]);
	}
	databuf[0] &= ~LSM6DS3A_ACC_WU_TH_MASK;//clear 
	databuf[0] |= 0x0a;

	// set Wu TH
	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_WAKE_UP_THS; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("%s write LSM6DS3A_WAKE_UP_THS register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}

	// read WU DUR
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_WAKE_UP_DUR, 1, databuf))
	{
		GSE_ERR("read acc wakeup dur register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  acc wakeup dur register: 0x%x\n", databuf[0]);
	}
	databuf[0] &= ~LSM6DS3A_ACC_WU_DUR_MASK;
	databuf[0] |= 0x20;

	//set WU DUR
	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_WAKE_UP_DUR; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write enable LSM6DS3A_WAKE_UP_DUR register err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	// read LSM6DS3A_TAP_CFG
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_TAP_CFG, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_TAP_CFG register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read LSM6DS3A_TAP_CFG register: 0x%x\n", databuf[0]);
	}

	// set TAP_CFG  SLOPE ENABLE
	databuf[0] &= ~LSM6DS3A_ACC_GYRO_SLOPE_FDS_MASK;//clear 
	databuf[0] |= LSM6DS3A_ACC_GYRO_SLOPE_FDS_ENABLE_HF_DISABLE;

	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_TAP_CFG;	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write enable pedometer func register err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	return LSM6DS3A_SUCCESS;    
}
static int LSM6DS3A_Enable_SigMotion_Func(struct i2c_client *client, LSM6DS3A_ACC_GYRO_SIGN_MOT_t newValue)
{
	u8 databuf[2] = {0}; 
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	GSE_FUN();    

	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL10_C, 1, databuf))
	{
		GSE_ERR("%s read LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("%s read acc data format register: 0x%x\n", __func__, databuf[0]);
	}
	/* do not reset step counter -- modified by liaoxl.lenovo 5.12.2015 start */
	databuf[0] &= ~(LSM6DS3A_ACC_GYRO_SIGN_MOT_MASK | LSM6DS3A_PEDO_RST_STEP_MASK);//clear 
	databuf[0] |= newValue;
	/* do not reset step counter -- modified by liaoxl.lenovo 5.12.2015 end */

	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_CTRL10_C; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("%s write LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	return LSM6DS3A_SUCCESS;    
}
#endif
#endif
#if defined(LSM6DS3A_STEP_COUNTER) ||defined(LSM6DS3A_TILT_FUNC) ||defined(LSM6DS3A_SIGNIFICANT_MOTION)
static int LSM6DS3A_acc_Enable_Func(struct i2c_client *client, LSM6DS3A_ACC_GYRO_FUNC_EN_t newValue)
{
	u8 databuf[2] = {0}; 
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	GSE_FUN();    

	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL10_C, 1, databuf))
	{
		GSE_ERR("%s read LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("%s read acc data format register: 0x%x\n", __func__, databuf[0]);
	}
	/* do not reset step counter -- modified by liaoxl.lenovo 5.12.2015 start */
	databuf[0] &= ~(LSM6DS3A_ACC_GYRO_FUNC_EN_MASK | LSM6DS3A_PEDO_RST_STEP_MASK);//clear 
	/* do not reset step counter -- modified by liaoxl.lenovo 5.12.2015 start */
	databuf[0] |= newValue;

	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_CTRL10_C; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("%s write LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}

	return LSM6DS3A_SUCCESS;    
}
#endif
#ifdef LSM6DS3A_STEP_COUNTER //step counter
static int LSM6DS3A_W_Open_RAM_Page(struct i2c_client *client, LSM6DS3A_ACC_GYRO_RAM_PAGE_t newValue)
{
	u8 databuf[2] = {0}; 
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	GSE_FUN();    

	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_RAM_ACCESS, 1, databuf))
	{
		GSE_ERR("%s read LSM6DS3A_RAM_ACCESS register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("%s read acc data format register: 0x%x\n", __func__, databuf[0]);
	}
	databuf[0] &= ~LSM6DS3A_RAM_PAGE_MASK;//clear 
	databuf[0] |= newValue;

	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_RAM_ACCESS; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("%s write LSM6DS3A_RAM_ACCESS register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}

	return LSM6DS3A_SUCCESS;
}

static int LSM6DS3A_Write_PedoThreshold(struct i2c_client *client, u8 newValue)
{
	u8 databuf[2] = {0}; 
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	GSE_FUN();    

	res = LSM6DS3A_W_Open_RAM_Page(client, LSM6DS3A_ACC_GYRO_RAM_PAGE_ENABLED);
	if(LSM6DS3A_SUCCESS != res)
	{
		return res;
	}
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CONFIG_PEDO_THS_MIN, 1, databuf))
	{
		GSE_ERR("%s read LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("%s read acc data format register: 0x%x\n", __func__, databuf[0]);
	}

	databuf[0] &= ~0x1F; 
	databuf[0] |= (newValue & 0x1F);

	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_CONFIG_PEDO_THS_MIN; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("%s write LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}

	databuf[0] = 0x14;
	databuf[1] = 0x6e; 
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("%s write LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	res = LSM6DS3A_W_Open_RAM_Page(client, LSM6DS3A_ACC_GYRO_RAM_PAGE_DISABLED);
	if(LSM6DS3A_SUCCESS != res)
	{
		GSE_ERR("%s write LSM6DS3A_W_Open_RAM_Page failed!\n", __func__);
		return res;
	}

	return LSM6DS3A_SUCCESS; 
}


static int LSM6DS3A_Reset_Pedo_Data(struct i2c_client *client, LSM6DS3A_ACC_GYRO_PEDO_RST_STEP_t newValue)
{
	u8 databuf[2] = {0}; 
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	GSE_FUN();    
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL10_C, 1, databuf))
	{
		GSE_ERR("%s read LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("%s read acc LSM6DS3A_CTRL10_C data format register: 0x%x\n", __func__, databuf[0]);
	}
	databuf[0] &= ~LSM6DS3A_PEDO_RST_STEP_MASK;//clear 
	databuf[0] |= newValue;

	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_CTRL10_C; 	
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("%s write LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}

	msleep(20);
	databuf[1] &= ~LSM6DS3A_PEDO_RST_STEP_MASK;
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("%s write LSM6DS3A_CTRL10_C register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}

	return LSM6DS3A_SUCCESS;
}
static int LSM6DS3A_Get_Pedo_DataReg(struct i2c_client *client, u16 *Value)
{
	u8 databuf[2] = {0};
	struct lsm6ds3a_i2c_data *obj = (struct lsm6ds3a_i2c_data*)i2c_get_clientdata(client);
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_STEP_COUNTER_L, 2, databuf))
	{
		GSE_ERR("LSM6DS3A read acc data  error\n");
		return -2;
	}

	*Value = (databuf[1]<<8)|databuf[0];	
	//	GSE_LOG("read step count=%d \n", *Value);

	return LSM6DS3A_SUCCESS;
}
#endif
/*----------------------------------------------------------------------------*/
static int LSM6DS3A_ReadAccData(struct i2c_client *client, char *buf, int bufsize)
{
	struct lsm6ds3a_i2c_data *obj = (struct lsm6ds3a_i2c_data*)i2c_get_clientdata(client);
	u8 databuf[20];
	int acc[LSM6DS3A_ACC_AXES_NUM];
	int res = 0;
	memset(databuf, 0, sizeof(u8)*10);

	if(NULL == buf)
	{
		return -1;
	}
	if(NULL == client)
	{
		*buf = 0;
		return -2;
	}

	if(0 == atomic_read(&obj->gs_enable))
	{
		res = LSM6DS3A_acc_SetPowerMode(client, 1);
		if(res)
		{
			GSE_ERR("Power on lsm6ds3a error %d!\n", res);
		}
		msleep(20);
	}

	res = LSM6DS3A_ReadAccRawData(client, obj->data);
	if(res < 0)
	{        
		GSE_ERR("I2C error: ret value=%d", res);
		return -3;
	}
	else
	{
		obj->data[LSM6DS3A_AXIS_X] = (long)(obj->data[LSM6DS3A_AXIS_X]) * obj->sensitivity*GRAVITY_EARTH_1000/(1000*1000); //NTC
		obj->data[LSM6DS3A_AXIS_Y] = (long)(obj->data[LSM6DS3A_AXIS_Y]) * obj->sensitivity*GRAVITY_EARTH_1000/(1000*1000);
		obj->data[LSM6DS3A_AXIS_Z] = (long)(obj->data[LSM6DS3A_AXIS_Z]) * obj->sensitivity*GRAVITY_EARTH_1000/(1000*1000);
		/*remap coordinate*/
		acc[obj->cvt.map[LSM6DS3A_AXIS_X]] = obj->cvt.sign[LSM6DS3A_AXIS_X]*obj->data[LSM6DS3A_AXIS_X];
		acc[obj->cvt.map[LSM6DS3A_AXIS_Y]] = obj->cvt.sign[LSM6DS3A_AXIS_Y]*obj->data[LSM6DS3A_AXIS_Y];
		acc[obj->cvt.map[LSM6DS3A_AXIS_Z]] = obj->cvt.sign[LSM6DS3A_AXIS_Z]*obj->data[LSM6DS3A_AXIS_Z];
		acc[LSM6DS3A_AXIS_X] =  acc[LSM6DS3A_AXIS_X] - obj->gs_cali[LSM6DS3A_AXIS_X];
		acc[LSM6DS3A_AXIS_Y] =  acc[LSM6DS3A_AXIS_Y] -obj->gs_cali[LSM6DS3A_AXIS_Y];
		acc[LSM6DS3A_AXIS_Z] =  acc[LSM6DS3A_AXIS_Z] - obj->gs_cali[LSM6DS3A_AXIS_Z];
		sprintf(buf, "%04x %04x %04x", acc[LSM6DS3A_AXIS_X], acc[LSM6DS3A_AXIS_Y], acc[LSM6DS3A_AXIS_Z]);
		//GSE_LOG("raw data:obj->data:%04x %04x %04x\n", obj->data[LSM6DS3A_AXIS_X], obj->data[LSM6DS3A_AXIS_Y], obj->data[LSM6DS3A_AXIS_Z]);
		//GSE_LOG("acc:%04x %04x %04x\n", acc[LSM6DS3A_AXIS_X], acc[LSM6DS3A_AXIS_Y], acc[LSM6DS3A_AXIS_Z]);
	}
	return 0;
}
static int LSM6DS3A_ReadAccRawData(struct i2c_client *client, s16 data[LSM6DS3A_ACC_AXES_NUM])
{
	int err = 0;
	char databuf[6] = {0};
	struct lsm6ds3a_i2c_data *obj = (struct lsm6ds3a_i2c_data*)i2c_get_clientdata(client);

	if(NULL == client)
	{
		err = -EINVAL;
	}	
	else
	{
		if(lsm6ds3a_i2c_read(obj, LSM6DS3A_OUTX_L_XL, 6, databuf))
		{
			GSE_ERR("LSM6DS3A read acc data  error\n");
			return -2;
		}
		else
		{
			data[LSM6DS3A_AXIS_X] = (s16)((databuf[LSM6DS3A_AXIS_X*2+1] << 8) | (databuf[LSM6DS3A_AXIS_X*2]));
			data[LSM6DS3A_AXIS_Y] = (s16)((databuf[LSM6DS3A_AXIS_Y*2+1] << 8) | (databuf[LSM6DS3A_AXIS_Y*2]));
			data[LSM6DS3A_AXIS_Z] = (s16)((databuf[LSM6DS3A_AXIS_Z*2+1] << 8) | (databuf[LSM6DS3A_AXIS_Z*2]));	
		}      
	}
	return err;
}
/*lenovo-sw caoyi1 add for selftest function 20150527 begin*/
#ifdef LSM6DS3A_FTM_ENABLE
static int lsm303d_acc_get_ST_data(struct i2c_client *client, int *xyz)
{
	int i;
	s16 acc_data[6];
	int hw_d[3] = {0};
	u8 buf[2];
	char databuf[6] = {0};
	int xyz_sum[3] = {0};

	if(hwmsen_read_block(client, LSM6DS3A_OUTX_L_XL, databuf, 6))
	{
		GSE_ERR("LSM6DS3A read acc data  error\n");
		return -2;
	}
	for(i=0; i<5;)
	{
		if(hwmsen_read_byte(client, LSM6DS3A_STATUS_REG, buf))
		{
			GSE_ERR("read acc data format register err!\n");
			return LSM6DS3A_ERR_I2C;
		}
		else
		{
			GSE_LOG("read  acc status  register: 0x%x\n", buf[0]);
		}

		if(buf[0] & 0x01) // checking status reg  0x01 bit)
		{
			i++;
			if(hwmsen_read_block(client, LSM6DS3A_OUTX_L_XL, databuf, 6))
			{
				GSE_ERR("LSM6DS3A read acc data  error\n");
				return -2;
			}

			acc_data[0] = (s16)((databuf[LSM6DS3A_AXIS_X*2+1] << 8) | (databuf[LSM6DS3A_AXIS_X*2]));
			acc_data[1] = (s16)((databuf[LSM6DS3A_AXIS_Y*2+1] << 8) | (databuf[LSM6DS3A_AXIS_Y*2]));
			acc_data[2] = (s16)((databuf[LSM6DS3A_AXIS_Z*2+1] << 8) | (databuf[LSM6DS3A_AXIS_Z*2]));
			GSE_ERR("raw-- x %d, y%d,z %d ,i %d \n",acc_data[0],acc_data[1],acc_data[2],i);	
			hw_d[0] = acc_data[0] * LSM6DS3A_ACC_SENSITIVITY_2G;
			hw_d[1] = acc_data[1] * LSM6DS3A_ACC_SENSITIVITY_2G;
			hw_d[2] = acc_data[2] * LSM6DS3A_ACC_SENSITIVITY_2G;
			GSE_ERR("x %d, y%d,z %d ,i %d \n",hw_d[0],hw_d[1],hw_d[2],i);	
			xyz_sum[0] =  hw_d[0] + xyz_sum[0] ;	  
			xyz_sum[1] =  hw_d[1] + xyz_sum[1] ;	  
			xyz_sum[2] =  hw_d[2] + xyz_sum[2] ;	 
		}else{
			msleep(25);
		}
	}

	xyz[0] = xyz_sum[0];
	xyz[1] = xyz_sum[1];
	xyz[2] = xyz_sum[2]; 
	GSE_ERR("sum x %d, y%d,z %d ,i %d \n",xyz[0], xyz[1], xyz[2] ,i);	
	return 0;
}
#endif
/*lenovo-sw caoyi1 add for selftest function 20150527 begin*/
static int LSM6DS3A_ReadChipInfo(struct i2c_client *client, char *buf, int bufsize)
{
	u8 databuf[10];    

	memset(databuf, 0, sizeof(u8)*10);

	if((NULL == buf)||(bufsize<=30))
	{
		return -1;
	}

	if(NULL == client)
	{
		*buf = 0;
		return -2;
	}
	sprintf(buf, "LSM6DS3A Chip");
	return 0;
}
static ssize_t show_chipinfo_value(struct device_driver *ddri, char *buf)
{
	struct i2c_client *client = lsm6ds3a_i2c_client;
	char strbuf[LSM6DS3A_BUFSIZE];
	if(NULL == client)
	{
		GSE_ERR("i2c client is null!!\n");
		return 0;
	}

	LSM6DS3A_ReadChipInfo(client, strbuf, LSM6DS3A_BUFSIZE);
	return snprintf(buf, PAGE_SIZE, "%s\n", strbuf);        
}
static ssize_t show_sensordata_value(struct device_driver *ddri, char *buf)
{
	struct i2c_client *client = lsm6ds3a_i2c_client;
	char strbuf[LSM6DS3A_BUFSIZE];
	int x,y,z;

	if(NULL == client)
	{
		GSE_ERR("i2c client is null!!\n");
		return 0;
	}

	LSM6DS3A_ReadAccData(client, strbuf, LSM6DS3A_BUFSIZE);
	sscanf(strbuf, "%x %x %x", &x, &y, &z);	
	return snprintf(buf, PAGE_SIZE, "%d, %d, %d\n", x,y,z);            
}
static ssize_t show_enable_value(struct device_driver *ddri, char *buf)
{
	ssize_t len = 0;
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;

	len += snprintf(buf, PAGE_SIZE, "%d\n", atomic_read(&obj->gs_enable));
	return len;
}
static ssize_t show_gs_cali_x_value(struct device_driver *ddri, char *buf)
{
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	int cali_x,cali_y,cali_z;

	cali_x =obj->gs_cali[LSM6DS3A_AXIS_X];
	cali_y =obj->gs_cali[LSM6DS3A_AXIS_Y];
	cali_z =obj->gs_cali[LSM6DS3A_AXIS_Z];
	return sprintf(buf, "x:%d y:%d z:%d\n", cali_x, cali_y, cali_z);
}
static ssize_t show_gs_cali_y_value(struct device_driver *ddri, char *buf)
{
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	int cali_x,cali_y,cali_z;

	cali_x =obj->gs_cali[LSM6DS3A_AXIS_X];
	cali_y =obj->gs_cali[LSM6DS3A_AXIS_Y];
	cali_z =obj->gs_cali[LSM6DS3A_AXIS_Z];
	return sprintf(buf, "x:%d y:%d z:%d\n", cali_x, cali_y, cali_z);
}
static ssize_t show_gs_cali_z_value(struct device_driver *ddri, char *buf)
{
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	int cali_x,cali_y,cali_z;

	cali_x =obj->gs_cali[LSM6DS3A_AXIS_X];
	cali_y =obj->gs_cali[LSM6DS3A_AXIS_Y];
	cali_z =obj->gs_cali[LSM6DS3A_AXIS_Z];
	return sprintf(buf, "x:%d y:%d z:%d\n", cali_x, cali_y, cali_z);
}
static ssize_t store_gs_cali_x_value(struct device_driver *ddri, const char *buf, size_t count)
{
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	int temp =0;

	if(1 == sscanf(buf, "%d", &temp))
	{
		obj->gs_cali[LSM6DS3A_AXIS_X] = temp;
	}
	else
	{
		GSE_ERR("store_gs_cali_x_value invalid format\n");
	}
	return count;
}
static ssize_t store_gs_cali_y_value(struct device_driver *ddri, const char *buf, size_t count)
{
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	int temp =0;

	if(1 == sscanf(buf, "%d", &temp))
	{
		obj->gs_cali[LSM6DS3A_AXIS_Y] = temp;
	}
	else
	{
		GSE_ERR("store_gs_cali_x_value invalid format\n");
	}
	return count;
}
static ssize_t store_gs_cali_z_value(struct device_driver *ddri, const char *buf, size_t count)
{
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	int temp =0;

	if(1 == sscanf(buf, "%d", &temp))
	{
		obj->gs_cali[LSM6DS3A_AXIS_Z] = temp;
	}
	else
	{
		GSE_ERR("store_gs_cali_x_value invalid format\n");
	}
	return count;
}
#ifdef LSM6DS3A_FTM_ENABLE
static int back_ST_reg_config(struct i2c_client  *client )
{
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	u8 databuf[2];

	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL1_XL, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL1_XL err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	obj ->resume_LSM6DS3A_CTRL1_XL = databuf[0];
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL2_G, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL2_G err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	obj ->resume_LSM6DS3A_CTRL2_G = databuf[0];
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL3_C, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL3_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	obj ->resume_LSM6DS3A_CTRL3_C = databuf[0];
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL4_C, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL4_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	obj ->resume_LSM6DS3A_CTRL4_C = databuf[0];
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL5_C, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL5_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	obj ->resume_LSM6DS3A_CTRL5_C = databuf[0];
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL6_C, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL6_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	obj ->resume_LSM6DS3A_CTRL6_C = databuf[0];
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL7_G, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL7_G err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	obj ->resume_LSM6DS3A_CTRL7_G = databuf[0];
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL8_XL, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL8_XL err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	obj ->resume_LSM6DS3A_CTRL8_XL = databuf[0];
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL9_XL, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL9_XL err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	obj ->resume_LSM6DS3A_CTRL9_XL = databuf[0];
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL10_C, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL10_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	obj ->resume_LSM6DS3A_CTRL10_C= databuf[0];

	return 0;
}
static int recover_ST_reg_config(struct i2c_client  *client )
{
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	u8 databuf[2];
	int res;

	databuf[1] = obj ->resume_LSM6DS3A_CTRL1_XL  ;
	databuf[0] = LSM6DS3A_CTRL1_XL; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL1_XL err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] =  obj ->resume_LSM6DS3A_CTRL2_G;
	databuf[0] = LSM6DS3A_CTRL2_G; 

	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL2_G err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] =  obj ->resume_LSM6DS3A_CTRL3_C;
	databuf[0] = LSM6DS3A_CTRL3_C; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL3_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] =  obj ->resume_LSM6DS3A_CTRL4_C;
	databuf[0] = LSM6DS3A_CTRL4_C; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL4_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] =  obj ->resume_LSM6DS3A_CTRL5_C;
	databuf[0] = LSM6DS3A_CTRL5_C; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL5_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] =  obj ->resume_LSM6DS3A_CTRL6_C;
	databuf[0] = LSM6DS3A_CTRL6_C; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL6_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1]  =  obj ->resume_LSM6DS3A_CTRL7_G;
	databuf[0] = LSM6DS3A_CTRL7_G; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL7_G err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] =  obj ->resume_LSM6DS3A_CTRL8_XL;
	databuf[0] = LSM6DS3A_CTRL8_XL; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL8_XL err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] =  obj ->resume_LSM6DS3A_CTRL9_XL;
	databuf[0] = LSM6DS3A_CTRL9_XL; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL9_XL err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] =  obj ->resume_LSM6DS3A_CTRL10_C;
	databuf[0] = LSM6DS3A_CTRL10_C; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL10_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	return 0;

}
static ssize_t show_acc_self_data(struct device_driver *ddri, char *buf)
{
	struct i2c_client *client = lsm6ds3a_i2c_client;

	int temp[3] ;
	int OUTX_NOST,OUTY_NOST,OUTZ_NOST;
	int OUTX_ST,OUTY_ST,OUTZ_ST;
	int ABS_OUTX,ABS_OUTY,ABS_OUTZ;
	int res;
	u8 databuf[2];
	u8 result = -1;

	res = back_ST_reg_config(client); 

	if(res < 0)
	{
		GSE_ERR("back ST_reg err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] = 0x30 ;
	databuf[0] = LSM6DS3A_CTRL1_XL; 

	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL1_XL err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] = 0x00 ;
	databuf[0] = LSM6DS3A_CTRL2_G; 

	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL2_G err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] = 0x44 ;
	databuf[0] = LSM6DS3A_CTRL3_C; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL3_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] = 0x00 ;
	databuf[0] = LSM6DS3A_CTRL4_C; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL4_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] = 0x00 ;
	databuf[0] = LSM6DS3A_CTRL5_C; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL5_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] = 0x00 ;
	databuf[0] = LSM6DS3A_CTRL6_C; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL6_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] = 0x00 ;
	databuf[0] = LSM6DS3A_CTRL7_G; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL7_G err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] = 0x00 ;
	databuf[0] = LSM6DS3A_CTRL8_XL; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL8_XL err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] = 0x38 ;
	databuf[0] = LSM6DS3A_CTRL9_XL; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL9_XL err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	databuf[1] = 0x00 ;
	databuf[0] = LSM6DS3A_CTRL10_C; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL10_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	LSM6DS3A_dumpReg(client);

	msleep(200);

	GSE_ERR("setting ST!\n");

	lsm303d_acc_get_ST_data(client, temp);

	OUTX_NOST =  temp[0] /5000;                                 // ug transfer to mg
	OUTY_NOST =  temp[1] /5000;	
	OUTZ_NOST =  temp[2] /5000;
	GSE_ERR("OUTX_NOST %d, OUTY_NOST %d,OUTZ_NOST %d \n",OUTX_NOST,OUTY_NOST,OUTZ_NOST);

	databuf[1] = 0x01 ;
	databuf[0] = LSM6DS3A_CTRL5_C; 
	res = i2c_master_send(client, databuf, 0x2);
	if(res <= 0)
	{
		GSE_ERR("write LSM6DS3A_CTRL5_C err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	LSM6DS3A_dumpReg(client);

	msleep(200);

	lsm303d_acc_get_ST_data(client, temp);

	OUTX_ST =  temp[0] /5000;
	OUTY_ST =  temp[1] /5000;	
	OUTZ_ST =  temp[2] /5000;

	GSE_ERR("OUTX_ST %d, OUTY_ST %d,OUTZ_ST %d \n",OUTX_ST,OUTY_ST,OUTZ_ST);


	ABS_OUTX = ABS_ST(OUTX_ST - OUTX_NOST) ;
	ABS_OUTY = ABS_ST(OUTY_ST - OUTY_NOST);
	ABS_OUTZ = ABS_ST(OUTZ_ST - OUTZ_NOST);

	if(((ABS_OUTX >= MIN_ST)&&(ABS_OUTX <= MAX_ST))
			&& ((ABS_OUTY >= MIN_ST)&&(ABS_OUTY <= MAX_ST))
			&& ((ABS_OUTZ >= MIN_ST)&&(ABS_OUTZ <= MAX_ST)))
	{
		GSE_ERR(" SELF TEST SUCCESS ABS_OUTX,ABS_OUTY,ABS_OUTZ:%d ,%d,%d\n", ABS_OUTX,ABS_OUTY,ABS_OUTZ);
		result = 1;
	}
	else
	{
		GSE_ERR(" SELF TEST FAIL ABS_OUTX,ABS_OUTY,ABS_OUTZ:%d ,%d,%d\n", ABS_OUTX,ABS_OUTY,ABS_OUTZ);
		result = 0;
	}
	res = recover_ST_reg_config(client); 

	if(res < 0)
	{
		GSE_ERR("recover ST_reg err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	return sprintf(buf, "%d\n", result);
}
#endif
/*lenovo-sw caoyi1 add for selftest function 20150527 end*/
/*----------------------------------------------------------------------------*/
static DRIVER_ATTR(chipinfo,	S_IWUSR | S_IRUGO, show_chipinfo_value,      NULL);
static DRIVER_ATTR(sensordata,	S_IWUSR | S_IRUGO, show_sensordata_value,    NULL);
static DRIVER_ATTR(enable,		S_IRUGO | S_IRUGO, show_enable_value, NULL);
static DRIVER_ATTR(gs_cali_x,	S_IWUSR | S_IRUGO, show_gs_cali_x_value,  store_gs_cali_x_value);
static DRIVER_ATTR(gs_cali_y,	S_IWUSR | S_IRUGO, show_gs_cali_y_value,  store_gs_cali_y_value);
static DRIVER_ATTR(gs_cali_z,	S_IWUSR | S_IRUGO, show_gs_cali_z_value,  store_gs_cali_z_value);
#ifdef LSM6DS3A_FTM_ENABLE
static DRIVER_ATTR(selftest,  S_IRUGO , show_acc_self_data, NULL);
#endif

static struct driver_attribute *LSM6DS3A_attr_list[] = {
	&driver_attr_chipinfo,     /*chip information*/
	&driver_attr_sensordata,   /*dump sensor data*/	
	&driver_attr_enable,
	&driver_attr_gs_cali_x ,   /* add for lenovo hal calib syspoint by jonny */
	&driver_attr_gs_cali_y ,   /* add for lenovo hal calib syspoint by jonny */
	&driver_attr_gs_cali_z ,   /* add for lenovo hal calib syspoint by jonny */
#ifdef LSM6DS3A_FTM_ENABLE
	&driver_attr_selftest,
#endif
};
/*----------------------------------------------------------------------------*/
static int lsm6ds3a_create_attr(struct device_driver *driver) 
{
	int idx, err = 0;
	int num = (int)(sizeof(LSM6DS3A_attr_list)/sizeof(LSM6DS3A_attr_list[0]));
	if (driver == NULL)
	{
		return -EINVAL;
	}

	for(idx = 0; idx < num; idx++)
	{
		if(0 != (err = driver_create_file(driver,  LSM6DS3A_attr_list[idx])))
		{            
			GSE_ERR("driver_create_file (%s) = %d\n",  LSM6DS3A_attr_list[idx]->attr.name, err);
			break;
		}
	}    
	return err;
}
/*----------------------------------------------------------------------------*/
static int lsm6ds3a_delete_attr(struct device_driver *driver)
{
	int idx ,err = 0;
	int num = (int)(sizeof( LSM6DS3A_attr_list)/sizeof( LSM6DS3A_attr_list[0]));

	if(driver == NULL)
	{
		return -EINVAL;
	}	

	for(idx = 0; idx < num; idx++)
	{
		driver_remove_file(driver,  LSM6DS3A_attr_list[idx]);
	}
	return err;
}
static int LSM6DS3A_Set_RegInc(struct i2c_client *client, bool inc)
{
	u8 databuf[2] = {0};    
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL3_C, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL3_XL err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  LSM6DS3A_CTRL3_C register: 0x%x\n", databuf[0]);
	}
	if(inc)
	{
		databuf[0] |= LSM6DS3A_CTRL3_C_IFINC;
		databuf[1] = databuf[0];
		databuf[0] = LSM6DS3A_CTRL3_C; 
		res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
		if(res < 0)
		{
			GSE_ERR("write full scale register err!\n");
			return LSM6DS3A_ERR_I2C;
		}
	}
	return LSM6DS3A_SUCCESS;    
}
/* software reset, executed when internal osc is turned on  -- add by liaoxl.lenovo 8.27.2005 start */
static int LSM6DS3A_Soft_Reset(struct i2c_client *client)
{
	u8 databuf[2] = {0};    
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_CTRL3_C, 1, databuf))
	{
		GSE_ERR("read LSM6DS3A_CTRL3_XL err!\n");
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  LSM6DS3A_CTRL3_C register: 0x%x\n", databuf[0]);
	}

	databuf[0] |= 0x01; /* software reset */
	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_CTRL3_C; 
	res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(res < 0)
	{
		GSE_ERR("write soft reset register err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	return LSM6DS3A_SUCCESS;    
}
/* software reset, executed when internal osc is turned on  -- add by liaoxl.lenovo 8.27.2005 end */
static int LSM6DS3A_init_client(struct i2c_client *client, int enable)
{
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);
	int res = 0;	
	GSE_LOG(" lsm6ds3a addr %x!\n",client->addr);
	/* do reset to ensure hardware inital state -- add by liaoxl.lenovo 8.27.2005 start */
	res = LSM6DS3A_acc_SetPowerMode(client, 1);
	if(res != LSM6DS3A_SUCCESS)
	{
		return res;
	}
	res = LSM6DS3A_Soft_Reset(client);
	if(res != LSM6DS3A_SUCCESS)
	{
		return res;
	}
	msleep(30);
	/* do reset to ensure hardware inital state -- add by liaoxl.lenovo 8.27.2005 end */

	res = LSM6DS3A_CheckDeviceID(client);
	if(res != LSM6DS3A_SUCCESS)
	{
		return res;
	}

	res = LSM6DS3A_Set_RegInc(client, true);
	if(res != LSM6DS3A_SUCCESS)
	{
		return res;
	}

	res = LSM6DS3A_acc_SetFullScale(client,LSM6DS3A_ACC_RANGE_2g);//we have only this choice
	if(res != LSM6DS3A_SUCCESS) 
	{
		return res;
	}

	//res = LSM6DS3A_acc_SetSampleRate(client, LSM6DS3A_ACC_ODR_104HZ);
	res = LSM6DS3A_acc_SetSampleRate(client, obj->sample_rate);
	if(res != LSM6DS3A_SUCCESS ) 
	{
		return res;
	}

	res = LSM6DS3A_acc_SetPowerMode(client, enable);
	if(res != LSM6DS3A_SUCCESS)
	{
		return res;
	}

	GSE_LOG("LSM6DS3A_init_client OK!\n");
	//acc setting

	return LSM6DS3A_SUCCESS;
}

/****************************************************************************** 
 * Function Configuration
 ******************************************************************************/
static int lsm6ds3a_open(struct inode *inode, struct file *file)
{
	file->private_data = lsm6ds3a_i2c_client;

	if(file->private_data == NULL)
	{
		GSE_ERR("null pointer!!\n");
		return -EINVAL;
	}
	return nonseekable_open(inode, file);
}
/*----------------------------------------------------------------------------*/
static int lsm6ds3a_release(struct inode *inode, struct file *file)
{
	file->private_data = NULL;
	return 0;
}
/*----------------------------------------------------------------------------*/
static long lsm6ds3a_acc_unlocked_ioctl(struct file *file, unsigned int cmd, unsigned long arg)
{
	struct i2c_client *client = (struct i2c_client*)file->private_data;
	struct lsm6ds3a_i2c_data *obj = (struct lsm6ds3a_i2c_data*)i2c_get_clientdata(client);	
	char strbuf[LSM6DS3A_BUFSIZE];
	void __user *data;
	SENSOR_DATA sensor_data;
	int err = 0;
	int cali[3];

	if(_IOC_DIR(cmd) & _IOC_READ)
	{
		err = !access_ok(VERIFY_WRITE, (void __user *)arg, _IOC_SIZE(cmd));
	}
	else if(_IOC_DIR(cmd) & _IOC_WRITE)
	{
		err = !access_ok(VERIFY_READ, (void __user *)arg, _IOC_SIZE(cmd));
	}

	if(err)
	{
		GSE_ERR("access error: %08X, (%2d, %2d)\n", cmd, _IOC_DIR(cmd), _IOC_SIZE(cmd));
		return -EFAULT;
	}

	switch(cmd)
	{
		case GSENSOR_IOCTL_INIT:			
			break;

		case GSENSOR_IOCTL_READ_CHIPINFO:
			data = (void __user *) arg;
			if(data == NULL)
			{
				err = -EINVAL;
				break;	  
			}

			LSM6DS3A_ReadChipInfo(client, strbuf, LSM6DS3A_BUFSIZE);

			if(copy_to_user(data, strbuf, strlen(strbuf)+1))
			{
				err = -EFAULT;
				break;
			}				 
			break;	  

		case GSENSOR_IOCTL_READ_SENSORDATA:
			data = (void __user *) arg;
			if(data == NULL)
			{
				err = -EINVAL;
				break;	  
			}

			LSM6DS3A_ReadAccData(client, strbuf, LSM6DS3A_BUFSIZE);

			if(copy_to_user(data, strbuf, strlen(strbuf)+1))
			{
				err = -EFAULT;
				break;	  
			}				 
			break;

		case GSENSOR_IOCTL_READ_GAIN:
			data = (void __user *) arg;
			if(data == NULL)
			{
				err = -EINVAL;
				break;	  
			}			

			break;

		case GSENSOR_IOCTL_READ_OFFSET:
			data = (void __user *) arg;
			if(data == NULL)
			{
				err = -EINVAL;
				break;	  
			}

			break;

		case GSENSOR_IOCTL_READ_RAW_DATA:
			data = (void __user *) arg;
			if(data == NULL)
			{
				err = -EINVAL;
				break;	  
			}

			LSM6DS3A_ReadAccRawData(client, (s16 *)strbuf);
			if(copy_to_user(data, strbuf, strlen(strbuf)+1))
			{
				err = -EFAULT;
				break;	  
			}
			break;	  

		case GSENSOR_IOCTL_SET_CALI:
			data = (void __user*)arg;
			if(data == NULL)
			{
				err = -EINVAL;
				break;	  
			}
			if(copy_from_user(&sensor_data, data, sizeof(sensor_data)))
			{
				err = -EFAULT;
				break;	  
			}
			if(atomic_read(&obj->suspend))
			{
				GSE_ERR("Perform calibration in suspend state!!\n");
				err = -EINVAL;
			}
			else
			{
				cali[LSM6DS3A_AXIS_X] = (s64)(sensor_data.x);
				cali[LSM6DS3A_AXIS_Y] = (s64)(sensor_data.y);	
				cali[LSM6DS3A_AXIS_Z] = (s64)(sensor_data.z);	
				err = LSM6DS3A_acc_WriteCalibration(client, cali);			 
			}
			break;

		case GSENSOR_IOCTL_CLR_CALI:
			err = LSM6DS3A_acc_ResetCalibration(client);
			break;

		case GSENSOR_IOCTL_GET_CALI:
			data = (void __user*)arg;
			if(data == NULL)
			{
				err = -EINVAL;
				break;	  
			}
			err = LSM6DS3A_acc_ReadCalibration(client, cali);
			if(err < 0)
			{
				break;
			}
			sensor_data.x = (s64)(cali[LSM6DS3A_AXIS_X]);
			sensor_data.y = (s64)(cali[LSM6DS3A_AXIS_Y]);
			sensor_data.z = (s64)(cali[LSM6DS3A_AXIS_Z]);
			if(copy_to_user(data, &sensor_data, sizeof(sensor_data)))
			{
				err = -EFAULT;
				break;
			}		
			break;

		default:
			GSE_ERR("unknown IOCTL: 0x%08x\n", cmd);
			err = -ENOIOCTLCMD;
			break;

	}
	return err;
}
#ifdef CONFIG_COMPAT
static long lsm6ds3a_acc_compat_ioctl(struct file *file, unsigned int cmd,
		unsigned long arg)
{
	long err = 0;

	void __user *arg32 = compat_ptr(arg);

	if (!file->f_op || !file->f_op->unlocked_ioctl)
		return -ENOTTY;

	switch (cmd)
	{
		case COMPAT_GSENSOR_IOCTL_READ_SENSORDATA:
			if (arg32 == NULL)
			{
				err = -EINVAL;
				break;    
			}

			err = file->f_op->unlocked_ioctl(file, GSENSOR_IOCTL_READ_SENSORDATA, (unsigned long)arg32);
			if (err){
				GSE_ERR("GSENSOR_IOCTL_READ_SENSORDATA unlocked_ioctl failed.");
				return err;
			}
			break;

		case COMPAT_GSENSOR_IOCTL_SET_CALI:
			if (arg32 == NULL)
			{
				err = -EINVAL;
				break;    
			}

			err = file->f_op->unlocked_ioctl(file, GSENSOR_IOCTL_SET_CALI, (unsigned long)arg32);
			if (err){
				GSE_ERR("GSENSOR_IOCTL_SET_CALI unlocked_ioctl failed.");
				return err;
			}
			break;

		case COMPAT_GSENSOR_IOCTL_GET_CALI:
			if (arg32 == NULL)
			{
				err = -EINVAL;
				break;    
			}

			err = file->f_op->unlocked_ioctl(file, GSENSOR_IOCTL_GET_CALI, (unsigned long)arg32);
			if (err){
				GSE_ERR("GSENSOR_IOCTL_GET_CALI unlocked_ioctl failed.");
				return err;
			}
			break;

		case COMPAT_GSENSOR_IOCTL_CLR_CALI:
			if (arg32 == NULL)
			{
				err = -EINVAL;
				break;    
			}

			err = file->f_op->unlocked_ioctl(file, GSENSOR_IOCTL_CLR_CALI, (unsigned long)arg32);
			if (err){
				GSE_ERR("GSENSOR_IOCTL_CLR_CALI unlocked_ioctl failed.");
				return err;
			}
			break;

		default:
			GSE_ERR("unknown IOCTL: 0x%08x\n", cmd);
			err = -ENOIOCTLCMD;
			break;

	}

	return err;
}
#endif
#ifdef CONFIG_HAS_EARLYSUSPEND
/* lenovo-sw liaoxl add for reduce power consume of lsm6ds3a  20150715 start */
static int lsm6ds3a_eint_pause(struct lsm6ds3a_i2c_data *obj)
{
	u8 databuf[2] = {0}; 
	int res = 0;

	/* step counter as non-wakup sensor, need to mask data report interrupt */
	if(pedo_enable_status)
	{
		/*disable INT2_STEP_DELTA bit*/
		if(lsm6ds3a_i2c_read(obj, LSM6DS3A_INT2_CTRL, 1, databuf))
		{
			GSE_ERR("%s read LSM6DS3A_INT2_CTRL register err!\n", __func__);
			return LSM6DS3A_ERR_I2C;
		}
		else
		{
			GSE_LOG("read  LSM6DS3A_INT2_CTRL register: 0x%x\n", databuf[0]);
		}
		databuf[0] &= ~0x80;//clear 
		databuf[1] = databuf[0];
		databuf[0] = LSM6DS3A_INT2_CTRL;
		res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
		if(res < 0)
		{
			GSE_ERR("write LSM6DS3A_INT2_CTRL register err!\n");
			return LSM6DS3A_ERR_I2C;
		}		
	}
	/* step detector is disable @ uplayer, no need to do mask here */
	/* signification motion is wakeup sensor, remain as before */
	/* tilt detector is wakeup sensor, remain as before */
	return res;
}
static int lsm6ds3a_eint_resume(struct lsm6ds3a_i2c_data *obj)
{
	u8 databuf[2] = {0}; 
	int res = 0;

	/* step counter as non-wakup sensor, need to unmask data report interrupt */
	if(pedo_enable_status)
	{
		/*disable INT2_STEP_DELTA bit*/
		if(lsm6ds3a_i2c_read(obj, LSM6DS3A_INT2_CTRL, 1, databuf))
		{
			GSE_ERR("%s read LSM6DS3A_INT2_CTRL register err!\n", __func__);
			return LSM6DS3A_ERR_I2C;
		}
		else
		{
			GSE_LOG("read  LSM6DS3A_INT2_CTRL register: 0x%x\n", databuf[0]);
		}
		databuf[0] |= 0x80;
		databuf[1] = databuf[0];
		databuf[0] = LSM6DS3A_INT2_CTRL;
		res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
		if(res < 0)
		{
			GSE_ERR("write LSM6DS3A_INT2_CTRL register err!\n");
			return LSM6DS3A_ERR_I2C;
		}		
	}
	/* step detector is disable @ uplayer, no need to do mask here */
	/* signification motion is wakeup sensor, remain as before */
	/* tilt detector is wakeup sensor, remain as before */
	return res;
}
/* lenovo-sw liaoxl add for reduce power consume of lsm6ds3a  20150715 end */
#endif
static const struct file_operations lsm6ds3a_acc_fops = {
	.owner = THIS_MODULE,
	.open = lsm6ds3a_open,
	.release = lsm6ds3a_release,
	.unlocked_ioctl = lsm6ds3a_acc_unlocked_ioctl,
#ifdef CONFIG_COMPAT
	.compat_ioctl = lsm6ds3a_acc_compat_ioctl,
#endif
};
/*----------------------------------------------------------------------------*/
static struct miscdevice lsm6ds3a_acc_device = {
	.minor = MISC_DYNAMIC_MINOR,
	.name = "gsensor",
	.fops = &lsm6ds3a_acc_fops,
};
/*----------------------------------------------------------------------------*/
#ifndef CONFIG_HAS_EARLYSUSPEND
/*----------------------------------------------------------------------------*/
static int lsm6ds3a_acc_suspend(struct i2c_client *client, pm_message_t msg) 
{
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);    
	int err = 0;
	GSE_FUN();    

	if(msg.event == PM_EVENT_SUSPEND)
	{   
		if(obj == NULL)
		{
			GSE_ERR("null pointer!!\n");
			return -EINVAL;
		}
		atomic_set(&obj->suspend, 1);

		if(pedo_enable_status  || tilt_enable_status || sigm_enable_status)
		{
			return 0;
		}
		err = LSM6DS3A_acc_SetPowerMode(obj->client, 0);
		if(err)
		{
			GSE_ERR("write power control fail!!\n");
			return err;
		}

		LSM6DS3A_power(obj->hw, 0);

	}
	return err;
}
/*----------------------------------------------------------------------------*/
static int lsm6ds3a_acc_resume(struct i2c_client *client)
{
	struct lsm6ds3a_i2c_data *obj = i2c_get_clientdata(client);        
	int err;
	GSE_FUN();

	if(obj == NULL)
	{
		GSE_ERR("null pointer!!\n");
		return -1;
	}

	if(pedo_enable_status  || tilt_enable_status || sigm_enable_status)
	{
		atomic_set(&obj->suspend, 0);
		return 0;
	}
	LSM6DS3A_power(obj->hw, 1);
	err = LSM6DS3A_acc_SetPowerMode(obj->client, atomic_read(&obj->gs_enable));
	if(err)
	{
		GSE_ERR("initialize client fail! err code %d!\n", err);
		return err ;        
	}
	atomic_set(&obj->suspend, 0);  

	return 0;
}
/*----------------------------------------------------------------------------*/
#else /*CONFIG_HAS_EARLY_SUSPEND is defined*/
/*----------------------------------------------------------------------------*/
static void lsm6ds3a_early_suspend(struct early_suspend *h) 
{
	struct lsm6ds3a_i2c_data *obj = container_of(h, struct lsm6ds3a_i2c_data, early_drv);   
	int err;

	GSE_LOG("lsm6ds3a_early_suspend entry!!!\n");
	if(obj == NULL)
	{
		GSE_ERR("null pointer!!\n");
		return;
	}
	if(pedo_enable_status  || tilt_enable_status || sigm_enable_status)
	{
		lsm6ds3a_eint_pause(obj);
		return;
	}
	if(atomic_read(&obj->gs_enable))
	{
		err = LSM6DS3A_acc_SetPowerMode(obj->client, 0);
		if(err < 0)
		{
			GSE_ERR("write power control fail!!\n");
			return;
		}
		atomic_set(&obj->suspend, 1); 
	}
	else
	{
		atomic_set(&obj->suspend, 0); 
	}
	LSM6DS3A_power(obj->hw, 0);
	GSE_LOG("bma25x_early_suspend fineshed!!!\n");
}
/*----------------------------------------------------------------------------*/
static void lsm6ds3a_late_resume(struct early_suspend *h)
{
	struct lsm6ds3a_i2c_data *obj = container_of(h, struct lsm6ds3a_i2c_data, early_drv);         
	int err;

	GSE_LOG("lsm6ds3a_late_resume entry suspend state=%d!!!\n", atomic_read(&obj->gs_enable));
	if(obj == NULL)
	{
		GSE_ERR("null pointer!!\n");
		return;
	}
	if(pedo_enable_status  || tilt_enable_status || sigm_enable_status)
	{
		lsm6ds3a_eint_resume(obj);
		return;
	}
	LSM6DS3A_power(obj->hw, 1);
	if(1 == atomic_read(&obj->suspend))
	{
		err =LSM6DS3A_acc_SetPowerMode(obj->client, 1);
		if(err < 0)
		{
			GSE_ERR("initialize client fail!!\n");
		}
	} 
	GSE_LOG("lsm6ds3a_late_resume fineshed!!!\n");
}
#endif /*CONFIG_HAS_EARLYSUSPEND*/
/* fifo operations  */
#ifdef LSM6DS3A_FIFO_SUPPORT
static DEFINE_MUTEX(lsm6ds3a_fifo_mutex);
static inline s64 lsm6ds3a_get_time_ns(void)
{
	struct timespec ts;
	/*
	 * calls getnstimeofday.
	 * If hrtimers then up to ns accurate, if not microsecond.
	 */
	ktime_get_real_ts(&ts);

	return timespec_to_ns(&ts);
}

static void lsm6ds3a_push_data_with_timestamp(struct lsm6ds3a_sensor_data *sdata,
		u16 offset, s64 timestamp)
{
	u8 *fifo_data_buffer;
	s32 data[3];

	if(obj_i2c_data == NULL)
	{
		return;
	}
	fifo_data_buffer = obj_i2c_data->fifo_data_buffer;
	data[0] = (s32)((s16)(fifo_data_buffer[offset + 0] |(fifo_data_buffer[offset + 1] << 8)));
	data[1] = (s32)((s16)(fifo_data_buffer[offset + 2] |(fifo_data_buffer[offset + 3] << 8)));
	data[2] = (s32)((s16)(fifo_data_buffer[offset + 4] |(fifo_data_buffer[offset + 5] << 8)));
	data[0] *= sdata->c_gain;
	data[1] *= sdata->c_gain;
	data[2] *= sdata->c_gain;
}

static void lsm6ds3a_report_single_event(struct lsm6ds3a_sensor_data *sdata, s32 data, s64 timestamp)
{

}

static void lsm6ds3a_parse_fifo_data(struct lsm6ds3a_i2c_data *cdata, u16 read_len)
{
	u16 fifo_offset = 0, steps_c = 0;
	u8 gyro_sip, accel_sip, step_c_sip;

	while (fifo_offset < read_len) {
		gyro_sip = cdata->sensors[LSM6DS3A_GYRO_IDX].sample_in_pattern;
		accel_sip = cdata->sensors[LSM6DS3A_ACCEL_IDX].sample_in_pattern;
		step_c_sip = cdata->sensors[LSM6DS3A_STEP_COUNTER_IDX].sample_in_pattern;

		do {
			if (gyro_sip > 0) 
			{
				if (cdata->sensors[LSM6DS3A_GYRO_IDX].sample_to_discard > 0)
				{
					cdata->sensors[LSM6DS3A_GYRO_IDX].sample_to_discard--;
				}
				else
				{
					lsm6ds3a_push_data_with_timestamp(&cdata->sensors[LSM6DS3A_GYRO_IDX],fifo_offset,cdata->sensors[LSM6DS3A_GYRO_IDX].timestamp);
				}
				cdata->sensors[LSM6DS3A_GYRO_IDX].timestamp += cdata->sensors[LSM6DS3A_GYRO_IDX].deltatime;
				fifo_offset += LSM6DS3A_FIFO_ELEMENT_LEN_BYTE;
				gyro_sip--;
			}

			if (accel_sip > 0) {
				if (cdata->sensors[LSM6DS3A_ACCEL_IDX].sample_to_discard > 0)
				{
					cdata->sensors[LSM6DS3A_ACCEL_IDX].sample_to_discard--;
				}
				else
				{
					lsm6ds3a_push_data_with_timestamp(&cdata->sensors[LSM6DS3A_ACCEL_IDX], fifo_offset, cdata->sensors[LSM6DS3A_ACCEL_IDX].timestamp);
				}
				cdata->sensors[LSM6DS3A_ACCEL_IDX].timestamp += cdata->sensors[LSM6DS3A_ACCEL_IDX].deltatime;
				fifo_offset += LSM6DS3A_FIFO_ELEMENT_LEN_BYTE;
				accel_sip--;
			}

			if (step_c_sip > 0) {
				steps_c = cdata->fifo_data_buffer[fifo_offset + 4] |(cdata->fifo_data_buffer[fifo_offset + 5] << 8);
				if (cdata->steps_c != steps_c)
				{
					lsm6ds3a_report_single_event(&cdata->sensors[LSM6DS3A_STEP_COUNTER_IDX], steps_c, cdata->sensors[LSM6DS3A_STEP_COUNTER_IDX].timestamp);
					cdata->steps_c = steps_c;
				}
				cdata->sensors[LSM6DS3A_STEP_COUNTER_IDX].timestamp += cdata->sensors[LSM6DS3A_STEP_COUNTER_IDX].deltatime;
				fifo_offset += LSM6DS3A_FIFO_ELEMENT_LEN_BYTE;
				step_c_sip--;
			}
		} while ((accel_sip > 0) || (gyro_sip > 0) || (step_c_sip > 0));
	}
	return;
}

void lsm6ds3a_read_fifo(struct lsm6ds3a_i2c_data *cdata)
{
	int err;
	u16 read_len = cdata->fifo_threshold * 2;

	if (!cdata->fifo_data_buffer)
		return;

	err = lsm6ds3a_i2c_read(cdata, LSM6DS3A_FIFO_DIFF_L, 2, (u8 *)&read_len);
	if (err < 0)
	{
		GSE_ERR("read LSM6DS3A_FIFO_DIFF_L err=%d\n", err);
		return;
	}

	if (read_len & LSM6DS3A_FIFO_DATA_OVR_2REGS) {
		GSE_ERR("data fifo overrun, failed to read it.\n");

		return;
	}

	read_len &= LSM6DS3A_FIFO_DIFF_MASK;
	read_len *= LSM6DS3A_FIFO_BYTE_FOR_CHANNEL;
	GSE_LOG("get length=%d of data in FIFO vs thd=%d\n", read_len, (cdata->fifo_threshold * 2));

	if (read_len > (cdata->fifo_threshold * 2))
		read_len = cdata->fifo_threshold;

	if (read_len == 0)
		return;

	err = lsm6ds3a_i2c_read(cdata, LSM6DS3A_FIFO_DATA_OUT_L, read_len, cdata->fifo_data_buffer);
	if (err < 0)
	{
		GSE_ERR("read LSM6DS3A_FIFO_DATA_OUT_L err=%d\n", err);
		return;
	}

	u8 *p = cdata->fifo_data_buffer;
	u16 size = read_len;

	while(read_len > 0)
	{
		if(read_len > 6)
		{
			GSE_LOG(" dma read idx[%d] data=%*ph\n", (size - read_len), 6, p);
			read_len -= 6;
			p += 6;
		}
		else
		{
			GSE_LOG(" dma read idx[%d] data=%*ph\n", (size - read_len), read_len, p);
			read_len = 0;
		}
	}
}

static int lsm6ds3a_set_fifo_enable(struct lsm6ds3a_i2c_data *cdata, bool status)
{
	int err;
	u8 reg_value;

	if (status)
		reg_value = LSM6DS3A_FIFO_ODR_MAX;
	else
		reg_value = LSM6DS3A_FIFO_ODR_OFF;

	err = lsm6ds3a_write_data_with_mask(cdata,
			LSM6DS3A_FIFO_ODR_ADDR,
			LSM6DS3A_FIFO_ODR_MASK,
			reg_value);
	if (err < 0)
		return err;

	cdata->sensors[LSM6DS3A_ACCEL_IDX].timestamp = lsm6ds3a_get_time_ns();
	cdata->sensors[LSM6DS3A_GYRO_IDX].timestamp = cdata->sensors[LSM6DS3A_ACCEL_IDX].timestamp;
	cdata->sensors[LSM6DS3A_STEP_COUNTER_IDX].timestamp = cdata->sensors[LSM6DS3A_ACCEL_IDX].timestamp;
	return 0;
}

int lsm6ds3a_set_fifo_mode(struct lsm6ds3a_i2c_data *cdata, enum fifo_mode fm)
{
	int err;
	u8 reg_value;
	bool enable_fifo;

	switch (fm) 
	{
		case BYPASS:
			reg_value = LSM6DS3A_FIFO_MODE_BYPASS;
			enable_fifo = false;
			break;
		case CONTINUOS:
			reg_value = LSM6DS3A_FIFO_MODE_CONTINUOS;
			enable_fifo = true;
			break;
		default:
			return -EINVAL;
	}

	err = lsm6ds3a_set_fifo_enable(cdata, enable_fifo);
	if (err < 0)
		return err;

	return lsm6ds3a_write_data_with_mask(cdata, LSM6DS3A_FIFO_MODE_ADDR, LSM6DS3A_FIFO_MODE_MASK, reg_value);
}

int lsm6ds3a_set_fifo_decimators_and_threshold(struct lsm6ds3a_i2c_data *cdata)
{
	int err;
	unsigned int min_odr = 416, max_odr = 0;
	u8 decimator = 0;
	struct lsm6ds3a_sensor_data *sdata_accel, *sdata_gyro, *sdata_step_c;
	u16 fifo_len = 0, fifo_threshold;
	u16 min_num_pattern, num_pattern;

	min_num_pattern = LSM6DS3A_MAX_FIFO_SIZE / LSM6DS3A_FIFO_ELEMENT_LEN_BYTE;
	sdata_accel = &cdata->sensors[LSM6DS3A_ACCEL_IDX];
	sdata_gyro = &cdata->sensors[LSM6DS3A_GYRO_IDX];
	sdata_step_c = &cdata->sensors[LSM6DS3A_STEP_COUNTER_IDX];
	sdata_accel->sample_in_pattern = 0;
	sdata_gyro->sample_in_pattern = 0;
	err = lsm6ds3a_write_data_with_mask(cdata,
			LSM6DS3A_FIFO_CTRL3_ADDR,
			LSM6DS3A_FIFO_ACCEL_DECIMATOR_MASK|LSM6DS3A_FIFO_GYRO_DECIMATOR_MASK,
			0);
	if (err < 0)
		return err;

	sdata_step_c->sample_in_pattern = 1;  // set 1 for test
	decimator = 0x01;
	err = lsm6ds3a_write_data_with_mask(cdata,
			LSM6DS3A_FIFO_CTRL4_ADDR,
			LSM6DS3A_FIFO_STEP_C_DECIMATOR_MASK,
			decimator);
	if (err < 0)
		return err;

	fifo_len = 8 * LSM6DS3A_FIFO_ELEMENT_LEN_BYTE; // set 8 for test

	if (fifo_len > 0) {
		fifo_threshold = fifo_len;
		err = lsm6ds3a_i2c_write(cdata,LSM6DS3A_FIFO_THR_L_ADDR , 1, (u8 *)&fifo_threshold);
		if (err < 0)
			return err;

		err = lsm6ds3a_write_data_with_mask(cdata,
				LSM6DS3A_FIFO_THR_H_ADDR,
				LSM6DS3A_FIFO_THR_H_MASK,
				*(((u8 *)&fifo_threshold) + 1));
		if (err < 0)
			return err;

		cdata->fifo_threshold = fifo_len;
	}
	if (cdata->fifo_data_buffer) {
		kfree(cdata->fifo_data_buffer);
		cdata->fifo_data_buffer = 0;
	}

	if (fifo_len > 0) {
		cdata->fifo_data_buffer = kzalloc((cdata->fifo_threshold * 2), GFP_KERNEL);
		if (!cdata->fifo_data_buffer)
			return -ENOMEM;
	}

	return fifo_len;
}

int lsm6ds3a_reconfigure_fifo(struct lsm6ds3a_i2c_data *cdata)
{
	int err, fifo_len;

	mutex_lock(&lsm6ds3a_fifo_mutex);
	lsm6ds3a_read_fifo(cdata);
	err = lsm6ds3a_set_fifo_mode(cdata, BYPASS);
	if (err < 0)
		goto reconfigure_fifo_irq_restore;

	fifo_len = lsm6ds3a_set_fifo_decimators_and_threshold(cdata);
	if (fifo_len < 0) {
		err = fifo_len;
		goto reconfigure_fifo_irq_restore;
	}

	if (fifo_len > 0) {
		err = lsm6ds3a_set_fifo_mode(cdata, CONTINUOS);
		if (err < 0)
			goto reconfigure_fifo_irq_restore;
	}

reconfigure_fifo_irq_restore:
	//	mutex_unlock(&cdata->fifo_lock);
	mutex_unlock(&lsm6ds3a_fifo_mutex);
	return err;
}


static ssize_t get_fifo_length(struct device *dev,
		struct device_attribute *attr, char *buf)
{
	struct lsm6ds3a_sensor_data *sdata = dev_get_drvdata(dev);

	return sprintf(buf, "%u\n", sdata->fifo_length);
}

static ssize_t set_fifo_length(struct device *dev,
		struct device_attribute *attr, const char *buf,
		size_t count)
{
	int err;
	unsigned int fifo_length;
	struct lsm6ds3a_sensor_data *sdata = dev_get_drvdata(dev);

	err = kstrtoint(buf, 10, &fifo_length);
	if (err < 0)
		return err;
	sdata->fifo_length = fifo_length;
	lsm6ds3a_reconfigure_fifo(obj_i2c_data);
	return count;
}

static ssize_t get_hw_fifo_lenght(struct device *dev,
		struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", LSM6DS3A_MAX_FIFO_LENGHT);
}

static ssize_t flush_fifo(struct device *dev,
		struct device_attribute *attr, const char *buf,
		size_t size)
{
	mutex_lock(&lsm6ds3a_fifo_mutex);
	lsm6ds3a_read_fifo(obj_i2c_data);
	mutex_unlock(&lsm6ds3a_fifo_mutex);
	return size;
}
#endif
#if(defined(LSM6DS3A_TILT_FUNC) || defined(LSM6DS3A_SIGNIFICANT_MOTION) || defined(LSM6DS3A_STEP_COUNTER))
static void lsm6ds3a_eint_work(struct work_struct *work)
{
	u8 src_value = 0, src_fifo = 0;
	u8 src_wu_value =0;
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;

	if(obj == NULL)
	{
		GSE_ERR("obj_i2c_data is null pointer!!\n");
		goto lsm6ds3a_eint_work_exit;
	}	
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_FUNC_SRC, 1, &src_value))
	{
		GSE_ERR("%s read LSM6DS3A_FUNC_SRC register err!\n", __func__);
		goto lsm6ds3a_eint_work_exit;
	}
#ifdef LSM6DS3A_FIFO_SUPPORT
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_FIFO_STATUS2, 1, &src_fifo))
	{
		GSE_ERR("%s read LSM6DS3A_FIFO_STATUS2 register err!\n", __func__);
		goto lsm6ds3a_eint_work_exit;
	}
#endif
#ifdef LSM6DS3A_STEP_COUNTER
#ifdef LSM6DS3A_FIFO_SUPPORT
	if(LSM6DS3A_FIFO_DATA_AVL & src_fifo)
	{
		if(LSM6DS3A_FIFO_OVER_RUN & src_fifo)
		{
			/* fifo overrun, reset fifo? */
		}
		else if(LSM6DS3A_FIFO_FULL & src_fifo)
		{
			/* fifo full, readback & send to uplayer */
		}
		else
		{
			/* anything to do?? */
			mutex_lock(&lsm6ds3a_fifo_mutex);
			lsm6ds3a_read_fifo(obj);
			mutex_unlock(&lsm6ds3a_fifo_mutex);
		}
	}
#endif
	/* 16bit step count overflow, need to reset */
	if(LSM6DS3A_STEP_OVERFLOW & src_value)
	{
		int res;
		u16 steps = 0;

		res = LSM6DS3A_Get_Pedo_DataReg(obj->client, &steps);
		if(res == LSM6DS3A_SUCCESS)
		{
			if(obj->boot_deb == 1)
			{
				/* state debounce */
				obj->boot_deb = 0;
				GSE_ERR("%s overflow intr first boot time with steps=%d.\n", __func__, steps);
			}
			else if((steps == 0) || (steps == 65535))
			{
				res = LSM6DS3A_Reset_Pedo_Data(obj->client, LSM6DS3A_ACC_GYRO_PEDO_RST_STEP_ENABLED);
				if(res != LSM6DS3A_SUCCESS)
				{
					GSE_ERR(" LSM6DS3A_Reset_Pedo_Data failed!\n");
				}
				else
				{
					obj->overflow += 1;
					atomic_set(&obj->reset_sc, 1);
					GSE_LOG("%s overflow intr done steps=%d en=%d.\n", __func__, steps, pedo_enable_status);
				}
			}
		}
	}
	/* at least 1 step recognized in delta time, readback & send to uplayer */
	if(LSM6DS3A_STEP_COUNT_DELTA_IA & src_value)
	{
		if(0 == atomic_read(&obj->suspend))
		{
			step_notify(TYPE_STEP_COUNTER);
		}
		obj->boot_deb = 0;
	}
	if((stepd_enable_status == true) && (LSM6DS3A_STEP_DETECT_INT_STATUS & src_value))
	{
		//add the action when receive step detection interrupt
		step_notify(TYPE_STEP_DETECTOR);
	}
#endif

#ifdef LSM6DS3A_SIGNIFICANT_MOTION
	if(sigm_enable_status == true)
	{
		if(lsm6ds3a_i2c_read(obj, LSM6DS3A_WAKE_UP_SRC, 1, &src_wu_value))
		{
			GSE_ERR("%s read LSM6DS3A_CTRL10_C register err!\n", __func__);
			goto lsm6ds3a_eint_work_exit;
		}

		if((LSM6DS3A_SIGNICANT_MOTION_INT_WU_STATUS & src_wu_value)|(LSM6DS3A_SIGNICANT_MOTION_INT_STATUS & src_value))
		{
			//add the action when receive the significant motion
			step_notify(TYPE_SIGNIFICANT);
		}
	}
#endif

#ifdef LSM6DS3A_TILT_FUNC
	if(LSM6DS3A_TILT_INT_STATUS & src_value)
	{
		//add the action when receive the tilt interrupt
		tilt_notify();
	}
#endif

lsm6ds3a_eint_work_exit:
	if(0 != atomic_read(&obj->int1_request_num))
	{
		mt_eint_unmask(CUST_EINT_LSM6DS3A_NUM);
	}
#ifdef LSM6DS3A_FIFO_SUPPORT
	if(0 != atomic_read(&obj->int2_request_num))
	{
		mt_eint_unmask(CUST_EINT2_LSM6DS3A_NUM);
	}
#endif
}
#endif
/*----------------------------------------------------------------------------*/
#if(defined(LSM6DS3A_TILT_FUNC) || defined(LSM6DS3A_SIGNIFICANT_MOTION) || defined(LSM6DS3A_STEP_COUNTER))
static void lsm6ds3a_eint_func(void)
{
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	if(!obj)
	{
		return;
	}	
	schedule_work(&obj->eint_work);
}

static void lsm6ds3a_eint2_func(void)
{
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	if(!obj)
	{
		return;
	}	
	schedule_work(&obj->eint_work);
}

static int lsm6ds3a_setup_eint(void)
{
#ifdef CUST_EINT_LSM6DS3A_TYPE
	mt_set_gpio_dir(GPIO_LSM6DS3A_EINT_PIN, GPIO_DIR_IN);
	mt_set_gpio_mode(GPIO_LSM6DS3A_EINT_PIN, GPIO_LSM6DS3A_EINT_PIN_M_EINT);
	mt_set_gpio_pull_enable(GPIO_LSM6DS3A_EINT_PIN, true);
	mt_set_gpio_pull_select(GPIO_LSM6DS3A_EINT_PIN, GPIO_PULL_UP);
	mt_eint_set_hw_debounce(CUST_EINT_LSM6DS3A_NUM, CUST_EINT_LSM6DS3A_DEBOUNCE_CN);
	mt_eint_registration(CUST_EINT_LSM6DS3A_NUM, CUST_EINT_LSM6DS3A_TYPE, lsm6ds3a_eint_func, 0);
	mt_eint_mask(CUST_EINT_LSM6DS3A_NUM);

	mt_set_gpio_dir(GPIO_LSM6DS3A_EINT2_PIN, GPIO_DIR_IN);
	mt_set_gpio_mode(GPIO_LSM6DS3A_EINT2_PIN, GPIO_LSM6DS3A_EINT2_PIN_M_EINT);
	mt_set_gpio_pull_enable(GPIO_LSM6DS3A_EINT2_PIN, true);
	mt_set_gpio_pull_select(GPIO_LSM6DS3A_EINT2_PIN, GPIO_PULL_UP);
	mt_eint_set_hw_debounce(CUST_EINT2_LSM6DS3A_NUM, CUST_EINT2_LSM6DS3A_DEBOUNCE_CN);
	mt_eint_registration(CUST_EINT2_LSM6DS3A_NUM, CUST_EINT2_LSM6DS3A_TYPE, lsm6ds3a_eint2_func, 0);
	mt_eint_mask(CUST_EINT2_LSM6DS3A_NUM);

#endif
	return 0;
}
#endif
/*----------------------------------------------------------------------------*/
static int lsm6ds3a_i2c_probe(struct i2c_client *client, const struct i2c_device_id *id)
{
	struct i2c_client *new_client;
	struct lsm6ds3a_i2c_data *obj;
	int err = 0;
	GSE_FUN();
	if(!(obj = kzalloc(sizeof(*obj), GFP_KERNEL)))
	{
		err = -ENOMEM;
		goto exit;
	}
	memset(obj, 0, sizeof(struct lsm6ds3a_i2c_data));
#if(defined(LSM6DS3A_TILT_FUNC) || defined(LSM6DS3A_SIGNIFICANT_MOTION) || defined(LSM6DS3A_STEP_COUNTER))
	INIT_WORK(&obj->eint_work, lsm6ds3a_eint_work);
#endif
	obj->hw = get_cust_acc_hw(); 
	obj->sample_rate = LSM6DS3A_ACC_ODR_104HZ;
	atomic_set(&obj->layout, obj->hw->direction);
	err = hwmsen_get_convert(obj->hw->direction, &obj->cvt);
	if(err)
	{
		GSE_ERR("invalid direction: %d\n", obj->hw->direction);
		goto exit_kfree;
	}
	obj_i2c_data = obj;
	obj->client = client;
	new_client = obj->client;
	i2c_set_clientdata(new_client,obj);
	atomic_set(&obj->suspend, 0);
	atomic_set(&obj->gs_enable, 0);
	/* init step counter intterupt vars  --add by liaoxl.lenovo 7.28.2015 start */
	obj->boot_deb = 2;
	obj->overflow = 0;
	obj->steps_c = 0;
	obj->step_c_delay = 3;
	obj->bounce_steps = 0;
	obj->bounce_count = 0;
	obj->last_bounce_step = 0;
	atomic_set(&obj->reset_sc, 0);
	atomic_set(&obj->int1_request_num, 0);
	atomic_set(&obj->int2_request_num, 0);
	/* init step counter intterupt vars  --add by liaoxl.lenovo 7.28.2015  end */
	/* for DMA transfer */
	gpDMABuf_va = (u8 *) dma_alloc_coherent(&client->dev, IIC_DMA_MAX_TRANSFER_SIZE, &gpDMABuf_pa, GFP_KERNEL);
	if (!gpDMABuf_va)
	{
		GSE_ERR("Allocate DMA I2C Buffer failed!");
		return -1;
	}
	memset(gpDMABuf_va, 0, IIC_DMA_MAX_TRANSFER_SIZE);
	lsm6ds3a_i2c_client = new_client;	
	err = LSM6DS3A_init_client(new_client, 0);
	if(err)
	{
		goto exit_init_failed;
	}
	err = misc_register(&lsm6ds3a_acc_device);
	if(err)
	{
		GSE_ERR("lsm6ds3a_gyro_device misc register failed!\n");
		goto exit_misc_device_register_failed;
	}
	if(err)
	{
		GSE_ERR("lsm6ds3a create attribute err = %d\n", err);
		goto exit_create_attr_failed;
	}	
#ifdef CONFIG_HAS_EARLYSUSPEND
	obj->early_drv.level    = EARLY_SUSPEND_LEVEL_DISABLE_FB - 1,
		obj->early_drv.suspend  = lsm6ds3a_early_suspend,
		obj->early_drv.resume   = lsm6ds3a_late_resume,    
		register_early_suspend(&obj->early_drv);
#endif 
	lsm6ds3a_acc_init_flag = 0;
#if(defined(LSM6DS3A_TILT_FUNC) || defined(LSM6DS3A_SIGNIFICANT_MOTION) || defined(LSM6DS3A_STEP_COUNTER))
	lsm6ds3a_setup_eint();
#endif
	GSE_LOG("%s: OK\n", __func__);    
	return 0;

exit_create_attr_failed:
	misc_deregister(&lsm6ds3a_acc_device);
exit_misc_device_register_failed:
exit_init_failed:
	/* for DMA transfer */
	if(gpDMABuf_va)
	{
		dma_free_coherent(&client->dev, IIC_DMA_MAX_TRANSFER_SIZE, gpDMABuf_va, gpDMABuf_pa);
		gpDMABuf_va = NULL;
		gpDMABuf_pa = 0;
	}
exit_kfree:
	kfree(obj);
exit:
	lsm6ds3a_acc_init_flag = -1;
	GSE_ERR("%s: err = %d\n", __func__, err);        
	return err;
}

/*----------------------------------------------------------------------------*/
static int lsm6ds3a_i2c_remove(struct i2c_client *client)
{
	int err = 0;	

	if(test_bit(CFG_LSM6DS3A_ACC, &lsm6ds3a_init_flag_test))
	{
		err = lsm6ds3a_delete_attr(&(lsm6ds3a_init_info.platform_diver_addr->driver));
	}
	lsm6ds3a_acc_init_flag = -1;
	if(err)
	{
		GSE_ERR("lsm6ds3a_i2c_remove fail: %d\n", err);
	}

	err = misc_deregister(&lsm6ds3a_acc_device);
	if(err)
	{
		GSE_ERR("misc_deregister lsm6ds3a_gyro_device fail: %d\n", err);
	}

	lsm6ds3a_i2c_client = NULL;
	i2c_unregister_device(client);
	kfree(i2c_get_clientdata(client));
	/* for DMA transfer */
	if(gpDMABuf_va)
	{
		dma_free_coherent(&client->dev, IIC_DMA_MAX_TRANSFER_SIZE, gpDMABuf_va, gpDMABuf_pa);
		gpDMABuf_va = NULL;
		gpDMABuf_pa = 0;
	}

	return 0;
}
static int lsm6ds3a_open_report_data(int open)
{
	//should queuq work to report event if  is_report_input_direct=true
	return 0;
}
// if use  this typ of enable , Gsensor only enabled but not report inputEvent to HAL
static int lsm6ds3a_enable_nodata(int en)
{
	int err = 0;
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;

	GSE_LOG("%s  suspend=%d old_enable=%d enable=%d\n",__FUNCTION__, atomic_read(&obj->suspend), atomic_read(&obj->gs_enable), en);
	if(obj == NULL)
	{
		GSE_ERR("obj_i2c_data is NULL!\n");
		return -1;
	}
#if 1
	if((1 != atomic_read(&obj->suspend)) && (en != atomic_read(&obj->gs_enable)))
	{
		err = LSM6DS3A_acc_SetPowerMode(obj->client, en);
		if(err != LSM6DS3A_SUCCESS)
		{
			GSE_ERR("gsensor_enable_nodata fail!\n");
		}
	}
#else
	int value = en;
	if(value == 1)
	{
		enable_status = true;
	}
	else
	{
		enable_status = false;
		obj->sample_rate = LSM6DS3A_ACC_ODR_104HZ; 
	}
	GSE_LOG("enable value=%d, atomic_read(&obj->gs_enable) =%d\n",value,atomic_read(&obj->gs_enable));
	if(((value == 0) && (atomic_read(&obj->gs_enable) == false)) ||((value == 1) && (atomic_read(&obj->gs_enable) == true)))
	{
		GSE_LOG("Gsensor device have updated!\n");
	}
	else if(!pedo_enable_status && !tilt_enable_status & !sigm_enable_status)
	{
		err = LSM6DS3A_acc_SetPowerMode( obj->client, enable_status);					
	}
#endif
	GSE_LOG("%s finished!!!\n",__FUNCTION__);
	return err;
}

static int lsm6ds3a_set_delay(u64 ns)
{
	int value =0;
	int err = 0;
	int sample_delay;
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;

	if(obj == NULL)
	{
		GSE_ERR("obj_i2c_data is NULL!\n");
		return -1;
	}

	value = (int)(ns/1000/1000);
	if(value <= 5)
	{
		sample_delay = LSM6DS3A_ACC_ODR_208HZ;
	}
	else if(value <= 10)
	{
		sample_delay = LSM6DS3A_ACC_ODR_104HZ;
	}
	else
	{
		sample_delay = LSM6DS3A_ACC_ODR_52HZ;
	}
	obj->sample_rate = sample_delay;
	err = LSM6DS3A_acc_SetSampleRate(obj->client, sample_delay);
	if(err != LSM6DS3A_SUCCESS ) 
	{
		GSE_ERR("Set delay parameter error!\n");
	}

	GSE_LOG("%s (%d), chip only use 1024HZ \n",__FUNCTION__, value);
	return 0;
}

static int lsm6ds3a_get_data(int* x ,int* y,int* z, int* status)
{
	char buff[LSM6DS3A_BUFSIZE];
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;

	if(obj == NULL)
	{
		GSE_ERR("obj_i2c_data is NULL!\n");
		return -1;
	}
	memset(buff, 0, sizeof(buff));
	LSM6DS3A_ReadAccData(obj->client, buff, LSM6DS3A_BUFSIZE);

	sscanf(buff, "%x %x %x", x, y, z);				
	*status = SENSOR_STATUS_ACCURACY_MEDIUM;				

	return 0;
}
#ifdef LSM6DS3A_TILT_FUNC
static int lsm6ds3a_tilt_open_report_data(int open)
{
	int res = 0;
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;

	if(1 == open)
	{
		tilt_enable_status = true;
		res = LSM6DS3A_enable_tilt(obj->client, true);
		if(LSM6DS3A_SUCCESS != res)
		{
			GSE_ERR("%s run LSM6DS3A_enable_tilt to true failed!\n", __func__);
		}
	}
	else if(0 == open)
	{
		tilt_enable_status = false;
		res = LSM6DS3A_enable_tilt(obj->client, false);
		if(LSM6DS3A_SUCCESS != res)
		{
			GSE_ERR("%s run LSM6DS3A_enable_tilt to false failed!\n", __func__);
		}
	}

	return res;
}
#endif

#ifdef LSM6DS3A_SIGNIFICANT_MOTION
static int lsm6ds3a_step_c_enable_significant(int en)
{
	int res =0;
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	GSE_FUN();

	if(1 == en)
	{
		sigm_enable_status = true;
		res = LSM6DS3A_Set_SigMotion_Threshold(obj->client, 0x08);
		if(LSM6DS3A_SUCCESS != res)
		{
			GSE_ERR("%s run LSM6DS3A_Set_SigMotion_Threshold to fail!\n", __func__);
		}
		res = LSM6DS3A_acc_SetSampleRate(obj->client, obj->sample_rate);
		if(LSM6DS3A_SUCCESS != res)
		{
			GSE_ERR("%s run LSM6DS3A_Set_SigMotion_Threshold to fail!\n", __func__);
		}
		res = LSM6DS3A_Enable_SigMotion_Func_On_Int(obj->client, true); //default route to INT2
		if(LSM6DS3A_SUCCESS != res)
		{
			GSE_ERR("%s run LSM6DS3A_Enable_SigMotion_Func_On_Int to fail!\n", __func__);
		}

		res = LSM6DS3A_acc_SetFullScale(obj->client, LSM6DS3A_ACC_RANGE_2g);
		if(LSM6DS3A_SUCCESS != res)
		{
			GSE_ERR("%s run LSM6DS3A_Enable_SigMotion_Func_On_Int to fail!\n", __func__);
		}
		GSE_LOG(" sigMotion enable with1 int1_count=%d\n", atomic_read(&obj->int1_request_num));
		if(0 == atomic_read(&obj->int1_request_num))
			mt_eint_unmask(CUST_EINT_LSM6DS3A_NUM);
		atomic_inc(&obj->int1_request_num);
		GSE_LOG(" sigMotion enable with2 int1_count=%d\n", atomic_read(&obj->int1_request_num));
	}
	else if(0 == en)
	{
		sigm_enable_status = false;
		res = LSM6DS3A_Enable_SigMotion_Func_On_Int(obj->client, false);
		if(LSM6DS3A_SUCCESS != res)
		{
			GSE_ERR("%s run LSM6DS3A_Enable_SigMotion_Func_On_Int to fail!\n", __func__);
		}
		/* do not turn off the func when other related func working, modified by liaoxl.lenovo 7.6.2015 */
		if(!atomic_read(&obj->gs_enable) && !tilt_enable_status && !pedo_enable_status)
		{
			res = LSM6DS3A_acc_SetPowerMode(obj->client, 0);
			if(LSM6DS3A_SUCCESS != res)
			{
				GSE_ERR("%s run LSM6DS3A_acc_SetPowerMode to fail!\n", __func__);
			}
		}
		GSE_LOG(" sigMotion disable with1 int1_count=%d\n", atomic_read(&obj->int1_request_num));
		atomic_dec(&obj->int1_request_num);
		if(0 >= atomic_read(&obj->int1_request_num))
		{
			atomic_set(&obj->int1_request_num, 0);
			cancel_work_sync(&obj->eint_work);
			mt_eint_mask(CUST_EINT_LSM6DS3A_NUM);
		}
		GSE_LOG(" sigMotion disable with2 int1_count=%d\n", atomic_read(&obj->int1_request_num));
	}

	return res;
}
#endif

#ifdef LSM6DS3A_STEP_COUNTER //step counter
static int lsm6ds3a_step_c_open_report_data(int open)
{

	return LSM6DS3A_SUCCESS;
}
static int lsm6ds3a_step_c_enable_nodata(int en)
{
	int res =0;
	int value = en;
	int err = 0;
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	GSE_FUN();

	if(obj == NULL)
	{
		GSE_ERR("%s obj_i2c_data is NULL!\n", __func__);
		return -1;
	}

	if(value == 1)
	{
		pedo_enable_status = true;
		res = LSM6DS3A_enable_pedo(obj->client, true);
		if(LSM6DS3A_SUCCESS != res)
		{
			GSE_LOG("LSM6DS3A_enable_pedo failed at open action!\n");
			return res;
		}

		step_notify(TYPE_STEP_COUNTER);/* for data init of step counter, add by liaoxl.lenovo 8.17.2015 */
	}
	else
	{
		pedo_enable_status = false;
		res = LSM6DS3A_enable_pedo(obj->client, false);
		if(LSM6DS3A_SUCCESS != res)
		{
			GSE_LOG("LSM6DS3A_enable_pedo failed at close action!\n");
			return res;
		}

	}

	GSE_LOG("lsm6ds3a_step_c_enable_nodata en=%d OK!\n", en);
	return err;
}
static int lsm6ds3a_step_c_enable_step_detect(int en)
{
	int ret = 0;
	u8 databuf[2] = {0}; 
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	GSE_FUN();

	/* enable INT1_STEP_DETECTOR */
	if(lsm6ds3a_i2c_read(obj, LSM6DS3A_INT1_CTRL, 1, databuf))
	{
		GSE_ERR("%s read LSM6DS3A_INT1_CTRL register err!\n", __func__);
		return LSM6DS3A_ERR_I2C;
	}
	else
	{
		GSE_LOG("read  LSM6DS3A_INT1_CTRL register: 0x%x\n", databuf[0]);
	}
	if(1 == en)
	{
		databuf[0] |= 0x80;			
	}
	else
	{
		databuf[0] &= ~0x80;//clear 
	}
	databuf[1] = databuf[0];
	databuf[0] = LSM6DS3A_INT1_CTRL; 	
	ret = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
	if(ret < 0)
	{
		GSE_ERR("write LSM6DS3A_INT1_CTRL register err!\n");
		return LSM6DS3A_ERR_I2C;
	}

	if(0 == en)
	{
		if(false == pedo_enable_status)
		{
			ret = LSM6DS3A_enable_pedo(obj->client, en);
		}
		else
		{
			/* step counter remind working */
		}
		atomic_dec(&obj->int1_request_num);
		if(0 >= atomic_read(&obj->int1_request_num))
		{
			atomic_set(&obj->int1_request_num, 0);
			cancel_work_sync(&obj->eint_work);
			mt_eint_mask(CUST_EINT_LSM6DS3A_NUM);
		}
		stepd_enable_status = false;  /* add for step detector sensor -- by liaoxl.lenovo 7.12.2015 */
		GSE_LOG(" disable detect with pedo=%d count=%d\n", pedo_enable_status, atomic_read(&obj->int1_request_num));
	}
	else if(1 == en)
	{
		if(false == pedo_enable_status)
		{
			ret = LSM6DS3A_enable_pedo(obj->client, en);
		}
		if(0 == atomic_read(&obj->int1_request_num))
			mt_eint_unmask(CUST_EINT_LSM6DS3A_NUM);
		atomic_inc(&obj->int1_request_num);
		stepd_enable_status = true;  /* add for step detector sensor -- by liaoxl.lenovo 7.12.2015 */
		GSE_LOG(" enable detect with pedo=%d count=%d\n", pedo_enable_status, atomic_read(&obj->int1_request_num));
	}

	return ret;
}

static int lsm6ds3a_step_c_set_delay(u64 delay)
{
	u8 databuf[2] = {0}, delta = 0;
	int res = 0, mre, mod;
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;

	mre = (int)delay / 1600;
	mod = (delay % 1600);
	if(mre > 200)
		delta = 200;
	else
		delta = (u8)mre;
	if(mod > 800)
		delta += 1;

	if(obj->step_c_delay != delta)
	{
		obj->step_c_delay = delta;
		GSE_LOG(" now lsm6ds3a_step_c_set_delay = %llums\n", delay);
		/* STEP_COUNT_DELTA value, 1LSB = 1.6384S */
		/* treat as batch timeout value */
		databuf[1] = 0x80;
		databuf[0] = LSM6DS3A_FUNC_CFG_ACCESS;
		res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
		if(res < 0)
		{
			GSE_ERR("%s turnon embedded func access err1!\n", __func__);
			return LSM6DS3A_ERR_I2C;
		}
		databuf[1] = delta;  // 3 steps for test
		databuf[0] = LSM6DS3A_STEP_COUNT_DELTA;
		res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
		if(res < 0)
		{
			GSE_ERR("%s write LSM6DS3A_STEP_COUNT_DELTA register err2!\n", __func__);
			return LSM6DS3A_ERR_I2C;
		}
		databuf[1] = 0x00;
		databuf[0] = LSM6DS3A_FUNC_CFG_ACCESS;
		res = lsm6ds3a_i2c_write(obj, databuf[0], 1, &databuf[1]);
		if(res < 0)
		{
			GSE_ERR("%s turnoff embedded func access err!\n", __func__);
			return LSM6DS3A_ERR_I2C;
		}
	}

	return 0;
}
static int lsm6ds3a_step_c_get_data(u64 *value, int *status)
{
	int err = 0;
	u16 pedo_data = 0;
	struct lsm6ds3a_i2c_data *obj = obj_i2c_data;
	int srst = atomic_read(&obj->reset_sc);

	err = LSM6DS3A_Get_Pedo_DataReg(obj->client, &pedo_data);
	if(LSM6DS3A_SUCCESS == err)
	{
		/* step counter overflow occus just now */
		if(0 != srst)
		{
			atomic_set(&obj->reset_sc, 0);
			obj->steps_c = pedo_data;
		}
		/* none reset operaton,do debounce check */
		else
		{
			/* lsm6ds data reg overflow result to this error? */
			if(pedo_data < obj->steps_c)
			{
				/* use old steps */
				if(0 == obj->bounce_count)
				{
					obj->bounce_count = 1;
					obj->last_bounce_step = pedo_data;
				}
				else
				{
					if(pedo_data > obj->last_bounce_step)
					{
						obj->bounce_count = 0;
						obj->bounce_steps += obj->steps_c;
						obj->steps_c = pedo_data;
					}
					else
					{
						obj->bounce_count = 0;
					}
				}
			}
			else
			{
				obj->steps_c = pedo_data;
			}
		}

		*value = obj->steps_c + obj->bounce_steps + ((obj->overflow) << 16);
		*status = SENSOR_STATUS_ACCURACY_MEDIUM;
	}

	return err;
}
static int lsm6ds3a_step_c_get_data_step_d(u64 *value, int *status)
{
	return 0;
}
static int lsm6ds3a_step_c_get_data_significant(u64 *value, int *status)
{
	return 0;
}
#endif

static int lsm6ds3a_local_init_common(void)
{
	struct acc_hw *accel_hw = get_cust_acc_hw();
	GSE_ERR("lsm6ds3a_local_init_common entry!!!\n");
	LSM6DS3A_power(accel_hw, 1);
	if(i2c_add_driver(&lsm6ds3a_i2c_driver))
	{
		GSE_ERR("add driver error\n");
		return -1;
	}
	GSE_ERR("lsm6ds3a_local_init_common finished!!!\n");
	return 0;
}
static int lsm6ds3a_local_init(void)
{
	int res = 0;
	struct acc_control_path ctl={0};
	struct acc_data_path data={0};
	struct lsm6ds3a_i2c_data *obj = NULL; 

	mutex_lock(&lsm6ds3a_init_mutex);
	set_bit(CFG_LSM6DS3A_ACC, &lsm6ds3a_init_flag_test);
	if((0==test_bit(CFG_LSM6DS3A_STEP_C, &lsm6ds3a_init_flag_test)) && (0 == test_bit(CFG_LSM6DS3A_TILT, &lsm6ds3a_init_flag_test)))
	{
		res = lsm6ds3a_local_init_common();
		if(res < 0)
		{
			goto lsm6ds3a_local_init_failed;
		}
	}
	if(lsm6ds3a_acc_init_flag == -1)
	{
		mutex_unlock(&lsm6ds3a_init_mutex);
		GSE_ERR("%s init failed!\n", __FUNCTION__);
		return -1;
	}
	else
	{
		obj = obj_i2c_data;
		if(NULL == obj)
		{
			GSE_ERR("i2c_data obj is null!!\n");
			goto lsm6ds3a_local_init_failed;
		}	
		res = lsm6ds3a_create_attr(&(lsm6ds3a_init_info.platform_diver_addr->driver));
		if(res < 0)
		{
			goto lsm6ds3a_local_init_failed;
		}

		ctl.open_report_data= lsm6ds3a_open_report_data;
		ctl.enable_nodata = lsm6ds3a_enable_nodata;
		ctl.set_delay  = lsm6ds3a_set_delay;
		ctl.is_report_input_direct = false;
		ctl.is_support_batch = obj->hw->is_batch_supported;
		res = acc_register_control_path(&ctl);
		if(res)
		{
			GSE_ERR("register acc control path err\n");
			goto lsm6ds3a_local_init_failed;
		}

		data.get_data = lsm6ds3a_get_data;
		data.vender_div = 1000;
		res = acc_register_data_path(&data);
		if(res)
		{
			GSE_ERR("register acc data path err= %d\n", res);
			goto lsm6ds3a_local_init_failed;
		}
	}
	mutex_unlock(&lsm6ds3a_init_mutex);
	return 0;
lsm6ds3a_local_init_failed:
	GSE_ERR("%s init failed\n", __FUNCTION__);
	mutex_unlock(&lsm6ds3a_init_mutex);
	return res;
}
static int lsm6ds3a_local_uninit(void)
{
	struct acc_hw *accel_hw = get_cust_acc_hw();

	clear_bit(CFG_LSM6DS3A_ACC, &lsm6ds3a_init_flag_test);
	LSM6DS3A_power(accel_hw, 0);  	
	i2c_del_driver(&lsm6ds3a_i2c_driver);
	return 0;
}
#ifdef LSM6DS3A_TILT_FUNC
static int lsm6ds3a_tilt_get_data(u16 *value, int *status)
{
	return 0;
}

static int lsm6ds3a_tilt_local_init(void)
{
	int res = 0;

	struct tilt_control_path tilt_ctl={0};
	struct tilt_data_path tilt_data={0};

	mutex_lock(&lsm6ds3a_init_mutex);
	set_bit(CFG_LSM6DS3A_TILT, &lsm6ds3a_init_flag_test);

	if((0==test_bit(CFG_LSM6DS3A_ACC, &lsm6ds3a_init_flag_test)) \
			&& (0==test_bit(CFG_LSM6DS3A_STEP_C, &lsm6ds3a_init_flag_test)))
	{
		res = lsm6ds3a_local_init_common();
		if(res < 0)
		{
			goto lsm6ds3a_tilt_local_init_failed;
		}
	}
	if(lsm6ds3a_acc_init_flag == -1)
	{
		mutex_unlock(&lsm6ds3a_init_mutex);
		GSE_ERR("%s init failed!\n", __FUNCTION__);
		return -1;
	}
	else
	{
		tilt_ctl.open_report_data= lsm6ds3a_tilt_open_report_data;	
		res = tilt_register_control_path(&tilt_ctl);

		tilt_data.get_data = lsm6ds3a_tilt_get_data;
		res = tilt_register_data_path(&tilt_data);
	}
	mutex_unlock(&lsm6ds3a_init_mutex);
	return 0;

lsm6ds3a_tilt_local_init_failed:
	mutex_unlock(&lsm6ds3a_init_mutex);
	GSE_ERR("%s init failed!\n", __FUNCTION__);
	return -1;
}

static int lsm6ds3a_tilt_local_uninit(void)
{
	clear_bit(CFG_LSM6DS3A_TILT, &lsm6ds3a_init_flag_test);
	return 0;
}
#endif

#ifdef LSM6DS3A_STEP_COUNTER
static int lsm6ds3a_step_c_local_init(void)
{
	int res = 0;

	struct step_c_control_path step_ctl={0};
	struct step_c_data_path step_data={0};	

	mutex_lock(&lsm6ds3a_init_mutex);

	set_bit(CFG_LSM6DS3A_STEP_C, &lsm6ds3a_init_flag_test);

	if((0==test_bit(CFG_LSM6DS3A_ACC, &lsm6ds3a_init_flag_test)) && (0 == test_bit(CFG_LSM6DS3A_TILT, &lsm6ds3a_init_flag_test)))
	{
		res = lsm6ds3a_local_init_common();
		if(res < 0)
		{
			goto lsm6ds3a_step_c_local_init_failed;
		}

	}
	if(lsm6ds3a_acc_init_flag == -1)
	{
		mutex_unlock(&lsm6ds3a_init_mutex);
		GSE_ERR("%s init failed!\n", __FUNCTION__);
		return -1;
	}
	else
	{
		step_ctl.open_report_data= lsm6ds3a_step_c_open_report_data;
		step_ctl.enable_nodata = lsm6ds3a_step_c_enable_nodata;
		step_ctl.enable_step_detect  = lsm6ds3a_step_c_enable_step_detect;
		step_ctl.set_delay = lsm6ds3a_step_c_set_delay;
		step_ctl.is_report_input_direct = false;
		step_ctl.is_support_batch = false;		
#ifdef LSM6DS3A_SIGNIFICANT_MOTION
		step_ctl.enable_significant = lsm6ds3a_step_c_enable_significant;
#endif
		res = step_c_register_control_path(&step_ctl);
		if(res)
		{
			GSE_ERR("register step counter control path err\n");
			goto lsm6ds3a_step_c_local_init_failed;
		}

		step_data.get_data = lsm6ds3a_step_c_get_data;
		step_data.get_data_step_d = lsm6ds3a_step_c_get_data_step_d;
		step_data.get_data_significant = lsm6ds3a_step_c_get_data_significant;
		step_data.vender_div = 1;
		res = step_c_register_data_path(&step_data);
		if(res)
		{
			GSE_ERR("register step counter data path err= %d\n", res);
			goto lsm6ds3a_step_c_local_init_failed;
		}
	}
	mutex_unlock(&lsm6ds3a_init_mutex);
	return 0;
lsm6ds3a_step_c_local_init_failed:
	mutex_unlock(&lsm6ds3a_init_mutex);
	GSE_ERR("%s init failed!\n", __FUNCTION__);
	return res;
}
static int lsm6ds3a_step_c_local_uninit(void)
{
	clear_bit(CFG_LSM6DS3A_STEP_C, &lsm6ds3a_init_flag_test);
	return 0;
}
#endif
/*----------------------------------------------------------------------------*/
static int __init lsm6ds3a_init(void)
{
	struct acc_hw *hw = get_cust_acc_hw();
	GSE_LOG("%s: i2c_number=%d\n", __func__,hw->i2c_num);
	i2c_register_board_info(hw->i2c_num, &i2c_lsm6ds3a, 1);
	acc_driver_add(&lsm6ds3a_init_info);	
#ifdef LSM6DS3A_STEP_COUNTER //step counter
	step_c_driver_add(&lsm6ds3a_step_c_init_info); //step counter
#endif
#ifdef LSM6DS3A_TILT_FUNC
	tilt_driver_add(&lsm6ds3a_tilt_init_info);
#endif
	return 0;    
}
/*----------------------------------------------------------------------------*/
static void __exit lsm6ds3a_exit(void)
{
	GSE_FUN();
}
/*----------------------------------------------------------------------------*/
module_init(lsm6ds3a_init);
module_exit(lsm6ds3a_exit);
/*----------------------------------------------------------------------------*/
MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("LSM6DS3A Accelerometer");
MODULE_AUTHOR("xj.wang@mediatek.com, darren.han@st.com");
