
#include "als_sub.h"
#include "aal_control.h"

struct als_sub_context *als_sub_context_obj = NULL;


static struct als_sub_init_info* als_sub_init_list[MAX_CHOOSE_ALS_SUB_NUM]= {0}; //modified
static void als_sub_early_suspend(struct early_suspend *h);
static void als_sub_late_resume(struct early_suspend *h);


int als_sub_data_report(struct input_dev *dev, int value, int status)
{
	struct als_sub_context *cxt = NULL;

	cxt  = als_sub_context_obj;
	//ALS_SUB_LOG("+als_data_report! %d, %d\n",value,status);
	//force trigger data update after sensor enable.
	if (cxt->is_get_valid_als_data_after_enable == false)
	{
		input_report_abs(dev, EVENT_TYPE_ALS_SUB_VALUE, value+1);
		cxt->is_get_valid_als_data_after_enable = true;
	}
	input_report_abs(dev, EVENT_TYPE_ALS_SUB_VALUE, value);
	input_report_abs(dev, EVENT_TYPE_ALS_SUB_STATUS, status);
	input_sync(dev);
	return 0;
}


static void als_sub_work_func(struct work_struct *work)
{

	struct als_sub_context *cxt = NULL;
	//int out_size;
	//hwm_sensor_data sensor_data;
	int value,status;
	int64_t  nt;
	struct timespec time; 
	int err;	

	cxt  = als_sub_context_obj;

	if(NULL == cxt->als_data.get_data)
	{
		ALS_SUB_ERR("als_sub driver not register data path\n");
		return;
	}


	time.tv_sec = time.tv_nsec = 0;    
	time = get_monotonic_coarse(); 
	nt = time.tv_sec*1000000000LL+time.tv_nsec;

	//add wake lock to make sure data can be read before system suspend
	err = cxt->als_data.get_data(&value,&status);

	if(err)
	{
		ALS_SUB_ERR("get als_sub data fails!!\n" );
		goto als_loop;
	}
	else
	{
		{	
			cxt->drv_data.als_data.values[0] = value;
			cxt->drv_data.als_data.status = status;
			cxt->drv_data.als_data.time = nt;

		}			
	}

	if(true ==  cxt->is_als_first_data_after_enable)
	{
		cxt->is_als_first_data_after_enable = false;
		//filter -1 value
		if(ALS_SUB_INVALID_VALUE == cxt->drv_data.als_data.values[0] )
		{
			ALS_SUB_LOG(" read invalid data \n");
			goto als_loop;

		}
	}
	//report data to input device
	//printk("new als_sub work run....\n");
	//ALS_SUB_LOG("als data[%d]  \n" ,cxt->drv_data.als_data.values[0]);
	/*lenovo-sw molg1 add 20141126 begin*/
	als_sub_data_report(cxt->idev_als,
			cxt->drv_data.als_data.values[0],
			cxt->drv_data.als_data.status);
	/*lenovo-sw molg1 add 20141126 end*/
als_loop:
	if(true == cxt->is_als_polling_run)
	{
		{
			mod_timer(&cxt->timer_als, jiffies + atomic_read(&cxt->delay_als)/(1000/HZ)); 
		}

	}
}


static void als_sub_poll(unsigned long data)
{
	struct als_sub_context *obj = (struct als_sub_context *)data;
	if((obj != NULL) && (obj->is_als_polling_run))
	{
		schedule_work(&obj->report_als);
	}
}


static struct als_sub_context *als_sub_context_alloc_object(void)
{

	struct als_sub_context *obj = kzalloc(sizeof(*obj), GFP_KERNEL); 
	ALS_SUB_LOG("als_sub_context_alloc_object++++\n");
	if(!obj)
	{
		ALS_SUB_ERR("Alloc als_sub object error!\n");
		return NULL;
	}	
	atomic_set(&obj->delay_als, 200); /*5Hz*/// set work queue delay time 200ms
	atomic_set(&obj->wake, 0);
	INIT_WORK(&obj->report_als, als_sub_work_func);
	init_timer(&obj->timer_als);
	obj->timer_als.expires	= jiffies + atomic_read(&obj->delay_als)/(1000/HZ);
	obj->timer_als.function	= als_sub_poll;
	obj->timer_als.data	= (unsigned long)obj;

	obj->is_als_first_data_after_enable = false;
	obj->is_als_polling_run = false;
	mutex_init(&obj->als_sub_op_mutex);
	obj->is_als_batch_enable = false;//for batch mode init

	ALS_SUB_LOG("als_sub_context_alloc_object----\n");
	return obj;
}

static int als_sub_real_enable(int enable)
{
	int err =0;
	struct als_sub_context *cxt = NULL;
	cxt = als_sub_context_obj;
	if(1==enable)
	{

		if(true==cxt->is_als_active_data || true ==cxt->is_als_active_nodata)
		{
			err = cxt->als_ctl.enable_nodata(1);
			if(err)
			{ 
				err = cxt->als_ctl.enable_nodata(1);
				if(err)
				{
					err = cxt->als_ctl.enable_nodata(1);
					if(err)
						ALS_SUB_ERR("als_sub enable(%d) err 3 timers = %d\n", enable, err);
				}
			}
			ALS_SUB_LOG("als_sub real enable  \n" );
		}

	}
	if(0 == enable)
	{
		if(false==cxt->is_als_active_data && false ==cxt->is_als_active_nodata)
		{
			
			err = cxt->als_ctl.enable_nodata(0);
			if(err)
			{ 
				ALS_SUB_ERR("als_sub enable(%d) err = %d\n", enable, err);
			}

		}
		/* lenovo-sw youwc1 20141211: report -1 when disable lsensor start */
		als_sub_data_report(cxt->idev_als, -1, 2);
		/* lenovo-sw youwc1 20141211: report -1 when disable lsensor end */
	}

	return err;
}
static int als_sub_enable_data(int enable)
{
	struct als_sub_context *cxt = NULL;
	//int err =0;
	cxt = als_sub_context_obj;
	if(NULL  == cxt->als_ctl.open_report_data)
	{
		ALS_SUB_ERR("no als control path\n");
		return -1;
	}

	if(1 == enable)
	{
		ALS_SUB_LOG("ALS_SUB enable data\n");
		cxt->is_als_active_data =true;
		cxt->is_als_first_data_after_enable = true;
		cxt->als_ctl.open_report_data(1);
		als_sub_real_enable(enable);
		if(false == cxt->is_als_polling_run && cxt->is_als_batch_enable == false)
		{
			if(false == cxt->als_ctl.is_report_input_direct)
			{
				cxt->is_get_valid_als_data_after_enable = false;
				mod_timer(&cxt->timer_als, jiffies + atomic_read(&cxt->delay_als)/(1000/HZ));
				cxt->is_als_polling_run = true;
			}
		}
	}
	if(0 == enable)
	{
		ALS_SUB_LOG("ALS_SUB disable \n");
		cxt->is_als_active_data =false;
		cxt->als_ctl.open_report_data(0);
		if(true == cxt->is_als_polling_run)
		{
			if(false == cxt->als_ctl.is_report_input_direct )
			{
				cxt->is_als_polling_run = false;
				smp_mb();
				del_timer_sync(&cxt->timer_als);
				smp_mb();
				cancel_work_sync(&cxt->report_als);
				cxt->drv_data.als_data.values[0] = ALS_SUB_INVALID_VALUE;
			}
		}
		als_sub_real_enable(enable);
	}
	return 0;
}

static ssize_t als_sub_store_active(struct device* dev, struct device_attribute *attr,
		const char *buf, size_t count)
{  
	struct als_sub_context *cxt = NULL;
	//int err =0;
	ALS_SUB_LOG("als_store_active buf=%s\n",buf);
	mutex_lock(&als_sub_context_obj->als_sub_op_mutex);
	cxt = als_sub_context_obj;

	if (!strncmp(buf, "1", 1)) 
	{
		als_sub_enable_data(1);
	} 
	else if (!strncmp(buf, "0", 1))
	{
		als_sub_enable_data(0);
	}
	else
	{
		ALS_SUB_ERR(" als_sub_store_active error !!\n");
	}
	mutex_unlock(&als_sub_context_obj->als_sub_op_mutex);
	ALS_SUB_LOG(" als_sub_store_active done\n");
	return count;
}
/*----------------------------------------------------------------------------*/
static ssize_t als_sub_show_active(struct device* dev, 
		struct device_attribute *attr, char *buf) 
{
	struct als_sub_context *cxt = NULL;
	int div = 0;
	cxt = als_sub_context_obj;
	div=cxt->als_data.vender_div;
	ALS_SUB_LOG("als vender_div value: %d\n", div);
	return snprintf(buf, PAGE_SIZE, "%d\n", div); 
}

static ssize_t als_sub_store_delay(struct device* dev, struct device_attribute *attr,
		const char *buf, size_t count)

{
	//struct als_sub_context *devobj = (struct als_sub_context*)dev_get_drvdata(dev);
	int delay;
	int mdelay=0;
	struct als_sub_context *cxt = NULL;
	//int err =0;
	mutex_lock(&als_sub_context_obj->als_sub_op_mutex);
	cxt = als_sub_context_obj;
	if(NULL == cxt->als_ctl.set_delay)
	{
		ALS_SUB_LOG("als_ctl set_delay NULL\n");
		mutex_unlock(&als_sub_context_obj->als_sub_op_mutex);
		return count;
	}

	if (1 != sscanf(buf, "%d", &delay)) {
		ALS_SUB_ERR("invalid format!!\n");
		mutex_unlock(&als_sub_context_obj->als_sub_op_mutex);
		return count;
	}

	if(false == cxt->als_ctl.is_report_input_direct)
	{
		mdelay = (int)delay/1000/1000;
		atomic_set(&als_sub_context_obj->delay_als, mdelay);
	}
	cxt->als_ctl.set_delay(delay);
	ALS_SUB_LOG(" als_delay %d ns\n",delay);
	mutex_unlock(&als_sub_context_obj->als_sub_op_mutex);
	return count;

}

static ssize_t als_sub_show_delay(struct device* dev, 
		struct device_attribute *attr, char *buf) 
{
	int len = 0;
	ALS_SUB_LOG(" not support now\n");
	return len;
}


static ssize_t als_sub_store_batch(struct device* dev, struct device_attribute *attr,
		const char *buf, size_t count)
{
	struct als_sub_context *cxt = NULL;
	//int err =0;
	ALS_SUB_LOG("als_store_batch buf=%s\n",buf);
	mutex_lock(&als_sub_context_obj->als_sub_op_mutex);
	cxt = als_sub_context_obj;
	if(cxt->als_ctl.is_support_batch){
		if (!strncmp(buf, "1", 1)) 
		{
			cxt->is_als_batch_enable = true;
			if(true == cxt->is_als_polling_run)
			{
				cxt->is_als_polling_run = false;
				del_timer_sync(&cxt->timer_als);
				cancel_work_sync(&cxt->report_als);
				cxt->drv_data.als_data.values[0] = ALS_SUB_INVALID_VALUE;
				cxt->drv_data.als_data.values[1] = ALS_SUB_INVALID_VALUE;
				cxt->drv_data.als_data.values[2] = ALS_SUB_INVALID_VALUE;
			}
		} 
		else if (!strncmp(buf, "0", 1))
		{
			cxt->is_als_batch_enable = false;
			if(false == cxt->is_als_polling_run)
			{
				if(false == cxt->als_ctl.is_report_input_direct)
				{
					cxt->is_get_valid_als_data_after_enable = false;
					mod_timer(&cxt->timer_als, jiffies + atomic_read(&cxt->delay_als)/(1000/HZ));
					cxt->is_als_polling_run = true;
				}
			}
		}
		else
		{
			ALS_SUB_ERR(" als_store_batch error !!\n");
		}
	}else{
		ALS_SUB_LOG(" als_store_batch not supported\n");
	}
	mutex_unlock(&als_sub_context_obj->als_sub_op_mutex);
	ALS_SUB_LOG(" als_store_batch done: %d\n", cxt->is_als_batch_enable);
	return count;

}

static ssize_t als_sub_show_batch(struct device* dev, 
		struct device_attribute *attr, char *buf) 
{
	return snprintf(buf, PAGE_SIZE, "%d\n", 0); 
}

static ssize_t als_sub_store_flush(struct device* dev, struct device_attribute *attr,
		const char *buf, size_t count)
{
	//mutex_lock(&als_sub_context_obj->als_sub_op_mutex);
	//  struct als_sub_context *devobj = (struct als_sub_context*)dev_get_drvdata(dev);
	//do read FIFO data function and report data immediately
	//mutex_unlock(&als_sub_context_obj->als_sub_op_mutex);
	return count;
}

static ssize_t als_sub_show_flush(struct device* dev, 
		struct device_attribute *attr, char *buf) 
{
	return snprintf(buf, PAGE_SIZE, "%d\n", 0); 
}

static ssize_t als_sub_show_devnum(struct device* dev, 
		struct device_attribute *attr, char *buf) 
{
	const char *devname =NULL;
	/*lenovo-sw molg1 add 20141126 begin*/
	devname = dev_name(&als_sub_context_obj->idev_als->dev);
	/*lenovo-sw molg1 add 20141126 end*/
	return snprintf(buf, PAGE_SIZE, "%s\n", devname+5); 
}




static int als_sub_remove(struct platform_device *pdev)
{
	ALS_SUB_LOG("als_ps_remove\n");
	return 0;
}

static int als_sub_probe(struct platform_device *pdev) 
{
	ALS_SUB_LOG("als_ps_probe\n");
	return 0;
}

#ifdef CONFIG_OF
static const struct of_device_id als_sub_of_match[] = {
	{ .compatible = "mediatek,als_sub", },
	{},
};
#endif

static struct platform_driver als_sub_driver = {
	.probe      = als_sub_probe,
	.remove     = als_sub_remove,    
	.driver     = 
	{
		.name  = "als_sub",
#ifdef CONFIG_OF
		.of_match_table = als_sub_of_match,
#endif
	}
};

static int als_sub_real_driver_init(void) 
{
	int i =0;
	int err=0;
	ALS_SUB_LOG(" als_sub_real_driver_init +\n");
	for(i = 0; i < MAX_CHOOSE_ALS_SUB_NUM; i++)
	{
		ALS_SUB_LOG("als_sub_real_driver_init i=%d\n",i);
		if(0 != als_sub_init_list[i])
		{
			ALS_SUB_LOG(" als_sub try to init driver %s\n", als_sub_init_list[i]->name);
			err = als_sub_init_list[i]->init();
			if(0 == err)
			{
				ALS_SUB_LOG(" als_sub real driver %s probe ok\n", als_sub_init_list[i]->name);
				break;
			}
		}
	}

	if(i == MAX_CHOOSE_ALS_SUB_NUM)
	{
		ALS_SUB_LOG(" als_sub_real_driver_init fail\n");
		err=-1;
	}
	return err;
}

int als_sub_driver_add(struct als_sub_init_info* obj) 
{
	int err=0;
	int i =0;

	ALS_SUB_FUN();
	if (!obj) {
		ALS_SUB_ERR("ALS_SUB driver add fail, als_sub_init_info is NULL \n");
		return -1;
	}

	for(i =0; i < MAX_CHOOSE_ALS_SUB_NUM; i++ )
	{
		if((i == 0) && (NULL == als_sub_init_list[0])){
			ALS_SUB_LOG("register als_sub driver for the first time\n");
			if(platform_driver_register(&als_sub_driver))
			{
				ALS_SUB_ERR("failed to register als_sub driver already exist\n");
			}
		}

		if(NULL == als_sub_init_list[i])
		{
			obj->platform_diver_addr = &als_sub_driver;
			als_sub_init_list[i] = obj;
			break;
		}
	}
	if(i >= MAX_CHOOSE_ALS_SUB_NUM)
	{
		ALS_SUB_ERR("ALS_SUB driver add err \n");
		err=-1;
	}

	return err;
}
EXPORT_SYMBOL_GPL(als_sub_driver_add);

int als_sub_report_interrupt_data(int value) 
{
	struct als_sub_context *cxt = NULL;
	//int err =0;
	cxt = als_sub_context_obj;	

	als_sub_data_report(cxt->idev_als,value,3);

	return 0;
}
/*----------------------------------------------------------------------------*/
EXPORT_SYMBOL_GPL(als_sub_report_interrupt_data);

static int als_sub_misc_init(struct als_sub_context *cxt)
{

	int err=0;
	cxt->mdev.minor = MISC_DYNAMIC_MINOR;
	cxt->mdev.name  = ALS_SUB_MISC_DEV_NAME;
	if((err = misc_register(&cxt->mdev)))
	{
		ALS_SUB_ERR("unable to register als_sub misc device!!\n");
	}
	return err;
}

/*lenovo-sw molg1 add 20141126 begin*/
static int als_sub_input_init(struct als_sub_context *cxt)
{
	struct input_dev *dev_als;
	int err = 0;

	dev_als = input_allocate_device();
	if(NULL == dev_als)
		return -ENOMEM;

	dev_als->name = "m_als_sub_input";//ALS_SUB_INPUTDEV_NAME;


	set_bit(EV_REL, dev_als->evbit);
	set_bit(EV_SYN, dev_als->evbit);
	input_set_capability(dev_als, EV_ABS, EVENT_TYPE_ALS_SUB_VALUE);
	input_set_capability(dev_als, EV_ABS, EVENT_TYPE_ALS_SUB_STATUS);
	input_set_abs_params(dev_als, EVENT_TYPE_ALS_SUB_VALUE, ALS_SUB_VALUE_MIN, ALS_SUB_VALUE_MAX, 0, 0);
	input_set_abs_params(dev_als, EVENT_TYPE_ALS_SUB_STATUS, ALS_SUB_STATUS_MIN, ALS_SUB_STATUS_MAX, 0, 0);
	input_set_drvdata(dev_als, cxt);


	err = input_register_device(dev_als);
	if (err < 0) {
		input_free_device(dev_als);
		return err;
	}
	cxt->idev_als = dev_als;

	return 0;
}
/*lenovo-sw molg1 add 20141126 end*/

DEVICE_ATTR(alssubactive,     		S_IWUSR | S_IRUGO, als_sub_show_active, als_sub_store_active);
DEVICE_ATTR(alssubdelay,      		S_IWUSR | S_IRUGO, als_sub_show_delay,  als_sub_store_delay);
DEVICE_ATTR(alssubbatch,      		S_IWUSR | S_IRUGO, als_sub_show_batch,  als_sub_store_batch);
DEVICE_ATTR(alssubflush,      		S_IWUSR | S_IRUGO, als_sub_show_flush,  als_sub_store_flush);
DEVICE_ATTR(alssubdevnum,      		S_IWUSR | S_IRUGO, als_sub_show_devnum,  NULL);


static struct attribute *als_sub_attributes[] = {
	&dev_attr_alssubactive.attr,
	&dev_attr_alssubdelay.attr,
	&dev_attr_alssubbatch.attr,
	&dev_attr_alssubflush.attr,
	&dev_attr_alssubdevnum.attr,
	NULL
};

static struct attribute_group als_sub_attribute_group = {
	.attrs = als_sub_attributes
};

int als_sub_register_data_path(struct als_sub_data_path *data)
{
	struct als_sub_context *cxt = NULL;
	//int err =0;
	cxt = als_sub_context_obj;
	cxt->als_data.get_data = data->get_data;
	cxt->als_data.vender_div = data->vender_div;
	cxt->als_data.als_get_raw_data = data->als_get_raw_data;
	ALS_SUB_LOG("als_sub register data path vender_div: %d\n", cxt->als_data.vender_div);
	if(NULL == cxt->als_data.get_data)
	{
		ALS_SUB_LOG("als register data path fail \n");
		return -1;
	}
	return 0;
}

int als_sub_register_control_path(struct als_sub_control_path *ctl)
{
	struct als_sub_context *cxt = NULL;
	int err =0;
	cxt = als_sub_context_obj;
	cxt->als_ctl.set_delay = ctl->set_delay;
	cxt->als_ctl.open_report_data= ctl->open_report_data;
	cxt->als_ctl.enable_nodata = ctl->enable_nodata;
	cxt->als_ctl.is_support_batch = ctl->is_support_batch;
	cxt->als_ctl.is_report_input_direct= ctl->is_report_input_direct;
	cxt->als_ctl.is_use_common_factory = ctl->is_use_common_factory;

	if(NULL==cxt->als_ctl.set_delay || NULL==cxt->als_ctl.open_report_data
			|| NULL==cxt->als_ctl.enable_nodata)
	{
		ALS_SUB_LOG("als register control path fail \n");
		return -1;
	}


	//add misc dev for sensor hal control cmd
	err = als_sub_misc_init(als_sub_context_obj);
	if(err)
	{
		ALS_SUB_ERR("unable to register als_sub misc device!!\n");
		return -2;
	}
	err = sysfs_create_group(&als_sub_context_obj->mdev.this_device->kobj,
			&als_sub_attribute_group);
	if (err < 0)
	{
		ALS_SUB_ERR("unable to create als_sub attribute file\n");
		return -3;
	}


	kobject_uevent(&als_sub_context_obj->mdev.this_device->kobj, KOBJ_ADD);

	return 0;	
}


//AAL functions****************************************
int als_sub_aal_enable(int enable)
{	
	int ret = 0;
	struct als_sub_context *cxt = NULL;

	if(!als_sub_context_obj){
		ALS_SUB_ERR("null pointer of als_sub_context_obj!!\n");
		return -1;
	}

	if(als_sub_context_obj->als_ctl.enable_nodata == NULL){
		ALS_SUB_ERR("als_sub context obj not exsit in als_sub_aal_enable\n");
		return -1;
	}
	cxt = als_sub_context_obj;

	if(enable == 1){
		if(als_sub_context_obj->is_als_active_data == false)
			ret = cxt->als_ctl.enable_nodata(enable);
	}else if(enable == 0){
		if(als_sub_context_obj->is_als_active_data == false)
			ret = cxt->als_ctl.enable_nodata(enable);
	}

	return ret;
}

int als_sub_aal_get_status()
{
	return 0;
}

int als_sub_aal_get_data()
{
	int ret = 0;
	struct als_sub_context *cxt = NULL;
	int value = 0;
	int status = 0;

	if(!als_sub_context_obj){
		ALS_SUB_ERR("als_sub_context_obj null pointer!!\n");
		return -1;
	}	

	if(als_sub_context_obj->als_data.get_data == NULL){
		ALS_SUB_ERR("aal:get_data not exsit\n");
		return -1;
	}

	cxt = als_sub_context_obj;
	ret = cxt->als_data.get_data(&value,&status);
	if(ret < 0)
		return -1;

	return value;
}
//***************************************************

static int alssub_probe(struct platform_device *pdev) 
{

	int err;
	ALS_SUB_LOG("+++++++++++++als_sub_probe!!\n");

	als_sub_context_obj = als_sub_context_alloc_object();
	if (!als_sub_context_obj)
	{
		err = -ENOMEM;
		ALS_SUB_ERR("unable to allocate devobj!\n");
		goto exit_alloc_data_failed;
	}

	//init real als_subeleration driver
	err = als_sub_real_driver_init();
	if(err)
	{
		ALS_SUB_ERR("als_sub real driver init fail\n");
		goto real_driver_init_fail;
	}


	//init input dev
	err = als_sub_input_init(als_sub_context_obj);
	if(err)
	{
		ALS_SUB_ERR("unable to register als_sub input device!\n");
		goto exit_alloc_input_dev_failed;
	}

#if defined(CONFIG_HAS_EARLYSUSPEND)
	atomic_set(&(als_sub_context_obj->early_suspend), 0);
	als_sub_context_obj->early_drv.level    = EARLY_SUSPEND_LEVEL_STOP_DRAWING - 1,
		als_sub_context_obj->early_drv.suspend  = als_sub_early_suspend,
		als_sub_context_obj->early_drv.resume   = als_sub_late_resume,    
		register_early_suspend(&als_sub_context_obj->early_drv);
#endif


	ALS_SUB_LOG("----als_sub_probe OK !!\n");
	return 0;

	//exit_hwmsen_create_attr_failed:
	//exit_misc_register_failed:    

	//exit_err_sysfs:


real_driver_init_fail:
exit_alloc_input_dev_failed:    
	kfree(als_sub_context_obj);
	als_sub_context_obj = NULL;
exit_alloc_data_failed:


	ALS_SUB_LOG("----als_sub_probe fail !!!\n");
	return err;
}



static int alssub_remove(struct platform_device *pdev)
{
	int err=0;
	ALS_SUB_FUN(f);
	/*lenovo-sw molg1 add 20141126 begin*/
	input_unregister_device(als_sub_context_obj->idev_als);        
	sysfs_remove_group(&als_sub_context_obj->idev_als->dev.kobj,
			&als_sub_attribute_group);
	/*lenovo-sw molg1 add 20141126 end*/
	if((err = misc_deregister(&als_sub_context_obj->mdev)))
	{
		ALS_SUB_ERR("misc_deregister fail: %d\n", err);
	}
	kfree(als_sub_context_obj);

	return 0;
}

static void als_sub_early_suspend(struct early_suspend *h) 
{
	atomic_set(&(als_sub_context_obj->early_suspend), 1);
	ALS_SUB_LOG(" als_sub_early_suspend ok------->hwm_obj->early_suspend=%d \n",atomic_read(&(als_sub_context_obj->early_suspend)));
	return ;
}
/*----------------------------------------------------------------------------*/
static void als_sub_late_resume(struct early_suspend *h)
{
	atomic_set(&(als_sub_context_obj->early_suspend), 0);
	ALS_SUB_LOG(" als_sub_late_resume ok------->hwm_obj->early_suspend=%d \n",atomic_read(&(als_sub_context_obj->early_suspend)));
	return ;
}

static int alssub_suspend(struct platform_device *dev, pm_message_t state) 
{
	return 0;
}
/*----------------------------------------------------------------------------*/
static int alssub_resume(struct platform_device *dev)
{
	return 0;
}

#ifdef CONFIG_OF
static const struct of_device_id alssub_of_match[] = {
	{ .compatible = "mediatek,m_als_sub_pl", },
	{},
};
#endif

static struct platform_driver alssub_driver =
{
	.probe      = alssub_probe,
	.remove     = alssub_remove,    
	.suspend    = alssub_suspend,
	.resume     = alssub_resume,
	.driver     = 
	{
		.name = ALS_SUB_PL_DEV_NAME,
#ifdef CONFIG_OF
		.of_match_table = alssub_of_match,
#endif
	}
};

static int __init als_sub_init(void) 
{
	ALS_SUB_FUN();

	if(platform_driver_register(&alssub_driver))
	{
		ALS_SUB_ERR("failed to register als_sub driver\n");
		return -ENODEV;
	}

	return 0;
}

static void __exit als_sub_exit(void)
{
	platform_driver_unregister(&alssub_driver);  
	platform_driver_unregister(&als_sub_driver);    

}
late_initcall(als_sub_init);
//module_init(als_sub_init);
//module_exit(als_sub_exit);
MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("ALS_SUB device driver");
MODULE_AUTHOR("Mediatek");

