#ifndef _SII_IDS_H
#define _SII_IDS_H
#define SII_GROUP_GENERAL  0x00
#define SII_GROUP_OSAL     0x01
#define SII_GROUP_NCL      0x02
#define SII_GROUP_APP      0x03
#define SII_STATUS_GROUP_MASK     0x00FF0000
#define SII_STATUS_GROUP_SHIFT    16
#define SII_STATUS_LEVEL_MASK     0x0000FF00
#define SII_STATUS_LEVEL_SHIFT    8
#define SII_STATUS_VALUE_MASK     0x000000FF
#define SII_STATUS_VALUE_SHIFT    0
#define SII_STATUS_LEVEL_SUCCESS  0x00
#define SII_STATUS_LEVEL_WARNING  0x01
#define SII_STATUS_LEVEL_ERROR    0x02
#define SII_STATUS_VALUE(group, level, value)                           \
    ((((group) << SII_STATUS_GROUP_SHIFT) & SII_STATUS_GROUP_MASK) |    \
     (((level) << SII_STATUS_LEVEL_SHIFT) & SII_STATUS_LEVEL_MASK) |    \
     (((value) << SII_STATUS_VALUE_SHIFT) & SII_STATUS_VALUE_MASK))
#define SII_STATUS_SET_GROUP(group, value)                          \
    (((value) & ~(SII_STATUS_GROUP_MASK)) |                         \
     (((group) << SII_STATUS_GROUP_SHIFT) & SII_STATUS_GROUP_MASK))
#define SII_STATUS_GET_GROUP(value)                                 \
    (((value) & SII_STATUS_GROUP_MASK) >> SII_STATUS_GROUP_SHIFT)
#define SII_STATUS_GET_LEVEL(value)                                 \
    (((value) & SII_STATUS_LEVEL_MASK) >> SII_STATUS_LEVEL_SHIFT)
#define SII_STATUS_ISERROR(status)                                      \
    (((SII_STATUS_GET_LEVEL(status)) == SII_STATUS_LEVEL_ERROR) ? true : false)
#define SII_STATUS_ISWARNING(status)                                    \
    (((SII_STATUS_GET_LEVEL(status)) == SII_STATUS_LEVEL_WARNING) ? true : false)
typedef enum {
	SII_STATUS_SUCCESS = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_SUCCESS, 0x00),
	SII_STATUS_SUCCESS_LAST,
	SII_STATUS_WARN_PENDING =
	    SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_WARNING, 0x01),
	SII_STATUS_WARN_BREAK = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_WARNING, 0x02),
	SII_STATUS_WARN_INCOMPLETE =
	    SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_WARNING, 0x03),
	SII_STATUS_WARN_CUSTOM1 =
	    SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_WARNING, 0x81),
	SII_STATUS_WARN_CUSTOM2 =
	    SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_WARNING, 0x82),
	SII_STATUS_WARN_CUSTOM3 =
	    SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_WARNING, 0x83),
	SII_STATUS_WARN_CUSTOM4 =
	    SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_WARNING, 0x84),
	SII_STATUS_WARN_CUSTOM5 =
	    SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_WARNING, 0x85),
	SII_STATUS_WARN_LAST,
	SII_STATUS_ERR_INVALID_HANDLE =
	    SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x00),
	SII_STATUS_ERR_INVALID_PARAM =
	    SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x01),
	SII_STATUS_ERR_INVALID_OP =
	    SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x02),
	SII_STATUS_ERR_NOT_AVAIL =
	    SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x03),
	SII_STATUS_ERR_IN_USE = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x04),
	SII_STATUS_ERR_TIMEOUT = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x05),
	SII_STATUS_ERR_FAILED = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x07),
	SII_STATUS_ERR_NOT_IMPLEMENTED =
	    SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x41),
	SII_STATUS_ERR_CUSTOM1 = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x81),
	SII_STATUS_ERR_CUSTOM2 = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x82),
	SII_STATUS_ERR_CUSTOM3 = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x83),
	SII_STATUS_ERR_CUSTOM4 = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x84),
	SII_STATUS_ERR_CUSTOM5 = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x85),
	SII_STATUS_ERR_CUSTOM6 = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x86),
	SII_STATUS_ERR_CUSTOM7 = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x87),
	SII_STATUS_ERR_CUSTOM8 = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x88),
	SII_STATUS_ERR_CUSTOM9 = SII_STATUS_VALUE(SII_GROUP_GENERAL, SII_STATUS_LEVEL_ERROR, 0x89),
	SII_STATUS_ERR_LAST
} SiiStatus_t;
#endif
