#ifndef BUILD_LK
#include <linux/string.h>
#include <linux/kernel.h>
#endif

#include "lcm_drv.h"

#ifdef BUILD_LK
	#include <platform/upmu_common.h>
	#include <platform/mt_gpio.h>
	#include <platform/mt_i2c.h> 
	#include <platform/mt_pmic.h>
	#include <string.h>
#elif defined(BUILD_UBOOT)
    #include <asm/arch/mt_gpio.h>
#else
	#include <mach/mt_pm_ldo.h>
    #include <mach/mt_gpio.h>
#endif

#include <cust_gpio_usage.h>
#include <cust_i2c.h>

#ifdef BUILD_LK
#define LCD_DEBUG(fmt)  dprintf(CRITICAL,fmt)
#else
#define LCD_DEBUG(fmt)  printk(fmt)
#endif


/*********************************************************
* Gate Driver
*********************************************************/
 
#ifndef BUILD_LK
#include <linux/kernel.h>
#include <linux/module.h>  
#include <linux/fs.h>
#include <linux/slab.h>
#include <linux/init.h>
#include <linux/list.h>
#include <linux/i2c.h>
#include <linux/irq.h>
//#include <linux/jiffies.h>
#include <linux/uaccess.h>
//#include <linux/delay.h>
#include <linux/interrupt.h>
#include <linux/io.h>
#include <linux/platform_device.h>
/***************************************************************************** 
 * Define
 *****************************************************************************/

#define TPS_I2C_BUSNUM  I2C_I2C_LCD_BIAS_CHANNEL//for I2C channel 0
#define I2C_ID_NAME "tps65132"
#define TPS_ADDR 0x3E

/***************************************************************************** 
 * GLobal Variable
 *****************************************************************************/
static struct i2c_board_info __initdata tps65132_board_info = {I2C_BOARD_INFO(I2C_ID_NAME, TPS_ADDR)};
static struct i2c_client *tps65132_i2c_client = NULL;


/***************************************************************************** 
 * Function Prototype
 *****************************************************************************/ 
static int tps65132_probe(struct i2c_client *client, const struct i2c_device_id *id);
static int tps65132_remove(struct i2c_client *client);
/***************************************************************************** 
 * Data Structure
 *****************************************************************************/

 struct tps65132_dev	{	
	struct i2c_client	*client;
	
};

static const struct i2c_device_id tps65132_id[] = {
	{ I2C_ID_NAME, 0 },
	{ }
};

//#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,36))
//static struct i2c_client_address_data addr_data = { .forces = forces,};
//#endif
static struct i2c_driver tps65132_iic_driver = {
	.id_table	= tps65132_id,
	.probe		= tps65132_probe,
	.remove		= tps65132_remove,
	.driver		= {
		.owner	= THIS_MODULE,
		.name	= "tps65132",
	},
 
};
/***************************************************************************** 
 * Extern Area
 *****************************************************************************/ 
 
 

/***************************************************************************** 
 * Function
 *****************************************************************************/ 
static int tps65132_probe(struct i2c_client *client, const struct i2c_device_id *id)
{  
	printk( "tps65132_iic_probe\n");
	printk("TPS: info==>name=%s addr=0x%x\n",client->name,client->addr);
	tps65132_i2c_client  = client;		
	return 0;      
}

static int tps65132_remove(struct i2c_client *client)
{  	
  printk( "tps65132_remove\n");
  tps65132_i2c_client = NULL;
   i2c_unregister_device(client);
  return 0;
}

 static int tps65132_write_bytes(unsigned char addr, unsigned char value)
{	
	int ret = 0;
	struct i2c_client *client = tps65132_i2c_client;
	char write_data[2]={0};	
	write_data[0]= addr;
	write_data[1] = value;
    ret=i2c_master_send(client, write_data, 2);
	if(ret<0)
	printk("tps65132 write data fail !!\n");	
	return ret ;
}

/*
 * module load/unload record keeping
 */

static int __init tps65132_iic_init(void)
{

   printk( "tps65132_iic_init\n");
   i2c_register_board_info(TPS_I2C_BUSNUM, &tps65132_board_info, 1);
   printk( "tps65132_iic_init2\n");
   i2c_add_driver(&tps65132_iic_driver);
   printk( "tps65132_iic_init success\n");	
   return 0;
}

static void __exit tps65132_iic_exit(void)
{
  printk( "tps65132_iic_exit\n");
  i2c_del_driver(&tps65132_iic_driver);  
}


module_init(tps65132_iic_init);
module_exit(tps65132_iic_exit);

MODULE_AUTHOR("Xiaokuan Shi");
MODULE_DESCRIPTION("MTK TPS65132 I2C Driver");
MODULE_LICENSE("GPL"); 

#endif


#ifdef BUILD_LK

#define TPS65132_SLAVE_ADDR_WRITE  0x7C  
static struct mt_i2c_t TPS65132_i2c;

static int TPS65132_write_byte(kal_uint8 addr, kal_uint8 value)
{
    kal_uint32 ret_code = I2C_OK;
    kal_uint8 write_data[2];
    kal_uint16 len;

    write_data[0]= addr;
    write_data[1] = value;

    TPS65132_i2c.id = I2C_I2C_LCD_BIAS_CHANNEL;//I2C2;
    /* Since i2c will left shift 1 bit, we need to set FAN5405 I2C address to >>1 */
    TPS65132_i2c.addr = (TPS65132_SLAVE_ADDR_WRITE >> 1);
    TPS65132_i2c.mode = ST_MODE;
    TPS65132_i2c.speed = 100;
    len = 2;

    ret_code = i2c_write(&TPS65132_i2c, write_data, len);
    //printf("%s: i2c_write: ret_code: %d\n", __func__, ret_code);

    return ret_code;
}

#endif



/*********************************************************
* LCM  Driver
*********************************************************/

static const unsigned char LCD_MODULE_ID = 0x01; //  haobing modified 2013.07.11
// ---------------------------------------------------------------------------
//  Local Constants
// ---------------------------------------------------------------------------
#define LCM_DSI_CMD_MODE 1
#define FRAME_WIDTH (1080)
#define FRAME_HEIGHT (1920)
#define GPIO_65132_EN GPIO_LCD_BIAS_ENP_PIN


#define REGFLAG_DELAY 0xFFFC
#define REGFLAG_UDELAY 0xFFFB

#define REGFLAG_END_OF_TABLE 0xFFFD   // END OF REGISTERS MARKER
#define REGFLAG_RESET_LOW 0xFFFE
#define REGFLAG_RESET_HIGH 0xFFFF

static LCM_DSI_MODE_SWITCH_CMD lcm_switch_mode_cmd;

#define UFO_ON_3X_60
//#define UFO_ON_3X_120
//#define UFO_OFF_60

#ifndef TRUE
    #define TRUE 1
#endif

#ifndef FALSE
    #define FALSE 0
#endif

//static unsigned int lcm_esd_test = FALSE;      ///only for ESD test
// ---------------------------------------------------------------------------
//  Local Variables
// ---------------------------------------------------------------------------
static const unsigned int BL_MIN_LEVEL = 20;
static LCM_UTIL_FUNCS lcm_util;
static int lcm_fps = 60;
#define SET_RESET_PIN(v) (lcm_util.set_reset_pin((v)))
#define MDELAY(n)        (lcm_util.mdelay(n))
#define UDELAY(n)        (lcm_util.udelay(n))

// ---------------------------------------------------------------------------
//  Local Functions
// ---------------------------------------------------------------------------

#define dsi_set_cmdq_V2(cmd, count, ppara, force_update)	lcm_util.dsi_set_cmdq_V2(cmd, count, ppara, force_update)
#define dsi_set_cmdq(pdata, queue_size, force_update)		lcm_util.dsi_set_cmdq(pdata, queue_size, force_update)
#define wrtie_cmd(cmd)										lcm_util.dsi_write_cmd(cmd)
#define write_regs(addr, pdata, byte_nums)					lcm_util.dsi_write_regs(addr, pdata, byte_nums)
#define read_reg(cmd)										lcm_util.dsi_dcs_read_lcm_reg(cmd)
#define read_reg_v2(cmd, buffer, buffer_size)   			lcm_util.dsi_dcs_read_lcm_reg_v2(cmd, buffer, buffer_size)
#define dsi_set_cmdq_V22(cmdq, cmd, count, ppara, force_update)	lcm_util.dsi_set_cmdq_V22(cmdq, cmd, count, ppara, force_update)
#define dsi_set_cmdq_V11(cmdq, pdata, queue_size, force_update)	lcm_util.dsi_set_cmdq_V11(cmdq, pdata, queue_size, force_update)

struct LCM_setting_table {
    unsigned int cmd;
    unsigned char count;
    unsigned char para_list[64];
};

static unsigned char od_table_33x33[] =
{  
  0,   8,  19,  30,  43,  53,  61,  74,  84,  94, 104, 113, 122, 130, 139, 148, 156, 164, 172, 180, 188, 195, 203, 210, 217, 224, 230, 237, 243, 247, 252, 255, 255,
  0,   8,  16,  26,  39,  50,  60,  72,  83,  94, 104, 113, 122, 130, 139, 148, 156, 164, 172, 180, 188, 196, 203, 210, 217, 224, 230, 236, 242, 245, 250, 253, 255,
  0,   8,  16,  24,  36,  47,  59,  70,  81,  91, 102, 112, 120, 130, 138, 146, 154, 162, 170, 178, 186, 194, 202, 209, 216, 222, 229, 236, 242, 245, 250, 253, 255,
  0,   8,  16,  24,  34,  45,  55,  66,  77,  88,  98, 109, 118, 128, 137, 146, 154, 162, 170, 178, 186, 194, 202, 209, 216, 222, 229, 236, 242, 245, 250, 253, 255,
  0,   8,  16,  24,  32,  42,  53,  64,  75,  84,  96, 106, 116, 126, 136, 144, 152, 160, 169, 176, 184, 192, 200, 208, 214, 221, 228, 235, 240, 246, 249, 253, 255,
  0,   8,  15,  23,  32,  40,  50,  62,  72,  84,  93, 104, 114, 125, 134, 144, 152, 160, 168, 176, 184, 192, 200, 207, 214, 221, 228, 234, 240, 245, 250, 253, 255,
  0,   8,  15,  22,  30,  39,  48,  58,  69,  80,  89, 100, 111, 121, 132, 141, 150, 158, 168, 176, 183, 192, 200, 206, 214, 221, 228, 234, 240, 245, 250, 253, 255,
  0,   8,  15,  20,  28,  36,  46,  56,  65,  77,  86,  98, 108, 119, 128, 140, 150, 158, 166, 174, 182, 190, 198, 206, 212, 220, 226, 234, 240, 245, 250, 253, 255,
  0,   8,  14,  20,  26,  34,  44,  55,  64,  74,  85,  95, 106, 116, 128, 137, 148, 156, 165, 174, 181, 190, 198, 206, 212, 220, 226, 232, 238, 244, 249, 254, 255,
  0,   8,  14,  19,  26,  33,  42,  52,  62,  72,  81,  93, 103, 114, 124, 136, 145, 156, 164, 172, 180, 188, 196, 204, 211, 218, 226, 232, 238, 244, 249, 254, 255,
  0,   7,  14,  19,  25,  32,  40,  50,  60,  70,  80,  89, 101, 110, 122, 132, 142, 152, 162, 170, 179, 188, 196, 204, 210, 218, 225, 232, 238, 244, 247, 252, 255,
  0,   7,  14,  18,  24,  30,  38,  47,  57,  66,  78,  88,  98, 109, 119, 130, 140, 150, 160, 170, 178, 186, 194, 202, 210, 218, 224, 232, 238, 243, 248, 251, 255,
  0,   7,  14,  17,  22,  29,  37,  46,  54,  65,  74,  85,  96, 105, 117, 126, 138, 147, 158, 166, 176, 186, 194, 202, 210, 216, 224, 230, 236, 242, 248, 251, 255,
  0,   7,  14,  16,  22,  29,  36,  44,  53,  62,  73,  82,  94, 104, 114, 126, 135, 146, 156, 166, 174, 184, 192, 201, 208, 216, 222, 230, 236, 242, 247, 252, 255,
  0,   7,  14,  16,  22,  28,  34,  42,  50,  60,  70,  81,  90, 102, 112, 122, 134, 143, 154, 163, 172, 182, 192, 200, 208, 216, 222, 230, 236, 242, 247, 252, 255,
  0,   7,  13,  17,  22,  28,  34,  42,  50,  58,  68,  78,  89,  99, 111, 120, 131, 142, 151, 162, 170, 180, 190, 199, 208, 214, 222, 230, 236, 242, 247, 252, 255,
  0,   7,  13,  17,  22,  27,  33,  40,  46,  56,  64,  75,  86,  97, 106, 119, 128, 140, 151, 161, 169, 184, 190, 199, 208, 220, 228, 234, 238, 246, 252, 255, 255,
  0,   7,  12,  16,  22,  27,  33,  40,  46,  54,  64,  74,  84,  94, 106, 116, 128, 136, 150, 161, 167, 182, 188, 199, 208, 218, 226, 234, 240, 246, 252, 255, 255,
  0,   7,  12,  16,  21,  26,  31,  38,  44,  52,  60,  71,  82,  92, 102, 114, 124, 136, 144, 158, 166, 181, 188, 198, 208, 217, 226, 233, 240, 246, 253, 255, 255,
  0,   7,  12,  16,  21,  26,  31,  38,  44,  52,  60,  68,  80,  90, 100, 110, 121, 131, 143, 152, 165, 176, 185, 196, 206, 215, 224, 232, 240, 246, 253, 255, 255,
  0,   7,  12,  15,  20,  25,  30,  36,  42,  50,  58,  66,  76,  86,  96, 106, 116, 127, 138, 149, 160, 172, 185, 195, 205, 216, 224, 232, 240, 246, 252, 255, 255,
  0,   7,  12,  16,  19,  24,  30,  36,  42,  49,  56,  65,  73,  82,  92, 102, 110, 122, 133, 145, 158, 168, 180, 191, 201, 212, 222, 230, 238, 246, 252, 255, 255,
  0,   6,   9,  14,  18,  23,  28,  34,  41,  48,  56,  64,  72,  80,  89,  99, 107, 118, 129, 140, 153, 165, 176, 188, 201, 211, 221, 229, 238, 245, 252, 255, 255,
  0,   6,   9,  14,  17,  22,  28,  33,  40,  47,  54,  63,  71,  79,  88,  97, 105, 115, 125, 136, 147, 159, 172, 184, 194, 207, 218, 228, 237, 245, 252, 255, 255,
  0,   6,   9,  14,  18,  21,  26,  32,  38,  44,  52,  60,  68,  77,  86,  95, 104, 114, 124, 134, 145, 156, 167, 180, 192, 202, 216, 226, 236, 245, 252, 255, 255,
  0,   6,   9,  12,  15,  20,  26,  31,  37,  44,  51,  59,  67,  76,  84,  93, 101, 110, 120, 130, 140, 151, 164, 175, 188, 200, 212, 225, 236, 245, 252, 255, 255,
  0,   4,   8,  12,  13,  18,  23,  29,  35,  42,  50,  58,  66,  75,  83,  92, 100, 109, 118, 128, 138, 149, 160, 171, 183, 196, 208, 220, 233, 244, 252, 255, 255,
  0,   4,   7,  10,  12,  17,  22,  27,  33,  40,  48,  56,  64,  74,  82,  91,  99, 108, 117, 126, 136, 146, 156, 166, 180, 191, 204, 216, 230, 241, 251, 255, 255,
  0,   4,   7,  10,  11,  16,  20,  26,  32,  40,  48,  56,  64,  73,  81,  90,  97, 106, 114, 122, 132, 142, 152, 163, 176, 188, 201, 214, 224, 240, 251, 255, 255,
  0,   4,   7,   9,  11,  16,  20,  25,  32,  40,  48,  56,  64,  72,  80,  88,  96, 104, 112, 121, 130, 140, 151, 162, 173, 185, 198, 211, 223, 232, 245, 254, 255,
  0,   4,   7,   9,  11,  14,  19,  25,  32,  40,  48,  56,  64,  72,  80,  88,  96, 104, 112, 121, 130, 140, 150, 160, 171, 182, 195, 208, 220, 231, 240, 250, 255,
  0,   4,   6,   7,   9,  13,  18,  24,  32,  40,  48,  56,  64,  72,  80,  88,  96, 104, 112, 120, 128, 138, 148, 158, 168, 178, 189, 200, 211, 224, 237, 248, 255,
  0,   4,   6,   7,   8,  12,  17,  24,  32,  40,  48,  56,  64,  72,  80,  88,  96, 104, 112, 120, 128, 136, 146, 156, 164, 177, 188, 198, 211, 224, 236, 248, 255,
};

static struct LCM_setting_table lcm_suspend_setting[] = {
	{0x28,0,{}},
	{0x10,0,{}},

	{REGFLAG_DELAY, 120, {}}
};

static struct LCM_setting_table lcm_60fps_setting[] = {  

    {0x00,1,{0x00}},
    {0xFF,3,{0x19,0x06,0x01}},

    {0x00,1,{0x80}},
    {0xFF,2,{0x19,0x06}},

    {0x00,1,{0x80}},
    {0xC0,14,{0x00,0x74,0x07,0xb0,0x0f,0x00,0x74,0x02,0x06,0x00,0x74,0x07,0xb0,0x0f}},

    {0x00,1,{0x00}},
    {0xFB,1,{0x01}},

    {0x00,1,{0x80}},
    {0xFF,2,{0x00,0x00}},

    {0x00,1,{0x00}},
    {0xFF,3,{0x00,0x00,0x00}},
    {REGFLAG_END_OF_TABLE, 0x00, {}}
};

static struct LCM_setting_table lcm_120fps_setting[] = {
    {0x00,1,{0x00}},
    {0xFF,3,{0x19,0x06,0x01}},

    {0x00,1,{0x80}},
    {0xFF,2,{0x19,0x06}},

    {0x00,1,{0x80}},
    {0xC0,14,{0x00,0x74,0x00,0x02,0x06,0x00,0x74,0x02,0x06,0x00,0x74,0x00,0x02,0x06}},

    {0x00,1,{0x00}},
    {0xFB,1,{0x01}},

    {0x00,1,{0x80}},
    {0xFF,2,{0x00,0x00}},

    {0x00,1,{0x00}},
    {0xFF,3,{0x00,0x00,0x00}},
    {REGFLAG_END_OF_TABLE, 0x00, {}}

};

static struct LCM_setting_table lcm_initialization_setting[] = {
//;*************************************************************************                                                            
//; MIPI initial code TABLE                                                                                                             
//;*************************************************************************                                                            
{0x00,1,{0x00}},                               //CODE_00_1DATA0   DBH 00,00   
{0xFF,3,{0x19,0x06,0x01}},                     //CODE_FF_3DATA0   DBH FF,19,06,01

{0x00,1,{0x80}},                               //CODE_00_1DATA1   DBH 00,80   
{0xFF,2,{0x19,0x06}},                          //CODE_FF_2DATA1   DBH FF,19,06

{0x00,1,{0xA0}},                               //CODE_00_1DATA2   DBH 00,A0    
{0xC1,3,{0x00,0xC0,0x10}},                     //CODE_C1_3DATA2   DBH C1,00,C0,10

//;*****************************
//;  VGH0 8V  VGLO -7V
{0x00,1,{0x91}},                               //CODE_00_1DATA3   DBH 00,91    
{0xC5,2,{0x14,0x1E}},                          //CODE_C5_2DATA3   DBH C5,14,1E
//;*****************************

//;*****************************
//; VGH pump X4VCI  VGL pump X4VCI
{0x00,1,{0x95}},                               //CODE_00_1DATA57   DBH 00,95    
{0xC5,1,{0x11}},                               //CODE_C5_1DATA57   DBH C5,11
//;*****************************

{0x00,1,{0x00}},                               //CODE_00_1DATA4   DBH 00,00     
{0xD9,1,{0x00}},                               //CODE_D9_1DATA4   DBH D9,00  ; VCOM

{0x00,1,{0x01}},                               //CODE_00_1DATA83   DBH 00,01     
{0xD9,1,{0xCD}},                               //CODE_D9_1DATA49   DBH D9,cd


{0x00,1,{0x02}},                               //CODE_0002_1DATA4   DBH 00,02     
{0xD9,1,{0x00}},                               //CODE_D900_1DATA4   DBH D9,00   ; VCOM

{0x00,1,{0x03}},                               //CODE_0003_1DATA83   DBH 00,03     
{0xD9,1,{0xCD}},                               //CODE_D903_1DATA49   DBH D9,cd

{0x00,1,{0x04}},                               //CODE_0004_1DATA4   DBH 00,04     
{0xD9,1,{0x00}},                               //CODE_D904_1DATA4   DBH D9,00   ; VCOM

{0x00,1,{0x05}},                               //CODE_0005_1DATA83   DBH 00,05     
{0xD9,1,{0xCD}},                               //CODE_D905_1DATA49   DBH D9,cd

{0x00,1,{0x06}},                               //CODE_0006_1DATA4   DBH 00,06     
{0xD9,1,{0x00}},                               //CODE_D906_1DATA4   DBH D9,00   ; VCOM

{0x00,1,{0x07}},                               //CODE_0007_1DATA83   DBH 00,07    
{0xD9,1,{0xCD}},                               //CODE_D907_1DATA49   DBH D9,cd


//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//; add discharge 
{0x00,1,{0x81}},                               //CODE_0081_1DATA0081  DBH 00,81
{0xA5,1,{0x01}},                               //CODE_A501_1DATAA501  DBH A5,01  

{0x00,1,{0xA5}},                               //CODE_00A5_1DATA00A5  DBH 00,A5
{0xC5,1,{0x11}},                               //CODE_C511_1DATAC511  DBH C5,11 


{0x00,1,{0x90}},                               //CODE_0090_1DATA0090  DBH 00,90
{0xF5,4,{0x09,0x16,0x09,0x16}},                //CODE_F509_1DATAF509  DBH F5,09,16,09,16
 
{0x00,1,{0xA7}},                               //CODE_00A7_1DATA00A7  DBH 00,A7
{0xF5,1,{0x1A}},                               //CODE_F51A_1DATAF51A  DBH F5,1A 

{0x00,1,{0x9D}},                               //CODE_009D_1DATA009D    DBH 00,9D
{0xF5,1,{0x1A}},                               //CODE_F51A0_10DATAF     DBH F5,1A 

{0x00,1,{0xA5}},                               //CODE_00A5_10DATA00   DBH 00,A5
{0xF5,1,{0x16}},                               //CODE_F516_1DATAF516  DBH F5,16

{0x00,1,{0x8D}},                               //CODE_008D_1DATA008D  DBH 00,8D
{0xF5,1,{0x17}},                               //CODE_F517_1DATAF517  DBH F5,17

{0x00,1,{0xE3}},                               //CODE_00E3_1DATA00E3  DBH 00,E3
{0xF5,1,{0x11}},                               //CODE_F511_1DATAF511  DBH F5,11
  
{0x00,1,{0xED}},                               //CODE_00ED_1DATA00ED    DBH 00,ED
{0xF5,1,{0x16}},                               //CODE_F5160_10DATAF5    DBH F5,16

{0x00,1,{0xE5}},                               //CODE_00E5_1DATA00E5    DBH 00,E5
{0xF5,1,{0x16}},                               //CODE_F5161_11DATAF5    DBH F5,16

{0x00,1,{0x81}},                               //CODE_0081_10DATA00    DBH 00,81
{0xF5,1,{0x16}},                               //CODE_F5162_12DATAF5    DBH F5,16

{0x00,1,{0x83}},                               //CODE_0083_1DATA0083    DBH 00,83
{0xF5,1,{0x16}},                               //CODE_F5163_13DATAF5    DBH F5,16

{0x00,1,{0xE1}},                               //CODE_00E1_1DATA00E1    DBH 00,E1
{0xF5,1,{0x16}},                               //CODE_F5164_14DATAF5    DBH F5,16
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//; WAKE UP

{0x00,1,{0xC0}},                               //CODE_00C0_1DATA00C0    DBH 00,C0
{0xCC,15,{0x0c,0x0c,0x00,0x00,0x0c,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},  //CODE_CC0C_1DATACC0C    DBH CC,0c,0c,00,00,0c,0c,0c,0c,00,00,00,00,00,00,00

{0x00,1,{0xD0}},                               //CODE_00D0_1DATA00D0    DBH 00,D0
{0xCC,15,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x33,0x33,0x33}},  //CODE_CC0D_1DATACC0D    DBH CC,00,00,00,00,00,00,00,00,00,00,00,33,33,33,33

{0x00,1,{0xE0}},                               //CODE_00E0_1DATA00E0    DBH 00,E0
{0xCC,15,{0x33,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},  //CODE_CC33_1DATACC33    DBH CC,33,33,00,00,00,00,00,00,00,00,00,00,00,00,00
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  

//;*****************************
//; osc 100MHz                      
{0x00,1,{0x80}},                               //CODE_00_1DATA5   DBH 00,80   
{0xC1,2,{0x77,0x77}},                          //CODE_C1_2DATA5   DBH C1,55,55  
{0x00,1,{0x81}},  //wangyq13 change for 60fps
{0xC0,1,{0x8F}},
//;*****************************

//;*****************************
//; gamma bias 1.0uA AP 80% 
{0x00,1,{0x94}},                               //CODE_00_1DATA6  DBH 00,94            ;Frequency
{0xC5,1,{0x64}},                               //CODE_C5_1DATA6  DBH C5,64;;;;;;;;;;;;;;;;;;;;;;;;
//;*****************************

//;*****************************
//; gamma bias 1.0uA AP 80%
{0x00,1,{0xA4}},                               //CODE_00_1DATA7  DBH 00,A4            
{0xC5,1,{0x64}},                               //CODE_C5_1DATA7  DBH C5,64  ;;;;;;;;;;;;;;
//;*****************************

//;*****************************
//;LVDD18 1.25V  lvdsvddv 1.25V
{0x00,1,{0xC1}},                               //CODE_00_1DATA8  DBH 00,C1            
{0xC5,1,{0xB5}},                               //CODE_C5_1DATA8  DBH C5,B5;            ;
//;*****************************

//;*****************************
//; PIXEL COLUMN INVERSION
{0x00,1,{0xB3}},                               //CODE_00_1DATA9  DBH 00,B3            
{0xC0,1,{0x88}},                               //CODE_C0_1DATA9  DBH C0,88
//;*****************************

//;*****************************
//; SCAN MODE FORWARD 00 BACKWARD 50
{0x00,1,{0xB4}},                               //CODE_00_1DATA87  DBH 00,B4           
{0xC0,1,{0x00}},                               //CODE_C0_1DATA87  DBH C0,50
//;*****************************


{0x00,1,{0xE0}},                               //CODE_C5E0_1DATA156   DBH 00,E0    ;BROKEN 
{0xC5,1,{0x01}},                               //CODE_C5E0_1DATA157   DBH C5,01

//;*****************************
//; gvddp gvddn 4.6
{0x00,1,{0x00}},                               //CODE_00_1DATA10  DBH 00,00            
{0xD8,2,{0x23,0x23}},                          //CODE_D8_2DATA10  DBH D8,23,23
//;*****************************

//;*****************************
//; sap 0.75   1line/2frame
{0x00,1,{0x80}},                               //CODE_00_1DATA11  DBH 00,80            
{0xC4,1,{0x81}},                               //CODE_C4_1DATA11  DBH C4,81;;;;;;;;;;;;;;;;;
//;*****************************

//;*****************************
//; 2to6
{0x00,1,{0xA0}},                               //CODE_00_1DATA12  DBH 00,A0            
{0xB3,1,{0x33}},                               //CODE_B3_1DATA12  DBH B3,33

{0x00,1,{0xA6}},                               //CODE_00_1DATA13  DBH 00,A6            
{0xB3,1,{0x30}},                               //CODE_B3_1DATA13  DBH B3,30
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


{0x00,1,{0xE0}},                               //CODE_00_1DATA14   DBH 00,E0            
{0xB4,10,{0x1C,0x19,0x3F,0x01,0x64,0x5C,0x01,0xA0,0x5F,0xA0}}, //CODE_B4_10DATA14  DBH B4,1C,19,3F,01,64,5C,01,A0,5F,A0

{0x00,1,{0xF0}},                               //CODE_00_1DATA15  DBH 00,F0            
{0xB4,1,{0x64}},                               //CODE_B4_1DATA15  DBH B4,64

//;*****************LTPS Timming*********************
{0x00,1,{0x80}},                               //CODE_00_1DATA88   DBH 00,80
{0xC0,14,{0x00,0x70,0x00,0x0A,0x0A,0x00,0x70,0x0A,0x0A,0x00,0x70,0x00,0x0A,0x0A}}, //CODE_C0_14DATA88  DBH C0,00,70,00,0A,0A,00,70,0A,0A,00,70,00,0A,0A

{0x00,1,{0x90}},                               //CODE_00_1DATA16  DBH 00,90            
{0xC0,6,{0x00,0x00,0x00,0x02,0x00,0x04}},                               //CODE_C0_6DATA16  DBH C0,00,00,00,02,00,04

{0x00,1,{0xA0}},                               //CODE_00_1DATA17   DBH 00,A0
{0xC0,15,{0x00,0x00,0x02,0x00,0x04,0x15,0x04,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00}}, //CODE_C0_15DATA17  DBH C0,00,00,02,00,04,15,04,00,00,11,00,00,00,11,00

{0x00,1,{0xD0}},                               //CODE_00_1DATA18   DBH 00,D0
{0xC0,15,{0x00,0x00,0x02,0x00,0x04,0x15,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_C0_15DATA18  DBH C0,00,00,02,00,04,15,04,00,00,00,00,00,00,00,00

{0x00,1,{0x80}},                               //CODE_00_1DATA19   DBH 00,80
{0xC2,12,{0x83,0x01,0x00,0x00,0x82,0x01,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_C2_12DATA19  DBH C2,83,01,00,00,82,01,00,00,00,00,00,00

{0x00,1,{0x90}},                               //CODE_00_1DATA20   DBH 00,90
{0xC2,12,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_C2_12DATA20  DBH C2,00,00,00,00,00,00,00,00,00,00,00,00

{0x00,1,{0xA0}},                               //CODE_00_1DATA21   DBH 00,A0
{0xC2,13,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_C2_13DATA21  DBH C2,00,00,00,00,00,00,00,00,00,00,00,00,00

{0x00,1,{0xB0}},                               //CODE_00_1DATA22   DBH 00,B0
{0xC2,15,{0x82,0x02,0x00,0x00,0x88,0x81,0x02,0x00,0x00,0x88,0x00,0x02,0x00,0x00,0x88}}, //CODE_C2_15DATA22  DBH C2,82,02,00,00,88,81,02,00,00,88,00,02,00,00,88

{0x00,1,{0xC0}},                               //CODE_00_1DATA23   DBH 00,C0
{0xC2,15,{0x01,0x02,0x00,0x00,0x88,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_C2_15DATA23  DBH C2,01,02,00,00,88,00,00,00,00,00,00,00,00,00,00

{0x00,1,{0xD0}},                               //CODE_00_1DATA24   DBH 00,D0
{0xC2,15,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x33,0x33,0x33,0x00}}, //CODE_C2_15DATA24  DBH C2,00,00,00,00,00,00,00,00,00,00,33,33,33,33,00

{0x00,1,{0x80}},                               //CODE_00_1DATA25   DBH 00,80
{0xC3,15,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_C3_15DATA25  DBH C3,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

{0x00,1,{0xA0}},                               //CODE_00_1DATA26   DBH 00,A0
{0xC3,12,{0x83,0x01,0x00,0x00,0x82,0x01,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_C3_12DATA26  DBH C3,83,01,00,00,82,01,00,00,00,00,00,00

{0x00,1,{0xB0}},                               //CODE_00_1DATA27   DBH 00,B0
{0xC3,14,{0x00,0x00,0x00,0x00,0x82,0x02,0x00,0x00,0x88,0x81,0x02,0x00,0x00,0x88}}, //CODE_C3_14DATA27  DBH C3,00,00,00,00,82,02,00,00,88,81,02,00,00,88

{0x00,1,{0xC0}},                               //CODE_00_1DATA28   DBH 00,C0
{0xC3,15,{0x00,0x02,0x00,0x00,0x88,0x01,0x02,0x00,0x00,0x88,0x00,0x00,0x00,0x00,0x00}}, //CODE_C3_15DATA28  DBH C3,00,02,00,00,88,01,02,00,00,88,00,00,00,00,00

{0x00,1,{0xD0}},                               //CODE_00_1DATA29   DBH 00,D0
{0xC3,15,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_C3_15DATA29  DBH C3,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

{0x00,1,{0xE0}},                               //CODE_00_1DATA30   DBH 00,E0
{0xC3,5,{0x33,0x33,0x33,0x33,0x00}},           //CODE_C3_5DATA30   DBH C3,33,33,33,33,00

{0x00,1,{0x80}},                               //CODE_00_1DATA31   DBH 00,80
{0xCB,11,{0x00,0x00,0x00,0x00,0x30,0x00,0x03,0x00,0x00,0x00,0x70}}, //CODE_CB_11DATA31  DBH CB,00,00,00,00,30,00,03,00,00,00,70

{0x00,1,{0x90}},                               //CODE_00_1DATA32   DBH 00,90
{0xCB,15,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_CB_15DATA32  DBH CB,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

{0x00,1,{0xA0}},                               //CODE_00_1DATA33   DBH 00,A0
{0xCB,15,{0x00,0x00,0x00,0xBF,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00}}, //CODE_CB_15DATA33  DBH CB,00,00,00,BF,00,00,00,00,00,FF,00,00,00,00,00

{0x00,1,{0xB0}},                               //CODE_00_1DATA34   DBH 00,B0
{0xCB,12,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x77,0x77}}, //CODE_CB_12DATA34  DBH CB,00,00,00,00,00,00,00,00,00,00,77,77

{0x00,1,{0xC0}},                               //CODE_00_1DATA35   DBH 00,C0
{0xCB,15,{0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01}}, //CODE_CB_15DATA35  DBH CB,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01

{0x00,1,{0xD0}},                               //CODE_00_1DATA36   DBH 00,D0
{0xCB,15,{0x01,0x01,0x01,0xF3,0x01,0x01,0x01,0x01,0x00,0xF3,0x00,0x00,0x01,0x00,0x01}}, //CODE_CB_15DATA36  DBH CB,01,01,01,F3,01,01,01,01,00,F3,00,00,01,00,01

{0x00,1,{0xE0}},                               //CODE_00_1DATA37   DBH 00,E0
{0xCB,12,{0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x77,0x07}}, //CODE_CB_12DATA37  DBH CB,00,01,00,01,00,01,00,01,00,00,77,07

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
{0x00,1,{0xF0}},                               //CODE_00_1DATA38   DBH 00,F0
{0xCB,11,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x03,0x33,0x03,0x00,0x70}}, //CODE_CB_11DATA38  DBH CB,FF,FF,FF,FF,FF,FF,03,33,03,00,70               ;;;;;  change
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

{0x00,1,{0x80}},                               //CODE_00_1DATA39   DBH 00,80
{0xCC,12,{0x08,0x09,0x18,0x19,0x0C,0x0D,0x0E,0x0F,0x07,0x07,0x07,0x07}}, //CODE_CC_12DATA39  DBH CC,08,09,18,19,0C,0D,0E,0F,07,07,07,07

{0x00,1,{0x90}},                               //CODE_00_1DATA40   DBH 00,90
{0xCC,12,{0x09,0x08,0x19,0x18,0x0F,0x0E,0x0D,0x0C,0x07,0x07,0x07,0x07}}, //CODE_CC_12DATA40  DBH CC,09,08,19,18,0F,0E,0D,0C,07,07,07,07

{0x00,1,{0xA0}},                               //CODE_00_1DATA41   DBH 00,A0
{0xCC,15,{0x14,0x15,0x16,0x17,0x1C,0x1D,0x1E,0x1F,0x01,0x04,0x20,0x07,0x07,0x07,0x00}}, //CODE_CC_15DATA41  DBH CC,14,15,16,17,1C,1D,1E,1F,01,04,20,07,07,07,00

{0x00,1,{0xB0}},                               //CODE_00_1DATA42   DBH 00,B0
{0xCC,9,{0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x07,0x00}}, //CODE_CC_9DATA42   DBH CC,01,02,03,04,05,06,07,07,00

{0x00,1,{0x80}},                               //CODE_00_1DATA43   DBH 00,80
{0xCD,15,{0x1A,0x01,0x11,0x12,0x1A,0x05,0x18,0x07,0x1A,0x1A,0x23,0x23,0x23,0x1F,0x1E}}, //CODE_CD_15DATA43  DBH CD,1A,01,11,12,1A,05,18,07,1A,1A,23,23,23,1F,1E

{0x00,1,{0x90}},                               //CODE_00_1DATA44   DBH 00,90
{0xCD,3,{0x1D,0x23,0x23}},                     //CODE_CD_3DATA44   DBH CD,1D,23,23

{0x00,1,{0xA0}},                               //CODE_00_1DATA45   DBH 00,A0
{0xCD,15,{0x1A,0x02,0x11,0x12,0x1A,0x06,0x18,0x08,0x1A,0x1A,0x23,0x23,0x23,0x1F,0x1E}}, //CODE_CD_15DATA45  DBH CD,1A,02,11,12,1A,06,18,08,1A,1A,23,23,23,1F,1E

{0x00,1,{0xB0}},                               //CODE_00_1DATA46   DBH 00,B0
{0xCD,3,{0x1D,0x23,0x23}},                     //CODE_CD_3DATA46   DBH CD,1D,23,23
//;**********************Touch Timming***********************************
{0x00,1,{0x80}},                               //CODE_00_1DATA47   DBH 00,80
{0xA4,10,{0xAF,0x00,0x20,0x04,0x00,0x17,0x15,0x03,0x60,0x00}}, //CODE_A4_10DATA47  DBH A4,AF,00,20,04,00,17,15,03,60,00

{0x00,1,{0x90}},                               //CODE_00_1DATA48   DBH 00,90
{0xA4,3,{0x00,0x00,0x00}},                     //CODE_A4_3DATA48   DBH A4,00,00,00

{0x00,1,{0x80}},                               //CODE_00_1DATA49   DBH 00,80
{0xA7,12,{0xFF,0x0F,0x1E,0x00,0x21,0x00,0x01,0x98,0x00,0x00,0x00,0x00}}, //CODE_A7_12DATA49  DBH A7,FF,0F,1E,00,21,00,01,98,00,00,00,00;***************20

{0x00,1,{0x90}},                               //CODE_00_1DATA50   DBH 00,90
{0xA7,10,{0x1e,0x21,0x3f,0x00,0x00,0xBE,0x90,0xCE,0x05,0xF0}}, //CODE_A7_10DATA50  DBH A7,1e,21,3f,00,00,BE,90,CE,05,F0

{0x00,1,{0xA0}},                               //CODE_00_1DATA51   DBH 00,A0
{0xA7,1,{0x30}},                               //CODE_A7_1DATA51   DBH A7,30

{0x00,1,{0xB0}},                               //CODE_00_1DATA52   DBH 00,B0
{0xA7,5,{0x01,0x20,0x1d,0x00,0x00}}, //CODE_A7_5DATA52   DBH A7,01,20,1d,00,00;01,2A,1B,00,00

{0x00,1,{0xC0}},                               //CODE_00_1DATA53   DBH 00,C0
{0xA7,12,{0xFF,0x0F,0x1E,0x00,0x1F,0x00,0x01,0x18,0x00,0x00,0x00,0x00}}, //CODE_A7_12DATA53  DBH A7,FF,0F,1E,00,1F,00,01,18,00,00,00,00

{0x00,1,{0xD0}},                               //CODE_00_1DATA54   DBH 00,D0
{0xA7,10,{0xFF,0xFF,0x1e,0x00,0x01,0x7C,0x81,0x7C,0x0B,0xE0}}, //CODE_A7_10DATA54  DBH A7,FF,FF,1e,00,01,7C,81,7C,0B,E0

{0x00,1,{0xE0}},                               //CODE_00_1DATA55   DBH 00,E0
{0xA7,1,{0x30}},                               //CODE_A7_1DATA55   DBH A7,30

{0x00,1,{0xF0}},                               //CODE_00_1DATA56   DBH 00,F0
{0xA7,5,{0x00,0x40,0x3a,0x00,0x00}},           //CODE_A7_5DATA56   DBH A7,00,40,3a,00,00

{0x00,1,{0x80}},                               //CODE_00_1DATA58   DBH 00,80
{0xA9,12,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_A9_12DATA58  DBH A9,00,00,00,00,00,00,00,00,00,00,00,00

{0x00,1,{0x90}},                               //CODE_00_1DATA59   DBH 00,90
{0xA9,10,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_A9_10DATA59  DBH A9,00,00,00,00,00,00,00,00,00,00

{0x00,1,{0xA0}},                               //CODE_00_1DATA60   DBH 00,A0
{0xA9,1,{0x00}},                               //CODE_A9_1DATA60   DBH A9,00

{0x00,1,{0xB0}},                               //CODE_00_1DATA61   DBH 00,B0
{0xA9,5,{0x00,0x00,0x00,0x00,0x00}}, //CODE_A9_5DATA61   DBH A9,00,00,00,00,00

{0x00,1,{0xC0}},                               //CODE_00_1DATA62   DBH 00,C0
{0xA9,14,{0xFF,0x3A,0x49,0x00,0x1E,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x77}}, //CODE_A9_14DATA62  DBH A9,FF,3A,49,00,1E,00,01,00,00,00,00,00,00,77

{0x00,1,{0xD0}},                               //CODE_00_1DATA63   DBH 00,D0
{0xA9,10,{0xFF,0xFF,0x1D,0x00,0x01,0x7C,0x81,0x7C,0x0B,0xE0}}, //CODE_A9_10DATA63  DBH A9,FF,FF,1D,00,01,7C,81,7C,0B,E0

{0x00,1,{0xE0}},                               //CODE_00_1DATA64   DBH 00,E0
{0xA9,1,{0x30}},                               //CODE_A9_1DATA64   DBH A9,30

{0x00,1,{0xF0}},                               //CODE_00_1DATA65   DBH 00,F0
{0xA9,5,{0x00,0x3C,0x3C,0x00,0x00}}, //CODE_A9_5DATA65   DBH A9,00,3C,3C,00,00

{0x00,1,{0xB0}},                               //CODE_00_1DATA66   DBH 00,B0
{0xA4,8,{0x05,0xF0,0x0B,0xE0,0x00,0x00,0x0B,0xE0}}, //CODE_A4_8DATA66   DBH A4,05,F0,0B,E0,00,00,0B,E0

{0x00,1,{0x80}},                               //CODE_00_1DATA67   DBH 00,80
{0xAB,15,{0x05,0x14,0x00,0x00,0xFF,0x6A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_AB_15DATA67  DBH AB,05,14,00,00,FF,6A,00,00,00,00,00,00,00,00,00

{0x00,1,{0xA0}},                               //CODE_00_1DATA68   DBH 00,A0
{0xAB,15,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x01,0x00,0x00}}, //CODE_AB_15DATA68  DBH AB,00,00,00,00,00,00,00,07,00,00,00,00,01,00,00

{0x00,1,{0xB0}},                               //CODE_00_1DATA69   DBH 00,B0
{0xAB,12,{0x00,0x00,0x68,0x0A,0x00,0x00,0x44,0x04,0x00,0x00,0x00,0x00}}, //CODE_AB_12DATA69  DBH AB,00,00,68,0A,00,00,44,04,00,00,00,00

{0x00,1,{0x93}},                               //CODE_00_1DATA70   DBH 00,93
{0xB3,1,{0x01}},                               //CODE_B3_1DATA70   DBH B3,01

{0x00,1,{0x80}},                               //CODE_00_1DATA71   DBH 00,80   
{0xCE,7,{0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_CE_7DATA71   DBH CE,00,00,00,00,00,00,00  

{0x00,1,{0x87}},                               //CODE_00_1DATA72   DBH 00,87  
{0xCE,7,{0x00,0x00,0x33,0x00,0x33,0x00,0x00}}, //CODE_CE_7DATA72   DBH CE,00,00,33,00,33,00,00

{0x00,1,{0xF0}},                               //CODE_00_1DATA73   DBH 00,F0  
{0xCE,4,{0x00,0x00,0x00,0x00}},                //CODE_CE_4DATA73   DBH CE,00,00,00,00
   
{0x00,1,{0x90}},                               //CODE_00_1DATA74   DBH 00,90  
{0xCE,15,{0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0x00,0xFC,0x00,0xFC,0x00,0x00,0x00,0x00}}, //CODE_CE_15DATA74  DBH CE,00,00,00,F0,00,00,00,00,FC,00,FC,00,00,00,00

{0x00,1,{0xA0}},                               //CODE_00_1DATA75   DBH 00,A0   
{0xCE,7,{0x00,0x00,0x40,0x40,0x40,0x00,0x00}}, //CODE_CE_7DATA75   DBH CE,00,00,40,40,40,00,00  

{0x00,1,{0xB0}},                               //CODE_00_1DATA76   DBH 00,B0  
{0xCE,15,{0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xF1,0x01,0xF1,0x01,0x01,0x01,0x01}}, //CODE_CE_15DATA76  DBH CE,01,01,01,01,01,01,01,01,F1,01,F1,01,01,01,01  

{0x00,1,{0xC0}},                               //CODE_00_1DATA77   DBH 00,C0   
{0xCE,7,{0x01,0x01,0x01,0x01,0x01,0x01,0x01}}, //CODE_CE_7DATA77   DBH CE,01,01,01,01,01,01,01  

{0x00,1,{0xD0}},                               //CODE_00_1DATA78   DBH 00,D0   
{0xCE,15,{0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0xF7,0x04,0xF7,0x04,0x04,0x00,0x00}}, //CODE_CE_15DATA78  DBH CE,04,04,04,04,04,04,04,04,F7,04,F7,04,04,00,00

{0x00,1,{0xE0}},                               //CODE_00_1DATA79   DBH 00,E0   
{0xCE,7,{0x00,0x00,0x15,0x15,0x15,0x04,0x04}}, //CODE_CE_7DATA79   DBH CE,00,00,15,15,15,04,04

{0x00,1,{0xF4}},                               //CODE_00_1DATA80   DBH 00,F4   
{0xCE,1,{0x25}},                               //CODE_CE_1DATA80   DBH CE,25



//;//==========CE Setting===========//

{0x00,1,{0xA0}},                               //CODE_00_1DATA120   DBH 00,A0
{0xD6,12,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}}, //CODE_D6_1DATA120   DBH D6,00,00,00,00,00,00,00,00,00,00,00,00

{0x00,1,{0xB0}},                               //CODE_00_1DATA121   DBH 00,B0
{0xD6,12,{0xfd,0xfd,0xfd,0xfd,0xfd,0xfd,0xfd,0xfd,0xfd,0xfd,0xfd,0xfd}}, //CODE_D6_1DATA121   DBH D6,fd,fd,fd,fd,fd,fd,fd,fd,fd,fd,fd,fd;H


{0x00,1,{0xC0}},                               //CODE_00_1DATA122   DBH 00,C0
{0xD6,12,{0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9}}, //CODE_D6_1DATA122   DBH D6,a9,a9,a9,a9,a9,a9,a9,a9,a9,a9,a9,a9;H


{0x00,1,{0xD0}},                               //CODE_00_1DATA123   DBH 00,D0
{0xD6,12,{0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x54,0x54}}, //CODE_D6_1DATA123   DBH D6,54,54,54,54,54,54,54,54,54,54,54,54;H

//;//=============================//


{0x00,1,{0x00}},                               //CODE_00_1DATA124  DBH 00,00
{0x81,1,{0x81}},                               //CODE_81_1DATA124  DBH 81,81

//{0x00,1,{0x00}},                               //CODE_00_1DATA99   DBH 00,00  
//{0xFB,1,{0x01}},                               //CODE_FB_1DATA99   DBH FB,01

//{0x00,1,{0x80}},                               //CODE_00_1DATA81   DBH 00,80   
//{0xFF,2,{0x00},0x00},                          //CODE_FF_2DATA81   DBH FF,00,00

//{0x00,1,{0x00}},                               //CODE_00_1DATA82   DBH 00,00  
//{0xFF,3,{0x00,0x00,0x00}},                     //CODE_FF_3DATA82   DBH FF,00,00,00
					     
//; ***********************************
//{0x11,0,{}},                                   //CODE_11_0DATA83   DBH 11
//{0x10,0,{}},                                   //CODE_10_0DATA85   DBH 10  
//;*********************************

//{0x00,1,{0x00}},                               //CODE_00_1DATA111   DBH 00,00
//{0x15,1,{0x01}},                               //CODE_15_1DATA111   DBH 15,01


//{0x00,1,{0x00}},                               //CODE_00_1DATA112   DBH 00,00
//{0xA1,1,{0x05}},                               //CODE_A1_1DATA112   DBH A1,05

//{0x00,1,{0x00}},                               //CODE_00_1DATA113   DBH 00,00
//{0x16,1,{0x04}},                               //CODE_16_1DATA113   DBH 16,04


//{0x00,1,{0x00}},                               //CODE_00_1DATA100  DBH 00,00
//{0xEB,1,{0x01}},                               //CODE_EB_1DATA100  DBH EB,01


//{0x00,1,{0x00}},                               //CODE_00_1DATA101  DBH 00,00
//{0xEB,1,{0x03}},                               //CODE_EB_1DATA101  DBH EB,03

//{0x00,1,{0x82}},                               //CODE_00_1DATA102  DBH 00,82
//{0xF6,1,{0x5A}},                               //CODE_F6_1DATA102  DBH F6,5A

//{0x00,1,{0x00}},                               //CODE_00_1DATA103  DBH 00,00
//{0xEB,3,{0x03,0x5A,0xA5}},                     //CODE_EB_3DATA103  DBH EB,03,5A,A5

//{0x00,1,{0x00}},                               //CODE_00_1DATA104  DBH 00,00
//{0xEB,3,{0x00,0x00,0x00}},                     //CODE_EB_3DATA104  DBH EB,00,00,00
 
//{0x29,0,{}},                                   //CODE_29_0DATA84   DBH 29
//{0x28,0,{}},                                   //CODE_28_0DATA86   DBH 28 


//{0x00,1,{0x00}},                               //CODE_0F_1DATA156   DBH 00,00    
//{0x0F,1,{0x01}},                               //CODE_0F_1DATA157   DBH 0F,01
//;**********************************
//;write user id   BB CC DD
//{0x00,1,{0x00}},                               //CODE_00_1DATA105   DBH 00,00     
//{0xD0,1,{0xBB}},                               //CODE_D000_1DATA1   DBH D0,BB

//{0x00,1,{0x00}},                               //CODE_00_1DATA109   DBH 00,00   
//{0xD1,1,{0xCC}},                               //CODE_D100_1DATA1   DBH D1,CC

//{0x00,1,{0x01}},                               //CODE_00_1DATA110   DBH 00,01   
//{0xD1,1,{0xDD}},                               //CODE_D101_1DATA1   DBH D1,DD
//;**********************************

//;**********************************
//;READ user id   BB CC DD
//{0xDA,0,{}},                                   //CODE_DA_1DATA0   DBH DA 
//{0xDB,0,{}},                                   //CODE_DB_1DATA0   DBH DB 
//{0xDC,0,{}},                                   //CODE_DC_1DATA0   DBH DC
//;**********************************

//{0xDA,1,{0x00}},                               //CODE_DA_1DATA106   DBH DA,00
//{0xDB,1,{0x00}},                               //CODE_DB_1DATA107   DBH DB,00
//{0xDC,1,{0x00}},                               //CODE_DC_1DATA108   DBH DC,00

{0x00,1,{0x00}},                               //CODE_e100_1DATA    DBH 00,00                                 
{0xE1,24,{0x00,0x04,0x09,0x15,0x1d,0x25,0x30,0x44,0x51,0x62,0x6f,0x78,0x80,0x79,0x6f,0x5d,0x49,0x37,0x28,0x20,0x1c,0x17,0x15,0x00}}, //CODE_e100_24DATA   DBH e1,00,04,09,15,1d,25,30,44,51,62,6f,78,80,79,6f,5d,49,37,28,20,1c,17,15,00

{0x00,1,{0x00}},                               //CODE_e200_1DATA    DBH 00,00   
{0xE2,24,{0x00,0x04,0x09,0x15,0x1d,0x25,0x30,0x44,0x51,0x62,0x6f,0x78,0x80,0x79,0x6f,0x5d,0x49,0x37,0x28,0x20,0x1c,0x17,0x15,0x00}}, //CODE_e200_24DATA   DBH e2,00,04,09,15,1d,25,30,44,51,62,6f,78,80,79,6f,5d,49,37,28,20,1c,17,15,00

{0x00,1,{0x00}},                               //CODE_e300_1DATA   DBH 00,00   
{0xE3,24,{0x00,0x04,0x09,0x15,0x1d,0x25,0x30,0x44,0x51,0x62,0x6f,0x78,0x80,0x79,0x6f,0x5d,0x49,0x37,0x28,0x20,0x1c,0x17,0x15,0x00}}, //CODE_e300_24DATA   DBH e3,00,04,09,15,1d,25,30,44,51,62,6f,78,80,79,6f,5d,49,37,28,20,1c,17,15,00

{0x00,1,{0x00}},                               //CODE_e400_1DATA    DBH 00,00   
{0xE4,24,{0x00,0x04,0x09,0x15,0x1d,0x25,0x30,0x44,0x51,0x62,0x6f,0x78,0x80,0x79,0x6f,0x5d,0x49,0x37,0x28,0x20,0x1c,0x17,0x15,0x00}}, //CODE_e400_24DATA   DBH e4,00,04,09,15,1d,25,30,44,51,62,6f,78,80,79,6f,5d,49,37,28,20,1c,17,15,00

{0x00,1,{0x00}},                               //CODE_e500_1DATA    DBH 00,00   
{0xE5,24,{0x00,0x04,0x09,0x15,0x1d,0x25,0x30,0x44,0x51,0x62,0x6f,0x78,0x80,0x79,0x6f,0x5d,0x49,0x37,0x28,0x20,0x1c,0x17,0x15,0x00}}, //CODE_e500_24DATA   DBH e5,00,04,09,15,1d,25,30,44,51,62,6f,78,80,79,6f,5d,49,37,28,20,1c,17,15,00

{0x00,1,{0x00}},                               //CODE_e600_1DATA    DBH 00,00   
{0xE6,24,{0x00,0x04,0x09,0x15,0x1d,0x25,0x30,0x44,0x51,0x62,0x6f,0x78,0x80,0x79,0x6f,0x5d,0x49,0x37,0x28,0x20,0x1c,0x17,0x15,0x00}}, //CODE_e600_24DATA   DBH e6,00,04,09,15,1d,25,30,44,51,62,6f,78,80,79,6f,5d,49,37,28,20,1c,17,15,00
//{0x00,1,{0x90}},
//{0xA6,8,{0x12,0x34,0x56,0x78,0x9a,0xbc,0xd0,0x00}},
//{0x00,1,{0x81}},        
//{0xA6,2,{0xad,0x01}},
//{0x00,1,{0x80}},
//{0xA6,1,{0xA5}},
	//{0x51,1,{0xFF}},
{0x00,1,{0x80}},                               //CODE_00_1DATA5   DBH 00,80   
{0xC1,2,{0x77,0x77}},                          //CODE_C1_2DATA5   DBH C1,55,55  
{0x00,1,{0x81}},  //wangyq13 change for 60fps
{0xC0,1,{0x78}},

        {0x44,2,{0x03,0x80}},
        {0x53,1,{0x24}},
	{0x35,1,{0x00}},
	{0x11,0,{}},    // Sleep out 
	{REGFLAG_DELAY, 130, {}},

	{0x29,0,{}},    // Display on
	{REGFLAG_END_OF_TABLE, 0x00, {}}
};

static struct LCM_setting_table lcm_backlight_level_setting[] = {
    {0x51, 1, {0xFF}},
    {REGFLAG_END_OF_TABLE, 0x00, {}}
};

static void push_table(struct LCM_setting_table *table, unsigned int count, unsigned char force_update)
{
    unsigned int i;
    for(i = 0; i < count; i++)
    {
        unsigned cmd;
        cmd = table[i].cmd;

        switch (cmd) {

            case REGFLAG_DELAY :
                if(table[i].count <= 10)
                    MDELAY(table[i].count);
                else
                    MDELAY(table[i].count);
                break;
				
			case REGFLAG_UDELAY :
				UDELAY(table[i].count);
				break;

            case REGFLAG_END_OF_TABLE :
                break;

            default:
                dsi_set_cmdq_V2(cmd, table[i].count, table[i].para_list, force_update);
        }
    }
}

//wangyq13 add for push table handle
static void push_table_cmdq(void* handle, struct LCM_setting_table *table, unsigned int count, unsigned char force_update)
{
    unsigned int i;
    for(i = 0; i < count; i++)
    {
        unsigned cmd;
        cmd = table[i].cmd;

        switch (cmd) {

            case REGFLAG_DELAY :
                if(table[i].count <= 10)
                    MDELAY(table[i].count);
                else
                    MDELAY(table[i].count);
                break;
				
			case REGFLAG_UDELAY :
				UDELAY(table[i].count);
				break;

            case REGFLAG_END_OF_TABLE :
                break;

            default:
                dsi_set_cmdq_V22(handle, cmd, table[i].count, table[i].para_list, force_update);
        }
    }
}

// ---------------------------------------------------------------------------
//  LCM Driver Implementations
// ---------------------------------------------------------------------------

static void lcm_set_util_funcs(const LCM_UTIL_FUNCS *util)
{
    memcpy(&lcm_util, util, sizeof(LCM_UTIL_FUNCS));
}

static void lcm_get_params(LCM_PARAMS *params)
{
	memset(params, 0, sizeof(LCM_PARAMS));

	params->type   = LCM_TYPE_DSI;

	params->width  = FRAME_WIDTH;
	params->height = FRAME_HEIGHT;

#if (LCM_DSI_CMD_MODE)
	params->dsi.mode   = CMD_MODE;
	params->dsi.switch_mode = SYNC_PULSE_VDO_MODE;
#else
    params->dsi.mode   = SYNC_PULSE_VDO_MODE;
	params->dsi.switch_mode = CMD_MODE;
#endif
	params->dsi.switch_mode_enable = 0;

	// DSI
	/* Command mode setting */
	params->dsi.LANE_NUM				    = LCM_FOUR_LANE;
	//The following defined the fomat for data coming from LCD engine.
	params->dsi.data_format.color_order 	= LCM_COLOR_ORDER_RGB;
	params->dsi.data_format.trans_seq   	= LCM_DSI_TRANS_SEQ_MSB_FIRST;
	params->dsi.data_format.padding     	= LCM_DSI_PADDING_ON_LSB;
	params->dsi.data_format.format          = LCM_DSI_FORMAT_RGB888;

	// Highly depends on LCD driver capability.
	params->dsi.packet_size=256;

#if (LCM_DSI_CMD_MODE)
//	params->dsi.packet_size_mult=4;
#endif
	//video mode timing

	params->dsi.PS=LCM_PACKED_PS_24BIT_RGB888;

	params->dsi.vertical_sync_active				= 2;
	params->dsi.vertical_backporch					= 8;
	params->dsi.vertical_frontporch					= 10;
	params->dsi.vertical_active_line				= FRAME_HEIGHT;

	params->dsi.horizontal_sync_active				= 10;
	params->dsi.horizontal_backporch				= 20;
	params->dsi.horizontal_frontporch				= 40;
	
	params->dsi.horizontal_active_pixel				= FRAME_WIDTH;

    /*command mode clock*/
#if (LCM_DSI_CMD_MODE)
//#if (defined UFO_ON_3X_60) || (defined UFO_ON_3X_120)
//    params->dsi.PLL_CLOCK = 150;//260;
//#else
    params->dsi.PLL_CLOCK = 440; //this value must be in MTK suggested table
//#endif
#endif

    /*video mode clock*/
/*#if (!LCM_DSI_CMD_MODE)
#if (defined UFO_ON_3X_60) || (defined UFO_ON_3X_120)
    params->dsi.PLL_CLOCK = 380;
#else
    params->dsi.PLL_CLOCK = 450; //this value must be in MTK suggested table
#endif
#endif*/

//#if (defined UFO_ON_3X_60) || (defined UFO_ON_3X_120)
//	params->dsi.ufoe_enable = 1;
//	params->dsi.ufoe_params.compress_ratio = 3;
//	params->dsi.ufoe_params.vlc_disable = 0;
//	params->dsi.horizontal_active_pixel	= FRAME_WIDTH/3;
//#endif
	params->dsi.cont_clock = 0;
	params->dsi.clk_lp_per_line_enable = 1;
	params->dsi.esd_check_enable = 1;
	params->dsi.customization_esd_check_enable = 0;
	params->dsi.lcm_esd_check_table[0].cmd          = 0x53;
	params->dsi.lcm_esd_check_table[0].count        = 1;
	params->dsi.lcm_esd_check_table[0].para_list[0] = 0x24;

//	params->dsi.lane_swap_en = 1;

//	params->dsi.lane_swap[MIPITX_PHY_PORT_0][MIPITX_PHY_LANE_0] 	= MIPITX_PHY_LANE_0;
//	params->dsi.lane_swap[MIPITX_PHY_PORT_0][MIPITX_PHY_LANE_1] 	= MIPITX_PHY_LANE_3;
//	params->dsi.lane_swap[MIPITX_PHY_PORT_0][MIPITX_PHY_LANE_2] 	= MIPITX_PHY_LANE_2;
//	params->dsi.lane_swap[MIPITX_PHY_PORT_0][MIPITX_PHY_LANE_3] 	= MIPITX_PHY_LANE_1;
//	params->dsi.lane_swap[MIPITX_PHY_PORT_0][MIPITX_PHY_LANE_CK] 	= MIPITX_PHY_LANE_CK;
//	params->dsi.lane_swap[MIPITX_PHY_PORT_0][MIPITX_PHY_LANE_RX] 	= MIPITX_PHY_LANE_0;

	//params->od_table_size = 33 * 33;
	//params->od_table = (void*)&od_table_33x33;
}

static void lcm_init_power(void)
{
#ifdef BUILD_LK
	//mt6331_upmu_set_rg_vgp1_en(1);
#else
	printk("%s, begin\n", __func__);
	//hwPowerOn(MT6331_POWER_LDO_VGP1, VOL_DEFAULT, "LCM_DRV");	
	printk("%s, end\n", __func__);
#endif
}

static void lcm_suspend_power(void)
{
#ifdef BUILD_LK
	//mt6331_upmu_set_rg_vgp1_en(0);
#else
	printk("%s, begin\n", __func__);
	//hwPowerDown(MT6331_POWER_LDO_VGP1, "LCM_DRV");	
	printk("%s, end\n", __func__);
#endif

}

static void lcm_resume_power(void)
{
#ifdef BUILD_LK
	//mt6331_upmu_set_rg_vgp1_en(1);
#else
	printk("%s, begin\n", __func__);
	//hwPowerOn(MT6331_POWER_LDO_VGP1, VOL_DEFAULT, "LCM_DRV");	
	printk("%s, end\n", __func__);
#endif
}

static void lcm_init(void)
{
	unsigned char cmd = 0x0;
	unsigned char data = 0xFF;
	int ret=0;
	cmd=0x00;
	data=0x0F;

	mt_set_gpio_mode(GPIO_LCM_LED_EN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCM_LED_EN, GPIO_DIR_OUT);

	mt_set_gpio_mode(GPIO_LCD_BIAS_ENP_PIN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCD_BIAS_ENP_PIN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCD_BIAS_ENP_PIN, GPIO_OUT_ONE);

	mt_set_gpio_mode(GPIO_LCD_BIAS_ENN_PIN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCD_BIAS_ENN_PIN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCD_BIAS_ENN_PIN, GPIO_OUT_ONE);

    MDELAY(5);

#ifdef BUILD_LK
	ret=TPS65132_write_byte(cmd,data);
    if(ret)    	
    dprintf(0, "[LK]nt35595----tps6132----cmd=%0x--i2c write error----\n",cmd);    	
	else
	dprintf(0, "[LK]nt35595----tps6132----cmd=%0x--i2c write success----\n",cmd);    		
#else
	ret=tps65132_write_bytes(cmd,data);
	if(ret<0)
	printk("[KERNEL]nt35595----tps6132---cmd=%0x-- i2c write error-----\n",cmd);
	else
	printk("[KERNEL]nt35595----tps6132---cmd=%0x-- i2c write success-----\n",cmd);
#endif

	cmd=0x01;
	data=0x0F;
#ifdef BUILD_LK
	ret=TPS65132_write_byte(cmd,data);
    if(ret)    	
	    dprintf(0, "[LK]nt35595----tps6132----cmd=%0x--i2c write error----\n",cmd);    	
	else
		dprintf(0, "[LK]nt35595----tps6132----cmd=%0x--i2c write success----\n",cmd);   
#else
	ret=tps65132_write_bytes(cmd,data);
	if(ret<0)
	printk("[KERNEL]nt35595----tps6132---cmd=%0x-- i2c write error-----\n",cmd);
	else
	printk("[KERNEL]nt35595----tps6132---cmd=%0x-- i2c write success-----\n",cmd);
#endif
	SET_RESET_PIN(1);
	MDELAY(1);
	SET_RESET_PIN(0);
	MDELAY(10);
	SET_RESET_PIN(1);
	MDELAY(10);

#ifdef  UFO_ON_3X_120
    lcm_fps  = 120;
#else
    lcm_fps  = 60;
#endif
	 push_table(lcm_initialization_setting, sizeof(lcm_initialization_setting) / sizeof(struct LCM_setting_table), 1);

         mt_set_gpio_out(GPIO_LCM_LED_EN, GPIO_OUT_ONE);
}

static void lcm_suspend(void)
{
       mt_set_gpio_out(GPIO_LCM_LED_EN, GPIO_OUT_ZERO);
	   
	mt_set_gpio_mode(GPIO_LCD_BIAS_ENN_PIN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCD_BIAS_ENN_PIN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCD_BIAS_ENN_PIN, GPIO_OUT_ZERO);

	mt_set_gpio_mode(GPIO_LCD_BIAS_ENP_PIN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCD_BIAS_ENP_PIN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCD_BIAS_ENP_PIN, GPIO_OUT_ZERO);

	push_table(lcm_suspend_setting, sizeof(lcm_suspend_setting) / sizeof(struct LCM_setting_table), 1);  
	SET_RESET_PIN(0);
	MDELAY(10);
}

static void lcm_resume(void)
{
	lcm_init(); 
}

static void lcm_update(unsigned int x, unsigned int y, unsigned int width, unsigned int height)
{
	unsigned int x0 = x;
	unsigned int y0 = y;
	unsigned int x1 = x0 + width - 1;
	unsigned int y1 = y0 + height - 1;

	unsigned char x0_MSB = ((x0>>8)&0xFF);
	unsigned char x0_LSB = (x0&0xFF);
	unsigned char x1_MSB = ((x1>>8)&0xFF);
	unsigned char x1_LSB = (x1&0xFF);
	unsigned char y0_MSB = ((y0>>8)&0xFF);
	unsigned char y0_LSB = (y0&0xFF);
	unsigned char y1_MSB = ((y1>>8)&0xFF);
	unsigned char y1_LSB = (y1&0xFF);

	unsigned int data_array[16];

	data_array[0]= 0x00053902;
	data_array[1]= (x1_MSB<<24)|(x0_LSB<<16)|(x0_MSB<<8)|0x2a;
	data_array[2]= (x1_LSB);
	dsi_set_cmdq(data_array, 3, 1);
	
	data_array[0]= 0x00053902;
	data_array[1]= (y1_MSB<<24)|(y0_LSB<<16)|(y0_MSB<<8)|0x2b;
	data_array[2]= (y1_LSB);
	dsi_set_cmdq(data_array, 3, 1);
	
	data_array[0]= 0x002c3909;
	dsi_set_cmdq(data_array, 1, 0);	
}

#define LCM_OTM1906B_ID_ADD  (0xDA)
#define LCM_OTM1906B_ID     (0x40)

#define GPIO_LCD_ID (GPIO130 |0x80000000)
static unsigned int lcm_compare_id(void)
{
	return 1;
}

// return TRUE: need recovery
// return FALSE: No need recovery

static unsigned int lcm_esd_check(void)
{
#ifndef BUILD_LK
	char  buffer[3];
	int   array[4];

	array[0] = 0x00013700;
	dsi_set_cmdq(array, 1, 1);

	read_reg_v2(0x53, buffer, 1);

	if(buffer[0] != 0x24)
	{
		printk("[LCM ERROR] [0x53]=0x%02x\n", buffer[0]);
		return TRUE;
	}
	else
	{
		printk("[LCM NORMAL] [0x53]=0x%02x\n", buffer[0]);
		return FALSE;
	}
#else
	return FALSE;
#endif

}

static unsigned int lcm_ata_check(unsigned char *buffer)
{
#ifndef BUILD_LK
	unsigned int ret = 0;
	unsigned int x0 = FRAME_WIDTH/4;
	unsigned int x1 = FRAME_WIDTH*3/4;

	unsigned char x0_MSB = ((x0>>8)&0xFF);
	unsigned char x0_LSB = (x0&0xFF);
	unsigned char x1_MSB = ((x1>>8)&0xFF);
	unsigned char x1_LSB = (x1&0xFF);

	unsigned int data_array[3];
	unsigned char read_buf[4];
	printk("ATA check size = 0x%x,0x%x,0x%x,0x%x\n",x0_MSB,x0_LSB,x1_MSB,x1_LSB);
	data_array[0]= 0x0005390A;//HS packet
	data_array[1]= (x1_MSB<<24)|(x0_LSB<<16)|(x0_MSB<<8)|0x2a;
	data_array[2]= (x1_LSB);
	dsi_set_cmdq(data_array, 3, 1);

	data_array[0] = 0x00043700;// read id return two byte,version and id
	dsi_set_cmdq(data_array, 1, 1);
	
	read_reg_v2(0x2A, read_buf, 4);

	if((read_buf[0] == x0_MSB) && (read_buf[1] == x0_LSB) 
		&& (read_buf[2] == x1_MSB) && (read_buf[3] == x1_LSB))
		ret = 1;
	else
		ret = 0;

	x0 = 0;
	x1 = FRAME_WIDTH - 1;

	x0_MSB = ((x0>>8)&0xFF);
	x0_LSB = (x0&0xFF);
	x1_MSB = ((x1>>8)&0xFF);
	x1_LSB = (x1&0xFF);

	data_array[0]= 0x0005390A;//HS packet
	data_array[1]= (x1_MSB<<24)|(x0_LSB<<16)|(x0_MSB<<8)|0x2a;
	data_array[2]= (x1_LSB);
	dsi_set_cmdq(data_array, 3, 1);
	return ret;
#else
	return 0;
#endif
}

static void lcm_setbacklight(unsigned int level)
{
#ifdef BUILD_LK
	dprintf(0,"%s,lk nt35595 backlight: level = %d\n", __func__, level);
#else
	printk("%s, kernel nt35595 backlight: level = %d\n", __func__, level);
#endif
	// Refresh value of backlight level.
	lcm_backlight_level_setting[0].para_list[0] = level;
	
	push_table(lcm_backlight_level_setting, sizeof(lcm_backlight_level_setting) / sizeof(struct LCM_setting_table), 1);

}

static void lcm_setbacklight_cmdq(void *handle, unsigned int level)
{
#ifdef BUILD_LK
	dprintf(0,"%s,lk nt35595 backlight: level = %d\n", __func__, level);
#else
	printk("%s, kernel nt35595 backlight: level = %d\n", __func__, level);
#endif
	// Refresh value of backlight level.
	lcm_backlight_level_setting[0].para_list[0] = level;
	
	push_table_cmdq(handle, lcm_backlight_level_setting, sizeof(lcm_backlight_level_setting) / sizeof(struct LCM_setting_table), 1);

}

static void* lcm_switch_mode(int mode)
{
#ifndef BUILD_LK
//customization: 1. V2C config 2 values, C2V config 1 value; 2. config mode control register
	if(mode == 0)
	{//V2C
		lcm_switch_mode_cmd.mode = CMD_MODE;
		lcm_switch_mode_cmd.addr = 0xBB;// mode control addr
		lcm_switch_mode_cmd.val[0]= 0x13;//enabel GRAM firstly, ensure writing one frame to GRAM
		lcm_switch_mode_cmd.val[1]= 0x10;//disable video mode secondly
	}
	else
	{//C2V
		lcm_switch_mode_cmd.mode = SYNC_PULSE_VDO_MODE;
		lcm_switch_mode_cmd.addr = 0xBB;
		lcm_switch_mode_cmd.val[0]= 0x03;//disable GRAM and enable video mode
	}
	return (void*)(&lcm_switch_mode_cmd);
#else
	return NULL;
#endif
}

static void lcm_send_60hz(void * cmdq)
{
    unsigned int array[]={
        0x00001500,
        0x00042902,
        0x010619FF,
        0x80001500,
        0x00032902,
        0x000619FF,
        0x80001500,
        0x000F2902,
        0x077400C0,
        0x74000fb0,
        0x74000602,
        0x000fb007,
        0x00001500,
        0x01FB2300,
        0x80001500,
        0x00032902,
        0x000000FF,
        0x00001500,
        0x00042902,
        0x000000FF
    };
    dsi_set_cmdq_V11(cmdq, array, sizeof(array)/sizeof(unsigned int),1);
    return;
    
}


static void lcm_send_120hz(void * cmdq)
{
    unsigned int array[]={
        0x00001500,
        0x00042902,
        0x010619FF,
        0x80001500,
        0x00032902,
        0x000619FF,
        0x80001500,
        0x000F2902,
        0x007400C0,
        0x74000602,
        0x74000602,
        0x00060200,
        0x00001500,
        0x01FB2300,
        0x80001500,
        0x00032902,
        0x000000FF,
        0x00001500,
        0x00042902,
        0x000000FF
    };
    dsi_set_cmdq_V11(cmdq, array, sizeof(array)/sizeof(unsigned int),1);
    return;
    
}

static int lcm_adjust_fps(void * cmdq, int fps)
{

#ifdef BUILD_LK
    dprintf(0,"%s:from %d to %d\n", __func__, lcm_fps, fps);
#else
    printk("%s:from %d to %d\n", __func__, lcm_fps, fps);
#endif

    if(lcm_fps == fps)
        return 0;

    if(fps == 60)
    {
        lcm_fps = 60;
	    //push_table(cmdq, lcm_60fps_setting, sizeof(lcm_60fps_setting) / sizeof(struct LCM_setting_table), 1);
	    lcm_send_60hz(cmdq);
    }
    else if(fps == 120)
    {
        lcm_fps = 120;
	    //push_table(cmdq, lcm_120fps_setting, sizeof(lcm_120fps_setting) / sizeof(struct LCM_setting_table), 1);
        lcm_send_120hz(cmdq);
    }
    else
    {
       return -1;
        
    }
    return 0;

}


LCM_DRIVER otm1906c_fhd_dsi_cmd_boe_lcm_drv=
{
    .name           	= "otm1906c_fhd_dsi_cmd_boe",
    .set_util_funcs 	= lcm_set_util_funcs,
    .get_params     	= lcm_get_params,
    .init           	= lcm_init,
    .suspend        	= lcm_suspend,
    .resume         	= lcm_resume,
     .compare_id     	= lcm_compare_id,
     .init_power		= lcm_init_power,
     .resume_power      = lcm_resume_power,
     .suspend_power     = lcm_suspend_power,
#if (defined UFO_ON_3X_60) || (defined UFO_ON_3X_120)
     .adjust_fps        = lcm_adjust_fps,
#endif
     .esd_check         = lcm_esd_check,
     .set_backlight     = lcm_setbacklight,
     .set_backlight_cmdq     = lcm_setbacklight_cmdq,
	 .ata_check		    = lcm_ata_check,
	 .update            = lcm_update,
     .switch_mode		= lcm_switch_mode,
};

