#ifndef _CUST_BATTERY_METER_TABLE_H
#define _CUST_BATTERY_METER_TABLE_H

#include <mach/mt_typedefs.h>

/* ============================================================*/
/* define*/
/* ============================================================*/
#define BAT_NTC_10 1
#define BAT_NTC_47 0

#if (BAT_NTC_10 == 1)
#define RBAT_PULL_UP_R	24000
#endif

#if (BAT_NTC_47 == 1)
#define RBAT_PULL_UP_R	61900
#endif

#define RBAT_PULL_UP_VOLT	2800



/* ============================================================*/
/* ENUM*/
/* ============================================================*/

/* ============================================================*/
/* structure*/
/* ============================================================*/

/* ============================================================*/
/* typedef*/
/* ============================================================*/
typedef struct _BATTERY_PROFILE_STRUCT
{
	kal_int32 percentage;
	kal_int32 voltage;
} BATTERY_PROFILE_STRUCT, *BATTERY_PROFILE_STRUCT_P;

typedef struct _R_PROFILE_STRUCT
{
	kal_int32 resistance; /* Ohm*/
	kal_int32 voltage;
} R_PROFILE_STRUCT, *R_PROFILE_STRUCT_P;

typedef enum
{
	T1_0C,
	T2_25C,
	T3_50C
} PROFILE_TEMPERATURE;

/* ============================================================*/
/* External Variables*/
/* ============================================================*/

/* ============================================================*/
/* External function*/
/* ============================================================*/

/* ============================================================*/
/* <DOD, Battery_Voltage> Table*/
/* ============================================================*/
#if (BAT_NTC_10 == 1)
/*lenovo-sw mahj2 update NTC param Begin*/
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
		{-20, 67790},
		{-15, 53460},
		{-10, 42450},
		{-5, 33930},
		{0, 27280},
		{5, 22070},
		{10, 17960},
		{15, 14700},
		{20, 12090},
		{25, 10000},
		{30, 8312},
		{35, 6942},
		{40, 5826},
		{45, 4911},
		{50, 4158},
		{55, 3536},
		{60, 3019}
	};
/*lenovo-sw mahj2 update NTC param End*/
#endif

#if (BAT_NTC_47 == 1)
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
		{-20, 483954},
		{-15, 360850},
		{-10, 271697},
		{ -5, 206463},
		{  0, 158214},
		{  5, 122259},
		{ 10, 95227},
		{ 15, 74730},
		{ 20, 59065},
		{ 25, 47000},
		{ 30, 37643},
		{ 35, 30334},
		{ 40, 24591},
		{ 45, 20048},
		{ 50, 16433},
		{ 55, 13539},
		{ 60, 11210}
	};
#endif
/*lenovo-sw mahj2 update ZCV param Begin*/
/* T0 -10C*/
BATTERY_PROFILE_STRUCT battery_profile_t0[] = 
{
	{0,4406},
	{2,4380},
	{4,4369},
	{5,4358},
	{7,4337},
	{9,4326},
	{11,4316},
	{12,4297},
	{14,4288},
	{16,4280},
	{18,4263},
	{20,4255},
	{21,4247},
	{23,4230},
	{25,4222},
	{27,4214},
	{28,4199},
	{30,4192},
	{32,4184},
	{34,4168},
	{36,4153},
	{37,4145},
	{39,4137},
	{41,4121},
	{43,4114},
	{44,4106},
	{47,4094},
	{48,4090},
	{50,4086},
	{52,4076},
	{53,4064},
	{55,4052},
	{57,4014},
	{59,4000},
	{60,3985},
	{63,3965},
	{64,3958},
	{66,3950},
	{68,3938},
	{70,3928},
	{71,3924},
	{73,3920},
	{75,3912},
	{76,3908},
	{79,3904},
	{80,3895},
	{82,3890},
	{84,3885},
	{86,3876},
	{87,3871},
	{89,3866},
	{91,3858},
	{93,3854},
	{95,3849},
	{96,3841},
	{98,3838},
	{100,3834},
	{102,3827},
	{103,3820},
	{105,3817},
	{107,3814},
	{109,3808},
	{111,3806},
	{112,3803},
	{114,3798},
	{116,3796},
	{118,3794},
	{119,3790},
	{121,3789},
	{123,3788},
	{125,3785},
	{127,3784},
	{128,3782},
	{130,3780},
	{132,3779},
	{134,3778},
	{135,3775},
	{137,3774},
	{139,3773},
	{141,3771},
	{143,3767},
	{144,3765},
	{146,3763},
	{148,3759},
	{150,3756},
	{151,3754},
	{153,3749},
	{155,3746},
	{157,3743},
	{159,3736},
	{160,3732},
	{162,3728},
	{164,3720},
	{166,3713},
	{167,3707},
	{170,3703},
	{171,3700},
	{173,3695},
	{175,3693},
	{176,3689},
	{178,3687},

};



      
        
/* T1 0C */
BATTERY_PROFILE_STRUCT battery_profile_t1[] = 
{
	{0,4389},
	{1,4368},
	{2,4358},
	{3,4348},
	{6,4329},
	{7,4319},
	{8,4309},
	{9,4292},
	{10,4284},
	{11,4276},
	{13,4259},
	{15,4244},
	{16,4236},
	{17,4227},
	{18,4212},
	{19,4204},
	{20,4196},
	{22,4181},
	{23,4174},
	{25,4166},
	{26,4151},
	{27,4136},
	{28,4128},
	{30,4120},
	{31,4106},
	{32,4100},
	{34,4093},
	{35,4088},
	{36,4083},
	{38,4078},
	{39,4053},
	{40,4018},
	{41,4005},
	{43,3992},
	{44,3974},
	{45,3967},
	{47,3960},
	{48,3948},
	{49,3943},
	{50,3938},
	{51,3928},
	{53,3920},
	{55,3915},
	{56,3910},
	{57,3899},
	{58,3893},
	{59,3887},
	{60,3877},
	{63,3867},
	{64,3862},
	{65,3858},
	{66,3850},
	{67,3846},
	{68,3842},
	{69,3835},
	{72,3832},
	{73,3828},
	{74,3822},
	{75,3816},
	{76,3814},
	{77,3811},
	{78,3806},
	{80,3803},
	{82,3800},
	{83,3796},
	{84,3794},
	{85,3792},
	{86,3788},
	{88,3784},
	{89,3783},
	{91,3782},
	{92,3779},
	{93,3778},
	{94,3777},
	{95,3775},
	{97,3774},
	{98,3773},
	{100,3770},
	{101,3768},
	{102,3766},
	{103,3764},
	{105,3759},
	{106,3757},
	{107,3755},
	{108,3749},
	{110,3746},
	{111,3742},
	{113,3734},
	{114,3725},
	{115,3720},
	{116,3715},
	{117,3705},
	{119,3702},
	{120,3699},
	{122,3694},
	{123,3692},
	{124,3691},
	{125,3685},
	{126,3670},
	{128,3646},
	{130,3622},

};





/* T2 25C*/
BATTERY_PROFILE_STRUCT battery_profile_t2[] = 
{
	{0,4389},
	{1,4370},
	{2,4362},
	{3,4353},
	{4,4336},
	{5,4327},
	{6,4318},
	{7,4301},
	{8,4292},
	{9,4284},
	{10,4267},
	{11,4250},
	{12,4242},
	{13,4234},
	{14,4217},
	{15,4209},
	{16,4201},
	{17,4186},
	{18,4178},
	{19,4170},
	{20,4154},
	{21,4139},
	{22,4131},
	{23,4123},
	{24,4108},
	{25,4100},
	{26,4093},
	{27,4081},
	{28,4078},
	{29,4076},
	{30,4061},
	{31,4034},
	{32,4021},
	{33,4008},
	{34,3990},
	{35,3984},
	{36,3978},
	{37,3969},
	{38,3966},
	{39,3962},
	{40,3953},
	{41,3940},
	{42,3933},
	{43,3926},
	{44,3909},
	{45,3901},
	{46,3893},
	{47,3880},
	{48,3874},
	{49,3869},
	{50,3860},
	{51,3852},
	{52,3848},
	{53,3844},
	{54,3836},
	{55,3832},
	{56,3829},
	{57,3823},
	{58,3817},
	{59,3814},
	{60,3812},
	{61,3806},
	{62,3804},
	{63,3801},
	{64,3797},
	{65,3794},
	{66,3792},
	{67,3788},
	{68,3784},
	{69,3782},
	{70,3781},
	{71,3777},
	{72,3775},
	{73,3773},
	{74,3768},
	{75,3766},
	{76,3763},
	{77,3759},
	{78,3754},
	{79,3752},
	{80,3749},
	{81,3744},
	{82,3742},
	{83,3739},
	{84,3733},
	{85,3730},
	{86,3726},
	{87,3717},
	{88,3710},
	{89,3704},
	{90,3698},
	{91,3690},
	{92,3689},
	{93,3688},
	{94,3686},
	{95,3684},
	{96,3683},
	{97,3677},
	{98,3642},
	{99,3606},
	{100,3570},

};





/* T3 50C*/
BATTERY_PROFILE_STRUCT battery_profile_t3[] = 
{
	{0,4374},
	{1,4355},
	{2,4347},
	{3,4339},
	{4,4322},
	{5,4314},
	{6,4305},
	{7,4288},
	{8,4280},
	{9,4271},
	{10,4254},
	{11,4237},
	{12,4228},
	{13,4220},
	{14,4204},
	{15,4196},
	{16,4188},
	{17,4171},
	{18,4163},
	{19,4155},
	{20,4140},
	{21,4124},
	{22,4116},
	{23,4108},
	{24,4093},
	{26,4086},
	{27,4078},
	{28,4063},
	{29,4058},
	{30,4054},
	{31,4038},
	{32,4019},
	{33,4011},
	{34,4003},
	{35,3993},
	{36,3988},
	{37,3982},
	{38,3970},
	{39,3964},
	{40,3957},
	{41,3946},
	{42,3933},
	{43,3925},
	{44,3917},
	{45,3898},
	{46,3890},
	{47,3883},
	{48,3872},
	{49,3867},
	{50,3862},
	{51,3853},
	{52,3845},
	{53,3841},
	{54,3837},
	{55,3830},
	{56,3827},
	{57,3824},
	{58,3817},
	{59,3814},
	{60,3811},
	{61,3806},
	{62,3801},
	{63,3798},
	{64,3795},
	{65,3791},
	{66,3788},
	{67,3786},
	{68,3782},
	{69,3778},
	{70,3776},
	{71,3775},
	{72,3769},
	{73,3764},
	{74,3759},
	{76,3750},
	{77,3747},
	{78,3744},
	{79,3739},
	{80,3734},
	{81,3731},
	{82,3728},
	{83,3724},
	{84,3722},
	{85,3719},
	{86,3712},
	{87,3708},
	{88,3703},
	{89,3695},
	{90,3686},
	{91,3681},
	{92,3676},
	{93,3674},
	{94,3673},
	{95,3672},
	{96,3670},
	{97,3667},
	{98,3664},
	{99,3636},
	{100,3572},
	{101,3524},
	{102,3477},

};





/* battery profile for actual temperature. The size should be the same as T1, T2 and T3*/
BATTERY_PROFILE_STRUCT battery_profile_temperature[] = {
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0}
};

/* ============================================================*/
/* <Rbat, Battery_Voltage> Table*/
/* ============================================================*/
/* T0 -10C*/
R_PROFILE_STRUCT r_profile_t0[] = {
{943, 4406},
{943, 4380},
{964, 4369},
{985, 4358},
{975, 4337},
{972, 4326},
{970, 4316},
{965, 4297},
{965, 4288},
{965, 4280},
{960, 4263},
{955, 4255},
{950, 4247},
{943, 4230},
{940, 4222},
{938, 4214},
{930, 4199},
{928, 4192},
{925, 4184},
{915, 4168},
{910, 4153},
{904, 4145},
{898, 4137},
{878, 4121},
{872, 4114},
{865, 4106},
{865, 4094},
{872, 4090},
{878, 4086},
{890, 4076},
{884, 4064},
{878, 4052},
{843, 4014},
{834, 4000},
{825, 3985},
{818, 3965},
{816, 3958},
{815, 3950},
{815, 3938},
{815, 3928},
{818, 3924},
{820, 3920},
{825, 3912},
{825, 3908},
{825, 3904},
{825, 3895},
{824, 3890},
{823, 3885},
{825, 3876},
{824, 3871},
{823, 3866},
{828, 3858},
{836, 3854},
{845, 3849},
{855, 3841},
{858, 3838},
{860, 3834},
{863, 3827},
{868, 3820},
{873, 3817},
{878, 3814},
{880, 3808},
{885, 3806},
{890, 3803},
{898, 3798},
{902, 3796},
{905, 3794},
{908, 3790},
{914, 3789},
{920, 3788},
{913, 3785},
{916, 3784},
{920, 3782},
{928, 3780},
{936, 3779},
{943, 3778},
{953, 3775},
{962, 3774},
{970, 3773},
{983, 3771},
{1000, 3767},
{1008, 3765},
{1015, 3763},
{1035, 3759},
{1048, 3756},
{1060, 3754},
{1085, 3749},
{1102, 3746},
{1120, 3743},
{1158, 3736},
{1182, 3732},
{1205, 3728},
{1263, 3720},
{1283, 3713},
{1268, 3707},
{1258, 3703},
{1243, 3700},
{1240, 3695},
{1233, 3693},
{1228, 3689},
{1220, 3687}
};

/* T1 0C*/
R_PROFILE_STRUCT r_profile_t1[] = {
{438, 4389},
{438, 4368},
{438, 4358},
{438, 4348},
{440, 4329},
{439, 4319},
{438, 4309},
{443, 4292},
{444, 4284},
{445, 4276},
{443, 4259},
{445, 4244},
{445, 4236},
{445, 4227},
{445, 4212},
{445, 4204},
{445, 4196},
{445, 4181},
{448, 4174},
{450, 4166},
{453, 4151},
{450, 4136},
{449, 4128},
{448, 4120},
{448, 4106},
{446, 4100},
{445, 4093},
{458, 4088},
{466, 4083},
{473, 4078},
{475, 4053},
{460, 4018},
{454, 4005},
{448, 3992},
{443, 3974},
{442, 3967},
{440, 3960},
{438, 3948},
{438, 3943},
{438, 3938},
{435, 3928},
{435, 3920},
{432, 3915},
{428, 3910},
{423, 3899},
{419, 3893},
{415, 3887},
{413, 3877},
{413, 3867},
{412, 3862},
{410, 3858},
{413, 3850},
{413, 3846},
{413, 3842},
{415, 3835},
{415, 3832},
{415, 3828},
{420, 3822},
{420, 3816},
{422, 3814},
{423, 3811},
{425, 3806},
{426, 3803},
{428, 3800},
{430, 3796},
{432, 3794},
{433, 3792},
{435, 3788},
{435, 3784},
{436, 3783},
{438, 3782},
{438, 3779},
{438, 3778},
{438, 3777},
{440, 3775},
{442, 3774},
{443, 3773},
{445, 3770},
{448, 3768},
{448, 3766},
{448, 3764},
{450, 3759},
{452, 3757},
{455, 3755},
{460, 3749},
{462, 3746},
{465, 3742},
{468, 3734},
{478, 3725},
{482, 3720},
{485, 3715},
{498, 3705},
{508, 3702},
{518, 3699},
{548, 3694},
{573, 3692},
{598, 3691},
{670, 3685},
{808, 3670},
{920, 3646},
{1033, 3622}
};

/* T2 25C*/
R_PROFILE_STRUCT r_profile_t2[] = {
{145, 4389},
{145, 4370},
{146, 4362},
{148, 4353},
{148, 4336},
{148, 4327},
{148, 4318},
{150, 4301},
{150, 4292},
{150, 4284},
{150, 4267},
{150, 4250},
{152, 4242},
{153, 4234},
{150, 4217},
{152, 4209},
{153, 4201},
{155, 4186},
{155, 4178},
{155, 4170},
{158, 4154},
{160, 4139},
{160, 4131},
{160, 4123},
{163, 4108},
{164, 4100},
{165, 4093},
{165, 4081},
{168, 4078},
{170, 4076},
{173, 4061},
{175, 4034},
{175, 4021},
{175, 4008},
{175, 3990},
{178, 3984},
{180, 3978},
{183, 3969},
{186, 3966},
{188, 3962},
{188, 3953},
{185, 3940},
{182, 3933},
{180, 3926},
{168, 3909},
{163, 3901},
{158, 3893},
{150, 3880},
{149, 3874},
{148, 3869},
{148, 3860},
{150, 3852},
{149, 3848},
{148, 3844},
{148, 3836},
{146, 3832},
{145, 3829},
{148, 3823},
{148, 3817},
{149, 3814},
{150, 3812},
{150, 3806},
{150, 3804},
{150, 3801},
{155, 3797},
{154, 3794},
{153, 3792},
{155, 3788},
{155, 3784},
{156, 3782},
{158, 3781},
{160, 3777},
{159, 3775},
{158, 3773},
{155, 3768},
{152, 3766},
{150, 3763},
{150, 3759},
{150, 3754},
{150, 3752},
{150, 3749},
{148, 3744},
{149, 3742},
{150, 3739},
{150, 3733},
{150, 3730},
{150, 3726},
{148, 3717},
{153, 3710},
{150, 3704},
{148, 3698},
{145, 3690},
{146, 3689},
{148, 3688},
{150, 3686},
{154, 3684},
{158, 3683},
{168, 3677},
{163, 3642},
{168, 3606},
{173, 3570}
};

/* T3 50C*/
R_PROFILE_STRUCT r_profile_t3[] = {
{113, 4374},
{113, 4355},
{116, 4347},
{118, 4339},
{118, 4322},
{118, 4314},
{118, 4305},
{118, 4288},
{119, 4280},
{120, 4271},
{118, 4254},
{118, 4237},
{118, 4228},
{118, 4220},
{120, 4204},
{120, 4196},
{120, 4188},
{118, 4171},
{119, 4163},
{120, 4155},
{123, 4140},
{123, 4124},
{123, 4116},
{123, 4108},
{125, 4093},
{125, 4086},
{125, 4078},
{125, 4063},
{128, 4058},
{130, 4054},
{128, 4038},
{128, 4019},
{129, 4011},
{130, 4003},
{133, 3993},
{134, 3988},
{135, 3982},
{135, 3970},
{135, 3964},
{135, 3957},
{140, 3946},
{143, 3933},
{142, 3925},
{140, 3917},
{128, 3898},
{126, 3890},
{123, 3883},
{123, 3872},
{122, 3867},
{120, 3862},
{118, 3853},
{120, 3845},
{119, 3841},
{118, 3837},
{118, 3830},
{119, 3827},
{120, 3824},
{120, 3817},
{120, 3814},
{120, 3811},
{123, 3806},
{123, 3801},
{123, 3798},
{123, 3795},
{125, 3791},
{125, 3788},
{125, 3786},
{128, 3782},
{130, 3778},
{132, 3776},
{133, 3775},
{130, 3769},
{126, 3764},
{123, 3759},
{120, 3750},
{122, 3747},
{123, 3744},
{123, 3739},
{123, 3734},
{122, 3731},
{120, 3728},
{123, 3724},
{123, 3722},
{123, 3719},
{123, 3712},
{122, 3708},
{120, 3703},
{120, 3695},
{123, 3686},
{120, 3681},
{118, 3676},
{120, 3674},
{122, 3673},
{123, 3672},
{130, 3670},
{132, 3667},
{135, 3664},
{130, 3636},
{135, 3572},
{140, 3524},
{145, 3477}
};

/* r-table profile for actual temperature. The size should be the same as T1, T2 and T3*/
R_PROFILE_STRUCT r_profile_temperature[] = {
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0}
};
/*lenovo-sw mahj2 update ZCV param End*/
/* ============================================================*/
/* function prototype*/
/* ============================================================*/
int fgauge_get_saddles(void);
BATTERY_PROFILE_STRUCT_P fgauge_get_profile(kal_uint32 temperature);

int fgauge_get_saddles_r_table(void);
R_PROFILE_STRUCT_P fgauge_get_profile_r_table(kal_uint32 temperature);

#endif

