#ifndef _CUST_BATTERY_METER_TABLE_H
#define _CUST_BATTERY_METER_TABLE_H

#include <mach/mt_typedefs.h>

/* ============================================================*/
/* define*/
/* ============================================================*/
#define BAT_NTC_10 1
#define BAT_NTC_47 0

#if (BAT_NTC_10 == 1)
#define RBAT_PULL_UP_R	24000
#endif

#if (BAT_NTC_47 == 1)
#define RBAT_PULL_UP_R	61900
#endif

#define RBAT_PULL_UP_VOLT	2800



/* ============================================================*/
/* ENUM*/
/* ============================================================*/

/* ============================================================*/
/* structure*/
/* ============================================================*/

/* ============================================================*/
/* typedef*/
/* ============================================================*/
typedef struct _BATTERY_PROFILE_STRUC
{
	kal_int32 percentage;
	kal_int32 voltage;
} BATTERY_PROFILE_STRUC, *BATTERY_PROFILE_STRUC_P;

typedef struct _R_PROFILE_STRUC
{
	kal_int32 resistance; /* Ohm*/
	kal_int32 voltage;
} R_PROFILE_STRUC, *R_PROFILE_STRUC_P;

typedef enum
{
	T1_0C,
	T2_25C,
	T3_50C
} PROFILE_TEMPERATURE;

/* ============================================================*/
/* External Variables*/
/* ============================================================*/

/* ============================================================*/
/* External function*/
/* ============================================================*/

/* ============================================================*/
/* <DOD, Battery_Voltage> Table*/
/* ============================================================*/
#if (BAT_NTC_10 == 1)
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
		{-20, 68237},
		{-15, 53650},
		{-10, 42506},
		{ -5, 33892},
		{  0, 27219},
		{  5, 22021},
		{ 10, 17926},
		{ 15, 14674},
		{ 20, 12081},
		{ 25, 10000},
		{ 30, 8315},
		{ 35, 6948},
		{ 40, 5834},
		{ 45, 4917},
		{ 50, 4161},
		{ 55, 3535},
		{ 60, 3014}
	};
#endif

#if (BAT_NTC_47 == 1)
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
		{-20, 483954},
		{-15, 360850},
		{-10, 271697},
		{ -5, 206463},
		{  0, 158214},
		{  5, 122259},
		{ 10, 95227},
		{ 15, 74730},
		{ 20, 59065},
		{ 25, 47000},
		{ 30, 37643},
		{ 35, 30334},
		{ 40, 24591},
		{ 45, 20048},
		{ 50, 16433},
		{ 55, 13539},
		{ 60, 11210}
	};
#endif

/* T0 -10C*/
BATTERY_PROFILE_STRUC battery_profile_t0[] = {
	{0, 4303},
	{6, 4281},
	{13, 4261},
	{18, 4240},
	{25, 4217},
	{31, 4194},
	{38, 4169},
	{44, 4145},
	{51, 4117},
	{56, 4088},
	{62, 4068},
	{69, 4047},
	{75, 4019},
	{82, 3997},
	{87, 3981},
	{94, 3967},
	{100, 3956},
	{107, 3942},
	{113, 3929},
	{118, 3913},
	{125, 3895},
	{128, 3880},
	{135, 3869},
	{141, 3857},
	{147, 3848},
	{154, 3839},
	{159, 3830},
	{166, 3823},
	{172, 3818},
	{179, 3811},
	{185, 3806},
	{192, 3800},
	{197, 3796},
	{203, 3791},
	{210, 3787},
	{216, 3781},
	{223, 3775},
	{228, 3770},
	{235, 3760},
	{241, 3752},
	{248, 3742},
	{254, 3731},
	{259, 3721},
	{266, 3713},
	{272, 3704},
	{279, 3698},
	{285, 3688},
	{292, 3665},
	{297, 3613},
	{304, 3526},
	{307, 3466},
	{310, 3444},
	{313, 3424},
	{313, 3404},
	{313, 3381},
	{316, 3357},
	{316, 3332},
	{316, 3310},
	{316, 3291},
	{316, 3274},
	{316, 3259},
	{316, 3245},
	{320, 3234},
	{320, 3221},
	{320, 3212},
	{320, 3204},
	{320, 3193},
	{320, 3186},
	{320, 3179},
	{320, 3168},
	{320, 3162},
	{320, 3157},
	{320, 3151},
	{320, 3143},
	{320, 3133},
	{320, 3125},
	{320, 3125},
	{320, 3125},
	{320, 3125},
	{320, 3125},
	{320, 3125},
	{320, 3125},

};      
        
/* T1 0C */
BATTERY_PROFILE_STRUC battery_profile_t1[] = {
	{0, 4316},
	{7, 4283},
	{12, 4244},
	{20, 4210},
	{22, 4185},
	{29, 4164},
	{34, 4144},
	{41, 4128},
	{49, 4109},
	{54, 4093},
	{61, 4080},
	{63, 4069},
	{71, 4047},
	{78, 4023},
	{83, 4003},
	{90, 3989},
	{95, 3977},
	{100, 3967},
	{105, 3955},
	{112, 3940},
	{120, 3923},
	{124, 3907},
	{132, 3891},
	{139, 3877},
	{141, 3864},
	{149, 3855},
	{154, 3846},
	{161, 3837},
	{166, 3831},
	{173, 3823},
	{181, 3815},
	{183, 3811},
	{190, 3804},
	{195, 3799},
	{202, 3794},
	{210, 3790},
	{215, 3785},
	{222, 3782},
	{224, 3778},
	{232, 3773},
	{237, 3768},
	{244, 3761},
	{251, 3753},
	{256, 3742},
	{261, 3727},
	{266, 3712},
	{273, 3704},
	{278, 3701},
	{285, 3698},
	{293, 3692},
	{298, 3680},
	{302, 3625},
	{307, 3528},
	{315, 3472},
	{322, 3403},
	{324, 3323},
	{324, 3267},
	{324, 3230},
	{327, 3203},
	{327, 3180},
	{327, 3157},
	{327, 3141},
	{327, 3124},
	{327, 3109},
	{327, 3096},
	{327, 3084},
	{327, 3079},
	{327, 3067},
	{327, 3058},
	{327, 3047},
	{327, 3041},
	{327, 3032},
	{327, 3029},
	{327, 3018},
	{327, 3008},
	{327, 3002},
	{327, 3003},
	{327, 2995},
	{327, 2985},
	{327, 2983},
	{327, 2979},
	{327, 2967},

};

/* T2 25C*/
BATTERY_PROFILE_STRUC battery_profile_t2[] = {
	{0, 4328},
	{2, 4303},
	{4, 4283},
	{5, 4263},
	{7, 4245},
	{9, 4227},
	{11, 4209},
	{13, 4189},
	{14, 4173},
	{16, 4155},
	{19, 4138},
	{21, 4121},
	{22, 4104},
	{24, 4087},
	{26, 4072},
	{28, 4058},
	{30, 4041},
	{31, 4025},
	{33, 4011},
	{35, 3996},
	{37, 3983},
	{39, 3972},
	{40, 3958},
	{42, 3945},
	{44, 3926},
	{46, 3907},
	{48, 3889},
	{49, 3876},
	{52, 3865},
	{54, 3854},
	{56, 3846},
	{57, 3840},
	{59, 3832},
	{61, 3824},
	{63, 3818},
	{65, 3813},
	{66, 3805},
	{68, 3801},
	{70, 3794},
	{72, 3789},
	{74, 3784},
	{75, 3778},
	{77, 3772},
	{79, 3765},
	{81, 3753},
	{84, 3745},
	{85, 3733},
	{87, 3717},
	{89, 3699},
	{91, 3692},
	{92, 3691},
	{94, 3689},
	{96, 3687},
	{98, 3668},
	{100, 3597},
	{101, 3497},
	{103, 3391},
	{104, 3157},
	{105, 3073},
	{105, 3022},
	{105, 2992},
	{105, 2969},
	{105, 2958},
	{105, 2946},
	{105, 2934},
	{105, 2925},
	{105, 2913},
	{105, 2910},
	{105, 2900},
	{105, 2891},
	{105, 2891},
	{105, 2891},
	{105, 2891},
	{105, 2891},
	{105, 2891},
	{105, 2891},
	{105, 2891},
	{105, 2891},
	{105, 2891},
	{105, 2891},
	{105, 2891},
	{105, 2891},
};

/* T3 50C*/
BATTERY_PROFILE_STRUC battery_profile_t3[] = {
	{0, 4331},
	{2, 4305},
	{3, 4284},
	{5, 4265},
	{7, 4244},
	{10, 4225},
	{11, 4206},
	{13, 4188},
	{15, 4170},
	{16, 4153},
	{18, 4135},
	{20, 4119},
	{22, 4102},
	{23, 4085},
	{26, 4069},
	{28, 4054},
	{29, 4038},
	{31, 4023},
	{33, 4010},
	{35, 3996},
	{36, 3984},
	{38, 3970},
	{40, 3958},
	{41, 3947},
	{44, 3934},
	{46, 3921},
	{47, 3904},
	{49, 3884},
	{51, 3868},
	{53, 3857},
	{54, 3848},
	{56, 3838},
	{59, 3832},
	{60, 3824},
	{62, 3817},
	{64, 3811},
	{66, 3806},
	{67, 3800},
	{69, 3794},
	{71, 3790},
	{72, 3784},
	{74, 3777},
	{77, 3763},
	{79, 3758},
	{80, 3750},
	{82, 3742},
	{84, 3733},
	{85, 3723},
	{87, 3709},
	{89, 3694},
	{91, 3678},
	{93, 3676},
	{95, 3675},
	{97, 3674},
	{98, 3669},
	{100, 3625},
	{102, 3547},
	{104, 3495},
	{105, 3458},
	{107, 3331},
	{109, 3140},
	{109, 3078},
	{109, 3033},
	{109, 3001},
	{109, 2980},
	{110, 2960},
	{110, 2944},
	{110, 2932},
	{110, 2921},
	{110, 2913},
	{110, 2903},
	{110, 2899},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
};

/* battery profile for actual temperature. The size should be the same as T1, T2 and T3*/
BATTERY_PROFILE_STRUC battery_profile_temperature[] = {
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0}
};

/* ============================================================*/
/* <Rbat, Battery_Voltage> Table*/
/* ============================================================*/
/* T0 -10C*/
R_PROFILE_STRUC r_profile_t0[] = {
	{408, 4303},
	{408, 4281},
	{415, 4261},
	{425, 4240},
	{430, 4217},
	{440, 4194},
	{463, 4169},
	{490, 4145},
	{525, 4117},
	{573, 4088},
	{615, 4068},
	{650, 4047},
	{675, 4019},
	{685, 3997},
	{705, 3981},
	{713, 3967},
	{720, 3956},
	{733, 3942},
	{728, 3929},
	{738, 3913},
	{725, 3895},
	{735, 3880},
	{745, 3869},
	{748, 3857},
	{760, 3848},
	{773, 3839},
	{783, 3830},
	{803, 3823},
	{820, 3818},
	{835, 3811},
	{863, 3806},
	{888, 3800},
	{903, 3796},
	{925, 3791},
	{955, 3787},
	{975, 3781},
	{1000, 3775},
	{1035, 3770},
	{1058, 3760},
	{1090, 3752},
	{1105, 3742},
	{1135, 3731},
	{1168, 3721},
	{1210, 3713},
	{1255, 3704},
	{1345, 3698},
	{1430, 3688},
	{1518, 3665},
	{1570, 3613},
	{1618, 3526},
	{1668, 3466},
	{1613, 3444},
	{1563, 3424},
	{1510, 3404},
	{1460, 3381},
	{1400, 3357},
	{1333, 3332},
	{1283, 3310},
	{1233, 3291},
	{1198, 3274},
	{1155, 3259},
	{1128, 3245},
	{1093, 3234},
	{1075, 3221},
	{1053, 3212},
	{1023, 3204},
	{1018, 3193},
	{1005, 3186},
	{978, 3179},
	{960, 3168},
	{940, 3162},
	{895, 3157},
	{890, 3151},
	{863, 3143},
	{925, 3133},
	{893, 3125},
	{893, 3125},
	{893, 3125},
	{893, 3125},
	{893, 3125},
	{893, 3125},
	{893, 3125}
};

/* T1 0C*/
R_PROFILE_STRUC r_profile_t1[] = {
	{258, 4316},
	{258, 4283},
	{278, 4244},
	{303, 4210},
	{333, 4185},
	{343, 4164},
	{350, 4144},
	{365, 4128},
	{370, 4109},
	{370, 4093},
	{380, 4080},
	{403, 4069},
	{395, 4047},
	{403, 4023},
	{403, 4003},
	{413, 3989},
	{418, 3977},
	{420, 3967},
	{423, 3955},
	{415, 3940},
	{410, 3923},
	{400, 3907},
	{393, 3891},
	{393, 3877},
	{388, 3864},
	{395, 3855},
	{403, 3846},
	{405, 3837},
	{415, 3831},
	{425, 3823},
	{430, 3815},
	{443, 3811},
	{450, 3804},
	{465, 3799},
	{475, 3794},
	{483, 3790},
	{490, 3785},
	{503, 3782},
	{520, 3778},
	{533, 3773},
	{545, 3768},
	{563, 3761},
	{588, 3753},
	{600, 3742},
	{608, 3727},
	{615, 3712},
	{635, 3704},
	{670, 3701},
	{710, 3698},
	{765, 3692},
	{840, 3680},
	{880, 3625},
	{915, 3528},
	{1080, 3472},
	{1323, 3403},
	{1315, 3323},
	{1180, 3267},
	{1080, 3230},
	{1010, 3203},
	{958, 3180},
	{925, 3157},
	{888, 3141},
	{860, 3124},
	{810, 3109},
	{788, 3096},
	{765, 3084},
	{700, 3079},
	{745, 3067},
	{680, 3058},
	{685, 3047},
	{650, 3041},
	{683, 3032},
	{615, 3029},
	{643, 3018},
	{660, 3008},
	{635, 3002},
	{530, 3003},
	{640, 2995},
	{595, 2985},
	{535, 2983},
	{463, 2979},
	{600, 2967}
};

/* T2 25C*/
R_PROFILE_STRUC r_profile_t2[] = {
	{155, 4328},
	{155, 4303},
	{155, 4283},
	{158, 4263},
	{158, 4245},
	{163, 4227},
	{165, 4209},
	{165, 4189},
	{170, 4173},
	{170, 4155},
	{173, 4138},
	{173, 4121},
	{173, 4104},
	{178, 4087},
	{180, 4072},
	{185, 4058},
	{188, 4041},
	{190, 4025},
	{200, 4011},
	{200, 3996},
	{205, 3983},
	{218, 3972},
	{215, 3958},
	{215, 3945},
	{200, 3926},
	{188, 3907},
	{173, 3889},
	{168, 3876},
	{163, 3865},
	{160, 3854},
	{163, 3846},
	{168, 3840},
	{170, 3832},
	{170, 3824},
	{170, 3818},
	{178, 3813},
	{175, 3805},
	{183, 3801},
	{180, 3794},
	{183, 3789},
	{185, 3784},
	{183, 3778},
	{185, 3772},
	{183, 3765},
	{173, 3753},
	{173, 3745},
	{173, 3733},
	{173, 3717},
	{173, 3699},
	{170, 3692},
	{175, 3691},
	{185, 3689},
	{198, 3687},
	{205, 3668},
	{208, 3597},
	{240, 3497},
	{273, 3391},
	{908, 3157},
	{705, 3073},
	{595, 3022},
	{513, 2992},
	{465, 2969},
	{413, 2958},
	{380, 2946},
	{368, 2934},
	{360, 2925},
	{335, 2913},
	{275, 2910},
	{315, 2900},
	{283, 2891},
	{283, 2891},
	{283, 2891},
	{283, 2891},
	{283, 2891},
	{283, 2891},
	{283, 2891},
	{283, 2891},
	{283, 2891},
	{283, 2891},
	{283, 2891},
	{283, 2891},
	{283, 2891}
};

/* T3 50C*/
R_PROFILE_STRUC r_profile_t3[] = {
	{123, 4331},
	{123, 4305},
	{128, 4284},
	{130, 4265},
	{130, 4244},
	{130, 4225},
	{128, 4206},
	{125, 4188},
	{130, 4170},
	{133, 4153},
	{133, 4135},
	{138, 4119},
	{138, 4102},
	{140, 4085},
	{140, 4069},
	{143, 4054},
	{140, 4038},
	{143, 4023},
	{148, 4010},
	{153, 3996},
	{155, 3984},
	{155, 3970},
	{165, 3958},
	{175, 3947},
	{175, 3934},
	{178, 3921},
	{170, 3904},
	{148, 3884},
	{135, 3868},
	{135, 3857},
	{133, 3848},
	{133, 3838},
	{135, 3832},
	{135, 3824},
	{135, 3817},
	{143, 3811},
	{145, 3806},
	{148, 3800},
	{145, 3794},
	{153, 3790},
	{150, 3784},
	{150, 3777},
	{133, 3763},
	{143, 3758},
	{140, 3750},
	{138, 3742},
	{135, 3733},
	{135, 3723},
	{133, 3709},
	{133, 3694},
	{130, 3678},
	{130, 3676},
	{138, 3675},
	{148, 3674},
	{160, 3669},
	{158, 3625},
	{170, 3547},
	{208, 3495},
	{220, 3458},
	{265, 3331},
	{855, 3140},
	{725, 3078},
	{600, 3033},
	{528, 3001},
	{460, 2980},
	{400, 2960},
	{380, 2944},
	{355, 2932},
	{315, 2921},
	{303, 2913},
	{308, 2903},
	{255, 2899},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889}
};

/* r-table profile for actual temperature. The size should be the same as T1, T2 and T3*/
R_PROFILE_STRUC r_profile_temperature[] = {
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0}
};

/* ============================================================*/
/* function prototype*/
/* ============================================================*/
int fgauge_get_saddles(void);
BATTERY_PROFILE_STRUC_P fgauge_get_profile(kal_uint32 temperature);

int fgauge_get_saddles_r_table(void);
R_PROFILE_STRUC_P fgauge_get_profile_r_table(kal_uint32 temperature);

#endif

