#ifndef _CUST_BATTERY_METER_TABLE_H
#define _CUST_BATTERY_METER_TABLE_H

#include <mach/mt_typedefs.h>

/* ============================================================*/
/* define*/
/* ============================================================*/
#define BAT_NTC_10 1
#define BAT_NTC_47 0

#if (BAT_NTC_10 == 1)
#define RBAT_PULL_UP_R	24000
#endif

#if (BAT_NTC_47 == 1)
#define RBAT_PULL_UP_R	61900
#endif

#define RBAT_PULL_UP_VOLT	2800



/* ============================================================*/
/* ENUM*/
/* ============================================================*/

/* ============================================================*/
/* structure*/
/* ============================================================*/

/* ============================================================*/
/* typedef*/
/* ============================================================*/
typedef struct _BATTERY_PROFILE_STRUCT
{
	kal_int32 percentage;
	kal_int32 voltage;
} BATTERY_PROFILE_STRUCT, *BATTERY_PROFILE_STRUCT_P;

typedef struct _R_PROFILE_STRUCT
{
	kal_int32 resistance; /* Ohm*/
	kal_int32 voltage;
} R_PROFILE_STRUCT, *R_PROFILE_STRUCT_P;

typedef enum
{
	T1_0C,
	T2_25C,
	T3_50C
} PROFILE_TEMPERATURE;

/* ============================================================*/
/* External Variables*/
/* ============================================================*/

/* ============================================================*/
/* External function*/
/* ============================================================*/

/* ============================================================*/
/* <DOD, Battery_Voltage> Table*/
/* ============================================================*/
#if (BAT_NTC_10 == 1)
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
		{-20, 68237},
		{-15, 53650},
		{-10, 42506},
		{ -5, 33892},
		{  0, 27219},
		{  5, 22021},
		{ 10, 17926},
		{ 15, 14674},
		{ 20, 12081},
		{ 25, 10000},
		{ 30, 8315},
		{ 35, 6948},
		{ 40, 5834},
		{ 45, 4917},
		{ 50, 4161},
		{ 55, 3535},
		{ 60, 3014}
	};
#endif

#if (BAT_NTC_47 == 1)
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
		{-20, 483954},
		{-15, 360850},
		{-10, 271697},
		{ -5, 206463},
		{  0, 158214},
		{  5, 122259},
		{ 10, 95227},
		{ 15, 74730},
		{ 20, 59065},
		{ 25, 47000},
		{ 30, 37643},
		{ 35, 30334},
		{ 40, 24591},
		{ 45, 20048},
		{ 50, 16433},
		{ 55, 13539},
		{ 60, 11210}
	};
#endif

/* T0 -10C*/
BATTERY_PROFILE_STRUCT battery_profile_t0[] = {
	{0, 4303},
	{6, 4281},
	{13, 4261},
	{19, 4240},
	{27, 4217},
	{33, 4194},
	{40, 4169},
	{46, 4145},
	{54, 4117},
	{60, 4088},
	{66, 4068},
	{73, 4047},
	{79, 4019},
	{87, 3997},
	{93, 3981},
	{100, 3967},
	{106, 3956},
	{113, 3942},
	{119, 3929},
	{125, 3913},
	{133, 3895},
	{136, 3880},
	{143, 3869},
	{149, 3857},
	{155, 3848},
	{163, 3839},
	{169, 3830},
	{176, 3823},
	{182, 3818},
	{190, 3811},
	{195, 3806},
	{203, 3800},
	{209, 3796},
	{215, 3791},
	{222, 3787},
	{228, 3781},
	{236, 3775},
	{242, 3770},
	{249, 3760},
	{255, 3752},
	{263, 3742},
	{269, 3731},
	{275, 3721},
	{282, 3713},
	{288, 3704},
	{295, 3698},
	{301, 3688},
	{309, 3665},
	{315, 3613},
	{322, 3526},
	{325, 3466},
	{328, 3444},
	{331, 3424},
	{331, 3404},
	{331, 3381},
	{334, 3357},
	{334, 3332},
	{334, 3310},
	{334, 3291},
	{334, 3274},
	{334, 3259},
	{334, 3245},
	{339, 3234},
	{339, 3221},
	{339, 3212},
	{339, 3204},
	{339, 3193},
	{339, 3186},
	{339, 3179},
	{339, 3168},
	{339, 3162},
	{339, 3157},
	{339, 3151},
	{339, 3143},
	{339, 3133},
	{339, 3125},
	{339, 3125},
	{339, 3125},
	{339, 3125},
	{339, 3125},
	{339, 3125},
	{339, 3125},
};      
        
/* T1 0C */
BATTERY_PROFILE_STRUCT battery_profile_t1[] = {
	{0, 4316},
	{5, 4283},
	{9, 4244},
	{14, 4210},
	{16, 4185},
	{21, 4164},
	{25, 4144},
	{30, 4128},
	{35, 4109},
	{39, 4093},
	{44, 4080},
	{46, 4069},
	{51, 4047},
	{56, 4023},
	{60, 4003},
	{65, 3989},
	{68, 3977},
	{72, 3967},
	{75, 3955},
	{81, 3940},
	{86, 3923},
	{89, 3907},
	{95, 3891},
	{100, 3877},
	{102, 3864},
	{107, 3855},
	{111, 3846},
	{116, 3837},
	{119, 3831},
	{125, 3823},
	{130, 3815},
	{132, 3811},
	{137, 3804},
	{140, 3799},
	{146, 3794},
	{151, 3790},
	{154, 3785},
	{160, 3782},
	{161, 3778},
	{167, 3773},
	{170, 3768},
	{175, 3761},
	{181, 3753},
	{184, 3742},
	{188, 3727},
	{191, 3712},
	{196, 3704},
	{200, 3701},
	{205, 3698},
	{211, 3692},
	{214, 3680},
	{218, 3625},
	{221, 3528},
	{226, 3472},
	{232, 3403},
	{233, 3323},
	{233, 3267},
	{233, 3230},
	{235, 3203},
	{235, 3180},
	{235, 3157},
	{235, 3141},
	{235, 3124},
	{235, 3109},
	{235, 3096},
	{235, 3084},
	{235, 3079},
	{235, 3067},
	{235, 3058},
	{235, 3047},
	{235, 3041},
	{235, 3032},
	{235, 3029},
	{235, 3018},
	{235, 3008},
	{235, 3002},
	{235, 3003},
	{235, 2995},
	{235, 2985},
	{235, 2983},
	{235, 2979},
	{235, 2967},

};

/* T2 25C*/
BATTERY_PROFILE_STRUCT battery_profile_t2[] = {
	{0, 4317},
	{2, 4292},
	{3, 4270},
	{5, 4250},
	{8, 4231},
	{10, 4213},
	{11, 4195},
	{13, 4176},
	{15, 4159},
	{16, 4143},
	{18, 4125},
	{20, 4110},
	{23, 4093},
	{24, 4077},
	{26, 4061},
	{28, 4047},
	{29, 4030},
	{31, 4014},
	{33, 4001},
	{35, 3988},
	{37, 3976},
	{39, 3962},
	{41, 3951},
	{42, 3935},
	{44, 3916},
	{46, 3897},
	{48, 3881},
	{49, 3869},
	{52, 3859},
	{54, 3849},
	{55, 3840},
	{57, 3835},
	{59, 3827},
	{61, 3820},
	{62, 3813},
	{65, 3807},
	{67, 3803},
	{68, 3797},
	{70, 3790},
	{72, 3786},
	{74, 3782},
	{75, 3777},
	{77, 3770},
	{80, 3763},
	{81, 3755},
	{83, 3745},
	{85, 3734},
	{87, 3717},
	{88, 3699},
	{90, 3692},
	{92, 3690},
	{94, 3689},
	{96, 3688},
	{98, 3676},
	{100, 3623},
	{101, 3548},
	{103, 3500},
	{105, 3482},
	{106, 3442},
	{109, 3323},
	{110, 3204},
	{110, 3162},
	{110, 3128},
	{111, 3098},
	{111, 3073},
	{111, 3053},
	{111, 3036},
	{111, 3023},
	{111, 3012},
	{111, 2998},
	{111, 2987},
	{111, 2978},
	{111, 2971},
	{111, 2963},
	{111, 2958},
	{111, 2956},
	{111, 2953},
	{111, 2948},
	{111, 2940},
	{111, 2934},
	{111, 2929},
	{111, 2926},
};

/* T3 50C*/
BATTERY_PROFILE_STRUCT battery_profile_t3[] = {
	{0, 4331},
	{2, 4305},
	{3, 4284},
	{5, 4265},
	{7, 4244},
	{10, 4225},
	{11, 4206},
	{13, 4188},
	{15, 4170},
	{16, 4153},
	{18, 4135},
	{20, 4119},
	{22, 4102},
	{23, 4085},
	{26, 4069},
	{28, 4054},
	{29, 4038},
	{31, 4023},
	{33, 4010},
	{35, 3996},
	{36, 3984},
	{38, 3970},
	{40, 3958},
	{41, 3947},
	{44, 3934},
	{46, 3921},
	{47, 3904},
	{49, 3884},
	{51, 3868},
	{53, 3857},
	{54, 3848},
	{56, 3838},
	{59, 3832},
	{60, 3824},
	{62, 3817},
	{64, 3811},
	{66, 3806},
	{67, 3800},
	{69, 3794},
	{71, 3790},
	{72, 3784},
	{74, 3777},
	{77, 3763},
	{79, 3758},
	{80, 3750},
	{82, 3742},
	{84, 3733},
	{85, 3723},
	{87, 3709},
	{89, 3694},
	{91, 3678},
	{93, 3676},
	{95, 3675},
	{97, 3674},
	{98, 3669},
	{100, 3625},
	{102, 3547},
	{104, 3495},
	{105, 3458},
	{107, 3331},
	{109, 3140},
	{109, 3078},
	{109, 3033},
	{109, 3001},
	{109, 2980},
	{110, 2960},
	{110, 2944},
	{110, 2932},
	{110, 2921},
	{110, 2913},
	{110, 2903},
	{110, 2899},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
	{110, 2889},
};

/* battery profile for actual temperature. The size should be the same as T1, T2 and T3*/
BATTERY_PROFILE_STRUCT battery_profile_temperature[] = {
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0}
};

/* ============================================================*/
/* <Rbat, Battery_Voltage> Table*/
/* ============================================================*/
/* T0 -10C*/
R_PROFILE_STRUCT r_profile_t0[] = {
	{408, 4303},
	{408, 4281},
	{415, 4261},
	{425, 4240},
	{430, 4217},
	{440, 4194},
	{463, 4169},
	{490, 4145},
	{525, 4117},
	{573, 4088},
	{615, 4068},
	{650, 4047},
	{675, 4019},
	{685, 3997},
	{705, 3981},
	{713, 3967},
	{720, 3956},
	{733, 3942},
	{728, 3929},
	{738, 3913},
	{725, 3895},
	{735, 3880},
	{745, 3869},
	{748, 3857},
	{760, 3848},
	{773, 3839},
	{783, 3830},
	{803, 3823},
	{820, 3818},
	{835, 3811},
	{863, 3806},
	{888, 3800},
	{903, 3796},
	{925, 3791},
	{955, 3787},
	{975, 3781},
	{1000, 3775},
	{1035, 3770},
	{1058, 3760},
	{1090, 3752},
	{1105, 3742},
	{1135, 3731},
	{1168, 3721},
	{1210, 3713},
	{1255, 3704},
	{1345, 3698},
	{1430, 3688},
	{1518, 3665},
	{1570, 3613},
	{1618, 3526},
	{1668, 3466},
	{1613, 3444},
	{1563, 3424},
	{1510, 3404},
	{1460, 3381},
	{1400, 3357},
	{1333, 3332},
	{1283, 3310},
	{1233, 3291},
	{1198, 3274},
	{1155, 3259},
	{1128, 3245},
	{1093, 3234},
	{1075, 3221},
	{1053, 3212},
	{1023, 3204},
	{1018, 3193},
	{1005, 3186},
	{978, 3179},
	{960, 3168},
	{940, 3162},
	{895, 3157},
	{890, 3151},
	{863, 3143},
	{925, 3133},
	{893, 3125},
	{893, 3125},
	{893, 3125},
	{893, 3125},
	{893, 3125},
	{893, 3125},
	{893, 3125}
};

/* T1 0C*/
R_PROFILE_STRUCT r_profile_t1[] = {
	{258, 4316},
	{258, 4283},
	{278, 4244},
	{303, 4210},
	{333, 4185},
	{343, 4164},
	{350, 4144},
	{365, 4128},
	{370, 4109},
	{370, 4093},
	{380, 4080},
	{403, 4069},
	{395, 4047},
	{403, 4023},
	{403, 4003},
	{413, 3989},
	{418, 3977},
	{420, 3967},
	{423, 3955},
	{415, 3940},
	{410, 3923},
	{400, 3907},
	{393, 3891},
	{393, 3877},
	{388, 3864},
	{395, 3855},
	{403, 3846},
	{405, 3837},
	{415, 3831},
	{425, 3823},
	{430, 3815},
	{443, 3811},
	{450, 3804},
	{465, 3799},
	{475, 3794},
	{483, 3790},
	{490, 3785},
	{503, 3782},
	{520, 3778},
	{533, 3773},
	{545, 3768},
	{563, 3761},
	{588, 3753},
	{600, 3742},
	{608, 3727},
	{615, 3712},
	{635, 3704},
	{670, 3701},
	{710, 3698},
	{765, 3692},
	{840, 3680},
	{880, 3625},
	{915, 3528},
	{1080, 3472},
	{1323, 3403},
	{1315, 3323},
	{1180, 3267},
	{1080, 3230},
	{1010, 3203},
	{958, 3180},
	{925, 3157},
	{888, 3141},
	{860, 3124},
	{810, 3109},
	{788, 3096},
	{765, 3084},
	{700, 3079},
	{745, 3067},
	{680, 3058},
	{685, 3047},
	{650, 3041},
	{683, 3032},
	{615, 3029},
	{643, 3018},
	{660, 3008},
	{635, 3002},
	{530, 3003},
	{640, 2995},
	{595, 2985},
	{535, 2983},
	{463, 2979},
	{600, 2967}
};

/* T2 25C*/
R_PROFILE_STRUCT r_profile_t2[] = {
	{173, 4317},
	{173, 4292},
	{175, 4270},
	{170, 4250},
	{173, 4231},
	{173, 4213},
	{178, 4195},
	{173, 4176},
	{183, 4159},
	{193, 4143},
	{193, 4125},
	{203, 4110},
	{205, 4093},
	{208, 4077},
	{205, 4061},
	{213, 4047},
	{215, 4030},
	{223, 4014},
	{230, 4001},
	{233, 3988},
	{240, 3976},
	{243, 3962},
	{248, 3951},
	{243, 3935},
	{223, 3916},
	{203, 3897},
	{195, 3881},
	{188, 3869},
	{188, 3859},
	{185, 3849},
	{183, 3840},
	{195, 3835},
	{198, 3827},
	{195, 3820},
	{198, 3813},
	{200, 3807},
	{208, 3803},
	{205, 3797},
	{205, 3790},
	{205, 3786},
	{210, 3782},
	{213, 3777},
	{208, 3770},
	{203, 3763},
	{198, 3755},
	{195, 3745},
	{198, 3734},
	{193, 3717},
	{193, 3699},
	{193, 3692},
	{195, 3690},
	{205, 3689},
	{220, 3688},
	{238, 3676},
	{238, 3623},
	{255, 3548},
	{293, 3500},
	{330, 3482},
	{390, 3442},
	{485, 3323},
	{1018, 3204},
	{925, 3162},
	{838, 3128},
	{748, 3098},
	{720, 3073},
	{668, 3053},
	{608, 3036},
	{560, 3023},
	{550, 3012},
	{558, 2998},
	{538, 2987},
	{515, 2978},
	{485, 2971},
	{458, 2963},
	{455, 2958},
	{403, 2956},
	{398, 2953},
	{373, 2948},
	{373, 2940},
	{408, 2934},
	{420, 2929},
	{335, 2926}
};

/* T3 50C*/
R_PROFILE_STRUCT r_profile_t3[] = {
	{123, 4331},
	{123, 4305},
	{128, 4284},
	{130, 4265},
	{130, 4244},
	{130, 4225},
	{128, 4206},
	{125, 4188},
	{130, 4170},
	{133, 4153},
	{133, 4135},
	{138, 4119},
	{138, 4102},
	{140, 4085},
	{140, 4069},
	{143, 4054},
	{140, 4038},
	{143, 4023},
	{148, 4010},
	{153, 3996},
	{155, 3984},
	{155, 3970},
	{165, 3958},
	{175, 3947},
	{175, 3934},
	{178, 3921},
	{170, 3904},
	{148, 3884},
	{135, 3868},
	{135, 3857},
	{133, 3848},
	{133, 3838},
	{135, 3832},
	{135, 3824},
	{135, 3817},
	{143, 3811},
	{145, 3806},
	{148, 3800},
	{145, 3794},
	{153, 3790},
	{150, 3784},
	{150, 3777},
	{133, 3763},
	{143, 3758},
	{140, 3750},
	{138, 3742},
	{135, 3733},
	{135, 3723},
	{133, 3709},
	{133, 3694},
	{130, 3678},
	{130, 3676},
	{138, 3675},
	{148, 3674},
	{160, 3669},
	{158, 3625},
	{170, 3547},
	{208, 3495},
	{220, 3458},
	{265, 3331},
	{855, 3140},
	{725, 3078},
	{600, 3033},
	{528, 3001},
	{460, 2980},
	{400, 2960},
	{380, 2944},
	{355, 2932},
	{315, 2921},
	{303, 2913},
	{308, 2903},
	{255, 2899},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889},
	{273, 2889}
};

/* r-table profile for actual temperature. The size should be the same as T1, T2 and T3*/
R_PROFILE_STRUCT r_profile_temperature[] = {
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0}
};

/* ============================================================*/
/* function prototype*/
/* ============================================================*/
int fgauge_get_saddles(void);
BATTERY_PROFILE_STRUCT_P fgauge_get_profile(kal_uint32 temperature);

int fgauge_get_saddles_r_table(void);
R_PROFILE_STRUCT_P fgauge_get_profile_r_table(kal_uint32 temperature);

#endif

