#include <linux/kernel.h>
#include <linux/module.h>

#include <mach/upmu_sw.h>
#include <mach/upmu_hw.h>
#include <mach/upmu_common.h>

const PMU_FLAG_TABLE_ENTRY pmu_flags_table[] = {
	{PMIC_THR_DET_DIS, MT6351_PMIC_THR_DET_DIS_ADDR, MT6351_PMIC_THR_DET_DIS_MASK,
	 MT6351_PMIC_THR_DET_DIS_SHIFT},
	{PMIC_THR_TEST, MT6351_PMIC_THR_TEST_ADDR, MT6351_PMIC_THR_TEST_MASK,
	 MT6351_PMIC_THR_TEST_SHIFT},
	{PMIC_THR_HWPDN_EN, MT6351_PMIC_THR_HWPDN_EN_ADDR, MT6351_PMIC_THR_HWPDN_EN_MASK,
	 MT6351_PMIC_THR_HWPDN_EN_SHIFT},
	{PMIC_STRUP_THERMAL_DEB_SEL, MT6351_PMIC_STRUP_THERMAL_DEB_SEL_ADDR,
	 MT6351_PMIC_STRUP_THERMAL_DEB_SEL_MASK, MT6351_PMIC_STRUP_THERMAL_DEB_SEL_SHIFT},
	{PMIC_USBDL, MT6351_PMIC_USBDL_ADDR, MT6351_PMIC_USBDL_MASK,
	 MT6351_PMIC_USBDL_SHIFT},
	{PMIC_PMU_THERMAL_DEB, MT6351_PMIC_PMU_THERMAL_DEB_ADDR,
	 MT6351_PMIC_PMU_THERMAL_DEB_MASK, MT6351_PMIC_PMU_THERMAL_DEB_SHIFT},
	{PMIC_PMU_THR_DEB, MT6351_PMIC_PMU_THR_DEB_ADDR, MT6351_PMIC_PMU_THR_DEB_MASK,
	 MT6351_PMIC_PMU_THR_DEB_SHIFT},
	{PMIC_PMU_THR_STATUS, MT6351_PMIC_PMU_THR_STATUS_ADDR,
	 MT6351_PMIC_PMU_THR_STATUS_MASK, MT6351_PMIC_PMU_THR_STATUS_SHIFT},
	{PMIC_STRUP_THER_DEB_RMAX, MT6351_PMIC_STRUP_THER_DEB_RMAX_ADDR,
	 MT6351_PMIC_STRUP_THER_DEB_RMAX_MASK, MT6351_PMIC_STRUP_THER_DEB_RMAX_SHIFT},
	{PMIC_STRUP_THER_DEB_FMAX, MT6351_PMIC_STRUP_THER_DEB_FMAX_ADDR,
	 MT6351_PMIC_STRUP_THER_DEB_FMAX_MASK, MT6351_PMIC_STRUP_THER_DEB_FMAX_SHIFT},
	{PMIC_DDUVLO_DEB_EN, MT6351_PMIC_DDUVLO_DEB_EN_ADDR,
	 MT6351_PMIC_DDUVLO_DEB_EN_MASK, MT6351_PMIC_DDUVLO_DEB_EN_SHIFT},
	{PMIC_PWRBB_DEB_EN, MT6351_PMIC_PWRBB_DEB_EN_ADDR, MT6351_PMIC_PWRBB_DEB_EN_MASK,
	 MT6351_PMIC_PWRBB_DEB_EN_SHIFT},
	{PMIC_STRUP_OSC_EN, MT6351_PMIC_STRUP_OSC_EN_ADDR, MT6351_PMIC_STRUP_OSC_EN_MASK,
	 MT6351_PMIC_STRUP_OSC_EN_SHIFT},
	{PMIC_STRUP_OSC_EN_SEL, MT6351_PMIC_STRUP_OSC_EN_SEL_ADDR,
	 MT6351_PMIC_STRUP_OSC_EN_SEL_MASK, MT6351_PMIC_STRUP_OSC_EN_SEL_SHIFT},
	{PMIC_STRUP_FT_CTRL, MT6351_PMIC_STRUP_FT_CTRL_ADDR,
	 MT6351_PMIC_STRUP_FT_CTRL_MASK, MT6351_PMIC_STRUP_FT_CTRL_SHIFT},
	{PMIC_STRUP_PWRON_FORCE, MT6351_PMIC_STRUP_PWRON_FORCE_ADDR,
	 MT6351_PMIC_STRUP_PWRON_FORCE_MASK, MT6351_PMIC_STRUP_PWRON_FORCE_SHIFT},
	{PMIC_BIAS_GEN_EN_FORCE, MT6351_PMIC_BIAS_GEN_EN_FORCE_ADDR,
	 MT6351_PMIC_BIAS_GEN_EN_FORCE_MASK, MT6351_PMIC_BIAS_GEN_EN_FORCE_SHIFT},
	{PMIC_STRUP_PWRON, MT6351_PMIC_STRUP_PWRON_ADDR, MT6351_PMIC_STRUP_PWRON_MASK,
	 MT6351_PMIC_STRUP_PWRON_SHIFT},
	{PMIC_STRUP_PWRON_SEL, MT6351_PMIC_STRUP_PWRON_SEL_ADDR,
	 MT6351_PMIC_STRUP_PWRON_SEL_MASK, MT6351_PMIC_STRUP_PWRON_SEL_SHIFT},
	{PMIC_BIAS_GEN_EN, MT6351_PMIC_BIAS_GEN_EN_ADDR, MT6351_PMIC_BIAS_GEN_EN_MASK,
	 MT6351_PMIC_BIAS_GEN_EN_SHIFT},
	{PMIC_BIAS_GEN_EN_SEL, MT6351_PMIC_BIAS_GEN_EN_SEL_ADDR,
	 MT6351_PMIC_BIAS_GEN_EN_SEL_MASK, MT6351_PMIC_BIAS_GEN_EN_SEL_SHIFT},
	{PMIC_RTC_XOSC32_ENB_SW, MT6351_PMIC_RTC_XOSC32_ENB_SW_ADDR,
	 MT6351_PMIC_RTC_XOSC32_ENB_SW_MASK, MT6351_PMIC_RTC_XOSC32_ENB_SW_SHIFT},
	{PMIC_RTC_XOSC32_ENB_SEL, MT6351_PMIC_RTC_XOSC32_ENB_SEL_ADDR,
	 MT6351_PMIC_RTC_XOSC32_ENB_SEL_MASK, MT6351_PMIC_RTC_XOSC32_ENB_SEL_SHIFT},
	{PMIC_STRUP_DIG_IO_PG_FORCE, MT6351_PMIC_STRUP_DIG_IO_PG_FORCE_ADDR,
	 MT6351_PMIC_STRUP_DIG_IO_PG_FORCE_MASK, MT6351_PMIC_STRUP_DIG_IO_PG_FORCE_SHIFT},
	{PMIC_RG_STRUP_VUSB33_PG_H2L_EN, MT6351_PMIC_RG_STRUP_VUSB33_PG_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VUSB33_PG_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VUSB33_PG_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VGPU_PG_H2L_EN, MT6351_PMIC_RG_STRUP_VGPU_PG_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VGPU_PG_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VGPU_PG_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VDRAM_PG_H2L_EN, MT6351_PMIC_RG_STRUP_VDRAM_PG_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VDRAM_PG_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VDRAM_PG_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VSRAM_PROC_PG_H2L_EN,
	 MT6351_PMIC_RG_STRUP_VSRAM_PROC_PG_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VSRAM_PROC_PG_H2L_EN_MASK,
	 MT6351_PMIC_RG_STRUP_VSRAM_PROC_PG_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VSRAM_MD_PG_H2L_EN, MT6351_PMIC_RG_STRUP_VSRAM_MD_PG_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VSRAM_MD_PG_H2L_EN_MASK,
	 MT6351_PMIC_RG_STRUP_VSRAM_MD_PG_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VA10_PG_H2L_EN, MT6351_PMIC_RG_STRUP_VA10_PG_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VA10_PG_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VA10_PG_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VEMC_PG_H2L_EN, MT6351_PMIC_RG_STRUP_VEMC_PG_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VEMC_PG_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VEMC_PG_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VS2_PG_H2L_EN, MT6351_PMIC_RG_STRUP_VS2_PG_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VS2_PG_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VS2_PG_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VMODEM_PG_H2L_EN, MT6351_PMIC_RG_STRUP_VMODEM_PG_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VMODEM_PG_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VMODEM_PG_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VMD1_PG_H2L_EN, MT6351_PMIC_RG_STRUP_VMD1_PG_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VMD1_PG_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VMD1_PG_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VCORE_PG_H2L_EN, MT6351_PMIC_RG_STRUP_VCORE_PG_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VCORE_PG_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VCORE_PG_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VA18_PG_H2L_EN, MT6351_PMIC_RG_STRUP_VA18_PG_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VA18_PG_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VA18_PG_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VS1_PG_H2L_EN, MT6351_PMIC_RG_STRUP_VS1_PG_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VS1_PG_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VS1_PG_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VTCXO24_PG_ENB, MT6351_PMIC_RG_STRUP_VTCXO24_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VTCXO24_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VTCXO24_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VUSB33_PG_ENB, MT6351_PMIC_RG_STRUP_VUSB33_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VUSB33_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VUSB33_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VGPU_PG_ENB, MT6351_PMIC_RG_STRUP_VGPU_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VGPU_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VGPU_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VDRAM_PG_ENB, MT6351_PMIC_RG_STRUP_VDRAM_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VDRAM_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VDRAM_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VSRAM_PROC_PG_ENB, MT6351_PMIC_RG_STRUP_VSRAM_PROC_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VSRAM_PROC_PG_ENB_MASK,
	 MT6351_PMIC_RG_STRUP_VSRAM_PROC_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VSRAM_MD_PG_ENB, MT6351_PMIC_RG_STRUP_VSRAM_MD_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VSRAM_MD_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VSRAM_MD_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VIO28_PG_ENB, MT6351_PMIC_RG_STRUP_VIO28_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VIO28_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VIO28_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VA10_PG_ENB, MT6351_PMIC_RG_STRUP_VA10_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VA10_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VA10_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VEMC_PG_ENB, MT6351_PMIC_RG_STRUP_VEMC_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VEMC_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VEMC_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VIO18_PG_ENB, MT6351_PMIC_RG_STRUP_VIO18_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VIO18_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VIO18_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VS2_PG_ENB, MT6351_PMIC_RG_STRUP_VS2_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VS2_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VS2_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VMODEM_PG_ENB, MT6351_PMIC_RG_STRUP_VMODEM_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VMODEM_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VMODEM_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VMD1_PG_ENB, MT6351_PMIC_RG_STRUP_VMD1_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VMD1_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VMD1_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VCORE_PG_ENB, MT6351_PMIC_RG_STRUP_VCORE_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VCORE_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VCORE_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VA18_PG_ENB, MT6351_PMIC_RG_STRUP_VA18_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VA18_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VA18_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VS1_PG_ENB, MT6351_PMIC_RG_STRUP_VS1_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VS1_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VS1_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VXO22_PG_ENB, MT6351_PMIC_RG_STRUP_VXO22_PG_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VXO22_PG_ENB_MASK, MT6351_PMIC_RG_STRUP_VXO22_PG_ENB_SHIFT},
	{PMIC_RG_STRUP_VGPU_OC_H2L_EN, MT6351_PMIC_RG_STRUP_VGPU_OC_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VGPU_OC_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VGPU_OC_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VSRAM_MD_OC_H2L_EN, MT6351_PMIC_RG_STRUP_VSRAM_MD_OC_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VSRAM_MD_OC_H2L_EN_MASK,
	 MT6351_PMIC_RG_STRUP_VSRAM_MD_OC_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VS2_OC_H2L_EN, MT6351_PMIC_RG_STRUP_VS2_OC_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VS2_OC_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VS2_OC_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VMODEM_OC_H2L_EN, MT6351_PMIC_RG_STRUP_VMODEM_OC_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VMODEM_OC_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VMODEM_OC_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VMD1_OC_H2L_EN, MT6351_PMIC_RG_STRUP_VMD1_OC_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VMD1_OC_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VMD1_OC_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VCORE_OC_H2L_EN, MT6351_PMIC_RG_STRUP_VCORE_OC_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VCORE_OC_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VCORE_OC_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VS1_OC_H2L_EN, MT6351_PMIC_RG_STRUP_VS1_OC_H2L_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_VS1_OC_H2L_EN_MASK, MT6351_PMIC_RG_STRUP_VS1_OC_H2L_EN_SHIFT},
	{PMIC_RG_STRUP_VGPU_OC_ENB, MT6351_PMIC_RG_STRUP_VGPU_OC_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VGPU_OC_ENB_MASK, MT6351_PMIC_RG_STRUP_VGPU_OC_ENB_SHIFT},
	{PMIC_RG_STRUP_VSRAM_MD_OC_ENB, MT6351_PMIC_RG_STRUP_VSRAM_MD_OC_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VSRAM_MD_OC_ENB_MASK, MT6351_PMIC_RG_STRUP_VSRAM_MD_OC_ENB_SHIFT},
	{PMIC_RG_STRUP_VS2_OC_ENB, MT6351_PMIC_RG_STRUP_VS2_OC_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VS2_OC_ENB_MASK, MT6351_PMIC_RG_STRUP_VS2_OC_ENB_SHIFT},
	{PMIC_RG_STRUP_VMODEM_OC_ENB, MT6351_PMIC_RG_STRUP_VMODEM_OC_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VMODEM_OC_ENB_MASK, MT6351_PMIC_RG_STRUP_VMODEM_OC_ENB_SHIFT},
	{PMIC_RG_STRUP_VMD1_OC_ENB, MT6351_PMIC_RG_STRUP_VMD1_OC_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VMD1_OC_ENB_MASK, MT6351_PMIC_RG_STRUP_VMD1_OC_ENB_SHIFT},
	{PMIC_RG_STRUP_VCORE_OC_ENB, MT6351_PMIC_RG_STRUP_VCORE_OC_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VCORE_OC_ENB_MASK, MT6351_PMIC_RG_STRUP_VCORE_OC_ENB_SHIFT},
	{PMIC_RG_STRUP_VS1_OC_ENB, MT6351_PMIC_RG_STRUP_VS1_OC_ENB_ADDR,
	 MT6351_PMIC_RG_STRUP_VS1_OC_ENB_MASK, MT6351_PMIC_RG_STRUP_VS1_OC_ENB_SHIFT},
	{PMIC_RG_STRUP_VDRAM_PG_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VDRAM_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VDRAM_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VDRAM_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VXO22_PG_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VXO22_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VXO22_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VXO22_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VGPU_OC_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VGPU_OC_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VGPU_OC_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VGPU_OC_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VSRAM_MD_OC_DEB_BYPASS,
	 MT6351_PMIC_RG_STRUP_VSRAM_MD_OC_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VSRAM_MD_OC_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VSRAM_MD_OC_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VS2_OC_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VS2_OC_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VS2_OC_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VS2_OC_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VMODEM_OC_DEB_BYPASS,
	 MT6351_PMIC_RG_STRUP_VMODEM_OC_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VMODEM_OC_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VMODEM_OC_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VMD1_OC_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VMD1_OC_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VMD1_OC_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VMD1_OC_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VCORE_OC_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VCORE_OC_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VCORE_OC_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VCORE_OC_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VS1_OC_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VS1_OC_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VS1_OC_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VS1_OC_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VTCXO24_PG_DEB_BYPASS,
	 MT6351_PMIC_RG_STRUP_VTCXO24_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VTCXO24_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VTCXO24_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VUSB33_PG_DEB_BYPASS,
	 MT6351_PMIC_RG_STRUP_VUSB33_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VUSB33_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VUSB33_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VGPU_PG_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VGPU_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VGPU_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VGPU_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VSRAM_DRAM_PG_DEB_BYPASS,
	 MT6351_PMIC_RG_STRUP_VSRAM_DRAM_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VSRAM_DRAM_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VSRAM_DRAM_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VSRAM_PROC_PG_DEB_BYPASS,
	 MT6351_PMIC_RG_STRUP_VSRAM_PROC_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VSRAM_PROC_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VSRAM_PROC_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VSRAM_MD_PG_DEB_BYPASS,
	 MT6351_PMIC_RG_STRUP_VSRAM_MD_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VSRAM_MD_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VSRAM_MD_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VIO28_PG_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VIO28_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VIO28_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VIO28_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VA10_PG_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VA10_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VA10_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VA10_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VEMC_PG_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VEMC_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VEMC_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VEMC_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VIO18_PG_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VIO18_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VIO18_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VIO18_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VS2_PG_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VS2_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VS2_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VS2_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VMODEM_PG_DEB_BYPASS,
	 MT6351_PMIC_RG_STRUP_VMODEM_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VMODEM_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VMODEM_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VMD1_PG_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VMD1_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VMD1_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VMD1_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VCORE_PG_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VCORE_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VCORE_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VCORE_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VA18_PG_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VA18_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VA18_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VA18_PG_DEB_BYPASS_SHIFT},
	{PMIC_RG_STRUP_VS1_PG_DEB_BYPASS, MT6351_PMIC_RG_STRUP_VS1_PG_DEB_BYPASS_ADDR,
	 MT6351_PMIC_RG_STRUP_VS1_PG_DEB_BYPASS_MASK,
	 MT6351_PMIC_RG_STRUP_VS1_PG_DEB_BYPASS_SHIFT},
	{PMIC_CLR_JUST_RST, MT6351_PMIC_CLR_JUST_RST_ADDR, MT6351_PMIC_CLR_JUST_RST_MASK,
	 MT6351_PMIC_CLR_JUST_RST_SHIFT},
	{PMIC_UVLO_L2H_DEB_EN, MT6351_PMIC_UVLO_L2H_DEB_EN_ADDR,
	 MT6351_PMIC_UVLO_L2H_DEB_EN_MASK, MT6351_PMIC_UVLO_L2H_DEB_EN_SHIFT},
	{PMIC_JUST_PWRKEY_RST, MT6351_PMIC_JUST_PWRKEY_RST_ADDR,
	 MT6351_PMIC_JUST_PWRKEY_RST_MASK, MT6351_PMIC_JUST_PWRKEY_RST_SHIFT},
	{PMIC_DA_QI_OSC_EN, MT6351_PMIC_DA_QI_OSC_EN_ADDR, MT6351_PMIC_DA_QI_OSC_EN_MASK,
	 MT6351_PMIC_DA_QI_OSC_EN_SHIFT},
	{PMIC_STRUP_EXT_PMIC_EN, MT6351_PMIC_STRUP_EXT_PMIC_EN_ADDR,
	 MT6351_PMIC_STRUP_EXT_PMIC_EN_MASK, MT6351_PMIC_STRUP_EXT_PMIC_EN_SHIFT},
	{PMIC_STRUP_EXT_PMIC_SEL, MT6351_PMIC_STRUP_EXT_PMIC_SEL_ADDR,
	 MT6351_PMIC_STRUP_EXT_PMIC_SEL_MASK, MT6351_PMIC_STRUP_EXT_PMIC_SEL_SHIFT},
	{PMIC_STRUP_CON8_RSV0, MT6351_PMIC_STRUP_CON8_RSV0_ADDR,
	 MT6351_PMIC_STRUP_CON8_RSV0_MASK, MT6351_PMIC_STRUP_CON8_RSV0_SHIFT},
	{PMIC_DA_QI_EXT_PMIC_EN, MT6351_PMIC_DA_QI_EXT_PMIC_EN_ADDR,
	 MT6351_PMIC_DA_QI_EXT_PMIC_EN_MASK, MT6351_PMIC_DA_QI_EXT_PMIC_EN_SHIFT},
	{PMIC_STRUP_AUXADC_START_SW, MT6351_PMIC_STRUP_AUXADC_START_SW_ADDR,
	 MT6351_PMIC_STRUP_AUXADC_START_SW_MASK, MT6351_PMIC_STRUP_AUXADC_START_SW_SHIFT},
	{PMIC_STRUP_AUXADC_RSTB_SW, MT6351_PMIC_STRUP_AUXADC_RSTB_SW_ADDR,
	 MT6351_PMIC_STRUP_AUXADC_RSTB_SW_MASK, MT6351_PMIC_STRUP_AUXADC_RSTB_SW_SHIFT},
	{PMIC_STRUP_AUXADC_START_SEL, MT6351_PMIC_STRUP_AUXADC_START_SEL_ADDR,
	 MT6351_PMIC_STRUP_AUXADC_START_SEL_MASK, MT6351_PMIC_STRUP_AUXADC_START_SEL_SHIFT},
	{PMIC_STRUP_AUXADC_RSTB_SEL, MT6351_PMIC_STRUP_AUXADC_RSTB_SEL_ADDR,
	 MT6351_PMIC_STRUP_AUXADC_RSTB_SEL_MASK, MT6351_PMIC_STRUP_AUXADC_RSTB_SEL_SHIFT},
	{PMIC_STRUP_PWROFF_SEQ_EN, MT6351_PMIC_STRUP_PWROFF_SEQ_EN_ADDR,
	 MT6351_PMIC_STRUP_PWROFF_SEQ_EN_MASK, MT6351_PMIC_STRUP_PWROFF_SEQ_EN_SHIFT},
	{PMIC_STRUP_PWROFF_PREOFF_EN, MT6351_PMIC_STRUP_PWROFF_PREOFF_EN_ADDR,
	 MT6351_PMIC_STRUP_PWROFF_PREOFF_EN_MASK, MT6351_PMIC_STRUP_PWROFF_PREOFF_EN_SHIFT},
	{PMIC_STRUP_PP_EN, MT6351_PMIC_STRUP_PP_EN_ADDR, MT6351_PMIC_STRUP_PP_EN_MASK,
	 MT6351_PMIC_STRUP_PP_EN_SHIFT},
	{PMIC_STRUP_PP_EN_SEL, MT6351_PMIC_STRUP_PP_EN_SEL_ADDR,
	 MT6351_PMIC_STRUP_PP_EN_SEL_MASK, MT6351_PMIC_STRUP_PP_EN_SEL_SHIFT},
	{PMIC_STRUP_DIG0_RSV0, MT6351_PMIC_STRUP_DIG0_RSV0_ADDR,
	 MT6351_PMIC_STRUP_DIG0_RSV0_MASK, MT6351_PMIC_STRUP_DIG0_RSV0_SHIFT},
	{PMIC_STRUP_DIG1_RSV0, MT6351_PMIC_STRUP_DIG1_RSV0_ADDR,
	 MT6351_PMIC_STRUP_DIG1_RSV0_MASK, MT6351_PMIC_STRUP_DIG1_RSV0_SHIFT},
	{PMIC_RG_RSV_SWREG, MT6351_PMIC_RG_RSV_SWREG_ADDR, MT6351_PMIC_RG_RSV_SWREG_MASK,
	 MT6351_PMIC_RG_RSV_SWREG_SHIFT},
	{PMIC_STRUP_PP_EN_PWROFF_CNT, MT6351_PMIC_STRUP_PP_EN_PWROFF_CNT_ADDR,
	 MT6351_PMIC_STRUP_PP_EN_PWROFF_CNT_MASK, MT6351_PMIC_STRUP_PP_EN_PWROFF_CNT_SHIFT},
	{PMIC_STRUP_UVLO_U1U2_SEL, MT6351_PMIC_STRUP_UVLO_U1U2_SEL_ADDR,
	 MT6351_PMIC_STRUP_UVLO_U1U2_SEL_MASK, MT6351_PMIC_STRUP_UVLO_U1U2_SEL_SHIFT},
	{PMIC_STRUP_UVLO_U1U2_SEL_SWCTRL, MT6351_PMIC_STRUP_UVLO_U1U2_SEL_SWCTRL_ADDR,
	 MT6351_PMIC_STRUP_UVLO_U1U2_SEL_SWCTRL_MASK,
	 MT6351_PMIC_STRUP_UVLO_U1U2_SEL_SWCTRL_SHIFT},
	{PMIC_STRUP_AUXADC_RPCNT_MAX, MT6351_PMIC_STRUP_AUXADC_RPCNT_MAX_ADDR,
	 MT6351_PMIC_STRUP_AUXADC_RPCNT_MAX_MASK, MT6351_PMIC_STRUP_AUXADC_RPCNT_MAX_SHIFT},
	{PMIC_RG_STRUP_THR_OVER_110_CLR, MT6351_PMIC_RG_STRUP_THR_OVER_110_CLR_ADDR,
	 MT6351_PMIC_RG_STRUP_THR_OVER_110_CLR_MASK, MT6351_PMIC_RG_STRUP_THR_OVER_110_CLR_SHIFT},
	{PMIC_RG_STRUP_THR_110_CLR, MT6351_PMIC_RG_STRUP_THR_110_CLR_ADDR,
	 MT6351_PMIC_RG_STRUP_THR_110_CLR_MASK, MT6351_PMIC_RG_STRUP_THR_110_CLR_SHIFT},
	{PMIC_RG_STRUP_THR_125_CLR, MT6351_PMIC_RG_STRUP_THR_125_CLR_ADDR,
	 MT6351_PMIC_RG_STRUP_THR_125_CLR_MASK, MT6351_PMIC_RG_STRUP_THR_125_CLR_SHIFT},
	{PMIC_RG_STRUP_THR_CLR, MT6351_PMIC_RG_STRUP_THR_CLR_ADDR,
	 MT6351_PMIC_RG_STRUP_THR_CLR_MASK, MT6351_PMIC_RG_STRUP_THR_CLR_SHIFT},
	{PMIC_RG_STRUP_THR_OVER_110_IRQ_EN, MT6351_PMIC_RG_STRUP_THR_OVER_110_IRQ_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_THR_OVER_110_IRQ_EN_MASK,
	 MT6351_PMIC_RG_STRUP_THR_OVER_110_IRQ_EN_SHIFT},
	{PMIC_RG_STRUP_THR_110_IRQ_EN, MT6351_PMIC_RG_STRUP_THR_110_IRQ_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_THR_110_IRQ_EN_MASK, MT6351_PMIC_RG_STRUP_THR_110_IRQ_EN_SHIFT},
	{PMIC_RG_STRUP_THR_125_IRQ_EN, MT6351_PMIC_RG_STRUP_THR_125_IRQ_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_THR_125_IRQ_EN_MASK, MT6351_PMIC_RG_STRUP_THR_125_IRQ_EN_SHIFT},
	{PMIC_RG_STRUP_THR_OVER_110_IRQ_STATUS,
	 MT6351_PMIC_RG_STRUP_THR_OVER_110_IRQ_STATUS_ADDR,
	 MT6351_PMIC_RG_STRUP_THR_OVER_110_IRQ_STATUS_MASK,
	 MT6351_PMIC_RG_STRUP_THR_OVER_110_IRQ_STATUS_SHIFT},
	{PMIC_RG_STRUP_THR_110_IRQ_STATUS, MT6351_PMIC_RG_STRUP_THR_110_IRQ_STATUS_ADDR,
	 MT6351_PMIC_RG_STRUP_THR_110_IRQ_STATUS_MASK,
	 MT6351_PMIC_RG_STRUP_THR_110_IRQ_STATUS_SHIFT},
	{PMIC_RG_STRUP_THR_125_IRQ_STATUS, MT6351_PMIC_RG_STRUP_THR_125_IRQ_STATUS_ADDR,
	 MT6351_PMIC_RG_STRUP_THR_125_IRQ_STATUS_MASK,
	 MT6351_PMIC_RG_STRUP_THR_125_IRQ_STATUS_SHIFT},
	{PMIC_STRUP_PG_STATUS_CLR, MT6351_PMIC_STRUP_PG_STATUS_CLR_ADDR,
	 MT6351_PMIC_STRUP_PG_STATUS_CLR_MASK, MT6351_PMIC_STRUP_PG_STATUS_CLR_SHIFT},
	{PMIC_RG_STRUP_LONG_PRESS_EXT_SEL, MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_SEL_ADDR,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_SEL_MASK,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_SEL_SHIFT},
	{PMIC_RG_STRUP_LONG_PRESS_EXT_TD, MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_TD_ADDR,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_TD_MASK,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_TD_SHIFT},
	{PMIC_RG_STRUP_LONG_PRESS_EXT_EN, MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_EN_ADDR,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_EN_MASK,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_EN_SHIFT},
	{PMIC_RG_STRUP_LONG_PRESS_EXT_CHR_CTRL,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_CHR_CTRL_ADDR,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_CHR_CTRL_MASK,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_CHR_CTRL_SHIFT},
	{PMIC_RG_STRUP_LONG_PRESS_EXT_PWRKY_CTRL,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_PWRKY_CTRL_ADDR,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_PWRKY_CTRL_MASK,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_PWRKY_CTRL_SHIFT},
	{PMIC_RG_STRUP_LONG_PRESS_EXT_PWRBB_CTRL,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_PWRBB_CTRL_ADDR,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_PWRBB_CTRL_MASK,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_EXT_PWRBB_CTRL_SHIFT},
	{PMIC_RG_STRUP_ENVTEM, MT6351_PMIC_RG_STRUP_ENVTEM_ADDR,
	 MT6351_PMIC_RG_STRUP_ENVTEM_MASK, MT6351_PMIC_RG_STRUP_ENVTEM_SHIFT},
	{PMIC_RG_STRUP_ENVTEM_CTRL, MT6351_PMIC_RG_STRUP_ENVTEM_CTRL_ADDR,
	 MT6351_PMIC_RG_STRUP_ENVTEM_CTRL_MASK, MT6351_PMIC_RG_STRUP_ENVTEM_CTRL_SHIFT},
	{PMIC_RG_STRUP_PWRKEY_COUNT_RESET, MT6351_PMIC_RG_STRUP_PWRKEY_COUNT_RESET_ADDR,
	 MT6351_PMIC_RG_STRUP_PWRKEY_COUNT_RESET_MASK,
	 MT6351_PMIC_RG_STRUP_PWRKEY_COUNT_RESET_SHIFT},
	{PMIC_RGS_ANA_CHIP_ID, MT6351_PMIC_RGS_ANA_CHIP_ID_ADDR,
	 MT6351_PMIC_RGS_ANA_CHIP_ID_MASK, MT6351_PMIC_RGS_ANA_CHIP_ID_SHIFT},
	{PMIC_RG_PP_EN_DRVSEL, MT6351_PMIC_RG_PP_EN_DRVSEL_ADDR,
	 MT6351_PMIC_RG_PP_EN_DRVSEL_MASK, MT6351_PMIC_RG_PP_EN_DRVSEL_SHIFT},
	{PMIC_RG_FCHR_PU_EN, MT6351_PMIC_RG_FCHR_PU_EN_ADDR,
	 MT6351_PMIC_RG_FCHR_PU_EN_MASK, MT6351_PMIC_RG_FCHR_PU_EN_SHIFT},
	{PMIC_RG_PMU_RSV, MT6351_PMIC_RG_PMU_RSV_ADDR, MT6351_PMIC_RG_PMU_RSV_MASK,
	 MT6351_PMIC_RG_PMU_RSV_SHIFT},
	{PMIC_RG_FCHR_KEYDET_EN, MT6351_PMIC_RG_FCHR_KEYDET_EN_ADDR,
	 MT6351_PMIC_RG_FCHR_KEYDET_EN_MASK, MT6351_PMIC_RG_FCHR_KEYDET_EN_SHIFT},
	{PMIC_RG_EN_DRVSEL, MT6351_PMIC_RG_EN_DRVSEL_ADDR, MT6351_PMIC_RG_EN_DRVSEL_MASK,
	 MT6351_PMIC_RG_EN_DRVSEL_SHIFT},
	{PMIC_RG_RST_DRVSEL, MT6351_PMIC_RG_RST_DRVSEL_ADDR,
	 MT6351_PMIC_RG_RST_DRVSEL_MASK, MT6351_PMIC_RG_RST_DRVSEL_SHIFT},
	{PMIC_RG_STRUP_IREF_TRIM, MT6351_PMIC_RG_STRUP_IREF_TRIM_ADDR,
	 MT6351_PMIC_RG_STRUP_IREF_TRIM_MASK, MT6351_PMIC_RG_STRUP_IREF_TRIM_SHIFT},
	{PMIC_RG_VREF_BG, MT6351_PMIC_RG_VREF_BG_ADDR, MT6351_PMIC_RG_VREF_BG_MASK,
	 MT6351_PMIC_RG_VREF_BG_SHIFT},
	{PMIC_RG_THR_TMODE, MT6351_PMIC_RG_THR_TMODE_ADDR, MT6351_PMIC_RG_THR_TMODE_MASK,
	 MT6351_PMIC_RG_THR_TMODE_SHIFT},
	{PMIC_RG_STRUP_THR_SEL, MT6351_PMIC_RG_STRUP_THR_SEL_ADDR,
	 MT6351_PMIC_RG_STRUP_THR_SEL_MASK, MT6351_PMIC_RG_STRUP_THR_SEL_SHIFT},
	{PMIC_RG_THRDET_SEL, MT6351_PMIC_RG_THRDET_SEL_ADDR,
	 MT6351_PMIC_RG_THRDET_SEL_MASK, MT6351_PMIC_RG_THRDET_SEL_SHIFT},
	{PMIC_HWCID, MT6351_PMIC_HWCID_ADDR, MT6351_PMIC_HWCID_MASK,
	 MT6351_PMIC_HWCID_SHIFT},
	{PMIC_SWCID, MT6351_PMIC_SWCID_ADDR, MT6351_PMIC_SWCID_MASK,
	 MT6351_PMIC_SWCID_SHIFT},
	{PMIC_RG_SRCLKEN_IN0_EN, MT6351_PMIC_RG_SRCLKEN_IN0_EN_ADDR,
	 MT6351_PMIC_RG_SRCLKEN_IN0_EN_MASK, MT6351_PMIC_RG_SRCLKEN_IN0_EN_SHIFT},
	{PMIC_RG_SRCLKEN_IN1_EN, MT6351_PMIC_RG_SRCLKEN_IN1_EN_ADDR,
	 MT6351_PMIC_RG_SRCLKEN_IN1_EN_MASK, MT6351_PMIC_RG_SRCLKEN_IN1_EN_SHIFT},
	{PMIC_RG_OSC_SEL, MT6351_PMIC_RG_OSC_SEL_ADDR, MT6351_PMIC_RG_OSC_SEL_MASK,
	 MT6351_PMIC_RG_OSC_SEL_SHIFT},
	{PMIC_RG_SRCLKEN_IN2_EN, MT6351_PMIC_RG_SRCLKEN_IN2_EN_ADDR,
	 MT6351_PMIC_RG_SRCLKEN_IN2_EN_MASK, MT6351_PMIC_RG_SRCLKEN_IN2_EN_SHIFT},
	{PMIC_RG_SRCLKEN_IN0_HW_MODE, MT6351_PMIC_RG_SRCLKEN_IN0_HW_MODE_ADDR,
	 MT6351_PMIC_RG_SRCLKEN_IN0_HW_MODE_MASK, MT6351_PMIC_RG_SRCLKEN_IN0_HW_MODE_SHIFT},
	{PMIC_RG_SRCLKEN_IN1_HW_MODE, MT6351_PMIC_RG_SRCLKEN_IN1_HW_MODE_ADDR,
	 MT6351_PMIC_RG_SRCLKEN_IN1_HW_MODE_MASK, MT6351_PMIC_RG_SRCLKEN_IN1_HW_MODE_SHIFT},
	{PMIC_RG_OSC_SEL_HW_MODE, MT6351_PMIC_RG_OSC_SEL_HW_MODE_ADDR,
	 MT6351_PMIC_RG_OSC_SEL_HW_MODE_MASK, MT6351_PMIC_RG_OSC_SEL_HW_MODE_SHIFT},
	{PMIC_RG_SRCLKEN_IN_SYNC_EN, MT6351_PMIC_RG_SRCLKEN_IN_SYNC_EN_ADDR,
	 MT6351_PMIC_RG_SRCLKEN_IN_SYNC_EN_MASK, MT6351_PMIC_RG_SRCLKEN_IN_SYNC_EN_SHIFT},
	{PMIC_RG_OSC_EN_AUTO_OFF, MT6351_PMIC_RG_OSC_EN_AUTO_OFF_ADDR,
	 MT6351_PMIC_RG_OSC_EN_AUTO_OFF_MASK, MT6351_PMIC_RG_OSC_EN_AUTO_OFF_SHIFT},
	{PMIC_TEST_OUT, MT6351_PMIC_TEST_OUT_ADDR, MT6351_PMIC_TEST_OUT_MASK,
	 MT6351_PMIC_TEST_OUT_SHIFT},
	{PMIC_RG_MON_FLAG_SEL, MT6351_PMIC_RG_MON_FLAG_SEL_ADDR,
	 MT6351_PMIC_RG_MON_FLAG_SEL_MASK, MT6351_PMIC_RG_MON_FLAG_SEL_SHIFT},
	{PMIC_RG_MON_GRP_SEL, MT6351_PMIC_RG_MON_GRP_SEL_ADDR,
	 MT6351_PMIC_RG_MON_GRP_SEL_MASK, MT6351_PMIC_RG_MON_GRP_SEL_SHIFT},
	{PMIC_RG_NANDTREE_MODE, MT6351_PMIC_RG_NANDTREE_MODE_ADDR,
	 MT6351_PMIC_RG_NANDTREE_MODE_MASK, MT6351_PMIC_RG_NANDTREE_MODE_SHIFT},
	{PMIC_RG_TEST_AUXADC, MT6351_PMIC_RG_TEST_AUXADC_ADDR,
	 MT6351_PMIC_RG_TEST_AUXADC_MASK, MT6351_PMIC_RG_TEST_AUXADC_SHIFT},
	{PMIC_RG_EFUSE_MODE, MT6351_PMIC_RG_EFUSE_MODE_ADDR,
	 MT6351_PMIC_RG_EFUSE_MODE_MASK, MT6351_PMIC_RG_EFUSE_MODE_SHIFT},
	{PMIC_RG_TEST_STRUP, MT6351_PMIC_RG_TEST_STRUP_ADDR,
	 MT6351_PMIC_RG_TEST_STRUP_MASK, MT6351_PMIC_RG_TEST_STRUP_SHIFT},
	{PMIC_TESTMODE_SW, MT6351_PMIC_TESTMODE_SW_ADDR, MT6351_PMIC_TESTMODE_SW_MASK,
	 MT6351_PMIC_TESTMODE_SW_SHIFT},
	{PMIC_EN_STATUS_VLDO28, MT6351_PMIC_EN_STATUS_VLDO28_ADDR,
	 MT6351_PMIC_EN_STATUS_VLDO28_MASK, MT6351_PMIC_EN_STATUS_VLDO28_SHIFT},
	{PMIC_EN_STATUS_VIO28, MT6351_PMIC_EN_STATUS_VIO28_ADDR,
	 MT6351_PMIC_EN_STATUS_VIO28_MASK, MT6351_PMIC_EN_STATUS_VIO28_SHIFT},
	{PMIC_EN_STATUS_VMCH, MT6351_PMIC_EN_STATUS_VMCH_ADDR,
	 MT6351_PMIC_EN_STATUS_VMCH_MASK, MT6351_PMIC_EN_STATUS_VMCH_SHIFT},
	{PMIC_EN_STATUS_VMC, MT6351_PMIC_EN_STATUS_VMC_ADDR,
	 MT6351_PMIC_EN_STATUS_VMC_MASK, MT6351_PMIC_EN_STATUS_VMC_SHIFT},
	{PMIC_EN_STATUS_VEMC, MT6351_PMIC_EN_STATUS_VEMC_ADDR,
	 MT6351_PMIC_EN_STATUS_VEMC_MASK, MT6351_PMIC_EN_STATUS_VEMC_SHIFT},
	{PMIC_EN_STATUS_VSIM2, MT6351_PMIC_EN_STATUS_VSIM2_ADDR,
	 MT6351_PMIC_EN_STATUS_VSIM2_MASK, MT6351_PMIC_EN_STATUS_VSIM2_SHIFT},
	{PMIC_EN_STATUS_VSIM1, MT6351_PMIC_EN_STATUS_VSIM1_ADDR,
	 MT6351_PMIC_EN_STATUS_VSIM1_MASK, MT6351_PMIC_EN_STATUS_VSIM1_SHIFT},
	{PMIC_EN_STATUS_VEFUSE, MT6351_PMIC_EN_STATUS_VEFUSE_ADDR,
	 MT6351_PMIC_EN_STATUS_VEFUSE_MASK, MT6351_PMIC_EN_STATUS_VEFUSE_SHIFT},
	{PMIC_EN_STATUS_VUSB33, MT6351_PMIC_EN_STATUS_VUSB33_ADDR,
	 MT6351_PMIC_EN_STATUS_VUSB33_MASK, MT6351_PMIC_EN_STATUS_VUSB33_SHIFT},
	{PMIC_EN_STATUS_VCN33, MT6351_PMIC_EN_STATUS_VCN33_ADDR,
	 MT6351_PMIC_EN_STATUS_VCN33_MASK, MT6351_PMIC_EN_STATUS_VCN33_SHIFT},
	{PMIC_EN_STATUS_VCAMA, MT6351_PMIC_EN_STATUS_VCAMA_ADDR,
	 MT6351_PMIC_EN_STATUS_VCAMA_MASK, MT6351_PMIC_EN_STATUS_VCAMA_SHIFT},
	{PMIC_EN_STATUS_VCN28, MT6351_PMIC_EN_STATUS_VCN28_ADDR,
	 MT6351_PMIC_EN_STATUS_VCN28_MASK, MT6351_PMIC_EN_STATUS_VCN28_SHIFT},
	{PMIC_EN_STATUS_VTCXO24, MT6351_PMIC_EN_STATUS_VTCXO24_ADDR,
	 MT6351_PMIC_EN_STATUS_VTCXO24_MASK, MT6351_PMIC_EN_STATUS_VTCXO24_SHIFT},
	{PMIC_EN_STATUS_VTCXO28, MT6351_PMIC_EN_STATUS_VTCXO28_ADDR,
	 MT6351_PMIC_EN_STATUS_VTCXO28_MASK, MT6351_PMIC_EN_STATUS_VTCXO28_SHIFT},
	{PMIC_EN_STATUS_VA18, MT6351_PMIC_EN_STATUS_VA18_ADDR,
	 MT6351_PMIC_EN_STATUS_VA18_MASK, MT6351_PMIC_EN_STATUS_VA18_SHIFT},
	{PMIC_EN_STATUS_VRTC, MT6351_PMIC_EN_STATUS_VRTC_ADDR,
	 MT6351_PMIC_EN_STATUS_VRTC_MASK, MT6351_PMIC_EN_STATUS_VRTC_SHIFT},
	{PMIC_EN_STATUS_VBIF28, MT6351_PMIC_EN_STATUS_VBIF28_ADDR,
	 MT6351_PMIC_EN_STATUS_VBIF28_MASK, MT6351_PMIC_EN_STATUS_VBIF28_SHIFT},
	{PMIC_EN_STATUS_VGP3, MT6351_PMIC_EN_STATUS_VGP3_ADDR,
	 MT6351_PMIC_EN_STATUS_VGP3_MASK, MT6351_PMIC_EN_STATUS_VGP3_SHIFT},
	{PMIC_EN_STATUS_VMIPI, MT6351_PMIC_EN_STATUS_VMIPI_ADDR,
	 MT6351_PMIC_EN_STATUS_VMIPI_MASK, MT6351_PMIC_EN_STATUS_VMIPI_SHIFT},
	{PMIC_EN_STATUS_VDRAM, MT6351_PMIC_EN_STATUS_VDRAM_ADDR,
	 MT6351_PMIC_EN_STATUS_VDRAM_MASK, MT6351_PMIC_EN_STATUS_VDRAM_SHIFT},
	{PMIC_EN_STATUS_VA10, MT6351_PMIC_EN_STATUS_VA10_ADDR,
	 MT6351_PMIC_EN_STATUS_VA10_MASK, MT6351_PMIC_EN_STATUS_VA10_SHIFT},
	{PMIC_EN_STATUS_VRF12, MT6351_PMIC_EN_STATUS_VRF12_ADDR,
	 MT6351_PMIC_EN_STATUS_VRF12_MASK, MT6351_PMIC_EN_STATUS_VRF12_SHIFT},
	{PMIC_EN_STATUS_VXO22, MT6351_PMIC_EN_STATUS_VXO22_ADDR,
	 MT6351_PMIC_EN_STATUS_VXO22_MASK, MT6351_PMIC_EN_STATUS_VXO22_SHIFT},
	{PMIC_EN_STATUS_VSRAM_PROC, MT6351_PMIC_EN_STATUS_VSRAM_PROC_ADDR,
	 MT6351_PMIC_EN_STATUS_VSRAM_PROC_MASK, MT6351_PMIC_EN_STATUS_VSRAM_PROC_SHIFT},
	{PMIC_EN_STATUS_VCAMIO, MT6351_PMIC_EN_STATUS_VCAMIO_ADDR,
	 MT6351_PMIC_EN_STATUS_VCAMIO_MASK, MT6351_PMIC_EN_STATUS_VCAMIO_SHIFT},
	{PMIC_EN_STATUS_VCN18, MT6351_PMIC_EN_STATUS_VCN18_ADDR,
	 MT6351_PMIC_EN_STATUS_VCN18_MASK, MT6351_PMIC_EN_STATUS_VCN18_SHIFT},
	{PMIC_EN_STATUS_VIO18, MT6351_PMIC_EN_STATUS_VIO18_ADDR,
	 MT6351_PMIC_EN_STATUS_VIO18_MASK, MT6351_PMIC_EN_STATUS_VIO18_SHIFT},
	{PMIC_EN_STATUS_VRF18, MT6351_PMIC_EN_STATUS_VRF18_ADDR,
	 MT6351_PMIC_EN_STATUS_VRF18_MASK, MT6351_PMIC_EN_STATUS_VRF18_SHIFT},
	{PMIC_EN_STATUS_VCAMD, MT6351_PMIC_EN_STATUS_VCAMD_ADDR,
	 MT6351_PMIC_EN_STATUS_VCAMD_MASK, MT6351_PMIC_EN_STATUS_VCAMD_SHIFT},
	{PMIC_EN_STATUS_VIBR, MT6351_PMIC_EN_STATUS_VIBR_ADDR,
	 MT6351_PMIC_EN_STATUS_VIBR_MASK, MT6351_PMIC_EN_STATUS_VIBR_SHIFT},
	{PMIC_OC_STATUS_VIBR, MT6351_PMIC_OC_STATUS_VIBR_ADDR,
	 MT6351_PMIC_OC_STATUS_VIBR_MASK, MT6351_PMIC_OC_STATUS_VIBR_SHIFT},
	{PMIC_OC_STATUS_VLDO28, MT6351_PMIC_OC_STATUS_VLDO28_ADDR,
	 MT6351_PMIC_OC_STATUS_VLDO28_MASK, MT6351_PMIC_OC_STATUS_VLDO28_SHIFT},
	{PMIC_OC_STATUS_VIO28, MT6351_PMIC_OC_STATUS_VIO28_ADDR,
	 MT6351_PMIC_OC_STATUS_VIO28_MASK, MT6351_PMIC_OC_STATUS_VIO28_SHIFT},
	{PMIC_OC_STATUS_VMC, MT6351_PMIC_OC_STATUS_VMC_ADDR,
	 MT6351_PMIC_OC_STATUS_VMC_MASK, MT6351_PMIC_OC_STATUS_VMC_SHIFT},
	{PMIC_OC_STATUS_VMCH, MT6351_PMIC_OC_STATUS_VMCH_ADDR,
	 MT6351_PMIC_OC_STATUS_VMCH_MASK, MT6351_PMIC_OC_STATUS_VMCH_SHIFT},
	{PMIC_OC_STATUS_VEMC, MT6351_PMIC_OC_STATUS_VEMC_ADDR,
	 MT6351_PMIC_OC_STATUS_VEMC_MASK, MT6351_PMIC_OC_STATUS_VEMC_SHIFT},
	{PMIC_OC_STATUS_VSIM2, MT6351_PMIC_OC_STATUS_VSIM2_ADDR,
	 MT6351_PMIC_OC_STATUS_VSIM2_MASK, MT6351_PMIC_OC_STATUS_VSIM2_SHIFT},
	{PMIC_OC_STATUS_VSIM1, MT6351_PMIC_OC_STATUS_VSIM1_ADDR,
	 MT6351_PMIC_OC_STATUS_VSIM1_MASK, MT6351_PMIC_OC_STATUS_VSIM1_SHIFT},
	{PMIC_OC_STATUS_VEFUSE, MT6351_PMIC_OC_STATUS_VEFUSE_ADDR,
	 MT6351_PMIC_OC_STATUS_VEFUSE_MASK, MT6351_PMIC_OC_STATUS_VEFUSE_SHIFT},
	{PMIC_OC_STATUS_VUSB33, MT6351_PMIC_OC_STATUS_VUSB33_ADDR,
	 MT6351_PMIC_OC_STATUS_VUSB33_MASK, MT6351_PMIC_OC_STATUS_VUSB33_SHIFT},
	{PMIC_OC_STATUS_VCN33, MT6351_PMIC_OC_STATUS_VCN33_ADDR,
	 MT6351_PMIC_OC_STATUS_VCN33_MASK, MT6351_PMIC_OC_STATUS_VCN33_SHIFT},
	{PMIC_OC_STATUS_VCAMA, MT6351_PMIC_OC_STATUS_VCAMA_ADDR,
	 MT6351_PMIC_OC_STATUS_VCAMA_MASK, MT6351_PMIC_OC_STATUS_VCAMA_SHIFT},
	{PMIC_OC_STATUS_VCN28, MT6351_PMIC_OC_STATUS_VCN28_ADDR,
	 MT6351_PMIC_OC_STATUS_VCN28_MASK, MT6351_PMIC_OC_STATUS_VCN28_SHIFT},
	{PMIC_OC_STATUS_VTCXO24, MT6351_PMIC_OC_STATUS_VTCXO24_ADDR,
	 MT6351_PMIC_OC_STATUS_VTCXO24_MASK, MT6351_PMIC_OC_STATUS_VTCXO24_SHIFT},
	{PMIC_OC_STATUS_VTCXO28, MT6351_PMIC_OC_STATUS_VTCXO28_ADDR,
	 MT6351_PMIC_OC_STATUS_VTCXO28_MASK, MT6351_PMIC_OC_STATUS_VTCXO28_SHIFT},
	{PMIC_OC_STATUS_VA18, MT6351_PMIC_OC_STATUS_VA18_ADDR,
	 MT6351_PMIC_OC_STATUS_VA18_MASK, MT6351_PMIC_OC_STATUS_VA18_SHIFT},
	{PMIC_OC_STATUS_VBIF28, MT6351_PMIC_OC_STATUS_VBIF28_ADDR,
	 MT6351_PMIC_OC_STATUS_VBIF28_MASK, MT6351_PMIC_OC_STATUS_VBIF28_SHIFT},
	{PMIC_OC_STATUS_VGP3, MT6351_PMIC_OC_STATUS_VGP3_ADDR,
	 MT6351_PMIC_OC_STATUS_VGP3_MASK, MT6351_PMIC_OC_STATUS_VGP3_SHIFT},
	{PMIC_OC_STATUS_VMIPI, MT6351_PMIC_OC_STATUS_VMIPI_ADDR,
	 MT6351_PMIC_OC_STATUS_VMIPI_MASK, MT6351_PMIC_OC_STATUS_VMIPI_SHIFT},
	{PMIC_OC_STATUS_VDRAM, MT6351_PMIC_OC_STATUS_VDRAM_ADDR,
	 MT6351_PMIC_OC_STATUS_VDRAM_MASK, MT6351_PMIC_OC_STATUS_VDRAM_SHIFT},
	{PMIC_OC_STATUS_VA10, MT6351_PMIC_OC_STATUS_VA10_ADDR,
	 MT6351_PMIC_OC_STATUS_VA10_MASK, MT6351_PMIC_OC_STATUS_VA10_SHIFT},
	{PMIC_OC_STATUS_VRF12, MT6351_PMIC_OC_STATUS_VRF12_ADDR,
	 MT6351_PMIC_OC_STATUS_VRF12_MASK, MT6351_PMIC_OC_STATUS_VRF12_SHIFT},
	{PMIC_OC_STATUS_VXO22, MT6351_PMIC_OC_STATUS_VXO22_ADDR,
	 MT6351_PMIC_OC_STATUS_VXO22_MASK, MT6351_PMIC_OC_STATUS_VXO22_SHIFT},
	{PMIC_OC_STATUS_VSRAM_PROC, MT6351_PMIC_OC_STATUS_VSRAM_PROC_ADDR,
	 MT6351_PMIC_OC_STATUS_VSRAM_PROC_MASK, MT6351_PMIC_OC_STATUS_VSRAM_PROC_SHIFT},
	{PMIC_OC_STATUS_VCAMIO, MT6351_PMIC_OC_STATUS_VCAMIO_ADDR,
	 MT6351_PMIC_OC_STATUS_VCAMIO_MASK, MT6351_PMIC_OC_STATUS_VCAMIO_SHIFT},
	{PMIC_OC_STATUS_VCN18, MT6351_PMIC_OC_STATUS_VCN18_ADDR,
	 MT6351_PMIC_OC_STATUS_VCN18_MASK, MT6351_PMIC_OC_STATUS_VCN18_SHIFT},
	{PMIC_OC_STATUS_VIO18, MT6351_PMIC_OC_STATUS_VIO18_ADDR,
	 MT6351_PMIC_OC_STATUS_VIO18_MASK, MT6351_PMIC_OC_STATUS_VIO18_SHIFT},
	{PMIC_OC_STATUS_VRF18, MT6351_PMIC_OC_STATUS_VRF18_ADDR,
	 MT6351_PMIC_OC_STATUS_VRF18_MASK, MT6351_PMIC_OC_STATUS_VRF18_SHIFT},
	{PMIC_OC_STATUS_VCAMD, MT6351_PMIC_OC_STATUS_VCAMD_ADDR,
	 MT6351_PMIC_OC_STATUS_VCAMD_MASK, MT6351_PMIC_OC_STATUS_VCAMD_SHIFT},
	{PMIC_VA18_PG_DEB, MT6351_PMIC_VA18_PG_DEB_ADDR, MT6351_PMIC_VA18_PG_DEB_MASK,
	 MT6351_PMIC_VA18_PG_DEB_SHIFT},
	{PMIC_VCORE_PG_DEB, MT6351_PMIC_VCORE_PG_DEB_ADDR, MT6351_PMIC_VCORE_PG_DEB_MASK,
	 MT6351_PMIC_VCORE_PG_DEB_SHIFT},
	{PMIC_VMD1_PG_DEB, MT6351_PMIC_VMD1_PG_DEB_ADDR, MT6351_PMIC_VMD1_PG_DEB_MASK,
	 MT6351_PMIC_VMD1_PG_DEB_SHIFT},
	{PMIC_VMODEM_PG_DEB, MT6351_PMIC_VMODEM_PG_DEB_ADDR,
	 MT6351_PMIC_VMODEM_PG_DEB_MASK, MT6351_PMIC_VMODEM_PG_DEB_SHIFT},
	{PMIC_VS2_PG_DEB, MT6351_PMIC_VS2_PG_DEB_ADDR, MT6351_PMIC_VS2_PG_DEB_MASK,
	 MT6351_PMIC_VS2_PG_DEB_SHIFT},
	{PMIC_VIO18_PG_DEB, MT6351_PMIC_VIO18_PG_DEB_ADDR, MT6351_PMIC_VIO18_PG_DEB_MASK,
	 MT6351_PMIC_VIO18_PG_DEB_SHIFT},
	{PMIC_VEMC_PG_DEB, MT6351_PMIC_VEMC_PG_DEB_ADDR, MT6351_PMIC_VEMC_PG_DEB_MASK,
	 MT6351_PMIC_VEMC_PG_DEB_SHIFT},
	{PMIC_VA10_PG_DEB, MT6351_PMIC_VA10_PG_DEB_ADDR, MT6351_PMIC_VA10_PG_DEB_MASK,
	 MT6351_PMIC_VA10_PG_DEB_SHIFT},
	{PMIC_VIO28_PG_DEB, MT6351_PMIC_VIO28_PG_DEB_ADDR, MT6351_PMIC_VIO28_PG_DEB_MASK,
	 MT6351_PMIC_VIO28_PG_DEB_SHIFT},
	{PMIC_VSRAM_MD_PG_DEB, MT6351_PMIC_VSRAM_MD_PG_DEB_ADDR,
	 MT6351_PMIC_VSRAM_MD_PG_DEB_MASK, MT6351_PMIC_VSRAM_MD_PG_DEB_SHIFT},
	{PMIC_VSRAM_PROC_PG_DEB, MT6351_PMIC_VSRAM_PROC_PG_DEB_ADDR,
	 MT6351_PMIC_VSRAM_PROC_PG_DEB_MASK, MT6351_PMIC_VSRAM_PROC_PG_DEB_SHIFT},
	{PMIC_VDRAM_PG_DEB, MT6351_PMIC_VDRAM_PG_DEB_ADDR, MT6351_PMIC_VDRAM_PG_DEB_MASK,
	 MT6351_PMIC_VDRAM_PG_DEB_SHIFT},
	{PMIC_VGPU_PG_DEB, MT6351_PMIC_VGPU_PG_DEB_ADDR, MT6351_PMIC_VGPU_PG_DEB_MASK,
	 MT6351_PMIC_VGPU_PG_DEB_SHIFT},
	{PMIC_VUSB33_PG_DEB, MT6351_PMIC_VUSB33_PG_DEB_ADDR,
	 MT6351_PMIC_VUSB33_PG_DEB_MASK, MT6351_PMIC_VUSB33_PG_DEB_SHIFT},
	{PMIC_VXO22_PG_DEB, MT6351_PMIC_VXO22_PG_DEB_ADDR, MT6351_PMIC_VXO22_PG_DEB_MASK,
	 MT6351_PMIC_VXO22_PG_DEB_SHIFT},
	{PMIC_VTCXO24_PG_DEB, MT6351_PMIC_VTCXO24_PG_DEB_ADDR,
	 MT6351_PMIC_VTCXO24_PG_DEB_MASK, MT6351_PMIC_VTCXO24_PG_DEB_SHIFT},
	{PMIC_VS1_PG_DEB, MT6351_PMIC_VS1_PG_DEB_ADDR, MT6351_PMIC_VS1_PG_DEB_MASK,
	 MT6351_PMIC_VS1_PG_DEB_SHIFT},
	{PMIC_STRUP_VA18_PG_STATUS, MT6351_PMIC_STRUP_VA18_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VA18_PG_STATUS_MASK, MT6351_PMIC_STRUP_VA18_PG_STATUS_SHIFT},
	{PMIC_STRUP_VCORE_PG_STATUS, MT6351_PMIC_STRUP_VCORE_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VCORE_PG_STATUS_MASK, MT6351_PMIC_STRUP_VCORE_PG_STATUS_SHIFT},
	{PMIC_STRUP_VMD1_PG_STATUS, MT6351_PMIC_STRUP_VMD1_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VMD1_PG_STATUS_MASK, MT6351_PMIC_STRUP_VMD1_PG_STATUS_SHIFT},
	{PMIC_STRUP_VMODEM_PG_STATUS, MT6351_PMIC_STRUP_VMODEM_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VMODEM_PG_STATUS_MASK, MT6351_PMIC_STRUP_VMODEM_PG_STATUS_SHIFT},
	{PMIC_STRUP_VS2_PG_STATUS, MT6351_PMIC_STRUP_VS2_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VS2_PG_STATUS_MASK, MT6351_PMIC_STRUP_VS2_PG_STATUS_SHIFT},
	{PMIC_STRUP_VIO18_PG_STATUS, MT6351_PMIC_STRUP_VIO18_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VIO18_PG_STATUS_MASK, MT6351_PMIC_STRUP_VIO18_PG_STATUS_SHIFT},
	{PMIC_STRUP_VEMC_PG_STATUS, MT6351_PMIC_STRUP_VEMC_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VEMC_PG_STATUS_MASK, MT6351_PMIC_STRUP_VEMC_PG_STATUS_SHIFT},
	{PMIC_STRUP_VA10_PG_STATUS, MT6351_PMIC_STRUP_VA10_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VA10_PG_STATUS_MASK, MT6351_PMIC_STRUP_VA10_PG_STATUS_SHIFT},
	{PMIC_STRUP_VIO28_PG_STATUS, MT6351_PMIC_STRUP_VIO28_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VIO28_PG_STATUS_MASK, MT6351_PMIC_STRUP_VIO28_PG_STATUS_SHIFT},
	{PMIC_STRUP_VSRAM_MD_PG_STATUS, MT6351_PMIC_STRUP_VSRAM_MD_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VSRAM_MD_PG_STATUS_MASK, MT6351_PMIC_STRUP_VSRAM_MD_PG_STATUS_SHIFT},
	{PMIC_STRUP_VSRAM_PROC_PG_STATUS, MT6351_PMIC_STRUP_VSRAM_PROC_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VSRAM_PROC_PG_STATUS_MASK,
	 MT6351_PMIC_STRUP_VSRAM_PROC_PG_STATUS_SHIFT},
	{PMIC_STRUP_VDRAM_PG_STATUS, MT6351_PMIC_STRUP_VDRAM_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VDRAM_PG_STATUS_MASK, MT6351_PMIC_STRUP_VDRAM_PG_STATUS_SHIFT},
	{PMIC_STRUP_VGPU_PG_STATUS, MT6351_PMIC_STRUP_VGPU_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VGPU_PG_STATUS_MASK, MT6351_PMIC_STRUP_VGPU_PG_STATUS_SHIFT},
	{PMIC_STRUP_VUSB33_PG_STATUS, MT6351_PMIC_STRUP_VUSB33_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VUSB33_PG_STATUS_MASK, MT6351_PMIC_STRUP_VUSB33_PG_STATUS_SHIFT},
	{PMIC_STRUP_VXO22_PG_STATUS, MT6351_PMIC_STRUP_VXO22_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VXO22_PG_STATUS_MASK, MT6351_PMIC_STRUP_VXO22_PG_STATUS_SHIFT},
	{PMIC_STRUP_VTCXO24_PG_STATUS, MT6351_PMIC_STRUP_VTCXO24_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VTCXO24_PG_STATUS_MASK, MT6351_PMIC_STRUP_VTCXO24_PG_STATUS_SHIFT},
	{PMIC_STRUP_VS1_PG_STATUS, MT6351_PMIC_STRUP_VS1_PG_STATUS_ADDR,
	 MT6351_PMIC_STRUP_VS1_PG_STATUS_MASK, MT6351_PMIC_STRUP_VS1_PG_STATUS_SHIFT},
	{PMIC_THERMAL_BACK110, MT6351_PMIC_THERMAL_BACK110_ADDR,
	 MT6351_PMIC_THERMAL_BACK110_MASK, MT6351_PMIC_THERMAL_BACK110_SHIFT},
	{PMIC_THERMAL_OVER110, MT6351_PMIC_THERMAL_OVER110_ADDR,
	 MT6351_PMIC_THERMAL_OVER110_MASK, MT6351_PMIC_THERMAL_OVER110_SHIFT},
	{PMIC_THERMAL_OVER125, MT6351_PMIC_THERMAL_OVER125_ADDR,
	 MT6351_PMIC_THERMAL_OVER125_MASK, MT6351_PMIC_THERMAL_OVER125_SHIFT},
	{PMIC_STRUP_THERMAL_STATUS, MT6351_PMIC_STRUP_THERMAL_STATUS_ADDR,
	 MT6351_PMIC_STRUP_THERMAL_STATUS_MASK, MT6351_PMIC_STRUP_THERMAL_STATUS_SHIFT},
	{PMIC_PMU_TEST_MODE_SCAN, MT6351_PMIC_PMU_TEST_MODE_SCAN_ADDR,
	 MT6351_PMIC_PMU_TEST_MODE_SCAN_MASK, MT6351_PMIC_PMU_TEST_MODE_SCAN_SHIFT},
	{PMIC_PWRKEY_DEB, MT6351_PMIC_PWRKEY_DEB_ADDR, MT6351_PMIC_PWRKEY_DEB_MASK,
	 MT6351_PMIC_PWRKEY_DEB_SHIFT},
	{PMIC_HOMEKEY_DEB, MT6351_PMIC_HOMEKEY_DEB_ADDR, MT6351_PMIC_HOMEKEY_DEB_MASK,
	 MT6351_PMIC_HOMEKEY_DEB_SHIFT},
	{PMIC_RTC_XTAL_DET_DONE, MT6351_PMIC_RTC_XTAL_DET_DONE_ADDR,
	 MT6351_PMIC_RTC_XTAL_DET_DONE_MASK, MT6351_PMIC_RTC_XTAL_DET_DONE_SHIFT},
	{PMIC_XOSC32_ENB_DET, MT6351_PMIC_XOSC32_ENB_DET_ADDR,
	 MT6351_PMIC_XOSC32_ENB_DET_MASK, MT6351_PMIC_XOSC32_ENB_DET_SHIFT},
	{PMIC_RTC_XTAL_DET_RSV, MT6351_PMIC_RTC_XTAL_DET_RSV_ADDR,
	 MT6351_PMIC_RTC_XTAL_DET_RSV_MASK, MT6351_PMIC_RTC_XTAL_DET_RSV_SHIFT},
	{PMIC_RG_PMU_TDSEL, MT6351_PMIC_RG_PMU_TDSEL_ADDR, MT6351_PMIC_RG_PMU_TDSEL_MASK,
	 MT6351_PMIC_RG_PMU_TDSEL_SHIFT},
	{PMIC_RG_SPI_TDSEL, MT6351_PMIC_RG_SPI_TDSEL_ADDR, MT6351_PMIC_RG_SPI_TDSEL_MASK,
	 MT6351_PMIC_RG_SPI_TDSEL_SHIFT},
	{PMIC_RG_AUD_TDSEL, MT6351_PMIC_RG_AUD_TDSEL_ADDR, MT6351_PMIC_RG_AUD_TDSEL_MASK,
	 MT6351_PMIC_RG_AUD_TDSEL_SHIFT},
	{PMIC_RG_E32CAL_TDSEL, MT6351_PMIC_RG_E32CAL_TDSEL_ADDR,
	 MT6351_PMIC_RG_E32CAL_TDSEL_MASK, MT6351_PMIC_RG_E32CAL_TDSEL_SHIFT},
	{PMIC_RG_PMU_RDSEL, MT6351_PMIC_RG_PMU_RDSEL_ADDR, MT6351_PMIC_RG_PMU_RDSEL_MASK,
	 MT6351_PMIC_RG_PMU_RDSEL_SHIFT},
	{PMIC_RG_SPI_RDSEL, MT6351_PMIC_RG_SPI_RDSEL_ADDR, MT6351_PMIC_RG_SPI_RDSEL_MASK,
	 MT6351_PMIC_RG_SPI_RDSEL_SHIFT},
	{PMIC_RG_AUD_RDSEL, MT6351_PMIC_RG_AUD_RDSEL_ADDR, MT6351_PMIC_RG_AUD_RDSEL_MASK,
	 MT6351_PMIC_RG_AUD_RDSEL_SHIFT},
	{PMIC_RG_E32CAL_RDSEL, MT6351_PMIC_RG_E32CAL_RDSEL_ADDR,
	 MT6351_PMIC_RG_E32CAL_RDSEL_MASK, MT6351_PMIC_RG_E32CAL_RDSEL_SHIFT},
	{PMIC_RG_SMT_WDTRSTB_IN, MT6351_PMIC_RG_SMT_WDTRSTB_IN_ADDR,
	 MT6351_PMIC_RG_SMT_WDTRSTB_IN_MASK, MT6351_PMIC_RG_SMT_WDTRSTB_IN_SHIFT},
	{PMIC_RG_SMT_HOMEKEY, MT6351_PMIC_RG_SMT_HOMEKEY_ADDR,
	 MT6351_PMIC_RG_SMT_HOMEKEY_MASK, MT6351_PMIC_RG_SMT_HOMEKEY_SHIFT},
	{PMIC_RG_SMT_SRCLKEN_IN0, MT6351_PMIC_RG_SMT_SRCLKEN_IN0_ADDR,
	 MT6351_PMIC_RG_SMT_SRCLKEN_IN0_MASK, MT6351_PMIC_RG_SMT_SRCLKEN_IN0_SHIFT},
	{PMIC_RG_SMT_SRCLKEN_IN1, MT6351_PMIC_RG_SMT_SRCLKEN_IN1_ADDR,
	 MT6351_PMIC_RG_SMT_SRCLKEN_IN1_MASK, MT6351_PMIC_RG_SMT_SRCLKEN_IN1_SHIFT},
	{PMIC_RG_SMT_RTC_32K1V8_0, MT6351_PMIC_RG_SMT_RTC_32K1V8_0_ADDR,
	 MT6351_PMIC_RG_SMT_RTC_32K1V8_0_MASK, MT6351_PMIC_RG_SMT_RTC_32K1V8_0_SHIFT},
	{PMIC_RG_SMT_RTC_32K1V8_1, MT6351_PMIC_RG_SMT_RTC_32K1V8_1_ADDR,
	 MT6351_PMIC_RG_SMT_RTC_32K1V8_1_MASK, MT6351_PMIC_RG_SMT_RTC_32K1V8_1_SHIFT},
	{PMIC_RG_SMT_SPI_CLK, MT6351_PMIC_RG_SMT_SPI_CLK_ADDR,
	 MT6351_PMIC_RG_SMT_SPI_CLK_MASK, MT6351_PMIC_RG_SMT_SPI_CLK_SHIFT},
	{PMIC_RG_SMT_SPI_CSN, MT6351_PMIC_RG_SMT_SPI_CSN_ADDR,
	 MT6351_PMIC_RG_SMT_SPI_CSN_MASK, MT6351_PMIC_RG_SMT_SPI_CSN_SHIFT},
	{PMIC_RG_SMT_SPI_MOSI, MT6351_PMIC_RG_SMT_SPI_MOSI_ADDR,
	 MT6351_PMIC_RG_SMT_SPI_MOSI_MASK, MT6351_PMIC_RG_SMT_SPI_MOSI_SHIFT},
	{PMIC_RG_SMT_SPI_MISO, MT6351_PMIC_RG_SMT_SPI_MISO_ADDR,
	 MT6351_PMIC_RG_SMT_SPI_MISO_MASK, MT6351_PMIC_RG_SMT_SPI_MISO_SHIFT},
	{PMIC_RG_SMT_AUD_CLK, MT6351_PMIC_RG_SMT_AUD_CLK_ADDR,
	 MT6351_PMIC_RG_SMT_AUD_CLK_MASK, MT6351_PMIC_RG_SMT_AUD_CLK_SHIFT},
	{PMIC_RG_SMT_AUD_DAT_MOSI, MT6351_PMIC_RG_SMT_AUD_DAT_MOSI_ADDR,
	 MT6351_PMIC_RG_SMT_AUD_DAT_MOSI_MASK, MT6351_PMIC_RG_SMT_AUD_DAT_MOSI_SHIFT},
	{PMIC_RG_SMT_AUD_DAT_MISO, MT6351_PMIC_RG_SMT_AUD_DAT_MISO_ADDR,
	 MT6351_PMIC_RG_SMT_AUD_DAT_MISO_MASK, MT6351_PMIC_RG_SMT_AUD_DAT_MISO_SHIFT},
	{PMIC_RG_SMT_ANC_DAT_MOSI, MT6351_PMIC_RG_SMT_ANC_DAT_MOSI_ADDR,
	 MT6351_PMIC_RG_SMT_ANC_DAT_MOSI_MASK, MT6351_PMIC_RG_SMT_ANC_DAT_MOSI_SHIFT},
	{PMIC_RG_SMT_VOW_CLK_MISO, MT6351_PMIC_RG_SMT_VOW_CLK_MISO_ADDR,
	 MT6351_PMIC_RG_SMT_VOW_CLK_MISO_MASK, MT6351_PMIC_RG_SMT_VOW_CLK_MISO_SHIFT},
	{PMIC_RG_SMT_ENBB, MT6351_PMIC_RG_SMT_ENBB_ADDR, MT6351_PMIC_RG_SMT_ENBB_MASK,
	 MT6351_PMIC_RG_SMT_ENBB_SHIFT},
	{PMIC_RG_SMT_XOSC_EN, MT6351_PMIC_RG_SMT_XOSC_EN_ADDR,
	 MT6351_PMIC_RG_SMT_XOSC_EN_MASK, MT6351_PMIC_RG_SMT_XOSC_EN_SHIFT},
	{PMIC_RG_OCTL_SRCLKEN_IN0, MT6351_PMIC_RG_OCTL_SRCLKEN_IN0_ADDR,
	 MT6351_PMIC_RG_OCTL_SRCLKEN_IN0_MASK, MT6351_PMIC_RG_OCTL_SRCLKEN_IN0_SHIFT},
	{PMIC_RG_OCTL_SRCLKEN_IN1, MT6351_PMIC_RG_OCTL_SRCLKEN_IN1_ADDR,
	 MT6351_PMIC_RG_OCTL_SRCLKEN_IN1_MASK, MT6351_PMIC_RG_OCTL_SRCLKEN_IN1_SHIFT},
	{PMIC_RG_OCTL_RTC_32K1V8_0, MT6351_PMIC_RG_OCTL_RTC_32K1V8_0_ADDR,
	 MT6351_PMIC_RG_OCTL_RTC_32K1V8_0_MASK, MT6351_PMIC_RG_OCTL_RTC_32K1V8_0_SHIFT},
	{PMIC_RG_OCTL_RTC_32K1V8_1, MT6351_PMIC_RG_OCTL_RTC_32K1V8_1_ADDR,
	 MT6351_PMIC_RG_OCTL_RTC_32K1V8_1_MASK, MT6351_PMIC_RG_OCTL_RTC_32K1V8_1_SHIFT},
	{PMIC_RG_OCTL_SPI_CLK, MT6351_PMIC_RG_OCTL_SPI_CLK_ADDR,
	 MT6351_PMIC_RG_OCTL_SPI_CLK_MASK, MT6351_PMIC_RG_OCTL_SPI_CLK_SHIFT},
	{PMIC_RG_OCTL_SPI_CSN, MT6351_PMIC_RG_OCTL_SPI_CSN_ADDR,
	 MT6351_PMIC_RG_OCTL_SPI_CSN_MASK, MT6351_PMIC_RG_OCTL_SPI_CSN_SHIFT},
	{PMIC_RG_OCTL_SPI_MOSI, MT6351_PMIC_RG_OCTL_SPI_MOSI_ADDR,
	 MT6351_PMIC_RG_OCTL_SPI_MOSI_MASK, MT6351_PMIC_RG_OCTL_SPI_MOSI_SHIFT},
	{PMIC_RG_OCTL_SPI_MISO, MT6351_PMIC_RG_OCTL_SPI_MISO_ADDR,
	 MT6351_PMIC_RG_OCTL_SPI_MISO_MASK, MT6351_PMIC_RG_OCTL_SPI_MISO_SHIFT},
	{PMIC_RG_OCTL_AUD_DAT_MOSI, MT6351_PMIC_RG_OCTL_AUD_DAT_MOSI_ADDR,
	 MT6351_PMIC_RG_OCTL_AUD_DAT_MOSI_MASK, MT6351_PMIC_RG_OCTL_AUD_DAT_MOSI_SHIFT},
	{PMIC_RG_OCTL_AUD_DAT_MISO, MT6351_PMIC_RG_OCTL_AUD_DAT_MISO_ADDR,
	 MT6351_PMIC_RG_OCTL_AUD_DAT_MISO_MASK, MT6351_PMIC_RG_OCTL_AUD_DAT_MISO_SHIFT},
	{PMIC_RG_OCTL_AUD_CLK, MT6351_PMIC_RG_OCTL_AUD_CLK_ADDR,
	 MT6351_PMIC_RG_OCTL_AUD_CLK_MASK, MT6351_PMIC_RG_OCTL_AUD_CLK_SHIFT},
	{PMIC_RG_OCTL_ANC_DAT_MOSI, MT6351_PMIC_RG_OCTL_ANC_DAT_MOSI_ADDR,
	 MT6351_PMIC_RG_OCTL_ANC_DAT_MOSI_MASK, MT6351_PMIC_RG_OCTL_ANC_DAT_MOSI_SHIFT},
	{PMIC_RG_OCTL_HOMEKEY, MT6351_PMIC_RG_OCTL_HOMEKEY_ADDR,
	 MT6351_PMIC_RG_OCTL_HOMEKEY_MASK, MT6351_PMIC_RG_OCTL_HOMEKEY_SHIFT},
	{PMIC_RG_OCTL_ENBB, MT6351_PMIC_RG_OCTL_ENBB_ADDR, MT6351_PMIC_RG_OCTL_ENBB_MASK,
	 MT6351_PMIC_RG_OCTL_ENBB_SHIFT},
	{PMIC_RG_OCTL_XOSC_EN, MT6351_PMIC_RG_OCTL_XOSC_EN_ADDR,
	 MT6351_PMIC_RG_OCTL_XOSC_EN_MASK, MT6351_PMIC_RG_OCTL_XOSC_EN_SHIFT},
	{PMIC_RG_OCTL_VOW_CLK_MISO, MT6351_PMIC_RG_OCTL_VOW_CLK_MISO_ADDR,
	 MT6351_PMIC_RG_OCTL_VOW_CLK_MISO_MASK, MT6351_PMIC_RG_OCTL_VOW_CLK_MISO_SHIFT},
	{PMIC_TOP_STATUS, MT6351_PMIC_TOP_STATUS_ADDR, MT6351_PMIC_TOP_STATUS_MASK,
	 MT6351_PMIC_TOP_STATUS_SHIFT},
	{PMIC_TOP_STATUS_SET, MT6351_PMIC_TOP_STATUS_SET_ADDR,
	 MT6351_PMIC_TOP_STATUS_SET_MASK, MT6351_PMIC_TOP_STATUS_SET_SHIFT},
	{PMIC_TOP_STATUS_CLR, MT6351_PMIC_TOP_STATUS_CLR_ADDR,
	 MT6351_PMIC_TOP_STATUS_CLR_MASK, MT6351_PMIC_TOP_STATUS_CLR_SHIFT},
	{PMIC_RG_G_SMPS_PD_CK_PDN, MT6351_PMIC_RG_G_SMPS_PD_CK_PDN_ADDR,
	 MT6351_PMIC_RG_G_SMPS_PD_CK_PDN_MASK, MT6351_PMIC_RG_G_SMPS_PD_CK_PDN_SHIFT},
	{PMIC_RG_G_SMPS_AUD_CK_PDN, MT6351_PMIC_RG_G_SMPS_AUD_CK_PDN_ADDR,
	 MT6351_PMIC_RG_G_SMPS_AUD_CK_PDN_MASK, MT6351_PMIC_RG_G_SMPS_AUD_CK_PDN_SHIFT},
	{PMIC_RG_G_DRV_2M_CK_PDN, MT6351_PMIC_RG_G_DRV_2M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_G_DRV_2M_CK_PDN_MASK, MT6351_PMIC_RG_G_DRV_2M_CK_PDN_SHIFT},
	{PMIC_RG_DRV_32K_CK_PDN, MT6351_PMIC_RG_DRV_32K_CK_PDN_ADDR,
	 MT6351_PMIC_RG_DRV_32K_CK_PDN_MASK, MT6351_PMIC_RG_DRV_32K_CK_PDN_SHIFT},
	{PMIC_RG_DRV_ISINK0_CK_PDN, MT6351_PMIC_RG_DRV_ISINK0_CK_PDN_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK0_CK_PDN_MASK, MT6351_PMIC_RG_DRV_ISINK0_CK_PDN_SHIFT},
	{PMIC_RG_DRV_ISINK1_CK_PDN, MT6351_PMIC_RG_DRV_ISINK1_CK_PDN_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK1_CK_PDN_MASK, MT6351_PMIC_RG_DRV_ISINK1_CK_PDN_SHIFT},
	{PMIC_RG_DRV_ISINK2_CK_PDN, MT6351_PMIC_RG_DRV_ISINK2_CK_PDN_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK2_CK_PDN_MASK, MT6351_PMIC_RG_DRV_ISINK2_CK_PDN_SHIFT},
	{PMIC_RG_DRV_ISINK3_CK_PDN, MT6351_PMIC_RG_DRV_ISINK3_CK_PDN_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK3_CK_PDN_MASK, MT6351_PMIC_RG_DRV_ISINK3_CK_PDN_SHIFT},
	{PMIC_RG_AUXADC_1M_CK_PDN, MT6351_PMIC_RG_AUXADC_1M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_AUXADC_1M_CK_PDN_MASK, MT6351_PMIC_RG_AUXADC_1M_CK_PDN_SHIFT},
	{PMIC_RG_AUXADC_SMPS_CK_PDN, MT6351_PMIC_RG_AUXADC_SMPS_CK_PDN_ADDR,
	 MT6351_PMIC_RG_AUXADC_SMPS_CK_PDN_MASK, MT6351_PMIC_RG_AUXADC_SMPS_CK_PDN_SHIFT},
	{PMIC_RG_AUXADC_RNG_CK_PDN, MT6351_PMIC_RG_AUXADC_RNG_CK_PDN_ADDR,
	 MT6351_PMIC_RG_AUXADC_RNG_CK_PDN_MASK, MT6351_PMIC_RG_AUXADC_RNG_CK_PDN_SHIFT},
	{PMIC_RG_AUXADC_26M_CK_PDN, MT6351_PMIC_RG_AUXADC_26M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_AUXADC_26M_CK_PDN_MASK, MT6351_PMIC_RG_AUXADC_26M_CK_PDN_SHIFT},
	{PMIC_RG_AUDNCP_CK_PDN, MT6351_PMIC_RG_AUDNCP_CK_PDN_ADDR,
	 MT6351_PMIC_RG_AUDNCP_CK_PDN_MASK, MT6351_PMIC_RG_AUDNCP_CK_PDN_SHIFT},
	{PMIC_RG_AUDIF_CK_PDN, MT6351_PMIC_RG_AUDIF_CK_PDN_ADDR,
	 MT6351_PMIC_RG_AUDIF_CK_PDN_MASK, MT6351_PMIC_RG_AUDIF_CK_PDN_SHIFT},
	{PMIC_RG_AUD_CK_PDN, MT6351_PMIC_RG_AUD_CK_PDN_ADDR,
	 MT6351_PMIC_RG_AUD_CK_PDN_MASK, MT6351_PMIC_RG_AUD_CK_PDN_SHIFT},
	{PMIC_RG_ZCD13M_CK_PDN, MT6351_PMIC_RG_ZCD13M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_ZCD13M_CK_PDN_MASK, MT6351_PMIC_RG_ZCD13M_CK_PDN_SHIFT},
	{PMIC_TOP_CKPDN_CON0_SET, MT6351_PMIC_TOP_CKPDN_CON0_SET_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON0_SET_MASK, MT6351_PMIC_TOP_CKPDN_CON0_SET_SHIFT},
	{PMIC_TOP_CKPDN_CON0_CLR, MT6351_PMIC_TOP_CKPDN_CON0_CLR_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON0_CLR_MASK, MT6351_PMIC_TOP_CKPDN_CON0_CLR_SHIFT},
	{PMIC_RG_RTC_32K_CK_PDN, MT6351_PMIC_RG_RTC_32K_CK_PDN_ADDR,
	 MT6351_PMIC_RG_RTC_32K_CK_PDN_MASK, MT6351_PMIC_RG_RTC_32K_CK_PDN_SHIFT},
	{PMIC_RG_RTC_MCLK_PDN, MT6351_PMIC_RG_RTC_MCLK_PDN_ADDR,
	 MT6351_PMIC_RG_RTC_MCLK_PDN_MASK, MT6351_PMIC_RG_RTC_MCLK_PDN_SHIFT},
	{PMIC_RG_RTC_75K_CK_PDN, MT6351_PMIC_RG_RTC_75K_CK_PDN_ADDR,
	 MT6351_PMIC_RG_RTC_75K_CK_PDN_MASK, MT6351_PMIC_RG_RTC_75K_CK_PDN_SHIFT},
	{PMIC_RG_RTCDET_CK_PDN, MT6351_PMIC_RG_RTCDET_CK_PDN_ADDR,
	 MT6351_PMIC_RG_RTCDET_CK_PDN_MASK, MT6351_PMIC_RG_RTCDET_CK_PDN_SHIFT},
	{PMIC_RG_RTC32K_1V8_0_O_PDN, MT6351_PMIC_RG_RTC32K_1V8_0_O_PDN_ADDR,
	 MT6351_PMIC_RG_RTC32K_1V8_0_O_PDN_MASK, MT6351_PMIC_RG_RTC32K_1V8_0_O_PDN_SHIFT},
	{PMIC_RG_RTC32K_1V8_1_O_PDN, MT6351_PMIC_RG_RTC32K_1V8_1_O_PDN_ADDR,
	 MT6351_PMIC_RG_RTC32K_1V8_1_O_PDN_MASK, MT6351_PMIC_RG_RTC32K_1V8_1_O_PDN_SHIFT},
	{PMIC_RG_RTC_2SEC_OFF_DET_PDN, MT6351_PMIC_RG_RTC_2SEC_OFF_DET_PDN_ADDR,
	 MT6351_PMIC_RG_RTC_2SEC_OFF_DET_PDN_MASK, MT6351_PMIC_RG_RTC_2SEC_OFF_DET_PDN_SHIFT},
	{PMIC_RG_FQMTR_CK_PDN, MT6351_PMIC_RG_FQMTR_CK_PDN_ADDR,
	 MT6351_PMIC_RG_FQMTR_CK_PDN_MASK, MT6351_PMIC_RG_FQMTR_CK_PDN_SHIFT},
	{PMIC_RG_STB_1M_CK_PDN, MT6351_PMIC_RG_STB_1M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_STB_1M_CK_PDN_MASK, MT6351_PMIC_RG_STB_1M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_1M_CK_PDN, MT6351_PMIC_RG_BUCK_1M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_1M_CK_PDN_MASK, MT6351_PMIC_RG_BUCK_1M_CK_PDN_SHIFT},
	{PMIC_RG_AUXADC_CK_PDN, MT6351_PMIC_RG_AUXADC_CK_PDN_ADDR,
	 MT6351_PMIC_RG_AUXADC_CK_PDN_MASK, MT6351_PMIC_RG_AUXADC_CK_PDN_SHIFT},
	{PMIC_RG_PWMOC_6M_CK_PDN, MT6351_PMIC_RG_PWMOC_6M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_PWMOC_6M_CK_PDN_MASK, MT6351_PMIC_RG_PWMOC_6M_CK_PDN_SHIFT},
	{PMIC_RG_PWMOC_AUD_6M_CK_PDN, MT6351_PMIC_RG_PWMOC_AUD_6M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_PWMOC_AUD_6M_CK_PDN_MASK, MT6351_PMIC_RG_PWMOC_AUD_6M_CK_PDN_SHIFT},
	{PMIC_TOP_CKPDN_CON1_SET, MT6351_PMIC_TOP_CKPDN_CON1_SET_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON1_SET_MASK, MT6351_PMIC_TOP_CKPDN_CON1_SET_SHIFT},
	{PMIC_TOP_CKPDN_CON1_CLR, MT6351_PMIC_TOP_CKPDN_CON1_CLR_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON1_CLR_MASK, MT6351_PMIC_TOP_CKPDN_CON1_CLR_SHIFT},
	{PMIC_RG_FGADC_ANA_CK_PDN, MT6351_PMIC_RG_FGADC_ANA_CK_PDN_ADDR,
	 MT6351_PMIC_RG_FGADC_ANA_CK_PDN_MASK, MT6351_PMIC_RG_FGADC_ANA_CK_PDN_SHIFT},
	{PMIC_RG_FGADC_DIG_CK_PDN, MT6351_PMIC_RG_FGADC_DIG_CK_PDN_ADDR,
	 MT6351_PMIC_RG_FGADC_DIG_CK_PDN_MASK, MT6351_PMIC_RG_FGADC_DIG_CK_PDN_SHIFT},
	{PMIC_RG_BIF_X72_CK_PDN, MT6351_PMIC_RG_BIF_X72_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BIF_X72_CK_PDN_MASK, MT6351_PMIC_RG_BIF_X72_CK_PDN_SHIFT},
	{PMIC_RG_BIF_X4_CK_PDN, MT6351_PMIC_RG_BIF_X4_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BIF_X4_CK_PDN_MASK, MT6351_PMIC_RG_BIF_X4_CK_PDN_SHIFT},
	{PMIC_RG_BIF_X1_CK_PDN, MT6351_PMIC_RG_BIF_X1_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BIF_X1_CK_PDN_MASK, MT6351_PMIC_RG_BIF_X1_CK_PDN_SHIFT},
	{PMIC_RG_PCHR_32K_CK_PDN, MT6351_PMIC_RG_PCHR_32K_CK_PDN_ADDR,
	 MT6351_PMIC_RG_PCHR_32K_CK_PDN_MASK, MT6351_PMIC_RG_PCHR_32K_CK_PDN_SHIFT},
	{PMIC_RG_ACCDET_CK_PDN, MT6351_PMIC_RG_ACCDET_CK_PDN_ADDR,
	 MT6351_PMIC_RG_ACCDET_CK_PDN_MASK, MT6351_PMIC_RG_ACCDET_CK_PDN_SHIFT},
	{PMIC_RG_FQMTR_32K_CK_PDN, MT6351_PMIC_RG_FQMTR_32K_CK_PDN_ADDR,
	 MT6351_PMIC_RG_FQMTR_32K_CK_PDN_MASK, MT6351_PMIC_RG_FQMTR_32K_CK_PDN_SHIFT},
	{PMIC_RG_INTRP_CK_PDN, MT6351_PMIC_RG_INTRP_CK_PDN_ADDR,
	 MT6351_PMIC_RG_INTRP_CK_PDN_MASK, MT6351_PMIC_RG_INTRP_CK_PDN_SHIFT},
	{PMIC_RG_RTC_26M_CK_PDN, MT6351_PMIC_RG_RTC_26M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_RTC_26M_CK_PDN_MASK, MT6351_PMIC_RG_RTC_26M_CK_PDN_SHIFT},
	{PMIC_RG_RTC_EOSC32_CK_PDN, MT6351_PMIC_RG_RTC_EOSC32_CK_PDN_ADDR,
	 MT6351_PMIC_RG_RTC_EOSC32_CK_PDN_MASK, MT6351_PMIC_RG_RTC_EOSC32_CK_PDN_SHIFT},
	{PMIC_RG_TRIM_75K_CK_PDN, MT6351_PMIC_RG_TRIM_75K_CK_PDN_ADDR,
	 MT6351_PMIC_RG_TRIM_75K_CK_PDN_MASK, MT6351_PMIC_RG_TRIM_75K_CK_PDN_SHIFT},
	{PMIC_RG_STRUP_LBAT_SEL_CK_PDN, MT6351_PMIC_RG_STRUP_LBAT_SEL_CK_PDN_ADDR,
	 MT6351_PMIC_RG_STRUP_LBAT_SEL_CK_PDN_MASK, MT6351_PMIC_RG_STRUP_LBAT_SEL_CK_PDN_SHIFT},
	{PMIC_TOP_CKPDN_CON2_SET, MT6351_PMIC_TOP_CKPDN_CON2_SET_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON2_SET_MASK, MT6351_PMIC_TOP_CKPDN_CON2_SET_SHIFT},
	{PMIC_TOP_CKPDN_CON2_CLR, MT6351_PMIC_TOP_CKPDN_CON2_CLR_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON2_CLR_MASK, MT6351_PMIC_TOP_CKPDN_CON2_CLR_SHIFT},
	{PMIC_RG_STRUP_75K_CK_PDN, MT6351_PMIC_RG_STRUP_75K_CK_PDN_ADDR,
	 MT6351_PMIC_RG_STRUP_75K_CK_PDN_MASK, MT6351_PMIC_RG_STRUP_75K_CK_PDN_SHIFT},
	{PMIC_RG_STRUP_32K_CK_PDN, MT6351_PMIC_RG_STRUP_32K_CK_PDN_ADDR,
	 MT6351_PMIC_RG_STRUP_32K_CK_PDN_MASK, MT6351_PMIC_RG_STRUP_32K_CK_PDN_SHIFT},
	{PMIC_RG_EFUSE_CK_PDN, MT6351_PMIC_RG_EFUSE_CK_PDN_ADDR,
	 MT6351_PMIC_RG_EFUSE_CK_PDN_MASK, MT6351_PMIC_RG_EFUSE_CK_PDN_SHIFT},
	{PMIC_RG_SMPS_CK_DIV_PDN, MT6351_PMIC_RG_SMPS_CK_DIV_PDN_ADDR,
	 MT6351_PMIC_RG_SMPS_CK_DIV_PDN_MASK, MT6351_PMIC_RG_SMPS_CK_DIV_PDN_SHIFT},
	{PMIC_RG_SPI_CK_PDN, MT6351_PMIC_RG_SPI_CK_PDN_ADDR,
	 MT6351_PMIC_RG_SPI_CK_PDN_MASK, MT6351_PMIC_RG_SPI_CK_PDN_SHIFT},
	{PMIC_RG_BGR_TEST_CK_PDN, MT6351_PMIC_RG_BGR_TEST_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BGR_TEST_CK_PDN_MASK, MT6351_PMIC_RG_BGR_TEST_CK_PDN_SHIFT},
	{PMIC_RG_FGADC_FT_CK_PDN, MT6351_PMIC_RG_FGADC_FT_CK_PDN_ADDR,
	 MT6351_PMIC_RG_FGADC_FT_CK_PDN_MASK, MT6351_PMIC_RG_FGADC_FT_CK_PDN_SHIFT},
	{PMIC_RG_PCHR_TEST_CK_PDN, MT6351_PMIC_RG_PCHR_TEST_CK_PDN_ADDR,
	 MT6351_PMIC_RG_PCHR_TEST_CK_PDN_MASK, MT6351_PMIC_RG_PCHR_TEST_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_32K_CK_PDN, MT6351_PMIC_RG_BUCK_32K_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_32K_CK_PDN_MASK, MT6351_PMIC_RG_BUCK_32K_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_ANA_CK_PDN, MT6351_PMIC_RG_BUCK_ANA_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_ANA_CK_PDN_MASK, MT6351_PMIC_RG_BUCK_ANA_CK_PDN_SHIFT},
	{PMIC_RG_EOSC_CALI_TEST_CK_PDN, MT6351_PMIC_RG_EOSC_CALI_TEST_CK_PDN_ADDR,
	 MT6351_PMIC_RG_EOSC_CALI_TEST_CK_PDN_MASK, MT6351_PMIC_RG_EOSC_CALI_TEST_CK_PDN_SHIFT},
	{PMIC_RG_G_SMPS_TEST_CK_PDN, MT6351_PMIC_RG_G_SMPS_TEST_CK_PDN_ADDR,
	 MT6351_PMIC_RG_G_SMPS_TEST_CK_PDN_MASK, MT6351_PMIC_RG_G_SMPS_TEST_CK_PDN_SHIFT},
	{PMIC_TOP_CKPDN_CON3_RSV, MT6351_PMIC_TOP_CKPDN_CON3_RSV_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON3_RSV_MASK, MT6351_PMIC_TOP_CKPDN_CON3_RSV_SHIFT},
	{PMIC_TOP_CKPDN_CON3_SET, MT6351_PMIC_TOP_CKPDN_CON3_SET_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON3_SET_MASK, MT6351_PMIC_TOP_CKPDN_CON3_SET_SHIFT},
	{PMIC_TOP_CKPDN_CON3_CLR, MT6351_PMIC_TOP_CKPDN_CON3_CLR_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON3_CLR_MASK, MT6351_PMIC_TOP_CKPDN_CON3_CLR_SHIFT},
	{PMIC_RG_BUCK_9M_CK_PDN, MT6351_PMIC_RG_BUCK_9M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_9M_CK_PDN_MASK, MT6351_PMIC_RG_BUCK_9M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VSRAM_PROC_9M_CK_PDN, MT6351_PMIC_RG_BUCK_VSRAM_PROC_9M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_VSRAM_PROC_9M_CK_PDN_MASK,
	 MT6351_PMIC_RG_BUCK_VSRAM_PROC_9M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VPA_9M_CK_PDN, MT6351_PMIC_RG_BUCK_VPA_9M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_VPA_9M_CK_PDN_MASK, MT6351_PMIC_RG_BUCK_VPA_9M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VMODEM_9M_CK_PDN, MT6351_PMIC_RG_BUCK_VMODEM_9M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_VMODEM_9M_CK_PDN_MASK, MT6351_PMIC_RG_BUCK_VMODEM_9M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VCORE_9M_CK_PDN, MT6351_PMIC_RG_BUCK_VCORE_9M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_VCORE_9M_CK_PDN_MASK, MT6351_PMIC_RG_BUCK_VCORE_9M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VGPU_9M_CK_PDN, MT6351_PMIC_RG_BUCK_VGPU_9M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_VGPU_9M_CK_PDN_MASK, MT6351_PMIC_RG_BUCK_VGPU_9M_CK_PDN_SHIFT},
	{PMIC_TOP_CKPDN_CON4_RSV, MT6351_PMIC_TOP_CKPDN_CON4_RSV_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON4_RSV_MASK, MT6351_PMIC_TOP_CKPDN_CON4_RSV_SHIFT},
	{PMIC_TOP_CKPDN_CON4_SET, MT6351_PMIC_TOP_CKPDN_CON4_SET_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON4_SET_MASK, MT6351_PMIC_TOP_CKPDN_CON4_SET_SHIFT},
	{PMIC_TOP_CKPDN_CON4_CLR, MT6351_PMIC_TOP_CKPDN_CON4_CLR_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON4_CLR_MASK, MT6351_PMIC_TOP_CKPDN_CON4_CLR_SHIFT},
	{PMIC_RG_LDO_CALI_75K_CK_PDN, MT6351_PMIC_RG_LDO_CALI_75K_CK_PDN_ADDR,
	 MT6351_PMIC_RG_LDO_CALI_75K_CK_PDN_MASK, MT6351_PMIC_RG_LDO_CALI_75K_CK_PDN_SHIFT},
	{PMIC_RG_INTRP_PRE_OC_CK_PDN, MT6351_PMIC_RG_INTRP_PRE_OC_CK_PDN_ADDR,
	 MT6351_PMIC_RG_INTRP_PRE_OC_CK_PDN_MASK, MT6351_PMIC_RG_INTRP_PRE_OC_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VS2_9M_CK_PDN, MT6351_PMIC_RG_BUCK_VS2_9M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_VS2_9M_CK_PDN_MASK, MT6351_PMIC_RG_BUCK_VS2_9M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VS1_9M_CK_PDN, MT6351_PMIC_RG_BUCK_VS1_9M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_VS1_9M_CK_PDN_MASK, MT6351_PMIC_RG_BUCK_VS1_9M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VMD1_9M_CK_PDN, MT6351_PMIC_RG_BUCK_VMD1_9M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_VMD1_9M_CK_PDN_MASK, MT6351_PMIC_RG_BUCK_VMD1_9M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VSRAM_MD_9M_CK_PDN, MT6351_PMIC_RG_BUCK_VSRAM_MD_9M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_VSRAM_MD_9M_CK_PDN_MASK,
	 MT6351_PMIC_RG_BUCK_VSRAM_MD_9M_CK_PDN_SHIFT},
	{PMIC_RG_VOW32K_CK_PDN, MT6351_PMIC_RG_VOW32K_CK_PDN_ADDR,
	 MT6351_PMIC_RG_VOW32K_CK_PDN_MASK, MT6351_PMIC_RG_VOW32K_CK_PDN_SHIFT},
	{PMIC_RG_VOW12M_CK_PDN, MT6351_PMIC_RG_VOW12M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_VOW12M_CK_PDN_MASK, MT6351_PMIC_RG_VOW12M_CK_PDN_SHIFT},
	{PMIC_RG_AUD18M_CK_PDN, MT6351_PMIC_RG_AUD18M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_AUD18M_CK_PDN_MASK, MT6351_PMIC_RG_AUD18M_CK_PDN_SHIFT},
	{PMIC_RG_DRV_ISINK4_CK_PDN, MT6351_PMIC_RG_DRV_ISINK4_CK_PDN_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK4_CK_PDN_MASK, MT6351_PMIC_RG_DRV_ISINK4_CK_PDN_SHIFT},
	{PMIC_RG_DRV_ISINK5_CK_PDN, MT6351_PMIC_RG_DRV_ISINK5_CK_PDN_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK5_CK_PDN_MASK, MT6351_PMIC_RG_DRV_ISINK5_CK_PDN_SHIFT},
	{PMIC_RG_DRV_ISINK6_CK_PDN, MT6351_PMIC_RG_DRV_ISINK6_CK_PDN_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK6_CK_PDN_MASK, MT6351_PMIC_RG_DRV_ISINK6_CK_PDN_SHIFT},
	{PMIC_RG_DRV_ISINK7_CK_PDN, MT6351_PMIC_RG_DRV_ISINK7_CK_PDN_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK7_CK_PDN_MASK, MT6351_PMIC_RG_DRV_ISINK7_CK_PDN_SHIFT},
	{PMIC_RG_DRV_CHRIND_CK_PDN, MT6351_PMIC_RG_DRV_CHRIND_CK_PDN_ADDR,
	 MT6351_PMIC_RG_DRV_CHRIND_CK_PDN_MASK, MT6351_PMIC_RG_DRV_CHRIND_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_AUD_1M_CK_PDN, MT6351_PMIC_RG_BUCK_AUD_1M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_BUCK_AUD_1M_CK_PDN_MASK, MT6351_PMIC_RG_BUCK_AUD_1M_CK_PDN_SHIFT},
	{PMIC_RG_STB_AUD_1M_CK_PDN, MT6351_PMIC_RG_STB_AUD_1M_CK_PDN_ADDR,
	 MT6351_PMIC_RG_STB_AUD_1M_CK_PDN_MASK, MT6351_PMIC_RG_STB_AUD_1M_CK_PDN_SHIFT},
	{PMIC_TOP_CKPDN_CON5_SET, MT6351_PMIC_TOP_CKPDN_CON5_SET_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON5_SET_MASK, MT6351_PMIC_TOP_CKPDN_CON5_SET_SHIFT},
	{PMIC_TOP_CKPDN_CON5_CLR, MT6351_PMIC_TOP_CKPDN_CON5_CLR_ADDR,
	 MT6351_PMIC_TOP_CKPDN_CON5_CLR_MASK, MT6351_PMIC_TOP_CKPDN_CON5_CLR_SHIFT},
	{PMIC_RG_AUDIF_CK_CKSEL, MT6351_PMIC_RG_AUDIF_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_AUDIF_CK_CKSEL_MASK, MT6351_PMIC_RG_AUDIF_CK_CKSEL_SHIFT},
	{PMIC_RG_AUD_CK_CKSEL, MT6351_PMIC_RG_AUD_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_AUD_CK_CKSEL_MASK, MT6351_PMIC_RG_AUD_CK_CKSEL_SHIFT},
	{PMIC_RG_DRV_ISINK0_CK_CKSEL, MT6351_PMIC_RG_DRV_ISINK0_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK0_CK_CKSEL_MASK, MT6351_PMIC_RG_DRV_ISINK0_CK_CKSEL_SHIFT},
	{PMIC_RG_DRV_ISINK1_CK_CKSEL, MT6351_PMIC_RG_DRV_ISINK1_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK1_CK_CKSEL_MASK, MT6351_PMIC_RG_DRV_ISINK1_CK_CKSEL_SHIFT},
	{PMIC_RG_DRV_ISINK2_CK_CKSEL, MT6351_PMIC_RG_DRV_ISINK2_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK2_CK_CKSEL_MASK, MT6351_PMIC_RG_DRV_ISINK2_CK_CKSEL_SHIFT},
	{PMIC_RG_DRV_ISINK3_CK_CKSEL, MT6351_PMIC_RG_DRV_ISINK3_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK3_CK_CKSEL_MASK, MT6351_PMIC_RG_DRV_ISINK3_CK_CKSEL_SHIFT},
	{PMIC_RG_FQMTR_CK_CKSEL, MT6351_PMIC_RG_FQMTR_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_FQMTR_CK_CKSEL_MASK, MT6351_PMIC_RG_FQMTR_CK_CKSEL_SHIFT},
	{PMIC_RG_75K_32K_SEL, MT6351_PMIC_RG_75K_32K_SEL_ADDR,
	 MT6351_PMIC_RG_75K_32K_SEL_MASK, MT6351_PMIC_RG_75K_32K_SEL_SHIFT},
	{PMIC_RG_AUXADC_CK_CKSEL, MT6351_PMIC_RG_AUXADC_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_AUXADC_CK_CKSEL_MASK, MT6351_PMIC_RG_AUXADC_CK_CKSEL_SHIFT},
	{PMIC_RG_OSC_SEL_HW_SRC_SEL, MT6351_PMIC_RG_OSC_SEL_HW_SRC_SEL_ADDR,
	 MT6351_PMIC_RG_OSC_SEL_HW_SRC_SEL_MASK, MT6351_PMIC_RG_OSC_SEL_HW_SRC_SEL_SHIFT},
	{PMIC_RG_SRCLKEN_SRC_SEL, MT6351_PMIC_RG_SRCLKEN_SRC_SEL_ADDR,
	 MT6351_PMIC_RG_SRCLKEN_SRC_SEL_MASK, MT6351_PMIC_RG_SRCLKEN_SRC_SEL_SHIFT},
	{PMIC_TOP_CKSEL_CON_SET, MT6351_PMIC_TOP_CKSEL_CON_SET_ADDR,
	 MT6351_PMIC_TOP_CKSEL_CON_SET_MASK, MT6351_PMIC_TOP_CKSEL_CON_SET_SHIFT},
	{PMIC_TOP_CKSEL_CON_CLR, MT6351_PMIC_TOP_CKSEL_CON_CLR_ADDR,
	 MT6351_PMIC_TOP_CKSEL_CON_CLR_MASK, MT6351_PMIC_TOP_CKSEL_CON_CLR_SHIFT},
	{PMIC_RG_STRUP_75K_CK_CKSEL, MT6351_PMIC_RG_STRUP_75K_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_STRUP_75K_CK_CKSEL_MASK, MT6351_PMIC_RG_STRUP_75K_CK_CKSEL_SHIFT},
	{PMIC_RG_BGR_TEST_CK_CKSEL, MT6351_PMIC_RG_BGR_TEST_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_BGR_TEST_CK_CKSEL_MASK, MT6351_PMIC_RG_BGR_TEST_CK_CKSEL_SHIFT},
	{PMIC_RG_PCHR_TEST_CK_CKSEL, MT6351_PMIC_RG_PCHR_TEST_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_PCHR_TEST_CK_CKSEL_MASK, MT6351_PMIC_RG_PCHR_TEST_CK_CKSEL_SHIFT},
	{PMIC_RG_FGADC_ANA_CK_CKSEL, MT6351_PMIC_RG_FGADC_ANA_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_FGADC_ANA_CK_CKSEL_MASK, MT6351_PMIC_RG_FGADC_ANA_CK_CKSEL_SHIFT},
	{PMIC_RG_DRV_ISINK4_CK_CKSEL, MT6351_PMIC_RG_DRV_ISINK4_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK4_CK_CKSEL_MASK, MT6351_PMIC_RG_DRV_ISINK4_CK_CKSEL_SHIFT},
	{PMIC_RG_DRV_ISINK5_CK_CKSEL, MT6351_PMIC_RG_DRV_ISINK5_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK5_CK_CKSEL_MASK, MT6351_PMIC_RG_DRV_ISINK5_CK_CKSEL_SHIFT},
	{PMIC_RG_DRV_ISINK6_CK_CKSEL, MT6351_PMIC_RG_DRV_ISINK6_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK6_CK_CKSEL_MASK, MT6351_PMIC_RG_DRV_ISINK6_CK_CKSEL_SHIFT},
	{PMIC_RG_DRV_ISINK7_CK_CKSEL, MT6351_PMIC_RG_DRV_ISINK7_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK7_CK_CKSEL_MASK, MT6351_PMIC_RG_DRV_ISINK7_CK_CKSEL_SHIFT},
	{PMIC_RG_DRV_CHRIND_CK_CKSEL, MT6351_PMIC_RG_DRV_CHRIND_CK_CKSEL_ADDR,
	 MT6351_PMIC_RG_DRV_CHRIND_CK_CKSEL_MASK, MT6351_PMIC_RG_DRV_CHRIND_CK_CKSEL_SHIFT},
	{PMIC_RG_TOP_CKSEL_CON1_RSV, MT6351_PMIC_RG_TOP_CKSEL_CON1_RSV_ADDR,
	 MT6351_PMIC_RG_TOP_CKSEL_CON1_RSV_MASK, MT6351_PMIC_RG_TOP_CKSEL_CON1_RSV_SHIFT},
	{PMIC_TOP_CKSEL_CON1_SET, MT6351_PMIC_TOP_CKSEL_CON1_SET_ADDR,
	 MT6351_PMIC_TOP_CKSEL_CON1_SET_MASK, MT6351_PMIC_TOP_CKSEL_CON1_SET_SHIFT},
	{PMIC_TOP_CKSEL_CON1_CLR, MT6351_PMIC_TOP_CKSEL_CON1_CLR_ADDR,
	 MT6351_PMIC_TOP_CKSEL_CON1_CLR_MASK, MT6351_PMIC_TOP_CKSEL_CON1_CLR_SHIFT},
	{PMIC_RG_SRCVOLTEN_SW, MT6351_PMIC_RG_SRCVOLTEN_SW_ADDR,
	 MT6351_PMIC_RG_SRCVOLTEN_SW_MASK, MT6351_PMIC_RG_SRCVOLTEN_SW_SHIFT},
	{PMIC_RG_BUCK_OSC_SEL_SW, MT6351_PMIC_RG_BUCK_OSC_SEL_SW_ADDR,
	 MT6351_PMIC_RG_BUCK_OSC_SEL_SW_MASK, MT6351_PMIC_RG_BUCK_OSC_SEL_SW_SHIFT},
	{PMIC_RG_VOWEN_SW, MT6351_PMIC_RG_VOWEN_SW_ADDR, MT6351_PMIC_RG_VOWEN_SW_MASK,
	 MT6351_PMIC_RG_VOWEN_SW_SHIFT},
	{PMIC_RG_SRCVOLTEN_MODE, MT6351_PMIC_RG_SRCVOLTEN_MODE_ADDR,
	 MT6351_PMIC_RG_SRCVOLTEN_MODE_MASK, MT6351_PMIC_RG_SRCVOLTEN_MODE_SHIFT},
	{PMIC_RG_BUCK_OSC_SEL_MODE, MT6351_PMIC_RG_BUCK_OSC_SEL_MODE_ADDR,
	 MT6351_PMIC_RG_BUCK_OSC_SEL_MODE_MASK, MT6351_PMIC_RG_BUCK_OSC_SEL_MODE_SHIFT},
	{PMIC_RG_VOWEN_MODE, MT6351_PMIC_RG_VOWEN_MODE_ADDR,
	 MT6351_PMIC_RG_VOWEN_MODE_MASK, MT6351_PMIC_RG_VOWEN_MODE_SHIFT},
	{PMIC_RG_TOP_CKSEL_CON2_RSV, MT6351_PMIC_RG_TOP_CKSEL_CON2_RSV_ADDR,
	 MT6351_PMIC_RG_TOP_CKSEL_CON2_RSV_MASK, MT6351_PMIC_RG_TOP_CKSEL_CON2_RSV_SHIFT},
	{PMIC_RG_BUCK_VMD1_OSC_SEL_SW, MT6351_PMIC_RG_BUCK_VMD1_OSC_SEL_SW_ADDR,
	 MT6351_PMIC_RG_BUCK_VMD1_OSC_SEL_SW_MASK, MT6351_PMIC_RG_BUCK_VMD1_OSC_SEL_SW_SHIFT},
	{PMIC_RG_BUCK_VMD1_OSC_SEL_MODE, MT6351_PMIC_RG_BUCK_VMD1_OSC_SEL_MODE_ADDR,
	 MT6351_PMIC_RG_BUCK_VMD1_OSC_SEL_MODE_MASK, MT6351_PMIC_RG_BUCK_VMD1_OSC_SEL_MODE_SHIFT},
	{PMIC_TOP_CKSEL_CON2_SET, MT6351_PMIC_TOP_CKSEL_CON2_SET_ADDR,
	 MT6351_PMIC_TOP_CKSEL_CON2_SET_MASK, MT6351_PMIC_TOP_CKSEL_CON2_SET_SHIFT},
	{PMIC_TOP_CKSEL_CON2_CLR, MT6351_PMIC_TOP_CKSEL_CON2_CLR_ADDR,
	 MT6351_PMIC_TOP_CKSEL_CON2_CLR_MASK, MT6351_PMIC_TOP_CKSEL_CON2_CLR_SHIFT},
	{PMIC_RG_BUCK_VCORE_OSC_SEL_SW, MT6351_PMIC_RG_BUCK_VCORE_OSC_SEL_SW_ADDR,
	 MT6351_PMIC_RG_BUCK_VCORE_OSC_SEL_SW_MASK, MT6351_PMIC_RG_BUCK_VCORE_OSC_SEL_SW_SHIFT},
	{PMIC_RG_BUCK_VSRAM_PROC_OSC_SEL_SW,
	 MT6351_PMIC_RG_BUCK_VSRAM_PROC_OSC_SEL_SW_ADDR,
	 MT6351_PMIC_RG_BUCK_VSRAM_PROC_OSC_SEL_SW_MASK,
	 MT6351_PMIC_RG_BUCK_VSRAM_PROC_OSC_SEL_SW_SHIFT},
	{PMIC_RG_BUCK_VPA_OSC_SEL_SW, MT6351_PMIC_RG_BUCK_VPA_OSC_SEL_SW_ADDR,
	 MT6351_PMIC_RG_BUCK_VPA_OSC_SEL_SW_MASK, MT6351_PMIC_RG_BUCK_VPA_OSC_SEL_SW_SHIFT},
	{PMIC_RG_BUCK_VMODEM_OSC_SEL_SW, MT6351_PMIC_RG_BUCK_VMODEM_OSC_SEL_SW_ADDR,
	 MT6351_PMIC_RG_BUCK_VMODEM_OSC_SEL_SW_MASK, MT6351_PMIC_RG_BUCK_VMODEM_OSC_SEL_SW_SHIFT},
	{PMIC_RG_BUCK_VGPU_OSC_SEL_SW, MT6351_PMIC_RG_BUCK_VGPU_OSC_SEL_SW_ADDR,
	 MT6351_PMIC_RG_BUCK_VGPU_OSC_SEL_SW_MASK, MT6351_PMIC_RG_BUCK_VGPU_OSC_SEL_SW_SHIFT},
	{PMIC_RG_BUCK_VSRAM_MD_OSC_SEL_SW, MT6351_PMIC_RG_BUCK_VSRAM_MD_OSC_SEL_SW_ADDR,
	 MT6351_PMIC_RG_BUCK_VSRAM_MD_OSC_SEL_SW_MASK,
	 MT6351_PMIC_RG_BUCK_VSRAM_MD_OSC_SEL_SW_SHIFT},
	{PMIC_RG_BUCK_VS2_OSC_SEL_SW, MT6351_PMIC_RG_BUCK_VS2_OSC_SEL_SW_ADDR,
	 MT6351_PMIC_RG_BUCK_VS2_OSC_SEL_SW_MASK, MT6351_PMIC_RG_BUCK_VS2_OSC_SEL_SW_SHIFT},
	{PMIC_RG_BUCK_VS1_OSC_SEL_SW, MT6351_PMIC_RG_BUCK_VS1_OSC_SEL_SW_ADDR,
	 MT6351_PMIC_RG_BUCK_VS1_OSC_SEL_SW_MASK, MT6351_PMIC_RG_BUCK_VS1_OSC_SEL_SW_SHIFT},
	{PMIC_RG_BUCK_VCORE_OSC_SEL_MODE, MT6351_PMIC_RG_BUCK_VCORE_OSC_SEL_MODE_ADDR,
	 MT6351_PMIC_RG_BUCK_VCORE_OSC_SEL_MODE_MASK,
	 MT6351_PMIC_RG_BUCK_VCORE_OSC_SEL_MODE_SHIFT},
	{PMIC_RG_BUCK_VSRAM_PROC_OSC_SEL_MODE,
	 MT6351_PMIC_RG_BUCK_VSRAM_PROC_OSC_SEL_MODE_ADDR,
	 MT6351_PMIC_RG_BUCK_VSRAM_PROC_OSC_SEL_MODE_MASK,
	 MT6351_PMIC_RG_BUCK_VSRAM_PROC_OSC_SEL_MODE_SHIFT},
	{PMIC_RG_BUCK_VPA_OSC_SEL_MODE, MT6351_PMIC_RG_BUCK_VPA_OSC_SEL_MODE_ADDR,
	 MT6351_PMIC_RG_BUCK_VPA_OSC_SEL_MODE_MASK, MT6351_PMIC_RG_BUCK_VPA_OSC_SEL_MODE_SHIFT},
	{PMIC_RG_BUCK_VMODEM_OSC_SEL_MODE, MT6351_PMIC_RG_BUCK_VMODEM_OSC_SEL_MODE_ADDR,
	 MT6351_PMIC_RG_BUCK_VMODEM_OSC_SEL_MODE_MASK,
	 MT6351_PMIC_RG_BUCK_VMODEM_OSC_SEL_MODE_SHIFT},
	{PMIC_RG_BUCK_VGPU_OSC_SEL_MODE, MT6351_PMIC_RG_BUCK_VGPU_OSC_SEL_MODE_ADDR,
	 MT6351_PMIC_RG_BUCK_VGPU_OSC_SEL_MODE_MASK, MT6351_PMIC_RG_BUCK_VGPU_OSC_SEL_MODE_SHIFT},
	{PMIC_RG_BUCK_VSRAM_MD_OSC_SEL_MODE,
	 MT6351_PMIC_RG_BUCK_VSRAM_MD_OSC_SEL_MODE_ADDR,
	 MT6351_PMIC_RG_BUCK_VSRAM_MD_OSC_SEL_MODE_MASK,
	 MT6351_PMIC_RG_BUCK_VSRAM_MD_OSC_SEL_MODE_SHIFT},
	{PMIC_RG_BUCK_VS2_OSC_SEL_MODE, MT6351_PMIC_RG_BUCK_VS2_OSC_SEL_MODE_ADDR,
	 MT6351_PMIC_RG_BUCK_VS2_OSC_SEL_MODE_MASK, MT6351_PMIC_RG_BUCK_VS2_OSC_SEL_MODE_SHIFT},
	{PMIC_RG_BUCK_VS1_OSC_SEL_MODE, MT6351_PMIC_RG_BUCK_VS1_OSC_SEL_MODE_ADDR,
	 MT6351_PMIC_RG_BUCK_VS1_OSC_SEL_MODE_MASK, MT6351_PMIC_RG_BUCK_VS1_OSC_SEL_MODE_SHIFT},
	{PMIC_TOP_CKSEL_CON3_SET, MT6351_PMIC_TOP_CKSEL_CON3_SET_ADDR,
	 MT6351_PMIC_TOP_CKSEL_CON3_SET_MASK, MT6351_PMIC_TOP_CKSEL_CON3_SET_SHIFT},
	{PMIC_TOP_CKSEL_CON3_CLR, MT6351_PMIC_TOP_CKSEL_CON3_CLR_ADDR,
	 MT6351_PMIC_TOP_CKSEL_CON3_CLR_MASK, MT6351_PMIC_TOP_CKSEL_CON3_CLR_SHIFT},
	{PMIC_RG_STRUP_LBAT_SEL_CK_DIVSEL, MT6351_PMIC_RG_STRUP_LBAT_SEL_CK_DIVSEL_ADDR,
	 MT6351_PMIC_RG_STRUP_LBAT_SEL_CK_DIVSEL_MASK,
	 MT6351_PMIC_RG_STRUP_LBAT_SEL_CK_DIVSEL_SHIFT},
	{PMIC_TOP_CKDIVSEL_CON_RSV, MT6351_PMIC_TOP_CKDIVSEL_CON_RSV_ADDR,
	 MT6351_PMIC_TOP_CKDIVSEL_CON_RSV_MASK, MT6351_PMIC_TOP_CKDIVSEL_CON_RSV_SHIFT},
	{PMIC_RG_BIF_X4_CK_DIVSEL, MT6351_PMIC_RG_BIF_X4_CK_DIVSEL_ADDR,
	 MT6351_PMIC_RG_BIF_X4_CK_DIVSEL_MASK, MT6351_PMIC_RG_BIF_X4_CK_DIVSEL_SHIFT},
	{PMIC_RG_REG_CK_DIVSEL, MT6351_PMIC_RG_REG_CK_DIVSEL_ADDR,
	 MT6351_PMIC_RG_REG_CK_DIVSEL_MASK, MT6351_PMIC_RG_REG_CK_DIVSEL_SHIFT},
	{PMIC_TOP_CKDIVSEL_CON0_RSV, MT6351_PMIC_TOP_CKDIVSEL_CON0_RSV_ADDR,
	 MT6351_PMIC_TOP_CKDIVSEL_CON0_RSV_MASK, MT6351_PMIC_TOP_CKDIVSEL_CON0_RSV_SHIFT},
	{PMIC_TOP_CKDIVSEL_CON0_SET, MT6351_PMIC_TOP_CKDIVSEL_CON0_SET_ADDR,
	 MT6351_PMIC_TOP_CKDIVSEL_CON0_SET_MASK, MT6351_PMIC_TOP_CKDIVSEL_CON0_SET_SHIFT},
	{PMIC_TOP_CKDIVSEL_CON0_CLR, MT6351_PMIC_TOP_CKDIVSEL_CON0_CLR_ADDR,
	 MT6351_PMIC_TOP_CKDIVSEL_CON0_CLR_MASK, MT6351_PMIC_TOP_CKDIVSEL_CON0_CLR_SHIFT},
	{PMIC_RG_AUXADC_SMPS_CK_DIVSEL, MT6351_PMIC_RG_AUXADC_SMPS_CK_DIVSEL_ADDR,
	 MT6351_PMIC_RG_AUXADC_SMPS_CK_DIVSEL_MASK, MT6351_PMIC_RG_AUXADC_SMPS_CK_DIVSEL_SHIFT},
	{PMIC_RG_AUXADC_26M_CK_DIVSEL, MT6351_PMIC_RG_AUXADC_26M_CK_DIVSEL_ADDR,
	 MT6351_PMIC_RG_AUXADC_26M_CK_DIVSEL_MASK, MT6351_PMIC_RG_AUXADC_26M_CK_DIVSEL_SHIFT},
	{PMIC_RG_BUCK_9M_CK_DIVSEL, MT6351_PMIC_RG_BUCK_9M_CK_DIVSEL_ADDR,
	 MT6351_PMIC_RG_BUCK_9M_CK_DIVSEL_MASK, MT6351_PMIC_RG_BUCK_9M_CK_DIVSEL_SHIFT},
	{PMIC_TOP_CKDIVSEL_CON1_SET, MT6351_PMIC_TOP_CKDIVSEL_CON1_SET_ADDR,
	 MT6351_PMIC_TOP_CKDIVSEL_CON1_SET_MASK, MT6351_PMIC_TOP_CKDIVSEL_CON1_SET_SHIFT},
	{PMIC_TOP_CKDIVSEL_CON1_CLR, MT6351_PMIC_TOP_CKDIVSEL_CON1_CLR_ADDR,
	 MT6351_PMIC_TOP_CKDIVSEL_CON1_CLR_MASK, MT6351_PMIC_TOP_CKDIVSEL_CON1_CLR_SHIFT},
	{PMIC_RG_G_SMPS_PD_CK_PDN_HWEN, MT6351_PMIC_RG_G_SMPS_PD_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_G_SMPS_PD_CK_PDN_HWEN_MASK, MT6351_PMIC_RG_G_SMPS_PD_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_G_SMPS_AUD_CK_PDN_HWEN, MT6351_PMIC_RG_G_SMPS_AUD_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_G_SMPS_AUD_CK_PDN_HWEN_MASK, MT6351_PMIC_RG_G_SMPS_AUD_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_G_DRV_2M_CK_PDN_HWEN, MT6351_PMIC_RG_G_DRV_2M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_G_DRV_2M_CK_PDN_HWEN_MASK, MT6351_PMIC_RG_G_DRV_2M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_AUXADC_CK_PDN_HWEN, MT6351_PMIC_RG_AUXADC_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_AUXADC_CK_PDN_HWEN_MASK, MT6351_PMIC_RG_AUXADC_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_AUXADC_SMPS_CK_PDN_HWEN, MT6351_PMIC_RG_AUXADC_SMPS_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_AUXADC_SMPS_CK_PDN_HWEN_MASK,
	 MT6351_PMIC_RG_AUXADC_SMPS_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_1M_CK_PDN_HWEN, MT6351_PMIC_RG_BUCK_1M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_BUCK_1M_CK_PDN_HWEN_MASK, MT6351_PMIC_RG_BUCK_1M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_EFUSE_CK_PDN_HWEN, MT6351_PMIC_RG_EFUSE_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_EFUSE_CK_PDN_HWEN_MASK, MT6351_PMIC_RG_EFUSE_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_RTC_26M_CK_PDN_HWEN, MT6351_PMIC_RG_RTC_26M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_RTC_26M_CK_PDN_HWEN_MASK, MT6351_PMIC_RG_RTC_26M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_AUXADC_26M_CK_PDN_HWEN, MT6351_PMIC_RG_AUXADC_26M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_AUXADC_26M_CK_PDN_HWEN_MASK, MT6351_PMIC_RG_AUXADC_26M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_AUXADC_CK_CKSEL_HWEN, MT6351_PMIC_RG_AUXADC_CK_CKSEL_HWEN_ADDR,
	 MT6351_PMIC_RG_AUXADC_CK_CKSEL_HWEN_MASK, MT6351_PMIC_RG_AUXADC_CK_CKSEL_HWEN_SHIFT},
	{PMIC_TOP_CKHWEN_CON0_RSV, MT6351_PMIC_TOP_CKHWEN_CON0_RSV_ADDR,
	 MT6351_PMIC_TOP_CKHWEN_CON0_RSV_MASK, MT6351_PMIC_TOP_CKHWEN_CON0_RSV_SHIFT},
	{PMIC_TOP_CKHWEN_CON0_SET, MT6351_PMIC_TOP_CKHWEN_CON0_SET_ADDR,
	 MT6351_PMIC_TOP_CKHWEN_CON0_SET_MASK, MT6351_PMIC_TOP_CKHWEN_CON0_SET_SHIFT},
	{PMIC_TOP_CKHWEN_CON0_CLR, MT6351_PMIC_TOP_CKHWEN_CON0_CLR_ADDR,
	 MT6351_PMIC_TOP_CKHWEN_CON0_CLR_MASK, MT6351_PMIC_TOP_CKHWEN_CON0_CLR_SHIFT},
	{PMIC_RG_BUCK_VSRAM_PROC_9M_CK_PDN_HWEN,
	 MT6351_PMIC_RG_BUCK_VSRAM_PROC_9M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_BUCK_VSRAM_PROC_9M_CK_PDN_HWEN_MASK,
	 MT6351_PMIC_RG_BUCK_VSRAM_PROC_9M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_VPA_9M_CK_PDN_HWEN, MT6351_PMIC_RG_BUCK_VPA_9M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_BUCK_VPA_9M_CK_PDN_HWEN_MASK,
	 MT6351_PMIC_RG_BUCK_VPA_9M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_VMODEM_9M_CK_PDN_HWEN,
	 MT6351_PMIC_RG_BUCK_VMODEM_9M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_BUCK_VMODEM_9M_CK_PDN_HWEN_MASK,
	 MT6351_PMIC_RG_BUCK_VMODEM_9M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_VCORE_9M_CK_PDN_HWEN, MT6351_PMIC_RG_BUCK_VCORE_9M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_BUCK_VCORE_9M_CK_PDN_HWEN_MASK,
	 MT6351_PMIC_RG_BUCK_VCORE_9M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_VGPU_9M_CK_PDN_HWEN, MT6351_PMIC_RG_BUCK_VGPU_9M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_BUCK_VGPU_9M_CK_PDN_HWEN_MASK,
	 MT6351_PMIC_RG_BUCK_VGPU_9M_CK_PDN_HWEN_SHIFT},
	{PMIC_TOP_CKHWEN_CON1_RSV, MT6351_PMIC_TOP_CKHWEN_CON1_RSV_ADDR,
	 MT6351_PMIC_TOP_CKHWEN_CON1_RSV_MASK, MT6351_PMIC_TOP_CKHWEN_CON1_RSV_SHIFT},
	{PMIC_TOP_CKHWEN_CON1_SET, MT6351_PMIC_TOP_CKHWEN_CON1_SET_ADDR,
	 MT6351_PMIC_TOP_CKHWEN_CON1_SET_MASK, MT6351_PMIC_TOP_CKHWEN_CON1_SET_SHIFT},
	{PMIC_TOP_CKHWEN_CON1_CLR, MT6351_PMIC_TOP_CKHWEN_CON1_CLR_ADDR,
	 MT6351_PMIC_TOP_CKHWEN_CON1_CLR_MASK, MT6351_PMIC_TOP_CKHWEN_CON1_CLR_SHIFT},
	{PMIC_RG_BUCK_VS2_9M_CK_PDN_HWEN, MT6351_PMIC_RG_BUCK_VS2_9M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_BUCK_VS2_9M_CK_PDN_HWEN_MASK,
	 MT6351_PMIC_RG_BUCK_VS2_9M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_VS1_9M_CK_PDN_HWEN, MT6351_PMIC_RG_BUCK_VS1_9M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_BUCK_VS1_9M_CK_PDN_HWEN_MASK,
	 MT6351_PMIC_RG_BUCK_VS1_9M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_VMD1_9M_CK_PDN_HWEN, MT6351_PMIC_RG_BUCK_VMD1_9M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_BUCK_VMD1_9M_CK_PDN_HWEN_MASK,
	 MT6351_PMIC_RG_BUCK_VMD1_9M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_VSRAM_MD_9M_CK_PDN_HWEN,
	 MT6351_PMIC_RG_BUCK_VSRAM_MD_9M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_BUCK_VSRAM_MD_9M_CK_PDN_HWEN_MASK,
	 MT6351_PMIC_RG_BUCK_VSRAM_MD_9M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_AUD18M_CK_PDN_HWEN, MT6351_PMIC_RG_AUD18M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_AUD18M_CK_PDN_HWEN_MASK, MT6351_PMIC_RG_AUD18M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_AUD_1M_CK_PDN_HWEN, MT6351_PMIC_RG_BUCK_AUD_1M_CK_PDN_HWEN_ADDR,
	 MT6351_PMIC_RG_BUCK_AUD_1M_CK_PDN_HWEN_MASK,
	 MT6351_PMIC_RG_BUCK_AUD_1M_CK_PDN_HWEN_SHIFT},
	{PMIC_TOP_CKHWEN_CON2_RSV, MT6351_PMIC_TOP_CKHWEN_CON2_RSV_ADDR,
	 MT6351_PMIC_TOP_CKHWEN_CON2_RSV_MASK, MT6351_PMIC_TOP_CKHWEN_CON2_RSV_SHIFT},
	{PMIC_TOP_CKHWEN_CON2_SET, MT6351_PMIC_TOP_CKHWEN_CON2_SET_ADDR,
	 MT6351_PMIC_TOP_CKHWEN_CON2_SET_MASK, MT6351_PMIC_TOP_CKHWEN_CON2_SET_SHIFT},
	{PMIC_TOP_CKHWEN_CON2_CLR, MT6351_PMIC_TOP_CKHWEN_CON2_CLR_ADDR,
	 MT6351_PMIC_TOP_CKHWEN_CON2_CLR_MASK, MT6351_PMIC_TOP_CKHWEN_CON2_CLR_SHIFT},
	{PMIC_RG_PMU75K_CK_TST_DIS, MT6351_PMIC_RG_PMU75K_CK_TST_DIS_ADDR,
	 MT6351_PMIC_RG_PMU75K_CK_TST_DIS_MASK, MT6351_PMIC_RG_PMU75K_CK_TST_DIS_SHIFT},
	{PMIC_RG_SMPS_CK_TST_DIS, MT6351_PMIC_RG_SMPS_CK_TST_DIS_ADDR,
	 MT6351_PMIC_RG_SMPS_CK_TST_DIS_MASK, MT6351_PMIC_RG_SMPS_CK_TST_DIS_SHIFT},
	{PMIC_RG_AUD26M_CK_TST_DIS, MT6351_PMIC_RG_AUD26M_CK_TST_DIS_ADDR,
	 MT6351_PMIC_RG_AUD26M_CK_TST_DIS_MASK, MT6351_PMIC_RG_AUD26M_CK_TST_DIS_SHIFT},
	{PMIC_RG_RTC32K_CK_TST_DIS, MT6351_PMIC_RG_RTC32K_CK_TST_DIS_ADDR,
	 MT6351_PMIC_RG_RTC32K_CK_TST_DIS_MASK, MT6351_PMIC_RG_RTC32K_CK_TST_DIS_SHIFT},
	{PMIC_RG_FG_CK_TST_DIS, MT6351_PMIC_RG_FG_CK_TST_DIS_ADDR,
	 MT6351_PMIC_RG_FG_CK_TST_DIS_MASK, MT6351_PMIC_RG_FG_CK_TST_DIS_SHIFT},
	{PMIC_RG_RTC26M_CK_TST_DIS, MT6351_PMIC_RG_RTC26M_CK_TST_DIS_ADDR,
	 MT6351_PMIC_RG_RTC26M_CK_TST_DIS_MASK, MT6351_PMIC_RG_RTC26M_CK_TST_DIS_SHIFT},
	{PMIC_RG_VOW12M_CK_TST_DIS, MT6351_PMIC_RG_VOW12M_CK_TST_DIS_ADDR,
	 MT6351_PMIC_RG_VOW12M_CK_TST_DIS_MASK, MT6351_PMIC_RG_VOW12M_CK_TST_DIS_SHIFT},
	{PMIC_TOP_CKTST_CON0_RSV, MT6351_PMIC_TOP_CKTST_CON0_RSV_ADDR,
	 MT6351_PMIC_TOP_CKTST_CON0_RSV_MASK, MT6351_PMIC_TOP_CKTST_CON0_RSV_SHIFT},
	{PMIC_RG_BUCK_ANA_AUTO_OFF_DIS, MT6351_PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_ADDR,
	 MT6351_PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_MASK, MT6351_PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_SHIFT},
	{PMIC_RG_DRV_ISINK0_CK_TSTSEL, MT6351_PMIC_RG_DRV_ISINK0_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK0_CK_TSTSEL_MASK, MT6351_PMIC_RG_DRV_ISINK0_CK_TSTSEL_SHIFT},
	{PMIC_RG_DRV_ISINK1_CK_TSTSEL, MT6351_PMIC_RG_DRV_ISINK1_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK1_CK_TSTSEL_MASK, MT6351_PMIC_RG_DRV_ISINK1_CK_TSTSEL_SHIFT},
	{PMIC_RG_DRV_ISINK2_CK_TSTSEL, MT6351_PMIC_RG_DRV_ISINK2_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK2_CK_TSTSEL_MASK, MT6351_PMIC_RG_DRV_ISINK2_CK_TSTSEL_SHIFT},
	{PMIC_RG_DRV_ISINK3_CK_TSTSEL, MT6351_PMIC_RG_DRV_ISINK3_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK3_CK_TSTSEL_MASK, MT6351_PMIC_RG_DRV_ISINK3_CK_TSTSEL_SHIFT},
	{PMIC_RG_FQMTR_CK_TSTSEL, MT6351_PMIC_RG_FQMTR_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_FQMTR_CK_TSTSEL_MASK, MT6351_PMIC_RG_FQMTR_CK_TSTSEL_SHIFT},
	{PMIC_RG_RTCDET_CK_TSTSEL, MT6351_PMIC_RG_RTCDET_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_RTCDET_CK_TSTSEL_MASK, MT6351_PMIC_RG_RTCDET_CK_TSTSEL_SHIFT},
	{PMIC_RG_PMU75K_CK_TSTSEL, MT6351_PMIC_RG_PMU75K_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_PMU75K_CK_TSTSEL_MASK, MT6351_PMIC_RG_PMU75K_CK_TSTSEL_SHIFT},
	{PMIC_RG_SMPS_CK_TSTSEL, MT6351_PMIC_RG_SMPS_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_SMPS_CK_TSTSEL_MASK, MT6351_PMIC_RG_SMPS_CK_TSTSEL_SHIFT},
	{PMIC_RG_AUD26M_CK_TSTSEL, MT6351_PMIC_RG_AUD26M_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_AUD26M_CK_TSTSEL_MASK, MT6351_PMIC_RG_AUD26M_CK_TSTSEL_SHIFT},
	{PMIC_RG_AUDIF_CK_TSTSEL, MT6351_PMIC_RG_AUDIF_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_AUDIF_CK_TSTSEL_MASK, MT6351_PMIC_RG_AUDIF_CK_TSTSEL_SHIFT},
	{PMIC_RG_AUD_CK_TSTSEL, MT6351_PMIC_RG_AUD_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_AUD_CK_TSTSEL_MASK, MT6351_PMIC_RG_AUD_CK_TSTSEL_SHIFT},
	{PMIC_RG_STRUP_75K_CK_TSTSEL, MT6351_PMIC_RG_STRUP_75K_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_STRUP_75K_CK_TSTSEL_MASK, MT6351_PMIC_RG_STRUP_75K_CK_TSTSEL_SHIFT},
	{PMIC_RG_RTC32K_CK_TSTSEL, MT6351_PMIC_RG_RTC32K_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_RTC32K_CK_TSTSEL_MASK, MT6351_PMIC_RG_RTC32K_CK_TSTSEL_SHIFT},
	{PMIC_RG_PCHR_TEST_CK_TSTSEL, MT6351_PMIC_RG_PCHR_TEST_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_PCHR_TEST_CK_TSTSEL_MASK, MT6351_PMIC_RG_PCHR_TEST_CK_TSTSEL_SHIFT},
	{PMIC_RG_BGR_TEST_CK_TSTSEL, MT6351_PMIC_RG_BGR_TEST_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_BGR_TEST_CK_TSTSEL_MASK, MT6351_PMIC_RG_BGR_TEST_CK_TSTSEL_SHIFT},
	{PMIC_RG_FG_CK_TSTSEL, MT6351_PMIC_RG_FG_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_FG_CK_TSTSEL_MASK, MT6351_PMIC_RG_FG_CK_TSTSEL_SHIFT},
	{PMIC_RG_FGADC_ANA_CK_TSTSEL, MT6351_PMIC_RG_FGADC_ANA_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_FGADC_ANA_CK_TSTSEL_MASK, MT6351_PMIC_RG_FGADC_ANA_CK_TSTSEL_SHIFT},
	{PMIC_RG_RTC26M_CK_TSTSEL, MT6351_PMIC_RG_RTC26M_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_RTC26M_CK_TSTSEL_MASK, MT6351_PMIC_RG_RTC26M_CK_TSTSEL_SHIFT},
	{PMIC_RG_RTC_EOSC32_CK_TSTSEL, MT6351_PMIC_RG_RTC_EOSC32_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_RTC_EOSC32_CK_TSTSEL_MASK, MT6351_PMIC_RG_RTC_EOSC32_CK_TSTSEL_SHIFT},
	{PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL, MT6351_PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL_MASK,
	 MT6351_PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL_SHIFT},
	{PMIC_RG_AUXADC_CK_TSTSEL, MT6351_PMIC_RG_AUXADC_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_AUXADC_CK_TSTSEL_MASK, MT6351_PMIC_RG_AUXADC_CK_TSTSEL_SHIFT},
	{PMIC_RG_AUXADC_SMPS_CK_TSTSEL, MT6351_PMIC_RG_AUXADC_SMPS_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_AUXADC_SMPS_CK_TSTSEL_MASK, MT6351_PMIC_RG_AUXADC_SMPS_CK_TSTSEL_SHIFT},
	{PMIC_RG_AUXADC_26M_CK_TSTSEL, MT6351_PMIC_RG_AUXADC_26M_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_AUXADC_26M_CK_TSTSEL_MASK, MT6351_PMIC_RG_AUXADC_26M_CK_TSTSEL_SHIFT},
	{PMIC_RG_VOW12M_CK_TSTSEL, MT6351_PMIC_RG_VOW12M_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_VOW12M_CK_TSTSEL_MASK, MT6351_PMIC_RG_VOW12M_CK_TSTSEL_SHIFT},
	{PMIC_RG_DRV_ISINK4_CK_TSTSEL, MT6351_PMIC_RG_DRV_ISINK4_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK4_CK_TSTSEL_MASK, MT6351_PMIC_RG_DRV_ISINK4_CK_TSTSEL_SHIFT},
	{PMIC_RG_DRV_ISINK5_CK_TSTSEL, MT6351_PMIC_RG_DRV_ISINK5_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK5_CK_TSTSEL_MASK, MT6351_PMIC_RG_DRV_ISINK5_CK_TSTSEL_SHIFT},
	{PMIC_RG_DRV_ISINK6_CK_TSTSEL, MT6351_PMIC_RG_DRV_ISINK6_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK6_CK_TSTSEL_MASK, MT6351_PMIC_RG_DRV_ISINK6_CK_TSTSEL_SHIFT},
	{PMIC_RG_DRV_ISINK7_CK_TSTSEL, MT6351_PMIC_RG_DRV_ISINK7_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_DRV_ISINK7_CK_TSTSEL_MASK, MT6351_PMIC_RG_DRV_ISINK7_CK_TSTSEL_SHIFT},
	{PMIC_RG_DRV_CHRIND_CK_TSTSEL, MT6351_PMIC_RG_DRV_CHRIND_CK_TSTSEL_ADDR,
	 MT6351_PMIC_RG_DRV_CHRIND_CK_TSTSEL_MASK, MT6351_PMIC_RG_DRV_CHRIND_CK_TSTSEL_SHIFT},
	{PMIC_TOP_CKTST_CON2_RSV, MT6351_PMIC_TOP_CKTST_CON2_RSV_ADDR,
	 MT6351_PMIC_TOP_CKTST_CON2_RSV_MASK, MT6351_PMIC_TOP_CKTST_CON2_RSV_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUD, MT6351_PMIC_RG_CLKSQ_EN_AUD_ADDR,
	 MT6351_PMIC_RG_CLKSQ_EN_AUD_MASK, MT6351_PMIC_RG_CLKSQ_EN_AUD_SHIFT},
	{PMIC_RG_CLKSQ_EN_FQR, MT6351_PMIC_RG_CLKSQ_EN_FQR_ADDR,
	 MT6351_PMIC_RG_CLKSQ_EN_FQR_MASK, MT6351_PMIC_RG_CLKSQ_EN_FQR_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUX_AP, MT6351_PMIC_RG_CLKSQ_EN_AUX_AP_ADDR,
	 MT6351_PMIC_RG_CLKSQ_EN_AUX_AP_MASK, MT6351_PMIC_RG_CLKSQ_EN_AUX_AP_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUX_MD, MT6351_PMIC_RG_CLKSQ_EN_AUX_MD_ADDR,
	 MT6351_PMIC_RG_CLKSQ_EN_AUX_MD_MASK, MT6351_PMIC_RG_CLKSQ_EN_AUX_MD_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUX_GPS, MT6351_PMIC_RG_CLKSQ_EN_AUX_GPS_ADDR,
	 MT6351_PMIC_RG_CLKSQ_EN_AUX_GPS_MASK, MT6351_PMIC_RG_CLKSQ_EN_AUX_GPS_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUX_RSV, MT6351_PMIC_RG_CLKSQ_EN_AUX_RSV_ADDR,
	 MT6351_PMIC_RG_CLKSQ_EN_AUX_RSV_MASK, MT6351_PMIC_RG_CLKSQ_EN_AUX_RSV_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUX_AP_MODE, MT6351_PMIC_RG_CLKSQ_EN_AUX_AP_MODE_ADDR,
	 MT6351_PMIC_RG_CLKSQ_EN_AUX_AP_MODE_MASK, MT6351_PMIC_RG_CLKSQ_EN_AUX_AP_MODE_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUX_MD_MODE, MT6351_PMIC_RG_CLKSQ_EN_AUX_MD_MODE_ADDR,
	 MT6351_PMIC_RG_CLKSQ_EN_AUX_MD_MODE_MASK, MT6351_PMIC_RG_CLKSQ_EN_AUX_MD_MODE_SHIFT},
	{PMIC_RG_CLKSQ_IN_SEL_VA18, MT6351_PMIC_RG_CLKSQ_IN_SEL_VA18_ADDR,
	 MT6351_PMIC_RG_CLKSQ_IN_SEL_VA18_MASK, MT6351_PMIC_RG_CLKSQ_IN_SEL_VA18_SHIFT},
	{PMIC_RG_CLKSQ_IN_SEL_VA18_SWCTRL, MT6351_PMIC_RG_CLKSQ_IN_SEL_VA18_SWCTRL_ADDR,
	 MT6351_PMIC_RG_CLKSQ_IN_SEL_VA18_SWCTRL_MASK,
	 MT6351_PMIC_RG_CLKSQ_IN_SEL_VA18_SWCTRL_SHIFT},
	{PMIC_TOP_CLKSQ_RSV, MT6351_PMIC_TOP_CLKSQ_RSV_ADDR,
	 MT6351_PMIC_TOP_CLKSQ_RSV_MASK, MT6351_PMIC_TOP_CLKSQ_RSV_SHIFT},
	{PMIC_DA_CLKSQ_EN_VA18, MT6351_PMIC_DA_CLKSQ_EN_VA18_ADDR,
	 MT6351_PMIC_DA_CLKSQ_EN_VA18_MASK, MT6351_PMIC_DA_CLKSQ_EN_VA18_SHIFT},
	{PMIC_TOP_CLKSQ_SET, MT6351_PMIC_TOP_CLKSQ_SET_ADDR,
	 MT6351_PMIC_TOP_CLKSQ_SET_MASK, MT6351_PMIC_TOP_CLKSQ_SET_SHIFT},
	{PMIC_TOP_CLKSQ_CLR, MT6351_PMIC_TOP_CLKSQ_CLR_ADDR,
	 MT6351_PMIC_TOP_CLKSQ_CLR_MASK, MT6351_PMIC_TOP_CLKSQ_CLR_SHIFT},
	{PMIC_RG_CLKSQ_RTC_EN, MT6351_PMIC_RG_CLKSQ_RTC_EN_ADDR,
	 MT6351_PMIC_RG_CLKSQ_RTC_EN_MASK, MT6351_PMIC_RG_CLKSQ_RTC_EN_SHIFT},
	{PMIC_RG_CLKSQ_RTC_EN_HW_MODE, MT6351_PMIC_RG_CLKSQ_RTC_EN_HW_MODE_ADDR,
	 MT6351_PMIC_RG_CLKSQ_RTC_EN_HW_MODE_MASK, MT6351_PMIC_RG_CLKSQ_RTC_EN_HW_MODE_SHIFT},
	{PMIC_TOP_CLKSQ_RTC_RSV0, MT6351_PMIC_TOP_CLKSQ_RTC_RSV0_ADDR,
	 MT6351_PMIC_TOP_CLKSQ_RTC_RSV0_MASK, MT6351_PMIC_TOP_CLKSQ_RTC_RSV0_SHIFT},
	{PMIC_RG_ENBB_SEL, MT6351_PMIC_RG_ENBB_SEL_ADDR, MT6351_PMIC_RG_ENBB_SEL_MASK,
	 MT6351_PMIC_RG_ENBB_SEL_SHIFT},
	{PMIC_RG_XOSC_EN_SEL, MT6351_PMIC_RG_XOSC_EN_SEL_ADDR,
	 MT6351_PMIC_RG_XOSC_EN_SEL_MASK, MT6351_PMIC_RG_XOSC_EN_SEL_SHIFT},
	{PMIC_TOP_CLKSQ_RTC_RSV1, MT6351_PMIC_TOP_CLKSQ_RTC_RSV1_ADDR,
	 MT6351_PMIC_TOP_CLKSQ_RTC_RSV1_MASK, MT6351_PMIC_TOP_CLKSQ_RTC_RSV1_SHIFT},
	{PMIC_DA_CLKSQ_EN_VDIG18, MT6351_PMIC_DA_CLKSQ_EN_VDIG18_ADDR,
	 MT6351_PMIC_DA_CLKSQ_EN_VDIG18_MASK, MT6351_PMIC_DA_CLKSQ_EN_VDIG18_SHIFT},
	{PMIC_TOP_CLKSQ_RTC_SET, MT6351_PMIC_TOP_CLKSQ_RTC_SET_ADDR,
	 MT6351_PMIC_TOP_CLKSQ_RTC_SET_MASK, MT6351_PMIC_TOP_CLKSQ_RTC_SET_SHIFT},
	{PMIC_TOP_CLKSQ_RTC_CLR, MT6351_PMIC_TOP_CLKSQ_RTC_CLR_ADDR,
	 MT6351_PMIC_TOP_CLKSQ_RTC_CLR_MASK, MT6351_PMIC_TOP_CLKSQ_RTC_CLR_SHIFT},
	{PMIC_OSC_75K_TRIM, MT6351_PMIC_OSC_75K_TRIM_ADDR, MT6351_PMIC_OSC_75K_TRIM_MASK,
	 MT6351_PMIC_OSC_75K_TRIM_SHIFT},
	{PMIC_RG_OSC_75K_TRIM_EN, MT6351_PMIC_RG_OSC_75K_TRIM_EN_ADDR,
	 MT6351_PMIC_RG_OSC_75K_TRIM_EN_MASK, MT6351_PMIC_RG_OSC_75K_TRIM_EN_SHIFT},
	{PMIC_RG_OSC_75K_TRIM_RATE, MT6351_PMIC_RG_OSC_75K_TRIM_RATE_ADDR,
	 MT6351_PMIC_RG_OSC_75K_TRIM_RATE_MASK, MT6351_PMIC_RG_OSC_75K_TRIM_RATE_SHIFT},
	{PMIC_DA_OSC_75K_TRIM, MT6351_PMIC_DA_OSC_75K_TRIM_ADDR,
	 MT6351_PMIC_DA_OSC_75K_TRIM_MASK, MT6351_PMIC_DA_OSC_75K_TRIM_SHIFT},
	{PMIC_RG_EFUSE_MAN_RST, MT6351_PMIC_RG_EFUSE_MAN_RST_ADDR,
	 MT6351_PMIC_RG_EFUSE_MAN_RST_MASK, MT6351_PMIC_RG_EFUSE_MAN_RST_SHIFT},
	{PMIC_RG_AUXADC_RST, MT6351_PMIC_RG_AUXADC_RST_ADDR,
	 MT6351_PMIC_RG_AUXADC_RST_MASK, MT6351_PMIC_RG_AUXADC_RST_SHIFT},
	{PMIC_RG_AUXADC_REG_RST, MT6351_PMIC_RG_AUXADC_REG_RST_ADDR,
	 MT6351_PMIC_RG_AUXADC_REG_RST_MASK, MT6351_PMIC_RG_AUXADC_REG_RST_SHIFT},
	{PMIC_RG_AUDIO_RST, MT6351_PMIC_RG_AUDIO_RST_ADDR, MT6351_PMIC_RG_AUDIO_RST_MASK,
	 MT6351_PMIC_RG_AUDIO_RST_SHIFT},
	{PMIC_RG_ACCDET_RST, MT6351_PMIC_RG_ACCDET_RST_ADDR,
	 MT6351_PMIC_RG_ACCDET_RST_MASK, MT6351_PMIC_RG_ACCDET_RST_SHIFT},
	{PMIC_RG_BIF_RST, MT6351_PMIC_RG_BIF_RST_ADDR, MT6351_PMIC_RG_BIF_RST_MASK,
	 MT6351_PMIC_RG_BIF_RST_SHIFT},
	{PMIC_RG_DRIVER_RST, MT6351_PMIC_RG_DRIVER_RST_ADDR,
	 MT6351_PMIC_RG_DRIVER_RST_MASK, MT6351_PMIC_RG_DRIVER_RST_SHIFT},
	{PMIC_RG_FGADC_RST, MT6351_PMIC_RG_FGADC_RST_ADDR, MT6351_PMIC_RG_FGADC_RST_MASK,
	 MT6351_PMIC_RG_FGADC_RST_SHIFT},
	{PMIC_RG_FQMTR_RST, MT6351_PMIC_RG_FQMTR_RST_ADDR, MT6351_PMIC_RG_FQMTR_RST_MASK,
	 MT6351_PMIC_RG_FQMTR_RST_SHIFT},
	{PMIC_RG_RTC_RST, MT6351_PMIC_RG_RTC_RST_ADDR, MT6351_PMIC_RG_RTC_RST_MASK,
	 MT6351_PMIC_RG_RTC_RST_SHIFT},
	{PMIC_RG_CHRWDT_RST, MT6351_PMIC_RG_CHRWDT_RST_ADDR,
	 MT6351_PMIC_RG_CHRWDT_RST_MASK, MT6351_PMIC_RG_CHRWDT_RST_SHIFT},
	{PMIC_RG_ZCD_RST, MT6351_PMIC_RG_ZCD_RST_ADDR, MT6351_PMIC_RG_ZCD_RST_MASK,
	 MT6351_PMIC_RG_ZCD_RST_SHIFT},
	{PMIC_RG_AUDNCP_RST, MT6351_PMIC_RG_AUDNCP_RST_ADDR,
	 MT6351_PMIC_RG_AUDNCP_RST_MASK, MT6351_PMIC_RG_AUDNCP_RST_SHIFT},
	{PMIC_RG_CLK_TRIM_RST, MT6351_PMIC_RG_CLK_TRIM_RST_ADDR,
	 MT6351_PMIC_RG_CLK_TRIM_RST_MASK, MT6351_PMIC_RG_CLK_TRIM_RST_SHIFT},
	{PMIC_RG_LDO_CALI_RST, MT6351_PMIC_RG_LDO_CALI_RST_ADDR,
	 MT6351_PMIC_RG_LDO_CALI_RST_MASK, MT6351_PMIC_RG_LDO_CALI_RST_SHIFT},
	{PMIC_TOP_RST_CON0_SET, MT6351_PMIC_TOP_RST_CON0_SET_ADDR,
	 MT6351_PMIC_TOP_RST_CON0_SET_MASK, MT6351_PMIC_TOP_RST_CON0_SET_SHIFT},
	{PMIC_TOP_RST_CON0_CLR, MT6351_PMIC_TOP_RST_CON0_CLR_ADDR,
	 MT6351_PMIC_TOP_RST_CON0_CLR_MASK, MT6351_PMIC_TOP_RST_CON0_CLR_SHIFT},
	{PMIC_RG_STRUP_LONG_PRESS_RST, MT6351_PMIC_RG_STRUP_LONG_PRESS_RST_ADDR,
	 MT6351_PMIC_RG_STRUP_LONG_PRESS_RST_MASK, MT6351_PMIC_RG_STRUP_LONG_PRESS_RST_SHIFT},
	{PMIC_TOP_RST_CON1_RSV, MT6351_PMIC_TOP_RST_CON1_RSV_ADDR,
	 MT6351_PMIC_TOP_RST_CON1_RSV_MASK, MT6351_PMIC_TOP_RST_CON1_RSV_SHIFT},
	{PMIC_TOP_RST_CON1_SET, MT6351_PMIC_TOP_RST_CON1_SET_ADDR,
	 MT6351_PMIC_TOP_RST_CON1_SET_MASK, MT6351_PMIC_TOP_RST_CON1_SET_SHIFT},
	{PMIC_TOP_RST_CON1_CLR, MT6351_PMIC_TOP_RST_CON1_CLR_ADDR,
	 MT6351_PMIC_TOP_RST_CON1_CLR_MASK, MT6351_PMIC_TOP_RST_CON1_CLR_SHIFT},
	{PMIC_RG_CHR_LDO_DET_MODE, MT6351_PMIC_RG_CHR_LDO_DET_MODE_ADDR,
	 MT6351_PMIC_RG_CHR_LDO_DET_MODE_MASK, MT6351_PMIC_RG_CHR_LDO_DET_MODE_SHIFT},
	{PMIC_RG_CHR_LDO_DET_SW, MT6351_PMIC_RG_CHR_LDO_DET_SW_ADDR,
	 MT6351_PMIC_RG_CHR_LDO_DET_SW_MASK, MT6351_PMIC_RG_CHR_LDO_DET_SW_SHIFT},
	{PMIC_RG_CHRWDT_FLAG_MODE, MT6351_PMIC_RG_CHRWDT_FLAG_MODE_ADDR,
	 MT6351_PMIC_RG_CHRWDT_FLAG_MODE_MASK, MT6351_PMIC_RG_CHRWDT_FLAG_MODE_SHIFT},
	{PMIC_RG_CHRWDT_FLAG_SW, MT6351_PMIC_RG_CHRWDT_FLAG_SW_ADDR,
	 MT6351_PMIC_RG_CHRWDT_FLAG_SW_MASK, MT6351_PMIC_RG_CHRWDT_FLAG_SW_SHIFT},
	{PMIC_TOP_RST_CON2_RSV, MT6351_PMIC_TOP_RST_CON2_RSV_ADDR,
	 MT6351_PMIC_TOP_RST_CON2_RSV_MASK, MT6351_PMIC_TOP_RST_CON2_RSV_SHIFT},
	{PMIC_RG_WDTRSTB_EN, MT6351_PMIC_RG_WDTRSTB_EN_ADDR,
	 MT6351_PMIC_RG_WDTRSTB_EN_MASK, MT6351_PMIC_RG_WDTRSTB_EN_SHIFT},
	{PMIC_RG_WDTRSTB_MODE, MT6351_PMIC_RG_WDTRSTB_MODE_ADDR,
	 MT6351_PMIC_RG_WDTRSTB_MODE_MASK, MT6351_PMIC_RG_WDTRSTB_MODE_SHIFT},
	{PMIC_WDTRSTB_STATUS, MT6351_PMIC_WDTRSTB_STATUS_ADDR,
	 MT6351_PMIC_WDTRSTB_STATUS_MASK, MT6351_PMIC_WDTRSTB_STATUS_SHIFT},
	{PMIC_WDTRSTB_STATUS_CLR, MT6351_PMIC_WDTRSTB_STATUS_CLR_ADDR,
	 MT6351_PMIC_WDTRSTB_STATUS_CLR_MASK, MT6351_PMIC_WDTRSTB_STATUS_CLR_SHIFT},
	{PMIC_RG_WDTRSTB_FB_EN, MT6351_PMIC_RG_WDTRSTB_FB_EN_ADDR,
	 MT6351_PMIC_RG_WDTRSTB_FB_EN_MASK, MT6351_PMIC_RG_WDTRSTB_FB_EN_SHIFT},
	{PMIC_RG_WDTRSTB_DEB, MT6351_PMIC_RG_WDTRSTB_DEB_ADDR,
	 MT6351_PMIC_RG_WDTRSTB_DEB_MASK, MT6351_PMIC_RG_WDTRSTB_DEB_SHIFT},
	{PMIC_RG_HOMEKEY_RST_EN, MT6351_PMIC_RG_HOMEKEY_RST_EN_ADDR,
	 MT6351_PMIC_RG_HOMEKEY_RST_EN_MASK, MT6351_PMIC_RG_HOMEKEY_RST_EN_SHIFT},
	{PMIC_RG_PWRKEY_RST_EN, MT6351_PMIC_RG_PWRKEY_RST_EN_ADDR,
	 MT6351_PMIC_RG_PWRKEY_RST_EN_MASK, MT6351_PMIC_RG_PWRKEY_RST_EN_SHIFT},
	{PMIC_RG_PWRRST_TMR_DIS, MT6351_PMIC_RG_PWRRST_TMR_DIS_ADDR,
	 MT6351_PMIC_RG_PWRRST_TMR_DIS_MASK, MT6351_PMIC_RG_PWRRST_TMR_DIS_SHIFT},
	{PMIC_RG_PWRKEY_RST_TD, MT6351_PMIC_RG_PWRKEY_RST_TD_ADDR,
	 MT6351_PMIC_RG_PWRKEY_RST_TD_MASK, MT6351_PMIC_RG_PWRKEY_RST_TD_SHIFT},
	{PMIC_TOP_RST_MISC_RSV, MT6351_PMIC_TOP_RST_MISC_RSV_ADDR,
	 MT6351_PMIC_TOP_RST_MISC_RSV_MASK, MT6351_PMIC_TOP_RST_MISC_RSV_SHIFT},
	{PMIC_TOP_RST_MISC_SET, MT6351_PMIC_TOP_RST_MISC_SET_ADDR,
	 MT6351_PMIC_TOP_RST_MISC_SET_MASK, MT6351_PMIC_TOP_RST_MISC_SET_SHIFT},
	{PMIC_TOP_RST_MISC_CLR, MT6351_PMIC_TOP_RST_MISC_CLR_ADDR,
	 MT6351_PMIC_TOP_RST_MISC_CLR_MASK, MT6351_PMIC_TOP_RST_MISC_CLR_SHIFT},
	{PMIC_VPWRIN_RSTB_STATUS, MT6351_PMIC_VPWRIN_RSTB_STATUS_ADDR,
	 MT6351_PMIC_VPWRIN_RSTB_STATUS_MASK, MT6351_PMIC_VPWRIN_RSTB_STATUS_SHIFT},
	{PMIC_DDLO_RSTB_STATUS, MT6351_PMIC_DDLO_RSTB_STATUS_ADDR,
	 MT6351_PMIC_DDLO_RSTB_STATUS_MASK, MT6351_PMIC_DDLO_RSTB_STATUS_SHIFT},
	{PMIC_UVLO_RSTB_STATUS, MT6351_PMIC_UVLO_RSTB_STATUS_ADDR,
	 MT6351_PMIC_UVLO_RSTB_STATUS_MASK, MT6351_PMIC_UVLO_RSTB_STATUS_SHIFT},
	{PMIC_RTC_DDLO_RSTB_STATUS, MT6351_PMIC_RTC_DDLO_RSTB_STATUS_ADDR,
	 MT6351_PMIC_RTC_DDLO_RSTB_STATUS_MASK, MT6351_PMIC_RTC_DDLO_RSTB_STATUS_SHIFT},
	{PMIC_CHRWDT_REG_RSTB_STATUS, MT6351_PMIC_CHRWDT_REG_RSTB_STATUS_ADDR,
	 MT6351_PMIC_CHRWDT_REG_RSTB_STATUS_MASK, MT6351_PMIC_CHRWDT_REG_RSTB_STATUS_SHIFT},
	{PMIC_CHRDET_REG_RSTB_STATUS, MT6351_PMIC_CHRDET_REG_RSTB_STATUS_ADDR,
	 MT6351_PMIC_CHRDET_REG_RSTB_STATUS_MASK, MT6351_PMIC_CHRDET_REG_RSTB_STATUS_SHIFT},
	{PMIC_TOP_RST_STATUS_RSV, MT6351_PMIC_TOP_RST_STATUS_RSV_ADDR,
	 MT6351_PMIC_TOP_RST_STATUS_RSV_MASK, MT6351_PMIC_TOP_RST_STATUS_RSV_SHIFT},
	{PMIC_TOP_RST_STATUS_SET, MT6351_PMIC_TOP_RST_STATUS_SET_ADDR,
	 MT6351_PMIC_TOP_RST_STATUS_SET_MASK, MT6351_PMIC_TOP_RST_STATUS_SET_SHIFT},
	{PMIC_TOP_RST_STATUS_CLR, MT6351_PMIC_TOP_RST_STATUS_CLR_ADDR,
	 MT6351_PMIC_TOP_RST_STATUS_CLR_MASK, MT6351_PMIC_TOP_RST_STATUS_CLR_SHIFT},
	{PMIC_RG_INT_EN_PWRKEY, MT6351_PMIC_RG_INT_EN_PWRKEY_ADDR,
	 MT6351_PMIC_RG_INT_EN_PWRKEY_MASK, MT6351_PMIC_RG_INT_EN_PWRKEY_SHIFT},
	{PMIC_RG_INT_EN_HOMEKEY, MT6351_PMIC_RG_INT_EN_HOMEKEY_ADDR,
	 MT6351_PMIC_RG_INT_EN_HOMEKEY_MASK, MT6351_PMIC_RG_INT_EN_HOMEKEY_SHIFT},
	{PMIC_RG_INT_EN_PWRKEY_R, MT6351_PMIC_RG_INT_EN_PWRKEY_R_ADDR,
	 MT6351_PMIC_RG_INT_EN_PWRKEY_R_MASK, MT6351_PMIC_RG_INT_EN_PWRKEY_R_SHIFT},
	{PMIC_RG_INT_EN_HOMEKEY_R, MT6351_PMIC_RG_INT_EN_HOMEKEY_R_ADDR,
	 MT6351_PMIC_RG_INT_EN_HOMEKEY_R_MASK, MT6351_PMIC_RG_INT_EN_HOMEKEY_R_SHIFT},
	{PMIC_RG_INT_EN_THR_H, MT6351_PMIC_RG_INT_EN_THR_H_ADDR,
	 MT6351_PMIC_RG_INT_EN_THR_H_MASK, MT6351_PMIC_RG_INT_EN_THR_H_SHIFT},
	{PMIC_RG_INT_EN_THR_L, MT6351_PMIC_RG_INT_EN_THR_L_ADDR,
	 MT6351_PMIC_RG_INT_EN_THR_L_MASK, MT6351_PMIC_RG_INT_EN_THR_L_SHIFT},
	{PMIC_RG_INT_EN_BAT_H, MT6351_PMIC_RG_INT_EN_BAT_H_ADDR,
	 MT6351_PMIC_RG_INT_EN_BAT_H_MASK, MT6351_PMIC_RG_INT_EN_BAT_H_SHIFT},
	{PMIC_RG_INT_EN_BAT_L, MT6351_PMIC_RG_INT_EN_BAT_L_ADDR,
	 MT6351_PMIC_RG_INT_EN_BAT_L_MASK, MT6351_PMIC_RG_INT_EN_BAT_L_SHIFT},
	{PMIC_RG_INT_EN_RTC, MT6351_PMIC_RG_INT_EN_RTC_ADDR,
	 MT6351_PMIC_RG_INT_EN_RTC_MASK, MT6351_PMIC_RG_INT_EN_RTC_SHIFT},
	{PMIC_RG_INT_EN_AUDIO, MT6351_PMIC_RG_INT_EN_AUDIO_ADDR,
	 MT6351_PMIC_RG_INT_EN_AUDIO_MASK, MT6351_PMIC_RG_INT_EN_AUDIO_SHIFT},
	{PMIC_RG_INT_EN_MAD, MT6351_PMIC_RG_INT_EN_MAD_ADDR,
	 MT6351_PMIC_RG_INT_EN_MAD_MASK, MT6351_PMIC_RG_INT_EN_MAD_SHIFT},
	{PMIC_RG_INT_EN_ACCDET, MT6351_PMIC_RG_INT_EN_ACCDET_ADDR,
	 MT6351_PMIC_RG_INT_EN_ACCDET_MASK, MT6351_PMIC_RG_INT_EN_ACCDET_SHIFT},
	{PMIC_RG_INT_EN_ACCDET_EINT, MT6351_PMIC_RG_INT_EN_ACCDET_EINT_ADDR,
	 MT6351_PMIC_RG_INT_EN_ACCDET_EINT_MASK, MT6351_PMIC_RG_INT_EN_ACCDET_EINT_SHIFT},
	{PMIC_RG_INT_EN_ACCDET_NEGV, MT6351_PMIC_RG_INT_EN_ACCDET_NEGV_ADDR,
	 MT6351_PMIC_RG_INT_EN_ACCDET_NEGV_MASK, MT6351_PMIC_RG_INT_EN_ACCDET_NEGV_SHIFT},
	{PMIC_RG_INT_EN_NI_LBAT_INT, MT6351_PMIC_RG_INT_EN_NI_LBAT_INT_ADDR,
	 MT6351_PMIC_RG_INT_EN_NI_LBAT_INT_MASK, MT6351_PMIC_RG_INT_EN_NI_LBAT_INT_SHIFT},
	{PMIC_INT_CON0_SET, MT6351_PMIC_INT_CON0_SET_ADDR, MT6351_PMIC_INT_CON0_SET_MASK,
	 MT6351_PMIC_INT_CON0_SET_SHIFT},
	{PMIC_INT_CON0_CLR, MT6351_PMIC_INT_CON0_CLR_ADDR, MT6351_PMIC_INT_CON0_CLR_MASK,
	 MT6351_PMIC_INT_CON0_CLR_SHIFT},
	{PMIC_RG_INT_EN_VCORE_OC, MT6351_PMIC_RG_INT_EN_VCORE_OC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VCORE_OC_MASK, MT6351_PMIC_RG_INT_EN_VCORE_OC_SHIFT},
	{PMIC_RG_INT_EN_VGPU_OC, MT6351_PMIC_RG_INT_EN_VGPU_OC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VGPU_OC_MASK, MT6351_PMIC_RG_INT_EN_VGPU_OC_SHIFT},
	{PMIC_RG_INT_EN_VSRAM_MD_OC, MT6351_PMIC_RG_INT_EN_VSRAM_MD_OC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VSRAM_MD_OC_MASK, MT6351_PMIC_RG_INT_EN_VSRAM_MD_OC_SHIFT},
	{PMIC_RG_INT_EN_VMODEM_OC, MT6351_PMIC_RG_INT_EN_VMODEM_OC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VMODEM_OC_MASK, MT6351_PMIC_RG_INT_EN_VMODEM_OC_SHIFT},
	{PMIC_RG_INT_EN_VM1_OC, MT6351_PMIC_RG_INT_EN_VM1_OC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VM1_OC_MASK, MT6351_PMIC_RG_INT_EN_VM1_OC_SHIFT},
	{PMIC_RG_INT_EN_VS1_OC, MT6351_PMIC_RG_INT_EN_VS1_OC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VS1_OC_MASK, MT6351_PMIC_RG_INT_EN_VS1_OC_SHIFT},
	{PMIC_RG_INT_EN_VS2_OC, MT6351_PMIC_RG_INT_EN_VS2_OC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VS2_OC_MASK, MT6351_PMIC_RG_INT_EN_VS2_OC_SHIFT},
	{PMIC_RG_INT_EN_VPA_OC, MT6351_PMIC_RG_INT_EN_VPA_OC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VPA_OC_MASK, MT6351_PMIC_RG_INT_EN_VPA_OC_SHIFT},
	{PMIC_RG_INT_EN_VCORE_PREOC, MT6351_PMIC_RG_INT_EN_VCORE_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VCORE_PREOC_MASK, MT6351_PMIC_RG_INT_EN_VCORE_PREOC_SHIFT},
	{PMIC_RG_INT_EN_VGPU_PREOC, MT6351_PMIC_RG_INT_EN_VGPU_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VGPU_PREOC_MASK, MT6351_PMIC_RG_INT_EN_VGPU_PREOC_SHIFT},
	{PMIC_RG_INT_EN_VSRAM_MD_PREOC, MT6351_PMIC_RG_INT_EN_VSRAM_MD_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VSRAM_MD_PREOC_MASK, MT6351_PMIC_RG_INT_EN_VSRAM_MD_PREOC_SHIFT},
	{PMIC_RG_INT_EN_VMODEM_PREOC, MT6351_PMIC_RG_INT_EN_VMODEM_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VMODEM_PREOC_MASK, MT6351_PMIC_RG_INT_EN_VMODEM_PREOC_SHIFT},
	{PMIC_RG_INT_EN_VM1_PREOC, MT6351_PMIC_RG_INT_EN_VM1_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VM1_PREOC_MASK, MT6351_PMIC_RG_INT_EN_VM1_PREOC_SHIFT},
	{PMIC_RG_INT_EN_VS1_PREOC, MT6351_PMIC_RG_INT_EN_VS1_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VS1_PREOC_MASK, MT6351_PMIC_RG_INT_EN_VS1_PREOC_SHIFT},
	{PMIC_RG_INT_EN_VS2_PREOC, MT6351_PMIC_RG_INT_EN_VS2_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_EN_VS2_PREOC_MASK, MT6351_PMIC_RG_INT_EN_VS2_PREOC_SHIFT},
	{PMIC_RG_INT_EN_LDO_OC, MT6351_PMIC_RG_INT_EN_LDO_OC_ADDR,
	 MT6351_PMIC_RG_INT_EN_LDO_OC_MASK, MT6351_PMIC_RG_INT_EN_LDO_OC_SHIFT},
	{PMIC_INT_CON1_SET, MT6351_PMIC_INT_CON1_SET_ADDR, MT6351_PMIC_INT_CON1_SET_MASK,
	 MT6351_PMIC_INT_CON1_SET_SHIFT},
	{PMIC_INT_CON1_CLR, MT6351_PMIC_INT_CON1_CLR_ADDR, MT6351_PMIC_INT_CON1_CLR_MASK,
	 MT6351_PMIC_INT_CON1_CLR_SHIFT},
	{PMIC_RG_INT_EN_JEITA_HOT, MT6351_PMIC_RG_INT_EN_JEITA_HOT_ADDR,
	 MT6351_PMIC_RG_INT_EN_JEITA_HOT_MASK, MT6351_PMIC_RG_INT_EN_JEITA_HOT_SHIFT},
	{PMIC_RG_INT_EN_JEITA_WARM, MT6351_PMIC_RG_INT_EN_JEITA_WARM_ADDR,
	 MT6351_PMIC_RG_INT_EN_JEITA_WARM_MASK, MT6351_PMIC_RG_INT_EN_JEITA_WARM_SHIFT},
	{PMIC_RG_INT_EN_JEITA_COOL, MT6351_PMIC_RG_INT_EN_JEITA_COOL_ADDR,
	 MT6351_PMIC_RG_INT_EN_JEITA_COOL_MASK, MT6351_PMIC_RG_INT_EN_JEITA_COOL_SHIFT},
	{PMIC_RG_INT_EN_JEITA_COLD, MT6351_PMIC_RG_INT_EN_JEITA_COLD_ADDR,
	 MT6351_PMIC_RG_INT_EN_JEITA_COLD_MASK, MT6351_PMIC_RG_INT_EN_JEITA_COLD_SHIFT},
	{PMIC_RG_INT_EN_AUXADC_IMP, MT6351_PMIC_RG_INT_EN_AUXADC_IMP_ADDR,
	 MT6351_PMIC_RG_INT_EN_AUXADC_IMP_MASK, MT6351_PMIC_RG_INT_EN_AUXADC_IMP_SHIFT},
	{PMIC_RG_INT_EN_NAG_C_DLTV, MT6351_PMIC_RG_INT_EN_NAG_C_DLTV_ADDR,
	 MT6351_PMIC_RG_INT_EN_NAG_C_DLTV_MASK, MT6351_PMIC_RG_INT_EN_NAG_C_DLTV_SHIFT},
	{PMIC_RG_INT_EN_OV, MT6351_PMIC_RG_INT_EN_OV_ADDR, MT6351_PMIC_RG_INT_EN_OV_MASK,
	 MT6351_PMIC_RG_INT_EN_OV_SHIFT},
	{PMIC_RG_INT_EN_BVALID_DET, MT6351_PMIC_RG_INT_EN_BVALID_DET_ADDR,
	 MT6351_PMIC_RG_INT_EN_BVALID_DET_MASK, MT6351_PMIC_RG_INT_EN_BVALID_DET_SHIFT},
	{PMIC_RG_INT_EN_RGS_BATON_HV, MT6351_PMIC_RG_INT_EN_RGS_BATON_HV_ADDR,
	 MT6351_PMIC_RG_INT_EN_RGS_BATON_HV_MASK, MT6351_PMIC_RG_INT_EN_RGS_BATON_HV_SHIFT},
	{PMIC_RG_INT_EN_VBATON_UNDET, MT6351_PMIC_RG_INT_EN_VBATON_UNDET_ADDR,
	 MT6351_PMIC_RG_INT_EN_VBATON_UNDET_MASK, MT6351_PMIC_RG_INT_EN_VBATON_UNDET_SHIFT},
	{PMIC_RG_INT_EN_WATCHDOG, MT6351_PMIC_RG_INT_EN_WATCHDOG_ADDR,
	 MT6351_PMIC_RG_INT_EN_WATCHDOG_MASK, MT6351_PMIC_RG_INT_EN_WATCHDOG_SHIFT},
	{PMIC_RG_INT_EN_PCHR_CM_VDEC, MT6351_PMIC_RG_INT_EN_PCHR_CM_VDEC_ADDR,
	 MT6351_PMIC_RG_INT_EN_PCHR_CM_VDEC_MASK, MT6351_PMIC_RG_INT_EN_PCHR_CM_VDEC_SHIFT},
	{PMIC_RG_INT_EN_CHRDET, MT6351_PMIC_RG_INT_EN_CHRDET_ADDR,
	 MT6351_PMIC_RG_INT_EN_CHRDET_MASK, MT6351_PMIC_RG_INT_EN_CHRDET_SHIFT},
	{PMIC_RG_INT_EN_PCHR_CM_VINC, MT6351_PMIC_RG_INT_EN_PCHR_CM_VINC_ADDR,
	 MT6351_PMIC_RG_INT_EN_PCHR_CM_VINC_MASK, MT6351_PMIC_RG_INT_EN_PCHR_CM_VINC_SHIFT},
	{PMIC_INT_CON2_SET, MT6351_PMIC_INT_CON2_SET_ADDR, MT6351_PMIC_INT_CON2_SET_MASK,
	 MT6351_PMIC_INT_CON2_SET_SHIFT},
	{PMIC_INT_CON2_CLR, MT6351_PMIC_INT_CON2_CLR_ADDR, MT6351_PMIC_INT_CON2_CLR_MASK,
	 MT6351_PMIC_INT_CON2_CLR_SHIFT},
	{PMIC_RG_INT_EN_FG_BAT_H, MT6351_PMIC_RG_INT_EN_FG_BAT_H_ADDR,
	 MT6351_PMIC_RG_INT_EN_FG_BAT_H_MASK, MT6351_PMIC_RG_INT_EN_FG_BAT_H_SHIFT},
	{PMIC_RG_INT_EN_FG_BAT_L, MT6351_PMIC_RG_INT_EN_FG_BAT_L_ADDR,
	 MT6351_PMIC_RG_INT_EN_FG_BAT_L_MASK, MT6351_PMIC_RG_INT_EN_FG_BAT_L_SHIFT},
	{PMIC_RG_INT_EN_FG_CUR_H, MT6351_PMIC_RG_INT_EN_FG_CUR_H_ADDR,
	 MT6351_PMIC_RG_INT_EN_FG_CUR_H_MASK, MT6351_PMIC_RG_INT_EN_FG_CUR_H_SHIFT},
	{PMIC_RG_INT_EN_FG_CUR_L, MT6351_PMIC_RG_INT_EN_FG_CUR_L_ADDR,
	 MT6351_PMIC_RG_INT_EN_FG_CUR_L_MASK, MT6351_PMIC_RG_INT_EN_FG_CUR_L_SHIFT},
	{PMIC_RG_INT_EN_FG_ZCV, MT6351_PMIC_RG_INT_EN_FG_ZCV_ADDR,
	 MT6351_PMIC_RG_INT_EN_FG_ZCV_MASK, MT6351_PMIC_RG_INT_EN_FG_ZCV_SHIFT},
	{PMIC_INT_CON3_SET, MT6351_PMIC_INT_CON3_SET_ADDR, MT6351_PMIC_INT_CON3_SET_MASK,
	 MT6351_PMIC_INT_CON3_SET_SHIFT},
	{PMIC_INT_CON3_CLR, MT6351_PMIC_INT_CON3_CLR_ADDR, MT6351_PMIC_INT_CON3_CLR_MASK,
	 MT6351_PMIC_INT_CON3_CLR_SHIFT},
	{PMIC_POLARITY, MT6351_PMIC_POLARITY_ADDR, MT6351_PMIC_POLARITY_MASK,
	 MT6351_PMIC_POLARITY_SHIFT},
	{PMIC_RG_HOMEKEY_INT_SEL, MT6351_PMIC_RG_HOMEKEY_INT_SEL_ADDR,
	 MT6351_PMIC_RG_HOMEKEY_INT_SEL_MASK, MT6351_PMIC_RG_HOMEKEY_INT_SEL_SHIFT},
	{PMIC_RG_PWRKEY_INT_SEL, MT6351_PMIC_RG_PWRKEY_INT_SEL_ADDR,
	 MT6351_PMIC_RG_PWRKEY_INT_SEL_MASK, MT6351_PMIC_RG_PWRKEY_INT_SEL_SHIFT},
	{PMIC_RG_CHRDET_INT_SEL, MT6351_PMIC_RG_CHRDET_INT_SEL_ADDR,
	 MT6351_PMIC_RG_CHRDET_INT_SEL_MASK, MT6351_PMIC_RG_CHRDET_INT_SEL_SHIFT},
	{PMIC_RG_PCHR_CM_VINC_POLARITY_RSV, MT6351_PMIC_RG_PCHR_CM_VINC_POLARITY_RSV_ADDR,
	 MT6351_PMIC_RG_PCHR_CM_VINC_POLARITY_RSV_MASK,
	 MT6351_PMIC_RG_PCHR_CM_VINC_POLARITY_RSV_SHIFT},
	{PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV, MT6351_PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV_ADDR,
	 MT6351_PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV_MASK,
	 MT6351_PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV_SHIFT},
	{PMIC_INT_MISC_CON_SET, MT6351_PMIC_INT_MISC_CON_SET_ADDR,
	 MT6351_PMIC_INT_MISC_CON_SET_MASK, MT6351_PMIC_INT_MISC_CON_SET_SHIFT},
	{PMIC_INT_MISC_CON_CLR, MT6351_PMIC_INT_MISC_CON_CLR_ADDR,
	 MT6351_PMIC_INT_MISC_CON_CLR_MASK, MT6351_PMIC_INT_MISC_CON_CLR_SHIFT},
	{PMIC_RG_INT_STATUS_PWRKEY, MT6351_PMIC_RG_INT_STATUS_PWRKEY_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_PWRKEY_MASK, MT6351_PMIC_RG_INT_STATUS_PWRKEY_SHIFT},
	{PMIC_RG_INT_STATUS_HOMEKEY, MT6351_PMIC_RG_INT_STATUS_HOMEKEY_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_HOMEKEY_MASK, MT6351_PMIC_RG_INT_STATUS_HOMEKEY_SHIFT},
	{PMIC_RG_INT_STATUS_PWRKEY_R, MT6351_PMIC_RG_INT_STATUS_PWRKEY_R_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_PWRKEY_R_MASK, MT6351_PMIC_RG_INT_STATUS_PWRKEY_R_SHIFT},
	{PMIC_RG_INT_STATUS_HOMEKEY_R, MT6351_PMIC_RG_INT_STATUS_HOMEKEY_R_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_HOMEKEY_R_MASK, MT6351_PMIC_RG_INT_STATUS_HOMEKEY_R_SHIFT},
	{PMIC_RG_INT_STATUS_THR_H, MT6351_PMIC_RG_INT_STATUS_THR_H_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_THR_H_MASK, MT6351_PMIC_RG_INT_STATUS_THR_H_SHIFT},
	{PMIC_RG_INT_STATUS_THR_L, MT6351_PMIC_RG_INT_STATUS_THR_L_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_THR_L_MASK, MT6351_PMIC_RG_INT_STATUS_THR_L_SHIFT},
	{PMIC_RG_INT_STATUS_BAT_H, MT6351_PMIC_RG_INT_STATUS_BAT_H_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_BAT_H_MASK, MT6351_PMIC_RG_INT_STATUS_BAT_H_SHIFT},
	{PMIC_RG_INT_STATUS_BAT_L, MT6351_PMIC_RG_INT_STATUS_BAT_L_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_BAT_L_MASK, MT6351_PMIC_RG_INT_STATUS_BAT_L_SHIFT},
	{PMIC_RG_INT_STATUS_RTC, MT6351_PMIC_RG_INT_STATUS_RTC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_RTC_MASK, MT6351_PMIC_RG_INT_STATUS_RTC_SHIFT},
	{PMIC_RG_INT_STATUS_AUDIO, MT6351_PMIC_RG_INT_STATUS_AUDIO_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_AUDIO_MASK, MT6351_PMIC_RG_INT_STATUS_AUDIO_SHIFT},
	{PMIC_RG_INT_STATUS_MAD, MT6351_PMIC_RG_INT_STATUS_MAD_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_MAD_MASK, MT6351_PMIC_RG_INT_STATUS_MAD_SHIFT},
	{PMIC_RG_INT_STATUS_ACCDET, MT6351_PMIC_RG_INT_STATUS_ACCDET_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_ACCDET_MASK, MT6351_PMIC_RG_INT_STATUS_ACCDET_SHIFT},
	{PMIC_RG_INT_STATUS_ACCDET_EINT, MT6351_PMIC_RG_INT_STATUS_ACCDET_EINT_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_ACCDET_EINT_MASK, MT6351_PMIC_RG_INT_STATUS_ACCDET_EINT_SHIFT},
	{PMIC_RG_INT_STATUS_ACCDET_NEGV, MT6351_PMIC_RG_INT_STATUS_ACCDET_NEGV_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_ACCDET_NEGV_MASK, MT6351_PMIC_RG_INT_STATUS_ACCDET_NEGV_SHIFT},
	{PMIC_RG_INT_STATUS_NI_LBAT_INT, MT6351_PMIC_RG_INT_STATUS_NI_LBAT_INT_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_NI_LBAT_INT_MASK, MT6351_PMIC_RG_INT_STATUS_NI_LBAT_INT_SHIFT},
	{PMIC_RG_INT_STATUS_VCORE_OC, MT6351_PMIC_RG_INT_STATUS_VCORE_OC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VCORE_OC_MASK, MT6351_PMIC_RG_INT_STATUS_VCORE_OC_SHIFT},
	{PMIC_RG_INT_STATUS_VGPU_OC, MT6351_PMIC_RG_INT_STATUS_VGPU_OC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VGPU_OC_MASK, MT6351_PMIC_RG_INT_STATUS_VGPU_OC_SHIFT},
	{PMIC_RG_INT_STATUS_VSRAM_MD_OC, MT6351_PMIC_RG_INT_STATUS_VSRAM_MD_OC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VSRAM_MD_OC_MASK, MT6351_PMIC_RG_INT_STATUS_VSRAM_MD_OC_SHIFT},
	{PMIC_RG_INT_STATUS_VMODEM_OC, MT6351_PMIC_RG_INT_STATUS_VMODEM_OC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VMODEM_OC_MASK, MT6351_PMIC_RG_INT_STATUS_VMODEM_OC_SHIFT},
	{PMIC_RG_INT_STATUS_VM1_OC, MT6351_PMIC_RG_INT_STATUS_VM1_OC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VM1_OC_MASK, MT6351_PMIC_RG_INT_STATUS_VM1_OC_SHIFT},
	{PMIC_RG_INT_STATUS_VS1_OC, MT6351_PMIC_RG_INT_STATUS_VS1_OC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VS1_OC_MASK, MT6351_PMIC_RG_INT_STATUS_VS1_OC_SHIFT},
	{PMIC_RG_INT_STATUS_VS2_OC, MT6351_PMIC_RG_INT_STATUS_VS2_OC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VS2_OC_MASK, MT6351_PMIC_RG_INT_STATUS_VS2_OC_SHIFT},
	{PMIC_RG_INT_STATUS_VPA_OC, MT6351_PMIC_RG_INT_STATUS_VPA_OC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VPA_OC_MASK, MT6351_PMIC_RG_INT_STATUS_VPA_OC_SHIFT},
	{PMIC_RG_INT_STATUS_VCORE_PREOC, MT6351_PMIC_RG_INT_STATUS_VCORE_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VCORE_PREOC_MASK, MT6351_PMIC_RG_INT_STATUS_VCORE_PREOC_SHIFT},
	{PMIC_RG_INT_STATUS_VGPU_PREOC, MT6351_PMIC_RG_INT_STATUS_VGPU_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VGPU_PREOC_MASK, MT6351_PMIC_RG_INT_STATUS_VGPU_PREOC_SHIFT},
	{PMIC_RG_INT_STATUS_VSRAM_MD_PREOC, MT6351_PMIC_RG_INT_STATUS_VSRAM_MD_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VSRAM_MD_PREOC_MASK,
	 MT6351_PMIC_RG_INT_STATUS_VSRAM_MD_PREOC_SHIFT},
	{PMIC_RG_INT_STATUS_VMODEM_PREOC, MT6351_PMIC_RG_INT_STATUS_VMODEM_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VMODEM_PREOC_MASK,
	 MT6351_PMIC_RG_INT_STATUS_VMODEM_PREOC_SHIFT},
	{PMIC_RG_INT_STATUS_VM1_PREOC, MT6351_PMIC_RG_INT_STATUS_VM1_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VM1_PREOC_MASK, MT6351_PMIC_RG_INT_STATUS_VM1_PREOC_SHIFT},
	{PMIC_RG_INT_STATUS_VS1_PREOC, MT6351_PMIC_RG_INT_STATUS_VS1_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VS1_PREOC_MASK, MT6351_PMIC_RG_INT_STATUS_VS1_PREOC_SHIFT},
	{PMIC_RG_INT_STATUS_VS2_PREOC, MT6351_PMIC_RG_INT_STATUS_VS2_PREOC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VS2_PREOC_MASK, MT6351_PMIC_RG_INT_STATUS_VS2_PREOC_SHIFT},
	{PMIC_RG_INT_STATUS_LDO_OC, MT6351_PMIC_RG_INT_STATUS_LDO_OC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_LDO_OC_MASK, MT6351_PMIC_RG_INT_STATUS_LDO_OC_SHIFT},
	{PMIC_RG_INT_STATUS_JEITA_HOT, MT6351_PMIC_RG_INT_STATUS_JEITA_HOT_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_JEITA_HOT_MASK, MT6351_PMIC_RG_INT_STATUS_JEITA_HOT_SHIFT},
	{PMIC_RG_INT_STATUS_JEITA_WARM, MT6351_PMIC_RG_INT_STATUS_JEITA_WARM_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_JEITA_WARM_MASK, MT6351_PMIC_RG_INT_STATUS_JEITA_WARM_SHIFT},
	{PMIC_RG_INT_STATUS_JEITA_COOL, MT6351_PMIC_RG_INT_STATUS_JEITA_COOL_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_JEITA_COOL_MASK, MT6351_PMIC_RG_INT_STATUS_JEITA_COOL_SHIFT},
	{PMIC_RG_INT_STATUS_JEITA_COLD, MT6351_PMIC_RG_INT_STATUS_JEITA_COLD_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_JEITA_COLD_MASK, MT6351_PMIC_RG_INT_STATUS_JEITA_COLD_SHIFT},
	{PMIC_RG_INT_STATUS_AUXADC_IMP, MT6351_PMIC_RG_INT_STATUS_AUXADC_IMP_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_AUXADC_IMP_MASK, MT6351_PMIC_RG_INT_STATUS_AUXADC_IMP_SHIFT},
	{PMIC_RG_INT_STATUS_NAG_C_DLTV, MT6351_PMIC_RG_INT_STATUS_NAG_C_DLTV_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_NAG_C_DLTV_MASK, MT6351_PMIC_RG_INT_STATUS_NAG_C_DLTV_SHIFT},
	{PMIC_RG_INT_STATUS_OV, MT6351_PMIC_RG_INT_STATUS_OV_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_OV_MASK, MT6351_PMIC_RG_INT_STATUS_OV_SHIFT},
	{PMIC_RG_INT_STATUS_BVALID_DET, MT6351_PMIC_RG_INT_STATUS_BVALID_DET_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_BVALID_DET_MASK, MT6351_PMIC_RG_INT_STATUS_BVALID_DET_SHIFT},
	{PMIC_RG_INT_STATUS_RGS_BATON_HV, MT6351_PMIC_RG_INT_STATUS_RGS_BATON_HV_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_RGS_BATON_HV_MASK,
	 MT6351_PMIC_RG_INT_STATUS_RGS_BATON_HV_SHIFT},
	{PMIC_RG_INT_STATUS_VBATON_UNDET, MT6351_PMIC_RG_INT_STATUS_VBATON_UNDET_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_VBATON_UNDET_MASK,
	 MT6351_PMIC_RG_INT_STATUS_VBATON_UNDET_SHIFT},
	{PMIC_RG_INT_STATUS_WATCHDOG, MT6351_PMIC_RG_INT_STATUS_WATCHDOG_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_WATCHDOG_MASK, MT6351_PMIC_RG_INT_STATUS_WATCHDOG_SHIFT},
	{PMIC_RG_INT_STATUS_PCHR_CM_VDEC, MT6351_PMIC_RG_INT_STATUS_PCHR_CM_VDEC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_PCHR_CM_VDEC_MASK,
	 MT6351_PMIC_RG_INT_STATUS_PCHR_CM_VDEC_SHIFT},
	{PMIC_RG_INT_STATUS_CHRDET, MT6351_PMIC_RG_INT_STATUS_CHRDET_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_CHRDET_MASK, MT6351_PMIC_RG_INT_STATUS_CHRDET_SHIFT},
	{PMIC_RG_INT_STATUS_PCHR_CM_VINC, MT6351_PMIC_RG_INT_STATUS_PCHR_CM_VINC_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_PCHR_CM_VINC_MASK,
	 MT6351_PMIC_RG_INT_STATUS_PCHR_CM_VINC_SHIFT},
	{PMIC_RG_INT_STATUS_FG_BAT_H, MT6351_PMIC_RG_INT_STATUS_FG_BAT_H_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_FG_BAT_H_MASK, MT6351_PMIC_RG_INT_STATUS_FG_BAT_H_SHIFT},
	{PMIC_RG_INT_STATUS_FG_BAT_L, MT6351_PMIC_RG_INT_STATUS_FG_BAT_L_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_FG_BAT_L_MASK, MT6351_PMIC_RG_INT_STATUS_FG_BAT_L_SHIFT},
	{PMIC_RG_INT_STATUS_FG_CUR_H, MT6351_PMIC_RG_INT_STATUS_FG_CUR_H_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_FG_CUR_H_MASK, MT6351_PMIC_RG_INT_STATUS_FG_CUR_H_SHIFT},
	{PMIC_RG_INT_STATUS_FG_CUR_L, MT6351_PMIC_RG_INT_STATUS_FG_CUR_L_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_FG_CUR_L_MASK, MT6351_PMIC_RG_INT_STATUS_FG_CUR_L_SHIFT},
	{PMIC_RG_INT_STATUS_FG_ZCV, MT6351_PMIC_RG_INT_STATUS_FG_ZCV_ADDR,
	 MT6351_PMIC_RG_INT_STATUS_FG_ZCV_MASK, MT6351_PMIC_RG_INT_STATUS_FG_ZCV_SHIFT},
	{PMIC_OC_GEAR_LDO, MT6351_PMIC_OC_GEAR_LDO_ADDR, MT6351_PMIC_OC_GEAR_LDO_MASK,
	 MT6351_PMIC_OC_GEAR_LDO_SHIFT},
	{PMIC_FQMTR_TCKSEL, MT6351_PMIC_FQMTR_TCKSEL_ADDR, MT6351_PMIC_FQMTR_TCKSEL_MASK,
	 MT6351_PMIC_FQMTR_TCKSEL_SHIFT},
	{PMIC_FQMTR_BUSY, MT6351_PMIC_FQMTR_BUSY_ADDR, MT6351_PMIC_FQMTR_BUSY_MASK,
	 MT6351_PMIC_FQMTR_BUSY_SHIFT},
	{PMIC_FQMTR_EN, MT6351_PMIC_FQMTR_EN_ADDR, MT6351_PMIC_FQMTR_EN_MASK,
	 MT6351_PMIC_FQMTR_EN_SHIFT},
	{PMIC_FQMTR_WINSET, MT6351_PMIC_FQMTR_WINSET_ADDR, MT6351_PMIC_FQMTR_WINSET_MASK,
	 MT6351_PMIC_FQMTR_WINSET_SHIFT},
	{PMIC_FQMTR_DATA, MT6351_PMIC_FQMTR_DATA_ADDR, MT6351_PMIC_FQMTR_DATA_MASK,
	 MT6351_PMIC_FQMTR_DATA_SHIFT},
	{PMIC_RG_SLP_RW_EN, MT6351_PMIC_RG_SLP_RW_EN_ADDR, MT6351_PMIC_RG_SLP_RW_EN_MASK,
	 MT6351_PMIC_RG_SLP_RW_EN_SHIFT},
	{PMIC_RG_SPI_RSV, MT6351_PMIC_RG_SPI_RSV_ADDR, MT6351_PMIC_RG_SPI_RSV_MASK,
	 MT6351_PMIC_RG_SPI_RSV_SHIFT},
	{PMIC_DEW_DIO_EN, MT6351_PMIC_DEW_DIO_EN_ADDR, MT6351_PMIC_DEW_DIO_EN_MASK,
	 MT6351_PMIC_DEW_DIO_EN_SHIFT},
	{PMIC_DEW_READ_TEST, MT6351_PMIC_DEW_READ_TEST_ADDR,
	 MT6351_PMIC_DEW_READ_TEST_MASK, MT6351_PMIC_DEW_READ_TEST_SHIFT},
	{PMIC_DEW_WRITE_TEST, MT6351_PMIC_DEW_WRITE_TEST_ADDR,
	 MT6351_PMIC_DEW_WRITE_TEST_MASK, MT6351_PMIC_DEW_WRITE_TEST_SHIFT},
	{PMIC_DEW_CRC_SWRST, MT6351_PMIC_DEW_CRC_SWRST_ADDR,
	 MT6351_PMIC_DEW_CRC_SWRST_MASK, MT6351_PMIC_DEW_CRC_SWRST_SHIFT},
	{PMIC_DEW_CRC_EN, MT6351_PMIC_DEW_CRC_EN_ADDR, MT6351_PMIC_DEW_CRC_EN_MASK,
	 MT6351_PMIC_DEW_CRC_EN_SHIFT},
	{PMIC_DEW_CRC_VAL, MT6351_PMIC_DEW_CRC_VAL_ADDR, MT6351_PMIC_DEW_CRC_VAL_MASK,
	 MT6351_PMIC_DEW_CRC_VAL_SHIFT},
	{PMIC_DEW_DBG_MON_SEL, MT6351_PMIC_DEW_DBG_MON_SEL_ADDR,
	 MT6351_PMIC_DEW_DBG_MON_SEL_MASK, MT6351_PMIC_DEW_DBG_MON_SEL_SHIFT},
	{PMIC_DEW_CIPHER_KEY_SEL, MT6351_PMIC_DEW_CIPHER_KEY_SEL_ADDR,
	 MT6351_PMIC_DEW_CIPHER_KEY_SEL_MASK, MT6351_PMIC_DEW_CIPHER_KEY_SEL_SHIFT},
	{PMIC_DEW_CIPHER_IV_SEL, MT6351_PMIC_DEW_CIPHER_IV_SEL_ADDR,
	 MT6351_PMIC_DEW_CIPHER_IV_SEL_MASK, MT6351_PMIC_DEW_CIPHER_IV_SEL_SHIFT},
	{PMIC_DEW_CIPHER_EN, MT6351_PMIC_DEW_CIPHER_EN_ADDR,
	 MT6351_PMIC_DEW_CIPHER_EN_MASK, MT6351_PMIC_DEW_CIPHER_EN_SHIFT},
	{PMIC_DEW_CIPHER_RDY, MT6351_PMIC_DEW_CIPHER_RDY_ADDR,
	 MT6351_PMIC_DEW_CIPHER_RDY_MASK, MT6351_PMIC_DEW_CIPHER_RDY_SHIFT},
	{PMIC_DEW_CIPHER_MODE, MT6351_PMIC_DEW_CIPHER_MODE_ADDR,
	 MT6351_PMIC_DEW_CIPHER_MODE_MASK, MT6351_PMIC_DEW_CIPHER_MODE_SHIFT},
	{PMIC_DEW_CIPHER_SWRST, MT6351_PMIC_DEW_CIPHER_SWRST_ADDR,
	 MT6351_PMIC_DEW_CIPHER_SWRST_MASK, MT6351_PMIC_DEW_CIPHER_SWRST_SHIFT},
	{PMIC_DEW_RDDMY_NO, MT6351_PMIC_DEW_RDDMY_NO_ADDR, MT6351_PMIC_DEW_RDDMY_NO_MASK,
	 MT6351_PMIC_DEW_RDDMY_NO_SHIFT},
	{PMIC_INT_TYPE_CON0, MT6351_PMIC_INT_TYPE_CON0_ADDR,
	 MT6351_PMIC_INT_TYPE_CON0_MASK, MT6351_PMIC_INT_TYPE_CON0_SHIFT},
	{PMIC_INT_TYPE_CON0_SET, MT6351_PMIC_INT_TYPE_CON0_SET_ADDR,
	 MT6351_PMIC_INT_TYPE_CON0_SET_MASK, MT6351_PMIC_INT_TYPE_CON0_SET_SHIFT},
	{PMIC_INT_TYPE_CON0_CLR, MT6351_PMIC_INT_TYPE_CON0_CLR_ADDR,
	 MT6351_PMIC_INT_TYPE_CON0_CLR_MASK, MT6351_PMIC_INT_TYPE_CON0_CLR_SHIFT},
	{PMIC_INT_TYPE_CON1, MT6351_PMIC_INT_TYPE_CON1_ADDR,
	 MT6351_PMIC_INT_TYPE_CON1_MASK, MT6351_PMIC_INT_TYPE_CON1_SHIFT},
	{PMIC_INT_TYPE_CON1_SET, MT6351_PMIC_INT_TYPE_CON1_SET_ADDR,
	 MT6351_PMIC_INT_TYPE_CON1_SET_MASK, MT6351_PMIC_INT_TYPE_CON1_SET_SHIFT},
	{PMIC_INT_TYPE_CON1_CLR, MT6351_PMIC_INT_TYPE_CON1_CLR_ADDR,
	 MT6351_PMIC_INT_TYPE_CON1_CLR_MASK, MT6351_PMIC_INT_TYPE_CON1_CLR_SHIFT},
	{PMIC_INT_TYPE_CON2, MT6351_PMIC_INT_TYPE_CON2_ADDR,
	 MT6351_PMIC_INT_TYPE_CON2_MASK, MT6351_PMIC_INT_TYPE_CON2_SHIFT},
	{PMIC_INT_TYPE_CON2_SET, MT6351_PMIC_INT_TYPE_CON2_SET_ADDR,
	 MT6351_PMIC_INT_TYPE_CON2_SET_MASK, MT6351_PMIC_INT_TYPE_CON2_SET_SHIFT},
	{PMIC_INT_TYPE_CON2_CLR, MT6351_PMIC_INT_TYPE_CON2_CLR_ADDR,
	 MT6351_PMIC_INT_TYPE_CON2_CLR_MASK, MT6351_PMIC_INT_TYPE_CON2_CLR_SHIFT},
	{PMIC_INT_TYPE_CON3, MT6351_PMIC_INT_TYPE_CON3_ADDR,
	 MT6351_PMIC_INT_TYPE_CON3_MASK, MT6351_PMIC_INT_TYPE_CON3_SHIFT},
	{PMIC_INT_TYPE_CON3_SET, MT6351_PMIC_INT_TYPE_CON3_SET_ADDR,
	 MT6351_PMIC_INT_TYPE_CON3_SET_MASK, MT6351_PMIC_INT_TYPE_CON3_SET_SHIFT},
	{PMIC_INT_TYPE_CON3_CLR, MT6351_PMIC_INT_TYPE_CON3_CLR_ADDR,
	 MT6351_PMIC_INT_TYPE_CON3_CLR_MASK, MT6351_PMIC_INT_TYPE_CON3_CLR_SHIFT},
	{PMIC_CPU_INT_STA, MT6351_PMIC_CPU_INT_STA_ADDR, MT6351_PMIC_CPU_INT_STA_MASK,
	 MT6351_PMIC_CPU_INT_STA_SHIFT},
	{PMIC_MD32_INT_STA, MT6351_PMIC_MD32_INT_STA_ADDR, MT6351_PMIC_MD32_INT_STA_MASK,
	 MT6351_PMIC_MD32_INT_STA_SHIFT},
	{PMIC_BUCK_LDO_FT_TESTMODE_EN, MT6351_PMIC_BUCK_LDO_FT_TESTMODE_EN_ADDR,
	 MT6351_PMIC_BUCK_LDO_FT_TESTMODE_EN_MASK, MT6351_PMIC_BUCK_LDO_FT_TESTMODE_EN_SHIFT},
	{PMIC_BUCK_ALL_CON0_RSV1, MT6351_PMIC_BUCK_ALL_CON0_RSV1_ADDR,
	 MT6351_PMIC_BUCK_ALL_CON0_RSV1_MASK, MT6351_PMIC_BUCK_ALL_CON0_RSV1_SHIFT},
	{PMIC_BUCK_ALL_CON0_RSV0, MT6351_PMIC_BUCK_ALL_CON0_RSV0_ADDR,
	 MT6351_PMIC_BUCK_ALL_CON0_RSV0_MASK, MT6351_PMIC_BUCK_ALL_CON0_RSV0_SHIFT},
	{PMIC_BUCK_BUCK_RSV, MT6351_PMIC_BUCK_BUCK_RSV_ADDR,
	 MT6351_PMIC_BUCK_BUCK_RSV_MASK, MT6351_PMIC_BUCK_BUCK_RSV_SHIFT},
	{PMIC_BUCK_BUCK_OSC_SEL_SRCLKEN_SEL,
	 MT6351_PMIC_BUCK_BUCK_OSC_SEL_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_BUCK_BUCK_OSC_SEL_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_BUCK_BUCK_OSC_SEL_SRCLKEN_SEL_SHIFT},
	{PMIC_BUCK_BUCK_R2R_PDN_SRCLKEN_SEL,
	 MT6351_PMIC_BUCK_BUCK_R2R_PDN_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_BUCK_BUCK_R2R_PDN_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_BUCK_BUCK_R2R_PDN_SRCLKEN_SEL_SHIFT},
	{PMIC_BUCK_BUCK_VSLEEP_SRCLKEN_SEL, MT6351_PMIC_BUCK_BUCK_VSLEEP_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_BUCK_BUCK_VSLEEP_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_BUCK_BUCK_VSLEEP_SRCLKEN_SEL_SHIFT},
	{PMIC_BUCK_ALL_CON2_RSV0, MT6351_PMIC_BUCK_ALL_CON2_RSV0_ADDR,
	 MT6351_PMIC_BUCK_ALL_CON2_RSV0_MASK, MT6351_PMIC_BUCK_ALL_CON2_RSV0_SHIFT},
	{PMIC_BUCK_VSLEEP_SRC0, MT6351_PMIC_BUCK_VSLEEP_SRC0_ADDR,
	 MT6351_PMIC_BUCK_VSLEEP_SRC0_MASK, MT6351_PMIC_BUCK_VSLEEP_SRC0_SHIFT},
	{PMIC_BUCK_VSLEEP_SRC1, MT6351_PMIC_BUCK_VSLEEP_SRC1_ADDR,
	 MT6351_PMIC_BUCK_VSLEEP_SRC1_MASK, MT6351_PMIC_BUCK_VSLEEP_SRC1_SHIFT},
	{PMIC_BUCK_R2R_SRC0, MT6351_PMIC_BUCK_R2R_SRC0_ADDR,
	 MT6351_PMIC_BUCK_R2R_SRC0_MASK, MT6351_PMIC_BUCK_R2R_SRC0_SHIFT},
	{PMIC_BUCK_R2R_SRC1, MT6351_PMIC_BUCK_R2R_SRC1_ADDR,
	 MT6351_PMIC_BUCK_R2R_SRC1_MASK, MT6351_PMIC_BUCK_R2R_SRC1_SHIFT},
	{PMIC_BUCK_BUCK_OSC_SEL_SRC0, MT6351_PMIC_BUCK_BUCK_OSC_SEL_SRC0_ADDR,
	 MT6351_PMIC_BUCK_BUCK_OSC_SEL_SRC0_MASK, MT6351_PMIC_BUCK_BUCK_OSC_SEL_SRC0_SHIFT},
	{PMIC_BUCK_SRCLKEN_DLY_SRC1, MT6351_PMIC_BUCK_SRCLKEN_DLY_SRC1_ADDR,
	 MT6351_PMIC_BUCK_SRCLKEN_DLY_SRC1_MASK, MT6351_PMIC_BUCK_SRCLKEN_DLY_SRC1_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_BIN2GRAY_MAP_ENB,
	 MT6351_PMIC_BUCK_VSRAM_PROC_BIN2GRAY_MAP_ENB_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_BIN2GRAY_MAP_ENB_MASK,
	 MT6351_PMIC_BUCK_VSRAM_PROC_BIN2GRAY_MAP_ENB_SHIFT},
	{PMIC_BUCK_VS2_BIN2GRAY_MAP_ENB, MT6351_PMIC_BUCK_VS2_BIN2GRAY_MAP_ENB_ADDR,
	 MT6351_PMIC_BUCK_VS2_BIN2GRAY_MAP_ENB_MASK, MT6351_PMIC_BUCK_VS2_BIN2GRAY_MAP_ENB_SHIFT},
	{PMIC_BUCK_VS1_BIN2GRAY_MAP_ENB, MT6351_PMIC_BUCK_VS1_BIN2GRAY_MAP_ENB_ADDR,
	 MT6351_PMIC_BUCK_VS1_BIN2GRAY_MAP_ENB_MASK, MT6351_PMIC_BUCK_VS1_BIN2GRAY_MAP_ENB_SHIFT},
	{PMIC_BUCK_VSRAM_MD_BIN2GRAY_MAP_ENB,
	 MT6351_PMIC_BUCK_VSRAM_MD_BIN2GRAY_MAP_ENB_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_BIN2GRAY_MAP_ENB_MASK,
	 MT6351_PMIC_BUCK_VSRAM_MD_BIN2GRAY_MAP_ENB_SHIFT},
	{PMIC_BUCK_VMD1_BIN2GRAY_MAP_ENB, MT6351_PMIC_BUCK_VMD1_BIN2GRAY_MAP_ENB_ADDR,
	 MT6351_PMIC_BUCK_VMD1_BIN2GRAY_MAP_ENB_MASK,
	 MT6351_PMIC_BUCK_VMD1_BIN2GRAY_MAP_ENB_SHIFT},
	{PMIC_BUCK_VPA_BIN2GRAY_MAP_ENB, MT6351_PMIC_BUCK_VPA_BIN2GRAY_MAP_ENB_ADDR,
	 MT6351_PMIC_BUCK_VPA_BIN2GRAY_MAP_ENB_MASK, MT6351_PMIC_BUCK_VPA_BIN2GRAY_MAP_ENB_SHIFT},
	{PMIC_BUCK_VMODEM_BIN2GRAY_MAP_ENB, MT6351_PMIC_BUCK_VMODEM_BIN2GRAY_MAP_ENB_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_BIN2GRAY_MAP_ENB_MASK,
	 MT6351_PMIC_BUCK_VMODEM_BIN2GRAY_MAP_ENB_SHIFT},
	{PMIC_BUCK_VGPU_BIN2GRAY_MAP_ENB, MT6351_PMIC_BUCK_VGPU_BIN2GRAY_MAP_ENB_ADDR,
	 MT6351_PMIC_BUCK_VGPU_BIN2GRAY_MAP_ENB_MASK,
	 MT6351_PMIC_BUCK_VGPU_BIN2GRAY_MAP_ENB_SHIFT},
	{PMIC_BUCK_VCORE_BIN2GRAY_MAP_ENB, MT6351_PMIC_BUCK_VCORE_BIN2GRAY_MAP_ENB_ADDR,
	 MT6351_PMIC_BUCK_VCORE_BIN2GRAY_MAP_ENB_MASK,
	 MT6351_PMIC_BUCK_VCORE_BIN2GRAY_MAP_ENB_SHIFT},
	{PMIC_BUCK_VPA_VOSEL_DLC011, MT6351_PMIC_BUCK_VPA_VOSEL_DLC011_ADDR,
	 MT6351_PMIC_BUCK_VPA_VOSEL_DLC011_MASK, MT6351_PMIC_BUCK_VPA_VOSEL_DLC011_SHIFT},
	{PMIC_BUCK_VPA_VOSEL_DLC111, MT6351_PMIC_BUCK_VPA_VOSEL_DLC111_ADDR,
	 MT6351_PMIC_BUCK_VPA_VOSEL_DLC111_MASK, MT6351_PMIC_BUCK_VPA_VOSEL_DLC111_SHIFT},
	{PMIC_BUCK_VPA_DLC_MAP_EN, MT6351_PMIC_BUCK_VPA_DLC_MAP_EN_ADDR,
	 MT6351_PMIC_BUCK_VPA_DLC_MAP_EN_MASK, MT6351_PMIC_BUCK_VPA_DLC_MAP_EN_SHIFT},
	{PMIC_BUCK_VPA_VOSEL_DLC001, MT6351_PMIC_BUCK_VPA_VOSEL_DLC001_ADDR,
	 MT6351_PMIC_BUCK_VPA_VOSEL_DLC001_MASK, MT6351_PMIC_BUCK_VPA_VOSEL_DLC001_SHIFT},
	{PMIC_BUCK_VPA_DLC, MT6351_PMIC_BUCK_VPA_DLC_ADDR, MT6351_PMIC_BUCK_VPA_DLC_MASK,
	 MT6351_PMIC_BUCK_VPA_DLC_SHIFT},
	{PMIC_DA_NI_VPA_DLC, MT6351_PMIC_DA_NI_VPA_DLC_ADDR,
	 MT6351_PMIC_DA_NI_VPA_DLC_MASK, MT6351_PMIC_DA_NI_VPA_DLC_SHIFT},
	{PMIC_BUCK_VPA_DVS_TRANS_TD, MT6351_PMIC_BUCK_VPA_DVS_TRANS_TD_ADDR,
	 MT6351_PMIC_BUCK_VPA_DVS_TRANS_TD_MASK, MT6351_PMIC_BUCK_VPA_DVS_TRANS_TD_SHIFT},
	{PMIC_BUCK_VPA_DVS_TRANS_CTRL, MT6351_PMIC_BUCK_VPA_DVS_TRANS_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VPA_DVS_TRANS_CTRL_MASK, MT6351_PMIC_BUCK_VPA_DVS_TRANS_CTRL_SHIFT},
	{PMIC_BUCK_VPA_DVS_TRANS_ONCE, MT6351_PMIC_BUCK_VPA_DVS_TRANS_ONCE_ADDR,
	 MT6351_PMIC_BUCK_VPA_DVS_TRANS_ONCE_MASK, MT6351_PMIC_BUCK_VPA_DVS_TRANS_ONCE_SHIFT},
	{PMIC_DA_NI_VPA_DVS_TRANST, MT6351_PMIC_DA_NI_VPA_DVS_TRANST_ADDR,
	 MT6351_PMIC_DA_NI_VPA_DVS_TRANST_MASK, MT6351_PMIC_DA_NI_VPA_DVS_TRANST_SHIFT},
	{PMIC_BUCK_VPA_DIG0_RSV5, MT6351_PMIC_BUCK_VPA_DIG0_RSV5_ADDR,
	 MT6351_PMIC_BUCK_VPA_DIG0_RSV5_MASK, MT6351_PMIC_BUCK_VPA_DIG0_RSV5_SHIFT},
	{PMIC_BUCK_VPA_DIG1_RSV5, MT6351_PMIC_BUCK_VPA_DIG1_RSV5_ADDR,
	 MT6351_PMIC_BUCK_VPA_DIG1_RSV5_MASK, MT6351_PMIC_BUCK_VPA_DIG1_RSV5_SHIFT},
	{PMIC_BUCK_VCORE_VOSEL_AUD, MT6351_PMIC_BUCK_VCORE_VOSEL_AUD_ADDR,
	 MT6351_PMIC_BUCK_VCORE_VOSEL_AUD_MASK, MT6351_PMIC_BUCK_VCORE_VOSEL_AUD_SHIFT},
	{PMIC_BUCK_VCORE_DVFS_DONE, MT6351_PMIC_BUCK_VCORE_DVFS_DONE_ADDR,
	 MT6351_PMIC_BUCK_VCORE_DVFS_DONE_MASK, MT6351_PMIC_BUCK_VCORE_DVFS_DONE_SHIFT},
	{PMIC_BUCK_VCORE_DVFS_DONE_SW, MT6351_PMIC_BUCK_VCORE_DVFS_DONE_SW_ADDR,
	 MT6351_PMIC_BUCK_VCORE_DVFS_DONE_SW_MASK, MT6351_PMIC_BUCK_VCORE_DVFS_DONE_SW_SHIFT},
	{PMIC_BUCK_VCORE_DVFS_DONE_STA, MT6351_PMIC_BUCK_VCORE_DVFS_DONE_STA_ADDR,
	 MT6351_PMIC_BUCK_VCORE_DVFS_DONE_STA_MASK, MT6351_PMIC_BUCK_VCORE_DVFS_DONE_STA_SHIFT},
	{PMIC_BUCK_VSRAM_MD_VOSEL_AUD, MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_AUD_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_AUD_MASK, MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_AUD_SHIFT},
	{PMIC_BUCK_VSRAM_MD_DVFS_DONE, MT6351_PMIC_BUCK_VSRAM_MD_DVFS_DONE_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_DVFS_DONE_MASK, MT6351_PMIC_BUCK_VSRAM_MD_DVFS_DONE_SHIFT},
	{PMIC_BUCK_VSRAM_MD_DVFS_DONE_SW, MT6351_PMIC_BUCK_VSRAM_MD_DVFS_DONE_SW_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_DVFS_DONE_SW_MASK,
	 MT6351_PMIC_BUCK_VSRAM_MD_DVFS_DONE_SW_SHIFT},
	{PMIC_BUCK_VSRAM_MD_DVFS_DONE_STA, MT6351_PMIC_BUCK_VSRAM_MD_DVFS_DONE_STA_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_DVFS_DONE_STA_MASK,
	 MT6351_PMIC_BUCK_VSRAM_MD_DVFS_DONE_STA_SHIFT},
	{PMIC_BUCK_VCORE_OC_STATUS, MT6351_PMIC_BUCK_VCORE_OC_STATUS_ADDR,
	 MT6351_PMIC_BUCK_VCORE_OC_STATUS_MASK, MT6351_PMIC_BUCK_VCORE_OC_STATUS_SHIFT},
	{PMIC_BUCK_VGPU_OC_STATUS, MT6351_PMIC_BUCK_VGPU_OC_STATUS_ADDR,
	 MT6351_PMIC_BUCK_VGPU_OC_STATUS_MASK, MT6351_PMIC_BUCK_VGPU_OC_STATUS_SHIFT},
	{PMIC_BUCK_VMODEM_OC_STATUS, MT6351_PMIC_BUCK_VMODEM_OC_STATUS_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_OC_STATUS_MASK, MT6351_PMIC_BUCK_VMODEM_OC_STATUS_SHIFT},
	{PMIC_BUCK_VMD1_OC_STATUS, MT6351_PMIC_BUCK_VMD1_OC_STATUS_ADDR,
	 MT6351_PMIC_BUCK_VMD1_OC_STATUS_MASK, MT6351_PMIC_BUCK_VMD1_OC_STATUS_SHIFT},
	{PMIC_BUCK_VSRAM_MD_OC_STATUS, MT6351_PMIC_BUCK_VSRAM_MD_OC_STATUS_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_OC_STATUS_MASK, MT6351_PMIC_BUCK_VSRAM_MD_OC_STATUS_SHIFT},
	{PMIC_BUCK_VS1_OC_STATUS, MT6351_PMIC_BUCK_VS1_OC_STATUS_ADDR,
	 MT6351_PMIC_BUCK_VS1_OC_STATUS_MASK, MT6351_PMIC_BUCK_VS1_OC_STATUS_SHIFT},
	{PMIC_BUCK_VS2_OC_STATUS, MT6351_PMIC_BUCK_VS2_OC_STATUS_ADDR,
	 MT6351_PMIC_BUCK_VS2_OC_STATUS_MASK, MT6351_PMIC_BUCK_VS2_OC_STATUS_SHIFT},
	{PMIC_BUCK_VPA_OC_STATUS, MT6351_PMIC_BUCK_VPA_OC_STATUS_ADDR,
	 MT6351_PMIC_BUCK_VPA_OC_STATUS_MASK, MT6351_PMIC_BUCK_VPA_OC_STATUS_SHIFT},
	{PMIC_BUCK_VCORE_OC_INT_EN, MT6351_PMIC_BUCK_VCORE_OC_INT_EN_ADDR,
	 MT6351_PMIC_BUCK_VCORE_OC_INT_EN_MASK, MT6351_PMIC_BUCK_VCORE_OC_INT_EN_SHIFT},
	{PMIC_BUCK_VGPU_OC_INT_EN, MT6351_PMIC_BUCK_VGPU_OC_INT_EN_ADDR,
	 MT6351_PMIC_BUCK_VGPU_OC_INT_EN_MASK, MT6351_PMIC_BUCK_VGPU_OC_INT_EN_SHIFT},
	{PMIC_BUCK_VMODEM_OC_INT_EN, MT6351_PMIC_BUCK_VMODEM_OC_INT_EN_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_OC_INT_EN_MASK, MT6351_PMIC_BUCK_VMODEM_OC_INT_EN_SHIFT},
	{PMIC_BUCK_VMD1_OC_INT_EN, MT6351_PMIC_BUCK_VMD1_OC_INT_EN_ADDR,
	 MT6351_PMIC_BUCK_VMD1_OC_INT_EN_MASK, MT6351_PMIC_BUCK_VMD1_OC_INT_EN_SHIFT},
	{PMIC_BUCK_VSRAM_MD_OC_INT_EN, MT6351_PMIC_BUCK_VSRAM_MD_OC_INT_EN_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_OC_INT_EN_MASK, MT6351_PMIC_BUCK_VSRAM_MD_OC_INT_EN_SHIFT},
	{PMIC_BUCK_VS1_OC_INT_EN, MT6351_PMIC_BUCK_VS1_OC_INT_EN_ADDR,
	 MT6351_PMIC_BUCK_VS1_OC_INT_EN_MASK, MT6351_PMIC_BUCK_VS1_OC_INT_EN_SHIFT},
	{PMIC_BUCK_VS2_OC_INT_EN, MT6351_PMIC_BUCK_VS2_OC_INT_EN_ADDR,
	 MT6351_PMIC_BUCK_VS2_OC_INT_EN_MASK, MT6351_PMIC_BUCK_VS2_OC_INT_EN_SHIFT},
	{PMIC_BUCK_VPA_OC_INT_EN, MT6351_PMIC_BUCK_VPA_OC_INT_EN_ADDR,
	 MT6351_PMIC_BUCK_VPA_OC_INT_EN_MASK, MT6351_PMIC_BUCK_VPA_OC_INT_EN_SHIFT},
	{PMIC_BUCK_VCORE_EN_OC_SDN_SEL, MT6351_PMIC_BUCK_VCORE_EN_OC_SDN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VCORE_EN_OC_SDN_SEL_MASK, MT6351_PMIC_BUCK_VCORE_EN_OC_SDN_SEL_SHIFT},
	{PMIC_BUCK_VGPU_EN_OC_SDN_SEL, MT6351_PMIC_BUCK_VGPU_EN_OC_SDN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VGPU_EN_OC_SDN_SEL_MASK, MT6351_PMIC_BUCK_VGPU_EN_OC_SDN_SEL_SHIFT},
	{PMIC_BUCK_VMODEM_EN_OC_SDN_SEL, MT6351_PMIC_BUCK_VMODEM_EN_OC_SDN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_EN_OC_SDN_SEL_MASK, MT6351_PMIC_BUCK_VMODEM_EN_OC_SDN_SEL_SHIFT},
	{PMIC_BUCK_VMD1_EN_OC_SDN_SEL, MT6351_PMIC_BUCK_VMD1_EN_OC_SDN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VMD1_EN_OC_SDN_SEL_MASK, MT6351_PMIC_BUCK_VMD1_EN_OC_SDN_SEL_SHIFT},
	{PMIC_BUCK_VSRAM_MD_EN_OC_SDN_SEL, MT6351_PMIC_BUCK_VSRAM_MD_EN_OC_SDN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_EN_OC_SDN_SEL_MASK,
	 MT6351_PMIC_BUCK_VSRAM_MD_EN_OC_SDN_SEL_SHIFT},
	{PMIC_BUCK_VS1_EN_OC_SDN_SEL, MT6351_PMIC_BUCK_VS1_EN_OC_SDN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VS1_EN_OC_SDN_SEL_MASK, MT6351_PMIC_BUCK_VS1_EN_OC_SDN_SEL_SHIFT},
	{PMIC_BUCK_VS2_EN_OC_SDN_SEL, MT6351_PMIC_BUCK_VS2_EN_OC_SDN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VS2_EN_OC_SDN_SEL_MASK, MT6351_PMIC_BUCK_VS2_EN_OC_SDN_SEL_SHIFT},
	{PMIC_BUCK_VPA_EN_OC_SDN_SEL, MT6351_PMIC_BUCK_VPA_EN_OC_SDN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VPA_EN_OC_SDN_SEL_MASK, MT6351_PMIC_BUCK_VPA_EN_OC_SDN_SEL_SHIFT},
	{PMIC_BUCK_VCORE_OC_FLAG_CLR, MT6351_PMIC_BUCK_VCORE_OC_FLAG_CLR_ADDR,
	 MT6351_PMIC_BUCK_VCORE_OC_FLAG_CLR_MASK, MT6351_PMIC_BUCK_VCORE_OC_FLAG_CLR_SHIFT},
	{PMIC_BUCK_VGPU_OC_FLAG_CLR, MT6351_PMIC_BUCK_VGPU_OC_FLAG_CLR_ADDR,
	 MT6351_PMIC_BUCK_VGPU_OC_FLAG_CLR_MASK, MT6351_PMIC_BUCK_VGPU_OC_FLAG_CLR_SHIFT},
	{PMIC_BUCK_VMODEM_OC_FLAG_CLR, MT6351_PMIC_BUCK_VMODEM_OC_FLAG_CLR_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_OC_FLAG_CLR_MASK, MT6351_PMIC_BUCK_VMODEM_OC_FLAG_CLR_SHIFT},
	{PMIC_BUCK_VMD1_OC_FLAG_CLR, MT6351_PMIC_BUCK_VMD1_OC_FLAG_CLR_ADDR,
	 MT6351_PMIC_BUCK_VMD1_OC_FLAG_CLR_MASK, MT6351_PMIC_BUCK_VMD1_OC_FLAG_CLR_SHIFT},
	{PMIC_BUCK_VSRAM_MD_OC_FLAG_CLR, MT6351_PMIC_BUCK_VSRAM_MD_OC_FLAG_CLR_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_OC_FLAG_CLR_MASK, MT6351_PMIC_BUCK_VSRAM_MD_OC_FLAG_CLR_SHIFT},
	{PMIC_BUCK_VS1_OC_FLAG_CLR, MT6351_PMIC_BUCK_VS1_OC_FLAG_CLR_ADDR,
	 MT6351_PMIC_BUCK_VS1_OC_FLAG_CLR_MASK, MT6351_PMIC_BUCK_VS1_OC_FLAG_CLR_SHIFT},
	{PMIC_BUCK_VS2_OC_FLAG_CLR, MT6351_PMIC_BUCK_VS2_OC_FLAG_CLR_ADDR,
	 MT6351_PMIC_BUCK_VS2_OC_FLAG_CLR_MASK, MT6351_PMIC_BUCK_VS2_OC_FLAG_CLR_SHIFT},
	{PMIC_BUCK_VPA_OC_FLAG_CLR, MT6351_PMIC_BUCK_VPA_OC_FLAG_CLR_ADDR,
	 MT6351_PMIC_BUCK_VPA_OC_FLAG_CLR_MASK, MT6351_PMIC_BUCK_VPA_OC_FLAG_CLR_SHIFT},
	{PMIC_BUCK_VCORE_OC_FLAG_CLR_SEL, MT6351_PMIC_BUCK_VCORE_OC_FLAG_CLR_SEL_ADDR,
	 MT6351_PMIC_BUCK_VCORE_OC_FLAG_CLR_SEL_MASK,
	 MT6351_PMIC_BUCK_VCORE_OC_FLAG_CLR_SEL_SHIFT},
	{PMIC_BUCK_VGPU_OC_FLAG_CLR_SEL, MT6351_PMIC_BUCK_VGPU_OC_FLAG_CLR_SEL_ADDR,
	 MT6351_PMIC_BUCK_VGPU_OC_FLAG_CLR_SEL_MASK, MT6351_PMIC_BUCK_VGPU_OC_FLAG_CLR_SEL_SHIFT},
	{PMIC_BUCK_VMODEM_OC_FLAG_CLR_SEL, MT6351_PMIC_BUCK_VMODEM_OC_FLAG_CLR_SEL_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_OC_FLAG_CLR_SEL_MASK,
	 MT6351_PMIC_BUCK_VMODEM_OC_FLAG_CLR_SEL_SHIFT},
	{PMIC_BUCK_VMD1_OC_FLAG_CLR_SEL, MT6351_PMIC_BUCK_VMD1_OC_FLAG_CLR_SEL_ADDR,
	 MT6351_PMIC_BUCK_VMD1_OC_FLAG_CLR_SEL_MASK, MT6351_PMIC_BUCK_VMD1_OC_FLAG_CLR_SEL_SHIFT},
	{PMIC_BUCK_VSRAM_MD_OC_FLAG_CLR_SEL,
	 MT6351_PMIC_BUCK_VSRAM_MD_OC_FLAG_CLR_SEL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_OC_FLAG_CLR_SEL_MASK,
	 MT6351_PMIC_BUCK_VSRAM_MD_OC_FLAG_CLR_SEL_SHIFT},
	{PMIC_BUCK_VS1_OC_FLAG_CLR_SEL, MT6351_PMIC_BUCK_VS1_OC_FLAG_CLR_SEL_ADDR,
	 MT6351_PMIC_BUCK_VS1_OC_FLAG_CLR_SEL_MASK, MT6351_PMIC_BUCK_VS1_OC_FLAG_CLR_SEL_SHIFT},
	{PMIC_BUCK_VS2_OC_FLAG_CLR_SEL, MT6351_PMIC_BUCK_VS2_OC_FLAG_CLR_SEL_ADDR,
	 MT6351_PMIC_BUCK_VS2_OC_FLAG_CLR_SEL_MASK, MT6351_PMIC_BUCK_VS2_OC_FLAG_CLR_SEL_SHIFT},
	{PMIC_BUCK_VPA_OC_FLAG_CLR_SEL, MT6351_PMIC_BUCK_VPA_OC_FLAG_CLR_SEL_ADDR,
	 MT6351_PMIC_BUCK_VPA_OC_FLAG_CLR_SEL_MASK, MT6351_PMIC_BUCK_VPA_OC_FLAG_CLR_SEL_SHIFT},
	{PMIC_BUCK_VCORE_OC_DEG_EN, MT6351_PMIC_BUCK_VCORE_OC_DEG_EN_ADDR,
	 MT6351_PMIC_BUCK_VCORE_OC_DEG_EN_MASK, MT6351_PMIC_BUCK_VCORE_OC_DEG_EN_SHIFT},
	{PMIC_BUCK_VCORE_OC_WND, MT6351_PMIC_BUCK_VCORE_OC_WND_ADDR,
	 MT6351_PMIC_BUCK_VCORE_OC_WND_MASK, MT6351_PMIC_BUCK_VCORE_OC_WND_SHIFT},
	{PMIC_BUCK_VCORE_OC_THD, MT6351_PMIC_BUCK_VCORE_OC_THD_ADDR,
	 MT6351_PMIC_BUCK_VCORE_OC_THD_MASK, MT6351_PMIC_BUCK_VCORE_OC_THD_SHIFT},
	{PMIC_BUCK_VGPU_OC_DEG_EN, MT6351_PMIC_BUCK_VGPU_OC_DEG_EN_ADDR,
	 MT6351_PMIC_BUCK_VGPU_OC_DEG_EN_MASK, MT6351_PMIC_BUCK_VGPU_OC_DEG_EN_SHIFT},
	{PMIC_BUCK_VGPU_OC_WND, MT6351_PMIC_BUCK_VGPU_OC_WND_ADDR,
	 MT6351_PMIC_BUCK_VGPU_OC_WND_MASK, MT6351_PMIC_BUCK_VGPU_OC_WND_SHIFT},
	{PMIC_BUCK_VGPU_OC_THD, MT6351_PMIC_BUCK_VGPU_OC_THD_ADDR,
	 MT6351_PMIC_BUCK_VGPU_OC_THD_MASK, MT6351_PMIC_BUCK_VGPU_OC_THD_SHIFT},
	{PMIC_BUCK_VMODEM_OC_DEG_EN, MT6351_PMIC_BUCK_VMODEM_OC_DEG_EN_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_OC_DEG_EN_MASK, MT6351_PMIC_BUCK_VMODEM_OC_DEG_EN_SHIFT},
	{PMIC_BUCK_VMODEM_OC_WND, MT6351_PMIC_BUCK_VMODEM_OC_WND_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_OC_WND_MASK, MT6351_PMIC_BUCK_VMODEM_OC_WND_SHIFT},
	{PMIC_BUCK_VMODEM_OC_THD, MT6351_PMIC_BUCK_VMODEM_OC_THD_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_OC_THD_MASK, MT6351_PMIC_BUCK_VMODEM_OC_THD_SHIFT},
	{PMIC_BUCK_VMD1_OC_DEG_EN, MT6351_PMIC_BUCK_VMD1_OC_DEG_EN_ADDR,
	 MT6351_PMIC_BUCK_VMD1_OC_DEG_EN_MASK, MT6351_PMIC_BUCK_VMD1_OC_DEG_EN_SHIFT},
	{PMIC_BUCK_VMD1_OC_WND, MT6351_PMIC_BUCK_VMD1_OC_WND_ADDR,
	 MT6351_PMIC_BUCK_VMD1_OC_WND_MASK, MT6351_PMIC_BUCK_VMD1_OC_WND_SHIFT},
	{PMIC_BUCK_VMD1_OC_THD, MT6351_PMIC_BUCK_VMD1_OC_THD_ADDR,
	 MT6351_PMIC_BUCK_VMD1_OC_THD_MASK, MT6351_PMIC_BUCK_VMD1_OC_THD_SHIFT},
	{PMIC_BUCK_VSRAM_MD_OC_DEG_EN, MT6351_PMIC_BUCK_VSRAM_MD_OC_DEG_EN_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_OC_DEG_EN_MASK, MT6351_PMIC_BUCK_VSRAM_MD_OC_DEG_EN_SHIFT},
	{PMIC_BUCK_VSRAM_MD_OC_WND, MT6351_PMIC_BUCK_VSRAM_MD_OC_WND_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_OC_WND_MASK, MT6351_PMIC_BUCK_VSRAM_MD_OC_WND_SHIFT},
	{PMIC_BUCK_VSRAM_MD_OC_THD, MT6351_PMIC_BUCK_VSRAM_MD_OC_THD_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_OC_THD_MASK, MT6351_PMIC_BUCK_VSRAM_MD_OC_THD_SHIFT},
	{PMIC_BUCK_VS1_OC_DEG_EN, MT6351_PMIC_BUCK_VS1_OC_DEG_EN_ADDR,
	 MT6351_PMIC_BUCK_VS1_OC_DEG_EN_MASK, MT6351_PMIC_BUCK_VS1_OC_DEG_EN_SHIFT},
	{PMIC_BUCK_VS1_OC_WND, MT6351_PMIC_BUCK_VS1_OC_WND_ADDR,
	 MT6351_PMIC_BUCK_VS1_OC_WND_MASK, MT6351_PMIC_BUCK_VS1_OC_WND_SHIFT},
	{PMIC_BUCK_VS1_OC_THD, MT6351_PMIC_BUCK_VS1_OC_THD_ADDR,
	 MT6351_PMIC_BUCK_VS1_OC_THD_MASK, MT6351_PMIC_BUCK_VS1_OC_THD_SHIFT},
	{PMIC_BUCK_VS2_OC_DEG_EN, MT6351_PMIC_BUCK_VS2_OC_DEG_EN_ADDR,
	 MT6351_PMIC_BUCK_VS2_OC_DEG_EN_MASK, MT6351_PMIC_BUCK_VS2_OC_DEG_EN_SHIFT},
	{PMIC_BUCK_VS2_OC_WND, MT6351_PMIC_BUCK_VS2_OC_WND_ADDR,
	 MT6351_PMIC_BUCK_VS2_OC_WND_MASK, MT6351_PMIC_BUCK_VS2_OC_WND_SHIFT},
	{PMIC_BUCK_VS2_OC_THD, MT6351_PMIC_BUCK_VS2_OC_THD_ADDR,
	 MT6351_PMIC_BUCK_VS2_OC_THD_MASK, MT6351_PMIC_BUCK_VS2_OC_THD_SHIFT},
	{PMIC_BUCK_VPA_OC_DEG_EN, MT6351_PMIC_BUCK_VPA_OC_DEG_EN_ADDR,
	 MT6351_PMIC_BUCK_VPA_OC_DEG_EN_MASK, MT6351_PMIC_BUCK_VPA_OC_DEG_EN_SHIFT},
	{PMIC_BUCK_VPA_OC_WND, MT6351_PMIC_BUCK_VPA_OC_WND_ADDR,
	 MT6351_PMIC_BUCK_VPA_OC_WND_MASK, MT6351_PMIC_BUCK_VPA_OC_WND_SHIFT},
	{PMIC_BUCK_VPA_OC_THD, MT6351_PMIC_BUCK_VPA_OC_THD_ADDR,
	 MT6351_PMIC_BUCK_VPA_OC_THD_MASK, MT6351_PMIC_BUCK_VPA_OC_THD_SHIFT},
	{PMIC_RG_SMPS_TESTMODE_B, MT6351_PMIC_RG_SMPS_TESTMODE_B_ADDR,
	 MT6351_PMIC_RG_SMPS_TESTMODE_B_MASK, MT6351_PMIC_RG_SMPS_TESTMODE_B_SHIFT},
	{PMIC_RG_VPA_BURSTH, MT6351_PMIC_RG_VPA_BURSTH_ADDR,
	 MT6351_PMIC_RG_VPA_BURSTH_MASK, MT6351_PMIC_RG_VPA_BURSTH_SHIFT},
	{PMIC_RG_VPA_BURSTL, MT6351_PMIC_RG_VPA_BURSTL_ADDR,
	 MT6351_PMIC_RG_VPA_BURSTL_MASK, MT6351_PMIC_RG_VPA_BURSTL_SHIFT},
	{PMIC_RG_VPA_TRIMH, MT6351_PMIC_RG_VPA_TRIMH_ADDR, MT6351_PMIC_RG_VPA_TRIMH_MASK,
	 MT6351_PMIC_RG_VPA_TRIMH_SHIFT},
	{PMIC_RG_VPA_TRIML, MT6351_PMIC_RG_VPA_TRIML_ADDR, MT6351_PMIC_RG_VPA_TRIML_MASK,
	 MT6351_PMIC_RG_VPA_TRIML_SHIFT},
	{PMIC_RG_VPA_TRIM_REF, MT6351_PMIC_RG_VPA_TRIM_REF_ADDR,
	 MT6351_PMIC_RG_VPA_TRIM_REF_MASK, MT6351_PMIC_RG_VPA_TRIM_REF_SHIFT},
	{PMIC_RG_VCORE_TRIMH, MT6351_PMIC_RG_VCORE_TRIMH_ADDR,
	 MT6351_PMIC_RG_VCORE_TRIMH_MASK, MT6351_PMIC_RG_VCORE_TRIMH_SHIFT},
	{PMIC_RG_VCORE_TRIML, MT6351_PMIC_RG_VCORE_TRIML_ADDR,
	 MT6351_PMIC_RG_VCORE_TRIML_MASK, MT6351_PMIC_RG_VCORE_TRIML_SHIFT},
	{PMIC_RG_VCORE_VSLEEP, MT6351_PMIC_RG_VCORE_VSLEEP_ADDR,
	 MT6351_PMIC_RG_VCORE_VSLEEP_MASK, MT6351_PMIC_RG_VCORE_VSLEEP_SHIFT},
	{PMIC_RG_VGPU_TRIMH, MT6351_PMIC_RG_VGPU_TRIMH_ADDR,
	 MT6351_PMIC_RG_VGPU_TRIMH_MASK, MT6351_PMIC_RG_VGPU_TRIMH_SHIFT},
	{PMIC_RG_VGPU_TRIML, MT6351_PMIC_RG_VGPU_TRIML_ADDR,
	 MT6351_PMIC_RG_VGPU_TRIML_MASK, MT6351_PMIC_RG_VGPU_TRIML_SHIFT},
	{PMIC_RG_VGPU_VSLEEP, MT6351_PMIC_RG_VGPU_VSLEEP_ADDR,
	 MT6351_PMIC_RG_VGPU_VSLEEP_MASK, MT6351_PMIC_RG_VGPU_VSLEEP_SHIFT},
	{PMIC_RG_VSRAM_MD_TRIMH, MT6351_PMIC_RG_VSRAM_MD_TRIMH_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_TRIMH_MASK, MT6351_PMIC_RG_VSRAM_MD_TRIMH_SHIFT},
	{PMIC_RG_VSRAM_MD_TRIML, MT6351_PMIC_RG_VSRAM_MD_TRIML_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_TRIML_MASK, MT6351_PMIC_RG_VSRAM_MD_TRIML_SHIFT},
	{PMIC_RG_VSRAM_MD_VSLEEP, MT6351_PMIC_RG_VSRAM_MD_VSLEEP_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_VSLEEP_MASK, MT6351_PMIC_RG_VSRAM_MD_VSLEEP_SHIFT},
	{PMIC_RG_VMODEM_TRIMH, MT6351_PMIC_RG_VMODEM_TRIMH_ADDR,
	 MT6351_PMIC_RG_VMODEM_TRIMH_MASK, MT6351_PMIC_RG_VMODEM_TRIMH_SHIFT},
	{PMIC_RG_VMODEM_TRIML, MT6351_PMIC_RG_VMODEM_TRIML_ADDR,
	 MT6351_PMIC_RG_VMODEM_TRIML_MASK, MT6351_PMIC_RG_VMODEM_TRIML_SHIFT},
	{PMIC_RG_VMODEM_VSLEEP, MT6351_PMIC_RG_VMODEM_VSLEEP_ADDR,
	 MT6351_PMIC_RG_VMODEM_VSLEEP_MASK, MT6351_PMIC_RG_VMODEM_VSLEEP_SHIFT},
	{PMIC_RG_VMD1_TRIMH, MT6351_PMIC_RG_VMD1_TRIMH_ADDR,
	 MT6351_PMIC_RG_VMD1_TRIMH_MASK, MT6351_PMIC_RG_VMD1_TRIMH_SHIFT},
	{PMIC_RG_VMD1_TRIML, MT6351_PMIC_RG_VMD1_TRIML_ADDR,
	 MT6351_PMIC_RG_VMD1_TRIML_MASK, MT6351_PMIC_RG_VMD1_TRIML_SHIFT},
	{PMIC_RG_VMD1_VSLEEP, MT6351_PMIC_RG_VMD1_VSLEEP_ADDR,
	 MT6351_PMIC_RG_VMD1_VSLEEP_MASK, MT6351_PMIC_RG_VMD1_VSLEEP_SHIFT},
	{PMIC_RG_VS1_TRIMH, MT6351_PMIC_RG_VS1_TRIMH_ADDR, MT6351_PMIC_RG_VS1_TRIMH_MASK,
	 MT6351_PMIC_RG_VS1_TRIMH_SHIFT},
	{PMIC_RG_VS1_TRIML, MT6351_PMIC_RG_VS1_TRIML_ADDR, MT6351_PMIC_RG_VS1_TRIML_MASK,
	 MT6351_PMIC_RG_VS1_TRIML_SHIFT},
	{PMIC_RG_VS1_VSLEEP, MT6351_PMIC_RG_VS1_VSLEEP_ADDR,
	 MT6351_PMIC_RG_VS1_VSLEEP_MASK, MT6351_PMIC_RG_VS1_VSLEEP_SHIFT},
	{PMIC_RG_VS2_TRIML, MT6351_PMIC_RG_VS2_TRIML_ADDR, MT6351_PMIC_RG_VS2_TRIML_MASK,
	 MT6351_PMIC_RG_VS2_TRIML_SHIFT},
	{PMIC_RG_VS2_VSLEEP, MT6351_PMIC_RG_VS2_VSLEEP_ADDR,
	 MT6351_PMIC_RG_VS2_VSLEEP_MASK, MT6351_PMIC_RG_VS2_VSLEEP_SHIFT},
	{PMIC_RG_VSRAM_PROCESSOR_TRIMH, MT6351_PMIC_RG_VSRAM_PROCESSOR_TRIMH_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROCESSOR_TRIMH_MASK, MT6351_PMIC_RG_VSRAM_PROCESSOR_TRIMH_SHIFT},
	{PMIC_RG_VSRAM_PROCESSOR_TRIML, MT6351_PMIC_RG_VSRAM_PROCESSOR_TRIML_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROCESSOR_TRIML_MASK, MT6351_PMIC_RG_VSRAM_PROCESSOR_TRIML_SHIFT},
	{PMIC_RG_VSRAM_PROCESSOR_VSLEEP, MT6351_PMIC_RG_VSRAM_PROCESSOR_VSLEEP_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROCESSOR_VSLEEP_MASK, MT6351_PMIC_RG_VSRAM_PROCESSOR_VSLEEP_SHIFT},
	{PMIC_RG_VCORE_VSLEEP_SEL, MT6351_PMIC_RG_VCORE_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_RG_VCORE_VSLEEP_SEL_MASK, MT6351_PMIC_RG_VCORE_VSLEEP_SEL_SHIFT},
	{PMIC_RG_VGPU_VSLEEP_SEL, MT6351_PMIC_RG_VGPU_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_RG_VGPU_VSLEEP_SEL_MASK, MT6351_PMIC_RG_VGPU_VSLEEP_SEL_SHIFT},
	{PMIC_RG_VSRAM_MD_VSLEEP_SEL, MT6351_PMIC_RG_VSRAM_MD_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_VSLEEP_SEL_MASK, MT6351_PMIC_RG_VSRAM_MD_VSLEEP_SEL_SHIFT},
	{PMIC_RG_VMODEM_VSLEEP_SEL, MT6351_PMIC_RG_VMODEM_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_RG_VMODEM_VSLEEP_SEL_MASK, MT6351_PMIC_RG_VMODEM_VSLEEP_SEL_SHIFT},
	{PMIC_RG_VMD1_VSLEEP_SEL, MT6351_PMIC_RG_VMD1_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_RG_VMD1_VSLEEP_SEL_MASK, MT6351_PMIC_RG_VMD1_VSLEEP_SEL_SHIFT},
	{PMIC_RG_VS1_VSLEEP_SEL, MT6351_PMIC_RG_VS1_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_RG_VS1_VSLEEP_SEL_MASK, MT6351_PMIC_RG_VS1_VSLEEP_SEL_SHIFT},
	{PMIC_RG_VS2_VSLEEP_SEL, MT6351_PMIC_RG_VS2_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_RG_VS2_VSLEEP_SEL_MASK, MT6351_PMIC_RG_VS2_VSLEEP_SEL_SHIFT},
	{PMIC_RG_VSRAM_PROCESSOR_VSLEEP_SEL,
	 MT6351_PMIC_RG_VSRAM_PROCESSOR_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROCESSOR_VSLEEP_SEL_MASK,
	 MT6351_PMIC_RG_VSRAM_PROCESSOR_VSLEEP_SEL_SHIFT},
	{PMIC_RG_VOUTDET_EN, MT6351_PMIC_RG_VOUTDET_EN_ADDR,
	 MT6351_PMIC_RG_VOUTDET_EN_MASK, MT6351_PMIC_RG_VOUTDET_EN_SHIFT},
	{PMIC_RG_VS2_TRIMH, MT6351_PMIC_RG_VS2_TRIMH_ADDR, MT6351_PMIC_RG_VS2_TRIMH_MASK,
	 MT6351_PMIC_RG_VS2_TRIMH_SHIFT},
	{PMIC_RG_VCORE_MODESET, MT6351_PMIC_RG_VCORE_MODESET_ADDR,
	 MT6351_PMIC_RG_VCORE_MODESET_MASK, MT6351_PMIC_RG_VCORE_MODESET_SHIFT},
	{PMIC_RG_VCORE_NDIS_EN, MT6351_PMIC_RG_VCORE_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VCORE_NDIS_EN_MASK, MT6351_PMIC_RG_VCORE_NDIS_EN_SHIFT},
	{PMIC_RG_VCORE_VRF18_SSTART_EN, MT6351_PMIC_RG_VCORE_VRF18_SSTART_EN_ADDR,
	 MT6351_PMIC_RG_VCORE_VRF18_SSTART_EN_MASK, MT6351_PMIC_RG_VCORE_VRF18_SSTART_EN_SHIFT},
	{PMIC_RG_VCORE_AUTO_MODE, MT6351_PMIC_RG_VCORE_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VCORE_AUTO_MODE_MASK, MT6351_PMIC_RG_VCORE_AUTO_MODE_SHIFT},
	{PMIC_RG_VCORE_RZSEL0, MT6351_PMIC_RG_VCORE_RZSEL0_ADDR,
	 MT6351_PMIC_RG_VCORE_RZSEL0_MASK, MT6351_PMIC_RG_VCORE_RZSEL0_SHIFT},
	{PMIC_RG_VCORE_RZSEL1, MT6351_PMIC_RG_VCORE_RZSEL1_ADDR,
	 MT6351_PMIC_RG_VCORE_RZSEL1_MASK, MT6351_PMIC_RG_VCORE_RZSEL1_SHIFT},
	{PMIC_RG_VCORE_CCSEL0, MT6351_PMIC_RG_VCORE_CCSEL0_ADDR,
	 MT6351_PMIC_RG_VCORE_CCSEL0_MASK, MT6351_PMIC_RG_VCORE_CCSEL0_SHIFT},
	{PMIC_RG_VCORE_CCSEL1, MT6351_PMIC_RG_VCORE_CCSEL1_ADDR,
	 MT6351_PMIC_RG_VCORE_CCSEL1_MASK, MT6351_PMIC_RG_VCORE_CCSEL1_SHIFT},
	{PMIC_RG_VCORE_CSL, MT6351_PMIC_RG_VCORE_CSL_ADDR, MT6351_PMIC_RG_VCORE_CSL_MASK,
	 MT6351_PMIC_RG_VCORE_CSL_SHIFT},
	{PMIC_RG_VCORE_SLP, MT6351_PMIC_RG_VCORE_SLP_ADDR, MT6351_PMIC_RG_VCORE_SLP_MASK,
	 MT6351_PMIC_RG_VCORE_SLP_SHIFT},
	{PMIC_RG_VCORE_ADRC_FEN, MT6351_PMIC_RG_VCORE_ADRC_FEN_ADDR,
	 MT6351_PMIC_RG_VCORE_ADRC_FEN_MASK, MT6351_PMIC_RG_VCORE_ADRC_FEN_SHIFT},
	{PMIC_RG_VCORE_VCCAP_CLAMP_FEN, MT6351_PMIC_RG_VCORE_VCCAP_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VCORE_VCCAP_CLAMP_FEN_MASK, MT6351_PMIC_RG_VCORE_VCCAP_CLAMP_FEN_SHIFT},
	{PMIC_RG_VCORE_VC_CLAMP_FEN, MT6351_PMIC_RG_VCORE_VC_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VCORE_VC_CLAMP_FEN_MASK, MT6351_PMIC_RG_VCORE_VC_CLAMP_FEN_SHIFT},
	{PMIC_RG_VCORE_PREOC_SEL, MT6351_PMIC_RG_VCORE_PREOC_SEL_ADDR,
	 MT6351_PMIC_RG_VCORE_PREOC_SEL_MASK, MT6351_PMIC_RG_VCORE_PREOC_SEL_SHIFT},
	{PMIC_RG_VCORE_PFMOC, MT6351_PMIC_RG_VCORE_PFMOC_ADDR,
	 MT6351_PMIC_RG_VCORE_PFMOC_MASK, MT6351_PMIC_RG_VCORE_PFMOC_SHIFT},
	{PMIC_RG_VCORE_CSR, MT6351_PMIC_RG_VCORE_CSR_ADDR, MT6351_PMIC_RG_VCORE_CSR_MASK,
	 MT6351_PMIC_RG_VCORE_CSR_SHIFT},
	{PMIC_RG_VCORE_ZXOS_TRIM, MT6351_PMIC_RG_VCORE_ZXOS_TRIM_ADDR,
	 MT6351_PMIC_RG_VCORE_ZXOS_TRIM_MASK, MT6351_PMIC_RG_VCORE_ZXOS_TRIM_SHIFT},
	{PMIC_RG_VCORE_CSM_N, MT6351_PMIC_RG_VCORE_CSM_N_ADDR,
	 MT6351_PMIC_RG_VCORE_CSM_N_MASK, MT6351_PMIC_RG_VCORE_CSM_N_SHIFT},
	{PMIC_RG_VCORE_CSM_P, MT6351_PMIC_RG_VCORE_CSM_P_ADDR,
	 MT6351_PMIC_RG_VCORE_CSM_P_MASK, MT6351_PMIC_RG_VCORE_CSM_P_SHIFT},
	{PMIC_RG_VCORE_PFMSR_EH, MT6351_PMIC_RG_VCORE_PFMSR_EH_ADDR,
	 MT6351_PMIC_RG_VCORE_PFMSR_EH_MASK, MT6351_PMIC_RG_VCORE_PFMSR_EH_SHIFT},
	{PMIC_RG_VCORE_NLIM_GATING, MT6351_PMIC_RG_VCORE_NLIM_GATING_ADDR,
	 MT6351_PMIC_RG_VCORE_NLIM_GATING_MASK, MT6351_PMIC_RG_VCORE_NLIM_GATING_SHIFT},
	{PMIC_RG_VCORE_PWRSR_EH, MT6351_PMIC_RG_VCORE_PWRSR_EH_ADDR,
	 MT6351_PMIC_RG_VCORE_PWRSR_EH_MASK, MT6351_PMIC_RG_VCORE_PWRSR_EH_SHIFT},
	{PMIC_RG_VCORE_HS_VTHDET, MT6351_PMIC_RG_VCORE_HS_VTHDET_ADDR,
	 MT6351_PMIC_RG_VCORE_HS_VTHDET_MASK, MT6351_PMIC_RG_VCORE_HS_VTHDET_SHIFT},
	{PMIC_RG_VCORE_PG_GATING, MT6351_PMIC_RG_VCORE_PG_GATING_ADDR,
	 MT6351_PMIC_RG_VCORE_PG_GATING_MASK, MT6351_PMIC_RG_VCORE_PG_GATING_SHIFT},
	{PMIC_RG_VCORE_HS_ONSPEED_EH, MT6351_PMIC_RG_VCORE_HS_ONSPEED_EH_ADDR,
	 MT6351_PMIC_RG_VCORE_HS_ONSPEED_EH_MASK, MT6351_PMIC_RG_VCORE_HS_ONSPEED_EH_SHIFT},
	{PMIC_RG_VCORE_NLIM_TRIMMING, MT6351_PMIC_RG_VCORE_NLIM_TRIMMING_ADDR,
	 MT6351_PMIC_RG_VCORE_NLIM_TRIMMING_MASK, MT6351_PMIC_RG_VCORE_NLIM_TRIMMING_SHIFT},
	{PMIC_RG_VCORE_DLC, MT6351_PMIC_RG_VCORE_DLC_ADDR, MT6351_PMIC_RG_VCORE_DLC_MASK,
	 MT6351_PMIC_RG_VCORE_DLC_SHIFT},
	{PMIC_RG_VCORE_DLC_N, MT6351_PMIC_RG_VCORE_DLC_N_ADDR,
	 MT6351_PMIC_RG_VCORE_DLC_N_MASK, MT6351_PMIC_RG_VCORE_DLC_N_SHIFT},
	{PMIC_RG_VCORE_PFM_RIP, MT6351_PMIC_RG_VCORE_PFM_RIP_ADDR,
	 MT6351_PMIC_RG_VCORE_PFM_RIP_MASK, MT6351_PMIC_RG_VCORE_PFM_RIP_SHIFT},
	{PMIC_RG_VCORE_TRAN_BST, MT6351_PMIC_RG_VCORE_TRAN_BST_ADDR,
	 MT6351_PMIC_RG_VCORE_TRAN_BST_MASK, MT6351_PMIC_RG_VCORE_TRAN_BST_SHIFT},
	{PMIC_RG_VCORE_DTS_ENB, MT6351_PMIC_RG_VCORE_DTS_ENB_ADDR,
	 MT6351_PMIC_RG_VCORE_DTS_ENB_MASK, MT6351_PMIC_RG_VCORE_DTS_ENB_SHIFT},
	{PMIC_RG_VCORE_MIN_OFF, MT6351_PMIC_RG_VCORE_MIN_OFF_ADDR,
	 MT6351_PMIC_RG_VCORE_MIN_OFF_MASK, MT6351_PMIC_RG_VCORE_MIN_OFF_SHIFT},
	{PMIC_RG_VCORE_1P35UP_SEL_EN, MT6351_PMIC_RG_VCORE_1P35UP_SEL_EN_ADDR,
	 MT6351_PMIC_RG_VCORE_1P35UP_SEL_EN_MASK, MT6351_PMIC_RG_VCORE_1P35UP_SEL_EN_SHIFT},
	{PMIC_RG_VCORE_DLC_AUTO_MODE, MT6351_PMIC_RG_VCORE_DLC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VCORE_DLC_AUTO_MODE_MASK, MT6351_PMIC_RG_VCORE_DLC_AUTO_MODE_SHIFT},
	{PMIC_RG_VCORE_DLC_SEL, MT6351_PMIC_RG_VCORE_DLC_SEL_ADDR,
	 MT6351_PMIC_RG_VCORE_DLC_SEL_MASK, MT6351_PMIC_RG_VCORE_DLC_SEL_SHIFT},
	{PMIC_RG_VCORE_SRC_AUTO_MODE, MT6351_PMIC_RG_VCORE_SRC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VCORE_SRC_AUTO_MODE_MASK, MT6351_PMIC_RG_VCORE_SRC_AUTO_MODE_SHIFT},
	{PMIC_RG_VCORE_UGP_SR, MT6351_PMIC_RG_VCORE_UGP_SR_ADDR,
	 MT6351_PMIC_RG_VCORE_UGP_SR_MASK, MT6351_PMIC_RG_VCORE_UGP_SR_SHIFT},
	{PMIC_RG_VCORE_LGN_SR, MT6351_PMIC_RG_VCORE_LGN_SR_ADDR,
	 MT6351_PMIC_RG_VCORE_LGN_SR_MASK, MT6351_PMIC_RG_VCORE_LGN_SR_SHIFT},
	{PMIC_RG_VCORE_UGP_SR_PFM, MT6351_PMIC_RG_VCORE_UGP_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VCORE_UGP_SR_PFM_MASK, MT6351_PMIC_RG_VCORE_UGP_SR_PFM_SHIFT},
	{PMIC_RG_VCORE_LGN_SR_PFM, MT6351_PMIC_RG_VCORE_LGN_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VCORE_LGN_SR_PFM_MASK, MT6351_PMIC_RG_VCORE_LGN_SR_PFM_SHIFT},
	{PMIC_RG_VCORE_UGD_VTHSEL, MT6351_PMIC_RG_VCORE_UGD_VTHSEL_ADDR,
	 MT6351_PMIC_RG_VCORE_UGD_VTHSEL_MASK, MT6351_PMIC_RG_VCORE_UGD_VTHSEL_SHIFT},
	{PMIC_RG_VCORE_FNLX_SNS, MT6351_PMIC_RG_VCORE_FNLX_SNS_ADDR,
	 MT6351_PMIC_RG_VCORE_FNLX_SNS_MASK, MT6351_PMIC_RG_VCORE_FNLX_SNS_SHIFT},
	{PMIC_RG_VCORE_VDIFF_ENLOWIQ, MT6351_PMIC_RG_VCORE_VDIFF_ENLOWIQ_ADDR,
	 MT6351_PMIC_RG_VCORE_VDIFF_ENLOWIQ_MASK, MT6351_PMIC_RG_VCORE_VDIFF_ENLOWIQ_SHIFT},
	{PMIC_RG_VCORE_PFMOC_FWUPOFF, MT6351_PMIC_RG_VCORE_PFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VCORE_PFMOC_FWUPOFF_MASK, MT6351_PMIC_RG_VCORE_PFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VCORE_PWFMOC_FWUPOFF, MT6351_PMIC_RG_VCORE_PWFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VCORE_PWFMOC_FWUPOFF_MASK, MT6351_PMIC_RG_VCORE_PWFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VCORE_CP_FWUPOFF, MT6351_PMIC_RG_VCORE_CP_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VCORE_CP_FWUPOFF_MASK, MT6351_PMIC_RG_VCORE_CP_FWUPOFF_SHIFT},
	{PMIC_RG_VCORE_ZX_GATING, MT6351_PMIC_RG_VCORE_ZX_GATING_ADDR,
	 MT6351_PMIC_RG_VCORE_ZX_GATING_MASK, MT6351_PMIC_RG_VCORE_ZX_GATING_SHIFT},
	{PMIC_RG_VCORE_RSV, MT6351_PMIC_RG_VCORE_RSV_ADDR, MT6351_PMIC_RG_VCORE_RSV_MASK,
	 MT6351_PMIC_RG_VCORE_RSV_SHIFT},
	{PMIC_RG_VCORE_PREOC_TRIMMING, MT6351_PMIC_RG_VCORE_PREOC_TRIMMING_ADDR,
	 MT6351_PMIC_RG_VCORE_PREOC_TRIMMING_MASK, MT6351_PMIC_RG_VCORE_PREOC_TRIMMING_SHIFT},
	{PMIC_RG_VCORE_AZC_EN, MT6351_PMIC_RG_VCORE_AZC_EN_ADDR,
	 MT6351_PMIC_RG_VCORE_AZC_EN_MASK, MT6351_PMIC_RG_VCORE_AZC_EN_SHIFT},
	{PMIC_RG_VCORE_AZC_DELAY, MT6351_PMIC_RG_VCORE_AZC_DELAY_ADDR,
	 MT6351_PMIC_RG_VCORE_AZC_DELAY_MASK, MT6351_PMIC_RG_VCORE_AZC_DELAY_SHIFT},
	{PMIC_RG_VCORE_AZC_HOLD_ENB, MT6351_PMIC_RG_VCORE_AZC_HOLD_ENB_ADDR,
	 MT6351_PMIC_RG_VCORE_AZC_HOLD_ENB_MASK, MT6351_PMIC_RG_VCORE_AZC_HOLD_ENB_SHIFT},
	{PMIC_RGS_QI_VCORE_OC_STATUS, MT6351_PMIC_RGS_QI_VCORE_OC_STATUS_ADDR,
	 MT6351_PMIC_RGS_QI_VCORE_OC_STATUS_MASK, MT6351_PMIC_RGS_QI_VCORE_OC_STATUS_SHIFT},
	{PMIC_RGS_QI_VCORE_DIG_MON, MT6351_PMIC_RGS_QI_VCORE_DIG_MON_ADDR,
	 MT6351_PMIC_RGS_QI_VCORE_DIG_MON_MASK, MT6351_PMIC_RGS_QI_VCORE_DIG_MON_SHIFT},
	{PMIC_RGS_VCORE_ENPWM_STATUS, MT6351_PMIC_RGS_VCORE_ENPWM_STATUS_ADDR,
	 MT6351_PMIC_RGS_VCORE_ENPWM_STATUS_MASK, MT6351_PMIC_RGS_VCORE_ENPWM_STATUS_SHIFT},
	{PMIC_RGS_QI_VCORE_PREOC, MT6351_PMIC_RGS_QI_VCORE_PREOC_ADDR,
	 MT6351_PMIC_RGS_QI_VCORE_PREOC_MASK, MT6351_PMIC_RGS_QI_VCORE_PREOC_SHIFT},
	{PMIC_RG_VGPU_MODESET, MT6351_PMIC_RG_VGPU_MODESET_ADDR,
	 MT6351_PMIC_RG_VGPU_MODESET_MASK, MT6351_PMIC_RG_VGPU_MODESET_SHIFT},
	{PMIC_RG_VGPU_NDIS_EN, MT6351_PMIC_RG_VGPU_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VGPU_NDIS_EN_MASK, MT6351_PMIC_RG_VGPU_NDIS_EN_SHIFT},
	{PMIC_RG_VGPU_VRF18_SSTART_EN, MT6351_PMIC_RG_VGPU_VRF18_SSTART_EN_ADDR,
	 MT6351_PMIC_RG_VGPU_VRF18_SSTART_EN_MASK, MT6351_PMIC_RG_VGPU_VRF18_SSTART_EN_SHIFT},
	{PMIC_RG_VGPU_AUTO_MODE, MT6351_PMIC_RG_VGPU_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VGPU_AUTO_MODE_MASK, MT6351_PMIC_RG_VGPU_AUTO_MODE_SHIFT},
	{PMIC_RG_VGPU_RZSEL0, MT6351_PMIC_RG_VGPU_RZSEL0_ADDR,
	 MT6351_PMIC_RG_VGPU_RZSEL0_MASK, MT6351_PMIC_RG_VGPU_RZSEL0_SHIFT},
	{PMIC_RG_VGPU_RZSEL1, MT6351_PMIC_RG_VGPU_RZSEL1_ADDR,
	 MT6351_PMIC_RG_VGPU_RZSEL1_MASK, MT6351_PMIC_RG_VGPU_RZSEL1_SHIFT},
	{PMIC_RG_VGPU_CCSEL0, MT6351_PMIC_RG_VGPU_CCSEL0_ADDR,
	 MT6351_PMIC_RG_VGPU_CCSEL0_MASK, MT6351_PMIC_RG_VGPU_CCSEL0_SHIFT},
	{PMIC_RG_VGPU_CCSEL1, MT6351_PMIC_RG_VGPU_CCSEL1_ADDR,
	 MT6351_PMIC_RG_VGPU_CCSEL1_MASK, MT6351_PMIC_RG_VGPU_CCSEL1_SHIFT},
	{PMIC_RG_VGPU_CSL, MT6351_PMIC_RG_VGPU_CSL_ADDR, MT6351_PMIC_RG_VGPU_CSL_MASK,
	 MT6351_PMIC_RG_VGPU_CSL_SHIFT},
	{PMIC_RG_VGPU_SLP, MT6351_PMIC_RG_VGPU_SLP_ADDR, MT6351_PMIC_RG_VGPU_SLP_MASK,
	 MT6351_PMIC_RG_VGPU_SLP_SHIFT},
	{PMIC_RG_VGPU_ADRC_FEN, MT6351_PMIC_RG_VGPU_ADRC_FEN_ADDR,
	 MT6351_PMIC_RG_VGPU_ADRC_FEN_MASK, MT6351_PMIC_RG_VGPU_ADRC_FEN_SHIFT},
	{PMIC_RG_VGPU_VCCAP_CLAMP_FEN, MT6351_PMIC_RG_VGPU_VCCAP_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VGPU_VCCAP_CLAMP_FEN_MASK, MT6351_PMIC_RG_VGPU_VCCAP_CLAMP_FEN_SHIFT},
	{PMIC_RG_VGPU_VC_CLAMP_FEN, MT6351_PMIC_RG_VGPU_VC_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VGPU_VC_CLAMP_FEN_MASK, MT6351_PMIC_RG_VGPU_VC_CLAMP_FEN_SHIFT},
	{PMIC_RG_VGPU_PREOC_SEL, MT6351_PMIC_RG_VGPU_PREOC_SEL_ADDR,
	 MT6351_PMIC_RG_VGPU_PREOC_SEL_MASK, MT6351_PMIC_RG_VGPU_PREOC_SEL_SHIFT},
	{PMIC_RG_VGPU_PFMOC, MT6351_PMIC_RG_VGPU_PFMOC_ADDR,
	 MT6351_PMIC_RG_VGPU_PFMOC_MASK, MT6351_PMIC_RG_VGPU_PFMOC_SHIFT},
	{PMIC_RG_VGPU_CSR, MT6351_PMIC_RG_VGPU_CSR_ADDR, MT6351_PMIC_RG_VGPU_CSR_MASK,
	 MT6351_PMIC_RG_VGPU_CSR_SHIFT},
	{PMIC_RG_VGPU_ZXOS_TRIM, MT6351_PMIC_RG_VGPU_ZXOS_TRIM_ADDR,
	 MT6351_PMIC_RG_VGPU_ZXOS_TRIM_MASK, MT6351_PMIC_RG_VGPU_ZXOS_TRIM_SHIFT},
	{PMIC_RG_VGPU_CSM_N, MT6351_PMIC_RG_VGPU_CSM_N_ADDR,
	 MT6351_PMIC_RG_VGPU_CSM_N_MASK, MT6351_PMIC_RG_VGPU_CSM_N_SHIFT},
	{PMIC_RG_VGPU_CSM_P, MT6351_PMIC_RG_VGPU_CSM_P_ADDR,
	 MT6351_PMIC_RG_VGPU_CSM_P_MASK, MT6351_PMIC_RG_VGPU_CSM_P_SHIFT},
	{PMIC_RG_VGPU_PFMSR_EH, MT6351_PMIC_RG_VGPU_PFMSR_EH_ADDR,
	 MT6351_PMIC_RG_VGPU_PFMSR_EH_MASK, MT6351_PMIC_RG_VGPU_PFMSR_EH_SHIFT},
	{PMIC_RG_VGPU_NLIM_GATING, MT6351_PMIC_RG_VGPU_NLIM_GATING_ADDR,
	 MT6351_PMIC_RG_VGPU_NLIM_GATING_MASK, MT6351_PMIC_RG_VGPU_NLIM_GATING_SHIFT},
	{PMIC_RG_VGPU_PWRSR_EH, MT6351_PMIC_RG_VGPU_PWRSR_EH_ADDR,
	 MT6351_PMIC_RG_VGPU_PWRSR_EH_MASK, MT6351_PMIC_RG_VGPU_PWRSR_EH_SHIFT},
	{PMIC_RG_VGPU_HS_VTHDET, MT6351_PMIC_RG_VGPU_HS_VTHDET_ADDR,
	 MT6351_PMIC_RG_VGPU_HS_VTHDET_MASK, MT6351_PMIC_RG_VGPU_HS_VTHDET_SHIFT},
	{PMIC_RG_VGPU_PG_GATING, MT6351_PMIC_RG_VGPU_PG_GATING_ADDR,
	 MT6351_PMIC_RG_VGPU_PG_GATING_MASK, MT6351_PMIC_RG_VGPU_PG_GATING_SHIFT},
	{PMIC_RG_VGPU_HS_ONSPEED_EH, MT6351_PMIC_RG_VGPU_HS_ONSPEED_EH_ADDR,
	 MT6351_PMIC_RG_VGPU_HS_ONSPEED_EH_MASK, MT6351_PMIC_RG_VGPU_HS_ONSPEED_EH_SHIFT},
	{PMIC_RG_VGPU_NLIM_TRIMMING, MT6351_PMIC_RG_VGPU_NLIM_TRIMMING_ADDR,
	 MT6351_PMIC_RG_VGPU_NLIM_TRIMMING_MASK, MT6351_PMIC_RG_VGPU_NLIM_TRIMMING_SHIFT},
	{PMIC_RG_VGPU_DLC, MT6351_PMIC_RG_VGPU_DLC_ADDR, MT6351_PMIC_RG_VGPU_DLC_MASK,
	 MT6351_PMIC_RG_VGPU_DLC_SHIFT},
	{PMIC_RG_VGPU_DLC_N, MT6351_PMIC_RG_VGPU_DLC_N_ADDR,
	 MT6351_PMIC_RG_VGPU_DLC_N_MASK, MT6351_PMIC_RG_VGPU_DLC_N_SHIFT},
	{PMIC_RG_VGPU_PFM_RIP, MT6351_PMIC_RG_VGPU_PFM_RIP_ADDR,
	 MT6351_PMIC_RG_VGPU_PFM_RIP_MASK, MT6351_PMIC_RG_VGPU_PFM_RIP_SHIFT},
	{PMIC_RG_VGPU_TRAN_BST, MT6351_PMIC_RG_VGPU_TRAN_BST_ADDR,
	 MT6351_PMIC_RG_VGPU_TRAN_BST_MASK, MT6351_PMIC_RG_VGPU_TRAN_BST_SHIFT},
	{PMIC_RG_VGPU_DTS_ENB, MT6351_PMIC_RG_VGPU_DTS_ENB_ADDR,
	 MT6351_PMIC_RG_VGPU_DTS_ENB_MASK, MT6351_PMIC_RG_VGPU_DTS_ENB_SHIFT},
	{PMIC_RG_VGPU_MIN_OFF, MT6351_PMIC_RG_VGPU_MIN_OFF_ADDR,
	 MT6351_PMIC_RG_VGPU_MIN_OFF_MASK, MT6351_PMIC_RG_VGPU_MIN_OFF_SHIFT},
	{PMIC_RG_VGPU_1P35UP_SEL_EN, MT6351_PMIC_RG_VGPU_1P35UP_SEL_EN_ADDR,
	 MT6351_PMIC_RG_VGPU_1P35UP_SEL_EN_MASK, MT6351_PMIC_RG_VGPU_1P35UP_SEL_EN_SHIFT},
	{PMIC_RG_VGPU_DLC_AUTO_MODE, MT6351_PMIC_RG_VGPU_DLC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VGPU_DLC_AUTO_MODE_MASK, MT6351_PMIC_RG_VGPU_DLC_AUTO_MODE_SHIFT},
	{PMIC_RG_VGPU_DLC_SEL, MT6351_PMIC_RG_VGPU_DLC_SEL_ADDR,
	 MT6351_PMIC_RG_VGPU_DLC_SEL_MASK, MT6351_PMIC_RG_VGPU_DLC_SEL_SHIFT},
	{PMIC_RG_VGPU_SRC_AUTO_MODE, MT6351_PMIC_RG_VGPU_SRC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VGPU_SRC_AUTO_MODE_MASK, MT6351_PMIC_RG_VGPU_SRC_AUTO_MODE_SHIFT},
	{PMIC_RG_VGPU_UGP_SR, MT6351_PMIC_RG_VGPU_UGP_SR_ADDR,
	 MT6351_PMIC_RG_VGPU_UGP_SR_MASK, MT6351_PMIC_RG_VGPU_UGP_SR_SHIFT},
	{PMIC_RG_VGPU_LGN_SR, MT6351_PMIC_RG_VGPU_LGN_SR_ADDR,
	 MT6351_PMIC_RG_VGPU_LGN_SR_MASK, MT6351_PMIC_RG_VGPU_LGN_SR_SHIFT},
	{PMIC_RG_VGPU_UGP_SR_PFM, MT6351_PMIC_RG_VGPU_UGP_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VGPU_UGP_SR_PFM_MASK, MT6351_PMIC_RG_VGPU_UGP_SR_PFM_SHIFT},
	{PMIC_RG_VGPU_LGN_SR_PFM, MT6351_PMIC_RG_VGPU_LGN_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VGPU_LGN_SR_PFM_MASK, MT6351_PMIC_RG_VGPU_LGN_SR_PFM_SHIFT},
	{PMIC_RG_VGPU_UGD_VTHSEL, MT6351_PMIC_RG_VGPU_UGD_VTHSEL_ADDR,
	 MT6351_PMIC_RG_VGPU_UGD_VTHSEL_MASK, MT6351_PMIC_RG_VGPU_UGD_VTHSEL_SHIFT},
	{PMIC_RG_VGPU_FNLX_SNS, MT6351_PMIC_RG_VGPU_FNLX_SNS_ADDR,
	 MT6351_PMIC_RG_VGPU_FNLX_SNS_MASK, MT6351_PMIC_RG_VGPU_FNLX_SNS_SHIFT},
	{PMIC_RG_VGPU_VDIFF_ENLOWIQ, MT6351_PMIC_RG_VGPU_VDIFF_ENLOWIQ_ADDR,
	 MT6351_PMIC_RG_VGPU_VDIFF_ENLOWIQ_MASK, MT6351_PMIC_RG_VGPU_VDIFF_ENLOWIQ_SHIFT},
	{PMIC_RG_VGPU_PFMOC_FWUPOFF, MT6351_PMIC_RG_VGPU_PFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VGPU_PFMOC_FWUPOFF_MASK, MT6351_PMIC_RG_VGPU_PFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VGPU_PWFMOC_FWUPOFF, MT6351_PMIC_RG_VGPU_PWFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VGPU_PWFMOC_FWUPOFF_MASK, MT6351_PMIC_RG_VGPU_PWFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VGPU_CP_FWUPOFF, MT6351_PMIC_RG_VGPU_CP_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VGPU_CP_FWUPOFF_MASK, MT6351_PMIC_RG_VGPU_CP_FWUPOFF_SHIFT},
	{PMIC_RG_VGPU_ZX_GATING, MT6351_PMIC_RG_VGPU_ZX_GATING_ADDR,
	 MT6351_PMIC_RG_VGPU_ZX_GATING_MASK, MT6351_PMIC_RG_VGPU_ZX_GATING_SHIFT},
	{PMIC_RG_VGPU_RSV, MT6351_PMIC_RG_VGPU_RSV_ADDR, MT6351_PMIC_RG_VGPU_RSV_MASK,
	 MT6351_PMIC_RG_VGPU_RSV_SHIFT},
	{PMIC_RG_VGPU_PREOC_TRIMMING, MT6351_PMIC_RG_VGPU_PREOC_TRIMMING_ADDR,
	 MT6351_PMIC_RG_VGPU_PREOC_TRIMMING_MASK, MT6351_PMIC_RG_VGPU_PREOC_TRIMMING_SHIFT},
	{PMIC_RG_VGPU_AZC_EN, MT6351_PMIC_RG_VGPU_AZC_EN_ADDR,
	 MT6351_PMIC_RG_VGPU_AZC_EN_MASK, MT6351_PMIC_RG_VGPU_AZC_EN_SHIFT},
	{PMIC_RG_VGPU_AZC_DELAY, MT6351_PMIC_RG_VGPU_AZC_DELAY_ADDR,
	 MT6351_PMIC_RG_VGPU_AZC_DELAY_MASK, MT6351_PMIC_RG_VGPU_AZC_DELAY_SHIFT},
	{PMIC_RG_VGPU_AZC_HOLD_ENB, MT6351_PMIC_RG_VGPU_AZC_HOLD_ENB_ADDR,
	 MT6351_PMIC_RG_VGPU_AZC_HOLD_ENB_MASK, MT6351_PMIC_RG_VGPU_AZC_HOLD_ENB_SHIFT},
	{PMIC_RGS_QI_VGPU_OC_STATUS, MT6351_PMIC_RGS_QI_VGPU_OC_STATUS_ADDR,
	 MT6351_PMIC_RGS_QI_VGPU_OC_STATUS_MASK, MT6351_PMIC_RGS_QI_VGPU_OC_STATUS_SHIFT},
	{PMIC_RGS_QI_VGPU_DIG_MON, MT6351_PMIC_RGS_QI_VGPU_DIG_MON_ADDR,
	 MT6351_PMIC_RGS_QI_VGPU_DIG_MON_MASK, MT6351_PMIC_RGS_QI_VGPU_DIG_MON_SHIFT},
	{PMIC_RGS_VGPU_ENPWM_STATUS, MT6351_PMIC_RGS_VGPU_ENPWM_STATUS_ADDR,
	 MT6351_PMIC_RGS_VGPU_ENPWM_STATUS_MASK, MT6351_PMIC_RGS_VGPU_ENPWM_STATUS_SHIFT},
	{PMIC_RGS_QI_VGPU_PREOC, MT6351_PMIC_RGS_QI_VGPU_PREOC_ADDR,
	 MT6351_PMIC_RGS_QI_VGPU_PREOC_MASK, MT6351_PMIC_RGS_QI_VGPU_PREOC_SHIFT},
	{PMIC_RG_VSRAM_MD_MODESET, MT6351_PMIC_RG_VSRAM_MD_MODESET_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_MODESET_MASK, MT6351_PMIC_RG_VSRAM_MD_MODESET_SHIFT},
	{PMIC_RG_VSRAM_MD_NDIS_EN, MT6351_PMIC_RG_VSRAM_MD_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_NDIS_EN_MASK, MT6351_PMIC_RG_VSRAM_MD_NDIS_EN_SHIFT},
	{PMIC_RG_VSRAM_MD_VRF18_SSTART_EN, MT6351_PMIC_RG_VSRAM_MD_VRF18_SSTART_EN_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_VRF18_SSTART_EN_MASK,
	 MT6351_PMIC_RG_VSRAM_MD_VRF18_SSTART_EN_SHIFT},
	{PMIC_RG_VSRAM_MD_AUTO_MODE, MT6351_PMIC_RG_VSRAM_MD_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_AUTO_MODE_MASK, MT6351_PMIC_RG_VSRAM_MD_AUTO_MODE_SHIFT},
	{PMIC_RG_VSRAM_MD_RZSEL0, MT6351_PMIC_RG_VSRAM_MD_RZSEL0_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_RZSEL0_MASK, MT6351_PMIC_RG_VSRAM_MD_RZSEL0_SHIFT},
	{PMIC_RG_VSRAM_MD_RZSEL1, MT6351_PMIC_RG_VSRAM_MD_RZSEL1_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_RZSEL1_MASK, MT6351_PMIC_RG_VSRAM_MD_RZSEL1_SHIFT},
	{PMIC_RG_VSRAM_MD_CCSEL0, MT6351_PMIC_RG_VSRAM_MD_CCSEL0_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_CCSEL0_MASK, MT6351_PMIC_RG_VSRAM_MD_CCSEL0_SHIFT},
	{PMIC_RG_VSRAM_MD_CCSEL1, MT6351_PMIC_RG_VSRAM_MD_CCSEL1_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_CCSEL1_MASK, MT6351_PMIC_RG_VSRAM_MD_CCSEL1_SHIFT},
	{PMIC_RG_VSRAM_MD_CSL, MT6351_PMIC_RG_VSRAM_MD_CSL_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_CSL_MASK, MT6351_PMIC_RG_VSRAM_MD_CSL_SHIFT},
	{PMIC_RG_VSRAM_MD_SLP, MT6351_PMIC_RG_VSRAM_MD_SLP_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_SLP_MASK, MT6351_PMIC_RG_VSRAM_MD_SLP_SHIFT},
	{PMIC_RG_VSRAM_MD_ADRC_FEN, MT6351_PMIC_RG_VSRAM_MD_ADRC_FEN_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_ADRC_FEN_MASK, MT6351_PMIC_RG_VSRAM_MD_ADRC_FEN_SHIFT},
	{PMIC_RG_VSRAM_MD_VCCAP_CLAMP_FEN, MT6351_PMIC_RG_VSRAM_MD_VCCAP_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_VCCAP_CLAMP_FEN_MASK,
	 MT6351_PMIC_RG_VSRAM_MD_VCCAP_CLAMP_FEN_SHIFT},
	{PMIC_RG_VSRAM_MD_VC_CLAMP_FEN, MT6351_PMIC_RG_VSRAM_MD_VC_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_VC_CLAMP_FEN_MASK, MT6351_PMIC_RG_VSRAM_MD_VC_CLAMP_FEN_SHIFT},
	{PMIC_RG_VSRAM_MD_PFMOC, MT6351_PMIC_RG_VSRAM_MD_PFMOC_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_PFMOC_MASK, MT6351_PMIC_RG_VSRAM_MD_PFMOC_SHIFT},
	{PMIC_RG_VSRAM_MD_CSR, MT6351_PMIC_RG_VSRAM_MD_CSR_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_CSR_MASK, MT6351_PMIC_RG_VSRAM_MD_CSR_SHIFT},
	{PMIC_RG_VSRAM_MD_ZXOS_TRIM, MT6351_PMIC_RG_VSRAM_MD_ZXOS_TRIM_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_ZXOS_TRIM_MASK, MT6351_PMIC_RG_VSRAM_MD_ZXOS_TRIM_SHIFT},
	{PMIC_RG_VSRAM_MD_PFMSR_EH, MT6351_PMIC_RG_VSRAM_MD_PFMSR_EH_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_PFMSR_EH_MASK, MT6351_PMIC_RG_VSRAM_MD_PFMSR_EH_SHIFT},
	{PMIC_RG_VSRAM_MD_NLIM_GATING, MT6351_PMIC_RG_VSRAM_MD_NLIM_GATING_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_NLIM_GATING_MASK, MT6351_PMIC_RG_VSRAM_MD_NLIM_GATING_SHIFT},
	{PMIC_RG_VSRAM_MD_PWRSR_EH, MT6351_PMIC_RG_VSRAM_MD_PWRSR_EH_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_PWRSR_EH_MASK, MT6351_PMIC_RG_VSRAM_MD_PWRSR_EH_SHIFT},
	{PMIC_RG_VSRAM_MD_HS_VTHDET, MT6351_PMIC_RG_VSRAM_MD_HS_VTHDET_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_HS_VTHDET_MASK, MT6351_PMIC_RG_VSRAM_MD_HS_VTHDET_SHIFT},
	{PMIC_RG_VSRAM_MD_PG_GATING, MT6351_PMIC_RG_VSRAM_MD_PG_GATING_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_PG_GATING_MASK, MT6351_PMIC_RG_VSRAM_MD_PG_GATING_SHIFT},
	{PMIC_RG_VSRAM_MD_HS_ONSPEED_EH, MT6351_PMIC_RG_VSRAM_MD_HS_ONSPEED_EH_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_HS_ONSPEED_EH_MASK, MT6351_PMIC_RG_VSRAM_MD_HS_ONSPEED_EH_SHIFT},
	{PMIC_RG_VSRAM_MD_NLIM_TRIMMING, MT6351_PMIC_RG_VSRAM_MD_NLIM_TRIMMING_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_NLIM_TRIMMING_MASK, MT6351_PMIC_RG_VSRAM_MD_NLIM_TRIMMING_SHIFT},
	{PMIC_RG_VSRAM_MD_DLC, MT6351_PMIC_RG_VSRAM_MD_DLC_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_DLC_MASK, MT6351_PMIC_RG_VSRAM_MD_DLC_SHIFT},
	{PMIC_RG_VSRAM_MD_DLC_N, MT6351_PMIC_RG_VSRAM_MD_DLC_N_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_DLC_N_MASK, MT6351_PMIC_RG_VSRAM_MD_DLC_N_SHIFT},
	{PMIC_RG_VSRAM_MD_PFM_RIP, MT6351_PMIC_RG_VSRAM_MD_PFM_RIP_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_PFM_RIP_MASK, MT6351_PMIC_RG_VSRAM_MD_PFM_RIP_SHIFT},
	{PMIC_RG_VSRAM_MD_TRAN_BST, MT6351_PMIC_RG_VSRAM_MD_TRAN_BST_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_TRAN_BST_MASK, MT6351_PMIC_RG_VSRAM_MD_TRAN_BST_SHIFT},
	{PMIC_RG_VSRAM_MD_DTS_ENB, MT6351_PMIC_RG_VSRAM_MD_DTS_ENB_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_DTS_ENB_MASK, MT6351_PMIC_RG_VSRAM_MD_DTS_ENB_SHIFT},
	{PMIC_RG_VSRAM_MD_MIN_OFF, MT6351_PMIC_RG_VSRAM_MD_MIN_OFF_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_MIN_OFF_MASK, MT6351_PMIC_RG_VSRAM_MD_MIN_OFF_SHIFT},
	{PMIC_RG_VSRAM_MD_1P35UP_SEL_EN, MT6351_PMIC_RG_VSRAM_MD_1P35UP_SEL_EN_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_1P35UP_SEL_EN_MASK, MT6351_PMIC_RG_VSRAM_MD_1P35UP_SEL_EN_SHIFT},
	{PMIC_RG_VSRAM_MD_DLC_AUTO_MODE, MT6351_PMIC_RG_VSRAM_MD_DLC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_DLC_AUTO_MODE_MASK, MT6351_PMIC_RG_VSRAM_MD_DLC_AUTO_MODE_SHIFT},
	{PMIC_RG_VSRAM_MD_DLC_SEL, MT6351_PMIC_RG_VSRAM_MD_DLC_SEL_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_DLC_SEL_MASK, MT6351_PMIC_RG_VSRAM_MD_DLC_SEL_SHIFT},
	{PMIC_RG_VSRAM_MD_SRC_AUTO_MODE, MT6351_PMIC_RG_VSRAM_MD_SRC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_SRC_AUTO_MODE_MASK, MT6351_PMIC_RG_VSRAM_MD_SRC_AUTO_MODE_SHIFT},
	{PMIC_RG_VSRAM_MD_UGP_SR, MT6351_PMIC_RG_VSRAM_MD_UGP_SR_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_UGP_SR_MASK, MT6351_PMIC_RG_VSRAM_MD_UGP_SR_SHIFT},
	{PMIC_RG_VSRAM_MD_LGN_SR, MT6351_PMIC_RG_VSRAM_MD_LGN_SR_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_LGN_SR_MASK, MT6351_PMIC_RG_VSRAM_MD_LGN_SR_SHIFT},
	{PMIC_RG_VSRAM_MD_UGP_SR_PFM, MT6351_PMIC_RG_VSRAM_MD_UGP_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_UGP_SR_PFM_MASK, MT6351_PMIC_RG_VSRAM_MD_UGP_SR_PFM_SHIFT},
	{PMIC_RG_VSRAM_MD_LGN_SR_PFM, MT6351_PMIC_RG_VSRAM_MD_LGN_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_LGN_SR_PFM_MASK, MT6351_PMIC_RG_VSRAM_MD_LGN_SR_PFM_SHIFT},
	{PMIC_RG_VSRAM_MD_UGD_VTHSEL, MT6351_PMIC_RG_VSRAM_MD_UGD_VTHSEL_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_UGD_VTHSEL_MASK, MT6351_PMIC_RG_VSRAM_MD_UGD_VTHSEL_SHIFT},
	{PMIC_RG_VSRAM_MD_FNLX_SNS, MT6351_PMIC_RG_VSRAM_MD_FNLX_SNS_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_FNLX_SNS_MASK, MT6351_PMIC_RG_VSRAM_MD_FNLX_SNS_SHIFT},
	{PMIC_RG_VSRAM_MD_VDIFF_ENLOWIQ, MT6351_PMIC_RG_VSRAM_MD_VDIFF_ENLOWIQ_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_VDIFF_ENLOWIQ_MASK, MT6351_PMIC_RG_VSRAM_MD_VDIFF_ENLOWIQ_SHIFT},
	{PMIC_RG_VSRAM_MD_PFMOC_FWUPOFF, MT6351_PMIC_RG_VSRAM_MD_PFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_PFMOC_FWUPOFF_MASK, MT6351_PMIC_RG_VSRAM_MD_PFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VSRAM_MD_PWFMOC_FWUPOFF, MT6351_PMIC_RG_VSRAM_MD_PWFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_PWFMOC_FWUPOFF_MASK,
	 MT6351_PMIC_RG_VSRAM_MD_PWFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VSRAM_MD_CP_FWUPOFF, MT6351_PMIC_RG_VSRAM_MD_CP_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_CP_FWUPOFF_MASK, MT6351_PMIC_RG_VSRAM_MD_CP_FWUPOFF_SHIFT},
	{PMIC_RG_VSRAM_MD_ZX_GATING, MT6351_PMIC_RG_VSRAM_MD_ZX_GATING_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_ZX_GATING_MASK, MT6351_PMIC_RG_VSRAM_MD_ZX_GATING_SHIFT},
	{PMIC_RG_VSRAM_MD_RSV, MT6351_PMIC_RG_VSRAM_MD_RSV_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_RSV_MASK, MT6351_PMIC_RG_VSRAM_MD_RSV_SHIFT},
	{PMIC_RG_VSRAM_MD_AZC_EN, MT6351_PMIC_RG_VSRAM_MD_AZC_EN_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_AZC_EN_MASK, MT6351_PMIC_RG_VSRAM_MD_AZC_EN_SHIFT},
	{PMIC_RG_VSRAM_MD_AZC_DELAY, MT6351_PMIC_RG_VSRAM_MD_AZC_DELAY_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_AZC_DELAY_MASK, MT6351_PMIC_RG_VSRAM_MD_AZC_DELAY_SHIFT},
	{PMIC_RG_VSRAM_MD_AZC_HOLD_ENB, MT6351_PMIC_RG_VSRAM_MD_AZC_HOLD_ENB_ADDR,
	 MT6351_PMIC_RG_VSRAM_MD_AZC_HOLD_ENB_MASK, MT6351_PMIC_RG_VSRAM_MD_AZC_HOLD_ENB_SHIFT},
	{PMIC_RGS_QI_VSRAM_MD_OC_STATUS, MT6351_PMIC_RGS_QI_VSRAM_MD_OC_STATUS_ADDR,
	 MT6351_PMIC_RGS_QI_VSRAM_MD_OC_STATUS_MASK, MT6351_PMIC_RGS_QI_VSRAM_MD_OC_STATUS_SHIFT},
	{PMIC_RGS_QI_VSRAM_MD_DIG_MON, MT6351_PMIC_RGS_QI_VSRAM_MD_DIG_MON_ADDR,
	 MT6351_PMIC_RGS_QI_VSRAM_MD_DIG_MON_MASK, MT6351_PMIC_RGS_QI_VSRAM_MD_DIG_MON_SHIFT},
	{PMIC_RGS_VSRAM_MD_ENPWM_STATUS, MT6351_PMIC_RGS_VSRAM_MD_ENPWM_STATUS_ADDR,
	 MT6351_PMIC_RGS_VSRAM_MD_ENPWM_STATUS_MASK, MT6351_PMIC_RGS_VSRAM_MD_ENPWM_STATUS_SHIFT},
	{PMIC_RG_VMODEM_MODESET, MT6351_PMIC_RG_VMODEM_MODESET_ADDR,
	 MT6351_PMIC_RG_VMODEM_MODESET_MASK, MT6351_PMIC_RG_VMODEM_MODESET_SHIFT},
	{PMIC_RG_VMODEM_NDIS_EN, MT6351_PMIC_RG_VMODEM_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VMODEM_NDIS_EN_MASK, MT6351_PMIC_RG_VMODEM_NDIS_EN_SHIFT},
	{PMIC_RG_VMODEM_VRF18_SSTART_EN, MT6351_PMIC_RG_VMODEM_VRF18_SSTART_EN_ADDR,
	 MT6351_PMIC_RG_VMODEM_VRF18_SSTART_EN_MASK, MT6351_PMIC_RG_VMODEM_VRF18_SSTART_EN_SHIFT},
	{PMIC_RG_VMODEM_AUTO_MODE, MT6351_PMIC_RG_VMODEM_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VMODEM_AUTO_MODE_MASK, MT6351_PMIC_RG_VMODEM_AUTO_MODE_SHIFT},
	{PMIC_RG_VMODEM_RZSEL0, MT6351_PMIC_RG_VMODEM_RZSEL0_ADDR,
	 MT6351_PMIC_RG_VMODEM_RZSEL0_MASK, MT6351_PMIC_RG_VMODEM_RZSEL0_SHIFT},
	{PMIC_RG_VMODEM_RZSEL1, MT6351_PMIC_RG_VMODEM_RZSEL1_ADDR,
	 MT6351_PMIC_RG_VMODEM_RZSEL1_MASK, MT6351_PMIC_RG_VMODEM_RZSEL1_SHIFT},
	{PMIC_RG_VMODEM_CCSEL0, MT6351_PMIC_RG_VMODEM_CCSEL0_ADDR,
	 MT6351_PMIC_RG_VMODEM_CCSEL0_MASK, MT6351_PMIC_RG_VMODEM_CCSEL0_SHIFT},
	{PMIC_RG_VMODEM_CCSEL1, MT6351_PMIC_RG_VMODEM_CCSEL1_ADDR,
	 MT6351_PMIC_RG_VMODEM_CCSEL1_MASK, MT6351_PMIC_RG_VMODEM_CCSEL1_SHIFT},
	{PMIC_RG_VMODEM_CSL, MT6351_PMIC_RG_VMODEM_CSL_ADDR,
	 MT6351_PMIC_RG_VMODEM_CSL_MASK, MT6351_PMIC_RG_VMODEM_CSL_SHIFT},
	{PMIC_RG_VMODEM_SLP, MT6351_PMIC_RG_VMODEM_SLP_ADDR,
	 MT6351_PMIC_RG_VMODEM_SLP_MASK, MT6351_PMIC_RG_VMODEM_SLP_SHIFT},
	{PMIC_RG_VMODEM_ADRC_FEN, MT6351_PMIC_RG_VMODEM_ADRC_FEN_ADDR,
	 MT6351_PMIC_RG_VMODEM_ADRC_FEN_MASK, MT6351_PMIC_RG_VMODEM_ADRC_FEN_SHIFT},
	{PMIC_RG_VMODEM_VCCAP_CLAMP_FEN, MT6351_PMIC_RG_VMODEM_VCCAP_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VMODEM_VCCAP_CLAMP_FEN_MASK, MT6351_PMIC_RG_VMODEM_VCCAP_CLAMP_FEN_SHIFT},
	{PMIC_RG_VMODEM_VC_CLAMP_FEN, MT6351_PMIC_RG_VMODEM_VC_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VMODEM_VC_CLAMP_FEN_MASK, MT6351_PMIC_RG_VMODEM_VC_CLAMP_FEN_SHIFT},
	{PMIC_RG_VMODEM_PFMOC, MT6351_PMIC_RG_VMODEM_PFMOC_ADDR,
	 MT6351_PMIC_RG_VMODEM_PFMOC_MASK, MT6351_PMIC_RG_VMODEM_PFMOC_SHIFT},
	{PMIC_RG_VMODEM_CSR, MT6351_PMIC_RG_VMODEM_CSR_ADDR,
	 MT6351_PMIC_RG_VMODEM_CSR_MASK, MT6351_PMIC_RG_VMODEM_CSR_SHIFT},
	{PMIC_RG_VMODEM_ZXOS_TRIM, MT6351_PMIC_RG_VMODEM_ZXOS_TRIM_ADDR,
	 MT6351_PMIC_RG_VMODEM_ZXOS_TRIM_MASK, MT6351_PMIC_RG_VMODEM_ZXOS_TRIM_SHIFT},
	{PMIC_RG_VMODEM_PFMSR_EH, MT6351_PMIC_RG_VMODEM_PFMSR_EH_ADDR,
	 MT6351_PMIC_RG_VMODEM_PFMSR_EH_MASK, MT6351_PMIC_RG_VMODEM_PFMSR_EH_SHIFT},
	{PMIC_RG_VMODEM_NLIM_GATING, MT6351_PMIC_RG_VMODEM_NLIM_GATING_ADDR,
	 MT6351_PMIC_RG_VMODEM_NLIM_GATING_MASK, MT6351_PMIC_RG_VMODEM_NLIM_GATING_SHIFT},
	{PMIC_RG_VMODEM_PWRSR_EH, MT6351_PMIC_RG_VMODEM_PWRSR_EH_ADDR,
	 MT6351_PMIC_RG_VMODEM_PWRSR_EH_MASK, MT6351_PMIC_RG_VMODEM_PWRSR_EH_SHIFT},
	{PMIC_RG_VMODEM_HS_VTHDET, MT6351_PMIC_RG_VMODEM_HS_VTHDET_ADDR,
	 MT6351_PMIC_RG_VMODEM_HS_VTHDET_MASK, MT6351_PMIC_RG_VMODEM_HS_VTHDET_SHIFT},
	{PMIC_RG_VMODEM_PG_GATING, MT6351_PMIC_RG_VMODEM_PG_GATING_ADDR,
	 MT6351_PMIC_RG_VMODEM_PG_GATING_MASK, MT6351_PMIC_RG_VMODEM_PG_GATING_SHIFT},
	{PMIC_RG_VMODEM_HS_ONSPEED_EH, MT6351_PMIC_RG_VMODEM_HS_ONSPEED_EH_ADDR,
	 MT6351_PMIC_RG_VMODEM_HS_ONSPEED_EH_MASK, MT6351_PMIC_RG_VMODEM_HS_ONSPEED_EH_SHIFT},
	{PMIC_RG_VMODEM_NLIM_TRIMMING, MT6351_PMIC_RG_VMODEM_NLIM_TRIMMING_ADDR,
	 MT6351_PMIC_RG_VMODEM_NLIM_TRIMMING_MASK, MT6351_PMIC_RG_VMODEM_NLIM_TRIMMING_SHIFT},
	{PMIC_RG_VMODEM_DLC, MT6351_PMIC_RG_VMODEM_DLC_ADDR,
	 MT6351_PMIC_RG_VMODEM_DLC_MASK, MT6351_PMIC_RG_VMODEM_DLC_SHIFT},
	{PMIC_RG_VMODEM_DLC_N, MT6351_PMIC_RG_VMODEM_DLC_N_ADDR,
	 MT6351_PMIC_RG_VMODEM_DLC_N_MASK, MT6351_PMIC_RG_VMODEM_DLC_N_SHIFT},
	{PMIC_RG_VMODEM_PFM_RIP, MT6351_PMIC_RG_VMODEM_PFM_RIP_ADDR,
	 MT6351_PMIC_RG_VMODEM_PFM_RIP_MASK, MT6351_PMIC_RG_VMODEM_PFM_RIP_SHIFT},
	{PMIC_RG_VMODEM_TRAN_BST, MT6351_PMIC_RG_VMODEM_TRAN_BST_ADDR,
	 MT6351_PMIC_RG_VMODEM_TRAN_BST_MASK, MT6351_PMIC_RG_VMODEM_TRAN_BST_SHIFT},
	{PMIC_RG_VMODEM_DTS_ENB, MT6351_PMIC_RG_VMODEM_DTS_ENB_ADDR,
	 MT6351_PMIC_RG_VMODEM_DTS_ENB_MASK, MT6351_PMIC_RG_VMODEM_DTS_ENB_SHIFT},
	{PMIC_RG_VMODEM_MIN_OFF, MT6351_PMIC_RG_VMODEM_MIN_OFF_ADDR,
	 MT6351_PMIC_RG_VMODEM_MIN_OFF_MASK, MT6351_PMIC_RG_VMODEM_MIN_OFF_SHIFT},
	{PMIC_RG_VMODEM_1P35UP_SEL_EN, MT6351_PMIC_RG_VMODEM_1P35UP_SEL_EN_ADDR,
	 MT6351_PMIC_RG_VMODEM_1P35UP_SEL_EN_MASK, MT6351_PMIC_RG_VMODEM_1P35UP_SEL_EN_SHIFT},
	{PMIC_RG_VMODEM_DLC_AUTO_MODE, MT6351_PMIC_RG_VMODEM_DLC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VMODEM_DLC_AUTO_MODE_MASK, MT6351_PMIC_RG_VMODEM_DLC_AUTO_MODE_SHIFT},
	{PMIC_RG_VMODEM_DLC_SEL, MT6351_PMIC_RG_VMODEM_DLC_SEL_ADDR,
	 MT6351_PMIC_RG_VMODEM_DLC_SEL_MASK, MT6351_PMIC_RG_VMODEM_DLC_SEL_SHIFT},
	{PMIC_RG_VMODEM_SRC_AUTO_MODE, MT6351_PMIC_RG_VMODEM_SRC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VMODEM_SRC_AUTO_MODE_MASK, MT6351_PMIC_RG_VMODEM_SRC_AUTO_MODE_SHIFT},
	{PMIC_RG_VMODEM_UGP_SR, MT6351_PMIC_RG_VMODEM_UGP_SR_ADDR,
	 MT6351_PMIC_RG_VMODEM_UGP_SR_MASK, MT6351_PMIC_RG_VMODEM_UGP_SR_SHIFT},
	{PMIC_RG_VMODEM_LGN_SR, MT6351_PMIC_RG_VMODEM_LGN_SR_ADDR,
	 MT6351_PMIC_RG_VMODEM_LGN_SR_MASK, MT6351_PMIC_RG_VMODEM_LGN_SR_SHIFT},
	{PMIC_RG_VMODEM_UGP_SR_PFM, MT6351_PMIC_RG_VMODEM_UGP_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VMODEM_UGP_SR_PFM_MASK, MT6351_PMIC_RG_VMODEM_UGP_SR_PFM_SHIFT},
	{PMIC_RG_VMODEM_LGN_SR_PFM, MT6351_PMIC_RG_VMODEM_LGN_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VMODEM_LGN_SR_PFM_MASK, MT6351_PMIC_RG_VMODEM_LGN_SR_PFM_SHIFT},
	{PMIC_RG_VMODEM_UGD_VTHSEL, MT6351_PMIC_RG_VMODEM_UGD_VTHSEL_ADDR,
	 MT6351_PMIC_RG_VMODEM_UGD_VTHSEL_MASK, MT6351_PMIC_RG_VMODEM_UGD_VTHSEL_SHIFT},
	{PMIC_RG_VMODEM_FNLX_SNS, MT6351_PMIC_RG_VMODEM_FNLX_SNS_ADDR,
	 MT6351_PMIC_RG_VMODEM_FNLX_SNS_MASK, MT6351_PMIC_RG_VMODEM_FNLX_SNS_SHIFT},
	{PMIC_RG_VMODEM_VDIFF_ENLOWIQ, MT6351_PMIC_RG_VMODEM_VDIFF_ENLOWIQ_ADDR,
	 MT6351_PMIC_RG_VMODEM_VDIFF_ENLOWIQ_MASK, MT6351_PMIC_RG_VMODEM_VDIFF_ENLOWIQ_SHIFT},
	{PMIC_RG_VMODEM_PFMOC_FWUPOFF, MT6351_PMIC_RG_VMODEM_PFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VMODEM_PFMOC_FWUPOFF_MASK, MT6351_PMIC_RG_VMODEM_PFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VMODEM_PWFMOC_FWUPOFF, MT6351_PMIC_RG_VMODEM_PWFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VMODEM_PWFMOC_FWUPOFF_MASK, MT6351_PMIC_RG_VMODEM_PWFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VMODEM_CP_FWUPOFF, MT6351_PMIC_RG_VMODEM_CP_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VMODEM_CP_FWUPOFF_MASK, MT6351_PMIC_RG_VMODEM_CP_FWUPOFF_SHIFT},
	{PMIC_RG_VMODEM_ZX_GATING, MT6351_PMIC_RG_VMODEM_ZX_GATING_ADDR,
	 MT6351_PMIC_RG_VMODEM_ZX_GATING_MASK, MT6351_PMIC_RG_VMODEM_ZX_GATING_SHIFT},
	{PMIC_RG_VMODEM_RSV, MT6351_PMIC_RG_VMODEM_RSV_ADDR,
	 MT6351_PMIC_RG_VMODEM_RSV_MASK, MT6351_PMIC_RG_VMODEM_RSV_SHIFT},
	{PMIC_RG_VMODEM_AZC_EN, MT6351_PMIC_RG_VMODEM_AZC_EN_ADDR,
	 MT6351_PMIC_RG_VMODEM_AZC_EN_MASK, MT6351_PMIC_RG_VMODEM_AZC_EN_SHIFT},
	{PMIC_RG_VMODEM_AZC_DELAY, MT6351_PMIC_RG_VMODEM_AZC_DELAY_ADDR,
	 MT6351_PMIC_RG_VMODEM_AZC_DELAY_MASK, MT6351_PMIC_RG_VMODEM_AZC_DELAY_SHIFT},
	{PMIC_RG_VMODEM_AZC_HOLD_ENB, MT6351_PMIC_RG_VMODEM_AZC_HOLD_ENB_ADDR,
	 MT6351_PMIC_RG_VMODEM_AZC_HOLD_ENB_MASK, MT6351_PMIC_RG_VMODEM_AZC_HOLD_ENB_SHIFT},
	{PMIC_RGS_QI_VMODEM_OC_STATUS, MT6351_PMIC_RGS_QI_VMODEM_OC_STATUS_ADDR,
	 MT6351_PMIC_RGS_QI_VMODEM_OC_STATUS_MASK, MT6351_PMIC_RGS_QI_VMODEM_OC_STATUS_SHIFT},
	{PMIC_RGS_QI_VMODEM_DIG_MON, MT6351_PMIC_RGS_QI_VMODEM_DIG_MON_ADDR,
	 MT6351_PMIC_RGS_QI_VMODEM_DIG_MON_MASK, MT6351_PMIC_RGS_QI_VMODEM_DIG_MON_SHIFT},
	{PMIC_RGS_VMODEM_ENPWM_STATUS, MT6351_PMIC_RGS_VMODEM_ENPWM_STATUS_ADDR,
	 MT6351_PMIC_RGS_VMODEM_ENPWM_STATUS_MASK, MT6351_PMIC_RGS_VMODEM_ENPWM_STATUS_SHIFT},
	{PMIC_RG_VMD1_MODESET, MT6351_PMIC_RG_VMD1_MODESET_ADDR,
	 MT6351_PMIC_RG_VMD1_MODESET_MASK, MT6351_PMIC_RG_VMD1_MODESET_SHIFT},
	{PMIC_RG_VMD1_NDIS_EN, MT6351_PMIC_RG_VMD1_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VMD1_NDIS_EN_MASK, MT6351_PMIC_RG_VMD1_NDIS_EN_SHIFT},
	{PMIC_RG_VMD1_VRF18_SSTART_EN, MT6351_PMIC_RG_VMD1_VRF18_SSTART_EN_ADDR,
	 MT6351_PMIC_RG_VMD1_VRF18_SSTART_EN_MASK, MT6351_PMIC_RG_VMD1_VRF18_SSTART_EN_SHIFT},
	{PMIC_RG_VMD1_AUTO_MODE, MT6351_PMIC_RG_VMD1_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VMD1_AUTO_MODE_MASK, MT6351_PMIC_RG_VMD1_AUTO_MODE_SHIFT},
	{PMIC_RG_VMD1_RZSEL0, MT6351_PMIC_RG_VMD1_RZSEL0_ADDR,
	 MT6351_PMIC_RG_VMD1_RZSEL0_MASK, MT6351_PMIC_RG_VMD1_RZSEL0_SHIFT},
	{PMIC_RG_VMD1_RZSEL1, MT6351_PMIC_RG_VMD1_RZSEL1_ADDR,
	 MT6351_PMIC_RG_VMD1_RZSEL1_MASK, MT6351_PMIC_RG_VMD1_RZSEL1_SHIFT},
	{PMIC_RG_VMD1_CCSEL0, MT6351_PMIC_RG_VMD1_CCSEL0_ADDR,
	 MT6351_PMIC_RG_VMD1_CCSEL0_MASK, MT6351_PMIC_RG_VMD1_CCSEL0_SHIFT},
	{PMIC_RG_VMD1_CCSEL1, MT6351_PMIC_RG_VMD1_CCSEL1_ADDR,
	 MT6351_PMIC_RG_VMD1_CCSEL1_MASK, MT6351_PMIC_RG_VMD1_CCSEL1_SHIFT},
	{PMIC_RG_VMD1_CSL, MT6351_PMIC_RG_VMD1_CSL_ADDR, MT6351_PMIC_RG_VMD1_CSL_MASK,
	 MT6351_PMIC_RG_VMD1_CSL_SHIFT},
	{PMIC_RG_VMD1_SLP, MT6351_PMIC_RG_VMD1_SLP_ADDR, MT6351_PMIC_RG_VMD1_SLP_MASK,
	 MT6351_PMIC_RG_VMD1_SLP_SHIFT},
	{PMIC_RG_VMD1_ADRC_FEN, MT6351_PMIC_RG_VMD1_ADRC_FEN_ADDR,
	 MT6351_PMIC_RG_VMD1_ADRC_FEN_MASK, MT6351_PMIC_RG_VMD1_ADRC_FEN_SHIFT},
	{PMIC_RG_VMD1_VCCAP_CLAMP_FEN, MT6351_PMIC_RG_VMD1_VCCAP_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VMD1_VCCAP_CLAMP_FEN_MASK, MT6351_PMIC_RG_VMD1_VCCAP_CLAMP_FEN_SHIFT},
	{PMIC_RG_VMD1_VC_CLAMP_FEN, MT6351_PMIC_RG_VMD1_VC_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VMD1_VC_CLAMP_FEN_MASK, MT6351_PMIC_RG_VMD1_VC_CLAMP_FEN_SHIFT},
	{PMIC_RG_VMD1_PFMOC, MT6351_PMIC_RG_VMD1_PFMOC_ADDR,
	 MT6351_PMIC_RG_VMD1_PFMOC_MASK, MT6351_PMIC_RG_VMD1_PFMOC_SHIFT},
	{PMIC_RG_VMD1_CSR, MT6351_PMIC_RG_VMD1_CSR_ADDR, MT6351_PMIC_RG_VMD1_CSR_MASK,
	 MT6351_PMIC_RG_VMD1_CSR_SHIFT},
	{PMIC_RG_VMD1_ZXOS_TRIM, MT6351_PMIC_RG_VMD1_ZXOS_TRIM_ADDR,
	 MT6351_PMIC_RG_VMD1_ZXOS_TRIM_MASK, MT6351_PMIC_RG_VMD1_ZXOS_TRIM_SHIFT},
	{PMIC_RG_VMD1_PFMSR_EH, MT6351_PMIC_RG_VMD1_PFMSR_EH_ADDR,
	 MT6351_PMIC_RG_VMD1_PFMSR_EH_MASK, MT6351_PMIC_RG_VMD1_PFMSR_EH_SHIFT},
	{PMIC_RG_VMD1_NLIM_GATING, MT6351_PMIC_RG_VMD1_NLIM_GATING_ADDR,
	 MT6351_PMIC_RG_VMD1_NLIM_GATING_MASK, MT6351_PMIC_RG_VMD1_NLIM_GATING_SHIFT},
	{PMIC_RG_VMD1_PWRSR_EH, MT6351_PMIC_RG_VMD1_PWRSR_EH_ADDR,
	 MT6351_PMIC_RG_VMD1_PWRSR_EH_MASK, MT6351_PMIC_RG_VMD1_PWRSR_EH_SHIFT},
	{PMIC_RG_VMD1_HS_VTHDET, MT6351_PMIC_RG_VMD1_HS_VTHDET_ADDR,
	 MT6351_PMIC_RG_VMD1_HS_VTHDET_MASK, MT6351_PMIC_RG_VMD1_HS_VTHDET_SHIFT},
	{PMIC_RG_VMD1_PG_GATING, MT6351_PMIC_RG_VMD1_PG_GATING_ADDR,
	 MT6351_PMIC_RG_VMD1_PG_GATING_MASK, MT6351_PMIC_RG_VMD1_PG_GATING_SHIFT},
	{PMIC_RG_VMD1_HS_ONSPEED_EH, MT6351_PMIC_RG_VMD1_HS_ONSPEED_EH_ADDR,
	 MT6351_PMIC_RG_VMD1_HS_ONSPEED_EH_MASK, MT6351_PMIC_RG_VMD1_HS_ONSPEED_EH_SHIFT},
	{PMIC_RG_VMD1_NLIM_TRIMMING, MT6351_PMIC_RG_VMD1_NLIM_TRIMMING_ADDR,
	 MT6351_PMIC_RG_VMD1_NLIM_TRIMMING_MASK, MT6351_PMIC_RG_VMD1_NLIM_TRIMMING_SHIFT},
	{PMIC_RG_VMD1_DLC, MT6351_PMIC_RG_VMD1_DLC_ADDR, MT6351_PMIC_RG_VMD1_DLC_MASK,
	 MT6351_PMIC_RG_VMD1_DLC_SHIFT},
	{PMIC_RG_VMD1_DLC_N, MT6351_PMIC_RG_VMD1_DLC_N_ADDR,
	 MT6351_PMIC_RG_VMD1_DLC_N_MASK, MT6351_PMIC_RG_VMD1_DLC_N_SHIFT},
	{PMIC_RG_VMD1_PFM_RIP, MT6351_PMIC_RG_VMD1_PFM_RIP_ADDR,
	 MT6351_PMIC_RG_VMD1_PFM_RIP_MASK, MT6351_PMIC_RG_VMD1_PFM_RIP_SHIFT},
	{PMIC_RG_VMD1_TRAN_BST, MT6351_PMIC_RG_VMD1_TRAN_BST_ADDR,
	 MT6351_PMIC_RG_VMD1_TRAN_BST_MASK, MT6351_PMIC_RG_VMD1_TRAN_BST_SHIFT},
	{PMIC_RG_VMD1_DTS_ENB, MT6351_PMIC_RG_VMD1_DTS_ENB_ADDR,
	 MT6351_PMIC_RG_VMD1_DTS_ENB_MASK, MT6351_PMIC_RG_VMD1_DTS_ENB_SHIFT},
	{PMIC_RG_VMD1_MIN_OFF, MT6351_PMIC_RG_VMD1_MIN_OFF_ADDR,
	 MT6351_PMIC_RG_VMD1_MIN_OFF_MASK, MT6351_PMIC_RG_VMD1_MIN_OFF_SHIFT},
	{PMIC_RG_VMD1_1P35UP_SEL_EN, MT6351_PMIC_RG_VMD1_1P35UP_SEL_EN_ADDR,
	 MT6351_PMIC_RG_VMD1_1P35UP_SEL_EN_MASK, MT6351_PMIC_RG_VMD1_1P35UP_SEL_EN_SHIFT},
	{PMIC_RG_VMD1_DLC_AUTO_MODE, MT6351_PMIC_RG_VMD1_DLC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VMD1_DLC_AUTO_MODE_MASK, MT6351_PMIC_RG_VMD1_DLC_AUTO_MODE_SHIFT},
	{PMIC_RG_VMD1_DLC_SEL, MT6351_PMIC_RG_VMD1_DLC_SEL_ADDR,
	 MT6351_PMIC_RG_VMD1_DLC_SEL_MASK, MT6351_PMIC_RG_VMD1_DLC_SEL_SHIFT},
	{PMIC_RG_VMD1_SRC_AUTO_MODE, MT6351_PMIC_RG_VMD1_SRC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VMD1_SRC_AUTO_MODE_MASK, MT6351_PMIC_RG_VMD1_SRC_AUTO_MODE_SHIFT},
	{PMIC_RG_VMD1_UGP_SR, MT6351_PMIC_RG_VMD1_UGP_SR_ADDR,
	 MT6351_PMIC_RG_VMD1_UGP_SR_MASK, MT6351_PMIC_RG_VMD1_UGP_SR_SHIFT},
	{PMIC_RG_VMD1_LGN_SR, MT6351_PMIC_RG_VMD1_LGN_SR_ADDR,
	 MT6351_PMIC_RG_VMD1_LGN_SR_MASK, MT6351_PMIC_RG_VMD1_LGN_SR_SHIFT},
	{PMIC_RG_VMD1_UGP_SR_PFM, MT6351_PMIC_RG_VMD1_UGP_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VMD1_UGP_SR_PFM_MASK, MT6351_PMIC_RG_VMD1_UGP_SR_PFM_SHIFT},
	{PMIC_RG_VMD1_LGN_SR_PFM, MT6351_PMIC_RG_VMD1_LGN_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VMD1_LGN_SR_PFM_MASK, MT6351_PMIC_RG_VMD1_LGN_SR_PFM_SHIFT},
	{PMIC_RG_VMD1_UGD_VTHSEL, MT6351_PMIC_RG_VMD1_UGD_VTHSEL_ADDR,
	 MT6351_PMIC_RG_VMD1_UGD_VTHSEL_MASK, MT6351_PMIC_RG_VMD1_UGD_VTHSEL_SHIFT},
	{PMIC_RG_VMD1_FNLX_SNS, MT6351_PMIC_RG_VMD1_FNLX_SNS_ADDR,
	 MT6351_PMIC_RG_VMD1_FNLX_SNS_MASK, MT6351_PMIC_RG_VMD1_FNLX_SNS_SHIFT},
	{PMIC_RG_VMD1_VDIFF_ENLOWIQ, MT6351_PMIC_RG_VMD1_VDIFF_ENLOWIQ_ADDR,
	 MT6351_PMIC_RG_VMD1_VDIFF_ENLOWIQ_MASK, MT6351_PMIC_RG_VMD1_VDIFF_ENLOWIQ_SHIFT},
	{PMIC_RG_VMD1_PFMOC_FWUPOFF, MT6351_PMIC_RG_VMD1_PFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VMD1_PFMOC_FWUPOFF_MASK, MT6351_PMIC_RG_VMD1_PFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VMD1_PWFMOC_FWUPOFF, MT6351_PMIC_RG_VMD1_PWFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VMD1_PWFMOC_FWUPOFF_MASK, MT6351_PMIC_RG_VMD1_PWFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VMD1_CP_FWUPOFF, MT6351_PMIC_RG_VMD1_CP_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VMD1_CP_FWUPOFF_MASK, MT6351_PMIC_RG_VMD1_CP_FWUPOFF_SHIFT},
	{PMIC_RG_VMD1_ZX_GATING, MT6351_PMIC_RG_VMD1_ZX_GATING_ADDR,
	 MT6351_PMIC_RG_VMD1_ZX_GATING_MASK, MT6351_PMIC_RG_VMD1_ZX_GATING_SHIFT},
	{PMIC_RG_VMD1_RSV, MT6351_PMIC_RG_VMD1_RSV_ADDR, MT6351_PMIC_RG_VMD1_RSV_MASK,
	 MT6351_PMIC_RG_VMD1_RSV_SHIFT},
	{PMIC_RG_VMD1_AZC_EN, MT6351_PMIC_RG_VMD1_AZC_EN_ADDR,
	 MT6351_PMIC_RG_VMD1_AZC_EN_MASK, MT6351_PMIC_RG_VMD1_AZC_EN_SHIFT},
	{PMIC_RG_VMD1_AZC_DELAY, MT6351_PMIC_RG_VMD1_AZC_DELAY_ADDR,
	 MT6351_PMIC_RG_VMD1_AZC_DELAY_MASK, MT6351_PMIC_RG_VMD1_AZC_DELAY_SHIFT},
	{PMIC_RG_VMD1_AZC_HOLD_ENB, MT6351_PMIC_RG_VMD1_AZC_HOLD_ENB_ADDR,
	 MT6351_PMIC_RG_VMD1_AZC_HOLD_ENB_MASK, MT6351_PMIC_RG_VMD1_AZC_HOLD_ENB_SHIFT},
	{PMIC_RGS_QI_VMD1_OC_STATUS, MT6351_PMIC_RGS_QI_VMD1_OC_STATUS_ADDR,
	 MT6351_PMIC_RGS_QI_VMD1_OC_STATUS_MASK, MT6351_PMIC_RGS_QI_VMD1_OC_STATUS_SHIFT},
	{PMIC_RGS_QI_VMD1_DIG_MON, MT6351_PMIC_RGS_QI_VMD1_DIG_MON_ADDR,
	 MT6351_PMIC_RGS_QI_VMD1_DIG_MON_MASK, MT6351_PMIC_RGS_QI_VMD1_DIG_MON_SHIFT},
	{PMIC_RGS_VMD1_ENPWM_STATUS, MT6351_PMIC_RGS_VMD1_ENPWM_STATUS_ADDR,
	 MT6351_PMIC_RGS_VMD1_ENPWM_STATUS_MASK, MT6351_PMIC_RGS_VMD1_ENPWM_STATUS_SHIFT},
	{PMIC_RG_VS1_MODESET, MT6351_PMIC_RG_VS1_MODESET_ADDR,
	 MT6351_PMIC_RG_VS1_MODESET_MASK, MT6351_PMIC_RG_VS1_MODESET_SHIFT},
	{PMIC_RG_VS1_NDIS_EN, MT6351_PMIC_RG_VS1_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VS1_NDIS_EN_MASK, MT6351_PMIC_RG_VS1_NDIS_EN_SHIFT},
	{PMIC_RG_VS1_VRF18_SSTART_EN, MT6351_PMIC_RG_VS1_VRF18_SSTART_EN_ADDR,
	 MT6351_PMIC_RG_VS1_VRF18_SSTART_EN_MASK, MT6351_PMIC_RG_VS1_VRF18_SSTART_EN_SHIFT},
	{PMIC_RG_VS1_AUTO_MODE, MT6351_PMIC_RG_VS1_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VS1_AUTO_MODE_MASK, MT6351_PMIC_RG_VS1_AUTO_MODE_SHIFT},
	{PMIC_RG_VS1_RZSEL0, MT6351_PMIC_RG_VS1_RZSEL0_ADDR,
	 MT6351_PMIC_RG_VS1_RZSEL0_MASK, MT6351_PMIC_RG_VS1_RZSEL0_SHIFT},
	{PMIC_RG_VS1_RZSEL1, MT6351_PMIC_RG_VS1_RZSEL1_ADDR,
	 MT6351_PMIC_RG_VS1_RZSEL1_MASK, MT6351_PMIC_RG_VS1_RZSEL1_SHIFT},
	{PMIC_RG_VS1_CCSEL0, MT6351_PMIC_RG_VS1_CCSEL0_ADDR,
	 MT6351_PMIC_RG_VS1_CCSEL0_MASK, MT6351_PMIC_RG_VS1_CCSEL0_SHIFT},
	{PMIC_RG_VS1_CCSEL1, MT6351_PMIC_RG_VS1_CCSEL1_ADDR,
	 MT6351_PMIC_RG_VS1_CCSEL1_MASK, MT6351_PMIC_RG_VS1_CCSEL1_SHIFT},
	{PMIC_RG_VS1_CSL, MT6351_PMIC_RG_VS1_CSL_ADDR, MT6351_PMIC_RG_VS1_CSL_MASK,
	 MT6351_PMIC_RG_VS1_CSL_SHIFT},
	{PMIC_RG_VS1_SLP, MT6351_PMIC_RG_VS1_SLP_ADDR, MT6351_PMIC_RG_VS1_SLP_MASK,
	 MT6351_PMIC_RG_VS1_SLP_SHIFT},
	{PMIC_RG_VS1_ADRC_FEN, MT6351_PMIC_RG_VS1_ADRC_FEN_ADDR,
	 MT6351_PMIC_RG_VS1_ADRC_FEN_MASK, MT6351_PMIC_RG_VS1_ADRC_FEN_SHIFT},
	{PMIC_RG_VS1_VCCAP_CLAMP_FEN, MT6351_PMIC_RG_VS1_VCCAP_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VS1_VCCAP_CLAMP_FEN_MASK, MT6351_PMIC_RG_VS1_VCCAP_CLAMP_FEN_SHIFT},
	{PMIC_RG_VS1_VC_CLAMP_FEN, MT6351_PMIC_RG_VS1_VC_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VS1_VC_CLAMP_FEN_MASK, MT6351_PMIC_RG_VS1_VC_CLAMP_FEN_SHIFT},
	{PMIC_RG_VS1_PFMOC, MT6351_PMIC_RG_VS1_PFMOC_ADDR, MT6351_PMIC_RG_VS1_PFMOC_MASK,
	 MT6351_PMIC_RG_VS1_PFMOC_SHIFT},
	{PMIC_RG_VS1_CSR, MT6351_PMIC_RG_VS1_CSR_ADDR, MT6351_PMIC_RG_VS1_CSR_MASK,
	 MT6351_PMIC_RG_VS1_CSR_SHIFT},
	{PMIC_RG_VS1_ZXOS_TRIM, MT6351_PMIC_RG_VS1_ZXOS_TRIM_ADDR,
	 MT6351_PMIC_RG_VS1_ZXOS_TRIM_MASK, MT6351_PMIC_RG_VS1_ZXOS_TRIM_SHIFT},
	{PMIC_RG_VS1_PFMSR_EH, MT6351_PMIC_RG_VS1_PFMSR_EH_ADDR,
	 MT6351_PMIC_RG_VS1_PFMSR_EH_MASK, MT6351_PMIC_RG_VS1_PFMSR_EH_SHIFT},
	{PMIC_RG_VS1_NLIM_GATING, MT6351_PMIC_RG_VS1_NLIM_GATING_ADDR,
	 MT6351_PMIC_RG_VS1_NLIM_GATING_MASK, MT6351_PMIC_RG_VS1_NLIM_GATING_SHIFT},
	{PMIC_RG_VS1_PWRSR_EH, MT6351_PMIC_RG_VS1_PWRSR_EH_ADDR,
	 MT6351_PMIC_RG_VS1_PWRSR_EH_MASK, MT6351_PMIC_RG_VS1_PWRSR_EH_SHIFT},
	{PMIC_RG_VS1_HS_VTHDET, MT6351_PMIC_RG_VS1_HS_VTHDET_ADDR,
	 MT6351_PMIC_RG_VS1_HS_VTHDET_MASK, MT6351_PMIC_RG_VS1_HS_VTHDET_SHIFT},
	{PMIC_RG_VS1_PG_GATING, MT6351_PMIC_RG_VS1_PG_GATING_ADDR,
	 MT6351_PMIC_RG_VS1_PG_GATING_MASK, MT6351_PMIC_RG_VS1_PG_GATING_SHIFT},
	{PMIC_RG_VS1_HS_ONSPEED_EH, MT6351_PMIC_RG_VS1_HS_ONSPEED_EH_ADDR,
	 MT6351_PMIC_RG_VS1_HS_ONSPEED_EH_MASK, MT6351_PMIC_RG_VS1_HS_ONSPEED_EH_SHIFT},
	{PMIC_RG_VS1_NLIM_TRIMMING, MT6351_PMIC_RG_VS1_NLIM_TRIMMING_ADDR,
	 MT6351_PMIC_RG_VS1_NLIM_TRIMMING_MASK, MT6351_PMIC_RG_VS1_NLIM_TRIMMING_SHIFT},
	{PMIC_RG_VS1_DLC, MT6351_PMIC_RG_VS1_DLC_ADDR, MT6351_PMIC_RG_VS1_DLC_MASK,
	 MT6351_PMIC_RG_VS1_DLC_SHIFT},
	{PMIC_RG_VS1_DLC_N, MT6351_PMIC_RG_VS1_DLC_N_ADDR, MT6351_PMIC_RG_VS1_DLC_N_MASK,
	 MT6351_PMIC_RG_VS1_DLC_N_SHIFT},
	{PMIC_RG_VS1_PFM_RIP, MT6351_PMIC_RG_VS1_PFM_RIP_ADDR,
	 MT6351_PMIC_RG_VS1_PFM_RIP_MASK, MT6351_PMIC_RG_VS1_PFM_RIP_SHIFT},
	{PMIC_RG_VS1_TRAN_BST, MT6351_PMIC_RG_VS1_TRAN_BST_ADDR,
	 MT6351_PMIC_RG_VS1_TRAN_BST_MASK, MT6351_PMIC_RG_VS1_TRAN_BST_SHIFT},
	{PMIC_RG_VS1_DTS_ENB, MT6351_PMIC_RG_VS1_DTS_ENB_ADDR,
	 MT6351_PMIC_RG_VS1_DTS_ENB_MASK, MT6351_PMIC_RG_VS1_DTS_ENB_SHIFT},
	{PMIC_RG_VS1_MIN_OFF, MT6351_PMIC_RG_VS1_MIN_OFF_ADDR,
	 MT6351_PMIC_RG_VS1_MIN_OFF_MASK, MT6351_PMIC_RG_VS1_MIN_OFF_SHIFT},
	{PMIC_RG_VS1_1P35UP_SEL_EN, MT6351_PMIC_RG_VS1_1P35UP_SEL_EN_ADDR,
	 MT6351_PMIC_RG_VS1_1P35UP_SEL_EN_MASK, MT6351_PMIC_RG_VS1_1P35UP_SEL_EN_SHIFT},
	{PMIC_RG_VS1_DLC_AUTO_MODE, MT6351_PMIC_RG_VS1_DLC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VS1_DLC_AUTO_MODE_MASK, MT6351_PMIC_RG_VS1_DLC_AUTO_MODE_SHIFT},
	{PMIC_RG_VS1_DLC_SEL, MT6351_PMIC_RG_VS1_DLC_SEL_ADDR,
	 MT6351_PMIC_RG_VS1_DLC_SEL_MASK, MT6351_PMIC_RG_VS1_DLC_SEL_SHIFT},
	{PMIC_RG_VS1_SRC_AUTO_MODE, MT6351_PMIC_RG_VS1_SRC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VS1_SRC_AUTO_MODE_MASK, MT6351_PMIC_RG_VS1_SRC_AUTO_MODE_SHIFT},
	{PMIC_RG_VS1_UGP_SR, MT6351_PMIC_RG_VS1_UGP_SR_ADDR,
	 MT6351_PMIC_RG_VS1_UGP_SR_MASK, MT6351_PMIC_RG_VS1_UGP_SR_SHIFT},
	{PMIC_RG_VS1_LGN_SR, MT6351_PMIC_RG_VS1_LGN_SR_ADDR,
	 MT6351_PMIC_RG_VS1_LGN_SR_MASK, MT6351_PMIC_RG_VS1_LGN_SR_SHIFT},
	{PMIC_RG_VS1_UGP_SR_PFM, MT6351_PMIC_RG_VS1_UGP_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VS1_UGP_SR_PFM_MASK, MT6351_PMIC_RG_VS1_UGP_SR_PFM_SHIFT},
	{PMIC_RG_VS1_LGN_SR_PFM, MT6351_PMIC_RG_VS1_LGN_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VS1_LGN_SR_PFM_MASK, MT6351_PMIC_RG_VS1_LGN_SR_PFM_SHIFT},
	{PMIC_RG_VS1_UGD_VTHSEL, MT6351_PMIC_RG_VS1_UGD_VTHSEL_ADDR,
	 MT6351_PMIC_RG_VS1_UGD_VTHSEL_MASK, MT6351_PMIC_RG_VS1_UGD_VTHSEL_SHIFT},
	{PMIC_RG_VS1_FNLX_SNS, MT6351_PMIC_RG_VS1_FNLX_SNS_ADDR,
	 MT6351_PMIC_RG_VS1_FNLX_SNS_MASK, MT6351_PMIC_RG_VS1_FNLX_SNS_SHIFT},
	{PMIC_RG_VS1_VDIFF_ENLOWIQ, MT6351_PMIC_RG_VS1_VDIFF_ENLOWIQ_ADDR,
	 MT6351_PMIC_RG_VS1_VDIFF_ENLOWIQ_MASK, MT6351_PMIC_RG_VS1_VDIFF_ENLOWIQ_SHIFT},
	{PMIC_RG_VS1_PFMOC_FWUPOFF, MT6351_PMIC_RG_VS1_PFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VS1_PFMOC_FWUPOFF_MASK, MT6351_PMIC_RG_VS1_PFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VS1_PWFMOC_FWUPOFF, MT6351_PMIC_RG_VS1_PWFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VS1_PWFMOC_FWUPOFF_MASK, MT6351_PMIC_RG_VS1_PWFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VS1_CP_FWUPOFF, MT6351_PMIC_RG_VS1_CP_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VS1_CP_FWUPOFF_MASK, MT6351_PMIC_RG_VS1_CP_FWUPOFF_SHIFT},
	{PMIC_RG_VS1_ZX_GATING, MT6351_PMIC_RG_VS1_ZX_GATING_ADDR,
	 MT6351_PMIC_RG_VS1_ZX_GATING_MASK, MT6351_PMIC_RG_VS1_ZX_GATING_SHIFT},
	{PMIC_RG_VS1_RSV, MT6351_PMIC_RG_VS1_RSV_ADDR, MT6351_PMIC_RG_VS1_RSV_MASK,
	 MT6351_PMIC_RG_VS1_RSV_SHIFT},
	{PMIC_RG_VS1_AZC_EN, MT6351_PMIC_RG_VS1_AZC_EN_ADDR,
	 MT6351_PMIC_RG_VS1_AZC_EN_MASK, MT6351_PMIC_RG_VS1_AZC_EN_SHIFT},
	{PMIC_RG_VS1_AZC_DELAY, MT6351_PMIC_RG_VS1_AZC_DELAY_ADDR,
	 MT6351_PMIC_RG_VS1_AZC_DELAY_MASK, MT6351_PMIC_RG_VS1_AZC_DELAY_SHIFT},
	{PMIC_RG_VS1_AZC_HOLD_ENB, MT6351_PMIC_RG_VS1_AZC_HOLD_ENB_ADDR,
	 MT6351_PMIC_RG_VS1_AZC_HOLD_ENB_MASK, MT6351_PMIC_RG_VS1_AZC_HOLD_ENB_SHIFT},
	{PMIC_RGS_QI_VS1_OC_STATUS, MT6351_PMIC_RGS_QI_VS1_OC_STATUS_ADDR,
	 MT6351_PMIC_RGS_QI_VS1_OC_STATUS_MASK, MT6351_PMIC_RGS_QI_VS1_OC_STATUS_SHIFT},
	{PMIC_RGS_QI_VS1_DIG_MON, MT6351_PMIC_RGS_QI_VS1_DIG_MON_ADDR,
	 MT6351_PMIC_RGS_QI_VS1_DIG_MON_MASK, MT6351_PMIC_RGS_QI_VS1_DIG_MON_SHIFT},
	{PMIC_RGS_VS1_ENPWM_STATUS, MT6351_PMIC_RGS_VS1_ENPWM_STATUS_ADDR,
	 MT6351_PMIC_RGS_VS1_ENPWM_STATUS_MASK, MT6351_PMIC_RGS_VS1_ENPWM_STATUS_SHIFT},
	{PMIC_RG_VS2_MODESET, MT6351_PMIC_RG_VS2_MODESET_ADDR,
	 MT6351_PMIC_RG_VS2_MODESET_MASK, MT6351_PMIC_RG_VS2_MODESET_SHIFT},
	{PMIC_RG_VS2_NDIS_EN, MT6351_PMIC_RG_VS2_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VS2_NDIS_EN_MASK, MT6351_PMIC_RG_VS2_NDIS_EN_SHIFT},
	{PMIC_RG_VS2_VRF18_SSTART_EN, MT6351_PMIC_RG_VS2_VRF18_SSTART_EN_ADDR,
	 MT6351_PMIC_RG_VS2_VRF18_SSTART_EN_MASK, MT6351_PMIC_RG_VS2_VRF18_SSTART_EN_SHIFT},
	{PMIC_RG_VS2_AUTO_MODE, MT6351_PMIC_RG_VS2_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VS2_AUTO_MODE_MASK, MT6351_PMIC_RG_VS2_AUTO_MODE_SHIFT},
	{PMIC_RG_VS2_RZSEL0, MT6351_PMIC_RG_VS2_RZSEL0_ADDR,
	 MT6351_PMIC_RG_VS2_RZSEL0_MASK, MT6351_PMIC_RG_VS2_RZSEL0_SHIFT},
	{PMIC_RG_VS2_RZSEL1, MT6351_PMIC_RG_VS2_RZSEL1_ADDR,
	 MT6351_PMIC_RG_VS2_RZSEL1_MASK, MT6351_PMIC_RG_VS2_RZSEL1_SHIFT},
	{PMIC_RG_VS2_CCSEL0, MT6351_PMIC_RG_VS2_CCSEL0_ADDR,
	 MT6351_PMIC_RG_VS2_CCSEL0_MASK, MT6351_PMIC_RG_VS2_CCSEL0_SHIFT},
	{PMIC_RG_VS2_CCSEL1, MT6351_PMIC_RG_VS2_CCSEL1_ADDR,
	 MT6351_PMIC_RG_VS2_CCSEL1_MASK, MT6351_PMIC_RG_VS2_CCSEL1_SHIFT},
	{PMIC_RG_VS2_CSL, MT6351_PMIC_RG_VS2_CSL_ADDR, MT6351_PMIC_RG_VS2_CSL_MASK,
	 MT6351_PMIC_RG_VS2_CSL_SHIFT},
	{PMIC_RG_VS2_SLP, MT6351_PMIC_RG_VS2_SLP_ADDR, MT6351_PMIC_RG_VS2_SLP_MASK,
	 MT6351_PMIC_RG_VS2_SLP_SHIFT},
	{PMIC_RG_VS2_ADRC_FEN, MT6351_PMIC_RG_VS2_ADRC_FEN_ADDR,
	 MT6351_PMIC_RG_VS2_ADRC_FEN_MASK, MT6351_PMIC_RG_VS2_ADRC_FEN_SHIFT},
	{PMIC_RG_VS2_VCCAP_CLAMP_FEN, MT6351_PMIC_RG_VS2_VCCAP_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VS2_VCCAP_CLAMP_FEN_MASK, MT6351_PMIC_RG_VS2_VCCAP_CLAMP_FEN_SHIFT},
	{PMIC_RG_VS2_VC_CLAMP_FEN, MT6351_PMIC_RG_VS2_VC_CLAMP_FEN_ADDR,
	 MT6351_PMIC_RG_VS2_VC_CLAMP_FEN_MASK, MT6351_PMIC_RG_VS2_VC_CLAMP_FEN_SHIFT},
	{PMIC_RG_VS2_PFMOC, MT6351_PMIC_RG_VS2_PFMOC_ADDR, MT6351_PMIC_RG_VS2_PFMOC_MASK,
	 MT6351_PMIC_RG_VS2_PFMOC_SHIFT},
	{PMIC_RG_VS2_CSR, MT6351_PMIC_RG_VS2_CSR_ADDR, MT6351_PMIC_RG_VS2_CSR_MASK,
	 MT6351_PMIC_RG_VS2_CSR_SHIFT},
	{PMIC_RG_VS2_ZXOS_TRIM, MT6351_PMIC_RG_VS2_ZXOS_TRIM_ADDR,
	 MT6351_PMIC_RG_VS2_ZXOS_TRIM_MASK, MT6351_PMIC_RG_VS2_ZXOS_TRIM_SHIFT},
	{PMIC_RG_VS2_PFMSR_EH, MT6351_PMIC_RG_VS2_PFMSR_EH_ADDR,
	 MT6351_PMIC_RG_VS2_PFMSR_EH_MASK, MT6351_PMIC_RG_VS2_PFMSR_EH_SHIFT},
	{PMIC_RG_VS2_NLIM_GATING, MT6351_PMIC_RG_VS2_NLIM_GATING_ADDR,
	 MT6351_PMIC_RG_VS2_NLIM_GATING_MASK, MT6351_PMIC_RG_VS2_NLIM_GATING_SHIFT},
	{PMIC_RG_VS2_PWRSR_EH, MT6351_PMIC_RG_VS2_PWRSR_EH_ADDR,
	 MT6351_PMIC_RG_VS2_PWRSR_EH_MASK, MT6351_PMIC_RG_VS2_PWRSR_EH_SHIFT},
	{PMIC_RG_VS2_HS_VTHDET, MT6351_PMIC_RG_VS2_HS_VTHDET_ADDR,
	 MT6351_PMIC_RG_VS2_HS_VTHDET_MASK, MT6351_PMIC_RG_VS2_HS_VTHDET_SHIFT},
	{PMIC_RG_VS2_PG_GATING, MT6351_PMIC_RG_VS2_PG_GATING_ADDR,
	 MT6351_PMIC_RG_VS2_PG_GATING_MASK, MT6351_PMIC_RG_VS2_PG_GATING_SHIFT},
	{PMIC_RG_VS2_HS_ONSPEED_EH, MT6351_PMIC_RG_VS2_HS_ONSPEED_EH_ADDR,
	 MT6351_PMIC_RG_VS2_HS_ONSPEED_EH_MASK, MT6351_PMIC_RG_VS2_HS_ONSPEED_EH_SHIFT},
	{PMIC_RG_VS2_NLIM_TRIMMING, MT6351_PMIC_RG_VS2_NLIM_TRIMMING_ADDR,
	 MT6351_PMIC_RG_VS2_NLIM_TRIMMING_MASK, MT6351_PMIC_RG_VS2_NLIM_TRIMMING_SHIFT},
	{PMIC_RG_VS2_DLC, MT6351_PMIC_RG_VS2_DLC_ADDR, MT6351_PMIC_RG_VS2_DLC_MASK,
	 MT6351_PMIC_RG_VS2_DLC_SHIFT},
	{PMIC_RG_VS2_DLC_N, MT6351_PMIC_RG_VS2_DLC_N_ADDR, MT6351_PMIC_RG_VS2_DLC_N_MASK,
	 MT6351_PMIC_RG_VS2_DLC_N_SHIFT},
	{PMIC_RG_VS2_PFM_RIP, MT6351_PMIC_RG_VS2_PFM_RIP_ADDR,
	 MT6351_PMIC_RG_VS2_PFM_RIP_MASK, MT6351_PMIC_RG_VS2_PFM_RIP_SHIFT},
	{PMIC_RG_VS2_TRAN_BST, MT6351_PMIC_RG_VS2_TRAN_BST_ADDR,
	 MT6351_PMIC_RG_VS2_TRAN_BST_MASK, MT6351_PMIC_RG_VS2_TRAN_BST_SHIFT},
	{PMIC_RG_VS2_DTS_ENB, MT6351_PMIC_RG_VS2_DTS_ENB_ADDR,
	 MT6351_PMIC_RG_VS2_DTS_ENB_MASK, MT6351_PMIC_RG_VS2_DTS_ENB_SHIFT},
	{PMIC_RG_VS2_MIN_OFF, MT6351_PMIC_RG_VS2_MIN_OFF_ADDR,
	 MT6351_PMIC_RG_VS2_MIN_OFF_MASK, MT6351_PMIC_RG_VS2_MIN_OFF_SHIFT},
	{PMIC_RG_VS2_1P35UP_SEL_EN, MT6351_PMIC_RG_VS2_1P35UP_SEL_EN_ADDR,
	 MT6351_PMIC_RG_VS2_1P35UP_SEL_EN_MASK, MT6351_PMIC_RG_VS2_1P35UP_SEL_EN_SHIFT},
	{PMIC_RG_VS2_DLC_AUTO_MODE, MT6351_PMIC_RG_VS2_DLC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VS2_DLC_AUTO_MODE_MASK, MT6351_PMIC_RG_VS2_DLC_AUTO_MODE_SHIFT},
	{PMIC_RG_VS2_DLC_SEL, MT6351_PMIC_RG_VS2_DLC_SEL_ADDR,
	 MT6351_PMIC_RG_VS2_DLC_SEL_MASK, MT6351_PMIC_RG_VS2_DLC_SEL_SHIFT},
	{PMIC_RG_VS2_SRC_AUTO_MODE, MT6351_PMIC_RG_VS2_SRC_AUTO_MODE_ADDR,
	 MT6351_PMIC_RG_VS2_SRC_AUTO_MODE_MASK, MT6351_PMIC_RG_VS2_SRC_AUTO_MODE_SHIFT},
	{PMIC_RG_VS2_UGP_SR, MT6351_PMIC_RG_VS2_UGP_SR_ADDR,
	 MT6351_PMIC_RG_VS2_UGP_SR_MASK, MT6351_PMIC_RG_VS2_UGP_SR_SHIFT},
	{PMIC_RG_VS2_LGN_SR, MT6351_PMIC_RG_VS2_LGN_SR_ADDR,
	 MT6351_PMIC_RG_VS2_LGN_SR_MASK, MT6351_PMIC_RG_VS2_LGN_SR_SHIFT},
	{PMIC_RG_VS2_UGP_SR_PFM, MT6351_PMIC_RG_VS2_UGP_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VS2_UGP_SR_PFM_MASK, MT6351_PMIC_RG_VS2_UGP_SR_PFM_SHIFT},
	{PMIC_RG_VS2_LGN_SR_PFM, MT6351_PMIC_RG_VS2_LGN_SR_PFM_ADDR,
	 MT6351_PMIC_RG_VS2_LGN_SR_PFM_MASK, MT6351_PMIC_RG_VS2_LGN_SR_PFM_SHIFT},
	{PMIC_RG_VS2_UGD_VTHSEL, MT6351_PMIC_RG_VS2_UGD_VTHSEL_ADDR,
	 MT6351_PMIC_RG_VS2_UGD_VTHSEL_MASK, MT6351_PMIC_RG_VS2_UGD_VTHSEL_SHIFT},
	{PMIC_RG_VS2_FNLX_SNS, MT6351_PMIC_RG_VS2_FNLX_SNS_ADDR,
	 MT6351_PMIC_RG_VS2_FNLX_SNS_MASK, MT6351_PMIC_RG_VS2_FNLX_SNS_SHIFT},
	{PMIC_RG_VS2_VDIFF_ENLOWIQ, MT6351_PMIC_RG_VS2_VDIFF_ENLOWIQ_ADDR,
	 MT6351_PMIC_RG_VS2_VDIFF_ENLOWIQ_MASK, MT6351_PMIC_RG_VS2_VDIFF_ENLOWIQ_SHIFT},
	{PMIC_RG_VS2_PFMOC_FWUPOFF, MT6351_PMIC_RG_VS2_PFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VS2_PFMOC_FWUPOFF_MASK, MT6351_PMIC_RG_VS2_PFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VS2_PWFMOC_FWUPOFF, MT6351_PMIC_RG_VS2_PWFMOC_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VS2_PWFMOC_FWUPOFF_MASK, MT6351_PMIC_RG_VS2_PWFMOC_FWUPOFF_SHIFT},
	{PMIC_RG_VS2_CP_FWUPOFF, MT6351_PMIC_RG_VS2_CP_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VS2_CP_FWUPOFF_MASK, MT6351_PMIC_RG_VS2_CP_FWUPOFF_SHIFT},
	{PMIC_RG_VS2_ZX_GATING, MT6351_PMIC_RG_VS2_ZX_GATING_ADDR,
	 MT6351_PMIC_RG_VS2_ZX_GATING_MASK, MT6351_PMIC_RG_VS2_ZX_GATING_SHIFT},
	{PMIC_RG_VS2_RSV, MT6351_PMIC_RG_VS2_RSV_ADDR, MT6351_PMIC_RG_VS2_RSV_MASK,
	 MT6351_PMIC_RG_VS2_RSV_SHIFT},
	{PMIC_RG_VS2_AZC_EN, MT6351_PMIC_RG_VS2_AZC_EN_ADDR,
	 MT6351_PMIC_RG_VS2_AZC_EN_MASK, MT6351_PMIC_RG_VS2_AZC_EN_SHIFT},
	{PMIC_RG_VS2_AZC_DELAY, MT6351_PMIC_RG_VS2_AZC_DELAY_ADDR,
	 MT6351_PMIC_RG_VS2_AZC_DELAY_MASK, MT6351_PMIC_RG_VS2_AZC_DELAY_SHIFT},
	{PMIC_RG_VS2_AZC_HOLD_ENB, MT6351_PMIC_RG_VS2_AZC_HOLD_ENB_ADDR,
	 MT6351_PMIC_RG_VS2_AZC_HOLD_ENB_MASK, MT6351_PMIC_RG_VS2_AZC_HOLD_ENB_SHIFT},
	{PMIC_RGS_QI_VS2_OC_STATUS, MT6351_PMIC_RGS_QI_VS2_OC_STATUS_ADDR,
	 MT6351_PMIC_RGS_QI_VS2_OC_STATUS_MASK, MT6351_PMIC_RGS_QI_VS2_OC_STATUS_SHIFT},
	{PMIC_RGS_QI_VS2_DIG_MON, MT6351_PMIC_RGS_QI_VS2_DIG_MON_ADDR,
	 MT6351_PMIC_RGS_QI_VS2_DIG_MON_MASK, MT6351_PMIC_RGS_QI_VS2_DIG_MON_SHIFT},
	{PMIC_RGS_VS2_ENPWM_STATUS, MT6351_PMIC_RGS_VS2_ENPWM_STATUS_ADDR,
	 MT6351_PMIC_RGS_VS2_ENPWM_STATUS_MASK, MT6351_PMIC_RGS_VS2_ENPWM_STATUS_SHIFT},
	{PMIC_RG_VPA_NDIS_EN, MT6351_PMIC_RG_VPA_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VPA_NDIS_EN_MASK, MT6351_PMIC_RG_VPA_NDIS_EN_SHIFT},
	{PMIC_RG_VPA_MODESET, MT6351_PMIC_RG_VPA_MODESET_ADDR,
	 MT6351_PMIC_RG_VPA_MODESET_MASK, MT6351_PMIC_RG_VPA_MODESET_SHIFT},
	{PMIC_RG_VPA_CC, MT6351_PMIC_RG_VPA_CC_ADDR, MT6351_PMIC_RG_VPA_CC_MASK,
	 MT6351_PMIC_RG_VPA_CC_SHIFT},
	{PMIC_RG_VPA_CSR, MT6351_PMIC_RG_VPA_CSR_ADDR, MT6351_PMIC_RG_VPA_CSR_MASK,
	 MT6351_PMIC_RG_VPA_CSR_SHIFT},
	{PMIC_RG_VPA_CSMIR, MT6351_PMIC_RG_VPA_CSMIR_ADDR, MT6351_PMIC_RG_VPA_CSMIR_MASK,
	 MT6351_PMIC_RG_VPA_CSMIR_SHIFT},
	{PMIC_RG_VPA_CSL, MT6351_PMIC_RG_VPA_CSL_ADDR, MT6351_PMIC_RG_VPA_CSL_MASK,
	 MT6351_PMIC_RG_VPA_CSL_SHIFT},
	{PMIC_RG_VPA_SLP, MT6351_PMIC_RG_VPA_SLP_ADDR, MT6351_PMIC_RG_VPA_SLP_MASK,
	 MT6351_PMIC_RG_VPA_SLP_SHIFT},
	{PMIC_RG_VPA_AZC_EN, MT6351_PMIC_RG_VPA_AZC_EN_ADDR,
	 MT6351_PMIC_RG_VPA_AZC_EN_MASK, MT6351_PMIC_RG_VPA_AZC_EN_SHIFT},
	{PMIC_RG_VPA_CP_FWUPOFF, MT6351_PMIC_RG_VPA_CP_FWUPOFF_ADDR,
	 MT6351_PMIC_RG_VPA_CP_FWUPOFF_MASK, MT6351_PMIC_RG_VPA_CP_FWUPOFF_SHIFT},
	{PMIC_RG_VPA_AZC_DELAY, MT6351_PMIC_RG_VPA_AZC_DELAY_ADDR,
	 MT6351_PMIC_RG_VPA_AZC_DELAY_MASK, MT6351_PMIC_RG_VPA_AZC_DELAY_SHIFT},
	{PMIC_RG_VPA_RZSEL, MT6351_PMIC_RG_VPA_RZSEL_ADDR, MT6351_PMIC_RG_VPA_RZSEL_MASK,
	 MT6351_PMIC_RG_VPA_RZSEL_SHIFT},
	{PMIC_RG_VPA_ZXREF, MT6351_PMIC_RG_VPA_ZXREF_ADDR, MT6351_PMIC_RG_VPA_ZXREF_MASK,
	 MT6351_PMIC_RG_VPA_ZXREF_SHIFT},
	{PMIC_RG_VPA_NLIM_SEL, MT6351_PMIC_RG_VPA_NLIM_SEL_ADDR,
	 MT6351_PMIC_RG_VPA_NLIM_SEL_MASK, MT6351_PMIC_RG_VPA_NLIM_SEL_SHIFT},
	{PMIC_RG_VPA_HZP, MT6351_PMIC_RG_VPA_HZP_ADDR, MT6351_PMIC_RG_VPA_HZP_MASK,
	 MT6351_PMIC_RG_VPA_HZP_SHIFT},
	{PMIC_RG_VPA_BWEX_GAT, MT6351_PMIC_RG_VPA_BWEX_GAT_ADDR,
	 MT6351_PMIC_RG_VPA_BWEX_GAT_MASK, MT6351_PMIC_RG_VPA_BWEX_GAT_SHIFT},
	{PMIC_RG_VPA_SLEW, MT6351_PMIC_RG_VPA_SLEW_ADDR, MT6351_PMIC_RG_VPA_SLEW_MASK,
	 MT6351_PMIC_RG_VPA_SLEW_SHIFT},
	{PMIC_RG_VPA_SLEW_NMOS, MT6351_PMIC_RG_VPA_SLEW_NMOS_ADDR,
	 MT6351_PMIC_RG_VPA_SLEW_NMOS_MASK, MT6351_PMIC_RG_VPA_SLEW_NMOS_SHIFT},
	{PMIC_RG_VPA_MIN_ON, MT6351_PMIC_RG_VPA_MIN_ON_ADDR,
	 MT6351_PMIC_RG_VPA_MIN_ON_MASK, MT6351_PMIC_RG_VPA_MIN_ON_SHIFT},
	{PMIC_RG_VPA_VBAT_DEL, MT6351_PMIC_RG_VPA_VBAT_DEL_ADDR,
	 MT6351_PMIC_RG_VPA_VBAT_DEL_MASK, MT6351_PMIC_RG_VPA_VBAT_DEL_SHIFT},
	{PMIC_RGS_VPA_AZC_VOS_SEL, MT6351_PMIC_RGS_VPA_AZC_VOS_SEL_ADDR,
	 MT6351_PMIC_RGS_VPA_AZC_VOS_SEL_MASK, MT6351_PMIC_RGS_VPA_AZC_VOS_SEL_SHIFT},
	{PMIC_RG_VPA_MIN_PK, MT6351_PMIC_RG_VPA_MIN_PK_ADDR,
	 MT6351_PMIC_RG_VPA_MIN_PK_MASK, MT6351_PMIC_RG_VPA_MIN_PK_SHIFT},
	{PMIC_RG_VPA_RSV1, MT6351_PMIC_RG_VPA_RSV1_ADDR, MT6351_PMIC_RG_VPA_RSV1_MASK,
	 MT6351_PMIC_RG_VPA_RSV1_SHIFT},
	{PMIC_RG_VPA_RSV2, MT6351_PMIC_RG_VPA_RSV2_ADDR, MT6351_PMIC_RG_VPA_RSV2_MASK,
	 MT6351_PMIC_RG_VPA_RSV2_SHIFT},
	{PMIC_RGS_QI_VPA_OC_STATUS, MT6351_PMIC_RGS_QI_VPA_OC_STATUS_ADDR,
	 MT6351_PMIC_RGS_QI_VPA_OC_STATUS_MASK, MT6351_PMIC_RGS_QI_VPA_OC_STATUS_SHIFT},
	{PMIC_BUCK_VCORE_EN_CTRL, MT6351_PMIC_BUCK_VCORE_EN_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VCORE_EN_CTRL_MASK, MT6351_PMIC_BUCK_VCORE_EN_CTRL_SHIFT},
	{PMIC_BUCK_VCORE_VOSEL_CTRL, MT6351_PMIC_BUCK_VCORE_VOSEL_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VCORE_VOSEL_CTRL_MASK, MT6351_PMIC_BUCK_VCORE_VOSEL_CTRL_SHIFT},
	{PMIC_BUCK_VCORE_EN_SEL, MT6351_PMIC_BUCK_VCORE_EN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VCORE_EN_SEL_MASK, MT6351_PMIC_BUCK_VCORE_EN_SEL_SHIFT},
	{PMIC_BUCK_VCORE_VOSEL_SEL, MT6351_PMIC_BUCK_VCORE_VOSEL_SEL_ADDR,
	 MT6351_PMIC_BUCK_VCORE_VOSEL_SEL_MASK, MT6351_PMIC_BUCK_VCORE_VOSEL_SEL_SHIFT},
	{PMIC_BUCK_VCORE_EN, MT6351_PMIC_BUCK_VCORE_EN_ADDR,
	 MT6351_PMIC_BUCK_VCORE_EN_MASK, MT6351_PMIC_BUCK_VCORE_EN_SHIFT},
	{PMIC_BUCK_VCORE_STBTD, MT6351_PMIC_BUCK_VCORE_STBTD_ADDR,
	 MT6351_PMIC_BUCK_VCORE_STBTD_MASK, MT6351_PMIC_BUCK_VCORE_STBTD_SHIFT},
	{PMIC_DA_VCORE_STB, MT6351_PMIC_DA_VCORE_STB_ADDR, MT6351_PMIC_DA_VCORE_STB_MASK,
	 MT6351_PMIC_DA_VCORE_STB_SHIFT},
	{PMIC_DA_QI_VCORE_EN, MT6351_PMIC_DA_QI_VCORE_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCORE_EN_MASK, MT6351_PMIC_DA_QI_VCORE_EN_SHIFT},
	{PMIC_BUCK_VCORE_SFCHG_FRATE, MT6351_PMIC_BUCK_VCORE_SFCHG_FRATE_ADDR,
	 MT6351_PMIC_BUCK_VCORE_SFCHG_FRATE_MASK, MT6351_PMIC_BUCK_VCORE_SFCHG_FRATE_SHIFT},
	{PMIC_BUCK_VCORE_SFCHG_FEN, MT6351_PMIC_BUCK_VCORE_SFCHG_FEN_ADDR,
	 MT6351_PMIC_BUCK_VCORE_SFCHG_FEN_MASK, MT6351_PMIC_BUCK_VCORE_SFCHG_FEN_SHIFT},
	{PMIC_BUCK_VCORE_SFCHG_RRATE, MT6351_PMIC_BUCK_VCORE_SFCHG_RRATE_ADDR,
	 MT6351_PMIC_BUCK_VCORE_SFCHG_RRATE_MASK, MT6351_PMIC_BUCK_VCORE_SFCHG_RRATE_SHIFT},
	{PMIC_BUCK_VCORE_SFCHG_REN, MT6351_PMIC_BUCK_VCORE_SFCHG_REN_ADDR,
	 MT6351_PMIC_BUCK_VCORE_SFCHG_REN_MASK, MT6351_PMIC_BUCK_VCORE_SFCHG_REN_SHIFT},
	{PMIC_BUCK_VCORE_VOSEL, MT6351_PMIC_BUCK_VCORE_VOSEL_ADDR,
	 MT6351_PMIC_BUCK_VCORE_VOSEL_MASK, MT6351_PMIC_BUCK_VCORE_VOSEL_SHIFT},
	{PMIC_BUCK_VCORE_VOSEL_ON, MT6351_PMIC_BUCK_VCORE_VOSEL_ON_ADDR,
	 MT6351_PMIC_BUCK_VCORE_VOSEL_ON_MASK, MT6351_PMIC_BUCK_VCORE_VOSEL_ON_SHIFT},
	{PMIC_BUCK_VCORE_VOSEL_SLEEP, MT6351_PMIC_BUCK_VCORE_VOSEL_SLEEP_ADDR,
	 MT6351_PMIC_BUCK_VCORE_VOSEL_SLEEP_MASK, MT6351_PMIC_BUCK_VCORE_VOSEL_SLEEP_SHIFT},
	{PMIC_DA_NI_VCORE_VOSEL, MT6351_PMIC_DA_NI_VCORE_VOSEL_ADDR,
	 MT6351_PMIC_DA_NI_VCORE_VOSEL_MASK, MT6351_PMIC_DA_NI_VCORE_VOSEL_SHIFT},
	{PMIC_DA_NI_VCORE_VOSEL_SYNC, MT6351_PMIC_DA_NI_VCORE_VOSEL_SYNC_ADDR,
	 MT6351_PMIC_DA_NI_VCORE_VOSEL_SYNC_MASK, MT6351_PMIC_DA_NI_VCORE_VOSEL_SYNC_SHIFT},
	{PMIC_BUCK_VCORE_TRANS_TD, MT6351_PMIC_BUCK_VCORE_TRANS_TD_ADDR,
	 MT6351_PMIC_BUCK_VCORE_TRANS_TD_MASK, MT6351_PMIC_BUCK_VCORE_TRANS_TD_SHIFT},
	{PMIC_BUCK_VCORE_TRANS_CTRL, MT6351_PMIC_BUCK_VCORE_TRANS_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VCORE_TRANS_CTRL_MASK, MT6351_PMIC_BUCK_VCORE_TRANS_CTRL_SHIFT},
	{PMIC_BUCK_VCORE_TRANS_ONCE, MT6351_PMIC_BUCK_VCORE_TRANS_ONCE_ADDR,
	 MT6351_PMIC_BUCK_VCORE_TRANS_ONCE_MASK, MT6351_PMIC_BUCK_VCORE_TRANS_ONCE_SHIFT},
	{PMIC_DA_QI_VCORE_DVS_EN, MT6351_PMIC_DA_QI_VCORE_DVS_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCORE_DVS_EN_MASK, MT6351_PMIC_DA_QI_VCORE_DVS_EN_SHIFT},
	{PMIC_BUCK_VCORE_VSLEEP_EN, MT6351_PMIC_BUCK_VCORE_VSLEEP_EN_ADDR,
	 MT6351_PMIC_BUCK_VCORE_VSLEEP_EN_MASK, MT6351_PMIC_BUCK_VCORE_VSLEEP_EN_SHIFT},
	{PMIC_BUCK_VCORE_R2R_PDN, MT6351_PMIC_BUCK_VCORE_R2R_PDN_ADDR,
	 MT6351_PMIC_BUCK_VCORE_R2R_PDN_MASK, MT6351_PMIC_BUCK_VCORE_R2R_PDN_SHIFT},
	{PMIC_BUCK_VCORE_VSLEEP_SEL, MT6351_PMIC_BUCK_VCORE_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_BUCK_VCORE_VSLEEP_SEL_MASK, MT6351_PMIC_BUCK_VCORE_VSLEEP_SEL_SHIFT},
	{PMIC_DA_NI_VCORE_R2R_PDN, MT6351_PMIC_DA_NI_VCORE_R2R_PDN_ADDR,
	 MT6351_PMIC_DA_NI_VCORE_R2R_PDN_MASK, MT6351_PMIC_DA_NI_VCORE_R2R_PDN_SHIFT},
	{PMIC_DA_NI_VCORE_VSLEEP_SEL, MT6351_PMIC_DA_NI_VCORE_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_DA_NI_VCORE_VSLEEP_SEL_MASK, MT6351_PMIC_DA_NI_VCORE_VSLEEP_SEL_SHIFT},
	{PMIC_BUCK_VGPU_EN_CTRL, MT6351_PMIC_BUCK_VGPU_EN_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VGPU_EN_CTRL_MASK, MT6351_PMIC_BUCK_VGPU_EN_CTRL_SHIFT},
	{PMIC_BUCK_VGPU_VOSEL_CTRL, MT6351_PMIC_BUCK_VGPU_VOSEL_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VGPU_VOSEL_CTRL_MASK, MT6351_PMIC_BUCK_VGPU_VOSEL_CTRL_SHIFT},
	{PMIC_BUCK_VGPU_EN_SEL, MT6351_PMIC_BUCK_VGPU_EN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VGPU_EN_SEL_MASK, MT6351_PMIC_BUCK_VGPU_EN_SEL_SHIFT},
	{PMIC_BUCK_VGPU_VOSEL_SEL, MT6351_PMIC_BUCK_VGPU_VOSEL_SEL_ADDR,
	 MT6351_PMIC_BUCK_VGPU_VOSEL_SEL_MASK, MT6351_PMIC_BUCK_VGPU_VOSEL_SEL_SHIFT},
	{PMIC_BUCK_VGPU_EN, MT6351_PMIC_BUCK_VGPU_EN_ADDR, MT6351_PMIC_BUCK_VGPU_EN_MASK,
	 MT6351_PMIC_BUCK_VGPU_EN_SHIFT},
	{PMIC_BUCK_VGPU_STBTD, MT6351_PMIC_BUCK_VGPU_STBTD_ADDR,
	 MT6351_PMIC_BUCK_VGPU_STBTD_MASK, MT6351_PMIC_BUCK_VGPU_STBTD_SHIFT},
	{PMIC_DA_VGPU_STB, MT6351_PMIC_DA_VGPU_STB_ADDR, MT6351_PMIC_DA_VGPU_STB_MASK,
	 MT6351_PMIC_DA_VGPU_STB_SHIFT},
	{PMIC_DA_QI_VGPU_EN, MT6351_PMIC_DA_QI_VGPU_EN_ADDR,
	 MT6351_PMIC_DA_QI_VGPU_EN_MASK, MT6351_PMIC_DA_QI_VGPU_EN_SHIFT},
	{PMIC_BUCK_VGPU_SFCHG_FRATE, MT6351_PMIC_BUCK_VGPU_SFCHG_FRATE_ADDR,
	 MT6351_PMIC_BUCK_VGPU_SFCHG_FRATE_MASK, MT6351_PMIC_BUCK_VGPU_SFCHG_FRATE_SHIFT},
	{PMIC_BUCK_VGPU_SFCHG_FEN, MT6351_PMIC_BUCK_VGPU_SFCHG_FEN_ADDR,
	 MT6351_PMIC_BUCK_VGPU_SFCHG_FEN_MASK, MT6351_PMIC_BUCK_VGPU_SFCHG_FEN_SHIFT},
	{PMIC_BUCK_VGPU_SFCHG_RRATE, MT6351_PMIC_BUCK_VGPU_SFCHG_RRATE_ADDR,
	 MT6351_PMIC_BUCK_VGPU_SFCHG_RRATE_MASK, MT6351_PMIC_BUCK_VGPU_SFCHG_RRATE_SHIFT},
	{PMIC_BUCK_VGPU_SFCHG_REN, MT6351_PMIC_BUCK_VGPU_SFCHG_REN_ADDR,
	 MT6351_PMIC_BUCK_VGPU_SFCHG_REN_MASK, MT6351_PMIC_BUCK_VGPU_SFCHG_REN_SHIFT},
	{PMIC_BUCK_VGPU_VOSEL, MT6351_PMIC_BUCK_VGPU_VOSEL_ADDR,
	 MT6351_PMIC_BUCK_VGPU_VOSEL_MASK, MT6351_PMIC_BUCK_VGPU_VOSEL_SHIFT},
	{PMIC_BUCK_VGPU_VOSEL_ON, MT6351_PMIC_BUCK_VGPU_VOSEL_ON_ADDR,
	 MT6351_PMIC_BUCK_VGPU_VOSEL_ON_MASK, MT6351_PMIC_BUCK_VGPU_VOSEL_ON_SHIFT},
	{PMIC_BUCK_VGPU_VOSEL_SLEEP, MT6351_PMIC_BUCK_VGPU_VOSEL_SLEEP_ADDR,
	 MT6351_PMIC_BUCK_VGPU_VOSEL_SLEEP_MASK, MT6351_PMIC_BUCK_VGPU_VOSEL_SLEEP_SHIFT},
	{PMIC_DA_NI_VGPU_VOSEL, MT6351_PMIC_DA_NI_VGPU_VOSEL_ADDR,
	 MT6351_PMIC_DA_NI_VGPU_VOSEL_MASK, MT6351_PMIC_DA_NI_VGPU_VOSEL_SHIFT},
	{PMIC_DA_NI_VGPU_VOSEL_SYNC, MT6351_PMIC_DA_NI_VGPU_VOSEL_SYNC_ADDR,
	 MT6351_PMIC_DA_NI_VGPU_VOSEL_SYNC_MASK, MT6351_PMIC_DA_NI_VGPU_VOSEL_SYNC_SHIFT},
	{PMIC_BUCK_VGPU_TRANS_TD, MT6351_PMIC_BUCK_VGPU_TRANS_TD_ADDR,
	 MT6351_PMIC_BUCK_VGPU_TRANS_TD_MASK, MT6351_PMIC_BUCK_VGPU_TRANS_TD_SHIFT},
	{PMIC_BUCK_VGPU_TRANS_CTRL, MT6351_PMIC_BUCK_VGPU_TRANS_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VGPU_TRANS_CTRL_MASK, MT6351_PMIC_BUCK_VGPU_TRANS_CTRL_SHIFT},
	{PMIC_BUCK_VGPU_TRANS_ONCE, MT6351_PMIC_BUCK_VGPU_TRANS_ONCE_ADDR,
	 MT6351_PMIC_BUCK_VGPU_TRANS_ONCE_MASK, MT6351_PMIC_BUCK_VGPU_TRANS_ONCE_SHIFT},
	{PMIC_DA_QI_VGPU_DVS_EN, MT6351_PMIC_DA_QI_VGPU_DVS_EN_ADDR,
	 MT6351_PMIC_DA_QI_VGPU_DVS_EN_MASK, MT6351_PMIC_DA_QI_VGPU_DVS_EN_SHIFT},
	{PMIC_BUCK_VGPU_VSLEEP_EN, MT6351_PMIC_BUCK_VGPU_VSLEEP_EN_ADDR,
	 MT6351_PMIC_BUCK_VGPU_VSLEEP_EN_MASK, MT6351_PMIC_BUCK_VGPU_VSLEEP_EN_SHIFT},
	{PMIC_BUCK_VGPU_R2R_PDN, MT6351_PMIC_BUCK_VGPU_R2R_PDN_ADDR,
	 MT6351_PMIC_BUCK_VGPU_R2R_PDN_MASK, MT6351_PMIC_BUCK_VGPU_R2R_PDN_SHIFT},
	{PMIC_BUCK_VGPU_VSLEEP_SEL, MT6351_PMIC_BUCK_VGPU_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_BUCK_VGPU_VSLEEP_SEL_MASK, MT6351_PMIC_BUCK_VGPU_VSLEEP_SEL_SHIFT},
	{PMIC_DA_NI_VGPU_R2R_PDN, MT6351_PMIC_DA_NI_VGPU_R2R_PDN_ADDR,
	 MT6351_PMIC_DA_NI_VGPU_R2R_PDN_MASK, MT6351_PMIC_DA_NI_VGPU_R2R_PDN_SHIFT},
	{PMIC_DA_NI_VGPU_VSLEEP_SEL, MT6351_PMIC_DA_NI_VGPU_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_DA_NI_VGPU_VSLEEP_SEL_MASK, MT6351_PMIC_DA_NI_VGPU_VSLEEP_SEL_SHIFT},
	{PMIC_BUCK_VMODEM_EN_CTRL, MT6351_PMIC_BUCK_VMODEM_EN_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_EN_CTRL_MASK, MT6351_PMIC_BUCK_VMODEM_EN_CTRL_SHIFT},
	{PMIC_BUCK_VMODEM_VOSEL_CTRL, MT6351_PMIC_BUCK_VMODEM_VOSEL_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_VOSEL_CTRL_MASK, MT6351_PMIC_BUCK_VMODEM_VOSEL_CTRL_SHIFT},
	{PMIC_BUCK_VMODEM_EN_SEL, MT6351_PMIC_BUCK_VMODEM_EN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_EN_SEL_MASK, MT6351_PMIC_BUCK_VMODEM_EN_SEL_SHIFT},
	{PMIC_BUCK_VMODEM_VOSEL_SEL, MT6351_PMIC_BUCK_VMODEM_VOSEL_SEL_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_VOSEL_SEL_MASK, MT6351_PMIC_BUCK_VMODEM_VOSEL_SEL_SHIFT},
	{PMIC_BUCK_VMODEM_EN, MT6351_PMIC_BUCK_VMODEM_EN_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_EN_MASK, MT6351_PMIC_BUCK_VMODEM_EN_SHIFT},
	{PMIC_BUCK_VMODEM_STBTD, MT6351_PMIC_BUCK_VMODEM_STBTD_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_STBTD_MASK, MT6351_PMIC_BUCK_VMODEM_STBTD_SHIFT},
	{PMIC_DA_VMODEM_STB, MT6351_PMIC_DA_VMODEM_STB_ADDR,
	 MT6351_PMIC_DA_VMODEM_STB_MASK, MT6351_PMIC_DA_VMODEM_STB_SHIFT},
	{PMIC_DA_QI_VMODEM_EN, MT6351_PMIC_DA_QI_VMODEM_EN_ADDR,
	 MT6351_PMIC_DA_QI_VMODEM_EN_MASK, MT6351_PMIC_DA_QI_VMODEM_EN_SHIFT},
	{PMIC_BUCK_VMODEM_SFCHG_FRATE, MT6351_PMIC_BUCK_VMODEM_SFCHG_FRATE_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_SFCHG_FRATE_MASK, MT6351_PMIC_BUCK_VMODEM_SFCHG_FRATE_SHIFT},
	{PMIC_BUCK_VMODEM_SFCHG_FEN, MT6351_PMIC_BUCK_VMODEM_SFCHG_FEN_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_SFCHG_FEN_MASK, MT6351_PMIC_BUCK_VMODEM_SFCHG_FEN_SHIFT},
	{PMIC_BUCK_VMODEM_SFCHG_RRATE, MT6351_PMIC_BUCK_VMODEM_SFCHG_RRATE_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_SFCHG_RRATE_MASK, MT6351_PMIC_BUCK_VMODEM_SFCHG_RRATE_SHIFT},
	{PMIC_BUCK_VMODEM_SFCHG_REN, MT6351_PMIC_BUCK_VMODEM_SFCHG_REN_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_SFCHG_REN_MASK, MT6351_PMIC_BUCK_VMODEM_SFCHG_REN_SHIFT},
	{PMIC_BUCK_VMODEM_VOSEL, MT6351_PMIC_BUCK_VMODEM_VOSEL_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_VOSEL_MASK, MT6351_PMIC_BUCK_VMODEM_VOSEL_SHIFT},
	{PMIC_BUCK_VMODEM_VOSEL_ON, MT6351_PMIC_BUCK_VMODEM_VOSEL_ON_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_VOSEL_ON_MASK, MT6351_PMIC_BUCK_VMODEM_VOSEL_ON_SHIFT},
	{PMIC_BUCK_VMODEM_VOSEL_SLEEP, MT6351_PMIC_BUCK_VMODEM_VOSEL_SLEEP_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_VOSEL_SLEEP_MASK, MT6351_PMIC_BUCK_VMODEM_VOSEL_SLEEP_SHIFT},
	{PMIC_DA_NI_VMODEM_VOSEL, MT6351_PMIC_DA_NI_VMODEM_VOSEL_ADDR,
	 MT6351_PMIC_DA_NI_VMODEM_VOSEL_MASK, MT6351_PMIC_DA_NI_VMODEM_VOSEL_SHIFT},
	{PMIC_DA_NI_VMODEM_VOSEL_SYNC, MT6351_PMIC_DA_NI_VMODEM_VOSEL_SYNC_ADDR,
	 MT6351_PMIC_DA_NI_VMODEM_VOSEL_SYNC_MASK, MT6351_PMIC_DA_NI_VMODEM_VOSEL_SYNC_SHIFT},
	{PMIC_BUCK_VMODEM_TRANS_TD, MT6351_PMIC_BUCK_VMODEM_TRANS_TD_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_TRANS_TD_MASK, MT6351_PMIC_BUCK_VMODEM_TRANS_TD_SHIFT},
	{PMIC_BUCK_VMODEM_TRANS_CTRL, MT6351_PMIC_BUCK_VMODEM_TRANS_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_TRANS_CTRL_MASK, MT6351_PMIC_BUCK_VMODEM_TRANS_CTRL_SHIFT},
	{PMIC_BUCK_VMODEM_TRANS_ONCE, MT6351_PMIC_BUCK_VMODEM_TRANS_ONCE_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_TRANS_ONCE_MASK, MT6351_PMIC_BUCK_VMODEM_TRANS_ONCE_SHIFT},
	{PMIC_DA_QI_VMODEM_DVS_EN, MT6351_PMIC_DA_QI_VMODEM_DVS_EN_ADDR,
	 MT6351_PMIC_DA_QI_VMODEM_DVS_EN_MASK, MT6351_PMIC_DA_QI_VMODEM_DVS_EN_SHIFT},
	{PMIC_BUCK_VMODEM_VSLEEP_EN, MT6351_PMIC_BUCK_VMODEM_VSLEEP_EN_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_VSLEEP_EN_MASK, MT6351_PMIC_BUCK_VMODEM_VSLEEP_EN_SHIFT},
	{PMIC_BUCK_VMODEM_R2R_PDN, MT6351_PMIC_BUCK_VMODEM_R2R_PDN_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_R2R_PDN_MASK, MT6351_PMIC_BUCK_VMODEM_R2R_PDN_SHIFT},
	{PMIC_BUCK_VMODEM_VSLEEP_SEL, MT6351_PMIC_BUCK_VMODEM_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_BUCK_VMODEM_VSLEEP_SEL_MASK, MT6351_PMIC_BUCK_VMODEM_VSLEEP_SEL_SHIFT},
	{PMIC_DA_NI_VMODEM_R2R_PDN, MT6351_PMIC_DA_NI_VMODEM_R2R_PDN_ADDR,
	 MT6351_PMIC_DA_NI_VMODEM_R2R_PDN_MASK, MT6351_PMIC_DA_NI_VMODEM_R2R_PDN_SHIFT},
	{PMIC_DA_NI_VMODEM_VSLEEP_SEL, MT6351_PMIC_DA_NI_VMODEM_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_DA_NI_VMODEM_VSLEEP_SEL_MASK, MT6351_PMIC_DA_NI_VMODEM_VSLEEP_SEL_SHIFT},
	{PMIC_BUCK_VMD1_EN_CTRL, MT6351_PMIC_BUCK_VMD1_EN_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VMD1_EN_CTRL_MASK, MT6351_PMIC_BUCK_VMD1_EN_CTRL_SHIFT},
	{PMIC_BUCK_VMD1_VOSEL_CTRL, MT6351_PMIC_BUCK_VMD1_VOSEL_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VMD1_VOSEL_CTRL_MASK, MT6351_PMIC_BUCK_VMD1_VOSEL_CTRL_SHIFT},
	{PMIC_BUCK_VMD1_EN_SEL, MT6351_PMIC_BUCK_VMD1_EN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VMD1_EN_SEL_MASK, MT6351_PMIC_BUCK_VMD1_EN_SEL_SHIFT},
	{PMIC_BUCK_VMD1_VOSEL_SEL, MT6351_PMIC_BUCK_VMD1_VOSEL_SEL_ADDR,
	 MT6351_PMIC_BUCK_VMD1_VOSEL_SEL_MASK, MT6351_PMIC_BUCK_VMD1_VOSEL_SEL_SHIFT},
	{PMIC_BUCK_VMD1_EN, MT6351_PMIC_BUCK_VMD1_EN_ADDR, MT6351_PMIC_BUCK_VMD1_EN_MASK,
	 MT6351_PMIC_BUCK_VMD1_EN_SHIFT},
	{PMIC_BUCK_VMD1_STBTD, MT6351_PMIC_BUCK_VMD1_STBTD_ADDR,
	 MT6351_PMIC_BUCK_VMD1_STBTD_MASK, MT6351_PMIC_BUCK_VMD1_STBTD_SHIFT},
	{PMIC_DA_VMD1_STB, MT6351_PMIC_DA_VMD1_STB_ADDR, MT6351_PMIC_DA_VMD1_STB_MASK,
	 MT6351_PMIC_DA_VMD1_STB_SHIFT},
	{PMIC_DA_QI_VMD1_EN, MT6351_PMIC_DA_QI_VMD1_EN_ADDR,
	 MT6351_PMIC_DA_QI_VMD1_EN_MASK, MT6351_PMIC_DA_QI_VMD1_EN_SHIFT},
	{PMIC_BUCK_VMD1_SFCHG_FRATE, MT6351_PMIC_BUCK_VMD1_SFCHG_FRATE_ADDR,
	 MT6351_PMIC_BUCK_VMD1_SFCHG_FRATE_MASK, MT6351_PMIC_BUCK_VMD1_SFCHG_FRATE_SHIFT},
	{PMIC_BUCK_VMD1_SFCHG_FEN, MT6351_PMIC_BUCK_VMD1_SFCHG_FEN_ADDR,
	 MT6351_PMIC_BUCK_VMD1_SFCHG_FEN_MASK, MT6351_PMIC_BUCK_VMD1_SFCHG_FEN_SHIFT},
	{PMIC_BUCK_VMD1_SFCHG_RRATE, MT6351_PMIC_BUCK_VMD1_SFCHG_RRATE_ADDR,
	 MT6351_PMIC_BUCK_VMD1_SFCHG_RRATE_MASK, MT6351_PMIC_BUCK_VMD1_SFCHG_RRATE_SHIFT},
	{PMIC_BUCK_VMD1_SFCHG_REN, MT6351_PMIC_BUCK_VMD1_SFCHG_REN_ADDR,
	 MT6351_PMIC_BUCK_VMD1_SFCHG_REN_MASK, MT6351_PMIC_BUCK_VMD1_SFCHG_REN_SHIFT},
	{PMIC_BUCK_VMD1_VOSEL, MT6351_PMIC_BUCK_VMD1_VOSEL_ADDR,
	 MT6351_PMIC_BUCK_VMD1_VOSEL_MASK, MT6351_PMIC_BUCK_VMD1_VOSEL_SHIFT},
	{PMIC_BUCK_VMD1_VOSEL_ON, MT6351_PMIC_BUCK_VMD1_VOSEL_ON_ADDR,
	 MT6351_PMIC_BUCK_VMD1_VOSEL_ON_MASK, MT6351_PMIC_BUCK_VMD1_VOSEL_ON_SHIFT},
	{PMIC_BUCK_VMD1_VOSEL_SLEEP, MT6351_PMIC_BUCK_VMD1_VOSEL_SLEEP_ADDR,
	 MT6351_PMIC_BUCK_VMD1_VOSEL_SLEEP_MASK, MT6351_PMIC_BUCK_VMD1_VOSEL_SLEEP_SHIFT},
	{PMIC_DA_NI_VMD1_VOSEL, MT6351_PMIC_DA_NI_VMD1_VOSEL_ADDR,
	 MT6351_PMIC_DA_NI_VMD1_VOSEL_MASK, MT6351_PMIC_DA_NI_VMD1_VOSEL_SHIFT},
	{PMIC_DA_NI_VMD1_VOSEL_SYNC, MT6351_PMIC_DA_NI_VMD1_VOSEL_SYNC_ADDR,
	 MT6351_PMIC_DA_NI_VMD1_VOSEL_SYNC_MASK, MT6351_PMIC_DA_NI_VMD1_VOSEL_SYNC_SHIFT},
	{PMIC_BUCK_VMD1_TRANS_TD, MT6351_PMIC_BUCK_VMD1_TRANS_TD_ADDR,
	 MT6351_PMIC_BUCK_VMD1_TRANS_TD_MASK, MT6351_PMIC_BUCK_VMD1_TRANS_TD_SHIFT},
	{PMIC_BUCK_VMD1_TRANS_CTRL, MT6351_PMIC_BUCK_VMD1_TRANS_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VMD1_TRANS_CTRL_MASK, MT6351_PMIC_BUCK_VMD1_TRANS_CTRL_SHIFT},
	{PMIC_BUCK_VMD1_TRANS_ONCE, MT6351_PMIC_BUCK_VMD1_TRANS_ONCE_ADDR,
	 MT6351_PMIC_BUCK_VMD1_TRANS_ONCE_MASK, MT6351_PMIC_BUCK_VMD1_TRANS_ONCE_SHIFT},
	{PMIC_DA_QI_VMD1_DVS_EN, MT6351_PMIC_DA_QI_VMD1_DVS_EN_ADDR,
	 MT6351_PMIC_DA_QI_VMD1_DVS_EN_MASK, MT6351_PMIC_DA_QI_VMD1_DVS_EN_SHIFT},
	{PMIC_BUCK_VMD1_VSLEEP_EN, MT6351_PMIC_BUCK_VMD1_VSLEEP_EN_ADDR,
	 MT6351_PMIC_BUCK_VMD1_VSLEEP_EN_MASK, MT6351_PMIC_BUCK_VMD1_VSLEEP_EN_SHIFT},
	{PMIC_BUCK_VMD1_R2R_PDN, MT6351_PMIC_BUCK_VMD1_R2R_PDN_ADDR,
	 MT6351_PMIC_BUCK_VMD1_R2R_PDN_MASK, MT6351_PMIC_BUCK_VMD1_R2R_PDN_SHIFT},
	{PMIC_BUCK_VMD1_VSLEEP_SEL, MT6351_PMIC_BUCK_VMD1_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_BUCK_VMD1_VSLEEP_SEL_MASK, MT6351_PMIC_BUCK_VMD1_VSLEEP_SEL_SHIFT},
	{PMIC_DA_NI_VMD1_R2R_PDN, MT6351_PMIC_DA_NI_VMD1_R2R_PDN_ADDR,
	 MT6351_PMIC_DA_NI_VMD1_R2R_PDN_MASK, MT6351_PMIC_DA_NI_VMD1_R2R_PDN_SHIFT},
	{PMIC_DA_NI_VMD1_VSLEEP_SEL, MT6351_PMIC_DA_NI_VMD1_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_DA_NI_VMD1_VSLEEP_SEL_MASK, MT6351_PMIC_DA_NI_VMD1_VSLEEP_SEL_SHIFT},
	{PMIC_BUCK_VSRAM_MD_EN_CTRL, MT6351_PMIC_BUCK_VSRAM_MD_EN_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_EN_CTRL_MASK, MT6351_PMIC_BUCK_VSRAM_MD_EN_CTRL_SHIFT},
	{PMIC_BUCK_VSRAM_MD_VOSEL_CTRL, MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_CTRL_MASK, MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_CTRL_SHIFT},
	{PMIC_BUCK_VSRAM_MD_EN_SEL, MT6351_PMIC_BUCK_VSRAM_MD_EN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_EN_SEL_MASK, MT6351_PMIC_BUCK_VSRAM_MD_EN_SEL_SHIFT},
	{PMIC_BUCK_VSRAM_MD_VOSEL_SEL, MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_SEL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_SEL_MASK, MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_SEL_SHIFT},
	{PMIC_BUCK_VSRAM_MD_EN, MT6351_PMIC_BUCK_VSRAM_MD_EN_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_EN_MASK, MT6351_PMIC_BUCK_VSRAM_MD_EN_SHIFT},
	{PMIC_BUCK_VSRAM_MD_STBTD, MT6351_PMIC_BUCK_VSRAM_MD_STBTD_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_STBTD_MASK, MT6351_PMIC_BUCK_VSRAM_MD_STBTD_SHIFT},
	{PMIC_DA_VSRAM_MD_STB, MT6351_PMIC_DA_VSRAM_MD_STB_ADDR,
	 MT6351_PMIC_DA_VSRAM_MD_STB_MASK, MT6351_PMIC_DA_VSRAM_MD_STB_SHIFT},
	{PMIC_DA_QI_VSRAM_MD_EN, MT6351_PMIC_DA_QI_VSRAM_MD_EN_ADDR,
	 MT6351_PMIC_DA_QI_VSRAM_MD_EN_MASK, MT6351_PMIC_DA_QI_VSRAM_MD_EN_SHIFT},
	{PMIC_BUCK_VSRAM_MD_SFCHG_FRATE, MT6351_PMIC_BUCK_VSRAM_MD_SFCHG_FRATE_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_SFCHG_FRATE_MASK, MT6351_PMIC_BUCK_VSRAM_MD_SFCHG_FRATE_SHIFT},
	{PMIC_BUCK_VSRAM_MD_SFCHG_FEN, MT6351_PMIC_BUCK_VSRAM_MD_SFCHG_FEN_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_SFCHG_FEN_MASK, MT6351_PMIC_BUCK_VSRAM_MD_SFCHG_FEN_SHIFT},
	{PMIC_BUCK_VSRAM_MD_SFCHG_RRATE, MT6351_PMIC_BUCK_VSRAM_MD_SFCHG_RRATE_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_SFCHG_RRATE_MASK, MT6351_PMIC_BUCK_VSRAM_MD_SFCHG_RRATE_SHIFT},
	{PMIC_BUCK_VSRAM_MD_SFCHG_REN, MT6351_PMIC_BUCK_VSRAM_MD_SFCHG_REN_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_SFCHG_REN_MASK, MT6351_PMIC_BUCK_VSRAM_MD_SFCHG_REN_SHIFT},
	{PMIC_BUCK_VSRAM_MD_VOSEL, MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_MASK, MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_SHIFT},
	{PMIC_BUCK_VSRAM_MD_VOSEL_ON, MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_ON_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_ON_MASK, MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_ON_SHIFT},
	{PMIC_BUCK_VSRAM_MD_VOSEL_SLEEP, MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_SLEEP_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_SLEEP_MASK, MT6351_PMIC_BUCK_VSRAM_MD_VOSEL_SLEEP_SHIFT},
	{PMIC_DA_NI_VSRAM_MD_VOSEL, MT6351_PMIC_DA_NI_VSRAM_MD_VOSEL_ADDR,
	 MT6351_PMIC_DA_NI_VSRAM_MD_VOSEL_MASK, MT6351_PMIC_DA_NI_VSRAM_MD_VOSEL_SHIFT},
	{PMIC_DA_NI_VSRAM_MD_VOSEL_SYNC, MT6351_PMIC_DA_NI_VSRAM_MD_VOSEL_SYNC_ADDR,
	 MT6351_PMIC_DA_NI_VSRAM_MD_VOSEL_SYNC_MASK, MT6351_PMIC_DA_NI_VSRAM_MD_VOSEL_SYNC_SHIFT},
	{PMIC_BUCK_VSRAM_MD_TRANS_TD, MT6351_PMIC_BUCK_VSRAM_MD_TRANS_TD_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_TRANS_TD_MASK, MT6351_PMIC_BUCK_VSRAM_MD_TRANS_TD_SHIFT},
	{PMIC_BUCK_VSRAM_MD_TRANS_CTRL, MT6351_PMIC_BUCK_VSRAM_MD_TRANS_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_TRANS_CTRL_MASK, MT6351_PMIC_BUCK_VSRAM_MD_TRANS_CTRL_SHIFT},
	{PMIC_BUCK_VSRAM_MD_TRANS_ONCE, MT6351_PMIC_BUCK_VSRAM_MD_TRANS_ONCE_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_TRANS_ONCE_MASK, MT6351_PMIC_BUCK_VSRAM_MD_TRANS_ONCE_SHIFT},
	{PMIC_DA_QI_VSRAM_MD_DVS_EN, MT6351_PMIC_DA_QI_VSRAM_MD_DVS_EN_ADDR,
	 MT6351_PMIC_DA_QI_VSRAM_MD_DVS_EN_MASK, MT6351_PMIC_DA_QI_VSRAM_MD_DVS_EN_SHIFT},
	{PMIC_BUCK_VSRAM_MD_VSLEEP_EN, MT6351_PMIC_BUCK_VSRAM_MD_VSLEEP_EN_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_VSLEEP_EN_MASK, MT6351_PMIC_BUCK_VSRAM_MD_VSLEEP_EN_SHIFT},
	{PMIC_BUCK_VSRAM_MD_R2R_PDN, MT6351_PMIC_BUCK_VSRAM_MD_R2R_PDN_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_R2R_PDN_MASK, MT6351_PMIC_BUCK_VSRAM_MD_R2R_PDN_SHIFT},
	{PMIC_BUCK_VSRAM_MD_VSLEEP_SEL, MT6351_PMIC_BUCK_VSRAM_MD_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_MD_VSLEEP_SEL_MASK, MT6351_PMIC_BUCK_VSRAM_MD_VSLEEP_SEL_SHIFT},
	{PMIC_DA_NI_VSRAM_MD_R2R_PDN, MT6351_PMIC_DA_NI_VSRAM_MD_R2R_PDN_ADDR,
	 MT6351_PMIC_DA_NI_VSRAM_MD_R2R_PDN_MASK, MT6351_PMIC_DA_NI_VSRAM_MD_R2R_PDN_SHIFT},
	{PMIC_DA_NI_VSRAM_MD_VSLEEP_SEL, MT6351_PMIC_DA_NI_VSRAM_MD_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_DA_NI_VSRAM_MD_VSLEEP_SEL_MASK, MT6351_PMIC_DA_NI_VSRAM_MD_VSLEEP_SEL_SHIFT},
	{PMIC_BUCK_VS1_EN_CTRL, MT6351_PMIC_BUCK_VS1_EN_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VS1_EN_CTRL_MASK, MT6351_PMIC_BUCK_VS1_EN_CTRL_SHIFT},
	{PMIC_BUCK_VS1_VOSEL_CTRL, MT6351_PMIC_BUCK_VS1_VOSEL_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VS1_VOSEL_CTRL_MASK, MT6351_PMIC_BUCK_VS1_VOSEL_CTRL_SHIFT},
	{PMIC_BUCK_VS1_EN_SEL, MT6351_PMIC_BUCK_VS1_EN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VS1_EN_SEL_MASK, MT6351_PMIC_BUCK_VS1_EN_SEL_SHIFT},
	{PMIC_BUCK_VS1_VOSEL_SEL, MT6351_PMIC_BUCK_VS1_VOSEL_SEL_ADDR,
	 MT6351_PMIC_BUCK_VS1_VOSEL_SEL_MASK, MT6351_PMIC_BUCK_VS1_VOSEL_SEL_SHIFT},
	{PMIC_BUCK_VS1_EN, MT6351_PMIC_BUCK_VS1_EN_ADDR, MT6351_PMIC_BUCK_VS1_EN_MASK,
	 MT6351_PMIC_BUCK_VS1_EN_SHIFT},
	{PMIC_BUCK_VS1_STBTD, MT6351_PMIC_BUCK_VS1_STBTD_ADDR,
	 MT6351_PMIC_BUCK_VS1_STBTD_MASK, MT6351_PMIC_BUCK_VS1_STBTD_SHIFT},
	{PMIC_DA_VS1_STB, MT6351_PMIC_DA_VS1_STB_ADDR, MT6351_PMIC_DA_VS1_STB_MASK,
	 MT6351_PMIC_DA_VS1_STB_SHIFT},
	{PMIC_DA_QI_VS1_EN, MT6351_PMIC_DA_QI_VS1_EN_ADDR, MT6351_PMIC_DA_QI_VS1_EN_MASK,
	 MT6351_PMIC_DA_QI_VS1_EN_SHIFT},
	{PMIC_BUCK_VS1_SFCHG_FRATE, MT6351_PMIC_BUCK_VS1_SFCHG_FRATE_ADDR,
	 MT6351_PMIC_BUCK_VS1_SFCHG_FRATE_MASK, MT6351_PMIC_BUCK_VS1_SFCHG_FRATE_SHIFT},
	{PMIC_BUCK_VS1_SFCHG_FEN, MT6351_PMIC_BUCK_VS1_SFCHG_FEN_ADDR,
	 MT6351_PMIC_BUCK_VS1_SFCHG_FEN_MASK, MT6351_PMIC_BUCK_VS1_SFCHG_FEN_SHIFT},
	{PMIC_BUCK_VS1_SFCHG_RRATE, MT6351_PMIC_BUCK_VS1_SFCHG_RRATE_ADDR,
	 MT6351_PMIC_BUCK_VS1_SFCHG_RRATE_MASK, MT6351_PMIC_BUCK_VS1_SFCHG_RRATE_SHIFT},
	{PMIC_BUCK_VS1_SFCHG_REN, MT6351_PMIC_BUCK_VS1_SFCHG_REN_ADDR,
	 MT6351_PMIC_BUCK_VS1_SFCHG_REN_MASK, MT6351_PMIC_BUCK_VS1_SFCHG_REN_SHIFT},
	{PMIC_BUCK_VS1_VOSEL, MT6351_PMIC_BUCK_VS1_VOSEL_ADDR,
	 MT6351_PMIC_BUCK_VS1_VOSEL_MASK, MT6351_PMIC_BUCK_VS1_VOSEL_SHIFT},
	{PMIC_BUCK_VS1_VOSEL_ON, MT6351_PMIC_BUCK_VS1_VOSEL_ON_ADDR,
	 MT6351_PMIC_BUCK_VS1_VOSEL_ON_MASK, MT6351_PMIC_BUCK_VS1_VOSEL_ON_SHIFT},
	{PMIC_BUCK_VS1_VOSEL_SLEEP, MT6351_PMIC_BUCK_VS1_VOSEL_SLEEP_ADDR,
	 MT6351_PMIC_BUCK_VS1_VOSEL_SLEEP_MASK, MT6351_PMIC_BUCK_VS1_VOSEL_SLEEP_SHIFT},
	{PMIC_DA_NI_VS1_VOSEL, MT6351_PMIC_DA_NI_VS1_VOSEL_ADDR,
	 MT6351_PMIC_DA_NI_VS1_VOSEL_MASK, MT6351_PMIC_DA_NI_VS1_VOSEL_SHIFT},
	{PMIC_DA_NI_VS1_VOSEL_SYNC, MT6351_PMIC_DA_NI_VS1_VOSEL_SYNC_ADDR,
	 MT6351_PMIC_DA_NI_VS1_VOSEL_SYNC_MASK, MT6351_PMIC_DA_NI_VS1_VOSEL_SYNC_SHIFT},
	{PMIC_BUCK_VS1_TRANS_TD, MT6351_PMIC_BUCK_VS1_TRANS_TD_ADDR,
	 MT6351_PMIC_BUCK_VS1_TRANS_TD_MASK, MT6351_PMIC_BUCK_VS1_TRANS_TD_SHIFT},
	{PMIC_BUCK_VS1_TRANS_CTRL, MT6351_PMIC_BUCK_VS1_TRANS_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VS1_TRANS_CTRL_MASK, MT6351_PMIC_BUCK_VS1_TRANS_CTRL_SHIFT},
	{PMIC_BUCK_VS1_TRANS_ONCE, MT6351_PMIC_BUCK_VS1_TRANS_ONCE_ADDR,
	 MT6351_PMIC_BUCK_VS1_TRANS_ONCE_MASK, MT6351_PMIC_BUCK_VS1_TRANS_ONCE_SHIFT},
	{PMIC_DA_QI_VS1_DVS_EN, MT6351_PMIC_DA_QI_VS1_DVS_EN_ADDR,
	 MT6351_PMIC_DA_QI_VS1_DVS_EN_MASK, MT6351_PMIC_DA_QI_VS1_DVS_EN_SHIFT},
	{PMIC_BUCK_VS1_VSLEEP_EN, MT6351_PMIC_BUCK_VS1_VSLEEP_EN_ADDR,
	 MT6351_PMIC_BUCK_VS1_VSLEEP_EN_MASK, MT6351_PMIC_BUCK_VS1_VSLEEP_EN_SHIFT},
	{PMIC_BUCK_VS1_R2R_PDN, MT6351_PMIC_BUCK_VS1_R2R_PDN_ADDR,
	 MT6351_PMIC_BUCK_VS1_R2R_PDN_MASK, MT6351_PMIC_BUCK_VS1_R2R_PDN_SHIFT},
	{PMIC_BUCK_VS1_VSLEEP_SEL, MT6351_PMIC_BUCK_VS1_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_BUCK_VS1_VSLEEP_SEL_MASK, MT6351_PMIC_BUCK_VS1_VSLEEP_SEL_SHIFT},
	{PMIC_DA_NI_VS1_R2R_PDN, MT6351_PMIC_DA_NI_VS1_R2R_PDN_ADDR,
	 MT6351_PMIC_DA_NI_VS1_R2R_PDN_MASK, MT6351_PMIC_DA_NI_VS1_R2R_PDN_SHIFT},
	{PMIC_DA_NI_VS1_VSLEEP_SEL, MT6351_PMIC_DA_NI_VS1_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_DA_NI_VS1_VSLEEP_SEL_MASK, MT6351_PMIC_DA_NI_VS1_VSLEEP_SEL_SHIFT},
	{PMIC_BUCK_VS2_EN_CTRL, MT6351_PMIC_BUCK_VS2_EN_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VS2_EN_CTRL_MASK, MT6351_PMIC_BUCK_VS2_EN_CTRL_SHIFT},
	{PMIC_BUCK_VS2_VOSEL_CTRL, MT6351_PMIC_BUCK_VS2_VOSEL_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VS2_VOSEL_CTRL_MASK, MT6351_PMIC_BUCK_VS2_VOSEL_CTRL_SHIFT},
	{PMIC_BUCK_VS2_EN_SEL, MT6351_PMIC_BUCK_VS2_EN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VS2_EN_SEL_MASK, MT6351_PMIC_BUCK_VS2_EN_SEL_SHIFT},
	{PMIC_BUCK_VS2_VOSEL_SEL, MT6351_PMIC_BUCK_VS2_VOSEL_SEL_ADDR,
	 MT6351_PMIC_BUCK_VS2_VOSEL_SEL_MASK, MT6351_PMIC_BUCK_VS2_VOSEL_SEL_SHIFT},
	{PMIC_BUCK_VS2_EN, MT6351_PMIC_BUCK_VS2_EN_ADDR, MT6351_PMIC_BUCK_VS2_EN_MASK,
	 MT6351_PMIC_BUCK_VS2_EN_SHIFT},
	{PMIC_BUCK_VS2_STBTD, MT6351_PMIC_BUCK_VS2_STBTD_ADDR,
	 MT6351_PMIC_BUCK_VS2_STBTD_MASK, MT6351_PMIC_BUCK_VS2_STBTD_SHIFT},
	{PMIC_DA_VS2_STB, MT6351_PMIC_DA_VS2_STB_ADDR, MT6351_PMIC_DA_VS2_STB_MASK,
	 MT6351_PMIC_DA_VS2_STB_SHIFT},
	{PMIC_DA_QI_VS2_EN, MT6351_PMIC_DA_QI_VS2_EN_ADDR, MT6351_PMIC_DA_QI_VS2_EN_MASK,
	 MT6351_PMIC_DA_QI_VS2_EN_SHIFT},
	{PMIC_BUCK_VS2_SFCHG_FRATE, MT6351_PMIC_BUCK_VS2_SFCHG_FRATE_ADDR,
	 MT6351_PMIC_BUCK_VS2_SFCHG_FRATE_MASK, MT6351_PMIC_BUCK_VS2_SFCHG_FRATE_SHIFT},
	{PMIC_BUCK_VS2_SFCHG_FEN, MT6351_PMIC_BUCK_VS2_SFCHG_FEN_ADDR,
	 MT6351_PMIC_BUCK_VS2_SFCHG_FEN_MASK, MT6351_PMIC_BUCK_VS2_SFCHG_FEN_SHIFT},
	{PMIC_BUCK_VS2_SFCHG_RRATE, MT6351_PMIC_BUCK_VS2_SFCHG_RRATE_ADDR,
	 MT6351_PMIC_BUCK_VS2_SFCHG_RRATE_MASK, MT6351_PMIC_BUCK_VS2_SFCHG_RRATE_SHIFT},
	{PMIC_BUCK_VS2_SFCHG_REN, MT6351_PMIC_BUCK_VS2_SFCHG_REN_ADDR,
	 MT6351_PMIC_BUCK_VS2_SFCHG_REN_MASK, MT6351_PMIC_BUCK_VS2_SFCHG_REN_SHIFT},
	{PMIC_BUCK_VS2_VOSEL, MT6351_PMIC_BUCK_VS2_VOSEL_ADDR,
	 MT6351_PMIC_BUCK_VS2_VOSEL_MASK, MT6351_PMIC_BUCK_VS2_VOSEL_SHIFT},
	{PMIC_BUCK_VS2_VOSEL_ON, MT6351_PMIC_BUCK_VS2_VOSEL_ON_ADDR,
	 MT6351_PMIC_BUCK_VS2_VOSEL_ON_MASK, MT6351_PMIC_BUCK_VS2_VOSEL_ON_SHIFT},
	{PMIC_BUCK_VS2_VOSEL_SLEEP, MT6351_PMIC_BUCK_VS2_VOSEL_SLEEP_ADDR,
	 MT6351_PMIC_BUCK_VS2_VOSEL_SLEEP_MASK, MT6351_PMIC_BUCK_VS2_VOSEL_SLEEP_SHIFT},
	{PMIC_DA_NI_VS2_VOSEL, MT6351_PMIC_DA_NI_VS2_VOSEL_ADDR,
	 MT6351_PMIC_DA_NI_VS2_VOSEL_MASK, MT6351_PMIC_DA_NI_VS2_VOSEL_SHIFT},
	{PMIC_DA_NI_VS2_VOSEL_SYNC, MT6351_PMIC_DA_NI_VS2_VOSEL_SYNC_ADDR,
	 MT6351_PMIC_DA_NI_VS2_VOSEL_SYNC_MASK, MT6351_PMIC_DA_NI_VS2_VOSEL_SYNC_SHIFT},
	{PMIC_BUCK_VS2_TRANS_TD, MT6351_PMIC_BUCK_VS2_TRANS_TD_ADDR,
	 MT6351_PMIC_BUCK_VS2_TRANS_TD_MASK, MT6351_PMIC_BUCK_VS2_TRANS_TD_SHIFT},
	{PMIC_BUCK_VS2_TRANS_CTRL, MT6351_PMIC_BUCK_VS2_TRANS_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VS2_TRANS_CTRL_MASK, MT6351_PMIC_BUCK_VS2_TRANS_CTRL_SHIFT},
	{PMIC_BUCK_VS2_TRANS_ONCE, MT6351_PMIC_BUCK_VS2_TRANS_ONCE_ADDR,
	 MT6351_PMIC_BUCK_VS2_TRANS_ONCE_MASK, MT6351_PMIC_BUCK_VS2_TRANS_ONCE_SHIFT},
	{PMIC_DA_QI_VS2_DVS_EN, MT6351_PMIC_DA_QI_VS2_DVS_EN_ADDR,
	 MT6351_PMIC_DA_QI_VS2_DVS_EN_MASK, MT6351_PMIC_DA_QI_VS2_DVS_EN_SHIFT},
	{PMIC_BUCK_VS2_VSLEEP_EN, MT6351_PMIC_BUCK_VS2_VSLEEP_EN_ADDR,
	 MT6351_PMIC_BUCK_VS2_VSLEEP_EN_MASK, MT6351_PMIC_BUCK_VS2_VSLEEP_EN_SHIFT},
	{PMIC_BUCK_VS2_R2R_PDN, MT6351_PMIC_BUCK_VS2_R2R_PDN_ADDR,
	 MT6351_PMIC_BUCK_VS2_R2R_PDN_MASK, MT6351_PMIC_BUCK_VS2_R2R_PDN_SHIFT},
	{PMIC_BUCK_VS2_VSLEEP_SEL, MT6351_PMIC_BUCK_VS2_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_BUCK_VS2_VSLEEP_SEL_MASK, MT6351_PMIC_BUCK_VS2_VSLEEP_SEL_SHIFT},
	{PMIC_DA_NI_VS2_R2R_PDN, MT6351_PMIC_DA_NI_VS2_R2R_PDN_ADDR,
	 MT6351_PMIC_DA_NI_VS2_R2R_PDN_MASK, MT6351_PMIC_DA_NI_VS2_R2R_PDN_SHIFT},
	{PMIC_DA_NI_VS2_VSLEEP_SEL, MT6351_PMIC_DA_NI_VS2_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_DA_NI_VS2_VSLEEP_SEL_MASK, MT6351_PMIC_DA_NI_VS2_VSLEEP_SEL_SHIFT},
	{PMIC_BUCK_VPA_EN_CTRL, MT6351_PMIC_BUCK_VPA_EN_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VPA_EN_CTRL_MASK, MT6351_PMIC_BUCK_VPA_EN_CTRL_SHIFT},
	{PMIC_BUCK_VPA_VOSEL_CTRL, MT6351_PMIC_BUCK_VPA_VOSEL_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VPA_VOSEL_CTRL_MASK, MT6351_PMIC_BUCK_VPA_VOSEL_CTRL_SHIFT},
	{PMIC_BUCK_VPA_EN_SEL, MT6351_PMIC_BUCK_VPA_EN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VPA_EN_SEL_MASK, MT6351_PMIC_BUCK_VPA_EN_SEL_SHIFT},
	{PMIC_BUCK_VPA_VOSEL_SEL, MT6351_PMIC_BUCK_VPA_VOSEL_SEL_ADDR,
	 MT6351_PMIC_BUCK_VPA_VOSEL_SEL_MASK, MT6351_PMIC_BUCK_VPA_VOSEL_SEL_SHIFT},
	{PMIC_BUCK_VPA_EN, MT6351_PMIC_BUCK_VPA_EN_ADDR, MT6351_PMIC_BUCK_VPA_EN_MASK,
	 MT6351_PMIC_BUCK_VPA_EN_SHIFT},
	{PMIC_BUCK_VPA_STBTD, MT6351_PMIC_BUCK_VPA_STBTD_ADDR,
	 MT6351_PMIC_BUCK_VPA_STBTD_MASK, MT6351_PMIC_BUCK_VPA_STBTD_SHIFT},
	{PMIC_DA_VPA_STB, MT6351_PMIC_DA_VPA_STB_ADDR, MT6351_PMIC_DA_VPA_STB_MASK,
	 MT6351_PMIC_DA_VPA_STB_SHIFT},
	{PMIC_DA_QI_VPA_EN, MT6351_PMIC_DA_QI_VPA_EN_ADDR, MT6351_PMIC_DA_QI_VPA_EN_MASK,
	 MT6351_PMIC_DA_QI_VPA_EN_SHIFT},
	{PMIC_BUCK_VPA_SFCHG_FRATE, MT6351_PMIC_BUCK_VPA_SFCHG_FRATE_ADDR,
	 MT6351_PMIC_BUCK_VPA_SFCHG_FRATE_MASK, MT6351_PMIC_BUCK_VPA_SFCHG_FRATE_SHIFT},
	{PMIC_BUCK_VPA_SFCHG_FEN, MT6351_PMIC_BUCK_VPA_SFCHG_FEN_ADDR,
	 MT6351_PMIC_BUCK_VPA_SFCHG_FEN_MASK, MT6351_PMIC_BUCK_VPA_SFCHG_FEN_SHIFT},
	{PMIC_BUCK_VPA_SFCHG_RRATE, MT6351_PMIC_BUCK_VPA_SFCHG_RRATE_ADDR,
	 MT6351_PMIC_BUCK_VPA_SFCHG_RRATE_MASK, MT6351_PMIC_BUCK_VPA_SFCHG_RRATE_SHIFT},
	{PMIC_BUCK_VPA_SFCHG_REN, MT6351_PMIC_BUCK_VPA_SFCHG_REN_ADDR,
	 MT6351_PMIC_BUCK_VPA_SFCHG_REN_MASK, MT6351_PMIC_BUCK_VPA_SFCHG_REN_SHIFT},
	{PMIC_BUCK_VPA_VOSEL, MT6351_PMIC_BUCK_VPA_VOSEL_ADDR,
	 MT6351_PMIC_BUCK_VPA_VOSEL_MASK, MT6351_PMIC_BUCK_VPA_VOSEL_SHIFT},
	{PMIC_BUCK_VPA_VOSEL_ON, MT6351_PMIC_BUCK_VPA_VOSEL_ON_ADDR,
	 MT6351_PMIC_BUCK_VPA_VOSEL_ON_MASK, MT6351_PMIC_BUCK_VPA_VOSEL_ON_SHIFT},
	{PMIC_BUCK_VPA_VOSEL_SLEEP, MT6351_PMIC_BUCK_VPA_VOSEL_SLEEP_ADDR,
	 MT6351_PMIC_BUCK_VPA_VOSEL_SLEEP_MASK, MT6351_PMIC_BUCK_VPA_VOSEL_SLEEP_SHIFT},
	{PMIC_DA_NI_VPA_VOSEL_GRAY, MT6351_PMIC_DA_NI_VPA_VOSEL_GRAY_ADDR,
	 MT6351_PMIC_DA_NI_VPA_VOSEL_GRAY_MASK, MT6351_PMIC_DA_NI_VPA_VOSEL_GRAY_SHIFT},
	{PMIC_DA_NI_VPA_VOSEL_SYNC, MT6351_PMIC_DA_NI_VPA_VOSEL_SYNC_ADDR,
	 MT6351_PMIC_DA_NI_VPA_VOSEL_SYNC_MASK, MT6351_PMIC_DA_NI_VPA_VOSEL_SYNC_SHIFT},
	{PMIC_BUCK_VPA_TRANS_TD, MT6351_PMIC_BUCK_VPA_TRANS_TD_ADDR,
	 MT6351_PMIC_BUCK_VPA_TRANS_TD_MASK, MT6351_PMIC_BUCK_VPA_TRANS_TD_SHIFT},
	{PMIC_BUCK_VPA_TRANS_CTRL, MT6351_PMIC_BUCK_VPA_TRANS_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VPA_TRANS_CTRL_MASK, MT6351_PMIC_BUCK_VPA_TRANS_CTRL_SHIFT},
	{PMIC_BUCK_VPA_TRANS_ONCE, MT6351_PMIC_BUCK_VPA_TRANS_ONCE_ADDR,
	 MT6351_PMIC_BUCK_VPA_TRANS_ONCE_MASK, MT6351_PMIC_BUCK_VPA_TRANS_ONCE_SHIFT},
	{PMIC_DA_QI_VPA_DVS_EN, MT6351_PMIC_DA_QI_VPA_DVS_EN_ADDR,
	 MT6351_PMIC_DA_QI_VPA_DVS_EN_MASK, MT6351_PMIC_DA_QI_VPA_DVS_EN_SHIFT},
	{PMIC_BUCK_VPA_VSLEEP_EN, MT6351_PMIC_BUCK_VPA_VSLEEP_EN_ADDR,
	 MT6351_PMIC_BUCK_VPA_VSLEEP_EN_MASK, MT6351_PMIC_BUCK_VPA_VSLEEP_EN_SHIFT},
	{PMIC_BUCK_VPA_R2R_PDN, MT6351_PMIC_BUCK_VPA_R2R_PDN_ADDR,
	 MT6351_PMIC_BUCK_VPA_R2R_PDN_MASK, MT6351_PMIC_BUCK_VPA_R2R_PDN_SHIFT},
	{PMIC_BUCK_VPA_VSLEEP_SEL, MT6351_PMIC_BUCK_VPA_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_BUCK_VPA_VSLEEP_SEL_MASK, MT6351_PMIC_BUCK_VPA_VSLEEP_SEL_SHIFT},
	{PMIC_DA_NI_VPA_R2R_PDN, MT6351_PMIC_DA_NI_VPA_R2R_PDN_ADDR,
	 MT6351_PMIC_DA_NI_VPA_R2R_PDN_MASK, MT6351_PMIC_DA_NI_VPA_R2R_PDN_SHIFT},
	{PMIC_DA_NI_VPA_VSLEEP_SEL, MT6351_PMIC_DA_NI_VPA_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_DA_NI_VPA_VSLEEP_SEL_MASK, MT6351_PMIC_DA_NI_VPA_VSLEEP_SEL_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_EN_CTRL, MT6351_PMIC_BUCK_VSRAM_PROC_EN_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_EN_CTRL_MASK, MT6351_PMIC_BUCK_VSRAM_PROC_EN_CTRL_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_VOSEL_CTRL, MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_CTRL_MASK,
	 MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_CTRL_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_EN_SEL, MT6351_PMIC_BUCK_VSRAM_PROC_EN_SEL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_EN_SEL_MASK, MT6351_PMIC_BUCK_VSRAM_PROC_EN_SEL_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_VOSEL_SEL, MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_SEL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_SEL_MASK, MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_SEL_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_EN, MT6351_PMIC_BUCK_VSRAM_PROC_EN_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_EN_MASK, MT6351_PMIC_BUCK_VSRAM_PROC_EN_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_STBTD, MT6351_PMIC_BUCK_VSRAM_PROC_STBTD_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_STBTD_MASK, MT6351_PMIC_BUCK_VSRAM_PROC_STBTD_SHIFT},
	{PMIC_DA_VSRAM_PROC_STB, MT6351_PMIC_DA_VSRAM_PROC_STB_ADDR,
	 MT6351_PMIC_DA_VSRAM_PROC_STB_MASK, MT6351_PMIC_DA_VSRAM_PROC_STB_SHIFT},
	{PMIC_DA_QI_VSRAM_PROC_EN_RSV, MT6351_PMIC_DA_QI_VSRAM_PROC_EN_RSV_ADDR,
	 MT6351_PMIC_DA_QI_VSRAM_PROC_EN_RSV_MASK, MT6351_PMIC_DA_QI_VSRAM_PROC_EN_RSV_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_SFCHG_FRATE, MT6351_PMIC_BUCK_VSRAM_PROC_SFCHG_FRATE_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_SFCHG_FRATE_MASK,
	 MT6351_PMIC_BUCK_VSRAM_PROC_SFCHG_FRATE_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_SFCHG_FEN, MT6351_PMIC_BUCK_VSRAM_PROC_SFCHG_FEN_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_SFCHG_FEN_MASK, MT6351_PMIC_BUCK_VSRAM_PROC_SFCHG_FEN_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_SFCHG_RRATE, MT6351_PMIC_BUCK_VSRAM_PROC_SFCHG_RRATE_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_SFCHG_RRATE_MASK,
	 MT6351_PMIC_BUCK_VSRAM_PROC_SFCHG_RRATE_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_SFCHG_REN, MT6351_PMIC_BUCK_VSRAM_PROC_SFCHG_REN_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_SFCHG_REN_MASK, MT6351_PMIC_BUCK_VSRAM_PROC_SFCHG_REN_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_VOSEL, MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_MASK, MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_VOSEL_ON, MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_ON_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_ON_MASK, MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_ON_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_VOSEL_SLEEP, MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_SLEEP_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_SLEEP_MASK,
	 MT6351_PMIC_BUCK_VSRAM_PROC_VOSEL_SLEEP_SHIFT},
	{PMIC_DA_NI_VSRAM_PROC_VOSEL, MT6351_PMIC_DA_NI_VSRAM_PROC_VOSEL_ADDR,
	 MT6351_PMIC_DA_NI_VSRAM_PROC_VOSEL_MASK, MT6351_PMIC_DA_NI_VSRAM_PROC_VOSEL_SHIFT},
	{PMIC_DA_NI_VSRAM_PROC_VOSEL_SYNC, MT6351_PMIC_DA_NI_VSRAM_PROC_VOSEL_SYNC_ADDR,
	 MT6351_PMIC_DA_NI_VSRAM_PROC_VOSEL_SYNC_MASK,
	 MT6351_PMIC_DA_NI_VSRAM_PROC_VOSEL_SYNC_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_TRANS_TD, MT6351_PMIC_BUCK_VSRAM_PROC_TRANS_TD_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_TRANS_TD_MASK, MT6351_PMIC_BUCK_VSRAM_PROC_TRANS_TD_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_TRANS_CTRL, MT6351_PMIC_BUCK_VSRAM_PROC_TRANS_CTRL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_TRANS_CTRL_MASK,
	 MT6351_PMIC_BUCK_VSRAM_PROC_TRANS_CTRL_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_TRANS_ONCE, MT6351_PMIC_BUCK_VSRAM_PROC_TRANS_ONCE_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_TRANS_ONCE_MASK,
	 MT6351_PMIC_BUCK_VSRAM_PROC_TRANS_ONCE_SHIFT},
	{PMIC_DA_QI_VSRAM_PROC_DVS_EN, MT6351_PMIC_DA_QI_VSRAM_PROC_DVS_EN_ADDR,
	 MT6351_PMIC_DA_QI_VSRAM_PROC_DVS_EN_MASK, MT6351_PMIC_DA_QI_VSRAM_PROC_DVS_EN_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_VSLEEP_EN, MT6351_PMIC_BUCK_VSRAM_PROC_VSLEEP_EN_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_VSLEEP_EN_MASK, MT6351_PMIC_BUCK_VSRAM_PROC_VSLEEP_EN_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_R2R_PDN, MT6351_PMIC_BUCK_VSRAM_PROC_R2R_PDN_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_R2R_PDN_MASK, MT6351_PMIC_BUCK_VSRAM_PROC_R2R_PDN_SHIFT},
	{PMIC_BUCK_VSRAM_PROC_VSLEEP_SEL, MT6351_PMIC_BUCK_VSRAM_PROC_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_BUCK_VSRAM_PROC_VSLEEP_SEL_MASK,
	 MT6351_PMIC_BUCK_VSRAM_PROC_VSLEEP_SEL_SHIFT},
	{PMIC_DA_NI_VSRAM_PROC_R2R_PDN, MT6351_PMIC_DA_NI_VSRAM_PROC_R2R_PDN_ADDR,
	 MT6351_PMIC_DA_NI_VSRAM_PROC_R2R_PDN_MASK, MT6351_PMIC_DA_NI_VSRAM_PROC_R2R_PDN_SHIFT},
	{PMIC_DA_NI_VSRAM_PROC_VSLEEP_SEL, MT6351_PMIC_DA_NI_VSRAM_PROC_VSLEEP_SEL_ADDR,
	 MT6351_PMIC_DA_NI_VSRAM_PROC_VSLEEP_SEL_MASK,
	 MT6351_PMIC_DA_NI_VSRAM_PROC_VSLEEP_SEL_SHIFT},
	{PMIC_BUCK_K_RST_DONE, MT6351_PMIC_BUCK_K_RST_DONE_ADDR,
	 MT6351_PMIC_BUCK_K_RST_DONE_MASK, MT6351_PMIC_BUCK_K_RST_DONE_SHIFT},
	{PMIC_BUCK_K_MAP_SEL, MT6351_PMIC_BUCK_K_MAP_SEL_ADDR,
	 MT6351_PMIC_BUCK_K_MAP_SEL_MASK, MT6351_PMIC_BUCK_K_MAP_SEL_SHIFT},
	{PMIC_BUCK_K_ONCE_EN, MT6351_PMIC_BUCK_K_ONCE_EN_ADDR,
	 MT6351_PMIC_BUCK_K_ONCE_EN_MASK, MT6351_PMIC_BUCK_K_ONCE_EN_SHIFT},
	{PMIC_BUCK_K_ONCE, MT6351_PMIC_BUCK_K_ONCE_ADDR, MT6351_PMIC_BUCK_K_ONCE_MASK,
	 MT6351_PMIC_BUCK_K_ONCE_SHIFT},
	{PMIC_BUCK_K_START_MANUAL, MT6351_PMIC_BUCK_K_START_MANUAL_ADDR,
	 MT6351_PMIC_BUCK_K_START_MANUAL_MASK, MT6351_PMIC_BUCK_K_START_MANUAL_SHIFT},
	{PMIC_BUCK_K_SRC_SEL, MT6351_PMIC_BUCK_K_SRC_SEL_ADDR,
	 MT6351_PMIC_BUCK_K_SRC_SEL_MASK, MT6351_PMIC_BUCK_K_SRC_SEL_SHIFT},
	{PMIC_BUCK_K_AUTO_EN, MT6351_PMIC_BUCK_K_AUTO_EN_ADDR,
	 MT6351_PMIC_BUCK_K_AUTO_EN_MASK, MT6351_PMIC_BUCK_K_AUTO_EN_SHIFT},
	{PMIC_BUCK_K_INV, MT6351_PMIC_BUCK_K_INV_ADDR, MT6351_PMIC_BUCK_K_INV_MASK,
	 MT6351_PMIC_BUCK_K_INV_SHIFT},
	{PMIC_BUCK_K_CONTROL_SMPS, MT6351_PMIC_BUCK_K_CONTROL_SMPS_ADDR,
	 MT6351_PMIC_BUCK_K_CONTROL_SMPS_MASK, MT6351_PMIC_BUCK_K_CONTROL_SMPS_SHIFT},
	{PMIC_K_RESULT, MT6351_PMIC_K_RESULT_ADDR, MT6351_PMIC_K_RESULT_MASK,
	 MT6351_PMIC_K_RESULT_SHIFT},
	{PMIC_K_DONE, MT6351_PMIC_K_DONE_ADDR, MT6351_PMIC_K_DONE_MASK,
	 MT6351_PMIC_K_DONE_SHIFT},
	{PMIC_K_CONTROL, MT6351_PMIC_K_CONTROL_ADDR, MT6351_PMIC_K_CONTROL_MASK,
	 MT6351_PMIC_K_CONTROL_SHIFT},
	{PMIC_DA_QI_SMPS_OSC_CAL, MT6351_PMIC_DA_QI_SMPS_OSC_CAL_ADDR,
	 MT6351_PMIC_DA_QI_SMPS_OSC_CAL_MASK, MT6351_PMIC_DA_QI_SMPS_OSC_CAL_SHIFT},
	{PMIC_BUCK_K_BUCK_CK_CNT, MT6351_PMIC_BUCK_K_BUCK_CK_CNT_ADDR,
	 MT6351_PMIC_BUCK_K_BUCK_CK_CNT_MASK, MT6351_PMIC_BUCK_K_BUCK_CK_CNT_SHIFT},
	{PMIC_WDTDBG_CLR, MT6351_PMIC_WDTDBG_CLR_ADDR, MT6351_PMIC_WDTDBG_CLR_MASK,
	 MT6351_PMIC_WDTDBG_CLR_SHIFT},
	{PMIC_WDTDBG_CON0_RSV0, MT6351_PMIC_WDTDBG_CON0_RSV0_ADDR,
	 MT6351_PMIC_WDTDBG_CON0_RSV0_MASK, MT6351_PMIC_WDTDBG_CON0_RSV0_SHIFT},
	{PMIC_VGPU_VOSEL_WDTDBG, MT6351_PMIC_VGPU_VOSEL_WDTDBG_ADDR,
	 MT6351_PMIC_VGPU_VOSEL_WDTDBG_MASK, MT6351_PMIC_VGPU_VOSEL_WDTDBG_SHIFT},
	{PMIC_VCORE_VOSEL_WDTDBG, MT6351_PMIC_VCORE_VOSEL_WDTDBG_ADDR,
	 MT6351_PMIC_VCORE_VOSEL_WDTDBG_MASK, MT6351_PMIC_VCORE_VOSEL_WDTDBG_SHIFT},
	{PMIC_VMD1_VOSEL_WDTDBG, MT6351_PMIC_VMD1_VOSEL_WDTDBG_ADDR,
	 MT6351_PMIC_VMD1_VOSEL_WDTDBG_MASK, MT6351_PMIC_VMD1_VOSEL_WDTDBG_SHIFT},
	{PMIC_VMODEM_VOSEL_WDTDBG, MT6351_PMIC_VMODEM_VOSEL_WDTDBG_ADDR,
	 MT6351_PMIC_VMODEM_VOSEL_WDTDBG_MASK, MT6351_PMIC_VMODEM_VOSEL_WDTDBG_SHIFT},
	{PMIC_VSRAM_PROC_VOSEL_WDTDBG, MT6351_PMIC_VSRAM_PROC_VOSEL_WDTDBG_ADDR,
	 MT6351_PMIC_VSRAM_PROC_VOSEL_WDTDBG_MASK, MT6351_PMIC_VSRAM_PROC_VOSEL_WDTDBG_SHIFT},
	{PMIC_VSRAM_MD_VOSEL_WDTDBG, MT6351_PMIC_VSRAM_MD_VOSEL_WDTDBG_ADDR,
	 MT6351_PMIC_VSRAM_MD_VOSEL_WDTDBG_MASK, MT6351_PMIC_VSRAM_MD_VOSEL_WDTDBG_SHIFT},
	{PMIC_RG_AUDZCDENABLE, MT6351_PMIC_RG_AUDZCDENABLE_ADDR,
	 MT6351_PMIC_RG_AUDZCDENABLE_MASK, MT6351_PMIC_RG_AUDZCDENABLE_SHIFT},
	{PMIC_RG_AUDZCDGAINSTEPTIME, MT6351_PMIC_RG_AUDZCDGAINSTEPTIME_ADDR,
	 MT6351_PMIC_RG_AUDZCDGAINSTEPTIME_MASK, MT6351_PMIC_RG_AUDZCDGAINSTEPTIME_SHIFT},
	{PMIC_RG_AUDZCDGAINSTEPSIZE, MT6351_PMIC_RG_AUDZCDGAINSTEPSIZE_ADDR,
	 MT6351_PMIC_RG_AUDZCDGAINSTEPSIZE_MASK, MT6351_PMIC_RG_AUDZCDGAINSTEPSIZE_SHIFT},
	{PMIC_RG_AUDZCDTIMEOUTMODESEL, MT6351_PMIC_RG_AUDZCDTIMEOUTMODESEL_ADDR,
	 MT6351_PMIC_RG_AUDZCDTIMEOUTMODESEL_MASK, MT6351_PMIC_RG_AUDZCDTIMEOUTMODESEL_SHIFT},
	{PMIC_RG_AUDZCDCLKSEL_VAUDP15, MT6351_PMIC_RG_AUDZCDCLKSEL_VAUDP15_ADDR,
	 MT6351_PMIC_RG_AUDZCDCLKSEL_VAUDP15_MASK, MT6351_PMIC_RG_AUDZCDCLKSEL_VAUDP15_SHIFT},
	{PMIC_RG_AUDZCDMUXSEL_VAUDP15, MT6351_PMIC_RG_AUDZCDMUXSEL_VAUDP15_ADDR,
	 MT6351_PMIC_RG_AUDZCDMUXSEL_VAUDP15_MASK, MT6351_PMIC_RG_AUDZCDMUXSEL_VAUDP15_SHIFT},
	{PMIC_RG_AUDLOLGAIN, MT6351_PMIC_RG_AUDLOLGAIN_ADDR,
	 MT6351_PMIC_RG_AUDLOLGAIN_MASK, MT6351_PMIC_RG_AUDLOLGAIN_SHIFT},
	{PMIC_RG_AUDLORGAIN, MT6351_PMIC_RG_AUDLORGAIN_ADDR,
	 MT6351_PMIC_RG_AUDLORGAIN_MASK, MT6351_PMIC_RG_AUDLORGAIN_SHIFT},
	{PMIC_RG_AUDHPLGAIN, MT6351_PMIC_RG_AUDHPLGAIN_ADDR,
	 MT6351_PMIC_RG_AUDHPLGAIN_MASK, MT6351_PMIC_RG_AUDHPLGAIN_SHIFT},
	{PMIC_RG_AUDHPRGAIN, MT6351_PMIC_RG_AUDHPRGAIN_ADDR,
	 MT6351_PMIC_RG_AUDHPRGAIN_MASK, MT6351_PMIC_RG_AUDHPRGAIN_SHIFT},
	{PMIC_RG_AUDHSGAIN, MT6351_PMIC_RG_AUDHSGAIN_ADDR, MT6351_PMIC_RG_AUDHSGAIN_MASK,
	 MT6351_PMIC_RG_AUDHSGAIN_SHIFT},
	{PMIC_RG_AUDIVLGAIN, MT6351_PMIC_RG_AUDIVLGAIN_ADDR,
	 MT6351_PMIC_RG_AUDIVLGAIN_MASK, MT6351_PMIC_RG_AUDIVLGAIN_SHIFT},
	{PMIC_RG_AUDIVRGAIN, MT6351_PMIC_RG_AUDIVRGAIN_ADDR,
	 MT6351_PMIC_RG_AUDIVRGAIN_MASK, MT6351_PMIC_RG_AUDIVRGAIN_SHIFT},
	{PMIC_RG_AUDINTGAIN1, MT6351_PMIC_RG_AUDINTGAIN1_ADDR,
	 MT6351_PMIC_RG_AUDINTGAIN1_MASK, MT6351_PMIC_RG_AUDINTGAIN1_SHIFT},
	{PMIC_RG_AUDINTGAIN2, MT6351_PMIC_RG_AUDINTGAIN2_ADDR,
	 MT6351_PMIC_RG_AUDINTGAIN2_MASK, MT6351_PMIC_RG_AUDINTGAIN2_SHIFT},
	{PMIC_RG_A_TRIM_EN, MT6351_PMIC_RG_A_TRIM_EN_ADDR, MT6351_PMIC_RG_A_TRIM_EN_MASK,
	 MT6351_PMIC_RG_A_TRIM_EN_SHIFT},
	{PMIC_RG_A_TRIM_SEL, MT6351_PMIC_RG_A_TRIM_SEL_ADDR,
	 MT6351_PMIC_RG_A_TRIM_SEL_MASK, MT6351_PMIC_RG_A_TRIM_SEL_SHIFT},
	{PMIC_RG_A_ISINKS_RSV, MT6351_PMIC_RG_A_ISINKS_RSV_ADDR,
	 MT6351_PMIC_RG_A_ISINKS_RSV_MASK, MT6351_PMIC_RG_A_ISINKS_RSV_SHIFT},
	{PMIC_RG_B_TRIM_EN, MT6351_PMIC_RG_B_TRIM_EN_ADDR, MT6351_PMIC_RG_B_TRIM_EN_MASK,
	 MT6351_PMIC_RG_B_TRIM_EN_SHIFT},
	{PMIC_RG_B_TRIM_SEL, MT6351_PMIC_RG_B_TRIM_SEL_ADDR,
	 MT6351_PMIC_RG_B_TRIM_SEL_MASK, MT6351_PMIC_RG_B_TRIM_SEL_SHIFT},
	{PMIC_RG_B_ISINKS_RSV, MT6351_PMIC_RG_B_ISINKS_RSV_ADDR,
	 MT6351_PMIC_RG_B_ISINKS_RSV_MASK, MT6351_PMIC_RG_B_ISINKS_RSV_SHIFT},
	{PMIC_ISINK_DIM0_FSEL, MT6351_PMIC_ISINK_DIM0_FSEL_ADDR,
	 MT6351_PMIC_ISINK_DIM0_FSEL_MASK, MT6351_PMIC_ISINK_DIM0_FSEL_SHIFT},
	{PMIC_ISINK0_RSV1, MT6351_PMIC_ISINK0_RSV1_ADDR, MT6351_PMIC_ISINK0_RSV1_MASK,
	 MT6351_PMIC_ISINK0_RSV1_SHIFT},
	{PMIC_ISINK0_RSV0, MT6351_PMIC_ISINK0_RSV0_ADDR, MT6351_PMIC_ISINK0_RSV0_MASK,
	 MT6351_PMIC_ISINK0_RSV0_SHIFT},
	{PMIC_ISINK_DIM0_DUTY, MT6351_PMIC_ISINK_DIM0_DUTY_ADDR,
	 MT6351_PMIC_ISINK_DIM0_DUTY_MASK, MT6351_PMIC_ISINK_DIM0_DUTY_SHIFT},
	{PMIC_ISINK_CH0_STEP, MT6351_PMIC_ISINK_CH0_STEP_ADDR,
	 MT6351_PMIC_ISINK_CH0_STEP_MASK, MT6351_PMIC_ISINK_CH0_STEP_SHIFT},
	{PMIC_ISINK_BREATH0_TF2_SEL, MT6351_PMIC_ISINK_BREATH0_TF2_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH0_TF2_SEL_MASK, MT6351_PMIC_ISINK_BREATH0_TF2_SEL_SHIFT},
	{PMIC_ISINK_BREATH0_TF1_SEL, MT6351_PMIC_ISINK_BREATH0_TF1_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH0_TF1_SEL_MASK, MT6351_PMIC_ISINK_BREATH0_TF1_SEL_SHIFT},
	{PMIC_ISINK_BREATH0_TR2_SEL, MT6351_PMIC_ISINK_BREATH0_TR2_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH0_TR2_SEL_MASK, MT6351_PMIC_ISINK_BREATH0_TR2_SEL_SHIFT},
	{PMIC_ISINK_BREATH0_TR1_SEL, MT6351_PMIC_ISINK_BREATH0_TR1_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH0_TR1_SEL_MASK, MT6351_PMIC_ISINK_BREATH0_TR1_SEL_SHIFT},
	{PMIC_ISINK_BREATH0_TOFF_SEL, MT6351_PMIC_ISINK_BREATH0_TOFF_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH0_TOFF_SEL_MASK, MT6351_PMIC_ISINK_BREATH0_TOFF_SEL_SHIFT},
	{PMIC_ISINK_BREATH0_TON_SEL, MT6351_PMIC_ISINK_BREATH0_TON_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH0_TON_SEL_MASK, MT6351_PMIC_ISINK_BREATH0_TON_SEL_SHIFT},
	{PMIC_ISINK_DIM1_FSEL, MT6351_PMIC_ISINK_DIM1_FSEL_ADDR,
	 MT6351_PMIC_ISINK_DIM1_FSEL_MASK, MT6351_PMIC_ISINK_DIM1_FSEL_SHIFT},
	{PMIC_ISINK1_RSV1, MT6351_PMIC_ISINK1_RSV1_ADDR, MT6351_PMIC_ISINK1_RSV1_MASK,
	 MT6351_PMIC_ISINK1_RSV1_SHIFT},
	{PMIC_ISINK1_RSV0, MT6351_PMIC_ISINK1_RSV0_ADDR, MT6351_PMIC_ISINK1_RSV0_MASK,
	 MT6351_PMIC_ISINK1_RSV0_SHIFT},
	{PMIC_ISINK_DIM1_DUTY, MT6351_PMIC_ISINK_DIM1_DUTY_ADDR,
	 MT6351_PMIC_ISINK_DIM1_DUTY_MASK, MT6351_PMIC_ISINK_DIM1_DUTY_SHIFT},
	{PMIC_ISINK_CH1_STEP, MT6351_PMIC_ISINK_CH1_STEP_ADDR,
	 MT6351_PMIC_ISINK_CH1_STEP_MASK, MT6351_PMIC_ISINK_CH1_STEP_SHIFT},
	{PMIC_ISINK_BREATH1_TF2_SEL, MT6351_PMIC_ISINK_BREATH1_TF2_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH1_TF2_SEL_MASK, MT6351_PMIC_ISINK_BREATH1_TF2_SEL_SHIFT},
	{PMIC_ISINK_BREATH1_TF1_SEL, MT6351_PMIC_ISINK_BREATH1_TF1_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH1_TF1_SEL_MASK, MT6351_PMIC_ISINK_BREATH1_TF1_SEL_SHIFT},
	{PMIC_ISINK_BREATH1_TR2_SEL, MT6351_PMIC_ISINK_BREATH1_TR2_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH1_TR2_SEL_MASK, MT6351_PMIC_ISINK_BREATH1_TR2_SEL_SHIFT},
	{PMIC_ISINK_BREATH1_TR1_SEL, MT6351_PMIC_ISINK_BREATH1_TR1_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH1_TR1_SEL_MASK, MT6351_PMIC_ISINK_BREATH1_TR1_SEL_SHIFT},
	{PMIC_ISINK_BREATH1_TOFF_SEL, MT6351_PMIC_ISINK_BREATH1_TOFF_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH1_TOFF_SEL_MASK, MT6351_PMIC_ISINK_BREATH1_TOFF_SEL_SHIFT},
	{PMIC_ISINK_BREATH1_TON_SEL, MT6351_PMIC_ISINK_BREATH1_TON_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH1_TON_SEL_MASK, MT6351_PMIC_ISINK_BREATH1_TON_SEL_SHIFT},
	{PMIC_ISINK_DIM4_FSEL, MT6351_PMIC_ISINK_DIM4_FSEL_ADDR,
	 MT6351_PMIC_ISINK_DIM4_FSEL_MASK, MT6351_PMIC_ISINK_DIM4_FSEL_SHIFT},
	{PMIC_ISINK4_RSV1, MT6351_PMIC_ISINK4_RSV1_ADDR, MT6351_PMIC_ISINK4_RSV1_MASK,
	 MT6351_PMIC_ISINK4_RSV1_SHIFT},
	{PMIC_ISINK4_RSV0, MT6351_PMIC_ISINK4_RSV0_ADDR, MT6351_PMIC_ISINK4_RSV0_MASK,
	 MT6351_PMIC_ISINK4_RSV0_SHIFT},
	{PMIC_ISINK_DIM4_DUTY, MT6351_PMIC_ISINK_DIM4_DUTY_ADDR,
	 MT6351_PMIC_ISINK_DIM4_DUTY_MASK, MT6351_PMIC_ISINK_DIM4_DUTY_SHIFT},
	{PMIC_ISINK_CH4_STEP, MT6351_PMIC_ISINK_CH4_STEP_ADDR,
	 MT6351_PMIC_ISINK_CH4_STEP_MASK, MT6351_PMIC_ISINK_CH4_STEP_SHIFT},
	{PMIC_ISINK_BREATH4_TF2_SEL, MT6351_PMIC_ISINK_BREATH4_TF2_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH4_TF2_SEL_MASK, MT6351_PMIC_ISINK_BREATH4_TF2_SEL_SHIFT},
	{PMIC_ISINK_BREATH4_TF1_SEL, MT6351_PMIC_ISINK_BREATH4_TF1_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH4_TF1_SEL_MASK, MT6351_PMIC_ISINK_BREATH4_TF1_SEL_SHIFT},
	{PMIC_ISINK_BREATH4_TR2_SEL, MT6351_PMIC_ISINK_BREATH4_TR2_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH4_TR2_SEL_MASK, MT6351_PMIC_ISINK_BREATH4_TR2_SEL_SHIFT},
	{PMIC_ISINK_BREATH4_TR1_SEL, MT6351_PMIC_ISINK_BREATH4_TR1_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH4_TR1_SEL_MASK, MT6351_PMIC_ISINK_BREATH4_TR1_SEL_SHIFT},
	{PMIC_ISINK_BREATH4_TOFF_SEL, MT6351_PMIC_ISINK_BREATH4_TOFF_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH4_TOFF_SEL_MASK, MT6351_PMIC_ISINK_BREATH4_TOFF_SEL_SHIFT},
	{PMIC_ISINK_BREATH4_TON_SEL, MT6351_PMIC_ISINK_BREATH4_TON_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH4_TON_SEL_MASK, MT6351_PMIC_ISINK_BREATH4_TON_SEL_SHIFT},
	{PMIC_ISINK_DIM5_FSEL, MT6351_PMIC_ISINK_DIM5_FSEL_ADDR,
	 MT6351_PMIC_ISINK_DIM5_FSEL_MASK, MT6351_PMIC_ISINK_DIM5_FSEL_SHIFT},
	{PMIC_ISINK5_RSV1, MT6351_PMIC_ISINK5_RSV1_ADDR, MT6351_PMIC_ISINK5_RSV1_MASK,
	 MT6351_PMIC_ISINK5_RSV1_SHIFT},
	{PMIC_ISINK5_RSV0, MT6351_PMIC_ISINK5_RSV0_ADDR, MT6351_PMIC_ISINK5_RSV0_MASK,
	 MT6351_PMIC_ISINK5_RSV0_SHIFT},
	{PMIC_ISINK_DIM5_DUTY, MT6351_PMIC_ISINK_DIM5_DUTY_ADDR,
	 MT6351_PMIC_ISINK_DIM5_DUTY_MASK, MT6351_PMIC_ISINK_DIM5_DUTY_SHIFT},
	{PMIC_ISINK_CH5_STEP, MT6351_PMIC_ISINK_CH5_STEP_ADDR,
	 MT6351_PMIC_ISINK_CH5_STEP_MASK, MT6351_PMIC_ISINK_CH5_STEP_SHIFT},
	{PMIC_ISINK_BREATH5_TF2_SEL, MT6351_PMIC_ISINK_BREATH5_TF2_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH5_TF2_SEL_MASK, MT6351_PMIC_ISINK_BREATH5_TF2_SEL_SHIFT},
	{PMIC_ISINK_BREATH5_TF1_SEL, MT6351_PMIC_ISINK_BREATH5_TF1_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH5_TF1_SEL_MASK, MT6351_PMIC_ISINK_BREATH5_TF1_SEL_SHIFT},
	{PMIC_ISINK_BREATH5_TR2_SEL, MT6351_PMIC_ISINK_BREATH5_TR2_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH5_TR2_SEL_MASK, MT6351_PMIC_ISINK_BREATH5_TR2_SEL_SHIFT},
	{PMIC_ISINK_BREATH5_TR1_SEL, MT6351_PMIC_ISINK_BREATH5_TR1_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH5_TR1_SEL_MASK, MT6351_PMIC_ISINK_BREATH5_TR1_SEL_SHIFT},
	{PMIC_ISINK_BREATH5_TOFF_SEL, MT6351_PMIC_ISINK_BREATH5_TOFF_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH5_TOFF_SEL_MASK, MT6351_PMIC_ISINK_BREATH5_TOFF_SEL_SHIFT},
	{PMIC_ISINK_BREATH5_TON_SEL, MT6351_PMIC_ISINK_BREATH5_TON_SEL_ADDR,
	 MT6351_PMIC_ISINK_BREATH5_TON_SEL_MASK, MT6351_PMIC_ISINK_BREATH5_TON_SEL_SHIFT},
	{PMIC_AD_NI_B_ISINK1_STATUS, MT6351_PMIC_AD_NI_B_ISINK1_STATUS_ADDR,
	 MT6351_PMIC_AD_NI_B_ISINK1_STATUS_MASK, MT6351_PMIC_AD_NI_B_ISINK1_STATUS_SHIFT},
	{PMIC_AD_NI_B_ISINK0_STATUS, MT6351_PMIC_AD_NI_B_ISINK0_STATUS_ADDR,
	 MT6351_PMIC_AD_NI_B_ISINK0_STATUS_MASK, MT6351_PMIC_AD_NI_B_ISINK0_STATUS_SHIFT},
	{PMIC_AD_NI_A_ISINK1_STATUS, MT6351_PMIC_AD_NI_A_ISINK1_STATUS_ADDR,
	 MT6351_PMIC_AD_NI_A_ISINK1_STATUS_MASK, MT6351_PMIC_AD_NI_A_ISINK1_STATUS_SHIFT},
	{PMIC_AD_NI_A_ISINK0_STATUS, MT6351_PMIC_AD_NI_A_ISINK0_STATUS_ADDR,
	 MT6351_PMIC_AD_NI_A_ISINK0_STATUS_MASK, MT6351_PMIC_AD_NI_A_ISINK0_STATUS_SHIFT},
	{PMIC_ISINK_PHASE0_DLY_EN, MT6351_PMIC_ISINK_PHASE0_DLY_EN_ADDR,
	 MT6351_PMIC_ISINK_PHASE0_DLY_EN_MASK, MT6351_PMIC_ISINK_PHASE0_DLY_EN_SHIFT},
	{PMIC_ISINK_PHASE1_DLY_EN, MT6351_PMIC_ISINK_PHASE1_DLY_EN_ADDR,
	 MT6351_PMIC_ISINK_PHASE1_DLY_EN_MASK, MT6351_PMIC_ISINK_PHASE1_DLY_EN_SHIFT},
	{PMIC_ISINK_PHASE4_DLY_EN, MT6351_PMIC_ISINK_PHASE4_DLY_EN_ADDR,
	 MT6351_PMIC_ISINK_PHASE4_DLY_EN_MASK, MT6351_PMIC_ISINK_PHASE4_DLY_EN_SHIFT},
	{PMIC_ISINK_PHASE5_DLY_EN, MT6351_PMIC_ISINK_PHASE5_DLY_EN_ADDR,
	 MT6351_PMIC_ISINK_PHASE5_DLY_EN_MASK, MT6351_PMIC_ISINK_PHASE5_DLY_EN_SHIFT},
	{PMIC_ISINK_PHASE_DLY_TC, MT6351_PMIC_ISINK_PHASE_DLY_TC_ADDR,
	 MT6351_PMIC_ISINK_PHASE_DLY_TC_MASK, MT6351_PMIC_ISINK_PHASE_DLY_TC_SHIFT},
	{PMIC_ISINK_CHOP0_SW, MT6351_PMIC_ISINK_CHOP0_SW_ADDR,
	 MT6351_PMIC_ISINK_CHOP0_SW_MASK, MT6351_PMIC_ISINK_CHOP0_SW_SHIFT},
	{PMIC_ISINK_CHOP1_SW, MT6351_PMIC_ISINK_CHOP1_SW_ADDR,
	 MT6351_PMIC_ISINK_CHOP1_SW_MASK, MT6351_PMIC_ISINK_CHOP1_SW_SHIFT},
	{PMIC_ISINK_CHOP4_SW, MT6351_PMIC_ISINK_CHOP4_SW_ADDR,
	 MT6351_PMIC_ISINK_CHOP4_SW_MASK, MT6351_PMIC_ISINK_CHOP4_SW_SHIFT},
	{PMIC_ISINK_CHOP5_SW, MT6351_PMIC_ISINK_CHOP5_SW_ADDR,
	 MT6351_PMIC_ISINK_CHOP5_SW_MASK, MT6351_PMIC_ISINK_CHOP5_SW_SHIFT},
	{PMIC_ISINK_SFSTR5_EN, MT6351_PMIC_ISINK_SFSTR5_EN_ADDR,
	 MT6351_PMIC_ISINK_SFSTR5_EN_MASK, MT6351_PMIC_ISINK_SFSTR5_EN_SHIFT},
	{PMIC_ISINK_SFSTR5_TC, MT6351_PMIC_ISINK_SFSTR5_TC_ADDR,
	 MT6351_PMIC_ISINK_SFSTR5_TC_MASK, MT6351_PMIC_ISINK_SFSTR5_TC_SHIFT},
	{PMIC_ISINK_SFSTR4_EN, MT6351_PMIC_ISINK_SFSTR4_EN_ADDR,
	 MT6351_PMIC_ISINK_SFSTR4_EN_MASK, MT6351_PMIC_ISINK_SFSTR4_EN_SHIFT},
	{PMIC_ISINK_SFSTR4_TC, MT6351_PMIC_ISINK_SFSTR4_TC_ADDR,
	 MT6351_PMIC_ISINK_SFSTR4_TC_MASK, MT6351_PMIC_ISINK_SFSTR4_TC_SHIFT},
	{PMIC_ISINK_SFSTR1_EN, MT6351_PMIC_ISINK_SFSTR1_EN_ADDR,
	 MT6351_PMIC_ISINK_SFSTR1_EN_MASK, MT6351_PMIC_ISINK_SFSTR1_EN_SHIFT},
	{PMIC_ISINK_SFSTR1_TC, MT6351_PMIC_ISINK_SFSTR1_TC_ADDR,
	 MT6351_PMIC_ISINK_SFSTR1_TC_MASK, MT6351_PMIC_ISINK_SFSTR1_TC_SHIFT},
	{PMIC_ISINK_SFSTR0_EN, MT6351_PMIC_ISINK_SFSTR0_EN_ADDR,
	 MT6351_PMIC_ISINK_SFSTR0_EN_MASK, MT6351_PMIC_ISINK_SFSTR0_EN_SHIFT},
	{PMIC_ISINK_SFSTR0_TC, MT6351_PMIC_ISINK_SFSTR0_TC_ADDR,
	 MT6351_PMIC_ISINK_SFSTR0_TC_MASK, MT6351_PMIC_ISINK_SFSTR0_TC_SHIFT},
	{PMIC_ISINK_CH0_EN, MT6351_PMIC_ISINK_CH0_EN_ADDR, MT6351_PMIC_ISINK_CH0_EN_MASK,
	 MT6351_PMIC_ISINK_CH0_EN_SHIFT},
	{PMIC_ISINK_CH1_EN, MT6351_PMIC_ISINK_CH1_EN_ADDR, MT6351_PMIC_ISINK_CH1_EN_MASK,
	 MT6351_PMIC_ISINK_CH1_EN_SHIFT},
	{PMIC_ISINK_CH4_EN, MT6351_PMIC_ISINK_CH4_EN_ADDR, MT6351_PMIC_ISINK_CH4_EN_MASK,
	 MT6351_PMIC_ISINK_CH4_EN_SHIFT},
	{PMIC_ISINK_CH5_EN, MT6351_PMIC_ISINK_CH5_EN_ADDR, MT6351_PMIC_ISINK_CH5_EN_MASK,
	 MT6351_PMIC_ISINK_CH5_EN_SHIFT},
	{PMIC_ISINK_CHOP0_EN, MT6351_PMIC_ISINK_CHOP0_EN_ADDR,
	 MT6351_PMIC_ISINK_CHOP0_EN_MASK, MT6351_PMIC_ISINK_CHOP0_EN_SHIFT},
	{PMIC_ISINK_CHOP1_EN, MT6351_PMIC_ISINK_CHOP1_EN_ADDR,
	 MT6351_PMIC_ISINK_CHOP1_EN_MASK, MT6351_PMIC_ISINK_CHOP1_EN_SHIFT},
	{PMIC_ISINK_CHOP4_EN, MT6351_PMIC_ISINK_CHOP4_EN_ADDR,
	 MT6351_PMIC_ISINK_CHOP4_EN_MASK, MT6351_PMIC_ISINK_CHOP4_EN_SHIFT},
	{PMIC_ISINK_CHOP5_EN, MT6351_PMIC_ISINK_CHOP5_EN_ADDR,
	 MT6351_PMIC_ISINK_CHOP5_EN_MASK, MT6351_PMIC_ISINK_CHOP5_EN_SHIFT},
	{PMIC_ISINK_CH0_BIAS_EN, MT6351_PMIC_ISINK_CH0_BIAS_EN_ADDR,
	 MT6351_PMIC_ISINK_CH0_BIAS_EN_MASK, MT6351_PMIC_ISINK_CH0_BIAS_EN_SHIFT},
	{PMIC_ISINK_CH1_BIAS_EN, MT6351_PMIC_ISINK_CH1_BIAS_EN_ADDR,
	 MT6351_PMIC_ISINK_CH1_BIAS_EN_MASK, MT6351_PMIC_ISINK_CH1_BIAS_EN_SHIFT},
	{PMIC_ISINK_CH4_BIAS_EN, MT6351_PMIC_ISINK_CH4_BIAS_EN_ADDR,
	 MT6351_PMIC_ISINK_CH4_BIAS_EN_MASK, MT6351_PMIC_ISINK_CH4_BIAS_EN_SHIFT},
	{PMIC_ISINK_CH5_BIAS_EN, MT6351_PMIC_ISINK_CH5_BIAS_EN_ADDR,
	 MT6351_PMIC_ISINK_CH5_BIAS_EN_MASK, MT6351_PMIC_ISINK_CH5_BIAS_EN_SHIFT},
	{PMIC_ISINK_RSV, MT6351_PMIC_ISINK_RSV_ADDR, MT6351_PMIC_ISINK_RSV_MASK,
	 MT6351_PMIC_ISINK_RSV_SHIFT},
	{PMIC_ISINK_CH5_MODE, MT6351_PMIC_ISINK_CH5_MODE_ADDR,
	 MT6351_PMIC_ISINK_CH5_MODE_MASK, MT6351_PMIC_ISINK_CH5_MODE_SHIFT},
	{PMIC_ISINK_CH4_MODE, MT6351_PMIC_ISINK_CH4_MODE_ADDR,
	 MT6351_PMIC_ISINK_CH4_MODE_MASK, MT6351_PMIC_ISINK_CH4_MODE_SHIFT},
	{PMIC_ISINK_CH1_MODE, MT6351_PMIC_ISINK_CH1_MODE_ADDR,
	 MT6351_PMIC_ISINK_CH1_MODE_MASK, MT6351_PMIC_ISINK_CH1_MODE_SHIFT},
	{PMIC_ISINK_CH0_MODE, MT6351_PMIC_ISINK_CH0_MODE_ADDR,
	 MT6351_PMIC_ISINK_CH0_MODE_MASK, MT6351_PMIC_ISINK_CH0_MODE_SHIFT},
	{PMIC_DA_QI_A_ISINKS_CH0_STEP, MT6351_PMIC_DA_QI_A_ISINKS_CH0_STEP_ADDR,
	 MT6351_PMIC_DA_QI_A_ISINKS_CH0_STEP_MASK, MT6351_PMIC_DA_QI_A_ISINKS_CH0_STEP_SHIFT},
	{PMIC_DA_QI_A_ISINKS_CH1_STEP, MT6351_PMIC_DA_QI_A_ISINKS_CH1_STEP_ADDR,
	 MT6351_PMIC_DA_QI_A_ISINKS_CH1_STEP_MASK, MT6351_PMIC_DA_QI_A_ISINKS_CH1_STEP_SHIFT},
	{PMIC_DA_QI_B_ISINKS_CH0_STEP, MT6351_PMIC_DA_QI_B_ISINKS_CH0_STEP_ADDR,
	 MT6351_PMIC_DA_QI_B_ISINKS_CH0_STEP_MASK, MT6351_PMIC_DA_QI_B_ISINKS_CH0_STEP_SHIFT},
	{PMIC_DA_QI_B_ISINKS_CH1_STEP, MT6351_PMIC_DA_QI_B_ISINKS_CH1_STEP_ADDR,
	 MT6351_PMIC_DA_QI_B_ISINKS_CH1_STEP_MASK, MT6351_PMIC_DA_QI_B_ISINKS_CH1_STEP_SHIFT},
	{PMIC_ISINK2_RSV1, MT6351_PMIC_ISINK2_RSV1_ADDR, MT6351_PMIC_ISINK2_RSV1_MASK,
	 MT6351_PMIC_ISINK2_RSV1_SHIFT},
	{PMIC_ISINK2_RSV0, MT6351_PMIC_ISINK2_RSV0_ADDR, MT6351_PMIC_ISINK2_RSV0_MASK,
	 MT6351_PMIC_ISINK2_RSV0_SHIFT},
	{PMIC_ISINK_CH2_STEP, MT6351_PMIC_ISINK_CH2_STEP_ADDR,
	 MT6351_PMIC_ISINK_CH2_STEP_MASK, MT6351_PMIC_ISINK_CH2_STEP_SHIFT},
	{PMIC_ISINK3_RSV1, MT6351_PMIC_ISINK3_RSV1_ADDR, MT6351_PMIC_ISINK3_RSV1_MASK,
	 MT6351_PMIC_ISINK3_RSV1_SHIFT},
	{PMIC_ISINK3_RSV0, MT6351_PMIC_ISINK3_RSV0_ADDR, MT6351_PMIC_ISINK3_RSV0_MASK,
	 MT6351_PMIC_ISINK3_RSV0_SHIFT},
	{PMIC_ISINK_CH3_STEP, MT6351_PMIC_ISINK_CH3_STEP_ADDR,
	 MT6351_PMIC_ISINK_CH3_STEP_MASK, MT6351_PMIC_ISINK_CH3_STEP_SHIFT},
	{PMIC_ISINK6_RSV1, MT6351_PMIC_ISINK6_RSV1_ADDR, MT6351_PMIC_ISINK6_RSV1_MASK,
	 MT6351_PMIC_ISINK6_RSV1_SHIFT},
	{PMIC_ISINK6_RSV0, MT6351_PMIC_ISINK6_RSV0_ADDR, MT6351_PMIC_ISINK6_RSV0_MASK,
	 MT6351_PMIC_ISINK6_RSV0_SHIFT},
	{PMIC_ISINK_CH6_STEP, MT6351_PMIC_ISINK_CH6_STEP_ADDR,
	 MT6351_PMIC_ISINK_CH6_STEP_MASK, MT6351_PMIC_ISINK_CH6_STEP_SHIFT},
	{PMIC_ISINK7_RSV1, MT6351_PMIC_ISINK7_RSV1_ADDR, MT6351_PMIC_ISINK7_RSV1_MASK,
	 MT6351_PMIC_ISINK7_RSV1_SHIFT},
	{PMIC_ISINK7_RSV0, MT6351_PMIC_ISINK7_RSV0_ADDR, MT6351_PMIC_ISINK7_RSV0_MASK,
	 MT6351_PMIC_ISINK7_RSV0_SHIFT},
	{PMIC_ISINK_CH7_STEP, MT6351_PMIC_ISINK_CH7_STEP_ADDR,
	 MT6351_PMIC_ISINK_CH7_STEP_MASK, MT6351_PMIC_ISINK_CH7_STEP_SHIFT},
	{PMIC_AD_NI_B_ISINK3_STATUS, MT6351_PMIC_AD_NI_B_ISINK3_STATUS_ADDR,
	 MT6351_PMIC_AD_NI_B_ISINK3_STATUS_MASK, MT6351_PMIC_AD_NI_B_ISINK3_STATUS_SHIFT},
	{PMIC_AD_NI_B_ISINK2_STATUS, MT6351_PMIC_AD_NI_B_ISINK2_STATUS_ADDR,
	 MT6351_PMIC_AD_NI_B_ISINK2_STATUS_MASK, MT6351_PMIC_AD_NI_B_ISINK2_STATUS_SHIFT},
	{PMIC_AD_NI_A_ISINK3_STATUS, MT6351_PMIC_AD_NI_A_ISINK3_STATUS_ADDR,
	 MT6351_PMIC_AD_NI_A_ISINK3_STATUS_MASK, MT6351_PMIC_AD_NI_A_ISINK3_STATUS_SHIFT},
	{PMIC_AD_NI_A_ISINK2_STATUS, MT6351_PMIC_AD_NI_A_ISINK2_STATUS_ADDR,
	 MT6351_PMIC_AD_NI_A_ISINK2_STATUS_MASK, MT6351_PMIC_AD_NI_A_ISINK2_STATUS_SHIFT},
	{PMIC_ISINK_CHOP7_SW, MT6351_PMIC_ISINK_CHOP7_SW_ADDR,
	 MT6351_PMIC_ISINK_CHOP7_SW_MASK, MT6351_PMIC_ISINK_CHOP7_SW_SHIFT},
	{PMIC_ISINK_CHOP6_SW, MT6351_PMIC_ISINK_CHOP6_SW_ADDR,
	 MT6351_PMIC_ISINK_CHOP6_SW_MASK, MT6351_PMIC_ISINK_CHOP6_SW_SHIFT},
	{PMIC_ISINK_CHOP3_SW, MT6351_PMIC_ISINK_CHOP3_SW_ADDR,
	 MT6351_PMIC_ISINK_CHOP3_SW_MASK, MT6351_PMIC_ISINK_CHOP3_SW_SHIFT},
	{PMIC_ISINK_CHOP2_SW, MT6351_PMIC_ISINK_CHOP2_SW_ADDR,
	 MT6351_PMIC_ISINK_CHOP2_SW_MASK, MT6351_PMIC_ISINK_CHOP2_SW_SHIFT},
	{PMIC_ISINK_CH7_EN, MT6351_PMIC_ISINK_CH7_EN_ADDR, MT6351_PMIC_ISINK_CH7_EN_MASK,
	 MT6351_PMIC_ISINK_CH7_EN_SHIFT},
	{PMIC_ISINK_CH6_EN, MT6351_PMIC_ISINK_CH6_EN_ADDR, MT6351_PMIC_ISINK_CH6_EN_MASK,
	 MT6351_PMIC_ISINK_CH6_EN_SHIFT},
	{PMIC_ISINK_CH3_EN, MT6351_PMIC_ISINK_CH3_EN_ADDR, MT6351_PMIC_ISINK_CH3_EN_MASK,
	 MT6351_PMIC_ISINK_CH3_EN_SHIFT},
	{PMIC_ISINK_CH2_EN, MT6351_PMIC_ISINK_CH2_EN_ADDR, MT6351_PMIC_ISINK_CH2_EN_MASK,
	 MT6351_PMIC_ISINK_CH2_EN_SHIFT},
	{PMIC_ISINK_CHOP7_EN, MT6351_PMIC_ISINK_CHOP7_EN_ADDR,
	 MT6351_PMIC_ISINK_CHOP7_EN_MASK, MT6351_PMIC_ISINK_CHOP7_EN_SHIFT},
	{PMIC_ISINK_CHOP6_EN, MT6351_PMIC_ISINK_CHOP6_EN_ADDR,
	 MT6351_PMIC_ISINK_CHOP6_EN_MASK, MT6351_PMIC_ISINK_CHOP6_EN_SHIFT},
	{PMIC_ISINK_CHOP3_EN, MT6351_PMIC_ISINK_CHOP3_EN_ADDR,
	 MT6351_PMIC_ISINK_CHOP3_EN_MASK, MT6351_PMIC_ISINK_CHOP3_EN_SHIFT},
	{PMIC_ISINK_CHOP2_EN, MT6351_PMIC_ISINK_CHOP2_EN_ADDR,
	 MT6351_PMIC_ISINK_CHOP2_EN_MASK, MT6351_PMIC_ISINK_CHOP2_EN_SHIFT},
	{PMIC_ISINK_CH7_BIAS_EN, MT6351_PMIC_ISINK_CH7_BIAS_EN_ADDR,
	 MT6351_PMIC_ISINK_CH7_BIAS_EN_MASK, MT6351_PMIC_ISINK_CH7_BIAS_EN_SHIFT},
	{PMIC_ISINK_CH6_BIAS_EN, MT6351_PMIC_ISINK_CH6_BIAS_EN_ADDR,
	 MT6351_PMIC_ISINK_CH6_BIAS_EN_MASK, MT6351_PMIC_ISINK_CH6_BIAS_EN_SHIFT},
	{PMIC_ISINK_CH3_BIAS_EN, MT6351_PMIC_ISINK_CH3_BIAS_EN_ADDR,
	 MT6351_PMIC_ISINK_CH3_BIAS_EN_MASK, MT6351_PMIC_ISINK_CH3_BIAS_EN_SHIFT},
	{PMIC_ISINK_CH2_BIAS_EN, MT6351_PMIC_ISINK_CH2_BIAS_EN_ADDR,
	 MT6351_PMIC_ISINK_CH2_BIAS_EN_MASK, MT6351_PMIC_ISINK_CH2_BIAS_EN_SHIFT},
	{PMIC_CHRIND_DIM_FSEL, MT6351_PMIC_CHRIND_DIM_FSEL_ADDR,
	 MT6351_PMIC_CHRIND_DIM_FSEL_MASK, MT6351_PMIC_CHRIND_DIM_FSEL_SHIFT},
	{PMIC_CHRIND_RSV1, MT6351_PMIC_CHRIND_RSV1_ADDR, MT6351_PMIC_CHRIND_RSV1_MASK,
	 MT6351_PMIC_CHRIND_RSV1_SHIFT},
	{PMIC_CHRIND_RSV0, MT6351_PMIC_CHRIND_RSV0_ADDR, MT6351_PMIC_CHRIND_RSV0_MASK,
	 MT6351_PMIC_CHRIND_RSV0_SHIFT},
	{PMIC_CHRIND_DIM_DUTY, MT6351_PMIC_CHRIND_DIM_DUTY_ADDR,
	 MT6351_PMIC_CHRIND_DIM_DUTY_MASK, MT6351_PMIC_CHRIND_DIM_DUTY_SHIFT},
	{PMIC_CHRIND_STEP, MT6351_PMIC_CHRIND_STEP_ADDR, MT6351_PMIC_CHRIND_STEP_MASK,
	 MT6351_PMIC_CHRIND_STEP_SHIFT},
	{PMIC_CHRIND_BREATH_TF2_SEL, MT6351_PMIC_CHRIND_BREATH_TF2_SEL_ADDR,
	 MT6351_PMIC_CHRIND_BREATH_TF2_SEL_MASK, MT6351_PMIC_CHRIND_BREATH_TF2_SEL_SHIFT},
	{PMIC_CHRIND_BREATH_TF1_SEL, MT6351_PMIC_CHRIND_BREATH_TF1_SEL_ADDR,
	 MT6351_PMIC_CHRIND_BREATH_TF1_SEL_MASK, MT6351_PMIC_CHRIND_BREATH_TF1_SEL_SHIFT},
	{PMIC_CHRIND_BREATH_TR2_SEL, MT6351_PMIC_CHRIND_BREATH_TR2_SEL_ADDR,
	 MT6351_PMIC_CHRIND_BREATH_TR2_SEL_MASK, MT6351_PMIC_CHRIND_BREATH_TR2_SEL_SHIFT},
	{PMIC_CHRIND_BREATH_TR1_SEL, MT6351_PMIC_CHRIND_BREATH_TR1_SEL_ADDR,
	 MT6351_PMIC_CHRIND_BREATH_TR1_SEL_MASK, MT6351_PMIC_CHRIND_BREATH_TR1_SEL_SHIFT},
	{PMIC_CHRIND_BREATH_TOFF_SEL, MT6351_PMIC_CHRIND_BREATH_TOFF_SEL_ADDR,
	 MT6351_PMIC_CHRIND_BREATH_TOFF_SEL_MASK, MT6351_PMIC_CHRIND_BREATH_TOFF_SEL_SHIFT},
	{PMIC_CHRIND_BREATH_TON_SEL, MT6351_PMIC_CHRIND_BREATH_TON_SEL_ADDR,
	 MT6351_PMIC_CHRIND_BREATH_TON_SEL_MASK, MT6351_PMIC_CHRIND_BREATH_TON_SEL_SHIFT},
	{PMIC_CHRIND_SFSTR_EN, MT6351_PMIC_CHRIND_SFSTR_EN_ADDR,
	 MT6351_PMIC_CHRIND_SFSTR_EN_MASK, MT6351_PMIC_CHRIND_SFSTR_EN_SHIFT},
	{PMIC_CHRIND_SFSTR_TC, MT6351_PMIC_CHRIND_SFSTR_TC_ADDR,
	 MT6351_PMIC_CHRIND_SFSTR_TC_MASK, MT6351_PMIC_CHRIND_SFSTR_TC_SHIFT},
	{PMIC_CHRIND_EN_SEL, MT6351_PMIC_CHRIND_EN_SEL_ADDR,
	 MT6351_PMIC_CHRIND_EN_SEL_MASK, MT6351_PMIC_CHRIND_EN_SEL_SHIFT},
	{PMIC_CHRIND_EN, MT6351_PMIC_CHRIND_EN_ADDR, MT6351_PMIC_CHRIND_EN_MASK,
	 MT6351_PMIC_CHRIND_EN_SHIFT},
	{PMIC_CHRIND_CHOP_EN, MT6351_PMIC_CHRIND_CHOP_EN_ADDR,
	 MT6351_PMIC_CHRIND_CHOP_EN_MASK, MT6351_PMIC_CHRIND_CHOP_EN_SHIFT},
	{PMIC_CHRIND_MODE, MT6351_PMIC_CHRIND_MODE_ADDR, MT6351_PMIC_CHRIND_MODE_MASK,
	 MT6351_PMIC_CHRIND_MODE_SHIFT},
	{PMIC_CHRIND_CHOP_SW, MT6351_PMIC_CHRIND_CHOP_SW_ADDR,
	 MT6351_PMIC_CHRIND_CHOP_SW_MASK, MT6351_PMIC_CHRIND_CHOP_SW_SHIFT},
	{PMIC_CHRIND_BIAS_EN, MT6351_PMIC_CHRIND_BIAS_EN_ADDR,
	 MT6351_PMIC_CHRIND_BIAS_EN_MASK, MT6351_PMIC_CHRIND_BIAS_EN_SHIFT},
	{PMIC_RG_VA18_MODE_SET, MT6351_PMIC_RG_VA18_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VA18_MODE_SET_MASK, MT6351_PMIC_RG_VA18_MODE_SET_SHIFT},
	{PMIC_RG_VA18_EN, MT6351_PMIC_RG_VA18_EN_ADDR, MT6351_PMIC_RG_VA18_EN_MASK,
	 MT6351_PMIC_RG_VA18_EN_SHIFT},
	{PMIC_RG_VA18_MODE_CTRL, MT6351_PMIC_RG_VA18_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VA18_MODE_CTRL_MASK, MT6351_PMIC_RG_VA18_MODE_CTRL_SHIFT},
	{PMIC_RG_VA18_ON_CTRL, MT6351_PMIC_RG_VA18_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VA18_ON_CTRL_MASK, MT6351_PMIC_RG_VA18_ON_CTRL_SHIFT},
	{PMIC_RG_VA18_SRCLK_MODE_SEL, MT6351_PMIC_RG_VA18_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VA18_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VA18_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VA18_MODE, MT6351_PMIC_DA_QI_VA18_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VA18_MODE_MASK, MT6351_PMIC_DA_QI_VA18_MODE_SHIFT},
	{PMIC_RG_VA18_STBTD, MT6351_PMIC_RG_VA18_STBTD_ADDR,
	 MT6351_PMIC_RG_VA18_STBTD_MASK, MT6351_PMIC_RG_VA18_STBTD_SHIFT},
	{PMIC_RG_VA18_SRCLK_EN_SEL, MT6351_PMIC_RG_VA18_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VA18_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VA18_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VA18_STB, MT6351_PMIC_DA_QI_VA18_STB_ADDR,
	 MT6351_PMIC_DA_QI_VA18_STB_MASK, MT6351_PMIC_DA_QI_VA18_STB_SHIFT},
	{PMIC_DA_QI_VA18_EN, MT6351_PMIC_DA_QI_VA18_EN_ADDR,
	 MT6351_PMIC_DA_QI_VA18_EN_MASK, MT6351_PMIC_DA_QI_VA18_EN_SHIFT},
	{PMIC_RG_VA18_AUXADC_PWDB_EN, MT6351_PMIC_RG_VA18_AUXADC_PWDB_EN_ADDR,
	 MT6351_PMIC_RG_VA18_AUXADC_PWDB_EN_MASK, MT6351_PMIC_RG_VA18_AUXADC_PWDB_EN_SHIFT},
	{PMIC_RG_VA18_OCFB_EN, MT6351_PMIC_RG_VA18_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VA18_OCFB_EN_MASK, MT6351_PMIC_RG_VA18_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VA18_OCFB_EN, MT6351_PMIC_DA_QI_VA18_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VA18_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VA18_OCFB_EN_SHIFT},
	{PMIC_RG_VTCXO24_MODE_SET, MT6351_PMIC_RG_VTCXO24_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VTCXO24_MODE_SET_MASK, MT6351_PMIC_RG_VTCXO24_MODE_SET_SHIFT},
	{PMIC_RG_VTCXO24_EN, MT6351_PMIC_RG_VTCXO24_EN_ADDR,
	 MT6351_PMIC_RG_VTCXO24_EN_MASK, MT6351_PMIC_RG_VTCXO24_EN_SHIFT},
	{PMIC_RG_VTCXO24_MODE_CTRL, MT6351_PMIC_RG_VTCXO24_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VTCXO24_MODE_CTRL_MASK, MT6351_PMIC_RG_VTCXO24_MODE_CTRL_SHIFT},
	{PMIC_RG_VTCXO24_ON_CTRL, MT6351_PMIC_RG_VTCXO24_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VTCXO24_ON_CTRL_MASK, MT6351_PMIC_RG_VTCXO24_ON_CTRL_SHIFT},
	{PMIC_RG_VTCXO24_SWITCH, MT6351_PMIC_RG_VTCXO24_SWITCH_ADDR,
	 MT6351_PMIC_RG_VTCXO24_SWITCH_MASK, MT6351_PMIC_RG_VTCXO24_SWITCH_SHIFT},
	{PMIC_RG_VTCXO24_SRCLK_MODE_SEL, MT6351_PMIC_RG_VTCXO24_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VTCXO24_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VTCXO24_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VTCXO24_MODE, MT6351_PMIC_DA_QI_VTCXO24_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VTCXO24_MODE_MASK, MT6351_PMIC_DA_QI_VTCXO24_MODE_SHIFT},
	{PMIC_RG_VTCXO24_STBTD, MT6351_PMIC_RG_VTCXO24_STBTD_ADDR,
	 MT6351_PMIC_RG_VTCXO24_STBTD_MASK, MT6351_PMIC_RG_VTCXO24_STBTD_SHIFT},
	{PMIC_RG_VTCXO24_SRCLK_EN_SEL, MT6351_PMIC_RG_VTCXO24_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VTCXO24_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VTCXO24_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VTCXO24_STB, MT6351_PMIC_DA_QI_VTCXO24_STB_ADDR,
	 MT6351_PMIC_DA_QI_VTCXO24_STB_MASK, MT6351_PMIC_DA_QI_VTCXO24_STB_SHIFT},
	{PMIC_DA_QI_VTCXO24_EN, MT6351_PMIC_DA_QI_VTCXO24_EN_ADDR,
	 MT6351_PMIC_DA_QI_VTCXO24_EN_MASK, MT6351_PMIC_DA_QI_VTCXO24_EN_SHIFT},
	{PMIC_RG_VTCXO24_OCFB_EN, MT6351_PMIC_RG_VTCXO24_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VTCXO24_OCFB_EN_MASK, MT6351_PMIC_RG_VTCXO24_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VTCXO24_OCFB_EN, MT6351_PMIC_DA_QI_VTCXO24_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VTCXO24_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VTCXO24_OCFB_EN_SHIFT},
	{PMIC_RG_VTCXO28_MODE_SET, MT6351_PMIC_RG_VTCXO28_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VTCXO28_MODE_SET_MASK, MT6351_PMIC_RG_VTCXO28_MODE_SET_SHIFT},
	{PMIC_RG_VTCXO28_EN, MT6351_PMIC_RG_VTCXO28_EN_ADDR,
	 MT6351_PMIC_RG_VTCXO28_EN_MASK, MT6351_PMIC_RG_VTCXO28_EN_SHIFT},
	{PMIC_RG_VTCXO28_MODE_CTRL, MT6351_PMIC_RG_VTCXO28_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VTCXO28_MODE_CTRL_MASK, MT6351_PMIC_RG_VTCXO28_MODE_CTRL_SHIFT},
	{PMIC_RG_VTCXO28_ON_CTRL, MT6351_PMIC_RG_VTCXO28_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VTCXO28_ON_CTRL_MASK, MT6351_PMIC_RG_VTCXO28_ON_CTRL_SHIFT},
	{PMIC_RG_VTCXO28_SRCLK_MODE_SEL, MT6351_PMIC_RG_VTCXO28_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VTCXO28_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VTCXO28_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VTCXO28_MODE, MT6351_PMIC_DA_QI_VTCXO28_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VTCXO28_MODE_MASK, MT6351_PMIC_DA_QI_VTCXO28_MODE_SHIFT},
	{PMIC_RG_VTCXO28_STBTD, MT6351_PMIC_RG_VTCXO28_STBTD_ADDR,
	 MT6351_PMIC_RG_VTCXO28_STBTD_MASK, MT6351_PMIC_RG_VTCXO28_STBTD_SHIFT},
	{PMIC_RG_VTCXO28_SRCLK_EN_SEL, MT6351_PMIC_RG_VTCXO28_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VTCXO28_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VTCXO28_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VTCXO28_STB, MT6351_PMIC_DA_QI_VTCXO28_STB_ADDR,
	 MT6351_PMIC_DA_QI_VTCXO28_STB_MASK, MT6351_PMIC_DA_QI_VTCXO28_STB_SHIFT},
	{PMIC_DA_QI_VTCXO28_EN, MT6351_PMIC_DA_QI_VTCXO28_EN_ADDR,
	 MT6351_PMIC_DA_QI_VTCXO28_EN_MASK, MT6351_PMIC_DA_QI_VTCXO28_EN_SHIFT},
	{PMIC_RG_VTCXO28_OCFB_EN, MT6351_PMIC_RG_VTCXO28_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VTCXO28_OCFB_EN_MASK, MT6351_PMIC_RG_VTCXO28_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VTCXO28_OCFB_EN, MT6351_PMIC_DA_QI_VTCXO28_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VTCXO28_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VTCXO28_OCFB_EN_SHIFT},
	{PMIC_RG_VCN28_MODE_SET, MT6351_PMIC_RG_VCN28_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VCN28_MODE_SET_MASK, MT6351_PMIC_RG_VCN28_MODE_SET_SHIFT},
	{PMIC_RG_VCN28_EN, MT6351_PMIC_RG_VCN28_EN_ADDR, MT6351_PMIC_RG_VCN28_EN_MASK,
	 MT6351_PMIC_RG_VCN28_EN_SHIFT},
	{PMIC_RG_VCN28_MODE_CTRL, MT6351_PMIC_RG_VCN28_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VCN28_MODE_CTRL_MASK, MT6351_PMIC_RG_VCN28_MODE_CTRL_SHIFT},
	{PMIC_RG_VCN28_ON_CTRL, MT6351_PMIC_RG_VCN28_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VCN28_ON_CTRL_MASK, MT6351_PMIC_RG_VCN28_ON_CTRL_SHIFT},
	{PMIC_RG_VCN28_SRCLK_MODE_SEL, MT6351_PMIC_RG_VCN28_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VCN28_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VCN28_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VCN28_MODE, MT6351_PMIC_DA_QI_VCN28_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VCN28_MODE_MASK, MT6351_PMIC_DA_QI_VCN28_MODE_SHIFT},
	{PMIC_RG_VCN28_STBTD, MT6351_PMIC_RG_VCN28_STBTD_ADDR,
	 MT6351_PMIC_RG_VCN28_STBTD_MASK, MT6351_PMIC_RG_VCN28_STBTD_SHIFT},
	{PMIC_RG_VCN28_SRCLK_EN_SEL, MT6351_PMIC_RG_VCN28_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VCN28_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VCN28_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VCN28_STB, MT6351_PMIC_DA_QI_VCN28_STB_ADDR,
	 MT6351_PMIC_DA_QI_VCN28_STB_MASK, MT6351_PMIC_DA_QI_VCN28_STB_SHIFT},
	{PMIC_DA_QI_VCN28_EN, MT6351_PMIC_DA_QI_VCN28_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCN28_EN_MASK, MT6351_PMIC_DA_QI_VCN28_EN_SHIFT},
	{PMIC_RG_VCN28_OCFB_EN, MT6351_PMIC_RG_VCN28_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VCN28_OCFB_EN_MASK, MT6351_PMIC_RG_VCN28_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VCN28_OCFB_EN, MT6351_PMIC_DA_QI_VCN28_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCN28_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VCN28_OCFB_EN_SHIFT},
	{PMIC_RG_VCN28_DUMMY_LOAD_EN, MT6351_PMIC_RG_VCN28_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VCN28_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VCN28_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VCN28_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VCN28_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VCN28_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VCN28_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VCN28_DUMMY_LOAD, MT6351_PMIC_RG_VCN28_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VCN28_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VCN28_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VCN28_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VCN28_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VCN28_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VCN28_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VCN28_DUMMY_LOAD, MT6351_PMIC_DA_QI_VCN28_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VCN28_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VCN28_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VCAMA_EN, MT6351_PMIC_RG_VCAMA_EN_ADDR, MT6351_PMIC_RG_VCAMA_EN_MASK,
	 MT6351_PMIC_RG_VCAMA_EN_SHIFT},
	{PMIC_RG_VCAMA_ON_CTRL, MT6351_PMIC_RG_VCAMA_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VCAMA_ON_CTRL_MASK, MT6351_PMIC_RG_VCAMA_ON_CTRL_SHIFT},
	{PMIC_RG_VCAMA_SRCLK_MODE_SEL, MT6351_PMIC_RG_VCAMA_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VCAMA_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VCAMA_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VCAMA_MODE, MT6351_PMIC_DA_QI_VCAMA_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VCAMA_MODE_MASK, MT6351_PMIC_DA_QI_VCAMA_MODE_SHIFT},
	{PMIC_RG_VCAMA_STBTD, MT6351_PMIC_RG_VCAMA_STBTD_ADDR,
	 MT6351_PMIC_RG_VCAMA_STBTD_MASK, MT6351_PMIC_RG_VCAMA_STBTD_SHIFT},
	{PMIC_RG_VCAMA_SRCLK_EN_SEL, MT6351_PMIC_RG_VCAMA_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VCAMA_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VCAMA_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VCAMA_STB, MT6351_PMIC_DA_QI_VCAMA_STB_ADDR,
	 MT6351_PMIC_DA_QI_VCAMA_STB_MASK, MT6351_PMIC_DA_QI_VCAMA_STB_SHIFT},
	{PMIC_DA_QI_VCAMA_EN, MT6351_PMIC_DA_QI_VCAMA_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCAMA_EN_MASK, MT6351_PMIC_DA_QI_VCAMA_EN_SHIFT},
	{PMIC_RG_VCAMA_OCFB_EN, MT6351_PMIC_RG_VCAMA_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VCAMA_OCFB_EN_MASK, MT6351_PMIC_RG_VCAMA_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VCAMA_OCFB_EN, MT6351_PMIC_DA_QI_VCAMA_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCAMA_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VCAMA_OCFB_EN_SHIFT},
	{PMIC_RG_VUSB33_MODE_SET, MT6351_PMIC_RG_VUSB33_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VUSB33_MODE_SET_MASK, MT6351_PMIC_RG_VUSB33_MODE_SET_SHIFT},
	{PMIC_RG_VUSB33_EN, MT6351_PMIC_RG_VUSB33_EN_ADDR, MT6351_PMIC_RG_VUSB33_EN_MASK,
	 MT6351_PMIC_RG_VUSB33_EN_SHIFT},
	{PMIC_RG_VUSB33_MODE_CTRL, MT6351_PMIC_RG_VUSB33_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VUSB33_MODE_CTRL_MASK, MT6351_PMIC_RG_VUSB33_MODE_CTRL_SHIFT},
	{PMIC_RG_VUSB33_ON_CTRL, MT6351_PMIC_RG_VUSB33_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VUSB33_ON_CTRL_MASK, MT6351_PMIC_RG_VUSB33_ON_CTRL_SHIFT},
	{PMIC_RG_VUSB33_SRCLK_MODE_SEL, MT6351_PMIC_RG_VUSB33_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VUSB33_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VUSB33_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VUSB33_MODE, MT6351_PMIC_DA_QI_VUSB33_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VUSB33_MODE_MASK, MT6351_PMIC_DA_QI_VUSB33_MODE_SHIFT},
	{PMIC_RG_VUSB33_STBTD, MT6351_PMIC_RG_VUSB33_STBTD_ADDR,
	 MT6351_PMIC_RG_VUSB33_STBTD_MASK, MT6351_PMIC_RG_VUSB33_STBTD_SHIFT},
	{PMIC_RG_VUSB33_SRCLK_EN_SEL, MT6351_PMIC_RG_VUSB33_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VUSB33_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VUSB33_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VUSB33_STB, MT6351_PMIC_DA_QI_VUSB33_STB_ADDR,
	 MT6351_PMIC_DA_QI_VUSB33_STB_MASK, MT6351_PMIC_DA_QI_VUSB33_STB_SHIFT},
	{PMIC_DA_QI_VUSB33_EN, MT6351_PMIC_DA_QI_VUSB33_EN_ADDR,
	 MT6351_PMIC_DA_QI_VUSB33_EN_MASK, MT6351_PMIC_DA_QI_VUSB33_EN_SHIFT},
	{PMIC_RG_VUSB33_OCFB_EN, MT6351_PMIC_RG_VUSB33_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VUSB33_OCFB_EN_MASK, MT6351_PMIC_RG_VUSB33_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VUSB33_OCFB_EN, MT6351_PMIC_DA_QI_VUSB33_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VUSB33_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VUSB33_OCFB_EN_SHIFT},
	{PMIC_RG_VUSB33_DUMMY_LOAD_EN, MT6351_PMIC_RG_VUSB33_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VUSB33_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VUSB33_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VUSB33_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VUSB33_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VUSB33_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VUSB33_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VUSB33_DUMMY_LOAD, MT6351_PMIC_RG_VUSB33_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VUSB33_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VUSB33_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VUSB33_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VUSB33_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VUSB33_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VUSB33_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VUSB33_DUMMY_LOAD, MT6351_PMIC_DA_QI_VUSB33_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VUSB33_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VUSB33_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VSIM1_MODE_SET, MT6351_PMIC_RG_VSIM1_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VSIM1_MODE_SET_MASK, MT6351_PMIC_RG_VSIM1_MODE_SET_SHIFT},
	{PMIC_RG_VSIM1_EN, MT6351_PMIC_RG_VSIM1_EN_ADDR, MT6351_PMIC_RG_VSIM1_EN_MASK,
	 MT6351_PMIC_RG_VSIM1_EN_SHIFT},
	{PMIC_RG_VSIM1_MODE_CTRL, MT6351_PMIC_RG_VSIM1_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VSIM1_MODE_CTRL_MASK, MT6351_PMIC_RG_VSIM1_MODE_CTRL_SHIFT},
	{PMIC_RG_VSIM1_ON_CTRL, MT6351_PMIC_RG_VSIM1_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VSIM1_ON_CTRL_MASK, MT6351_PMIC_RG_VSIM1_ON_CTRL_SHIFT},
	{PMIC_RG_VSIM1_SRCLK_MODE_SEL, MT6351_PMIC_RG_VSIM1_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VSIM1_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VSIM1_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VSIM1_MODE, MT6351_PMIC_DA_QI_VSIM1_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VSIM1_MODE_MASK, MT6351_PMIC_DA_QI_VSIM1_MODE_SHIFT},
	{PMIC_RG_VSIM1_STBTD, MT6351_PMIC_RG_VSIM1_STBTD_ADDR,
	 MT6351_PMIC_RG_VSIM1_STBTD_MASK, MT6351_PMIC_RG_VSIM1_STBTD_SHIFT},
	{PMIC_RG_VSIM1_SRCLK_EN_SEL, MT6351_PMIC_RG_VSIM1_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VSIM1_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VSIM1_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VSIM1_STB, MT6351_PMIC_DA_QI_VSIM1_STB_ADDR,
	 MT6351_PMIC_DA_QI_VSIM1_STB_MASK, MT6351_PMIC_DA_QI_VSIM1_STB_SHIFT},
	{PMIC_DA_QI_VSIM1_EN, MT6351_PMIC_DA_QI_VSIM1_EN_ADDR,
	 MT6351_PMIC_DA_QI_VSIM1_EN_MASK, MT6351_PMIC_DA_QI_VSIM1_EN_SHIFT},
	{PMIC_RG_VSIM1_OCFB_EN, MT6351_PMIC_RG_VSIM1_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VSIM1_OCFB_EN_MASK, MT6351_PMIC_RG_VSIM1_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VSIM1_OCFB_EN, MT6351_PMIC_DA_QI_VSIM1_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VSIM1_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VSIM1_OCFB_EN_SHIFT},
	{PMIC_RG_VSIM1_DUMMY_LOAD_EN, MT6351_PMIC_RG_VSIM1_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VSIM1_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VSIM1_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VSIM1_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VSIM1_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VSIM1_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VSIM1_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VSIM1_DUMMY_LOAD, MT6351_PMIC_RG_VSIM1_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VSIM1_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VSIM1_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VSIM1_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VSIM1_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VSIM1_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VSIM1_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VSIM1_DUMMY_LOAD, MT6351_PMIC_DA_QI_VSIM1_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VSIM1_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VSIM1_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VSIM2_MODE_SET, MT6351_PMIC_RG_VSIM2_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VSIM2_MODE_SET_MASK, MT6351_PMIC_RG_VSIM2_MODE_SET_SHIFT},
	{PMIC_RG_VSIM2_EN, MT6351_PMIC_RG_VSIM2_EN_ADDR, MT6351_PMIC_RG_VSIM2_EN_MASK,
	 MT6351_PMIC_RG_VSIM2_EN_SHIFT},
	{PMIC_RG_VSIM2_MODE_CTRL, MT6351_PMIC_RG_VSIM2_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VSIM2_MODE_CTRL_MASK, MT6351_PMIC_RG_VSIM2_MODE_CTRL_SHIFT},
	{PMIC_RG_VSIM2_ON_CTRL, MT6351_PMIC_RG_VSIM2_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VSIM2_ON_CTRL_MASK, MT6351_PMIC_RG_VSIM2_ON_CTRL_SHIFT},
	{PMIC_RG_VSIM2_SRCLK_MODE_SEL, MT6351_PMIC_RG_VSIM2_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VSIM2_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VSIM2_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VSIM2_MODE, MT6351_PMIC_DA_QI_VSIM2_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VSIM2_MODE_MASK, MT6351_PMIC_DA_QI_VSIM2_MODE_SHIFT},
	{PMIC_RG_VSIM2_STBTD, MT6351_PMIC_RG_VSIM2_STBTD_ADDR,
	 MT6351_PMIC_RG_VSIM2_STBTD_MASK, MT6351_PMIC_RG_VSIM2_STBTD_SHIFT},
	{PMIC_RG_VSIM2_SRCLK_EN_SEL, MT6351_PMIC_RG_VSIM2_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VSIM2_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VSIM2_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VSIM2_STB, MT6351_PMIC_DA_QI_VSIM2_STB_ADDR,
	 MT6351_PMIC_DA_QI_VSIM2_STB_MASK, MT6351_PMIC_DA_QI_VSIM2_STB_SHIFT},
	{PMIC_DA_QI_VSIM2_EN, MT6351_PMIC_DA_QI_VSIM2_EN_ADDR,
	 MT6351_PMIC_DA_QI_VSIM2_EN_MASK, MT6351_PMIC_DA_QI_VSIM2_EN_SHIFT},
	{PMIC_RG_VSIM2_OCFB_EN, MT6351_PMIC_RG_VSIM2_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VSIM2_OCFB_EN_MASK, MT6351_PMIC_RG_VSIM2_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VSIM2_OCFB_EN, MT6351_PMIC_DA_QI_VSIM2_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VSIM2_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VSIM2_OCFB_EN_SHIFT},
	{PMIC_RG_VSIM2_DUMMY_LOAD_EN, MT6351_PMIC_RG_VSIM2_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VSIM2_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VSIM2_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VSIM2_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VSIM2_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VSIM2_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VSIM2_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VSIM2_DUMMY_LOAD, MT6351_PMIC_RG_VSIM2_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VSIM2_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VSIM2_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VSIM2_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VSIM2_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VSIM2_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VSIM2_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VSIM2_DUMMY_LOAD, MT6351_PMIC_DA_QI_VSIM2_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VSIM2_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VSIM2_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VEMC_MODE_SET, MT6351_PMIC_RG_VEMC_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VEMC_MODE_SET_MASK, MT6351_PMIC_RG_VEMC_MODE_SET_SHIFT},
	{PMIC_RG_VEMC_EN, MT6351_PMIC_RG_VEMC_EN_ADDR, MT6351_PMIC_RG_VEMC_EN_MASK,
	 MT6351_PMIC_RG_VEMC_EN_SHIFT},
	{PMIC_RG_VEMC_MODE_CTRL, MT6351_PMIC_RG_VEMC_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VEMC_MODE_CTRL_MASK, MT6351_PMIC_RG_VEMC_MODE_CTRL_SHIFT},
	{PMIC_RG_VEMC_ON_CTRL, MT6351_PMIC_RG_VEMC_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VEMC_ON_CTRL_MASK, MT6351_PMIC_RG_VEMC_ON_CTRL_SHIFT},
	{PMIC_RG_VEMC_SRCLK_MODE_SEL, MT6351_PMIC_RG_VEMC_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VEMC_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VEMC_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VEMC_MODE, MT6351_PMIC_DA_QI_VEMC_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VEMC_MODE_MASK, MT6351_PMIC_DA_QI_VEMC_MODE_SHIFT},
	{PMIC_RG_VEMC_STBTD, MT6351_PMIC_RG_VEMC_STBTD_ADDR,
	 MT6351_PMIC_RG_VEMC_STBTD_MASK, MT6351_PMIC_RG_VEMC_STBTD_SHIFT},
	{PMIC_RG_VEMC_SRCLK_EN_SEL, MT6351_PMIC_RG_VEMC_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VEMC_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VEMC_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VEMC_STB, MT6351_PMIC_DA_QI_VEMC_STB_ADDR,
	 MT6351_PMIC_DA_QI_VEMC_STB_MASK, MT6351_PMIC_DA_QI_VEMC_STB_SHIFT},
	{PMIC_DA_QI_VEMC_EN, MT6351_PMIC_DA_QI_VEMC_EN_ADDR,
	 MT6351_PMIC_DA_QI_VEMC_EN_MASK, MT6351_PMIC_DA_QI_VEMC_EN_SHIFT},
	{PMIC_RG_VEMC_OCFB_EN, MT6351_PMIC_RG_VEMC_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VEMC_OCFB_EN_MASK, MT6351_PMIC_RG_VEMC_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VEMC_OCFB_EN, MT6351_PMIC_DA_QI_VEMC_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VEMC_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VEMC_OCFB_EN_SHIFT},
	{PMIC_RG_VEMC_DUMMY_LOAD_EN, MT6351_PMIC_RG_VEMC_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VEMC_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VEMC_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VEMC_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VEMC_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VEMC_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VEMC_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VEMC_DUMMY_LOAD, MT6351_PMIC_RG_VEMC_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VEMC_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VEMC_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VEMC_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VEMC_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VEMC_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VEMC_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VEMC_DUMMY_LOAD, MT6351_PMIC_DA_QI_VEMC_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VEMC_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VEMC_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VMCH_MODE_SET, MT6351_PMIC_RG_VMCH_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VMCH_MODE_SET_MASK, MT6351_PMIC_RG_VMCH_MODE_SET_SHIFT},
	{PMIC_RG_VMCH_EN, MT6351_PMIC_RG_VMCH_EN_ADDR, MT6351_PMIC_RG_VMCH_EN_MASK,
	 MT6351_PMIC_RG_VMCH_EN_SHIFT},
	{PMIC_RG_VMCH_MODE_CTRL, MT6351_PMIC_RG_VMCH_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VMCH_MODE_CTRL_MASK, MT6351_PMIC_RG_VMCH_MODE_CTRL_SHIFT},
	{PMIC_RG_VMCH_ON_CTRL, MT6351_PMIC_RG_VMCH_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VMCH_ON_CTRL_MASK, MT6351_PMIC_RG_VMCH_ON_CTRL_SHIFT},
	{PMIC_RG_VMCH_SRCLK_MODE_SEL, MT6351_PMIC_RG_VMCH_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VMCH_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VMCH_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VMCH_MODE, MT6351_PMIC_DA_QI_VMCH_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VMCH_MODE_MASK, MT6351_PMIC_DA_QI_VMCH_MODE_SHIFT},
	{PMIC_RG_VMCH_STBTD, MT6351_PMIC_RG_VMCH_STBTD_ADDR,
	 MT6351_PMIC_RG_VMCH_STBTD_MASK, MT6351_PMIC_RG_VMCH_STBTD_SHIFT},
	{PMIC_RG_VMCH_SRCLK_EN_SEL, MT6351_PMIC_RG_VMCH_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VMCH_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VMCH_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VMCH_STB, MT6351_PMIC_DA_QI_VMCH_STB_ADDR,
	 MT6351_PMIC_DA_QI_VMCH_STB_MASK, MT6351_PMIC_DA_QI_VMCH_STB_SHIFT},
	{PMIC_DA_QI_VMCH_EN, MT6351_PMIC_DA_QI_VMCH_EN_ADDR,
	 MT6351_PMIC_DA_QI_VMCH_EN_MASK, MT6351_PMIC_DA_QI_VMCH_EN_SHIFT},
	{PMIC_RG_VMCH_OCFB_EN, MT6351_PMIC_RG_VMCH_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VMCH_OCFB_EN_MASK, MT6351_PMIC_RG_VMCH_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VMCH_OCFB_EN, MT6351_PMIC_DA_QI_VMCH_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VMCH_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VMCH_OCFB_EN_SHIFT},
	{PMIC_RG_VMCH_DUMMY_LOAD_EN, MT6351_PMIC_RG_VMCH_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VMCH_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VMCH_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VMCH_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VMCH_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VMCH_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VMCH_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VMCH_DUMMY_LOAD, MT6351_PMIC_RG_VMCH_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VMCH_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VMCH_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VMCH_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VMCH_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VMCH_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VMCH_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VMCH_DUMMY_LOAD, MT6351_PMIC_DA_QI_VMCH_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VMCH_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VMCH_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VIO28_MODE_SET, MT6351_PMIC_RG_VIO28_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VIO28_MODE_SET_MASK, MT6351_PMIC_RG_VIO28_MODE_SET_SHIFT},
	{PMIC_RG_VIO28_EN, MT6351_PMIC_RG_VIO28_EN_ADDR, MT6351_PMIC_RG_VIO28_EN_MASK,
	 MT6351_PMIC_RG_VIO28_EN_SHIFT},
	{PMIC_RG_VIO28_MODE_CTRL, MT6351_PMIC_RG_VIO28_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VIO28_MODE_CTRL_MASK, MT6351_PMIC_RG_VIO28_MODE_CTRL_SHIFT},
	{PMIC_RG_VIO28_ON_CTRL, MT6351_PMIC_RG_VIO28_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VIO28_ON_CTRL_MASK, MT6351_PMIC_RG_VIO28_ON_CTRL_SHIFT},
	{PMIC_RG_VIO28_SRCLK_MODE_SEL, MT6351_PMIC_RG_VIO28_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VIO28_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VIO28_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VIO28_MODE, MT6351_PMIC_DA_QI_VIO28_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VIO28_MODE_MASK, MT6351_PMIC_DA_QI_VIO28_MODE_SHIFT},
	{PMIC_RG_VIO28_STBTD, MT6351_PMIC_RG_VIO28_STBTD_ADDR,
	 MT6351_PMIC_RG_VIO28_STBTD_MASK, MT6351_PMIC_RG_VIO28_STBTD_SHIFT},
	{PMIC_RG_VIO28_SRCLK_EN_SEL, MT6351_PMIC_RG_VIO28_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VIO28_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VIO28_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VIO28_STB, MT6351_PMIC_DA_QI_VIO28_STB_ADDR,
	 MT6351_PMIC_DA_QI_VIO28_STB_MASK, MT6351_PMIC_DA_QI_VIO28_STB_SHIFT},
	{PMIC_DA_QI_VIO28_EN, MT6351_PMIC_DA_QI_VIO28_EN_ADDR,
	 MT6351_PMIC_DA_QI_VIO28_EN_MASK, MT6351_PMIC_DA_QI_VIO28_EN_SHIFT},
	{PMIC_RG_VIO28_OCFB_EN, MT6351_PMIC_RG_VIO28_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VIO28_OCFB_EN_MASK, MT6351_PMIC_RG_VIO28_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VIO28_OCFB_EN, MT6351_PMIC_DA_QI_VIO28_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VIO28_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VIO28_OCFB_EN_SHIFT},
	{PMIC_RG_VIO28_DUMMY_LOAD_EN, MT6351_PMIC_RG_VIO28_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VIO28_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VIO28_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VIO28_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VIO28_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VIO28_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VIO28_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VIO28_DUMMY_LOAD, MT6351_PMIC_RG_VIO28_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VIO28_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VIO28_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VIO28_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VIO28_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VIO28_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VIO28_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VIO28_DUMMY_LOAD, MT6351_PMIC_DA_QI_VIO28_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VIO28_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VIO28_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VIBR_MODE_SET, MT6351_PMIC_RG_VIBR_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VIBR_MODE_SET_MASK, MT6351_PMIC_RG_VIBR_MODE_SET_SHIFT},
	{PMIC_RG_VIBR_EN, MT6351_PMIC_RG_VIBR_EN_ADDR, MT6351_PMIC_RG_VIBR_EN_MASK,
	 MT6351_PMIC_RG_VIBR_EN_SHIFT},
	{PMIC_RG_VIBR_MODE_CTRL, MT6351_PMIC_RG_VIBR_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VIBR_MODE_CTRL_MASK, MT6351_PMIC_RG_VIBR_MODE_CTRL_SHIFT},
	{PMIC_RG_VIBR_ON_CTRL, MT6351_PMIC_RG_VIBR_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VIBR_ON_CTRL_MASK, MT6351_PMIC_RG_VIBR_ON_CTRL_SHIFT},
	{PMIC_RG_VIBR_THER_SDN_EN, MT6351_PMIC_RG_VIBR_THER_SDN_EN_ADDR,
	 MT6351_PMIC_RG_VIBR_THER_SDN_EN_MASK, MT6351_PMIC_RG_VIBR_THER_SDN_EN_SHIFT},
	{PMIC_RG_VIBR_SRCLK_MODE_SEL, MT6351_PMIC_RG_VIBR_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VIBR_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VIBR_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VIBR_MODE, MT6351_PMIC_DA_QI_VIBR_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VIBR_MODE_MASK, MT6351_PMIC_DA_QI_VIBR_MODE_SHIFT},
	{PMIC_RG_VIBR_STBTD, MT6351_PMIC_RG_VIBR_STBTD_ADDR,
	 MT6351_PMIC_RG_VIBR_STBTD_MASK, MT6351_PMIC_RG_VIBR_STBTD_SHIFT},
	{PMIC_RG_VIBR_SRCLK_EN_SEL, MT6351_PMIC_RG_VIBR_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VIBR_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VIBR_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VIBR_STB, MT6351_PMIC_DA_QI_VIBR_STB_ADDR,
	 MT6351_PMIC_DA_QI_VIBR_STB_MASK, MT6351_PMIC_DA_QI_VIBR_STB_SHIFT},
	{PMIC_DA_QI_VIBR_EN, MT6351_PMIC_DA_QI_VIBR_EN_ADDR,
	 MT6351_PMIC_DA_QI_VIBR_EN_MASK, MT6351_PMIC_DA_QI_VIBR_EN_SHIFT},
	{PMIC_RG_VIBR_OCFB_EN, MT6351_PMIC_RG_VIBR_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VIBR_OCFB_EN_MASK, MT6351_PMIC_RG_VIBR_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VIBR_OCFB_EN, MT6351_PMIC_DA_QI_VIBR_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VIBR_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VIBR_OCFB_EN_SHIFT},
	{PMIC_RG_VIBR_DUMMY_LOAD_EN, MT6351_PMIC_RG_VIBR_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VIBR_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VIBR_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VIBR_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VIBR_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VIBR_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VIBR_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VIBR_DUMMY_LOAD, MT6351_PMIC_RG_VIBR_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VIBR_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VIBR_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VIBR_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VIBR_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VIBR_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VIBR_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VIBR_DUMMY_LOAD, MT6351_PMIC_DA_QI_VIBR_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VIBR_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VIBR_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VCAMD_MODE_SET, MT6351_PMIC_RG_VCAMD_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VCAMD_MODE_SET_MASK, MT6351_PMIC_RG_VCAMD_MODE_SET_SHIFT},
	{PMIC_RG_VCAMD_EN, MT6351_PMIC_RG_VCAMD_EN_ADDR, MT6351_PMIC_RG_VCAMD_EN_MASK,
	 MT6351_PMIC_RG_VCAMD_EN_SHIFT},
	{PMIC_RG_VCAMD_MODE_CTRL, MT6351_PMIC_RG_VCAMD_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VCAMD_MODE_CTRL_MASK, MT6351_PMIC_RG_VCAMD_MODE_CTRL_SHIFT},
	{PMIC_RG_VCAMD_SRCLK_MODE_SEL, MT6351_PMIC_RG_VCAMD_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VCAMD_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VCAMD_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VCAMD_MODE, MT6351_PMIC_DA_QI_VCAMD_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VCAMD_MODE_MASK, MT6351_PMIC_DA_QI_VCAMD_MODE_SHIFT},
	{PMIC_RG_VCAMD_STBTD, MT6351_PMIC_RG_VCAMD_STBTD_ADDR,
	 MT6351_PMIC_RG_VCAMD_STBTD_MASK, MT6351_PMIC_RG_VCAMD_STBTD_SHIFT},
	{PMIC_DA_QI_VCAMD_STB, MT6351_PMIC_DA_QI_VCAMD_STB_ADDR,
	 MT6351_PMIC_DA_QI_VCAMD_STB_MASK, MT6351_PMIC_DA_QI_VCAMD_STB_SHIFT},
	{PMIC_DA_QI_VCAMD_EN, MT6351_PMIC_DA_QI_VCAMD_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCAMD_EN_MASK, MT6351_PMIC_DA_QI_VCAMD_EN_SHIFT},
	{PMIC_RG_VCAMD_OCFB_EN, MT6351_PMIC_RG_VCAMD_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VCAMD_OCFB_EN_MASK, MT6351_PMIC_RG_VCAMD_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VCAMD_OCFB_EN, MT6351_PMIC_DA_QI_VCAMD_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCAMD_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VCAMD_OCFB_EN_SHIFT},
	{PMIC_RG_VCAMD_DUMMY_LOAD_EN, MT6351_PMIC_RG_VCAMD_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VCAMD_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VCAMD_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VCAMD_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VCAMD_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VCAMD_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VCAMD_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VCAMD_DUMMY_LOAD, MT6351_PMIC_RG_VCAMD_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VCAMD_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VCAMD_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VCAMD_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VCAMD_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VCAMD_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VCAMD_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VCAMD_DUMMY_LOAD, MT6351_PMIC_DA_QI_VCAMD_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VCAMD_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VCAMD_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VRF18_MODE_SET, MT6351_PMIC_RG_VRF18_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VRF18_MODE_SET_MASK, MT6351_PMIC_RG_VRF18_MODE_SET_SHIFT},
	{PMIC_RG_VRF18_EN, MT6351_PMIC_RG_VRF18_EN_ADDR, MT6351_PMIC_RG_VRF18_EN_MASK,
	 MT6351_PMIC_RG_VRF18_EN_SHIFT},
	{PMIC_RG_VRF18_MODE_CTRL, MT6351_PMIC_RG_VRF18_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VRF18_MODE_CTRL_MASK, MT6351_PMIC_RG_VRF18_MODE_CTRL_SHIFT},
	{PMIC_RG_VRF18_ON_CTRL, MT6351_PMIC_RG_VRF18_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VRF18_ON_CTRL_MASK, MT6351_PMIC_RG_VRF18_ON_CTRL_SHIFT},
	{PMIC_RG_VRF18_SRCLK_MODE_SEL, MT6351_PMIC_RG_VRF18_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VRF18_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VRF18_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VRF18_MODE, MT6351_PMIC_DA_QI_VRF18_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VRF18_MODE_MASK, MT6351_PMIC_DA_QI_VRF18_MODE_SHIFT},
	{PMIC_RG_VRF18_STBTD, MT6351_PMIC_RG_VRF18_STBTD_ADDR,
	 MT6351_PMIC_RG_VRF18_STBTD_MASK, MT6351_PMIC_RG_VRF18_STBTD_SHIFT},
	{PMIC_RG_VRF18_SRCLK_EN_SEL, MT6351_PMIC_RG_VRF18_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VRF18_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VRF18_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VRF18_STB, MT6351_PMIC_DA_QI_VRF18_STB_ADDR,
	 MT6351_PMIC_DA_QI_VRF18_STB_MASK, MT6351_PMIC_DA_QI_VRF18_STB_SHIFT},
	{PMIC_DA_QI_VRF18_EN, MT6351_PMIC_DA_QI_VRF18_EN_ADDR,
	 MT6351_PMIC_DA_QI_VRF18_EN_MASK, MT6351_PMIC_DA_QI_VRF18_EN_SHIFT},
	{PMIC_RG_VRF18_OCFB_EN, MT6351_PMIC_RG_VRF18_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VRF18_OCFB_EN_MASK, MT6351_PMIC_RG_VRF18_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VRF18_OCFB_EN, MT6351_PMIC_DA_QI_VRF18_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VRF18_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VRF18_OCFB_EN_SHIFT},
	{PMIC_RG_VRF18_DUMMY_LOAD_EN, MT6351_PMIC_RG_VRF18_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VRF18_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VRF18_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VRF18_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VRF18_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VRF18_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VRF18_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VRF18_DUMMY_LOAD, MT6351_PMIC_RG_VRF18_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VRF18_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VRF18_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VRF18_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VRF18_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VRF18_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VRF18_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VRF18_DUMMY_LOAD, MT6351_PMIC_DA_QI_VRF18_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VRF18_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VRF18_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VIO18_MODE_SET, MT6351_PMIC_RG_VIO18_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VIO18_MODE_SET_MASK, MT6351_PMIC_RG_VIO18_MODE_SET_SHIFT},
	{PMIC_RG_VIO18_EN, MT6351_PMIC_RG_VIO18_EN_ADDR, MT6351_PMIC_RG_VIO18_EN_MASK,
	 MT6351_PMIC_RG_VIO18_EN_SHIFT},
	{PMIC_RG_VIO18_MODE_CTRL, MT6351_PMIC_RG_VIO18_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VIO18_MODE_CTRL_MASK, MT6351_PMIC_RG_VIO18_MODE_CTRL_SHIFT},
	{PMIC_RG_VIO18_ON_CTRL, MT6351_PMIC_RG_VIO18_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VIO18_ON_CTRL_MASK, MT6351_PMIC_RG_VIO18_ON_CTRL_SHIFT},
	{PMIC_RG_VIO18_SRCLK_MODE_SEL, MT6351_PMIC_RG_VIO18_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VIO18_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VIO18_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VIO18_MODE, MT6351_PMIC_DA_QI_VIO18_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VIO18_MODE_MASK, MT6351_PMIC_DA_QI_VIO18_MODE_SHIFT},
	{PMIC_RG_VIO18_STBTD, MT6351_PMIC_RG_VIO18_STBTD_ADDR,
	 MT6351_PMIC_RG_VIO18_STBTD_MASK, MT6351_PMIC_RG_VIO18_STBTD_SHIFT},
	{PMIC_RG_VIO18_SRCLK_EN_SEL, MT6351_PMIC_RG_VIO18_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VIO18_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VIO18_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VIO18_STB, MT6351_PMIC_DA_QI_VIO18_STB_ADDR,
	 MT6351_PMIC_DA_QI_VIO18_STB_MASK, MT6351_PMIC_DA_QI_VIO18_STB_SHIFT},
	{PMIC_DA_QI_VIO18_EN, MT6351_PMIC_DA_QI_VIO18_EN_ADDR,
	 MT6351_PMIC_DA_QI_VIO18_EN_MASK, MT6351_PMIC_DA_QI_VIO18_EN_SHIFT},
	{PMIC_RG_VIO18_OCFB_EN, MT6351_PMIC_RG_VIO18_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VIO18_OCFB_EN_MASK, MT6351_PMIC_RG_VIO18_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VIO18_OCFB_EN, MT6351_PMIC_DA_QI_VIO18_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VIO18_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VIO18_OCFB_EN_SHIFT},
	{PMIC_RG_VIO18_DUMMY_LOAD_EN, MT6351_PMIC_RG_VIO18_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VIO18_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VIO18_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VIO18_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VIO18_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VIO18_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VIO18_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VIO18_DUMMY_LOAD, MT6351_PMIC_RG_VIO18_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VIO18_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VIO18_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VIO18_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VIO18_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VIO18_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VIO18_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VIO18_DUMMY_LOAD, MT6351_PMIC_DA_QI_VIO18_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VIO18_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VIO18_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VCN18_MODE_SET, MT6351_PMIC_RG_VCN18_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VCN18_MODE_SET_MASK, MT6351_PMIC_RG_VCN18_MODE_SET_SHIFT},
	{PMIC_RG_VCN18_EN, MT6351_PMIC_RG_VCN18_EN_ADDR, MT6351_PMIC_RG_VCN18_EN_MASK,
	 MT6351_PMIC_RG_VCN18_EN_SHIFT},
	{PMIC_RG_VCN18_MODE_CTRL, MT6351_PMIC_RG_VCN18_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VCN18_MODE_CTRL_MASK, MT6351_PMIC_RG_VCN18_MODE_CTRL_SHIFT},
	{PMIC_RG_VCN18_ON_CTRL, MT6351_PMIC_RG_VCN18_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VCN18_ON_CTRL_MASK, MT6351_PMIC_RG_VCN18_ON_CTRL_SHIFT},
	{PMIC_RG_VCN18_SRCLK_MODE_SEL, MT6351_PMIC_RG_VCN18_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VCN18_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VCN18_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VCN18_MODE, MT6351_PMIC_DA_QI_VCN18_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VCN18_MODE_MASK, MT6351_PMIC_DA_QI_VCN18_MODE_SHIFT},
	{PMIC_RG_VCN18_STBTD, MT6351_PMIC_RG_VCN18_STBTD_ADDR,
	 MT6351_PMIC_RG_VCN18_STBTD_MASK, MT6351_PMIC_RG_VCN18_STBTD_SHIFT},
	{PMIC_RG_VCN18_SRCLK_EN_SEL, MT6351_PMIC_RG_VCN18_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VCN18_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VCN18_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VCN18_STB, MT6351_PMIC_DA_QI_VCN18_STB_ADDR,
	 MT6351_PMIC_DA_QI_VCN18_STB_MASK, MT6351_PMIC_DA_QI_VCN18_STB_SHIFT},
	{PMIC_DA_QI_VCN18_EN, MT6351_PMIC_DA_QI_VCN18_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCN18_EN_MASK, MT6351_PMIC_DA_QI_VCN18_EN_SHIFT},
	{PMIC_RG_VCN18_OCFB_EN, MT6351_PMIC_RG_VCN18_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VCN18_OCFB_EN_MASK, MT6351_PMIC_RG_VCN18_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VCN18_OCFB_EN, MT6351_PMIC_DA_QI_VCN18_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCN18_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VCN18_OCFB_EN_SHIFT},
	{PMIC_RG_VCN18_DUMMY_LOAD_EN, MT6351_PMIC_RG_VCN18_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VCN18_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VCN18_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VCN18_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VCN18_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VCN18_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VCN18_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VCN18_DUMMY_LOAD, MT6351_PMIC_RG_VCN18_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VCN18_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VCN18_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VCN18_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VCN18_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VCN18_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VCN18_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VCN18_DUMMY_LOAD, MT6351_PMIC_DA_QI_VCN18_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VCN18_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VCN18_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VCAMIO_MODE_SET, MT6351_PMIC_RG_VCAMIO_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VCAMIO_MODE_SET_MASK, MT6351_PMIC_RG_VCAMIO_MODE_SET_SHIFT},
	{PMIC_RG_VCAMIO_EN, MT6351_PMIC_RG_VCAMIO_EN_ADDR, MT6351_PMIC_RG_VCAMIO_EN_MASK,
	 MT6351_PMIC_RG_VCAMIO_EN_SHIFT},
	{PMIC_RG_VCAMIO_MODE_CTRL, MT6351_PMIC_RG_VCAMIO_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VCAMIO_MODE_CTRL_MASK, MT6351_PMIC_RG_VCAMIO_MODE_CTRL_SHIFT},
	{PMIC_RG_VCAMIO_SRCLK_MODE_SEL, MT6351_PMIC_RG_VCAMIO_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VCAMIO_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VCAMIO_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VCAMIO_MODE, MT6351_PMIC_DA_QI_VCAMIO_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VCAMIO_MODE_MASK, MT6351_PMIC_DA_QI_VCAMIO_MODE_SHIFT},
	{PMIC_RG_VCAMIO_STBTD, MT6351_PMIC_RG_VCAMIO_STBTD_ADDR,
	 MT6351_PMIC_RG_VCAMIO_STBTD_MASK, MT6351_PMIC_RG_VCAMIO_STBTD_SHIFT},
	{PMIC_DA_QI_VCAMIO_STB, MT6351_PMIC_DA_QI_VCAMIO_STB_ADDR,
	 MT6351_PMIC_DA_QI_VCAMIO_STB_MASK, MT6351_PMIC_DA_QI_VCAMIO_STB_SHIFT},
	{PMIC_DA_QI_VCAMIO_EN, MT6351_PMIC_DA_QI_VCAMIO_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCAMIO_EN_MASK, MT6351_PMIC_DA_QI_VCAMIO_EN_SHIFT},
	{PMIC_RG_VCAMIO_OCFB_EN, MT6351_PMIC_RG_VCAMIO_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VCAMIO_OCFB_EN_MASK, MT6351_PMIC_RG_VCAMIO_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VCAMIO_OCFB_EN, MT6351_PMIC_DA_QI_VCAMIO_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCAMIO_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VCAMIO_OCFB_EN_SHIFT},
	{PMIC_RG_VCAMIO_DUMMY_LOAD_EN, MT6351_PMIC_RG_VCAMIO_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VCAMIO_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VCAMIO_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VCAMIO_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VCAMIO_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VCAMIO_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VCAMIO_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VCAMIO_DUMMY_LOAD, MT6351_PMIC_RG_VCAMIO_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VCAMIO_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VCAMIO_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VCAMIO_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VCAMIO_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VCAMIO_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VCAMIO_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VCAMIO_DUMMY_LOAD, MT6351_PMIC_DA_QI_VCAMIO_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VCAMIO_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VCAMIO_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VSRAM_PROC_MODE_SET, MT6351_PMIC_RG_VSRAM_PROC_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_MODE_SET_MASK, MT6351_PMIC_RG_VSRAM_PROC_MODE_SET_SHIFT},
	{PMIC_RG_VSRAM_PROC_EN, MT6351_PMIC_RG_VSRAM_PROC_EN_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_EN_MASK, MT6351_PMIC_RG_VSRAM_PROC_EN_SHIFT},
	{PMIC_RG_VSRAM_PROC_MODE_CTRL, MT6351_PMIC_RG_VSRAM_PROC_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_MODE_CTRL_MASK, MT6351_PMIC_RG_VSRAM_PROC_MODE_CTRL_SHIFT},
	{PMIC_RG_VSRAM_PROC_ON_CTRL, MT6351_PMIC_RG_VSRAM_PROC_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_ON_CTRL_MASK, MT6351_PMIC_RG_VSRAM_PROC_ON_CTRL_SHIFT},
	{PMIC_RG_VSRAM_PROC_SRCLK_MODE_SEL, MT6351_PMIC_RG_VSRAM_PROC_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_SRCLK_MODE_SEL_MASK,
	 MT6351_PMIC_RG_VSRAM_PROC_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VSRAM_PROC_MODE, MT6351_PMIC_DA_QI_VSRAM_PROC_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VSRAM_PROC_MODE_MASK, MT6351_PMIC_DA_QI_VSRAM_PROC_MODE_SHIFT},
	{PMIC_RG_VSRAM_PROC_STBTD, MT6351_PMIC_RG_VSRAM_PROC_STBTD_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_STBTD_MASK, MT6351_PMIC_RG_VSRAM_PROC_STBTD_SHIFT},
	{PMIC_RG_VSRAM_PROC_SRCLK_EN_SEL, MT6351_PMIC_RG_VSRAM_PROC_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_SRCLK_EN_SEL_MASK,
	 MT6351_PMIC_RG_VSRAM_PROC_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VSRAM_PROC_STB, MT6351_PMIC_DA_QI_VSRAM_PROC_STB_ADDR,
	 MT6351_PMIC_DA_QI_VSRAM_PROC_STB_MASK, MT6351_PMIC_DA_QI_VSRAM_PROC_STB_SHIFT},
	{PMIC_DA_QI_VSRAM_PROC_EN, MT6351_PMIC_DA_QI_VSRAM_PROC_EN_ADDR,
	 MT6351_PMIC_DA_QI_VSRAM_PROC_EN_MASK, MT6351_PMIC_DA_QI_VSRAM_PROC_EN_SHIFT},
	{PMIC_RG_VSRAM_PROC_OCFB_EN, MT6351_PMIC_RG_VSRAM_PROC_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_OCFB_EN_MASK, MT6351_PMIC_RG_VSRAM_PROC_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VSRAM_PROC_OCFB_EN, MT6351_PMIC_DA_QI_VSRAM_PROC_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VSRAM_PROC_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VSRAM_PROC_OCFB_EN_SHIFT},
	{PMIC_RG_VSRAM_PROC_DUMMY_LOAD_EN, MT6351_PMIC_RG_VSRAM_PROC_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_DUMMY_LOAD_EN_MASK,
	 MT6351_PMIC_RG_VSRAM_PROC_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VSRAM_PROC_DUMMY_LOAD_CTRL,
	 MT6351_PMIC_RG_VSRAM_PROC_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_DUMMY_LOAD_CTRL_MASK,
	 MT6351_PMIC_RG_VSRAM_PROC_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VSRAM_PROC_DUMMY_LOAD, MT6351_PMIC_RG_VSRAM_PROC_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VSRAM_PROC_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VSRAM_PROC_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VSRAM_PROC_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VSRAM_PROC_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VSRAM_PROC_DUMMY_LOAD, MT6351_PMIC_DA_QI_VSRAM_PROC_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VSRAM_PROC_DUMMY_LOAD_MASK,
	 MT6351_PMIC_DA_QI_VSRAM_PROC_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VXO22_MODE_SET, MT6351_PMIC_RG_VXO22_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VXO22_MODE_SET_MASK, MT6351_PMIC_RG_VXO22_MODE_SET_SHIFT},
	{PMIC_RG_VXO22_EN, MT6351_PMIC_RG_VXO22_EN_ADDR, MT6351_PMIC_RG_VXO22_EN_MASK,
	 MT6351_PMIC_RG_VXO22_EN_SHIFT},
	{PMIC_RG_VXO22_MODE_CTRL, MT6351_PMIC_RG_VXO22_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VXO22_MODE_CTRL_MASK, MT6351_PMIC_RG_VXO22_MODE_CTRL_SHIFT},
	{PMIC_RG_VXO22_ON_CTRL, MT6351_PMIC_RG_VXO22_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VXO22_ON_CTRL_MASK, MT6351_PMIC_RG_VXO22_ON_CTRL_SHIFT},
	{PMIC_RG_VXO22_SWITCH, MT6351_PMIC_RG_VXO22_SWITCH_ADDR,
	 MT6351_PMIC_RG_VXO22_SWITCH_MASK, MT6351_PMIC_RG_VXO22_SWITCH_SHIFT},
	{PMIC_RG_VXO22_SRCLK_MODE_SEL, MT6351_PMIC_RG_VXO22_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VXO22_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VXO22_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VXO22_MODE, MT6351_PMIC_DA_QI_VXO22_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VXO22_MODE_MASK, MT6351_PMIC_DA_QI_VXO22_MODE_SHIFT},
	{PMIC_RG_VXO22_STBTD, MT6351_PMIC_RG_VXO22_STBTD_ADDR,
	 MT6351_PMIC_RG_VXO22_STBTD_MASK, MT6351_PMIC_RG_VXO22_STBTD_SHIFT},
	{PMIC_RG_VXO22_SRCLK_EN_SEL, MT6351_PMIC_RG_VXO22_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VXO22_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VXO22_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VXO22_STB, MT6351_PMIC_DA_QI_VXO22_STB_ADDR,
	 MT6351_PMIC_DA_QI_VXO22_STB_MASK, MT6351_PMIC_DA_QI_VXO22_STB_SHIFT},
	{PMIC_DA_QI_VXO22_EN, MT6351_PMIC_DA_QI_VXO22_EN_ADDR,
	 MT6351_PMIC_DA_QI_VXO22_EN_MASK, MT6351_PMIC_DA_QI_VXO22_EN_SHIFT},
	{PMIC_RG_VXO22_OCFB_EN, MT6351_PMIC_RG_VXO22_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VXO22_OCFB_EN_MASK, MT6351_PMIC_RG_VXO22_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VXO22_OCFB_EN, MT6351_PMIC_DA_QI_VXO22_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VXO22_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VXO22_OCFB_EN_SHIFT},
	{PMIC_RG_VRF12_MODE_SET, MT6351_PMIC_RG_VRF12_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VRF12_MODE_SET_MASK, MT6351_PMIC_RG_VRF12_MODE_SET_SHIFT},
	{PMIC_RG_VRF12_EN, MT6351_PMIC_RG_VRF12_EN_ADDR, MT6351_PMIC_RG_VRF12_EN_MASK,
	 MT6351_PMIC_RG_VRF12_EN_SHIFT},
	{PMIC_RG_VRF12_MODE_CTRL, MT6351_PMIC_RG_VRF12_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VRF12_MODE_CTRL_MASK, MT6351_PMIC_RG_VRF12_MODE_CTRL_SHIFT},
	{PMIC_RG_VRF12_ON_CTRL, MT6351_PMIC_RG_VRF12_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VRF12_ON_CTRL_MASK, MT6351_PMIC_RG_VRF12_ON_CTRL_SHIFT},
	{PMIC_RG_VRF12_SRCLK_MODE_SEL, MT6351_PMIC_RG_VRF12_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VRF12_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VRF12_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VRF12_MODE, MT6351_PMIC_DA_QI_VRF12_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VRF12_MODE_MASK, MT6351_PMIC_DA_QI_VRF12_MODE_SHIFT},
	{PMIC_RG_VRF12_STBTD, MT6351_PMIC_RG_VRF12_STBTD_ADDR,
	 MT6351_PMIC_RG_VRF12_STBTD_MASK, MT6351_PMIC_RG_VRF12_STBTD_SHIFT},
	{PMIC_RG_VRF12_SRCLK_EN_SEL, MT6351_PMIC_RG_VRF12_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VRF12_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VRF12_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VRF12_STB, MT6351_PMIC_DA_QI_VRF12_STB_ADDR,
	 MT6351_PMIC_DA_QI_VRF12_STB_MASK, MT6351_PMIC_DA_QI_VRF12_STB_SHIFT},
	{PMIC_DA_QI_VRF12_EN, MT6351_PMIC_DA_QI_VRF12_EN_ADDR,
	 MT6351_PMIC_DA_QI_VRF12_EN_MASK, MT6351_PMIC_DA_QI_VRF12_EN_SHIFT},
	{PMIC_RG_VRF12_OCFB_EN, MT6351_PMIC_RG_VRF12_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VRF12_OCFB_EN_MASK, MT6351_PMIC_RG_VRF12_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VRF12_OCFB_EN, MT6351_PMIC_DA_QI_VRF12_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VRF12_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VRF12_OCFB_EN_SHIFT},
	{PMIC_RG_VRF12_DUMMY_LOAD_EN, MT6351_PMIC_RG_VRF12_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VRF12_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VRF12_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VRF12_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VRF12_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VRF12_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VRF12_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VRF12_DUMMY_LOAD, MT6351_PMIC_RG_VRF12_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VRF12_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VRF12_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VRF12_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VRF12_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VRF12_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VRF12_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VRF12_DUMMY_LOAD, MT6351_PMIC_DA_QI_VRF12_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VRF12_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VRF12_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VA10_MODE_SET, MT6351_PMIC_RG_VA10_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VA10_MODE_SET_MASK, MT6351_PMIC_RG_VA10_MODE_SET_SHIFT},
	{PMIC_RG_VA10_EN, MT6351_PMIC_RG_VA10_EN_ADDR, MT6351_PMIC_RG_VA10_EN_MASK,
	 MT6351_PMIC_RG_VA10_EN_SHIFT},
	{PMIC_RG_VA10_MODE_CTRL, MT6351_PMIC_RG_VA10_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VA10_MODE_CTRL_MASK, MT6351_PMIC_RG_VA10_MODE_CTRL_SHIFT},
	{PMIC_RG_VA10_ON_CTRL, MT6351_PMIC_RG_VA10_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VA10_ON_CTRL_MASK, MT6351_PMIC_RG_VA10_ON_CTRL_SHIFT},
	{PMIC_RG_VA10_SRCLK_MODE_SEL, MT6351_PMIC_RG_VA10_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VA10_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VA10_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VA10_MODE, MT6351_PMIC_DA_QI_VA10_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VA10_MODE_MASK, MT6351_PMIC_DA_QI_VA10_MODE_SHIFT},
	{PMIC_RG_VA10_STBTD, MT6351_PMIC_RG_VA10_STBTD_ADDR,
	 MT6351_PMIC_RG_VA10_STBTD_MASK, MT6351_PMIC_RG_VA10_STBTD_SHIFT},
	{PMIC_RG_VA10_SRCLK_EN_SEL, MT6351_PMIC_RG_VA10_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VA10_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VA10_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VA10_STB, MT6351_PMIC_DA_QI_VA10_STB_ADDR,
	 MT6351_PMIC_DA_QI_VA10_STB_MASK, MT6351_PMIC_DA_QI_VA10_STB_SHIFT},
	{PMIC_DA_QI_VA10_EN, MT6351_PMIC_DA_QI_VA10_EN_ADDR,
	 MT6351_PMIC_DA_QI_VA10_EN_MASK, MT6351_PMIC_DA_QI_VA10_EN_SHIFT},
	{PMIC_RG_VA10_OCFB_EN, MT6351_PMIC_RG_VA10_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VA10_OCFB_EN_MASK, MT6351_PMIC_RG_VA10_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VA10_OCFB_EN, MT6351_PMIC_DA_QI_VA10_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VA10_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VA10_OCFB_EN_SHIFT},
	{PMIC_RG_VA10_DUMMY_LOAD_EN, MT6351_PMIC_RG_VA10_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VA10_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VA10_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VA10_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VA10_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VA10_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VA10_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VA10_DUMMY_LOAD, MT6351_PMIC_RG_VA10_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VA10_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VA10_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VA10_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VA10_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VA10_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VA10_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VA10_DUMMY_LOAD, MT6351_PMIC_DA_QI_VA10_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VA10_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VA10_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VDRAM_MODE_SET, MT6351_PMIC_RG_VDRAM_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VDRAM_MODE_SET_MASK, MT6351_PMIC_RG_VDRAM_MODE_SET_SHIFT},
	{PMIC_RG_VDRAM_EN, MT6351_PMIC_RG_VDRAM_EN_ADDR, MT6351_PMIC_RG_VDRAM_EN_MASK,
	 MT6351_PMIC_RG_VDRAM_EN_SHIFT},
	{PMIC_RG_VDRAM_MODE_CTRL, MT6351_PMIC_RG_VDRAM_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VDRAM_MODE_CTRL_MASK, MT6351_PMIC_RG_VDRAM_MODE_CTRL_SHIFT},
	{PMIC_RG_VDRAM_ON_CTRL, MT6351_PMIC_RG_VDRAM_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VDRAM_ON_CTRL_MASK, MT6351_PMIC_RG_VDRAM_ON_CTRL_SHIFT},
	{PMIC_RG_VDRAM_SRCLK_MODE_SEL, MT6351_PMIC_RG_VDRAM_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VDRAM_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VDRAM_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VDRAM_MODE, MT6351_PMIC_DA_QI_VDRAM_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VDRAM_MODE_MASK, MT6351_PMIC_DA_QI_VDRAM_MODE_SHIFT},
	{PMIC_RG_VDRAM_STBTD, MT6351_PMIC_RG_VDRAM_STBTD_ADDR,
	 MT6351_PMIC_RG_VDRAM_STBTD_MASK, MT6351_PMIC_RG_VDRAM_STBTD_SHIFT},
	{PMIC_RG_VDRAM_SRCLK_EN_SEL, MT6351_PMIC_RG_VDRAM_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VDRAM_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VDRAM_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VDRAM_STB, MT6351_PMIC_DA_QI_VDRAM_STB_ADDR,
	 MT6351_PMIC_DA_QI_VDRAM_STB_MASK, MT6351_PMIC_DA_QI_VDRAM_STB_SHIFT},
	{PMIC_DA_QI_VDRAM_EN, MT6351_PMIC_DA_QI_VDRAM_EN_ADDR,
	 MT6351_PMIC_DA_QI_VDRAM_EN_MASK, MT6351_PMIC_DA_QI_VDRAM_EN_SHIFT},
	{PMIC_RG_VDRAM_OCFB_EN, MT6351_PMIC_RG_VDRAM_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VDRAM_OCFB_EN_MASK, MT6351_PMIC_RG_VDRAM_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VDRAM_OCFB_EN, MT6351_PMIC_DA_QI_VDRAM_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VDRAM_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VDRAM_OCFB_EN_SHIFT},
	{PMIC_RG_VDRAM_DUMMY_LOAD_EN, MT6351_PMIC_RG_VDRAM_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VDRAM_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VDRAM_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VDRAM_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VDRAM_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VDRAM_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VDRAM_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VDRAM_DUMMY_LOAD, MT6351_PMIC_RG_VDRAM_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VDRAM_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VDRAM_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VDRAM_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VDRAM_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VDRAM_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VDRAM_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VDRAM_DUMMY_LOAD, MT6351_PMIC_DA_QI_VDRAM_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VDRAM_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VDRAM_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VMIPI_MODE_SET, MT6351_PMIC_RG_VMIPI_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VMIPI_MODE_SET_MASK, MT6351_PMIC_RG_VMIPI_MODE_SET_SHIFT},
	{PMIC_RG_VMIPI_EN, MT6351_PMIC_RG_VMIPI_EN_ADDR, MT6351_PMIC_RG_VMIPI_EN_MASK,
	 MT6351_PMIC_RG_VMIPI_EN_SHIFT},
	{PMIC_RG_VMIPI_MODE_CTRL, MT6351_PMIC_RG_VMIPI_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VMIPI_MODE_CTRL_MASK, MT6351_PMIC_RG_VMIPI_MODE_CTRL_SHIFT},
	{PMIC_RG_VMIPI_ON_CTRL, MT6351_PMIC_RG_VMIPI_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VMIPI_ON_CTRL_MASK, MT6351_PMIC_RG_VMIPI_ON_CTRL_SHIFT},
	{PMIC_RG_VMIPI_SRCLK_MODE_SEL, MT6351_PMIC_RG_VMIPI_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VMIPI_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VMIPI_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VMIPI_MODE, MT6351_PMIC_DA_QI_VMIPI_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VMIPI_MODE_MASK, MT6351_PMIC_DA_QI_VMIPI_MODE_SHIFT},
	{PMIC_RG_VMIPI_STBTD, MT6351_PMIC_RG_VMIPI_STBTD_ADDR,
	 MT6351_PMIC_RG_VMIPI_STBTD_MASK, MT6351_PMIC_RG_VMIPI_STBTD_SHIFT},
	{PMIC_RG_VMIPI_SRCLK_EN_SEL, MT6351_PMIC_RG_VMIPI_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VMIPI_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VMIPI_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VMIPI_STB, MT6351_PMIC_DA_QI_VMIPI_STB_ADDR,
	 MT6351_PMIC_DA_QI_VMIPI_STB_MASK, MT6351_PMIC_DA_QI_VMIPI_STB_SHIFT},
	{PMIC_DA_QI_VMIPI_EN, MT6351_PMIC_DA_QI_VMIPI_EN_ADDR,
	 MT6351_PMIC_DA_QI_VMIPI_EN_MASK, MT6351_PMIC_DA_QI_VMIPI_EN_SHIFT},
	{PMIC_RG_VMIPI_OCFB_EN, MT6351_PMIC_RG_VMIPI_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VMIPI_OCFB_EN_MASK, MT6351_PMIC_RG_VMIPI_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VMIPI_OCFB_EN, MT6351_PMIC_DA_QI_VMIPI_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VMIPI_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VMIPI_OCFB_EN_SHIFT},
	{PMIC_RG_VMIPI_DUMMY_LOAD_EN, MT6351_PMIC_RG_VMIPI_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VMIPI_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VMIPI_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VMIPI_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VMIPI_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VMIPI_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VMIPI_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VMIPI_DUMMY_LOAD, MT6351_PMIC_RG_VMIPI_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VMIPI_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VMIPI_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VMIPI_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VMIPI_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VMIPI_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VMIPI_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VMIPI_DUMMY_LOAD, MT6351_PMIC_DA_QI_VMIPI_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VMIPI_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VMIPI_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VGP3_MODE_SET, MT6351_PMIC_RG_VGP3_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VGP3_MODE_SET_MASK, MT6351_PMIC_RG_VGP3_MODE_SET_SHIFT},
	{PMIC_RG_VGP3_EN, MT6351_PMIC_RG_VGP3_EN_ADDR, MT6351_PMIC_RG_VGP3_EN_MASK,
	 MT6351_PMIC_RG_VGP3_EN_SHIFT},
	{PMIC_RG_VGP3_MODE_CTRL, MT6351_PMIC_RG_VGP3_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VGP3_MODE_CTRL_MASK, MT6351_PMIC_RG_VGP3_MODE_CTRL_SHIFT},
	{PMIC_RG_VGP3_ON_CTRL, MT6351_PMIC_RG_VGP3_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VGP3_ON_CTRL_MASK, MT6351_PMIC_RG_VGP3_ON_CTRL_SHIFT},
	{PMIC_RG_VGP3_SRCLK_MODE_SEL, MT6351_PMIC_RG_VGP3_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VGP3_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VGP3_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VGP3_MODE, MT6351_PMIC_DA_QI_VGP3_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VGP3_MODE_MASK, MT6351_PMIC_DA_QI_VGP3_MODE_SHIFT},
	{PMIC_RG_VGP3_STBTD, MT6351_PMIC_RG_VGP3_STBTD_ADDR,
	 MT6351_PMIC_RG_VGP3_STBTD_MASK, MT6351_PMIC_RG_VGP3_STBTD_SHIFT},
	{PMIC_RG_VGP3_SRCLK_EN_SEL, MT6351_PMIC_RG_VGP3_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VGP3_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VGP3_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VGP3_STB, MT6351_PMIC_DA_QI_VGP3_STB_ADDR,
	 MT6351_PMIC_DA_QI_VGP3_STB_MASK, MT6351_PMIC_DA_QI_VGP3_STB_SHIFT},
	{PMIC_DA_QI_VGP3_EN, MT6351_PMIC_DA_QI_VGP3_EN_ADDR,
	 MT6351_PMIC_DA_QI_VGP3_EN_MASK, MT6351_PMIC_DA_QI_VGP3_EN_SHIFT},
	{PMIC_RG_VGP3_OCFB_EN, MT6351_PMIC_RG_VGP3_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VGP3_OCFB_EN_MASK, MT6351_PMIC_RG_VGP3_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VGP3_OCFB_EN, MT6351_PMIC_DA_QI_VGP3_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VGP3_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VGP3_OCFB_EN_SHIFT},
	{PMIC_RG_VGP3_DUMMY_LOAD_EN, MT6351_PMIC_RG_VGP3_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VGP3_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VGP3_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VGP3_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VGP3_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VGP3_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VGP3_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VGP3_DUMMY_LOAD, MT6351_PMIC_RG_VGP3_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VGP3_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VGP3_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VGP3_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VGP3_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VGP3_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VGP3_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VGP3_DUMMY_LOAD, MT6351_PMIC_DA_QI_VGP3_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VGP3_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VGP3_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VBIF28_MODE_SET, MT6351_PMIC_RG_VBIF28_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VBIF28_MODE_SET_MASK, MT6351_PMIC_RG_VBIF28_MODE_SET_SHIFT},
	{PMIC_RG_VBIF28_EN, MT6351_PMIC_RG_VBIF28_EN_ADDR, MT6351_PMIC_RG_VBIF28_EN_MASK,
	 MT6351_PMIC_RG_VBIF28_EN_SHIFT},
	{PMIC_RG_VBIF28_MODE_CTRL, MT6351_PMIC_RG_VBIF28_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VBIF28_MODE_CTRL_MASK, MT6351_PMIC_RG_VBIF28_MODE_CTRL_SHIFT},
	{PMIC_RG_VBIF28_ON_CTRL, MT6351_PMIC_RG_VBIF28_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VBIF28_ON_CTRL_MASK, MT6351_PMIC_RG_VBIF28_ON_CTRL_SHIFT},
	{PMIC_RG_VBIF28_SRCLK_MODE_SEL, MT6351_PMIC_RG_VBIF28_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VBIF28_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VBIF28_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VBIF28_MODE, MT6351_PMIC_DA_QI_VBIF28_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VBIF28_MODE_MASK, MT6351_PMIC_DA_QI_VBIF28_MODE_SHIFT},
	{PMIC_RG_VBIF28_STBTD, MT6351_PMIC_RG_VBIF28_STBTD_ADDR,
	 MT6351_PMIC_RG_VBIF28_STBTD_MASK, MT6351_PMIC_RG_VBIF28_STBTD_SHIFT},
	{PMIC_RG_VBIF28_SRCLK_EN_SEL, MT6351_PMIC_RG_VBIF28_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VBIF28_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VBIF28_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VBIF28_STB, MT6351_PMIC_DA_QI_VBIF28_STB_ADDR,
	 MT6351_PMIC_DA_QI_VBIF28_STB_MASK, MT6351_PMIC_DA_QI_VBIF28_STB_SHIFT},
	{PMIC_DA_QI_VBIF28_EN, MT6351_PMIC_DA_QI_VBIF28_EN_ADDR,
	 MT6351_PMIC_DA_QI_VBIF28_EN_MASK, MT6351_PMIC_DA_QI_VBIF28_EN_SHIFT},
	{PMIC_RG_VBIF28_OCFB_EN, MT6351_PMIC_RG_VBIF28_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VBIF28_OCFB_EN_MASK, MT6351_PMIC_RG_VBIF28_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VBIF28_OCFB_EN, MT6351_PMIC_DA_QI_VBIF28_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VBIF28_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VBIF28_OCFB_EN_SHIFT},
	{PMIC_RG_VBIF28_DUMMY_LOAD_EN, MT6351_PMIC_RG_VBIF28_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VBIF28_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VBIF28_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VBIF28_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VBIF28_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VBIF28_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VBIF28_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VBIF28_DUMMY_LOAD, MT6351_PMIC_RG_VBIF28_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VBIF28_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VBIF28_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VBIF28_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VBIF28_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VBIF28_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VBIF28_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VBIF28_DUMMY_LOAD, MT6351_PMIC_DA_QI_VBIF28_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VBIF28_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VBIF28_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VEFUSE_MODE_SET, MT6351_PMIC_RG_VEFUSE_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VEFUSE_MODE_SET_MASK, MT6351_PMIC_RG_VEFUSE_MODE_SET_SHIFT},
	{PMIC_RG_VEFUSE_EN, MT6351_PMIC_RG_VEFUSE_EN_ADDR, MT6351_PMIC_RG_VEFUSE_EN_MASK,
	 MT6351_PMIC_RG_VEFUSE_EN_SHIFT},
	{PMIC_RG_VEFUSE_MODE_CTRL, MT6351_PMIC_RG_VEFUSE_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VEFUSE_MODE_CTRL_MASK, MT6351_PMIC_RG_VEFUSE_MODE_CTRL_SHIFT},
	{PMIC_RG_VEFUSE_SRCLK_MODE_SEL, MT6351_PMIC_RG_VEFUSE_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VEFUSE_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VEFUSE_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VEFUSE_MODE, MT6351_PMIC_DA_QI_VEFUSE_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VEFUSE_MODE_MASK, MT6351_PMIC_DA_QI_VEFUSE_MODE_SHIFT},
	{PMIC_RG_VEFUSE_STBTD, MT6351_PMIC_RG_VEFUSE_STBTD_ADDR,
	 MT6351_PMIC_RG_VEFUSE_STBTD_MASK, MT6351_PMIC_RG_VEFUSE_STBTD_SHIFT},
	{PMIC_DA_QI_VEFUSE_STB, MT6351_PMIC_DA_QI_VEFUSE_STB_ADDR,
	 MT6351_PMIC_DA_QI_VEFUSE_STB_MASK, MT6351_PMIC_DA_QI_VEFUSE_STB_SHIFT},
	{PMIC_DA_QI_VEFUSE_EN, MT6351_PMIC_DA_QI_VEFUSE_EN_ADDR,
	 MT6351_PMIC_DA_QI_VEFUSE_EN_MASK, MT6351_PMIC_DA_QI_VEFUSE_EN_SHIFT},
	{PMIC_RG_VEFUSE_OCFB_EN, MT6351_PMIC_RG_VEFUSE_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VEFUSE_OCFB_EN_MASK, MT6351_PMIC_RG_VEFUSE_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VEFUSE_OCFB_EN, MT6351_PMIC_DA_QI_VEFUSE_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VEFUSE_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VEFUSE_OCFB_EN_SHIFT},
	{PMIC_RG_VEFUSE_DUMMY_LOAD_EN, MT6351_PMIC_RG_VEFUSE_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VEFUSE_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VEFUSE_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VEFUSE_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VEFUSE_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VEFUSE_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VEFUSE_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VEFUSE_DUMMY_LOAD, MT6351_PMIC_RG_VEFUSE_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VEFUSE_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VEFUSE_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VEFUSE_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VEFUSE_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VEFUSE_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VEFUSE_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VEFUSE_DUMMY_LOAD, MT6351_PMIC_DA_QI_VEFUSE_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VEFUSE_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VEFUSE_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VCN33_MODE_SET, MT6351_PMIC_RG_VCN33_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VCN33_MODE_SET_MASK, MT6351_PMIC_RG_VCN33_MODE_SET_SHIFT},
	{PMIC_RG_VCN33_MODE_CTRL, MT6351_PMIC_RG_VCN33_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VCN33_MODE_CTRL_MASK, MT6351_PMIC_RG_VCN33_MODE_CTRL_SHIFT},
	{PMIC_RG_VCN33_SRCLK_MODE_SEL, MT6351_PMIC_RG_VCN33_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VCN33_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VCN33_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VCN33_MODE, MT6351_PMIC_DA_QI_VCN33_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VCN33_MODE_MASK, MT6351_PMIC_DA_QI_VCN33_MODE_SHIFT},
	{PMIC_RG_VCN33_STBTD, MT6351_PMIC_RG_VCN33_STBTD_ADDR,
	 MT6351_PMIC_RG_VCN33_STBTD_MASK, MT6351_PMIC_RG_VCN33_STBTD_SHIFT},
	{PMIC_DA_QI_VCN33_STB, MT6351_PMIC_DA_QI_VCN33_STB_ADDR,
	 MT6351_PMIC_DA_QI_VCN33_STB_MASK, MT6351_PMIC_DA_QI_VCN33_STB_SHIFT},
	{PMIC_DA_QI_VCN33_EN, MT6351_PMIC_DA_QI_VCN33_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCN33_EN_MASK, MT6351_PMIC_DA_QI_VCN33_EN_SHIFT},
	{PMIC_RG_VCN33_OCFB_EN, MT6351_PMIC_RG_VCN33_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VCN33_OCFB_EN_MASK, MT6351_PMIC_RG_VCN33_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VCN33_OCFB_EN, MT6351_PMIC_DA_QI_VCN33_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VCN33_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VCN33_OCFB_EN_SHIFT},
	{PMIC_RG_VCN33_DUMMY_LOAD_EN, MT6351_PMIC_RG_VCN33_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VCN33_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VCN33_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VCN33_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VCN33_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VCN33_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VCN33_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VCN33_DUMMY_LOAD, MT6351_PMIC_RG_VCN33_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VCN33_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VCN33_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VCN33_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VCN33_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VCN33_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VCN33_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VCN33_DUMMY_LOAD, MT6351_PMIC_DA_QI_VCN33_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VCN33_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VCN33_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VCN33_EN_BT, MT6351_PMIC_RG_VCN33_EN_BT_ADDR,
	 MT6351_PMIC_RG_VCN33_EN_BT_MASK, MT6351_PMIC_RG_VCN33_EN_BT_SHIFT},
	{PMIC_RG_VCN33_ON_CTRL_BT, MT6351_PMIC_RG_VCN33_ON_CTRL_BT_ADDR,
	 MT6351_PMIC_RG_VCN33_ON_CTRL_BT_MASK, MT6351_PMIC_RG_VCN33_ON_CTRL_BT_SHIFT},
	{PMIC_RG_VCN33_SRCLK_EN_SEL_BT, MT6351_PMIC_RG_VCN33_SRCLK_EN_SEL_BT_ADDR,
	 MT6351_PMIC_RG_VCN33_SRCLK_EN_SEL_BT_MASK, MT6351_PMIC_RG_VCN33_SRCLK_EN_SEL_BT_SHIFT},
	{PMIC_RG_VCN33_EN_WIFI, MT6351_PMIC_RG_VCN33_EN_WIFI_ADDR,
	 MT6351_PMIC_RG_VCN33_EN_WIFI_MASK, MT6351_PMIC_RG_VCN33_EN_WIFI_SHIFT},
	{PMIC_RG_VCN33_ON_CTRL_WIFI, MT6351_PMIC_RG_VCN33_ON_CTRL_WIFI_ADDR,
	 MT6351_PMIC_RG_VCN33_ON_CTRL_WIFI_MASK, MT6351_PMIC_RG_VCN33_ON_CTRL_WIFI_SHIFT},
	{PMIC_RG_VCN33_SRCLK_EN_SEL_WIFI, MT6351_PMIC_RG_VCN33_SRCLK_EN_SEL_WIFI_ADDR,
	 MT6351_PMIC_RG_VCN33_SRCLK_EN_SEL_WIFI_MASK,
	 MT6351_PMIC_RG_VCN33_SRCLK_EN_SEL_WIFI_SHIFT},
	{PMIC_RG_VLDO28_MODE_SET, MT6351_PMIC_RG_VLDO28_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VLDO28_MODE_SET_MASK, MT6351_PMIC_RG_VLDO28_MODE_SET_SHIFT},
	{PMIC_RG_VLDO28_MODE_CTRL, MT6351_PMIC_RG_VLDO28_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VLDO28_MODE_CTRL_MASK, MT6351_PMIC_RG_VLDO28_MODE_CTRL_SHIFT},
	{PMIC_RG_VLDO28_ON_CTRL, MT6351_PMIC_RG_VLDO28_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VLDO28_ON_CTRL_MASK, MT6351_PMIC_RG_VLDO28_ON_CTRL_SHIFT},
	{PMIC_RG_VLDO28_SRCLK_MODE_SEL, MT6351_PMIC_RG_VLDO28_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VLDO28_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VLDO28_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VLDO28_MODE, MT6351_PMIC_DA_QI_VLDO28_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VLDO28_MODE_MASK, MT6351_PMIC_DA_QI_VLDO28_MODE_SHIFT},
	{PMIC_RG_VLDO28_STBTD, MT6351_PMIC_RG_VLDO28_STBTD_ADDR,
	 MT6351_PMIC_RG_VLDO28_STBTD_MASK, MT6351_PMIC_RG_VLDO28_STBTD_SHIFT},
	{PMIC_DA_QI_VLDO28_STB, MT6351_PMIC_DA_QI_VLDO28_STB_ADDR,
	 MT6351_PMIC_DA_QI_VLDO28_STB_MASK, MT6351_PMIC_DA_QI_VLDO28_STB_SHIFT},
	{PMIC_DA_QI_VLDO28_EN, MT6351_PMIC_DA_QI_VLDO28_EN_ADDR,
	 MT6351_PMIC_DA_QI_VLDO28_EN_MASK, MT6351_PMIC_DA_QI_VLDO28_EN_SHIFT},
	{PMIC_RG_VLDO28_OCFB_EN, MT6351_PMIC_RG_VLDO28_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VLDO28_OCFB_EN_MASK, MT6351_PMIC_RG_VLDO28_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VLDO28_OCFB_EN, MT6351_PMIC_DA_QI_VLDO28_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VLDO28_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VLDO28_OCFB_EN_SHIFT},
	{PMIC_RG_VLDO28_DUMMY_LOAD_EN, MT6351_PMIC_RG_VLDO28_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VLDO28_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VLDO28_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VLDO28_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VLDO28_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VLDO28_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VLDO28_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VLDO28_DUMMY_LOAD, MT6351_PMIC_RG_VLDO28_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VLDO28_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VLDO28_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VLDO28_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VLDO28_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VLDO28_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VLDO28_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VLDO28_DUMMY_LOAD, MT6351_PMIC_DA_QI_VLDO28_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VLDO28_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VLDO28_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VLDO28_EN_0, MT6351_PMIC_RG_VLDO28_EN_0_ADDR,
	 MT6351_PMIC_RG_VLDO28_EN_0_MASK, MT6351_PMIC_RG_VLDO28_EN_0_SHIFT},
	{PMIC_RG_VLDO28_ON_CTRL_0, MT6351_PMIC_RG_VLDO28_ON_CTRL_0_ADDR,
	 MT6351_PMIC_RG_VLDO28_ON_CTRL_0_MASK, MT6351_PMIC_RG_VLDO28_ON_CTRL_0_SHIFT},
	{PMIC_RG_VLDO28_SRCLK_EN_SEL_0, MT6351_PMIC_RG_VLDO28_SRCLK_EN_SEL_0_ADDR,
	 MT6351_PMIC_RG_VLDO28_SRCLK_EN_SEL_0_MASK, MT6351_PMIC_RG_VLDO28_SRCLK_EN_SEL_0_SHIFT},
	{PMIC_RG_VLDO28_EN_1, MT6351_PMIC_RG_VLDO28_EN_1_ADDR,
	 MT6351_PMIC_RG_VLDO28_EN_1_MASK, MT6351_PMIC_RG_VLDO28_EN_1_SHIFT},
	{PMIC_RG_VLDO28_ON_CTRL_1, MT6351_PMIC_RG_VLDO28_ON_CTRL_1_ADDR,
	 MT6351_PMIC_RG_VLDO28_ON_CTRL_1_MASK, MT6351_PMIC_RG_VLDO28_ON_CTRL_1_SHIFT},
	{PMIC_RG_VLDO28_SRCLK_EN_SEL_1, MT6351_PMIC_RG_VLDO28_SRCLK_EN_SEL_1_ADDR,
	 MT6351_PMIC_RG_VLDO28_SRCLK_EN_SEL_1_MASK, MT6351_PMIC_RG_VLDO28_SRCLK_EN_SEL_1_SHIFT},
	{PMIC_RG_LDO_RSV1, MT6351_PMIC_RG_LDO_RSV1_ADDR, MT6351_PMIC_RG_LDO_RSV1_MASK,
	 MT6351_PMIC_RG_LDO_RSV1_SHIFT},
	{PMIC_RG_LDO_RSV0, MT6351_PMIC_RG_LDO_RSV0_ADDR, MT6351_PMIC_RG_LDO_RSV0_MASK,
	 MT6351_PMIC_RG_LDO_RSV0_SHIFT},
	{PMIC_RG_LDO_RSV2, MT6351_PMIC_RG_LDO_RSV2_ADDR, MT6351_PMIC_RG_LDO_RSV2_MASK,
	 MT6351_PMIC_RG_LDO_RSV2_SHIFT},
	{PMIC_RG_VMC_MODE_SET, MT6351_PMIC_RG_VMC_MODE_SET_ADDR,
	 MT6351_PMIC_RG_VMC_MODE_SET_MASK, MT6351_PMIC_RG_VMC_MODE_SET_SHIFT},
	{PMIC_RG_VMC_EN, MT6351_PMIC_RG_VMC_EN_ADDR, MT6351_PMIC_RG_VMC_EN_MASK,
	 MT6351_PMIC_RG_VMC_EN_SHIFT},
	{PMIC_RG_VMC_MODE_CTRL, MT6351_PMIC_RG_VMC_MODE_CTRL_ADDR,
	 MT6351_PMIC_RG_VMC_MODE_CTRL_MASK, MT6351_PMIC_RG_VMC_MODE_CTRL_SHIFT},
	{PMIC_RG_VMC_ON_CTRL, MT6351_PMIC_RG_VMC_ON_CTRL_ADDR,
	 MT6351_PMIC_RG_VMC_ON_CTRL_MASK, MT6351_PMIC_RG_VMC_ON_CTRL_SHIFT},
	{PMIC_RG_VMC_SRCLK_MODE_SEL, MT6351_PMIC_RG_VMC_SRCLK_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_VMC_SRCLK_MODE_SEL_MASK, MT6351_PMIC_RG_VMC_SRCLK_MODE_SEL_SHIFT},
	{PMIC_DA_QI_VMC_MODE, MT6351_PMIC_DA_QI_VMC_MODE_ADDR,
	 MT6351_PMIC_DA_QI_VMC_MODE_MASK, MT6351_PMIC_DA_QI_VMC_MODE_SHIFT},
	{PMIC_RG_VMC_STBTD, MT6351_PMIC_RG_VMC_STBTD_ADDR, MT6351_PMIC_RG_VMC_STBTD_MASK,
	 MT6351_PMIC_RG_VMC_STBTD_SHIFT},
	{PMIC_RG_VMC_SRCLK_EN_SEL, MT6351_PMIC_RG_VMC_SRCLK_EN_SEL_ADDR,
	 MT6351_PMIC_RG_VMC_SRCLK_EN_SEL_MASK, MT6351_PMIC_RG_VMC_SRCLK_EN_SEL_SHIFT},
	{PMIC_DA_QI_VMC_STB, MT6351_PMIC_DA_QI_VMC_STB_ADDR,
	 MT6351_PMIC_DA_QI_VMC_STB_MASK, MT6351_PMIC_DA_QI_VMC_STB_SHIFT},
	{PMIC_DA_QI_VMC_EN, MT6351_PMIC_DA_QI_VMC_EN_ADDR, MT6351_PMIC_DA_QI_VMC_EN_MASK,
	 MT6351_PMIC_DA_QI_VMC_EN_SHIFT},
	{PMIC_RG_VMC_OCFB_EN, MT6351_PMIC_RG_VMC_OCFB_EN_ADDR,
	 MT6351_PMIC_RG_VMC_OCFB_EN_MASK, MT6351_PMIC_RG_VMC_OCFB_EN_SHIFT},
	{PMIC_DA_QI_VMC_OCFB_EN, MT6351_PMIC_DA_QI_VMC_OCFB_EN_ADDR,
	 MT6351_PMIC_DA_QI_VMC_OCFB_EN_MASK, MT6351_PMIC_DA_QI_VMC_OCFB_EN_SHIFT},
	{PMIC_RG_VMC_DUMMY_LOAD_EN, MT6351_PMIC_RG_VMC_DUMMY_LOAD_EN_ADDR,
	 MT6351_PMIC_RG_VMC_DUMMY_LOAD_EN_MASK, MT6351_PMIC_RG_VMC_DUMMY_LOAD_EN_SHIFT},
	{PMIC_RG_VMC_DUMMY_LOAD_CTRL, MT6351_PMIC_RG_VMC_DUMMY_LOAD_CTRL_ADDR,
	 MT6351_PMIC_RG_VMC_DUMMY_LOAD_CTRL_MASK, MT6351_PMIC_RG_VMC_DUMMY_LOAD_CTRL_SHIFT},
	{PMIC_RG_VMC_DUMMY_LOAD, MT6351_PMIC_RG_VMC_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_RG_VMC_DUMMY_LOAD_MASK, MT6351_PMIC_RG_VMC_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VMC_DUMMY_LOAD_SRCLKEN_SEL,
	 MT6351_PMIC_RG_VMC_DUMMY_LOAD_SRCLKEN_SEL_ADDR,
	 MT6351_PMIC_RG_VMC_DUMMY_LOAD_SRCLKEN_SEL_MASK,
	 MT6351_PMIC_RG_VMC_DUMMY_LOAD_SRCLKEN_SEL_SHIFT},
	{PMIC_DA_QI_VMC_DUMMY_LOAD, MT6351_PMIC_DA_QI_VMC_DUMMY_LOAD_ADDR,
	 MT6351_PMIC_DA_QI_VMC_DUMMY_LOAD_MASK, MT6351_PMIC_DA_QI_VMC_DUMMY_LOAD_SHIFT},
	{PMIC_RG_VMC_TRANS_EN, MT6351_PMIC_RG_VMC_TRANS_EN_ADDR,
	 MT6351_PMIC_RG_VMC_TRANS_EN_MASK, MT6351_PMIC_RG_VMC_TRANS_EN_SHIFT},
	{PMIC_RG_VMC_TRANS_CTRL, MT6351_PMIC_RG_VMC_TRANS_CTRL_ADDR,
	 MT6351_PMIC_RG_VMC_TRANS_CTRL_MASK, MT6351_PMIC_RG_VMC_TRANS_CTRL_SHIFT},
	{PMIC_RG_VMC_TRANS_ONCE, MT6351_PMIC_RG_VMC_TRANS_ONCE_ADDR,
	 MT6351_PMIC_RG_VMC_TRANS_ONCE_MASK, MT6351_PMIC_RG_VMC_TRANS_ONCE_SHIFT},
	{PMIC_RG_VMC_INT_DIS_SEL, MT6351_PMIC_RG_VMC_INT_DIS_SEL_ADDR,
	 MT6351_PMIC_RG_VMC_INT_DIS_SEL_MASK, MT6351_PMIC_RG_VMC_INT_DIS_SEL_SHIFT},
	{PMIC_DA_QI_VMC_INT_DIS, MT6351_PMIC_DA_QI_VMC_INT_DIS_ADDR,
	 MT6351_PMIC_DA_QI_VMC_INT_DIS_MASK, MT6351_PMIC_DA_QI_VMC_INT_DIS_SHIFT},
	{PMIC_RG_LDO_MANUAL_OFS_SEL, MT6351_PMIC_RG_LDO_MANUAL_OFS_SEL_ADDR,
	 MT6351_PMIC_RG_LDO_MANUAL_OFS_SEL_MASK, MT6351_PMIC_RG_LDO_MANUAL_OFS_SEL_SHIFT},
	{PMIC_RG_LDO_MANUAL_OFS_EN, MT6351_PMIC_RG_LDO_MANUAL_OFS_EN_ADDR,
	 MT6351_PMIC_RG_LDO_MANUAL_OFS_EN_MASK, MT6351_PMIC_RG_LDO_MANUAL_OFS_EN_SHIFT},
	{PMIC_RG_LDO_CALI_RSV, MT6351_PMIC_RG_LDO_CALI_RSV_ADDR,
	 MT6351_PMIC_RG_LDO_CALI_RSV_MASK, MT6351_PMIC_RG_LDO_CALI_RSV_SHIFT},
	{PMIC_RG_LDO_CALI_MODE_SEL, MT6351_PMIC_RG_LDO_CALI_MODE_SEL_ADDR,
	 MT6351_PMIC_RG_LDO_CALI_MODE_SEL_MASK, MT6351_PMIC_RG_LDO_CALI_MODE_SEL_SHIFT},
	{PMIC_RG_LDO_MANUAL_MODE, MT6351_PMIC_RG_LDO_MANUAL_MODE_ADDR,
	 MT6351_PMIC_RG_LDO_MANUAL_MODE_MASK, MT6351_PMIC_RG_LDO_MANUAL_MODE_SHIFT},
	{PMIC_RG_LDO_AUTO_START, MT6351_PMIC_RG_LDO_AUTO_START_ADDR,
	 MT6351_PMIC_RG_LDO_AUTO_START_MASK, MT6351_PMIC_RG_LDO_AUTO_START_SHIFT},
	{PMIC_RG_LDO_CALI_CLR, MT6351_PMIC_RG_LDO_CALI_CLR_ADDR,
	 MT6351_PMIC_RG_LDO_CALI_CLR_MASK, MT6351_PMIC_RG_LDO_CALI_CLR_SHIFT},
	{PMIC_LDO_CALI_INC_COUNT, MT6351_PMIC_LDO_CALI_INC_COUNT_ADDR,
	 MT6351_PMIC_LDO_CALI_INC_COUNT_MASK, MT6351_PMIC_LDO_CALI_INC_COUNT_SHIFT},
	{PMIC_LDO_K_START, MT6351_PMIC_LDO_K_START_ADDR, MT6351_PMIC_LDO_K_START_MASK,
	 MT6351_PMIC_LDO_K_START_SHIFT},
	{PMIC_LDO_CALI_DONE, MT6351_PMIC_LDO_CALI_DONE_ADDR,
	 MT6351_PMIC_LDO_CALI_DONE_MASK, MT6351_PMIC_LDO_CALI_DONE_SHIFT},
	{PMIC_LDO_CALI_CNT, MT6351_PMIC_LDO_CALI_CNT_ADDR, MT6351_PMIC_LDO_CALI_CNT_MASK,
	 MT6351_PMIC_LDO_CALI_CNT_SHIFT},
	{PMIC_LDO_CALI_EFUSE_EN, MT6351_PMIC_LDO_CALI_EFUSE_EN_ADDR,
	 MT6351_PMIC_LDO_CALI_EFUSE_EN_MASK, MT6351_PMIC_LDO_CALI_EFUSE_EN_SHIFT},
	{PMIC_DA_QI_VIO18_OFS_CAL_EN, MT6351_PMIC_DA_QI_VIO18_OFS_CAL_EN_ADDR,
	 MT6351_PMIC_DA_QI_VIO18_OFS_CAL_EN_MASK, MT6351_PMIC_DA_QI_VIO18_OFS_CAL_EN_SHIFT},
	{PMIC_AD_QI_VIO18_CAL_INDI, MT6351_PMIC_AD_QI_VIO18_CAL_INDI_ADDR,
	 MT6351_PMIC_AD_QI_VIO18_CAL_INDI_MASK, MT6351_PMIC_AD_QI_VIO18_CAL_INDI_SHIFT},
	{PMIC_DA_QI_VIO18_OFS_SEL, MT6351_PMIC_DA_QI_VIO18_OFS_SEL_ADDR,
	 MT6351_PMIC_DA_QI_VIO18_OFS_SEL_MASK, MT6351_PMIC_DA_QI_VIO18_OFS_SEL_SHIFT},
	{PMIC_LDO_DEGTD_SEL, MT6351_PMIC_LDO_DEGTD_SEL_ADDR,
	 MT6351_PMIC_LDO_DEGTD_SEL_MASK, MT6351_PMIC_LDO_DEGTD_SEL_SHIFT},
	{PMIC_RG_VRTC_EN, MT6351_PMIC_RG_VRTC_EN_ADDR, MT6351_PMIC_RG_VRTC_EN_MASK,
	 MT6351_PMIC_RG_VRTC_EN_SHIFT},
	{PMIC_DA_QI_VRTC_EN, MT6351_PMIC_DA_QI_VRTC_EN_ADDR,
	 MT6351_PMIC_DA_QI_VRTC_EN_MASK, MT6351_PMIC_DA_QI_VRTC_EN_SHIFT},
	{PMIC_RG_ALDO_RESEV, MT6351_PMIC_RG_ALDO_RESEV_ADDR,
	 MT6351_PMIC_RG_ALDO_RESEV_MASK, MT6351_PMIC_RG_ALDO_RESEV_SHIFT},
	{PMIC_RG_DLDO_RESEV, MT6351_PMIC_RG_DLDO_RESEV_ADDR,
	 MT6351_PMIC_RG_DLDO_RESEV_MASK, MT6351_PMIC_RG_DLDO_RESEV_SHIFT},
	{PMIC_RG_SLDO_RESEV195, MT6351_PMIC_RG_SLDO_RESEV195_ADDR,
	 MT6351_PMIC_RG_SLDO_RESEV195_MASK, MT6351_PMIC_RG_SLDO_RESEV195_SHIFT},
	{PMIC_RG_SLDO_2_RESEV195, MT6351_PMIC_RG_SLDO_2_RESEV195_ADDR,
	 MT6351_PMIC_RG_SLDO_2_RESEV195_MASK, MT6351_PMIC_RG_SLDO_2_RESEV195_SHIFT},
	{PMIC_RG_SLDO_RESEV135, MT6351_PMIC_RG_SLDO_RESEV135_ADDR,
	 MT6351_PMIC_RG_SLDO_RESEV135_MASK, MT6351_PMIC_RG_SLDO_RESEV135_SHIFT},
	{PMIC_RG_SLDO_2_RESEV135, MT6351_PMIC_RG_SLDO_2_RESEV135_ADDR,
	 MT6351_PMIC_RG_SLDO_2_RESEV135_MASK, MT6351_PMIC_RG_SLDO_2_RESEV135_SHIFT},
	{PMIC_RG_VXO22_CAL, MT6351_PMIC_RG_VXO22_CAL_ADDR, MT6351_PMIC_RG_VXO22_CAL_MASK,
	 MT6351_PMIC_RG_VXO22_CAL_SHIFT},
	{PMIC_RG_VXO22_VOSEL, MT6351_PMIC_RG_VXO22_VOSEL_ADDR,
	 MT6351_PMIC_RG_VXO22_VOSEL_MASK, MT6351_PMIC_RG_VXO22_VOSEL_SHIFT},
	{PMIC_RG_VXO22_NDIS_EN, MT6351_PMIC_RG_VXO22_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VXO22_NDIS_EN_MASK, MT6351_PMIC_RG_VXO22_NDIS_EN_SHIFT},
	{PMIC_RG_VTCXO28_CAL, MT6351_PMIC_RG_VTCXO28_CAL_ADDR,
	 MT6351_PMIC_RG_VTCXO28_CAL_MASK, MT6351_PMIC_RG_VTCXO28_CAL_SHIFT},
	{PMIC_RG_VTCXO28_VOSEL, MT6351_PMIC_RG_VTCXO28_VOSEL_ADDR,
	 MT6351_PMIC_RG_VTCXO28_VOSEL_MASK, MT6351_PMIC_RG_VTCXO28_VOSEL_SHIFT},
	{PMIC_RG_VTCXO28_NDIS_EN, MT6351_PMIC_RG_VTCXO28_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VTCXO28_NDIS_EN_MASK, MT6351_PMIC_RG_VTCXO28_NDIS_EN_SHIFT},
	{PMIC_RG_VTCXO24_CAL, MT6351_PMIC_RG_VTCXO24_CAL_ADDR,
	 MT6351_PMIC_RG_VTCXO24_CAL_MASK, MT6351_PMIC_RG_VTCXO24_CAL_SHIFT},
	{PMIC_RG_VTCXO24_VOSEL, MT6351_PMIC_RG_VTCXO24_VOSEL_ADDR,
	 MT6351_PMIC_RG_VTCXO24_VOSEL_MASK, MT6351_PMIC_RG_VTCXO24_VOSEL_SHIFT},
	{PMIC_RG_VTCXO24_NDIS_EN, MT6351_PMIC_RG_VTCXO24_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VTCXO24_NDIS_EN_MASK, MT6351_PMIC_RG_VTCXO24_NDIS_EN_SHIFT},
	{PMIC_RG_VBIF28_CAL, MT6351_PMIC_RG_VBIF28_CAL_ADDR,
	 MT6351_PMIC_RG_VBIF28_CAL_MASK, MT6351_PMIC_RG_VBIF28_CAL_SHIFT},
	{PMIC_RG_VBIF28_VOSEL, MT6351_PMIC_RG_VBIF28_VOSEL_ADDR,
	 MT6351_PMIC_RG_VBIF28_VOSEL_MASK, MT6351_PMIC_RG_VBIF28_VOSEL_SHIFT},
	{PMIC_RG_VBIF28_NDIS_EN, MT6351_PMIC_RG_VBIF28_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VBIF28_NDIS_EN_MASK, MT6351_PMIC_RG_VBIF28_NDIS_EN_SHIFT},
	{PMIC_RG_VCN28_CAL, MT6351_PMIC_RG_VCN28_CAL_ADDR, MT6351_PMIC_RG_VCN28_CAL_MASK,
	 MT6351_PMIC_RG_VCN28_CAL_SHIFT},
	{PMIC_RG_VCN28_VOSEL, MT6351_PMIC_RG_VCN28_VOSEL_ADDR,
	 MT6351_PMIC_RG_VCN28_VOSEL_MASK, MT6351_PMIC_RG_VCN28_VOSEL_SHIFT},
	{PMIC_RG_VCN28_NDIS_EN, MT6351_PMIC_RG_VCN28_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VCN28_NDIS_EN_MASK, MT6351_PMIC_RG_VCN28_NDIS_EN_SHIFT},
	{PMIC_RG_VMCH_CAL, MT6351_PMIC_RG_VMCH_CAL_ADDR, MT6351_PMIC_RG_VMCH_CAL_MASK,
	 MT6351_PMIC_RG_VMCH_CAL_SHIFT},
	{PMIC_RG_VMCH_VOSEL, MT6351_PMIC_RG_VMCH_VOSEL_ADDR,
	 MT6351_PMIC_RG_VMCH_VOSEL_MASK, MT6351_PMIC_RG_VMCH_VOSEL_SHIFT},
	{PMIC_RG_VMCH_NDIS_EN, MT6351_PMIC_RG_VMCH_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VMCH_NDIS_EN_MASK, MT6351_PMIC_RG_VMCH_NDIS_EN_SHIFT},
	{PMIC_RG_VMCH_OC_TRIM, MT6351_PMIC_RG_VMCH_OC_TRIM_ADDR,
	 MT6351_PMIC_RG_VMCH_OC_TRIM_MASK, MT6351_PMIC_RG_VMCH_OC_TRIM_SHIFT},
	{PMIC_RG_VMCH_N2LP_EHC_V18, MT6351_PMIC_RG_VMCH_N2LP_EHC_V18_ADDR,
	 MT6351_PMIC_RG_VMCH_N2LP_EHC_V18_MASK, MT6351_PMIC_RG_VMCH_N2LP_EHC_V18_SHIFT},
	{PMIC_RG_VEMC_CAL, MT6351_PMIC_RG_VEMC_CAL_ADDR, MT6351_PMIC_RG_VEMC_CAL_MASK,
	 MT6351_PMIC_RG_VEMC_CAL_SHIFT},
	{PMIC_RG_VEMC_VOSEL, MT6351_PMIC_RG_VEMC_VOSEL_ADDR,
	 MT6351_PMIC_RG_VEMC_VOSEL_MASK, MT6351_PMIC_RG_VEMC_VOSEL_SHIFT},
	{PMIC_RG_VEMC_NDIS_EN, MT6351_PMIC_RG_VEMC_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VEMC_NDIS_EN_MASK, MT6351_PMIC_RG_VEMC_NDIS_EN_SHIFT},
	{PMIC_RG_VEMC_OC_TRIM, MT6351_PMIC_RG_VEMC_OC_TRIM_ADDR,
	 MT6351_PMIC_RG_VEMC_OC_TRIM_MASK, MT6351_PMIC_RG_VEMC_OC_TRIM_SHIFT},
	{PMIC_RG_VEMC_N2LP_EHC_V18, MT6351_PMIC_RG_VEMC_N2LP_EHC_V18_ADDR,
	 MT6351_PMIC_RG_VEMC_N2LP_EHC_V18_MASK, MT6351_PMIC_RG_VEMC_N2LP_EHC_V18_SHIFT},
	{PMIC_RG_VCAMA_CAL, MT6351_PMIC_RG_VCAMA_CAL_ADDR, MT6351_PMIC_RG_VCAMA_CAL_MASK,
	 MT6351_PMIC_RG_VCAMA_CAL_SHIFT},
	{PMIC_RG_VCAMA_VOSEL, MT6351_PMIC_RG_VCAMA_VOSEL_ADDR,
	 MT6351_PMIC_RG_VCAMA_VOSEL_MASK, MT6351_PMIC_RG_VCAMA_VOSEL_SHIFT},
	{PMIC_RG_VCAMA_NDIS_EN, MT6351_PMIC_RG_VCAMA_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VCAMA_NDIS_EN_MASK, MT6351_PMIC_RG_VCAMA_NDIS_EN_SHIFT},
	{PMIC_RG_VCAMA_FBSEL, MT6351_PMIC_RG_VCAMA_FBSEL_ADDR,
	 MT6351_PMIC_RG_VCAMA_FBSEL_MASK, MT6351_PMIC_RG_VCAMA_FBSEL_SHIFT},
	{PMIC_RG_VCN33_CAL, MT6351_PMIC_RG_VCN33_CAL_ADDR, MT6351_PMIC_RG_VCN33_CAL_MASK,
	 MT6351_PMIC_RG_VCN33_CAL_SHIFT},
	{PMIC_RG_VCN33_VOSEL, MT6351_PMIC_RG_VCN33_VOSEL_ADDR,
	 MT6351_PMIC_RG_VCN33_VOSEL_MASK, MT6351_PMIC_RG_VCN33_VOSEL_SHIFT},
	{PMIC_RG_VCN33_NDIS_EN, MT6351_PMIC_RG_VCN33_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VCN33_NDIS_EN_MASK, MT6351_PMIC_RG_VCN33_NDIS_EN_SHIFT},
	{PMIC_RG_VCN33_N2LP_EHC_V18, MT6351_PMIC_RG_VCN33_N2LP_EHC_V18_ADDR,
	 MT6351_PMIC_RG_VCN33_N2LP_EHC_V18_MASK, MT6351_PMIC_RG_VCN33_N2LP_EHC_V18_SHIFT},
	{PMIC_RG_VIO28_CAL, MT6351_PMIC_RG_VIO28_CAL_ADDR, MT6351_PMIC_RG_VIO28_CAL_MASK,
	 MT6351_PMIC_RG_VIO28_CAL_SHIFT},
	{PMIC_RG_VIO28_VOSEL, MT6351_PMIC_RG_VIO28_VOSEL_ADDR,
	 MT6351_PMIC_RG_VIO28_VOSEL_MASK, MT6351_PMIC_RG_VIO28_VOSEL_SHIFT},
	{PMIC_RG_VIO28_NDIS_EN, MT6351_PMIC_RG_VIO28_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VIO28_NDIS_EN_MASK, MT6351_PMIC_RG_VIO28_NDIS_EN_SHIFT},
	{PMIC_RG_VIO28_LP_HIGH_SPEED_ENB, MT6351_PMIC_RG_VIO28_LP_HIGH_SPEED_ENB_ADDR,
	 MT6351_PMIC_RG_VIO28_LP_HIGH_SPEED_ENB_MASK,
	 MT6351_PMIC_RG_VIO28_LP_HIGH_SPEED_ENB_SHIFT},
	{PMIC_RG_VMC_CAL, MT6351_PMIC_RG_VMC_CAL_ADDR, MT6351_PMIC_RG_VMC_CAL_MASK,
	 MT6351_PMIC_RG_VMC_CAL_SHIFT},
	{PMIC_RG_VMC_VOSEL, MT6351_PMIC_RG_VMC_VOSEL_ADDR, MT6351_PMIC_RG_VMC_VOSEL_MASK,
	 MT6351_PMIC_RG_VMC_VOSEL_SHIFT},
	{PMIC_RG_VMC_NDIS_EN, MT6351_PMIC_RG_VMC_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VMC_NDIS_EN_MASK, MT6351_PMIC_RG_VMC_NDIS_EN_SHIFT},
	{PMIC_RG_VMC_LP_HIGH_SPEED_ENB, MT6351_PMIC_RG_VMC_LP_HIGH_SPEED_ENB_ADDR,
	 MT6351_PMIC_RG_VMC_LP_HIGH_SPEED_ENB_MASK, MT6351_PMIC_RG_VMC_LP_HIGH_SPEED_ENB_SHIFT},
	{PMIC_RG_VIBR_CAL, MT6351_PMIC_RG_VIBR_CAL_ADDR, MT6351_PMIC_RG_VIBR_CAL_MASK,
	 MT6351_PMIC_RG_VIBR_CAL_SHIFT},
	{PMIC_RG_VIBR_VOSEL, MT6351_PMIC_RG_VIBR_VOSEL_ADDR,
	 MT6351_PMIC_RG_VIBR_VOSEL_MASK, MT6351_PMIC_RG_VIBR_VOSEL_SHIFT},
	{PMIC_RG_VIBR_NDIS_EN, MT6351_PMIC_RG_VIBR_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VIBR_NDIS_EN_MASK, MT6351_PMIC_RG_VIBR_NDIS_EN_SHIFT},
	{PMIC_RG_VIBR_LP_HIGH_SPEED_ENB, MT6351_PMIC_RG_VIBR_LP_HIGH_SPEED_ENB_ADDR,
	 MT6351_PMIC_RG_VIBR_LP_HIGH_SPEED_ENB_MASK, MT6351_PMIC_RG_VIBR_LP_HIGH_SPEED_ENB_SHIFT},
	{PMIC_RG_VUSB33_CAL, MT6351_PMIC_RG_VUSB33_CAL_ADDR,
	 MT6351_PMIC_RG_VUSB33_CAL_MASK, MT6351_PMIC_RG_VUSB33_CAL_SHIFT},
	{PMIC_RG_VUSB33_NDIS_EN, MT6351_PMIC_RG_VUSB33_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VUSB33_NDIS_EN_MASK, MT6351_PMIC_RG_VUSB33_NDIS_EN_SHIFT},
	{PMIC_RG_VUSB33_OC_TRIM, MT6351_PMIC_RG_VUSB33_OC_TRIM_ADDR,
	 MT6351_PMIC_RG_VUSB33_OC_TRIM_MASK, MT6351_PMIC_RG_VUSB33_OC_TRIM_SHIFT},
	{PMIC_RG_VSIM1_CAL, MT6351_PMIC_RG_VSIM1_CAL_ADDR, MT6351_PMIC_RG_VSIM1_CAL_MASK,
	 MT6351_PMIC_RG_VSIM1_CAL_SHIFT},
	{PMIC_RG_VSIM1_VOSEL, MT6351_PMIC_RG_VSIM1_VOSEL_ADDR,
	 MT6351_PMIC_RG_VSIM1_VOSEL_MASK, MT6351_PMIC_RG_VSIM1_VOSEL_SHIFT},
	{PMIC_RG_VSIM1_NDIS_EN, MT6351_PMIC_RG_VSIM1_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VSIM1_NDIS_EN_MASK, MT6351_PMIC_RG_VSIM1_NDIS_EN_SHIFT},
	{PMIC_RG_VSIM1_STB_CAL, MT6351_PMIC_RG_VSIM1_STB_CAL_ADDR,
	 MT6351_PMIC_RG_VSIM1_STB_CAL_MASK, MT6351_PMIC_RG_VSIM1_STB_CAL_SHIFT},
	{PMIC_RG_VSIM1_STB_SEL, MT6351_PMIC_RG_VSIM1_STB_SEL_ADDR,
	 MT6351_PMIC_RG_VSIM1_STB_SEL_MASK, MT6351_PMIC_RG_VSIM1_STB_SEL_SHIFT},
	{PMIC_RG_VSIM1_OC_TRIM, MT6351_PMIC_RG_VSIM1_OC_TRIM_ADDR,
	 MT6351_PMIC_RG_VSIM1_OC_TRIM_MASK, MT6351_PMIC_RG_VSIM1_OC_TRIM_SHIFT},
	{PMIC_RG_VSIM1_NDIS_EN_INT, MT6351_PMIC_RG_VSIM1_NDIS_EN_INT_ADDR,
	 MT6351_PMIC_RG_VSIM1_NDIS_EN_INT_MASK, MT6351_PMIC_RG_VSIM1_NDIS_EN_INT_SHIFT},
	{PMIC_RG_EFUSE_SIM1_MODE, MT6351_PMIC_RG_EFUSE_SIM1_MODE_ADDR,
	 MT6351_PMIC_RG_EFUSE_SIM1_MODE_MASK, MT6351_PMIC_RG_EFUSE_SIM1_MODE_SHIFT},
	{PMIC_RG_VSIM1_LP_HIGH_SPEED_ENB, MT6351_PMIC_RG_VSIM1_LP_HIGH_SPEED_ENB_ADDR,
	 MT6351_PMIC_RG_VSIM1_LP_HIGH_SPEED_ENB_MASK,
	 MT6351_PMIC_RG_VSIM1_LP_HIGH_SPEED_ENB_SHIFT},
	{PMIC_RG_VSIM2_CAL, MT6351_PMIC_RG_VSIM2_CAL_ADDR, MT6351_PMIC_RG_VSIM2_CAL_MASK,
	 MT6351_PMIC_RG_VSIM2_CAL_SHIFT},
	{PMIC_RG_VSIM2_VOSEL, MT6351_PMIC_RG_VSIM2_VOSEL_ADDR,
	 MT6351_PMIC_RG_VSIM2_VOSEL_MASK, MT6351_PMIC_RG_VSIM2_VOSEL_SHIFT},
	{PMIC_RG_VSIM2_NDIS_EN, MT6351_PMIC_RG_VSIM2_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VSIM2_NDIS_EN_MASK, MT6351_PMIC_RG_VSIM2_NDIS_EN_SHIFT},
	{PMIC_RG_VSIM2_STB_CAL, MT6351_PMIC_RG_VSIM2_STB_CAL_ADDR,
	 MT6351_PMIC_RG_VSIM2_STB_CAL_MASK, MT6351_PMIC_RG_VSIM2_STB_CAL_SHIFT},
	{PMIC_RG_VSIM2_STB_SEL, MT6351_PMIC_RG_VSIM2_STB_SEL_ADDR,
	 MT6351_PMIC_RG_VSIM2_STB_SEL_MASK, MT6351_PMIC_RG_VSIM2_STB_SEL_SHIFT},
	{PMIC_RG_VSIM2_OC_TRIM, MT6351_PMIC_RG_VSIM2_OC_TRIM_ADDR,
	 MT6351_PMIC_RG_VSIM2_OC_TRIM_MASK, MT6351_PMIC_RG_VSIM2_OC_TRIM_SHIFT},
	{PMIC_RG_VSIM2_NDIS_EN_INT, MT6351_PMIC_RG_VSIM2_NDIS_EN_INT_ADDR,
	 MT6351_PMIC_RG_VSIM2_NDIS_EN_INT_MASK, MT6351_PMIC_RG_VSIM2_NDIS_EN_INT_SHIFT},
	{PMIC_RG_EFUSE_VSIM2_MODE, MT6351_PMIC_RG_EFUSE_VSIM2_MODE_ADDR,
	 MT6351_PMIC_RG_EFUSE_VSIM2_MODE_MASK, MT6351_PMIC_RG_EFUSE_VSIM2_MODE_SHIFT},
	{PMIC_RG_VSIM2_LP_HIGH_SPEED_ENB, MT6351_PMIC_RG_VSIM2_LP_HIGH_SPEED_ENB_ADDR,
	 MT6351_PMIC_RG_VSIM2_LP_HIGH_SPEED_ENB_MASK,
	 MT6351_PMIC_RG_VSIM2_LP_HIGH_SPEED_ENB_SHIFT},
	{PMIC_RG_VEFUSE_CAL, MT6351_PMIC_RG_VEFUSE_CAL_ADDR,
	 MT6351_PMIC_RG_VEFUSE_CAL_MASK, MT6351_PMIC_RG_VEFUSE_CAL_SHIFT},
	{PMIC_RG_VEFUSE_VOSEL, MT6351_PMIC_RG_VEFUSE_VOSEL_ADDR,
	 MT6351_PMIC_RG_VEFUSE_VOSEL_MASK, MT6351_PMIC_RG_VEFUSE_VOSEL_SHIFT},
	{PMIC_RG_VEFUSE_NDIS_EN, MT6351_PMIC_RG_VEFUSE_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VEFUSE_NDIS_EN_MASK, MT6351_PMIC_RG_VEFUSE_NDIS_EN_SHIFT},
	{PMIC_RG_VEFUSE_STB_CAL, MT6351_PMIC_RG_VEFUSE_STB_CAL_ADDR,
	 MT6351_PMIC_RG_VEFUSE_STB_CAL_MASK, MT6351_PMIC_RG_VEFUSE_STB_CAL_SHIFT},
	{PMIC_RG_VEFUSE_STB_SEL, MT6351_PMIC_RG_VEFUSE_STB_SEL_ADDR,
	 MT6351_PMIC_RG_VEFUSE_STB_SEL_MASK, MT6351_PMIC_RG_VEFUSE_STB_SEL_SHIFT},
	{PMIC_RG_VEFUSE_OC_TRIM, MT6351_PMIC_RG_VEFUSE_OC_TRIM_ADDR,
	 MT6351_PMIC_RG_VEFUSE_OC_TRIM_MASK, MT6351_PMIC_RG_VEFUSE_OC_TRIM_SHIFT},
	{PMIC_RG_VEFUSE_NDIS_EN_INT, MT6351_PMIC_RG_VEFUSE_NDIS_EN_INT_ADDR,
	 MT6351_PMIC_RG_VEFUSE_NDIS_EN_INT_MASK, MT6351_PMIC_RG_VEFUSE_NDIS_EN_INT_SHIFT},
	{PMIC_RG_EFUSE_MODE_1, MT6351_PMIC_RG_EFUSE_MODE_1_ADDR,
	 MT6351_PMIC_RG_EFUSE_MODE_1_MASK, MT6351_PMIC_RG_EFUSE_MODE_1_SHIFT},
	{PMIC_RG_VEFUSE_LP_HIGH_SPEED_ENB, MT6351_PMIC_RG_VEFUSE_LP_HIGH_SPEED_ENB_ADDR,
	 MT6351_PMIC_RG_VEFUSE_LP_HIGH_SPEED_ENB_MASK,
	 MT6351_PMIC_RG_VEFUSE_LP_HIGH_SPEED_ENB_SHIFT},
	{PMIC_RG_VA18_CAL, MT6351_PMIC_RG_VA18_CAL_ADDR, MT6351_PMIC_RG_VA18_CAL_MASK,
	 MT6351_PMIC_RG_VA18_CAL_SHIFT},
	{PMIC_RG_VA18_VOSEL, MT6351_PMIC_RG_VA18_VOSEL_ADDR,
	 MT6351_PMIC_RG_VA18_VOSEL_MASK, MT6351_PMIC_RG_VA18_VOSEL_SHIFT},
	{PMIC_RG_VA18_NDIS_EN, MT6351_PMIC_RG_VA18_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VA18_NDIS_EN_MASK, MT6351_PMIC_RG_VA18_NDIS_EN_SHIFT},
	{PMIC_RG_VGP3_CAL, MT6351_PMIC_RG_VGP3_CAL_ADDR, MT6351_PMIC_RG_VGP3_CAL_MASK,
	 MT6351_PMIC_RG_VGP3_CAL_SHIFT},
	{PMIC_RG_VGP3_VOSEL, MT6351_PMIC_RG_VGP3_VOSEL_ADDR,
	 MT6351_PMIC_RG_VGP3_VOSEL_MASK, MT6351_PMIC_RG_VGP3_VOSEL_SHIFT},
	{PMIC_RG_VGP3_NDIS_EN, MT6351_PMIC_RG_VGP3_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VGP3_NDIS_EN_MASK, MT6351_PMIC_RG_VGP3_NDIS_EN_SHIFT},
	{PMIC_RG_VGP3_FT_DNMC_EN, MT6351_PMIC_RG_VGP3_FT_DNMC_EN_ADDR,
	 MT6351_PMIC_RG_VGP3_FT_DNMC_EN_MASK, MT6351_PMIC_RG_VGP3_FT_DNMC_EN_SHIFT},
	{PMIC_RG_VCAMD_CAL, MT6351_PMIC_RG_VCAMD_CAL_ADDR, MT6351_PMIC_RG_VCAMD_CAL_MASK,
	 MT6351_PMIC_RG_VCAMD_CAL_SHIFT},
	{PMIC_RG_VCAMD_VOSEL, MT6351_PMIC_RG_VCAMD_VOSEL_ADDR,
	 MT6351_PMIC_RG_VCAMD_VOSEL_MASK, MT6351_PMIC_RG_VCAMD_VOSEL_SHIFT},
	{PMIC_RG_VCAMD_NDIS_EN, MT6351_PMIC_RG_VCAMD_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VCAMD_NDIS_EN_MASK, MT6351_PMIC_RG_VCAMD_NDIS_EN_SHIFT},
	{PMIC_RG_VCAMD_RSV, MT6351_PMIC_RG_VCAMD_RSV_ADDR, MT6351_PMIC_RG_VCAMD_RSV_MASK,
	 MT6351_PMIC_RG_VCAMD_RSV_SHIFT},
	{PMIC_RG_VCAMD_OC_TRIM, MT6351_PMIC_RG_VCAMD_OC_TRIM_ADDR,
	 MT6351_PMIC_RG_VCAMD_OC_TRIM_MASK, MT6351_PMIC_RG_VCAMD_OC_TRIM_SHIFT},
	{PMIC_RG_VIO18_CAL, MT6351_PMIC_RG_VIO18_CAL_ADDR, MT6351_PMIC_RG_VIO18_CAL_MASK,
	 MT6351_PMIC_RG_VIO18_CAL_SHIFT},
	{PMIC_RG_VIO18_NDIS_EN, MT6351_PMIC_RG_VIO18_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VIO18_NDIS_EN_MASK, MT6351_PMIC_RG_VIO18_NDIS_EN_SHIFT},
	{PMIC_RG_VIO18_FT_DNMC_EN, MT6351_PMIC_RG_VIO18_FT_DNMC_EN_ADDR,
	 MT6351_PMIC_RG_VIO18_FT_DNMC_EN_MASK, MT6351_PMIC_RG_VIO18_FT_DNMC_EN_SHIFT},
	{PMIC_RG_VRF18_CAL, MT6351_PMIC_RG_VRF18_CAL_ADDR, MT6351_PMIC_RG_VRF18_CAL_MASK,
	 MT6351_PMIC_RG_VRF18_CAL_SHIFT},
	{PMIC_RG_VRF18_VOSEL, MT6351_PMIC_RG_VRF18_VOSEL_ADDR,
	 MT6351_PMIC_RG_VRF18_VOSEL_MASK, MT6351_PMIC_RG_VRF18_VOSEL_SHIFT},
	{PMIC_RG_VRF18_NDIS_EN, MT6351_PMIC_RG_VRF18_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VRF18_NDIS_EN_MASK, MT6351_PMIC_RG_VRF18_NDIS_EN_SHIFT},
	{PMIC_RG_VRF18_FT_DNMC_EN, MT6351_PMIC_RG_VRF18_FT_DNMC_EN_ADDR,
	 MT6351_PMIC_RG_VRF18_FT_DNMC_EN_MASK, MT6351_PMIC_RG_VRF18_FT_DNMC_EN_SHIFT},
	{PMIC_RG_VRF12_CAL, MT6351_PMIC_RG_VRF12_CAL_ADDR, MT6351_PMIC_RG_VRF12_CAL_MASK,
	 MT6351_PMIC_RG_VRF12_CAL_SHIFT},
	{PMIC_RG_VRF12_VOSEL, MT6351_PMIC_RG_VRF12_VOSEL_ADDR,
	 MT6351_PMIC_RG_VRF12_VOSEL_MASK, MT6351_PMIC_RG_VRF12_VOSEL_SHIFT},
	{PMIC_RG_VRF12_NDIS_EN, MT6351_PMIC_RG_VRF12_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VRF12_NDIS_EN_MASK, MT6351_PMIC_RG_VRF12_NDIS_EN_SHIFT},
	{PMIC_RG_VRF12_STB_SEL, MT6351_PMIC_RG_VRF12_STB_SEL_ADDR,
	 MT6351_PMIC_RG_VRF12_STB_SEL_MASK, MT6351_PMIC_RG_VRF12_STB_SEL_SHIFT},
	{PMIC_RG_VA10_CAL, MT6351_PMIC_RG_VA10_CAL_ADDR, MT6351_PMIC_RG_VA10_CAL_MASK,
	 MT6351_PMIC_RG_VA10_CAL_SHIFT},
	{PMIC_RG_VA10_VOSEL, MT6351_PMIC_RG_VA10_VOSEL_ADDR,
	 MT6351_PMIC_RG_VA10_VOSEL_MASK, MT6351_PMIC_RG_VA10_VOSEL_SHIFT},
	{PMIC_RG_VA10_NDIS_EN, MT6351_PMIC_RG_VA10_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VA10_NDIS_EN_MASK, MT6351_PMIC_RG_VA10_NDIS_EN_SHIFT},
	{PMIC_RG_VA10_STB_SEL, MT6351_PMIC_RG_VA10_STB_SEL_ADDR,
	 MT6351_PMIC_RG_VA10_STB_SEL_MASK, MT6351_PMIC_RG_VA10_STB_SEL_SHIFT},
	{PMIC_RG_VCAMIO_CAL, MT6351_PMIC_RG_VCAMIO_CAL_ADDR,
	 MT6351_PMIC_RG_VCAMIO_CAL_MASK, MT6351_PMIC_RG_VCAMIO_CAL_SHIFT},
	{PMIC_RG_VCAMIO_VOSEL, MT6351_PMIC_RG_VCAMIO_VOSEL_ADDR,
	 MT6351_PMIC_RG_VCAMIO_VOSEL_MASK, MT6351_PMIC_RG_VCAMIO_VOSEL_SHIFT},
	{PMIC_RG_VCAMIO_NDIS_EN, MT6351_PMIC_RG_VCAMIO_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VCAMIO_NDIS_EN_MASK, MT6351_PMIC_RG_VCAMIO_NDIS_EN_SHIFT},
	{PMIC_RG_VCAMIO_STB_SEL, MT6351_PMIC_RG_VCAMIO_STB_SEL_ADDR,
	 MT6351_PMIC_RG_VCAMIO_STB_SEL_MASK, MT6351_PMIC_RG_VCAMIO_STB_SEL_SHIFT},
	{PMIC_RG_VCN18_CAL, MT6351_PMIC_RG_VCN18_CAL_ADDR, MT6351_PMIC_RG_VCN18_CAL_MASK,
	 MT6351_PMIC_RG_VCN18_CAL_SHIFT},
	{PMIC_RG_VCN18_VOSEL, MT6351_PMIC_RG_VCN18_VOSEL_ADDR,
	 MT6351_PMIC_RG_VCN18_VOSEL_MASK, MT6351_PMIC_RG_VCN18_VOSEL_SHIFT},
	{PMIC_RG_VCN18_NDIS_EN, MT6351_PMIC_RG_VCN18_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VCN18_NDIS_EN_MASK, MT6351_PMIC_RG_VCN18_NDIS_EN_SHIFT},
	{PMIC_RG_VCN18_STB_SEL, MT6351_PMIC_RG_VCN18_STB_SEL_ADDR,
	 MT6351_PMIC_RG_VCN18_STB_SEL_MASK, MT6351_PMIC_RG_VCN18_STB_SEL_SHIFT},
	{PMIC_RG_VMIPI_CAL, MT6351_PMIC_RG_VMIPI_CAL_ADDR, MT6351_PMIC_RG_VMIPI_CAL_MASK,
	 MT6351_PMIC_RG_VMIPI_CAL_SHIFT},
	{PMIC_RG_VMIPI_VOSEL, MT6351_PMIC_RG_VMIPI_VOSEL_ADDR,
	 MT6351_PMIC_RG_VMIPI_VOSEL_MASK, MT6351_PMIC_RG_VMIPI_VOSEL_SHIFT},
	{PMIC_RG_VMIPI_NDIS_EN, MT6351_PMIC_RG_VMIPI_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VMIPI_NDIS_EN_MASK, MT6351_PMIC_RG_VMIPI_NDIS_EN_SHIFT},
	{PMIC_RG_VMIPI_STB_SEL, MT6351_PMIC_RG_VMIPI_STB_SEL_ADDR,
	 MT6351_PMIC_RG_VMIPI_STB_SEL_MASK, MT6351_PMIC_RG_VMIPI_STB_SEL_SHIFT},
	{PMIC_RG_VSRAM_PROC_NDIS_EN, MT6351_PMIC_RG_VSRAM_PROC_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_NDIS_EN_MASK, MT6351_PMIC_RG_VSRAM_PROC_NDIS_EN_SHIFT},
	{PMIC_RG_VSRAM_PROC_NDIS_PLCUR, MT6351_PMIC_RG_VSRAM_PROC_NDIS_PLCUR_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_NDIS_PLCUR_MASK, MT6351_PMIC_RG_VSRAM_PROC_NDIS_PLCUR_SHIFT},
	{PMIC_RG_VSRAM_PROC_STB_SEL, MT6351_PMIC_RG_VSRAM_PROC_STB_SEL_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_STB_SEL_MASK, MT6351_PMIC_RG_VSRAM_PROC_STB_SEL_SHIFT},
	{PMIC_RG_VSRAM_PROC_PLCUR_EN, MT6351_PMIC_RG_VSRAM_PROC_PLCUR_EN_ADDR,
	 MT6351_PMIC_RG_VSRAM_PROC_PLCUR_EN_MASK, MT6351_PMIC_RG_VSRAM_PROC_PLCUR_EN_SHIFT},
	{PMIC_RG_VDRAM_CAL, MT6351_PMIC_RG_VDRAM_CAL_ADDR, MT6351_PMIC_RG_VDRAM_CAL_MASK,
	 MT6351_PMIC_RG_VDRAM_CAL_SHIFT},
	{PMIC_RG_VDRAM_VOSEL, MT6351_PMIC_RG_VDRAM_VOSEL_ADDR,
	 MT6351_PMIC_RG_VDRAM_VOSEL_MASK, MT6351_PMIC_RG_VDRAM_VOSEL_SHIFT},
	{PMIC_RG_VDRAM_NDIS_EN, MT6351_PMIC_RG_VDRAM_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VDRAM_NDIS_EN_MASK, MT6351_PMIC_RG_VDRAM_NDIS_EN_SHIFT},
	{PMIC_RG_VDRAM_RSV, MT6351_PMIC_RG_VDRAM_RSV_ADDR, MT6351_PMIC_RG_VDRAM_RSV_MASK,
	 MT6351_PMIC_RG_VDRAM_RSV_SHIFT},
	{PMIC_RG_VDRAM_OC_TRIM, MT6351_PMIC_RG_VDRAM_OC_TRIM_ADDR,
	 MT6351_PMIC_RG_VDRAM_OC_TRIM_MASK, MT6351_PMIC_RG_VDRAM_OC_TRIM_SHIFT},
	{PMIC_RG_VLDO28_CAL, MT6351_PMIC_RG_VLDO28_CAL_ADDR,
	 MT6351_PMIC_RG_VLDO28_CAL_MASK, MT6351_PMIC_RG_VLDO28_CAL_SHIFT},
	{PMIC_RG_VLDO28_NDIS_EN, MT6351_PMIC_RG_VLDO28_NDIS_EN_ADDR,
	 MT6351_PMIC_RG_VLDO28_NDIS_EN_MASK, MT6351_PMIC_RG_VLDO28_NDIS_EN_SHIFT},
	{PMIC_RG_VLDO28_OC_TRIM, MT6351_PMIC_RG_VLDO28_OC_TRIM_ADDR,
	 MT6351_PMIC_RG_VLDO28_OC_TRIM_MASK, MT6351_PMIC_RG_VLDO28_OC_TRIM_SHIFT},
	{PMIC_RG_VLDO28_N2LP_EHC_V18, MT6351_PMIC_RG_VLDO28_N2LP_EHC_V18_ADDR,
	 MT6351_PMIC_RG_VLDO28_N2LP_EHC_V18_MASK, MT6351_PMIC_RG_VLDO28_N2LP_EHC_V18_SHIFT},
	{PMIC_BIF_COMMAND_0, MT6351_PMIC_BIF_COMMAND_0_ADDR,
	 MT6351_PMIC_BIF_COMMAND_0_MASK, MT6351_PMIC_BIF_COMMAND_0_SHIFT},
	{PMIC_BIF_COMMAND_1, MT6351_PMIC_BIF_COMMAND_1_ADDR,
	 MT6351_PMIC_BIF_COMMAND_1_MASK, MT6351_PMIC_BIF_COMMAND_1_SHIFT},
	{PMIC_BIF_COMMAND_2, MT6351_PMIC_BIF_COMMAND_2_ADDR,
	 MT6351_PMIC_BIF_COMMAND_2_MASK, MT6351_PMIC_BIF_COMMAND_2_SHIFT},
	{PMIC_BIF_COMMAND_3, MT6351_PMIC_BIF_COMMAND_3_ADDR,
	 MT6351_PMIC_BIF_COMMAND_3_MASK, MT6351_PMIC_BIF_COMMAND_3_SHIFT},
	{PMIC_BIF_COMMAND_4, MT6351_PMIC_BIF_COMMAND_4_ADDR,
	 MT6351_PMIC_BIF_COMMAND_4_MASK, MT6351_PMIC_BIF_COMMAND_4_SHIFT},
	{PMIC_BIF_COMMAND_5, MT6351_PMIC_BIF_COMMAND_5_ADDR,
	 MT6351_PMIC_BIF_COMMAND_5_MASK, MT6351_PMIC_BIF_COMMAND_5_SHIFT},
	{PMIC_BIF_COMMAND_6, MT6351_PMIC_BIF_COMMAND_6_ADDR,
	 MT6351_PMIC_BIF_COMMAND_6_MASK, MT6351_PMIC_BIF_COMMAND_6_SHIFT},
	{PMIC_BIF_COMMAND_7, MT6351_PMIC_BIF_COMMAND_7_ADDR,
	 MT6351_PMIC_BIF_COMMAND_7_MASK, MT6351_PMIC_BIF_COMMAND_7_SHIFT},
	{PMIC_BIF_COMMAND_8, MT6351_PMIC_BIF_COMMAND_8_ADDR,
	 MT6351_PMIC_BIF_COMMAND_8_MASK, MT6351_PMIC_BIF_COMMAND_8_SHIFT},
	{PMIC_BIF_COMMAND_9, MT6351_PMIC_BIF_COMMAND_9_ADDR,
	 MT6351_PMIC_BIF_COMMAND_9_MASK, MT6351_PMIC_BIF_COMMAND_9_SHIFT},
	{PMIC_BIF_COMMAND_10, MT6351_PMIC_BIF_COMMAND_10_ADDR,
	 MT6351_PMIC_BIF_COMMAND_10_MASK, MT6351_PMIC_BIF_COMMAND_10_SHIFT},
	{PMIC_BIF_COMMAND_11, MT6351_PMIC_BIF_COMMAND_11_ADDR,
	 MT6351_PMIC_BIF_COMMAND_11_MASK, MT6351_PMIC_BIF_COMMAND_11_SHIFT},
	{PMIC_BIF_COMMAND_12, MT6351_PMIC_BIF_COMMAND_12_ADDR,
	 MT6351_PMIC_BIF_COMMAND_12_MASK, MT6351_PMIC_BIF_COMMAND_12_SHIFT},
	{PMIC_BIF_COMMAND_13, MT6351_PMIC_BIF_COMMAND_13_ADDR,
	 MT6351_PMIC_BIF_COMMAND_13_MASK, MT6351_PMIC_BIF_COMMAND_13_SHIFT},
	{PMIC_BIF_COMMAND_14, MT6351_PMIC_BIF_COMMAND_14_ADDR,
	 MT6351_PMIC_BIF_COMMAND_14_MASK, MT6351_PMIC_BIF_COMMAND_14_SHIFT},
	{PMIC_BIF_RSV, MT6351_PMIC_BIF_RSV_ADDR, MT6351_PMIC_BIF_RSV_MASK,
	 MT6351_PMIC_BIF_RSV_SHIFT},
	{PMIC_BIF_COMMAND_TYPE, MT6351_PMIC_BIF_COMMAND_TYPE_ADDR,
	 MT6351_PMIC_BIF_COMMAND_TYPE_MASK, MT6351_PMIC_BIF_COMMAND_TYPE_SHIFT},
	{PMIC_BIF_TRASFER_NUM, MT6351_PMIC_BIF_TRASFER_NUM_ADDR,
	 MT6351_PMIC_BIF_TRASFER_NUM_MASK, MT6351_PMIC_BIF_TRASFER_NUM_SHIFT},
	{PMIC_BIF_LOGIC_0_SET, MT6351_PMIC_BIF_LOGIC_0_SET_ADDR,
	 MT6351_PMIC_BIF_LOGIC_0_SET_MASK, MT6351_PMIC_BIF_LOGIC_0_SET_SHIFT},
	{PMIC_BIF_LOGIC_1_SET, MT6351_PMIC_BIF_LOGIC_1_SET_ADDR,
	 MT6351_PMIC_BIF_LOGIC_1_SET_MASK, MT6351_PMIC_BIF_LOGIC_1_SET_SHIFT},
	{PMIC_BIF_STOP_SET, MT6351_PMIC_BIF_STOP_SET_ADDR, MT6351_PMIC_BIF_STOP_SET_MASK,
	 MT6351_PMIC_BIF_STOP_SET_SHIFT},
	{PMIC_BIF_DEBOUNCE_WND, MT6351_PMIC_BIF_DEBOUNCE_WND_ADDR,
	 MT6351_PMIC_BIF_DEBOUNCE_WND_MASK, MT6351_PMIC_BIF_DEBOUNCE_WND_SHIFT},
	{PMIC_BIF_DEBOUNCE_THD, MT6351_PMIC_BIF_DEBOUNCE_THD_ADDR,
	 MT6351_PMIC_BIF_DEBOUNCE_THD_MASK, MT6351_PMIC_BIF_DEBOUNCE_THD_SHIFT},
	{PMIC_BIF_DEBOUNCE_EN, MT6351_PMIC_BIF_DEBOUNCE_EN_ADDR,
	 MT6351_PMIC_BIF_DEBOUNCE_EN_MASK, MT6351_PMIC_BIF_DEBOUNCE_EN_SHIFT},
	{PMIC_BIF_READ_EXPECT_NUM, MT6351_PMIC_BIF_READ_EXPECT_NUM_ADDR,
	 MT6351_PMIC_BIF_READ_EXPECT_NUM_MASK, MT6351_PMIC_BIF_READ_EXPECT_NUM_SHIFT},
	{PMIC_BIF_TRASACT_TRIGGER, MT6351_PMIC_BIF_TRASACT_TRIGGER_ADDR,
	 MT6351_PMIC_BIF_TRASACT_TRIGGER_MASK, MT6351_PMIC_BIF_TRASACT_TRIGGER_SHIFT},
	{PMIC_BIF_DATA_NUM, MT6351_PMIC_BIF_DATA_NUM_ADDR, MT6351_PMIC_BIF_DATA_NUM_MASK,
	 MT6351_PMIC_BIF_DATA_NUM_SHIFT},
	{PMIC_BIF_RESPONSE, MT6351_PMIC_BIF_RESPONSE_ADDR, MT6351_PMIC_BIF_RESPONSE_MASK,
	 MT6351_PMIC_BIF_RESPONSE_SHIFT},
	{PMIC_BIF_DATA_0, MT6351_PMIC_BIF_DATA_0_ADDR, MT6351_PMIC_BIF_DATA_0_MASK,
	 MT6351_PMIC_BIF_DATA_0_SHIFT},
	{PMIC_BIF_ACK_0, MT6351_PMIC_BIF_ACK_0_ADDR, MT6351_PMIC_BIF_ACK_0_MASK,
	 MT6351_PMIC_BIF_ACK_0_SHIFT},
	{PMIC_BIF_ERROR_0, MT6351_PMIC_BIF_ERROR_0_ADDR, MT6351_PMIC_BIF_ERROR_0_MASK,
	 MT6351_PMIC_BIF_ERROR_0_SHIFT},
	{PMIC_BIF_DATA_1, MT6351_PMIC_BIF_DATA_1_ADDR, MT6351_PMIC_BIF_DATA_1_MASK,
	 MT6351_PMIC_BIF_DATA_1_SHIFT},
	{PMIC_BIF_ACK_1, MT6351_PMIC_BIF_ACK_1_ADDR, MT6351_PMIC_BIF_ACK_1_MASK,
	 MT6351_PMIC_BIF_ACK_1_SHIFT},
	{PMIC_BIF_ERROR_1, MT6351_PMIC_BIF_ERROR_1_ADDR, MT6351_PMIC_BIF_ERROR_1_MASK,
	 MT6351_PMIC_BIF_ERROR_1_SHIFT},
	{PMIC_BIF_DATA_2, MT6351_PMIC_BIF_DATA_2_ADDR, MT6351_PMIC_BIF_DATA_2_MASK,
	 MT6351_PMIC_BIF_DATA_2_SHIFT},
	{PMIC_BIF_ACK_2, MT6351_PMIC_BIF_ACK_2_ADDR, MT6351_PMIC_BIF_ACK_2_MASK,
	 MT6351_PMIC_BIF_ACK_2_SHIFT},
	{PMIC_BIF_ERROR_2, MT6351_PMIC_BIF_ERROR_2_ADDR, MT6351_PMIC_BIF_ERROR_2_MASK,
	 MT6351_PMIC_BIF_ERROR_2_SHIFT},
	{PMIC_BIF_DATA_3, MT6351_PMIC_BIF_DATA_3_ADDR, MT6351_PMIC_BIF_DATA_3_MASK,
	 MT6351_PMIC_BIF_DATA_3_SHIFT},
	{PMIC_BIF_ACK_3, MT6351_PMIC_BIF_ACK_3_ADDR, MT6351_PMIC_BIF_ACK_3_MASK,
	 MT6351_PMIC_BIF_ACK_3_SHIFT},
	{PMIC_BIF_ERROR_3, MT6351_PMIC_BIF_ERROR_3_ADDR, MT6351_PMIC_BIF_ERROR_3_MASK,
	 MT6351_PMIC_BIF_ERROR_3_SHIFT},
	{PMIC_BIF_DATA_4, MT6351_PMIC_BIF_DATA_4_ADDR, MT6351_PMIC_BIF_DATA_4_MASK,
	 MT6351_PMIC_BIF_DATA_4_SHIFT},
	{PMIC_BIF_ACK_4, MT6351_PMIC_BIF_ACK_4_ADDR, MT6351_PMIC_BIF_ACK_4_MASK,
	 MT6351_PMIC_BIF_ACK_4_SHIFT},
	{PMIC_BIF_ERROR_4, MT6351_PMIC_BIF_ERROR_4_ADDR, MT6351_PMIC_BIF_ERROR_4_MASK,
	 MT6351_PMIC_BIF_ERROR_4_SHIFT},
	{PMIC_BIF_DATA_5, MT6351_PMIC_BIF_DATA_5_ADDR, MT6351_PMIC_BIF_DATA_5_MASK,
	 MT6351_PMIC_BIF_DATA_5_SHIFT},
	{PMIC_BIF_ACK_5, MT6351_PMIC_BIF_ACK_5_ADDR, MT6351_PMIC_BIF_ACK_5_MASK,
	 MT6351_PMIC_BIF_ACK_5_SHIFT},
	{PMIC_BIF_ERROR_5, MT6351_PMIC_BIF_ERROR_5_ADDR, MT6351_PMIC_BIF_ERROR_5_MASK,
	 MT6351_PMIC_BIF_ERROR_5_SHIFT},
	{PMIC_BIF_DATA_6, MT6351_PMIC_BIF_DATA_6_ADDR, MT6351_PMIC_BIF_DATA_6_MASK,
	 MT6351_PMIC_BIF_DATA_6_SHIFT},
	{PMIC_BIF_ACK_6, MT6351_PMIC_BIF_ACK_6_ADDR, MT6351_PMIC_BIF_ACK_6_MASK,
	 MT6351_PMIC_BIF_ACK_6_SHIFT},
	{PMIC_BIF_ERROR_6, MT6351_PMIC_BIF_ERROR_6_ADDR, MT6351_PMIC_BIF_ERROR_6_MASK,
	 MT6351_PMIC_BIF_ERROR_6_SHIFT},
	{PMIC_BIF_DATA_7, MT6351_PMIC_BIF_DATA_7_ADDR, MT6351_PMIC_BIF_DATA_7_MASK,
	 MT6351_PMIC_BIF_DATA_7_SHIFT},
	{PMIC_BIF_ACK_7, MT6351_PMIC_BIF_ACK_7_ADDR, MT6351_PMIC_BIF_ACK_7_MASK,
	 MT6351_PMIC_BIF_ACK_7_SHIFT},
	{PMIC_BIF_ERROR_7, MT6351_PMIC_BIF_ERROR_7_ADDR, MT6351_PMIC_BIF_ERROR_7_MASK,
	 MT6351_PMIC_BIF_ERROR_7_SHIFT},
	{PMIC_BIF_DATA_8, MT6351_PMIC_BIF_DATA_8_ADDR, MT6351_PMIC_BIF_DATA_8_MASK,
	 MT6351_PMIC_BIF_DATA_8_SHIFT},
	{PMIC_BIF_ACK_8, MT6351_PMIC_BIF_ACK_8_ADDR, MT6351_PMIC_BIF_ACK_8_MASK,
	 MT6351_PMIC_BIF_ACK_8_SHIFT},
	{PMIC_BIF_ERROR_8, MT6351_PMIC_BIF_ERROR_8_ADDR, MT6351_PMIC_BIF_ERROR_8_MASK,
	 MT6351_PMIC_BIF_ERROR_8_SHIFT},
	{PMIC_BIF_DATA_9, MT6351_PMIC_BIF_DATA_9_ADDR, MT6351_PMIC_BIF_DATA_9_MASK,
	 MT6351_PMIC_BIF_DATA_9_SHIFT},
	{PMIC_BIF_ACK_9, MT6351_PMIC_BIF_ACK_9_ADDR, MT6351_PMIC_BIF_ACK_9_MASK,
	 MT6351_PMIC_BIF_ACK_9_SHIFT},
	{PMIC_BIF_ERROR_9, MT6351_PMIC_BIF_ERROR_9_ADDR, MT6351_PMIC_BIF_ERROR_9_MASK,
	 MT6351_PMIC_BIF_ERROR_9_SHIFT},
	{PMIC_BIF_TEST_MODE0, MT6351_PMIC_BIF_TEST_MODE0_ADDR,
	 MT6351_PMIC_BIF_TEST_MODE0_MASK, MT6351_PMIC_BIF_TEST_MODE0_SHIFT},
	{PMIC_BIF_TEST_MODE1, MT6351_PMIC_BIF_TEST_MODE1_ADDR,
	 MT6351_PMIC_BIF_TEST_MODE1_MASK, MT6351_PMIC_BIF_TEST_MODE1_SHIFT},
	{PMIC_BIF_TEST_MODE2, MT6351_PMIC_BIF_TEST_MODE2_ADDR,
	 MT6351_PMIC_BIF_TEST_MODE2_MASK, MT6351_PMIC_BIF_TEST_MODE2_SHIFT},
	{PMIC_BIF_TEST_MODE3, MT6351_PMIC_BIF_TEST_MODE3_ADDR,
	 MT6351_PMIC_BIF_TEST_MODE3_MASK, MT6351_PMIC_BIF_TEST_MODE3_SHIFT},
	{PMIC_BIF_TEST_MODE4, MT6351_PMIC_BIF_TEST_MODE4_ADDR,
	 MT6351_PMIC_BIF_TEST_MODE4_MASK, MT6351_PMIC_BIF_TEST_MODE4_SHIFT},
	{PMIC_BIF_TEST_MODE5, MT6351_PMIC_BIF_TEST_MODE5_ADDR,
	 MT6351_PMIC_BIF_TEST_MODE5_MASK, MT6351_PMIC_BIF_TEST_MODE5_SHIFT},
	{PMIC_BIF_TEST_MODE6, MT6351_PMIC_BIF_TEST_MODE6_ADDR,
	 MT6351_PMIC_BIF_TEST_MODE6_MASK, MT6351_PMIC_BIF_TEST_MODE6_SHIFT},
	{PMIC_BIF_TEST_MODE7, MT6351_PMIC_BIF_TEST_MODE7_ADDR,
	 MT6351_PMIC_BIF_TEST_MODE7_MASK, MT6351_PMIC_BIF_TEST_MODE7_SHIFT},
	{PMIC_BIF_TEST_MODE8, MT6351_PMIC_BIF_TEST_MODE8_ADDR,
	 MT6351_PMIC_BIF_TEST_MODE8_MASK, MT6351_PMIC_BIF_TEST_MODE8_SHIFT},
	{PMIC_BIF_BAT_LOST_SW, MT6351_PMIC_BIF_BAT_LOST_SW_ADDR,
	 MT6351_PMIC_BIF_BAT_LOST_SW_MASK, MT6351_PMIC_BIF_BAT_LOST_SW_SHIFT},
	{PMIC_BIF_RX_DATA_SW, MT6351_PMIC_BIF_RX_DATA_SW_ADDR,
	 MT6351_PMIC_BIF_RX_DATA_SW_MASK, MT6351_PMIC_BIF_RX_DATA_SW_SHIFT},
	{PMIC_BIF_TX_DATA_SW, MT6351_PMIC_BIF_TX_DATA_SW_ADDR,
	 MT6351_PMIC_BIF_TX_DATA_SW_MASK, MT6351_PMIC_BIF_TX_DATA_SW_SHIFT},
	{PMIC_BIF_RX_EN_SW, MT6351_PMIC_BIF_RX_EN_SW_ADDR, MT6351_PMIC_BIF_RX_EN_SW_MASK,
	 MT6351_PMIC_BIF_RX_EN_SW_SHIFT},
	{PMIC_BIF_TX_EN_SW, MT6351_PMIC_BIF_TX_EN_SW_ADDR, MT6351_PMIC_BIF_TX_EN_SW_MASK,
	 MT6351_PMIC_BIF_TX_EN_SW_SHIFT},
	{PMIC_BIF_BACK_NORMAL, MT6351_PMIC_BIF_BACK_NORMAL_ADDR,
	 MT6351_PMIC_BIF_BACK_NORMAL_MASK, MT6351_PMIC_BIF_BACK_NORMAL_SHIFT},
	{PMIC_BIF_IRQ_CLR, MT6351_PMIC_BIF_IRQ_CLR_ADDR, MT6351_PMIC_BIF_IRQ_CLR_MASK,
	 MT6351_PMIC_BIF_IRQ_CLR_SHIFT},
	{PMIC_BIF_BAT_LOST_GATED, MT6351_PMIC_BIF_BAT_LOST_GATED_ADDR,
	 MT6351_PMIC_BIF_BAT_LOST_GATED_MASK, MT6351_PMIC_BIF_BAT_LOST_GATED_SHIFT},
	{PMIC_BIF_IRQ, MT6351_PMIC_BIF_IRQ_ADDR, MT6351_PMIC_BIF_IRQ_MASK,
	 MT6351_PMIC_BIF_IRQ_SHIFT},
	{PMIC_BIF_TIMEOUT, MT6351_PMIC_BIF_TIMEOUT_ADDR, MT6351_PMIC_BIF_TIMEOUT_MASK,
	 MT6351_PMIC_BIF_TIMEOUT_SHIFT},
	{PMIC_BIF_BAT_LOST, MT6351_PMIC_BIF_BAT_LOST_ADDR, MT6351_PMIC_BIF_BAT_LOST_MASK,
	 MT6351_PMIC_BIF_BAT_LOST_SHIFT},
	{PMIC_BIF_TOTAL_VALID, MT6351_PMIC_BIF_TOTAL_VALID_ADDR,
	 MT6351_PMIC_BIF_TOTAL_VALID_MASK, MT6351_PMIC_BIF_TOTAL_VALID_SHIFT},
	{PMIC_BIF_BUS_STATUS, MT6351_PMIC_BIF_BUS_STATUS_ADDR,
	 MT6351_PMIC_BIF_BUS_STATUS_MASK, MT6351_PMIC_BIF_BUS_STATUS_SHIFT},
	{PMIC_BIF_POWER_UP_COUNT, MT6351_PMIC_BIF_POWER_UP_COUNT_ADDR,
	 MT6351_PMIC_BIF_POWER_UP_COUNT_MASK, MT6351_PMIC_BIF_POWER_UP_COUNT_SHIFT},
	{PMIC_BIF_POWER_UP, MT6351_PMIC_BIF_POWER_UP_ADDR, MT6351_PMIC_BIF_POWER_UP_MASK,
	 MT6351_PMIC_BIF_POWER_UP_SHIFT},
	{PMIC_BIF_RX_ERROR_UNKNOWN, MT6351_PMIC_BIF_RX_ERROR_UNKNOWN_ADDR,
	 MT6351_PMIC_BIF_RX_ERROR_UNKNOWN_MASK, MT6351_PMIC_BIF_RX_ERROR_UNKNOWN_SHIFT},
	{PMIC_BIF_RX_ERROR_INSUFF, MT6351_PMIC_BIF_RX_ERROR_INSUFF_ADDR,
	 MT6351_PMIC_BIF_RX_ERROR_INSUFF_MASK, MT6351_PMIC_BIF_RX_ERROR_INSUFF_SHIFT},
	{PMIC_BIF_RX_ERROR_LOWPHASE, MT6351_PMIC_BIF_RX_ERROR_LOWPHASE_ADDR,
	 MT6351_PMIC_BIF_RX_ERROR_LOWPHASE_MASK, MT6351_PMIC_BIF_RX_ERROR_LOWPHASE_SHIFT},
	{PMIC_BIF_RX_STATE, MT6351_PMIC_BIF_RX_STATE_ADDR, MT6351_PMIC_BIF_RX_STATE_MASK,
	 MT6351_PMIC_BIF_RX_STATE_SHIFT},
	{PMIC_BIF_FLOW_CTL_STATE, MT6351_PMIC_BIF_FLOW_CTL_STATE_ADDR,
	 MT6351_PMIC_BIF_FLOW_CTL_STATE_MASK, MT6351_PMIC_BIF_FLOW_CTL_STATE_SHIFT},
	{PMIC_BIF_TX_STATE, MT6351_PMIC_BIF_TX_STATE_ADDR, MT6351_PMIC_BIF_TX_STATE_MASK,
	 MT6351_PMIC_BIF_TX_STATE_SHIFT},
	{PMIC_AD_QI_BIF_RX_DATA, MT6351_PMIC_AD_QI_BIF_RX_DATA_ADDR,
	 MT6351_PMIC_AD_QI_BIF_RX_DATA_MASK, MT6351_PMIC_AD_QI_BIF_RX_DATA_SHIFT},
	{PMIC_DA_QI_BIF_RX_EN, MT6351_PMIC_DA_QI_BIF_RX_EN_ADDR,
	 MT6351_PMIC_DA_QI_BIF_RX_EN_MASK, MT6351_PMIC_DA_QI_BIF_RX_EN_SHIFT},
	{PMIC_DA_QI_BIF_TX_DATA, MT6351_PMIC_DA_QI_BIF_TX_DATA_ADDR,
	 MT6351_PMIC_DA_QI_BIF_TX_DATA_MASK, MT6351_PMIC_DA_QI_BIF_TX_DATA_SHIFT},
	{PMIC_DA_QI_BIF_TX_EN, MT6351_PMIC_DA_QI_BIF_TX_EN_ADDR,
	 MT6351_PMIC_DA_QI_BIF_TX_EN_MASK, MT6351_PMIC_DA_QI_BIF_TX_EN_SHIFT},
	{PMIC_BIF_TX_DATA_FIANL, MT6351_PMIC_BIF_TX_DATA_FIANL_ADDR,
	 MT6351_PMIC_BIF_TX_DATA_FIANL_MASK, MT6351_PMIC_BIF_TX_DATA_FIANL_SHIFT},
	{PMIC_BIF_RX_DATA_SAMPLING, MT6351_PMIC_BIF_RX_DATA_SAMPLING_ADDR,
	 MT6351_PMIC_BIF_RX_DATA_SAMPLING_MASK, MT6351_PMIC_BIF_RX_DATA_SAMPLING_SHIFT},
	{PMIC_BIF_RX_DATA_RECOVERY, MT6351_PMIC_BIF_RX_DATA_RECOVERY_ADDR,
	 MT6351_PMIC_BIF_RX_DATA_RECOVERY_MASK, MT6351_PMIC_BIF_RX_DATA_RECOVERY_SHIFT},
	{PMIC_RG_BATON_HT_EN, MT6351_PMIC_RG_BATON_HT_EN_ADDR,
	 MT6351_PMIC_RG_BATON_HT_EN_MASK, MT6351_PMIC_RG_BATON_HT_EN_SHIFT},
	{PMIC_RG_BATON_HT_EN_DLY_TIME, MT6351_PMIC_RG_BATON_HT_EN_DLY_TIME_ADDR,
	 MT6351_PMIC_RG_BATON_HT_EN_DLY_TIME_MASK, MT6351_PMIC_RG_BATON_HT_EN_DLY_TIME_SHIFT},
	{PMIC_DA_QI_BATON_HT_EN, MT6351_PMIC_DA_QI_BATON_HT_EN_ADDR,
	 MT6351_PMIC_DA_QI_BATON_HT_EN_MASK, MT6351_PMIC_DA_QI_BATON_HT_EN_SHIFT},
	{PMIC_BIF_TIMEOUT_SET, MT6351_PMIC_BIF_TIMEOUT_SET_ADDR,
	 MT6351_PMIC_BIF_TIMEOUT_SET_MASK, MT6351_PMIC_BIF_TIMEOUT_SET_SHIFT},
	{PMIC_BIF_RX_DEG_WND, MT6351_PMIC_BIF_RX_DEG_WND_ADDR,
	 MT6351_PMIC_BIF_RX_DEG_WND_MASK, MT6351_PMIC_BIF_RX_DEG_WND_SHIFT},
	{PMIC_BIF_RX_DEG_EN, MT6351_PMIC_BIF_RX_DEG_EN_ADDR,
	 MT6351_PMIC_BIF_RX_DEG_EN_MASK, MT6351_PMIC_BIF_RX_DEG_EN_SHIFT},
	{PMIC_BIF_RSV1, MT6351_PMIC_BIF_RSV1_ADDR, MT6351_PMIC_BIF_RSV1_MASK,
	 MT6351_PMIC_BIF_RSV1_SHIFT},
	{PMIC_BIF_RSV0, MT6351_PMIC_BIF_RSV0_ADDR, MT6351_PMIC_BIF_RSV0_MASK,
	 MT6351_PMIC_BIF_RSV0_SHIFT},
	{PMIC_RG_OTP_PA, MT6351_PMIC_RG_OTP_PA_ADDR, MT6351_PMIC_RG_OTP_PA_MASK,
	 MT6351_PMIC_RG_OTP_PA_SHIFT},
	{PMIC_RG_OTP_PDIN, MT6351_PMIC_RG_OTP_PDIN_ADDR, MT6351_PMIC_RG_OTP_PDIN_MASK,
	 MT6351_PMIC_RG_OTP_PDIN_SHIFT},
	{PMIC_RG_OTP_PTM, MT6351_PMIC_RG_OTP_PTM_ADDR, MT6351_PMIC_RG_OTP_PTM_MASK,
	 MT6351_PMIC_RG_OTP_PTM_SHIFT},
	{PMIC_RG_OTP_PWE, MT6351_PMIC_RG_OTP_PWE_ADDR, MT6351_PMIC_RG_OTP_PWE_MASK,
	 MT6351_PMIC_RG_OTP_PWE_SHIFT},
	{PMIC_RG_OTP_PPROG, MT6351_PMIC_RG_OTP_PPROG_ADDR, MT6351_PMIC_RG_OTP_PPROG_MASK,
	 MT6351_PMIC_RG_OTP_PPROG_SHIFT},
	{PMIC_RG_OTP_PWE_SRC, MT6351_PMIC_RG_OTP_PWE_SRC_ADDR,
	 MT6351_PMIC_RG_OTP_PWE_SRC_MASK, MT6351_PMIC_RG_OTP_PWE_SRC_SHIFT},
	{PMIC_RG_OTP_PROG_PKEY, MT6351_PMIC_RG_OTP_PROG_PKEY_ADDR,
	 MT6351_PMIC_RG_OTP_PROG_PKEY_MASK, MT6351_PMIC_RG_OTP_PROG_PKEY_SHIFT},
	{PMIC_RG_OTP_RD_PKEY, MT6351_PMIC_RG_OTP_RD_PKEY_ADDR,
	 MT6351_PMIC_RG_OTP_RD_PKEY_MASK, MT6351_PMIC_RG_OTP_RD_PKEY_SHIFT},
	{PMIC_RG_OTP_RD_TRIG, MT6351_PMIC_RG_OTP_RD_TRIG_ADDR,
	 MT6351_PMIC_RG_OTP_RD_TRIG_MASK, MT6351_PMIC_RG_OTP_RD_TRIG_SHIFT},
	{PMIC_RG_RD_RDY_BYPASS, MT6351_PMIC_RG_RD_RDY_BYPASS_ADDR,
	 MT6351_PMIC_RG_RD_RDY_BYPASS_MASK, MT6351_PMIC_RG_RD_RDY_BYPASS_SHIFT},
	{PMIC_RG_SKIP_OTP_OUT, MT6351_PMIC_RG_SKIP_OTP_OUT_ADDR,
	 MT6351_PMIC_RG_SKIP_OTP_OUT_MASK, MT6351_PMIC_RG_SKIP_OTP_OUT_SHIFT},
	{PMIC_RG_OTP_RD_SW, MT6351_PMIC_RG_OTP_RD_SW_ADDR, MT6351_PMIC_RG_OTP_RD_SW_MASK,
	 MT6351_PMIC_RG_OTP_RD_SW_SHIFT},
	{PMIC_RG_OTP_DOUT_SW, MT6351_PMIC_RG_OTP_DOUT_SW_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_SW_MASK, MT6351_PMIC_RG_OTP_DOUT_SW_SHIFT},
	{PMIC_RG_OTP_RD_BUSY, MT6351_PMIC_RG_OTP_RD_BUSY_ADDR,
	 MT6351_PMIC_RG_OTP_RD_BUSY_MASK, MT6351_PMIC_RG_OTP_RD_BUSY_SHIFT},
	{PMIC_RG_OTP_RD_ACK, MT6351_PMIC_RG_OTP_RD_ACK_ADDR,
	 MT6351_PMIC_RG_OTP_RD_ACK_MASK, MT6351_PMIC_RG_OTP_RD_ACK_SHIFT},
	{PMIC_RG_OTP_PA_SW, MT6351_PMIC_RG_OTP_PA_SW_ADDR, MT6351_PMIC_RG_OTP_PA_SW_MASK,
	 MT6351_PMIC_RG_OTP_PA_SW_SHIFT},
	{PMIC_RG_OTP_DOUT_0_15, MT6351_PMIC_RG_OTP_DOUT_0_15_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_0_15_MASK, MT6351_PMIC_RG_OTP_DOUT_0_15_SHIFT},
	{PMIC_RG_OTP_DOUT_16_31, MT6351_PMIC_RG_OTP_DOUT_16_31_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_16_31_MASK, MT6351_PMIC_RG_OTP_DOUT_16_31_SHIFT},
	{PMIC_RG_OTP_DOUT_32_47, MT6351_PMIC_RG_OTP_DOUT_32_47_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_32_47_MASK, MT6351_PMIC_RG_OTP_DOUT_32_47_SHIFT},
	{PMIC_RG_OTP_DOUT_48_63, MT6351_PMIC_RG_OTP_DOUT_48_63_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_48_63_MASK, MT6351_PMIC_RG_OTP_DOUT_48_63_SHIFT},
	{PMIC_RG_OTP_DOUT_64_79, MT6351_PMIC_RG_OTP_DOUT_64_79_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_64_79_MASK, MT6351_PMIC_RG_OTP_DOUT_64_79_SHIFT},
	{PMIC_RG_OTP_DOUT_80_95, MT6351_PMIC_RG_OTP_DOUT_80_95_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_80_95_MASK, MT6351_PMIC_RG_OTP_DOUT_80_95_SHIFT},
	{PMIC_RG_OTP_DOUT_96_111, MT6351_PMIC_RG_OTP_DOUT_96_111_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_96_111_MASK, MT6351_PMIC_RG_OTP_DOUT_96_111_SHIFT},
	{PMIC_RG_OTP_DOUT_112_127, MT6351_PMIC_RG_OTP_DOUT_112_127_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_112_127_MASK, MT6351_PMIC_RG_OTP_DOUT_112_127_SHIFT},
	{PMIC_RG_OTP_DOUT_128_143, MT6351_PMIC_RG_OTP_DOUT_128_143_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_128_143_MASK, MT6351_PMIC_RG_OTP_DOUT_128_143_SHIFT},
	{PMIC_RG_OTP_DOUT_144_159, MT6351_PMIC_RG_OTP_DOUT_144_159_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_144_159_MASK, MT6351_PMIC_RG_OTP_DOUT_144_159_SHIFT},
	{PMIC_RG_OTP_DOUT_160_175, MT6351_PMIC_RG_OTP_DOUT_160_175_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_160_175_MASK, MT6351_PMIC_RG_OTP_DOUT_160_175_SHIFT},
	{PMIC_RG_OTP_DOUT_176_191, MT6351_PMIC_RG_OTP_DOUT_176_191_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_176_191_MASK, MT6351_PMIC_RG_OTP_DOUT_176_191_SHIFT},
	{PMIC_RG_OTP_DOUT_192_207, MT6351_PMIC_RG_OTP_DOUT_192_207_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_192_207_MASK, MT6351_PMIC_RG_OTP_DOUT_192_207_SHIFT},
	{PMIC_RG_OTP_DOUT_208_223, MT6351_PMIC_RG_OTP_DOUT_208_223_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_208_223_MASK, MT6351_PMIC_RG_OTP_DOUT_208_223_SHIFT},
	{PMIC_RG_OTP_DOUT_224_239, MT6351_PMIC_RG_OTP_DOUT_224_239_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_224_239_MASK, MT6351_PMIC_RG_OTP_DOUT_224_239_SHIFT},
	{PMIC_RG_OTP_DOUT_240_255, MT6351_PMIC_RG_OTP_DOUT_240_255_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_240_255_MASK, MT6351_PMIC_RG_OTP_DOUT_240_255_SHIFT},
	{PMIC_RG_OTP_DOUT_256_271, MT6351_PMIC_RG_OTP_DOUT_256_271_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_256_271_MASK, MT6351_PMIC_RG_OTP_DOUT_256_271_SHIFT},
	{PMIC_RG_OTP_DOUT_272_287, MT6351_PMIC_RG_OTP_DOUT_272_287_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_272_287_MASK, MT6351_PMIC_RG_OTP_DOUT_272_287_SHIFT},
	{PMIC_RG_OTP_DOUT_288_303, MT6351_PMIC_RG_OTP_DOUT_288_303_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_288_303_MASK, MT6351_PMIC_RG_OTP_DOUT_288_303_SHIFT},
	{PMIC_RG_OTP_DOUT_304_319, MT6351_PMIC_RG_OTP_DOUT_304_319_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_304_319_MASK, MT6351_PMIC_RG_OTP_DOUT_304_319_SHIFT},
	{PMIC_RG_OTP_DOUT_320_335, MT6351_PMIC_RG_OTP_DOUT_320_335_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_320_335_MASK, MT6351_PMIC_RG_OTP_DOUT_320_335_SHIFT},
	{PMIC_RG_OTP_DOUT_336_351, MT6351_PMIC_RG_OTP_DOUT_336_351_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_336_351_MASK, MT6351_PMIC_RG_OTP_DOUT_336_351_SHIFT},
	{PMIC_RG_OTP_DOUT_352_367, MT6351_PMIC_RG_OTP_DOUT_352_367_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_352_367_MASK, MT6351_PMIC_RG_OTP_DOUT_352_367_SHIFT},
	{PMIC_RG_OTP_DOUT_368_383, MT6351_PMIC_RG_OTP_DOUT_368_383_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_368_383_MASK, MT6351_PMIC_RG_OTP_DOUT_368_383_SHIFT},
	{PMIC_RG_OTP_DOUT_384_399, MT6351_PMIC_RG_OTP_DOUT_384_399_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_384_399_MASK, MT6351_PMIC_RG_OTP_DOUT_384_399_SHIFT},
	{PMIC_RG_OTP_DOUT_400_415, MT6351_PMIC_RG_OTP_DOUT_400_415_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_400_415_MASK, MT6351_PMIC_RG_OTP_DOUT_400_415_SHIFT},
	{PMIC_RG_OTP_DOUT_416_431, MT6351_PMIC_RG_OTP_DOUT_416_431_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_416_431_MASK, MT6351_PMIC_RG_OTP_DOUT_416_431_SHIFT},
	{PMIC_RG_OTP_DOUT_432_447, MT6351_PMIC_RG_OTP_DOUT_432_447_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_432_447_MASK, MT6351_PMIC_RG_OTP_DOUT_432_447_SHIFT},
	{PMIC_RG_OTP_DOUT_448_463, MT6351_PMIC_RG_OTP_DOUT_448_463_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_448_463_MASK, MT6351_PMIC_RG_OTP_DOUT_448_463_SHIFT},
	{PMIC_RG_OTP_DOUT_464_479, MT6351_PMIC_RG_OTP_DOUT_464_479_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_464_479_MASK, MT6351_PMIC_RG_OTP_DOUT_464_479_SHIFT},
	{PMIC_RG_OTP_DOUT_480_495, MT6351_PMIC_RG_OTP_DOUT_480_495_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_480_495_MASK, MT6351_PMIC_RG_OTP_DOUT_480_495_SHIFT},
	{PMIC_RG_OTP_DOUT_496_511, MT6351_PMIC_RG_OTP_DOUT_496_511_ADDR,
	 MT6351_PMIC_RG_OTP_DOUT_496_511_MASK, MT6351_PMIC_RG_OTP_DOUT_496_511_SHIFT},
	{PMIC_RG_OTP_VAL_0_15, MT6351_PMIC_RG_OTP_VAL_0_15_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_0_15_MASK, MT6351_PMIC_RG_OTP_VAL_0_15_SHIFT},
	{PMIC_RG_OTP_VAL_16_31, MT6351_PMIC_RG_OTP_VAL_16_31_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_16_31_MASK, MT6351_PMIC_RG_OTP_VAL_16_31_SHIFT},
	{PMIC_RG_OTP_VAL_32_47, MT6351_PMIC_RG_OTP_VAL_32_47_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_32_47_MASK, MT6351_PMIC_RG_OTP_VAL_32_47_SHIFT},
	{PMIC_RG_OTP_VAL_48_63, MT6351_PMIC_RG_OTP_VAL_48_63_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_48_63_MASK, MT6351_PMIC_RG_OTP_VAL_48_63_SHIFT},
	{PMIC_RG_OTP_VAL_64_79, MT6351_PMIC_RG_OTP_VAL_64_79_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_64_79_MASK, MT6351_PMIC_RG_OTP_VAL_64_79_SHIFT},
	{PMIC_RG_OTP_VAL_80_95, MT6351_PMIC_RG_OTP_VAL_80_95_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_80_95_MASK, MT6351_PMIC_RG_OTP_VAL_80_95_SHIFT},
	{PMIC_RG_OTP_VAL_96_111, MT6351_PMIC_RG_OTP_VAL_96_111_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_96_111_MASK, MT6351_PMIC_RG_OTP_VAL_96_111_SHIFT},
	{PMIC_RG_OTP_VAL_112_127, MT6351_PMIC_RG_OTP_VAL_112_127_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_112_127_MASK, MT6351_PMIC_RG_OTP_VAL_112_127_SHIFT},
	{PMIC_RG_OTP_VAL_128_143, MT6351_PMIC_RG_OTP_VAL_128_143_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_128_143_MASK, MT6351_PMIC_RG_OTP_VAL_128_143_SHIFT},
	{PMIC_RG_OTP_VAL_144_159, MT6351_PMIC_RG_OTP_VAL_144_159_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_144_159_MASK, MT6351_PMIC_RG_OTP_VAL_144_159_SHIFT},
	{PMIC_RG_OTP_VAL_160_175, MT6351_PMIC_RG_OTP_VAL_160_175_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_160_175_MASK, MT6351_PMIC_RG_OTP_VAL_160_175_SHIFT},
	{PMIC_RG_OTP_VAL_176_191, MT6351_PMIC_RG_OTP_VAL_176_191_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_176_191_MASK, MT6351_PMIC_RG_OTP_VAL_176_191_SHIFT},
	{PMIC_RG_OTP_VAL_192_207, MT6351_PMIC_RG_OTP_VAL_192_207_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_192_207_MASK, MT6351_PMIC_RG_OTP_VAL_192_207_SHIFT},
	{PMIC_RG_OTP_VAL_208_223, MT6351_PMIC_RG_OTP_VAL_208_223_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_208_223_MASK, MT6351_PMIC_RG_OTP_VAL_208_223_SHIFT},
	{PMIC_RG_OTP_VAL_224_239, MT6351_PMIC_RG_OTP_VAL_224_239_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_224_239_MASK, MT6351_PMIC_RG_OTP_VAL_224_239_SHIFT},
	{PMIC_RG_OTP_VAL_240_255, MT6351_PMIC_RG_OTP_VAL_240_255_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_240_255_MASK, MT6351_PMIC_RG_OTP_VAL_240_255_SHIFT},
	{PMIC_RG_OTP_VAL_256_271, MT6351_PMIC_RG_OTP_VAL_256_271_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_256_271_MASK, MT6351_PMIC_RG_OTP_VAL_256_271_SHIFT},
	{PMIC_RG_OTP_VAL_272_287, MT6351_PMIC_RG_OTP_VAL_272_287_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_272_287_MASK, MT6351_PMIC_RG_OTP_VAL_272_287_SHIFT},
	{PMIC_RG_OTP_VAL_288_303, MT6351_PMIC_RG_OTP_VAL_288_303_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_288_303_MASK, MT6351_PMIC_RG_OTP_VAL_288_303_SHIFT},
	{PMIC_RG_OTP_VAL_304_319, MT6351_PMIC_RG_OTP_VAL_304_319_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_304_319_MASK, MT6351_PMIC_RG_OTP_VAL_304_319_SHIFT},
	{PMIC_RG_OTP_VAL_320_335, MT6351_PMIC_RG_OTP_VAL_320_335_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_320_335_MASK, MT6351_PMIC_RG_OTP_VAL_320_335_SHIFT},
	{PMIC_RG_OTP_VAL_336_351, MT6351_PMIC_RG_OTP_VAL_336_351_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_336_351_MASK, MT6351_PMIC_RG_OTP_VAL_336_351_SHIFT},
	{PMIC_RG_OTP_VAL_352_367, MT6351_PMIC_RG_OTP_VAL_352_367_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_352_367_MASK, MT6351_PMIC_RG_OTP_VAL_352_367_SHIFT},
	{PMIC_RG_OTP_VAL_368_383, MT6351_PMIC_RG_OTP_VAL_368_383_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_368_383_MASK, MT6351_PMIC_RG_OTP_VAL_368_383_SHIFT},
	{PMIC_RG_OTP_VAL_384_399, MT6351_PMIC_RG_OTP_VAL_384_399_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_384_399_MASK, MT6351_PMIC_RG_OTP_VAL_384_399_SHIFT},
	{PMIC_RG_OTP_VAL_400_415, MT6351_PMIC_RG_OTP_VAL_400_415_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_400_415_MASK, MT6351_PMIC_RG_OTP_VAL_400_415_SHIFT},
	{PMIC_RG_OTP_VAL_416_431, MT6351_PMIC_RG_OTP_VAL_416_431_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_416_431_MASK, MT6351_PMIC_RG_OTP_VAL_416_431_SHIFT},
	{PMIC_RG_OTP_VAL_432_447, MT6351_PMIC_RG_OTP_VAL_432_447_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_432_447_MASK, MT6351_PMIC_RG_OTP_VAL_432_447_SHIFT},
	{PMIC_RG_OTP_VAL_448_463, MT6351_PMIC_RG_OTP_VAL_448_463_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_448_463_MASK, MT6351_PMIC_RG_OTP_VAL_448_463_SHIFT},
	{PMIC_RG_OTP_VAL_464_479, MT6351_PMIC_RG_OTP_VAL_464_479_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_464_479_MASK, MT6351_PMIC_RG_OTP_VAL_464_479_SHIFT},
	{PMIC_RG_OTP_VAL_480_495, MT6351_PMIC_RG_OTP_VAL_480_495_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_480_495_MASK, MT6351_PMIC_RG_OTP_VAL_480_495_SHIFT},
	{PMIC_RG_OTP_VAL_496_511, MT6351_PMIC_RG_OTP_VAL_496_511_ADDR,
	 MT6351_PMIC_RG_OTP_VAL_496_511_MASK, MT6351_PMIC_RG_OTP_VAL_496_511_SHIFT},
	{PMIC_MIX_EOSC32_STP_LPDTB, MT6351_PMIC_MIX_EOSC32_STP_LPDTB_ADDR,
	 MT6351_PMIC_MIX_EOSC32_STP_LPDTB_MASK, MT6351_PMIC_MIX_EOSC32_STP_LPDTB_SHIFT},
	{PMIC_MIX_EOSC32_STP_LPDEN, MT6351_PMIC_MIX_EOSC32_STP_LPDEN_ADDR,
	 MT6351_PMIC_MIX_EOSC32_STP_LPDEN_MASK, MT6351_PMIC_MIX_EOSC32_STP_LPDEN_SHIFT},
	{PMIC_MIX_XOSC32_STP_PWDB, MT6351_PMIC_MIX_XOSC32_STP_PWDB_ADDR,
	 MT6351_PMIC_MIX_XOSC32_STP_PWDB_MASK, MT6351_PMIC_MIX_XOSC32_STP_PWDB_SHIFT},
	{PMIC_MIX_XOSC32_STP_LPDTB, MT6351_PMIC_MIX_XOSC32_STP_LPDTB_ADDR,
	 MT6351_PMIC_MIX_XOSC32_STP_LPDTB_MASK, MT6351_PMIC_MIX_XOSC32_STP_LPDTB_SHIFT},
	{PMIC_MIX_XOSC32_STP_LPDEN, MT6351_PMIC_MIX_XOSC32_STP_LPDEN_ADDR,
	 MT6351_PMIC_MIX_XOSC32_STP_LPDEN_MASK, MT6351_PMIC_MIX_XOSC32_STP_LPDEN_SHIFT},
	{PMIC_MIX_XOSC32_STP_LPDRST, MT6351_PMIC_MIX_XOSC32_STP_LPDRST_ADDR,
	 MT6351_PMIC_MIX_XOSC32_STP_LPDRST_MASK, MT6351_PMIC_MIX_XOSC32_STP_LPDRST_SHIFT},
	{PMIC_MIX_XOSC32_STP_CALI, MT6351_PMIC_MIX_XOSC32_STP_CALI_ADDR,
	 MT6351_PMIC_MIX_XOSC32_STP_CALI_MASK, MT6351_PMIC_MIX_XOSC32_STP_CALI_SHIFT},
	{PMIC_STMP_MODE, MT6351_PMIC_STMP_MODE_ADDR, MT6351_PMIC_STMP_MODE_MASK,
	 MT6351_PMIC_STMP_MODE_SHIFT},
	{PMIC_MIX_EOSC32_STP_CHOP_EN, MT6351_PMIC_MIX_EOSC32_STP_CHOP_EN_ADDR,
	 MT6351_PMIC_MIX_EOSC32_STP_CHOP_EN_MASK, MT6351_PMIC_MIX_EOSC32_STP_CHOP_EN_SHIFT},
	{PMIC_MIX_DCXO_STP_LVSH_EN, MT6351_PMIC_MIX_DCXO_STP_LVSH_EN_ADDR,
	 MT6351_PMIC_MIX_DCXO_STP_LVSH_EN_MASK, MT6351_PMIC_MIX_DCXO_STP_LVSH_EN_SHIFT},
	{PMIC_MIX_PMU_STP_DDLO_VRTC, MT6351_PMIC_MIX_PMU_STP_DDLO_VRTC_ADDR,
	 MT6351_PMIC_MIX_PMU_STP_DDLO_VRTC_MASK, MT6351_PMIC_MIX_PMU_STP_DDLO_VRTC_SHIFT},
	{PMIC_MIX_PMU_STP_DDLO_VRTC_EN, MT6351_PMIC_MIX_PMU_STP_DDLO_VRTC_EN_ADDR,
	 MT6351_PMIC_MIX_PMU_STP_DDLO_VRTC_EN_MASK, MT6351_PMIC_MIX_PMU_STP_DDLO_VRTC_EN_SHIFT},
	{PMIC_MIX_RTC_STP_XOSC32_ENB, MT6351_PMIC_MIX_RTC_STP_XOSC32_ENB_ADDR,
	 MT6351_PMIC_MIX_RTC_STP_XOSC32_ENB_MASK, MT6351_PMIC_MIX_RTC_STP_XOSC32_ENB_SHIFT},
	{PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE,
	 MT6351_PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_ADDR,
	 MT6351_PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_MASK,
	 MT6351_PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_SHIFT},
	{PMIC_MIX_EOSC32_STP_RSV, MT6351_PMIC_MIX_EOSC32_STP_RSV_ADDR,
	 MT6351_PMIC_MIX_EOSC32_STP_RSV_MASK, MT6351_PMIC_MIX_EOSC32_STP_RSV_SHIFT},
	{PMIC_MIX_EOSC32_VCT_EN, MT6351_PMIC_MIX_EOSC32_VCT_EN_ADDR,
	 MT6351_PMIC_MIX_EOSC32_VCT_EN_MASK, MT6351_PMIC_MIX_EOSC32_VCT_EN_SHIFT},
	{PMIC_MIX_EOSC32_OPT, MT6351_PMIC_MIX_EOSC32_OPT_ADDR,
	 MT6351_PMIC_MIX_EOSC32_OPT_MASK, MT6351_PMIC_MIX_EOSC32_OPT_SHIFT},
	{PMIC_MIX_DCXO_STP_LVSH_EN_INT, MT6351_PMIC_MIX_DCXO_STP_LVSH_EN_INT_ADDR,
	 MT6351_PMIC_MIX_DCXO_STP_LVSH_EN_INT_MASK, MT6351_PMIC_MIX_DCXO_STP_LVSH_EN_INT_SHIFT},
	{PMIC_MIX_RTC_GPIO_COREDETB, MT6351_PMIC_MIX_RTC_GPIO_COREDETB_ADDR,
	 MT6351_PMIC_MIX_RTC_GPIO_COREDETB_MASK, MT6351_PMIC_MIX_RTC_GPIO_COREDETB_SHIFT},
	{PMIC_MIX_RTC_GPIO_F32KOB, MT6351_PMIC_MIX_RTC_GPIO_F32KOB_ADDR,
	 MT6351_PMIC_MIX_RTC_GPIO_F32KOB_MASK, MT6351_PMIC_MIX_RTC_GPIO_F32KOB_SHIFT},
	{PMIC_MIX_RTC_GPIO_GPO, MT6351_PMIC_MIX_RTC_GPIO_GPO_ADDR,
	 MT6351_PMIC_MIX_RTC_GPIO_GPO_MASK, MT6351_PMIC_MIX_RTC_GPIO_GPO_SHIFT},
	{PMIC_MIX_RTC_GPIO_OE, MT6351_PMIC_MIX_RTC_GPIO_OE_ADDR,
	 MT6351_PMIC_MIX_RTC_GPIO_OE_MASK, MT6351_PMIC_MIX_RTC_GPIO_OE_SHIFT},
	{PMIC_MIX_RTC_STP_DEBUG_OUT, MT6351_PMIC_MIX_RTC_STP_DEBUG_OUT_ADDR,
	 MT6351_PMIC_MIX_RTC_STP_DEBUG_OUT_MASK, MT6351_PMIC_MIX_RTC_STP_DEBUG_OUT_SHIFT},
	{PMIC_MIX_RTC_STP_DEBUG_SEL, MT6351_PMIC_MIX_RTC_STP_DEBUG_SEL_ADDR,
	 MT6351_PMIC_MIX_RTC_STP_DEBUG_SEL_MASK, MT6351_PMIC_MIX_RTC_STP_DEBUG_SEL_SHIFT},
	{PMIC_MIX_RTC_STP_K_EOSC32_EN, MT6351_PMIC_MIX_RTC_STP_K_EOSC32_EN_ADDR,
	 MT6351_PMIC_MIX_RTC_STP_K_EOSC32_EN_MASK, MT6351_PMIC_MIX_RTC_STP_K_EOSC32_EN_SHIFT},
	{PMIC_MIX_RTC_STP_EMBCK_SEL, MT6351_PMIC_MIX_RTC_STP_EMBCK_SEL_ADDR,
	 MT6351_PMIC_MIX_RTC_STP_EMBCK_SEL_MASK, MT6351_PMIC_MIX_RTC_STP_EMBCK_SEL_SHIFT},
	{PMIC_MIX_STP_BBWAKEUP, MT6351_PMIC_MIX_STP_BBWAKEUP_ADDR,
	 MT6351_PMIC_MIX_STP_BBWAKEUP_MASK, MT6351_PMIC_MIX_STP_BBWAKEUP_SHIFT},
	{PMIC_MIX_STP_RTC_DDLO, MT6351_PMIC_MIX_STP_RTC_DDLO_ADDR,
	 MT6351_PMIC_MIX_STP_RTC_DDLO_MASK, MT6351_PMIC_MIX_STP_RTC_DDLO_SHIFT},
	{PMIC_MIX_RTC_XOSC32_ENB, MT6351_PMIC_MIX_RTC_XOSC32_ENB_ADDR,
	 MT6351_PMIC_MIX_RTC_XOSC32_ENB_MASK, MT6351_PMIC_MIX_RTC_XOSC32_ENB_SHIFT},
	{PMIC_MIX_EFUSE_XOSC32_ENB_OPT, MT6351_PMIC_MIX_EFUSE_XOSC32_ENB_OPT_ADDR,
	 MT6351_PMIC_MIX_EFUSE_XOSC32_ENB_OPT_MASK, MT6351_PMIC_MIX_EFUSE_XOSC32_ENB_OPT_SHIFT},
	{PMIC_FG_ON, MT6351_PMIC_FG_ON_ADDR, MT6351_PMIC_FG_ON_MASK,
	 MT6351_PMIC_FG_ON_SHIFT},
	{PMIC_FG_CAL, MT6351_PMIC_FG_CAL_ADDR, MT6351_PMIC_FG_CAL_MASK,
	 MT6351_PMIC_FG_CAL_SHIFT},
	{PMIC_FG_AUTOCALRATE, MT6351_PMIC_FG_AUTOCALRATE_ADDR,
	 MT6351_PMIC_FG_AUTOCALRATE_MASK, MT6351_PMIC_FG_AUTOCALRATE_SHIFT},
	{PMIC_FG_SW_CR, MT6351_PMIC_FG_SW_CR_ADDR, MT6351_PMIC_FG_SW_CR_MASK,
	 MT6351_PMIC_FG_SW_CR_SHIFT},
	{PMIC_FG_SW_READ_PRE, MT6351_PMIC_FG_SW_READ_PRE_ADDR,
	 MT6351_PMIC_FG_SW_READ_PRE_MASK, MT6351_PMIC_FG_SW_READ_PRE_SHIFT},
	{PMIC_FG_LATCHDATA_ST, MT6351_PMIC_FG_LATCHDATA_ST_ADDR,
	 MT6351_PMIC_FG_LATCHDATA_ST_MASK, MT6351_PMIC_FG_LATCHDATA_ST_SHIFT},
	{PMIC_FG_SW_CLEAR, MT6351_PMIC_FG_SW_CLEAR_ADDR, MT6351_PMIC_FG_SW_CLEAR_MASK,
	 MT6351_PMIC_FG_SW_CLEAR_SHIFT},
	{PMIC_FG_OFFSET_RST, MT6351_PMIC_FG_OFFSET_RST_ADDR,
	 MT6351_PMIC_FG_OFFSET_RST_MASK, MT6351_PMIC_FG_OFFSET_RST_SHIFT},
	{PMIC_FG_TIME_RST, MT6351_PMIC_FG_TIME_RST_ADDR, MT6351_PMIC_FG_TIME_RST_MASK,
	 MT6351_PMIC_FG_TIME_RST_SHIFT},
	{PMIC_FG_CHARGE_RST, MT6351_PMIC_FG_CHARGE_RST_ADDR,
	 MT6351_PMIC_FG_CHARGE_RST_MASK, MT6351_PMIC_FG_CHARGE_RST_SHIFT},
	{PMIC_FG_SW_RSTCLR, MT6351_PMIC_FG_SW_RSTCLR_ADDR, MT6351_PMIC_FG_SW_RSTCLR_MASK,
	 MT6351_PMIC_FG_SW_RSTCLR_SHIFT},
	{PMIC_FG_CAR_34_19, MT6351_PMIC_FG_CAR_34_19_ADDR, MT6351_PMIC_FG_CAR_34_19_MASK,
	 MT6351_PMIC_FG_CAR_34_19_SHIFT},
	{PMIC_FG_CAR_18_03, MT6351_PMIC_FG_CAR_18_03_ADDR, MT6351_PMIC_FG_CAR_18_03_MASK,
	 MT6351_PMIC_FG_CAR_18_03_SHIFT},
	{PMIC_FG_CAR_02_00, MT6351_PMIC_FG_CAR_02_00_ADDR, MT6351_PMIC_FG_CAR_02_00_MASK,
	 MT6351_PMIC_FG_CAR_02_00_SHIFT},
	{PMIC_FG_NTER_32_17, MT6351_PMIC_FG_NTER_32_17_ADDR,
	 MT6351_PMIC_FG_NTER_32_17_MASK, MT6351_PMIC_FG_NTER_32_17_SHIFT},
	{PMIC_FG_NTER_16_01, MT6351_PMIC_FG_NTER_16_01_ADDR,
	 MT6351_PMIC_FG_NTER_16_01_MASK, MT6351_PMIC_FG_NTER_16_01_SHIFT},
	{PMIC_FG_NTER_00, MT6351_PMIC_FG_NTER_00_ADDR, MT6351_PMIC_FG_NTER_00_MASK,
	 MT6351_PMIC_FG_NTER_00_SHIFT},
	{PMIC_FG_BLTR_31_16, MT6351_PMIC_FG_BLTR_31_16_ADDR,
	 MT6351_PMIC_FG_BLTR_31_16_MASK, MT6351_PMIC_FG_BLTR_31_16_SHIFT},
	{PMIC_FG_BLTR_15_00, MT6351_PMIC_FG_BLTR_15_00_ADDR,
	 MT6351_PMIC_FG_BLTR_15_00_MASK, MT6351_PMIC_FG_BLTR_15_00_SHIFT},
	{PMIC_FG_BFTR_31_16, MT6351_PMIC_FG_BFTR_31_16_ADDR,
	 MT6351_PMIC_FG_BFTR_31_16_MASK, MT6351_PMIC_FG_BFTR_31_16_SHIFT},
	{PMIC_FG_BFTR_15_00, MT6351_PMIC_FG_BFTR_15_00_ADDR,
	 MT6351_PMIC_FG_BFTR_15_00_MASK, MT6351_PMIC_FG_BFTR_15_00_SHIFT},
	{PMIC_FG_CURRENT_OUT, MT6351_PMIC_FG_CURRENT_OUT_ADDR,
	 MT6351_PMIC_FG_CURRENT_OUT_MASK, MT6351_PMIC_FG_CURRENT_OUT_SHIFT},
	{PMIC_FG_ADJUST_OFFSET_VALUE, MT6351_PMIC_FG_ADJUST_OFFSET_VALUE_ADDR,
	 MT6351_PMIC_FG_ADJUST_OFFSET_VALUE_MASK, MT6351_PMIC_FG_ADJUST_OFFSET_VALUE_SHIFT},
	{PMIC_FG_OFFSET, MT6351_PMIC_FG_OFFSET_ADDR, MT6351_PMIC_FG_OFFSET_MASK,
	 MT6351_PMIC_FG_OFFSET_SHIFT},
	{PMIC_RG_FGANALOGTEST, MT6351_PMIC_RG_FGANALOGTEST_ADDR,
	 MT6351_PMIC_RG_FGANALOGTEST_MASK, MT6351_PMIC_RG_FGANALOGTEST_SHIFT},
	{PMIC_RG_FGRINTMODE, MT6351_PMIC_RG_FGRINTMODE_ADDR,
	 MT6351_PMIC_RG_FGRINTMODE_MASK, MT6351_PMIC_RG_FGRINTMODE_SHIFT},
	{PMIC_RG_SPARE, MT6351_PMIC_RG_SPARE_ADDR, MT6351_PMIC_RG_SPARE_MASK,
	 MT6351_PMIC_RG_SPARE_SHIFT},
	{PMIC_FG_OSR, MT6351_PMIC_FG_OSR_ADDR, MT6351_PMIC_FG_OSR_MASK,
	 MT6351_PMIC_FG_OSR_SHIFT},
	{PMIC_FG_ADJ_OFFSET_EN, MT6351_PMIC_FG_ADJ_OFFSET_EN_ADDR,
	 MT6351_PMIC_FG_ADJ_OFFSET_EN_MASK, MT6351_PMIC_FG_ADJ_OFFSET_EN_SHIFT},
	{PMIC_FG_ADC_AUTORST, MT6351_PMIC_FG_ADC_AUTORST_ADDR,
	 MT6351_PMIC_FG_ADC_AUTORST_MASK, MT6351_PMIC_FG_ADC_AUTORST_SHIFT},
	{PMIC_FG_FIR1BYPASS, MT6351_PMIC_FG_FIR1BYPASS_ADDR,
	 MT6351_PMIC_FG_FIR1BYPASS_MASK, MT6351_PMIC_FG_FIR1BYPASS_SHIFT},
	{PMIC_FG_FIR2BYPASS, MT6351_PMIC_FG_FIR2BYPASS_ADDR,
	 MT6351_PMIC_FG_FIR2BYPASS_MASK, MT6351_PMIC_FG_FIR2BYPASS_SHIFT},
	{PMIC_FG_L_CUR_INT_STS, MT6351_PMIC_FG_L_CUR_INT_STS_ADDR,
	 MT6351_PMIC_FG_L_CUR_INT_STS_MASK, MT6351_PMIC_FG_L_CUR_INT_STS_SHIFT},
	{PMIC_FG_H_CUR_INT_STS, MT6351_PMIC_FG_H_CUR_INT_STS_ADDR,
	 MT6351_PMIC_FG_H_CUR_INT_STS_MASK, MT6351_PMIC_FG_H_CUR_INT_STS_SHIFT},
	{PMIC_FG_L_INT_STS, MT6351_PMIC_FG_L_INT_STS_ADDR, MT6351_PMIC_FG_L_INT_STS_MASK,
	 MT6351_PMIC_FG_L_INT_STS_SHIFT},
	{PMIC_FG_H_INT_STS, MT6351_PMIC_FG_H_INT_STS_ADDR, MT6351_PMIC_FG_H_INT_STS_MASK,
	 MT6351_PMIC_FG_H_INT_STS_SHIFT},
	{PMIC_FG_ADC_RSTDETECT, MT6351_PMIC_FG_ADC_RSTDETECT_ADDR,
	 MT6351_PMIC_FG_ADC_RSTDETECT_MASK, MT6351_PMIC_FG_ADC_RSTDETECT_SHIFT},
	{PMIC_FG_SLP_EN, MT6351_PMIC_FG_SLP_EN_ADDR, MT6351_PMIC_FG_SLP_EN_MASK,
	 MT6351_PMIC_FG_SLP_EN_SHIFT},
	{PMIC_FG_ZCV_DET_EN, MT6351_PMIC_FG_ZCV_DET_EN_ADDR,
	 MT6351_PMIC_FG_ZCV_DET_EN_MASK, MT6351_PMIC_FG_ZCV_DET_EN_SHIFT},
	{PMIC_RG_FG_AUXADC_R, MT6351_PMIC_RG_FG_AUXADC_R_ADDR,
	 MT6351_PMIC_RG_FG_AUXADC_R_MASK, MT6351_PMIC_RG_FG_AUXADC_R_SHIFT},
	{PMIC_DA_FGADC_EN, MT6351_PMIC_DA_FGADC_EN_ADDR, MT6351_PMIC_DA_FGADC_EN_MASK,
	 MT6351_PMIC_DA_FGADC_EN_SHIFT},
	{PMIC_DA_FGCAL_EN, MT6351_PMIC_DA_FGCAL_EN_ADDR, MT6351_PMIC_DA_FGCAL_EN_MASK,
	 MT6351_PMIC_DA_FGCAL_EN_SHIFT},
	{PMIC_DA_FG_RST, MT6351_PMIC_DA_FG_RST_ADDR, MT6351_PMIC_DA_FG_RST_MASK,
	 MT6351_PMIC_DA_FG_RST_SHIFT},
	{PMIC_FG_CIC2, MT6351_PMIC_FG_CIC2_ADDR, MT6351_PMIC_FG_CIC2_MASK,
	 MT6351_PMIC_FG_CIC2_SHIFT},
	{PMIC_FG_SLP_CUR_TH, MT6351_PMIC_FG_SLP_CUR_TH_ADDR,
	 MT6351_PMIC_FG_SLP_CUR_TH_MASK, MT6351_PMIC_FG_SLP_CUR_TH_SHIFT},
	{PMIC_FG_SLP_TIME, MT6351_PMIC_FG_SLP_TIME_ADDR, MT6351_PMIC_FG_SLP_TIME_MASK,
	 MT6351_PMIC_FG_SLP_TIME_SHIFT},
	{PMIC_FG_SRCVOLTEN_FTIME, MT6351_PMIC_FG_SRCVOLTEN_FTIME_ADDR,
	 MT6351_PMIC_FG_SRCVOLTEN_FTIME_MASK, MT6351_PMIC_FG_SRCVOLTEN_FTIME_SHIFT},
	{PMIC_FG_DET_TIME, MT6351_PMIC_FG_DET_TIME_ADDR, MT6351_PMIC_FG_DET_TIME_MASK,
	 MT6351_PMIC_FG_DET_TIME_SHIFT},
	{PMIC_FG_ZCV_CAR_34_19, MT6351_PMIC_FG_ZCV_CAR_34_19_ADDR,
	 MT6351_PMIC_FG_ZCV_CAR_34_19_MASK, MT6351_PMIC_FG_ZCV_CAR_34_19_SHIFT},
	{PMIC_FG_ZCV_CAR_18_03, MT6351_PMIC_FG_ZCV_CAR_18_03_ADDR,
	 MT6351_PMIC_FG_ZCV_CAR_18_03_MASK, MT6351_PMIC_FG_ZCV_CAR_18_03_SHIFT},
	{PMIC_FG_ZCV_CAR_02_00, MT6351_PMIC_FG_ZCV_CAR_02_00_ADDR,
	 MT6351_PMIC_FG_ZCV_CAR_02_00_MASK, MT6351_PMIC_FG_ZCV_CAR_02_00_SHIFT},
	{PMIC_FG_ZCV_CURR, MT6351_PMIC_FG_ZCV_CURR_ADDR, MT6351_PMIC_FG_ZCV_CURR_MASK,
	 MT6351_PMIC_FG_ZCV_CURR_SHIFT},
	{PMIC_FG_R_CURR, MT6351_PMIC_FG_R_CURR_ADDR, MT6351_PMIC_FG_R_CURR_MASK,
	 MT6351_PMIC_FG_R_CURR_SHIFT},
	{PMIC_FG_MODE, MT6351_PMIC_FG_MODE_ADDR, MT6351_PMIC_FG_MODE_MASK,
	 MT6351_PMIC_FG_MODE_SHIFT},
	{PMIC_FG_RST_SW, MT6351_PMIC_FG_RST_SW_ADDR, MT6351_PMIC_FG_RST_SW_MASK,
	 MT6351_PMIC_FG_RST_SW_SHIFT},
	{PMIC_FG_FGCAL_EN_SW, MT6351_PMIC_FG_FGCAL_EN_SW_ADDR,
	 MT6351_PMIC_FG_FGCAL_EN_SW_MASK, MT6351_PMIC_FG_FGCAL_EN_SW_SHIFT},
	{PMIC_FG_FGADC_EN_SW, MT6351_PMIC_FG_FGADC_EN_SW_ADDR,
	 MT6351_PMIC_FG_FGADC_EN_SW_MASK, MT6351_PMIC_FG_FGADC_EN_SW_SHIFT},
	{PMIC_FG_RSV1, MT6351_PMIC_FG_RSV1_ADDR, MT6351_PMIC_FG_RSV1_MASK,
	 MT6351_PMIC_FG_RSV1_SHIFT},
	{PMIC_FG_TEST_MODE0, MT6351_PMIC_FG_TEST_MODE0_ADDR,
	 MT6351_PMIC_FG_TEST_MODE0_MASK, MT6351_PMIC_FG_TEST_MODE0_SHIFT},
	{PMIC_FG_TEST_MODE1, MT6351_PMIC_FG_TEST_MODE1_ADDR,
	 MT6351_PMIC_FG_TEST_MODE1_MASK, MT6351_PMIC_FG_TEST_MODE1_SHIFT},
	{PMIC_FG_GAIN, MT6351_PMIC_FG_GAIN_ADDR, MT6351_PMIC_FG_GAIN_MASK,
	 MT6351_PMIC_FG_GAIN_SHIFT},
	{PMIC_FG_CUR_HTH, MT6351_PMIC_FG_CUR_HTH_ADDR, MT6351_PMIC_FG_CUR_HTH_MASK,
	 MT6351_PMIC_FG_CUR_HTH_SHIFT},
	{PMIC_FG_CUR_LTH, MT6351_PMIC_FG_CUR_LTH_ADDR, MT6351_PMIC_FG_CUR_LTH_MASK,
	 MT6351_PMIC_FG_CUR_LTH_SHIFT},
	{PMIC_FG_ZCV_DET_TIME, MT6351_PMIC_FG_ZCV_DET_TIME_ADDR,
	 MT6351_PMIC_FG_ZCV_DET_TIME_MASK, MT6351_PMIC_FG_ZCV_DET_TIME_SHIFT},
	{PMIC_FG_ZCV_CAR_TH_33_19, MT6351_PMIC_FG_ZCV_CAR_TH_33_19_ADDR,
	 MT6351_PMIC_FG_ZCV_CAR_TH_33_19_MASK, MT6351_PMIC_FG_ZCV_CAR_TH_33_19_SHIFT},
	{PMIC_FG_ZCV_CAR_TH_18_03, MT6351_PMIC_FG_ZCV_CAR_TH_18_03_ADDR,
	 MT6351_PMIC_FG_ZCV_CAR_TH_18_03_MASK, MT6351_PMIC_FG_ZCV_CAR_TH_18_03_SHIFT},
	{PMIC_FG_ZCV_CAR_TH_02_00, MT6351_PMIC_FG_ZCV_CAR_TH_02_00_ADDR,
	 MT6351_PMIC_FG_ZCV_CAR_TH_02_00_MASK, MT6351_PMIC_FG_ZCV_CAR_TH_02_00_SHIFT},
	{PMIC_SYSTEM_INFO_CON0, MT6351_PMIC_SYSTEM_INFO_CON0_ADDR,
	 MT6351_PMIC_SYSTEM_INFO_CON0_MASK, MT6351_PMIC_SYSTEM_INFO_CON0_SHIFT},
	{PMIC_SYSTEM_INFO_CON1, MT6351_PMIC_SYSTEM_INFO_CON1_ADDR,
	 MT6351_PMIC_SYSTEM_INFO_CON1_MASK, MT6351_PMIC_SYSTEM_INFO_CON1_SHIFT},
	{PMIC_SYSTEM_INFO_CON2, MT6351_PMIC_SYSTEM_INFO_CON2_ADDR,
	 MT6351_PMIC_SYSTEM_INFO_CON2_MASK, MT6351_PMIC_SYSTEM_INFO_CON2_SHIFT},
	{PMIC_SYSTEM_INFO_CON3, MT6351_PMIC_SYSTEM_INFO_CON3_ADDR,
	 MT6351_PMIC_SYSTEM_INFO_CON3_MASK, MT6351_PMIC_SYSTEM_INFO_CON3_SHIFT},
	{PMIC_SYSTEM_INFO_CON4, MT6351_PMIC_SYSTEM_INFO_CON4_ADDR,
	 MT6351_PMIC_SYSTEM_INFO_CON4_MASK, MT6351_PMIC_SYSTEM_INFO_CON4_SHIFT},
	{PMIC_RG_AUDDACLPWRUP_VAUDP32, MT6351_PMIC_RG_AUDDACLPWRUP_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDDACLPWRUP_VAUDP32_MASK, MT6351_PMIC_RG_AUDDACLPWRUP_VAUDP32_SHIFT},
	{PMIC_RG_AUDDACRPWRUP_VAUDP32, MT6351_PMIC_RG_AUDDACRPWRUP_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDDACRPWRUP_VAUDP32_MASK, MT6351_PMIC_RG_AUDDACRPWRUP_VAUDP32_SHIFT},
	{PMIC_RG_AUD_DAC_PWR_UP_VA32, MT6351_PMIC_RG_AUD_DAC_PWR_UP_VA32_ADDR,
	 MT6351_PMIC_RG_AUD_DAC_PWR_UP_VA32_MASK, MT6351_PMIC_RG_AUD_DAC_PWR_UP_VA32_SHIFT},
	{PMIC_RG_AUD_DAC_PWL_UP_VA32, MT6351_PMIC_RG_AUD_DAC_PWL_UP_VA32_ADDR,
	 MT6351_PMIC_RG_AUD_DAC_PWL_UP_VA32_MASK, MT6351_PMIC_RG_AUD_DAC_PWL_UP_VA32_SHIFT},
	{PMIC_RG_AUDHSPWRUP_VAUDP32, MT6351_PMIC_RG_AUDHSPWRUP_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHSPWRUP_VAUDP32_MASK, MT6351_PMIC_RG_AUDHSPWRUP_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPLPWRUP_VAUDP32, MT6351_PMIC_RG_AUDHPLPWRUP_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPLPWRUP_VAUDP32_MASK, MT6351_PMIC_RG_AUDHPLPWRUP_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPRPWRUP_VAUDP32, MT6351_PMIC_RG_AUDHPRPWRUP_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPRPWRUP_VAUDP32_MASK, MT6351_PMIC_RG_AUDHPRPWRUP_VAUDP32_SHIFT},
	{PMIC_RG_AUDHSMUXINPUTSEL_VAUDP32, MT6351_PMIC_RG_AUDHSMUXINPUTSEL_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHSMUXINPUTSEL_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDHSMUXINPUTSEL_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP32, MT6351_PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP32, MT6351_PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP32_SHIFT},
	{PMIC_RG_AUDHSSCDISABLE_VAUDP32, MT6351_PMIC_RG_AUDHSSCDISABLE_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHSSCDISABLE_VAUDP32_MASK, MT6351_PMIC_RG_AUDHSSCDISABLE_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPLSCDISABLE_VAUDP32, MT6351_PMIC_RG_AUDHPLSCDISABLE_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPLSCDISABLE_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDHPLSCDISABLE_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPRSCDISABLE_VAUDP32, MT6351_PMIC_RG_AUDHPRSCDISABLE_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPRSCDISABLE_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDHPRSCDISABLE_VAUDP32_SHIFT},
	{PMIC_RG_AUDHSBSCCURRENT_VAUDP32, MT6351_PMIC_RG_AUDHSBSCCURRENT_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHSBSCCURRENT_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDHSBSCCURRENT_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPLBSCCURRENT_VAUDP32, MT6351_PMIC_RG_AUDHPLBSCCURRENT_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPLBSCCURRENT_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDHPLBSCCURRENT_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPRBSCCURRENT_VAUDP32, MT6351_PMIC_RG_AUDHPRBSCCURRENT_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPRBSCCURRENT_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDHPRBSCCURRENT_VAUDP32_SHIFT},
	{PMIC_RG_AUDHSSTARTUP_VAUDP32, MT6351_PMIC_RG_AUDHSSTARTUP_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHSSTARTUP_VAUDP32_MASK, MT6351_PMIC_RG_AUDHSSTARTUP_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPSTARTUP_VAUDP32, MT6351_PMIC_RG_AUDHPSTARTUP_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPSTARTUP_VAUDP32_MASK, MT6351_PMIC_RG_AUDHPSTARTUP_VAUDP32_SHIFT},
	{PMIC_RG_AUDBGBON_VAUDP32, MT6351_PMIC_RG_AUDBGBON_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDBGBON_VAUDP32_MASK, MT6351_PMIC_RG_AUDBGBON_VAUDP32_SHIFT},
	{PMIC_RG_PRECHARGEBUF_EN_VAUDP32, MT6351_PMIC_RG_PRECHARGEBUF_EN_VAUDP32_ADDR,
	 MT6351_PMIC_RG_PRECHARGEBUF_EN_VAUDP32_MASK,
	 MT6351_PMIC_RG_PRECHARGEBUF_EN_VAUDP32_SHIFT},
	{PMIC_RG_HSINPUTSTBENH_VAUDP32, MT6351_PMIC_RG_HSINPUTSTBENH_VAUDP32_ADDR,
	 MT6351_PMIC_RG_HSINPUTSTBENH_VAUDP32_MASK, MT6351_PMIC_RG_HSINPUTSTBENH_VAUDP32_SHIFT},
	{PMIC_RG_HSOUTPUTSTBENH_VAUDP32, MT6351_PMIC_RG_HSOUTPUTSTBENH_VAUDP32_ADDR,
	 MT6351_PMIC_RG_HSOUTPUTSTBENH_VAUDP32_MASK, MT6351_PMIC_RG_HSOUTPUTSTBENH_VAUDP32_SHIFT},
	{PMIC_RG_HSINPUTRESET0_VAUDP32, MT6351_PMIC_RG_HSINPUTRESET0_VAUDP32_ADDR,
	 MT6351_PMIC_RG_HSINPUTRESET0_VAUDP32_MASK, MT6351_PMIC_RG_HSINPUTRESET0_VAUDP32_SHIFT},
	{PMIC_RG_HSOUTPUTRESET0_VAUDP32, MT6351_PMIC_RG_HSOUTPUTRESET0_VAUDP32_ADDR,
	 MT6351_PMIC_RG_HSOUTPUTRESET0_VAUDP32_MASK, MT6351_PMIC_RG_HSOUTPUTRESET0_VAUDP32_SHIFT},
	{PMIC_RG_HSOUT_SHORTVCM_VAUDP32, MT6351_PMIC_RG_HSOUT_SHORTVCM_VAUDP32_ADDR,
	 MT6351_PMIC_RG_HSOUT_SHORTVCM_VAUDP32_MASK, MT6351_PMIC_RG_HSOUT_SHORTVCM_VAUDP32_SHIFT},
	{PMIC_RG_HPINPUTSTBENH_VAUDP32, MT6351_PMIC_RG_HPINPUTSTBENH_VAUDP32_ADDR,
	 MT6351_PMIC_RG_HPINPUTSTBENH_VAUDP32_MASK, MT6351_PMIC_RG_HPINPUTSTBENH_VAUDP32_SHIFT},
	{PMIC_RG_HPOUTPUTSTBENH_VAUDP32, MT6351_PMIC_RG_HPOUTPUTSTBENH_VAUDP32_ADDR,
	 MT6351_PMIC_RG_HPOUTPUTSTBENH_VAUDP32_MASK, MT6351_PMIC_RG_HPOUTPUTSTBENH_VAUDP32_SHIFT},
	{PMIC_RG_HPINPUTRESET0_VAUDP32, MT6351_PMIC_RG_HPINPUTRESET0_VAUDP32_ADDR,
	 MT6351_PMIC_RG_HPINPUTRESET0_VAUDP32_MASK, MT6351_PMIC_RG_HPINPUTRESET0_VAUDP32_SHIFT},
	{PMIC_RG_HPOUTPUTRESET0_VAUDP32, MT6351_PMIC_RG_HPOUTPUTRESET0_VAUDP32_ADDR,
	 MT6351_PMIC_RG_HPOUTPUTRESET0_VAUDP32_MASK, MT6351_PMIC_RG_HPOUTPUTRESET0_VAUDP32_SHIFT},
	{PMIC_RG_HPOUT_SHORTVCM_VAUDP32, MT6351_PMIC_RG_HPOUT_SHORTVCM_VAUDP32_ADDR,
	 MT6351_PMIC_RG_HPOUT_SHORTVCM_VAUDP32_MASK, MT6351_PMIC_RG_HPOUT_SHORTVCM_VAUDP32_SHIFT},
	{PMIC_RG_HPOUTSTB_RSEL_VAUDP32, MT6351_PMIC_RG_HPOUTSTB_RSEL_VAUDP32_ADDR,
	 MT6351_PMIC_RG_HPOUTSTB_RSEL_VAUDP32_MASK, MT6351_PMIC_RG_HPOUTSTB_RSEL_VAUDP32_SHIFT},
	{PMIC_RG_LINENOISEENH_VAUDP32, MT6351_PMIC_RG_LINENOISEENH_VAUDP32_ADDR,
	 MT6351_PMIC_RG_LINENOISEENH_VAUDP32_MASK, MT6351_PMIC_RG_LINENOISEENH_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPLTRIM_VAUDP32, MT6351_PMIC_RG_AUDHPLTRIM_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPLTRIM_VAUDP32_MASK, MT6351_PMIC_RG_AUDHPLTRIM_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPRTRIM_VAUDP32, MT6351_PMIC_RG_AUDHPRTRIM_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPRTRIM_VAUDP32_MASK, MT6351_PMIC_RG_AUDHPRTRIM_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPTRIM_EN_VAUDP32, MT6351_PMIC_RG_AUDHPTRIM_EN_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPTRIM_EN_VAUDP32_MASK, MT6351_PMIC_RG_AUDHPTRIM_EN_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPLFINETRIM_VAUDP32, MT6351_PMIC_RG_AUDHPLFINETRIM_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPLFINETRIM_VAUDP32_MASK, MT6351_PMIC_RG_AUDHPLFINETRIM_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPRFINETRIM_VAUDP32, MT6351_PMIC_RG_AUDHPRFINETRIM_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPRFINETRIM_VAUDP32_MASK, MT6351_PMIC_RG_AUDHPRFINETRIM_VAUDP32_SHIFT},
	{PMIC_RG_AUDLOLPWRUP_VAUDP32, MT6351_PMIC_RG_AUDLOLPWRUP_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDLOLPWRUP_VAUDP32_MASK, MT6351_PMIC_RG_AUDLOLPWRUP_VAUDP32_SHIFT},
	{PMIC_RG_AUDLOLMUXINPUTSEL_VAUDP32, MT6351_PMIC_RG_AUDLOLMUXINPUTSEL_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDLOLMUXINPUTSEL_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDLOLMUXINPUTSEL_VAUDP32_SHIFT},
	{PMIC_RG_AUDLOLSCDISABLE_VAUDP32, MT6351_PMIC_RG_AUDLOLSCDISABLE_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDLOLSCDISABLE_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDLOLSCDISABLE_VAUDP32_SHIFT},
	{PMIC_RG_AUDLOLBSCCURRENT_VAUDP32, MT6351_PMIC_RG_AUDLOLBSCCURRENT_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDLOLBSCCURRENT_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDLOLBSCCURRENT_VAUDP32_SHIFT},
	{PMIC_RG_AUDLOSTARTUP_VAUDP32, MT6351_PMIC_RG_AUDLOSTARTUP_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDLOSTARTUP_VAUDP32_MASK, MT6351_PMIC_RG_AUDLOSTARTUP_VAUDP32_SHIFT},
	{PMIC_RG_LOINPUTSTBENH_VAUDP32, MT6351_PMIC_RG_LOINPUTSTBENH_VAUDP32_ADDR,
	 MT6351_PMIC_RG_LOINPUTSTBENH_VAUDP32_MASK, MT6351_PMIC_RG_LOINPUTSTBENH_VAUDP32_SHIFT},
	{PMIC_RG_LOOUTPUTSTBENH_VAUDP32, MT6351_PMIC_RG_LOOUTPUTSTBENH_VAUDP32_ADDR,
	 MT6351_PMIC_RG_LOOUTPUTSTBENH_VAUDP32_MASK, MT6351_PMIC_RG_LOOUTPUTSTBENH_VAUDP32_SHIFT},
	{PMIC_RG_LOINPUTRESET0_VAUDP32, MT6351_PMIC_RG_LOINPUTRESET0_VAUDP32_ADDR,
	 MT6351_PMIC_RG_LOINPUTRESET0_VAUDP32_MASK, MT6351_PMIC_RG_LOINPUTRESET0_VAUDP32_SHIFT},
	{PMIC_RG_LOOUTPUTRESET0_VAUDP32, MT6351_PMIC_RG_LOOUTPUTRESET0_VAUDP32_ADDR,
	 MT6351_PMIC_RG_LOOUTPUTRESET0_VAUDP32_MASK, MT6351_PMIC_RG_LOOUTPUTRESET0_VAUDP32_SHIFT},
	{PMIC_RG_LOOUT_SHORTVCM_VAUDP32, MT6351_PMIC_RG_LOOUT_SHORTVCM_VAUDP32_ADDR,
	 MT6351_PMIC_RG_LOOUT_SHORTVCM_VAUDP32_MASK, MT6351_PMIC_RG_LOOUT_SHORTVCM_VAUDP32_SHIFT},
	{PMIC_RG_LOOUTSTB_RSEL_VAUDP32, MT6351_PMIC_RG_LOOUTSTB_RSEL_VAUDP32_ADDR,
	 MT6351_PMIC_RG_LOOUTSTB_RSEL_VAUDP32_MASK, MT6351_PMIC_RG_LOOUTSTB_RSEL_VAUDP32_SHIFT},
	{PMIC_RG_AUDLOLTRIM_VAUDP32, MT6351_PMIC_RG_AUDLOLTRIM_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDLOLTRIM_VAUDP32_MASK, MT6351_PMIC_RG_AUDLOLTRIM_VAUDP32_SHIFT},
	{PMIC_RG_AUDLOTRIM_EN_VAUDP32, MT6351_PMIC_RG_AUDLOTRIM_EN_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDLOTRIM_EN_VAUDP32_MASK, MT6351_PMIC_RG_AUDLOTRIM_EN_VAUDP32_SHIFT},
	{PMIC_RG_AUDLOLFINETRIM_VAUDP32, MT6351_PMIC_RG_AUDLOLFINETRIM_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDLOLFINETRIM_VAUDP32_MASK, MT6351_PMIC_RG_AUDLOLFINETRIM_VAUDP32_SHIFT},
	{PMIC_RG_AUDTRIMBUF_EN_VAUDP32, MT6351_PMIC_RG_AUDTRIMBUF_EN_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDTRIMBUF_EN_VAUDP32_MASK, MT6351_PMIC_RG_AUDTRIMBUF_EN_VAUDP32_SHIFT},
	{PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP32,
	 MT6351_PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP32_SHIFT},
	{PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP32,
	 MT6351_PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPSPKDET_EN_VAUDP32, MT6351_PMIC_RG_AUDHPSPKDET_EN_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPSPKDET_EN_VAUDP32_MASK, MT6351_PMIC_RG_AUDHPSPKDET_EN_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP32,
	 MT6351_PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP32_SHIFT},
	{PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP32,
	 MT6351_PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP32_MASK,
	 MT6351_PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP32_SHIFT},
	{PMIC_RG_ABIDEC_RSVD0_VA32, MT6351_PMIC_RG_ABIDEC_RSVD0_VA32_ADDR,
	 MT6351_PMIC_RG_ABIDEC_RSVD0_VA32_MASK, MT6351_PMIC_RG_ABIDEC_RSVD0_VA32_SHIFT},
	{PMIC_RG_ABIDEC_RSVD1_VA32, MT6351_PMIC_RG_ABIDEC_RSVD1_VA32_ADDR,
	 MT6351_PMIC_RG_ABIDEC_RSVD1_VA32_MASK, MT6351_PMIC_RG_ABIDEC_RSVD1_VA32_SHIFT},
	{PMIC_RG_ABIDEC_RSVD0_VAUDP32, MT6351_PMIC_RG_ABIDEC_RSVD0_VAUDP32_ADDR,
	 MT6351_PMIC_RG_ABIDEC_RSVD0_VAUDP32_MASK, MT6351_PMIC_RG_ABIDEC_RSVD0_VAUDP32_SHIFT},
	{PMIC_RG_ABIDEC_RSVD1_VAUDP32, MT6351_PMIC_RG_ABIDEC_RSVD1_VAUDP32_ADDR,
	 MT6351_PMIC_RG_ABIDEC_RSVD1_VAUDP32_MASK, MT6351_PMIC_RG_ABIDEC_RSVD1_VAUDP32_SHIFT},
	{PMIC_RG_AUDZCDMUXSEL_VAUDP32, MT6351_PMIC_RG_AUDZCDMUXSEL_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDZCDMUXSEL_VAUDP32_MASK, MT6351_PMIC_RG_AUDZCDMUXSEL_VAUDP32_SHIFT},
	{PMIC_RG_AUDZCDCLKSEL_VAUDP32, MT6351_PMIC_RG_AUDZCDCLKSEL_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDZCDCLKSEL_VAUDP32_MASK, MT6351_PMIC_RG_AUDZCDCLKSEL_VAUDP32_SHIFT},
	{PMIC_RG_AUDBIASADJ_0_VAUDP32, MT6351_PMIC_RG_AUDBIASADJ_0_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDBIASADJ_0_VAUDP32_MASK, MT6351_PMIC_RG_AUDBIASADJ_0_VAUDP32_SHIFT},
	{PMIC_RG_AUDBIASADJ_1_VAUDP32, MT6351_PMIC_RG_AUDBIASADJ_1_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDBIASADJ_1_VAUDP32_MASK, MT6351_PMIC_RG_AUDBIASADJ_1_VAUDP32_SHIFT},
	{PMIC_RG_AUDIBIASPWRDN_VAUDP32, MT6351_PMIC_RG_AUDIBIASPWRDN_VAUDP32_ADDR,
	 MT6351_PMIC_RG_AUDIBIASPWRDN_VAUDP32_MASK, MT6351_PMIC_RG_AUDIBIASPWRDN_VAUDP32_SHIFT},
	{PMIC_RG_RSTB_DECODER_VA32, MT6351_PMIC_RG_RSTB_DECODER_VA32_ADDR,
	 MT6351_PMIC_RG_RSTB_DECODER_VA32_MASK, MT6351_PMIC_RG_RSTB_DECODER_VA32_SHIFT},
	{PMIC_RG_SEL_DECODER_96K_VA32, MT6351_PMIC_RG_SEL_DECODER_96K_VA32_ADDR,
	 MT6351_PMIC_RG_SEL_DECODER_96K_VA32_MASK, MT6351_PMIC_RG_SEL_DECODER_96K_VA32_SHIFT},
	{PMIC_RG_SEL_DELAY_VCORE, MT6351_PMIC_RG_SEL_DELAY_VCORE_ADDR,
	 MT6351_PMIC_RG_SEL_DELAY_VCORE_MASK, MT6351_PMIC_RG_SEL_DELAY_VCORE_SHIFT},
	{PMIC_RG_AUDGLB_PWRDN_VA32, MT6351_PMIC_RG_AUDGLB_PWRDN_VA32_ADDR,
	 MT6351_PMIC_RG_AUDGLB_PWRDN_VA32_MASK, MT6351_PMIC_RG_AUDGLB_PWRDN_VA32_SHIFT},
	{PMIC_RG_LCLDO_DEC_EN_VA32, MT6351_PMIC_RG_LCLDO_DEC_EN_VA32_ADDR,
	 MT6351_PMIC_RG_LCLDO_DEC_EN_VA32_MASK, MT6351_PMIC_RG_LCLDO_DEC_EN_VA32_SHIFT},
	{PMIC_RG_LCLDO_DEC_PDDIS_EN_VA18, MT6351_PMIC_RG_LCLDO_DEC_PDDIS_EN_VA18_ADDR,
	 MT6351_PMIC_RG_LCLDO_DEC_PDDIS_EN_VA18_MASK,
	 MT6351_PMIC_RG_LCLDO_DEC_PDDIS_EN_VA18_SHIFT},
	{PMIC_RG_LCLDO_DEC_REMOTE_SENSE_VA18,
	 MT6351_PMIC_RG_LCLDO_DEC_REMOTE_SENSE_VA18_ADDR,
	 MT6351_PMIC_RG_LCLDO_DEC_REMOTE_SENSE_VA18_MASK,
	 MT6351_PMIC_RG_LCLDO_DEC_REMOTE_SENSE_VA18_SHIFT},
	{PMIC_RG_AUDPMU_RSVD_VA18, MT6351_PMIC_RG_AUDPMU_RSVD_VA18_ADDR,
	 MT6351_PMIC_RG_AUDPMU_RSVD_VA18_MASK, MT6351_PMIC_RG_AUDPMU_RSVD_VA18_SHIFT},
	{PMIC_RG_NVREG_EN_VAUDP32, MT6351_PMIC_RG_NVREG_EN_VAUDP32_ADDR,
	 MT6351_PMIC_RG_NVREG_EN_VAUDP32_MASK, MT6351_PMIC_RG_NVREG_EN_VAUDP32_SHIFT},
	{PMIC_RG_NVREG_PULL0V_VAUDP32, MT6351_PMIC_RG_NVREG_PULL0V_VAUDP32_ADDR,
	 MT6351_PMIC_RG_NVREG_PULL0V_VAUDP32_MASK, MT6351_PMIC_RG_NVREG_PULL0V_VAUDP32_SHIFT},
	{PMIC_RG_AUDGLB_LP2_VOW_EN_VA32, MT6351_PMIC_RG_AUDGLB_LP2_VOW_EN_VA32_ADDR,
	 MT6351_PMIC_RG_AUDGLB_LP2_VOW_EN_VA32_MASK, MT6351_PMIC_RG_AUDGLB_LP2_VOW_EN_VA32_SHIFT},
	{PMIC_RG_AUDPREAMPLON, MT6351_PMIC_RG_AUDPREAMPLON_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPLON_MASK, MT6351_PMIC_RG_AUDPREAMPLON_SHIFT},
	{PMIC_RG_AUDPREAMPLDCCEN, MT6351_PMIC_RG_AUDPREAMPLDCCEN_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPLDCCEN_MASK, MT6351_PMIC_RG_AUDPREAMPLDCCEN_SHIFT},
	{PMIC_RG_AUDPREAMPLDCPRECHARGE, MT6351_PMIC_RG_AUDPREAMPLDCPRECHARGE_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPLDCPRECHARGE_MASK, MT6351_PMIC_RG_AUDPREAMPLDCPRECHARGE_SHIFT},
	{PMIC_RG_AUDPREAMPLPGATEST, MT6351_PMIC_RG_AUDPREAMPLPGATEST_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPLPGATEST_MASK, MT6351_PMIC_RG_AUDPREAMPLPGATEST_SHIFT},
	{PMIC_RG_AUDPREAMPLINPUTSEL, MT6351_PMIC_RG_AUDPREAMPLINPUTSEL_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPLINPUTSEL_MASK, MT6351_PMIC_RG_AUDPREAMPLINPUTSEL_SHIFT},
	{PMIC_RG_AUDPREAMPLVSCALE, MT6351_PMIC_RG_AUDPREAMPLVSCALE_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPLVSCALE_MASK, MT6351_PMIC_RG_AUDPREAMPLVSCALE_SHIFT},
	{PMIC_RG_AUDPREAMPLGAIN, MT6351_PMIC_RG_AUDPREAMPLGAIN_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPLGAIN_MASK, MT6351_PMIC_RG_AUDPREAMPLGAIN_SHIFT},
	{PMIC_RG_AUDADCLPWRUP, MT6351_PMIC_RG_AUDADCLPWRUP_ADDR,
	 MT6351_PMIC_RG_AUDADCLPWRUP_MASK, MT6351_PMIC_RG_AUDADCLPWRUP_SHIFT},
	{PMIC_RG_AUDADCLINPUTSEL, MT6351_PMIC_RG_AUDADCLINPUTSEL_ADDR,
	 MT6351_PMIC_RG_AUDADCLINPUTSEL_MASK, MT6351_PMIC_RG_AUDADCLINPUTSEL_SHIFT},
	{PMIC_RG_AUDPREAMPRON, MT6351_PMIC_RG_AUDPREAMPRON_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPRON_MASK, MT6351_PMIC_RG_AUDPREAMPRON_SHIFT},
	{PMIC_RG_AUDPREAMPRDCCEN, MT6351_PMIC_RG_AUDPREAMPRDCCEN_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPRDCCEN_MASK, MT6351_PMIC_RG_AUDPREAMPRDCCEN_SHIFT},
	{PMIC_RG_AUDPREAMPRDCPRECHARGE, MT6351_PMIC_RG_AUDPREAMPRDCPRECHARGE_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPRDCPRECHARGE_MASK, MT6351_PMIC_RG_AUDPREAMPRDCPRECHARGE_SHIFT},
	{PMIC_RG_AUDPREAMPRPGATEST, MT6351_PMIC_RG_AUDPREAMPRPGATEST_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPRPGATEST_MASK, MT6351_PMIC_RG_AUDPREAMPRPGATEST_SHIFT},
	{PMIC_RG_AUDPREAMPRINPUTSEL, MT6351_PMIC_RG_AUDPREAMPRINPUTSEL_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPRINPUTSEL_MASK, MT6351_PMIC_RG_AUDPREAMPRINPUTSEL_SHIFT},
	{PMIC_RG_AUDPREAMPRVSCALE, MT6351_PMIC_RG_AUDPREAMPRVSCALE_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPRVSCALE_MASK, MT6351_PMIC_RG_AUDPREAMPRVSCALE_SHIFT},
	{PMIC_RG_AUDPREAMPRGAIN, MT6351_PMIC_RG_AUDPREAMPRGAIN_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPRGAIN_MASK, MT6351_PMIC_RG_AUDPREAMPRGAIN_SHIFT},
	{PMIC_RG_AUDADCRPWRUP, MT6351_PMIC_RG_AUDADCRPWRUP_ADDR,
	 MT6351_PMIC_RG_AUDADCRPWRUP_MASK, MT6351_PMIC_RG_AUDADCRPWRUP_SHIFT},
	{PMIC_RG_AUDADCRINPUTSEL, MT6351_PMIC_RG_AUDADCRINPUTSEL_ADDR,
	 MT6351_PMIC_RG_AUDADCRINPUTSEL_MASK, MT6351_PMIC_RG_AUDADCRINPUTSEL_SHIFT},
	{PMIC_RG_AUDULHALFBIAS, MT6351_PMIC_RG_AUDULHALFBIAS_ADDR,
	 MT6351_PMIC_RG_AUDULHALFBIAS_MASK, MT6351_PMIC_RG_AUDULHALFBIAS_SHIFT},
	{PMIC_RG_AUDGLBVOWLPWEN, MT6351_PMIC_RG_AUDGLBVOWLPWEN_ADDR,
	 MT6351_PMIC_RG_AUDGLBVOWLPWEN_MASK, MT6351_PMIC_RG_AUDGLBVOWLPWEN_SHIFT},
	{PMIC_RG_AUDPREAMPLPEN, MT6351_PMIC_RG_AUDPREAMPLPEN_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPLPEN_MASK, MT6351_PMIC_RG_AUDPREAMPLPEN_SHIFT},
	{PMIC_RG_AUDADC1STSTAGELPEN, MT6351_PMIC_RG_AUDADC1STSTAGELPEN_ADDR,
	 MT6351_PMIC_RG_AUDADC1STSTAGELPEN_MASK, MT6351_PMIC_RG_AUDADC1STSTAGELPEN_SHIFT},
	{PMIC_RG_AUDADC2NDSTAGELPEN, MT6351_PMIC_RG_AUDADC2NDSTAGELPEN_ADDR,
	 MT6351_PMIC_RG_AUDADC2NDSTAGELPEN_MASK, MT6351_PMIC_RG_AUDADC2NDSTAGELPEN_SHIFT},
	{PMIC_RG_AUDADCFLASHLPEN, MT6351_PMIC_RG_AUDADCFLASHLPEN_ADDR,
	 MT6351_PMIC_RG_AUDADCFLASHLPEN_MASK, MT6351_PMIC_RG_AUDADCFLASHLPEN_SHIFT},
	{PMIC_RG_AUDPREAMPIDDTEST, MT6351_PMIC_RG_AUDPREAMPIDDTEST_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPIDDTEST_MASK, MT6351_PMIC_RG_AUDPREAMPIDDTEST_SHIFT},
	{PMIC_RG_AUDADC1STSTAGEIDDTEST, MT6351_PMIC_RG_AUDADC1STSTAGEIDDTEST_ADDR,
	 MT6351_PMIC_RG_AUDADC1STSTAGEIDDTEST_MASK, MT6351_PMIC_RG_AUDADC1STSTAGEIDDTEST_SHIFT},
	{PMIC_RG_AUDADC2NDSTAGEIDDTEST, MT6351_PMIC_RG_AUDADC2NDSTAGEIDDTEST_ADDR,
	 MT6351_PMIC_RG_AUDADC2NDSTAGEIDDTEST_MASK, MT6351_PMIC_RG_AUDADC2NDSTAGEIDDTEST_SHIFT},
	{PMIC_RG_AUDADCREFBUFIDDTEST, MT6351_PMIC_RG_AUDADCREFBUFIDDTEST_ADDR,
	 MT6351_PMIC_RG_AUDADCREFBUFIDDTEST_MASK, MT6351_PMIC_RG_AUDADCREFBUFIDDTEST_SHIFT},
	{PMIC_RG_AUDADCFLASHIDDTEST, MT6351_PMIC_RG_AUDADCFLASHIDDTEST_ADDR,
	 MT6351_PMIC_RG_AUDADCFLASHIDDTEST_MASK, MT6351_PMIC_RG_AUDADCFLASHIDDTEST_SHIFT},
	{PMIC_RG_AUDADCDAC0P25FS, MT6351_PMIC_RG_AUDADCDAC0P25FS_ADDR,
	 MT6351_PMIC_RG_AUDADCDAC0P25FS_MASK, MT6351_PMIC_RG_AUDADCDAC0P25FS_SHIFT},
	{PMIC_RG_AUDADCCLKSEL, MT6351_PMIC_RG_AUDADCCLKSEL_ADDR,
	 MT6351_PMIC_RG_AUDADCCLKSEL_MASK, MT6351_PMIC_RG_AUDADCCLKSEL_SHIFT},
	{PMIC_RG_AUDADCCLKSOURCE, MT6351_PMIC_RG_AUDADCCLKSOURCE_ADDR,
	 MT6351_PMIC_RG_AUDADCCLKSOURCE_MASK, MT6351_PMIC_RG_AUDADCCLKSOURCE_SHIFT},
	{PMIC_RG_AUDADCCLKGENMODE, MT6351_PMIC_RG_AUDADCCLKGENMODE_ADDR,
	 MT6351_PMIC_RG_AUDADCCLKGENMODE_MASK, MT6351_PMIC_RG_AUDADCCLKGENMODE_SHIFT},
	{PMIC_RG_AUDADCCLKRSTB, MT6351_PMIC_RG_AUDADCCLKRSTB_ADDR,
	 MT6351_PMIC_RG_AUDADCCLKRSTB_MASK, MT6351_PMIC_RG_AUDADCCLKRSTB_SHIFT},
	{PMIC_RG_AUDPREAMPAAFEN, MT6351_PMIC_RG_AUDPREAMPAAFEN_ADDR,
	 MT6351_PMIC_RG_AUDPREAMPAAFEN_MASK, MT6351_PMIC_RG_AUDPREAMPAAFEN_SHIFT},
	{PMIC_RG_DCCVCMBUFLPMODSEL, MT6351_PMIC_RG_DCCVCMBUFLPMODSEL_ADDR,
	 MT6351_PMIC_RG_DCCVCMBUFLPMODSEL_MASK, MT6351_PMIC_RG_DCCVCMBUFLPMODSEL_SHIFT},
	{PMIC_RG_DCCVCMBUFLPSWEN, MT6351_PMIC_RG_DCCVCMBUFLPSWEN_ADDR,
	 MT6351_PMIC_RG_DCCVCMBUFLPSWEN_MASK, MT6351_PMIC_RG_DCCVCMBUFLPSWEN_SHIFT},
	{PMIC_RG_AUDSPAREPGA, MT6351_PMIC_RG_AUDSPAREPGA_ADDR,
	 MT6351_PMIC_RG_AUDSPAREPGA_MASK, MT6351_PMIC_RG_AUDSPAREPGA_SHIFT},
	{PMIC_RG_AUDADC1STSTAGESDENB, MT6351_PMIC_RG_AUDADC1STSTAGESDENB_ADDR,
	 MT6351_PMIC_RG_AUDADC1STSTAGESDENB_MASK, MT6351_PMIC_RG_AUDADC1STSTAGESDENB_SHIFT},
	{PMIC_RG_AUDADC2NDSTAGERESET, MT6351_PMIC_RG_AUDADC2NDSTAGERESET_ADDR,
	 MT6351_PMIC_RG_AUDADC2NDSTAGERESET_MASK, MT6351_PMIC_RG_AUDADC2NDSTAGERESET_SHIFT},
	{PMIC_RG_AUDADC3RDSTAGERESET, MT6351_PMIC_RG_AUDADC3RDSTAGERESET_ADDR,
	 MT6351_PMIC_RG_AUDADC3RDSTAGERESET_MASK, MT6351_PMIC_RG_AUDADC3RDSTAGERESET_SHIFT},
	{PMIC_RG_AUDADCFSRESET, MT6351_PMIC_RG_AUDADCFSRESET_ADDR,
	 MT6351_PMIC_RG_AUDADCFSRESET_MASK, MT6351_PMIC_RG_AUDADCFSRESET_SHIFT},
	{PMIC_RG_AUDADCWIDECM, MT6351_PMIC_RG_AUDADCWIDECM_ADDR,
	 MT6351_PMIC_RG_AUDADCWIDECM_MASK, MT6351_PMIC_RG_AUDADCWIDECM_SHIFT},
	{PMIC_RG_AUDADCNOPATEST, MT6351_PMIC_RG_AUDADCNOPATEST_ADDR,
	 MT6351_PMIC_RG_AUDADCNOPATEST_MASK, MT6351_PMIC_RG_AUDADCNOPATEST_SHIFT},
	{PMIC_RG_AUDADCBYPASS, MT6351_PMIC_RG_AUDADCBYPASS_ADDR,
	 MT6351_PMIC_RG_AUDADCBYPASS_MASK, MT6351_PMIC_RG_AUDADCBYPASS_SHIFT},
	{PMIC_RG_AUDADCFFBYPASS, MT6351_PMIC_RG_AUDADCFFBYPASS_ADDR,
	 MT6351_PMIC_RG_AUDADCFFBYPASS_MASK, MT6351_PMIC_RG_AUDADCFFBYPASS_SHIFT},
	{PMIC_RG_AUDADCDACFBCURRENT, MT6351_PMIC_RG_AUDADCDACFBCURRENT_ADDR,
	 MT6351_PMIC_RG_AUDADCDACFBCURRENT_MASK, MT6351_PMIC_RG_AUDADCDACFBCURRENT_SHIFT},
	{PMIC_RG_AUDADCDACIDDTEST, MT6351_PMIC_RG_AUDADCDACIDDTEST_ADDR,
	 MT6351_PMIC_RG_AUDADCDACIDDTEST_MASK, MT6351_PMIC_RG_AUDADCDACIDDTEST_SHIFT},
	{PMIC_RG_AUDADCDACNRZ, MT6351_PMIC_RG_AUDADCDACNRZ_ADDR,
	 MT6351_PMIC_RG_AUDADCDACNRZ_MASK, MT6351_PMIC_RG_AUDADCDACNRZ_SHIFT},
	{PMIC_RG_AUDADCNODEM, MT6351_PMIC_RG_AUDADCNODEM_ADDR,
	 MT6351_PMIC_RG_AUDADCNODEM_MASK, MT6351_PMIC_RG_AUDADCNODEM_SHIFT},
	{PMIC_RG_AUDADCDACTEST, MT6351_PMIC_RG_AUDADCDACTEST_ADDR,
	 MT6351_PMIC_RG_AUDADCDACTEST_MASK, MT6351_PMIC_RG_AUDADCDACTEST_SHIFT},
	{PMIC_RG_AUDADCTESTDATA, MT6351_PMIC_RG_AUDADCTESTDATA_ADDR,
	 MT6351_PMIC_RG_AUDADCTESTDATA_MASK, MT6351_PMIC_RG_AUDADCTESTDATA_SHIFT},
	{PMIC_RG_AUDRCTUNEL, MT6351_PMIC_RG_AUDRCTUNEL_ADDR,
	 MT6351_PMIC_RG_AUDRCTUNEL_MASK, MT6351_PMIC_RG_AUDRCTUNEL_SHIFT},
	{PMIC_RG_AUDRCTUNELSEL, MT6351_PMIC_RG_AUDRCTUNELSEL_ADDR,
	 MT6351_PMIC_RG_AUDRCTUNELSEL_MASK, MT6351_PMIC_RG_AUDRCTUNELSEL_SHIFT},
	{PMIC_RG_AUDRCTUNER, MT6351_PMIC_RG_AUDRCTUNER_ADDR,
	 MT6351_PMIC_RG_AUDRCTUNER_MASK, MT6351_PMIC_RG_AUDRCTUNER_SHIFT},
	{PMIC_RG_AUDRCTUNERSEL, MT6351_PMIC_RG_AUDRCTUNERSEL_ADDR,
	 MT6351_PMIC_RG_AUDRCTUNERSEL_MASK, MT6351_PMIC_RG_AUDRCTUNERSEL_SHIFT},
	{PMIC_RG_AUDSPAREVA30, MT6351_PMIC_RG_AUDSPAREVA30_ADDR,
	 MT6351_PMIC_RG_AUDSPAREVA30_MASK, MT6351_PMIC_RG_AUDSPAREVA30_SHIFT},
	{PMIC_RG_AUDSPAREVA18, MT6351_PMIC_RG_AUDSPAREVA18_ADDR,
	 MT6351_PMIC_RG_AUDSPAREVA18_MASK, MT6351_PMIC_RG_AUDSPAREVA18_SHIFT},
	{PMIC_RG_AUDDIGMICEN, MT6351_PMIC_RG_AUDDIGMICEN_ADDR,
	 MT6351_PMIC_RG_AUDDIGMICEN_MASK, MT6351_PMIC_RG_AUDDIGMICEN_SHIFT},
	{PMIC_RG_AUDDIGMICBIAS, MT6351_PMIC_RG_AUDDIGMICBIAS_ADDR,
	 MT6351_PMIC_RG_AUDDIGMICBIAS_MASK, MT6351_PMIC_RG_AUDDIGMICBIAS_SHIFT},
	{PMIC_RG_DMICHPCLKEN, MT6351_PMIC_RG_DMICHPCLKEN_ADDR,
	 MT6351_PMIC_RG_DMICHPCLKEN_MASK, MT6351_PMIC_RG_DMICHPCLKEN_SHIFT},
	{PMIC_RG_AUDDIGMICPDUTY, MT6351_PMIC_RG_AUDDIGMICPDUTY_ADDR,
	 MT6351_PMIC_RG_AUDDIGMICPDUTY_MASK, MT6351_PMIC_RG_AUDDIGMICPDUTY_SHIFT},
	{PMIC_RG_AUDDIGMICNDUTY, MT6351_PMIC_RG_AUDDIGMICNDUTY_ADDR,
	 MT6351_PMIC_RG_AUDDIGMICNDUTY_MASK, MT6351_PMIC_RG_AUDDIGMICNDUTY_SHIFT},
	{PMIC_RG_DMICMONEN, MT6351_PMIC_RG_DMICMONEN_ADDR, MT6351_PMIC_RG_DMICMONEN_MASK,
	 MT6351_PMIC_RG_DMICMONEN_SHIFT},
	{PMIC_RG_DMICMONSEL, MT6351_PMIC_RG_DMICMONSEL_ADDR,
	 MT6351_PMIC_RG_DMICMONSEL_MASK, MT6351_PMIC_RG_DMICMONSEL_SHIFT},
	{PMIC_RG_AUDSPAREVMIC, MT6351_PMIC_RG_AUDSPAREVMIC_ADDR,
	 MT6351_PMIC_RG_AUDSPAREVMIC_MASK, MT6351_PMIC_RG_AUDSPAREVMIC_SHIFT},
	{PMIC_RG_AUDPWDBMICBIAS0, MT6351_PMIC_RG_AUDPWDBMICBIAS0_ADDR,
	 MT6351_PMIC_RG_AUDPWDBMICBIAS0_MASK, MT6351_PMIC_RG_AUDPWDBMICBIAS0_SHIFT},
	{PMIC_RG_AUDMICBIAS0DCSW0P1EN, MT6351_PMIC_RG_AUDMICBIAS0DCSW0P1EN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS0DCSW0P1EN_MASK, MT6351_PMIC_RG_AUDMICBIAS0DCSW0P1EN_SHIFT},
	{PMIC_RG_AUDMICBIAS0DCSW0P2EN, MT6351_PMIC_RG_AUDMICBIAS0DCSW0P2EN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS0DCSW0P2EN_MASK, MT6351_PMIC_RG_AUDMICBIAS0DCSW0P2EN_SHIFT},
	{PMIC_RG_AUDMICBIAS0DCSW0NEN, MT6351_PMIC_RG_AUDMICBIAS0DCSW0NEN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS0DCSW0NEN_MASK, MT6351_PMIC_RG_AUDMICBIAS0DCSW0NEN_SHIFT},
	{PMIC_RG_AUDMICBIAS0VREF, MT6351_PMIC_RG_AUDMICBIAS0VREF_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS0VREF_MASK, MT6351_PMIC_RG_AUDMICBIAS0VREF_SHIFT},
	{PMIC_RG_AUDMICBIAS0LOWPEN, MT6351_PMIC_RG_AUDMICBIAS0LOWPEN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS0LOWPEN_MASK, MT6351_PMIC_RG_AUDMICBIAS0LOWPEN_SHIFT},
	{PMIC_RG_AUDPWDBMICBIAS2, MT6351_PMIC_RG_AUDPWDBMICBIAS2_ADDR,
	 MT6351_PMIC_RG_AUDPWDBMICBIAS2_MASK, MT6351_PMIC_RG_AUDPWDBMICBIAS2_SHIFT},
	{PMIC_RG_AUDMICBIAS2DCSW2P1EN, MT6351_PMIC_RG_AUDMICBIAS2DCSW2P1EN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS2DCSW2P1EN_MASK, MT6351_PMIC_RG_AUDMICBIAS2DCSW2P1EN_SHIFT},
	{PMIC_RG_AUDMICBIAS2DCSW2P2EN, MT6351_PMIC_RG_AUDMICBIAS2DCSW2P2EN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS2DCSW2P2EN_MASK, MT6351_PMIC_RG_AUDMICBIAS2DCSW2P2EN_SHIFT},
	{PMIC_RG_AUDMICBIAS2DCSW2NEN, MT6351_PMIC_RG_AUDMICBIAS2DCSW2NEN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS2DCSW2NEN_MASK, MT6351_PMIC_RG_AUDMICBIAS2DCSW2NEN_SHIFT},
	{PMIC_RG_AUDMICBIAS2VREF, MT6351_PMIC_RG_AUDMICBIAS2VREF_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS2VREF_MASK, MT6351_PMIC_RG_AUDMICBIAS2VREF_SHIFT},
	{PMIC_RG_AUDMICBIAS2LOWPEN, MT6351_PMIC_RG_AUDMICBIAS2LOWPEN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS2LOWPEN_MASK, MT6351_PMIC_RG_AUDMICBIAS2LOWPEN_SHIFT},
	{PMIC_RG_AUDPWDBMICBIAS1, MT6351_PMIC_RG_AUDPWDBMICBIAS1_ADDR,
	 MT6351_PMIC_RG_AUDPWDBMICBIAS1_MASK, MT6351_PMIC_RG_AUDPWDBMICBIAS1_SHIFT},
	{PMIC_RG_AUDMICBIAS1DCSW1PEN, MT6351_PMIC_RG_AUDMICBIAS1DCSW1PEN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS1DCSW1PEN_MASK, MT6351_PMIC_RG_AUDMICBIAS1DCSW1PEN_SHIFT},
	{PMIC_RG_AUDMICBIAS1DCSW1NEN, MT6351_PMIC_RG_AUDMICBIAS1DCSW1NEN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS1DCSW1NEN_MASK, MT6351_PMIC_RG_AUDMICBIAS1DCSW1NEN_SHIFT},
	{PMIC_RG_AUDMICBIAS1VREF, MT6351_PMIC_RG_AUDMICBIAS1VREF_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS1VREF_MASK, MT6351_PMIC_RG_AUDMICBIAS1VREF_SHIFT},
	{PMIC_RG_AUDMICBIAS1LOWPEN, MT6351_PMIC_RG_AUDMICBIAS1LOWPEN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS1LOWPEN_MASK, MT6351_PMIC_RG_AUDMICBIAS1LOWPEN_SHIFT},
	{PMIC_RG_AUDMICBIAS1DCSW3PEN, MT6351_PMIC_RG_AUDMICBIAS1DCSW3PEN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS1DCSW3PEN_MASK, MT6351_PMIC_RG_AUDMICBIAS1DCSW3PEN_SHIFT},
	{PMIC_RG_AUDMICBIAS1DCSW3NEN, MT6351_PMIC_RG_AUDMICBIAS1DCSW3NEN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS1DCSW3NEN_MASK, MT6351_PMIC_RG_AUDMICBIAS1DCSW3NEN_SHIFT},
	{PMIC_RG_AUDMICBIAS2DCSW3PEN, MT6351_PMIC_RG_AUDMICBIAS2DCSW3PEN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS2DCSW3PEN_MASK, MT6351_PMIC_RG_AUDMICBIAS2DCSW3PEN_SHIFT},
	{PMIC_RG_AUDMICBIAS2DCSW3NEN, MT6351_PMIC_RG_AUDMICBIAS2DCSW3NEN_ADDR,
	 MT6351_PMIC_RG_AUDMICBIAS2DCSW3NEN_MASK, MT6351_PMIC_RG_AUDMICBIAS2DCSW3NEN_SHIFT},
	{PMIC_RG_BANDGAPGEN, MT6351_PMIC_RG_BANDGAPGEN_ADDR,
	 MT6351_PMIC_RG_BANDGAPGEN_MASK, MT6351_PMIC_RG_BANDGAPGEN_SHIFT},
	{PMIC_RG_AUDACCDETMICBIAS0PULLLOW, MT6351_PMIC_RG_AUDACCDETMICBIAS0PULLLOW_ADDR,
	 MT6351_PMIC_RG_AUDACCDETMICBIAS0PULLLOW_MASK,
	 MT6351_PMIC_RG_AUDACCDETMICBIAS0PULLLOW_SHIFT},
	{PMIC_RG_AUDACCDETMICBIAS1PULLLOW, MT6351_PMIC_RG_AUDACCDETMICBIAS1PULLLOW_ADDR,
	 MT6351_PMIC_RG_AUDACCDETMICBIAS1PULLLOW_MASK,
	 MT6351_PMIC_RG_AUDACCDETMICBIAS1PULLLOW_SHIFT},
	{PMIC_RG_AUDACCDETMICBIAS2PULLLOW, MT6351_PMIC_RG_AUDACCDETMICBIAS2PULLLOW_ADDR,
	 MT6351_PMIC_RG_AUDACCDETMICBIAS2PULLLOW_MASK,
	 MT6351_PMIC_RG_AUDACCDETMICBIAS2PULLLOW_SHIFT},
	{PMIC_RG_AUDACCDETVIN1PULLLOW, MT6351_PMIC_RG_AUDACCDETVIN1PULLLOW_ADDR,
	 MT6351_PMIC_RG_AUDACCDETVIN1PULLLOW_MASK, MT6351_PMIC_RG_AUDACCDETVIN1PULLLOW_SHIFT},
	{PMIC_RG_AUDACCDETVTHACAL, MT6351_PMIC_RG_AUDACCDETVTHACAL_ADDR,
	 MT6351_PMIC_RG_AUDACCDETVTHACAL_MASK, MT6351_PMIC_RG_AUDACCDETVTHACAL_SHIFT},
	{PMIC_RG_AUDACCDETVTHBCAL, MT6351_PMIC_RG_AUDACCDETVTHBCAL_ADDR,
	 MT6351_PMIC_RG_AUDACCDETVTHBCAL_MASK, MT6351_PMIC_RG_AUDACCDETVTHBCAL_SHIFT},
	{PMIC_RG_ACCDET1SEL, MT6351_PMIC_RG_ACCDET1SEL_ADDR,
	 MT6351_PMIC_RG_ACCDET1SEL_MASK, MT6351_PMIC_RG_ACCDET1SEL_SHIFT},
	{PMIC_RG_ACCDET2SEL, MT6351_PMIC_RG_ACCDET2SEL_ADDR,
	 MT6351_PMIC_RG_ACCDET2SEL_MASK, MT6351_PMIC_RG_ACCDET2SEL_SHIFT},
	{PMIC_RG_SWBUFMODSEL, MT6351_PMIC_RG_SWBUFMODSEL_ADDR,
	 MT6351_PMIC_RG_SWBUFMODSEL_MASK, MT6351_PMIC_RG_SWBUFMODSEL_SHIFT},
	{PMIC_RG_SWBUFSWEN, MT6351_PMIC_RG_SWBUFSWEN_ADDR, MT6351_PMIC_RG_SWBUFSWEN_MASK,
	 MT6351_PMIC_RG_SWBUFSWEN_SHIFT},
	{PMIC_RG_EINTCOMPVTH, MT6351_PMIC_RG_EINTCOMPVTH_ADDR,
	 MT6351_PMIC_RG_EINTCOMPVTH_MASK, MT6351_PMIC_RG_EINTCOMPVTH_SHIFT},
	{PMIC_RG_EINTCONFIGACCDET, MT6351_PMIC_RG_EINTCONFIGACCDET_ADDR,
	 MT6351_PMIC_RG_EINTCONFIGACCDET_MASK, MT6351_PMIC_RG_EINTCONFIGACCDET_SHIFT},
	{PMIC_RG_NVDETCMPEN, MT6351_PMIC_RG_NVDETCMPEN_ADDR,
	 MT6351_PMIC_RG_NVDETCMPEN_MASK, MT6351_PMIC_RG_NVDETCMPEN_SHIFT},
	{PMIC_RG_NVDETVTH, MT6351_PMIC_RG_NVDETVTH_ADDR, MT6351_PMIC_RG_NVDETVTH_MASK,
	 MT6351_PMIC_RG_NVDETVTH_SHIFT},
	{PMIC_RG_NVMODSEL, MT6351_PMIC_RG_NVMODSEL_ADDR, MT6351_PMIC_RG_NVMODSEL_MASK,
	 MT6351_PMIC_RG_NVMODSEL_SHIFT},
	{PMIC_RG_NVCMPSWEN, MT6351_PMIC_RG_NVCMPSWEN_ADDR, MT6351_PMIC_RG_NVCMPSWEN_MASK,
	 MT6351_PMIC_RG_NVCMPSWEN_SHIFT},
	{PMIC_RG_AUDENCSPAREVA30, MT6351_PMIC_RG_AUDENCSPAREVA30_ADDR,
	 MT6351_PMIC_RG_AUDENCSPAREVA30_MASK, MT6351_PMIC_RG_AUDENCSPAREVA30_SHIFT},
	{PMIC_RG_AUDENCSPAREVA18, MT6351_PMIC_RG_AUDENCSPAREVA18_ADDR,
	 MT6351_PMIC_RG_AUDENCSPAREVA18_MASK, MT6351_PMIC_RG_AUDENCSPAREVA18_SHIFT},
	{PMIC_RG_PLL_EN, MT6351_PMIC_RG_PLL_EN_ADDR, MT6351_PMIC_RG_PLL_EN_MASK,
	 MT6351_PMIC_RG_PLL_EN_SHIFT},
	{PMIC_RG_PLLBS_RST, MT6351_PMIC_RG_PLLBS_RST_ADDR, MT6351_PMIC_RG_PLLBS_RST_MASK,
	 MT6351_PMIC_RG_PLLBS_RST_SHIFT},
	{PMIC_RG_PLL_DCKO_SEL, MT6351_PMIC_RG_PLL_DCKO_SEL_ADDR,
	 MT6351_PMIC_RG_PLL_DCKO_SEL_MASK, MT6351_PMIC_RG_PLL_DCKO_SEL_SHIFT},
	{PMIC_RG_PLL_DIV1, MT6351_PMIC_RG_PLL_DIV1_ADDR, MT6351_PMIC_RG_PLL_DIV1_MASK,
	 MT6351_PMIC_RG_PLL_DIV1_SHIFT},
	{PMIC_RG_PLL_RLATCH_EN, MT6351_PMIC_RG_PLL_RLATCH_EN_ADDR,
	 MT6351_PMIC_RG_PLL_RLATCH_EN_MASK, MT6351_PMIC_RG_PLL_RLATCH_EN_SHIFT},
	{PMIC_RG_PLL_PDIV1_EN, MT6351_PMIC_RG_PLL_PDIV1_EN_ADDR,
	 MT6351_PMIC_RG_PLL_PDIV1_EN_MASK, MT6351_PMIC_RG_PLL_PDIV1_EN_SHIFT},
	{PMIC_RG_PLL_PDIV1, MT6351_PMIC_RG_PLL_PDIV1_ADDR, MT6351_PMIC_RG_PLL_PDIV1_MASK,
	 MT6351_PMIC_RG_PLL_PDIV1_SHIFT},
	{PMIC_RG_PLL_BC, MT6351_PMIC_RG_PLL_BC_ADDR, MT6351_PMIC_RG_PLL_BC_MASK,
	 MT6351_PMIC_RG_PLL_BC_SHIFT},
	{PMIC_RG_PLL_BP, MT6351_PMIC_RG_PLL_BP_ADDR, MT6351_PMIC_RG_PLL_BP_MASK,
	 MT6351_PMIC_RG_PLL_BP_SHIFT},
	{PMIC_RG_PLL_BR, MT6351_PMIC_RG_PLL_BR_ADDR, MT6351_PMIC_RG_PLL_BR_MASK,
	 MT6351_PMIC_RG_PLL_BR_SHIFT},
	{PMIC_RG_CKO_SEL, MT6351_PMIC_RG_CKO_SEL_ADDR, MT6351_PMIC_RG_CKO_SEL_MASK,
	 MT6351_PMIC_RG_CKO_SEL_SHIFT},
	{PMIC_RG_PLL_IBSEL, MT6351_PMIC_RG_PLL_IBSEL_ADDR, MT6351_PMIC_RG_PLL_IBSEL_MASK,
	 MT6351_PMIC_RG_PLL_IBSEL_SHIFT},
	{PMIC_RG_PLL_CKT_SEL, MT6351_PMIC_RG_PLL_CKT_SEL_ADDR,
	 MT6351_PMIC_RG_PLL_CKT_SEL_MASK, MT6351_PMIC_RG_PLL_CKT_SEL_SHIFT},
	{PMIC_RG_PLL_VCT_EN, MT6351_PMIC_RG_PLL_VCT_EN_ADDR,
	 MT6351_PMIC_RG_PLL_VCT_EN_MASK, MT6351_PMIC_RG_PLL_VCT_EN_SHIFT},
	{PMIC_RG_PLL_CKT_EN, MT6351_PMIC_RG_PLL_CKT_EN_ADDR,
	 MT6351_PMIC_RG_PLL_CKT_EN_MASK, MT6351_PMIC_RG_PLL_CKT_EN_SHIFT},
	{PMIC_RG_PLL_HPM_EN, MT6351_PMIC_RG_PLL_HPM_EN_ADDR,
	 MT6351_PMIC_RG_PLL_HPM_EN_MASK, MT6351_PMIC_RG_PLL_HPM_EN_SHIFT},
	{PMIC_RG_PLL_DCHP_EN, MT6351_PMIC_RG_PLL_DCHP_EN_ADDR,
	 MT6351_PMIC_RG_PLL_DCHP_EN_MASK, MT6351_PMIC_RG_PLL_DCHP_EN_SHIFT},
	{PMIC_RG_PLL_CDIV, MT6351_PMIC_RG_PLL_CDIV_ADDR, MT6351_PMIC_RG_PLL_CDIV_MASK,
	 MT6351_PMIC_RG_PLL_CDIV_SHIFT},
	{PMIC_RG_VCOBAND, MT6351_PMIC_RG_VCOBAND_ADDR, MT6351_PMIC_RG_VCOBAND_MASK,
	 MT6351_PMIC_RG_VCOBAND_SHIFT},
	{PMIC_RG_CKDRV_EN, MT6351_PMIC_RG_CKDRV_EN_ADDR, MT6351_PMIC_RG_CKDRV_EN_MASK,
	 MT6351_PMIC_RG_CKDRV_EN_SHIFT},
	{PMIC_RG_PLL_DCHP_AEN, MT6351_PMIC_RG_PLL_DCHP_AEN_ADDR,
	 MT6351_PMIC_RG_PLL_DCHP_AEN_MASK, MT6351_PMIC_RG_PLL_DCHP_AEN_SHIFT},
	{PMIC_RG_PLL_RSVA, MT6351_PMIC_RG_PLL_RSVA_ADDR, MT6351_PMIC_RG_PLL_RSVA_MASK,
	 MT6351_PMIC_RG_PLL_RSVA_SHIFT},
	{PMIC_RGS_AUDRCTUNELREAD, MT6351_PMIC_RGS_AUDRCTUNELREAD_ADDR,
	 MT6351_PMIC_RGS_AUDRCTUNELREAD_MASK, MT6351_PMIC_RGS_AUDRCTUNELREAD_SHIFT},
	{PMIC_RGS_AUDRCTUNERREAD, MT6351_PMIC_RGS_AUDRCTUNERREAD_ADDR,
	 MT6351_PMIC_RGS_AUDRCTUNERREAD_MASK, MT6351_PMIC_RGS_AUDRCTUNERREAD_SHIFT},
	{PMIC_RG_DIVCKS_CHG, MT6351_PMIC_RG_DIVCKS_CHG_ADDR,
	 MT6351_PMIC_RG_DIVCKS_CHG_MASK, MT6351_PMIC_RG_DIVCKS_CHG_SHIFT},
	{PMIC_RG_DIVCKS_ON, MT6351_PMIC_RG_DIVCKS_ON_ADDR, MT6351_PMIC_RG_DIVCKS_ON_MASK,
	 MT6351_PMIC_RG_DIVCKS_ON_SHIFT},
	{PMIC_RG_DIVCKS_PRG, MT6351_PMIC_RG_DIVCKS_PRG_ADDR,
	 MT6351_PMIC_RG_DIVCKS_PRG_MASK, MT6351_PMIC_RG_DIVCKS_PRG_SHIFT},
	{PMIC_RG_DIVCKS_PWD_NCP, MT6351_PMIC_RG_DIVCKS_PWD_NCP_ADDR,
	 MT6351_PMIC_RG_DIVCKS_PWD_NCP_MASK, MT6351_PMIC_RG_DIVCKS_PWD_NCP_SHIFT},
	{PMIC_RG_DIVCKS_PWD_NCP_ST_SEL, MT6351_PMIC_RG_DIVCKS_PWD_NCP_ST_SEL_ADDR,
	 MT6351_PMIC_RG_DIVCKS_PWD_NCP_ST_SEL_MASK, MT6351_PMIC_RG_DIVCKS_PWD_NCP_ST_SEL_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH0, MT6351_PMIC_AUXADC_ADC_OUT_CH0_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH0_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH0_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH0, MT6351_PMIC_AUXADC_ADC_RDY_CH0_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH0_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH0_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH1, MT6351_PMIC_AUXADC_ADC_OUT_CH1_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH1_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH1_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH1, MT6351_PMIC_AUXADC_ADC_RDY_CH1_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH1_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH1_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH2, MT6351_PMIC_AUXADC_ADC_OUT_CH2_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH2_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH2_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH2, MT6351_PMIC_AUXADC_ADC_RDY_CH2_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH2_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH2_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH3, MT6351_PMIC_AUXADC_ADC_OUT_CH3_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH3_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH3_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH3, MT6351_PMIC_AUXADC_ADC_RDY_CH3_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH3_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH3_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH4, MT6351_PMIC_AUXADC_ADC_OUT_CH4_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH4_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH4_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH4, MT6351_PMIC_AUXADC_ADC_RDY_CH4_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH4_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH4_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH5, MT6351_PMIC_AUXADC_ADC_OUT_CH5_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH5_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH5_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH5, MT6351_PMIC_AUXADC_ADC_RDY_CH5_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH5_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH5_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH6, MT6351_PMIC_AUXADC_ADC_OUT_CH6_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH6_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH6_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH6, MT6351_PMIC_AUXADC_ADC_RDY_CH6_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH6_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH6_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH7, MT6351_PMIC_AUXADC_ADC_OUT_CH7_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH7_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH7_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH7, MT6351_PMIC_AUXADC_ADC_RDY_CH7_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH7_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH7_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH8, MT6351_PMIC_AUXADC_ADC_OUT_CH8_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH8_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH8_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH8, MT6351_PMIC_AUXADC_ADC_RDY_CH8_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH8_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH8_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH9, MT6351_PMIC_AUXADC_ADC_OUT_CH9_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH9_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH9_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH9, MT6351_PMIC_AUXADC_ADC_RDY_CH9_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH9_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH9_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH10, MT6351_PMIC_AUXADC_ADC_OUT_CH10_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH10_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH10_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH10, MT6351_PMIC_AUXADC_ADC_RDY_CH10_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH10_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH10_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH11, MT6351_PMIC_AUXADC_ADC_OUT_CH11_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH11_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH11_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH11, MT6351_PMIC_AUXADC_ADC_RDY_CH11_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH11_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH11_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH12_15, MT6351_PMIC_AUXADC_ADC_OUT_CH12_15_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH12_15_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH12_15_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH12_15, MT6351_PMIC_AUXADC_ADC_RDY_CH12_15_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH12_15_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH12_15_SHIFT},
	{PMIC_AUXADC_ADC_OUT_THR_HW, MT6351_PMIC_AUXADC_ADC_OUT_THR_HW_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_THR_HW_MASK, MT6351_PMIC_AUXADC_ADC_OUT_THR_HW_SHIFT},
	{PMIC_AUXADC_ADC_RDY_THR_HW, MT6351_PMIC_AUXADC_ADC_RDY_THR_HW_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_THR_HW_MASK, MT6351_PMIC_AUXADC_ADC_RDY_THR_HW_SHIFT},
	{PMIC_AUXADC_ADC_OUT_LBAT, MT6351_PMIC_AUXADC_ADC_OUT_LBAT_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_LBAT_MASK, MT6351_PMIC_AUXADC_ADC_OUT_LBAT_SHIFT},
	{PMIC_AUXADC_ADC_RDY_LBAT, MT6351_PMIC_AUXADC_ADC_RDY_LBAT_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_LBAT_MASK, MT6351_PMIC_AUXADC_ADC_RDY_LBAT_SHIFT},
	{PMIC_AUXADC_ADC_OUT_LBAT2, MT6351_PMIC_AUXADC_ADC_OUT_LBAT2_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_LBAT2_MASK, MT6351_PMIC_AUXADC_ADC_OUT_LBAT2_SHIFT},
	{PMIC_AUXADC_ADC_RDY_LBAT2, MT6351_PMIC_AUXADC_ADC_RDY_LBAT2_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_LBAT2_MASK, MT6351_PMIC_AUXADC_ADC_RDY_LBAT2_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH7_BY_GPS, MT6351_PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH7_BY_GPS, MT6351_PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH7_BY_MD, MT6351_PMIC_AUXADC_ADC_OUT_CH7_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH7_BY_MD_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH7_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH7_BY_MD, MT6351_PMIC_AUXADC_ADC_RDY_CH7_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH7_BY_MD_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH7_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH7_BY_AP, MT6351_PMIC_AUXADC_ADC_OUT_CH7_BY_AP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH7_BY_AP_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH7_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH7_BY_AP, MT6351_PMIC_AUXADC_ADC_RDY_CH7_BY_AP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH7_BY_AP_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH7_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH4_BY_MD, MT6351_PMIC_AUXADC_ADC_OUT_CH4_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH4_BY_MD_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH4_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH4_BY_MD, MT6351_PMIC_AUXADC_ADC_RDY_CH4_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH4_BY_MD_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH4_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR, MT6351_PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_MASK,
	 MT6351_PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_SHIFT},
	{PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR, MT6351_PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_MASK,
	 MT6351_PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_SHIFT},
	{PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR, MT6351_PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_MASK,
	 MT6351_PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_SHIFT},
	{PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR, MT6351_PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_MASK,
	 MT6351_PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH0_BY_MD, MT6351_PMIC_AUXADC_ADC_OUT_CH0_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH0_BY_MD_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH0_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH0_BY_MD, MT6351_PMIC_AUXADC_ADC_RDY_CH0_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH0_BY_MD_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH0_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH0_BY_AP, MT6351_PMIC_AUXADC_ADC_OUT_CH0_BY_AP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH0_BY_AP_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH0_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH0_BY_AP, MT6351_PMIC_AUXADC_ADC_RDY_CH0_BY_AP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH0_BY_AP_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH0_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH1_BY_MD, MT6351_PMIC_AUXADC_ADC_OUT_CH1_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH1_BY_MD_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH1_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH1_BY_MD, MT6351_PMIC_AUXADC_ADC_RDY_CH1_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH1_BY_MD_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH1_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH1_BY_AP, MT6351_PMIC_AUXADC_ADC_OUT_CH1_BY_AP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_CH1_BY_AP_MASK, MT6351_PMIC_AUXADC_ADC_OUT_CH1_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH1_BY_AP, MT6351_PMIC_AUXADC_ADC_RDY_CH1_BY_AP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_CH1_BY_AP_MASK, MT6351_PMIC_AUXADC_ADC_RDY_CH1_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_OUT_VISMPS0, MT6351_PMIC_AUXADC_ADC_OUT_VISMPS0_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_VISMPS0_MASK, MT6351_PMIC_AUXADC_ADC_OUT_VISMPS0_SHIFT},
	{PMIC_AUXADC_ADC_RDY_VISMPS0, MT6351_PMIC_AUXADC_ADC_RDY_VISMPS0_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_VISMPS0_MASK, MT6351_PMIC_AUXADC_ADC_RDY_VISMPS0_SHIFT},
	{PMIC_AUXADC_ADC_OUT_FGADC1, MT6351_PMIC_AUXADC_ADC_OUT_FGADC1_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_FGADC1_MASK, MT6351_PMIC_AUXADC_ADC_OUT_FGADC1_SHIFT},
	{PMIC_AUXADC_ADC_RDY_FGADC1, MT6351_PMIC_AUXADC_ADC_RDY_FGADC1_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_FGADC1_MASK, MT6351_PMIC_AUXADC_ADC_RDY_FGADC1_SHIFT},
	{PMIC_AUXADC_ADC_OUT_FGADC2, MT6351_PMIC_AUXADC_ADC_OUT_FGADC2_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_FGADC2_MASK, MT6351_PMIC_AUXADC_ADC_OUT_FGADC2_SHIFT},
	{PMIC_AUXADC_ADC_RDY_FGADC2, MT6351_PMIC_AUXADC_ADC_RDY_FGADC2_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_FGADC2_MASK, MT6351_PMIC_AUXADC_ADC_RDY_FGADC2_SHIFT},
	{PMIC_AUXADC_ADC_OUT_IMP, MT6351_PMIC_AUXADC_ADC_OUT_IMP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_IMP_MASK, MT6351_PMIC_AUXADC_ADC_OUT_IMP_SHIFT},
	{PMIC_AUXADC_ADC_RDY_IMP, MT6351_PMIC_AUXADC_ADC_RDY_IMP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_IMP_MASK, MT6351_PMIC_AUXADC_ADC_RDY_IMP_SHIFT},
	{PMIC_AUXADC_ADC_OUT_IMP_AVG, MT6351_PMIC_AUXADC_ADC_OUT_IMP_AVG_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_IMP_AVG_MASK, MT6351_PMIC_AUXADC_ADC_OUT_IMP_AVG_SHIFT},
	{PMIC_AUXADC_ADC_RDY_IMP_AVG, MT6351_PMIC_AUXADC_ADC_RDY_IMP_AVG_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_IMP_AVG_MASK, MT6351_PMIC_AUXADC_ADC_RDY_IMP_AVG_SHIFT},
	{PMIC_AUXADC_ADC_OUT_RAW, MT6351_PMIC_AUXADC_ADC_OUT_RAW_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_RAW_MASK, MT6351_PMIC_AUXADC_ADC_OUT_RAW_SHIFT},
	{PMIC_AUXADC_ADC_OUT_MDRT, MT6351_PMIC_AUXADC_ADC_OUT_MDRT_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_MDRT_MASK, MT6351_PMIC_AUXADC_ADC_OUT_MDRT_SHIFT},
	{PMIC_AUXADC_ADC_RDY_MDRT, MT6351_PMIC_AUXADC_ADC_RDY_MDRT_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_MDRT_MASK, MT6351_PMIC_AUXADC_ADC_RDY_MDRT_SHIFT},
	{PMIC_AUXADC_ADC_OUT_MDBG, MT6351_PMIC_AUXADC_ADC_OUT_MDBG_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_MDBG_MASK, MT6351_PMIC_AUXADC_ADC_OUT_MDBG_SHIFT},
	{PMIC_AUXADC_ADC_RDY_MDBG, MT6351_PMIC_AUXADC_ADC_RDY_MDBG_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_MDBG_MASK, MT6351_PMIC_AUXADC_ADC_RDY_MDBG_SHIFT},
	{PMIC_AUXADC_ADC_OUT_JEITA, MT6351_PMIC_AUXADC_ADC_OUT_JEITA_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_JEITA_MASK, MT6351_PMIC_AUXADC_ADC_OUT_JEITA_SHIFT},
	{PMIC_AUXADC_ADC_RDY_JEITA, MT6351_PMIC_AUXADC_ADC_RDY_JEITA_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_JEITA_MASK, MT6351_PMIC_AUXADC_ADC_RDY_JEITA_SHIFT},
	{PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS, MT6351_PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS_MASK,
	 MT6351_PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS_SHIFT},
	{PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS, MT6351_PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS_MASK,
	 MT6351_PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS_SHIFT},
	{PMIC_AUXADC_ADC_OUT_DCXO_BY_MD, MT6351_PMIC_AUXADC_ADC_OUT_DCXO_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_DCXO_BY_MD_MASK, MT6351_PMIC_AUXADC_ADC_OUT_DCXO_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_RDY_DCXO_BY_MD, MT6351_PMIC_AUXADC_ADC_RDY_DCXO_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_DCXO_BY_MD_MASK, MT6351_PMIC_AUXADC_ADC_RDY_DCXO_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_OUT_DCXO_BY_AP, MT6351_PMIC_AUXADC_ADC_OUT_DCXO_BY_AP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_DCXO_BY_AP_MASK, MT6351_PMIC_AUXADC_ADC_OUT_DCXO_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_RDY_DCXO_BY_AP, MT6351_PMIC_AUXADC_ADC_RDY_DCXO_BY_AP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_DCXO_BY_AP_MASK, MT6351_PMIC_AUXADC_ADC_RDY_DCXO_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_OUT_DCXO_MDRT, MT6351_PMIC_AUXADC_ADC_OUT_DCXO_MDRT_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_DCXO_MDRT_MASK, MT6351_PMIC_AUXADC_ADC_OUT_DCXO_MDRT_SHIFT},
	{PMIC_AUXADC_ADC_RDY_DCXO_MDRT, MT6351_PMIC_AUXADC_ADC_RDY_DCXO_MDRT_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_DCXO_MDRT_MASK, MT6351_PMIC_AUXADC_ADC_RDY_DCXO_MDRT_SHIFT},
	{PMIC_AUXADC_ADC_OUT_NAG, MT6351_PMIC_AUXADC_ADC_OUT_NAG_ADDR,
	 MT6351_PMIC_AUXADC_ADC_OUT_NAG_MASK, MT6351_PMIC_AUXADC_ADC_OUT_NAG_SHIFT},
	{PMIC_AUXADC_ADC_RDY_NAG, MT6351_PMIC_AUXADC_ADC_RDY_NAG_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_NAG_MASK, MT6351_PMIC_AUXADC_ADC_RDY_NAG_SHIFT},
	{PMIC_AUXADC_BUF_OUT_00, MT6351_PMIC_AUXADC_BUF_OUT_00_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_00_MASK, MT6351_PMIC_AUXADC_BUF_OUT_00_SHIFT},
	{PMIC_AUXADC_BUF_RDY_00, MT6351_PMIC_AUXADC_BUF_RDY_00_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_00_MASK, MT6351_PMIC_AUXADC_BUF_RDY_00_SHIFT},
	{PMIC_AUXADC_BUF_OUT_01, MT6351_PMIC_AUXADC_BUF_OUT_01_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_01_MASK, MT6351_PMIC_AUXADC_BUF_OUT_01_SHIFT},
	{PMIC_AUXADC_BUF_RDY_01, MT6351_PMIC_AUXADC_BUF_RDY_01_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_01_MASK, MT6351_PMIC_AUXADC_BUF_RDY_01_SHIFT},
	{PMIC_AUXADC_BUF_OUT_02, MT6351_PMIC_AUXADC_BUF_OUT_02_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_02_MASK, MT6351_PMIC_AUXADC_BUF_OUT_02_SHIFT},
	{PMIC_AUXADC_BUF_RDY_02, MT6351_PMIC_AUXADC_BUF_RDY_02_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_02_MASK, MT6351_PMIC_AUXADC_BUF_RDY_02_SHIFT},
	{PMIC_AUXADC_BUF_OUT_03, MT6351_PMIC_AUXADC_BUF_OUT_03_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_03_MASK, MT6351_PMIC_AUXADC_BUF_OUT_03_SHIFT},
	{PMIC_AUXADC_BUF_RDY_03, MT6351_PMIC_AUXADC_BUF_RDY_03_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_03_MASK, MT6351_PMIC_AUXADC_BUF_RDY_03_SHIFT},
	{PMIC_AUXADC_BUF_OUT_04, MT6351_PMIC_AUXADC_BUF_OUT_04_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_04_MASK, MT6351_PMIC_AUXADC_BUF_OUT_04_SHIFT},
	{PMIC_AUXADC_BUF_RDY_04, MT6351_PMIC_AUXADC_BUF_RDY_04_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_04_MASK, MT6351_PMIC_AUXADC_BUF_RDY_04_SHIFT},
	{PMIC_AUXADC_BUF_OUT_05, MT6351_PMIC_AUXADC_BUF_OUT_05_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_05_MASK, MT6351_PMIC_AUXADC_BUF_OUT_05_SHIFT},
	{PMIC_AUXADC_BUF_RDY_05, MT6351_PMIC_AUXADC_BUF_RDY_05_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_05_MASK, MT6351_PMIC_AUXADC_BUF_RDY_05_SHIFT},
	{PMIC_AUXADC_BUF_OUT_06, MT6351_PMIC_AUXADC_BUF_OUT_06_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_06_MASK, MT6351_PMIC_AUXADC_BUF_OUT_06_SHIFT},
	{PMIC_AUXADC_BUF_RDY_06, MT6351_PMIC_AUXADC_BUF_RDY_06_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_06_MASK, MT6351_PMIC_AUXADC_BUF_RDY_06_SHIFT},
	{PMIC_AUXADC_BUF_OUT_07, MT6351_PMIC_AUXADC_BUF_OUT_07_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_07_MASK, MT6351_PMIC_AUXADC_BUF_OUT_07_SHIFT},
	{PMIC_AUXADC_BUF_RDY_07, MT6351_PMIC_AUXADC_BUF_RDY_07_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_07_MASK, MT6351_PMIC_AUXADC_BUF_RDY_07_SHIFT},
	{PMIC_AUXADC_BUF_OUT_08, MT6351_PMIC_AUXADC_BUF_OUT_08_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_08_MASK, MT6351_PMIC_AUXADC_BUF_OUT_08_SHIFT},
	{PMIC_AUXADC_BUF_RDY_08, MT6351_PMIC_AUXADC_BUF_RDY_08_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_08_MASK, MT6351_PMIC_AUXADC_BUF_RDY_08_SHIFT},
	{PMIC_AUXADC_BUF_OUT_09, MT6351_PMIC_AUXADC_BUF_OUT_09_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_09_MASK, MT6351_PMIC_AUXADC_BUF_OUT_09_SHIFT},
	{PMIC_AUXADC_BUF_RDY_09, MT6351_PMIC_AUXADC_BUF_RDY_09_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_09_MASK, MT6351_PMIC_AUXADC_BUF_RDY_09_SHIFT},
	{PMIC_AUXADC_BUF_OUT_10, MT6351_PMIC_AUXADC_BUF_OUT_10_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_10_MASK, MT6351_PMIC_AUXADC_BUF_OUT_10_SHIFT},
	{PMIC_AUXADC_BUF_RDY_10, MT6351_PMIC_AUXADC_BUF_RDY_10_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_10_MASK, MT6351_PMIC_AUXADC_BUF_RDY_10_SHIFT},
	{PMIC_AUXADC_BUF_OUT_11, MT6351_PMIC_AUXADC_BUF_OUT_11_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_11_MASK, MT6351_PMIC_AUXADC_BUF_OUT_11_SHIFT},
	{PMIC_AUXADC_BUF_RDY_11, MT6351_PMIC_AUXADC_BUF_RDY_11_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_11_MASK, MT6351_PMIC_AUXADC_BUF_RDY_11_SHIFT},
	{PMIC_AUXADC_BUF_OUT_12, MT6351_PMIC_AUXADC_BUF_OUT_12_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_12_MASK, MT6351_PMIC_AUXADC_BUF_OUT_12_SHIFT},
	{PMIC_AUXADC_BUF_RDY_12, MT6351_PMIC_AUXADC_BUF_RDY_12_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_12_MASK, MT6351_PMIC_AUXADC_BUF_RDY_12_SHIFT},
	{PMIC_AUXADC_BUF_OUT_13, MT6351_PMIC_AUXADC_BUF_OUT_13_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_13_MASK, MT6351_PMIC_AUXADC_BUF_OUT_13_SHIFT},
	{PMIC_AUXADC_BUF_RDY_13, MT6351_PMIC_AUXADC_BUF_RDY_13_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_13_MASK, MT6351_PMIC_AUXADC_BUF_RDY_13_SHIFT},
	{PMIC_AUXADC_BUF_OUT_14, MT6351_PMIC_AUXADC_BUF_OUT_14_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_14_MASK, MT6351_PMIC_AUXADC_BUF_OUT_14_SHIFT},
	{PMIC_AUXADC_BUF_RDY_14, MT6351_PMIC_AUXADC_BUF_RDY_14_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_14_MASK, MT6351_PMIC_AUXADC_BUF_RDY_14_SHIFT},
	{PMIC_AUXADC_BUF_OUT_15, MT6351_PMIC_AUXADC_BUF_OUT_15_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_15_MASK, MT6351_PMIC_AUXADC_BUF_OUT_15_SHIFT},
	{PMIC_AUXADC_BUF_RDY_15, MT6351_PMIC_AUXADC_BUF_RDY_15_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_15_MASK, MT6351_PMIC_AUXADC_BUF_RDY_15_SHIFT},
	{PMIC_AUXADC_BUF_OUT_16, MT6351_PMIC_AUXADC_BUF_OUT_16_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_16_MASK, MT6351_PMIC_AUXADC_BUF_OUT_16_SHIFT},
	{PMIC_AUXADC_BUF_RDY_16, MT6351_PMIC_AUXADC_BUF_RDY_16_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_16_MASK, MT6351_PMIC_AUXADC_BUF_RDY_16_SHIFT},
	{PMIC_AUXADC_BUF_OUT_17, MT6351_PMIC_AUXADC_BUF_OUT_17_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_17_MASK, MT6351_PMIC_AUXADC_BUF_OUT_17_SHIFT},
	{PMIC_AUXADC_BUF_RDY_17, MT6351_PMIC_AUXADC_BUF_RDY_17_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_17_MASK, MT6351_PMIC_AUXADC_BUF_RDY_17_SHIFT},
	{PMIC_AUXADC_BUF_OUT_18, MT6351_PMIC_AUXADC_BUF_OUT_18_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_18_MASK, MT6351_PMIC_AUXADC_BUF_OUT_18_SHIFT},
	{PMIC_AUXADC_BUF_RDY_18, MT6351_PMIC_AUXADC_BUF_RDY_18_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_18_MASK, MT6351_PMIC_AUXADC_BUF_RDY_18_SHIFT},
	{PMIC_AUXADC_BUF_OUT_19, MT6351_PMIC_AUXADC_BUF_OUT_19_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_19_MASK, MT6351_PMIC_AUXADC_BUF_OUT_19_SHIFT},
	{PMIC_AUXADC_BUF_RDY_19, MT6351_PMIC_AUXADC_BUF_RDY_19_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_19_MASK, MT6351_PMIC_AUXADC_BUF_RDY_19_SHIFT},
	{PMIC_AUXADC_BUF_OUT_20, MT6351_PMIC_AUXADC_BUF_OUT_20_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_20_MASK, MT6351_PMIC_AUXADC_BUF_OUT_20_SHIFT},
	{PMIC_AUXADC_BUF_RDY_20, MT6351_PMIC_AUXADC_BUF_RDY_20_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_20_MASK, MT6351_PMIC_AUXADC_BUF_RDY_20_SHIFT},
	{PMIC_AUXADC_BUF_OUT_21, MT6351_PMIC_AUXADC_BUF_OUT_21_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_21_MASK, MT6351_PMIC_AUXADC_BUF_OUT_21_SHIFT},
	{PMIC_AUXADC_BUF_RDY_21, MT6351_PMIC_AUXADC_BUF_RDY_21_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_21_MASK, MT6351_PMIC_AUXADC_BUF_RDY_21_SHIFT},
	{PMIC_AUXADC_BUF_OUT_22, MT6351_PMIC_AUXADC_BUF_OUT_22_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_22_MASK, MT6351_PMIC_AUXADC_BUF_OUT_22_SHIFT},
	{PMIC_AUXADC_BUF_RDY_22, MT6351_PMIC_AUXADC_BUF_RDY_22_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_22_MASK, MT6351_PMIC_AUXADC_BUF_RDY_22_SHIFT},
	{PMIC_AUXADC_BUF_OUT_23, MT6351_PMIC_AUXADC_BUF_OUT_23_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_23_MASK, MT6351_PMIC_AUXADC_BUF_OUT_23_SHIFT},
	{PMIC_AUXADC_BUF_RDY_23, MT6351_PMIC_AUXADC_BUF_RDY_23_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_23_MASK, MT6351_PMIC_AUXADC_BUF_RDY_23_SHIFT},
	{PMIC_AUXADC_BUF_OUT_24, MT6351_PMIC_AUXADC_BUF_OUT_24_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_24_MASK, MT6351_PMIC_AUXADC_BUF_OUT_24_SHIFT},
	{PMIC_AUXADC_BUF_RDY_24, MT6351_PMIC_AUXADC_BUF_RDY_24_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_24_MASK, MT6351_PMIC_AUXADC_BUF_RDY_24_SHIFT},
	{PMIC_AUXADC_BUF_OUT_25, MT6351_PMIC_AUXADC_BUF_OUT_25_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_25_MASK, MT6351_PMIC_AUXADC_BUF_OUT_25_SHIFT},
	{PMIC_AUXADC_BUF_RDY_25, MT6351_PMIC_AUXADC_BUF_RDY_25_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_25_MASK, MT6351_PMIC_AUXADC_BUF_RDY_25_SHIFT},
	{PMIC_AUXADC_BUF_OUT_26, MT6351_PMIC_AUXADC_BUF_OUT_26_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_26_MASK, MT6351_PMIC_AUXADC_BUF_OUT_26_SHIFT},
	{PMIC_AUXADC_BUF_RDY_26, MT6351_PMIC_AUXADC_BUF_RDY_26_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_26_MASK, MT6351_PMIC_AUXADC_BUF_RDY_26_SHIFT},
	{PMIC_AUXADC_BUF_OUT_27, MT6351_PMIC_AUXADC_BUF_OUT_27_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_27_MASK, MT6351_PMIC_AUXADC_BUF_OUT_27_SHIFT},
	{PMIC_AUXADC_BUF_RDY_27, MT6351_PMIC_AUXADC_BUF_RDY_27_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_27_MASK, MT6351_PMIC_AUXADC_BUF_RDY_27_SHIFT},
	{PMIC_AUXADC_BUF_OUT_28, MT6351_PMIC_AUXADC_BUF_OUT_28_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_28_MASK, MT6351_PMIC_AUXADC_BUF_OUT_28_SHIFT},
	{PMIC_AUXADC_BUF_RDY_28, MT6351_PMIC_AUXADC_BUF_RDY_28_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_28_MASK, MT6351_PMIC_AUXADC_BUF_RDY_28_SHIFT},
	{PMIC_AUXADC_BUF_OUT_29, MT6351_PMIC_AUXADC_BUF_OUT_29_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_29_MASK, MT6351_PMIC_AUXADC_BUF_OUT_29_SHIFT},
	{PMIC_AUXADC_BUF_RDY_29, MT6351_PMIC_AUXADC_BUF_RDY_29_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_29_MASK, MT6351_PMIC_AUXADC_BUF_RDY_29_SHIFT},
	{PMIC_AUXADC_BUF_OUT_30, MT6351_PMIC_AUXADC_BUF_OUT_30_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_30_MASK, MT6351_PMIC_AUXADC_BUF_OUT_30_SHIFT},
	{PMIC_AUXADC_BUF_RDY_30, MT6351_PMIC_AUXADC_BUF_RDY_30_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_30_MASK, MT6351_PMIC_AUXADC_BUF_RDY_30_SHIFT},
	{PMIC_AUXADC_BUF_OUT_31, MT6351_PMIC_AUXADC_BUF_OUT_31_ADDR,
	 MT6351_PMIC_AUXADC_BUF_OUT_31_MASK, MT6351_PMIC_AUXADC_BUF_OUT_31_SHIFT},
	{PMIC_AUXADC_BUF_RDY_31, MT6351_PMIC_AUXADC_BUF_RDY_31_ADDR,
	 MT6351_PMIC_AUXADC_BUF_RDY_31_MASK, MT6351_PMIC_AUXADC_BUF_RDY_31_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN, MT6351_PMIC_AUXADC_ADC_BUSY_IN_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_LBAT, MT6351_PMIC_AUXADC_ADC_BUSY_IN_LBAT_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_LBAT_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_LBAT_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_LBAT2, MT6351_PMIC_AUXADC_ADC_BUSY_IN_LBAT2_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_LBAT2_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_LBAT2_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_VISMPS0, MT6351_PMIC_AUXADC_ADC_BUSY_IN_VISMPS0_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_VISMPS0_MASK,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_VISMPS0_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_WAKEUP, MT6351_PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT, MT6351_PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT_MASK,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP_MASK,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD_MASK,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS, MT6351_PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MASK,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_JEITA, MT6351_PMIC_AUXADC_ADC_BUSY_IN_JEITA_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_JEITA_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_JEITA_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_MDRT, MT6351_PMIC_AUXADC_ADC_BUSY_IN_MDRT_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_MDRT_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_MDRT_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_MDBG, MT6351_PMIC_AUXADC_ADC_BUSY_IN_MDBG_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_MDBG_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_MDBG_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_SHARE, MT6351_PMIC_AUXADC_ADC_BUSY_IN_SHARE_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_SHARE_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_SHARE_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_IMP, MT6351_PMIC_AUXADC_ADC_BUSY_IN_IMP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_IMP_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_IMP_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_FGADC1, MT6351_PMIC_AUXADC_ADC_BUSY_IN_FGADC1_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_FGADC1_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_FGADC1_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_FGADC2, MT6351_PMIC_AUXADC_ADC_BUSY_IN_FGADC2_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_FGADC2_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_FGADC2_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_GPS_AP, MT6351_PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_GPS_MD, MT6351_PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_GPS, MT6351_PMIC_AUXADC_ADC_BUSY_IN_GPS_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_GPS_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_GPS_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_THR_HW, MT6351_PMIC_AUXADC_ADC_BUSY_IN_THR_HW_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_THR_HW_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_THR_HW_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_THR_MD, MT6351_PMIC_AUXADC_ADC_BUSY_IN_THR_MD_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_THR_MD_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_THR_MD_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_NAG, MT6351_PMIC_AUXADC_ADC_BUSY_IN_NAG_ADDR,
	 MT6351_PMIC_AUXADC_ADC_BUSY_IN_NAG_MASK, MT6351_PMIC_AUXADC_ADC_BUSY_IN_NAG_SHIFT},
	{PMIC_AUXADC_RQST_CH0, MT6351_PMIC_AUXADC_RQST_CH0_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH0_MASK, MT6351_PMIC_AUXADC_RQST_CH0_SHIFT},
	{PMIC_AUXADC_RQST_CH1, MT6351_PMIC_AUXADC_RQST_CH1_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH1_MASK, MT6351_PMIC_AUXADC_RQST_CH1_SHIFT},
	{PMIC_AUXADC_RQST_CH2, MT6351_PMIC_AUXADC_RQST_CH2_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH2_MASK, MT6351_PMIC_AUXADC_RQST_CH2_SHIFT},
	{PMIC_AUXADC_RQST_CH3, MT6351_PMIC_AUXADC_RQST_CH3_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH3_MASK, MT6351_PMIC_AUXADC_RQST_CH3_SHIFT},
	{PMIC_AUXADC_RQST_CH4, MT6351_PMIC_AUXADC_RQST_CH4_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH4_MASK, MT6351_PMIC_AUXADC_RQST_CH4_SHIFT},
	{PMIC_AUXADC_RQST_CH5, MT6351_PMIC_AUXADC_RQST_CH5_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH5_MASK, MT6351_PMIC_AUXADC_RQST_CH5_SHIFT},
	{PMIC_AUXADC_RQST_CH6, MT6351_PMIC_AUXADC_RQST_CH6_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH6_MASK, MT6351_PMIC_AUXADC_RQST_CH6_SHIFT},
	{PMIC_AUXADC_RQST_CH7, MT6351_PMIC_AUXADC_RQST_CH7_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH7_MASK, MT6351_PMIC_AUXADC_RQST_CH7_SHIFT},
	{PMIC_AUXADC_RQST_CH8, MT6351_PMIC_AUXADC_RQST_CH8_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH8_MASK, MT6351_PMIC_AUXADC_RQST_CH8_SHIFT},
	{PMIC_AUXADC_RQST_CH9, MT6351_PMIC_AUXADC_RQST_CH9_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH9_MASK, MT6351_PMIC_AUXADC_RQST_CH9_SHIFT},
	{PMIC_AUXADC_RQST_CH10, MT6351_PMIC_AUXADC_RQST_CH10_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH10_MASK, MT6351_PMIC_AUXADC_RQST_CH10_SHIFT},
	{PMIC_AUXADC_RQST_CH11, MT6351_PMIC_AUXADC_RQST_CH11_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH11_MASK, MT6351_PMIC_AUXADC_RQST_CH11_SHIFT},
	{PMIC_AUXADC_RQST_CH12, MT6351_PMIC_AUXADC_RQST_CH12_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH12_MASK, MT6351_PMIC_AUXADC_RQST_CH12_SHIFT},
	{PMIC_AUXADC_RQST_CH13, MT6351_PMIC_AUXADC_RQST_CH13_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH13_MASK, MT6351_PMIC_AUXADC_RQST_CH13_SHIFT},
	{PMIC_AUXADC_RQST_CH14, MT6351_PMIC_AUXADC_RQST_CH14_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH14_MASK, MT6351_PMIC_AUXADC_RQST_CH14_SHIFT},
	{PMIC_AUXADC_RQST_CH15, MT6351_PMIC_AUXADC_RQST_CH15_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH15_MASK, MT6351_PMIC_AUXADC_RQST_CH15_SHIFT},
	{PMIC_AUXADC_RQST0_SET, MT6351_PMIC_AUXADC_RQST0_SET_ADDR,
	 MT6351_PMIC_AUXADC_RQST0_SET_MASK, MT6351_PMIC_AUXADC_RQST0_SET_SHIFT},
	{PMIC_AUXADC_RQST0_CLR, MT6351_PMIC_AUXADC_RQST0_CLR_ADDR,
	 MT6351_PMIC_AUXADC_RQST0_CLR_MASK, MT6351_PMIC_AUXADC_RQST0_CLR_SHIFT},
	{PMIC_AUXADC_RQST_CH0_BY_MD, MT6351_PMIC_AUXADC_RQST_CH0_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH0_BY_MD_MASK, MT6351_PMIC_AUXADC_RQST_CH0_BY_MD_SHIFT},
	{PMIC_AUXADC_RQST_CH1_BY_MD, MT6351_PMIC_AUXADC_RQST_CH1_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH1_BY_MD_MASK, MT6351_PMIC_AUXADC_RQST_CH1_BY_MD_SHIFT},
	{PMIC_AUXADC_RQST_RSV0, MT6351_PMIC_AUXADC_RQST_RSV0_ADDR,
	 MT6351_PMIC_AUXADC_RQST_RSV0_MASK, MT6351_PMIC_AUXADC_RQST_RSV0_SHIFT},
	{PMIC_AUXADC_RQST_CH4_BY_MD, MT6351_PMIC_AUXADC_RQST_CH4_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH4_BY_MD_MASK, MT6351_PMIC_AUXADC_RQST_CH4_BY_MD_SHIFT},
	{PMIC_AUXADC_RQST_CH7_BY_MD, MT6351_PMIC_AUXADC_RQST_CH7_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH7_BY_MD_MASK, MT6351_PMIC_AUXADC_RQST_CH7_BY_MD_SHIFT},
	{PMIC_AUXADC_RQST_CH7_BY_GPS, MT6351_PMIC_AUXADC_RQST_CH7_BY_GPS_ADDR,
	 MT6351_PMIC_AUXADC_RQST_CH7_BY_GPS_MASK, MT6351_PMIC_AUXADC_RQST_CH7_BY_GPS_SHIFT},
	{PMIC_AUXADC_RQST_DCXO_BY_MD, MT6351_PMIC_AUXADC_RQST_DCXO_BY_MD_ADDR,
	 MT6351_PMIC_AUXADC_RQST_DCXO_BY_MD_MASK, MT6351_PMIC_AUXADC_RQST_DCXO_BY_MD_SHIFT},
	{PMIC_AUXADC_RQST_DCXO_BY_GPS, MT6351_PMIC_AUXADC_RQST_DCXO_BY_GPS_ADDR,
	 MT6351_PMIC_AUXADC_RQST_DCXO_BY_GPS_MASK, MT6351_PMIC_AUXADC_RQST_DCXO_BY_GPS_SHIFT},
	{PMIC_AUXADC_RQST_RSV1, MT6351_PMIC_AUXADC_RQST_RSV1_ADDR,
	 MT6351_PMIC_AUXADC_RQST_RSV1_MASK, MT6351_PMIC_AUXADC_RQST_RSV1_SHIFT},
	{PMIC_AUXADC_RQST1_SET, MT6351_PMIC_AUXADC_RQST1_SET_ADDR,
	 MT6351_PMIC_AUXADC_RQST1_SET_MASK, MT6351_PMIC_AUXADC_RQST1_SET_SHIFT},
	{PMIC_AUXADC_RQST1_CLR, MT6351_PMIC_AUXADC_RQST1_CLR_ADDR,
	 MT6351_PMIC_AUXADC_RQST1_CLR_MASK, MT6351_PMIC_AUXADC_RQST1_CLR_SHIFT},
	{PMIC_AUXADC_CK_ON_EXTD, MT6351_PMIC_AUXADC_CK_ON_EXTD_ADDR,
	 MT6351_PMIC_AUXADC_CK_ON_EXTD_MASK, MT6351_PMIC_AUXADC_CK_ON_EXTD_SHIFT},
	{PMIC_AUXADC_SRCLKEN_SRC_SEL, MT6351_PMIC_AUXADC_SRCLKEN_SRC_SEL_ADDR,
	 MT6351_PMIC_AUXADC_SRCLKEN_SRC_SEL_MASK, MT6351_PMIC_AUXADC_SRCLKEN_SRC_SEL_SHIFT},
	{PMIC_AUXADC_ADC_PWDB, MT6351_PMIC_AUXADC_ADC_PWDB_ADDR,
	 MT6351_PMIC_AUXADC_ADC_PWDB_MASK, MT6351_PMIC_AUXADC_ADC_PWDB_SHIFT},
	{PMIC_AUXADC_ADC_PWDB_SWCTRL, MT6351_PMIC_AUXADC_ADC_PWDB_SWCTRL_ADDR,
	 MT6351_PMIC_AUXADC_ADC_PWDB_SWCTRL_MASK, MT6351_PMIC_AUXADC_ADC_PWDB_SWCTRL_SHIFT},
	{PMIC_AUXADC_STRUP_CK_ON_ENB, MT6351_PMIC_AUXADC_STRUP_CK_ON_ENB_ADDR,
	 MT6351_PMIC_AUXADC_STRUP_CK_ON_ENB_MASK, MT6351_PMIC_AUXADC_STRUP_CK_ON_ENB_SHIFT},
	{PMIC_AUXADC_ADC_RDY_WAKEUP_CLR, MT6351_PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_ADDR,
	 MT6351_PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_MASK, MT6351_PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_SHIFT},
	{PMIC_AUXADC_SRCLKEN_CK_EN, MT6351_PMIC_AUXADC_SRCLKEN_CK_EN_ADDR,
	 MT6351_PMIC_AUXADC_SRCLKEN_CK_EN_MASK, MT6351_PMIC_AUXADC_SRCLKEN_CK_EN_SHIFT},
	{PMIC_AUXADC_CK_AON_GPS, MT6351_PMIC_AUXADC_CK_AON_GPS_ADDR,
	 MT6351_PMIC_AUXADC_CK_AON_GPS_MASK, MT6351_PMIC_AUXADC_CK_AON_GPS_SHIFT},
	{PMIC_AUXADC_CK_AON_MD, MT6351_PMIC_AUXADC_CK_AON_MD_ADDR,
	 MT6351_PMIC_AUXADC_CK_AON_MD_MASK, MT6351_PMIC_AUXADC_CK_AON_MD_SHIFT},
	{PMIC_AUXADC_CK_AON, MT6351_PMIC_AUXADC_CK_AON_ADDR,
	 MT6351_PMIC_AUXADC_CK_AON_MASK, MT6351_PMIC_AUXADC_CK_AON_SHIFT},
	{PMIC_AUXADC_CON0_SET, MT6351_PMIC_AUXADC_CON0_SET_ADDR,
	 MT6351_PMIC_AUXADC_CON0_SET_MASK, MT6351_PMIC_AUXADC_CON0_SET_SHIFT},
	{PMIC_AUXADC_CON0_CLR, MT6351_PMIC_AUXADC_CON0_CLR_ADDR,
	 MT6351_PMIC_AUXADC_CON0_CLR_MASK, MT6351_PMIC_AUXADC_CON0_CLR_SHIFT},
	{PMIC_AUXADC_AVG_NUM_SMALL, MT6351_PMIC_AUXADC_AVG_NUM_SMALL_ADDR,
	 MT6351_PMIC_AUXADC_AVG_NUM_SMALL_MASK, MT6351_PMIC_AUXADC_AVG_NUM_SMALL_SHIFT},
	{PMIC_AUXADC_AVG_NUM_LARGE, MT6351_PMIC_AUXADC_AVG_NUM_LARGE_ADDR,
	 MT6351_PMIC_AUXADC_AVG_NUM_LARGE_MASK, MT6351_PMIC_AUXADC_AVG_NUM_LARGE_SHIFT},
	{PMIC_AUXADC_SPL_NUM, MT6351_PMIC_AUXADC_SPL_NUM_ADDR,
	 MT6351_PMIC_AUXADC_SPL_NUM_MASK, MT6351_PMIC_AUXADC_SPL_NUM_SHIFT},
	{PMIC_AUXADC_AVG_NUM_SEL, MT6351_PMIC_AUXADC_AVG_NUM_SEL_ADDR,
	 MT6351_PMIC_AUXADC_AVG_NUM_SEL_MASK, MT6351_PMIC_AUXADC_AVG_NUM_SEL_SHIFT},
	{PMIC_AUXADC_AVG_NUM_SEL_SHARE, MT6351_PMIC_AUXADC_AVG_NUM_SEL_SHARE_ADDR,
	 MT6351_PMIC_AUXADC_AVG_NUM_SEL_SHARE_MASK, MT6351_PMIC_AUXADC_AVG_NUM_SEL_SHARE_SHIFT},
	{PMIC_AUXADC_AVG_NUM_SEL_LBAT, MT6351_PMIC_AUXADC_AVG_NUM_SEL_LBAT_ADDR,
	 MT6351_PMIC_AUXADC_AVG_NUM_SEL_LBAT_MASK, MT6351_PMIC_AUXADC_AVG_NUM_SEL_LBAT_SHIFT},
	{PMIC_AUXADC_AVG_NUM_SEL_VISMPS, MT6351_PMIC_AUXADC_AVG_NUM_SEL_VISMPS_ADDR,
	 MT6351_PMIC_AUXADC_AVG_NUM_SEL_VISMPS_MASK, MT6351_PMIC_AUXADC_AVG_NUM_SEL_VISMPS_SHIFT},
	{PMIC_AUXADC_AVG_NUM_SEL_WAKEUP, MT6351_PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_ADDR,
	 MT6351_PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_MASK, MT6351_PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_SHIFT},
	{PMIC_AUXADC_SPL_NUM_LARGE, MT6351_PMIC_AUXADC_SPL_NUM_LARGE_ADDR,
	 MT6351_PMIC_AUXADC_SPL_NUM_LARGE_MASK, MT6351_PMIC_AUXADC_SPL_NUM_LARGE_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SLEEP, MT6351_PMIC_AUXADC_SPL_NUM_SLEEP_ADDR,
	 MT6351_PMIC_AUXADC_SPL_NUM_SLEEP_MASK, MT6351_PMIC_AUXADC_SPL_NUM_SLEEP_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SLEEP_SEL, MT6351_PMIC_AUXADC_SPL_NUM_SLEEP_SEL_ADDR,
	 MT6351_PMIC_AUXADC_SPL_NUM_SLEEP_SEL_MASK, MT6351_PMIC_AUXADC_SPL_NUM_SLEEP_SEL_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SEL, MT6351_PMIC_AUXADC_SPL_NUM_SEL_ADDR,
	 MT6351_PMIC_AUXADC_SPL_NUM_SEL_MASK, MT6351_PMIC_AUXADC_SPL_NUM_SEL_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SEL_SHARE, MT6351_PMIC_AUXADC_SPL_NUM_SEL_SHARE_ADDR,
	 MT6351_PMIC_AUXADC_SPL_NUM_SEL_SHARE_MASK, MT6351_PMIC_AUXADC_SPL_NUM_SEL_SHARE_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SEL_LBAT, MT6351_PMIC_AUXADC_SPL_NUM_SEL_LBAT_ADDR,
	 MT6351_PMIC_AUXADC_SPL_NUM_SEL_LBAT_MASK, MT6351_PMIC_AUXADC_SPL_NUM_SEL_LBAT_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SEL_VISMPS, MT6351_PMIC_AUXADC_SPL_NUM_SEL_VISMPS_ADDR,
	 MT6351_PMIC_AUXADC_SPL_NUM_SEL_VISMPS_MASK, MT6351_PMIC_AUXADC_SPL_NUM_SEL_VISMPS_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SEL_WAKEUP, MT6351_PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_ADDR,
	 MT6351_PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_MASK, MT6351_PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_SHIFT},
	{PMIC_AUXADC_TRIM_CH0_SEL, MT6351_PMIC_AUXADC_TRIM_CH0_SEL_ADDR,
	 MT6351_PMIC_AUXADC_TRIM_CH0_SEL_MASK, MT6351_PMIC_AUXADC_TRIM_CH0_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH1_SEL, MT6351_PMIC_AUXADC_TRIM_CH1_SEL_ADDR,
	 MT6351_PMIC_AUXADC_TRIM_CH1_SEL_MASK, MT6351_PMIC_AUXADC_TRIM_CH1_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH2_SEL, MT6351_PMIC_AUXADC_TRIM_CH2_SEL_ADDR,
	 MT6351_PMIC_AUXADC_TRIM_CH2_SEL_MASK, MT6351_PMIC_AUXADC_TRIM_CH2_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH3_SEL, MT6351_PMIC_AUXADC_TRIM_CH3_SEL_ADDR,
	 MT6351_PMIC_AUXADC_TRIM_CH3_SEL_MASK, MT6351_PMIC_AUXADC_TRIM_CH3_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH4_SEL, MT6351_PMIC_AUXADC_TRIM_CH4_SEL_ADDR,
	 MT6351_PMIC_AUXADC_TRIM_CH4_SEL_MASK, MT6351_PMIC_AUXADC_TRIM_CH4_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH5_SEL, MT6351_PMIC_AUXADC_TRIM_CH5_SEL_ADDR,
	 MT6351_PMIC_AUXADC_TRIM_CH5_SEL_MASK, MT6351_PMIC_AUXADC_TRIM_CH5_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH6_SEL, MT6351_PMIC_AUXADC_TRIM_CH6_SEL_ADDR,
	 MT6351_PMIC_AUXADC_TRIM_CH6_SEL_MASK, MT6351_PMIC_AUXADC_TRIM_CH6_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH7_SEL, MT6351_PMIC_AUXADC_TRIM_CH7_SEL_ADDR,
	 MT6351_PMIC_AUXADC_TRIM_CH7_SEL_MASK, MT6351_PMIC_AUXADC_TRIM_CH7_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH8_SEL, MT6351_PMIC_AUXADC_TRIM_CH8_SEL_ADDR,
	 MT6351_PMIC_AUXADC_TRIM_CH8_SEL_MASK, MT6351_PMIC_AUXADC_TRIM_CH8_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH9_SEL, MT6351_PMIC_AUXADC_TRIM_CH9_SEL_ADDR,
	 MT6351_PMIC_AUXADC_TRIM_CH9_SEL_MASK, MT6351_PMIC_AUXADC_TRIM_CH9_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH10_SEL, MT6351_PMIC_AUXADC_TRIM_CH10_SEL_ADDR,
	 MT6351_PMIC_AUXADC_TRIM_CH10_SEL_MASK, MT6351_PMIC_AUXADC_TRIM_CH10_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH11_SEL, MT6351_PMIC_AUXADC_TRIM_CH11_SEL_ADDR,
	 MT6351_PMIC_AUXADC_TRIM_CH11_SEL_MASK, MT6351_PMIC_AUXADC_TRIM_CH11_SEL_SHIFT},
	{PMIC_AUXADC_ADC_2S_COMP_ENB, MT6351_PMIC_AUXADC_ADC_2S_COMP_ENB_ADDR,
	 MT6351_PMIC_AUXADC_ADC_2S_COMP_ENB_MASK, MT6351_PMIC_AUXADC_ADC_2S_COMP_ENB_SHIFT},
	{PMIC_AUXADC_ADC_TRIM_COMP, MT6351_PMIC_AUXADC_ADC_TRIM_COMP_ADDR,
	 MT6351_PMIC_AUXADC_ADC_TRIM_COMP_MASK, MT6351_PMIC_AUXADC_ADC_TRIM_COMP_SHIFT},
	{PMIC_AUXADC_SW_GAIN_TRIM, MT6351_PMIC_AUXADC_SW_GAIN_TRIM_ADDR,
	 MT6351_PMIC_AUXADC_SW_GAIN_TRIM_MASK, MT6351_PMIC_AUXADC_SW_GAIN_TRIM_SHIFT},
	{PMIC_AUXADC_SW_OFFSET_TRIM, MT6351_PMIC_AUXADC_SW_OFFSET_TRIM_ADDR,
	 MT6351_PMIC_AUXADC_SW_OFFSET_TRIM_MASK, MT6351_PMIC_AUXADC_SW_OFFSET_TRIM_SHIFT},
	{PMIC_AUXADC_RNG_EN, MT6351_PMIC_AUXADC_RNG_EN_ADDR,
	 MT6351_PMIC_AUXADC_RNG_EN_MASK, MT6351_PMIC_AUXADC_RNG_EN_SHIFT},
	{PMIC_AUXADC_DATA_REUSE_SEL, MT6351_PMIC_AUXADC_DATA_REUSE_SEL_ADDR,
	 MT6351_PMIC_AUXADC_DATA_REUSE_SEL_MASK, MT6351_PMIC_AUXADC_DATA_REUSE_SEL_SHIFT},
	{PMIC_AUXADC_TEST_MODE, MT6351_PMIC_AUXADC_TEST_MODE_ADDR,
	 MT6351_PMIC_AUXADC_TEST_MODE_MASK, MT6351_PMIC_AUXADC_TEST_MODE_SHIFT},
	{PMIC_AUXADC_BIT_SEL, MT6351_PMIC_AUXADC_BIT_SEL_ADDR,
	 MT6351_PMIC_AUXADC_BIT_SEL_MASK, MT6351_PMIC_AUXADC_BIT_SEL_SHIFT},
	{PMIC_AUXADC_START_SW, MT6351_PMIC_AUXADC_START_SW_ADDR,
	 MT6351_PMIC_AUXADC_START_SW_MASK, MT6351_PMIC_AUXADC_START_SW_SHIFT},
	{PMIC_AUXADC_START_SWCTRL, MT6351_PMIC_AUXADC_START_SWCTRL_ADDR,
	 MT6351_PMIC_AUXADC_START_SWCTRL_MASK, MT6351_PMIC_AUXADC_START_SWCTRL_SHIFT},
	{PMIC_AUXADC_TS_VBE_SEL, MT6351_PMIC_AUXADC_TS_VBE_SEL_ADDR,
	 MT6351_PMIC_AUXADC_TS_VBE_SEL_MASK, MT6351_PMIC_AUXADC_TS_VBE_SEL_SHIFT},
	{PMIC_AUXADC_TS_VBE_SEL_SWCTRL, MT6351_PMIC_AUXADC_TS_VBE_SEL_SWCTRL_ADDR,
	 MT6351_PMIC_AUXADC_TS_VBE_SEL_SWCTRL_MASK, MT6351_PMIC_AUXADC_TS_VBE_SEL_SWCTRL_SHIFT},
	{PMIC_AUXADC_VBUF_EN, MT6351_PMIC_AUXADC_VBUF_EN_ADDR,
	 MT6351_PMIC_AUXADC_VBUF_EN_MASK, MT6351_PMIC_AUXADC_VBUF_EN_SHIFT},
	{PMIC_AUXADC_VBUF_EN_SWCTRL, MT6351_PMIC_AUXADC_VBUF_EN_SWCTRL_ADDR,
	 MT6351_PMIC_AUXADC_VBUF_EN_SWCTRL_MASK, MT6351_PMIC_AUXADC_VBUF_EN_SWCTRL_SHIFT},
	{PMIC_AUXADC_OUT_SEL, MT6351_PMIC_AUXADC_OUT_SEL_ADDR,
	 MT6351_PMIC_AUXADC_OUT_SEL_MASK, MT6351_PMIC_AUXADC_OUT_SEL_SHIFT},
	{PMIC_AUXADC_DA_DAC, MT6351_PMIC_AUXADC_DA_DAC_ADDR,
	 MT6351_PMIC_AUXADC_DA_DAC_MASK, MT6351_PMIC_AUXADC_DA_DAC_SHIFT},
	{PMIC_AUXADC_DA_DAC_SWCTRL, MT6351_PMIC_AUXADC_DA_DAC_SWCTRL_ADDR,
	 MT6351_PMIC_AUXADC_DA_DAC_SWCTRL_MASK, MT6351_PMIC_AUXADC_DA_DAC_SWCTRL_SHIFT},
	{PMIC_AD_AUXADC_COMP, MT6351_PMIC_AD_AUXADC_COMP_ADDR,
	 MT6351_PMIC_AD_AUXADC_COMP_MASK, MT6351_PMIC_AD_AUXADC_COMP_SHIFT},
	{PMIC_RG_VBUF_EXTEN, MT6351_PMIC_RG_VBUF_EXTEN_ADDR,
	 MT6351_PMIC_RG_VBUF_EXTEN_MASK, MT6351_PMIC_RG_VBUF_EXTEN_SHIFT},
	{PMIC_RG_VBUF_CALEN, MT6351_PMIC_RG_VBUF_CALEN_ADDR,
	 MT6351_PMIC_RG_VBUF_CALEN_MASK, MT6351_PMIC_RG_VBUF_CALEN_SHIFT},
	{PMIC_RG_VBUF_BYP, MT6351_PMIC_RG_VBUF_BYP_ADDR, MT6351_PMIC_RG_VBUF_BYP_MASK,
	 MT6351_PMIC_RG_VBUF_BYP_SHIFT},
	{PMIC_RG_AUX_RSV, MT6351_PMIC_RG_AUX_RSV_ADDR, MT6351_PMIC_RG_AUX_RSV_MASK,
	 MT6351_PMIC_RG_AUX_RSV_SHIFT},
	{PMIC_RG_AUXADC_CALI, MT6351_PMIC_RG_AUXADC_CALI_ADDR,
	 MT6351_PMIC_RG_AUXADC_CALI_MASK, MT6351_PMIC_RG_AUXADC_CALI_SHIFT},
	{PMIC_AUXADC_ADCIN_VSEN_EN, MT6351_PMIC_AUXADC_ADCIN_VSEN_EN_ADDR,
	 MT6351_PMIC_AUXADC_ADCIN_VSEN_EN_MASK, MT6351_PMIC_AUXADC_ADCIN_VSEN_EN_SHIFT},
	{PMIC_AUXADC_ADCIN_VBAT_EN, MT6351_PMIC_AUXADC_ADCIN_VBAT_EN_ADDR,
	 MT6351_PMIC_AUXADC_ADCIN_VBAT_EN_MASK, MT6351_PMIC_AUXADC_ADCIN_VBAT_EN_SHIFT},
	{PMIC_AUXADC_ADCIN_VSEN_MUX_EN, MT6351_PMIC_AUXADC_ADCIN_VSEN_MUX_EN_ADDR,
	 MT6351_PMIC_AUXADC_ADCIN_VSEN_MUX_EN_MASK, MT6351_PMIC_AUXADC_ADCIN_VSEN_MUX_EN_SHIFT},
	{PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN,
	 MT6351_PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_ADDR,
	 MT6351_PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_MASK,
	 MT6351_PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_SHIFT},
	{PMIC_AUXADC_ADCIN_CHR_EN, MT6351_PMIC_AUXADC_ADCIN_CHR_EN_ADDR,
	 MT6351_PMIC_AUXADC_ADCIN_CHR_EN_MASK, MT6351_PMIC_AUXADC_ADCIN_CHR_EN_SHIFT},
	{PMIC_AUXADC_ADCIN_BATON_TDET_EN, MT6351_PMIC_AUXADC_ADCIN_BATON_TDET_EN_ADDR,
	 MT6351_PMIC_AUXADC_ADCIN_BATON_TDET_EN_MASK,
	 MT6351_PMIC_AUXADC_ADCIN_BATON_TDET_EN_SHIFT},
	{PMIC_AUXADC_ACCDET_ANASWCTRL_EN, MT6351_PMIC_AUXADC_ACCDET_ANASWCTRL_EN_ADDR,
	 MT6351_PMIC_AUXADC_ACCDET_ANASWCTRL_EN_MASK,
	 MT6351_PMIC_AUXADC_ACCDET_ANASWCTRL_EN_SHIFT},
	{PMIC_AUXADC_DIG0_RSV0, MT6351_PMIC_AUXADC_DIG0_RSV0_ADDR,
	 MT6351_PMIC_AUXADC_DIG0_RSV0_MASK, MT6351_PMIC_AUXADC_DIG0_RSV0_SHIFT},
	{PMIC_AUXADC_CHSEL, MT6351_PMIC_AUXADC_CHSEL_ADDR, MT6351_PMIC_AUXADC_CHSEL_MASK,
	 MT6351_PMIC_AUXADC_CHSEL_SHIFT},
	{PMIC_AUXADC_SWCTRL_EN, MT6351_PMIC_AUXADC_SWCTRL_EN_ADDR,
	 MT6351_PMIC_AUXADC_SWCTRL_EN_MASK, MT6351_PMIC_AUXADC_SWCTRL_EN_SHIFT},
	{PMIC_AUXADC_SOURCE_LBAT_SEL, MT6351_PMIC_AUXADC_SOURCE_LBAT_SEL_ADDR,
	 MT6351_PMIC_AUXADC_SOURCE_LBAT_SEL_MASK, MT6351_PMIC_AUXADC_SOURCE_LBAT_SEL_SHIFT},
	{PMIC_AUXADC_SOURCE_LBAT2_SEL, MT6351_PMIC_AUXADC_SOURCE_LBAT2_SEL_ADDR,
	 MT6351_PMIC_AUXADC_SOURCE_LBAT2_SEL_MASK, MT6351_PMIC_AUXADC_SOURCE_LBAT2_SEL_SHIFT},
	{PMIC_AUXADC_DIG0_RSV2, MT6351_PMIC_AUXADC_DIG0_RSV2_ADDR,
	 MT6351_PMIC_AUXADC_DIG0_RSV2_MASK, MT6351_PMIC_AUXADC_DIG0_RSV2_SHIFT},
	{PMIC_AUXADC_DIG1_RSV2, MT6351_PMIC_AUXADC_DIG1_RSV2_ADDR,
	 MT6351_PMIC_AUXADC_DIG1_RSV2_MASK, MT6351_PMIC_AUXADC_DIG1_RSV2_SHIFT},
	{PMIC_AUXADC_DAC_EXTD, MT6351_PMIC_AUXADC_DAC_EXTD_ADDR,
	 MT6351_PMIC_AUXADC_DAC_EXTD_MASK, MT6351_PMIC_AUXADC_DAC_EXTD_SHIFT},
	{PMIC_AUXADC_DAC_EXTD_EN, MT6351_PMIC_AUXADC_DAC_EXTD_EN_ADDR,
	 MT6351_PMIC_AUXADC_DAC_EXTD_EN_MASK, MT6351_PMIC_AUXADC_DAC_EXTD_EN_SHIFT},
	{PMIC_AUXADC_PMU_THR_PDN_SW, MT6351_PMIC_AUXADC_PMU_THR_PDN_SW_ADDR,
	 MT6351_PMIC_AUXADC_PMU_THR_PDN_SW_MASK, MT6351_PMIC_AUXADC_PMU_THR_PDN_SW_SHIFT},
	{PMIC_AUXADC_PMU_THR_PDN_SEL, MT6351_PMIC_AUXADC_PMU_THR_PDN_SEL_ADDR,
	 MT6351_PMIC_AUXADC_PMU_THR_PDN_SEL_MASK, MT6351_PMIC_AUXADC_PMU_THR_PDN_SEL_SHIFT},
	{PMIC_AUXADC_PMU_THR_PDN_STATUS, MT6351_PMIC_AUXADC_PMU_THR_PDN_STATUS_ADDR,
	 MT6351_PMIC_AUXADC_PMU_THR_PDN_STATUS_MASK, MT6351_PMIC_AUXADC_PMU_THR_PDN_STATUS_SHIFT},
	{PMIC_AUXADC_DIG0_RSV1, MT6351_PMIC_AUXADC_DIG0_RSV1_ADDR,
	 MT6351_PMIC_AUXADC_DIG0_RSV1_MASK, MT6351_PMIC_AUXADC_DIG0_RSV1_SHIFT},
	{PMIC_AUXADC_START_SHADE_NUM, MT6351_PMIC_AUXADC_START_SHADE_NUM_ADDR,
	 MT6351_PMIC_AUXADC_START_SHADE_NUM_MASK, MT6351_PMIC_AUXADC_START_SHADE_NUM_SHIFT},
	{PMIC_AUXADC_START_SHADE_EN, MT6351_PMIC_AUXADC_START_SHADE_EN_ADDR,
	 MT6351_PMIC_AUXADC_START_SHADE_EN_MASK, MT6351_PMIC_AUXADC_START_SHADE_EN_SHIFT},
	{PMIC_AUXADC_START_SHADE_SEL, MT6351_PMIC_AUXADC_START_SHADE_SEL_ADDR,
	 MT6351_PMIC_AUXADC_START_SHADE_SEL_MASK, MT6351_PMIC_AUXADC_START_SHADE_SEL_SHIFT},
	{PMIC_AUXADC_AUTORPT_PRD, MT6351_PMIC_AUXADC_AUTORPT_PRD_ADDR,
	 MT6351_PMIC_AUXADC_AUTORPT_PRD_MASK, MT6351_PMIC_AUXADC_AUTORPT_PRD_SHIFT},
	{PMIC_AUXADC_AUTORPT_EN, MT6351_PMIC_AUXADC_AUTORPT_EN_ADDR,
	 MT6351_PMIC_AUXADC_AUTORPT_EN_MASK, MT6351_PMIC_AUXADC_AUTORPT_EN_SHIFT},
	{PMIC_AUXADC_LBAT_DEBT_MAX, MT6351_PMIC_AUXADC_LBAT_DEBT_MAX_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_DEBT_MAX_MASK, MT6351_PMIC_AUXADC_LBAT_DEBT_MAX_SHIFT},
	{PMIC_AUXADC_LBAT_DEBT_MIN, MT6351_PMIC_AUXADC_LBAT_DEBT_MIN_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_DEBT_MIN_MASK, MT6351_PMIC_AUXADC_LBAT_DEBT_MIN_SHIFT},
	{PMIC_AUXADC_LBAT_DET_PRD_15_0, MT6351_PMIC_AUXADC_LBAT_DET_PRD_15_0_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_DET_PRD_15_0_MASK, MT6351_PMIC_AUXADC_LBAT_DET_PRD_15_0_SHIFT},
	{PMIC_AUXADC_LBAT_DET_PRD_19_16, MT6351_PMIC_AUXADC_LBAT_DET_PRD_19_16_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_DET_PRD_19_16_MASK, MT6351_PMIC_AUXADC_LBAT_DET_PRD_19_16_SHIFT},
	{PMIC_AUXADC_LBAT_VOLT_MAX, MT6351_PMIC_AUXADC_LBAT_VOLT_MAX_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_VOLT_MAX_MASK, MT6351_PMIC_AUXADC_LBAT_VOLT_MAX_SHIFT},
	{PMIC_AUXADC_LBAT_IRQ_EN_MAX, MT6351_PMIC_AUXADC_LBAT_IRQ_EN_MAX_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_IRQ_EN_MAX_MASK, MT6351_PMIC_AUXADC_LBAT_IRQ_EN_MAX_SHIFT},
	{PMIC_AUXADC_LBAT_EN_MAX, MT6351_PMIC_AUXADC_LBAT_EN_MAX_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_EN_MAX_MASK, MT6351_PMIC_AUXADC_LBAT_EN_MAX_SHIFT},
	{PMIC_AUXADC_LBAT_MAX_IRQ_B, MT6351_PMIC_AUXADC_LBAT_MAX_IRQ_B_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_MAX_IRQ_B_MASK, MT6351_PMIC_AUXADC_LBAT_MAX_IRQ_B_SHIFT},
	{PMIC_AUXADC_LBAT_VOLT_MIN, MT6351_PMIC_AUXADC_LBAT_VOLT_MIN_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_VOLT_MIN_MASK, MT6351_PMIC_AUXADC_LBAT_VOLT_MIN_SHIFT},
	{PMIC_AUXADC_LBAT_IRQ_EN_MIN, MT6351_PMIC_AUXADC_LBAT_IRQ_EN_MIN_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_IRQ_EN_MIN_MASK, MT6351_PMIC_AUXADC_LBAT_IRQ_EN_MIN_SHIFT},
	{PMIC_AUXADC_LBAT_EN_MIN, MT6351_PMIC_AUXADC_LBAT_EN_MIN_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_EN_MIN_MASK, MT6351_PMIC_AUXADC_LBAT_EN_MIN_SHIFT},
	{PMIC_AUXADC_LBAT_MIN_IRQ_B, MT6351_PMIC_AUXADC_LBAT_MIN_IRQ_B_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_MIN_IRQ_B_MASK, MT6351_PMIC_AUXADC_LBAT_MIN_IRQ_B_SHIFT},
	{PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX,
	 MT6351_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_MASK,
	 MT6351_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_SHIFT},
	{PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN,
	 MT6351_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_ADDR,
	 MT6351_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_MASK,
	 MT6351_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_SHIFT},
	{PMIC_AUXADC_ACCDET_AUTO_SPL, MT6351_PMIC_AUXADC_ACCDET_AUTO_SPL_ADDR,
	 MT6351_PMIC_AUXADC_ACCDET_AUTO_SPL_MASK, MT6351_PMIC_AUXADC_ACCDET_AUTO_SPL_SHIFT},
	{PMIC_AUXADC_ACCDET_AUTO_RQST_CLR, MT6351_PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_ADDR,
	 MT6351_PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_MASK,
	 MT6351_PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_SHIFT},
	{PMIC_AUXADC_ACCDET_DIG1_RSV0, MT6351_PMIC_AUXADC_ACCDET_DIG1_RSV0_ADDR,
	 MT6351_PMIC_AUXADC_ACCDET_DIG1_RSV0_MASK, MT6351_PMIC_AUXADC_ACCDET_DIG1_RSV0_SHIFT},
	{PMIC_AUXADC_ACCDET_DIG0_RSV0, MT6351_PMIC_AUXADC_ACCDET_DIG0_RSV0_ADDR,
	 MT6351_PMIC_AUXADC_ACCDET_DIG0_RSV0_MASK, MT6351_PMIC_AUXADC_ACCDET_DIG0_RSV0_SHIFT},
	{PMIC_AUXADC_THR_DEBT_MAX, MT6351_PMIC_AUXADC_THR_DEBT_MAX_ADDR,
	 MT6351_PMIC_AUXADC_THR_DEBT_MAX_MASK, MT6351_PMIC_AUXADC_THR_DEBT_MAX_SHIFT},
	{PMIC_AUXADC_THR_DEBT_MIN, MT6351_PMIC_AUXADC_THR_DEBT_MIN_ADDR,
	 MT6351_PMIC_AUXADC_THR_DEBT_MIN_MASK, MT6351_PMIC_AUXADC_THR_DEBT_MIN_SHIFT},
	{PMIC_AUXADC_THR_DET_PRD_15_0, MT6351_PMIC_AUXADC_THR_DET_PRD_15_0_ADDR,
	 MT6351_PMIC_AUXADC_THR_DET_PRD_15_0_MASK, MT6351_PMIC_AUXADC_THR_DET_PRD_15_0_SHIFT},
	{PMIC_AUXADC_THR_DET_PRD_19_16, MT6351_PMIC_AUXADC_THR_DET_PRD_19_16_ADDR,
	 MT6351_PMIC_AUXADC_THR_DET_PRD_19_16_MASK, MT6351_PMIC_AUXADC_THR_DET_PRD_19_16_SHIFT},
	{PMIC_AUXADC_THR_VOLT_MAX, MT6351_PMIC_AUXADC_THR_VOLT_MAX_ADDR,
	 MT6351_PMIC_AUXADC_THR_VOLT_MAX_MASK, MT6351_PMIC_AUXADC_THR_VOLT_MAX_SHIFT},
	{PMIC_AUXADC_THR_IRQ_EN_MAX, MT6351_PMIC_AUXADC_THR_IRQ_EN_MAX_ADDR,
	 MT6351_PMIC_AUXADC_THR_IRQ_EN_MAX_MASK, MT6351_PMIC_AUXADC_THR_IRQ_EN_MAX_SHIFT},
	{PMIC_AUXADC_THR_EN_MAX, MT6351_PMIC_AUXADC_THR_EN_MAX_ADDR,
	 MT6351_PMIC_AUXADC_THR_EN_MAX_MASK, MT6351_PMIC_AUXADC_THR_EN_MAX_SHIFT},
	{PMIC_AUXADC_THR_MAX_IRQ_B, MT6351_PMIC_AUXADC_THR_MAX_IRQ_B_ADDR,
	 MT6351_PMIC_AUXADC_THR_MAX_IRQ_B_MASK, MT6351_PMIC_AUXADC_THR_MAX_IRQ_B_SHIFT},
	{PMIC_AUXADC_THR_VOLT_MIN, MT6351_PMIC_AUXADC_THR_VOLT_MIN_ADDR,
	 MT6351_PMIC_AUXADC_THR_VOLT_MIN_MASK, MT6351_PMIC_AUXADC_THR_VOLT_MIN_SHIFT},
	{PMIC_AUXADC_THR_IRQ_EN_MIN, MT6351_PMIC_AUXADC_THR_IRQ_EN_MIN_ADDR,
	 MT6351_PMIC_AUXADC_THR_IRQ_EN_MIN_MASK, MT6351_PMIC_AUXADC_THR_IRQ_EN_MIN_SHIFT},
	{PMIC_AUXADC_THR_EN_MIN, MT6351_PMIC_AUXADC_THR_EN_MIN_ADDR,
	 MT6351_PMIC_AUXADC_THR_EN_MIN_MASK, MT6351_PMIC_AUXADC_THR_EN_MIN_SHIFT},
	{PMIC_AUXADC_THR_MIN_IRQ_B, MT6351_PMIC_AUXADC_THR_MIN_IRQ_B_ADDR,
	 MT6351_PMIC_AUXADC_THR_MIN_IRQ_B_MASK, MT6351_PMIC_AUXADC_THR_MIN_IRQ_B_SHIFT},
	{PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX,
	 MT6351_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_ADDR,
	 MT6351_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_MASK,
	 MT6351_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_SHIFT},
	{PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN,
	 MT6351_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_ADDR,
	 MT6351_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_MASK,
	 MT6351_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_SHIFT},
	{PMIC_EFUSE_GAIN_CH4_TRIM, MT6351_PMIC_EFUSE_GAIN_CH4_TRIM_ADDR,
	 MT6351_PMIC_EFUSE_GAIN_CH4_TRIM_MASK, MT6351_PMIC_EFUSE_GAIN_CH4_TRIM_SHIFT},
	{PMIC_EFUSE_OFFSET_CH4_TRIM, MT6351_PMIC_EFUSE_OFFSET_CH4_TRIM_ADDR,
	 MT6351_PMIC_EFUSE_OFFSET_CH4_TRIM_MASK, MT6351_PMIC_EFUSE_OFFSET_CH4_TRIM_SHIFT},
	{PMIC_EFUSE_GAIN_CH0_TRIM, MT6351_PMIC_EFUSE_GAIN_CH0_TRIM_ADDR,
	 MT6351_PMIC_EFUSE_GAIN_CH0_TRIM_MASK, MT6351_PMIC_EFUSE_GAIN_CH0_TRIM_SHIFT},
	{PMIC_EFUSE_OFFSET_CH0_TRIM, MT6351_PMIC_EFUSE_OFFSET_CH0_TRIM_ADDR,
	 MT6351_PMIC_EFUSE_OFFSET_CH0_TRIM_MASK, MT6351_PMIC_EFUSE_OFFSET_CH0_TRIM_SHIFT},
	{PMIC_EFUSE_GAIN_CH7_TRIM, MT6351_PMIC_EFUSE_GAIN_CH7_TRIM_ADDR,
	 MT6351_PMIC_EFUSE_GAIN_CH7_TRIM_MASK, MT6351_PMIC_EFUSE_GAIN_CH7_TRIM_SHIFT},
	{PMIC_EFUSE_OFFSET_CH7_TRIM, MT6351_PMIC_EFUSE_OFFSET_CH7_TRIM_ADDR,
	 MT6351_PMIC_EFUSE_OFFSET_CH7_TRIM_MASK, MT6351_PMIC_EFUSE_OFFSET_CH7_TRIM_SHIFT},
	{PMIC_AUXADC_FGADC_START_SW, MT6351_PMIC_AUXADC_FGADC_START_SW_ADDR,
	 MT6351_PMIC_AUXADC_FGADC_START_SW_MASK, MT6351_PMIC_AUXADC_FGADC_START_SW_SHIFT},
	{PMIC_AUXADC_FGADC_START_SEL, MT6351_PMIC_AUXADC_FGADC_START_SEL_ADDR,
	 MT6351_PMIC_AUXADC_FGADC_START_SEL_MASK, MT6351_PMIC_AUXADC_FGADC_START_SEL_SHIFT},
	{PMIC_AUXADC_FGADC_R_SW, MT6351_PMIC_AUXADC_FGADC_R_SW_ADDR,
	 MT6351_PMIC_AUXADC_FGADC_R_SW_MASK, MT6351_PMIC_AUXADC_FGADC_R_SW_SHIFT},
	{PMIC_AUXADC_FGADC_R_SEL, MT6351_PMIC_AUXADC_FGADC_R_SEL_ADDR,
	 MT6351_PMIC_AUXADC_FGADC_R_SEL_MASK, MT6351_PMIC_AUXADC_FGADC_R_SEL_SHIFT},
	{PMIC_AUXADC_DBG_DIG0_RSV2, MT6351_PMIC_AUXADC_DBG_DIG0_RSV2_ADDR,
	 MT6351_PMIC_AUXADC_DBG_DIG0_RSV2_MASK, MT6351_PMIC_AUXADC_DBG_DIG0_RSV2_SHIFT},
	{PMIC_AUXADC_DBG_DIG1_RSV2, MT6351_PMIC_AUXADC_DBG_DIG1_RSV2_ADDR,
	 MT6351_PMIC_AUXADC_DBG_DIG1_RSV2_MASK, MT6351_PMIC_AUXADC_DBG_DIG1_RSV2_SHIFT},
	{PMIC_AUXADC_IMPEDANCE_CNT, MT6351_PMIC_AUXADC_IMPEDANCE_CNT_ADDR,
	 MT6351_PMIC_AUXADC_IMPEDANCE_CNT_MASK, MT6351_PMIC_AUXADC_IMPEDANCE_CNT_SHIFT},
	{PMIC_AUXADC_IMPEDANCE_CHSEL, MT6351_PMIC_AUXADC_IMPEDANCE_CHSEL_ADDR,
	 MT6351_PMIC_AUXADC_IMPEDANCE_CHSEL_MASK, MT6351_PMIC_AUXADC_IMPEDANCE_CHSEL_SHIFT},
	{PMIC_AUXADC_IMPEDANCE_IRQ_CLR, MT6351_PMIC_AUXADC_IMPEDANCE_IRQ_CLR_ADDR,
	 MT6351_PMIC_AUXADC_IMPEDANCE_IRQ_CLR_MASK, MT6351_PMIC_AUXADC_IMPEDANCE_IRQ_CLR_SHIFT},
	{PMIC_AUXADC_IMPEDANCE_IRQ_STATUS, MT6351_PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_ADDR,
	 MT6351_PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_MASK,
	 MT6351_PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_SHIFT},
	{PMIC_AUXADC_CLR_IMP_CNT_STOP, MT6351_PMIC_AUXADC_CLR_IMP_CNT_STOP_ADDR,
	 MT6351_PMIC_AUXADC_CLR_IMP_CNT_STOP_MASK, MT6351_PMIC_AUXADC_CLR_IMP_CNT_STOP_SHIFT},
	{PMIC_AUXADC_IMPEDANCE_MODE, MT6351_PMIC_AUXADC_IMPEDANCE_MODE_ADDR,
	 MT6351_PMIC_AUXADC_IMPEDANCE_MODE_MASK, MT6351_PMIC_AUXADC_IMPEDANCE_MODE_SHIFT},
	{PMIC_AUXADC_IMP_AUTORPT_PRD, MT6351_PMIC_AUXADC_IMP_AUTORPT_PRD_ADDR,
	 MT6351_PMIC_AUXADC_IMP_AUTORPT_PRD_MASK, MT6351_PMIC_AUXADC_IMP_AUTORPT_PRD_SHIFT},
	{PMIC_AUXADC_IMP_AUTORPT_EN, MT6351_PMIC_AUXADC_IMP_AUTORPT_EN_ADDR,
	 MT6351_PMIC_AUXADC_IMP_AUTORPT_EN_MASK, MT6351_PMIC_AUXADC_IMP_AUTORPT_EN_SHIFT},
	{PMIC_AUXADC_VISMPS0_DEBT_MAX, MT6351_PMIC_AUXADC_VISMPS0_DEBT_MAX_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_DEBT_MAX_MASK, MT6351_PMIC_AUXADC_VISMPS0_DEBT_MAX_SHIFT},
	{PMIC_AUXADC_VISMPS0_DEBT_MIN, MT6351_PMIC_AUXADC_VISMPS0_DEBT_MIN_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_DEBT_MIN_MASK, MT6351_PMIC_AUXADC_VISMPS0_DEBT_MIN_SHIFT},
	{PMIC_AUXADC_VISMPS0_DET_PRD_15_0, MT6351_PMIC_AUXADC_VISMPS0_DET_PRD_15_0_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_DET_PRD_15_0_MASK,
	 MT6351_PMIC_AUXADC_VISMPS0_DET_PRD_15_0_SHIFT},
	{PMIC_AUXADC_VISMPS0_DET_PRD_19_16, MT6351_PMIC_AUXADC_VISMPS0_DET_PRD_19_16_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_DET_PRD_19_16_MASK,
	 MT6351_PMIC_AUXADC_VISMPS0_DET_PRD_19_16_SHIFT},
	{PMIC_AUXADC_VISMPS0_VOLT_MAX, MT6351_PMIC_AUXADC_VISMPS0_VOLT_MAX_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_VOLT_MAX_MASK, MT6351_PMIC_AUXADC_VISMPS0_VOLT_MAX_SHIFT},
	{PMIC_AUXADC_VISMPS0_IRQ_EN_MAX, MT6351_PMIC_AUXADC_VISMPS0_IRQ_EN_MAX_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_IRQ_EN_MAX_MASK, MT6351_PMIC_AUXADC_VISMPS0_IRQ_EN_MAX_SHIFT},
	{PMIC_AUXADC_VISMPS0_EN_MAX, MT6351_PMIC_AUXADC_VISMPS0_EN_MAX_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_EN_MAX_MASK, MT6351_PMIC_AUXADC_VISMPS0_EN_MAX_SHIFT},
	{PMIC_AUXADC_VISMPS0_MAX_IRQ_B, MT6351_PMIC_AUXADC_VISMPS0_MAX_IRQ_B_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_MAX_IRQ_B_MASK, MT6351_PMIC_AUXADC_VISMPS0_MAX_IRQ_B_SHIFT},
	{PMIC_AUXADC_VISMPS0_VOLT_MIN, MT6351_PMIC_AUXADC_VISMPS0_VOLT_MIN_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_VOLT_MIN_MASK, MT6351_PMIC_AUXADC_VISMPS0_VOLT_MIN_SHIFT},
	{PMIC_AUXADC_VISMPS0_IRQ_EN_MIN, MT6351_PMIC_AUXADC_VISMPS0_IRQ_EN_MIN_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_IRQ_EN_MIN_MASK, MT6351_PMIC_AUXADC_VISMPS0_IRQ_EN_MIN_SHIFT},
	{PMIC_AUXADC_VISMPS0_EN_MIN, MT6351_PMIC_AUXADC_VISMPS0_EN_MIN_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_EN_MIN_MASK, MT6351_PMIC_AUXADC_VISMPS0_EN_MIN_SHIFT},
	{PMIC_AUXADC_VISMPS0_MIN_IRQ_B, MT6351_PMIC_AUXADC_VISMPS0_MIN_IRQ_B_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_MIN_IRQ_B_MASK, MT6351_PMIC_AUXADC_VISMPS0_MIN_IRQ_B_SHIFT},
	{PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MAX,
	 MT6351_PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MAX_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MAX_MASK,
	 MT6351_PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MAX_SHIFT},
	{PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MIN,
	 MT6351_PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MIN_ADDR,
	 MT6351_PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MIN_MASK,
	 MT6351_PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MIN_SHIFT},
	{PMIC_AUXADC_LBAT2_DEBT_MAX, MT6351_PMIC_AUXADC_LBAT2_DEBT_MAX_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_DEBT_MAX_MASK, MT6351_PMIC_AUXADC_LBAT2_DEBT_MAX_SHIFT},
	{PMIC_AUXADC_LBAT2_DEBT_MIN, MT6351_PMIC_AUXADC_LBAT2_DEBT_MIN_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_DEBT_MIN_MASK, MT6351_PMIC_AUXADC_LBAT2_DEBT_MIN_SHIFT},
	{PMIC_AUXADC_LBAT2_DET_PRD_15_0, MT6351_PMIC_AUXADC_LBAT2_DET_PRD_15_0_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_DET_PRD_15_0_MASK, MT6351_PMIC_AUXADC_LBAT2_DET_PRD_15_0_SHIFT},
	{PMIC_AUXADC_LBAT2_DET_PRD_19_16, MT6351_PMIC_AUXADC_LBAT2_DET_PRD_19_16_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_DET_PRD_19_16_MASK,
	 MT6351_PMIC_AUXADC_LBAT2_DET_PRD_19_16_SHIFT},
	{PMIC_AUXADC_LBAT2_VOLT_MAX, MT6351_PMIC_AUXADC_LBAT2_VOLT_MAX_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_VOLT_MAX_MASK, MT6351_PMIC_AUXADC_LBAT2_VOLT_MAX_SHIFT},
	{PMIC_AUXADC_LBAT2_IRQ_EN_MAX, MT6351_PMIC_AUXADC_LBAT2_IRQ_EN_MAX_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_IRQ_EN_MAX_MASK, MT6351_PMIC_AUXADC_LBAT2_IRQ_EN_MAX_SHIFT},
	{PMIC_AUXADC_LBAT2_EN_MAX, MT6351_PMIC_AUXADC_LBAT2_EN_MAX_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_EN_MAX_MASK, MT6351_PMIC_AUXADC_LBAT2_EN_MAX_SHIFT},
	{PMIC_AUXADC_LBAT2_MAX_IRQ_B, MT6351_PMIC_AUXADC_LBAT2_MAX_IRQ_B_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_MAX_IRQ_B_MASK, MT6351_PMIC_AUXADC_LBAT2_MAX_IRQ_B_SHIFT},
	{PMIC_AUXADC_LBAT2_VOLT_MIN, MT6351_PMIC_AUXADC_LBAT2_VOLT_MIN_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_VOLT_MIN_MASK, MT6351_PMIC_AUXADC_LBAT2_VOLT_MIN_SHIFT},
	{PMIC_AUXADC_LBAT2_IRQ_EN_MIN, MT6351_PMIC_AUXADC_LBAT2_IRQ_EN_MIN_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_IRQ_EN_MIN_MASK, MT6351_PMIC_AUXADC_LBAT2_IRQ_EN_MIN_SHIFT},
	{PMIC_AUXADC_LBAT2_EN_MIN, MT6351_PMIC_AUXADC_LBAT2_EN_MIN_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_EN_MIN_MASK, MT6351_PMIC_AUXADC_LBAT2_EN_MIN_SHIFT},
	{PMIC_AUXADC_LBAT2_MIN_IRQ_B, MT6351_PMIC_AUXADC_LBAT2_MIN_IRQ_B_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_MIN_IRQ_B_MASK, MT6351_PMIC_AUXADC_LBAT2_MIN_IRQ_B_SHIFT},
	{PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX,
	 MT6351_PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_MASK,
	 MT6351_PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_SHIFT},
	{PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN,
	 MT6351_PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_ADDR,
	 MT6351_PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_MASK,
	 MT6351_PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_SHIFT},
	{PMIC_AUXADC_MDBG_DET_PRD, MT6351_PMIC_AUXADC_MDBG_DET_PRD_ADDR,
	 MT6351_PMIC_AUXADC_MDBG_DET_PRD_MASK, MT6351_PMIC_AUXADC_MDBG_DET_PRD_SHIFT},
	{PMIC_AUXADC_MDBG_DET_EN, MT6351_PMIC_AUXADC_MDBG_DET_EN_ADDR,
	 MT6351_PMIC_AUXADC_MDBG_DET_EN_MASK, MT6351_PMIC_AUXADC_MDBG_DET_EN_SHIFT},
	{PMIC_AUXADC_MDBG_R_PTR, MT6351_PMIC_AUXADC_MDBG_R_PTR_ADDR,
	 MT6351_PMIC_AUXADC_MDBG_R_PTR_MASK, MT6351_PMIC_AUXADC_MDBG_R_PTR_SHIFT},
	{PMIC_AUXADC_MDBG_W_PTR, MT6351_PMIC_AUXADC_MDBG_W_PTR_ADDR,
	 MT6351_PMIC_AUXADC_MDBG_W_PTR_MASK, MT6351_PMIC_AUXADC_MDBG_W_PTR_SHIFT},
	{PMIC_AUXADC_MDBG_BUF_LENGTH, MT6351_PMIC_AUXADC_MDBG_BUF_LENGTH_ADDR,
	 MT6351_PMIC_AUXADC_MDBG_BUF_LENGTH_MASK, MT6351_PMIC_AUXADC_MDBG_BUF_LENGTH_SHIFT},
	{PMIC_AUXADC_MDRT_DET_PRD, MT6351_PMIC_AUXADC_MDRT_DET_PRD_ADDR,
	 MT6351_PMIC_AUXADC_MDRT_DET_PRD_MASK, MT6351_PMIC_AUXADC_MDRT_DET_PRD_SHIFT},
	{PMIC_AUXADC_MDRT_DET_EN, MT6351_PMIC_AUXADC_MDRT_DET_EN_ADDR,
	 MT6351_PMIC_AUXADC_MDRT_DET_EN_MASK, MT6351_PMIC_AUXADC_MDRT_DET_EN_SHIFT},
	{PMIC_AUXADC_MDRT_DET_WKUP_START_CNT,
	 MT6351_PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_ADDR,
	 MT6351_PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_MASK,
	 MT6351_PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_SHIFT},
	{PMIC_AUXADC_MDRT_DET_WKUP_START_CLR,
	 MT6351_PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_ADDR,
	 MT6351_PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_MASK,
	 MT6351_PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_SHIFT},
	{PMIC_AUXADC_MDRT_DET_WKUP_START, MT6351_PMIC_AUXADC_MDRT_DET_WKUP_START_ADDR,
	 MT6351_PMIC_AUXADC_MDRT_DET_WKUP_START_MASK,
	 MT6351_PMIC_AUXADC_MDRT_DET_WKUP_START_SHIFT},
	{PMIC_AUXADC_MDRT_DET_WKUP_START_SEL,
	 MT6351_PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_ADDR,
	 MT6351_PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_MASK,
	 MT6351_PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_SHIFT},
	{PMIC_AUXADC_MDRT_DET_WKUP_EN, MT6351_PMIC_AUXADC_MDRT_DET_WKUP_EN_ADDR,
	 MT6351_PMIC_AUXADC_MDRT_DET_WKUP_EN_MASK, MT6351_PMIC_AUXADC_MDRT_DET_WKUP_EN_SHIFT},
	{PMIC_AUXADC_MDRT_DET_SRCLKEN_IND, MT6351_PMIC_AUXADC_MDRT_DET_SRCLKEN_IND_ADDR,
	 MT6351_PMIC_AUXADC_MDRT_DET_SRCLKEN_IND_MASK,
	 MT6351_PMIC_AUXADC_MDRT_DET_SRCLKEN_IND_SHIFT},
	{PMIC_AUXADC_JEITA_IRQ_EN, MT6351_PMIC_AUXADC_JEITA_IRQ_EN_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_IRQ_EN_MASK, MT6351_PMIC_AUXADC_JEITA_IRQ_EN_SHIFT},
	{PMIC_AUXADC_JEITA_EN, MT6351_PMIC_AUXADC_JEITA_EN_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_EN_MASK, MT6351_PMIC_AUXADC_JEITA_EN_SHIFT},
	{PMIC_AUXADC_JEITA_DET_PRD, MT6351_PMIC_AUXADC_JEITA_DET_PRD_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_DET_PRD_MASK, MT6351_PMIC_AUXADC_JEITA_DET_PRD_SHIFT},
	{PMIC_AUXADC_JEITA_DEBT, MT6351_PMIC_AUXADC_JEITA_DEBT_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_DEBT_MASK, MT6351_PMIC_AUXADC_JEITA_DEBT_SHIFT},
	{PMIC_AUXADC_JEITA_MIPI_DIS, MT6351_PMIC_AUXADC_JEITA_MIPI_DIS_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_MIPI_DIS_MASK, MT6351_PMIC_AUXADC_JEITA_MIPI_DIS_SHIFT},
	{PMIC_AUXADC_JEITA_VOLT_HOT, MT6351_PMIC_AUXADC_JEITA_VOLT_HOT_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_VOLT_HOT_MASK, MT6351_PMIC_AUXADC_JEITA_VOLT_HOT_SHIFT},
	{PMIC_AUXADC_JEITA_HOT_IRQ, MT6351_PMIC_AUXADC_JEITA_HOT_IRQ_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_HOT_IRQ_MASK, MT6351_PMIC_AUXADC_JEITA_HOT_IRQ_SHIFT},
	{PMIC_AUXADC_JEITA_VOLT_WARM, MT6351_PMIC_AUXADC_JEITA_VOLT_WARM_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_VOLT_WARM_MASK, MT6351_PMIC_AUXADC_JEITA_VOLT_WARM_SHIFT},
	{PMIC_AUXADC_JEITA_WARM_IRQ, MT6351_PMIC_AUXADC_JEITA_WARM_IRQ_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_WARM_IRQ_MASK, MT6351_PMIC_AUXADC_JEITA_WARM_IRQ_SHIFT},
	{PMIC_AUXADC_JEITA_VOLT_COOL, MT6351_PMIC_AUXADC_JEITA_VOLT_COOL_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_VOLT_COOL_MASK, MT6351_PMIC_AUXADC_JEITA_VOLT_COOL_SHIFT},
	{PMIC_AUXADC_JEITA_COOL_IRQ, MT6351_PMIC_AUXADC_JEITA_COOL_IRQ_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_COOL_IRQ_MASK, MT6351_PMIC_AUXADC_JEITA_COOL_IRQ_SHIFT},
	{PMIC_AUXADC_JEITA_VOLT_COLD, MT6351_PMIC_AUXADC_JEITA_VOLT_COLD_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_VOLT_COLD_MASK, MT6351_PMIC_AUXADC_JEITA_VOLT_COLD_SHIFT},
	{PMIC_AUXADC_JEITA_COLD_IRQ, MT6351_PMIC_AUXADC_JEITA_COLD_IRQ_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_COLD_IRQ_MASK, MT6351_PMIC_AUXADC_JEITA_COLD_IRQ_SHIFT},
	{PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD,
	 MT6351_PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD_MASK,
	 MT6351_PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD_SHIFT},
	{PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL,
	 MT6351_PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL_MASK,
	 MT6351_PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL_SHIFT},
	{PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM,
	 MT6351_PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM_MASK,
	 MT6351_PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM_SHIFT},
	{PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT,
	 MT6351_PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT_ADDR,
	 MT6351_PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT_MASK,
	 MT6351_PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT_SHIFT},
	{PMIC_AUXADC_DCXO_MDRT_DET_PRD, MT6351_PMIC_AUXADC_DCXO_MDRT_DET_PRD_ADDR,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_PRD_MASK, MT6351_PMIC_AUXADC_DCXO_MDRT_DET_PRD_SHIFT},
	{PMIC_AUXADC_DCXO_MDRT_DET_EN, MT6351_PMIC_AUXADC_DCXO_MDRT_DET_EN_ADDR,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_EN_MASK, MT6351_PMIC_AUXADC_DCXO_MDRT_DET_EN_SHIFT},
	{PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT_ADDR,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT_MASK,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT_SHIFT},
	{PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR_ADDR,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR_MASK,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR_SHIFT},
	{PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN, MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN_ADDR,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN_MASK,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN_SHIFT},
	{PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL_ADDR,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL_MASK,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL_SHIFT},
	{PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_ADDR,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_MASK,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SHIFT},
	{PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND_ADDR,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND_MASK,
	 MT6351_PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND_SHIFT},
	{PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL, MT6351_PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL_ADDR,
	 MT6351_PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL_MASK,
	 MT6351_PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL_SHIFT},
	{PMIC_AUXADC_NAG_EN, MT6351_PMIC_AUXADC_NAG_EN_ADDR,
	 MT6351_PMIC_AUXADC_NAG_EN_MASK, MT6351_PMIC_AUXADC_NAG_EN_SHIFT},
	{PMIC_AUXADC_NAG_CLR, MT6351_PMIC_AUXADC_NAG_CLR_ADDR,
	 MT6351_PMIC_AUXADC_NAG_CLR_MASK, MT6351_PMIC_AUXADC_NAG_CLR_SHIFT},
	{PMIC_AUXADC_NAG_VBAT1_SEL, MT6351_PMIC_AUXADC_NAG_VBAT1_SEL_ADDR,
	 MT6351_PMIC_AUXADC_NAG_VBAT1_SEL_MASK, MT6351_PMIC_AUXADC_NAG_VBAT1_SEL_SHIFT},
	{PMIC_AUXADC_NAG_PRD, MT6351_PMIC_AUXADC_NAG_PRD_ADDR,
	 MT6351_PMIC_AUXADC_NAG_PRD_MASK, MT6351_PMIC_AUXADC_NAG_PRD_SHIFT},
	{PMIC_AUXADC_NAG_IRQ_EN, MT6351_PMIC_AUXADC_NAG_IRQ_EN_ADDR,
	 MT6351_PMIC_AUXADC_NAG_IRQ_EN_MASK, MT6351_PMIC_AUXADC_NAG_IRQ_EN_SHIFT},
	{PMIC_AUXADC_NAG_C_DLTV_IRQ, MT6351_PMIC_AUXADC_NAG_C_DLTV_IRQ_ADDR,
	 MT6351_PMIC_AUXADC_NAG_C_DLTV_IRQ_MASK, MT6351_PMIC_AUXADC_NAG_C_DLTV_IRQ_SHIFT},
	{PMIC_AUXADC_NAG_ZCV, MT6351_PMIC_AUXADC_NAG_ZCV_ADDR,
	 MT6351_PMIC_AUXADC_NAG_ZCV_MASK, MT6351_PMIC_AUXADC_NAG_ZCV_SHIFT},
	{PMIC_AUXADC_NAG_C_DLTV_TH_15_0, MT6351_PMIC_AUXADC_NAG_C_DLTV_TH_15_0_ADDR,
	 MT6351_PMIC_AUXADC_NAG_C_DLTV_TH_15_0_MASK, MT6351_PMIC_AUXADC_NAG_C_DLTV_TH_15_0_SHIFT},
	{PMIC_AUXADC_NAG_C_DLTV_TH_26_16, MT6351_PMIC_AUXADC_NAG_C_DLTV_TH_26_16_ADDR,
	 MT6351_PMIC_AUXADC_NAG_C_DLTV_TH_26_16_MASK,
	 MT6351_PMIC_AUXADC_NAG_C_DLTV_TH_26_16_SHIFT},
	{PMIC_AUXADC_NAG_CNT_15_0, MT6351_PMIC_AUXADC_NAG_CNT_15_0_ADDR,
	 MT6351_PMIC_AUXADC_NAG_CNT_15_0_MASK, MT6351_PMIC_AUXADC_NAG_CNT_15_0_SHIFT},
	{PMIC_AUXADC_NAG_CNT_25_16, MT6351_PMIC_AUXADC_NAG_CNT_25_16_ADDR,
	 MT6351_PMIC_AUXADC_NAG_CNT_25_16_MASK, MT6351_PMIC_AUXADC_NAG_CNT_25_16_SHIFT},
	{PMIC_AUXADC_NAG_DLTV, MT6351_PMIC_AUXADC_NAG_DLTV_ADDR,
	 MT6351_PMIC_AUXADC_NAG_DLTV_MASK, MT6351_PMIC_AUXADC_NAG_DLTV_SHIFT},
	{PMIC_AUXADC_NAG_C_DLTV_15_0, MT6351_PMIC_AUXADC_NAG_C_DLTV_15_0_ADDR,
	 MT6351_PMIC_AUXADC_NAG_C_DLTV_15_0_MASK, MT6351_PMIC_AUXADC_NAG_C_DLTV_15_0_SHIFT},
	{PMIC_AUXADC_NAG_C_DLTV_26_16, MT6351_PMIC_AUXADC_NAG_C_DLTV_26_16_ADDR,
	 MT6351_PMIC_AUXADC_NAG_C_DLTV_26_16_MASK, MT6351_PMIC_AUXADC_NAG_C_DLTV_26_16_SHIFT},
	{PMIC_AD_AUDACCDETCMPOC, MT6351_PMIC_AD_AUDACCDETCMPOC_ADDR,
	 MT6351_PMIC_AD_AUDACCDETCMPOC_MASK, MT6351_PMIC_AD_AUDACCDETCMPOC_SHIFT},
	{PMIC_RG_AUDACCDETANASWCTRLENB, MT6351_PMIC_RG_AUDACCDETANASWCTRLENB_ADDR,
	 MT6351_PMIC_RG_AUDACCDETANASWCTRLENB_MASK, MT6351_PMIC_RG_AUDACCDETANASWCTRLENB_SHIFT},
	{PMIC_RG_ACCDETSEL, MT6351_PMIC_RG_ACCDETSEL_ADDR, MT6351_PMIC_RG_ACCDETSEL_MASK,
	 MT6351_PMIC_RG_ACCDETSEL_SHIFT},
	{PMIC_RG_AUDACCDETSWCTRL, MT6351_PMIC_RG_AUDACCDETSWCTRL_ADDR,
	 MT6351_PMIC_RG_AUDACCDETSWCTRL_MASK, MT6351_PMIC_RG_AUDACCDETSWCTRL_SHIFT},
	{PMIC_RG_AUDACCDETTVDET, MT6351_PMIC_RG_AUDACCDETTVDET_ADDR,
	 MT6351_PMIC_RG_AUDACCDETTVDET_MASK, MT6351_PMIC_RG_AUDACCDETTVDET_SHIFT},
	{PMIC_AUDACCDETAUXADCSWCTRL, MT6351_PMIC_AUDACCDETAUXADCSWCTRL_ADDR,
	 MT6351_PMIC_AUDACCDETAUXADCSWCTRL_MASK, MT6351_PMIC_AUDACCDETAUXADCSWCTRL_SHIFT},
	{PMIC_AUDACCDETAUXADCSWCTRL_SEL, MT6351_PMIC_AUDACCDETAUXADCSWCTRL_SEL_ADDR,
	 MT6351_PMIC_AUDACCDETAUXADCSWCTRL_SEL_MASK, MT6351_PMIC_AUDACCDETAUXADCSWCTRL_SEL_SHIFT},
	{PMIC_RG_AUDACCDETRSV, MT6351_PMIC_RG_AUDACCDETRSV_ADDR,
	 MT6351_PMIC_RG_AUDACCDETRSV_MASK, MT6351_PMIC_RG_AUDACCDETRSV_SHIFT},
	{PMIC_ACCDET_EN, MT6351_PMIC_ACCDET_EN_ADDR, MT6351_PMIC_ACCDET_EN_MASK,
	 MT6351_PMIC_ACCDET_EN_SHIFT},
	{PMIC_ACCDET_SEQ_INIT, MT6351_PMIC_ACCDET_SEQ_INIT_ADDR,
	 MT6351_PMIC_ACCDET_SEQ_INIT_MASK, MT6351_PMIC_ACCDET_SEQ_INIT_SHIFT},
	{PMIC_ACCDET_EINTDET_EN, MT6351_PMIC_ACCDET_EINTDET_EN_ADDR,
	 MT6351_PMIC_ACCDET_EINTDET_EN_MASK, MT6351_PMIC_ACCDET_EINTDET_EN_SHIFT},
	{PMIC_ACCDET_EINT_SEQ_INIT, MT6351_PMIC_ACCDET_EINT_SEQ_INIT_ADDR,
	 MT6351_PMIC_ACCDET_EINT_SEQ_INIT_MASK, MT6351_PMIC_ACCDET_EINT_SEQ_INIT_SHIFT},
	{PMIC_ACCDET_NEGVDET_EN, MT6351_PMIC_ACCDET_NEGVDET_EN_ADDR,
	 MT6351_PMIC_ACCDET_NEGVDET_EN_MASK, MT6351_PMIC_ACCDET_NEGVDET_EN_SHIFT},
	{PMIC_ACCDET_NEGVDET_EN_CTRL, MT6351_PMIC_ACCDET_NEGVDET_EN_CTRL_ADDR,
	 MT6351_PMIC_ACCDET_NEGVDET_EN_CTRL_MASK, MT6351_PMIC_ACCDET_NEGVDET_EN_CTRL_SHIFT},
	{PMIC_ACCDET_ANASWCTRL_SEL, MT6351_PMIC_ACCDET_ANASWCTRL_SEL_ADDR,
	 MT6351_PMIC_ACCDET_ANASWCTRL_SEL_MASK, MT6351_PMIC_ACCDET_ANASWCTRL_SEL_SHIFT},
	{PMIC_ACCDET_CMP_PWM_EN, MT6351_PMIC_ACCDET_CMP_PWM_EN_ADDR,
	 MT6351_PMIC_ACCDET_CMP_PWM_EN_MASK, MT6351_PMIC_ACCDET_CMP_PWM_EN_SHIFT},
	{PMIC_ACCDET_VTH_PWM_EN, MT6351_PMIC_ACCDET_VTH_PWM_EN_ADDR,
	 MT6351_PMIC_ACCDET_VTH_PWM_EN_MASK, MT6351_PMIC_ACCDET_VTH_PWM_EN_SHIFT},
	{PMIC_ACCDET_MBIAS_PWM_EN, MT6351_PMIC_ACCDET_MBIAS_PWM_EN_ADDR,
	 MT6351_PMIC_ACCDET_MBIAS_PWM_EN_MASK, MT6351_PMIC_ACCDET_MBIAS_PWM_EN_SHIFT},
	{PMIC_ACCDET_EINT_PWM_EN, MT6351_PMIC_ACCDET_EINT_PWM_EN_ADDR,
	 MT6351_PMIC_ACCDET_EINT_PWM_EN_MASK, MT6351_PMIC_ACCDET_EINT_PWM_EN_SHIFT},
	{PMIC_ACCDET_CMP_PWM_IDLE, MT6351_PMIC_ACCDET_CMP_PWM_IDLE_ADDR,
	 MT6351_PMIC_ACCDET_CMP_PWM_IDLE_MASK, MT6351_PMIC_ACCDET_CMP_PWM_IDLE_SHIFT},
	{PMIC_ACCDET_VTH_PWM_IDLE, MT6351_PMIC_ACCDET_VTH_PWM_IDLE_ADDR,
	 MT6351_PMIC_ACCDET_VTH_PWM_IDLE_MASK, MT6351_PMIC_ACCDET_VTH_PWM_IDLE_SHIFT},
	{PMIC_ACCDET_MBIAS_PWM_IDLE, MT6351_PMIC_ACCDET_MBIAS_PWM_IDLE_ADDR,
	 MT6351_PMIC_ACCDET_MBIAS_PWM_IDLE_MASK, MT6351_PMIC_ACCDET_MBIAS_PWM_IDLE_SHIFT},
	{PMIC_ACCDET_EINT_PWM_IDLE, MT6351_PMIC_ACCDET_EINT_PWM_IDLE_ADDR,
	 MT6351_PMIC_ACCDET_EINT_PWM_IDLE_MASK, MT6351_PMIC_ACCDET_EINT_PWM_IDLE_SHIFT},
	{PMIC_ACCDET_PWM_WIDTH, MT6351_PMIC_ACCDET_PWM_WIDTH_ADDR,
	 MT6351_PMIC_ACCDET_PWM_WIDTH_MASK, MT6351_PMIC_ACCDET_PWM_WIDTH_SHIFT},
	{PMIC_ACCDET_PWM_THRESH, MT6351_PMIC_ACCDET_PWM_THRESH_ADDR,
	 MT6351_PMIC_ACCDET_PWM_THRESH_MASK, MT6351_PMIC_ACCDET_PWM_THRESH_SHIFT},
	{PMIC_ACCDET_RISE_DELAY, MT6351_PMIC_ACCDET_RISE_DELAY_ADDR,
	 MT6351_PMIC_ACCDET_RISE_DELAY_MASK, MT6351_PMIC_ACCDET_RISE_DELAY_SHIFT},
	{PMIC_ACCDET_FALL_DELAY, MT6351_PMIC_ACCDET_FALL_DELAY_ADDR,
	 MT6351_PMIC_ACCDET_FALL_DELAY_MASK, MT6351_PMIC_ACCDET_FALL_DELAY_SHIFT},
	{PMIC_ACCDET_DEBOUNCE0, MT6351_PMIC_ACCDET_DEBOUNCE0_ADDR,
	 MT6351_PMIC_ACCDET_DEBOUNCE0_MASK, MT6351_PMIC_ACCDET_DEBOUNCE0_SHIFT},
	{PMIC_ACCDET_DEBOUNCE1, MT6351_PMIC_ACCDET_DEBOUNCE1_ADDR,
	 MT6351_PMIC_ACCDET_DEBOUNCE1_MASK, MT6351_PMIC_ACCDET_DEBOUNCE1_SHIFT},
	{PMIC_ACCDET_DEBOUNCE2, MT6351_PMIC_ACCDET_DEBOUNCE2_ADDR,
	 MT6351_PMIC_ACCDET_DEBOUNCE2_MASK, MT6351_PMIC_ACCDET_DEBOUNCE2_SHIFT},
	{PMIC_ACCDET_DEBOUNCE3, MT6351_PMIC_ACCDET_DEBOUNCE3_ADDR,
	 MT6351_PMIC_ACCDET_DEBOUNCE3_MASK, MT6351_PMIC_ACCDET_DEBOUNCE3_SHIFT},
	{PMIC_ACCDET_DEBOUNCE4, MT6351_PMIC_ACCDET_DEBOUNCE4_ADDR,
	 MT6351_PMIC_ACCDET_DEBOUNCE4_MASK, MT6351_PMIC_ACCDET_DEBOUNCE4_SHIFT},
	{PMIC_ACCDET_IVAL_CUR_IN, MT6351_PMIC_ACCDET_IVAL_CUR_IN_ADDR,
	 MT6351_PMIC_ACCDET_IVAL_CUR_IN_MASK, MT6351_PMIC_ACCDET_IVAL_CUR_IN_SHIFT},
	{PMIC_ACCDET_EINT_IVAL_CUR_IN, MT6351_PMIC_ACCDET_EINT_IVAL_CUR_IN_ADDR,
	 MT6351_PMIC_ACCDET_EINT_IVAL_CUR_IN_MASK, MT6351_PMIC_ACCDET_EINT_IVAL_CUR_IN_SHIFT},
	{PMIC_ACCDET_IVAL_SAM_IN, MT6351_PMIC_ACCDET_IVAL_SAM_IN_ADDR,
	 MT6351_PMIC_ACCDET_IVAL_SAM_IN_MASK, MT6351_PMIC_ACCDET_IVAL_SAM_IN_SHIFT},
	{PMIC_ACCDET_EINT_IVAL_SAM_IN, MT6351_PMIC_ACCDET_EINT_IVAL_SAM_IN_ADDR,
	 MT6351_PMIC_ACCDET_EINT_IVAL_SAM_IN_MASK, MT6351_PMIC_ACCDET_EINT_IVAL_SAM_IN_SHIFT},
	{PMIC_ACCDET_IVAL_MEM_IN, MT6351_PMIC_ACCDET_IVAL_MEM_IN_ADDR,
	 MT6351_PMIC_ACCDET_IVAL_MEM_IN_MASK, MT6351_PMIC_ACCDET_IVAL_MEM_IN_SHIFT},
	{PMIC_ACCDET_EINT_IVAL_MEM_IN, MT6351_PMIC_ACCDET_EINT_IVAL_MEM_IN_ADDR,
	 MT6351_PMIC_ACCDET_EINT_IVAL_MEM_IN_MASK, MT6351_PMIC_ACCDET_EINT_IVAL_MEM_IN_SHIFT},
	{PMIC_ACCDET_EINT_IVAL_SEL, MT6351_PMIC_ACCDET_EINT_IVAL_SEL_ADDR,
	 MT6351_PMIC_ACCDET_EINT_IVAL_SEL_MASK, MT6351_PMIC_ACCDET_EINT_IVAL_SEL_SHIFT},
	{PMIC_ACCDET_IVAL_SEL, MT6351_PMIC_ACCDET_IVAL_SEL_ADDR,
	 MT6351_PMIC_ACCDET_IVAL_SEL_MASK, MT6351_PMIC_ACCDET_IVAL_SEL_SHIFT},
	{PMIC_ACCDET_IRQ, MT6351_PMIC_ACCDET_IRQ_ADDR, MT6351_PMIC_ACCDET_IRQ_MASK,
	 MT6351_PMIC_ACCDET_IRQ_SHIFT},
	{PMIC_ACCDET_NEGV_IRQ, MT6351_PMIC_ACCDET_NEGV_IRQ_ADDR,
	 MT6351_PMIC_ACCDET_NEGV_IRQ_MASK, MT6351_PMIC_ACCDET_NEGV_IRQ_SHIFT},
	{PMIC_ACCDET_EINT_IRQ, MT6351_PMIC_ACCDET_EINT_IRQ_ADDR,
	 MT6351_PMIC_ACCDET_EINT_IRQ_MASK, MT6351_PMIC_ACCDET_EINT_IRQ_SHIFT},
	{PMIC_ACCDET_IRQ_CLR, MT6351_PMIC_ACCDET_IRQ_CLR_ADDR,
	 MT6351_PMIC_ACCDET_IRQ_CLR_MASK, MT6351_PMIC_ACCDET_IRQ_CLR_SHIFT},
	{PMIC_ACCDET_NEGV_IRQ_CLR, MT6351_PMIC_ACCDET_NEGV_IRQ_CLR_ADDR,
	 MT6351_PMIC_ACCDET_NEGV_IRQ_CLR_MASK, MT6351_PMIC_ACCDET_NEGV_IRQ_CLR_SHIFT},
	{PMIC_ACCDET_EINT_IRQ_CLR, MT6351_PMIC_ACCDET_EINT_IRQ_CLR_ADDR,
	 MT6351_PMIC_ACCDET_EINT_IRQ_CLR_MASK, MT6351_PMIC_ACCDET_EINT_IRQ_CLR_SHIFT},
	{PMIC_ACCDET_EINT_IRQ_POLARITY, MT6351_PMIC_ACCDET_EINT_IRQ_POLARITY_ADDR,
	 MT6351_PMIC_ACCDET_EINT_IRQ_POLARITY_MASK, MT6351_PMIC_ACCDET_EINT_IRQ_POLARITY_SHIFT},
	{PMIC_ACCDET_TEST_MODE0, MT6351_PMIC_ACCDET_TEST_MODE0_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE0_MASK, MT6351_PMIC_ACCDET_TEST_MODE0_SHIFT},
	{PMIC_ACCDET_TEST_MODE1, MT6351_PMIC_ACCDET_TEST_MODE1_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE1_MASK, MT6351_PMIC_ACCDET_TEST_MODE1_SHIFT},
	{PMIC_ACCDET_TEST_MODE2, MT6351_PMIC_ACCDET_TEST_MODE2_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE2_MASK, MT6351_PMIC_ACCDET_TEST_MODE2_SHIFT},
	{PMIC_ACCDET_TEST_MODE3, MT6351_PMIC_ACCDET_TEST_MODE3_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE3_MASK, MT6351_PMIC_ACCDET_TEST_MODE3_SHIFT},
	{PMIC_ACCDET_TEST_MODE4, MT6351_PMIC_ACCDET_TEST_MODE4_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE4_MASK, MT6351_PMIC_ACCDET_TEST_MODE4_SHIFT},
	{PMIC_ACCDET_TEST_MODE5, MT6351_PMIC_ACCDET_TEST_MODE5_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE5_MASK, MT6351_PMIC_ACCDET_TEST_MODE5_SHIFT},
	{PMIC_ACCDET_PWM_SEL, MT6351_PMIC_ACCDET_PWM_SEL_ADDR,
	 MT6351_PMIC_ACCDET_PWM_SEL_MASK, MT6351_PMIC_ACCDET_PWM_SEL_SHIFT},
	{PMIC_ACCDET_IN_SW, MT6351_PMIC_ACCDET_IN_SW_ADDR, MT6351_PMIC_ACCDET_IN_SW_MASK,
	 MT6351_PMIC_ACCDET_IN_SW_SHIFT},
	{PMIC_ACCDET_CMP_EN_SW, MT6351_PMIC_ACCDET_CMP_EN_SW_ADDR,
	 MT6351_PMIC_ACCDET_CMP_EN_SW_MASK, MT6351_PMIC_ACCDET_CMP_EN_SW_SHIFT},
	{PMIC_ACCDET_VTH_EN_SW, MT6351_PMIC_ACCDET_VTH_EN_SW_ADDR,
	 MT6351_PMIC_ACCDET_VTH_EN_SW_MASK, MT6351_PMIC_ACCDET_VTH_EN_SW_SHIFT},
	{PMIC_ACCDET_MBIAS_EN_SW, MT6351_PMIC_ACCDET_MBIAS_EN_SW_ADDR,
	 MT6351_PMIC_ACCDET_MBIAS_EN_SW_MASK, MT6351_PMIC_ACCDET_MBIAS_EN_SW_SHIFT},
	{PMIC_ACCDET_PWM_EN_SW, MT6351_PMIC_ACCDET_PWM_EN_SW_ADDR,
	 MT6351_PMIC_ACCDET_PWM_EN_SW_MASK, MT6351_PMIC_ACCDET_PWM_EN_SW_SHIFT},
	{PMIC_ACCDET_IN, MT6351_PMIC_ACCDET_IN_ADDR, MT6351_PMIC_ACCDET_IN_MASK,
	 MT6351_PMIC_ACCDET_IN_SHIFT},
	{PMIC_ACCDET_CUR_IN, MT6351_PMIC_ACCDET_CUR_IN_ADDR,
	 MT6351_PMIC_ACCDET_CUR_IN_MASK, MT6351_PMIC_ACCDET_CUR_IN_SHIFT},
	{PMIC_ACCDET_SAM_IN, MT6351_PMIC_ACCDET_SAM_IN_ADDR,
	 MT6351_PMIC_ACCDET_SAM_IN_MASK, MT6351_PMIC_ACCDET_SAM_IN_SHIFT},
	{PMIC_ACCDET_MEM_IN, MT6351_PMIC_ACCDET_MEM_IN_ADDR,
	 MT6351_PMIC_ACCDET_MEM_IN_MASK, MT6351_PMIC_ACCDET_MEM_IN_SHIFT},
	{PMIC_ACCDET_STATE, MT6351_PMIC_ACCDET_STATE_ADDR, MT6351_PMIC_ACCDET_STATE_MASK,
	 MT6351_PMIC_ACCDET_STATE_SHIFT},
	{PMIC_ACCDET_MBIAS_CLK, MT6351_PMIC_ACCDET_MBIAS_CLK_ADDR,
	 MT6351_PMIC_ACCDET_MBIAS_CLK_MASK, MT6351_PMIC_ACCDET_MBIAS_CLK_SHIFT},
	{PMIC_ACCDET_VTH_CLK, MT6351_PMIC_ACCDET_VTH_CLK_ADDR,
	 MT6351_PMIC_ACCDET_VTH_CLK_MASK, MT6351_PMIC_ACCDET_VTH_CLK_SHIFT},
	{PMIC_ACCDET_CMP_CLK, MT6351_PMIC_ACCDET_CMP_CLK_ADDR,
	 MT6351_PMIC_ACCDET_CMP_CLK_MASK, MT6351_PMIC_ACCDET_CMP_CLK_SHIFT},
	{PMIC_DA_NI_AUDACCDETAUXADCSWCTRL, MT6351_PMIC_DA_NI_AUDACCDETAUXADCSWCTRL_ADDR,
	 MT6351_PMIC_DA_NI_AUDACCDETAUXADCSWCTRL_MASK,
	 MT6351_PMIC_DA_NI_AUDACCDETAUXADCSWCTRL_SHIFT},
	{PMIC_ACCDET_EINT_DEB_SEL, MT6351_PMIC_ACCDET_EINT_DEB_SEL_ADDR,
	 MT6351_PMIC_ACCDET_EINT_DEB_SEL_MASK, MT6351_PMIC_ACCDET_EINT_DEB_SEL_SHIFT},
	{PMIC_ACCDET_EINT_DEBOUNCE, MT6351_PMIC_ACCDET_EINT_DEBOUNCE_ADDR,
	 MT6351_PMIC_ACCDET_EINT_DEBOUNCE_MASK, MT6351_PMIC_ACCDET_EINT_DEBOUNCE_SHIFT},
	{PMIC_ACCDET_EINT_PWM_THRESH, MT6351_PMIC_ACCDET_EINT_PWM_THRESH_ADDR,
	 MT6351_PMIC_ACCDET_EINT_PWM_THRESH_MASK, MT6351_PMIC_ACCDET_EINT_PWM_THRESH_SHIFT},
	{PMIC_ACCDET_EINT_PWM_WIDTH, MT6351_PMIC_ACCDET_EINT_PWM_WIDTH_ADDR,
	 MT6351_PMIC_ACCDET_EINT_PWM_WIDTH_MASK, MT6351_PMIC_ACCDET_EINT_PWM_WIDTH_SHIFT},
	{PMIC_ACCDET_NEGV_THRESH, MT6351_PMIC_ACCDET_NEGV_THRESH_ADDR,
	 MT6351_PMIC_ACCDET_NEGV_THRESH_MASK, MT6351_PMIC_ACCDET_NEGV_THRESH_SHIFT},
	{PMIC_ACCDET_EINT_PWM_FALL_DELAY, MT6351_PMIC_ACCDET_EINT_PWM_FALL_DELAY_ADDR,
	 MT6351_PMIC_ACCDET_EINT_PWM_FALL_DELAY_MASK,
	 MT6351_PMIC_ACCDET_EINT_PWM_FALL_DELAY_SHIFT},
	{PMIC_ACCDET_EINT_PWM_RISE_DELAY, MT6351_PMIC_ACCDET_EINT_PWM_RISE_DELAY_ADDR,
	 MT6351_PMIC_ACCDET_EINT_PWM_RISE_DELAY_MASK,
	 MT6351_PMIC_ACCDET_EINT_PWM_RISE_DELAY_SHIFT},
	{PMIC_ACCDET_TEST_MODE13, MT6351_PMIC_ACCDET_TEST_MODE13_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE13_MASK, MT6351_PMIC_ACCDET_TEST_MODE13_SHIFT},
	{PMIC_ACCDET_TEST_MODE12, MT6351_PMIC_ACCDET_TEST_MODE12_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE12_MASK, MT6351_PMIC_ACCDET_TEST_MODE12_SHIFT},
	{PMIC_ACCDET_NVDETECTOUT_SW, MT6351_PMIC_ACCDET_NVDETECTOUT_SW_ADDR,
	 MT6351_PMIC_ACCDET_NVDETECTOUT_SW_MASK, MT6351_PMIC_ACCDET_NVDETECTOUT_SW_SHIFT},
	{PMIC_ACCDET_TEST_MODE11, MT6351_PMIC_ACCDET_TEST_MODE11_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE11_MASK, MT6351_PMIC_ACCDET_TEST_MODE11_SHIFT},
	{PMIC_ACCDET_TEST_MODE10, MT6351_PMIC_ACCDET_TEST_MODE10_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE10_MASK, MT6351_PMIC_ACCDET_TEST_MODE10_SHIFT},
	{PMIC_ACCDET_EINTCMPOUT_SW, MT6351_PMIC_ACCDET_EINTCMPOUT_SW_ADDR,
	 MT6351_PMIC_ACCDET_EINTCMPOUT_SW_MASK, MT6351_PMIC_ACCDET_EINTCMPOUT_SW_SHIFT},
	{PMIC_ACCDET_TEST_MODE9, MT6351_PMIC_ACCDET_TEST_MODE9_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE9_MASK, MT6351_PMIC_ACCDET_TEST_MODE9_SHIFT},
	{PMIC_ACCDET_TEST_MODE8, MT6351_PMIC_ACCDET_TEST_MODE8_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE8_MASK, MT6351_PMIC_ACCDET_TEST_MODE8_SHIFT},
	{PMIC_ACCDET_AUXADC_CTRL_SW, MT6351_PMIC_ACCDET_AUXADC_CTRL_SW_ADDR,
	 MT6351_PMIC_ACCDET_AUXADC_CTRL_SW_MASK, MT6351_PMIC_ACCDET_AUXADC_CTRL_SW_SHIFT},
	{PMIC_ACCDET_TEST_MODE7, MT6351_PMIC_ACCDET_TEST_MODE7_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE7_MASK, MT6351_PMIC_ACCDET_TEST_MODE7_SHIFT},
	{PMIC_ACCDET_TEST_MODE6, MT6351_PMIC_ACCDET_TEST_MODE6_ADDR,
	 MT6351_PMIC_ACCDET_TEST_MODE6_MASK, MT6351_PMIC_ACCDET_TEST_MODE6_SHIFT},
	{PMIC_ACCDET_EINTCMP_EN_SW, MT6351_PMIC_ACCDET_EINTCMP_EN_SW_ADDR,
	 MT6351_PMIC_ACCDET_EINTCMP_EN_SW_MASK, MT6351_PMIC_ACCDET_EINTCMP_EN_SW_SHIFT},
	{PMIC_ACCDET_EINT_STATE, MT6351_PMIC_ACCDET_EINT_STATE_ADDR,
	 MT6351_PMIC_ACCDET_EINT_STATE_MASK, MT6351_PMIC_ACCDET_EINT_STATE_SHIFT},
	{PMIC_ACCDET_AUXADC_DEBOUNCE_END, MT6351_PMIC_ACCDET_AUXADC_DEBOUNCE_END_ADDR,
	 MT6351_PMIC_ACCDET_AUXADC_DEBOUNCE_END_MASK,
	 MT6351_PMIC_ACCDET_AUXADC_DEBOUNCE_END_SHIFT},
	{PMIC_ACCDET_AUXADC_CONNECT_PRE, MT6351_PMIC_ACCDET_AUXADC_CONNECT_PRE_ADDR,
	 MT6351_PMIC_ACCDET_AUXADC_CONNECT_PRE_MASK, MT6351_PMIC_ACCDET_AUXADC_CONNECT_PRE_SHIFT},
	{PMIC_ACCDET_EINT_CUR_IN, MT6351_PMIC_ACCDET_EINT_CUR_IN_ADDR,
	 MT6351_PMIC_ACCDET_EINT_CUR_IN_MASK, MT6351_PMIC_ACCDET_EINT_CUR_IN_SHIFT},
	{PMIC_ACCDET_EINT_SAM_IN, MT6351_PMIC_ACCDET_EINT_SAM_IN_ADDR,
	 MT6351_PMIC_ACCDET_EINT_SAM_IN_MASK, MT6351_PMIC_ACCDET_EINT_SAM_IN_SHIFT},
	{PMIC_ACCDET_EINT_MEM_IN, MT6351_PMIC_ACCDET_EINT_MEM_IN_ADDR,
	 MT6351_PMIC_ACCDET_EINT_MEM_IN_MASK, MT6351_PMIC_ACCDET_EINT_MEM_IN_SHIFT},
	{PMIC_AD_NVDETECTOUT, MT6351_PMIC_AD_NVDETECTOUT_ADDR,
	 MT6351_PMIC_AD_NVDETECTOUT_MASK, MT6351_PMIC_AD_NVDETECTOUT_SHIFT},
	{PMIC_AD_EINTCMPOUT, MT6351_PMIC_AD_EINTCMPOUT_ADDR,
	 MT6351_PMIC_AD_EINTCMPOUT_MASK, MT6351_PMIC_AD_EINTCMPOUT_SHIFT},
	{PMIC_DA_NI_EINTCMPEN, MT6351_PMIC_DA_NI_EINTCMPEN_ADDR,
	 MT6351_PMIC_DA_NI_EINTCMPEN_MASK, MT6351_PMIC_DA_NI_EINTCMPEN_SHIFT},
	{PMIC_ACCDET_NEGV_COUNT_IN, MT6351_PMIC_ACCDET_NEGV_COUNT_IN_ADDR,
	 MT6351_PMIC_ACCDET_NEGV_COUNT_IN_MASK, MT6351_PMIC_ACCDET_NEGV_COUNT_IN_SHIFT},
	{PMIC_ACCDET_NEGV_EN_FINAL, MT6351_PMIC_ACCDET_NEGV_EN_FINAL_ADDR,
	 MT6351_PMIC_ACCDET_NEGV_EN_FINAL_MASK, MT6351_PMIC_ACCDET_NEGV_EN_FINAL_SHIFT},
	{PMIC_ACCDET_NEGV_COUNT_END, MT6351_PMIC_ACCDET_NEGV_COUNT_END_ADDR,
	 MT6351_PMIC_ACCDET_NEGV_COUNT_END_MASK, MT6351_PMIC_ACCDET_NEGV_COUNT_END_SHIFT},
	{PMIC_ACCDET_NEGV_MINU, MT6351_PMIC_ACCDET_NEGV_MINU_ADDR,
	 MT6351_PMIC_ACCDET_NEGV_MINU_MASK, MT6351_PMIC_ACCDET_NEGV_MINU_SHIFT},
	{PMIC_ACCDET_NEGV_ADD, MT6351_PMIC_ACCDET_NEGV_ADD_ADDR,
	 MT6351_PMIC_ACCDET_NEGV_ADD_MASK, MT6351_PMIC_ACCDET_NEGV_ADD_SHIFT},
	{PMIC_ACCDET_NEGV_CMP, MT6351_PMIC_ACCDET_NEGV_CMP_ADDR,
	 MT6351_PMIC_ACCDET_NEGV_CMP_MASK, MT6351_PMIC_ACCDET_NEGV_CMP_SHIFT},
	{PMIC_ACCDET_CUR_DEB, MT6351_PMIC_ACCDET_CUR_DEB_ADDR,
	 MT6351_PMIC_ACCDET_CUR_DEB_MASK, MT6351_PMIC_ACCDET_CUR_DEB_SHIFT},
	{PMIC_ACCDET_EINT_CUR_DEB, MT6351_PMIC_ACCDET_EINT_CUR_DEB_ADDR,
	 MT6351_PMIC_ACCDET_EINT_CUR_DEB_MASK, MT6351_PMIC_ACCDET_EINT_CUR_DEB_SHIFT},
	{PMIC_ACCDET_RSV_CON0, MT6351_PMIC_ACCDET_RSV_CON0_ADDR,
	 MT6351_PMIC_ACCDET_RSV_CON0_MASK, MT6351_PMIC_ACCDET_RSV_CON0_SHIFT},
	{PMIC_ACCDET_RSV_CON1, MT6351_PMIC_ACCDET_RSV_CON1_ADDR,
	 MT6351_PMIC_ACCDET_RSV_CON1_MASK, MT6351_PMIC_ACCDET_RSV_CON1_SHIFT},
	{PMIC_ACCDET_AUXADC_CONNECT_TIME, MT6351_PMIC_ACCDET_AUXADC_CONNECT_TIME_ADDR,
	 MT6351_PMIC_ACCDET_AUXADC_CONNECT_TIME_MASK,
	 MT6351_PMIC_ACCDET_AUXADC_CONNECT_TIME_SHIFT},
	{PMIC_RG_VCDT_HV_EN, MT6351_PMIC_RG_VCDT_HV_EN_ADDR,
	 MT6351_PMIC_RG_VCDT_HV_EN_MASK, MT6351_PMIC_RG_VCDT_HV_EN_SHIFT},
	{PMIC_RGS_CHR_LDO_DET, MT6351_PMIC_RGS_CHR_LDO_DET_ADDR,
	 MT6351_PMIC_RGS_CHR_LDO_DET_MASK, MT6351_PMIC_RGS_CHR_LDO_DET_SHIFT},
	{PMIC_RG_PCHR_AUTOMODE, MT6351_PMIC_RG_PCHR_AUTOMODE_ADDR,
	 MT6351_PMIC_RG_PCHR_AUTOMODE_MASK, MT6351_PMIC_RG_PCHR_AUTOMODE_SHIFT},
	{PMIC_RG_CSDAC_EN, MT6351_PMIC_RG_CSDAC_EN_ADDR, MT6351_PMIC_RG_CSDAC_EN_MASK,
	 MT6351_PMIC_RG_CSDAC_EN_SHIFT},
	{PMIC_RG_NORM_CHR_EN, MT6351_PMIC_RG_NORM_CHR_EN_ADDR,
	 MT6351_PMIC_RG_NORM_CHR_EN_MASK, MT6351_PMIC_RG_NORM_CHR_EN_SHIFT},
	{PMIC_RGS_CHRDET, MT6351_PMIC_RGS_CHRDET_ADDR, MT6351_PMIC_RGS_CHRDET_MASK,
	 MT6351_PMIC_RGS_CHRDET_SHIFT},
	{PMIC_RGS_VCDT_LV_DET, MT6351_PMIC_RGS_VCDT_LV_DET_ADDR,
	 MT6351_PMIC_RGS_VCDT_LV_DET_MASK, MT6351_PMIC_RGS_VCDT_LV_DET_SHIFT},
	{PMIC_RGS_VCDT_HV_DET, MT6351_PMIC_RGS_VCDT_HV_DET_ADDR,
	 MT6351_PMIC_RGS_VCDT_HV_DET_MASK, MT6351_PMIC_RGS_VCDT_HV_DET_SHIFT},
	{PMIC_RG_VCDT_LV_VTH, MT6351_PMIC_RG_VCDT_LV_VTH_ADDR,
	 MT6351_PMIC_RG_VCDT_LV_VTH_MASK, MT6351_PMIC_RG_VCDT_LV_VTH_SHIFT},
	{PMIC_RG_VCDT_HV_VTH, MT6351_PMIC_RG_VCDT_HV_VTH_ADDR,
	 MT6351_PMIC_RG_VCDT_HV_VTH_MASK, MT6351_PMIC_RG_VCDT_HV_VTH_SHIFT},
	{PMIC_RG_VBAT_CV_EN, MT6351_PMIC_RG_VBAT_CV_EN_ADDR,
	 MT6351_PMIC_RG_VBAT_CV_EN_MASK, MT6351_PMIC_RG_VBAT_CV_EN_SHIFT},
	{PMIC_RG_VBAT_CC_EN, MT6351_PMIC_RG_VBAT_CC_EN_ADDR,
	 MT6351_PMIC_RG_VBAT_CC_EN_MASK, MT6351_PMIC_RG_VBAT_CC_EN_SHIFT},
	{PMIC_RG_CS_EN, MT6351_PMIC_RG_CS_EN_ADDR, MT6351_PMIC_RG_CS_EN_MASK,
	 MT6351_PMIC_RG_CS_EN_SHIFT},
	{PMIC_RGS_CS_DET, MT6351_PMIC_RGS_CS_DET_ADDR, MT6351_PMIC_RGS_CS_DET_MASK,
	 MT6351_PMIC_RGS_CS_DET_SHIFT},
	{PMIC_RGS_VBAT_CV_DET, MT6351_PMIC_RGS_VBAT_CV_DET_ADDR,
	 MT6351_PMIC_RGS_VBAT_CV_DET_MASK, MT6351_PMIC_RGS_VBAT_CV_DET_SHIFT},
	{PMIC_RGS_VBAT_CC_DET, MT6351_PMIC_RGS_VBAT_CC_DET_ADDR,
	 MT6351_PMIC_RGS_VBAT_CC_DET_MASK, MT6351_PMIC_RGS_VBAT_CC_DET_SHIFT},
	{PMIC_RG_VBAT_NORM_CV_VTH, MT6351_PMIC_RG_VBAT_NORM_CV_VTH_ADDR,
	 MT6351_PMIC_RG_VBAT_NORM_CV_VTH_MASK, MT6351_PMIC_RG_VBAT_NORM_CV_VTH_SHIFT},
	{PMIC_RG_VBAT_CC_VTH, MT6351_PMIC_RG_VBAT_CC_VTH_ADDR,
	 MT6351_PMIC_RG_VBAT_CC_VTH_MASK, MT6351_PMIC_RG_VBAT_CC_VTH_SHIFT},
	{PMIC_RG_NORM_CS_VTH, MT6351_PMIC_RG_NORM_CS_VTH_ADDR,
	 MT6351_PMIC_RG_NORM_CS_VTH_MASK, MT6351_PMIC_RG_NORM_CS_VTH_SHIFT},
	{PMIC_RG_PCHR_TOHTC, MT6351_PMIC_RG_PCHR_TOHTC_ADDR,
	 MT6351_PMIC_RG_PCHR_TOHTC_MASK, MT6351_PMIC_RG_PCHR_TOHTC_SHIFT},
	{PMIC_RG_PCHR_TOLTC, MT6351_PMIC_RG_PCHR_TOLTC_ADDR,
	 MT6351_PMIC_RG_PCHR_TOLTC_MASK, MT6351_PMIC_RG_PCHR_TOLTC_SHIFT},
	{PMIC_RG_VBAT_OV_EN, MT6351_PMIC_RG_VBAT_OV_EN_ADDR,
	 MT6351_PMIC_RG_VBAT_OV_EN_MASK, MT6351_PMIC_RG_VBAT_OV_EN_SHIFT},
	{PMIC_RG_VBAT_OV_VTH, MT6351_PMIC_RG_VBAT_OV_VTH_ADDR,
	 MT6351_PMIC_RG_VBAT_OV_VTH_MASK, MT6351_PMIC_RG_VBAT_OV_VTH_SHIFT},
	{PMIC_RG_VBAT_OV_DEG, MT6351_PMIC_RG_VBAT_OV_DEG_ADDR,
	 MT6351_PMIC_RG_VBAT_OV_DEG_MASK, MT6351_PMIC_RG_VBAT_OV_DEG_SHIFT},
	{PMIC_RGS_VBAT_OV_DET, MT6351_PMIC_RGS_VBAT_OV_DET_ADDR,
	 MT6351_PMIC_RGS_VBAT_OV_DET_MASK, MT6351_PMIC_RGS_VBAT_OV_DET_SHIFT},
	{PMIC_RG_BATON_EN, MT6351_PMIC_RG_BATON_EN_ADDR, MT6351_PMIC_RG_BATON_EN_MASK,
	 MT6351_PMIC_RG_BATON_EN_SHIFT},
	{PMIC_RG_BATON_HT_EN_RSV0, MT6351_PMIC_RG_BATON_HT_EN_RSV0_ADDR,
	 MT6351_PMIC_RG_BATON_HT_EN_RSV0_MASK, MT6351_PMIC_RG_BATON_HT_EN_RSV0_SHIFT},
	{PMIC_BATON_TDET_EN, MT6351_PMIC_BATON_TDET_EN_ADDR,
	 MT6351_PMIC_BATON_TDET_EN_MASK, MT6351_PMIC_BATON_TDET_EN_SHIFT},
	{PMIC_RG_BATON_HT_TRIM, MT6351_PMIC_RG_BATON_HT_TRIM_ADDR,
	 MT6351_PMIC_RG_BATON_HT_TRIM_MASK, MT6351_PMIC_RG_BATON_HT_TRIM_SHIFT},
	{PMIC_RG_BATON_HT_TRIM_SET, MT6351_PMIC_RG_BATON_HT_TRIM_SET_ADDR,
	 MT6351_PMIC_RG_BATON_HT_TRIM_SET_MASK, MT6351_PMIC_RG_BATON_HT_TRIM_SET_SHIFT},
	{PMIC_RG_BATON_TDET_EN, MT6351_PMIC_RG_BATON_TDET_EN_ADDR,
	 MT6351_PMIC_RG_BATON_TDET_EN_MASK, MT6351_PMIC_RG_BATON_TDET_EN_SHIFT},
	{PMIC_RG_CSDAC_DATA, MT6351_PMIC_RG_CSDAC_DATA_ADDR,
	 MT6351_PMIC_RG_CSDAC_DATA_MASK, MT6351_PMIC_RG_CSDAC_DATA_SHIFT},
	{PMIC_RG_FRC_CSVTH_USBDL, MT6351_PMIC_RG_FRC_CSVTH_USBDL_ADDR,
	 MT6351_PMIC_RG_FRC_CSVTH_USBDL_MASK, MT6351_PMIC_RG_FRC_CSVTH_USBDL_SHIFT},
	{PMIC_RGS_PCHR_FLAG_OUT, MT6351_PMIC_RGS_PCHR_FLAG_OUT_ADDR,
	 MT6351_PMIC_RGS_PCHR_FLAG_OUT_MASK, MT6351_PMIC_RGS_PCHR_FLAG_OUT_SHIFT},
	{PMIC_RG_PCHR_FLAG_EN, MT6351_PMIC_RG_PCHR_FLAG_EN_ADDR,
	 MT6351_PMIC_RG_PCHR_FLAG_EN_MASK, MT6351_PMIC_RG_PCHR_FLAG_EN_SHIFT},
	{PMIC_RG_OTG_BVALID_EN, MT6351_PMIC_RG_OTG_BVALID_EN_ADDR,
	 MT6351_PMIC_RG_OTG_BVALID_EN_MASK, MT6351_PMIC_RG_OTG_BVALID_EN_SHIFT},
	{PMIC_RGS_OTG_BVALID_DET, MT6351_PMIC_RGS_OTG_BVALID_DET_ADDR,
	 MT6351_PMIC_RGS_OTG_BVALID_DET_MASK, MT6351_PMIC_RGS_OTG_BVALID_DET_SHIFT},
	{PMIC_RG_PCHR_FLAG_SEL, MT6351_PMIC_RG_PCHR_FLAG_SEL_ADDR,
	 MT6351_PMIC_RG_PCHR_FLAG_SEL_MASK, MT6351_PMIC_RG_PCHR_FLAG_SEL_SHIFT},
	{PMIC_RG_PCHR_TESTMODE, MT6351_PMIC_RG_PCHR_TESTMODE_ADDR,
	 MT6351_PMIC_RG_PCHR_TESTMODE_MASK, MT6351_PMIC_RG_PCHR_TESTMODE_SHIFT},
	{PMIC_RG_CSDAC_TESTMODE, MT6351_PMIC_RG_CSDAC_TESTMODE_ADDR,
	 MT6351_PMIC_RG_CSDAC_TESTMODE_MASK, MT6351_PMIC_RG_CSDAC_TESTMODE_SHIFT},
	{PMIC_RG_PCHR_RST, MT6351_PMIC_RG_PCHR_RST_ADDR, MT6351_PMIC_RG_PCHR_RST_MASK,
	 MT6351_PMIC_RG_PCHR_RST_SHIFT},
	{PMIC_RG_PCHR_FT_CTRL, MT6351_PMIC_RG_PCHR_FT_CTRL_ADDR,
	 MT6351_PMIC_RG_PCHR_FT_CTRL_MASK, MT6351_PMIC_RG_PCHR_FT_CTRL_SHIFT},
	{PMIC_RG_CHRWDT_TD, MT6351_PMIC_RG_CHRWDT_TD_ADDR, MT6351_PMIC_RG_CHRWDT_TD_MASK,
	 MT6351_PMIC_RG_CHRWDT_TD_SHIFT},
	{PMIC_RG_CHRWDT_EN, MT6351_PMIC_RG_CHRWDT_EN_ADDR, MT6351_PMIC_RG_CHRWDT_EN_MASK,
	 MT6351_PMIC_RG_CHRWDT_EN_SHIFT},
	{PMIC_RG_CHRWDT_WR, MT6351_PMIC_RG_CHRWDT_WR_ADDR, MT6351_PMIC_RG_CHRWDT_WR_MASK,
	 MT6351_PMIC_RG_CHRWDT_WR_SHIFT},
	{PMIC_RG_PCHR_RV, MT6351_PMIC_RG_PCHR_RV_ADDR, MT6351_PMIC_RG_PCHR_RV_MASK,
	 MT6351_PMIC_RG_PCHR_RV_SHIFT},
	{PMIC_RG_CHRWDT_INT_EN, MT6351_PMIC_RG_CHRWDT_INT_EN_ADDR,
	 MT6351_PMIC_RG_CHRWDT_INT_EN_MASK, MT6351_PMIC_RG_CHRWDT_INT_EN_SHIFT},
	{PMIC_RG_CHRWDT_FLAG_WR, MT6351_PMIC_RG_CHRWDT_FLAG_WR_ADDR,
	 MT6351_PMIC_RG_CHRWDT_FLAG_WR_MASK, MT6351_PMIC_RG_CHRWDT_FLAG_WR_SHIFT},
	{PMIC_RGS_CHRWDT_OUT, MT6351_PMIC_RGS_CHRWDT_OUT_ADDR,
	 MT6351_PMIC_RGS_CHRWDT_OUT_MASK, MT6351_PMIC_RGS_CHRWDT_OUT_SHIFT},
	{PMIC_RG_USBDL_RST, MT6351_PMIC_RG_USBDL_RST_ADDR, MT6351_PMIC_RG_USBDL_RST_MASK,
	 MT6351_PMIC_RG_USBDL_RST_SHIFT},
	{PMIC_RG_USBDL_SET, MT6351_PMIC_RG_USBDL_SET_ADDR, MT6351_PMIC_RG_USBDL_SET_MASK,
	 MT6351_PMIC_RG_USBDL_SET_SHIFT},
	{PMIC_RG_ADCIN_VSEN_MUX_EN, MT6351_PMIC_RG_ADCIN_VSEN_MUX_EN_ADDR,
	 MT6351_PMIC_RG_ADCIN_VSEN_MUX_EN_MASK, MT6351_PMIC_RG_ADCIN_VSEN_MUX_EN_SHIFT},
	{PMIC_RG_ADCIN_VSEN_EXT_BATON_EN, MT6351_PMIC_RG_ADCIN_VSEN_EXT_BATON_EN_ADDR,
	 MT6351_PMIC_RG_ADCIN_VSEN_EXT_BATON_EN_MASK,
	 MT6351_PMIC_RG_ADCIN_VSEN_EXT_BATON_EN_SHIFT},
	{PMIC_RG_ADCIN_VBAT_EN, MT6351_PMIC_RG_ADCIN_VBAT_EN_ADDR,
	 MT6351_PMIC_RG_ADCIN_VBAT_EN_MASK, MT6351_PMIC_RG_ADCIN_VBAT_EN_SHIFT},
	{PMIC_RG_ADCIN_VSEN_EN, MT6351_PMIC_RG_ADCIN_VSEN_EN_ADDR,
	 MT6351_PMIC_RG_ADCIN_VSEN_EN_MASK, MT6351_PMIC_RG_ADCIN_VSEN_EN_SHIFT},
	{PMIC_RG_ADCIN_CHR_EN, MT6351_PMIC_RG_ADCIN_CHR_EN_ADDR,
	 MT6351_PMIC_RG_ADCIN_CHR_EN_MASK, MT6351_PMIC_RG_ADCIN_CHR_EN_SHIFT},
	{PMIC_RG_UVLO_VTHL, MT6351_PMIC_RG_UVLO_VTHL_ADDR, MT6351_PMIC_RG_UVLO_VTHL_MASK,
	 MT6351_PMIC_RG_UVLO_VTHL_SHIFT},
	{PMIC_RG_UVLO_VH_LAT, MT6351_PMIC_RG_UVLO_VH_LAT_ADDR,
	 MT6351_PMIC_RG_UVLO_VH_LAT_MASK, MT6351_PMIC_RG_UVLO_VH_LAT_SHIFT},
	{PMIC_RG_LBAT_INT_VTH, MT6351_PMIC_RG_LBAT_INT_VTH_ADDR,
	 MT6351_PMIC_RG_LBAT_INT_VTH_MASK, MT6351_PMIC_RG_LBAT_INT_VTH_SHIFT},
	{PMIC_RG_BGR_RSEL, MT6351_PMIC_RG_BGR_RSEL_ADDR, MT6351_PMIC_RG_BGR_RSEL_MASK,
	 MT6351_PMIC_RG_BGR_RSEL_SHIFT},
	{PMIC_RG_BGR_UNCHOP_PH, MT6351_PMIC_RG_BGR_UNCHOP_PH_ADDR,
	 MT6351_PMIC_RG_BGR_UNCHOP_PH_MASK, MT6351_PMIC_RG_BGR_UNCHOP_PH_SHIFT},
	{PMIC_RG_BGR_UNCHOP, MT6351_PMIC_RG_BGR_UNCHOP_ADDR,
	 MT6351_PMIC_RG_BGR_UNCHOP_MASK, MT6351_PMIC_RG_BGR_UNCHOP_SHIFT},
	{PMIC_RG_BC11_BB_CTRL, MT6351_PMIC_RG_BC11_BB_CTRL_ADDR,
	 MT6351_PMIC_RG_BC11_BB_CTRL_MASK, MT6351_PMIC_RG_BC11_BB_CTRL_SHIFT},
	{PMIC_RG_BC11_RST, MT6351_PMIC_RG_BC11_RST_ADDR, MT6351_PMIC_RG_BC11_RST_MASK,
	 MT6351_PMIC_RG_BC11_RST_SHIFT},
	{PMIC_RG_BC11_VSRC_EN, MT6351_PMIC_RG_BC11_VSRC_EN_ADDR,
	 MT6351_PMIC_RG_BC11_VSRC_EN_MASK, MT6351_PMIC_RG_BC11_VSRC_EN_SHIFT},
	{PMIC_RGS_BC11_CMP_OUT, MT6351_PMIC_RGS_BC11_CMP_OUT_ADDR,
	 MT6351_PMIC_RGS_BC11_CMP_OUT_MASK, MT6351_PMIC_RGS_BC11_CMP_OUT_SHIFT},
	{PMIC_RG_BC11_VREF_VTH, MT6351_PMIC_RG_BC11_VREF_VTH_ADDR,
	 MT6351_PMIC_RG_BC11_VREF_VTH_MASK, MT6351_PMIC_RG_BC11_VREF_VTH_SHIFT},
	{PMIC_RG_BC11_CMP_EN, MT6351_PMIC_RG_BC11_CMP_EN_ADDR,
	 MT6351_PMIC_RG_BC11_CMP_EN_MASK, MT6351_PMIC_RG_BC11_CMP_EN_SHIFT},
	{PMIC_RG_BC11_IPD_EN, MT6351_PMIC_RG_BC11_IPD_EN_ADDR,
	 MT6351_PMIC_RG_BC11_IPD_EN_MASK, MT6351_PMIC_RG_BC11_IPD_EN_SHIFT},
	{PMIC_RG_BC11_IPU_EN, MT6351_PMIC_RG_BC11_IPU_EN_ADDR,
	 MT6351_PMIC_RG_BC11_IPU_EN_MASK, MT6351_PMIC_RG_BC11_IPU_EN_SHIFT},
	{PMIC_RG_BC11_BIAS_EN, MT6351_PMIC_RG_BC11_BIAS_EN_ADDR,
	 MT6351_PMIC_RG_BC11_BIAS_EN_MASK, MT6351_PMIC_RG_BC11_BIAS_EN_SHIFT},
	{PMIC_RG_CSDAC_STP_INC, MT6351_PMIC_RG_CSDAC_STP_INC_ADDR,
	 MT6351_PMIC_RG_CSDAC_STP_INC_MASK, MT6351_PMIC_RG_CSDAC_STP_INC_SHIFT},
	{PMIC_RG_CSDAC_STP_DEC, MT6351_PMIC_RG_CSDAC_STP_DEC_ADDR,
	 MT6351_PMIC_RG_CSDAC_STP_DEC_MASK, MT6351_PMIC_RG_CSDAC_STP_DEC_SHIFT},
	{PMIC_RG_CSDAC_DLY, MT6351_PMIC_RG_CSDAC_DLY_ADDR, MT6351_PMIC_RG_CSDAC_DLY_MASK,
	 MT6351_PMIC_RG_CSDAC_DLY_SHIFT},
	{PMIC_RG_CSDAC_STP, MT6351_PMIC_RG_CSDAC_STP_ADDR, MT6351_PMIC_RG_CSDAC_STP_MASK,
	 MT6351_PMIC_RG_CSDAC_STP_SHIFT},
	{PMIC_RG_LOW_ICH_DB, MT6351_PMIC_RG_LOW_ICH_DB_ADDR,
	 MT6351_PMIC_RG_LOW_ICH_DB_MASK, MT6351_PMIC_RG_LOW_ICH_DB_SHIFT},
	{PMIC_RG_CHRIND_ON, MT6351_PMIC_RG_CHRIND_ON_ADDR, MT6351_PMIC_RG_CHRIND_ON_MASK,
	 MT6351_PMIC_RG_CHRIND_ON_SHIFT},
	{PMIC_RG_CHRIND_DIMMING, MT6351_PMIC_RG_CHRIND_DIMMING_ADDR,
	 MT6351_PMIC_RG_CHRIND_DIMMING_MASK, MT6351_PMIC_RG_CHRIND_DIMMING_SHIFT},
	{PMIC_RG_CV_MODE, MT6351_PMIC_RG_CV_MODE_ADDR, MT6351_PMIC_RG_CV_MODE_MASK,
	 MT6351_PMIC_RG_CV_MODE_SHIFT},
	{PMIC_RG_VCDT_MODE, MT6351_PMIC_RG_VCDT_MODE_ADDR, MT6351_PMIC_RG_VCDT_MODE_MASK,
	 MT6351_PMIC_RG_VCDT_MODE_SHIFT},
	{PMIC_RG_CSDAC_MODE, MT6351_PMIC_RG_CSDAC_MODE_ADDR,
	 MT6351_PMIC_RG_CSDAC_MODE_MASK, MT6351_PMIC_RG_CSDAC_MODE_SHIFT},
	{PMIC_RG_TRACKING_EN, MT6351_PMIC_RG_TRACKING_EN_ADDR,
	 MT6351_PMIC_RG_TRACKING_EN_MASK, MT6351_PMIC_RG_TRACKING_EN_SHIFT},
	{PMIC_RG_HWCV_EN, MT6351_PMIC_RG_HWCV_EN_ADDR, MT6351_PMIC_RG_HWCV_EN_MASK,
	 MT6351_PMIC_RG_HWCV_EN_SHIFT},
	{PMIC_RG_ULC_DET_EN, MT6351_PMIC_RG_ULC_DET_EN_ADDR,
	 MT6351_PMIC_RG_ULC_DET_EN_MASK, MT6351_PMIC_RG_ULC_DET_EN_SHIFT},
	{PMIC_RG_BGR_TRIM_EN, MT6351_PMIC_RG_BGR_TRIM_EN_ADDR,
	 MT6351_PMIC_RG_BGR_TRIM_EN_MASK, MT6351_PMIC_RG_BGR_TRIM_EN_SHIFT},
	{PMIC_RG_ICHRG_TRIM, MT6351_PMIC_RG_ICHRG_TRIM_ADDR,
	 MT6351_PMIC_RG_ICHRG_TRIM_MASK, MT6351_PMIC_RG_ICHRG_TRIM_SHIFT},
	{PMIC_RG_BGR_TRIM, MT6351_PMIC_RG_BGR_TRIM_ADDR, MT6351_PMIC_RG_BGR_TRIM_MASK,
	 MT6351_PMIC_RG_BGR_TRIM_SHIFT},
	{PMIC_RG_OVP_TRIM, MT6351_PMIC_RG_OVP_TRIM_ADDR, MT6351_PMIC_RG_OVP_TRIM_MASK,
	 MT6351_PMIC_RG_OVP_TRIM_SHIFT},
	{PMIC_RG_CHR_OSC_TRIM, MT6351_PMIC_RG_CHR_OSC_TRIM_ADDR,
	 MT6351_PMIC_RG_CHR_OSC_TRIM_MASK, MT6351_PMIC_RG_CHR_OSC_TRIM_SHIFT},
	{PMIC_DA_QI_BGR_EXT_BUF_EN, MT6351_PMIC_DA_QI_BGR_EXT_BUF_EN_ADDR,
	 MT6351_PMIC_DA_QI_BGR_EXT_BUF_EN_MASK, MT6351_PMIC_DA_QI_BGR_EXT_BUF_EN_SHIFT},
	{PMIC_RG_BGR_TEST_EN, MT6351_PMIC_RG_BGR_TEST_EN_ADDR,
	 MT6351_PMIC_RG_BGR_TEST_EN_MASK, MT6351_PMIC_RG_BGR_TEST_EN_SHIFT},
	{PMIC_RG_BGR_TEST_RSTB, MT6351_PMIC_RG_BGR_TEST_RSTB_ADDR,
	 MT6351_PMIC_RG_BGR_TEST_RSTB_MASK, MT6351_PMIC_RG_BGR_TEST_RSTB_SHIFT},
	{PMIC_RG_DAC_USBDL_MAX, MT6351_PMIC_RG_DAC_USBDL_MAX_ADDR,
	 MT6351_PMIC_RG_DAC_USBDL_MAX_MASK, MT6351_PMIC_RG_DAC_USBDL_MAX_SHIFT},
	{PMIC_RG_CM_VDEC_TRIG, MT6351_PMIC_RG_CM_VDEC_TRIG_ADDR,
	 MT6351_PMIC_RG_CM_VDEC_TRIG_MASK, MT6351_PMIC_RG_CM_VDEC_TRIG_SHIFT},
	{PMIC_PCHR_CM_VDEC_STATUS, MT6351_PMIC_PCHR_CM_VDEC_STATUS_ADDR,
	 MT6351_PMIC_PCHR_CM_VDEC_STATUS_MASK, MT6351_PMIC_PCHR_CM_VDEC_STATUS_SHIFT},
	{PMIC_RG_CM_VINC_TRIG, MT6351_PMIC_RG_CM_VINC_TRIG_ADDR,
	 MT6351_PMIC_RG_CM_VINC_TRIG_MASK, MT6351_PMIC_RG_CM_VINC_TRIG_SHIFT},
	{PMIC_PCHR_CM_VINC_STATUS, MT6351_PMIC_PCHR_CM_VINC_STATUS_ADDR,
	 MT6351_PMIC_PCHR_CM_VINC_STATUS_MASK, MT6351_PMIC_PCHR_CM_VINC_STATUS_SHIFT},
	{PMIC_RG_CM_VDEC_HPRD1, MT6351_PMIC_RG_CM_VDEC_HPRD1_ADDR,
	 MT6351_PMIC_RG_CM_VDEC_HPRD1_MASK, MT6351_PMIC_RG_CM_VDEC_HPRD1_SHIFT},
	{PMIC_RG_CM_VDEC_HPRD2, MT6351_PMIC_RG_CM_VDEC_HPRD2_ADDR,
	 MT6351_PMIC_RG_CM_VDEC_HPRD2_MASK, MT6351_PMIC_RG_CM_VDEC_HPRD2_SHIFT},
	{PMIC_RG_CM_VDEC_HPRD3, MT6351_PMIC_RG_CM_VDEC_HPRD3_ADDR,
	 MT6351_PMIC_RG_CM_VDEC_HPRD3_MASK, MT6351_PMIC_RG_CM_VDEC_HPRD3_SHIFT},
	{PMIC_RG_CM_VDEC_HPRD4, MT6351_PMIC_RG_CM_VDEC_HPRD4_ADDR,
	 MT6351_PMIC_RG_CM_VDEC_HPRD4_MASK, MT6351_PMIC_RG_CM_VDEC_HPRD4_SHIFT},
	{PMIC_RG_CM_VDEC_HPRD5, MT6351_PMIC_RG_CM_VDEC_HPRD5_ADDR,
	 MT6351_PMIC_RG_CM_VDEC_HPRD5_MASK, MT6351_PMIC_RG_CM_VDEC_HPRD5_SHIFT},
	{PMIC_RG_CM_VDEC_HPRD6, MT6351_PMIC_RG_CM_VDEC_HPRD6_ADDR,
	 MT6351_PMIC_RG_CM_VDEC_HPRD6_MASK, MT6351_PMIC_RG_CM_VDEC_HPRD6_SHIFT},
	{PMIC_RG_CM_VINC_HPRD1, MT6351_PMIC_RG_CM_VINC_HPRD1_ADDR,
	 MT6351_PMIC_RG_CM_VINC_HPRD1_MASK, MT6351_PMIC_RG_CM_VINC_HPRD1_SHIFT},
	{PMIC_RG_CM_VINC_HPRD2, MT6351_PMIC_RG_CM_VINC_HPRD2_ADDR,
	 MT6351_PMIC_RG_CM_VINC_HPRD2_MASK, MT6351_PMIC_RG_CM_VINC_HPRD2_SHIFT},
	{PMIC_RG_CM_VINC_HPRD3, MT6351_PMIC_RG_CM_VINC_HPRD3_ADDR,
	 MT6351_PMIC_RG_CM_VINC_HPRD3_MASK, MT6351_PMIC_RG_CM_VINC_HPRD3_SHIFT},
	{PMIC_RG_CM_VINC_HPRD4, MT6351_PMIC_RG_CM_VINC_HPRD4_ADDR,
	 MT6351_PMIC_RG_CM_VINC_HPRD4_MASK, MT6351_PMIC_RG_CM_VINC_HPRD4_SHIFT},
	{PMIC_RG_CM_VINC_HPRD5, MT6351_PMIC_RG_CM_VINC_HPRD5_ADDR,
	 MT6351_PMIC_RG_CM_VINC_HPRD5_MASK, MT6351_PMIC_RG_CM_VINC_HPRD5_SHIFT},
	{PMIC_RG_CM_VINC_HPRD6, MT6351_PMIC_RG_CM_VINC_HPRD6_ADDR,
	 MT6351_PMIC_RG_CM_VINC_HPRD6_MASK, MT6351_PMIC_RG_CM_VINC_HPRD6_SHIFT},
	{PMIC_RG_CM_LPRD, MT6351_PMIC_RG_CM_LPRD_ADDR, MT6351_PMIC_RG_CM_LPRD_MASK,
	 MT6351_PMIC_RG_CM_LPRD_SHIFT},
	{PMIC_RG_CM_CS_VTHL, MT6351_PMIC_RG_CM_CS_VTHL_ADDR,
	 MT6351_PMIC_RG_CM_CS_VTHL_MASK, MT6351_PMIC_RG_CM_CS_VTHL_SHIFT},
	{PMIC_RG_CM_CS_VTHH, MT6351_PMIC_RG_CM_CS_VTHH_ADDR,
	 MT6351_PMIC_RG_CM_CS_VTHH_MASK, MT6351_PMIC_RG_CM_CS_VTHH_SHIFT},
	{PMIC_RG_PCHR_RSV, MT6351_PMIC_RG_PCHR_RSV_ADDR, MT6351_PMIC_RG_PCHR_RSV_MASK,
	 MT6351_PMIC_RG_PCHR_RSV_SHIFT},
	{PMIC_RG_ENVTEM_D, MT6351_PMIC_RG_ENVTEM_D_ADDR, MT6351_PMIC_RG_ENVTEM_D_MASK,
	 MT6351_PMIC_RG_ENVTEM_D_SHIFT},
	{PMIC_RG_ENVTEM_EN, MT6351_PMIC_RG_ENVTEM_EN_ADDR, MT6351_PMIC_RG_ENVTEM_EN_MASK,
	 MT6351_PMIC_RG_ENVTEM_EN_SHIFT},
	{PMIC_RGS_BATON_HV, MT6351_PMIC_RGS_BATON_HV_ADDR, MT6351_PMIC_RGS_BATON_HV_MASK,
	 MT6351_PMIC_RGS_BATON_HV_SHIFT},
	{PMIC_RG_HW_VTH_CTRL, MT6351_PMIC_RG_HW_VTH_CTRL_ADDR,
	 MT6351_PMIC_RG_HW_VTH_CTRL_MASK, MT6351_PMIC_RG_HW_VTH_CTRL_SHIFT},
	{PMIC_RG_HW_VTH2, MT6351_PMIC_RG_HW_VTH2_ADDR, MT6351_PMIC_RG_HW_VTH2_MASK,
	 MT6351_PMIC_RG_HW_VTH2_SHIFT},
	{PMIC_RG_HW_VTH1, MT6351_PMIC_RG_HW_VTH1_ADDR, MT6351_PMIC_RG_HW_VTH1_MASK,
	 MT6351_PMIC_RG_HW_VTH1_SHIFT},
	{PMIC_RG_CM_VDEC_INT_EN, MT6351_PMIC_RG_CM_VDEC_INT_EN_ADDR,
	 MT6351_PMIC_RG_CM_VDEC_INT_EN_MASK, MT6351_PMIC_RG_CM_VDEC_INT_EN_SHIFT},
	{PMIC_RG_CM_VINC_INT_EN, MT6351_PMIC_RG_CM_VINC_INT_EN_ADDR,
	 MT6351_PMIC_RG_CM_VINC_INT_EN_MASK, MT6351_PMIC_RG_CM_VINC_INT_EN_SHIFT},
	{PMIC_RG_QI_BATON_LT_EN, MT6351_PMIC_RG_QI_BATON_LT_EN_ADDR,
	 MT6351_PMIC_RG_QI_BATON_LT_EN_MASK, MT6351_PMIC_RG_QI_BATON_LT_EN_SHIFT},
	{PMIC_RGS_BATON_UNDET, MT6351_PMIC_RGS_BATON_UNDET_ADDR,
	 MT6351_PMIC_RGS_BATON_UNDET_MASK, MT6351_PMIC_RGS_BATON_UNDET_SHIFT},
	{PMIC_RG_JW_CS_VTH, MT6351_PMIC_RG_JW_CS_VTH_ADDR, MT6351_PMIC_RG_JW_CS_VTH_MASK,
	 MT6351_PMIC_RG_JW_CS_VTH_SHIFT},
	{PMIC_RG_JW_CV_VTH, MT6351_PMIC_RG_JW_CV_VTH_ADDR, MT6351_PMIC_RG_JW_CV_VTH_MASK,
	 MT6351_PMIC_RG_JW_CV_VTH_SHIFT},
	{PMIC_RG_JC_CS_VTH, MT6351_PMIC_RG_JC_CS_VTH_ADDR, MT6351_PMIC_RG_JC_CS_VTH_MASK,
	 MT6351_PMIC_RG_JC_CS_VTH_SHIFT},
	{PMIC_RG_JC_CV_VTH, MT6351_PMIC_RG_JC_CV_VTH_ADDR, MT6351_PMIC_RG_JC_CV_VTH_MASK,
	 MT6351_PMIC_RG_JC_CV_VTH_SHIFT},
	{PMIC_RG_BC11_ACA_EN, MT6351_PMIC_RG_BC11_ACA_EN_ADDR,
	 MT6351_PMIC_RG_BC11_ACA_EN_MASK, MT6351_PMIC_RG_BC11_ACA_EN_SHIFT},
	{PMIC_RG_JEITA_EN, MT6351_PMIC_RG_JEITA_EN_ADDR, MT6351_PMIC_RG_JEITA_EN_MASK,
	 MT6351_PMIC_RG_JEITA_EN_SHIFT},
	{PMIC_RG_VCDT_TRIM, MT6351_PMIC_RG_VCDT_TRIM_ADDR, MT6351_PMIC_RG_VCDT_TRIM_MASK,
	 MT6351_PMIC_RG_VCDT_TRIM_SHIFT},
	{PMIC_RGS_BC11_ID_FLOAT, MT6351_PMIC_RGS_BC11_ID_FLOAT_ADDR,
	 MT6351_PMIC_RGS_BC11_ID_FLOAT_MASK, MT6351_PMIC_RGS_BC11_ID_FLOAT_SHIFT},
	{PMIC_RGS_BC11_ID_A, MT6351_PMIC_RGS_BC11_ID_A_ADDR,
	 MT6351_PMIC_RGS_BC11_ID_A_MASK, MT6351_PMIC_RGS_BC11_ID_A_SHIFT},
	{PMIC_RGS_BC11_ID_B, MT6351_PMIC_RGS_BC11_ID_B_ADDR,
	 MT6351_PMIC_RGS_BC11_ID_B_MASK, MT6351_PMIC_RGS_BC11_ID_B_SHIFT},
	{PMIC_RGS_BC11_ID_C, MT6351_PMIC_RGS_BC11_ID_C_ADDR,
	 MT6351_PMIC_RGS_BC11_ID_C_MASK, MT6351_PMIC_RGS_BC11_ID_C_SHIFT},
	{PMIC_RGS_BC11_ID_GND, MT6351_PMIC_RGS_BC11_ID_GND_ADDR,
	 MT6351_PMIC_RGS_BC11_ID_GND_MASK, MT6351_PMIC_RGS_BC11_ID_GND_SHIFT},
	{PMIC_RGS_BC11_ACA_OTG_DET, MT6351_PMIC_RGS_BC11_ACA_OTG_DET_ADDR,
	 MT6351_PMIC_RGS_BC11_ACA_OTG_DET_MASK, MT6351_PMIC_RGS_BC11_ACA_OTG_DET_SHIFT},
	{PMIC_RG_INDICATOR_TRIM, MT6351_PMIC_RG_INDICATOR_TRIM_ADDR,
	 MT6351_PMIC_RG_INDICATOR_TRIM_MASK, MT6351_PMIC_RG_INDICATOR_TRIM_SHIFT},
	{PMIC_EOSC_CALI_START, MT6351_PMIC_EOSC_CALI_START_ADDR,
	 MT6351_PMIC_EOSC_CALI_START_MASK, MT6351_PMIC_EOSC_CALI_START_SHIFT},
	{PMIC_EOSC_CALI_TD, MT6351_PMIC_EOSC_CALI_TD_ADDR, MT6351_PMIC_EOSC_CALI_TD_MASK,
	 MT6351_PMIC_EOSC_CALI_TD_SHIFT},
	{PMIC_EOSC_CALI_TEST, MT6351_PMIC_EOSC_CALI_TEST_ADDR,
	 MT6351_PMIC_EOSC_CALI_TEST_MASK, MT6351_PMIC_EOSC_CALI_TEST_SHIFT},
	{PMIC_EOSC_CALI_DCXO_RDY_TD, MT6351_PMIC_EOSC_CALI_DCXO_RDY_TD_ADDR,
	 MT6351_PMIC_EOSC_CALI_DCXO_RDY_TD_MASK, MT6351_PMIC_EOSC_CALI_DCXO_RDY_TD_SHIFT},
	{PMIC_FRC_VTCXO0_ON, MT6351_PMIC_FRC_VTCXO0_ON_ADDR,
	 MT6351_PMIC_FRC_VTCXO0_ON_MASK, MT6351_PMIC_FRC_VTCXO0_ON_SHIFT},
	{PMIC_EOSC_CALI_RSV, MT6351_PMIC_EOSC_CALI_RSV_ADDR,
	 MT6351_PMIC_EOSC_CALI_RSV_MASK, MT6351_PMIC_EOSC_CALI_RSV_SHIFT},
	{PMIC_VRTC_PWM_MODE, MT6351_PMIC_VRTC_PWM_MODE_ADDR,
	 MT6351_PMIC_VRTC_PWM_MODE_MASK, MT6351_PMIC_VRTC_PWM_MODE_SHIFT},
	{PMIC_VRTC_PWM_RSV, MT6351_PMIC_VRTC_PWM_RSV_ADDR, MT6351_PMIC_VRTC_PWM_RSV_MASK,
	 MT6351_PMIC_VRTC_PWM_RSV_SHIFT},
	{PMIC_VRTC_PWM_L_DUTY, MT6351_PMIC_VRTC_PWM_L_DUTY_ADDR,
	 MT6351_PMIC_VRTC_PWM_L_DUTY_MASK, MT6351_PMIC_VRTC_PWM_L_DUTY_SHIFT},
	{PMIC_VRTC_PWM_H_DUTY, MT6351_PMIC_VRTC_PWM_H_DUTY_ADDR,
	 MT6351_PMIC_VRTC_PWM_H_DUTY_MASK, MT6351_PMIC_VRTC_PWM_H_DUTY_SHIFT},
	{PMIC_VRTC_CAP_SEL, MT6351_PMIC_VRTC_CAP_SEL_ADDR, MT6351_PMIC_VRTC_CAP_SEL_MASK,
	 MT6351_PMIC_VRTC_CAP_SEL_SHIFT},
};


unsigned short mt6351_set_register_value(PMU_FLAGS_LIST_ENUM flagname, unsigned int val)
{
	const PMU_FLAG_TABLE_ENTRY *pFlag = &pmu_flags_table[flagname];
	unsigned int ret = 0;


	if (pFlag->flagname != flagname) {
		pr_notice("[pmu_set_register_value]pmic flag idx error\n");
		return 1;
	}


	ret = pmic_config_interface((pFlag->offset),
				    (unsigned int) (val),
				    (unsigned int) (pFlag->mask), (unsigned int) (pFlag->shift)
	    );

	return 0;
}


unsigned short mt6351_get_register_value(PMU_FLAGS_LIST_ENUM flagname)
{
	const PMU_FLAG_TABLE_ENTRY *pFlag = &pmu_flags_table[flagname];
	unsigned int val;
	unsigned int ret;

	ret =
	    pmic_read_interface((unsigned int) pFlag->offset, &val, (unsigned int) (pFlag->mask),
				(unsigned int) (pFlag->shift));

	return val;
}


unsigned short pmic_set_register_value(PMU_FLAGS_LIST_ENUM flagname, unsigned int val)
{
	return mt6351_set_register_value(flagname, val);
}


unsigned short pmic_get_register_value(PMU_FLAGS_LIST_ENUM flagname)
{
	return mt6351_get_register_value(flagname);
}



unsigned short bc11_set_register_value(PMU_FLAGS_LIST_ENUM flagname, unsigned int val)
{
	return mt6351_set_register_value(flagname, val);
}


unsigned short bc11_get_register_value(PMU_FLAGS_LIST_ENUM flagname)
{
	return mt6351_get_register_value(flagname);
}
