#if defined LINUX_MIPSN32
/* For an N32 strace decode the N32 64-bit syscalls. */
[6000] = { 3,	TD,		sys_read,			"read"			}, /* start of Linux N32 */
[6001] = { 3,	TD,		sys_write,			"write"			},
[6002] = { 3,	TD|TF,		sys_open,			"open"			},
[6003] = { 1,	TD,		sys_close,			"close"			},
[6004] = { 2,	TF,		sys_stat64,			"stat"			},
[6005] = { 2,	TD,		sys_fstat64,			"fstat"			},
[6006] = { 2,	TF,		sys_lstat64,			"lstat"			},
[6007] = { 3,	TD,		sys_poll,			"poll"			},
[6008] = { 3,	TD,		sys_lseek,			"lseek"			},
[6009] = { 6,	TD|TM|SI,	sys_mmap,			"mmap"			},
[6010] = { 3,	TM|SI,		sys_mprotect,			"mprotect"		},
[6011] = { 2,	TM|SI,		sys_munmap,			"munmap"		},
[6012] = { 1,	TM|SI,		sys_brk,			"brk"			},
[6013] = { 4,	TS,		sys_rt_sigaction,		"rt_sigaction"		},
[6014] = { 4,	TS,		sys_rt_sigprocmask,		"rt_sigprocmask"	},
[6015] = { 3,	TD,		sys_ioctl,			"ioctl"			},
[6016] = { 4,	TD,		sys_pread,			"pread64"		},
[6017] = { 4,	TD,		sys_pwrite,			"pwrite64"		},
[6018] = { 3,	TD,		sys_readv,			"readv"			},
[6019] = { 3,	TD,		sys_writev,			"writev"		},
[6020] = { 2,	TF,		sys_access,			"access"		},
[6021] = { 1,	TD,		sys_pipe,			"pipe"			},
[6022] = { 5,	TD,		sys_select,			"select"		},
[6023] = { 0,	0,		sys_sched_yield,		"sched_yield"		},
[6024] = { 5,	TM|SI,		sys_mremap,			"mremap"		},
[6025] = { 3,	TM,		sys_msync,			"msync"			},
[6026] = { 3,	TM,		sys_mincore,			"mincore"		},
[6027] = { 3,	TM,		sys_madvise,			"madvise"		},
[6028] = { 3,	TI,		sys_shmget,			"shmget"		},
[6029] = { 3,	TI|TM|SI,	sys_shmat,			"shmat"			},
[6030] = { 3,	TI,		sys_shmctl,			"shmctl"		},
[6031] = { 1,	TD,		sys_dup,			"dup"			},
[6032] = { 2,	TD,		sys_dup2,			"dup2"			},
[6033] = { 0,	TS,		sys_pause,			"pause"			},
[6034] = { 2,	0,		sys_nanosleep,			"nanosleep"		},
[6035] = { 2,	0,		sys_getitimer,			"getitimer"		},
[6036] = { 3,	0,		sys_setitimer,			"setitimer"		},
[6037] = { 1,	0,		sys_alarm,			"alarm"			},
[6038] = { 0,	0,		sys_getpid,			"getpid"		},
[6039] = { 4,	TD|TN,		sys_sendfile,			"sendfile"		},
[6040] = { 3,	TN,		sys_socket,			"socket"		},
[6041] = { 3,	TN,		sys_connect,			"connect"		},
[6042] = { 3,	TN,		sys_accept,			"accept"		},
[6043] = { 6,	TN,		sys_sendto,			"sendto"		},
[6044] = { 6,	TN,		sys_recvfrom,			"recvfrom"		},
[6045] = { 3,	TN,		sys_sendmsg,			"sendmsg"		},
[6046] = { 3,	TN,		sys_recvmsg,			"recvmsg"		},
[6047] = { 2,	TN,		sys_shutdown,			"shutdown"		},
[6048] = { 3,	TN,		sys_bind,			"bind"			},
[6049] = { 2,	TN,		sys_listen,			"listen"		},
[6050] = { 3,	TN,		sys_getsockname,		"getsockname"		},
[6051] = { 3,	TN,		sys_getpeername,		"getpeername"		},
[6052] = { 4,	TN,		sys_socketpair,			"socketpair"		},
[6053] = { 5,	TN,		sys_setsockopt,			"setsockopt"		},
[6054] = { 5,	TN,		sys_getsockopt,			"getsockopt"		},
[6055] = { 5,	TP,		sys_clone,			"clone"			},
[6056] = { 0,	TP,		sys_fork,			"fork"			},
[6057] = { 3,	TF|TP|SE|SI,	sys_execve,			"execve"		},
[6058] = { 1,	TP|SE,		sys_exit,			"exit"			},
[6059] = { 4,	TP,		sys_wait4,			"wait4"			},
[6060] = { 2,	TS,		sys_kill,			"kill"			},
[6061] = { 1,	0,		sys_uname,			"uname"			},
[6062] = { 3,	TI,		sys_semget,			"semget"		},
[6063] = { 3,	TI,		printargs,			"semop"			},
[6064] = { 4,	TI,		sys_semctl,			"semctl"		},
[6065] = { 1,	TI|TM|SI,	sys_shmdt,			"shmdt"			},
[6066] = { 2,	TI,		sys_msgget,			"msgget"		},
[6067] = { 4,	TI,		sys_msgsnd,			"msgsnd"		},
[6068] = { 5,	TI,		sys_msgrcv,			"msgrcv"		},
[6069] = { 3,	TI,		sys_msgctl,			"msgctl"		},
[6070] = { 3,	TD,		sys_fcntl,			"fcntl"			},
[6071] = { 2,	TD,		sys_flock,			"flock"			},
[6072] = { 1,	TD,		sys_fsync,			"fsync"			},
[6073] = { 1,	TD,		sys_fdatasync,			"fdatasync"		},
[6074] = { 2,	TF,		sys_truncate64,			"truncate"		},
[6075] = { 2,	TD,		sys_ftruncate64,		"ftruncate"		},
[6076] = { 3,	TD,		sys_getdents,			"getdents"		},
[6077] = { 2,	TF,		sys_getcwd,			"getcwd"		},
[6078] = { 1,	TF,		sys_chdir,			"chdir"			},
[6079] = { 1,	TD,		sys_fchdir,			"fchdir"		},
[6080] = { 2,	TF,		sys_rename,			"rename"		},
[6081] = { 2,	TF,		sys_mkdir,			"mkdir"			},
[6082] = { 1,	TF,		sys_rmdir,			"rmdir"			},
[6083] = { 2,	TD|TF,		sys_creat,			"creat"			},
[6084] = { 2,	TF,		sys_link,			"link"			},
[6085] = { 1,	TF,		sys_unlink,			"unlink"		},
[6086] = { 2,	TF,		sys_symlink,			"symlink"		},
[6087] = { 3,	TF,		sys_readlink,			"readlink"		},
[6088] = { 2,	TF,		sys_chmod,			"chmod"			},
[6089] = { 2,	TD,		sys_fchmod,			"fchmod"		},
[6090] = { 3,	TF,		sys_chown,			"chown"			},
[6091] = { 3,	TD,		sys_fchown,			"fchown"		},
[6092] = { 3,	TF,		sys_chown,			"lchown"		},
[6093] = { 1,	0,		sys_umask,			"umask"			},
[6094] = { 2,	0,		sys_gettimeofday,		"gettimeofday"		},
[6095] = { 2,	0,		sys_getrlimit,			"getrlimit"		},
[6096] = { 2,	0,		sys_getrusage,			"getrusage"		},
[6097] = { 1,	0,		sys_sysinfo,			"sysinfo"		},
[6098] = { 1,	0,		sys_times,			"times"			},
[6099] = { 4,	0,		sys_ptrace,			"ptrace"		},
[6100] = { 0,	NF,		sys_getuid,			"getuid"		},
[6101] = { 3,	0,		sys_syslog,			"syslog"		},
[6102] = { 0,	NF,		sys_getgid,			"getgid"		},
[6103] = { 1,	0,		sys_setuid,			"setuid"		},
[6104] = { 1,	0,		sys_setgid,			"setgid"		},
[6105] = { 0,	NF,		sys_geteuid,			"geteuid"		},
[6106] = { 0,	NF,		sys_getegid,			"getegid"		},
[6107] = { 2,	0,		sys_setpgid,			"setpgid"		},
[6108] = { 0,	0,		sys_getppid,			"getppid"		},
[6109] = { 0,	0,		sys_getpgrp,			"getpgrp"		},
[6110] = { 0,	0,		sys_setsid,			"setsid"		},
[6111] = { 2,	0,		sys_setreuid,			"setreuid"		},
[6112] = { 2,	0,		sys_setregid,			"setregid"		},
[6113] = { 2,	0,		sys_getgroups,			"getgroups"		},
[6114] = { 2,	0,		sys_setgroups,			"setgroups"		},
[6115] = { 3,	0,		sys_setresuid,			"setresuid"		},
[6116] = { 3,	0,		sys_getresuid,			"getresuid"		},
[6117] = { 3,	0,		sys_setresgid,			"setresgid"		},
[6118] = { 3,	0,		sys_getresgid,			"getresgid"		},
[6119] = { 0,	0,		sys_getpgid,			"getpgid"		},
[6120] = { 1,	NF,		sys_setfsuid,			"setfsuid"		},
[6121] = { 1,	NF,		sys_setfsgid,			"setfsgid"		},
[6122] = { 1,	0,		sys_getsid,			"getsid"		},
[6123] = { 2,	0,		sys_capget,			"capget"		},
[6124] = { 2,	0,		sys_capset,			"capset"		},
[6125] = { 2,	TS,		sys_rt_sigpending,		"rt_sigpending"		},
[6126] = { 4,	TS,		sys_rt_sigtimedwait,		"rt_sigtimedwait"	},
[6127] = { 3,	TS,		sys_rt_sigqueueinfo,		"rt_sigqueueinfo"	},
[6128] = { 2,	TS,		sys_rt_sigsuspend,		"rt_sigsuspend"		},
[6129] = { 2,	TS,		sys_sigaltstack,		"sigaltstack"		},
[6130] = { 2,	TF,		sys_utime,			"utime"			},
[6131] = { 3,	TF,		sys_mknod,			"mknod"			},
[6132] = { 1,	0,		sys_personality,		"personality"		},
[6133] = { 2,	0,		sys_ustat,			"ustat"			},
[6134] = { 3,	TF,		sys_statfs,			"statfs"		},
[6135] = { 3,	TD,		sys_fstatfs,			"fstatfs"		},
[6136] = { 5,	0,		sys_sysfs,			"sysfs"			},
[6137] = { 2,	0,		sys_getpriority,		"getpriority"		},
[6138] = { 3,	0,		sys_setpriority,		"setpriority"		},
[6139] = { 2,	0,		sys_sched_setparam,		"sched_setparam"	},
[6140] = { 2,	0,		sys_sched_getparam,		"sched_getparam"	},
[6141] = { 3,	0,		sys_sched_setscheduler,		"sched_setscheduler"	},
[6142] = { 1,	0,		sys_sched_getscheduler,		"sched_getscheduler"	},
[6143] = { 1,	0,		sys_sched_get_priority_max,	"sched_get_priority_max"},
[6144] = { 1,	0,		sys_sched_get_priority_min,	"sched_get_priority_min"},
[6145] = { 2,	0,		sys_sched_rr_get_interval,	"sched_rr_get_interval"	},
[6146] = { 2,	TM,		sys_mlock,			"mlock"			},
[6147] = { 2,	TM,		sys_munlock,			"munlock"		},
[6148] = { 1,	TM,		sys_mlockall,			"mlockall"		},
[6149] = { 0,	TM,		sys_munlockall,			"munlockall"		},
[6150] = { 0,	0,		sys_vhangup,			"vhangup"		},
[6151] = { 2,	TF,		sys_pivotroot,			"pivot_root"		},
[6152] = { 1,	0,		sys_sysctl,			"_sysctl"		},
[6153] = { 5,	0,		sys_prctl,			"prctl"			},
[6154] = { 1,	0,		sys_adjtimex,			"adjtimex"		},
[6155] = { 2,	0,		sys_setrlimit,			"setrlimit"		},
[6156] = { 1,	TF,		sys_chroot,			"chroot"		},
[6157] = { 0,	0,		sys_sync,			"sync"			},
[6158] = { 1,	TF,		sys_acct,			"acct"			},
[6159] = { 2,	0,		sys_settimeofday,		"settimeofday"		},
[6160] = { 5,	TF,		sys_mount,			"mount"			},
[6161] = { 2,	TF,		sys_umount2,			"umount2"		},
[6162] = { 2,	TF,		sys_swapon,			"swapon"		},
[6163] = { 1,	TF,		sys_swapoff,			"swapoff"		},
[6164] = { 4,	0,		sys_reboot,			"reboot"		},
[6165] = { 2,	0,		sys_sethostname,		"sethostname"		},
[6166] = { 2,	0,		sys_setdomainname,		"setdomainname"		},
[6167] = { 2,	0,		sys_create_module,		"create_module"		},
[6168] = { 4,	0,		sys_init_module,		"init_module"		},
[6169] = { 1,	0,		sys_delete_module,		"delete_module"		},
[6170] = { 1,	0,		sys_get_kernel_syms,		"get_kernel_syms"	},
[6171] = { 5,	0,		sys_query_module,		"query_module"		},
[6172] = { 4,	TF,		sys_quotactl,			"quotactl"		},
[6173] = { 3,	0,		sys_nfsservctl,			"nfsservctl"		},
[6174] = { 5,	TN,		printargs,			"getpmsg"		},
[6175] = { 5,	TN,		printargs,			"putpmsg"		},
[6176] = { 0,	0,		sys_afs_syscall,		"afs_syscall"		},
[6177] = { 0,	0,		printargs,			"reserved177"		},
[6178] = { 0,	0,		sys_gettid,			"gettid"		},
[6179] = { 3,	TD,		sys_readahead,			"readahead"		},
[6180] = { 5,	TF,		sys_setxattr,			"setxattr"		},
[6181] = { 5,	TF,		sys_setxattr,			"lsetxattr"		},
[6182] = { 5,	TD,		sys_fsetxattr,			"fsetxattr"		},
[6183] = { 4,	TF,		sys_getxattr,			"getxattr"		},
[6184] = { 4,	TF,		sys_getxattr,			"lgetxattr"		},
[6185] = { 4,	TD,		sys_fgetxattr,			"fgetxattr"		},
[6186] = { 3,	TF,		sys_listxattr,			"listxattr"		},
[6187] = { 3,	TF,		sys_listxattr,			"llistxattr"		},
[6188] = { 3,	TD,		sys_flistxattr,			"flistxattr"		},
[6189] = { 2,	TF,		sys_removexattr,		"removexattr"		},
[6190] = { 2,	TF,		sys_removexattr,		"lremovexattr"		},
[6191] = { 2,	TD,		sys_fremovexattr,		"fremovexattr"		},
[6192] = { 2,	TS,		sys_kill,			"tkill"			},
[6193] = { 1,	0,		sys_time,			"time"			},
[6194] = { 6,	0,		sys_futex,			"futex"			},
[6195] = { 3,	0,		sys_sched_setaffinity,		"sched_setaffinity"	},
[6196] = { 3,	0,		sys_sched_getaffinity,		"sched_getaffinity"	},
[6197] = { 3,	0,		printargs,			"cacheflush"		},
[6198] = { 3,	0,		printargs,			"cachectl"		},
[6199] = { 4,	0,		sys_sysmips,			"sysmips"		},
[6200] = { 2,	0,		sys_io_setup,			"io_setup"		},
[6201] = { 1,	0,		sys_io_destroy,			"io_destroy"		},
[6202] = { 5,	0,		sys_io_getevents,		"io_getevents"		},
[6203] = { 3,	0,		sys_io_submit,			"io_submit"		},
[6204] = { 3,	0,		sys_io_cancel,			"io_cancel"		},
[6205] = { 1,	TP|SE,		sys_exit,			"exit_group"		},
[6206] = { 3,	0,		sys_lookup_dcookie,		"lookup_dcookie"	},
[6207] = { 1,	TD,		sys_epoll_create,		"epoll_create"		},
[6208] = { 4,	TD,		sys_epoll_ctl,			"epoll_ctl"		},
[6209] = { 4,	TD,		sys_epoll_wait,			"epoll_wait"		},
[6210] = { 5,	TM|SI,		sys_remap_file_pages,		"remap_file_pages"	},
[6211] = { 0,	TS,		sys_rt_sigreturn,		"rt_sigreturn"		},
[6212] = { 3,	TD,		sys_fcntl,			"fcntl64"		},
[6213] = { 1,	0,		sys_set_tid_address,		"set_tid_address"	},
[6214] = { 0,	0,		sys_restart_syscall,		"restart_syscall"	},
[6215] = { 4,	TI,		sys_semtimedop,			"semtimedop"		},
[6216] = { 4,	TD,		sys_fadvise64,			"fadvise64"		},
[6217] = { 3,	TF,		sys_statfs64,			"statfs64"		},
[6218] = { 3,	TD,		sys_fstatfs64,			"fstatfs64"		},
[6219] = { 4,	TD|TN,		sys_sendfile64,			"sendfile64"		},
[6220] = { 3,	0,		sys_timer_create,		"timer_create"		},
[6221] = { 4,	0,		sys_timer_settime,		"timer_settime"		},
[6222] = { 2,	0,		sys_timer_gettime,		"timer_gettime"		},
[6223] = { 1,	0,		sys_timer_getoverrun,		"timer_getoverrun"	},
[6224] = { 1,	0,		sys_timer_delete,		"timer_delete"		},
[6225] = { 2,	0,		sys_clock_settime,		"clock_settime"		},
[6226] = { 2,	0,		sys_clock_gettime,		"clock_gettime"		},
[6227] = { 2,	0,		sys_clock_getres,		"clock_getres"		},
[6228] = { 4,	0,		sys_clock_nanosleep,		"clock_nanosleep"	},
[6229] = { 3,	TS,		sys_tgkill,			"tgkill"		},
[6230] = { 2,	TF,		sys_utimes,			"utimes"		},
[6231] = { 6,	TM,		sys_mbind,			"mbind"			},
[6232] = { 5,	TM,		sys_get_mempolicy,		"get_mempolicy"		},
[6233] = { 3,	TM,		sys_set_mempolicy,		"set_mempolicy"		},
[6234] = { 4,	0,		sys_mq_open,			"mq_open"		},
[6235] = { 1,	0,		sys_mq_unlink,			"mq_unlink"		},
[6236] = { 5,	0,		sys_mq_timedsend,		"mq_timedsend"		},
[6237] = { 5,	0,		sys_mq_timedreceive,		"mq_timedreceive"	},
[6238] = { 2,	0,		sys_mq_notify,			"mq_notify"		},
[6239] = { 3,	0,		sys_mq_getsetattr,		"mq_getsetattr"		},
[6240] = { 5,	0,		sys_vserver,			"vserver"		},
[6241] = { 5,	TP,		sys_waitid,			"waitid"		},
[6242] = { },
[6243] = { 5,	0,		sys_add_key,			"add_key"		},
[6244] = { 4,	0,		sys_request_key,		"request_key"		},
[6245] = { 5,	0,		sys_keyctl,			"keyctl"		},
[6246] = { 1,	0,		sys_set_thread_area,		"set_thread_area"	},
[6247] = { 0,	TD,		sys_inotify_init,		"inotify_init"		},
[6248] = { 3,	TD,		sys_inotify_add_watch,		"inotify_add_watch"	},
[6249] = { 2,	TD,		sys_inotify_rm_watch,		"inotify_rm_watch"	},
[6250] = { 4,	TM,		sys_migrate_pages,		"migrate_pages"		},
[6251] = { 4,	TD|TF,		sys_openat,			"openat"		},
[6252] = { 3,	TD|TF,		sys_mkdirat,			"mkdirat"		},
[6253] = { 4,	TD|TF,		sys_mknodat,			"mknodat"		},
[6254] = { 5,	TD|TF,		sys_fchownat,			"fchownat"		},
[6255] = { 3,	TD|TF,		sys_futimesat,			"futimesat"		},
[6256] = { 4,	TD|TF,		sys_newfstatat,			"newfstatat"		},
[6257] = { 3,	TD|TF,		sys_unlinkat,			"unlinkat"		},
[6258] = { 4,	TD|TF,		sys_renameat,			"renameat"		},
[6259] = { 5,	TD|TF,		sys_linkat,			"linkat"		},
[6260] = { 3,	TD|TF,		sys_symlinkat,			"symlinkat"		},
[6261] = { 4,	TD|TF,		sys_readlinkat,			"readlinkat"		},
[6262] = { 3,	TD|TF,		sys_fchmodat,			"fchmodat"		},
[6263] = { 3,	TD|TF,		sys_faccessat,			"faccessat"		},
[6264] = { 6,	TD,		sys_pselect6,			"pselect6"		},
[6265] = { 5,	TD,		sys_ppoll,			"ppoll"			},
[6266] = { 1,	TP,		sys_unshare,			"unshare"		},
[6267] = { 6,	TD,		sys_splice,			"splice"		},
[6268] = { 4,	TD,		sys_sync_file_range,		"sync_file_range"	},
[6269] = { 4,	TD,		sys_tee,			"tee"			},
[6270] = { 4,	TD,		sys_vmsplice,			"vmsplice"		},
[6271] = { 6,	TM,		sys_move_pages,			"move_pages"		},
[6272] = { 2,	0,		sys_set_robust_list,		"set_robust_list"	},
[6273] = { 3,	0,		sys_get_robust_list,		"get_robust_list"	},
[6274] = { 4,	0,		sys_kexec_load,			"kexec_load"		},
[6275] = { 3,	0,		sys_getcpu,			"getcpu"		},
[6276] = { 6,	TD,		sys_epoll_pwait,		"epoll_pwait"		},
[6277] = { 3,	0,		sys_ioprio_set,			"ioprio_set"		},
[6278] = { 2,	0,		sys_ioprio_get,			"ioprio_get"		},
[6279] = { 4,	TD|TF,		sys_utimensat,			"utimensat"		},
[6280] = { 3,	TD|TS,		sys_signalfd,			"signalfd"		},
[6281] = { 4,	TD,		sys_timerfd,			"timerfd"		},
[6282] = { 1,	TD,		sys_eventfd,			"eventfd"		},
[6283] = { 4,	TD,		sys_fallocate,			"fallocate"		},
[6284] = { 2,	TD,		sys_timerfd_create,		"timerfd_create"	},
[6285] = { 2,	TD,		sys_timerfd_gettime,		"timerfd_gettime"	},
[6286] = { 4,	TD,		sys_timerfd_settime,		"timerfd_settime"	},
[6287] = { 4,	TD|TS,		sys_signalfd4,			"signalfd4"		},
[6288] = { 2,	TD,		sys_eventfd2,			"eventfd2"		},
[6289] = { 1,	TD,		sys_epoll_create1,		"epoll_create1"		},
[6290] = { 3,	TD,		sys_dup3,			"dup3"			},
[6291] = { 2,	TD,		sys_pipe2,			"pipe2"			},
[6292] = { 1,	TD,		sys_inotify_init1,		"inotify_init1"		},
[6293] = { 4,	TD,		sys_preadv,			"preadv"		},
[6294] = { 4,	TD,		sys_pwritev,			"pwritev"		},
[6295] = { 4,	TP|TS,		sys_rt_tgsigqueueinfo,		"rt_tgsigqueueinfo"	},
[6296] = { 5,	TD,		sys_perf_event_open,		"perf_event_open"	},
[6297] = { 4,	TN,		sys_accept4,			"accept4"		},
[6298] = { 5,	TN,		sys_recvmmsg,			"recvmmsg"		},
[6299] = { 3,	TD,		sys_getdents64,			"getdents64"		},
[6300] = { 2,	TD,		sys_fanotify_init,		"fanotify_init"		},
[6301] = { 5,	TD|TF,		sys_fanotify_mark,		"fanotify_mark"		},
[6302] = { 4,	0,		sys_prlimit64,			"prlimit64"		},
[6303] = { 5,	TD|TF,		sys_name_to_handle_at,		"name_to_handle_at"	},
[6304] = { 3,	TD,		sys_open_by_handle_at,		"open_by_handle_at"	},
[6305] = { 2,	0,		sys_clock_adjtime,		"clock_adjtime"		},
[6306] = { 1,	TD,		sys_syncfs,			"syncfs"		},
[6307] = { 4,	TN,		sys_sendmmsg,			"sendmmsg"		},
[6308] = { 2,	TD,		sys_setns,			"setns"			},
[6309] = { 6,	0,		sys_process_vm_readv,		"process_vm_readv"	},
[6310] = { 6,	0,		sys_process_vm_writev,		"process_vm_writev"	},
[6311] = { 5,	0,		sys_kcmp,			"kcmp"			},
[6312] = { 3,	TD,		sys_finit_module,		"finit_module"		},
[6313] = { 3,	0,		sys_sched_setattr,		"sched_setattr"		},
[6314] = { 4,	0,		sys_sched_getattr,		"sched_getattr"		},
[6315] = { 5,	TD|TF,		sys_renameat2,			"renameat2"		},
[6316] = { 3,	0,		sys_seccomp,			"seccomp",		},
[6317] = { 3,	0,		sys_getrandom,			"getrandom",		},
[6318] = { 2,	TD,		sys_memfd_create,		"memfd_create",		},
[6319] = { 3,	TD,		sys_bpf,			"bpf",			},
[6320] = { 5,	TD|TF|TP|SE|SI,	sys_execveat,			"execveat",		},
[6321 ... 6399] = { },

# define SYS_socket_subcall      6400
# include "subcall.h"

#else

# include "syscallent-n32-stub.h"

#endif
