/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2008
*
   BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

#ifndef BUILD_LK
#include <linux/string.h>
#endif
#include "lcm_drv.h"

#ifdef BUILD_LK
	#include <platform/mt_gpio.h>
	#include <platform/mt_pmic.h>
#elif defined(BUILD_UBOOT)
    #include <asm/arch/mt_gpio.h>
#else
	#include <mach/mt_pm_ldo.h>
    #include <mach/mt_gpio.h>
#endif
#include <cust_gpio_usage.h>

#ifdef BUILD_LK
#define LCD_DEBUG(fmt)  dprintf(CRITICAL,fmt)
#else
#define LCD_DEBUG(fmt)  printk(fmt)
#endif
//Lenovo-sw wuwl10 add 20150113 for esd recover backlight
#ifndef BUILD_LK
static unsigned int esd_last_backlight_level = 255;
#endif

static const unsigned int BL_MIN_LEVEL =20;
static LCM_UTIL_FUNCS lcm_util;

#define SET_RESET_PIN(v)    								(lcm_util.set_reset_pin((v)))
#define MDELAY(n) 											(lcm_util.mdelay(n))

// ---------------------------------------------------------------------------
//  Local Functions
// ---------------------------------------------------------------------------

#define dsi_set_cmdq_V2(cmd, count, ppara, force_update)	lcm_util.dsi_set_cmdq_V2(cmd, count, ppara, force_update)
#define dsi_set_cmdq(pdata, queue_size, force_update)		lcm_util.dsi_set_cmdq(pdata, queue_size, force_update)
#define wrtie_cmd(cmd)										lcm_util.dsi_write_cmd(cmd)
#define write_regs(addr, pdata, byte_nums)					lcm_util.dsi_write_regs(addr, pdata, byte_nums)
#define read_reg(cmd)										lcm_util.dsi_dcs_read_lcm_reg(cmd)
#define read_reg_v2(cmd, buffer, buffer_size)   			lcm_util.dsi_dcs_read_lcm_reg_v2(cmd, buffer, buffer_size)    

// ---------------------------------------------------------------------------
//  Local Constants
// ---------------------------------------------------------------------------

#define FRAME_WIDTH  										(720)
#define FRAME_HEIGHT 										(1280)

#define REGFLAG_DELAY             							0XFE
#define REGFLAG_END_OF_TABLE      							0xFF   // END OF REGISTERS MARKER

#ifndef GPIO_LCD_BIAS_ENP_PIN
#define GPIO_LCD_BIAS_ENP_PIN GPIO122
#endif
#ifndef GPIO_LCD_BIAS_ENN_PIN
#define GPIO_LCD_BIAS_ENN_PIN GPIO95
#endif
#ifndef GPIO_LCM_BL_EN
#define GPIO_LCM_BL_EN GPIO113
#endif
#ifndef GPIO_LCM_LED_EN
#define GPIO_LCM_LED_EN GPIO94
#endif
#ifndef GPIO_DISP_ID0_PIN
#define GPIO_DISP_ID0_PIN GPIO114
#endif

#define LCM_DSI_CMD_MODE									0
#ifndef FPGA_EARLY_PORTING
#define GPIO_65132_EN GPIO_LCD_BIAS_ENP_PIN
#endif

#define LCM_ID_HX8394 0x94

// ---------------------------------------------------------------------------
//  Local Variables
// ---------------------------------------------------------------------------

static LCM_UTIL_FUNCS lcm_util = {0};

#define SET_RESET_PIN(v)    								(lcm_util.set_reset_pin((v)))

#define UDELAY(n) 											(lcm_util.udelay(n))
#define MDELAY(n) 											(lcm_util.mdelay(n))


// ---------------------------------------------------------------------------
//  Local Functions
// ---------------------------------------------------------------------------

#define dsi_set_cmdq_V2(cmd, count, ppara, force_update)	lcm_util.dsi_set_cmdq_V2(cmd, count, ppara, force_update)
#define dsi_set_cmdq(pdata, queue_size, force_update)		lcm_util.dsi_set_cmdq(pdata, queue_size, force_update)
#define wrtie_cmd(cmd)										lcm_util.dsi_write_cmd(cmd)
#define write_regs(addr, pdata, byte_nums)					lcm_util.dsi_write_regs(addr, pdata, byte_nums)
#define read_reg											lcm_util.dsi_read_reg()
#define read_reg_v2(cmd, buffer, buffer_size)   			lcm_util.dsi_dcs_read_lcm_reg_v2(cmd, buffer, buffer_size)    
       

static struct LCM_setting_table {
    unsigned cmd;
    unsigned char count;
    unsigned char para_list[64];
};


static struct LCM_setting_table lcm_sleep_out_setting[] = {
    // Sleep Out
	{0x11, 0, {0x00}},
    {REGFLAG_DELAY, 100, {}},

    // Display ON
	{0x29, 0, {0x00}},
	{REGFLAG_DELAY, 10, {}},
	
	{REGFLAG_END_OF_TABLE, 0x00, {}}
};


static struct LCM_setting_table lcm_sleep_in_setting[] = {
	// Display off sequence
	{0x28, 0, {0x00}},

    // Sleep Mode On
	{0x10, 0, {0x00}},

	{REGFLAG_END_OF_TABLE, 0x00, {}}
};
static struct LCM_setting_table lcm_backlight_level_setting[] = {
{0x51, 1, {0xFF}},
{REGFLAG_END_OF_TABLE, 0x00, {}}
};
static struct LCM_setting_table lcm_cabc_level_setting[] = {
{0x55, 1, {0x00}},
{REGFLAG_END_OF_TABLE, 0x00, {}}
};
static struct LCM_setting_table lcm_inverse_off_setting[] = {
{0x20, 1, {0x00}},
{REGFLAG_END_OF_TABLE, 0x00, {}}
};
static struct LCM_setting_table lcm_inverse_on_setting[] = {
{0x21, 1, {0x00}},
{REGFLAG_END_OF_TABLE, 0x00, {}}
};

static void push_table(struct LCM_setting_table *table, unsigned int count, unsigned char force_update)
{
	unsigned int i;

    for(i = 0; i < count; i++) {
		
        unsigned cmd;
        cmd = table[i].cmd;
		
        switch (cmd) {
			
            case REGFLAG_DELAY :
                MDELAY(table[i].count);
                break;
				
            case REGFLAG_END_OF_TABLE :
                break;
				
            default:
				dsi_set_cmdq_V2(cmd, table[i].count, table[i].para_list, force_update);
       	}
    }
	
}


// ---------------------------------------------------------------------------
//  LCM Driver Implementations
// ---------------------------------------------------------------------------

static void lcm_set_util_funcs(const LCM_UTIL_FUNCS *util)
{
    memcpy(&lcm_util, util, sizeof(LCM_UTIL_FUNCS));
}


static void lcm_get_params(LCM_PARAMS *params)
{
		memset(params, 0, sizeof(LCM_PARAMS));
	
		params->type   = LCM_TYPE_DSI;

		params->width  = FRAME_WIDTH;
		params->height = FRAME_HEIGHT;

#if (LCM_DSI_CMD_MODE)
		params->dsi.mode   = CMD_MODE;
#else
		params->dsi.mode   = BURST_VDO_MODE;
#endif
	
		// DSI
		/* Command mode setting */
		params->dsi.LANE_NUM				= LCM_FOUR_LANE;
        //The following defined the fomat for data coming from LCD engine.
        params->dsi.data_format.color_order     = LCM_COLOR_ORDER_RGB;
        params->dsi.data_format.trans_seq       = LCM_DSI_TRANS_SEQ_MSB_FIRST;
        params->dsi.data_format.padding         = LCM_DSI_PADDING_ON_LSB;
        params->dsi.data_format.format              = LCM_DSI_FORMAT_RGB888;

        // Highly depends on LCD driver capability.
        params->dsi.packet_size=256;

		params->dsi.PS=LCM_PACKED_PS_24BIT_RGB888;

		params->dsi.vertical_sync_active				= 2;
		params->dsi.vertical_backporch					= 14;
		params->dsi.vertical_frontporch					= 16;
		params->dsi.vertical_active_line				= FRAME_HEIGHT; 

		params->dsi.horizontal_sync_active				= 2;
		params->dsi.horizontal_backporch				= 42;
		params->dsi.horizontal_frontporch				= 44;
		params->dsi.horizontal_active_pixel				= FRAME_WIDTH;

#ifndef FPGA_EARLY_PORTING
        params->dsi.PLL_CLOCK = 220; //this value must be in MTK suggested table
#else
        params->dsi.pll_div1 = 0;
        params->dsi.pll_div2 = 0;
        params->dsi.fbk_div = 0x1;
#endif
//lenovo_sw wuwl10 20150113 modify for enable esd check
#if 0
	    params->dsi.esd_check_enable =1;
	    params->dsi.customization_esd_check_enable =1;

	    params->dsi.lcm_esd_check_table[2].cmd =0xD9;
	    params->dsi.lcm_esd_check_table[2].count =1;
	    params->dsi.lcm_esd_check_table[2].para_list[0] =0x80;


	    params->dsi.lcm_esd_check_table[1].cmd =0x0A;
	    params->dsi.lcm_esd_check_table[1].count =1;
	    params->dsi.lcm_esd_check_table[1].para_list[0] =0x1C;

	    params->dsi.lcm_esd_check_table[0].cmd =0x09;
	    params->dsi.lcm_esd_check_table[0].count =4;
	    params->dsi.lcm_esd_check_table[0].para_list[0] =0x80;
	    params->dsi.lcm_esd_check_table[0].para_list[1] =0x73;
	    params->dsi.lcm_esd_check_table[0].para_list[2] =0x06;
	    params->dsi.lcm_esd_check_table[0].para_list[3] =0x00;
#endif

}
const static unsigned char LCD_MODULE_ID = 0x01; 

static unsigned int lcm_compare_id(void)
{

unsigned char  id_pin_read = 0;


#ifdef GPIO_DISP_ID0_PIN
	id_pin_read = mt_get_gpio_in(GPIO_DISP_ID0_PIN);
	#endif
	#ifdef BUILD_LK
		dprintf(0, "%s,LCD_ID_value=%d \n", __func__, id_pin_read);
	#endif
	if(LCD_MODULE_ID == id_pin_read)
		return 1;
	else
		return 0;
}


static void lcm_init(void)
{
	unsigned int data_array[16];
	int ret=0;

	SET_RESET_PIN(1);
	MDELAY(1);
   	SET_RESET_PIN(0);
	MDELAY(1);
    SET_RESET_PIN(1);
	MDELAY(5);

	mt_set_gpio_mode(GPIO_LCD_BIAS_ENP_PIN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCD_BIAS_ENP_PIN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCD_BIAS_ENP_PIN, GPIO_OUT_ONE);
	MDELAY(10);

	mt_set_gpio_mode(GPIO_LCD_BIAS_ENN_PIN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCD_BIAS_ENN_PIN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCD_BIAS_ENN_PIN, GPIO_OUT_ONE);
	MDELAY(50);

    data_array[0]= 0x00043902;
	data_array[1]= 0x9483FFB9;
	dsi_set_cmdq(&data_array, 2, 1);

	data_array[0]= 0x00033902;
	data_array[1]= 0x008333BA;
	dsi_set_cmdq(&data_array, 2, 1);

	data_array[0]= 0x00103902;
	data_array[1]= 0x0E0E6CB1;
	data_array[2]= 0xF1110437;
	data_array[3]= 0x2395E880;
	data_array[4]= 0x18D2C080;
	dsi_set_cmdq(&data_array, 5, 1);

	data_array[0]= 0x000C3902;
	data_array[1]= 0x0E6400B2;
	data_array[2]= 0x0823320D;
	data_array[3]= 0x004D1C08;
	dsi_set_cmdq(&data_array, 4, 1);

	data_array[0]= 0x000D3902;
	data_array[1]= 0x03FF00B4;
	data_array[2]= 0x03500350;
	data_array[3]= 0x016A0150;
	data_array[4]= 0x0000006A;
	dsi_set_cmdq(&data_array, 5, 1);

    data_array[0]= 0x00043902;
	data_array[1]= 0x010E41BF;
	dsi_set_cmdq(&data_array, 2, 1);

	data_array[0]= 0x00263902;
	data_array[1]= 0x000700D3; //GIP
	data_array[2]= 0x00100000;
	data_array[3]= 0x00051032;
	data_array[4]= 0x00103200;
	data_array[5]= 0x10320000;
	data_array[6]= 0x36000000;
	data_array[7]= 0x37090903;
	data_array[8]= 0x00370000;
	data_array[9]= 0x0A000000;
	data_array[10]= 0x00000100;
	dsi_set_cmdq(&data_array, 11, 1);

	data_array[0]= 0x002D3902;
	data_array[1]= 0x000302D5;
	data_array[2]= 0x04070601;
	data_array[3]= 0x22212005;
	data_array[4]= 0x18181823;
	data_array[5]= 0x18181818;
	data_array[6]= 0x18181818;
	data_array[7]= 0x18181818;
	data_array[8]= 0x18181818;
	data_array[9]= 0x18181818;
	data_array[10]= 0x24181818;
	data_array[11]= 0x19181825;
	data_array[12]= 0x00000019;
	dsi_set_cmdq(&data_array, 13, 1);

	data_array[0]= 0x002D3902;
	data_array[1]= 0x070405D6;
	data_array[2]= 0x03000106;
	data_array[3]= 0x21222302;
	data_array[4]= 0x18181820;
	data_array[5]= 0x58181818;
	data_array[6]= 0x18181858;
	data_array[7]= 0x18181818;
	data_array[8]= 0x18181818;
	data_array[9]= 0x18181818;
	data_array[10]= 0x25181818;
	data_array[11]= 0x18191924;
	data_array[12]= 0x00000018;
	dsi_set_cmdq(&data_array, 13, 1);
	

	data_array[0]= 0x002B3902;
	data_array[1]= 0x231F07E0;
	data_array[2]= 0x2E3F3B38;
	data_array[3]= 0x0D0B0846;
	data_array[4]= 0x15120F17;
	data_array[5]= 0x12081413;
	data_array[6]= 0x1F071916;
	data_array[7]= 0x3F3B3823;
	data_array[8]= 0x0B08462E;
	data_array[9]= 0x120F170D;
	data_array[10]= 0x08141315;
	data_array[11]= 0x00191612;
	dsi_set_cmdq(&data_array, 12, 1);

    data_array[0]= 0x00023902;
	data_array[1]= 0x000009CC;
	dsi_set_cmdq(&data_array, 2, 1);

	data_array[0]= 0x00053902;
	data_array[1]= 0x40C000C7;
	data_array[2]= 0x000000C0;
	dsi_set_cmdq(&data_array, 3, 1);
	MDELAY(10);

    data_array[0]= 0x00033902;
	data_array[1]= 0x007575B6;
	dsi_set_cmdq(&data_array, 2, 1);

    data_array[0]= 0x00033902;
	data_array[1]= 0x001430C0;
	dsi_set_cmdq(&data_array, 2, 1);

    data_array[0]= 0x00023902;
	data_array[1]= 0x000007BC;
	dsi_set_cmdq(&data_array, 2, 1);
 
 	data_array[0]= 0x00043902;
	data_array[1]= 0x14001fC9;// PWM 20K
	dsi_set_cmdq(&data_array, 2, 1);

	data_array[0] = 0x00352300;//te on
	dsi_set_cmdq(&data_array, 1, 1);

	data_array[0] = 0x00512300;//bl mode
	dsi_set_cmdq(&data_array, 1, 1);

	data_array[0] = 0x24532300;//bl mode
	dsi_set_cmdq(&data_array, 1, 1);

	data_array[0] = 0x02552300;//cabc 03
	dsi_set_cmdq(&data_array, 1, 1);

        data_array[0] = 0x325E2300;//cabc min limit
        dsi_set_cmdq(&data_array, 1, 1);

/*
	data_array[0] = 0x01552300;
	dsi_set_cmdq(&data_array, 1, 1);

	MDELAY(5);
	data_array[0]= 0x00033902;
	data_array[1]= 0x000101E4;
	dsi_set_cmdq(&data_array, 2, 1);
*/
	MDELAY(5);
	data_array[0] = 0x00110500;	
	dsi_set_cmdq(&data_array, 1, 1);
	MDELAY(120);

	data_array[0] = 0x00290500;	
	dsi_set_cmdq(&data_array, 1, 1);
	MDELAY(20);

#ifdef GPIO_LCM_BL_EN
	mt_set_gpio_mode(GPIO_LCM_BL_EN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCM_BL_EN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCM_BL_EN, GPIO_OUT_ONE);
#endif
#ifdef GPIO_LCM_LED_EN
	mt_set_gpio_mode(GPIO_LCM_LED_EN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCM_LED_EN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCM_LED_EN, GPIO_OUT_ONE);
#endif
} 

static void lcm_suspend(void)
{
#ifdef GPIO_LCM_BL_EN
	mt_set_gpio_mode(GPIO_LCM_BL_EN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCM_BL_EN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCM_BL_EN, GPIO_OUT_ZERO);
#endif
#ifdef GPIO_LCM_LED_EN
	mt_set_gpio_mode(GPIO_LCM_LED_EN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCM_LED_EN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCM_LED_EN, GPIO_OUT_ZERO);
#endif
	SET_RESET_PIN(1);	
	MDELAY(10);	
	SET_RESET_PIN(0);
	MDELAY(10);	
	SET_RESET_PIN(1);

MDELAY(120);
	mt_set_gpio_mode(GPIO_LCD_BIAS_ENN_PIN, GPIO_MODE_00); //lenovo.sw2 houdz modify first VSN power down then VSP power down
	mt_set_gpio_dir(GPIO_LCD_BIAS_ENN_PIN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCD_BIAS_ENN_PIN, GPIO_OUT_ZERO);
MDELAY(5);
	mt_set_gpio_mode(GPIO_LCD_BIAS_ENP_PIN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCD_BIAS_ENP_PIN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCD_BIAS_ENP_PIN, GPIO_OUT_ZERO);
MDELAY(50);//250->50 lenovo.sw2 houdz modify
}

static void lcm_resume(void)
{
	lcm_init();
}

static void lcm_update(unsigned int x, unsigned int y,
                       unsigned int width, unsigned int height)
{
	unsigned int x0 = x;
	unsigned int y0 = y;
	unsigned int x1 = x0 + width - 1;
	unsigned int y1 = y0 + height - 1;

	unsigned char x0_MSB = ((x0>>8)&0xFF);
	unsigned char x0_LSB = (x0&0xFF);
	unsigned char x1_MSB = ((x1>>8)&0xFF);
	unsigned char x1_LSB = (x1&0xFF);
	unsigned char y0_MSB = ((y0>>8)&0xFF);
	unsigned char y0_LSB = (y0&0xFF);
	unsigned char y1_MSB = ((y1>>8)&0xFF);
	unsigned char y1_LSB = (y1&0xFF);

	unsigned int data_array[16];

	data_array[0]= 0x00053902;
	data_array[1]= (x1_MSB<<24)|(x0_LSB<<16)|(x0_MSB<<8)|0x2a;
	data_array[2]= (x1_LSB);
	dsi_set_cmdq(data_array, 3, 1);
	
	data_array[0]= 0x00053902;
	data_array[1]= (y1_MSB<<24)|(y0_LSB<<16)|(y0_MSB<<8)|0x2b;
	data_array[2]= (y1_LSB);
	dsi_set_cmdq(data_array, 3, 1);
	
	data_array[0]= 0x002c3909;
	dsi_set_cmdq(data_array, 1, 0);	
}

static void lcm_setbacklight(unsigned int level)
{
#ifdef BUILD_LK
	dprintf(0,"%s,lk hx8394d tm backlight: level = %d\n", __func__, level);
#else
	printk("%s, kernel hx8394d tm backlight: level = %d\n", __func__, level);
//Lenovo-sw wuwl10 add 20150113 for esd recover backlight
	esd_last_backlight_level = level;
#endif
//Lenovo-sw wuwl10 add 20150109 for min backlight control
	if((0 < level) && (level < 5))
	{
		level = 5;
	}
	// Refresh value of backlight level.
	lcm_backlight_level_setting[0].para_list[0] = level;
	
	push_table(lcm_backlight_level_setting, sizeof(lcm_backlight_level_setting) / sizeof(struct LCM_setting_table), 1);

}


//Lenovo-sw wuwl10 add 20150113 for esd recover backlight begin
#ifndef BUILD_LK
static void lcm_esd_recover_backlight(void)
{
	printk("%s, kernel hx8394d tm recover backlight: level = %d\n", __func__, esd_last_backlight_level);

	// recovder last backlight level.
	lcm_backlight_level_setting[0].para_list[0] = esd_last_backlight_level;
	push_table(lcm_backlight_level_setting, sizeof(lcm_backlight_level_setting) / sizeof(struct LCM_setting_table), 1);
}
#endif
//Lenovo-sw wuwl10 add 20150113 for esd recover backlight end

#ifdef CONFIG_LENOVO_CUSTOM_LCM_FEATURE
static void lcm_set_cabcmode(unsigned int mode)
{
#ifdef BUILD_LK
	dprintf(0,"%s mode = %d\n", __func__, mode);
#else
	printk("%s mode = %d\n", __func__, mode);
#endif
	// Refresh value of backlight level.
	lcm_cabc_level_setting[0].para_list[0] = mode;
	
	push_table(lcm_cabc_level_setting, sizeof(lcm_cabc_level_setting) / sizeof(struct LCM_setting_table), 1);

}
static void lcm_set_inversemode(unsigned int mode)
{
#ifdef BUILD_LK
	dprintf(0,"%s mode = %d\n", __func__, mode);
#else
	printk("%s mode = %d\n", __func__, mode);
#endif
	// Refresh value of backlight level.
if(mode)	
	push_table(lcm_inverse_on_setting, sizeof(lcm_inverse_on_setting) / sizeof(struct LCM_setting_table), 1);
else
	push_table(lcm_inverse_off_setting, sizeof(lcm_inverse_off_setting) / sizeof(struct LCM_setting_table), 1);
}
#endif
LCM_DRIVER hx8394d_hd720_dsi_vdo_tm_lcm_drv = 
{
    .name			= "hx8394d_dsi_vdo_tm",
	.set_util_funcs = lcm_set_util_funcs,
	.get_params     = lcm_get_params,
	.init           = lcm_init,
	.suspend        = lcm_suspend,
	.resume         = lcm_resume,
	.compare_id     = lcm_compare_id,
	.set_backlight	= lcm_setbacklight,
//Lenovo-sw wuwl10 add 20150113 for esd recover backlight begin
#ifndef BUILD_LK
	//.esd_recover_backlight = lcm_esd_recover_backlight,^
#endif
//Lenovo-sw wuwl10 add 20150113 for esd recover backlight end
#ifdef CONFIG_LENOVO_CUSTOM_LCM_FEATURE
	.set_cabcmode = lcm_set_cabcmode,
	.set_inversemode = lcm_set_inversemode,
#endif
#if (LCM_DSI_CMD_MODE)
    .update         = lcm_update,
#endif
};
