#ifndef _CUST_BATTERY_METER_TABLE_H
#define _CUST_BATTERY_METER_TABLE_H

#include <mach/mt_typedefs.h>

// ============================================================
// define
// ============================================================
#define BAT_NTC_10 1
#define BAT_NTC_47 0

#if (BAT_NTC_10 == 1)
#define RBAT_PULL_UP_R             24000	
#endif

#if (BAT_NTC_47 == 1)
#define RBAT_PULL_UP_R             61900	
#endif

#define RBAT_PULL_UP_VOLT          2800



// ============================================================
// ENUM
// ============================================================

// ============================================================
// structure
// ============================================================

// ============================================================
// typedef
// ============================================================
typedef struct _BATTERY_PROFILE_STRUC
{
    kal_int32 percentage;
    kal_int32 voltage;
} BATTERY_PROFILE_STRUC, *BATTERY_PROFILE_STRUC_P;

typedef struct _R_PROFILE_STRUC
{
    kal_int32 resistance; // Ohm
    kal_int32 voltage;
} R_PROFILE_STRUC, *R_PROFILE_STRUC_P;

typedef enum
{
    T1_0C,
    T2_25C,
    T3_50C
} PROFILE_TEMPERATURE;

// ============================================================
// External Variables
// ============================================================

// ============================================================
// External function
// ============================================================

// ============================================================
// <DOD, Battery_Voltage> Table
// ============================================================
#if (BAT_NTC_10 == 1)
/*lenovo-sw mahj2 update NTC param begin 2014-10-21 */
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
        {-20,67790},
        {-15,53460},
        {-10,42450},
        { -5,33930},
        {  0,27280},
        {  5,22070},
        { 10,17960},
        { 15,14700},
        { 20,12090},
        { 25,10000},
        { 30,8312},
        { 35,6942},
        { 40,5826},
        { 45,4911},
        { 50,4158},
        { 55,3536},
        { 60,3019}
    };
/*lenovo-sw mahj2 update NTC param end 2014-10-21 */
#endif

#if (BAT_NTC_47 == 1)
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
        {-20,483954},
        {-15,360850},
        {-10,271697},
        { -5,206463},
        {  0,158214},
        {  5,122259},
        { 10,95227},
        { 15,74730},
        { 20,59065},
        { 25,47000},
        { 30,37643},
        { 35,30334},
        { 40,24591},
        { 45,20048},
        { 50,16433},
        { 55,13539},
        { 60,11210}        
    };
#endif
/*lenovo-sw mahj2 update battery param begin 2014-10-21 */
// T0 -10C
BATTERY_PROFILE_STRUC battery_profile_t0[] =
{
{0, 4345},
{1, 4334},
{2, 4323},
{3, 4315},
{4, 4307},
{5, 4292},
{6, 4285},
{7, 4278},
{8, 4273},
{9, 4268},
{10, 4262},
{11, 4255},
{12, 4243},
{13, 4238},
{14, 4232},
{15, 4226},
{16, 4220},
{17, 4214},
{18, 4209},
{19, 4198},
{20, 4193},
{21, 4188},
{22, 4182},
{23, 4177},
{24, 4172},
{25, 4167},
{26, 4162},
{27, 4156},
{28, 4146},
{29, 4140},
{30, 4134},
{31, 4129},
{32, 4124},
{33, 4119},
{34, 4114},
{35, 4106},
{36, 4102},
{37, 4099},
{38, 4094},
{39, 4090},
{40, 4086},
{41, 4082},
{42, 4069},
{43, 4060},
{44, 4051},
{45, 4040},
{46, 4030},
{47, 4022},
{48, 4013},
{49, 4004},
{50, 3996},
{51, 3983},
{52, 3978},
{53, 3972},
{54, 3967},
{55, 3962},
{56, 3958},
{57, 3954},
{58, 3945},
{59, 3942},
{60, 3938},
{61, 3935},
{62, 3932},
{63, 3928},
{64, 3924},
{65, 3919},
{66, 3916},
{67, 3912},
{68, 3909},
{69, 3906},
{70, 3902},
{71, 3898},
{72, 3894},
{73, 3891},
{74, 3884},
{75, 3882},
{76, 3879},
{77, 3876},
{78, 3872},
{79, 3870},
{80, 3868},
{81, 3861},
{82, 3858},
{83, 3855},
{84, 3852},
{85, 3849},
{86, 3846},
{87, 3844},
{88, 3839},
{89, 3836},
{90, 3834},
{91, 3832},
{92, 3829},
{93, 3828},
{94, 3826},
{95, 3822},
{96, 3820},
{97, 3819},
{98, 3816},
{99, 3814},
{100, 3812}
};      
        
// T1 0C 
BATTERY_PROFILE_STRUC battery_profile_t1[] =
{
{0, 4334},
{1, 4317},
{2, 4301},
{3, 4294},
{4, 4288},
{5, 4276},
{6, 4264},
{7, 4253},
{8, 4241},
{9, 4235},
{10, 4229},
{11, 4219},
{12, 4207},
{13, 4196},
{14, 4186},
{15, 4175},
{16, 4170},
{17, 4164},
{18, 4155},
{19, 4144},
{20, 4134},
{21, 4123},
{22, 4118},
{23, 4113},
{24, 4103},
{25, 4094},
{26, 4088},
{27, 4083},
{28, 4080},
{29, 4076},
{30, 4063},
{31, 4046},
{32, 4025},
{33, 4006},
{34, 3998},
{35, 3989},
{36, 3976},
{37, 3966},
{38, 3958},
{39, 3952},
{40, 3944},
{41, 3941},
{42, 3938},
{43, 3932},
{44, 3925},
{45, 3916},
{46, 3910},
{47, 3905},
{48, 3900},
{49, 3893},
{50, 3885},
{51, 3878},
{52, 3870},
{53, 3867},
{54, 3864},
{55, 3858},
{56, 3852},
{57, 3847},
{58, 3842},
{59, 3838},
{60, 3835},
{61, 3830},
{62, 3825},
{63, 3822},
{64, 3818},
{65, 3816},
{66, 3814},
{67, 3809},
{68, 3807},
{69, 3805},
{70, 3801},
{71, 3797},
{72, 3796},
{73, 3795},
{74, 3791},
{75, 3788},
{76, 3787},
{77, 3786},
{78, 3785},
{79, 3784},
{80, 3782},
{81, 3780},
{82, 3780},
{83, 3777},
{84, 3776},
{85, 3776},
{86, 3773},
{87, 3771},
{88, 3767},
{89, 3764},
{90, 3762},
{91, 3760},
{92, 3755},
{93, 3752},
{94, 3748},
{95, 3744},
{96, 3738},
{97, 3735},
{98, 3732},
{99, 3724},
{100, 3718}
       
};           

// T2 25C
BATTERY_PROFILE_STRUC battery_profile_t2[] =
{
{0, 4328},
{1, 4311},
{2, 4297},
{3, 4286},
{4, 4273},
{5, 4261},
{6, 4249},
{7, 4238},
{8, 4226},
{9, 4220},
{10, 4214},
{11, 4202},
{12, 4192},
{13, 4179},
{14, 4168},
{15, 4157},
{16, 4147},
{17, 4137},
{18, 4125},
{19, 4115},
{20, 4105},
{21, 4094},
{22, 4084},
{23, 4075},
{24, 4068},
{25, 4066},
{26, 4056},
{27, 4048},
{28, 4040},
{29, 4022},
{30, 4006},
{31, 3993},
{32, 3984},
{33, 3978},
{34, 3975},
{35, 3970},
{36, 3963},
{37, 3956},
{38, 3950},
{39, 3941},
{40, 3933},
{41, 3924},
{42, 3915},
{43, 3902},
{44, 3890},
{45, 3880},
{46, 3876},
{47, 3871},
{48, 3864},
{49, 3858},
{50, 3851},
{51, 3846},
{52, 3841},
{53, 3835},
{54, 3829},
{55, 3825},
{56, 3822},
{57, 3818},
{58, 3813},
{59, 3809},
{60, 3806},
{61, 3804},
{62, 3801},
{63, 3796},
{64, 3795},
{65, 3794},
{66, 3790},
{67, 3787},
{68, 3786},
{69, 3782},
{70, 3780},
{71, 3778},
{72, 3775},
{73, 3771},
{74, 3766},
{75, 3762},
{76, 3759},
{77, 3755},
{78, 3750},
{79, 3747},
{80, 3745},
{81, 3740},
{82, 3738},
{83, 3737},
{84, 3735},
{85, 3729},
{86, 3724},
{87, 3718},
{88, 3712},
{89, 3705},
{90, 3697},
{91, 3689},
{92, 3686},
{93, 3686},
{94, 3686},
{95, 3684},
{96, 3682},
{97, 3675},
{98, 3660},
{99, 3623},
{100, 3572}
       
};     

// T3 50C
BATTERY_PROFILE_STRUC battery_profile_t3[] =
{
{0, 4325},
{1, 4308},
{2, 4295},
{3, 4284},
{4, 4271},
{5, 4258},
{6, 4246},
{7, 4236},
{8, 4223},
{9, 4212},
{10, 4206},
{11, 4200},
{12, 4188},
{13, 4176},
{14, 4165},
{15, 4154},
{16, 4144},
{17, 4132},
{18, 4122},
{19, 4112},
{20, 4101},
{21, 4092},
{22, 4081},
{23, 4072},
{24, 4062},
{25, 4053},
{26, 4045},
{27, 4034},
{28, 4023},
{29, 4013},
{30, 4008},
{31, 4002},
{32, 3996},
{33, 3988},
{34, 3980},
{35, 3972},
{36, 3964},
{37, 3956},
{38, 3948},
{39, 3941},
{40, 3934},
{41, 3924},
{42, 3915},
{43, 3903},
{44, 3891},
{45, 3881},
{46, 3872},
{47, 3865},
{48, 3859},
{49, 3852},
{50, 3846},
{51, 3844},
{52, 3842},
{53, 3836},
{54, 3831},
{55, 3825},
{56, 3821},
{57, 3819},
{58, 3813},
{59, 3809},
{60, 3806},
{61, 3804},
{62, 3800},
{63, 3797},
{64, 3794},
{65, 3789},
{66, 3787},
{67, 3785},
{68, 3782},
{69, 3779},
{70, 3777},
{71, 3775},
{72, 3773},
{73, 3768},
{74, 3759},
{75, 3753},
{76, 3748},
{77, 3745},
{78, 3742},
{79, 3737},
{80, 3732},
{81, 3731},
{82, 3727},
{83, 3722},
{84, 3719},
{85, 3713},
{86, 3709},
{87, 3701},
{88, 3696},
{89, 3689},
{90, 3681},
{91, 3680},
{92, 3679},
{93, 3678},
{94, 3677},
{95, 3676},
{96, 3673},
{97, 3668},
{98, 3651},
{99, 3615},
{100, 3567}
     
};           

// battery profile for actual temperature. The size should be the same as T1, T2 and T3
BATTERY_PROFILE_STRUC battery_profile_temperature[] =
{
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0}
};    

// ============================================================
// <Rbat, Battery_Voltage> Table
// ============================================================
// T0 -10C
R_PROFILE_STRUC r_profile_t0[] =
{
{990, 4345},
{990, 4334},
{990, 4323},
{995, 4315},
{1000, 4307},
{1001, 4292},
{1002, 4285},
{1002, 4278},
{1002, 4273},
{1001, 4268},
{1000, 4262},
{998, 4255},
{987, 4243},
{988, 4238},
{988, 4232},
{984, 4226},
{980, 4220},
{976, 4214},
{973, 4209},
{970, 4198},
{968, 4193},
{965, 4188},
{962, 4182},
{960, 4177},
{960, 4172},
{959, 4167},
{958, 4162},
{956, 4156},
{957, 4146},
{990, 4140},
{1022, 4134},
{1040, 4129},
{1057, 4124},
{1056, 4119},
{1055, 4114},
{1059, 4106},
{1063, 4102},
{1067, 4099},
{1068, 4094},
{1069, 4090},
{1068, 4086},
{1067, 4082},
{1065, 4069},
{1057, 4060},
{1049, 4051},
{1040, 4040},
{1032, 4030},
{1027, 4022},
{1022, 4013},
{1016, 4004},
{1009, 3996},
{1003, 3983},
{1002, 3978},
{1000, 3972},
{1000, 3967},
{1000, 3962},
{1002, 3958},
{1003, 3954},
{1001, 3945},
{1002, 3942},
{1004, 3938},
{1004, 3935},
{1005, 3932},
{998, 3928},
{992, 3924},
{999, 3919},
{998, 3916},
{998, 3912},
{998, 3909},
{998, 3906},
{1022, 3902},
{1047, 3898},
{1024, 3894},
{1002, 3891},
{998, 3884},
{1002, 3882},
{1005, 3879},
{1000, 3876},
{994, 3872},
{998, 3870},
{1001, 3868},
{996, 3861},
{998, 3858},
{999, 3855},
{998, 3852},
{998, 3849},
{1002, 3846},
{1005, 3844},
{1008, 3839},
{1010, 3836},
{1012, 3834},
{1012, 3832},
{1012, 3829},
{1018, 3828},
{1023, 3826},
{1021, 3822},
{1024, 3820},
{1026, 3819},
{1027, 3816},
{889, 3814},
{889, 3812}
};      

// T1 0C
R_PROFILE_STRUC r_profile_t1[] =
{
{573, 4334},
{573, 4317},
{585, 4301},
{600, 4294},
{616, 4288},
{602, 4276},
{604, 4264},
{617, 4253},
{613, 4241},
{612, 4235},
{611, 4229},
{609, 4219},
{602, 4207},
{600, 4196},
{597, 4186},
{608, 4175},
{597, 4170},
{586, 4164},
{599, 4155},
{600, 4144},
{571, 4134},
{582, 4123},
{578, 4118},
{574, 4113},
{570, 4103},
{566, 4094},
{574, 4088},
{589, 4083},
{591, 4080},
{593, 4076},
{585, 4063},
{575, 4046},
{560, 4025},
{556, 4006},
{554, 3998},
{552, 3989},
{553, 3976},
{553, 3966},
{551, 3958},
{557, 3952},
{554, 3944},
{554, 3941},
{553, 3938},
{547, 3932},
{553, 3925},
{547, 3916},
{546, 3910},
{537, 3905},
{528, 3900},
{527, 3893},
{530, 3885},
{523, 3878},
{520, 3870},
{520, 3867},
{521, 3864},
{523, 3858},
{522, 3852},
{528, 3847},
{526, 3842},
{527, 3838},
{528, 3835},
{534, 3830},
{532, 3825},
{532, 3822},
{533, 3818},
{534, 3816},
{535, 3814},
{537, 3809},
{541, 3807},
{546, 3805},
{553, 3801},
{550, 3797},
{558, 3796},
{566, 3795},
{595, 3791},
{607, 3788},
{613, 3787},
{626, 3786},
{628, 3785},
{629, 3784},
{629, 3782},
{633, 3780},
{643, 3780},
{654, 3777},
{656, 3776},
{658, 3776},
{629, 3773},
{639, 3771},
{646, 3767},
{649, 3764},
{649, 3762},
{649, 3760},
{661, 3755},
{690, 3752},
{705, 3748},
{727, 3744},
{735, 3738},
{745, 3735},
{755, 3732},
{781, 3724},
{797, 3718}
};     

// T2 25C
R_PROFILE_STRUC r_profile_t2[] =
{
{149, 4328},
{149, 4311},
{149, 4297},
{157, 4286},
{153, 4273},
{154, 4261},
{154, 4249},
{155, 4238},
{152, 4226},
{151, 4220},
{150, 4214},
{153, 4202},
{155, 4192},
{149, 4179},
{149, 4168},
{151, 4157},
{150, 4147},
{154, 4137},
{153, 4125},
{156, 4115},
{157, 4105},
{157, 4094},
{160, 4084},
{158, 4075},
{163, 4068},
{176, 4066},
{168, 4056},
{166, 4048},
{163, 4040},
{159, 4022},
{158, 4006},
{159, 3993},
{161, 3984},
{163, 3978},
{170, 3975},
{167, 3970},
{168, 3963},
{168, 3956},
{175, 3950},
{174, 3941},
{174, 3933},
{174, 3924},
{178, 3915},
{171, 3902},
{166, 3890},
{156, 3880},
{156, 3876},
{155, 3871},
{154, 3864},
{154, 3858},
{152, 3851},
{152, 3846},
{151, 3841},
{149, 3835},
{149, 3829},
{149, 3825},
{155, 3822},
{157, 3818},
{154, 3813},
{153, 3809},
{155, 3806},
{161, 3804},
{161, 3801},
{153, 3796},
{157, 3795},
{161, 3794},
{157, 3790},
{158, 3787},
{158, 3786},
{159, 3782},
{158, 3780},
{160, 3778},
{160, 3775},
{154, 3771},
{151, 3766},
{153, 3762},
{153, 3759},
{154, 3755},
{153, 3750},
{152, 3747},
{157, 3745},
{154, 3740},
{154, 3738},
{154, 3737},
{157, 3735},
{157, 3729},
{157, 3724},
{157, 3718},
{155, 3712},
{151, 3705},
{148, 3697},
{151, 3689},
{150, 3686},
{155, 3686},
{157, 3686},
{160, 3684},
{162, 3682},
{164, 3675},
{166, 3660},
{168, 3623},
{171, 3572}
    
}; 

// T3 50C
R_PROFILE_STRUC r_profile_t3[] =
{
{118, 4325},
{118, 4308},
{122, 4295},
{126, 4284},
{126, 4271},
{124, 4258},
{124, 4246},
{126, 4236},
{123, 4223},
{123, 4212},
{121, 4206},
{119, 4200},
{127, 4188},
{124, 4176},
{121, 4165},
{123, 4154},
{126, 4144},
{126, 4132},
{123, 4122},
{126, 4112},
{126, 4101},
{127, 4092},
{125, 4081},
{124, 4072},
{123, 4062},
{126, 4053},
{131, 4045},
{129, 4034},
{130, 4023},
{134, 4013},
{132, 4008},
{130, 4002},
{131, 3996},
{136, 3988},
{134, 3980},
{137, 3972},
{135, 3964},
{138, 3956},
{140, 3948},
{139, 3941},
{140, 3934},
{141, 3924},
{141, 3915},
{136, 3903},
{128, 3891},
{127, 3881},
{128, 3872},
{126, 3865},
{126, 3859},
{123, 3852},
{123, 3846},
{124, 3844},
{124, 3842},
{125, 3836},
{123, 3831},
{122, 3825},
{126, 3821},
{126, 3819},
{124, 3813},
{125, 3809},
{128, 3806},
{130, 3804},
{130, 3800},
{128, 3797},
{127, 3794},
{129, 3789},
{130, 3787},
{132, 3785},
{136, 3782},
{131, 3779},
{137, 3777},
{134, 3775},
{132, 3773},
{130, 3768},
{121, 3759},
{120, 3753},
{120, 3748},
{124, 3745},
{126, 3742},
{126, 3737},
{121, 3732},
{130, 3731},
{125, 3727},
{123, 3722},
{126, 3719},
{122, 3713},
{126, 3709},
{123, 3701},
{123, 3696},
{126, 3689},
{124, 3681},
{126, 3680},
{127, 3679},
{128, 3678},
{130, 3677},
{133, 3676},
{133, 3673},
{137, 3668},
{136, 3651},
{134, 3615},
{134, 3567}
	      
}; 

// r-table profile for actual temperature. The size should be the same as T1, T2 and T3
R_PROFILE_STRUC r_profile_temperature[] =
{
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0}
};    
/*lenovo-sw mahj2 update battery param end 2014-10-21 */
// ============================================================
// function prototype
// ============================================================
int fgauge_get_saddles(void);
BATTERY_PROFILE_STRUC_P fgauge_get_profile(kal_uint32 temperature);

int fgauge_get_saddles_r_table(void);
R_PROFILE_STRUC_P fgauge_get_profile_r_table(kal_uint32 temperature);

#endif	//#ifndef _CUST_BATTERY_METER_TABLE_H

