#ifndef _CUST_BATTERY_METER_TABLE_H
#define _CUST_BATTERY_METER_TABLE_H

#include <mach/mt_typedefs.h>

// ============================================================
// define
// ============================================================
#define BAT_NTC_10 1
#define BAT_NTC_47 0

#if (BAT_NTC_10 == 1)
#define RBAT_PULL_UP_R             24000	
#endif

#if (BAT_NTC_47 == 1)
#define RBAT_PULL_UP_R             61900	
#endif

#define RBAT_PULL_UP_VOLT          2800



// ============================================================
// ENUM
// ============================================================

// ============================================================
// structure
// ============================================================

// ============================================================
// typedef
// ============================================================
typedef struct _BATTERY_PROFILE_STRUC
{
    kal_int32 percentage;
    kal_int32 voltage;
} BATTERY_PROFILE_STRUC, *BATTERY_PROFILE_STRUC_P;

typedef struct _R_PROFILE_STRUC
{
    kal_int32 resistance; // Ohm
    kal_int32 voltage;
} R_PROFILE_STRUC, *R_PROFILE_STRUC_P;

typedef enum
{
    T1_0C,
    T2_25C,
    T3_50C
} PROFILE_TEMPERATURE;

// ============================================================
// External Variables
// ============================================================

// ============================================================
// External function
// ============================================================

// ============================================================
// <DOD, Battery_Voltage> Table
// ============================================================
#if (BAT_NTC_10 == 1)
/*lenovo-sw mahj2 update NTC param begin 2014-10-21 */
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
        {-20,67790},
        {-15,53460},
        {-10,42450},
        { -5,33930},
        {  0,27280},
        {  5,22070},
        { 10,17960},
        { 15,14700},
        { 20,12090},
        { 25,10000},
        { 30,8312},
        { 35,6942},
        { 40,5826},
        { 45,4911},
        { 50,4158},
        { 55,3536},
        { 60,3019}
    };
/*lenovo-sw mahj2 update NTC param end 2014-10-21 */
#endif

#if (BAT_NTC_47 == 1)
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
        {-20,483954},
        {-15,360850},
        {-10,271697},
        { -5,206463},
        {  0,158214},
        {  5,122259},
        { 10,95227},
        { 15,74730},
        { 20,59065},
        { 25,47000},
        { 30,37643},
        { 35,30334},
        { 40,24591},
        { 45,20048},
        { 50,16433},
        { 55,13539},
        { 60,11210}        
    };
#endif
/*lenovo-sw mahj2 update battery param begin 2014-10-21 */
// T0 -10C
BATTERY_PROFILE_STRUC battery_profile_t0[] =
{
 	{0  , 4345},
	{1  , 4323},
	{2  , 4307},
	{3  , 4292},
	{4  , 4278},
	{5  , 4268},
	{6  , 4255},
	{7  , 4243},
	{8  , 4232},
	{9  , 4220},
	{10 , 4209},
	{11 , 4198},
	{12 , 4188},
	{13 , 4177},
	{14 , 4167},
	{15 , 4156},
	{16 , 4146},
	{17 , 4140},
	{18 , 4134},
	{19 , 4124},
	{20 , 4114},
	{21 , 4106},
	{22 , 4099},
	{23 , 4090},
	{24 , 4082},
	{25 , 4069},
	{26 , 4051},
	{27 , 4030},
	{28 , 4013},
	{29 , 3996},
	{30 , 3983},
	{31 , 3972},
	{32 , 3962},
	{33 , 3954},
	{34 , 3945},
	{35 , 3938},
	{36 , 3932},
	{37 , 3924},
	{38 , 3919},
	{39 , 3912},
	{40 , 3906},
	{41 , 3898},
	{42 , 3891},
	{43 , 3884},
	{44 , 3879},
	{45 , 3872},
	{46 , 3868},
	{47 , 3861},
	{48 , 3855},
	{49 , 3849},
	{50 , 3844},
	{51 , 3839},
	{52 , 3836},
	{53 , 3834},
	{54 , 3829},
	{55 , 3826},
	{56 , 3822},
	{57 , 3819},
	{58 , 3814},
	{59 , 3811},
	{60 , 3809},
	{61 , 3807},
	{62 , 3804},
	{63 , 3802},
	{64 , 3801},
	{65 , 3799},
	{66 , 3798},
	{67 , 3797},
	{68 , 3794},
	{69 , 3792},
	{70 , 3791},
	{71 , 3789},
	{72 , 3786},
	{73 , 3786},
	{74 , 3782},
	{75 , 3780},
	{76 , 3777},
	{77 , 3773},
	{78 , 3770},
	{79 , 3765},
	{80 , 3761},
	{81 , 3757},
	{82 , 3753},
	{83 , 3747},
	{84 , 3743},
	{85 , 3738},
	{86 , 3732},
	{87 , 3725},
	{88 , 3721},
	{89 , 3715},
	{90 , 3711},
	{91 , 3707},
	{92 , 3705},
	{93 , 3703},
	{94 , 3700},
	{95 , 3692},
	{96 , 3672},
	{97 , 3639},
	{98 , 3598},
	{99 , 3554},
	{100, 3400}	   
};      
        
// T1 0C 
BATTERY_PROFILE_STRUC battery_profile_t1[] =
{
	{0  , 4334},
	{1  , 4317},
	{2  , 4301},
	{3  , 4288},
	{4  , 4276},
	{5  , 4264},
	{6  , 4253},
	{7  , 4241},
	{8  , 4229},
	{9  , 4219},
	{10 , 4207},
	{11 , 4196},
	{12 , 4186},
	{13 , 4175},
	{14 , 4164},
	{15 , 4155},
	{16 , 4144},
	{17 , 4134},
	{18 , 4123},
	{19 , 4113},
	{20 , 4103},
	{21 , 4094},
	{22 , 4091},
	{23 , 4088},
	{24 , 4083},
	{25 , 4076},
	{26 , 4063},
	{27 , 4046},
	{28 , 4025},
	{29 , 4006},
	{30 , 3989},
	{31 , 3976},
	{32 , 3966},
	{33 , 3958},
	{34 , 3952},
	{35 , 3944},
	{36 , 3938},
	{37 , 3932},
	{38 , 3925},
	{39 , 3916},
	{40 , 3910},
	{41 , 3900},
	{42 , 3893},
	{43 , 3885},
	{44 , 3878},
	{45 , 3870},
	{46 , 3864},
	{47 , 3858},
	{48 , 3852},
	{49 , 3847},
	{50 , 3842},
	{51 , 3835},
	{52 , 3830},
	{53 , 3825},
	{54 , 3822},
	{55 , 3818},
	{56 , 3814},
	{57 , 3809},
	{58 , 3807},
	{59 , 3805},
	{60 , 3801},
	{61 , 3797},
	{62 , 3795},
	{63 , 3791},
	{64 , 3788},
	{65 , 3787},
	{66 , 3787},
	{67 , 3786},
	{68 , 3784},
	{69 , 3782},
	{70 , 3780},
	{71 , 3780},
	{72 , 3777},
	{73 , 3776},
	{74 , 3773},
	{75 , 3771},
	{76 , 3767},
	{77 , 3764},
	{78 , 3760},
	{79 , 3755},
	{80 , 3752},
	{81 , 3748},
	{82 , 3744},
	{83 , 3738},
	{84 , 3732},
	{85 , 3724},
	{86 , 3718},
	{87 , 3711},
	{88 , 3703},
	{89 , 3698},
	{90 , 3696},
	{91 , 3694},
	{92 , 3691},
	{93 , 3687},
	{94 , 3682},
	{95 , 3667},
	{96 , 3639},
	{97 , 3587},
	{98 , 3544},
	{99 , 3472},
	{100, 3426}
       
};           

// T2 25C
BATTERY_PROFILE_STRUC battery_profile_t2[] =
{
    	{0	,4328},
	{1	,4311},
	{2	,4297},
	{3	,4286},
	{4	,4273},
	{5	,4261},
	{6	,4249},
	{7	,4238},
	{8	,4226},
	{9	,4214},
	{10	,4202},
	{11	,4192},
	{12	,4179},
	{13	,4168},
	{14	,4157},
	{15	,4147},
	{16	,4137},
	{17	,4131},
	{18	,4125},
	{19	,4115},
	{20	,4105},
	{21	,4094},
	{22	,4084},
	{23	,4075},
	{24	,4068},
	{25	,4066},
	{26	,4056},
	{27	,4040},
	{28	,4022},
	{29	,4006},
	{30	,3993},
	{31	,3984},
	{32	,3978},
	{33	,3975},
	{34	,3970},
	{35	,3963},
	{36	,3956},
	{37	,3950},
	{38	,3941},
	{39	,3933},
	{40	,3924},
	{41	,3915},
	{42	,3902},
	{43	,3890},
	{44	,3880},
	{45	,3871},
	{46	,3864},
	{47	,3858},
	{48	,3851},
	{49	,3846},
	{50	,3841},
	{51	,3838},
	{52	,3835},
	{53	,3829},
	{54	,3825},
	{55	,3822},
	{56	,3818},
	{57	,3813},
	{58	,3809},
	{59	,3806},
	{60	,3804},
	{61	,3801},
	{62	,3796},
	{63	,3794},
	{64	,3790},
	{65	,3787},
	{66	,3786},
	{67	,3782},
	{68	,3780},
	{69	,3778},
	{70	,3775},
	{71	,3771},
	{72	,3766},
	{73	,3762},
	{74	,3759},
	{75	,3755},
	{76	,3750},
	{77	,3747},
	{78	,3745},
	{79	,3740},
	{80	,3737},
	{81	,3735},
	{82	,3729},
	{83	,3724},
	{84	,3718},
	{85	,3712},
	{86	,3709},
	{87	,3705},
	{88	,3697},
	{89	,3689},
	{90	,3686},
	{91	,3686},
	{92	,3686},
	{93	,3684},
	{94	,3682},
	{95	,3675},
	{96	,3660},
	{97	,3623},
	{98	,3572},
	{99	,3505},
	{100,3411}	
       
};     

// T3 50C
BATTERY_PROFILE_STRUC battery_profile_t3[] =
{
	{0	,4325},
	{1	,4308},
	{2	,4295},
	{3	,4284},
	{4	,4271},
	{5	,4258},
	{6	,4246},
	{7	,4236},
	{8	,4223},
	{9	,4212},
	{10	,4200},
	{11	,4188},
	{12	,4176},
	{13	,4165},
	{14	,4154},
	{15	,4144},
	{16	,4132},
	{17	,4127},
	{18	,4122},
	{19	,4112},
	{20	,4101},
	{21	,4092},
	{22	,4081},
	{23	,4072},
	{24	,4062},
	{25	,4053},
	{26	,4045},
	{27	,4034},
	{28	,4023},
	{29	,4013},
	{30	,4002},
	{31	,3996},
	{32	,3988},
	{33	,3980},
	{34	,3972},
	{35	,3964},
	{36	,3956},
	{37	,3948},
	{38	,3941},
	{39	,3934},
	{40	,3924},
	{41	,3915},
	{42	,3903},
	{43	,3891},
	{44	,3881},
	{45	,3872},
	{46	,3865},
	{47	,3859},
	{48	,3852},
	{49	,3846},
	{50	,3842},
	{51	,3836},
	{52	,3833},
	{53	,3831},
	{54	,3825},
	{55	,3821},
	{56	,3819},
	{57	,3813},
	{58	,3809},
	{59	,3806},
	{60	,3804},
	{61	,3800},
	{62	,3797},
	{63	,3794},
	{64	,3789},
	{65	,3787},
	{66	,3785},
	{67	,3782},
	{68	,3779},
	{69	,3777},
	{70	,3773},
	{71	,3768},
	{72	,3759},
	{73	,3753},
	{74	,3748},
	{75	,3745},
	{76	,3742},
	{77	,3737},
	{78	,3732},
	{79	,3731},
	{80	,3727},
	{81	,3722},
	{82	,3719},
	{83	,3713},
	{84	,3709},
	{85	,3701},
	{86	,3696},
	{87	,3692},
	{88	,3689},
	{89	,3681},
	{90	,3679},
	{91	,3678},
	{92	,3677},
	{93	,3676},
	{94	,3673},
	{95	,3668},
	{96	,3651},
	{97	,3615},
	{98	,3567},
	{99	,3505},
	{100,3419}	
     
};           

// battery profile for actual temperature. The size should be the same as T1, T2 and T3
BATTERY_PROFILE_STRUC battery_profile_temperature[] =
{
  {0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },  
	{0  , 0 }, 
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },  
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 }
};    

// ============================================================
// <Rbat, Battery_Voltage> Table
// ============================================================
// T0 -10C
R_PROFILE_STRUC r_profile_t0[] =
{
 	{990  , 4345},
	{990  , 4323},
	{1000  , 4307},
	{1001  , 4292},
	{1002  , 4278},
	{1001  , 4268},
	{998  , 4255},
	{986  , 4243},
	{988  , 4232},
	{980  , 4220},
	{973 , 4209},
	{969 , 4198},
	{965 , 4188},
	{960 , 4177},
	{959 , 4167},
	{956 , 4156},
	{957 , 4146},
	{988 , 4140},
	{1022 , 4134},
	{1057 , 4124},
	{1055 , 4114},
	{1059 , 4106},
	{1067 , 4099},
	{1069 , 4090},
	{1067 , 4082},
	{1065 , 4069},
	{1049 , 4051},
	{1032 , 4030},
	{1022 , 4013},
	{1009 , 3996},
	{1003 , 3983},
	{1000 , 3972},
	{1000 , 3962},
	{1003 , 3954},
	{1001 , 3945},
	{1004 , 3938},
	{1005 , 3932},
	{992 , 3924},
	{999 , 3919},
	{998 , 3912},
	{998 , 3906},
	{1047 , 3898},
	{1002 , 3891},
	{998 , 3884},
	{1005 , 3879},
	{994 , 3872},
	{1001 , 3868},
	{996 , 3861},
	{999 , 3855},
	{998 , 3849},
	{1005 , 3844},
	{1008 , 3839},
	{1010 , 3836},
	{1012 , 3834},
	{1012 , 3829},
	{1023 , 3826},
	{1021 , 3822},
	{1026 , 3819},
	{1028 , 3814},
	{1033 , 3811},
	{1038 , 3809},
	{1043 , 3807},
	{1048 , 3804},
	{1000 , 3802},
	{1033 , 3801},
	{1045 , 3799},
	{1056 , 3798},
	{1067 , 3797},
	{1078 , 3794},
	{1089 , 3792},
	{1103 , 3791},
	{1120 , 3789},
	{1132 , 3786},
	{1154 , 3786},
	{1151 , 3782},
	{1179 , 3780},
	{1202 , 3777},
	{1221 , 3773},
	{1252 , 3770},
	{1287 , 3765},
	{1245 , 3761},
	{1302 , 3757},
	{1332 , 3753},
	{1364 , 3747},
	{1358 , 3743},
	{1346 , 3738},
	{1331 , 3732},
	{1313 , 3725},
	{1303 , 3721},
	{1288 , 3715},
	{1279 , 3711},
	{1270 , 3707},
	{1263 , 3705},
	{1260 , 3703},
	{1251 , 3700},
	{1232 , 3692},
	{1184 , 3672},
	{1098 , 3639},
	{996   , 3598},
	{889   , 3554},
	{889   , 3400}	
};      

// T1 0C
R_PROFILE_STRUC r_profile_t1[] =
{
	{573  , 4334},
	{573  , 4317},
	{585  , 4301},
	{616  , 4288},
	{602  , 4276},
	{604  , 4264},
	{617  , 4253},
	{613  , 4241},
	{611  , 4229},
	{609  , 4219},
	{602 , 4207},
	{600 , 4196},
	{597 , 4186},
	{608 , 4175},
	{586 , 4164},
	{599 , 4155},
	{600 , 4144},
	{571 , 4134},
	{582 , 4123},
	{574 , 4113},
	{570 , 4103},
	{566 , 4094},
	{570 , 4091},
	{574 , 4088},
	{589 , 4083},
	{593 , 4076},
	{585 , 4063},
	{575 , 4046},
	{560 , 4025},
	{556 , 4006},
	{552 , 3989},
	{553 , 3976},
	{553 , 3966},
	{551 , 3958},
	{557 , 3952},
	{554 , 3944},
	{553 , 3938},
	{547 , 3932},
	{553 , 3925},
	{547 , 3916},
	{546 , 3910},
	{528 , 3900},
	{527 , 3893},
	{530 , 3885},
	{523 , 3878},
	{520 , 3870},
	{521 , 3864},
	{523 , 3858},
	{522 , 3852},
	{528 , 3847},
	{526 , 3842},
	{528 , 3835},
	{534 , 3830},
	{532 , 3825},
	{532 , 3822},
	{533 , 3818},
	{535 , 3814},
	{537 , 3809},
	{541 , 3807},
	{546 , 3805},
	{554 , 3801},
	{550 , 3797},
	{566 , 3795},
	{595 , 3791},
	{607 , 3788},
	{613 , 3787},
	{613 , 3787},
	{626 , 3786},
	{629 , 3784},
	{629 , 3782},
	{633 , 3780},
	{643 , 3780},
	{654 , 3777},
	{658 , 3776},
	{629 , 3773},
	{639 , 3771},
	{646 , 3767},
	{649 , 3764},
	{649 , 3760},
	{661 , 3755},
	{690 , 3752},
	{705 , 3748},
	{727 , 3744},
	{735 , 3738},
	{755 , 3732},
	{781 , 3724},
	{797 , 3718},
	{829 , 3711},
	{832 , 3703},
	{848 , 3698},
	{885 , 3696},
	{928 , 3694},
	{972 , 3691},
	{1027 , 3687},
	{1072 , 3682},
	{1122 , 3667},
	{1098 , 3639},
	{968 , 3587},
	{860 , 3544},
	{681 , 3472},
	{564, 3426}
	      
};     

// T2 25C
R_PROFILE_STRUC r_profile_t2[] =
{
	{149 ,4328},
	{149 ,4311},
	{149 ,4297},
	{157 ,4286},
	{153 ,4273},
	{154 ,4261},
	{154 ,4249},
	{155 ,4238},
	{152 ,4226},
	{150 ,4214},
	{153 ,4202},
	{155 ,4192},
	{149 ,4179},
	{149 ,4168},
	{151 ,4157},
	{150 ,4147},
	{154 ,4137},
	{154 ,4131},
	{153 ,4125},
	{156 ,4115},
	{157 ,4105},
	{157 ,4094},
	{160 ,4084},
	{158 ,4075},
	{163 ,4068},
	{176 ,4066},
	{168 ,4056},
	{163 ,4040},
	{159 ,4022},
	{158 ,4006},
	{159 ,3993},
	{161 ,3984},
	{164 ,3978},
	{170 ,3975},
	{167 ,3970},
	{168 ,3963},
	{168 ,3956},
	{175 ,3950},
	{174 ,3941},
	{174 ,3933},
	{174 ,3924},
	{178 ,3915},
	{171 ,3902},
	{166 ,3890},
	{156 ,3880},
	{155 ,3871},
	{154 ,3864},
	{154 ,3858},
	{152 ,3851},
	{152 ,3846},
	{151 ,3841},
	{151 ,3838},
	{150 ,3835},
	{149 ,3829},
	{150 ,3825},
	{155 ,3822},
	{157 ,3818},
	{154 ,3813},
	{153 ,3809},
	{155 ,3806},
	{161 ,3804},
	{161 ,3801},
	{153 ,3796},
	{161 ,3794},
	{157 ,3790},
	{158 ,3787},
	{158 ,3786},
	{159 ,3782},
	{158 ,3780},
	{160 ,3778},
	{160 ,3775},
	{154 ,3771},
	{151 ,3766},
	{153 ,3762},
	{154 ,3759},
	{154 ,3755},
	{153 ,3750},
	{152 ,3747},
	{157 ,3745},
	{154 ,3740},
	{154 ,3737},
	{157 ,3735},
	{157 ,3729},
	{157 ,3724},
	{157 ,3718},
	{155 ,3712},
	{153 ,3709},
	{151 ,3705},
	{148 ,3697},
	{151 ,3689},
	{150 ,3686},
	{155 ,3686},
	{157 ,3686},
	{160 ,3684},
	{162 ,3682},
	{164 ,3675},
	{166 ,3660},
	{168 ,3623},
	{171 ,3572},
	{180 ,3505},
	{194 ,3411}
    
}; 

// T3 50C
R_PROFILE_STRUC r_profile_t3[] =
{
	{119 ,4325},
	{119 ,4308},
	{122 ,4295},
	{126 ,4284},
	{126 ,4271},
	{124 ,4258},
	{124 ,4246},
	{126 ,4236},
	{123 ,4223},
	{123 ,4212},
	{119 ,4200},
	{127 ,4188},
	{124 ,4176},
	{121 ,4165},
	{123 ,4154},
	{126 ,4144},
	{126 ,4132},
	{125 ,4127},
	{123 ,4122},
	{126 ,4112},
	{126 ,4101},
	{127 ,4092},
	{125 ,4081},
	{124 ,4072},
	{123 ,4062},
	{126 ,4053},
	{131 ,4045},
	{129 ,4034},
	{130 ,4023},
	{134 ,4013},
	{130 ,4002},
	{131 ,3996},
	{136 ,3988},
	{134 ,3980},
	{137 ,3972},
	{135 ,3964},
	{138 ,3956},
	{140 ,3948},
	{140 ,3941},
	{140 ,3934},
	{141 ,3924},
	{141 ,3915},
	{136 ,3903},
	{129 ,3891},
	{127 ,3881},
	{128 ,3872},
	{126 ,3865},
	{126 ,3859},
	{123 ,3852},
	{123 ,3846},
	{124 ,3842},
	{125 ,3836},
	{124 ,3833},
	{123 ,3831},
	{122 ,3825},
	{126 ,3821},
	{126 ,3819},
	{124 ,3813},
	{125 ,3809},
	{128 ,3806},
	{130 ,3804},
	{130 ,3800},
	{128 ,3797},
	{127 ,3794},
	{129 ,3789},
	{130 ,3787},
	{132 ,3785},
	{136 ,3782},
	{131 ,3779},
	{137 ,3777},
	{132 ,3773},
	{130 ,3768},
	{121 ,3759},
	{120 ,3753},
	{120 ,3748},
	{124 ,3745},
	{126 ,3742},
	{126 ,3737},
	{121 ,3732},
	{129 ,3731},
	{125 ,3727},
	{123 ,3722},
	{126 ,3719},
	{122 ,3713},
	{126 ,3709},
	{123 ,3701},
	{123 ,3696},
	{125 ,3692},
	{126 ,3689},
	{124 ,3681},
	{127 ,3679},
	{128 ,3678},
	{130 ,3677},
	{133 ,3676},
	{133 ,3673},
	{137 ,3668},
	{136 ,3651},
	{134 ,3615},
	{134 ,3567},
	{143 ,3505},
	{153 ,3419}
	      
}; 

// r-table profile for actual temperature. The size should be the same as T1, T2 and T3
R_PROFILE_STRUC r_profile_temperature[] =
{
  {0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },  
	{0  , 0 }, 
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },  
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 }
};    
/*lenovo-sw mahj2 update battery param end 2014-10-21 */
// ============================================================
// function prototype
// ============================================================
int fgauge_get_saddles(void);
BATTERY_PROFILE_STRUC_P fgauge_get_profile(kal_uint32 temperature);

int fgauge_get_saddles_r_table(void);
R_PROFILE_STRUC_P fgauge_get_profile_r_table(kal_uint32 temperature);

#endif	//#ifndef _CUST_BATTERY_METER_TABLE_H

