#ifndef _CUST_BATTERY_METER_TABLE_H
#define _CUST_BATTERY_METER_TABLE_H

#include <mach/mt_typedefs.h>

// ============================================================
// define
// ============================================================
#define BAT_NTC_10 1
#define BAT_NTC_47 0

#if (BAT_NTC_10 == 1)
#define RBAT_PULL_UP_R             24000	
#endif

#if (BAT_NTC_47 == 1)
#define RBAT_PULL_UP_R             61900	
#endif

#define RBAT_PULL_UP_VOLT          2800



// ============================================================
// ENUM
// ============================================================

// ============================================================
// structure
// ============================================================

// ============================================================
// typedef
// ============================================================
typedef struct _BATTERY_PROFILE_STRUC
{
    kal_int32 percentage;
    kal_int32 voltage;
} BATTERY_PROFILE_STRUC, *BATTERY_PROFILE_STRUC_P;

typedef struct _R_PROFILE_STRUC
{
    kal_int32 resistance; // Ohm
    kal_int32 voltage;
} R_PROFILE_STRUC, *R_PROFILE_STRUC_P;

typedef enum
{
    T1_0C,
    T2_25C,
    T3_50C
} PROFILE_TEMPERATURE;

// ============================================================
// External Variables
// ============================================================

// ============================================================
// External function
// ============================================================

// ============================================================
// <DOD, Battery_Voltage> Table
// ============================================================
#if (BAT_NTC_10 == 1)
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
        {-20,68237},
        {-15,53650},
        {-10,42506},
        { -5,33892},
        {  0,27219},
        {  5,22021},
        { 10,17926},
        { 15,14674},
        { 20,12081},
        { 25,10000},
        { 30,8315},
        { 35,6948},
        { 40,5834},
        { 45,4917},
        { 50,4161},
        { 55,3535},
        { 60,3014}
    };
#endif

#if (BAT_NTC_47 == 1)
    BATT_TEMPERATURE Batt_Temperature_Table[] = {
        {-20,483954},
        {-15,360850},
        {-10,271697},
        { -5,206463},
        {  0,158214},
        {  5,122259},
        { 10,95227},
        { 15,74730},
        { 20,59065},
        { 25,47000},
        { 30,37643},
        { 35,30334},
        { 40,24591},
        { 45,20048},
        { 50,16433},
        { 55,13539},
        { 60,11210}        
    };
#endif

// T0 -10C
BATTERY_PROFILE_STRUC battery_profile_t0[] =
{
	{0   , 4240},         
	{3   , 4206},         
	{6   , 4172},         
	{9   , 4138},         
	{12  , 4104},         
	{15  , 4078},         
	{18  , 4053},         
	{21  , 4023},         
	{24  , 3999},         
	{27  , 3978},         
	{30  , 3962},         
	{33  , 3945},         
	{36  , 3925},         
	{39  , 3908},         
	{42  , 3891},         
	{45  , 3876},         
	{48  , 3862},         
	{51  , 3851},         
	{54  , 3840},         
	{57  , 3831},         
	{60  , 3824},         
	{63  , 3815},         
	{66  , 3809},         
	{69  , 3804},         
	{72  , 3799},         
	{75  , 3793},         
	{78  , 3790},         
	{81  , 3787},         
	{83  , 3784},         
	{85  , 3781},         
	{86  , 3779},         
	{87  , 3776},         
	{89  , 3774},         
	{89  , 3772},         
	{90  , 3771},         
	{91  , 3768},         
	{92  , 3767},         
	{92  , 3767},         
	{93  , 3764},         
	{93  , 3762},         
	{94  , 3763},         
	{94  , 3760},         
	{95  , 3759},         
	{95  , 3759},         
	{95  , 3758},         
	{96  , 3757},         
	{96  , 3756},         
	{96  , 3755},         
	{96  , 3753},         
	{97  , 3753},         
	{97  , 3751},         
	{97  , 3750},         
	{97  , 3749},         
	{97  , 3749},         
	{97  , 3748},         
	{98  , 3747},         
	{98  , 3745},         
	{98  , 3746},         
	{98  , 3744},         
	{98  , 3745},         
	{98  , 3743},          
  {98  , 3742},
  {99  , 3742},
  {99  , 3740},
  {99  , 3740},
  {99  , 3739},
  {99  , 3740},
  {99  , 3739},
  {99  , 3739},
  {99  , 3738},
	{100 , 3736}, 
	{100 , 3737},
	{100 , 3737},
	{100 , 3735},
	{100 , 3735},
	{100 , 3734}, 
	{100 , 3734}	       
};      
        
// T1 0C 
BATTERY_PROFILE_STRUC battery_profile_t1[] =
{
	{0   , 4291},         
	{2   , 4258},         
	{4   , 4234},         
	{7   , 4210},         
	{9   , 4187},         
	{11  , 4165},         
	{13  , 4145},         
	{16  , 4122},         
	{18  , 4103},         
	{20  , 4086},         
	{22  , 4066},         
	{24  , 4042},         
	{27  , 4016},         
	{29  , 3995},         
	{31  , 3976},         
	{33  , 3956},         
	{36  , 3935},         
	{38  , 3916},         
	{40  , 3899},         
	{42  , 3884},         
	{45  , 3869},         
	{47  , 3858},         
	{49  , 3848},         
	{51  , 3839},         
	{53  , 3830},         
	{56  , 3821},         
	{58  , 3813},         
	{60  , 3805},         
	{62  , 3799},         
	{65  , 3794},         
	{67  , 3789},         
	{69  , 3783},         
	{71  , 3779},         
	{73  , 3774},         
	{76  , 3766},         
	{78  , 3757},         
	{80  , 3747},         
	{82  , 3733},         
	{85  , 3717},         
	{87  , 3708},         
	{89  , 3701},         
	{91  , 3697},         
	{93  , 3692},         
	{95  , 3676},         
	{96  , 3656},         
	{97  , 3638},         
	{98  , 3623},         
	{98  , 3610},         
	{98  , 3600},         
	{98  , 3594},         
	{99  , 3588},         
	{99  , 3582},         
	{99  , 3576},         
	{99  , 3572},         
	{99  , 3567},         
	{99  , 3565},         
	{99  , 3562},         
	{99  , 3558},         
  {99  , 3555},
	{99  , 3553},         
	{99  , 3551},          
  {100 , 3547},
  {100 , 3545},
  {100 , 3544},
  {100 , 3542},
  {100 , 3540},
  {100 , 3537},
  {100 , 3536},
  {100 , 3534},
  {100 , 3532},
	{100 , 3529}, 
	{100 , 3528},
	{100 , 3526},
	{100 , 3524},
	{100 , 3522},
	{100 , 3521}, 
	{100 , 3519}	       
};           

// T2 25C
BATTERY_PROFILE_STRUC battery_profile_t2[] =
{
	{0   , 4330},         
	{2   , 4303},         
	{4   , 4281},         
	{6   , 4258},         
	{8   , 4235},         
	{10  , 4212},         
	{12  , 4191},         
	{14  , 4168},         
	{16  , 4147},         
	{18  , 4126},         
	{20  , 4106},         
	{22  , 4086},         
	{24  , 4070},         
	{27  , 4047},         
	{29  , 4026},         
	{31  , 4006},         
	{33  , 3988},         
	{35  , 3974},         
	{37  , 3960},         
	{39  , 3944},         
	{41  , 3925},         
	{43  , 3900},         
	{45  , 3880},         
	{47  , 3865},         
	{49  , 3853},         
	{51  , 3843},         
	{53  , 3834},         
	{55  , 3825},         
	{57  , 3817},         
	{59  , 3810},         
	{61  , 3803},         
	{63  , 3796},         
	{65  , 3791},         
	{67  , 3786},         
	{69  , 3781},         
	{71  , 3777},         
	{73  , 3772},         
	{75  , 3766},         
	{77  , 3757},         
	{80  , 3748},         
	{82  , 3738},         
	{84  , 3722},         
	{86  , 3702},         
	{88  , 3692},         
	{90  , 3689},         
	{92  , 3686},         
	{94  , 3682},         
	{96  , 3655},         
	{98  , 3564},         
	{100 , 3411},         
	{100 , 3354},         
	{100 , 3339},         
	{100 , 3330},         
	{100 , 3322},         
	{100 , 3315},         
	{100 , 3310},         
	{100 , 3304},         
	{100 , 3301},         
	{100 , 3299},         
	{100 , 3296},         
	{100 , 3293},          
  {100 , 3291},
  {100 , 3290},
  {100 , 3288},
  {100 , 3286},
  {100 , 3283},
  {100 , 3281},
  {100 , 3279},
  {100 , 3276},
  {100 , 3275},
	{100 , 3272}, 
	{100 , 3268},
	{100 , 3267},
	{100 , 3263},
	{100 , 3261},
	{100 , 3257},
	{100 , 3255}	       
};     

// T3 50C
BATTERY_PROFILE_STRUC battery_profile_t3[] =
{
	{0   , 4338},         
	{2   , 4315},         
	{4   , 4292},         
	{6   , 4270},         
	{8   , 4247},         
	{10  , 4225},         
	{12  , 4202},         
	{15  , 4180},         
	{17  , 4158},         
	{19  , 4138},         
	{21  , 4116},         
	{23  , 4096},         
	{25  , 4076},         
	{27  , 4058},         
	{29  , 4038},         
	{31  , 4020},         
	{33  , 4001},         
	{35  , 3985},         
	{37  , 3968},         
	{39  , 3951},         
	{41  , 3928},         
	{44  , 3904},         
	{46  , 3887},         
	{48  , 3872},         
	{50  , 3862},         
	{52  , 3851},         
	{54  , 3840},         
	{56  , 3831},         
	{58  , 3822},         
	{60  , 3814},         
	{62  , 3805},         
	{64  , 3798},         
	{66  , 3791},         
	{68  , 3784},         
	{70  , 3772},         
	{73  , 3760},         
	{75  , 3753},         
	{77  , 3742},         
	{79  , 3734},         
	{81  , 3726},         
	{83  , 3711},         
	{85  , 3694},         
	{87  , 3679},         
	{89  , 3675},         
	{91  , 3673},         
	{93  , 3669},         
	{95  , 3652},         
	{97  , 3576},         
	{100 , 3453},         
	{100 , 3283},         
	{100 , 3260},         
	{100 , 3247},         
	{100 , 3244},         
	{100 , 3243},         
	{100 , 3242},         
	{100 , 3241},         
	{100 , 3240},         
	{100 , 3237},         
	{100 , 3235},         
	{100 , 3235},         
	{100 , 3234},          
  {100 , 3232},
  {100 , 3230},
  {100 , 3230},
  {100 , 3227},
  {100 , 3225},
  {100 , 3224},
  {100 , 3222},
  {100 , 3222},
  {100 , 3220},
	{100 , 3217}, 
	{100 , 3216},
	{100 , 3215},
	{100 , 3212},
	{100 , 3211},
	{100 , 3209},
	{100 , 3207}	       
};           

// battery profile for actual temperature. The size should be the same as T1, T2 and T3
BATTERY_PROFILE_STRUC battery_profile_temperature[] =
{
  {0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },  
	{0  , 0 }, 
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },  
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 }
};    

// ============================================================
// <Rbat, Battery_Voltage> Table
// ============================================================
// T0 -10C
R_PROFILE_STRUC r_profile_t0[] =
{
	{953  , 4240},         
	{953  , 4206},         
	{970  , 4172},         
	{998  , 4138},         
	{1060 , 4104},         
	{1143 , 4078},         
	{1175 , 4053},         
	{1185 , 4023},         
	{1195 , 3999},         
	{1198 , 3978},         
	{1208 , 3962},         
	{1220 , 3945},         
	{1220 , 3925},         
	{1220 , 3908},         
	{1230 , 3891},         
	{1235 , 3876},         
	{1245 , 3862},         
	{1255 , 3851},         
	{1263 , 3840},         
	{1280 , 3831},         
	{1298 , 3824},         
	{1310 , 3815},         
	{1330 , 3809},         
	{1348 , 3804},         
	{1373 , 3799},         
	{1395 , 3793},         
	{1430 , 3790},         
	{1470 , 3787},         
	{1463 , 3784},         
	{1453 , 3781},         
	{1450 , 3779},         
	{1440 , 3776},         
	{1438 , 3774},         
	{1433 , 3772},         
	{1430 , 3771},         
	{1423 , 3768},         
	{1418 , 3767},         
	{1423 , 3767},         
	{1413 , 3764},         
	{1405 , 3762},         
	{1410 , 3763},         
	{1400 , 3760},         
	{1398 , 3759},         
	{1400 , 3759},         
	{1395 , 3758},         
	{1395 , 3757},         
	{1393 , 3756},         
	{1390 , 3755},         
	{1383 , 3753},         
	{1385 , 3753},         
	{1378 , 3751},         
	{1378 , 3750},         
	{1375 , 3749},         
	{1375 , 3749},         
	{1373 , 3748},         
	{1373 , 3747},         
	{1365 , 3745},         
	{1368 , 3746},         
	{1363 , 3744},         
	{1365 , 3745},         
	{1360 , 3743},          
  {1363 , 3742},
  {1358 , 3742},
  {1353 , 3740},
  {1350 , 3740},
  {1353 , 3739},
  {1360 , 3740},
  {1358 , 3739},
  {1348 , 3739},
  {1350 , 3738},
	{1345 , 3736}, 
	{1345 , 3737},
	{1345 , 3737},
	{1343 , 3735},
	{1340 , 3735},
	{1345 , 3734}, 
	{1338 , 3734}	       
};      

// T1 0C
R_PROFILE_STRUC r_profile_t1[] =
{
	{425  , 4291},         
	{425  , 4258},         
	{440  , 4234},         
	{448  , 4210},         
	{450  , 4187},         
	{463  , 4165},         
	{478  , 4145},         
	{480  , 4122},         
	{488  , 4103},         
	{500  , 4086},         
	{518  , 4066},         
	{530  , 4042},         
	{528  , 4016},         
	{538  , 3995},         
	{548  , 3976},         
	{543  , 3956},         
	{535  , 3935},         
	{540  , 3916},         
	{535  , 3899},         
	{538  , 3884},         
	{543  , 3869},         
	{550  , 3858},         
	{563  , 3848},         
	{583  , 3839},         
	{593  , 3830},         
	{598  , 3821},         
	{613  , 3813},         
	{630  , 3805},         
	{643  , 3799},         
	{658  , 3794},         
	{678  , 3789},         
	{703  , 3783},         
	{733  , 3779},         
	{758  , 3774},         
	{783  , 3766},         
	{818  , 3757},         
	{850  , 3747},         
	{868  , 3733},         
	{893  , 3717},         
	{933  , 3708},         
	{963  , 3701},         
	{1030 , 3697},         
	{1120 , 3692},         
	{1190 , 3676},         
	{1143 , 3656},         
	{1098 , 3638},         
	{1058 , 3623},         
	{1028 , 3610},         
	{1003 , 3600},         
	{988  , 3594},         
	{973  , 3588},         
	{955  , 3582},         
	{945  , 3576},         
	{933  , 3572},         
	{920  , 3567},         
	{915  , 3565},         
	{905  , 3562},         
	{898  , 3558},         
	{893  , 3555},         
	{883  , 3553},         
	{880  , 3551},          
  {875  , 3547},
  {868  , 3545},
  {865  , 3544},
  {863  , 3542},
  {855  , 3540},
  {843  , 3537},
  {850  , 3536},
  {848  , 3534},
  {843  , 3532},
	{823  , 3529}, 
	{828  , 3528},
	{833  , 3526},
	{823  , 3524},
	{808  , 3522},
	{820  , 3521}, 
	{805  , 3519}	       
};     

// T2 25C
R_PROFILE_STRUC r_profile_t2[] =
{
	{148 , 4330},         
	{148 , 4303},         
	{158 , 4281},         
	{160 , 4258},         
	{160 , 4235},         
	{163 , 4212},         
	{165 , 4191},         
	{165 , 4168},         
	{170 , 4147},         
	{173 , 4126},         
	{178 , 4106},         
	{178 , 4086},         
	{188 , 4070},         
	{188 , 4047},         
	{193 , 4026},         
	{195 , 4006},         
	{200 , 3988},         
	{208 , 3974},         
	{210 , 3960},         
	{215 , 3944},         
	{208 , 3925},         
	{183 , 3900},         
	{170 , 3880},         
	{165 , 3865},         
	{165 , 3853},         
	{168 , 3843},         
	{173 , 3834},         
	{175 , 3825},         
	{178 , 3817},         
	{183 , 3810},         
	{183 , 3803},         
	{185 , 3796},         
	{195 , 3791},         
	{198 , 3786},         
	{200 , 3781},         
	{200 , 3777},         
	{203 , 3772},         
	{203 , 3766},         
	{203 , 3757},         
	{208 , 3748},         
	{213 , 3738},         
	{213 , 3722},         
	{215 , 3702},         
	{215 , 3692},         
	{228 , 3689},         
	{245 , 3686},         
	{273 , 3682},         
	{285 , 3655},         
	{310 , 3564},         
	{395 , 3411},         
	{388 , 3354},         
	{350 , 3339},         
	{328 , 3330},         
	{305 , 3322},         
	{290 , 3315},         
	{278 , 3310},         
	{265 , 3304},         
	{253 , 3301},         
	{248 , 3299},         
	{243 , 3296},         
	{238 , 3293},          
  {230 , 3291},
  {233 , 3290},
  {230 , 3288},
  {230 , 3286},
  {230 , 3283},
  {228 , 3281},
  {230 , 3279},
  {230 , 3276},
  {235 , 3275},
	{240 , 3272}, 
	{235 , 3268},
	{238 , 3267},
	{233 , 3263},
	{238 , 3261},
	{233 , 3257}, 
	{235 , 3255}	       
}; 

// T3 50C
R_PROFILE_STRUC r_profile_t3[] =
{
	{105  , 4338},         
	{105  , 4315},         
	{108  , 4292},         
	{110  , 4270},         
	{110  , 4247},         
	{113  , 4225},         
	{110  , 4202},         
	{113  , 4180},         
	{113  , 4158},         
	{118  , 4138},         
	{115  , 4116},         
	{118  , 4096},         
	{123  , 4076},         
	{128  , 4058},         
	{125  , 4038},         
	{133  , 4020},         
	{133  , 4001},         
	{138  , 3985},         
	{140  , 3968},         
	{145  , 3951},         
	{135  , 3928},         
	{120  , 3904},         
	{113  , 3887},         
	{108  , 3872},         
	{115  , 3862},         
	{118  , 3851},         
	{120  , 3840},         
	{123  , 3831},         
	{120  , 3822},         
	{128  , 3814},         
	{123  , 3805},         
	{128  , 3798},         
	{130  , 3791},         
	{135  , 3784},         
	{125  , 3772},         
	{118  , 3760},         
	{125  , 3753},         
	{120  , 3742},         
	{120  , 3734},         
	{125  , 3726},         
	{120  , 3711},         
	{120  , 3694},         
	{120  , 3679},         
	{118  , 3675},         
	{125  , 3673},         
	{130  , 3669},         
	{135  , 3652},         
	{150  , 3576},         
	{175  , 3453},         
	{213  , 3283},         
	{150  , 3260},         
	{123  , 3247},         
	{113  , 3244},         
	{110  , 3243},         
	{108  , 3242},         
	{108  , 3241},         
	{108  , 3240},         
	{100  , 3237},         
	{100  , 3235},         
	{105  , 3235},         
	{103  , 3234},          
  {105  , 3232},
  {100  , 3230},
  {108  , 3230},
  {103  , 3227},
  {103  , 3225},
  {103  , 3224},
  {103  , 3222},
  {103  , 3222},
  {103  , 3220},
	{100  , 3217}, 
	{103  , 3216},
	{105  , 3215},
	{105  , 3212},
	{103  , 3211},
	{103  , 3209}, 
	{105  , 3207}	       
}; 

// r-table profile for actual temperature. The size should be the same as T1, T2 and T3
R_PROFILE_STRUC r_profile_temperature[] =
{
  {0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },  
	{0  , 0 }, 
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },  
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 },
	{0  , 0 }
};    

// ============================================================
// function prototype
// ============================================================
int fgauge_get_saddles(void);
BATTERY_PROFILE_STRUC_P fgauge_get_profile(kal_uint32 temperature);

int fgauge_get_saddles_r_table(void);
R_PROFILE_STRUC_P fgauge_get_profile_r_table(kal_uint32 temperature);

#endif	//#ifndef _CUST_BATTERY_METER_TABLE_H

