#include <linux/kernel.h>
#include <linux/module.h>

#include <mach/upmu_sw.h>
#include <mach/upmu_hw.h>
#include <mach/upmu_common.h>

//MT6325
void mt6325_upmu_set_thr_det_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_THR_DET_DIS_MASK),
                             (kal_uint32)(MT6325_PMIC_THR_DET_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_thr_tmode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_THR_TMODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_THR_TMODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_thr_temp_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_THR_TEMP_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_THR_TEMP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_strup_thr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_THR_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_THR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_thr_hwpdn_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_THR_HWPDN_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_THR_HWPDN_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_thrdet_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_THRDET_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_THRDET_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_strup_iref_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_IREF_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_IREF_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_usbdl_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_USBDL_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_USBDL_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fchr_keydet_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FCHR_KEYDET_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FCHR_KEYDET_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fchr_pu_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FCHR_PU_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FCHR_PU_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_en_drvsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_EN_DRVSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_EN_DRVSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rstb_drv_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RSTB_DRV_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RSTB_DRV_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vref_bg(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VREF_BG_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VREF_BG_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pmu_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PMU_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PMU_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_thr_test(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_THR_TEST_MASK),
                             (kal_uint32)(MT6325_PMIC_THR_TEST_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_pmu_thr_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_STRUP_CON5),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_PMU_THR_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_PMU_THR_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_pmu_thr_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_STRUP_CON5),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_PMU_THR_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_PMU_THR_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_dduvlo_deb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_DDUVLO_DEB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_DDUVLO_DEB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_pwrbb_deb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_PWRBB_DEB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_PWRBB_DEB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_osc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_OSC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_OSC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_osc_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_OSC_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_OSC_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_ft_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_FT_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_FT_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_pwron_force(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_PWRON_FORCE_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_PWRON_FORCE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bias_gen_en_force(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIAS_GEN_EN_FORCE_MASK),
                             (kal_uint32)(MT6325_PMIC_BIAS_GEN_EN_FORCE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_pwron(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_PWRON_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_PWRON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_pwron_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_PWRON_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_PWRON_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bias_gen_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIAS_GEN_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_BIAS_GEN_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bias_gen_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIAS_GEN_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_BIAS_GEN_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rtc_xosc32_enb_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RTC_XOSC32_ENB_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_RTC_XOSC32_ENB_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rtc_xosc32_enb_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RTC_XOSC32_ENB_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RTC_XOSC32_ENB_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_dig_io_pg_force(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_DIG_IO_PG_FORCE_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_DIG_IO_PG_FORCE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vaud28_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VAUD28_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VAUD28_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vtcxo_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VTCXO_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VTCXO_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vusb_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VUSB_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VUSB_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio28_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO28_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO28_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_pg_h2l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_PG_H2L_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_PG_H2L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_PG_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_PG_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_PG_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_PG_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_PG_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_PG_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vaud28_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VAUD28_PG_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_VAUD28_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vtcxo_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VTCXO_PG_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_VTCXO_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vusb_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VUSB_PG_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_VUSB_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_PG_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio28_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO28_PG_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO28_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_PG_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_ext_pmic_en_pg_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_EXT_PMIC_EN_PG_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_EXT_PMIC_EN_PG_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_clr_just_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_CLR_JUST_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_CLR_JUST_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_uvlo_l2h_deb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_UVLO_L2H_DEB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_UVLO_L2H_DEB_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_just_pwrkey_rst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_STRUP_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_JUST_PWRKEY_RST_MASK),
                           (kal_uint32)(MT6325_PMIC_JUST_PWRKEY_RST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_osc_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_STRUP_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_OSC_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_OSC_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_strup_ext_pmic_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_EXT_PMIC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_EXT_PMIC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_ext_pmic_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_EXT_PMIC_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_EXT_PMIC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_con8_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_CON8_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_CON8_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_ext_pmic_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_STRUP_CON10),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_EXT_PMIC_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_EXT_PMIC_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_strup_auxadc_start_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_AUXADC_START_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_AUXADC_START_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_auxadc_rstb_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_AUXADC_RSTB_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_AUXADC_RSTB_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_auxadc_start_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_AUXADC_START_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_AUXADC_START_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_auxadc_rstb_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_AUXADC_RSTB_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_AUXADC_RSTB_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_pwroff_seq_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_PWROFF_SEQ_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_PWROFF_SEQ_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_pwroff_preoff_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_PWROFF_PREOFF_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_PWROFF_PREOFF_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_pp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_PP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_PP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_pp_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_PP_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_PP_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_dig1_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_DIG1_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_DIG1_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_uvlo_vthl_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_UVLO_VTHL_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_UVLO_VTHL_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bgr_rsv6(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV6_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV6_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bgr_rsv5(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV5_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV5_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bgr_rsv4(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV4_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV4_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bgr_rsv3(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV3_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV3_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bgr_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bgr_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bgr_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_strup_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_en_smt(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_EN_SMT_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_EN_SMT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_en_sr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_EN_SR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_EN_SR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_en_e8(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_EN_E8_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_EN_E8_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_en_e4(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_EN_E4_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_EN_E4_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_testmode_swen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_TESTMODE_SWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_TESTMODE_SWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rsv_swreg(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RSV_SWREG_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RSV_SWREG_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_strup_pg_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_STRUP_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_STRUP_PG_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_STRUP_PG_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_usbdl(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_STRUP_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_USBDL_MASK),
                           (kal_uint32)(MT6325_PMIC_USBDL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_strup_pg_status_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_PG_STATUS_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_PG_STATUS_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_pp_en_pwroff_cnt(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_PP_EN_PWROFF_CNT_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_PP_EN_PWROFF_CNT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_dig0_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_DIG0_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_DIG0_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_uvlo_u1u2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_UVLO_U1U2_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_UVLO_U1U2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_uvlo_u1u2_sel_swctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_UVLO_U1U2_SEL_SWCTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_UVLO_U1U2_SEL_SWCTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_lbat_int_sel_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_LBAT_INT_SEL_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_LBAT_INT_SEL_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_lbat_int_sel_swctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_LBAT_INT_SEL_SWCTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_LBAT_INT_SEL_SWCTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_lbat_int_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_LBAT_INT_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_LBAT_INT_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_lbat_irq_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_LBAT_IRQ_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_LBAT_IRQ_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_lbat_irq_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_LBAT_IRQ_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_LBAT_IRQ_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_lbat_irq_swctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_LBAT_IRQ_SWCTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_LBAT_IRQ_SWCTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_uvlo_vsys_deb_75k_rpcnt_max(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_UVLO_VSYS_DEB_75K_RPCNT_MAX_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_UVLO_VSYS_DEB_75K_RPCNT_MAX_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_uvlo_vsys_deb_2m_rpcnt_max(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_UVLO_VSYS_DEB_2M_RPCNT_MAX_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_UVLO_VSYS_DEB_2M_RPCNT_MAX_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_strup_auxadc_rpcnt_max(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STRUP_AUXADC_RPCNT_MAX_MASK),
                             (kal_uint32)(MT6325_PMIC_STRUP_AUXADC_RPCNT_MAX_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rst_drvsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_STRUP_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RST_DRVSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RST_DRVSEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_hwcid(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_HWCID),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_HWCID_MASK),
                           (kal_uint32)(MT6325_PMIC_HWCID_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_swcid(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SWCID),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_SWCID_MASK),
                           (kal_uint32)(MT6325_PMIC_SWCID_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_srclken_in0_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SRCLKEN_IN0_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SRCLKEN_IN0_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_srclken_in1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SRCLKEN_IN1_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SRCLKEN_IN1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_osc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OSC_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OSC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_srclken_in0_hw_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SRCLKEN_IN0_HW_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SRCLKEN_IN0_HW_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_srclken_in1_hw_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SRCLKEN_IN1_HW_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SRCLKEN_IN1_HW_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_osc_sel_hw_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OSC_SEL_HW_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OSC_SEL_HW_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_srclken_in_sync_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SRCLKEN_IN_SYNC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SRCLKEN_IN_SYNC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_osc_en_auto_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OSC_EN_AUTO_OFF_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OSC_EN_AUTO_OFF_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_test_out(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_TEST_OUT),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_TEST_OUT_MASK),
                           (kal_uint32)(MT6325_PMIC_TEST_OUT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_mon_flag_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TEST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_MON_FLAG_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_MON_FLAG_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_mon_grp_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TEST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_MON_GRP_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_MON_GRP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_nandtree_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_NANDTREE_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_NANDTREE_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_test_auxadc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_TEST_AUXADC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_TEST_AUXADC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_efuse_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_EFUSE_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_EFUSE_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_test_strup(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TEST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_TEST_STRUP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_TEST_STRUP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_testmode_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TESTMODE_SW),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TESTMODE_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_TESTMODE_SW_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_en_status_vdvfs11(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VDVFS11_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VDVFS11_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vdvfs12(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VDVFS12_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VDVFS12_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vdram(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VDRAM_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VDRAM_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vrf18_0(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VRF18_0_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VRF18_0_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vgpu(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VGPU_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VGPU_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vcore1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCORE1_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCORE1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vcore2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCORE2_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCORE2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vio18(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VIO18_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VIO18_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vpa(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VPA_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VPA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vrtc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VRTC_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VRTC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vtcxo0(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VTCXO0_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VTCXO0_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vtcxo1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VTCXO1_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VTCXO1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vaud28(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VAUD28_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VAUD28_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vauxa28(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VAUXA28_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VAUXA28_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vcama(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCAMA_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCAMA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vio28(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VIO28_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VIO28_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vcam_af(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCAM_AF_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCAM_AF_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vmc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VMC_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VMC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vmch(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VMCH_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VMCH_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vemc33(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VEMC33_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VEMC33_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vgp1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VGP1_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VGP1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vefuse(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VEFUSE_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VEFUSE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vsim1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VSIM1_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VSIM1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vsim2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VSIM2_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VSIM2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vcn28(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCN28_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCN28_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vmipi(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VMIPI_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VMIPI_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vibr(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VIBR_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VIBR_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vcamd(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCAMD_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCAMD_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vusb33(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VUSB33_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VUSB33_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vcam_io(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCAM_IO_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCAM_IO_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vsram_dvfs1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VSRAM_DVFS1_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VSRAM_DVFS1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vgp2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VGP2_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VGP2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vgp3(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VGP3_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VGP3_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vbiasn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VBIASN_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VBIASN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vcn33(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCN33_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCN33_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vcn18(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCN18_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VCN18_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_en_status_vrf18_1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_EN_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VRF18_1_MASK),
                           (kal_uint32)(MT6325_PMIC_EN_STATUS_VRF18_1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vdvfs11(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VDVFS11_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VDVFS11_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vdvfs12(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VDVFS12_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VDVFS12_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vdram(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VDRAM_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VDRAM_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vrf18_0(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VRF18_0_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VRF18_0_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vgpu(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VGPU_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VGPU_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vcore1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCORE1_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCORE1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vcore2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCORE2_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCORE2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vio18(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VIO18_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VIO18_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vpa(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VPA_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VPA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vtcxo0(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VTCXO0_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VTCXO0_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vtcxo1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VTCXO1_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VTCXO1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vaud28(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VAUD28_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VAUD28_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vauxa28(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VAUXA28_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VAUXA28_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vcama(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCAMA_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCAMA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vio28(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VIO28_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VIO28_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vcam_af(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCAM_AF_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCAM_AF_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vmc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VMC_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VMC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vmch(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VMCH_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VMCH_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vemc33(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VEMC33_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VEMC33_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vgp1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VGP1_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VGP1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vefuse(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VEFUSE_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VEFUSE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vsim1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VSIM1_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VSIM1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vsim2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VSIM2_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VSIM2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vcn28(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCN28_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCN28_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vmipi(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VMIPI_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VMIPI_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vibr(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VIBR_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VIBR_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vcamd(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCAMD_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCAMD_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vusb33(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VUSB33_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VUSB33_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vcam_io(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCAM_IO_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCAM_IO_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vsram_dvfs1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VSRAM_DVFS1_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VSRAM_DVFS1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vbiasn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VBIASN_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VBIASN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vgp2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VGP2_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VGP2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vgp3(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VGP3_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VGP3_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vcn33(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCN33_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCN33_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vcn18(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCN18_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VCN18_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_oc_status_vrf18_1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OCSTATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VRF18_1_MASK),
                           (kal_uint32)(MT6325_PMIC_OC_STATUS_VRF18_1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vtcxo_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VTCXO_PG_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_VTCXO_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vaud28_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VAUD28_PG_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_VAUD28_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vsram_dvfs1_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_PG_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vio28_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VIO28_PG_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_VIO28_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vio18_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VIO18_PG_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_VIO18_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vcore2_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VCORE2_PG_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_VCORE2_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vcore1_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VCORE1_PG_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_VCORE1_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vgpu_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VGPU_PG_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_VGPU_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vusb_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VUSB_PG_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_VUSB_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vdram_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VDRAM_PG_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_VDRAM_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vdvfs12_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VDVFS12_PG_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_VDVFS12_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vdvfs11_pg_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_PGSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VDVFS11_PG_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_VDVFS11_PG_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_pmu_test_mode_scan(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_TOPSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_PMU_TEST_MODE_SCAN_MASK),
                           (kal_uint32)(MT6325_PMIC_PMU_TEST_MODE_SCAN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_pwrkey_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_TOPSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_PWRKEY_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_PWRKEY_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_homekey_deb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_TOPSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_HOMEKEY_DEB_MASK),
                           (kal_uint32)(MT6325_PMIC_HOMEKEY_DEB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rtc_xtal_det_done(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_TOPSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RTC_XTAL_DET_DONE_MASK),
                           (kal_uint32)(MT6325_PMIC_RTC_XTAL_DET_DONE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_xosc32_enb_det(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_TOPSTATUS),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_XOSC32_ENB_DET_MASK),
                           (kal_uint32)(MT6325_PMIC_XOSC32_ENB_DET_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rtc_xtal_det_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOPSTATUS),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RTC_XTAL_DET_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RTC_XTAL_DET_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pmu_tdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PMU_TDSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PMU_TDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spi_tdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPI_TDSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPI_TDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_aud_tdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_TDSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_TDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_e32cal_tdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_E32CAL_TDSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_E32CAL_TDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pmu_rdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PMU_RDSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PMU_RDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spi_rdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPI_RDSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPI_RDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_aud_rdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_RDSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_RDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_e32cal_rdsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RDSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_E32CAL_RDSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_E32CAL_RDSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_wdtrstb_in(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_WDTRSTB_IN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_WDTRSTB_IN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_homekey(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_HOMEKEY_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_HOMEKEY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_srclken_in0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_SRCLKEN_IN0_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_SRCLKEN_IN0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_srclken_in1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_SRCLKEN_IN1_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_SRCLKEN_IN1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_rtc_32k1v8_0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_RTC_32K1V8_0_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_RTC_32K1V8_0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_rtc_32k1v8_1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_RTC_32K1V8_1_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_RTC_32K1V8_1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_spi_clk(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_SPI_CLK_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_SPI_CLK_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_spi_csn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_SPI_CSN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_SPI_CSN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_spi_mosi(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_SPI_MOSI_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_SPI_MOSI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_spi_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_SPI_MISO_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_SPI_MISO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_aud_clk(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_AUD_CLK_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_AUD_CLK_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_aud_dat_mosi(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_AUD_DAT_MOSI_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_AUD_DAT_MOSI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_aud_dat_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_AUD_DAT_MISO_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_AUD_DAT_MISO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_voice_clk_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_VOICE_CLK_MISO_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_VOICE_CLK_MISO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_enbb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_ENBB_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_ENBB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smt_xosc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_XOSC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMT_XOSC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_srclken_in0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_SRCLKEN_IN0_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_SRCLKEN_IN0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_srclken_in1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_SRCLKEN_IN1_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_SRCLKEN_IN1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_rtc_32k1v8_0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_RTC_32K1V8_0_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_RTC_32K1V8_0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_rtc_32k1v8_1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_RTC_32K1V8_1_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_RTC_32K1V8_1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_spi_clk(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_SPI_CLK_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_SPI_CLK_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_spi_csn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_SPI_CSN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_SPI_CSN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_spi_mosi(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_SPI_MOSI_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_SPI_MOSI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_spi_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_SPI_MISO_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_SPI_MISO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_aud_dat_mosi(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_AUD_DAT_MOSI_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_AUD_DAT_MOSI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_aud_dat_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_AUD_DAT_MISO_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_AUD_DAT_MISO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_aud_clk(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_AUD_CLK_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_AUD_CLK_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_voice_clk_miso(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_VOICE_CLK_MISO_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_VOICE_CLK_MISO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_homekey(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_HOMEKEY_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_HOMEKEY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_enbb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_ENBB_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_ENBB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_octl_xosc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DRV_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_XOSC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OCTL_XOSC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_status(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_STATUS),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_STATUS_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_STATUS_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_rgs_vdvfs11_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_VDVFS11_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_VDVFS11_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_vdvfs12_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_VDVFS12_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_VDVFS12_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_vgpu_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_VGPU_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_VGPU_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_vio18_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_VIO18_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_VIO18_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_vcore1_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_VCORE1_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_VCORE1_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_vcore2_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_VCORE2_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_VCORE2_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_vrf18_0_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_VRF18_0_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_VRF18_0_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_vdram_enpwm_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_VDRAM_ENPWM_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_VDRAM_ENPWM_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_pp_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_PP_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_PP_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_bc11_id_float(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_BC11_ID_FLOAT_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_BC11_ID_FLOAT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_bc11_id_a(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_BC11_ID_A_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_BC11_ID_A_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_bc11_id_b(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_BC11_ID_B_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_BC11_ID_B_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_bc11_id_c(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_BC11_ID_C_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_BC11_ID_C_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_bc11_id_gd(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RGS_ANA_MON),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_BC11_ID_GD_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_BC11_ID_GD_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_g_smps_pd_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_G_SMPS_PD_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_G_SMPS_PD_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_g_smps_aud_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_G_SMPS_AUD_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_G_SMPS_AUD_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_g_drv_2m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_G_DRV_2M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_G_DRV_2M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_drv_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_drv_isink0_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK0_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK0_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_drv_isink1_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK1_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK1_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_drv_isink2_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK2_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK2_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_drv_isink3_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK3_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK3_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auxadc_1m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_1M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_1M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auxadc_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auxadc_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audncp_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDNCP_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDNCP_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audif_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIF_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIF_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_aud_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_zcd13m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ZCD13M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ZCD13M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vow12m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VOW12M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VOW12M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc_mclk_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_MCLK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_MCLK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc_75k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_75K_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_75K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtcdet_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTCDET_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTCDET_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc32k_1v8_0_o_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC32K_1V8_0_O_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC32K_1V8_0_O_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc32k_1v8_1_o_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC32K_1V8_1_O_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC32K_1V8_1_O_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc_2sec_off_det_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_2SEC_OFF_DET_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_2SEC_OFF_DET_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fqmtr_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FQMTR_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FQMTR_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_stb_1m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_STB_1M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_STB_1M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_buck_1m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_1M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_1M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_buck_18m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_18M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_18M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pwmoc_6m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PWMOC_6M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PWMOC_6M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_stb_aud_1m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_STB_AUD_1M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_STB_AUD_1M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_buck_aud_1m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_AUD_1M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_AUD_1M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_buck_aud_18m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_AUD_18M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_AUD_18M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pwmoc_aud_6m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PWMOC_AUD_6M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PWMOC_AUD_6M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_pwm_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_PWM_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_PWM_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fgadc_ana_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FGADC_ANA_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FGADC_ANA_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fgadc_dig_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FGADC_DIG_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FGADC_DIG_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bif_x72_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BIF_X72_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BIF_X72_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bif_x4_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BIF_X4_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BIF_X4_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bif_x1_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BIF_X1_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BIF_X1_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pchr_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PCHR_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PCHR_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_aud18m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUD18M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUD18M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_accdet_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ACCDET_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ACCDET_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fqmtr_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FQMTR_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FQMTR_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_intrp_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INTRP_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INTRP_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc_26m_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_26M_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_26M_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc_eosc32_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_EOSC32_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_EOSC32_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_trim_75k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_TRIM_75K_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_TRIM_75K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_strup_lbat_sel_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_LBAT_SEL_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_LBAT_SEL_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_strup_75k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_75K_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_75K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_strup_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_efuse_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_EFUSE_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_EFUSE_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smps_ck_div_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMPS_CK_DIV_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMPS_CK_DIV_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spi_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPI_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPI_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bgr_test_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_TEST_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_TEST_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fgadc_ft_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FGADC_FT_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FGADC_FT_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pchr_test_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PCHR_TEST_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PCHR_TEST_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_buck_32k_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_32K_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_32K_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_buck_ana_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_ANA_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_ANA_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_eosc_cali_test_ck_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_EOSC_CALI_TEST_CK_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_EOSC_CALI_TEST_CK_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_ckpdn_con3_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKPDN_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_CKPDN_CON3_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_CKPDN_CON3_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audif_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIF_CK_CKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIF_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_aud_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_CK_CKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_drv_isink0_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK0_CK_CKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK0_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_drv_isink1_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK1_CK_CKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK1_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_drv_isink2_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK2_CK_CKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK2_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_drv_isink3_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK3_CK_CKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK3_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fqmtr_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FQMTR_CK_CKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FQMTR_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_75k_32k_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_75K_32K_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_75K_32K_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auxadc_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_CK_CKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_cksel_con0_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_CKSEL_CON0_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_CKSEL_CON0_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_osc_sel_hw_src_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OSC_SEL_HW_SRC_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OSC_SEL_HW_SRC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_strup_75k_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_75K_CK_CKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_75K_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bgr_test_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_TEST_CK_CKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_TEST_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pchr_test_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PCHR_TEST_CK_CKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PCHR_TEST_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fgadc_ana_ck_cksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FGADC_ANA_CK_CKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FGADC_ANA_CK_CKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_cksel_con1_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_CKSEL_CON1_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_CKSEL_CON1_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_srcvolten_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SRCVOLTEN_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SRCVOLTEN_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vowen_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VOWEN_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VOWEN_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_buck_osc_sel_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_OSC_SEL_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_OSC_SEL_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_osc_sel_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_OSC_SEL_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_OSC_SEL_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_srcvolten_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SRCVOLTEN_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SRCVOLTEN_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vowen_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VOWEN_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VOWEN_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_buck_osc_sel_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_OSC_SEL_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_OSC_SEL_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_osc_sel_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_OSC_SEL_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_OSC_SEL_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_cksel_con2_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKSEL_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_CKSEL_CON2_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_CKSEL_CON2_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_strup_lbat_sel_ck_divsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKDIVSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_LBAT_SEL_CK_DIVSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_LBAT_SEL_CK_DIVSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_ckdivsel_con_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKDIVSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_CKDIVSEL_CON_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_CKDIVSEL_CON_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bif_x4_ck_divsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKDIVSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BIF_X4_CK_DIVSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BIF_X4_CK_DIVSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_reg_ck_divsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKDIVSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_REG_CK_DIVSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_REG_CK_DIVSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_buck_18m_ck_divsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKDIVSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_18M_CK_DIVSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_18M_CK_DIVSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auxadc_smps_ck_divsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKDIVSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_SMPS_CK_DIVSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_SMPS_CK_DIVSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_ck_divsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKDIVSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_CK_DIVSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_CK_DIVSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_pwm_ck_divsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKDIVSEL_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_PWM_CK_DIVSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_PWM_CK_DIVSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_g_smps_pd_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_G_SMPS_PD_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_G_SMPS_PD_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_g_smps_aud_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_G_SMPS_AUD_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_G_SMPS_AUD_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_g_drv_2m_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_G_DRV_2M_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_G_DRV_2M_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auxadc_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_buck_1m_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_1M_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_1M_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_buck_aud_1m_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_AUD_1M_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_AUD_1M_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_efuse_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_EFUSE_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_EFUSE_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc_26m_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_26M_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_26M_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_aud18m_ck_pdn_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUD18M_CK_PDN_HWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUD18M_CK_PDN_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auxadc_smps_ck_divsel_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_SMPS_CK_DIVSEL_HWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_SMPS_CK_DIVSEL_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auxadc_ck_cksel_hwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_CK_CKSEL_HWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_CK_CKSEL_HWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_ckhwen_con_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKHWEN_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_CKHWEN_CON_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_CKHWEN_CON_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pmu75k_ck_tst_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PMU75K_CK_TST_DIS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PMU75K_CK_TST_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smps_ck_tst_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMPS_CK_TST_DIS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMPS_CK_TST_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_aud26m_ck_tst_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUD26M_CK_TST_DIS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUD26M_CK_TST_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vow12m_ck_tst_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VOW12M_CK_TST_DIS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VOW12M_CK_TST_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc32k_ck_tst_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC32K_CK_TST_DIS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC32K_CK_TST_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_ck_tst_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_CK_TST_DIS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_CK_TST_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fg_ck_tst_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FG_CK_TST_DIS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FG_CK_TST_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc26m_ck_tst_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC26M_CK_TST_DIS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC26M_CK_TST_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_cktst_con0_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_CKTST_CON0_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_CKTST_CON0_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_buck_ana_auto_off_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_drv_isink0_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK0_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK0_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_drv_isink1_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK1_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK1_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_drv_isink2_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK2_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK2_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_drv_isink3_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK3_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRV_ISINK3_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fqmtr_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FQMTR_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FQMTR_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtcdet_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTCDET_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTCDET_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pmu75k_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PMU75K_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PMU75K_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smps_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMPS_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMPS_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_aud26m_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUD26M_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUD26M_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vow12m_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VOW12M_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VOW12M_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audif_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIF_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIF_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_aud_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_strup_75k_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_75K_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_STRUP_75K_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc32k_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC32K_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC32K_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pchr_test_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PCHR_TEST_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PCHR_TEST_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bgr_test_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_TEST_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BGR_TEST_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fg_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FG_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FG_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fgadc_ana_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FGADC_ANA_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FGADC_ANA_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc26m_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC26M_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC26M_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc_eosc32_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_EOSC32_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_EOSC32_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_eosc_cali_test_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auxadc_ck_tstsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_CK_TSTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_CK_TSTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_cktst_con2_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CKTST_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_CKTST_CON2_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_CKTST_CON2_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_clksq_en_aud(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_clksq_en_fqr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_FQR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_FQR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_clksq_en_aux_ap(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUX_AP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUX_AP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_clksq_en_aux_md(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUX_MD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUX_MD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_clksq_en_aux_gps(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUX_GPS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUX_GPS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_clksq_en_aux_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUX_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUX_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_clksq_en_aux_ap_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUX_AP_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUX_AP_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_clksq_en_aux_md_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUX_MD_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_EN_AUX_MD_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_clksq_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_CLKSQ_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_CLKSQ_RSV_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_da_clksq_en_va28(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_TOP_CLKSQ),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_DA_CLKSQ_EN_VA28_MASK),
                           (kal_uint32)(MT6325_PMIC_DA_CLKSQ_EN_VA28_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_clksq_rtc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ_RTC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_RTC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_RTC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_clksq_rtc_en_hw_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ_RTC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_RTC_EN_HW_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CLKSQ_RTC_EN_HW_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_clksq_rtc_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ_RTC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_CLKSQ_RTC_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_CLKSQ_RTC_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_enbb_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ_RTC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ENBB_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ENBB_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_xosc_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ_RTC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_XOSC_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_XOSC_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_clksq_rtc_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLKSQ_RTC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_CLKSQ_RTC_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_CLKSQ_RTC_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_da_clksq_en_vdig18(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_TOP_CLKSQ_RTC),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_DA_CLKSQ_EN_VDIG18_MASK),
                           (kal_uint32)(MT6325_PMIC_DA_CLKSQ_EN_VDIG18_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_osc_75k_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLK_TRIM),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_OSC_75K_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_OSC_75K_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_osc_75k_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLK_TRIM),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OSC_75K_TRIM_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OSC_75K_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_osc_75k_trim_rate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_CLK_TRIM),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OSC_75K_TRIM_RATE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OSC_75K_TRIM_RATE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_rg_osc_75k_trim(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_TOP_CLK_TRIM),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OSC_75K_TRIM_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OSC_75K_TRIM_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_efuse_man_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_EFUSE_MAN_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_EFUSE_MAN_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auxadc_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auxadc_reg_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_REG_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUXADC_REG_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audio_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIO_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIO_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_accdet_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ACCDET_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ACCDET_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bif_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BIF_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BIF_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_driver_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DRIVER_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DRIVER_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fgadc_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FGADC_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FGADC_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fqmtr_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FQMTR_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FQMTR_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rtc_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RTC_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_chrwdt_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CHRWDT_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CHRWDT_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_zcd_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ZCD_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ZCD_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audncp_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDNCP_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDNCP_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_clk_trim_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CLK_TRIM_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CLK_TRIM_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_rst_con0_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_RST_CON0_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_RST_CON0_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_chr_ldo_det_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CHR_LDO_DET_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CHR_LDO_DET_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_chr_ldo_det_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CHR_LDO_DET_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CHR_LDO_DET_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_chrwdt_flag_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CHRWDT_FLAG_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CHRWDT_FLAG_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_chrwdt_flag_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CHRWDT_FLAG_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CHRWDT_FLAG_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_rst_con1_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_RST_CON1_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_RST_CON1_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_wdtrstb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_WDTRSTB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_WDTRSTB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_wdtrstb_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_WDTRSTB_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_WDTRSTB_MODE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_wdtrstb_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_TOP_RST_MISC),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_WDTRSTB_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_WDTRSTB_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_wdtrstb_status_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_WDTRSTB_STATUS_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_WDTRSTB_STATUS_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_wdtrstb_fb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_WDTRSTB_FB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_WDTRSTB_FB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_homekey_rst_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HOMEKEY_RST_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HOMEKEY_RST_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pwrkey_rst_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PWRKEY_RST_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PWRKEY_RST_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pwrrst_tmr_dis(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PWRRST_TMR_DIS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PWRRST_TMR_DIS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pwrkey_rst_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_MISC),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PWRKEY_RST_TD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PWRKEY_RST_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpwrin_rstb_status(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_STATUS),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPWRIN_RSTB_STATUS_MASK),
                             (kal_uint32)(MT6325_PMIC_VPWRIN_RSTB_STATUS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_ddlo_rstb_status(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_STATUS),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_DDLO_RSTB_STATUS_MASK),
                             (kal_uint32)(MT6325_PMIC_DDLO_RSTB_STATUS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_uvlo_rstb_status(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_STATUS),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_UVLO_RSTB_STATUS_MASK),
                             (kal_uint32)(MT6325_PMIC_UVLO_RSTB_STATUS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rtc_ddlo_rstb_status(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_STATUS),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RTC_DDLO_RSTB_STATUS_MASK),
                             (kal_uint32)(MT6325_PMIC_RTC_DDLO_RSTB_STATUS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_chrwdt_reg_rstb_status(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_STATUS),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_CHRWDT_REG_RSTB_STATUS_MASK),
                             (kal_uint32)(MT6325_PMIC_CHRWDT_REG_RSTB_STATUS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_chrdet_reg_rstb_status(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_STATUS),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_CHRDET_REG_RSTB_STATUS_MASK),
                             (kal_uint32)(MT6325_PMIC_CHRDET_REG_RSTB_STATUS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_top_rst_status_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_TOP_RST_STATUS),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_TOP_RST_STATUS_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_TOP_RST_STATUS_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_pwrkey(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_PWRKEY_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_PWRKEY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_homekey(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_HOMEKEY_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_HOMEKEY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_pwrkey_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_PWRKEY_R_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_PWRKEY_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_homekey_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_HOMEKEY_R_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_HOMEKEY_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_thr_h(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_THR_H_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_THR_H_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_thr_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_THR_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_THR_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_bat_h(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_BAT_H_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_BAT_H_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_bat_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_BAT_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_BAT_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_bif(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_BIF_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_BIF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_rtc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_RTC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_RTC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_audio(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_AUDIO_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_AUDIO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_vow(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VOW_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VOW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_accdet(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_ACCDET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_ACCDET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_accdet_eint(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_ACCDET_EINT_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_ACCDET_EINT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_accdet_negv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_ACCDET_NEGV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_ACCDET_NEGV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_ni_lbat_int(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_NI_LBAT_INT_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_NI_LBAT_INT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_vdvfs11_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VDVFS11_OC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VDVFS11_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_vdvfs12_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VDVFS12_OC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VDVFS12_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_vrf18_0_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VRF18_0_OC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VRF18_0_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_vdram_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VDRAM_OC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VDRAM_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_vgpu_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VGPU_OC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VGPU_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_vcore1_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VCORE1_OC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VCORE1_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_vcore2_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VCORE2_OC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VCORE2_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_vio18_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VIO18_OC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VIO18_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_vpa_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VPA_OC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VPA_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_ldo_oc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_LDO_OC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_LDO_OC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_bat2_h(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_BAT2_H_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_BAT2_H_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_bat2_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_BAT2_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_BAT2_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_vismps0_h(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VISMPS0_H_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VISMPS0_H_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_vismps0_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VISMPS0_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VISMPS0_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_auxadc_imp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_AUXADC_IMP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_AUXADC_IMP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_ov(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_OV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_OV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_bvalid_det(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_BVALID_DET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_BVALID_DET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_vbaton_undet(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VBATON_UNDET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_VBATON_UNDET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_watchdog(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_WATCHDOG_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_WATCHDOG_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_pchr_cm_vdec(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_PCHR_CM_VDEC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_PCHR_CM_VDEC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_chrdet(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_CHRDET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_CHRDET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_pchr_cm_vinc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_PCHR_CM_VINC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_PCHR_CM_VINC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_fg_bat_h(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_FG_BAT_H_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_FG_BAT_H_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_fg_bat_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_FG_BAT_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_FG_BAT_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_fg_cur_h(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_FG_CUR_H_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_FG_CUR_H_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_fg_cur_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_FG_CUR_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_FG_CUR_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_fg_zcv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_FG_ZCV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_FG_ZCV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_spkl_d(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_SPKL_D_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_SPKL_D_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_int_en_spkl_ab(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_SPKL_AB_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_INT_EN_SPKL_AB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_polarity(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_MISC_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_POLARITY_MASK),
                             (kal_uint32)(MT6325_PMIC_POLARITY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_homekey_int_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_MISC_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HOMEKEY_INT_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HOMEKEY_INT_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pwrkey_int_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_MISC_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PWRKEY_INT_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PWRKEY_INT_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_chrdet_int_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_MISC_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CHRDET_INT_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CHRDET_INT_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pchr_cm_vinc_polarity_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_MISC_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PCHR_CM_VINC_POLARITY_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PCHR_CM_VINC_POLARITY_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pchr_cm_vdec_polarity_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_MISC_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_rg_int_status_pwrkey(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_PWRKEY_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_PWRKEY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_homekey(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_HOMEKEY_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_HOMEKEY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_pwrkey_r(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_PWRKEY_R_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_PWRKEY_R_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_homekey_r(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_HOMEKEY_R_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_HOMEKEY_R_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_thr_h(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_THR_H_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_THR_H_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_thr_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_THR_L_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_THR_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_bat_h(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_BAT_H_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_BAT_H_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_bat_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_BAT_L_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_BAT_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_bif(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_BIF_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_BIF_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_rtc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_RTC_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_RTC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_audio(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_AUDIO_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_AUDIO_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_vow(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VOW_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VOW_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_accdet(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_ACCDET_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_ACCDET_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_accdet_eint(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_ACCDET_EINT_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_ACCDET_EINT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_accdet_negv(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_ACCDET_NEGV_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_ACCDET_NEGV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_ni_lbat_int(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_NI_LBAT_INT_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_NI_LBAT_INT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_vdvfs11_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VDVFS11_OC_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VDVFS11_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_vdvfs12_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VDVFS12_OC_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VDVFS12_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_vrf18_0_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VRF18_0_OC_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VRF18_0_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_vdram_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VDRAM_OC_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VDRAM_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_vgpu_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VGPU_OC_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VGPU_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_vcore1_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VCORE1_OC_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VCORE1_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_vcore2_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VCORE2_OC_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VCORE2_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_vio18_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VIO18_OC_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VIO18_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_vpa_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VPA_OC_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VPA_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_ldo_oc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_LDO_OC_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_LDO_OC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_bat2_h(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_BAT2_H_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_BAT2_H_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_bat2_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_BAT2_L_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_BAT2_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_vismps0_h(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VISMPS0_H_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VISMPS0_H_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_vismps0_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VISMPS0_L_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VISMPS0_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_auxadc_imp(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_AUXADC_IMP_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_AUXADC_IMP_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_ov(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_OV_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_OV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_bvalid_det(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_BVALID_DET_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_BVALID_DET_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_vbaton_undet(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VBATON_UNDET_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_VBATON_UNDET_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_watchdog(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_WATCHDOG_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_WATCHDOG_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_pchr_cm_vdec(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_PCHR_CM_VDEC_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_PCHR_CM_VDEC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_chrdet(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_CHRDET_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_CHRDET_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_pchr_cm_vinc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_PCHR_CM_VINC_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_PCHR_CM_VINC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_fg_bat_h(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_FG_BAT_H_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_FG_BAT_H_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_fg_bat_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_FG_BAT_L_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_FG_BAT_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_fg_cur_h(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_FG_CUR_H_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_FG_CUR_H_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_fg_cur_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_FG_CUR_L_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_FG_CUR_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_fg_zcv(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_FG_ZCV_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_FG_ZCV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_spkl_d(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_SPKL_D_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_SPKL_D_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_int_status_spkl_ab(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STATUS2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_SPKL_AB_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_INT_STATUS_SPKL_AB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_oc_gear_ldo(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OC_GEAR_0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_OC_GEAR_LDO_MASK),
                             (kal_uint32)(MT6325_PMIC_OC_GEAR_LDO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fqmtr_tcksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FQMTR_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FQMTR_TCKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_FQMTR_TCKSEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_fqmtr_busy(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FQMTR_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FQMTR_BUSY_MASK),
                           (kal_uint32)(MT6325_PMIC_FQMTR_BUSY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_fqmtr_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FQMTR_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FQMTR_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_FQMTR_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fqmtr_winset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FQMTR_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FQMTR_WINSET_MASK),
                             (kal_uint32)(MT6325_PMIC_FQMTR_WINSET_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_fqmtr_data(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FQMTR_CON2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FQMTR_DATA_MASK),
                           (kal_uint32)(MT6325_PMIC_FQMTR_DATA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_slp_rw_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RG_SPI_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SLP_RW_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SLP_RW_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spi_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RG_SPI_CON),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPI_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPI_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_dew_dio_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DEW_DIO_EN),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_DEW_DIO_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_DEW_DIO_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_dew_read_test(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_DEW_READ_TEST),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_DEW_READ_TEST_MASK),
                           (kal_uint32)(MT6325_PMIC_DEW_READ_TEST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_dew_write_test(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DEW_WRITE_TEST),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_DEW_WRITE_TEST_MASK),
                             (kal_uint32)(MT6325_PMIC_DEW_WRITE_TEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_dew_crc_swrst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DEW_CRC_SWRST),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_DEW_CRC_SWRST_MASK),
                             (kal_uint32)(MT6325_PMIC_DEW_CRC_SWRST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_dew_crc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DEW_CRC_EN),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_DEW_CRC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_DEW_CRC_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_dew_crc_val(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_DEW_CRC_VAL),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_DEW_CRC_VAL_MASK),
                           (kal_uint32)(MT6325_PMIC_DEW_CRC_VAL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_dew_dbg_mon_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DEW_DBG_MON_SEL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_DEW_DBG_MON_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_DEW_DBG_MON_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_dew_cipher_key_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DEW_CIPHER_KEY_SEL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_DEW_CIPHER_KEY_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_DEW_CIPHER_KEY_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_dew_cipher_iv_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DEW_CIPHER_IV_SEL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_DEW_CIPHER_IV_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_DEW_CIPHER_IV_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_dew_cipher_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DEW_CIPHER_EN),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_DEW_CIPHER_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_DEW_CIPHER_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_dew_cipher_rdy(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_DEW_CIPHER_RDY),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_DEW_CIPHER_RDY_MASK),
                           (kal_uint32)(MT6325_PMIC_DEW_CIPHER_RDY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_dew_cipher_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DEW_CIPHER_MODE),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_DEW_CIPHER_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_DEW_CIPHER_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_dew_cipher_swrst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DEW_CIPHER_SWRST),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_DEW_CIPHER_SWRST_MASK),
                             (kal_uint32)(MT6325_PMIC_DEW_CIPHER_SWRST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_dew_rddmy_no(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_DEW_RDDMY_NO),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_DEW_RDDMY_NO_MASK),
                             (kal_uint32)(MT6325_PMIC_DEW_RDDMY_NO_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_int_type_con0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_TYPE_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_INT_TYPE_CON0_MASK),
                             (kal_uint32)(MT6325_PMIC_INT_TYPE_CON0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_int_type_con1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_TYPE_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_INT_TYPE_CON1_MASK),
                             (kal_uint32)(MT6325_PMIC_INT_TYPE_CON1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_int_type_con2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_INT_TYPE_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_INT_TYPE_CON2_MASK),
                             (kal_uint32)(MT6325_PMIC_INT_TYPE_CON2_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_cpu_int_sta(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STA),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_CPU_INT_STA_MASK),
                           (kal_uint32)(MT6325_PMIC_CPU_INT_STA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_md32_int_sta(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_INT_STA),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_MD32_INT_STA_MASK),
                           (kal_uint32)(MT6325_PMIC_MD32_INT_STA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_buck_all_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BUCK_ALL_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_BUCK_ALL_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsleep_src0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSLEEP_SRC0_MASK),
                             (kal_uint32)(MT6325_PMIC_VSLEEP_SRC0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsleep_src1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSLEEP_SRC1_MASK),
                             (kal_uint32)(MT6325_PMIC_VSLEEP_SRC1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_r2r_src0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_R2R_SRC0_MASK),
                             (kal_uint32)(MT6325_PMIC_R2R_SRC0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_r2r_src1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_R2R_SRC1_MASK),
                             (kal_uint32)(MT6325_PMIC_R2R_SRC1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_buck_osc_sel_src0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BUCK_OSC_SEL_SRC0_MASK),
                             (kal_uint32)(MT6325_PMIC_BUCK_OSC_SEL_SRC0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_srclken_dly_src1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SRCLKEN_DLY_SRC1_MASK),
                             (kal_uint32)(MT6325_PMIC_SRCLKEN_DLY_SRC1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_buck_con5_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BUCK_CON5_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_BUCK_CON5_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vgpu_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON5),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_DIG_MON_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vio18_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON5),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_DIG_MON_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcore1_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON6),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_DIG_MON_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcore2_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON6),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_DIG_MON_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vrf18_0_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON7),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_0_DIG_MON_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_0_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vpa_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON7),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_DIG_MON_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vdvfs11_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON8),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS11_DIG_MON_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS11_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vdvfs12_dig_mon(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON8),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS12_DIG_MON_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS12_DIG_MON_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdvfs11_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_WND_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_THD_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_WND_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_THD_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_WND_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_THD_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_WND_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_THD_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_WND_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_THD_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_WND_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_THD_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_WND_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_THD_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_WND_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_THD_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_oc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_oc_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_DEG_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_WND_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_THD_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_oc_flag_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_FLAG_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_FLAG_CLR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_oc_flag_clr_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_FLAG_CLR_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_FLAG_CLR_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_vdvfs11_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VDVFS11_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_VDVFS11_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vdvfs12_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VDVFS12_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_VDVFS12_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vrf18_0_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VRF18_0_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_VRF18_0_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vpa_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VPA_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_VPA_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vgpu_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VGPU_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_VGPU_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vcore1_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VCORE1_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_VCORE1_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vcore2_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VCORE2_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_VCORE2_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vio18_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VIO18_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_VIO18_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vdram_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_ALL_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VDRAM_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_VDRAM_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdvfs11_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_INT_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_INT_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_INT_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_INT_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_INT_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_INT_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_INT_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_INT_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_oc_int_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_INT_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_OC_INT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_en_oc_sdn_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_EN_OC_SDN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_EN_OC_SDN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_track_sleep_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_TRACK_SLEEP_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_TRACK_SLEEP_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_track_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_TRACK_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_TRACK_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs1_track_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS1_TRACK_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS1_TRACK_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_vosel_delta(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_DELTA_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_DELTA_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_vosel_offset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_OFFSET_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_OFFSET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_vosel_on_lb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_ON_LB_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_ON_LB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_vosel_on_hb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_ON_HB_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_ON_HB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_vosel_sleep_lb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_SLEEP_LB_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_SLEEP_LB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vdvfs11_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VDVFS11_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VDVFS11_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vdvfs12_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VDVFS12_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VDVFS12_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vgpu_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VGPU_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VGPU_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vcore1_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VCORE1_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VCORE1_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vcore2_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VCORE2_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VCORE2_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vdram_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VDRAM_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VDRAM_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vsram_dvfs1_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VSRAM_DVFS1_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VSRAM_DVFS1_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vdvfs11_vsleep_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VDVFS11_VSLEEP_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VDVFS11_VSLEEP_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vdvfs12_vsleep_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VDVFS12_VSLEEP_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VDVFS12_VSLEEP_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vgpu_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VGPU_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VGPU_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vcore1_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VCORE1_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VCORE1_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vcore2_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VCORE2_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VCORE2_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vdram_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VDRAM_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VDRAM_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vrf18_0_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VRF18_0_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VRF18_0_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_qi_vio18_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_ALL_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_QI_VIO18_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_QI_VIO18_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_min_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_MIN_OFF_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_MIN_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_nvt_buff_off_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_NVT_BUFF_OFF_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_NVT_BUFF_OFF_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_vrf18_sstart_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_VRF18_SSTART_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_VRF18_SSTART_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_1p35up_sel_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_1P35UP_SEL_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_1P35UP_SEL_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_rzsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_RZSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_RZSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_cc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_CC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_CC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_CSR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_CSL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_SLP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_ZX_OS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_MODESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_CSM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_pfm_rip(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_PFM_RIP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_PFM_RIP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_tran_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_TRAN_BST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_TRAN_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_dts_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_DTS_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_DTS_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_rcl_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_RCL_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_RCL_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_rcl_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_RCL_TRIM_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_RCL_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_c2_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_C2_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_C2_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_min_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_MIN_OFF_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_MIN_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_nvt_buff_off_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_NVT_BUFF_OFF_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_NVT_BUFF_OFF_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_vrf18_sstart_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_VRF18_SSTART_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_VRF18_SSTART_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_1p35up_sel_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_1P35UP_SEL_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_1P35UP_SEL_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_rzsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_RZSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_RZSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_cc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_CC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_CC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_CSR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_CSL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_SLP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_ZX_OS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_MODESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_CSM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_pfm_rip(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_PFM_RIP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_PFM_RIP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_tran_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_TRAN_BST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_TRAN_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_dts_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_DTS_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_DTS_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_rcl_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_RCL_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_RCL_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_rcl_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_RCL_TRIM_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_RCL_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_c2_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_C2_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_C2_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_smps_testmode_b(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SMPS_TESTMODE_B_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SMPS_TESTMODE_B_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsram_dvfs1_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_TRIMH_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsram_dvfs1_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_TRIML_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_TRIMH_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_TRIML_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_TRIMH_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_TRIML_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_TRIMH_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_TRIML_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_TRIMH_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_TRIML_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_TRIMH_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_TRIML_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_TRIMH_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_TRIML_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_TRIMH_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_TRIML_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_trim_ref(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_TRIM_REF_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_TRIM_REF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_TRIMH_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_TRIML_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_trimh(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_TRIMH_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_TRIMH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_triml(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_TRIML_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_TRIML_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsram_dvfs1_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore1_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE1_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_bursth(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_BURSTH_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_BURSTH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_burstl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_BURSTL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_BURSTL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdram_vsleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_VSLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDRAM_VSLEEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_dmy100ma_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DMY100MA_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DMY100MA_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_dmy100ma_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SMPS_TOP_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DMY100MA_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DMY100MA_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs1_min_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS1_MIN_OFF_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS1_MIN_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs1_nvt_buff_off_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS1_NVT_BUFF_OFF_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS1_NVT_BUFF_OFF_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs1_vrf18_sstart_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS1_VRF18_SSTART_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS1_VRF18_SSTART_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs1_1p35up_sel_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS1_1P35UP_SEL_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS1_1P35UP_SEL_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_rzsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_RZSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_RZSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_rzsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_RZSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_RZSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_pfm_rip(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_PFM_RIP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_PFM_RIP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_CSR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_CSR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_pfm_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_PFM_CSR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_PFM_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_pfm_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_PFM_CSR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_PFM_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_CSL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_CSL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_SLP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_SLP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_ZX_OS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_ZX_OS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_MODESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_MODESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_trans_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_TRANS_BST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_TRANS_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_trans_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_TRANS_BST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_TRANS_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_uvp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_UVP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_UVP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_uvp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_UVP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_UVP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_CSM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_CSM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_pkmode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_PKMODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_PKMODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_pkmode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_PKMODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_PKMODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_oc_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_OC_OFF_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_OC_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs12_oc_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_OC_OFF_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS12_OC_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdvfs11_phs_shed_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS1_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_PHS_SHED_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDVFS11_PHS_SHED_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_min_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_MIN_OFF_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_MIN_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_nvt_buff_off_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_NVT_BUFF_OFF_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_NVT_BUFF_OFF_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_vrf18_sstart_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_VRF18_SSTART_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_VRF18_SSTART_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_1p35up_sel_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_1P35UP_SEL_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_1P35UP_SEL_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_rzsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_RZSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_RZSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_cc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_CC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_CC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_CSR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_CSL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_SLP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_ZX_OS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_MODESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_CSM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_pfm_rip(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_PFM_RIP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_PFM_RIP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_tran_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_TRAN_BST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_TRAN_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_dts_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_DTS_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_DTS_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_rcl_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_RCL_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_RCL_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_rcl_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_RCL_TRIM_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_RCL_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgpu_c2_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_C2_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGPU_C2_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_rzsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_RZSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_RZSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_cc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_CC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_CC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_CSR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_csmir(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_CSMIR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_CSMIR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_CSL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_SLP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_zx_os_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_ZX_OS_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_ZX_OS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_ZX_OS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_hzp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_HZP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_HZP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_bwex_gat(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_BWEX_GAT_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_BWEX_GAT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_MODESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_slew(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_SLEW_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_SLEW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_slew_nmos(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_SLEW_NMOS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_SLEW_NMOS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_min_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_MIN_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_MIN_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_vbat_del(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_VBAT_DEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_VBAT_DEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vpa_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VPA_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_min_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_MIN_OFF_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_MIN_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_nvt_buff_off_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_NVT_BUFF_OFF_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_NVT_BUFF_OFF_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_vrf18_sstart_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_VRF18_SSTART_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_VRF18_SSTART_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_1p35up_sel_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_1P35UP_SEL_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_1P35UP_SEL_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_rzsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_RZSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_RZSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_cc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_CC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_CC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_CSR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_CSL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_SLP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_ZX_OS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_MODESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_CSM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_pfm_rip(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_PFM_RIP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_PFM_RIP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_tran_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_TRAN_BST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_TRAN_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_dts_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_DTS_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_DTS_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_rcl_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_RCL_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_RCL_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_rcl_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_RCL_TRIM_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_RCL_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcore2_c2_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_C2_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCORE2_C2_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_min_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_MIN_OFF_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_MIN_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_nvt_buff_off_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_NVT_BUFF_OFF_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_NVT_BUFF_OFF_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_vrf18_sstart_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_VRF18_SSTART_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_VRF18_SSTART_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_1p35up_sel_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_1P35UP_SEL_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_1P35UP_SEL_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_rzsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_RZSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_RZSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_cc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_CC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_CC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_CSR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_CSL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_SLP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_ZX_OS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_MODESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_CSM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_pfm_rip(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_PFM_RIP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_PFM_RIP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_tran_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_TRAN_BST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_TRAN_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_dts_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_DTS_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_DTS_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_rcl_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_RCL_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_RCL_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_rcl_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_RCL_TRIM_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_RCL_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio18_c2_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_C2_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO18_C2_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf1_min_off(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF1_MIN_OFF_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF1_MIN_OFF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_nvt_buff_off_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_NVT_BUFF_OFF_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_NVT_BUFF_OFF_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_sstart_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_SSTART_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_SSTART_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_1p35up_sel_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_1P35UP_SEL_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_1P35UP_SEL_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_rzsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_RZSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_RZSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_cc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_CC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_CC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_csr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_CSR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_CSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_csl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_CSL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_CSL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_slp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_SLP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_SLP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_zx_os(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_ZX_OS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_ZX_OS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_zxos_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_ZXOS_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_ZXOS_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_modeset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_MODESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_MODESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_csm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_CSM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_CSM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_pfm_rip(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_PFM_RIP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_PFM_RIP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_tran_bst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_TRAN_BST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_TRAN_BST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_dts_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_DTS_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_DTS_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_rcl_trim(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_RCL_TRIM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_RCL_TRIM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_rcl_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_RCL_TRIM_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_RCL_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_0_c2_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_C2_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_0_C2_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_EN_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_dig1_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_DIG1_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_DIG1_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_dig0_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_DIG0_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_DIG0_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_dig1_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_DIG1_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_DIG1_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vdvfs11_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS11_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS11_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS11_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vdvfs11_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS11_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS11_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS11_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vdvfs11_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS11_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS11_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS11_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdvfs11_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_SFCHG_REN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VOSEL_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vdvfs11_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS11_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS11_VOSEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS11_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdvfs11_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_TRANS_TD_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vdvfs11_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS11_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS11_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS11_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdvfs11_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_R2R_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs11_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS11_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS11_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vdvfs11_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS11_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS11_R2R_PDN_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS11_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_vdvfs11_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS11_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS11_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS11_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdvfs12_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_EN_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_dig1_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_DIG1_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_DIG1_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_dig0_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_DIG0_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_DIG0_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_dig1_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_DIG1_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_DIG1_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vdvfs12_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS12_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS12_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS12_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vdvfs12_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS12_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS12_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS12_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vdvfs12_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS12_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS12_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VDVFS12_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdvfs12_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_SFCHG_REN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VOSEL_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vdvfs12_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS12_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS12_VOSEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS12_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdvfs12_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_TRANS_TD_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vdvfs12_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS12_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS12_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS12_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdvfs12_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_R2R_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdvfs12_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDVFS12_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDVFS12_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vdvfs12_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS12_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS12_R2R_PDN_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS12_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_vdvfs12_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDVFS12_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS12_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VDVFS12_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vsram_dvfs1_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_EN_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_dig1_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG1_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG1_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_dig0_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG0_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG0_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_dig1_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG1_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG1_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_vsram_dvfs1_dig0_rsv4(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG0_RSV4_MASK),
                           (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG0_RSV4_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_vsram_dvfs1_dig0_rsv3(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG0_RSV3_MASK),
                           (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_DIG0_RSV3_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vsram_dvfs1_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VSRAM_DVFS1_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VSRAM_DVFS1_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vsram_dvfs1_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_SFCHG_REN_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_vosel_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vsram_dvfs1_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VSRAM_DVFS1_VOSEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VSRAM_DVFS1_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vsram_dvfs1_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_TRANS_TD_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vsram_dvfs1_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VSRAM_DVFS1_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VSRAM_DVFS1_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vsram_dvfs1_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_R2R_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vsram_dvfs1_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VSRAM_DVFS1_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vsram_dvfs1_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VSRAM_DVFS1_R2R_PDN_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VSRAM_DVFS1_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_vsram_dvfs1_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VSRAM_DVFS1_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VSRAM_DVFS1_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VSRAM_DVFS1_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdram_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_EN_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_burst_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_BURST_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_BURST_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_dig0_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_DIG0_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_DIG0_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_burst_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_BURST_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_BURST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vdram_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDRAM_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VDRAM_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VDRAM_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vdram_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDRAM_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VDRAM_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VDRAM_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vdram_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDRAM_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VDRAM_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VDRAM_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdram_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_SFCHG_REN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VOSEL_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vdram_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDRAM_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VDRAM_VOSEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VDRAM_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdram_burst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_BURST_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_BURST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_burst_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_BURST_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_BURST_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_burst_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_BURST_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_BURST_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vdram_burst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDRAM_CON15),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VDRAM_BURST_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VDRAM_BURST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdram_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_TRANS_TD_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vdram_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDRAM_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VDRAM_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VDRAM_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vdram_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_R2R_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vdram_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VDRAM_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VDRAM_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vdram_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDRAM_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VDRAM_R2R_PDN_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VDRAM_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_vdram_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VDRAM_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VDRAM_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VDRAM_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vrf18_0_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_EN_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_burst_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_BURST_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_BURST_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_dig0_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_DIG0_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_DIG0_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_burst_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_BURST_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_BURST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vrf18_0_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VRF18_0_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_0_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_0_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vrf18_0_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VRF18_0_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_0_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_0_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vrf18_0_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VRF18_0_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_0_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_0_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vrf18_0_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_SFCHG_REN_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VOSEL_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vrf18_0_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VRF18_0_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VRF18_0_VOSEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VRF18_0_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vrf18_0_burst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_BURST_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_BURST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_burst_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_BURST_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_BURST_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_burst_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_BURST_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_BURST_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vrf18_0_burst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VRF18_0_CON15),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_0_BURST_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_0_BURST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vrf18_0_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_TRANS_TD_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vrf18_0_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VRF18_0_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VRF18_0_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VRF18_0_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vrf18_0_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_R2R_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vrf18_0_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VRF18_0_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VRF18_0_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vrf18_0_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VRF18_0_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VRF18_0_R2R_PDN_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VRF18_0_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_vrf18_0_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VRF18_0_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VRF18_0_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VRF18_0_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vgpu_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_EN_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_dlc_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_burst_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_BURST_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_BURST_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_dlc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_burst_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_BURST_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_BURST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vgpu_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VGPU_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vgpu_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VGPU_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vgpu_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VGPU_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vgpu_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_SFCHG_REN_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_VOSEL_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vgpu_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VGPU_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VGPU_VOSEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VGPU_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vgpu_burst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_BURST_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_BURST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_burst_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_BURST_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_BURST_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_burst_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_BURST_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_BURST_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vgpu_burst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VGPU_CON15),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_BURST_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_BURST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vgpu_dlc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_dlc_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_dlc_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vgpu_dlc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VGPU_CON16),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_DLC_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_DLC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vgpu_dlc_n(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_N_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_N_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_dlc_n_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_N_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_N_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_dlc_n_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_N_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_DLC_N_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vgpu_dlc_n(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VGPU_CON17),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_DLC_N_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGPU_DLC_N_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vgpu_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_TRANS_TD_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vgpu_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VGPU_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VGPU_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VGPU_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vgpu_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_R2R_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vgpu_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VGPU_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VGPU_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VGPU_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vgpu_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VGPU_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VGPU_R2R_PDN_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VGPU_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_vgpu_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VGPU_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VGPU_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VGPU_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore1_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_EN_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_dlc_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_burst_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_BURST_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_BURST_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_dlc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_burst_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_BURST_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_BURST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcore1_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE1_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcore1_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE1_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcore1_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE1_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore1_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_SFCHG_REN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VOSEL_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vcore1_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE1_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE1_VOSEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE1_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore1_burst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_BURST_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_BURST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_burst_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_BURST_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_BURST_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_burst_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_BURST_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_BURST_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcore1_burst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE1_CON15),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_BURST_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_BURST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore1_dlc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_dlc_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_dlc_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcore1_dlc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE1_CON16),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_DLC_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_DLC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore1_dlc_n(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_N_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_N_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_dlc_n_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_N_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_N_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_dlc_n_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_N_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_DLC_N_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcore1_dlc_n(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE1_CON17),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_DLC_N_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE1_DLC_N_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore1_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_TRANS_TD_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vcore1_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE1_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE1_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE1_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore1_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_R2R_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore1_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE1_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE1_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vcore1_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE1_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE1_R2R_PDN_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE1_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_vcore1_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE1_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE1_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE1_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore2_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_EN_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_dlc_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_burst_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_BURST_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_BURST_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_dlc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_burst_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_BURST_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_BURST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcore2_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE2_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcore2_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE2_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcore2_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE2_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore2_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_SFCHG_REN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VOSEL_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vcore2_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE2_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE2_VOSEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE2_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore2_burst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_BURST_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_BURST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_burst_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_BURST_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_BURST_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_burst_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_BURST_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_BURST_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcore2_burst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE2_CON15),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_BURST_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_BURST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore2_dlc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_dlc_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_dlc_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcore2_dlc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE2_CON16),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_DLC_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_DLC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore2_dlc_n(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_N_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_N_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_dlc_n_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_N_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_N_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_dlc_n_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_N_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_DLC_N_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcore2_dlc_n(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE2_CON17),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_DLC_N_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCORE2_DLC_N_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore2_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_TRANS_TD_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vcore2_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE2_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE2_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE2_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore2_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_R2R_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vcore2_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vcore2_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE2_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE2_R2R_PDN_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE2_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_vcore2_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE2_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE2_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VCORE2_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vcore2_vosel_aud(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VOSEL_AUD_MASK),
                             (kal_uint32)(MT6325_PMIC_VCORE2_VOSEL_AUD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_buck_dvfs_done(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BUCK_DVFS_DONE_MASK),
                             (kal_uint32)(MT6325_PMIC_BUCK_DVFS_DONE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_buck_dvfs_done_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VCORE2_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BUCK_DVFS_DONE_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_BUCK_DVFS_DONE_SW_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_vcore_dvfs_done_sta(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VCORE2_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_VCORE_DVFS_DONE_STA_MASK),
                           (kal_uint32)(MT6325_PMIC_VCORE_DVFS_DONE_STA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vio18_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_EN_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_dlc_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_burst_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_BURST_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_BURST_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_dlc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_burst_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_BURST_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_BURST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vio18_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VIO18_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vio18_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VIO18_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vio18_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VIO18_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vio18_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_SFCHG_REN_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_VOSEL_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vio18_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VIO18_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VIO18_VOSEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VIO18_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vio18_burst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_BURST_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_BURST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_burst_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_BURST_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_BURST_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_burst_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_BURST_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_BURST_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vio18_burst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VIO18_CON15),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_BURST_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_BURST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vio18_dlc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_dlc_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_dlc_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vio18_dlc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VIO18_CON16),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_DLC_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_DLC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vio18_dlc_n(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_N_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_N_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_dlc_n_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_N_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_N_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_dlc_n_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_N_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_DLC_N_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vio18_dlc_n(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VIO18_CON17),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_DLC_N_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VIO18_DLC_N_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vio18_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_TRANS_TD_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vio18_vosel_trans(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VIO18_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VIO18_VOSEL_TRANS_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VIO18_VOSEL_TRANS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vio18_vsleep_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_VSLEEP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_VSLEEP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_r2r_pdn(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_R2R_PDN_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_R2R_PDN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vio18_vsleep_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VIO18_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VIO18_VSLEEP_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VIO18_VSLEEP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vio18_r2r_pdn(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VIO18_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VIO18_R2R_PDN_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VIO18_R2R_PDN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_vio18_vsleep_sel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VIO18_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VIO18_VSLEEP_SEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VIO18_VSLEEP_SEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vpa_dig0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG0_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_en_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_EN_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_EN_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_dlc_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DLC_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DLC_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_burst_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_BURST_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_BURST_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_vosel_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_dlc_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DLC_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DLC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_burst_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_BURST_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_BURST_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vpa_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VPA_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vpa_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VPA_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vpa_oc_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VPA_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_OC_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_OC_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vpa_sfchg_frate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_SFCHG_FRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_SFCHG_FRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_sfchg_fen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_SFCHG_FEN_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_SFCHG_FEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_sfchg_rrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_SFCHG_RRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_SFCHG_RRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_sfchg_ren(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_SFCHG_REN_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_SFCHG_REN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_vosel_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_vosel_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vpa_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VPA_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VPA_VOSEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VPA_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vpa_dig0_rsv3(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG0_RSV3_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG0_RSV3_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_dlc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DLC_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DLC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_dlc_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DLC_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DLC_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_dlc_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DLC_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DLC_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vpa_dlc(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VPA_CON16),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_DLC_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_DLC_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vpa_dig0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG0_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_dig1_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG1_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG1_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_TRANS_TD_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vpa_dvs_bw(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VPA_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VPA_DVS_BW_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VPA_DVS_BW_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vpa_dig1_rsv4(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG1_RSV4_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG1_RSV4_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_dig1_rsv3(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG1_RSV3_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG1_RSV3_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_bursth(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_BURSTH_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_BURSTH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_bursth_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_BURSTH_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_BURSTH_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_bursth_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_BURSTH_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_BURSTH_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vpa_bursth(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VPA_CON19),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_BURSTH_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_BURSTH_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vpa_burstl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_BURSTL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_BURSTL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_burstl_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_BURSTL_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_BURSTL_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_burstl_sleep(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_BURSTL_SLEEP_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_BURSTL_SLEEP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vpa_burstl(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VPA_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_BURSTL_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VPA_BURSTL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vpa_vosel_dlc011(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_DLC011_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_DLC011_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_vosel_dlc111(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_DLC111_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_DLC111_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_dlc_map_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DLC_MAP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DLC_MAP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_vosel_dlc001(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_DLC001_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_VOSEL_DLC001_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_dvs_trans_td(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DVS_TRANS_TD_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DVS_TRANS_TD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_dvs_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DVS_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DVS_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_dvs_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DVS_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DVS_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_vpa_dvs_transt(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_VPA_CON23),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VPA_DVS_TRANST_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VPA_DVS_TRANST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_vpa_dig0_rsv4(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG0_RSV4_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG0_RSV4_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_vpa_dig1_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_VPA_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG1_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_VPA_DIG1_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_k_rst_done(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_K_RST_DONE_MASK),
                             (kal_uint32)(MT6325_PMIC_K_RST_DONE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_k_map_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_K_MAP_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_K_MAP_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_k_once_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_K_ONCE_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_K_ONCE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_k_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_K_ONCE_MASK),
                             (kal_uint32)(MT6325_PMIC_K_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_k_start_manual(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_K_START_MANUAL_MASK),
                             (kal_uint32)(MT6325_PMIC_K_START_MANUAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_k_src_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_K_SRC_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_K_SRC_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_k_auto_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_K_AUTO_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_K_AUTO_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_k_inv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_K_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_K_INV_MASK),
                             (kal_uint32)(MT6325_PMIC_K_INV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_k_control_smps(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_K_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_K_CONTROL_SMPS_MASK),
                             (kal_uint32)(MT6325_PMIC_K_CONTROL_SMPS_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_k_result(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_K_CON2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_K_RESULT_MASK),
                           (kal_uint32)(MT6325_PMIC_K_RESULT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_k_done(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_K_CON2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_K_DONE_MASK),
                           (kal_uint32)(MT6325_PMIC_K_DONE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_k_control(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_K_CON2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_K_CONTROL_MASK),
                           (kal_uint32)(MT6325_PMIC_K_CONTROL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_smps_osc_cal(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BUCK_K_CON2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_SMPS_OSC_CAL_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_SMPS_OSC_CAL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_k_buck_ck_cnt(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BUCK_K_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_K_BUCK_CK_CNT_MASK),
                             (kal_uint32)(MT6325_PMIC_K_BUCK_CK_CNT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audzcdenable(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ZCD_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDZCDENABLE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDZCDENABLE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audzcdgainsteptime(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ZCD_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDZCDGAINSTEPTIME_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDZCDGAINSTEPTIME_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audzcdgainstepsize(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ZCD_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDZCDGAINSTEPSIZE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDZCDGAINSTEPSIZE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audzcdtimeoutmodesel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ZCD_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDZCDTIMEOUTMODESEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDZCDTIMEOUTMODESEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audzcdclksel_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ZCD_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDZCDCLKSEL_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDZCDCLKSEL_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audzcdmuxsel_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ZCD_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDZCDMUXSEL_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDZCDMUXSEL_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audlolgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ZCD_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDLOLGAIN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDLOLGAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audlorgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ZCD_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDLORGAIN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDLORGAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhplgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ZCD_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLGAIN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLGAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhprgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ZCD_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRGAIN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRGAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhsgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ZCD_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHSGAIN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHSGAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audivlgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ZCD_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIVLGAIN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIVLGAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audivrgain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ZCD_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIVRGAIN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIVRGAIN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_rg_audintgain1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_ZCD_CON5),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_AUDINTGAIN1_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_AUDINTGAIN1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_audintgain2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_ZCD_CON5),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_AUDINTGAIN2_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_AUDINTGAIN2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_isink_dim0_fsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK0_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM0_FSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM0_FSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink0_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK0_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK0_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK0_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink0_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK0_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK0_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK0_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_dim0_duty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK0_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM0_DUTY_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM0_DUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch0_step(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK0_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH0_STEP_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH0_STEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath0_tf2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK0_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH0_TF2_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH0_TF2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath0_tf1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK0_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH0_TF1_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH0_TF1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath0_tr2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK0_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH0_TR2_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH0_TR2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath0_tr1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK0_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH0_TR1_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH0_TR1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath0_toff_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK0_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH0_TOFF_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH0_TOFF_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath0_ton_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK0_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH0_TON_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH0_TON_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_dim1_fsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK1_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM1_FSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM1_FSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink1_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK1_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK1_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK1_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink1_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK1_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK1_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK1_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_dim1_duty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK1_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM1_DUTY_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM1_DUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch1_step(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK1_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH1_STEP_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH1_STEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath1_tf2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK1_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH1_TF2_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH1_TF2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath1_tf1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK1_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH1_TF1_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH1_TF1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath1_tr2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK1_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH1_TR2_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH1_TR2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath1_tr1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK1_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH1_TR1_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH1_TR1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath1_toff_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK1_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH1_TOFF_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH1_TOFF_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath1_ton_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK1_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH1_TON_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH1_TON_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_dim2_fsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK2_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM2_FSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM2_FSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink2_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK2_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK2_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK2_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink2_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK2_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK2_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK2_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_dim2_duty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK2_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM2_DUTY_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM2_DUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch2_step(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK2_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH2_STEP_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH2_STEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath2_tf2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK2_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH2_TF2_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH2_TF2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath2_tf1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK2_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH2_TF1_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH2_TF1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath2_tr2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK2_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH2_TR2_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH2_TR2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath2_tr1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK2_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH2_TR1_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH2_TR1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath2_toff_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK2_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH2_TOFF_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH2_TOFF_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath2_ton_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK2_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH2_TON_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH2_TON_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_dim3_fsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK3_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM3_FSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM3_FSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink3_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK3_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK3_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK3_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink3_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK3_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK3_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK3_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_dim3_duty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK3_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM3_DUTY_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_DIM3_DUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch3_step(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK3_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH3_STEP_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH3_STEP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath3_tf2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK3_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH3_TF2_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH3_TF2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath3_tf1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK3_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH3_TF1_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH3_TF1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath3_tr2_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK3_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH3_TR2_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH3_TR2_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath3_tr1_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK3_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH3_TR1_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH3_TR1_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath3_toff_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK3_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH3_TOFF_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH3_TOFF_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_breath3_ton_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK3_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH3_TON_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_BREATH3_TON_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_isinks_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ISINKS_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ISINKS_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_isink3_double_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ISINK3_DOUBLE_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ISINK3_DOUBLE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_isink2_double_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ISINK2_DOUBLE_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ISINK2_DOUBLE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_isink1_double_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ISINK1_DOUBLE_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ISINK1_DOUBLE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_isink0_double_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ISINK0_DOUBLE_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ISINK0_DOUBLE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_trim_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_TRIM_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_TRIM_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_trim_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_ANA0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_TRIM_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_TRIM_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_ni_isink3_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_ISINK_ANA1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_ISINK3_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_ISINK3_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_isink2_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_ISINK_ANA1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_ISINK2_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_ISINK2_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_isink1_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_ISINK_ANA1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_ISINK1_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_ISINK1_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_isink0_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_ISINK_ANA1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_ISINK0_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_ISINK0_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_isink_phase0_dly_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_PHASE0_DLY_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_PHASE0_DLY_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_phase1_dly_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_PHASE1_DLY_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_PHASE1_DLY_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_phase2_dly_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_PHASE2_DLY_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_PHASE2_DLY_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_phase3_dly_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_PHASE3_DLY_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_PHASE3_DLY_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_phase_dly_tc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_PHASE_DLY_TC_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_PHASE_DLY_TC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_chop0_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP0_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP0_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_chop1_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP1_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP1_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_chop2_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP2_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP2_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_chop3_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_PHASE_DLY),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP3_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP3_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_sfstr3_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_SFSTR),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR3_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR3_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_sfstr3_tc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_SFSTR),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR3_TC_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR3_TC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_sfstr2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_SFSTR),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR2_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_sfstr2_tc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_SFSTR),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR2_TC_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR2_TC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_sfstr1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_SFSTR),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR1_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_sfstr1_tc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_SFSTR),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR1_TC_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR1_TC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_sfstr0_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_SFSTR),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR0_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR0_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_sfstr0_tc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_SFSTR),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR0_TC_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_SFSTR0_TC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch0_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH0_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH0_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH1_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH2_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch3_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH3_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH3_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_chop0_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP0_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP0_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_chop1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP1_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_chop2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP2_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_chop3_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP3_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CHOP3_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch0_bias_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH0_BIAS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH0_BIAS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch1_bias_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH1_BIAS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH1_BIAS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch2_bias_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH2_BIAS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH2_BIAS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch3_bias_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_EN_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH3_BIAS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH3_BIAS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_MODE_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch3_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_MODE_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH3_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH3_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch2_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_MODE_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH2_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH2_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch1_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_MODE_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH1_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH1_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_isink_ch0_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_ISINK_MODE_CTRL),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH0_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_ISINK_CH0_MODE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_rg_isinks_ch0_step(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_ISINK_ANA_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_ISINKS_CH0_STEP_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_ISINKS_CH0_STEP_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_isinks_ch1_step(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_ISINK_ANA_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_ISINKS_CH1_STEP_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_ISINKS_CH1_STEP_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_isinks_ch2_step(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_ISINK_ANA_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_ISINKS_CH2_STEP_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_ISINKS_CH2_STEP_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_isinks_ch3_step(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_ISINK_ANA_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_ISINKS_CH3_STEP_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_ISINKS_CH3_STEP_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vtcxo0_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo0_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo0_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo0_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo0_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vtcxo0_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO0_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO0_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vtcxo0_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo0_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vtcxo0_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO0_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO0_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vtcxo0_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO0_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO0_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vtcxo1_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo1_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo1_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo1_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vtcxo1_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO1_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO1_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vtcxo1_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo1_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vtcxo1_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO1_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO1_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vtcxo1_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO1_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO1_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vaud28_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vaud28_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vaud28_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vaud28_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vaud28_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vaud28_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VAUD28_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VAUD28_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vaud28_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vaud28_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vaud28_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VAUD28_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VAUD28_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vaud28_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VAUD28_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VAUD28_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vauxa28_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vauxa28_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vauxa28_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vauxa28_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vauxa28_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vauxa28_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VAUXA28_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VAUXA28_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vauxa28_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vauxa28_auxadc_pwdb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_AUXADC_PWDB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_AUXADC_PWDB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vauxa28_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vauxa28_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VAUXA28_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VAUXA28_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vauxa28_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VAUXA28_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VAUXA28_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vbif28_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbif28_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbif28_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbif28_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbif28_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vbif28_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON4),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VBIF28_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VBIF28_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vbif28_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbif28_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vbif28_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON4),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VBIF28_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VBIF28_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vbif28_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON4),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VBIF28_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VBIF28_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vcama_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMA_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMA_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcama_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMA_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMA_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcama_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON5),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMA_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMA_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcama_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON5),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMA_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMA_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vcn28_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn28_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn28_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn28_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn28_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcn28_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON6),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCN28_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCN28_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vcn28_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn28_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcn28_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON6),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCN28_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCN28_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcn28_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON6),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCN28_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCN28_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vcn33_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn33_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn33_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn33_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn33_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcn33_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON7),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCN33_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCN33_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vcn33_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn33_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcn33_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON7),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCN33_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCN33_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcn33_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON7),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCN33_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCN33_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vrf18_1_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_1_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_1_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_1_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vrf18_1_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON8),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_1_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_1_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vrf18_1_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_1_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vrf18_1_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON8),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_1_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_1_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vrf18_1_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON8),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_1_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_1_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vusb33_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vusb33_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vusb33_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vusb33_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vusb33_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vusb33_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VUSB33_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VUSB33_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vusb33_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vusb33_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vusb33_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VUSB33_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VUSB33_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vusb33_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VUSB33_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VUSB33_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vmch_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmch_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmch_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmch_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmch_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vmch_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON10),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VMCH_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VMCH_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vmch_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmch_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vmch_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON10),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VMCH_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VMCH_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vmch_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON10),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VMCH_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VMCH_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vmc_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmc_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmc_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmc_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vmc_int_dis(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON11),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VMC_INT_DIS_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VMC_INT_DIS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vmc_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON11),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VMC_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VMC_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vmc_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmc_int_dis_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_INT_DIS_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_INT_DIS_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmc_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vmc_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON11),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VMC_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VMC_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vmc_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON11),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VMC_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VMC_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vemc33_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vemc33_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vemc33_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vemc33_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vemc33_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vemc_3v3_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON12),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VEMC_3V3_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VEMC_3V3_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vemc33_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vemc33_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vemc_3v3_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON12),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VEMC_3V3_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VEMC_3V3_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vemc_3v3_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON12),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VEMC_3V3_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VEMC_3V3_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vio28_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio28_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio28_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio28_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio28_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vio28_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON13),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VIO28_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VIO28_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vio28_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio28_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vio28_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON13),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VIO28_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VIO28_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vio28_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON13),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VIO28_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VIO28_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vcam_af_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcam_af_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcam_af_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcam_af_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcam_af_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcamaf_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMAF_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMAF_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vcam_af_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcam_af_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcamaf_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMAF_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMAF_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcamaf_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMAF_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMAF_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vgp1_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp1_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp1_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp1_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vgp1_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON15),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGP1_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGP1_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vgp1_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp1_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vgp1_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON15),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGP1_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGP1_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vgp1_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON15),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGP1_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGP1_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vefuse_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vefuse_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vefuse_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vefuse_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vefuse_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vefuse_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON16),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VEFUSE_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VEFUSE_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vefuse_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vefuse_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vefuse_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON16),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VEFUSE_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VEFUSE_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vefuse_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON16),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VEFUSE_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VEFUSE_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vsim1_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim1_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim1_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim1_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vsim1_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON17),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM1_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM1_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vsim1_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim1_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vsim1_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON17),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM1_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM1_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vsim1_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON17),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM1_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM1_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vsim2_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim2_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim2_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim2_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vsim2_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM2_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM2_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vsim2_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim2_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vsim2_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM2_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM2_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vsim2_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM2_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM2_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vmipi_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmipi_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmipi_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmipi_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmipi_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vmipi_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON19),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VMIPI_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VMIPI_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vmipi_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmipi_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON19),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vmipi_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON19),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VMIPI_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VMIPI_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vmipi_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON19),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VMIPI_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VMIPI_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vibr_ther_shen_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_THER_SHEN_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_THER_SHEN_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vibr_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vibr_sw_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_SW_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_SW_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vibr_fr_ori(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_FR_ORI_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_FR_ORI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vibr_mst_time(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_MST_TIME_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_MST_TIME_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vibr_mid_state(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON20),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_MID_STATE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_MID_STATE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vibr_fr(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VIBR_FR_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VIBR_FR_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_vibr_pwdb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_VIBR_PWDB_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_VIBR_PWDB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vcn18_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn18_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn18_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn18_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn18_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcn18_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON21),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCN18_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCN18_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vcn18_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn18_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcn18_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON21),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCN18_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCN18_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcn18_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON21),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCN18_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCN18_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_vdig18_vosel(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON22),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_VDIG18_VOSEL_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_VDIG18_VOSEL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vdig18_srclken_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDIG18_SRCLKEN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDIG18_SRCLKEN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdig18_sleep_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDIG18_SLEEP_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDIG18_SLEEP_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdig18_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDIG18_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDIG18_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vdig18_vosel_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VDIG18_VOSEL_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VDIG18_VOSEL_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp2_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp2_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp2_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp2_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp2_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vgp2_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON23),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGP2_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGP2_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vgp2_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp2_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vgp2_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON23),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGP2_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGP2_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vgp2_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON23),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGP2_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGP2_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vcamd_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamd_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamd_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamd_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamd_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcamd_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON24),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMD_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMD_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vcamd_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamd_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcamd_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON24),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMD_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMD_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcamd_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON24),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMD_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMD_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vcam_io_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcam_io_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcam_io_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcam_io_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcam_io_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcamio_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON25),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMIO_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMIO_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vcam_io_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcam_io_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vcamio_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON25),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMIO_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMIO_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcamio_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON25),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMIO_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMIO_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vsram_dvfs1_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsram_dvfs1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsram_dvfs1_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsram_dvfs1_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsram_dvfs1_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vsram_dvfs1_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON26),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VSRAM_DVFS1_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VSRAM_DVFS1_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vsram_dvfs1_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsram_dvfs1_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vsram_dvfs1_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON26),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VSRAM_DVFS1_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VSRAM_DVFS1_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vsram_dvfs1_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON26),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VSRAM_DVFS1_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VSRAM_DVFS1_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vgp3_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp3_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp3_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp3_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp3_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vgp3_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON27),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGP3_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGP3_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vgp3_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp3_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vgp3_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON27),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGP3_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGP3_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vgp3_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON27),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGP3_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGP3_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vbiasn_mode_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_MODE_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_MODE_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbiasn_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbiasn_mode_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_MODE_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_MODE_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbiasn_on_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_ON_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_ON_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbiasn_srclk_mode_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_SRCLK_MODE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_SRCLK_MODE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vbiasn_mode(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON28),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VBIASN_MODE_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VBIASN_MODE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vbiasn_stbtd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_STBTD_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_STBTD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbiasn_srclk_en_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON28),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_SRCLK_EN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_SRCLK_EN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vbiasn_stb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON28),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VBIASN_STB_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VBIASN_STB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vbiasn_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON28),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VBIASN_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VBIASN_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vrtc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON29),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRTC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRTC_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vrtc_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON29),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VRTC_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VRTC_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vbiasn_dis_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_DIS_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_DIS_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbiasn_trans_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_TRANS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_TRANS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbiasn_trans_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_TRANS_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_TRANS_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbiasn_trans_once(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_TRANS_ONCE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_TRANS_ONCE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vbiasn_chr(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_CON30),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VBIASN_CHR_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VBIASN_CHR_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_vtcxo1_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo1_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo0_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo0_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbif28_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbif28_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vaud28_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vaud28_sense_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_SENSE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_SENSE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vaud28_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcama_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMA_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMA_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcama_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMA_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMA_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcama_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMA_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMA_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vauxa28_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vauxa28_sense_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_SENSE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_SENSE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vauxa28_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn33_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn33_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn33_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn28_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn28_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vusb33_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vusb33_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_1_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_1_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_1_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmc_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmc_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmc_stb_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_STB_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_STB_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmc_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmch_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmch_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmch_db_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_DB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_DB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmch_stb_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_STB_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_STB_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmch_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vemc_3v3_stb_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC_3V3_STB_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC_3V3_STB_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vemc_3v3_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC_3V3_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC_3V3_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vemc_3v3_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC_3V3_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC_3V3_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vemc_3v3_dl_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC_3V3_DL_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC_3V3_DL_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vemc_3v3_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC_3V3_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC_3V3_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamaf_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMAF_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMAF_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamaf_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMAF_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMAF_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamaf_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMAF_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMAF_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio28_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio28_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp2_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp2_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp2_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp1_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp1_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp1_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim2_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim2_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim2_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim1_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim1_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim1_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vibr_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vibr_vocal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_VOCAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIBR_VOCAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmipi_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmipi_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmipi_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vefuse_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vefuse_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vefuse_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn18_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn18_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn18_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamd_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamd_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamd_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamio_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMIO_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMIO_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamio_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMIO_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMIO_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamio_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMIO_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMIO_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsram_dvfs1_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsram_dvfs1_ndis_plcur(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_NDIS_PLCUR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_NDIS_PLCUR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsram_dvfs1_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbiasn_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbiasn_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp3_ndis_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_NDIS_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_NDIS_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp3_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp3_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbiasn_vosel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_VCON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_VOSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_VOSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_dldo_1_rsv_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_RSV0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DLDO_1_RSV_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DLDO_1_RSV_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_ldo_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_RSV0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_LDO_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_LDO_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_dldo_1_rsv_h(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_RSV0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DLDO_1_RSV_H_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DLDO_1_RSV_H_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_dldo_2_rsv_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_RSV1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DLDO_2_RSV_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DLDO_2_RSV_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_ldo_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_RSV1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_LDO_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_LDO_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_dldo_2_rsv_h(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_RSV1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DLDO_2_RSV_H_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DLDO_2_RSV_H_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_ldo_rsv3(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_RSV2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_LDO_RSV3_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_LDO_RSV3_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_sysldo_rsvl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_RSV2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SYSLDO_RSVL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SYSLDO_RSVL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_sysldo_rsv_h(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_RSV2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SYSLDO_RSV_H_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SYSLDO_RSV_H_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_adldo_rsv_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_RSV3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ADLDO_RSV_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ADLDO_RSV_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_ldo_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_RSV3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_LDO_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_LDO_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_adldo_rsv_h(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_RSV3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ADLDO_RSV_H_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ADLDO_RSV_H_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmc_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMC_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vio28_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VIO28_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vemc33_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEMC33_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmch_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMCH_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vusb33_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VUSB33_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vrf18_1_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VRF18_1_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn33_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN33_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn28_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN28_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcama_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMA_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMA_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vauxa28_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUXA28_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbif28_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vaud28_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VAUD28_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo1_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO1_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vtcxo0_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VTCXO0_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_ldo_degtd_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_LDO_DEGTD_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_LDO_DEGTD_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbiasn_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIASN_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp3_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP3_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsram_dvfs1_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSRAM_DVFS1_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcam_io_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_IO_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcamd_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAMD_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp2_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP2_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcn18_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCN18_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vmipi_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VMIPI_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim2_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM2_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vsim1_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VSIM1_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vefuse_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VEFUSE_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vgp1_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VGP1_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vcam_af_ocfb_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_LDO_OCFB1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_OCFB_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VCAM_AF_OCFB_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_vmc_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VMC_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VMC_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vio28_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VIO28_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VIO28_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vemc_3v3_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VEMC_3V3_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VEMC_3V3_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vmch_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VMCH_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VMCH_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vusb33_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VUSB33_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VUSB33_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vrf18_1_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_1_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VRF18_1_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcn33_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCN33_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCN33_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcn28_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCN28_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCN28_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcama_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMA_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMA_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vauxa28_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VAUXA28_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VAUXA28_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vbif28_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VBIF28_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VBIF28_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vaud28_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VAUD28_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VAUD28_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vtcxo1_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO1_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO1_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vtcxo0_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO0_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VTCXO0_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vbiasn_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VBIASN_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VBIASN_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vgp3_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGP3_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGP3_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vsram_dvfs1_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VSRAM_DVFS1_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VSRAM_DVFS1_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcamio_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMIO_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMIO_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcamd_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMD_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMD_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vgp2_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGP2_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGP2_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcn18_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCN18_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCN18_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vmipi_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VMIPI_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VMIPI_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vsim2_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM2_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM2_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vsim1_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM1_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VSIM1_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vefuse_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VEFUSE_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VEFUSE_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vgp1_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VGP1_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VGP1_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_vcamaf_ocfb_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_OCFB3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMAF_OCFB_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_VCAMAF_OCFB_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_vcamio_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_ANA_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_VCAMIO_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_VCAMIO_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_vcamaf_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_LDO_ANA_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_VCAMAF_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_VCAMAF_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_bif_command_0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_0_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_1_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_2_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_3(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_3_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_3_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_4(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_4_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_4_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_5(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_5_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_5_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_6(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_6_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_6_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_7(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_7_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_7_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_8(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_8_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_8_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_9(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_9_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_9_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_10(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_10_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_10_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_11(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_11_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_11_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_12(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_12_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_12_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_13(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_13_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_13_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_14(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_14_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_14_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_command_type(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_TYPE_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_COMMAND_TYPE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_trasfer_num(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TRASFER_NUM_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TRASFER_NUM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_logic_0_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_LOGIC_0_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_LOGIC_0_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_logic_1_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_LOGIC_1_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_LOGIC_1_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_stop_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_STOP_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_STOP_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_debounce_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_DEBOUNCE_WND_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_DEBOUNCE_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_debounce_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_DEBOUNCE_THD_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_DEBOUNCE_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_debounce_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_DEBOUNCE_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_DEBOUNCE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_read_expect_num(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON17),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_READ_EXPECT_NUM_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_READ_EXPECT_NUM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_trasact_trigger(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON18),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TRASACT_TRIGGER_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TRASACT_TRIGGER_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_bif_data_num(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON19),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_NUM_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_NUM_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_response(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON19),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_RESPONSE_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_RESPONSE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_data_0(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_0_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_0_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_ack_0(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_0_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_0_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_error_0(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_0_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_0_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_data_1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON21),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_1_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_ack_1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON21),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_1_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_error_1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON21),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_1_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_data_2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON22),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_2_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_ack_2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON22),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_2_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_error_2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON22),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_2_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_data_3(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON23),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_3_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_3_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_ack_3(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON23),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_3_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_3_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_error_3(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON23),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_3_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_3_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_data_4(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON24),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_4_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_4_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_ack_4(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON24),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_4_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_4_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_error_4(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON24),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_4_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_4_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_data_5(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON25),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_5_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_5_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_ack_5(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON25),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_5_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_5_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_error_5(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON25),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_5_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_5_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_data_6(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON26),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_6_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_6_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_ack_6(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON26),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_6_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_6_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_error_6(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON26),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_6_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_6_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_data_7(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON27),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_7_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_7_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_ack_7(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON27),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_7_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_7_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_error_7(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON27),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_7_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_7_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_data_8(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON28),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_8_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_8_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_ack_8(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON28),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_8_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_8_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_error_8(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON28),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_8_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_8_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_data_9(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON29),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_9_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_DATA_9_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_ack_9(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON29),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_9_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ACK_9_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_error_9(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON29),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_9_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_ERROR_9_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_bif_test_mode0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE0_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_test_mode1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE1_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_test_mode2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE2_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_test_mode3(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE3_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE3_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_test_mode4(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE4_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE4_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_test_mode5(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE5_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE5_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_test_mode6(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE6_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE6_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_test_mode7(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE7_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE7_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_test_mode8(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE8_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TEST_MODE8_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_bat_lost_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_BAT_LOST_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_BAT_LOST_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_rx_data_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_RX_DATA_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_RX_DATA_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_tx_data_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TX_DATA_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TX_DATA_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_rx_en_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_RX_EN_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_RX_EN_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_tx_en_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON30),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TX_EN_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TX_EN_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_back_normal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON31),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_BACK_NORMAL_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_BACK_NORMAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_irq_clr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON31),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_IRQ_CLR_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_IRQ_CLR_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_bif_bat_lost_gated(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON31),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_BAT_LOST_GATED_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_BAT_LOST_GATED_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_irq(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON31),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_IRQ_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_IRQ_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_timeout(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON31),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_TIMEOUT_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_TIMEOUT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_bat_lost(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON31),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_BAT_LOST_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_BAT_LOST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_total_valid(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON31),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_TOTAL_VALID_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_TOTAL_VALID_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_bus_status(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON31),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_BUS_STATUS_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_BUS_STATUS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_bif_power_up_count(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON32),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_POWER_UP_COUNT_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_POWER_UP_COUNT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_power_up(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON32),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_POWER_UP_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_POWER_UP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_bif_rx_error_unknow(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON33),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_RX_ERROR_UNKNOW_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_RX_ERROR_UNKNOW_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_rx_error_insuff(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON33),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_RX_ERROR_INSUFF_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_RX_ERROR_INSUFF_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_rx_error_lowphase(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON33),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_RX_ERROR_LOWPHASE_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_RX_ERROR_LOWPHASE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_rx_state(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON33),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_RX_STATE_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_RX_STATE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_flow_ctl_state(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON33),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_FLOW_CTL_STATE_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_FLOW_CTL_STATE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_tx_state(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON33),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_TX_STATE_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_TX_STATE_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_bif_rx_data(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON33),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_BIF_RX_DATA_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_BIF_RX_DATA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_bif_rx_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON33),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_BIF_RX_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_BIF_RX_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_bif_tx_data(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON33),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_BIF_TX_DATA_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_BIF_TX_DATA_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_qi_bif_tx_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON33),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_BIF_TX_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_BIF_TX_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_tx_data_fianl(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON34),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_TX_DATA_FIANL_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_TX_DATA_FIANL_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_rx_data_sampling(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON35),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_RX_DATA_SAMPLING_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_RX_DATA_SAMPLING_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_bif_rx_data_recovery(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON36),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_RX_DATA_RECOVERY_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_RX_DATA_RECOVERY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_baton_ht_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BATON_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BATON_HT_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BATON_HT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_baton_tdet_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BATON_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BATON_TDET_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BATON_TDET_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_vbif28_auxadc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BATON_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_AUXADC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VBIF28_AUXADC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_baton_ht_en_dly_time(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BATON_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BATON_HT_EN_DLY_TIME_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BATON_HT_EN_DLY_TIME_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_qi_baton_ht_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BATON_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_QI_BATON_HT_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_QI_BATON_HT_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rgs_baton_hv(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BATON_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RGS_BATON_HV_MASK),
                           (kal_uint32)(MT6325_PMIC_RGS_BATON_HV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_baton_ht_trim_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BATON_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BATON_HT_TRIM_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BATON_HT_TRIM_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hw_vth_ctrl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BATON_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HW_VTH_CTRL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HW_VTH_CTRL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hw_vth2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BATON_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HW_VTH2_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HW_VTH2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hw_vth1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BATON_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HW_VTH1_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HW_VTH1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_timeout_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON37),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_TIMEOUT_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_TIMEOUT_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_rx_deg_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON38),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_RX_DEG_WND_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_RX_DEG_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_bif_rx_deg_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON38),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_RX_DEG_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_RX_DEG_EN_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_bif_rsv1(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_BIF_CON39),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_BIF_RSV1_MASK),
                           (kal_uint32)(MT6325_PMIC_BIF_RSV1_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_bif_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_BIF_CON39),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_BIF_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_BIF_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_en_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_EN_L_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_EN_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spkmode_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPKMODE_L_MASK),
                             (kal_uint32)(MT6325_PMIC_SPKMODE_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_trim_en_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_EN_L_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_EN_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_oc_shdn_dl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_OC_SHDN_DL_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_OC_SHDN_DL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_ther_shdn_l_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_THER_SHDN_L_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_THER_SHDN_L_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_out_stage_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_OUT_STAGE_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_OUT_STAGE_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_gainl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_GAINL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_GAINL_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_da_spk_offset_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_DA_SPK_OFFSET_L_MASK),
                           (kal_uint32)(MT6325_PMIC_DA_SPK_OFFSET_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_da_spk_lead_dglh_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_DA_SPK_LEAD_DGLH_L_MASK),
                           (kal_uint32)(MT6325_PMIC_DA_SPK_LEAD_DGLH_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_spk_lead_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_SPK_LEAD_L_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_SPK_LEAD_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_spk_offset_l_ov(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_SPK_OFFSET_L_OV_MASK),
                           (kal_uint32)(MT6325_PMIC_SPK_OFFSET_L_OV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_spk_offset_l_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_OFFSET_L_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_OFFSET_L_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_lead_l_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_LEAD_L_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_LEAD_L_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_offset_l_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_OFFSET_L_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_OFFSET_L_MODE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_spk_trim_done_l(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_SPK_TRIM_DONE_L_MASK),
                           (kal_uint32)(MT6325_PMIC_SPK_TRIM_DONE_L_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_spk_intg_rst_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_INTG_RST_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_INTG_RST_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_force_en_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_FORCE_EN_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_FORCE_EN_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_slew_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_SLEW_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_SLEW_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spkab_obias_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPKAB_OBIAS_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPKAB_OBIAS_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spkrcv_en_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPKRCV_EN_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPKRCV_EN_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_drc_en_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_DRC_EN_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_DRC_EN_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_test_en_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_TEST_EN_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_TEST_EN_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spkab_oc_en_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPKAB_OC_EN_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPKAB_OC_EN_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_oc_en_l(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_OC_EN_L_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_OC_EN_L_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_en_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_EN_R_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_EN_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spkmode_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPKMODE_R_MASK),
                             (kal_uint32)(MT6325_PMIC_SPKMODE_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_trim_en_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_EN_R_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_EN_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_oc_shdn_dr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_OC_SHDN_DR_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_OC_SHDN_DR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_ther_shdn_r_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_THER_SHDN_R_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_THER_SHDN_R_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_gainr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_GAINR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_GAINR_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_da_spk_offset_r(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON4),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_DA_SPK_OFFSET_R_MASK),
                           (kal_uint32)(MT6325_PMIC_DA_SPK_OFFSET_R_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_da_spk_lead_dglh_r(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON4),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_DA_SPK_LEAD_DGLH_R_MASK),
                           (kal_uint32)(MT6325_PMIC_DA_SPK_LEAD_DGLH_R_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_ni_spk_lead_r(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON4),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_NI_SPK_LEAD_R_MASK),
                           (kal_uint32)(MT6325_PMIC_NI_SPK_LEAD_R_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_spk_offset_r_ov(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON4),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_SPK_OFFSET_R_OV_MASK),
                           (kal_uint32)(MT6325_PMIC_SPK_OFFSET_R_OV_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_spk_offset_r_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_OFFSET_R_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_OFFSET_R_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_lead_r_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_LEAD_R_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_LEAD_R_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_offset_r_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_OFFSET_R_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_OFFSET_R_MODE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_spk_trim_done_r(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON4),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_SPK_TRIM_DONE_R_MASK),
                           (kal_uint32)(MT6325_PMIC_SPK_TRIM_DONE_R_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_spk_intg_rst_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_INTG_RST_R_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_INTG_RST_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_force_en_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_FORCE_EN_R_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_FORCE_EN_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_slew_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_SLEW_R_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_SLEW_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spkab_obias_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPKAB_OBIAS_R_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPKAB_OBIAS_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spkrcv_en_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPKRCV_EN_R_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPKRCV_EN_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_drc_en_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_DRC_EN_R_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_DRC_EN_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_test_en_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_TEST_EN_R_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_TEST_EN_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spkab_oc_en_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPKAB_OC_EN_R_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPKAB_OC_EN_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_oc_en_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_OC_EN_R_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_OC_EN_R_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spkpga_gainr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPKPGA_GAINR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPKPGA_GAINR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_trim_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_WND_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_trim_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_THD_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_THD_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_oc_wnd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_OC_WND_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_OC_WND_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_oc_thd(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_OC_THD_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_OC_THD_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_spk_d_oc_r_deg(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON6),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_SPK_D_OC_R_DEG_MASK),
                           (kal_uint32)(MT6325_PMIC_SPK_D_OC_R_DEG_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_spk_ab_oc_r_deg(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON6),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_SPK_AB_OC_R_DEG_MASK),
                           (kal_uint32)(MT6325_PMIC_SPK_AB_OC_R_DEG_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_spk_d_oc_l_deg(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON6),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_SPK_D_OC_L_DEG_MASK),
                           (kal_uint32)(MT6325_PMIC_SPK_D_OC_L_DEG_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_spk_ab_oc_l_deg(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_SPK_CON6),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_SPK_AB_OC_L_DEG_MASK),
                           (kal_uint32)(MT6325_PMIC_SPK_AB_OC_L_DEG_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_spk_td1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TD1_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TD1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_td2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TD2_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TD2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_td3(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TD3_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TD3_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_trim_div(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_DIV_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_DIV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_btl_set(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BTL_SET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BTL_SET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_ibias_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_IBIAS_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_IBIAS_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_ccode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_CCODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_CCODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_en_view_vcm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_EN_VIEW_VCM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_EN_VIEW_VCM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_en_view_clk(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_EN_VIEW_CLK_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_EN_VIEW_CLK_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_vcm_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_VCM_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_VCM_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_vcm_ibsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_VCM_IBSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_VCM_IBSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_fbrc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_FBRC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_FBRC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spkab_ovdrv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPKAB_OVDRV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPKAB_OVDRV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_octh_d(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_OCTH_D_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_OCTH_D_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spkpga_gainl(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPKPGA_GAINL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPKPGA_GAINL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_vcm_fast_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_VCM_FAST_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_VCM_FAST_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_test_mode0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TEST_MODE0_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TEST_MODE0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_test_mode1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TEST_MODE1_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TEST_MODE1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_td_wait(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TD_WAIT_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TD_WAIT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_td_done(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TD_DONE_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TD_DONE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_en_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_EN_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_EN_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_vcm_fast_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_VCM_FAST_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_VCM_FAST_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_rst_r_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_RST_R_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_RST_R_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_rst_l_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_RST_L_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_RST_L_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spkmode_r_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPKMODE_R_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPKMODE_R_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spkmode_l_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPKMODE_L_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPKMODE_L_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_depop_en_r_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_DEPOP_EN_R_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_DEPOP_EN_R_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_depop_en_l_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_DEPOP_EN_L_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_DEPOP_EN_L_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_en_r_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_EN_R_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_EN_R_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_en_l_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_EN_L_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_EN_L_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_outstg_en_r_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_OUTSTG_EN_R_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_OUTSTG_EN_R_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_outstg_en_l_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_OUTSTG_EN_L_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_OUTSTG_EN_L_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_trim_en_r_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_EN_R_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_EN_R_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_trim_en_l_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_EN_L_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_EN_L_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_trim_stop_r_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_STOP_R_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_STOP_R_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_spk_trim_stop_l_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_STOP_L_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_SPK_TRIM_STOP_L_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_isense_test_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ISENSE_TEST_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ISENSE_TEST_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_isense_refsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ISENSE_REFSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ISENSE_REFSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_isense_gainsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ISENSE_GAINSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ISENSE_GAINSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_isense_pdreset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ISENSE_PDRESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ISENSE_PDRESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_isense_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ISENSE_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ISENSE_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_rsv0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_RSV0_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_RSV0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_abd_volsen_gain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ABD_VOLSEN_GAIN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ABD_VOLSEN_GAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_abd_volsen_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ABD_VOLSEN_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ABD_VOLSEN_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_abd_cursen_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ABD_CURSEN_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_ABD_CURSEN_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_rsv2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_RSV2_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_RSV2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_trim2(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_TRIM2_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_TRIM2_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_trim1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_TRIM1_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_TRIM1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_d_cursen_rsetsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_D_CURSEN_RSETSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_D_CURSEN_RSETSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_d_cursen_gain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_D_CURSEN_GAIN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_D_CURSEN_GAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_d_cursen_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_D_CURSEN_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_D_CURSEN_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_ab_cursen_rsetsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_AB_CURSEN_RSETSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_AB_CURSEN_RSETSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_ab_cursen_gain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_AB_CURSEN_GAIN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_AB_CURSEN_GAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_ab_cursen_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_AB_CURSEN_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_AB_CURSEN_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spkpga_gain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPKPGA_GAIN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPKPGA_GAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spk_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPK_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_isense_pd_reset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ISENSE_PD_RESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ISENSE_PD_RESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audivlpwrup_vaudp12(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIVLPWRUP_VAUDP12_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIVLPWRUP_VAUDP12_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audivlstartup_vaudp12(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIVLSTARTUP_VAUDP12_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIVLSTARTUP_VAUDP12_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audivlmuxsel_vaudp12(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIVLMUXSEL_VAUDP12_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIVLMUXSEL_VAUDP12_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audivlmute_vaudp12(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_SPK_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIVLMUTE_VAUDP12_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIVLMUTE_VAUDP12_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_pa(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PA_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PA_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_pdin(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PDIN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PDIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_ptm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PTM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PTM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_pwe(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PWE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PWE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_pprog(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PPROG_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PPROG_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_pwe_src(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PWE_SRC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PWE_SRC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_prog_pkey(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PROG_PKEY_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_PROG_PKEY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_rd_pkey(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_RD_PKEY_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_RD_PKEY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_rd_trig(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_RD_TRIG_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_RD_TRIG_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rd_rdy_bypass(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RD_RDY_BYPASS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RD_RDY_BYPASS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_skip_otp_out(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SKIP_OTP_OUT_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SKIP_OTP_OUT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_rd_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_RD_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_RD_SW_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_sw(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_CON12),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_SW_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_SW_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_rd_busy(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_CON13),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_RD_BUSY_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_RD_BUSY_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_rd_ack(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_CON13),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_RD_ACK_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_RD_ACK_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_pa_sw(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_CON14),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_PA_SW_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_PA_SW_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_0_15(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_0_15),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_0_15_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_0_15_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_16_31(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_16_31),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_16_31_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_16_31_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_32_47(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_32_47),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_32_47_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_32_47_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_48_63(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_48_63),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_48_63_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_48_63_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_64_79(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_64_79),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_64_79_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_64_79_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_80_95(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_80_95),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_80_95_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_80_95_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_96_111(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_96_111),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_96_111_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_96_111_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_112_127(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_112_127),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_112_127_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_112_127_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_128_143(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_128_143),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_128_143_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_128_143_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_144_159(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_144_159),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_144_159_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_144_159_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_160_175(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_160_175),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_160_175_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_160_175_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_176_191(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_176_191),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_176_191_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_176_191_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_192_207(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_192_207),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_192_207_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_192_207_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_208_223(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_208_223),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_208_223_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_208_223_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_224_239(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_224_239),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_224_239_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_224_239_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_240_255(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_240_255),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_240_255_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_240_255_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_256_271(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_256_271),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_256_271_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_256_271_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_272_287(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_272_287),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_272_287_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_272_287_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_288_303(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_288_303),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_288_303_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_288_303_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_304_319(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_304_319),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_304_319_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_304_319_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_320_335(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_320_335),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_320_335_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_320_335_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_336_351(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_336_351),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_336_351_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_336_351_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_352_367(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_352_367),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_352_367_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_352_367_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_368_383(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_368_383),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_368_383_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_368_383_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_384_399(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_384_399),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_384_399_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_384_399_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_400_415(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_400_415),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_400_415_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_400_415_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_416_431(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_416_431),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_416_431_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_416_431_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_432_447(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_432_447),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_432_447_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_432_447_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_448_463(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_448_463),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_448_463_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_448_463_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_464_479(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_464_479),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_464_479_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_464_479_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_480_495(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_480_495),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_480_495_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_480_495_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_rg_otp_dout_496_511(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_OTP_DOUT_496_511),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_496_511_MASK),
                           (kal_uint32)(MT6325_PMIC_RG_OTP_DOUT_496_511_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_otp_val_0_15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_0_15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_0_15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_0_15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_16_31(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_16_31),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_16_31_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_16_31_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_32_47(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_32_47),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_32_47_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_32_47_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_48_63(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_48_63),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_48_63_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_48_63_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_64_79(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_64_79),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_64_79_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_64_79_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_80_95(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_80_95),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_80_95_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_80_95_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_96_111(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_96_111),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_96_111_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_96_111_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_112_127(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_112_127),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_112_127_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_112_127_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_128_143(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_128_143),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_128_143_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_128_143_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_144_159(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_144_159),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_144_159_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_144_159_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_160_175(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_160_175),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_160_175_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_160_175_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_176_191(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_176_191),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_176_191_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_176_191_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_192_207(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_192_207),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_192_207_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_192_207_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_208_223(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_208_223),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_208_223_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_208_223_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_224_239(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_224_239),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_224_239_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_224_239_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_240_255(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_240_255),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_240_255_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_240_255_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_256_271(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_256_271),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_256_271_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_256_271_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_272_287(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_272_287),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_272_287_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_272_287_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_288_303(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_288_303),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_288_303_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_288_303_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_304_319(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_304_319),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_304_319_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_304_319_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_320_335(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_320_335),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_320_335_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_320_335_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_336_351(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_336_351),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_336_351_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_336_351_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_352_367(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_352_367),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_352_367_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_352_367_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_368_383(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_368_383),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_368_383_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_368_383_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_384_399(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_384_399),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_384_399_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_384_399_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_400_415(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_400_415),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_400_415_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_400_415_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_416_431(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_416_431),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_416_431_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_416_431_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_432_447(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_432_447),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_432_447_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_432_447_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_448_463(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_448_463),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_448_463_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_448_463_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_464_479(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_464_479),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_464_479_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_464_479_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_480_495(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_480_495),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_480_495_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_480_495_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_otp_val_496_511(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_OTP_VAL_496_511),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_496_511_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_OTP_VAL_496_511_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_mix_eosc32_stp_lpdtb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RTC_MIX_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_MIX_EOSC32_STP_LPDTB_MASK),
                           (kal_uint32)(MT6325_PMIC_MIX_EOSC32_STP_LPDTB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_mix_eosc32_stp_lpden(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_EOSC32_STP_LPDEN_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_EOSC32_STP_LPDEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_xosc32_stp_pwdb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_XOSC32_STP_PWDB_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_XOSC32_STP_PWDB_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_mix_xosc32_stp_lpdtb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RTC_MIX_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_MIX_XOSC32_STP_LPDTB_MASK),
                           (kal_uint32)(MT6325_PMIC_MIX_XOSC32_STP_LPDTB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_mix_xosc32_stp_lpden(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_XOSC32_STP_LPDEN_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_XOSC32_STP_LPDEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_xosc32_stp_lpdrst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_XOSC32_STP_LPDRST_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_XOSC32_STP_LPDRST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_xosc32_stp_cali(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_XOSC32_STP_CALI_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_XOSC32_STP_CALI_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_stmp_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_STMP_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_STMP_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_eosc32_stp_chop_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_EOSC32_STP_CHOP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_EOSC32_STP_CHOP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_dcxo_stp_lvsh_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_DCXO_STP_LVSH_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_DCXO_STP_LVSH_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_pmu_stp_ddlo_vrtc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_PMU_STP_DDLO_VRTC_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_PMU_STP_DDLO_VRTC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_pmu_stp_ddlo_vrtc_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_PMU_STP_DDLO_VRTC_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_PMU_STP_DDLO_VRTC_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_rtc_stp_xosc32_enb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_RTC_STP_XOSC32_ENB_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_RTC_STP_XOSC32_ENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_dcxo_stp_test_deglitch_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_eosc32_stp_rsv(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_EOSC32_STP_RSV_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_EOSC32_STP_RSV_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_eosc32_vct_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_EOSC32_VCT_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_EOSC32_VCT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_eosc32_opt(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_EOSC32_OPT_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_EOSC32_OPT_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_mix_rtc_stp_debug_out(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RTC_MIX_CON2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_MIX_RTC_STP_DEBUG_OUT_MASK),
                           (kal_uint32)(MT6325_PMIC_MIX_RTC_STP_DEBUG_OUT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_mix_rtc_stp_debug_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_RTC_STP_DEBUG_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_RTC_STP_DEBUG_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_rtc_stp_k_eosc32_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_RTC_STP_K_EOSC32_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_RTC_STP_K_EOSC32_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_rtc_stp_embck_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_RTC_STP_EMBCK_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_RTC_STP_EMBCK_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_mix_stp_bbwakeup(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_STP_BBWAKEUP_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_STP_BBWAKEUP_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_mix_stp_rtc_ddlo(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RTC_MIX_CON2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_MIX_STP_RTC_DDLO_MASK),
                           (kal_uint32)(MT6325_PMIC_MIX_STP_RTC_DDLO_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_mix_rtc_xosc32_enb(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_RTC_MIX_CON2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_MIX_RTC_XOSC32_ENB_MASK),
                           (kal_uint32)(MT6325_PMIC_MIX_RTC_XOSC32_ENB_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_mix_efuse_xosc32_enb_opt(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_RTC_MIX_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_MIX_EFUSE_XOSC32_ENB_OPT_MASK),
                             (kal_uint32)(MT6325_PMIC_MIX_EFUSE_XOSC32_ENB_OPT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_on(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_ON_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_ON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_cal(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_CAL_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_CAL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_autocalrate(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_AUTOCALRATE_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_AUTOCALRATE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_sw_cr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_SW_CR_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_SW_CR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_sw_read_pre(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_SW_READ_PRE_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_SW_READ_PRE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_fg_latchdata_st(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON0),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_LATCHDATA_ST_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_LATCHDATA_ST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_fg_sw_clear(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_SW_CLEAR_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_SW_CLEAR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_offset_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_OFFSET_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_OFFSET_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_time_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_TIME_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_TIME_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_charge_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_CHARGE_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_CHARGE_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_sw_rstclr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_SW_RSTCLR_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_SW_RSTCLR_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_fg_car_31_16(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON1),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_CAR_31_16_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_CAR_31_16_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_fg_car_15_00(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON2),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_CAR_15_00_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_CAR_15_00_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_fg_nter_29_16(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON3),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_NTER_29_16_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_NTER_29_16_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_fg_nter_15_00(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON4),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_NTER_15_00_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_NTER_15_00_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_fg_bltr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_BLTR_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_BLTR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_bftr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_BFTR_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_BFTR_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_fg_current_out(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON7),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_CURRENT_OUT_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_CURRENT_OUT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_fg_adjust_offset_value(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_ADJUST_OFFSET_VALUE_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_ADJUST_OFFSET_VALUE_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_fg_offset(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON9),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_OFFSET_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_OFFSET_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_rg_fgrintmode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FGRINTMODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FGRINTMODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fganalogtest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FGANALOGTEST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FGANALOGTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_spare(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON10),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SPARE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SPARE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_osr(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_OSR_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_OSR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_adj_offset_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_ADJ_OFFSET_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_ADJ_OFFSET_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_adc_autorst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_ADC_AUTORST_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_ADC_AUTORST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_fir1bypass(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_FIR1BYPASS_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_FIR1BYPASS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_fir2bypass(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_FIR2BYPASS_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_FIR2BYPASS_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_fg_l_cur_int_sts(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON12),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_L_CUR_INT_STS_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_L_CUR_INT_STS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_fg_h_cur_int_sts(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON12),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_H_CUR_INT_STS_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_H_CUR_INT_STS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_fg_l_int_sts(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON12),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_L_INT_STS_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_L_INT_STS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_fg_h_int_sts(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON12),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_H_INT_STS_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_H_INT_STS_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_fg_adc_rstdetect(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON12),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_ADC_RSTDETECT_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_ADC_RSTDETECT_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_fg_slp_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_SLP_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_SLP_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_zcv_det_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_ZCV_DET_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_ZCV_DET_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fg_auxadc_r(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FG_AUXADC_R_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FG_AUXADC_R_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_fgadc_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON12),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FGADC_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_FGADC_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_fgcal_en(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON12),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FGCAL_EN_MASK),
                           (kal_uint32)(MT6325_PMIC_FGCAL_EN_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_fg_rst(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON12),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_RST_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_RST_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_fg_cic2(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON13),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_CIC2_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_CIC2_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_fg_slp_cur_th(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON14),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_SLP_CUR_TH_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_SLP_CUR_TH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_slp_time(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON15),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_SLP_TIME_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_SLP_TIME_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_srcvolten_ftime(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_SRCVOLTEN_FTIME_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_SRCVOLTEN_FTIME_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_det_time(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON16),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_DET_TIME_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_DET_TIME_SHIFT)
	                         );
  pmic_unlock();
}

kal_uint32 mt6325_upmu_get_fg_zcv_car_31_16(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON17),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_ZCV_CAR_31_16_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_ZCV_CAR_31_16_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_fg_zcv_car_15_00(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON18),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_ZCV_CAR_15_00_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_ZCV_CAR_15_00_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_fg_zcv_curr(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON19),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_ZCV_CURR_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_ZCV_CURR_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

kal_uint32 mt6325_upmu_get_fg_r_curr(void)
{
  kal_uint32 ret=0;
  kal_uint32 val=0;

  pmic_lock();
  ret=pmic_read_interface( (kal_uint32)(MT6325_FGADC_CON20),
                           (&val),
                           (kal_uint32)(MT6325_PMIC_FG_R_CURR_MASK),
                           (kal_uint32)(MT6325_PMIC_FG_R_CURR_SHIFT)
	                       );
  pmic_unlock();

  return val;
}

void mt6325_upmu_set_fg_mode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_MODE_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_MODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_rst_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_RST_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_RST_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_fgcal_en_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_FGCAL_EN_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_FGCAL_EN_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_fgadc_en_sw(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_FGADC_EN_SW_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_FGADC_EN_SW_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_rsv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_RSV1_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_RSV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_test_mode0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_TEST_MODE0_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_TEST_MODE0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_test_mode1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON21),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_TEST_MODE1_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_TEST_MODE1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_gain(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON22),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_GAIN_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_GAIN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_cur_hth(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON23),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_CUR_HTH_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_CUR_HTH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_cur_lth(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON24),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_CUR_LTH_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_CUR_LTH_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_zcv_det_time(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON25),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_ZCV_DET_TIME_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_ZCV_DET_TIME_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_zcv_car_th_30_16(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON26),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_ZCV_CAR_TH_30_16_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_ZCV_CAR_TH_30_16_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_fg_zcv_car_th_15_00(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_CON27),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_FG_ZCV_CAR_TH_15_00_MASK),
                             (kal_uint32)(MT6325_PMIC_FG_ZCV_CAR_TH_15_00_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_fgintmode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_FGADC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_FGINTMODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_FGINTMODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auddaclpwrup_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDDACLPWRUP_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDDACLPWRUP_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auddacrpwrup_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDDACRPWRUP_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDDACRPWRUP_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_aud_dac_pwr_up_va28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_DAC_PWR_UP_VA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_DAC_PWR_UP_VA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_aud_dac_pwl_up_va28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_DAC_PWL_UP_VA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUD_DAC_PWL_UP_VA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhspwrup_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHSPWRUP_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHSPWRUP_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhplpwrup_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLPWRUP_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLPWRUP_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhprpwrup_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRPWRUP_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRPWRUP_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhsmuxinputsel_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHSMUXINPUTSEL_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHSMUXINPUTSEL_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhplmuxinputsel_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhprmuxinputsel_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhsscdisable_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHSSCDISABLE_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHSSCDISABLE_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhplscdisable_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLSCDISABLE_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLSCDISABLE_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhprscdisable_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRSCDISABLE_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRSCDISABLE_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhplbsccurrent_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLBSCCURRENT_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLBSCCURRENT_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhprbsccurrent_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRBSCCURRENT_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRBSCCURRENT_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhsbsccurrent_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHSBSCCURRENT_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHSBSCCURRENT_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhpstartup_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPSTARTUP_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPSTARTUP_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhsstartup_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHSSTARTUP_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHSSTARTUP_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_prechargebuf_en_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PRECHARGEBUF_EN_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PRECHARGEBUF_EN_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hpinputstbenh_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HPINPUTSTBENH_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HPINPUTSTBENH_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hpoutputstbenh_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HPOUTPUTSTBENH_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HPOUTPUTSTBENH_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hpinputreset0_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HPINPUTRESET0_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HPINPUTRESET0_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hpoutputreset0_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HPOUTPUTRESET0_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HPOUTPUTRESET0_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hpout_shortvcm_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HPOUT_SHORTVCM_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HPOUT_SHORTVCM_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hsinputstbenh_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HSINPUTSTBENH_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HSINPUTSTBENH_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hsoutputstbenh_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HSOUTPUTSTBENH_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HSOUTPUTSTBENH_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hsinputreset0_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HSINPUTRESET0_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HSINPUTRESET0_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hsoutputreset0_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HSOUTPUTRESET0_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HSOUTPUTRESET0_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hpoutstb_rsel_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HPOUTSTB_RSEL_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HPOUTSTB_RSEL_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hsout_shortvcm_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HSOUT_SHORTVCM_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HSOUT_SHORTVCM_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhpltrim_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLTRIM_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLTRIM_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhprtrim_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRTRIM_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRTRIM_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhptrim_en_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPTRIM_EN_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPTRIM_EN_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhplfinetrim_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLFINETRIM_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPLFINETRIM_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhprfinetrim_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRFINETRIM_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPRFINETRIM_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audtrimbuf_en_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDTRIMBUF_EN_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDTRIMBUF_EN_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audtrimbuf_inputmuxsel_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audtrimbuf_gainsel_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhpspkdet_en_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPSPKDET_EN_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPSPKDET_EN_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhpspkdet_inputmuxsel_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audhpspkdet_outputmuxsel_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_abidec_reserved_va28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ABIDEC_RESERVED_VA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ABIDEC_RESERVED_VA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_abidec_reserved_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_ABIDEC_RESERVED_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_ABIDEC_RESERVED_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audbiasadj_0_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDBIASADJ_0_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDBIASADJ_0_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audbiasadj_1_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDBIASADJ_1_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDBIASADJ_1_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audibiaspwrdn_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIBIASPWRDN_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDIBIASPWRDN_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rstb_decoder_va28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RSTB_DECODER_VA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RSTB_DECODER_VA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_rstb_encoder_va28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_RSTB_ENCODER_VA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_RSTB_ENCODER_VA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_sel_decoder_96k_va28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SEL_DECODER_96K_VA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SEL_DECODER_96K_VA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_sel_encoder_96k_va28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SEL_ENCODER_96K_VA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SEL_ENCODER_96K_VA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_sel_delay_vcore(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_SEL_DELAY_VCORE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_SEL_DELAY_VCORE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hcldo_en_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HCLDO_EN_VA18_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HCLDO_EN_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_lcldo_en_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_EN_VA18_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_EN_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_lcldo_enc_en_va28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_ENC_EN_VA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_ENC_EN_VA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_va33refgen_en_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VA33REFGEN_EN_VA18_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VA33REFGEN_EN_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hcldo_pddis_en_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HCLDO_PDDIS_EN_VA18_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HCLDO_PDDIS_EN_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hcldo_remote_sense_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HCLDO_REMOTE_SENSE_VA18_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HCLDO_REMOTE_SENSE_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_lcldo_pddis_en_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_PDDIS_EN_VA18_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_PDDIS_EN_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_lcldo_remote_sense_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_REMOTE_SENSE_VA18_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_REMOTE_SENSE_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_lcldo_vosel_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_VOSEL_VA18_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_VOSEL_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_hcldo_vosel_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_HCLDO_VOSEL_VA18_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_HCLDO_VOSEL_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_lcldo_enc_pddis_en_va28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_ENC_PDDIS_EN_VA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_ENC_PDDIS_EN_VA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_lcldo_enc_remote_sense_va28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_ENC_REMOTE_SENSE_VA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_LCLDO_ENC_REMOTE_SENSE_VA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_va28refgen_en_va28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_VA28REFGEN_EN_VA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_VA28REFGEN_EN_VA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpmu_reserved_va28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPMU_RESERVED_VA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPMU_RESERVED_VA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpmu_reserved_va18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPMU_RESERVED_VA18_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPMU_RESERVED_VA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpmu_reserved_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPMU_RESERVED_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPMU_RESERVED_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_nvreg_en_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_NVREG_EN_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_NVREG_EN_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_nvreg_pull0v_vaudp15(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_NVREG_PULL0V_VAUDP15_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_NVREG_PULL0V_VAUDP15_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audglb_pwrdn_va28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDDEC_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDGLB_PWRDN_VA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDGLB_PWRDN_VA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreamplon(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLON_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreampldccen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLDCCEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLDCCEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreampldcrpecharge(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLDCRPECHARGE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLDCRPECHARGE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreamplpgatest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLPGATEST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLPGATEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreamplvscale(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLVSCALE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLVSCALE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreamplinputsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLINPUTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLINPUTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadclpwrup(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCLPWRUP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCLPWRUP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadclinputsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON0),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCLINPUTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCLINPUTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreampron(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPRON_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPRON_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreamprdccen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPRDCCEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPRDCCEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreamprdcrpecharge(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPRDCRPECHARGE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPRDCRPECHARGE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreamprpgatest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPRPGATEST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPRPGATEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreamprvscale(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPRVSCALE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPRVSCALE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreamprinputsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPRINPUTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPRINPUTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcrpwrup(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCRPWRUP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCRPWRUP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcrinputsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON1),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCRINPUTSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCRINPUTSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audulhalfbias(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDULHALFBIAS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDULHALFBIAS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audglbvowlpwen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDGLBVOWLPWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDGLBVOWLPWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreamplpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLPEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPLPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadc1ststagelpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC1STSTAGELPEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC1STSTAGELPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadc2ndstagelpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC2NDSTAGELPEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC2NDSTAGELPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcflashlpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCFLASHLPEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCFLASHLPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreampiddtest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPIDDTEST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPIDDTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadc1ststageiddtest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC1STSTAGEIDDTEST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC1STSTAGEIDDTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadc2ndstageiddtest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC2NDSTAGEIDDTEST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC2NDSTAGEIDDTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcrefbufiddtest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCREFBUFIDDTEST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCREFBUFIDDTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcflashiddtest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON2),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCFLASHIDDTEST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCFLASHIDDTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcdac0p25fs(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCDAC0P25FS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCDAC0P25FS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcclksel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCCLKSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCCLKSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcclksource(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCCLKSOURCE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCCLKSOURCE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcclkgenmode(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCCLKGENMODE_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCCLKGENMODE_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpreampaafen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPAAFEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPREAMPAAFEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_dccvcmbuflpmodsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DCCVCMBUFLPMODSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DCCVCMBUFLPMODSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_dccvcmbuflpswen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DCCVCMBUFLPSWEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DCCVCMBUFLPSWEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audsparepga(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON3),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDSPAREPGA_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDSPAREPGA_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadc1ststagesdenb(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC1STSTAGESDENB_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC1STSTAGESDENB_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadc2ndstagereset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC2NDSTAGERESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC2NDSTAGERESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadc3rdstagereset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC3RDSTAGERESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADC3RDSTAGERESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcfsreset(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCFSRESET_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCFSRESET_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcwidecm(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCWIDECM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCWIDECM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcnopatest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCNOPATEST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCNOPATEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcbypass(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCBYPASS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCBYPASS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcffbypass(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCFFBYPASS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCFFBYPASS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcdacfbcurrent(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCDACFBCURRENT_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCDACFBCURRENT_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcdaciddtest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCDACIDDTEST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCDACIDDTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcdacnrz(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCDACNRZ_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCDACNRZ_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcnodem(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCNODEM_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCNODEM_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadcdactest(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON4),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCDACTEST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCDACTEST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audadctestdata(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON5),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCTESTDATA_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDADCTESTDATA_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audrctunel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDRCTUNEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDRCTUNEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audrctunelsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDRCTUNELSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDRCTUNELSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audrctuner(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDRCTUNER_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDRCTUNER_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audrctunersel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON6),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDRCTUNERSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDRCTUNERSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audspareva28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDSPAREVA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDSPAREVA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audspareva18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON7),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDSPAREVA18_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDSPAREVA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auddigmicen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDDIGMICEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDDIGMICEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auddigmicbias(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDDIGMICBIAS_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDDIGMICBIAS_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_dmichpclken(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DMICHPCLKEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DMICHPCLKEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auddigmicpduty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDDIGMICPDUTY_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDDIGMICPDUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_auddigmicnduty(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDDIGMICNDUTY_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDDIGMICNDUTY_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_dmicmonen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DMICMONEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DMICMONEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_dmicmonsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_DMICMONSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_DMICMONSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audsparevmic(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON8),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDSPAREVMIC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDSPAREVMIC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpwdbmicbias0(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPWDBMICBIAS0_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPWDBMICBIAS0_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audmicbias0dcswpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIAS0DCSWPEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIAS0DCSWPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audmicbias0dcswnen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIAS0DCSWNEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIAS0DCSWNEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audmicbias0bypassen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIAS0BYPASSEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIAS0BYPASSEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audpwdbmicbias1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPWDBMICBIAS1_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDPWDBMICBIAS1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audmicbias1dcswpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIAS1DCSWPEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIAS1DCSWPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audmicbias1dcswnen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIAS1DCSWNEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIAS1DCSWNEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audmicbias1bypassen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIAS1BYPASSEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIAS1BYPASSEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audmicbiasvref(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIASVREF_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIASVREF_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audmicbiaslowpen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIASLOWPEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDMICBIASLOWPEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_bandgapgen(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON9),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_BANDGAPGEN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_BANDGAPGEN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audencspareva28(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDENCSPAREVA28_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDENCSPAREVA28_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_audencspareva18(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON11),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_AUDENCSPAREVA18_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_AUDENCSPAREVA18_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pllbs_rst(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLLBS_RST_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLLBS_RST_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_dcko_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_DCKO_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_DCKO_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_div1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_DIV1_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_DIV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_rlatch_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_RLATCH_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_RLATCH_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_pdiv1_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_PDIV1_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_PDIV1_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_pdiv1(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON12),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_PDIV1_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_PDIV1_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_bc(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_BC_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_BC_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_bp(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_BP_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_BP_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_br(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_BR_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_BR_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_cko_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_CKO_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_CKO_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_ibsel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_IBSEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_IBSEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_ckt_sel(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_CKT_SEL_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_CKT_SEL_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_vct_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_VCT_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_VCT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_ckt_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_CKT_EN_MASK),
                             (kal_uint32)(MT6325_PMIC_RG_PLL_CKT_EN_SHIFT)
	                         );
  pmic_unlock();
}

void mt6325_upmu_set_rg_pll_hpm_en(kal_uint32 val)
{
  kal_uint32 ret=0;

  pmic_lock();
  ret=pmic_config_interface( (kal_uint32)(MT6325_AUDENC_ANA_CON13),
                             (kal_uint32)(val),
                             (kal_uint32)(MT632